# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PrivateCloudArgs', 'PrivateCloud']

@pulumi.input_type
class PrivateCloudArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 management_cluster: pulumi.Input['PrivateCloudManagementClusterArgs'],
                 network_config: pulumi.Input['PrivateCloudNetworkConfigArgs'],
                 deletion_delay_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 send_deletion_delay_hours_if_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PrivateCloud resource.
        :param pulumi.Input[_builtins.str] location: The location where the PrivateCloud should reside.
        :param pulumi.Input['PrivateCloudManagementClusterArgs'] management_cluster: The management cluster for this private cloud. This used for creating and managing the default cluster.
               Structure is documented below.
        :param pulumi.Input['PrivateCloudNetworkConfigArgs'] network_config: Network configuration in the consumer project with which the peering has to be done.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] deletion_delay_hours: The number of hours to delay this request. You can set this value to an hour between 0 to 8, where setting it to 0 starts the deletion request immediately. If no value is set, a default value is set at the API Level.
        :param pulumi.Input[_builtins.str] description: User-provided description for this private cloud.
        :param pulumi.Input[_builtins.str] name: The ID of the PrivateCloud.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] send_deletion_delay_hours_if_zero: While set true, deletion_delay_hours value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the deletion_delay_hours field. It can be used both alone and together with deletion_delay_hours.
        :param pulumi.Input[_builtins.str] type: Initial type of the private cloud.
               Possible values are: `STANDARD`, `TIME_LIMITED`, `STRETCHED`.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "management_cluster", management_cluster)
        pulumi.set(__self__, "network_config", network_config)
        if deletion_delay_hours is not None:
            pulumi.set(__self__, "deletion_delay_hours", deletion_delay_hours)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if send_deletion_delay_hours_if_zero is not None:
            pulumi.set(__self__, "send_deletion_delay_hours_if_zero", send_deletion_delay_hours_if_zero)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location where the PrivateCloud should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managementCluster")
    def management_cluster(self) -> pulumi.Input['PrivateCloudManagementClusterArgs']:
        """
        The management cluster for this private cloud. This used for creating and managing the default cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "management_cluster")

    @management_cluster.setter
    def management_cluster(self, value: pulumi.Input['PrivateCloudManagementClusterArgs']):
        pulumi.set(self, "management_cluster", value)

    @_builtins.property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Input['PrivateCloudNetworkConfigArgs']:
        """
        Network configuration in the consumer project with which the peering has to be done.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: pulumi.Input['PrivateCloudNetworkConfigArgs']):
        pulumi.set(self, "network_config", value)

    @_builtins.property
    @pulumi.getter(name="deletionDelayHours")
    def deletion_delay_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of hours to delay this request. You can set this value to an hour between 0 to 8, where setting it to 0 starts the deletion request immediately. If no value is set, a default value is set at the API Level.
        """
        return pulumi.get(self, "deletion_delay_hours")

    @deletion_delay_hours.setter
    def deletion_delay_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deletion_delay_hours", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided description for this private cloud.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the PrivateCloud.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="sendDeletionDelayHoursIfZero")
    def send_deletion_delay_hours_if_zero(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        While set true, deletion_delay_hours value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the deletion_delay_hours field. It can be used both alone and together with deletion_delay_hours.
        """
        return pulumi.get(self, "send_deletion_delay_hours_if_zero")

    @send_deletion_delay_hours_if_zero.setter
    def send_deletion_delay_hours_if_zero(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_deletion_delay_hours_if_zero", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Initial type of the private cloud.
        Possible values are: `STANDARD`, `TIME_LIMITED`, `STRETCHED`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _PrivateCloudState:
    def __init__(__self__, *,
                 deletion_delay_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hcxes: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudHcxArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_cluster: Optional[pulumi.Input['PrivateCloudManagementClusterArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_config: Optional[pulumi.Input['PrivateCloudNetworkConfigArgs']] = None,
                 nsxes: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudNsxArgs']]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 send_deletion_delay_hours_if_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 vcenters: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudVcenterArgs']]]] = None):
        """
        Input properties used for looking up and filtering PrivateCloud resources.
        :param pulumi.Input[_builtins.int] deletion_delay_hours: The number of hours to delay this request. You can set this value to an hour between 0 to 8, where setting it to 0 starts the deletion request immediately. If no value is set, a default value is set at the API Level.
        :param pulumi.Input[_builtins.str] description: User-provided description for this private cloud.
        :param pulumi.Input[Sequence[pulumi.Input['PrivateCloudHcxArgs']]] hcxes: Details about a HCX Cloud Manager appliance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location where the PrivateCloud should reside.
        :param pulumi.Input['PrivateCloudManagementClusterArgs'] management_cluster: The management cluster for this private cloud. This used for creating and managing the default cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The ID of the PrivateCloud.
        :param pulumi.Input['PrivateCloudNetworkConfigArgs'] network_config: Network configuration in the consumer project with which the peering has to be done.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['PrivateCloudNsxArgs']]] nsxes: Details about a NSX Manager appliance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] send_deletion_delay_hours_if_zero: While set true, deletion_delay_hours value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the deletion_delay_hours field. It can be used both alone and together with deletion_delay_hours.
        :param pulumi.Input[_builtins.str] state: State of the appliance.
               Possible values are: `ACTIVE`, `CREATING`.
        :param pulumi.Input[_builtins.str] type: Initial type of the private cloud.
               Possible values are: `STANDARD`, `TIME_LIMITED`, `STRETCHED`.
        :param pulumi.Input[_builtins.str] uid: System-generated unique identifier for the resource.
        :param pulumi.Input[Sequence[pulumi.Input['PrivateCloudVcenterArgs']]] vcenters: Details about a vCenter Server management appliance.
               Structure is documented below.
        """
        if deletion_delay_hours is not None:
            pulumi.set(__self__, "deletion_delay_hours", deletion_delay_hours)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hcxes is not None:
            pulumi.set(__self__, "hcxes", hcxes)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if management_cluster is not None:
            pulumi.set(__self__, "management_cluster", management_cluster)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if nsxes is not None:
            pulumi.set(__self__, "nsxes", nsxes)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if send_deletion_delay_hours_if_zero is not None:
            pulumi.set(__self__, "send_deletion_delay_hours_if_zero", send_deletion_delay_hours_if_zero)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if vcenters is not None:
            pulumi.set(__self__, "vcenters", vcenters)

    @_builtins.property
    @pulumi.getter(name="deletionDelayHours")
    def deletion_delay_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of hours to delay this request. You can set this value to an hour between 0 to 8, where setting it to 0 starts the deletion request immediately. If no value is set, a default value is set at the API Level.
        """
        return pulumi.get(self, "deletion_delay_hours")

    @deletion_delay_hours.setter
    def deletion_delay_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deletion_delay_hours", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided description for this private cloud.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def hcxes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudHcxArgs']]]]:
        """
        Details about a HCX Cloud Manager appliance.
        Structure is documented below.
        """
        return pulumi.get(self, "hcxes")

    @hcxes.setter
    def hcxes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudHcxArgs']]]]):
        pulumi.set(self, "hcxes", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the PrivateCloud should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managementCluster")
    def management_cluster(self) -> Optional[pulumi.Input['PrivateCloudManagementClusterArgs']]:
        """
        The management cluster for this private cloud. This used for creating and managing the default cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "management_cluster")

    @management_cluster.setter
    def management_cluster(self, value: Optional[pulumi.Input['PrivateCloudManagementClusterArgs']]):
        pulumi.set(self, "management_cluster", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the PrivateCloud.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['PrivateCloudNetworkConfigArgs']]:
        """
        Network configuration in the consumer project with which the peering has to be done.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['PrivateCloudNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @_builtins.property
    @pulumi.getter
    def nsxes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudNsxArgs']]]]:
        """
        Details about a NSX Manager appliance.
        Structure is documented below.
        """
        return pulumi.get(self, "nsxes")

    @nsxes.setter
    def nsxes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudNsxArgs']]]]):
        pulumi.set(self, "nsxes", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="sendDeletionDelayHoursIfZero")
    def send_deletion_delay_hours_if_zero(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        While set true, deletion_delay_hours value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the deletion_delay_hours field. It can be used both alone and together with deletion_delay_hours.
        """
        return pulumi.get(self, "send_deletion_delay_hours_if_zero")

    @send_deletion_delay_hours_if_zero.setter
    def send_deletion_delay_hours_if_zero(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_deletion_delay_hours_if_zero", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the appliance.
        Possible values are: `ACTIVE`, `CREATING`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Initial type of the private cloud.
        Possible values are: `STANDARD`, `TIME_LIMITED`, `STRETCHED`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System-generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter
    def vcenters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudVcenterArgs']]]]:
        """
        Details about a vCenter Server management appliance.
        Structure is documented below.
        """
        return pulumi.get(self, "vcenters")

    @vcenters.setter
    def vcenters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudVcenterArgs']]]]):
        pulumi.set(self, "vcenters", value)


@pulumi.type_token("gcp:vmwareengine/privateCloud:PrivateCloud")
class PrivateCloud(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_delay_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_cluster: Optional[pulumi.Input[Union['PrivateCloudManagementClusterArgs', 'PrivateCloudManagementClusterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['PrivateCloudNetworkConfigArgs', 'PrivateCloudNetworkConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 send_deletion_delay_hours_if_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents a private cloud resource. Private clouds are zonal resources.

        To get more information about PrivateCloud, see:

        * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.privateClouds)

        ## Example Usage

        ### Vmware Engine Private Cloud Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pc_nw = gcp.vmwareengine.Network("pc-nw",
            name="pc-nw",
            location="global",
            type="STANDARD",
            description="PC network description.")
        vmw_engine_pc = gcp.vmwareengine.PrivateCloud("vmw-engine-pc",
            location="us-west1-a",
            name="sample-pc",
            description="Sample test PC.",
            network_config={
                "management_cidr": "192.168.30.0/24",
                "vmware_engine_network": pc_nw.id,
            },
            management_cluster={
                "cluster_id": "sample-mgmt-cluster",
                "node_type_configs": [{
                    "node_type_id": "standard-72",
                    "node_count": 3,
                }],
            })
        ```
        ### Vmware Engine Private Cloud Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pc_nw = gcp.vmwareengine.Network("pc-nw",
            name="pc-nw",
            location="global",
            type="STANDARD",
            description="PC network description.")
        vmw_engine_pc = gcp.vmwareengine.PrivateCloud("vmw-engine-pc",
            location="us-west1-a",
            name="sample-pc",
            description="Sample test PC.",
            type="TIME_LIMITED",
            network_config={
                "management_cidr": "192.168.30.0/24",
                "vmware_engine_network": pc_nw.id,
            },
            management_cluster={
                "cluster_id": "sample-mgmt-cluster",
                "node_type_configs": [{
                    "node_type_id": "standard-72",
                    "node_count": 1,
                    "custom_core_count": 32,
                }],
                "autoscaling_settings": {
                    "autoscaling_policies": [{
                        "autoscale_policy_id": "autoscaling-policy",
                        "node_type_id": "standard-72",
                        "scale_out_size": 1,
                        "cpu_thresholds": {
                            "scale_out": 80,
                            "scale_in": 15,
                        },
                        "consumed_memory_thresholds": {
                            "scale_out": 75,
                            "scale_in": 20,
                        },
                        "storage_thresholds": {
                            "scale_out": 80,
                            "scale_in": 20,
                        },
                    }],
                    "min_cluster_node_count": 3,
                    "max_cluster_node_count": 8,
                    "cool_down_period": "1800s",
                },
            },
            deletion_delay_hours=0,
            send_deletion_delay_hours_if_zero=True)
        ```

        ## Import

        PrivateCloud can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/privateClouds/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, PrivateCloud can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vmwareengine/privateCloud:PrivateCloud default projects/{{project}}/locations/{{location}}/privateClouds/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/privateCloud:PrivateCloud default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/privateCloud:PrivateCloud default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] deletion_delay_hours: The number of hours to delay this request. You can set this value to an hour between 0 to 8, where setting it to 0 starts the deletion request immediately. If no value is set, a default value is set at the API Level.
        :param pulumi.Input[_builtins.str] description: User-provided description for this private cloud.
        :param pulumi.Input[_builtins.str] location: The location where the PrivateCloud should reside.
        :param pulumi.Input[Union['PrivateCloudManagementClusterArgs', 'PrivateCloudManagementClusterArgsDict']] management_cluster: The management cluster for this private cloud. This used for creating and managing the default cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The ID of the PrivateCloud.
        :param pulumi.Input[Union['PrivateCloudNetworkConfigArgs', 'PrivateCloudNetworkConfigArgsDict']] network_config: Network configuration in the consumer project with which the peering has to be done.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] send_deletion_delay_hours_if_zero: While set true, deletion_delay_hours value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the deletion_delay_hours field. It can be used both alone and together with deletion_delay_hours.
        :param pulumi.Input[_builtins.str] type: Initial type of the private cloud.
               Possible values are: `STANDARD`, `TIME_LIMITED`, `STRETCHED`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateCloudArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a private cloud resource. Private clouds are zonal resources.

        To get more information about PrivateCloud, see:

        * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.privateClouds)

        ## Example Usage

        ### Vmware Engine Private Cloud Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pc_nw = gcp.vmwareengine.Network("pc-nw",
            name="pc-nw",
            location="global",
            type="STANDARD",
            description="PC network description.")
        vmw_engine_pc = gcp.vmwareengine.PrivateCloud("vmw-engine-pc",
            location="us-west1-a",
            name="sample-pc",
            description="Sample test PC.",
            network_config={
                "management_cidr": "192.168.30.0/24",
                "vmware_engine_network": pc_nw.id,
            },
            management_cluster={
                "cluster_id": "sample-mgmt-cluster",
                "node_type_configs": [{
                    "node_type_id": "standard-72",
                    "node_count": 3,
                }],
            })
        ```
        ### Vmware Engine Private Cloud Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pc_nw = gcp.vmwareengine.Network("pc-nw",
            name="pc-nw",
            location="global",
            type="STANDARD",
            description="PC network description.")
        vmw_engine_pc = gcp.vmwareengine.PrivateCloud("vmw-engine-pc",
            location="us-west1-a",
            name="sample-pc",
            description="Sample test PC.",
            type="TIME_LIMITED",
            network_config={
                "management_cidr": "192.168.30.0/24",
                "vmware_engine_network": pc_nw.id,
            },
            management_cluster={
                "cluster_id": "sample-mgmt-cluster",
                "node_type_configs": [{
                    "node_type_id": "standard-72",
                    "node_count": 1,
                    "custom_core_count": 32,
                }],
                "autoscaling_settings": {
                    "autoscaling_policies": [{
                        "autoscale_policy_id": "autoscaling-policy",
                        "node_type_id": "standard-72",
                        "scale_out_size": 1,
                        "cpu_thresholds": {
                            "scale_out": 80,
                            "scale_in": 15,
                        },
                        "consumed_memory_thresholds": {
                            "scale_out": 75,
                            "scale_in": 20,
                        },
                        "storage_thresholds": {
                            "scale_out": 80,
                            "scale_in": 20,
                        },
                    }],
                    "min_cluster_node_count": 3,
                    "max_cluster_node_count": 8,
                    "cool_down_period": "1800s",
                },
            },
            deletion_delay_hours=0,
            send_deletion_delay_hours_if_zero=True)
        ```

        ## Import

        PrivateCloud can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/privateClouds/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, PrivateCloud can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vmwareengine/privateCloud:PrivateCloud default projects/{{project}}/locations/{{location}}/privateClouds/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/privateCloud:PrivateCloud default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/privateCloud:PrivateCloud default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PrivateCloudArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateCloudArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_delay_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_cluster: Optional[pulumi.Input[Union['PrivateCloudManagementClusterArgs', 'PrivateCloudManagementClusterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['PrivateCloudNetworkConfigArgs', 'PrivateCloudNetworkConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 send_deletion_delay_hours_if_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateCloudArgs.__new__(PrivateCloudArgs)

            __props__.__dict__["deletion_delay_hours"] = deletion_delay_hours
            __props__.__dict__["description"] = description
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if management_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'management_cluster'")
            __props__.__dict__["management_cluster"] = management_cluster
            __props__.__dict__["name"] = name
            if network_config is None and not opts.urn:
                raise TypeError("Missing required property 'network_config'")
            __props__.__dict__["network_config"] = network_config
            __props__.__dict__["project"] = project
            __props__.__dict__["send_deletion_delay_hours_if_zero"] = send_deletion_delay_hours_if_zero
            __props__.__dict__["type"] = type
            __props__.__dict__["hcxes"] = None
            __props__.__dict__["nsxes"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["vcenters"] = None
        super(PrivateCloud, __self__).__init__(
            'gcp:vmwareengine/privateCloud:PrivateCloud',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deletion_delay_hours: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            hcxes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PrivateCloudHcxArgs', 'PrivateCloudHcxArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            management_cluster: Optional[pulumi.Input[Union['PrivateCloudManagementClusterArgs', 'PrivateCloudManagementClusterArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_config: Optional[pulumi.Input[Union['PrivateCloudNetworkConfigArgs', 'PrivateCloudNetworkConfigArgsDict']]] = None,
            nsxes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PrivateCloudNsxArgs', 'PrivateCloudNsxArgsDict']]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            send_deletion_delay_hours_if_zero: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            vcenters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PrivateCloudVcenterArgs', 'PrivateCloudVcenterArgsDict']]]]] = None) -> 'PrivateCloud':
        """
        Get an existing PrivateCloud resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] deletion_delay_hours: The number of hours to delay this request. You can set this value to an hour between 0 to 8, where setting it to 0 starts the deletion request immediately. If no value is set, a default value is set at the API Level.
        :param pulumi.Input[_builtins.str] description: User-provided description for this private cloud.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PrivateCloudHcxArgs', 'PrivateCloudHcxArgsDict']]]] hcxes: Details about a HCX Cloud Manager appliance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location where the PrivateCloud should reside.
        :param pulumi.Input[Union['PrivateCloudManagementClusterArgs', 'PrivateCloudManagementClusterArgsDict']] management_cluster: The management cluster for this private cloud. This used for creating and managing the default cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The ID of the PrivateCloud.
        :param pulumi.Input[Union['PrivateCloudNetworkConfigArgs', 'PrivateCloudNetworkConfigArgsDict']] network_config: Network configuration in the consumer project with which the peering has to be done.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PrivateCloudNsxArgs', 'PrivateCloudNsxArgsDict']]]] nsxes: Details about a NSX Manager appliance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] send_deletion_delay_hours_if_zero: While set true, deletion_delay_hours value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the deletion_delay_hours field. It can be used both alone and together with deletion_delay_hours.
        :param pulumi.Input[_builtins.str] state: State of the appliance.
               Possible values are: `ACTIVE`, `CREATING`.
        :param pulumi.Input[_builtins.str] type: Initial type of the private cloud.
               Possible values are: `STANDARD`, `TIME_LIMITED`, `STRETCHED`.
        :param pulumi.Input[_builtins.str] uid: System-generated unique identifier for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PrivateCloudVcenterArgs', 'PrivateCloudVcenterArgsDict']]]] vcenters: Details about a vCenter Server management appliance.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateCloudState.__new__(_PrivateCloudState)

        __props__.__dict__["deletion_delay_hours"] = deletion_delay_hours
        __props__.__dict__["description"] = description
        __props__.__dict__["hcxes"] = hcxes
        __props__.__dict__["location"] = location
        __props__.__dict__["management_cluster"] = management_cluster
        __props__.__dict__["name"] = name
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["nsxes"] = nsxes
        __props__.__dict__["project"] = project
        __props__.__dict__["send_deletion_delay_hours_if_zero"] = send_deletion_delay_hours_if_zero
        __props__.__dict__["state"] = state
        __props__.__dict__["type"] = type
        __props__.__dict__["uid"] = uid
        __props__.__dict__["vcenters"] = vcenters
        return PrivateCloud(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deletionDelayHours")
    def deletion_delay_hours(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of hours to delay this request. You can set this value to an hour between 0 to 8, where setting it to 0 starts the deletion request immediately. If no value is set, a default value is set at the API Level.
        """
        return pulumi.get(self, "deletion_delay_hours")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-provided description for this private cloud.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def hcxes(self) -> pulumi.Output[Sequence['outputs.PrivateCloudHcx']]:
        """
        Details about a HCX Cloud Manager appliance.
        Structure is documented below.
        """
        return pulumi.get(self, "hcxes")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location where the PrivateCloud should reside.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managementCluster")
    def management_cluster(self) -> pulumi.Output['outputs.PrivateCloudManagementCluster']:
        """
        The management cluster for this private cloud. This used for creating and managing the default cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "management_cluster")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the PrivateCloud.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output['outputs.PrivateCloudNetworkConfig']:
        """
        Network configuration in the consumer project with which the peering has to be done.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @_builtins.property
    @pulumi.getter
    def nsxes(self) -> pulumi.Output[Sequence['outputs.PrivateCloudNsx']]:
        """
        Details about a NSX Manager appliance.
        Structure is documented below.
        """
        return pulumi.get(self, "nsxes")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="sendDeletionDelayHoursIfZero")
    def send_deletion_delay_hours_if_zero(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        While set true, deletion_delay_hours value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the deletion_delay_hours field. It can be used both alone and together with deletion_delay_hours.
        """
        return pulumi.get(self, "send_deletion_delay_hours_if_zero")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the appliance.
        Possible values are: `ACTIVE`, `CREATING`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Initial type of the private cloud.
        Possible values are: `STANDARD`, `TIME_LIMITED`, `STRETCHED`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        System-generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter
    def vcenters(self) -> pulumi.Output[Sequence['outputs.PrivateCloudVcenter']]:
        """
        Details about a vCenter Server management appliance.
        Structure is documented below.
        """
        return pulumi.get(self, "vcenters")

