# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.allowed_radius import AllowedRadius
from ..types.ao_e_answer import AoEAnswer
from ..types.appointment_availability_slots import AppointmentAvailabilitySlots
from ..types.appointment_booking_request import AppointmentBookingRequest
from ..types.appointment_provider import AppointmentProvider
from ..types.appointment_reschedule_request import AppointmentRescheduleRequest
from ..types.area_info import AreaInfo
from ..types.billing import Billing
from ..types.client_facing_appointment import ClientFacingAppointment
from ..types.client_facing_appointment_cancellation_reason import ClientFacingAppointmentCancellationReason
from ..types.client_facing_lab import ClientFacingLab
from ..types.client_facing_lab_test import ClientFacingLabTest
from ..types.client_facing_labs import ClientFacingLabs
from ..types.client_facing_marker import ClientFacingMarker
from ..types.client_facing_order import ClientFacingOrder
from ..types.consent import Consent
from ..types.get_markers_response import GetMarkersResponse
from ..types.get_orders_response import GetOrdersResponse
from ..types.health_insurance_create_request import HealthInsuranceCreateRequest
from ..types.interpretation import Interpretation
from ..types.lab_location_capability import LabLocationCapability
from ..types.lab_results_metadata import LabResultsMetadata
from ..types.lab_results_raw import LabResultsRaw
from ..types.lab_test_collection_method import LabTestCollectionMethod
from ..types.lab_test_generation_method_filter import LabTestGenerationMethodFilter
from ..types.lab_test_resources_response import LabTestResourcesResponse
from ..types.lab_test_status import LabTestStatus
from ..types.order_activation_type import OrderActivationType
from ..types.order_low_level_status import OrderLowLevelStatus
from ..types.order_set_request import OrderSetRequest
from ..types.order_status import OrderStatus
from ..types.patient_address import PatientAddress
from ..types.patient_address_with_validation import PatientAddressWithValidation
from ..types.patient_details_with_validation import PatientDetailsWithValidation
from ..types.physician_create_request import PhysicianCreateRequest
from ..types.post_order_response import PostOrderResponse
from ..types.psc_info import PscInfo
from ..types.simulation_flags import SimulationFlags
from ..types.us_address import UsAddress
from .raw_client import AsyncRawLabTestsClient, RawLabTestsClient
from .types.lab_tests_get_orders_request_order_direction import LabTestsGetOrdersRequestOrderDirection
from .types.lab_tests_get_orders_request_order_key import LabTestsGetOrdersRequestOrderKey
from .types.lab_tests_get_paginated_request_order_direction import LabTestsGetPaginatedRequestOrderDirection
from .types.lab_tests_get_paginated_request_order_key import LabTestsGetPaginatedRequestOrderKey
from .types.lab_tests_get_request_order_direction import LabTestsGetRequestOrderDirection
from .types.lab_tests_get_request_order_key import LabTestsGetRequestOrderKey

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class LabTestsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawLabTestsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawLabTestsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawLabTestsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        generation_method: typing.Optional[LabTestGenerationMethodFilter] = None,
        lab_slug: typing.Optional[str] = None,
        collection_method: typing.Optional[LabTestCollectionMethod] = None,
        status: typing.Optional[LabTestStatus] = None,
        marker_ids: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        provider_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        order_key: typing.Optional[LabTestsGetRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingLabTest]:
        """
        GET all the lab tests the team has access to.

        Parameters
        ----------
        generation_method : typing.Optional[LabTestGenerationMethodFilter]
            Filter on whether auto-generated lab tests created by Vital, manually created lab tests, or all lab tests should be returned.

        lab_slug : typing.Optional[str]
            Filter by the slug of the lab for these lab tests.

        collection_method : typing.Optional[LabTestCollectionMethod]
            Filter by the collection method for these lab tests.

        status : typing.Optional[LabTestStatus]
            Filter by the status of these lab tests.

        marker_ids : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            Filter to only include lab tests containing these marker IDs.

        provider_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter to only include lab tests containing these provider IDs.

        name : typing.Optional[str]
            Filter by the name of the lab test (a case-insensitive substring search).

        order_key : typing.Optional[LabTestsGetRequestOrderKey]

        order_direction : typing.Optional[LabTestsGetRequestOrderDirection]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingLabTest]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get()
        """
        _response = self._raw_client.get(
            generation_method=generation_method,
            lab_slug=lab_slug,
            collection_method=collection_method,
            status=status,
            marker_ids=marker_ids,
            provider_ids=provider_ids,
            name=name,
            order_key=order_key,
            order_direction=order_direction,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        name: str,
        method: LabTestCollectionMethod,
        description: str,
        marker_ids: typing.Optional[typing.Sequence[int]] = OMIT,
        provider_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        fasting: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingLabTest:
        """
        Parameters
        ----------
        name : str

        method : LabTestCollectionMethod

        description : str

        marker_ids : typing.Optional[typing.Sequence[int]]

        provider_ids : typing.Optional[typing.Sequence[str]]

        fasting : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingLabTest
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import LabTestCollectionMethod
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.create(name='name', method=LabTestCollectionMethod.TESTKIT, description='description', )
        """
        _response = self._raw_client.create(
            name=name,
            method=method,
            description=description,
            marker_ids=marker_ids,
            provider_ids=provider_ids,
            fasting=fasting,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, lab_test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingLabTest:
        """
        GET all the lab tests the team has access to.

        Parameters
        ----------
        lab_test_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingLabTest
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_by_id(lab_test_id='lab_test_id', )
        """
        _response = self._raw_client.get_by_id(lab_test_id, request_options=request_options)
        return _response.data

    def update_lab_test(
        self,
        lab_test_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingLabTest:
        """
        Parameters
        ----------
        lab_test_id : str

        name : typing.Optional[str]

        active : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingLabTest
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.update_lab_test(lab_test_id='lab_test_id', )
        """
        _response = self._raw_client.update_lab_test(
            lab_test_id, name=name, active=active, request_options=request_options
        )
        return _response.data

    def get_markers(
        self,
        *,
        lab_id: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        name: typing.Optional[str] = None,
        a_la_carte_enabled: typing.Optional[bool] = None,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetMarkersResponse:
        """
        GET all the markers for the given lab.

        Parameters
        ----------
        lab_id : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            The identifier Vital assigned to a lab partner.

        name : typing.Optional[str]
            The name or test code of an individual biomarker or a panel.

        a_la_carte_enabled : typing.Optional[bool]

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMarkersResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_markers()
        """
        _response = self._raw_client.get_markers(
            lab_id=lab_id,
            name=name,
            a_la_carte_enabled=a_la_carte_enabled,
            page=page,
            size=size,
            request_options=request_options,
        )
        return _response.data

    def get_markers_for_order_set(
        self,
        *,
        request: OrderSetRequest,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetMarkersResponse:
        """
        Parameters
        ----------
        request : OrderSetRequest

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMarkersResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import OrderSetRequest
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_markers_for_order_set(request=OrderSetRequest(), )
        """
        _response = self._raw_client.get_markers_for_order_set(
            request=request, page=page, size=size, request_options=request_options
        )
        return _response.data

    def get_markers_for_lab_test(
        self,
        lab_test_id: str,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetMarkersResponse:
        """
        Parameters
        ----------
        lab_test_id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMarkersResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_markers_for_lab_test(lab_test_id='lab_test_id', )
        """
        _response = self._raw_client.get_markers_for_lab_test(
            lab_test_id, page=page, size=size, request_options=request_options
        )
        return _response.data

    def get_markers_by_lab_and_provider_id(
        self, provider_id: str, lab_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingMarker:
        """
        GET a specific marker for the given lab and provider_id

        Parameters
        ----------
        provider_id : str

        lab_id : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingMarker
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_markers_by_lab_and_provider_id(provider_id='provider_id', lab_id=1, )
        """
        _response = self._raw_client.get_markers_by_lab_and_provider_id(
            provider_id, lab_id, request_options=request_options
        )
        return _response.data

    def get_labs(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[ClientFacingLab]:
        """
        GET all the labs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingLab]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_labs()
        """
        _response = self._raw_client.get_labs(request_options=request_options)
        return _response.data

    def get_paginated(
        self,
        *,
        lab_test_limit: typing.Optional[int] = None,
        next_cursor: typing.Optional[str] = None,
        generation_method: typing.Optional[LabTestGenerationMethodFilter] = None,
        lab_slug: typing.Optional[str] = None,
        collection_method: typing.Optional[LabTestCollectionMethod] = None,
        status: typing.Optional[LabTestStatus] = None,
        marker_ids: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        provider_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        order_key: typing.Optional[LabTestsGetPaginatedRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetPaginatedRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LabTestResourcesResponse:
        """
        GET lab tests the team has access to as a paginated list.

        Parameters
        ----------
        lab_test_limit : typing.Optional[int]

        next_cursor : typing.Optional[str]

        generation_method : typing.Optional[LabTestGenerationMethodFilter]
            Filter on whether auto-generated lab tests created by Vital, manually created lab tests, or all lab tests should be returned.

        lab_slug : typing.Optional[str]
            Filter by the slug of the lab for these lab tests.

        collection_method : typing.Optional[LabTestCollectionMethod]
            Filter by the collection method for these lab tests.

        status : typing.Optional[LabTestStatus]
            Filter by the status of these lab tests.

        marker_ids : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            Filter to only include lab tests containing these marker IDs.

        provider_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter to only include lab tests containing these provider IDs.

        name : typing.Optional[str]
            Filter by the name of the lab test (a case-insensitive substring search).

        order_key : typing.Optional[LabTestsGetPaginatedRequestOrderKey]

        order_direction : typing.Optional[LabTestsGetPaginatedRequestOrderDirection]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LabTestResourcesResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_paginated()
        """
        _response = self._raw_client.get_paginated(
            lab_test_limit=lab_test_limit,
            next_cursor=next_cursor,
            generation_method=generation_method,
            lab_slug=lab_slug,
            collection_method=collection_method,
            status=status,
            marker_ids=marker_ids,
            provider_ids=provider_ids,
            name=name,
            order_key=order_key,
            order_direction=order_direction,
            request_options=request_options,
        )
        return _response.data

    def get_lab_test_collection_instruction_pdf(
        self, lab_test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[bytes]:
        """
        GET collection instructions for a lab test

        Parameters
        ----------
        lab_test_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            PDF with collection instructions
        """
        with self._raw_client.get_lab_test_collection_instruction_pdf(
            lab_test_id, request_options=request_options
        ) as r:
            yield from r.data

    def get_phlebotomy_appointment_availability(
        self,
        *,
        request: UsAddress,
        start_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppointmentAvailabilitySlots:
        """
        Return the available time slots to book an appointment with a phlebotomist
        for the given address and order.

        Parameters
        ----------
        request : UsAddress

        start_date : typing.Optional[str]
            Start date for appointment availability

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppointmentAvailabilitySlots
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import UsAddress
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_phlebotomy_appointment_availability(request=UsAddress(first_line='first_line', city='city', state='state', zip_code='zip_code', ), )
        """
        _response = self._raw_client.get_phlebotomy_appointment_availability(
            request=request, start_date=start_date, request_options=request_options
        )
        return _response.data

    def book_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentBookingRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Book an at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentBookingRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import AppointmentBookingRequest
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.book_phlebotomy_appointment(order_id='order_id', request=AppointmentBookingRequest(booking_key='booking_key', ), )
        """
        _response = self._raw_client.book_phlebotomy_appointment(
            order_id, request=request, request_options=request_options
        )
        return _response.data

    def request_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        address: UsAddress,
        provider: AppointmentProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Request an at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        address : UsAddress
            At-home phlebotomy appointment address.

        provider : AppointmentProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import UsAddress
        from vital import AppointmentProvider
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.request_phlebotomy_appointment(order_id='order_id', address=UsAddress(first_line='first_line', city='city', state='state', zip_code='zip_code', ), provider=AppointmentProvider.GETLABS, )
        """
        _response = self._raw_client.request_phlebotomy_appointment(
            order_id, address=address, provider=provider, request_options=request_options
        )
        return _response.data

    def reschedule_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentRescheduleRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Reschedule a previously booked at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentRescheduleRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import AppointmentRescheduleRequest
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.reschedule_phlebotomy_appointment(order_id='order_id', request=AppointmentRescheduleRequest(booking_key='booking_key', ), )
        """
        _response = self._raw_client.reschedule_phlebotomy_appointment(
            order_id, request=request, request_options=request_options
        )
        return _response.data

    def cancel_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        cancellation_reason_id: str,
        notes: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Cancel a previously booked at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        cancellation_reason_id : str

        notes : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.cancel_phlebotomy_appointment(order_id='order_id', cancellation_reason_id='cancellation_reason_id', )
        """
        _response = self._raw_client.cancel_phlebotomy_appointment(
            order_id, cancellation_reason_id=cancellation_reason_id, notes=notes, request_options=request_options
        )
        return _response.data

    def get_phlebotomy_appointment_cancellation_reason(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingAppointmentCancellationReason]:
        """
        Get the list of reasons for cancelling an at-home phlebotomy appointment.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingAppointmentCancellationReason]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_phlebotomy_appointment_cancellation_reason()
        """
        _response = self._raw_client.get_phlebotomy_appointment_cancellation_reason(request_options=request_options)
        return _response.data

    def get_phlebotomy_appointment(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingAppointment:
        """
        Get the appointment associated with an order.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_phlebotomy_appointment(order_id='order_id', )
        """
        _response = self._raw_client.get_phlebotomy_appointment(order_id, request_options=request_options)
        return _response.data

    def get_area_info(
        self,
        *,
        zip_code: str,
        radius: typing.Optional[AllowedRadius] = None,
        lab: typing.Optional[ClientFacingLabs] = None,
        labs: typing.Optional[typing.Union[ClientFacingLabs, typing.Sequence[ClientFacingLabs]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AreaInfo:
        """
        GET information about an area with respect to lab-testing.

        Information returned:
        * Whether a given zip code is served by our Phlebotomy network.
        * List of Lab locations in the area.

        Parameters
        ----------
        zip_code : str
            Zip code of the area to check

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        lab : typing.Optional[ClientFacingLabs]
            Lab to check for PSCs

        labs : typing.Optional[typing.Union[ClientFacingLabs, typing.Sequence[ClientFacingLabs]]]
            List of labs to check for PSCs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AreaInfo
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_area_info(zip_code='zip_code', )
        """
        _response = self._raw_client.get_area_info(
            zip_code=zip_code, radius=radius, lab=lab, labs=labs, request_options=request_options
        )
        return _response.data

    def get_psc_info(
        self,
        *,
        zip_code: str,
        lab_id: int,
        radius: typing.Optional[AllowedRadius] = None,
        capabilities: typing.Optional[
            typing.Union[LabLocationCapability, typing.Sequence[LabLocationCapability]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PscInfo:
        """
        Parameters
        ----------
        zip_code : str
            Zip code of the area to check

        lab_id : int
            Lab ID to check for PSCs

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        capabilities : typing.Optional[typing.Union[LabLocationCapability, typing.Sequence[LabLocationCapability]]]
            Filter for only locations with certain capabilities

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PscInfo
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_psc_info(zip_code='zip_code', lab_id=1, )
        """
        _response = self._raw_client.get_psc_info(
            zip_code=zip_code, lab_id=lab_id, radius=radius, capabilities=capabilities, request_options=request_options
        )
        return _response.data

    def get_order_psc_info(
        self,
        order_id: str,
        *,
        radius: typing.Optional[AllowedRadius] = None,
        capabilities: typing.Optional[
            typing.Union[LabLocationCapability, typing.Sequence[LabLocationCapability]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PscInfo:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        capabilities : typing.Optional[typing.Union[LabLocationCapability, typing.Sequence[LabLocationCapability]]]
            Filter for only locations with certain capabilities

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PscInfo
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_order_psc_info(order_id='order_id', )
        """
        _response = self._raw_client.get_order_psc_info(
            order_id, radius=radius, capabilities=capabilities, request_options=request_options
        )
        return _response.data

    def get_result_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[bytes]:
        """
        This endpoint returns the lab results for the order.

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            PDF with results
        """
        with self._raw_client.get_result_pdf(order_id, request_options=request_options) as r:
            yield from r.data

    def get_result_metadata(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> LabResultsMetadata:
        """
        Return metadata related to order results, such as lab metadata,
        provider and sample dates.

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LabResultsMetadata
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_result_metadata(order_id='order_id', )
        """
        _response = self._raw_client.get_result_metadata(order_id, request_options=request_options)
        return _response.data

    def get_result_raw(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> LabResultsRaw:
        """
        Return both metadata and raw json test data

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LabResultsRaw
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_result_raw(order_id='order_id', )
        """
        _response = self._raw_client.get_result_raw(order_id, request_options=request_options)
        return _response.data

    def get_labels_pdf(
        self,
        order_id: str,
        *,
        collection_date: dt.datetime,
        number_of_labels: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        This endpoint returns the printed labels for the order.

        Parameters
        ----------
        order_id : str

        collection_date : dt.datetime
            Collection date

        number_of_labels : typing.Optional[int]
            Number of labels to generate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            PDF with labels
        """
        with self._raw_client.get_labels_pdf(
            order_id,
            collection_date=collection_date,
            number_of_labels=number_of_labels,
            request_options=request_options,
        ) as r:
            yield from r.data

    def get_psc_appointment_availability(
        self,
        *,
        start_date: typing.Optional[str] = None,
        site_codes: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        zip_code: typing.Optional[str] = None,
        radius: typing.Optional[AllowedRadius] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppointmentAvailabilitySlots:
        """
        Parameters
        ----------
        start_date : typing.Optional[str]
            Start date for appointment availability

        site_codes : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of site codes to fetch availability for

        zip_code : typing.Optional[str]
            Zip code of the area to check

        radius : typing.Optional[AllowedRadius]
            Radius in which to search. (meters)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppointmentAvailabilitySlots
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_psc_appointment_availability()
        """
        _response = self._raw_client.get_psc_appointment_availability(
            start_date=start_date,
            site_codes=site_codes,
            zip_code=zip_code,
            radius=radius,
            request_options=request_options,
        )
        return _response.data

    def book_psc_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentBookingRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentBookingRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import AppointmentBookingRequest
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.book_psc_appointment(order_id='order_id', request=AppointmentBookingRequest(booking_key='booking_key', ), )
        """
        _response = self._raw_client.book_psc_appointment(order_id, request=request, request_options=request_options)
        return _response.data

    def reschedule_psc_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentRescheduleRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentRescheduleRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import AppointmentRescheduleRequest
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.reschedule_psc_appointment(order_id='order_id', request=AppointmentRescheduleRequest(booking_key='booking_key', ), )
        """
        _response = self._raw_client.reschedule_psc_appointment(
            order_id, request=request, request_options=request_options
        )
        return _response.data

    def cancel_psc_appointment(
        self,
        order_id: str,
        *,
        cancellation_reason_id: str,
        note: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        cancellation_reason_id : str

        note : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.cancel_psc_appointment(order_id='order_id', cancellation_reason_id='cancellationReasonId', )
        """
        _response = self._raw_client.cancel_psc_appointment(
            order_id, cancellation_reason_id=cancellation_reason_id, note=note, request_options=request_options
        )
        return _response.data

    def get_psc_appointment_cancellation_reason(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingAppointmentCancellationReason]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingAppointmentCancellationReason]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_psc_appointment_cancellation_reason()
        """
        _response = self._raw_client.get_psc_appointment_cancellation_reason(request_options=request_options)
        return _response.data

    def get_psc_appointment(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingAppointment:
        """
        Get the appointment associated with an order.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_psc_appointment(order_id='order_id', )
        """
        _response = self._raw_client.get_psc_appointment(order_id, request_options=request_options)
        return _response.data

    def get_order_collection_instruction_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[bytes]:
        """
        GET collection instructions for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            PDF with collection instructions
        """
        with self._raw_client.get_order_collection_instruction_pdf(order_id, request_options=request_options) as r:
            yield from r.data

    def get_order_requistion_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[bytes]:
        """
        GET requisition pdf for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            PDF with requisition form
        """
        with self._raw_client.get_order_requistion_pdf(order_id, request_options=request_options) as r:
            yield from r.data

    def get_order_abn_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[bytes]:
        """
        GET ABN pdf for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            PDF with ABN form
        """
        with self._raw_client.get_order_abn_pdf(order_id, request_options=request_options) as r:
            yield from r.data

    def get_order(self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ClientFacingOrder:
        """
        GET individual order by ID.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingOrder
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_order(order_id='order_id', )
        """
        _response = self._raw_client.get_order(order_id, request_options=request_options)
        return _response.data

    def create_order(
        self,
        *,
        user_id: str,
        patient_details: PatientDetailsWithValidation,
        patient_address: PatientAddressWithValidation,
        lab_test_id: typing.Optional[str] = OMIT,
        order_set: typing.Optional[OrderSetRequest] = OMIT,
        collection_method: typing.Optional[LabTestCollectionMethod] = OMIT,
        physician: typing.Optional[PhysicianCreateRequest] = OMIT,
        health_insurance: typing.Optional[HealthInsuranceCreateRequest] = OMIT,
        priority: typing.Optional[bool] = OMIT,
        billing_type: typing.Optional[Billing] = OMIT,
        icd_codes: typing.Optional[typing.Sequence[str]] = OMIT,
        consents: typing.Optional[typing.Sequence[Consent]] = OMIT,
        activate_by: typing.Optional[str] = OMIT,
        aoe_answers: typing.Optional[typing.Sequence[AoEAnswer]] = OMIT,
        passthrough: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostOrderResponse:
        """
        Parameters
        ----------
        user_id : str

        patient_details : PatientDetailsWithValidation

        patient_address : PatientAddressWithValidation

        lab_test_id : typing.Optional[str]

        order_set : typing.Optional[OrderSetRequest]

        collection_method : typing.Optional[LabTestCollectionMethod]

        physician : typing.Optional[PhysicianCreateRequest]

        health_insurance : typing.Optional[HealthInsuranceCreateRequest]

        priority : typing.Optional[bool]
            Defines whether order is priority or not. For some labs, this refers to a STAT order.

        billing_type : typing.Optional[Billing]

        icd_codes : typing.Optional[typing.Sequence[str]]

        consents : typing.Optional[typing.Sequence[Consent]]

        activate_by : typing.Optional[str]
            Schedule an Order to be processed in a future date.

        aoe_answers : typing.Optional[typing.Sequence[AoEAnswer]]

        passthrough : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostOrderResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import PatientDetailsWithValidation
        from vital import Gender
        from vital import PatientAddressWithValidation
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.create_order(user_id='user_id', patient_details=PatientDetailsWithValidation(first_name='first_name', last_name='last_name', dob='dob', gender=Gender.FEMALE, phone_number='phone_number', email='email', ), patient_address=PatientAddressWithValidation(first_line='first_line', city='city', state='state', zip='zip', country='country', ), )
        """
        _response = self._raw_client.create_order(
            user_id=user_id,
            patient_details=patient_details,
            patient_address=patient_address,
            lab_test_id=lab_test_id,
            order_set=order_set,
            collection_method=collection_method,
            physician=physician,
            health_insurance=health_insurance,
            priority=priority,
            billing_type=billing_type,
            icd_codes=icd_codes,
            consents=consents,
            activate_by=activate_by,
            aoe_answers=aoe_answers,
            passthrough=passthrough,
            request_options=request_options,
        )
        return _response.data

    def import_order(
        self,
        *,
        user_id: str,
        billing_type: Billing,
        order_set: OrderSetRequest,
        collection_method: LabTestCollectionMethod,
        patient_details: PatientDetailsWithValidation,
        patient_address: PatientAddress,
        sample_id: str,
        physician: typing.Optional[PhysicianCreateRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostOrderResponse:
        """
        Parameters
        ----------
        user_id : str

        billing_type : Billing

        order_set : OrderSetRequest

        collection_method : LabTestCollectionMethod

        patient_details : PatientDetailsWithValidation

        patient_address : PatientAddress

        sample_id : str

        physician : typing.Optional[PhysicianCreateRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostOrderResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import Billing
        from vital import OrderSetRequest
        from vital import LabTestCollectionMethod
        from vital import PatientDetailsWithValidation
        from vital import Gender
        from vital import PatientAddress
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.import_order(user_id='user_id', billing_type=Billing.CLIENT_BILL, order_set=OrderSetRequest(), collection_method=LabTestCollectionMethod.TESTKIT, patient_details=PatientDetailsWithValidation(first_name='first_name', last_name='last_name', dob='dob', gender=Gender.FEMALE, phone_number='phone_number', email='email', ), patient_address=PatientAddress(receiver_name='receiver_name', first_line='first_line', city='city', state='state', zip='zip', country='country', ), sample_id='sample_id', )
        """
        _response = self._raw_client.import_order(
            user_id=user_id,
            billing_type=billing_type,
            order_set=order_set,
            collection_method=collection_method,
            patient_details=patient_details,
            patient_address=patient_address,
            sample_id=sample_id,
            physician=physician,
            request_options=request_options,
        )
        return _response.data

    def cancel_order(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PostOrderResponse:
        """
        POST cancel order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostOrderResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.cancel_order(order_id='order_id', )
        """
        _response = self._raw_client.cancel_order(order_id, request_options=request_options)
        return _response.data

    def simulate_order_process(
        self,
        order_id: str,
        *,
        final_status: typing.Optional[OrderStatus] = None,
        delay: typing.Optional[int] = None,
        request: typing.Optional[SimulationFlags] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Get available test kits.

        Parameters
        ----------
        order_id : str

        final_status : typing.Optional[OrderStatus]

        delay : typing.Optional[int]

        request : typing.Optional[SimulationFlags]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.simulate_order_process(order_id='order_id', )
        """
        _response = self._raw_client.simulate_order_process(
            order_id, final_status=final_status, delay=delay, request=request, request_options=request_options
        )
        return _response.data

    def update_on_site_collection_order_draw_completed(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PostOrderResponse:
        """
        PATCH update on site collection order when draw is completed

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostOrderResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.update_on_site_collection_order_draw_completed(order_id='order_id', )
        """
        _response = self._raw_client.update_on_site_collection_order_draw_completed(
            order_id, request_options=request_options
        )
        return _response.data

    def get_orders(
        self,
        *,
        search_input: typing.Optional[str] = None,
        start_date: typing.Optional[dt.datetime] = None,
        end_date: typing.Optional[dt.datetime] = None,
        updated_start_date: typing.Optional[dt.datetime] = None,
        updated_end_date: typing.Optional[dt.datetime] = None,
        status: typing.Optional[typing.Union[OrderLowLevelStatus, typing.Sequence[OrderLowLevelStatus]]] = None,
        order_key: typing.Optional[LabTestsGetOrdersRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetOrdersRequestOrderDirection] = None,
        order_type: typing.Optional[
            typing.Union[LabTestCollectionMethod, typing.Sequence[LabTestCollectionMethod]]
        ] = None,
        is_critical: typing.Optional[bool] = None,
        interpretation: typing.Optional[Interpretation] = None,
        order_activation_types: typing.Optional[
            typing.Union[OrderActivationType, typing.Sequence[OrderActivationType]]
        ] = None,
        user_id: typing.Optional[str] = None,
        patient_name: typing.Optional[str] = None,
        shipping_recipient_name: typing.Optional[str] = None,
        order_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetOrdersResponse:
        """
        GET many orders with filters.

        Parameters
        ----------
        search_input : typing.Optional[str]
            Search by order id, user id, patient name, shipping dob, or shipping recipient name.

        start_date : typing.Optional[dt.datetime]
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        end_date : typing.Optional[dt.datetime]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        updated_start_date : typing.Optional[dt.datetime]
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        updated_end_date : typing.Optional[dt.datetime]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        status : typing.Optional[typing.Union[OrderLowLevelStatus, typing.Sequence[OrderLowLevelStatus]]]
            Filter by low level status.

        order_key : typing.Optional[LabTestsGetOrdersRequestOrderKey]
            Order key to sort by.

        order_direction : typing.Optional[LabTestsGetOrdersRequestOrderDirection]
            Order direction to sort by.

        order_type : typing.Optional[typing.Union[LabTestCollectionMethod, typing.Sequence[LabTestCollectionMethod]]]
            Filter by method used to perform the lab test.

        is_critical : typing.Optional[bool]
            Filter by critical order status.

        interpretation : typing.Optional[Interpretation]
            Filter by result interpretation of the lab test.

        order_activation_types : typing.Optional[typing.Union[OrderActivationType, typing.Sequence[OrderActivationType]]]
            Filter by activation type.

        user_id : typing.Optional[str]
            Filter by user ID.

        patient_name : typing.Optional[str]
            Filter by patient name.

        shipping_recipient_name : typing.Optional[str]
            Filter by shipping recipient name.

        order_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter by order ids.

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrdersResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.lab_tests.get_orders()
        """
        _response = self._raw_client.get_orders(
            search_input=search_input,
            start_date=start_date,
            end_date=end_date,
            updated_start_date=updated_start_date,
            updated_end_date=updated_end_date,
            status=status,
            order_key=order_key,
            order_direction=order_direction,
            order_type=order_type,
            is_critical=is_critical,
            interpretation=interpretation,
            order_activation_types=order_activation_types,
            user_id=user_id,
            patient_name=patient_name,
            shipping_recipient_name=shipping_recipient_name,
            order_ids=order_ids,
            page=page,
            size=size,
            request_options=request_options,
        )
        return _response.data


class AsyncLabTestsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawLabTestsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawLabTestsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawLabTestsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        generation_method: typing.Optional[LabTestGenerationMethodFilter] = None,
        lab_slug: typing.Optional[str] = None,
        collection_method: typing.Optional[LabTestCollectionMethod] = None,
        status: typing.Optional[LabTestStatus] = None,
        marker_ids: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        provider_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        order_key: typing.Optional[LabTestsGetRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingLabTest]:
        """
        GET all the lab tests the team has access to.

        Parameters
        ----------
        generation_method : typing.Optional[LabTestGenerationMethodFilter]
            Filter on whether auto-generated lab tests created by Vital, manually created lab tests, or all lab tests should be returned.

        lab_slug : typing.Optional[str]
            Filter by the slug of the lab for these lab tests.

        collection_method : typing.Optional[LabTestCollectionMethod]
            Filter by the collection method for these lab tests.

        status : typing.Optional[LabTestStatus]
            Filter by the status of these lab tests.

        marker_ids : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            Filter to only include lab tests containing these marker IDs.

        provider_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter to only include lab tests containing these provider IDs.

        name : typing.Optional[str]
            Filter by the name of the lab test (a case-insensitive substring search).

        order_key : typing.Optional[LabTestsGetRequestOrderKey]

        order_direction : typing.Optional[LabTestsGetRequestOrderDirection]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingLabTest]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            generation_method=generation_method,
            lab_slug=lab_slug,
            collection_method=collection_method,
            status=status,
            marker_ids=marker_ids,
            provider_ids=provider_ids,
            name=name,
            order_key=order_key,
            order_direction=order_direction,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        name: str,
        method: LabTestCollectionMethod,
        description: str,
        marker_ids: typing.Optional[typing.Sequence[int]] = OMIT,
        provider_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        fasting: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingLabTest:
        """
        Parameters
        ----------
        name : str

        method : LabTestCollectionMethod

        description : str

        marker_ids : typing.Optional[typing.Sequence[int]]

        provider_ids : typing.Optional[typing.Sequence[str]]

        fasting : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingLabTest
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import LabTestCollectionMethod
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.create(name='name', method=LabTestCollectionMethod.TESTKIT, description='description', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            method=method,
            description=description,
            marker_ids=marker_ids,
            provider_ids=provider_ids,
            fasting=fasting,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, lab_test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingLabTest:
        """
        GET all the lab tests the team has access to.

        Parameters
        ----------
        lab_test_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingLabTest
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_by_id(lab_test_id='lab_test_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(lab_test_id, request_options=request_options)
        return _response.data

    async def update_lab_test(
        self,
        lab_test_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingLabTest:
        """
        Parameters
        ----------
        lab_test_id : str

        name : typing.Optional[str]

        active : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingLabTest
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.update_lab_test(lab_test_id='lab_test_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_lab_test(
            lab_test_id, name=name, active=active, request_options=request_options
        )
        return _response.data

    async def get_markers(
        self,
        *,
        lab_id: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        name: typing.Optional[str] = None,
        a_la_carte_enabled: typing.Optional[bool] = None,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetMarkersResponse:
        """
        GET all the markers for the given lab.

        Parameters
        ----------
        lab_id : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            The identifier Vital assigned to a lab partner.

        name : typing.Optional[str]
            The name or test code of an individual biomarker or a panel.

        a_la_carte_enabled : typing.Optional[bool]

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMarkersResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_markers()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_markers(
            lab_id=lab_id,
            name=name,
            a_la_carte_enabled=a_la_carte_enabled,
            page=page,
            size=size,
            request_options=request_options,
        )
        return _response.data

    async def get_markers_for_order_set(
        self,
        *,
        request: OrderSetRequest,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetMarkersResponse:
        """
        Parameters
        ----------
        request : OrderSetRequest

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMarkersResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import OrderSetRequest
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_markers_for_order_set(request=OrderSetRequest(), )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_markers_for_order_set(
            request=request, page=page, size=size, request_options=request_options
        )
        return _response.data

    async def get_markers_for_lab_test(
        self,
        lab_test_id: str,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetMarkersResponse:
        """
        Parameters
        ----------
        lab_test_id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMarkersResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_markers_for_lab_test(lab_test_id='lab_test_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_markers_for_lab_test(
            lab_test_id, page=page, size=size, request_options=request_options
        )
        return _response.data

    async def get_markers_by_lab_and_provider_id(
        self, provider_id: str, lab_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingMarker:
        """
        GET a specific marker for the given lab and provider_id

        Parameters
        ----------
        provider_id : str

        lab_id : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingMarker
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_markers_by_lab_and_provider_id(provider_id='provider_id', lab_id=1, )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_markers_by_lab_and_provider_id(
            provider_id, lab_id, request_options=request_options
        )
        return _response.data

    async def get_labs(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingLab]:
        """
        GET all the labs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingLab]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_labs()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_labs(request_options=request_options)
        return _response.data

    async def get_paginated(
        self,
        *,
        lab_test_limit: typing.Optional[int] = None,
        next_cursor: typing.Optional[str] = None,
        generation_method: typing.Optional[LabTestGenerationMethodFilter] = None,
        lab_slug: typing.Optional[str] = None,
        collection_method: typing.Optional[LabTestCollectionMethod] = None,
        status: typing.Optional[LabTestStatus] = None,
        marker_ids: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        provider_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        order_key: typing.Optional[LabTestsGetPaginatedRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetPaginatedRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LabTestResourcesResponse:
        """
        GET lab tests the team has access to as a paginated list.

        Parameters
        ----------
        lab_test_limit : typing.Optional[int]

        next_cursor : typing.Optional[str]

        generation_method : typing.Optional[LabTestGenerationMethodFilter]
            Filter on whether auto-generated lab tests created by Vital, manually created lab tests, or all lab tests should be returned.

        lab_slug : typing.Optional[str]
            Filter by the slug of the lab for these lab tests.

        collection_method : typing.Optional[LabTestCollectionMethod]
            Filter by the collection method for these lab tests.

        status : typing.Optional[LabTestStatus]
            Filter by the status of these lab tests.

        marker_ids : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            Filter to only include lab tests containing these marker IDs.

        provider_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter to only include lab tests containing these provider IDs.

        name : typing.Optional[str]
            Filter by the name of the lab test (a case-insensitive substring search).

        order_key : typing.Optional[LabTestsGetPaginatedRequestOrderKey]

        order_direction : typing.Optional[LabTestsGetPaginatedRequestOrderDirection]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LabTestResourcesResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_paginated()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_paginated(
            lab_test_limit=lab_test_limit,
            next_cursor=next_cursor,
            generation_method=generation_method,
            lab_slug=lab_slug,
            collection_method=collection_method,
            status=status,
            marker_ids=marker_ids,
            provider_ids=provider_ids,
            name=name,
            order_key=order_key,
            order_direction=order_direction,
            request_options=request_options,
        )
        return _response.data

    async def get_lab_test_collection_instruction_pdf(
        self, lab_test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[bytes]:
        """
        GET collection instructions for a lab test

        Parameters
        ----------
        lab_test_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            PDF with collection instructions
        """
        async with self._raw_client.get_lab_test_collection_instruction_pdf(
            lab_test_id, request_options=request_options
        ) as r:
            async for data in r.data:
                yield data

    async def get_phlebotomy_appointment_availability(
        self,
        *,
        request: UsAddress,
        start_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppointmentAvailabilitySlots:
        """
        Return the available time slots to book an appointment with a phlebotomist
        for the given address and order.

        Parameters
        ----------
        request : UsAddress

        start_date : typing.Optional[str]
            Start date for appointment availability

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppointmentAvailabilitySlots
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import UsAddress
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_phlebotomy_appointment_availability(request=UsAddress(first_line='first_line', city='city', state='state', zip_code='zip_code', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_phlebotomy_appointment_availability(
            request=request, start_date=start_date, request_options=request_options
        )
        return _response.data

    async def book_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentBookingRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Book an at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentBookingRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import AppointmentBookingRequest
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.book_phlebotomy_appointment(order_id='order_id', request=AppointmentBookingRequest(booking_key='booking_key', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.book_phlebotomy_appointment(
            order_id, request=request, request_options=request_options
        )
        return _response.data

    async def request_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        address: UsAddress,
        provider: AppointmentProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Request an at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        address : UsAddress
            At-home phlebotomy appointment address.

        provider : AppointmentProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import UsAddress
        from vital import AppointmentProvider
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.request_phlebotomy_appointment(order_id='order_id', address=UsAddress(first_line='first_line', city='city', state='state', zip_code='zip_code', ), provider=AppointmentProvider.GETLABS, )
        asyncio.run(main())
        """
        _response = await self._raw_client.request_phlebotomy_appointment(
            order_id, address=address, provider=provider, request_options=request_options
        )
        return _response.data

    async def reschedule_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentRescheduleRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Reschedule a previously booked at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentRescheduleRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import AppointmentRescheduleRequest
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.reschedule_phlebotomy_appointment(order_id='order_id', request=AppointmentRescheduleRequest(booking_key='booking_key', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.reschedule_phlebotomy_appointment(
            order_id, request=request, request_options=request_options
        )
        return _response.data

    async def cancel_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        cancellation_reason_id: str,
        notes: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Cancel a previously booked at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        cancellation_reason_id : str

        notes : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.cancel_phlebotomy_appointment(order_id='order_id', cancellation_reason_id='cancellation_reason_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cancel_phlebotomy_appointment(
            order_id, cancellation_reason_id=cancellation_reason_id, notes=notes, request_options=request_options
        )
        return _response.data

    async def get_phlebotomy_appointment_cancellation_reason(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingAppointmentCancellationReason]:
        """
        Get the list of reasons for cancelling an at-home phlebotomy appointment.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingAppointmentCancellationReason]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_phlebotomy_appointment_cancellation_reason()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_phlebotomy_appointment_cancellation_reason(
            request_options=request_options
        )
        return _response.data

    async def get_phlebotomy_appointment(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingAppointment:
        """
        Get the appointment associated with an order.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_phlebotomy_appointment(order_id='order_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_phlebotomy_appointment(order_id, request_options=request_options)
        return _response.data

    async def get_area_info(
        self,
        *,
        zip_code: str,
        radius: typing.Optional[AllowedRadius] = None,
        lab: typing.Optional[ClientFacingLabs] = None,
        labs: typing.Optional[typing.Union[ClientFacingLabs, typing.Sequence[ClientFacingLabs]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AreaInfo:
        """
        GET information about an area with respect to lab-testing.

        Information returned:
        * Whether a given zip code is served by our Phlebotomy network.
        * List of Lab locations in the area.

        Parameters
        ----------
        zip_code : str
            Zip code of the area to check

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        lab : typing.Optional[ClientFacingLabs]
            Lab to check for PSCs

        labs : typing.Optional[typing.Union[ClientFacingLabs, typing.Sequence[ClientFacingLabs]]]
            List of labs to check for PSCs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AreaInfo
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_area_info(zip_code='zip_code', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_area_info(
            zip_code=zip_code, radius=radius, lab=lab, labs=labs, request_options=request_options
        )
        return _response.data

    async def get_psc_info(
        self,
        *,
        zip_code: str,
        lab_id: int,
        radius: typing.Optional[AllowedRadius] = None,
        capabilities: typing.Optional[
            typing.Union[LabLocationCapability, typing.Sequence[LabLocationCapability]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PscInfo:
        """
        Parameters
        ----------
        zip_code : str
            Zip code of the area to check

        lab_id : int
            Lab ID to check for PSCs

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        capabilities : typing.Optional[typing.Union[LabLocationCapability, typing.Sequence[LabLocationCapability]]]
            Filter for only locations with certain capabilities

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PscInfo
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_psc_info(zip_code='zip_code', lab_id=1, )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_psc_info(
            zip_code=zip_code, lab_id=lab_id, radius=radius, capabilities=capabilities, request_options=request_options
        )
        return _response.data

    async def get_order_psc_info(
        self,
        order_id: str,
        *,
        radius: typing.Optional[AllowedRadius] = None,
        capabilities: typing.Optional[
            typing.Union[LabLocationCapability, typing.Sequence[LabLocationCapability]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PscInfo:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        capabilities : typing.Optional[typing.Union[LabLocationCapability, typing.Sequence[LabLocationCapability]]]
            Filter for only locations with certain capabilities

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PscInfo
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_order_psc_info(order_id='order_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_order_psc_info(
            order_id, radius=radius, capabilities=capabilities, request_options=request_options
        )
        return _response.data

    async def get_result_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[bytes]:
        """
        This endpoint returns the lab results for the order.

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            PDF with results
        """
        async with self._raw_client.get_result_pdf(order_id, request_options=request_options) as r:
            async for data in r.data:
                yield data

    async def get_result_metadata(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> LabResultsMetadata:
        """
        Return metadata related to order results, such as lab metadata,
        provider and sample dates.

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LabResultsMetadata
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_result_metadata(order_id='order_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_result_metadata(order_id, request_options=request_options)
        return _response.data

    async def get_result_raw(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> LabResultsRaw:
        """
        Return both metadata and raw json test data

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LabResultsRaw
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_result_raw(order_id='order_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_result_raw(order_id, request_options=request_options)
        return _response.data

    async def get_labels_pdf(
        self,
        order_id: str,
        *,
        collection_date: dt.datetime,
        number_of_labels: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        This endpoint returns the printed labels for the order.

        Parameters
        ----------
        order_id : str

        collection_date : dt.datetime
            Collection date

        number_of_labels : typing.Optional[int]
            Number of labels to generate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            PDF with labels
        """
        async with self._raw_client.get_labels_pdf(
            order_id,
            collection_date=collection_date,
            number_of_labels=number_of_labels,
            request_options=request_options,
        ) as r:
            async for data in r.data:
                yield data

    async def get_psc_appointment_availability(
        self,
        *,
        start_date: typing.Optional[str] = None,
        site_codes: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        zip_code: typing.Optional[str] = None,
        radius: typing.Optional[AllowedRadius] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppointmentAvailabilitySlots:
        """
        Parameters
        ----------
        start_date : typing.Optional[str]
            Start date for appointment availability

        site_codes : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of site codes to fetch availability for

        zip_code : typing.Optional[str]
            Zip code of the area to check

        radius : typing.Optional[AllowedRadius]
            Radius in which to search. (meters)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppointmentAvailabilitySlots
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_psc_appointment_availability()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_psc_appointment_availability(
            start_date=start_date,
            site_codes=site_codes,
            zip_code=zip_code,
            radius=radius,
            request_options=request_options,
        )
        return _response.data

    async def book_psc_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentBookingRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentBookingRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import AppointmentBookingRequest
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.book_psc_appointment(order_id='order_id', request=AppointmentBookingRequest(booking_key='booking_key', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.book_psc_appointment(
            order_id, request=request, request_options=request_options
        )
        return _response.data

    async def reschedule_psc_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentRescheduleRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentRescheduleRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import AppointmentRescheduleRequest
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.reschedule_psc_appointment(order_id='order_id', request=AppointmentRescheduleRequest(booking_key='booking_key', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.reschedule_psc_appointment(
            order_id, request=request, request_options=request_options
        )
        return _response.data

    async def cancel_psc_appointment(
        self,
        order_id: str,
        *,
        cancellation_reason_id: str,
        note: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingAppointment:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        cancellation_reason_id : str

        note : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.cancel_psc_appointment(order_id='order_id', cancellation_reason_id='cancellationReasonId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cancel_psc_appointment(
            order_id, cancellation_reason_id=cancellation_reason_id, note=note, request_options=request_options
        )
        return _response.data

    async def get_psc_appointment_cancellation_reason(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingAppointmentCancellationReason]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingAppointmentCancellationReason]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_psc_appointment_cancellation_reason()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_psc_appointment_cancellation_reason(request_options=request_options)
        return _response.data

    async def get_psc_appointment(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingAppointment:
        """
        Get the appointment associated with an order.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingAppointment
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_psc_appointment(order_id='order_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_psc_appointment(order_id, request_options=request_options)
        return _response.data

    async def get_order_collection_instruction_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[bytes]:
        """
        GET collection instructions for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            PDF with collection instructions
        """
        async with self._raw_client.get_order_collection_instruction_pdf(
            order_id, request_options=request_options
        ) as r:
            async for data in r.data:
                yield data

    async def get_order_requistion_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[bytes]:
        """
        GET requisition pdf for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            PDF with requisition form
        """
        async with self._raw_client.get_order_requistion_pdf(order_id, request_options=request_options) as r:
            async for data in r.data:
                yield data

    async def get_order_abn_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[bytes]:
        """
        GET ABN pdf for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            PDF with ABN form
        """
        async with self._raw_client.get_order_abn_pdf(order_id, request_options=request_options) as r:
            async for data in r.data:
                yield data

    async def get_order(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingOrder:
        """
        GET individual order by ID.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingOrder
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_order(order_id='order_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_order(order_id, request_options=request_options)
        return _response.data

    async def create_order(
        self,
        *,
        user_id: str,
        patient_details: PatientDetailsWithValidation,
        patient_address: PatientAddressWithValidation,
        lab_test_id: typing.Optional[str] = OMIT,
        order_set: typing.Optional[OrderSetRequest] = OMIT,
        collection_method: typing.Optional[LabTestCollectionMethod] = OMIT,
        physician: typing.Optional[PhysicianCreateRequest] = OMIT,
        health_insurance: typing.Optional[HealthInsuranceCreateRequest] = OMIT,
        priority: typing.Optional[bool] = OMIT,
        billing_type: typing.Optional[Billing] = OMIT,
        icd_codes: typing.Optional[typing.Sequence[str]] = OMIT,
        consents: typing.Optional[typing.Sequence[Consent]] = OMIT,
        activate_by: typing.Optional[str] = OMIT,
        aoe_answers: typing.Optional[typing.Sequence[AoEAnswer]] = OMIT,
        passthrough: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostOrderResponse:
        """
        Parameters
        ----------
        user_id : str

        patient_details : PatientDetailsWithValidation

        patient_address : PatientAddressWithValidation

        lab_test_id : typing.Optional[str]

        order_set : typing.Optional[OrderSetRequest]

        collection_method : typing.Optional[LabTestCollectionMethod]

        physician : typing.Optional[PhysicianCreateRequest]

        health_insurance : typing.Optional[HealthInsuranceCreateRequest]

        priority : typing.Optional[bool]
            Defines whether order is priority or not. For some labs, this refers to a STAT order.

        billing_type : typing.Optional[Billing]

        icd_codes : typing.Optional[typing.Sequence[str]]

        consents : typing.Optional[typing.Sequence[Consent]]

        activate_by : typing.Optional[str]
            Schedule an Order to be processed in a future date.

        aoe_answers : typing.Optional[typing.Sequence[AoEAnswer]]

        passthrough : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostOrderResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import PatientDetailsWithValidation
        from vital import Gender
        from vital import PatientAddressWithValidation
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.create_order(user_id='user_id', patient_details=PatientDetailsWithValidation(first_name='first_name', last_name='last_name', dob='dob', gender=Gender.FEMALE, phone_number='phone_number', email='email', ), patient_address=PatientAddressWithValidation(first_line='first_line', city='city', state='state', zip='zip', country='country', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_order(
            user_id=user_id,
            patient_details=patient_details,
            patient_address=patient_address,
            lab_test_id=lab_test_id,
            order_set=order_set,
            collection_method=collection_method,
            physician=physician,
            health_insurance=health_insurance,
            priority=priority,
            billing_type=billing_type,
            icd_codes=icd_codes,
            consents=consents,
            activate_by=activate_by,
            aoe_answers=aoe_answers,
            passthrough=passthrough,
            request_options=request_options,
        )
        return _response.data

    async def import_order(
        self,
        *,
        user_id: str,
        billing_type: Billing,
        order_set: OrderSetRequest,
        collection_method: LabTestCollectionMethod,
        patient_details: PatientDetailsWithValidation,
        patient_address: PatientAddress,
        sample_id: str,
        physician: typing.Optional[PhysicianCreateRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostOrderResponse:
        """
        Parameters
        ----------
        user_id : str

        billing_type : Billing

        order_set : OrderSetRequest

        collection_method : LabTestCollectionMethod

        patient_details : PatientDetailsWithValidation

        patient_address : PatientAddress

        sample_id : str

        physician : typing.Optional[PhysicianCreateRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostOrderResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import Billing
        from vital import OrderSetRequest
        from vital import LabTestCollectionMethod
        from vital import PatientDetailsWithValidation
        from vital import Gender
        from vital import PatientAddress
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.import_order(user_id='user_id', billing_type=Billing.CLIENT_BILL, order_set=OrderSetRequest(), collection_method=LabTestCollectionMethod.TESTKIT, patient_details=PatientDetailsWithValidation(first_name='first_name', last_name='last_name', dob='dob', gender=Gender.FEMALE, phone_number='phone_number', email='email', ), patient_address=PatientAddress(receiver_name='receiver_name', first_line='first_line', city='city', state='state', zip='zip', country='country', ), sample_id='sample_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.import_order(
            user_id=user_id,
            billing_type=billing_type,
            order_set=order_set,
            collection_method=collection_method,
            patient_details=patient_details,
            patient_address=patient_address,
            sample_id=sample_id,
            physician=physician,
            request_options=request_options,
        )
        return _response.data

    async def cancel_order(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PostOrderResponse:
        """
        POST cancel order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostOrderResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.cancel_order(order_id='order_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cancel_order(order_id, request_options=request_options)
        return _response.data

    async def simulate_order_process(
        self,
        order_id: str,
        *,
        final_status: typing.Optional[OrderStatus] = None,
        delay: typing.Optional[int] = None,
        request: typing.Optional[SimulationFlags] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Get available test kits.

        Parameters
        ----------
        order_id : str

        final_status : typing.Optional[OrderStatus]

        delay : typing.Optional[int]

        request : typing.Optional[SimulationFlags]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.simulate_order_process(order_id='order_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.simulate_order_process(
            order_id, final_status=final_status, delay=delay, request=request, request_options=request_options
        )
        return _response.data

    async def update_on_site_collection_order_draw_completed(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PostOrderResponse:
        """
        PATCH update on site collection order when draw is completed

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostOrderResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.update_on_site_collection_order_draw_completed(order_id='order_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_on_site_collection_order_draw_completed(
            order_id, request_options=request_options
        )
        return _response.data

    async def get_orders(
        self,
        *,
        search_input: typing.Optional[str] = None,
        start_date: typing.Optional[dt.datetime] = None,
        end_date: typing.Optional[dt.datetime] = None,
        updated_start_date: typing.Optional[dt.datetime] = None,
        updated_end_date: typing.Optional[dt.datetime] = None,
        status: typing.Optional[typing.Union[OrderLowLevelStatus, typing.Sequence[OrderLowLevelStatus]]] = None,
        order_key: typing.Optional[LabTestsGetOrdersRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetOrdersRequestOrderDirection] = None,
        order_type: typing.Optional[
            typing.Union[LabTestCollectionMethod, typing.Sequence[LabTestCollectionMethod]]
        ] = None,
        is_critical: typing.Optional[bool] = None,
        interpretation: typing.Optional[Interpretation] = None,
        order_activation_types: typing.Optional[
            typing.Union[OrderActivationType, typing.Sequence[OrderActivationType]]
        ] = None,
        user_id: typing.Optional[str] = None,
        patient_name: typing.Optional[str] = None,
        shipping_recipient_name: typing.Optional[str] = None,
        order_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetOrdersResponse:
        """
        GET many orders with filters.

        Parameters
        ----------
        search_input : typing.Optional[str]
            Search by order id, user id, patient name, shipping dob, or shipping recipient name.

        start_date : typing.Optional[dt.datetime]
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        end_date : typing.Optional[dt.datetime]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        updated_start_date : typing.Optional[dt.datetime]
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        updated_end_date : typing.Optional[dt.datetime]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        status : typing.Optional[typing.Union[OrderLowLevelStatus, typing.Sequence[OrderLowLevelStatus]]]
            Filter by low level status.

        order_key : typing.Optional[LabTestsGetOrdersRequestOrderKey]
            Order key to sort by.

        order_direction : typing.Optional[LabTestsGetOrdersRequestOrderDirection]
            Order direction to sort by.

        order_type : typing.Optional[typing.Union[LabTestCollectionMethod, typing.Sequence[LabTestCollectionMethod]]]
            Filter by method used to perform the lab test.

        is_critical : typing.Optional[bool]
            Filter by critical order status.

        interpretation : typing.Optional[Interpretation]
            Filter by result interpretation of the lab test.

        order_activation_types : typing.Optional[typing.Union[OrderActivationType, typing.Sequence[OrderActivationType]]]
            Filter by activation type.

        user_id : typing.Optional[str]
            Filter by user ID.

        patient_name : typing.Optional[str]
            Filter by patient name.

        shipping_recipient_name : typing.Optional[str]
            Filter by shipping recipient name.

        order_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter by order ids.

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrdersResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.lab_tests.get_orders()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_orders(
            search_input=search_input,
            start_date=start_date,
            end_date=end_date,
            updated_start_date=updated_start_date,
            updated_end_date=updated_end_date,
            status=status,
            order_key=order_key,
            order_direction=order_direction,
            order_type=order_type,
            is_critical=is_critical,
            interpretation=interpretation,
            order_activation_types=order_activation_types,
            user_id=user_id,
            patient_name=patient_name,
            shipping_recipient_name=shipping_recipient_name,
            order_ids=order_ids,
            page=page,
            size=size,
            request_options=request_options,
        )
        return _response.data
