# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .appointment_event_status import AppointmentEventStatus
from .appointment_provider import AppointmentProvider
from .appointment_status import AppointmentStatus
from .appointment_type import AppointmentType
from .client_facing_appointment_event import ClientFacingAppointmentEvent
from .lng_lat import LngLat
from .us_address import UsAddress


class ClientFacingAppointment(UniversalBaseModel):
    id: str
    user_id: str
    order_id: str
    address: UsAddress
    location: LngLat
    start_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Time is in UTC
    """

    end_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Time is in UTC
    """

    iana_timezone: typing.Optional[str] = None
    type: AppointmentType
    provider: AppointmentProvider
    status: AppointmentStatus
    provider_id: str
    external_id: typing.Optional[str] = None
    can_reschedule: bool
    event_status: AppointmentEventStatus
    event_data: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    events: typing.List[ClientFacingAppointmentEvent]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
