# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class SourceType(str, enum.Enum):
    """
    ℹ️ This enum is non-exhaustive.
    """

    APP = "app"
    BLE = "ble"
    DEVICE = "device"
    LAB = "lab"
    PROVIDER = "provider"
    _UNKNOWN = "__SOURCETYPE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "SourceType":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        app: typing.Callable[[], T_Result],
        ble: typing.Callable[[], T_Result],
        device: typing.Callable[[], T_Result],
        lab: typing.Callable[[], T_Result],
        provider: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is SourceType.APP:
            return app()
        if self is SourceType.BLE:
            return ble()
        if self is SourceType.DEVICE:
            return device()
        if self is SourceType.LAB:
            return lab()
        if self is SourceType.PROVIDER:
            return provider()
        return _unknown_member(self._value_)
