import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecsPatterns from '@aws-cdk/aws-ecs-patterns';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface ExpressServiceProps {
    /**
     * The VPC.
     *
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * options to customize the servide.
     *
     * @stability stable
     * @defult - None
     */
    readonly serviceOptions?: ecsPatterns.ApplicationLoadBalancedFargateServiceProps;
    /**
     * local path to the docker assets directory.
     *
     * @stability stable
     */
    readonly expressAssets: string;
}
/**
 * @stability stable
 */
export declare class ExpressService extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly expressAssets: string;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: ExpressServiceProps);
}
