# coding: utf-8

"""
AskUI Workspaces API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.1.30
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing_extensions import Annotated, Self

from askui.tools.askui.askui_workspaces.models.runner_host import RunnerHost


class CreateScheduleRequestDto(BaseModel):
    """
    CreateScheduleRequestDto
    """  # noqa: E501

    name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=63)]] = (
        "Unnamed"
    )
    host: Optional[RunnerHost] = None
    runner_ids: Optional[List[StrictStr]] = None
    tags: Optional[List[StrictStr]] = None
    started_at: Optional[datetime] = Field(
        default=None,
        description="Timestamp after which the schedule starts. If not specified, the schedule starts immediately.",
    )
    ended_at: Optional[datetime] = None
    ended_after: Optional[StrictInt] = None
    schedule: Optional[StrictStr] = None
    workflows: Optional[List[StrictStr]] = None
    data: Optional[Dict[str, Any]] = Field(
        default=None,
        description="Arbitrary data to be stored with the schedule which is made available to the runner when executing AskUI workflows.",
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "name",
        "host",
        "runner_ids",
        "tags",
        "started_at",
        "ended_at",
        "ended_after",
        "schedule",
        "workflows",
        "data",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateScheduleRequestDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if ended_at (nullable) is None
        # and model_fields_set contains the field
        if self.ended_at is None and "ended_at" in self.model_fields_set:
            _dict["ended_at"] = None

        # set to None if ended_after (nullable) is None
        # and model_fields_set contains the field
        if self.ended_after is None and "ended_after" in self.model_fields_set:
            _dict["ended_after"] = None

        # set to None if schedule (nullable) is None
        # and model_fields_set contains the field
        if self.schedule is None and "schedule" in self.model_fields_set:
            _dict["schedule"] = None

        # set to None if workflows (nullable) is None
        # and model_fields_set contains the field
        if self.workflows is None and "workflows" in self.model_fields_set:
            _dict["workflows"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateScheduleRequestDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name") if obj.get("name") is not None else "Unnamed",
                "host": obj.get("host"),
                "runner_ids": obj.get("runner_ids"),
                "tags": obj.get("tags"),
                "started_at": obj.get("started_at"),
                "ended_at": obj.get("ended_at"),
                "ended_after": obj.get("ended_after"),
                "schedule": obj.get("schedule"),
                "workflows": obj.get("workflows"),
                "data": obj.get("data"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
