# coding: utf-8

"""
AskUI Workspaces API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.1.30
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, Dict, Optional, Set, Union

from pydantic import (
    BaseModel,
    ConfigDict,
    ValidationError,
    field_validator,
)
from typing_extensions import Self

from askui.tools.askui.askui_workspaces.models.agent_execution_state_canceled import (
    AgentExecutionStateCanceled,
)
from askui.tools.askui.askui_workspaces.models.agent_execution_state_confirmed import (
    AgentExecutionStateConfirmed,
)
from askui.tools.askui.askui_workspaces.models.agent_execution_state_delivered_to_destination_output import (
    AgentExecutionStateDeliveredToDestinationOutput,
)
from askui.tools.askui.askui_workspaces.models.agent_execution_state_pending_data_extraction import (
    AgentExecutionStatePendingDataExtraction,
)
from askui.tools.askui.askui_workspaces.models.agent_execution_state_pending_inputs import (
    AgentExecutionStatePendingInputs,
)
from askui.tools.askui.askui_workspaces.models.agent_execution_state_pending_review import (
    AgentExecutionStatePendingReview,
)

STATE_ONE_OF_SCHEMAS = [
    "AgentExecutionStateCanceled",
    "AgentExecutionStateConfirmed",
    "AgentExecutionStateDeliveredToDestinationOutput",
    "AgentExecutionStatePendingDataExtraction",
    "AgentExecutionStatePendingInputs",
    "AgentExecutionStatePendingReview",
]


class State(BaseModel):
    """
    State
    """

    # data type: AgentExecutionStatePendingInputs
    oneof_schema_1_validator: Optional[AgentExecutionStatePendingInputs] = None
    # data type: AgentExecutionStatePendingDataExtraction
    oneof_schema_2_validator: Optional[AgentExecutionStatePendingDataExtraction] = None
    # data type: AgentExecutionStatePendingReview
    oneof_schema_3_validator: Optional[AgentExecutionStatePendingReview] = None
    # data type: AgentExecutionStateCanceled
    oneof_schema_4_validator: Optional[AgentExecutionStateCanceled] = None
    # data type: AgentExecutionStateConfirmed
    oneof_schema_5_validator: Optional[AgentExecutionStateConfirmed] = None
    # data type: AgentExecutionStateDeliveredToDestinationOutput
    oneof_schema_6_validator: Optional[
        AgentExecutionStateDeliveredToDestinationOutput
    ] = None
    actual_instance: Optional[
        Union[
            AgentExecutionStateCanceled,
            AgentExecutionStateConfirmed,
            AgentExecutionStateDeliveredToDestinationOutput,
            AgentExecutionStatePendingDataExtraction,
            AgentExecutionStatePendingInputs,
            AgentExecutionStatePendingReview,
        ]
    ] = None
    one_of_schemas: Set[str] = {
        "AgentExecutionStateCanceled",
        "AgentExecutionStateConfirmed",
        "AgentExecutionStateDeliveredToDestinationOutput",
        "AgentExecutionStatePendingDataExtraction",
        "AgentExecutionStatePendingInputs",
        "AgentExecutionStatePendingReview",
    }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )

    discriminator_value_class_map: Dict[str, str] = {}

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator("actual_instance")
    def actual_instance_must_validate_oneof(cls, v):
        instance = State.model_construct()
        error_messages = []
        match = 0
        # validate data type: AgentExecutionStatePendingInputs
        if not isinstance(v, AgentExecutionStatePendingInputs):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `AgentExecutionStatePendingInputs`"
            )
        else:
            match += 1
        # validate data type: AgentExecutionStatePendingDataExtraction
        if not isinstance(v, AgentExecutionStatePendingDataExtraction):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `AgentExecutionStatePendingDataExtraction`"
            )
        else:
            match += 1
        # validate data type: AgentExecutionStatePendingReview
        if not isinstance(v, AgentExecutionStatePendingReview):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `AgentExecutionStatePendingReview`"
            )
        else:
            match += 1
        # validate data type: AgentExecutionStateCanceled
        if not isinstance(v, AgentExecutionStateCanceled):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `AgentExecutionStateCanceled`"
            )
        else:
            match += 1
        # validate data type: AgentExecutionStateConfirmed
        if not isinstance(v, AgentExecutionStateConfirmed):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `AgentExecutionStateConfirmed`"
            )
        else:
            match += 1
        # validate data type: AgentExecutionStateDeliveredToDestinationOutput
        if not isinstance(v, AgentExecutionStateDeliveredToDestinationOutput):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `AgentExecutionStateDeliveredToDestinationOutput`"
            )
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when setting `actual_instance` in State with oneOf schemas: AgentExecutionStateCanceled, AgentExecutionStateConfirmed, AgentExecutionStateDeliveredToDestinationOutput, AgentExecutionStatePendingDataExtraction, AgentExecutionStatePendingInputs, AgentExecutionStatePendingReview. Details: "
                + ", ".join(error_messages)
            )
        if match == 0:
            # no match
            raise ValueError(
                "No match found when setting `actual_instance` in State with oneOf schemas: AgentExecutionStateCanceled, AgentExecutionStateConfirmed, AgentExecutionStateDeliveredToDestinationOutput, AgentExecutionStatePendingDataExtraction, AgentExecutionStatePendingInputs, AgentExecutionStatePendingReview. Details: "
                + ", ".join(error_messages)
            )
        return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("status")
        if not _data_type:
            raise ValueError(
                "Failed to lookup data type from the field `status` in the input."
            )

        # check if data type is `AgentExecutionStateCanceled`
        if _data_type == "CANCELED":
            instance.actual_instance = AgentExecutionStateCanceled.from_json(json_str)
            return instance

        # check if data type is `AgentExecutionStateConfirmed`
        if _data_type == "CONFIRMED":
            instance.actual_instance = AgentExecutionStateConfirmed.from_json(json_str)
            return instance

        # check if data type is `AgentExecutionStateDeliveredToDestinationOutput`
        if _data_type == "DELIVERED_TO_DESTINATION":
            instance.actual_instance = (
                AgentExecutionStateDeliveredToDestinationOutput.from_json(json_str)
            )
            return instance

        # check if data type is `AgentExecutionStatePendingDataExtraction`
        if _data_type == "PENDING_DATA_EXTRACTION":
            instance.actual_instance = (
                AgentExecutionStatePendingDataExtraction.from_json(json_str)
            )
            return instance

        # check if data type is `AgentExecutionStatePendingInputs`
        if _data_type == "PENDING_INPUTS":
            instance.actual_instance = AgentExecutionStatePendingInputs.from_json(
                json_str
            )
            return instance

        # check if data type is `AgentExecutionStatePendingReview`
        if _data_type == "PENDING_REVIEW":
            instance.actual_instance = AgentExecutionStatePendingReview.from_json(
                json_str
            )
            return instance

        # check if data type is `AgentExecutionStateCanceled`
        if _data_type == "AgentExecutionStateCanceled":
            instance.actual_instance = AgentExecutionStateCanceled.from_json(json_str)
            return instance

        # check if data type is `AgentExecutionStateConfirmed`
        if _data_type == "AgentExecutionStateConfirmed":
            instance.actual_instance = AgentExecutionStateConfirmed.from_json(json_str)
            return instance

        # check if data type is `AgentExecutionStateDeliveredToDestinationOutput`
        if _data_type == "AgentExecutionStateDeliveredToDestination-Output":
            instance.actual_instance = (
                AgentExecutionStateDeliveredToDestinationOutput.from_json(json_str)
            )
            return instance

        # check if data type is `AgentExecutionStatePendingDataExtraction`
        if _data_type == "AgentExecutionStatePendingDataExtraction":
            instance.actual_instance = (
                AgentExecutionStatePendingDataExtraction.from_json(json_str)
            )
            return instance

        # check if data type is `AgentExecutionStatePendingInputs`
        if _data_type == "AgentExecutionStatePendingInputs":
            instance.actual_instance = AgentExecutionStatePendingInputs.from_json(
                json_str
            )
            return instance

        # check if data type is `AgentExecutionStatePendingReview`
        if _data_type == "AgentExecutionStatePendingReview":
            instance.actual_instance = AgentExecutionStatePendingReview.from_json(
                json_str
            )
            return instance

        # deserialize data into AgentExecutionStatePendingInputs
        try:
            instance.actual_instance = AgentExecutionStatePendingInputs.from_json(
                json_str
            )
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AgentExecutionStatePendingDataExtraction
        try:
            instance.actual_instance = (
                AgentExecutionStatePendingDataExtraction.from_json(json_str)
            )
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AgentExecutionStatePendingReview
        try:
            instance.actual_instance = AgentExecutionStatePendingReview.from_json(
                json_str
            )
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AgentExecutionStateCanceled
        try:
            instance.actual_instance = AgentExecutionStateCanceled.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AgentExecutionStateConfirmed
        try:
            instance.actual_instance = AgentExecutionStateConfirmed.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AgentExecutionStateDeliveredToDestinationOutput
        try:
            instance.actual_instance = (
                AgentExecutionStateDeliveredToDestinationOutput.from_json(json_str)
            )
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into State with oneOf schemas: AgentExecutionStateCanceled, AgentExecutionStateConfirmed, AgentExecutionStateDeliveredToDestinationOutput, AgentExecutionStatePendingDataExtraction, AgentExecutionStatePendingInputs, AgentExecutionStatePendingReview. Details: "
                + ", ".join(error_messages)
            )
        if match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into State with oneOf schemas: AgentExecutionStateCanceled, AgentExecutionStateConfirmed, AgentExecutionStateDeliveredToDestinationOutput, AgentExecutionStatePendingDataExtraction, AgentExecutionStatePendingInputs, AgentExecutionStatePendingReview. Details: "
                + ", ".join(error_messages)
            )
        return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(
            self.actual_instance.to_json
        ):
            return self.actual_instance.to_json()
        return json.dumps(self.actual_instance)

    def to_dict(
        self,
    ) -> Optional[
        Union[
            Dict[str, Any],
            AgentExecutionStateCanceled,
            AgentExecutionStateConfirmed,
            AgentExecutionStateDeliveredToDestinationOutput,
            AgentExecutionStatePendingDataExtraction,
            AgentExecutionStatePendingInputs,
            AgentExecutionStatePendingReview,
        ]
    ]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(
            self.actual_instance.to_dict
        ):
            return self.actual_instance.to_dict()
        # primitive type
        return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())
