# Roadmap

The development of `torrra` is an ongoing process, with a focus on enhancing its capabilities, improving user experience, and expanding its feature set. This roadmap outlines the key areas of development, including features that have been completed and those that are planned for future releases.

## Completed Features

The following features have been successfully implemented and are available in the current version of `torrra`:

- [x] **Jackett Integration:** Full support for connecting to and searching via Jackett instances.
- [x] **Prowlarr Support:** Integration with Prowlarr for managing and searching torrent indexers.
- [x] **Torrent Download UI with Pause/Resume:** A responsive Text-User Interface (TUI) for managing active torrent downloads, including the ability to pause and resume transfers.
- [x] **Config File Support:** Implementation of a `config.toml` file for persistent user preferences and settings.
- [x] **Standalone Binary & AUR Packaging:** Availability of pre-built executables for various operating systems and packaging for Arch Linux via AUR.
- [x] **Magnet Info Preview (Seeders/Leechers before download):** Ability to display crucial torrent metadata (like seeders and leechers) before initiating a download.

## Planned Features

Our future development efforts will focus on introducing the following enhancements and new functionalities:

- [ ] **Advanced Filtering/Sorting:** Implementing more robust options for filtering and sorting search results within the TUI (e.g., by size, seeders, date, category).
- [ ] **Keyboard Shortcuts Overlay / Help Screen:** Introducing an in-app overlay or dedicated screen to display available keyboard shortcuts and general help for the TUI.
- [ ] **Support for Custom Indexers:** Allowing users to define and integrate their own custom torrent indexers beyond Jackett and Prowlarr.

We welcome community feedback and contributions to help shape the future of `torrra`. If you have suggestions or would like to contribute, please refer to the [Contributing Guide](contributing).
