```{include} ../../README.md
```

```{toctree}
:caption: Tutorials

tutorials/installation
tutorials/navigation
tutorials/slicing
tutorials/export
tutorials/login
tutorials/serving-files
tutorials/search
tutorials/writing
tutorials/streaming
tutorials/simple-server
tutorials/plotly-integration
tutorials/zarr-integration
```

```{toctree}
:caption: How To Guides

how-to/authentication
how-to/profiles
how-to/client-logger
how-to/docker
how-to/helm
how-to/configuration
how-to/read-custom-formats
how-to/custom-export-formats
how-to/api-keys
how-to/custom-clients
how-to/metrics
how-to/direct-client
how-to/tiled-authn-database
how-to/register
how-to/retries
```

```{toctree}
:caption: Explanations

explanations/architecture
explanations/standards
explanations/structures
explanations/metadata
explanations/security
explanations/compression
explanations/specialized-formats
explanations/caching
explanations/access-control
explanations/catalog
explanations/faq
explanations/roadmap
explanations/lineage
explanations/storage-database
```

```{toctree}
:caption: Reference

reference/service
reference/http-api-overview
reference/python-client
reference/queries
reference/authentication
reference/scopes
reference/commandline
reference/service-configuration
reference/client-profiles
reference/release-history
reference/min-versions
```
