from setuptools import setup, find_packages

with open('requirements.txt') as f:
    required = f.read().splitlines()

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="simpleterraform",
    version="1.0.3", 
    author="Sourav Kumar Singh",
    author_email="1109souravkumar@example.com",
    description="Automated Infrastructure as Code Generator",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yourusername/simpleterraform",
    
    # NOW WE POINT TO THE NEW FOLDER
    packages=find_packages(), # This automatically finds 'simpleterraform'
    
    include_package_data=True,
    install_requires=required,
    
    entry_points={
        "console_scripts": [
            # Syntax: command = package.module:function
            "simpleterraform=simpleterraform.main:run", 
        ],
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.7',
)