import os
from pathlib import Path

# Define the path to the broken template
root_template_path = Path("templates/root/main.tf.j2")

# The Corrected, Verified Template Content
CORRECT_TEMPLATE = """terraform {
  required_providers {
    aws = {
      source  = "hashicorp/aws"
      version = "~> 5.0"
    }
  }
}

provider "aws" {
  region = "us-east-1"
}

# ------------------------------------------------------------------------------
# MODULES
# ------------------------------------------------------------------------------

{% for module in modules %}
module "{{ module.module_id }}" {
  source = "../terraform_modules/{{ module.project_name }}-{{ module.module_type }}"

  # --- GLOBAL VARIABLES ---
  project_name = "{{ module.project_name }}"

  # ----------------------------------------
  # MODULE SPECIFIC CONFIGURATION
  # ----------------------------------------

  {% if module.module_type == 'networking' %}
  vpc_cidr             = "{{ module.config.vpc_cidr }}"
  availability_zones   = {{ module.config.availability_zones | tojson }}
  public_subnets_cidr  = {{ module.config.public_subnets_cidr | tojson }}
  private_subnets_cidr = {{ module.config.private_subnets_cidr | tojson }}
  enable_nat_gateway   = {{ module.config.enable_nat_gateway | lower }}
  tags                 = { Project = "{{ module.project_name }}" }

  {% elif module.module_type == 'security' %}
  vpc_id = module.{{ module.config.linked_vpc_module }}.vpc_id

  {% elif module.module_type == 'compute' %}
  ami_id            = "{{ module.config.ami_id }}"
  instance_type     = "{{ module.config.instance_type }}"
  security_group_id = module.{{ module.config.linked_security_module }}.security_group_id
  subnet_id         = module.{{ module.config.linked_networking_module }}.public_subnets[0]

  {% endif %}
}
{% endfor %}
"""

# Write the fix
if root_template_path.parent.exists():
    with open(root_template_path, "w") as f:
        f.write(CORRECT_TEMPLATE)
    print(f"✅ Successfully fixed: {root_template_path}")
    print("🚀 You can now run 'python main.py' again.")
else:
    print(f"❌ Error: Directory {root_template_path.parent} does not exist. Run setup first.")