import os
import sys
from pathlib import Path

# The Architecture Definition
PROJECT_STRUCTURE = {
    "directories": [
        "metadata",                 # JSON State
        "templates/root",           # Root main.tf templates
        "templates/modules/networking", # Networking templates
        "templates/modules/security",   # Security templates (placeholder)
        "terraform_modules",        # Generated output
        "root",                     # Generated root output
        "src",                      # Python Source Code
    ],
    "files": {
        "requirements.txt": "rich\nquestionary\njinja2\n",
        "README.md": "# Terraform CLI Generator\n\nAutomated IaC Tool.",
        ".gitignore": "__pycache__/\n*.pyc\n.env\n.DS_Store\n/terraform_modules/*\n/root/*.tf\n",
        "./__init__.py": "",
        "./inputs.py":"",
        "./ui.py": "# UI Logic using Rich and Questionary\n",
        "./generator.py": "# Logic to render Jinja2 templates\n",
        "./state_manager.py": "# Logic to handle JSON metadata\n",
        "main.py": ""
    }
}

def create_structure():
    print(f"🔨 Initializing Project Structure...")
    
    # 1. Create Directories
    for folder in PROJECT_STRUCTURE["directories"]:
        path = Path(folder)
        if not path.exists():
            path.mkdir(parents=True, exist_ok=True)
            print(f"  ✔ Created directory: {folder}/")
        else:
            print(f"  ℹ Directory exists: {folder}/")

    # 2. Create Files
    for filename, content in PROJECT_STRUCTURE["files"].items():
        path = Path(filename)
        if not path.exists():
            with open(path, "w", encoding="utf-8") as f:
                f.write(content)
            print(f"  ✔ Created file: {filename}")
        else:
            print(f"  ℹ File exists: {filename}")
            
    print("\n✨ Setup Complete! Next steps:")
    print("  1. pip install -r requirements.txt")
    print("  2. python main.py")

if __name__ == "__main__":
    create_structure()