# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalLocationArgs', 'ExternalLocation']

@pulumi.input_type
class ExternalLocationArgs:
    def __init__(__self__, *,
                 credential_name: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_file_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_details: Optional[pulumi.Input['ExternalLocationEncryptionDetailsArgs']] = None,
                 fallback: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_event_queue: Optional[pulumi.Input['ExternalLocationFileEventQueueArgs']] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_validation: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ExternalLocation resource.
        :param pulumi.Input[_builtins.str] credential_name: Name of the StorageCredential to use with this external location.
        :param pulumi.Input[_builtins.str] url: Path URL in cloud storage, of the form: `s3://[bucket-host]/[bucket-dir]` (AWS), `abfss://[user]@[host]/[path]` (Azure), `gs://[bucket-host]/[bucket-dir]` (GCP).
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[_builtins.bool] enable_file_events: indicates if managed file events are enabled for this external location.  Requires `file_event_queue` block.
        :param pulumi.Input[_builtins.bool] fallback: Indicates whether fallback mode is enabled for this external location. When fallback mode is enabled (disabled by default), the access to the location falls back to cluster credentials if UC credentials are not sufficient.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroy external location regardless of its dependents.
        :param pulumi.Input[_builtins.bool] force_update: Update external location regardless of its dependents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the external location is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the external location to `ISOLATION_MODE_ISOLATED` will automatically allow access from the current workspace.
        :param pulumi.Input[_builtins.str] name: Name of External Location, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the external location owner.
        :param pulumi.Input[_builtins.bool] read_only: Indicates whether the external location is read-only.
        :param pulumi.Input[_builtins.bool] skip_validation: Suppress validation errors if any & force save the external location
        """
        pulumi.set(__self__, "credential_name", credential_name)
        pulumi.set(__self__, "url", url)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if enable_file_events is not None:
            pulumi.set(__self__, "enable_file_events", enable_file_events)
        if encryption_details is not None:
            pulumi.set(__self__, "encryption_details", encryption_details)
        if fallback is not None:
            pulumi.set(__self__, "fallback", fallback)
        if file_event_queue is not None:
            pulumi.set(__self__, "file_event_queue", file_event_queue)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if isolation_mode is not None:
            pulumi.set(__self__, "isolation_mode", isolation_mode)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if skip_validation is not None:
            pulumi.set(__self__, "skip_validation", skip_validation)

    @_builtins.property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the StorageCredential to use with this external location.
        """
        return pulumi.get(self, "credential_name")

    @credential_name.setter
    def credential_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "credential_name", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        Path URL in cloud storage, of the form: `s3://[bucket-host]/[bucket-dir]` (AWS), `abfss://[user]@[host]/[path]` (Azure), `gs://[bucket-host]/[bucket-dir]` (GCP).
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-supplied free-form text.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="enableFileEvents")
    def enable_file_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        indicates if managed file events are enabled for this external location.  Requires `file_event_queue` block.
        """
        return pulumi.get(self, "enable_file_events")

    @enable_file_events.setter
    def enable_file_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_file_events", value)

    @_builtins.property
    @pulumi.getter(name="encryptionDetails")
    def encryption_details(self) -> Optional[pulumi.Input['ExternalLocationEncryptionDetailsArgs']]:
        return pulumi.get(self, "encryption_details")

    @encryption_details.setter
    def encryption_details(self, value: Optional[pulumi.Input['ExternalLocationEncryptionDetailsArgs']]):
        pulumi.set(self, "encryption_details", value)

    @_builtins.property
    @pulumi.getter
    def fallback(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether fallback mode is enabled for this external location. When fallback mode is enabled (disabled by default), the access to the location falls back to cluster credentials if UC credentials are not sufficient.
        """
        return pulumi.get(self, "fallback")

    @fallback.setter
    def fallback(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fallback", value)

    @_builtins.property
    @pulumi.getter(name="fileEventQueue")
    def file_event_queue(self) -> Optional[pulumi.Input['ExternalLocationFileEventQueueArgs']]:
        return pulumi.get(self, "file_event_queue")

    @file_event_queue.setter
    def file_event_queue(self, value: Optional[pulumi.Input['ExternalLocationFileEventQueueArgs']]):
        pulumi.set(self, "file_event_queue", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Destroy external location regardless of its dependents.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Update external location regardless of its dependents.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update", value)

    @_builtins.property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the external location is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the external location to `ISOLATION_MODE_ISOLATED` will automatically allow access from the current workspace.
        """
        return pulumi.get(self, "isolation_mode")

    @isolation_mode.setter
    def isolation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isolation_mode", value)

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of External Location, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username/groupname/sp application_id of the external location owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the external location is read-only.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @_builtins.property
    @pulumi.getter(name="skipValidation")
    def skip_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Suppress validation errors if any & force save the external location
        """
        return pulumi.get(self, "skip_validation")

    @skip_validation.setter
    def skip_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_validation", value)


@pulumi.input_type
class _ExternalLocationState:
    def __init__(__self__, *,
                 browse_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_file_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_details: Optional[pulumi.Input['ExternalLocationEncryptionDetailsArgs']] = None,
                 fallback: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_event_queue: Optional[pulumi.Input['ExternalLocationFileEventQueueArgs']] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExternalLocation resources.
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[_builtins.int] created_at: Time at which this external location was created, in epoch milliseconds.
        :param pulumi.Input[_builtins.str] created_by: Username of external location creator.
        :param pulumi.Input[_builtins.str] credential_id: Unique ID of the location's storage credential.
        :param pulumi.Input[_builtins.str] credential_name: Name of the StorageCredential to use with this external location.
        :param pulumi.Input[_builtins.bool] enable_file_events: indicates if managed file events are enabled for this external location.  Requires `file_event_queue` block.
        :param pulumi.Input[_builtins.bool] fallback: Indicates whether fallback mode is enabled for this external location. When fallback mode is enabled (disabled by default), the access to the location falls back to cluster credentials if UC credentials are not sufficient.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroy external location regardless of its dependents.
        :param pulumi.Input[_builtins.bool] force_update: Update external location regardless of its dependents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the external location is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the external location to `ISOLATION_MODE_ISOLATED` will automatically allow access from the current workspace.
        :param pulumi.Input[_builtins.str] name: Name of External Location, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the external location owner.
        :param pulumi.Input[_builtins.bool] read_only: Indicates whether the external location is read-only.
        :param pulumi.Input[_builtins.bool] skip_validation: Suppress validation errors if any & force save the external location
        :param pulumi.Input[_builtins.int] updated_at: Time at which external location this was last modified, in epoch milliseconds.
        :param pulumi.Input[_builtins.str] updated_by: Username of user who last modified the external location.
        :param pulumi.Input[_builtins.str] url: Path URL in cloud storage, of the form: `s3://[bucket-host]/[bucket-dir]` (AWS), `abfss://[user]@[host]/[path]` (Azure), `gs://[bucket-host]/[bucket-dir]` (GCP).
        """
        if browse_only is not None:
            pulumi.set(__self__, "browse_only", browse_only)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if credential_name is not None:
            pulumi.set(__self__, "credential_name", credential_name)
        if enable_file_events is not None:
            pulumi.set(__self__, "enable_file_events", enable_file_events)
        if encryption_details is not None:
            pulumi.set(__self__, "encryption_details", encryption_details)
        if fallback is not None:
            pulumi.set(__self__, "fallback", fallback)
        if file_event_queue is not None:
            pulumi.set(__self__, "file_event_queue", file_event_queue)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if isolation_mode is not None:
            pulumi.set(__self__, "isolation_mode", isolation_mode)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if skip_validation is not None:
            pulumi.set(__self__, "skip_validation", skip_validation)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="browseOnly")
    def browse_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "browse_only")

    @browse_only.setter
    def browse_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "browse_only", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-supplied free-form text.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time at which this external location was created, in epoch milliseconds.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username of external location creator.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique ID of the location's storage credential.
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_id", value)

    @_builtins.property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the StorageCredential to use with this external location.
        """
        return pulumi.get(self, "credential_name")

    @credential_name.setter
    def credential_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_name", value)

    @_builtins.property
    @pulumi.getter(name="enableFileEvents")
    def enable_file_events(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        indicates if managed file events are enabled for this external location.  Requires `file_event_queue` block.
        """
        return pulumi.get(self, "enable_file_events")

    @enable_file_events.setter
    def enable_file_events(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_file_events", value)

    @_builtins.property
    @pulumi.getter(name="encryptionDetails")
    def encryption_details(self) -> Optional[pulumi.Input['ExternalLocationEncryptionDetailsArgs']]:
        return pulumi.get(self, "encryption_details")

    @encryption_details.setter
    def encryption_details(self, value: Optional[pulumi.Input['ExternalLocationEncryptionDetailsArgs']]):
        pulumi.set(self, "encryption_details", value)

    @_builtins.property
    @pulumi.getter
    def fallback(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether fallback mode is enabled for this external location. When fallback mode is enabled (disabled by default), the access to the location falls back to cluster credentials if UC credentials are not sufficient.
        """
        return pulumi.get(self, "fallback")

    @fallback.setter
    def fallback(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fallback", value)

    @_builtins.property
    @pulumi.getter(name="fileEventQueue")
    def file_event_queue(self) -> Optional[pulumi.Input['ExternalLocationFileEventQueueArgs']]:
        return pulumi.get(self, "file_event_queue")

    @file_event_queue.setter
    def file_event_queue(self, value: Optional[pulumi.Input['ExternalLocationFileEventQueueArgs']]):
        pulumi.set(self, "file_event_queue", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Destroy external location regardless of its dependents.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Update external location regardless of its dependents.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update", value)

    @_builtins.property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the external location is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the external location to `ISOLATION_MODE_ISOLATED` will automatically allow access from the current workspace.
        """
        return pulumi.get(self, "isolation_mode")

    @isolation_mode.setter
    def isolation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isolation_mode", value)

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of External Location, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username/groupname/sp application_id of the external location owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the external location is read-only.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @_builtins.property
    @pulumi.getter(name="skipValidation")
    def skip_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Suppress validation errors if any & force save the external location
        """
        return pulumi.get(self, "skip_validation")

    @skip_validation.setter
    def skip_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_validation", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time at which external location this was last modified, in epoch milliseconds.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username of user who last modified the external location.
        """
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_by", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path URL in cloud storage, of the form: `s3://[bucket-host]/[bucket-dir]` (AWS), `abfss://[user]@[host]/[path]` (Azure), `gs://[bucket-host]/[bucket-dir]` (GCP).
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("databricks:index/externalLocation:ExternalLocation")
class ExternalLocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_file_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_details: Optional[pulumi.Input[Union['ExternalLocationEncryptionDetailsArgs', 'ExternalLocationEncryptionDetailsArgsDict']]] = None,
                 fallback: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_event_queue: Optional[pulumi.Input[Union['ExternalLocationFileEventQueueArgs', 'ExternalLocationFileEventQueueArgsDict']]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        To work with external tables, Unity Catalog introduces two new objects to access and work with external cloud storage:

        - StorageCredential represent authentication methods to access cloud storage (e.g. an IAM role for Amazon S3 or a service principal for Azure Storage). Storage credentials are access-controlled to determine which users can use the credential.
        - `ExternalLocation` are objects that combine a cloud storage path with a Storage Credential that can be used to access the location.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        For AWS

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external = databricks.StorageCredential("external",
            name=external_data_access["name"],
            aws_iam_role={
                "role_arn": external_data_access["arn"],
            },
            comment="Managed by TF")
        some = databricks.ExternalLocation("some",
            name="external",
            url=f"s3://{external_aws_s3_bucket['id']}/some",
            credential_name=external.id,
            comment="Managed by TF")
        some_grants = databricks.Grants("some",
            external_location=some.id,
            grants=[{
                "principal": "Data Engineers",
                "privileges": [
                    "CREATE_EXTERNAL_TABLE",
                    "READ_FILES",
                ],
            }])
        ```

        For Azure

        ## Import

        This resource can be imported by `name`:

        hcl

        import {

          to = databricks_external_location.this

          id = "<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/externalLocation:ExternalLocation this <name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[_builtins.str] credential_name: Name of the StorageCredential to use with this external location.
        :param pulumi.Input[_builtins.bool] enable_file_events: indicates if managed file events are enabled for this external location.  Requires `file_event_queue` block.
        :param pulumi.Input[_builtins.bool] fallback: Indicates whether fallback mode is enabled for this external location. When fallback mode is enabled (disabled by default), the access to the location falls back to cluster credentials if UC credentials are not sufficient.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroy external location regardless of its dependents.
        :param pulumi.Input[_builtins.bool] force_update: Update external location regardless of its dependents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the external location is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the external location to `ISOLATION_MODE_ISOLATED` will automatically allow access from the current workspace.
        :param pulumi.Input[_builtins.str] name: Name of External Location, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the external location owner.
        :param pulumi.Input[_builtins.bool] read_only: Indicates whether the external location is read-only.
        :param pulumi.Input[_builtins.bool] skip_validation: Suppress validation errors if any & force save the external location
        :param pulumi.Input[_builtins.str] url: Path URL in cloud storage, of the form: `s3://[bucket-host]/[bucket-dir]` (AWS), `abfss://[user]@[host]/[path]` (Azure), `gs://[bucket-host]/[bucket-dir]` (GCP).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalLocationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        To work with external tables, Unity Catalog introduces two new objects to access and work with external cloud storage:

        - StorageCredential represent authentication methods to access cloud storage (e.g. an IAM role for Amazon S3 or a service principal for Azure Storage). Storage credentials are access-controlled to determine which users can use the credential.
        - `ExternalLocation` are objects that combine a cloud storage path with a Storage Credential that can be used to access the location.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        For AWS

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external = databricks.StorageCredential("external",
            name=external_data_access["name"],
            aws_iam_role={
                "role_arn": external_data_access["arn"],
            },
            comment="Managed by TF")
        some = databricks.ExternalLocation("some",
            name="external",
            url=f"s3://{external_aws_s3_bucket['id']}/some",
            credential_name=external.id,
            comment="Managed by TF")
        some_grants = databricks.Grants("some",
            external_location=some.id,
            grants=[{
                "principal": "Data Engineers",
                "privileges": [
                    "CREATE_EXTERNAL_TABLE",
                    "READ_FILES",
                ],
            }])
        ```

        For Azure

        ## Import

        This resource can be imported by `name`:

        hcl

        import {

          to = databricks_external_location.this

          id = "<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/externalLocation:ExternalLocation this <name>
        ```

        :param str resource_name: The name of the resource.
        :param ExternalLocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalLocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_file_events: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_details: Optional[pulumi.Input[Union['ExternalLocationEncryptionDetailsArgs', 'ExternalLocationEncryptionDetailsArgsDict']]] = None,
                 fallback: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_event_queue: Optional[pulumi.Input[Union['ExternalLocationFileEventQueueArgs', 'ExternalLocationFileEventQueueArgsDict']]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalLocationArgs.__new__(ExternalLocationArgs)

            __props__.__dict__["comment"] = comment
            if credential_name is None and not opts.urn:
                raise TypeError("Missing required property 'credential_name'")
            __props__.__dict__["credential_name"] = credential_name
            __props__.__dict__["enable_file_events"] = enable_file_events
            __props__.__dict__["encryption_details"] = encryption_details
            __props__.__dict__["fallback"] = fallback
            __props__.__dict__["file_event_queue"] = file_event_queue
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["force_update"] = force_update
            __props__.__dict__["isolation_mode"] = isolation_mode
            __props__.__dict__["metastore_id"] = metastore_id
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            __props__.__dict__["read_only"] = read_only
            __props__.__dict__["skip_validation"] = skip_validation
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["browse_only"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["credential_id"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["updated_by"] = None
        super(ExternalLocation, __self__).__init__(
            'databricks:index/externalLocation:ExternalLocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            browse_only: Optional[pulumi.Input[_builtins.bool]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.int]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            credential_id: Optional[pulumi.Input[_builtins.str]] = None,
            credential_name: Optional[pulumi.Input[_builtins.str]] = None,
            enable_file_events: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_details: Optional[pulumi.Input[Union['ExternalLocationEncryptionDetailsArgs', 'ExternalLocationEncryptionDetailsArgsDict']]] = None,
            fallback: Optional[pulumi.Input[_builtins.bool]] = None,
            file_event_queue: Optional[pulumi.Input[Union['ExternalLocationFileEventQueueArgs', 'ExternalLocationFileEventQueueArgsDict']]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            force_update: Optional[pulumi.Input[_builtins.bool]] = None,
            isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
            metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            read_only: Optional[pulumi.Input[_builtins.bool]] = None,
            skip_validation: Optional[pulumi.Input[_builtins.bool]] = None,
            updated_at: Optional[pulumi.Input[_builtins.int]] = None,
            updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'ExternalLocation':
        """
        Get an existing ExternalLocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[_builtins.int] created_at: Time at which this external location was created, in epoch milliseconds.
        :param pulumi.Input[_builtins.str] created_by: Username of external location creator.
        :param pulumi.Input[_builtins.str] credential_id: Unique ID of the location's storage credential.
        :param pulumi.Input[_builtins.str] credential_name: Name of the StorageCredential to use with this external location.
        :param pulumi.Input[_builtins.bool] enable_file_events: indicates if managed file events are enabled for this external location.  Requires `file_event_queue` block.
        :param pulumi.Input[_builtins.bool] fallback: Indicates whether fallback mode is enabled for this external location. When fallback mode is enabled (disabled by default), the access to the location falls back to cluster credentials if UC credentials are not sufficient.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroy external location regardless of its dependents.
        :param pulumi.Input[_builtins.bool] force_update: Update external location regardless of its dependents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the external location is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the external location to `ISOLATION_MODE_ISOLATED` will automatically allow access from the current workspace.
        :param pulumi.Input[_builtins.str] name: Name of External Location, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the external location owner.
        :param pulumi.Input[_builtins.bool] read_only: Indicates whether the external location is read-only.
        :param pulumi.Input[_builtins.bool] skip_validation: Suppress validation errors if any & force save the external location
        :param pulumi.Input[_builtins.int] updated_at: Time at which external location this was last modified, in epoch milliseconds.
        :param pulumi.Input[_builtins.str] updated_by: Username of user who last modified the external location.
        :param pulumi.Input[_builtins.str] url: Path URL in cloud storage, of the form: `s3://[bucket-host]/[bucket-dir]` (AWS), `abfss://[user]@[host]/[path]` (Azure), `gs://[bucket-host]/[bucket-dir]` (GCP).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalLocationState.__new__(_ExternalLocationState)

        __props__.__dict__["browse_only"] = browse_only
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["credential_name"] = credential_name
        __props__.__dict__["enable_file_events"] = enable_file_events
        __props__.__dict__["encryption_details"] = encryption_details
        __props__.__dict__["fallback"] = fallback
        __props__.__dict__["file_event_queue"] = file_event_queue
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["force_update"] = force_update
        __props__.__dict__["isolation_mode"] = isolation_mode
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["skip_validation"] = skip_validation
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["updated_by"] = updated_by
        __props__.__dict__["url"] = url
        return ExternalLocation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="browseOnly")
    def browse_only(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "browse_only")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-supplied free-form text.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.int]:
        """
        Time at which this external location was created, in epoch milliseconds.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        Username of external location creator.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique ID of the location's storage credential.
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the StorageCredential to use with this external location.
        """
        return pulumi.get(self, "credential_name")

    @_builtins.property
    @pulumi.getter(name="enableFileEvents")
    def enable_file_events(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        indicates if managed file events are enabled for this external location.  Requires `file_event_queue` block.
        """
        return pulumi.get(self, "enable_file_events")

    @_builtins.property
    @pulumi.getter(name="encryptionDetails")
    def encryption_details(self) -> pulumi.Output[Optional['outputs.ExternalLocationEncryptionDetails']]:
        return pulumi.get(self, "encryption_details")

    @_builtins.property
    @pulumi.getter
    def fallback(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether fallback mode is enabled for this external location. When fallback mode is enabled (disabled by default), the access to the location falls back to cluster credentials if UC credentials are not sufficient.
        """
        return pulumi.get(self, "fallback")

    @_builtins.property
    @pulumi.getter(name="fileEventQueue")
    def file_event_queue(self) -> pulumi.Output[Optional['outputs.ExternalLocationFileEventQueue']]:
        return pulumi.get(self, "file_event_queue")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Destroy external location regardless of its dependents.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Update external location regardless of its dependents.
        """
        return pulumi.get(self, "force_update")

    @_builtins.property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Whether the external location is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the external location to `ISOLATION_MODE_ISOLATED` will automatically allow access from the current workspace.
        """
        return pulumi.get(self, "isolation_mode")

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "metastore_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of External Location, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Username/groupname/sp application_id of the external location owner.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the external location is read-only.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="skipValidation")
    def skip_validation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Suppress validation errors if any & force save the external location
        """
        return pulumi.get(self, "skip_validation")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.int]:
        """
        Time at which external location this was last modified, in epoch milliseconds.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        Username of user who last modified the external location.
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        Path URL in cloud storage, of the form: `s3://[bucket-host]/[bucket-dir]` (AWS), `abfss://[user]@[host]/[path]` (Azure), `gs://[bucket-host]/[bucket-dir]` (GCP).
        """
        return pulumi.get(self, "url")

