# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCleanRoomAssetResult',
    'AwaitableGetCleanRoomAssetResult',
    'get_clean_room_asset',
    'get_clean_room_asset_output',
]

@pulumi.output_type
class GetCleanRoomAssetResult:
    """
    A collection of values returned by getCleanRoomAsset.
    """
    def __init__(__self__, added_at=None, asset_type=None, clean_room_name=None, foreign_table=None, foreign_table_local_details=None, id=None, name=None, notebook=None, owner_collaborator_alias=None, status=None, table=None, table_local_details=None, view=None, view_local_details=None, volume_local_details=None, workspace_id=None):
        if added_at and not isinstance(added_at, int):
            raise TypeError("Expected argument 'added_at' to be a int")
        pulumi.set(__self__, "added_at", added_at)
        if asset_type and not isinstance(asset_type, str):
            raise TypeError("Expected argument 'asset_type' to be a str")
        pulumi.set(__self__, "asset_type", asset_type)
        if clean_room_name and not isinstance(clean_room_name, str):
            raise TypeError("Expected argument 'clean_room_name' to be a str")
        pulumi.set(__self__, "clean_room_name", clean_room_name)
        if foreign_table and not isinstance(foreign_table, dict):
            raise TypeError("Expected argument 'foreign_table' to be a dict")
        pulumi.set(__self__, "foreign_table", foreign_table)
        if foreign_table_local_details and not isinstance(foreign_table_local_details, dict):
            raise TypeError("Expected argument 'foreign_table_local_details' to be a dict")
        pulumi.set(__self__, "foreign_table_local_details", foreign_table_local_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notebook and not isinstance(notebook, dict):
            raise TypeError("Expected argument 'notebook' to be a dict")
        pulumi.set(__self__, "notebook", notebook)
        if owner_collaborator_alias and not isinstance(owner_collaborator_alias, str):
            raise TypeError("Expected argument 'owner_collaborator_alias' to be a str")
        pulumi.set(__self__, "owner_collaborator_alias", owner_collaborator_alias)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if table and not isinstance(table, dict):
            raise TypeError("Expected argument 'table' to be a dict")
        pulumi.set(__self__, "table", table)
        if table_local_details and not isinstance(table_local_details, dict):
            raise TypeError("Expected argument 'table_local_details' to be a dict")
        pulumi.set(__self__, "table_local_details", table_local_details)
        if view and not isinstance(view, dict):
            raise TypeError("Expected argument 'view' to be a dict")
        pulumi.set(__self__, "view", view)
        if view_local_details and not isinstance(view_local_details, dict):
            raise TypeError("Expected argument 'view_local_details' to be a dict")
        pulumi.set(__self__, "view_local_details", view_local_details)
        if volume_local_details and not isinstance(volume_local_details, dict):
            raise TypeError("Expected argument 'volume_local_details' to be a dict")
        pulumi.set(__self__, "volume_local_details", volume_local_details)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="addedAt")
    def added_at(self) -> _builtins.int:
        """
        (integer) - When the asset is added to the clean room, in epoch milliseconds
        """
        return pulumi.get(self, "added_at")

    @_builtins.property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> _builtins.str:
        """
        (string) - The type of the asset. Possible values are: `FOREIGN_TABLE`, `NOTEBOOK_FILE`, `TABLE`, `VIEW`, `VOLUME`
        """
        return pulumi.get(self, "asset_type")

    @_builtins.property
    @pulumi.getter(name="cleanRoomName")
    def clean_room_name(self) -> Optional[_builtins.str]:
        """
        (string) - The name of the clean room this asset belongs to.
        This field is required for create operations and populated by the server for responses
        """
        return pulumi.get(self, "clean_room_name")

    @_builtins.property
    @pulumi.getter(name="foreignTable")
    def foreign_table(self) -> Optional['outputs.GetCleanRoomAssetForeignTableResult']:
        """
        (CleanRoomAssetForeignTable) - Foreign table details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **FOREIGN_TABLE**
        """
        return pulumi.get(self, "foreign_table")

    @_builtins.property
    @pulumi.getter(name="foreignTableLocalDetails")
    def foreign_table_local_details(self) -> Optional['outputs.GetCleanRoomAssetForeignTableLocalDetailsResult']:
        """
        (CleanRoomAssetForeignTableLocalDetails) - Local details for a foreign that are only available to its owner.
        Present if and only if **asset_type** is **FOREIGN_TABLE**
        """
        return pulumi.get(self, "foreign_table_local_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (string) - The name of the partition column
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notebook(self) -> Optional['outputs.GetCleanRoomAssetNotebookResult']:
        """
        (CleanRoomAssetNotebook) - Notebook details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **NOTEBOOK_FILE**
        """
        return pulumi.get(self, "notebook")

    @_builtins.property
    @pulumi.getter(name="ownerCollaboratorAlias")
    def owner_collaborator_alias(self) -> _builtins.str:
        """
        (string) - The alias of the collaborator who owns this asset
        """
        return pulumi.get(self, "owner_collaborator_alias")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        (string) - Status of the asset. Possible values are: `ACTIVE`, `PENDING`, `PERMISSION_DENIED`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional['outputs.GetCleanRoomAssetTableResult']:
        """
        (CleanRoomAssetTable) - Table details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **TABLE**
        """
        return pulumi.get(self, "table")

    @_builtins.property
    @pulumi.getter(name="tableLocalDetails")
    def table_local_details(self) -> Optional['outputs.GetCleanRoomAssetTableLocalDetailsResult']:
        """
        (CleanRoomAssetTableLocalDetails) - Local details for a table that are only available to its owner.
        Present if and only if **asset_type** is **TABLE**
        """
        return pulumi.get(self, "table_local_details")

    @_builtins.property
    @pulumi.getter
    def view(self) -> Optional['outputs.GetCleanRoomAssetViewResult']:
        """
        (CleanRoomAssetView) - View details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **VIEW**
        """
        return pulumi.get(self, "view")

    @_builtins.property
    @pulumi.getter(name="viewLocalDetails")
    def view_local_details(self) -> Optional['outputs.GetCleanRoomAssetViewLocalDetailsResult']:
        """
        (CleanRoomAssetViewLocalDetails) - Local details for a view that are only available to its owner.
        Present if and only if **asset_type** is **VIEW**
        """
        return pulumi.get(self, "view_local_details")

    @_builtins.property
    @pulumi.getter(name="volumeLocalDetails")
    def volume_local_details(self) -> Optional['outputs.GetCleanRoomAssetVolumeLocalDetailsResult']:
        """
        (CleanRoomAssetVolumeLocalDetails) - Local details for a volume that are only available to its owner.
        Present if and only if **asset_type** is **VOLUME**
        """
        return pulumi.get(self, "volume_local_details")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "workspace_id")


class AwaitableGetCleanRoomAssetResult(GetCleanRoomAssetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCleanRoomAssetResult(
            added_at=self.added_at,
            asset_type=self.asset_type,
            clean_room_name=self.clean_room_name,
            foreign_table=self.foreign_table,
            foreign_table_local_details=self.foreign_table_local_details,
            id=self.id,
            name=self.name,
            notebook=self.notebook,
            owner_collaborator_alias=self.owner_collaborator_alias,
            status=self.status,
            table=self.table,
            table_local_details=self.table_local_details,
            view=self.view,
            view_local_details=self.view_local_details,
            volume_local_details=self.volume_local_details,
            workspace_id=self.workspace_id)


def get_clean_room_asset(asset_type: Optional[_builtins.str] = None,
                         clean_room_name: Optional[_builtins.str] = None,
                         foreign_table: Optional[Union['GetCleanRoomAssetForeignTableArgs', 'GetCleanRoomAssetForeignTableArgsDict']] = None,
                         foreign_table_local_details: Optional[Union['GetCleanRoomAssetForeignTableLocalDetailsArgs', 'GetCleanRoomAssetForeignTableLocalDetailsArgsDict']] = None,
                         name: Optional[_builtins.str] = None,
                         notebook: Optional[Union['GetCleanRoomAssetNotebookArgs', 'GetCleanRoomAssetNotebookArgsDict']] = None,
                         table: Optional[Union['GetCleanRoomAssetTableArgs', 'GetCleanRoomAssetTableArgsDict']] = None,
                         table_local_details: Optional[Union['GetCleanRoomAssetTableLocalDetailsArgs', 'GetCleanRoomAssetTableLocalDetailsArgsDict']] = None,
                         view: Optional[Union['GetCleanRoomAssetViewArgs', 'GetCleanRoomAssetViewArgsDict']] = None,
                         view_local_details: Optional[Union['GetCleanRoomAssetViewLocalDetailsArgs', 'GetCleanRoomAssetViewLocalDetailsArgsDict']] = None,
                         volume_local_details: Optional[Union['GetCleanRoomAssetVolumeLocalDetailsArgs', 'GetCleanRoomAssetVolumeLocalDetailsArgsDict']] = None,
                         workspace_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCleanRoomAssetResult:
    """
    This data source can be used to get a single clean room asset.

    ## Example Usage

    # Example: Clean Room Asset Datasource

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.index.CleanRoomsAsset("this", name=example-cleanroom-asset)
    ```


    :param _builtins.str asset_type: The type of the asset. Possible values are: `FOREIGN_TABLE`, `NOTEBOOK_FILE`, `TABLE`, `VIEW`, `VOLUME`
    :param _builtins.str clean_room_name: The name of the clean room this asset belongs to.
           This field is required for create operations and populated by the server for responses
    :param Union['GetCleanRoomAssetForeignTableArgs', 'GetCleanRoomAssetForeignTableArgsDict'] foreign_table: (CleanRoomAssetForeignTable) - Foreign table details available to all collaborators of the clean room.
           Present if and only if **asset_type** is **FOREIGN_TABLE**
    :param Union['GetCleanRoomAssetForeignTableLocalDetailsArgs', 'GetCleanRoomAssetForeignTableLocalDetailsArgsDict'] foreign_table_local_details: (CleanRoomAssetForeignTableLocalDetails) - Local details for a foreign that are only available to its owner.
           Present if and only if **asset_type** is **FOREIGN_TABLE**
    :param _builtins.str name: A fully qualified name that uniquely identifies the asset within the clean room.
           This is also the name displayed in the clean room UI.
           
           For UC securable assets (tables, volumes, etc.), the format is *shared_catalog*.*shared_schema*.*asset_name*
           
           For notebooks, the name is the notebook file name.
           For jar analyses, the name is the jar analysis name
    :param Union['GetCleanRoomAssetNotebookArgs', 'GetCleanRoomAssetNotebookArgsDict'] notebook: (CleanRoomAssetNotebook) - Notebook details available to all collaborators of the clean room.
           Present if and only if **asset_type** is **NOTEBOOK_FILE**
    :param Union['GetCleanRoomAssetTableArgs', 'GetCleanRoomAssetTableArgsDict'] table: (CleanRoomAssetTable) - Table details available to all collaborators of the clean room.
           Present if and only if **asset_type** is **TABLE**
    :param Union['GetCleanRoomAssetTableLocalDetailsArgs', 'GetCleanRoomAssetTableLocalDetailsArgsDict'] table_local_details: (CleanRoomAssetTableLocalDetails) - Local details for a table that are only available to its owner.
           Present if and only if **asset_type** is **TABLE**
    :param Union['GetCleanRoomAssetViewArgs', 'GetCleanRoomAssetViewArgsDict'] view: (CleanRoomAssetView) - View details available to all collaborators of the clean room.
           Present if and only if **asset_type** is **VIEW**
    :param Union['GetCleanRoomAssetViewLocalDetailsArgs', 'GetCleanRoomAssetViewLocalDetailsArgsDict'] view_local_details: (CleanRoomAssetViewLocalDetails) - Local details for a view that are only available to its owner.
           Present if and only if **asset_type** is **VIEW**
    :param Union['GetCleanRoomAssetVolumeLocalDetailsArgs', 'GetCleanRoomAssetVolumeLocalDetailsArgsDict'] volume_local_details: (CleanRoomAssetVolumeLocalDetails) - Local details for a volume that are only available to its owner.
           Present if and only if **asset_type** is **VOLUME**
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['assetType'] = asset_type
    __args__['cleanRoomName'] = clean_room_name
    __args__['foreignTable'] = foreign_table
    __args__['foreignTableLocalDetails'] = foreign_table_local_details
    __args__['name'] = name
    __args__['notebook'] = notebook
    __args__['table'] = table
    __args__['tableLocalDetails'] = table_local_details
    __args__['view'] = view
    __args__['viewLocalDetails'] = view_local_details
    __args__['volumeLocalDetails'] = volume_local_details
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getCleanRoomAsset:getCleanRoomAsset', __args__, opts=opts, typ=GetCleanRoomAssetResult).value

    return AwaitableGetCleanRoomAssetResult(
        added_at=pulumi.get(__ret__, 'added_at'),
        asset_type=pulumi.get(__ret__, 'asset_type'),
        clean_room_name=pulumi.get(__ret__, 'clean_room_name'),
        foreign_table=pulumi.get(__ret__, 'foreign_table'),
        foreign_table_local_details=pulumi.get(__ret__, 'foreign_table_local_details'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        notebook=pulumi.get(__ret__, 'notebook'),
        owner_collaborator_alias=pulumi.get(__ret__, 'owner_collaborator_alias'),
        status=pulumi.get(__ret__, 'status'),
        table=pulumi.get(__ret__, 'table'),
        table_local_details=pulumi.get(__ret__, 'table_local_details'),
        view=pulumi.get(__ret__, 'view'),
        view_local_details=pulumi.get(__ret__, 'view_local_details'),
        volume_local_details=pulumi.get(__ret__, 'volume_local_details'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_clean_room_asset_output(asset_type: Optional[pulumi.Input[_builtins.str]] = None,
                                clean_room_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                foreign_table: Optional[pulumi.Input[Optional[Union['GetCleanRoomAssetForeignTableArgs', 'GetCleanRoomAssetForeignTableArgsDict']]]] = None,
                                foreign_table_local_details: Optional[pulumi.Input[Optional[Union['GetCleanRoomAssetForeignTableLocalDetailsArgs', 'GetCleanRoomAssetForeignTableLocalDetailsArgsDict']]]] = None,
                                name: Optional[pulumi.Input[_builtins.str]] = None,
                                notebook: Optional[pulumi.Input[Optional[Union['GetCleanRoomAssetNotebookArgs', 'GetCleanRoomAssetNotebookArgsDict']]]] = None,
                                table: Optional[pulumi.Input[Optional[Union['GetCleanRoomAssetTableArgs', 'GetCleanRoomAssetTableArgsDict']]]] = None,
                                table_local_details: Optional[pulumi.Input[Optional[Union['GetCleanRoomAssetTableLocalDetailsArgs', 'GetCleanRoomAssetTableLocalDetailsArgsDict']]]] = None,
                                view: Optional[pulumi.Input[Optional[Union['GetCleanRoomAssetViewArgs', 'GetCleanRoomAssetViewArgsDict']]]] = None,
                                view_local_details: Optional[pulumi.Input[Optional[Union['GetCleanRoomAssetViewLocalDetailsArgs', 'GetCleanRoomAssetViewLocalDetailsArgsDict']]]] = None,
                                volume_local_details: Optional[pulumi.Input[Optional[Union['GetCleanRoomAssetVolumeLocalDetailsArgs', 'GetCleanRoomAssetVolumeLocalDetailsArgsDict']]]] = None,
                                workspace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCleanRoomAssetResult]:
    """
    This data source can be used to get a single clean room asset.

    ## Example Usage

    # Example: Clean Room Asset Datasource

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.index.CleanRoomsAsset("this", name=example-cleanroom-asset)
    ```


    :param _builtins.str asset_type: The type of the asset. Possible values are: `FOREIGN_TABLE`, `NOTEBOOK_FILE`, `TABLE`, `VIEW`, `VOLUME`
    :param _builtins.str clean_room_name: The name of the clean room this asset belongs to.
           This field is required for create operations and populated by the server for responses
    :param Union['GetCleanRoomAssetForeignTableArgs', 'GetCleanRoomAssetForeignTableArgsDict'] foreign_table: (CleanRoomAssetForeignTable) - Foreign table details available to all collaborators of the clean room.
           Present if and only if **asset_type** is **FOREIGN_TABLE**
    :param Union['GetCleanRoomAssetForeignTableLocalDetailsArgs', 'GetCleanRoomAssetForeignTableLocalDetailsArgsDict'] foreign_table_local_details: (CleanRoomAssetForeignTableLocalDetails) - Local details for a foreign that are only available to its owner.
           Present if and only if **asset_type** is **FOREIGN_TABLE**
    :param _builtins.str name: A fully qualified name that uniquely identifies the asset within the clean room.
           This is also the name displayed in the clean room UI.
           
           For UC securable assets (tables, volumes, etc.), the format is *shared_catalog*.*shared_schema*.*asset_name*
           
           For notebooks, the name is the notebook file name.
           For jar analyses, the name is the jar analysis name
    :param Union['GetCleanRoomAssetNotebookArgs', 'GetCleanRoomAssetNotebookArgsDict'] notebook: (CleanRoomAssetNotebook) - Notebook details available to all collaborators of the clean room.
           Present if and only if **asset_type** is **NOTEBOOK_FILE**
    :param Union['GetCleanRoomAssetTableArgs', 'GetCleanRoomAssetTableArgsDict'] table: (CleanRoomAssetTable) - Table details available to all collaborators of the clean room.
           Present if and only if **asset_type** is **TABLE**
    :param Union['GetCleanRoomAssetTableLocalDetailsArgs', 'GetCleanRoomAssetTableLocalDetailsArgsDict'] table_local_details: (CleanRoomAssetTableLocalDetails) - Local details for a table that are only available to its owner.
           Present if and only if **asset_type** is **TABLE**
    :param Union['GetCleanRoomAssetViewArgs', 'GetCleanRoomAssetViewArgsDict'] view: (CleanRoomAssetView) - View details available to all collaborators of the clean room.
           Present if and only if **asset_type** is **VIEW**
    :param Union['GetCleanRoomAssetViewLocalDetailsArgs', 'GetCleanRoomAssetViewLocalDetailsArgsDict'] view_local_details: (CleanRoomAssetViewLocalDetails) - Local details for a view that are only available to its owner.
           Present if and only if **asset_type** is **VIEW**
    :param Union['GetCleanRoomAssetVolumeLocalDetailsArgs', 'GetCleanRoomAssetVolumeLocalDetailsArgsDict'] volume_local_details: (CleanRoomAssetVolumeLocalDetails) - Local details for a volume that are only available to its owner.
           Present if and only if **asset_type** is **VOLUME**
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['assetType'] = asset_type
    __args__['cleanRoomName'] = clean_room_name
    __args__['foreignTable'] = foreign_table
    __args__['foreignTableLocalDetails'] = foreign_table_local_details
    __args__['name'] = name
    __args__['notebook'] = notebook
    __args__['table'] = table
    __args__['tableLocalDetails'] = table_local_details
    __args__['view'] = view
    __args__['viewLocalDetails'] = view_local_details
    __args__['volumeLocalDetails'] = volume_local_details
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getCleanRoomAsset:getCleanRoomAsset', __args__, opts=opts, typ=GetCleanRoomAssetResult)
    return __ret__.apply(lambda __response__: GetCleanRoomAssetResult(
        added_at=pulumi.get(__response__, 'added_at'),
        asset_type=pulumi.get(__response__, 'asset_type'),
        clean_room_name=pulumi.get(__response__, 'clean_room_name'),
        foreign_table=pulumi.get(__response__, 'foreign_table'),
        foreign_table_local_details=pulumi.get(__response__, 'foreign_table_local_details'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        notebook=pulumi.get(__response__, 'notebook'),
        owner_collaborator_alias=pulumi.get(__response__, 'owner_collaborator_alias'),
        status=pulumi.get(__response__, 'status'),
        table=pulumi.get(__response__, 'table'),
        table_local_details=pulumi.get(__response__, 'table_local_details'),
        view=pulumi.get(__response__, 'view'),
        view_local_details=pulumi.get(__response__, 'view_local_details'),
        volume_local_details=pulumi.get(__response__, 'volume_local_details'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
