# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCleanRoomsCleanRoomResult',
    'AwaitableGetCleanRoomsCleanRoomResult',
    'get_clean_rooms_clean_room',
    'get_clean_rooms_clean_room_output',
]

@pulumi.output_type
class GetCleanRoomsCleanRoomResult:
    """
    A collection of values returned by getCleanRoomsCleanRoom.
    """
    def __init__(__self__, access_restricted=None, comment=None, created_at=None, id=None, local_collaborator_alias=None, name=None, output_catalog=None, owner=None, remote_detailed_info=None, status=None, updated_at=None, workspace_id=None):
        if access_restricted and not isinstance(access_restricted, str):
            raise TypeError("Expected argument 'access_restricted' to be a str")
        pulumi.set(__self__, "access_restricted", access_restricted)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if created_at and not isinstance(created_at, int):
            raise TypeError("Expected argument 'created_at' to be a int")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_collaborator_alias and not isinstance(local_collaborator_alias, str):
            raise TypeError("Expected argument 'local_collaborator_alias' to be a str")
        pulumi.set(__self__, "local_collaborator_alias", local_collaborator_alias)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_catalog and not isinstance(output_catalog, dict):
            raise TypeError("Expected argument 'output_catalog' to be a dict")
        pulumi.set(__self__, "output_catalog", output_catalog)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if remote_detailed_info and not isinstance(remote_detailed_info, dict):
            raise TypeError("Expected argument 'remote_detailed_info' to be a dict")
        pulumi.set(__self__, "remote_detailed_info", remote_detailed_info)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if updated_at and not isinstance(updated_at, int):
            raise TypeError("Expected argument 'updated_at' to be a int")
        pulumi.set(__self__, "updated_at", updated_at)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="accessRestricted")
    def access_restricted(self) -> _builtins.str:
        """
        (string) - Whether clean room access is restricted due to [CSP](https://docs.databricks.com/en/security/privacy/security-profile.html). Possible values are: `CSP_MISMATCH`, `NO_RESTRICTION`
        """
        return pulumi.get(self, "access_restricted")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        (string)
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.int:
        """
        (integer) - When the clean room was created, in epoch milliseconds
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localCollaboratorAlias")
    def local_collaborator_alias(self) -> _builtins.str:
        """
        (string) - The alias of the collaborator tied to the local clean room
        """
        return pulumi.get(self, "local_collaborator_alias")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (string) - The name of the clean room.
        It should follow [UC securable naming requirements](https://docs.databricks.com/en/data-governance/unity-catalog/index.html#securable-object-naming-requirements)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outputCatalog")
    def output_catalog(self) -> 'outputs.GetCleanRoomsCleanRoomOutputCatalogResult':
        """
        (CleanRoomOutputCatalog) - Output catalog of the clean room. It is an output only field. Output catalog is manipulated
        using the separate CreateCleanRoomOutputCatalog API
        """
        return pulumi.get(self, "output_catalog")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[_builtins.str]:
        """
        (string) - This is the Databricks username of the owner of the local clean room securable for permission management
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="remoteDetailedInfo")
    def remote_detailed_info(self) -> Optional['outputs.GetCleanRoomsCleanRoomRemoteDetailedInfoResult']:
        """
        (CleanRoomRemoteDetail) - Central clean room details. During creation, users need to specify
        cloud_vendor, region, and collaborators.global_metastore_id.
        This field will not be filled in the ListCleanRooms call
        """
        return pulumi.get(self, "remote_detailed_info")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        (string) - . Possible values are: `CREATED`, `NOT_CREATED`, `NOT_ELIGIBLE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.int:
        """
        (integer) - When the clean room was last updated, in epoch milliseconds
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "workspace_id")


class AwaitableGetCleanRoomsCleanRoomResult(GetCleanRoomsCleanRoomResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCleanRoomsCleanRoomResult(
            access_restricted=self.access_restricted,
            comment=self.comment,
            created_at=self.created_at,
            id=self.id,
            local_collaborator_alias=self.local_collaborator_alias,
            name=self.name,
            output_catalog=self.output_catalog,
            owner=self.owner,
            remote_detailed_info=self.remote_detailed_info,
            status=self.status,
            updated_at=self.updated_at,
            workspace_id=self.workspace_id)


def get_clean_rooms_clean_room(comment: Optional[_builtins.str] = None,
                               name: Optional[_builtins.str] = None,
                               owner: Optional[_builtins.str] = None,
                               remote_detailed_info: Optional[Union['GetCleanRoomsCleanRoomRemoteDetailedInfoArgs', 'GetCleanRoomsCleanRoomRemoteDetailedInfoArgsDict']] = None,
                               workspace_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCleanRoomsCleanRoomResult:
    """
    This data source can be used to get a single clean room.

    ## Example Usage

    # Example: Datasource (Singular) Artifact

    ```python
    import pulumi
    import pulumi_databricks as databricks

    example = databricks.get_clean_rooms_clean_room(name="example-clean-room")
    ```


    :param _builtins.str comment: (string)
    :param _builtins.str name: The name of the clean room.
           It should follow [UC securable naming requirements](https://docs.databricks.com/en/data-governance/unity-catalog/index.html#securable-object-naming-requirements)
    :param _builtins.str owner: (string) - This is the Databricks username of the owner of the local clean room securable for permission management
    :param Union['GetCleanRoomsCleanRoomRemoteDetailedInfoArgs', 'GetCleanRoomsCleanRoomRemoteDetailedInfoArgsDict'] remote_detailed_info: (CleanRoomRemoteDetail) - Central clean room details. During creation, users need to specify
           cloud_vendor, region, and collaborators.global_metastore_id.
           This field will not be filled in the ListCleanRooms call
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['comment'] = comment
    __args__['name'] = name
    __args__['owner'] = owner
    __args__['remoteDetailedInfo'] = remote_detailed_info
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getCleanRoomsCleanRoom:getCleanRoomsCleanRoom', __args__, opts=opts, typ=GetCleanRoomsCleanRoomResult).value

    return AwaitableGetCleanRoomsCleanRoomResult(
        access_restricted=pulumi.get(__ret__, 'access_restricted'),
        comment=pulumi.get(__ret__, 'comment'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        local_collaborator_alias=pulumi.get(__ret__, 'local_collaborator_alias'),
        name=pulumi.get(__ret__, 'name'),
        output_catalog=pulumi.get(__ret__, 'output_catalog'),
        owner=pulumi.get(__ret__, 'owner'),
        remote_detailed_info=pulumi.get(__ret__, 'remote_detailed_info'),
        status=pulumi.get(__ret__, 'status'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_clean_rooms_clean_room_output(comment: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      owner: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      remote_detailed_info: Optional[pulumi.Input[Optional[Union['GetCleanRoomsCleanRoomRemoteDetailedInfoArgs', 'GetCleanRoomsCleanRoomRemoteDetailedInfoArgsDict']]]] = None,
                                      workspace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCleanRoomsCleanRoomResult]:
    """
    This data source can be used to get a single clean room.

    ## Example Usage

    # Example: Datasource (Singular) Artifact

    ```python
    import pulumi
    import pulumi_databricks as databricks

    example = databricks.get_clean_rooms_clean_room(name="example-clean-room")
    ```


    :param _builtins.str comment: (string)
    :param _builtins.str name: The name of the clean room.
           It should follow [UC securable naming requirements](https://docs.databricks.com/en/data-governance/unity-catalog/index.html#securable-object-naming-requirements)
    :param _builtins.str owner: (string) - This is the Databricks username of the owner of the local clean room securable for permission management
    :param Union['GetCleanRoomsCleanRoomRemoteDetailedInfoArgs', 'GetCleanRoomsCleanRoomRemoteDetailedInfoArgsDict'] remote_detailed_info: (CleanRoomRemoteDetail) - Central clean room details. During creation, users need to specify
           cloud_vendor, region, and collaborators.global_metastore_id.
           This field will not be filled in the ListCleanRooms call
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['comment'] = comment
    __args__['name'] = name
    __args__['owner'] = owner
    __args__['remoteDetailedInfo'] = remote_detailed_info
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getCleanRoomsCleanRoom:getCleanRoomsCleanRoom', __args__, opts=opts, typ=GetCleanRoomsCleanRoomResult)
    return __ret__.apply(lambda __response__: GetCleanRoomsCleanRoomResult(
        access_restricted=pulumi.get(__response__, 'access_restricted'),
        comment=pulumi.get(__response__, 'comment'),
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        local_collaborator_alias=pulumi.get(__response__, 'local_collaborator_alias'),
        name=pulumi.get(__response__, 'name'),
        output_catalog=pulumi.get(__response__, 'output_catalog'),
        owner=pulumi.get(__response__, 'owner'),
        remote_detailed_info=pulumi.get(__response__, 'remote_detailed_info'),
        status=pulumi.get(__response__, 'status'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
