# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, cluster_id=None, cluster_info=None, cluster_name=None, id=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_info and not isinstance(cluster_info, dict):
            raise TypeError("Expected argument 'cluster_info' to be a dict")
        pulumi.set(__self__, "cluster_info", cluster_info)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterInfo")
    def cluster_info(self) -> 'outputs.GetClusterClusterInfoResult':
        """
        block, consisting of following fields:
        """
        return pulumi.get(self, "cluster_info")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        Cluster name, which doesn’t have to be unique.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        cluster ID
        """
        return pulumi.get(self, "id")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            cluster_id=self.cluster_id,
            cluster_info=self.cluster_info,
            cluster_name=self.cluster_name,
            id=self.id)


def get_cluster(cluster_id: Optional[_builtins.str] = None,
                cluster_info: Optional[Union['GetClusterClusterInfoArgs', 'GetClusterClusterInfoArgsDict']] = None,
                cluster_name: Optional[_builtins.str] = None,
                id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Retrieves information about a Cluster using its id. This could be retrieved programmatically using get_clusters data source.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Retrieve attributes of each SQL warehouses in a workspace

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_clusters()
    all_get_cluster = {__key: databricks.get_cluster(cluster_id=__value) for __key, __value in all.ids}
    ```


    :param _builtins.str cluster_id: The id of the cluster.
    :param Union['GetClusterClusterInfoArgs', 'GetClusterClusterInfoArgsDict'] cluster_info: block, consisting of following fields:
    :param _builtins.str cluster_name: The exact name of the cluster to search. Can only be specified if there is exactly one cluster with the provided name.
    :param _builtins.str id: cluster ID
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['clusterInfo'] = cluster_info
    __args__['clusterName'] = cluster_name
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        cluster_info=pulumi.get(__ret__, 'cluster_info'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        id=pulumi.get(__ret__, 'id'))
def get_cluster_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       cluster_info: Optional[pulumi.Input[Optional[Union['GetClusterClusterInfoArgs', 'GetClusterClusterInfoArgsDict']]]] = None,
                       cluster_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    Retrieves information about a Cluster using its id. This could be retrieved programmatically using get_clusters data source.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Retrieve attributes of each SQL warehouses in a workspace

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_clusters()
    all_get_cluster = {__key: databricks.get_cluster(cluster_id=__value) for __key, __value in all.ids}
    ```


    :param _builtins.str cluster_id: The id of the cluster.
    :param Union['GetClusterClusterInfoArgs', 'GetClusterClusterInfoArgsDict'] cluster_info: block, consisting of following fields:
    :param _builtins.str cluster_name: The exact name of the cluster to search. Can only be specified if there is exactly one cluster with the provided name.
    :param _builtins.str id: cluster ID
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['clusterInfo'] = cluster_info
    __args__['clusterName'] = cluster_name
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        cluster_info=pulumi.get(__response__, 'cluster_info'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        id=pulumi.get(__response__, 'id')))
