# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetServicePrincipalResult',
    'AwaitableGetServicePrincipalResult',
    'get_service_principal',
    'get_service_principal_output',
]

@pulumi.output_type
class GetServicePrincipalResult:
    """
    A collection of values returned by getServicePrincipal.
    """
    def __init__(__self__, acl_principal_id=None, active=None, application_id=None, display_name=None, external_id=None, home=None, id=None, repos=None, scim_id=None, sp_id=None):
        if acl_principal_id and not isinstance(acl_principal_id, str):
            raise TypeError("Expected argument 'acl_principal_id' to be a str")
        pulumi.set(__self__, "acl_principal_id", acl_principal_id)
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_id and not isinstance(external_id, str):
            raise TypeError("Expected argument 'external_id' to be a str")
        pulumi.set(__self__, "external_id", external_id)
        if home and not isinstance(home, str):
            raise TypeError("Expected argument 'home' to be a str")
        pulumi.set(__self__, "home", home)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if repos and not isinstance(repos, str):
            raise TypeError("Expected argument 'repos' to be a str")
        pulumi.set(__self__, "repos", repos)
        if scim_id and not isinstance(scim_id, str):
            raise TypeError("Expected argument 'scim_id' to be a str")
        pulumi.set(__self__, "scim_id", scim_id)
        if sp_id and not isinstance(sp_id, str):
            raise TypeError("Expected argument 'sp_id' to be a str")
        pulumi.set(__self__, "sp_id", sp_id)

    @_builtins.property
    @pulumi.getter(name="aclPrincipalId")
    def acl_principal_id(self) -> _builtins.str:
        """
        identifier for use in databricks_access_control_rule_set, e.g. `servicePrincipals/00000000-0000-0000-0000-000000000000`.
        """
        return pulumi.get(self, "acl_principal_id")

    @_builtins.property
    @pulumi.getter
    def active(self) -> _builtins.bool:
        """
        Whether service principal is active or not.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        """
        Application ID of the service principal.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name of the service principal, e.g. `Foo SPN`.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        ID of the service principal in an external identity provider.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def home(self) -> _builtins.str:
        """
        Home folder of the service principal, e.g. `/Users/11111111-2222-3333-4444-555666777888`.
        """
        return pulumi.get(self, "home")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the service principal (SCIM ID).
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def repos(self) -> _builtins.str:
        """
        Repos location of the service principal, e.g. `/Repos/11111111-2222-3333-4444-555666777888`.
        """
        return pulumi.get(self, "repos")

    @_builtins.property
    @pulumi.getter(name="scimId")
    def scim_id(self) -> _builtins.str:
        """
        same as `id`.
        """
        return pulumi.get(self, "scim_id")

    @_builtins.property
    @pulumi.getter(name="spId")
    def sp_id(self) -> _builtins.str:
        return pulumi.get(self, "sp_id")


class AwaitableGetServicePrincipalResult(GetServicePrincipalResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServicePrincipalResult(
            acl_principal_id=self.acl_principal_id,
            active=self.active,
            application_id=self.application_id,
            display_name=self.display_name,
            external_id=self.external_id,
            home=self.home,
            id=self.id,
            repos=self.repos,
            scim_id=self.scim_id,
            sp_id=self.sp_id)


def get_service_principal(acl_principal_id: Optional[_builtins.str] = None,
                          active: Optional[_builtins.bool] = None,
                          application_id: Optional[_builtins.str] = None,
                          display_name: Optional[_builtins.str] = None,
                          external_id: Optional[_builtins.str] = None,
                          home: Optional[_builtins.str] = None,
                          id: Optional[_builtins.str] = None,
                          repos: Optional[_builtins.str] = None,
                          scim_id: Optional[_builtins.str] = None,
                          sp_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServicePrincipalResult:
    """
    Retrieves information about databricks_service_principal.

    > This data source can be used with an account or workspace-level provider.

    ## Example Usage

    Adding service principal `11111111-2222-3333-4444-555666777888` to administrative group

    ```python
    import pulumi
    import pulumi_databricks as databricks

    admins = databricks.get_group(display_name="admins")
    spn = databricks.get_service_principal(application_id="11111111-2222-3333-4444-555666777888")
    my_member_a = databricks.GroupMember("my_member_a",
        group_id=admins.id,
        member_id=spn.id)
    ```

    ## Related Resources

    The following resources are used in the same context:

    - End to end workspace management guide.
    - get_current_user data to retrieve information about User or databricks_service_principal, that is calling Databricks REST API.
    - Group to manage [Account-level](https://docs.databricks.com/aws/en/admin/users-groups/groups) or [Workspace-level](https://docs.databricks.com/aws/en/admin/users-groups/workspace-local-groups) groups.
    - Group data to retrieve information about Group members, entitlements and instance profiles.
    - GroupInstanceProfile to attach InstanceProfile (AWS) to databricks_group.
    - GroupMember to attach users and groups as group members.
    - Permissions to manage [access control](https://docs.databricks.com/security/access-control/index.html) in Databricks workspace.
    - databricks_service principal to manage service principals


    :param _builtins.str acl_principal_id: identifier for use in databricks_access_control_rule_set, e.g. `servicePrincipals/00000000-0000-0000-0000-000000000000`.
    :param _builtins.bool active: Whether service principal is active or not.
    :param _builtins.str application_id: Application ID of the service principal. The service principal must exist before this resource can be retrieved.
    :param _builtins.str display_name: Exact display name of the service principal. The service principal must exist before this resource can be retrieved.  In case if there are several service principals with the same name, an error is thrown.
    :param _builtins.str external_id: ID of the service principal in an external identity provider.
    :param _builtins.str home: Home folder of the service principal, e.g. `/Users/11111111-2222-3333-4444-555666777888`.
    :param _builtins.str id: The id of the service principal (SCIM ID).
    :param _builtins.str repos: Repos location of the service principal, e.g. `/Repos/11111111-2222-3333-4444-555666777888`.
    :param _builtins.str scim_id: Unique SCIM ID for a service principal in the Databricks workspace. The service principal must exist before this resource can be retrieved.
    """
    __args__ = dict()
    __args__['aclPrincipalId'] = acl_principal_id
    __args__['active'] = active
    __args__['applicationId'] = application_id
    __args__['displayName'] = display_name
    __args__['externalId'] = external_id
    __args__['home'] = home
    __args__['id'] = id
    __args__['repos'] = repos
    __args__['scimId'] = scim_id
    __args__['spId'] = sp_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getServicePrincipal:getServicePrincipal', __args__, opts=opts, typ=GetServicePrincipalResult).value

    return AwaitableGetServicePrincipalResult(
        acl_principal_id=pulumi.get(__ret__, 'acl_principal_id'),
        active=pulumi.get(__ret__, 'active'),
        application_id=pulumi.get(__ret__, 'application_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_id=pulumi.get(__ret__, 'external_id'),
        home=pulumi.get(__ret__, 'home'),
        id=pulumi.get(__ret__, 'id'),
        repos=pulumi.get(__ret__, 'repos'),
        scim_id=pulumi.get(__ret__, 'scim_id'),
        sp_id=pulumi.get(__ret__, 'sp_id'))
def get_service_principal_output(acl_principal_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 active: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                 application_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 external_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 home: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 repos: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 scim_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 sp_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServicePrincipalResult]:
    """
    Retrieves information about databricks_service_principal.

    > This data source can be used with an account or workspace-level provider.

    ## Example Usage

    Adding service principal `11111111-2222-3333-4444-555666777888` to administrative group

    ```python
    import pulumi
    import pulumi_databricks as databricks

    admins = databricks.get_group(display_name="admins")
    spn = databricks.get_service_principal(application_id="11111111-2222-3333-4444-555666777888")
    my_member_a = databricks.GroupMember("my_member_a",
        group_id=admins.id,
        member_id=spn.id)
    ```

    ## Related Resources

    The following resources are used in the same context:

    - End to end workspace management guide.
    - get_current_user data to retrieve information about User or databricks_service_principal, that is calling Databricks REST API.
    - Group to manage [Account-level](https://docs.databricks.com/aws/en/admin/users-groups/groups) or [Workspace-level](https://docs.databricks.com/aws/en/admin/users-groups/workspace-local-groups) groups.
    - Group data to retrieve information about Group members, entitlements and instance profiles.
    - GroupInstanceProfile to attach InstanceProfile (AWS) to databricks_group.
    - GroupMember to attach users and groups as group members.
    - Permissions to manage [access control](https://docs.databricks.com/security/access-control/index.html) in Databricks workspace.
    - databricks_service principal to manage service principals


    :param _builtins.str acl_principal_id: identifier for use in databricks_access_control_rule_set, e.g. `servicePrincipals/00000000-0000-0000-0000-000000000000`.
    :param _builtins.bool active: Whether service principal is active or not.
    :param _builtins.str application_id: Application ID of the service principal. The service principal must exist before this resource can be retrieved.
    :param _builtins.str display_name: Exact display name of the service principal. The service principal must exist before this resource can be retrieved.  In case if there are several service principals with the same name, an error is thrown.
    :param _builtins.str external_id: ID of the service principal in an external identity provider.
    :param _builtins.str home: Home folder of the service principal, e.g. `/Users/11111111-2222-3333-4444-555666777888`.
    :param _builtins.str id: The id of the service principal (SCIM ID).
    :param _builtins.str repos: Repos location of the service principal, e.g. `/Repos/11111111-2222-3333-4444-555666777888`.
    :param _builtins.str scim_id: Unique SCIM ID for a service principal in the Databricks workspace. The service principal must exist before this resource can be retrieved.
    """
    __args__ = dict()
    __args__['aclPrincipalId'] = acl_principal_id
    __args__['active'] = active
    __args__['applicationId'] = application_id
    __args__['displayName'] = display_name
    __args__['externalId'] = external_id
    __args__['home'] = home
    __args__['id'] = id
    __args__['repos'] = repos
    __args__['scimId'] = scim_id
    __args__['spId'] = sp_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getServicePrincipal:getServicePrincipal', __args__, opts=opts, typ=GetServicePrincipalResult)
    return __ret__.apply(lambda __response__: GetServicePrincipalResult(
        acl_principal_id=pulumi.get(__response__, 'acl_principal_id'),
        active=pulumi.get(__response__, 'active'),
        application_id=pulumi.get(__response__, 'application_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        external_id=pulumi.get(__response__, 'external_id'),
        home=pulumi.get(__response__, 'home'),
        id=pulumi.get(__response__, 'id'),
        repos=pulumi.get(__response__, 'repos'),
        scim_id=pulumi.get(__response__, 'scim_id'),
        sp_id=pulumi.get(__response__, 'sp_id')))
