# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MwsNetworkConnectivityConfigArgs', 'MwsNetworkConnectivityConfig']

@pulumi.input_type
class MwsNetworkConnectivityConfigArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_config: Optional[pulumi.Input['MwsNetworkConnectivityConfigEgressConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a MwsNetworkConnectivityConfig resource.
        :param pulumi.Input[_builtins.str] region: Region of the Network Connectivity Config. NCCs can only be referenced by your workspaces in the same region. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.int] creation_time: time in epoch milliseconds when this object was created.
        :param pulumi.Input['MwsNetworkConnectivityConfigEgressConfigArgs'] egress_config: block containing information about network connectivity rules that apply to network traffic from your serverless compute resources. Consists of the following fields:
        :param pulumi.Input[_builtins.str] name: Name of the network connectivity configuration. The name can contain alphanumeric characters, hyphens, and underscores. The length must be between 3 and 30 characters. The name must match the regular expression `^[0-9a-zA-Z-_]{3,30}$`. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account
        :param pulumi.Input[_builtins.int] updated_time: time in epoch milliseconds when this object was updated.
        """
        pulumi.set(__self__, "region", region)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if egress_config is not None:
            pulumi.set(__self__, "egress_config", egress_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connectivity_config_id is not None:
            pulumi.set(__self__, "network_connectivity_config_id", network_connectivity_config_id)
        if updated_time is not None:
            pulumi.set(__self__, "updated_time", updated_time)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        Region of the Network Connectivity Config. NCCs can only be referenced by your workspaces in the same region. Change forces creation of a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        time in epoch milliseconds when this object was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="egressConfig")
    def egress_config(self) -> Optional[pulumi.Input['MwsNetworkConnectivityConfigEgressConfigArgs']]:
        """
        block containing information about network connectivity rules that apply to network traffic from your serverless compute resources. Consists of the following fields:
        """
        return pulumi.get(self, "egress_config")

    @egress_config.setter
    def egress_config(self, value: Optional[pulumi.Input['MwsNetworkConnectivityConfigEgressConfigArgs']]):
        pulumi.set(self, "egress_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the network connectivity configuration. The name can contain alphanumeric characters, hyphens, and underscores. The length must be between 3 and 30 characters. The name must match the regular expression `^[0-9a-zA-Z-_]{3,30}$`. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @network_connectivity_config_id.setter
    def network_connectivity_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_connectivity_config_id", value)

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        time in epoch milliseconds when this object was updated.
        """
        return pulumi.get(self, "updated_time")

    @updated_time.setter
    def updated_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated_time", value)


@pulumi.input_type
class _MwsNetworkConnectivityConfigState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_config: Optional[pulumi.Input['MwsNetworkConnectivityConfigEgressConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering MwsNetworkConnectivityConfig resources.
        :param pulumi.Input[_builtins.int] creation_time: time in epoch milliseconds when this object was created.
        :param pulumi.Input['MwsNetworkConnectivityConfigEgressConfigArgs'] egress_config: block containing information about network connectivity rules that apply to network traffic from your serverless compute resources. Consists of the following fields:
        :param pulumi.Input[_builtins.str] name: Name of the network connectivity configuration. The name can contain alphanumeric characters, hyphens, and underscores. The length must be between 3 and 30 characters. The name must match the regular expression `^[0-9a-zA-Z-_]{3,30}$`. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account
        :param pulumi.Input[_builtins.str] region: Region of the Network Connectivity Config. NCCs can only be referenced by your workspaces in the same region. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.int] updated_time: time in epoch milliseconds when this object was updated.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if egress_config is not None:
            pulumi.set(__self__, "egress_config", egress_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connectivity_config_id is not None:
            pulumi.set(__self__, "network_connectivity_config_id", network_connectivity_config_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if updated_time is not None:
            pulumi.set(__self__, "updated_time", updated_time)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        time in epoch milliseconds when this object was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="egressConfig")
    def egress_config(self) -> Optional[pulumi.Input['MwsNetworkConnectivityConfigEgressConfigArgs']]:
        """
        block containing information about network connectivity rules that apply to network traffic from your serverless compute resources. Consists of the following fields:
        """
        return pulumi.get(self, "egress_config")

    @egress_config.setter
    def egress_config(self, value: Optional[pulumi.Input['MwsNetworkConnectivityConfigEgressConfigArgs']]):
        pulumi.set(self, "egress_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the network connectivity configuration. The name can contain alphanumeric characters, hyphens, and underscores. The length must be between 3 and 30 characters. The name must match the regular expression `^[0-9a-zA-Z-_]{3,30}$`. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @network_connectivity_config_id.setter
    def network_connectivity_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_connectivity_config_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region of the Network Connectivity Config. NCCs can only be referenced by your workspaces in the same region. Change forces creation of a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        time in epoch milliseconds when this object was updated.
        """
        return pulumi.get(self, "updated_time")

    @updated_time.setter
    def updated_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated_time", value)


@pulumi.type_token("databricks:index/mwsNetworkConnectivityConfig:MwsNetworkConnectivityConfig")
class MwsNetworkConnectivityConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_config: Optional[pulumi.Input[Union['MwsNetworkConnectivityConfigEgressConfigArgs', 'MwsNetworkConnectivityConfigEgressConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Allows you to create a Network Connectivity Config that can be used as part of a MwsWorkspaces resource to create a [Databricks Workspace that leverages serverless network connectivity configs](https://learn.microsoft.com/en-us/azure/databricks/security/network/serverless-network-security/serverless-firewall).

        > This resource can only be used with an account-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        region = config.require_object("region")
        prefix = config.require_object("prefix")
        ncc = databricks.MwsNetworkConnectivityConfig("ncc",
            name=f"ncc-for-{prefix}",
            region=region)
        ncc_binding = databricks.MwsNccBinding("ncc_binding",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            workspace_id=databricks_workspace_id)
        ```

        ## Related Resources

        The following resources are used in the context:

        * MwsWorkspaces to set up Databricks workspaces.
        * MwsNccBinding to attach an NCC to a workspace.
        * MwsNccPrivateEndpointRule to create a private endpoint rule.

        ## Import

        This resource can be imported by Databricks account ID and Network Connectivity Config ID.

        hcl

        import {

          to = databricks_mws_network_connectivity_config.this

          id = "<account_id>/<network_connectivity_config_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/mwsNetworkConnectivityConfig:MwsNetworkConnectivityConfig this "<account_id>/<network_connectivity_config_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] creation_time: time in epoch milliseconds when this object was created.
        :param pulumi.Input[Union['MwsNetworkConnectivityConfigEgressConfigArgs', 'MwsNetworkConnectivityConfigEgressConfigArgsDict']] egress_config: block containing information about network connectivity rules that apply to network traffic from your serverless compute resources. Consists of the following fields:
        :param pulumi.Input[_builtins.str] name: Name of the network connectivity configuration. The name can contain alphanumeric characters, hyphens, and underscores. The length must be between 3 and 30 characters. The name must match the regular expression `^[0-9a-zA-Z-_]{3,30}$`. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account
        :param pulumi.Input[_builtins.str] region: Region of the Network Connectivity Config. NCCs can only be referenced by your workspaces in the same region. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.int] updated_time: time in epoch milliseconds when this object was updated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MwsNetworkConnectivityConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows you to create a Network Connectivity Config that can be used as part of a MwsWorkspaces resource to create a [Databricks Workspace that leverages serverless network connectivity configs](https://learn.microsoft.com/en-us/azure/databricks/security/network/serverless-network-security/serverless-firewall).

        > This resource can only be used with an account-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        region = config.require_object("region")
        prefix = config.require_object("prefix")
        ncc = databricks.MwsNetworkConnectivityConfig("ncc",
            name=f"ncc-for-{prefix}",
            region=region)
        ncc_binding = databricks.MwsNccBinding("ncc_binding",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            workspace_id=databricks_workspace_id)
        ```

        ## Related Resources

        The following resources are used in the context:

        * MwsWorkspaces to set up Databricks workspaces.
        * MwsNccBinding to attach an NCC to a workspace.
        * MwsNccPrivateEndpointRule to create a private endpoint rule.

        ## Import

        This resource can be imported by Databricks account ID and Network Connectivity Config ID.

        hcl

        import {

          to = databricks_mws_network_connectivity_config.this

          id = "<account_id>/<network_connectivity_config_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/mwsNetworkConnectivityConfig:MwsNetworkConnectivityConfig this "<account_id>/<network_connectivity_config_id>"
        ```

        :param str resource_name: The name of the resource.
        :param MwsNetworkConnectivityConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MwsNetworkConnectivityConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_config: Optional[pulumi.Input[Union['MwsNetworkConnectivityConfigEgressConfigArgs', 'MwsNetworkConnectivityConfigEgressConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MwsNetworkConnectivityConfigArgs.__new__(MwsNetworkConnectivityConfigArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["creation_time"] = creation_time
            __props__.__dict__["egress_config"] = egress_config
            __props__.__dict__["name"] = name
            __props__.__dict__["network_connectivity_config_id"] = network_connectivity_config_id
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["updated_time"] = updated_time
        super(MwsNetworkConnectivityConfig, __self__).__init__(
            'databricks:index/mwsNetworkConnectivityConfig:MwsNetworkConnectivityConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            creation_time: Optional[pulumi.Input[_builtins.int]] = None,
            egress_config: Optional[pulumi.Input[Union['MwsNetworkConnectivityConfigEgressConfigArgs', 'MwsNetworkConnectivityConfigEgressConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_connectivity_config_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            updated_time: Optional[pulumi.Input[_builtins.int]] = None) -> 'MwsNetworkConnectivityConfig':
        """
        Get an existing MwsNetworkConnectivityConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] creation_time: time in epoch milliseconds when this object was created.
        :param pulumi.Input[Union['MwsNetworkConnectivityConfigEgressConfigArgs', 'MwsNetworkConnectivityConfigEgressConfigArgsDict']] egress_config: block containing information about network connectivity rules that apply to network traffic from your serverless compute resources. Consists of the following fields:
        :param pulumi.Input[_builtins.str] name: Name of the network connectivity configuration. The name can contain alphanumeric characters, hyphens, and underscores. The length must be between 3 and 30 characters. The name must match the regular expression `^[0-9a-zA-Z-_]{3,30}$`. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account
        :param pulumi.Input[_builtins.str] region: Region of the Network Connectivity Config. NCCs can only be referenced by your workspaces in the same region. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.int] updated_time: time in epoch milliseconds when this object was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MwsNetworkConnectivityConfigState.__new__(_MwsNetworkConnectivityConfigState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["egress_config"] = egress_config
        __props__.__dict__["name"] = name
        __props__.__dict__["network_connectivity_config_id"] = network_connectivity_config_id
        __props__.__dict__["region"] = region
        __props__.__dict__["updated_time"] = updated_time
        return MwsNetworkConnectivityConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.int]:
        """
        time in epoch milliseconds when this object was created.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="egressConfig")
    def egress_config(self) -> pulumi.Output['outputs.MwsNetworkConnectivityConfigEgressConfig']:
        """
        block containing information about network connectivity rules that apply to network traffic from your serverless compute resources. Consists of the following fields:
        """
        return pulumi.get(self, "egress_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the network connectivity configuration. The name can contain alphanumeric characters, hyphens, and underscores. The length must be between 3 and 30 characters. The name must match the regular expression `^[0-9a-zA-Z-_]{3,30}$`. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> pulumi.Output[_builtins.str]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region of the Network Connectivity Config. NCCs can only be referenced by your workspaces in the same region. Change forces creation of a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> pulumi.Output[_builtins.int]:
        """
        time in epoch milliseconds when this object was updated.
        """
        return pulumi.get(self, "updated_time")

