# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotificationDestinationArgs', 'NotificationDestination']

@pulumi.input_type
class NotificationDestinationArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 config: Optional[pulumi.Input['NotificationDestinationConfigArgs']] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NotificationDestination resource.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Notification Destination.
        :param pulumi.Input['NotificationDestinationConfigArgs'] config: The configuration of the Notification Destination. It must contain exactly one of the following blocks:
        :param pulumi.Input[_builtins.str] destination_type: the type of Notification Destination.
        """
        pulumi.set(__self__, "display_name", display_name)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the Notification Destination.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['NotificationDestinationConfigArgs']]:
        """
        The configuration of the Notification Destination. It must contain exactly one of the following blocks:
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['NotificationDestinationConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the type of Notification Destination.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_type", value)


@pulumi.input_type
class _NotificationDestinationState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['NotificationDestinationConfigArgs']] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NotificationDestination resources.
        :param pulumi.Input['NotificationDestinationConfigArgs'] config: The configuration of the Notification Destination. It must contain exactly one of the following blocks:
        :param pulumi.Input[_builtins.str] destination_type: the type of Notification Destination.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Notification Destination.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['NotificationDestinationConfigArgs']]:
        """
        The configuration of the Notification Destination. It must contain exactly one of the following blocks:
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['NotificationDestinationConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the type of Notification Destination.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_type", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the Notification Destination.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)


@pulumi.type_token("databricks:index/notificationDestination:NotificationDestination")
class NotificationDestination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['NotificationDestinationConfigArgs', 'NotificationDestinationConfigArgsDict']]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to manage [Notification Destinations](https://docs.databricks.com/api/workspace/notificationdestinations). Notification destinations are used to send notifications for query alerts and jobs to destinations outside of Databricks. Only workspace admins can create, update, and delete notification destinations.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        `Email` notification destination:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ndresource = databricks.NotificationDestination("ndresource",
            display_name="Notification Destination",
            config={
                "email": {
                    "addresses": ["abc@gmail.com"],
                },
            })
        ```
        `Slack` notification destination:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ndresource = databricks.NotificationDestination("ndresource",
            display_name="Notification Destination",
            config={
                "slack": {
                    "url": "https://hooks.slack.com/services/...",
                },
            })
        ```
        `PagerDuty` notification destination:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ndresource = databricks.NotificationDestination("ndresource",
            display_name="Notification Destination",
            config={
                "pagerduty": {
                    "integration_key": "xxxxxx",
                },
            })
        ```
        `Microsoft Teams` notification destination:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ndresource = databricks.NotificationDestination("ndresource",
            display_name="Notification Destination",
            config={
                "microsoft_teams": {
                    "url": "https://outlook.office.com/webhook/...",
                },
            })
        ```
        `Generic Webhook` notification destination:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ndresource = databricks.NotificationDestination("ndresource",
            display_name="Notification Destination",
            config={
                "generic_webhook": {
                    "url": "https://example.com/webhook",
                    "username": "username",
                    "password": "password",
                },
            })
        ```

        ## Import

        This resource can be imported by notification ID:

        hcl

        import {

          to = databricks_notification_destination.this

          id = "<notification-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/notificationDestination:NotificationDestination this <notification-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NotificationDestinationConfigArgs', 'NotificationDestinationConfigArgsDict']] config: The configuration of the Notification Destination. It must contain exactly one of the following blocks:
        :param pulumi.Input[_builtins.str] destination_type: the type of Notification Destination.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Notification Destination.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationDestinationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage [Notification Destinations](https://docs.databricks.com/api/workspace/notificationdestinations). Notification destinations are used to send notifications for query alerts and jobs to destinations outside of Databricks. Only workspace admins can create, update, and delete notification destinations.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        `Email` notification destination:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ndresource = databricks.NotificationDestination("ndresource",
            display_name="Notification Destination",
            config={
                "email": {
                    "addresses": ["abc@gmail.com"],
                },
            })
        ```
        `Slack` notification destination:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ndresource = databricks.NotificationDestination("ndresource",
            display_name="Notification Destination",
            config={
                "slack": {
                    "url": "https://hooks.slack.com/services/...",
                },
            })
        ```
        `PagerDuty` notification destination:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ndresource = databricks.NotificationDestination("ndresource",
            display_name="Notification Destination",
            config={
                "pagerduty": {
                    "integration_key": "xxxxxx",
                },
            })
        ```
        `Microsoft Teams` notification destination:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ndresource = databricks.NotificationDestination("ndresource",
            display_name="Notification Destination",
            config={
                "microsoft_teams": {
                    "url": "https://outlook.office.com/webhook/...",
                },
            })
        ```
        `Generic Webhook` notification destination:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ndresource = databricks.NotificationDestination("ndresource",
            display_name="Notification Destination",
            config={
                "generic_webhook": {
                    "url": "https://example.com/webhook",
                    "username": "username",
                    "password": "password",
                },
            })
        ```

        ## Import

        This resource can be imported by notification ID:

        hcl

        import {

          to = databricks_notification_destination.this

          id = "<notification-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/notificationDestination:NotificationDestination this <notification-id>
        ```

        :param str resource_name: The name of the resource.
        :param NotificationDestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationDestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['NotificationDestinationConfigArgs', 'NotificationDestinationConfigArgsDict']]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationDestinationArgs.__new__(NotificationDestinationArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["destination_type"] = destination_type
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
        super(NotificationDestination, __self__).__init__(
            'databricks:index/notificationDestination:NotificationDestination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['NotificationDestinationConfigArgs', 'NotificationDestinationConfigArgsDict']]] = None,
            destination_type: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'NotificationDestination':
        """
        Get an existing NotificationDestination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NotificationDestinationConfigArgs', 'NotificationDestinationConfigArgsDict']] config: The configuration of the Notification Destination. It must contain exactly one of the following blocks:
        :param pulumi.Input[_builtins.str] destination_type: the type of Notification Destination.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Notification Destination.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationDestinationState.__new__(_NotificationDestinationState)

        __props__.__dict__["config"] = config
        __props__.__dict__["destination_type"] = destination_type
        __props__.__dict__["display_name"] = display_name
        return NotificationDestination(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional['outputs.NotificationDestinationConfig']]:
        """
        The configuration of the Notification Destination. It must contain exactly one of the following blocks:
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Output[_builtins.str]:
        """
        the type of Notification Destination.
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the Notification Destination.
        """
        return pulumi.get(self, "display_name")

