# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PermissionsArgs', 'Permissions']

@pulumi.input_type
class PermissionsArgs:
    def __init__(__self__, *,
                 access_controls: pulumi.Input[Sequence[pulumi.Input['PermissionsAccessControlArgs']]],
                 alert_v2_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_path: Optional[pulumi.Input[_builtins.str]] = None,
                 experiment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook_path: Optional[pulumi.Input[_builtins.str]] = None,
                 object_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 registered_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_path: Optional[pulumi.Input[_builtins.str]] = None,
                 serving_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_alert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vector_search_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_file_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_file_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Permissions resource.
        :param pulumi.Input[_builtins.str] object_type: type of permissions.
        """
        pulumi.set(__self__, "access_controls", access_controls)
        if alert_v2_id is not None:
            pulumi.set(__self__, "alert_v2_id", alert_v2_id)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_policy_id is not None:
            pulumi.set(__self__, "cluster_policy_id", cluster_policy_id)
        if dashboard_id is not None:
            pulumi.set(__self__, "dashboard_id", dashboard_id)
        if database_instance_name is not None:
            pulumi.set(__self__, "database_instance_name", database_instance_name)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if directory_path is not None:
            pulumi.set(__self__, "directory_path", directory_path)
        if experiment_id is not None:
            pulumi.set(__self__, "experiment_id", experiment_id)
        if instance_pool_id is not None:
            pulumi.set(__self__, "instance_pool_id", instance_pool_id)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if notebook_id is not None:
            pulumi.set(__self__, "notebook_id", notebook_id)
        if notebook_path is not None:
            pulumi.set(__self__, "notebook_path", notebook_path)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if registered_model_id is not None:
            pulumi.set(__self__, "registered_model_id", registered_model_id)
        if repo_id is not None:
            pulumi.set(__self__, "repo_id", repo_id)
        if repo_path is not None:
            pulumi.set(__self__, "repo_path", repo_path)
        if serving_endpoint_id is not None:
            pulumi.set(__self__, "serving_endpoint_id", serving_endpoint_id)
        if sql_alert_id is not None:
            pulumi.set(__self__, "sql_alert_id", sql_alert_id)
        if sql_dashboard_id is not None:
            pulumi.set(__self__, "sql_dashboard_id", sql_dashboard_id)
        if sql_endpoint_id is not None:
            pulumi.set(__self__, "sql_endpoint_id", sql_endpoint_id)
        if sql_query_id is not None:
            pulumi.set(__self__, "sql_query_id", sql_query_id)
        if vector_search_endpoint_id is not None:
            pulumi.set(__self__, "vector_search_endpoint_id", vector_search_endpoint_id)
        if workspace_file_id is not None:
            pulumi.set(__self__, "workspace_file_id", workspace_file_id)
        if workspace_file_path is not None:
            pulumi.set(__self__, "workspace_file_path", workspace_file_path)

    @_builtins.property
    @pulumi.getter(name="accessControls")
    def access_controls(self) -> pulumi.Input[Sequence[pulumi.Input['PermissionsAccessControlArgs']]]:
        return pulumi.get(self, "access_controls")

    @access_controls.setter
    def access_controls(self, value: pulumi.Input[Sequence[pulumi.Input['PermissionsAccessControlArgs']]]):
        pulumi.set(self, "access_controls", value)

    @_builtins.property
    @pulumi.getter(name="alertV2Id")
    def alert_v2_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "alert_v2_id")

    @alert_v2_id.setter
    def alert_v2_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_v2_id", value)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterPolicyId")
    def cluster_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_policy_id")

    @cluster_policy_id.setter
    def cluster_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dashboard_id")

    @dashboard_id.setter
    def dashboard_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dashboard_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseInstanceName")
    def database_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "database_instance_name")

    @database_instance_name.setter
    def database_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="directoryPath")
    def directory_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "directory_path")

    @directory_path.setter
    def directory_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_path", value)

    @_builtins.property
    @pulumi.getter(name="experimentId")
    def experiment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "experiment_id")

    @experiment_id.setter
    def experiment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "experiment_id", value)

    @_builtins.property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "instance_pool_id")

    @instance_pool_id.setter
    def instance_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="notebookId")
    def notebook_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "notebook_id")

    @notebook_id.setter
    def notebook_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notebook_id", value)

    @_builtins.property
    @pulumi.getter(name="notebookPath")
    def notebook_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "notebook_path")

    @notebook_path.setter
    def notebook_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notebook_path", value)

    @_builtins.property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of permissions.
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_type", value)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter(name="registeredModelId")
    def registered_model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "registered_model_id")

    @registered_model_id.setter
    def registered_model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registered_model_id", value)

    @_builtins.property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "repo_id")

    @repo_id.setter
    def repo_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_id", value)

    @_builtins.property
    @pulumi.getter(name="repoPath")
    def repo_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "repo_path")

    @repo_path.setter
    def repo_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_path", value)

    @_builtins.property
    @pulumi.getter(name="servingEndpointId")
    def serving_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "serving_endpoint_id")

    @serving_endpoint_id.setter
    def serving_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serving_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="sqlAlertId")
    def sql_alert_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sql_alert_id")

    @sql_alert_id.setter
    def sql_alert_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_alert_id", value)

    @_builtins.property
    @pulumi.getter(name="sqlDashboardId")
    def sql_dashboard_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sql_dashboard_id")

    @sql_dashboard_id.setter
    def sql_dashboard_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_dashboard_id", value)

    @_builtins.property
    @pulumi.getter(name="sqlEndpointId")
    def sql_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sql_endpoint_id")

    @sql_endpoint_id.setter
    def sql_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="sqlQueryId")
    def sql_query_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sql_query_id")

    @sql_query_id.setter
    def sql_query_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_query_id", value)

    @_builtins.property
    @pulumi.getter(name="vectorSearchEndpointId")
    def vector_search_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vector_search_endpoint_id")

    @vector_search_endpoint_id.setter
    def vector_search_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vector_search_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceFileId")
    def workspace_file_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "workspace_file_id")

    @workspace_file_id.setter
    def workspace_file_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_file_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceFilePath")
    def workspace_file_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "workspace_file_path")

    @workspace_file_path.setter
    def workspace_file_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_file_path", value)


@pulumi.input_type
class _PermissionsState:
    def __init__(__self__, *,
                 access_controls: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionsAccessControlArgs']]]] = None,
                 alert_v2_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_path: Optional[pulumi.Input[_builtins.str]] = None,
                 experiment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook_path: Optional[pulumi.Input[_builtins.str]] = None,
                 object_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 registered_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_path: Optional[pulumi.Input[_builtins.str]] = None,
                 serving_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_alert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vector_search_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_file_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_file_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Permissions resources.
        :param pulumi.Input[_builtins.str] object_type: type of permissions.
        """
        if access_controls is not None:
            pulumi.set(__self__, "access_controls", access_controls)
        if alert_v2_id is not None:
            pulumi.set(__self__, "alert_v2_id", alert_v2_id)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_policy_id is not None:
            pulumi.set(__self__, "cluster_policy_id", cluster_policy_id)
        if dashboard_id is not None:
            pulumi.set(__self__, "dashboard_id", dashboard_id)
        if database_instance_name is not None:
            pulumi.set(__self__, "database_instance_name", database_instance_name)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if directory_path is not None:
            pulumi.set(__self__, "directory_path", directory_path)
        if experiment_id is not None:
            pulumi.set(__self__, "experiment_id", experiment_id)
        if instance_pool_id is not None:
            pulumi.set(__self__, "instance_pool_id", instance_pool_id)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if notebook_id is not None:
            pulumi.set(__self__, "notebook_id", notebook_id)
        if notebook_path is not None:
            pulumi.set(__self__, "notebook_path", notebook_path)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if registered_model_id is not None:
            pulumi.set(__self__, "registered_model_id", registered_model_id)
        if repo_id is not None:
            pulumi.set(__self__, "repo_id", repo_id)
        if repo_path is not None:
            pulumi.set(__self__, "repo_path", repo_path)
        if serving_endpoint_id is not None:
            pulumi.set(__self__, "serving_endpoint_id", serving_endpoint_id)
        if sql_alert_id is not None:
            pulumi.set(__self__, "sql_alert_id", sql_alert_id)
        if sql_dashboard_id is not None:
            pulumi.set(__self__, "sql_dashboard_id", sql_dashboard_id)
        if sql_endpoint_id is not None:
            pulumi.set(__self__, "sql_endpoint_id", sql_endpoint_id)
        if sql_query_id is not None:
            pulumi.set(__self__, "sql_query_id", sql_query_id)
        if vector_search_endpoint_id is not None:
            pulumi.set(__self__, "vector_search_endpoint_id", vector_search_endpoint_id)
        if workspace_file_id is not None:
            pulumi.set(__self__, "workspace_file_id", workspace_file_id)
        if workspace_file_path is not None:
            pulumi.set(__self__, "workspace_file_path", workspace_file_path)

    @_builtins.property
    @pulumi.getter(name="accessControls")
    def access_controls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PermissionsAccessControlArgs']]]]:
        return pulumi.get(self, "access_controls")

    @access_controls.setter
    def access_controls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionsAccessControlArgs']]]]):
        pulumi.set(self, "access_controls", value)

    @_builtins.property
    @pulumi.getter(name="alertV2Id")
    def alert_v2_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "alert_v2_id")

    @alert_v2_id.setter
    def alert_v2_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_v2_id", value)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterPolicyId")
    def cluster_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_policy_id")

    @cluster_policy_id.setter
    def cluster_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dashboard_id")

    @dashboard_id.setter
    def dashboard_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dashboard_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseInstanceName")
    def database_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "database_instance_name")

    @database_instance_name.setter
    def database_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="directoryPath")
    def directory_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "directory_path")

    @directory_path.setter
    def directory_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_path", value)

    @_builtins.property
    @pulumi.getter(name="experimentId")
    def experiment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "experiment_id")

    @experiment_id.setter
    def experiment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "experiment_id", value)

    @_builtins.property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "instance_pool_id")

    @instance_pool_id.setter
    def instance_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="notebookId")
    def notebook_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "notebook_id")

    @notebook_id.setter
    def notebook_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notebook_id", value)

    @_builtins.property
    @pulumi.getter(name="notebookPath")
    def notebook_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "notebook_path")

    @notebook_path.setter
    def notebook_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notebook_path", value)

    @_builtins.property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of permissions.
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_type", value)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter(name="registeredModelId")
    def registered_model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "registered_model_id")

    @registered_model_id.setter
    def registered_model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registered_model_id", value)

    @_builtins.property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "repo_id")

    @repo_id.setter
    def repo_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_id", value)

    @_builtins.property
    @pulumi.getter(name="repoPath")
    def repo_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "repo_path")

    @repo_path.setter
    def repo_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_path", value)

    @_builtins.property
    @pulumi.getter(name="servingEndpointId")
    def serving_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "serving_endpoint_id")

    @serving_endpoint_id.setter
    def serving_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serving_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="sqlAlertId")
    def sql_alert_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sql_alert_id")

    @sql_alert_id.setter
    def sql_alert_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_alert_id", value)

    @_builtins.property
    @pulumi.getter(name="sqlDashboardId")
    def sql_dashboard_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sql_dashboard_id")

    @sql_dashboard_id.setter
    def sql_dashboard_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_dashboard_id", value)

    @_builtins.property
    @pulumi.getter(name="sqlEndpointId")
    def sql_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sql_endpoint_id")

    @sql_endpoint_id.setter
    def sql_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="sqlQueryId")
    def sql_query_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sql_query_id")

    @sql_query_id.setter
    def sql_query_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_query_id", value)

    @_builtins.property
    @pulumi.getter(name="vectorSearchEndpointId")
    def vector_search_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vector_search_endpoint_id")

    @vector_search_endpoint_id.setter
    def vector_search_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vector_search_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceFileId")
    def workspace_file_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "workspace_file_id")

    @workspace_file_id.setter
    def workspace_file_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_file_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceFilePath")
    def workspace_file_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "workspace_file_path")

    @workspace_file_path.setter
    def workspace_file_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_file_path", value)


@pulumi.type_token("databricks:index/permissions:Permissions")
class Permissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_controls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PermissionsAccessControlArgs', 'PermissionsAccessControlArgsDict']]]]] = None,
                 alert_v2_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_path: Optional[pulumi.Input[_builtins.str]] = None,
                 experiment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook_path: Optional[pulumi.Input[_builtins.str]] = None,
                 object_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 registered_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_path: Optional[pulumi.Input[_builtins.str]] = None,
                 serving_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_alert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vector_search_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_file_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to generically manage [access control](https://docs.databricks.com/security/access-control/index.html) in Databricks workspaces. It ensures that only _admins_, _authenticated principal_ and those declared within `access_control` blocks would have specified access. It is not possible to remove management rights from _admins_ group.

        > This resource can only be used with a workspace-level provider!

        > This resource is _authoritative_ for permissions on objects. Configuring this resource for an object will **OVERWRITE** any existing permissions of the same type unless imported, and changes made outside of Pulumi will be reset.

        > It is not possible to lower permissions for `admins`, so Databricks Pulumi Provider removes those `access_control` blocks automatically.

        > If multiple permission levels are specified for an identity (e.g. `CAN_RESTART` and `CAN_MANAGE` for a cluster), only the highest level permission is returned and will cause permanent drift.

        > To manage access control on service principals, use databricks_access_control_rule_set.

        ## Cluster usage

        It's possible to separate [cluster access control](https://docs.databricks.com/security/access-control/cluster-acl.html) to three different permission levels: `CAN_ATTACH_TO`, `CAN_RESTART` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        ds = databricks.Group("ds", display_name="Data Science")
        latest = databricks.get_spark_version()
        smallest = databricks.get_node_type(local_disk=True)
        shared_autoscaling = databricks.Cluster("shared_autoscaling",
            cluster_name="Shared Autoscaling",
            spark_version=latest.id,
            node_type_id=smallest.id,
            autotermination_minutes=60,
            autoscale={
                "min_workers": 1,
                "max_workers": 10,
            })
        cluster_usage = databricks.Permissions("cluster_usage",
            cluster_id=shared_autoscaling.id,
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_ATTACH_TO",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_RESTART",
                },
                {
                    "group_name": ds.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Cluster Policy usage

        Cluster policies allow creation of clusters, that match [given policy](https://docs.databricks.com/administration-guide/clusters/policies.html). It's possible to assign `CAN_USE` permission to users and groups:

        ```python
        import pulumi
        import json
        import pulumi_databricks as databricks

        ds = databricks.Group("ds", display_name="Data Science")
        eng = databricks.Group("eng", display_name="Engineering")
        something_simple = databricks.ClusterPolicy("something_simple",
            name="Some simple policy",
            definition=json.dumps({
                "spark_conf.spark.hadoop.javax.jdo.option.ConnectionURL": {
                    "type": "forbidden",
                },
                "spark_conf.spark.secondkey": {
                    "type": "forbidden",
                },
            }))
        policy_usage = databricks.Permissions("policy_usage",
            cluster_policy_id=something_simple.id,
            access_controls=[
                {
                    "group_name": ds.display_name,
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_USE",
                },
            ])
        ```

        ## Instance Pool usage

        Instance Pools access control [allows to](https://docs.databricks.com/security/access-control/pool-acl.html) assign `CAN_ATTACH_TO` and `CAN_MANAGE` permissions to users, service principals, and groups. It's also possible to grant creation of Instance Pools to individual groups and users, service principals.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        smallest = databricks.get_node_type(local_disk=True)
        this = databricks.InstancePool("this",
            instance_pool_name="Reserved Instances",
            idle_instance_autotermination_minutes=60,
            node_type_id=smallest.id,
            min_idle_instances=0,
            max_capacity=10)
        pool_usage = databricks.Permissions("pool_usage",
            instance_pool_id=this.id,
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_ATTACH_TO",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Job usage

        There are four assignable [permission levels](https://docs.databricks.com/security/access-control/jobs-acl.html#job-permissions) for databricks_job: `CAN_VIEW`, `CAN_MANAGE_RUN`, `IS_OWNER`, and `CAN_MANAGE`. Admins are granted the `CAN_MANAGE` permission by default, and they can assign that permission to non-admin users, and service principals.

        - The creator of a job has `IS_OWNER` permission. Destroying `Permissions` resource for a job would revert ownership to the creator.
        - A job must have exactly one owner. If a resource is changed and no owner is specified, the currently authenticated principal would become the new owner of the job. Nothing would change, per se, if the job was created through Pulumi.
        - A job cannot have a group as an owner.
        - Jobs triggered through _Run Now_ assume the permissions of the job owner and not the user, and service principal who issued Run Now.
        - Read [main documentation](https://docs.databricks.com/security/access-control/jobs-acl.html) for additional detail.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        aws_principal = databricks.ServicePrincipal("aws_principal", display_name="main")
        latest = databricks.get_spark_version()
        smallest = databricks.get_node_type(local_disk=True)
        this = databricks.Job("this",
            name="Featurization",
            max_concurrent_runs=1,
            tasks=[{
                "task_key": "task1",
                "new_cluster": {
                    "num_workers": 300,
                    "spark_version": latest.id,
                    "node_type_id": smallest.id,
                },
                "notebook_task": {
                    "notebook_path": "/Production/MakeFeatures",
                },
            }])
        job_usage = databricks.Permissions("job_usage",
            job_id=this.id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_VIEW",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_MANAGE_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
                {
                    "service_principal_name": aws_principal.application_id,
                    "permission_level": "IS_OWNER",
                },
            ])
        ```

        ## Lakeflow Declarative Pipelines usage

        There are four assignable [permission levels](https://docs.databricks.com/aws/en/security/auth/access-control#lakeflow-declarative-pipelines-acls) for databricks_pipeline: `CAN_VIEW`, `CAN_RUN`, `CAN_MANAGE`, and `IS_OWNER`. Admins are granted the `CAN_MANAGE` permission by default, and they can assign that permission to non-admin users, and service principals.

        - The creator of a Lakeflow Declarative Pipeline has `IS_OWNER` permission. Destroying `Permissions` resource for a pipeline would revert ownership to the creator.
        - A Lakeflow Declarative Pipeline must have exactly one owner. If a resource is changed and no owner is specified, the currently authenticated principal would become the new owner of the pipeline. Nothing would change, per se, if the pipeline was created through Pulumi.
        - A Lakeflow Declarative Pipeline cannot have a group as an owner.
        - Lakeflow Declarative Pipelines triggered through _Start_ assume the permissions of the pipeline owner and not the user, and service principal who issued Run Now.
        - Read [main documentation](https://docs.databricks.com/aws/en/security/auth/access-control#lakeflow-declarative-pipelines-acls) for additional detail.

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumi_std as std

        me = databricks.get_current_user()
        eng = databricks.Group("eng", display_name="Engineering")
        ldp_demo = databricks.Notebook("ldp_demo",
            content_base64=std.base64encode(input=\"\"\"import dlt
        json_path = "/databricks-datasets/wikipedia-datasets/data-001/clickstream/raw-uncompressed-json/2015_2_clickstream.json"
        @dlt.table(
           comment="The raw wikipedia clickstream dataset, ingested from /databricks-datasets."
        )
        def clickstream_raw():
            return (spark.read.format("json").load(json_path))
        \"\"\").result,
            language="PYTHON",
            path=f"{me.home}/ldp_demo")
        this = databricks.Pipeline("this",
            name=f"LDP Demo Pipeline ({me.alphanumeric})",
            storage="/test/tf-pipeline",
            configuration={
                "key1": "value1",
                "key2": "value2",
            },
            libraries=[{
                "notebook": {
                    "path": ldp_demo.id,
                },
            }],
            continuous=False,
            filters={
                "includes": ["com.databricks.include"],
                "excludes": ["com.databricks.exclude"],
            })
        ldp_usage = databricks.Permissions("ldp_usage",
            pipeline_id=this.id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_VIEW",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Notebook usage

        Valid [permission levels](https://docs.databricks.com/security/access-control/workspace-acl.html#notebook-permissions) for Notebook are: `CAN_READ`, `CAN_RUN`, `CAN_EDIT`, and `CAN_MANAGE`.

        A notebook could be specified by using either `notebook_path` or `notebook_id` attribute.  The value for the `notebook_id` is the object ID of the resource in the Databricks Workspace that is exposed as `object_id` attribute of the `Notebook` resource as shown below.

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumi_std as std

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        this = databricks.Notebook("this",
            content_base64=std.base64encode(input="# Welcome to your Python notebook").result,
            path="/Production/ETL/Features",
            language="PYTHON")
        notebook_usage_by_path = databricks.Permissions("notebook_usage_by_path",
            notebook_path=this.path,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        notebook_usage_by_id = databricks.Permissions("notebook_usage_by_id",
            notebook_id=this.object_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        > when importing a permissions resource, only the `notebook_id` is filled!

        ## Workspace file usage

        Valid permission levels for WorkspaceFile are: `CAN_READ`, `CAN_RUN`, `CAN_EDIT`, and `CAN_MANAGE`.

        A workspace file could be specified by using either `workspace_file_path` or `workspace_file_id` attribute.  The value for the `workspace_file_id` is the object ID of the resource in the Databricks Workspace that is exposed as `object_id` attribute of the `WorkspaceFile` resource as shown below.

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumi_std as std

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        this = databricks.WorkspaceFile("this",
            content_base64=std.base64encode(input="print('Hello World')").result,
            path="/Production/ETL/Features.py")
        workspace_file_usage_by_path = databricks.Permissions("workspace_file_usage_by_path",
            workspace_file_path=this.path,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        workspace_file_usage_by_id = databricks.Permissions("workspace_file_usage_by_id",
            workspace_file_id=this.object_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        > when importing a permissions resource, only the `workspace_file_id` is filled!

        ## Folder usage

        Valid [permission levels](https://docs.databricks.com/security/access-control/workspace-acl.html#folder-permissions) for folders of Directory are: `CAN_READ`, `CAN_RUN`, `CAN_EDIT`, and `CAN_MANAGE`. Notebooks and experiments in a folder inherit all permissions settings of that folder. For example, a user (or service principal) that has `CAN_RUN` permission on a folder has `CAN_RUN` permission on the notebooks in that folder.

        - All users can list items in the folder without any permissions.
        - All users (or service principals) have `CAN_MANAGE` permission for items in the Workspace > Shared Icon Shared folder. You can grant `CAN_MANAGE` permission to notebooks and folders by moving them to the Shared Icon Shared folder.
        - All users (or service principals) have `CAN_MANAGE` permission for objects the user creates.
        - User home directory - The user (or service principal) has `CAN_MANAGE` permission. All other users (or service principals) can list their directories.

        A folder could be specified by using either `directory_path` or `directory_id` attribute.  The value for the `directory_id` is the object ID of the resource in the Databricks Workspace that is exposed as `object_id` attribute of the `Directory` resource as shown below.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        this = databricks.Directory("this", path="/Production/ETL")
        folder_usage_by_path = databricks.Permissions("folder_usage_by_path",
            directory_path=this.path,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        folder_usage_by_id = databricks.Permissions("folder_usage_by_id",
            directory_id=this.object_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        > when importing a permissions resource, only the `directory_id` is filled!

        ## Repos usage

        Valid [permission levels](https://docs.databricks.com/security/access-control/workspace-acl.html) for Repo are: `CAN_READ`, `CAN_RUN`, `CAN_EDIT`, and `CAN_MANAGE`.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        this = databricks.Repo("this", url="https://github.com/user/demo.git")
        repo_usage = databricks.Permissions("repo_usage",
            repo_id=this.id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        ## MLflow Experiment usage

        Valid [permission levels](https://docs.databricks.com/security/access-control/workspace-acl.html#mlflow-experiment-permissions-1) for MlflowExperiment are: `CAN_READ`, `CAN_EDIT`, and `CAN_MANAGE`.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.get_current_user()
        this = databricks.MlflowExperiment("this",
            name=f"{me.home}/Sample",
            artifact_location="s3://bucket/my-experiment",
            description="My MLflow experiment description")
        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        experiment_usage = databricks.Permissions("experiment_usage",
            experiment_id=this.id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_MANAGE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        ## MLflow Model usage

        Valid [permission levels](https://docs.databricks.com/security/access-control/workspace-acl.html#mlflow-model-permissions-1) for MlflowModel are: `CAN_READ`, `CAN_EDIT`, `CAN_MANAGE_STAGING_VERSIONS`, `CAN_MANAGE_PRODUCTION_VERSIONS`, and `CAN_MANAGE`. You can also manage permissions for all MLflow models by `registered_model_id = "root"`.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.MlflowModel("this", name="SomePredictions")
        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        model_usage = databricks.Permissions("model_usage",
            registered_model_id=this.registered_model_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_MANAGE_PRODUCTION_VERSIONS",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE_STAGING_VERSIONS",
                },
            ])
        ```

        ## Model serving usage

        Valid permission levels for ModelServing are: `CAN_VIEW`, `CAN_QUERY`, and `CAN_MANAGE`.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.ModelServing("this",
            name="tf-test",
            config={
                "served_models": [{
                    "name": "prod_model",
                    "model_name": "test",
                    "model_version": "1",
                    "workload_size": "Small",
                    "scale_to_zero_enabled": True,
                }],
            })
        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        ml_serving_usage = databricks.Permissions("ml_serving_usage",
            serving_endpoint_id=this.serving_endpoint_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_VIEW",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_MANAGE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_QUERY",
                },
            ])
        ```

        ## Mosaic AI Vector Search usage

        Valid permission levels for VectorSearchEndpoint are: `CAN_USE` and `CAN_MANAGE`.

        > You need to use the `endpoint_id` attribute of `VectorSearchEndpoint` as value for `vector_search_endpoint_id`, not the `id`!

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.VectorSearchEndpoint("this",
            name="vector-search-test",
            endpoint_type="STANDARD")
        eng = databricks.Group("eng", display_name="Engineering")
        vector_search_endpoint_usage = databricks.Permissions("vector_search_endpoint_usage",
            vector_search_endpoint_id=this.endpoint_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Passwords usage

        By default on AWS deployments, all admin users can sign in to Databricks using either SSO or their username and password, and all API users can authenticate to the Databricks REST APIs using their username and password. As an admin, you [can limit](https://docs.databricks.com/administration-guide/users-groups/single-sign-on/index.html#optional-configure-password-access-control) admin users' and API users' ability to authenticate with their username and password by configuring `CAN_USE` permissions using password access control.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        guests = databricks.Group("guests", display_name="Guest Users")
        password_usage = databricks.Permissions("password_usage",
            authorization="passwords",
            access_controls=[{
                "group_name": guests.display_name,
                "permission_level": "CAN_USE",
            }])
        ```

        ## Token usage

        It is required to have at least 1 personal access token in the workspace before you can manage tokens permissions.

        !> **Warning** There can be only one `authorization = "tokens"` permissions resource per workspace, otherwise there'll be a permanent configuration drift. After applying changes, users who previously had either `CAN_USE` or `CAN_MANAGE` permission but no longer have either permission have their access to token-based authentication revoked. Their active tokens are immediately deleted (revoked).

        Only [possible permission](https://docs.databricks.com/administration-guide/access-control/tokens.html) to assign to non-admin group is `CAN_USE`, where _admins_ `CAN_MANAGE` all tokens:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        token_usage = databricks.Permissions("token_usage",
            authorization="tokens",
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_USE",
                },
            ])
        ```

        ## SQL warehouse usage

        [SQL warehouses](https://docs.databricks.com/sql/user/security/access-control/sql-endpoint-acl.html) have five possible permissions: `CAN_USE`, `CAN_MONITOR`, `CAN_MANAGE`, `CAN_VIEW` and `IS_OWNER`:

        - The creator of a warehouse has `IS_OWNER` permission. Destroying `Permissions` resource for a warehouse would revert ownership to the creator.
        - A warehouse must have exactly one owner. If a resource is changed and no owner is specified, the currently authenticated principal would become the new owner of the warehouse. Nothing would change, per se, if the warehouse was created through Pulumi.
        - A warehouse cannot have a group as an owner.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.get_current_user()
        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        this = databricks.SqlEndpoint("this",
            name=f"Endpoint of {me.alphanumeric}",
            cluster_size="Small",
            max_num_clusters=1,
            tags={
                "custom_tags": [{
                    "key": "City",
                    "value": "Amsterdam",
                }],
            })
        endpoint_usage = databricks.Permissions("endpoint_usage",
            sql_endpoint_id=this.id,
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Dashboard usage

        [Dashboards](https://docs.databricks.com/en/dashboards/tutorials/manage-permissions.html) have four possible permissions: `CAN_READ`, `CAN_RUN`, `CAN_EDIT` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        dashboard = databricks.Dashboard("dashboard", display_name="TF New Dashboard")
        dashboard_usage = databricks.Permissions("dashboard_usage",
            dashboard_id=dashboard.id,
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Legacy SQL Dashboard usage

        [Legacy SQL dashboards](https://docs.databricks.com/sql/user/security/access-control/dashboard-acl.html) have three possible permissions: `CAN_VIEW`, `CAN_RUN` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        sql_dashboard_usage = databricks.Permissions("sql_dashboard_usage",
            sql_dashboard_id="3244325",
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## SQL Query usage

        [SQL queries](https://docs.databricks.com/sql/user/security/access-control/query-acl.html) have three possible permissions: `CAN_VIEW`, `CAN_RUN` and `CAN_MANAGE`:

        > If you do not define an `access_control` block granting `CAN_MANAGE` explictly for the user calling this provider, Databricks Pulumi Provider will add `CAN_MANAGE` permission for the caller. This is a failsafe to prevent situations where the caller is locked out from making changes to the targeted `SqlQuery` resource when backend API do not apply permission inheritance correctly.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        query_usage = databricks.Permissions("query_usage",
            sql_query_id="3244325",
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## SQL Alert (AlertV2) usage

        [Alert V2](https://docs.databricks.com/sql/user/security/access-control/alert-acl.html) which is the new version of SQL Alert have 4 possible permission levels: `CAN_READ`, `CAN_RUN`, `CAN_EDIT`, and `CAN_MANAGE`.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        app_usage = databricks.Permissions("app_usage",
            alert_v2_id="12345",
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        ## SQL Alert (legacy) usage

        [SQL alerts](https://docs.databricks.com/sql/user/security/access-control/alert-acl.html) have three possible permissions: `CAN_VIEW`, `CAN_RUN` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        alert_usage = databricks.Permissions("alert_usage",
            sql_alert_id="3244325",
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Databricks Apps usage

        [Databricks Apps](https://docs.databricks.com/en/dev-tools/databricks-apps/index.html) have two possible permissions: `CAN_USE` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        eng = databricks.Group("eng", display_name="Engineering")
        app_usage = databricks.Permissions("app_usage",
            app_name="myapp",
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Lakebase Database Instances usage

        [Databricks Lakebase](https://docs.databricks.com/aws/en/oltp/) have two possible permissions: `CAN_USE` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        eng = databricks.Group("eng", display_name="Engineering")
        app_usage = databricks.Permissions("app_usage",
            database_instance_name="my_database",
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Instance Profiles

        Instance Profiles are not managed by General Permissions API and therefore GroupInstanceProfile and UserInstanceProfile should be used to allow usage of specific AWS EC2 IAM roles to users or groups.

        ## Secrets

        One can control access to Secret through `initial_manage_principal` argument on SecretScope or databricks_secret_acl, so that users (or service principals) can `READ`, `WRITE` or `MANAGE` entries within secret scope.

        ## Tables, Views and Databases

        General Permissions API does not apply to access control for tables and they have to be managed separately using the SqlPermissions resource, though you're encouraged to use Unity Catalog or migrate to it.

        ## Data Access with Unity Catalog

        Initially in Unity Catalog all users have no access to data, which has to be later assigned through Grants or Grant resource.

        ## Import

        The resource permissions can be imported using the object id

        ```sh
        $ pulumi import databricks:index/permissions:Permissions databricks_permissions <object type>/<object id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] object_type: type of permissions.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to generically manage [access control](https://docs.databricks.com/security/access-control/index.html) in Databricks workspaces. It ensures that only _admins_, _authenticated principal_ and those declared within `access_control` blocks would have specified access. It is not possible to remove management rights from _admins_ group.

        > This resource can only be used with a workspace-level provider!

        > This resource is _authoritative_ for permissions on objects. Configuring this resource for an object will **OVERWRITE** any existing permissions of the same type unless imported, and changes made outside of Pulumi will be reset.

        > It is not possible to lower permissions for `admins`, so Databricks Pulumi Provider removes those `access_control` blocks automatically.

        > If multiple permission levels are specified for an identity (e.g. `CAN_RESTART` and `CAN_MANAGE` for a cluster), only the highest level permission is returned and will cause permanent drift.

        > To manage access control on service principals, use databricks_access_control_rule_set.

        ## Cluster usage

        It's possible to separate [cluster access control](https://docs.databricks.com/security/access-control/cluster-acl.html) to three different permission levels: `CAN_ATTACH_TO`, `CAN_RESTART` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        ds = databricks.Group("ds", display_name="Data Science")
        latest = databricks.get_spark_version()
        smallest = databricks.get_node_type(local_disk=True)
        shared_autoscaling = databricks.Cluster("shared_autoscaling",
            cluster_name="Shared Autoscaling",
            spark_version=latest.id,
            node_type_id=smallest.id,
            autotermination_minutes=60,
            autoscale={
                "min_workers": 1,
                "max_workers": 10,
            })
        cluster_usage = databricks.Permissions("cluster_usage",
            cluster_id=shared_autoscaling.id,
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_ATTACH_TO",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_RESTART",
                },
                {
                    "group_name": ds.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Cluster Policy usage

        Cluster policies allow creation of clusters, that match [given policy](https://docs.databricks.com/administration-guide/clusters/policies.html). It's possible to assign `CAN_USE` permission to users and groups:

        ```python
        import pulumi
        import json
        import pulumi_databricks as databricks

        ds = databricks.Group("ds", display_name="Data Science")
        eng = databricks.Group("eng", display_name="Engineering")
        something_simple = databricks.ClusterPolicy("something_simple",
            name="Some simple policy",
            definition=json.dumps({
                "spark_conf.spark.hadoop.javax.jdo.option.ConnectionURL": {
                    "type": "forbidden",
                },
                "spark_conf.spark.secondkey": {
                    "type": "forbidden",
                },
            }))
        policy_usage = databricks.Permissions("policy_usage",
            cluster_policy_id=something_simple.id,
            access_controls=[
                {
                    "group_name": ds.display_name,
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_USE",
                },
            ])
        ```

        ## Instance Pool usage

        Instance Pools access control [allows to](https://docs.databricks.com/security/access-control/pool-acl.html) assign `CAN_ATTACH_TO` and `CAN_MANAGE` permissions to users, service principals, and groups. It's also possible to grant creation of Instance Pools to individual groups and users, service principals.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        smallest = databricks.get_node_type(local_disk=True)
        this = databricks.InstancePool("this",
            instance_pool_name="Reserved Instances",
            idle_instance_autotermination_minutes=60,
            node_type_id=smallest.id,
            min_idle_instances=0,
            max_capacity=10)
        pool_usage = databricks.Permissions("pool_usage",
            instance_pool_id=this.id,
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_ATTACH_TO",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Job usage

        There are four assignable [permission levels](https://docs.databricks.com/security/access-control/jobs-acl.html#job-permissions) for databricks_job: `CAN_VIEW`, `CAN_MANAGE_RUN`, `IS_OWNER`, and `CAN_MANAGE`. Admins are granted the `CAN_MANAGE` permission by default, and they can assign that permission to non-admin users, and service principals.

        - The creator of a job has `IS_OWNER` permission. Destroying `Permissions` resource for a job would revert ownership to the creator.
        - A job must have exactly one owner. If a resource is changed and no owner is specified, the currently authenticated principal would become the new owner of the job. Nothing would change, per se, if the job was created through Pulumi.
        - A job cannot have a group as an owner.
        - Jobs triggered through _Run Now_ assume the permissions of the job owner and not the user, and service principal who issued Run Now.
        - Read [main documentation](https://docs.databricks.com/security/access-control/jobs-acl.html) for additional detail.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        aws_principal = databricks.ServicePrincipal("aws_principal", display_name="main")
        latest = databricks.get_spark_version()
        smallest = databricks.get_node_type(local_disk=True)
        this = databricks.Job("this",
            name="Featurization",
            max_concurrent_runs=1,
            tasks=[{
                "task_key": "task1",
                "new_cluster": {
                    "num_workers": 300,
                    "spark_version": latest.id,
                    "node_type_id": smallest.id,
                },
                "notebook_task": {
                    "notebook_path": "/Production/MakeFeatures",
                },
            }])
        job_usage = databricks.Permissions("job_usage",
            job_id=this.id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_VIEW",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_MANAGE_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
                {
                    "service_principal_name": aws_principal.application_id,
                    "permission_level": "IS_OWNER",
                },
            ])
        ```

        ## Lakeflow Declarative Pipelines usage

        There are four assignable [permission levels](https://docs.databricks.com/aws/en/security/auth/access-control#lakeflow-declarative-pipelines-acls) for databricks_pipeline: `CAN_VIEW`, `CAN_RUN`, `CAN_MANAGE`, and `IS_OWNER`. Admins are granted the `CAN_MANAGE` permission by default, and they can assign that permission to non-admin users, and service principals.

        - The creator of a Lakeflow Declarative Pipeline has `IS_OWNER` permission. Destroying `Permissions` resource for a pipeline would revert ownership to the creator.
        - A Lakeflow Declarative Pipeline must have exactly one owner. If a resource is changed and no owner is specified, the currently authenticated principal would become the new owner of the pipeline. Nothing would change, per se, if the pipeline was created through Pulumi.
        - A Lakeflow Declarative Pipeline cannot have a group as an owner.
        - Lakeflow Declarative Pipelines triggered through _Start_ assume the permissions of the pipeline owner and not the user, and service principal who issued Run Now.
        - Read [main documentation](https://docs.databricks.com/aws/en/security/auth/access-control#lakeflow-declarative-pipelines-acls) for additional detail.

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumi_std as std

        me = databricks.get_current_user()
        eng = databricks.Group("eng", display_name="Engineering")
        ldp_demo = databricks.Notebook("ldp_demo",
            content_base64=std.base64encode(input=\"\"\"import dlt
        json_path = "/databricks-datasets/wikipedia-datasets/data-001/clickstream/raw-uncompressed-json/2015_2_clickstream.json"
        @dlt.table(
           comment="The raw wikipedia clickstream dataset, ingested from /databricks-datasets."
        )
        def clickstream_raw():
            return (spark.read.format("json").load(json_path))
        \"\"\").result,
            language="PYTHON",
            path=f"{me.home}/ldp_demo")
        this = databricks.Pipeline("this",
            name=f"LDP Demo Pipeline ({me.alphanumeric})",
            storage="/test/tf-pipeline",
            configuration={
                "key1": "value1",
                "key2": "value2",
            },
            libraries=[{
                "notebook": {
                    "path": ldp_demo.id,
                },
            }],
            continuous=False,
            filters={
                "includes": ["com.databricks.include"],
                "excludes": ["com.databricks.exclude"],
            })
        ldp_usage = databricks.Permissions("ldp_usage",
            pipeline_id=this.id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_VIEW",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Notebook usage

        Valid [permission levels](https://docs.databricks.com/security/access-control/workspace-acl.html#notebook-permissions) for Notebook are: `CAN_READ`, `CAN_RUN`, `CAN_EDIT`, and `CAN_MANAGE`.

        A notebook could be specified by using either `notebook_path` or `notebook_id` attribute.  The value for the `notebook_id` is the object ID of the resource in the Databricks Workspace that is exposed as `object_id` attribute of the `Notebook` resource as shown below.

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumi_std as std

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        this = databricks.Notebook("this",
            content_base64=std.base64encode(input="# Welcome to your Python notebook").result,
            path="/Production/ETL/Features",
            language="PYTHON")
        notebook_usage_by_path = databricks.Permissions("notebook_usage_by_path",
            notebook_path=this.path,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        notebook_usage_by_id = databricks.Permissions("notebook_usage_by_id",
            notebook_id=this.object_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        > when importing a permissions resource, only the `notebook_id` is filled!

        ## Workspace file usage

        Valid permission levels for WorkspaceFile are: `CAN_READ`, `CAN_RUN`, `CAN_EDIT`, and `CAN_MANAGE`.

        A workspace file could be specified by using either `workspace_file_path` or `workspace_file_id` attribute.  The value for the `workspace_file_id` is the object ID of the resource in the Databricks Workspace that is exposed as `object_id` attribute of the `WorkspaceFile` resource as shown below.

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumi_std as std

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        this = databricks.WorkspaceFile("this",
            content_base64=std.base64encode(input="print('Hello World')").result,
            path="/Production/ETL/Features.py")
        workspace_file_usage_by_path = databricks.Permissions("workspace_file_usage_by_path",
            workspace_file_path=this.path,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        workspace_file_usage_by_id = databricks.Permissions("workspace_file_usage_by_id",
            workspace_file_id=this.object_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        > when importing a permissions resource, only the `workspace_file_id` is filled!

        ## Folder usage

        Valid [permission levels](https://docs.databricks.com/security/access-control/workspace-acl.html#folder-permissions) for folders of Directory are: `CAN_READ`, `CAN_RUN`, `CAN_EDIT`, and `CAN_MANAGE`. Notebooks and experiments in a folder inherit all permissions settings of that folder. For example, a user (or service principal) that has `CAN_RUN` permission on a folder has `CAN_RUN` permission on the notebooks in that folder.

        - All users can list items in the folder without any permissions.
        - All users (or service principals) have `CAN_MANAGE` permission for items in the Workspace > Shared Icon Shared folder. You can grant `CAN_MANAGE` permission to notebooks and folders by moving them to the Shared Icon Shared folder.
        - All users (or service principals) have `CAN_MANAGE` permission for objects the user creates.
        - User home directory - The user (or service principal) has `CAN_MANAGE` permission. All other users (or service principals) can list their directories.

        A folder could be specified by using either `directory_path` or `directory_id` attribute.  The value for the `directory_id` is the object ID of the resource in the Databricks Workspace that is exposed as `object_id` attribute of the `Directory` resource as shown below.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        this = databricks.Directory("this", path="/Production/ETL")
        folder_usage_by_path = databricks.Permissions("folder_usage_by_path",
            directory_path=this.path,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        folder_usage_by_id = databricks.Permissions("folder_usage_by_id",
            directory_id=this.object_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        > when importing a permissions resource, only the `directory_id` is filled!

        ## Repos usage

        Valid [permission levels](https://docs.databricks.com/security/access-control/workspace-acl.html) for Repo are: `CAN_READ`, `CAN_RUN`, `CAN_EDIT`, and `CAN_MANAGE`.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        this = databricks.Repo("this", url="https://github.com/user/demo.git")
        repo_usage = databricks.Permissions("repo_usage",
            repo_id=this.id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        ## MLflow Experiment usage

        Valid [permission levels](https://docs.databricks.com/security/access-control/workspace-acl.html#mlflow-experiment-permissions-1) for MlflowExperiment are: `CAN_READ`, `CAN_EDIT`, and `CAN_MANAGE`.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.get_current_user()
        this = databricks.MlflowExperiment("this",
            name=f"{me.home}/Sample",
            artifact_location="s3://bucket/my-experiment",
            description="My MLflow experiment description")
        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        experiment_usage = databricks.Permissions("experiment_usage",
            experiment_id=this.id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_MANAGE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        ## MLflow Model usage

        Valid [permission levels](https://docs.databricks.com/security/access-control/workspace-acl.html#mlflow-model-permissions-1) for MlflowModel are: `CAN_READ`, `CAN_EDIT`, `CAN_MANAGE_STAGING_VERSIONS`, `CAN_MANAGE_PRODUCTION_VERSIONS`, and `CAN_MANAGE`. You can also manage permissions for all MLflow models by `registered_model_id = "root"`.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.MlflowModel("this", name="SomePredictions")
        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        model_usage = databricks.Permissions("model_usage",
            registered_model_id=this.registered_model_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_READ",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_MANAGE_PRODUCTION_VERSIONS",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE_STAGING_VERSIONS",
                },
            ])
        ```

        ## Model serving usage

        Valid permission levels for ModelServing are: `CAN_VIEW`, `CAN_QUERY`, and `CAN_MANAGE`.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.ModelServing("this",
            name="tf-test",
            config={
                "served_models": [{
                    "name": "prod_model",
                    "model_name": "test",
                    "model_version": "1",
                    "workload_size": "Small",
                    "scale_to_zero_enabled": True,
                }],
            })
        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        ml_serving_usage = databricks.Permissions("ml_serving_usage",
            serving_endpoint_id=this.serving_endpoint_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_VIEW",
                },
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_MANAGE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_QUERY",
                },
            ])
        ```

        ## Mosaic AI Vector Search usage

        Valid permission levels for VectorSearchEndpoint are: `CAN_USE` and `CAN_MANAGE`.

        > You need to use the `endpoint_id` attribute of `VectorSearchEndpoint` as value for `vector_search_endpoint_id`, not the `id`!

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.VectorSearchEndpoint("this",
            name="vector-search-test",
            endpoint_type="STANDARD")
        eng = databricks.Group("eng", display_name="Engineering")
        vector_search_endpoint_usage = databricks.Permissions("vector_search_endpoint_usage",
            vector_search_endpoint_id=this.endpoint_id,
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Passwords usage

        By default on AWS deployments, all admin users can sign in to Databricks using either SSO or their username and password, and all API users can authenticate to the Databricks REST APIs using their username and password. As an admin, you [can limit](https://docs.databricks.com/administration-guide/users-groups/single-sign-on/index.html#optional-configure-password-access-control) admin users' and API users' ability to authenticate with their username and password by configuring `CAN_USE` permissions using password access control.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        guests = databricks.Group("guests", display_name="Guest Users")
        password_usage = databricks.Permissions("password_usage",
            authorization="passwords",
            access_controls=[{
                "group_name": guests.display_name,
                "permission_level": "CAN_USE",
            }])
        ```

        ## Token usage

        It is required to have at least 1 personal access token in the workspace before you can manage tokens permissions.

        !> **Warning** There can be only one `authorization = "tokens"` permissions resource per workspace, otherwise there'll be a permanent configuration drift. After applying changes, users who previously had either `CAN_USE` or `CAN_MANAGE` permission but no longer have either permission have their access to token-based authentication revoked. Their active tokens are immediately deleted (revoked).

        Only [possible permission](https://docs.databricks.com/administration-guide/access-control/tokens.html) to assign to non-admin group is `CAN_USE`, where _admins_ `CAN_MANAGE` all tokens:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        token_usage = databricks.Permissions("token_usage",
            authorization="tokens",
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_USE",
                },
            ])
        ```

        ## SQL warehouse usage

        [SQL warehouses](https://docs.databricks.com/sql/user/security/access-control/sql-endpoint-acl.html) have five possible permissions: `CAN_USE`, `CAN_MONITOR`, `CAN_MANAGE`, `CAN_VIEW` and `IS_OWNER`:

        - The creator of a warehouse has `IS_OWNER` permission. Destroying `Permissions` resource for a warehouse would revert ownership to the creator.
        - A warehouse must have exactly one owner. If a resource is changed and no owner is specified, the currently authenticated principal would become the new owner of the warehouse. Nothing would change, per se, if the warehouse was created through Pulumi.
        - A warehouse cannot have a group as an owner.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.get_current_user()
        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        this = databricks.SqlEndpoint("this",
            name=f"Endpoint of {me.alphanumeric}",
            cluster_size="Small",
            max_num_clusters=1,
            tags={
                "custom_tags": [{
                    "key": "City",
                    "value": "Amsterdam",
                }],
            })
        endpoint_usage = databricks.Permissions("endpoint_usage",
            sql_endpoint_id=this.id,
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Dashboard usage

        [Dashboards](https://docs.databricks.com/en/dashboards/tutorials/manage-permissions.html) have four possible permissions: `CAN_READ`, `CAN_RUN`, `CAN_EDIT` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        dashboard = databricks.Dashboard("dashboard", display_name="TF New Dashboard")
        dashboard_usage = databricks.Permissions("dashboard_usage",
            dashboard_id=dashboard.id,
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Legacy SQL Dashboard usage

        [Legacy SQL dashboards](https://docs.databricks.com/sql/user/security/access-control/dashboard-acl.html) have three possible permissions: `CAN_VIEW`, `CAN_RUN` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        sql_dashboard_usage = databricks.Permissions("sql_dashboard_usage",
            sql_dashboard_id="3244325",
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## SQL Query usage

        [SQL queries](https://docs.databricks.com/sql/user/security/access-control/query-acl.html) have three possible permissions: `CAN_VIEW`, `CAN_RUN` and `CAN_MANAGE`:

        > If you do not define an `access_control` block granting `CAN_MANAGE` explictly for the user calling this provider, Databricks Pulumi Provider will add `CAN_MANAGE` permission for the caller. This is a failsafe to prevent situations where the caller is locked out from making changes to the targeted `SqlQuery` resource when backend API do not apply permission inheritance correctly.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        query_usage = databricks.Permissions("query_usage",
            sql_query_id="3244325",
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## SQL Alert (AlertV2) usage

        [Alert V2](https://docs.databricks.com/sql/user/security/access-control/alert-acl.html) which is the new version of SQL Alert have 4 possible permission levels: `CAN_READ`, `CAN_RUN`, `CAN_EDIT`, and `CAN_MANAGE`.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        app_usage = databricks.Permissions("app_usage",
            alert_v2_id="12345",
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_EDIT",
                },
            ])
        ```

        ## SQL Alert (legacy) usage

        [SQL alerts](https://docs.databricks.com/sql/user/security/access-control/alert-acl.html) have three possible permissions: `CAN_VIEW`, `CAN_RUN` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        auto = databricks.Group("auto", display_name="Automation")
        eng = databricks.Group("eng", display_name="Engineering")
        alert_usage = databricks.Permissions("alert_usage",
            sql_alert_id="3244325",
            access_controls=[
                {
                    "group_name": auto.display_name,
                    "permission_level": "CAN_RUN",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Databricks Apps usage

        [Databricks Apps](https://docs.databricks.com/en/dev-tools/databricks-apps/index.html) have two possible permissions: `CAN_USE` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        eng = databricks.Group("eng", display_name="Engineering")
        app_usage = databricks.Permissions("app_usage",
            app_name="myapp",
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Lakebase Database Instances usage

        [Databricks Lakebase](https://docs.databricks.com/aws/en/oltp/) have two possible permissions: `CAN_USE` and `CAN_MANAGE`:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        eng = databricks.Group("eng", display_name="Engineering")
        app_usage = databricks.Permissions("app_usage",
            database_instance_name="my_database",
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_USE",
                },
                {
                    "group_name": eng.display_name,
                    "permission_level": "CAN_MANAGE",
                },
            ])
        ```

        ## Instance Profiles

        Instance Profiles are not managed by General Permissions API and therefore GroupInstanceProfile and UserInstanceProfile should be used to allow usage of specific AWS EC2 IAM roles to users or groups.

        ## Secrets

        One can control access to Secret through `initial_manage_principal` argument on SecretScope or databricks_secret_acl, so that users (or service principals) can `READ`, `WRITE` or `MANAGE` entries within secret scope.

        ## Tables, Views and Databases

        General Permissions API does not apply to access control for tables and they have to be managed separately using the SqlPermissions resource, though you're encouraged to use Unity Catalog or migrate to it.

        ## Data Access with Unity Catalog

        Initially in Unity Catalog all users have no access to data, which has to be later assigned through Grants or Grant resource.

        ## Import

        The resource permissions can be imported using the object id

        ```sh
        $ pulumi import databricks:index/permissions:Permissions databricks_permissions <object type>/<object id>
        ```

        :param str resource_name: The name of the resource.
        :param PermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_controls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PermissionsAccessControlArgs', 'PermissionsAccessControlArgsDict']]]]] = None,
                 alert_v2_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_path: Optional[pulumi.Input[_builtins.str]] = None,
                 experiment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook_path: Optional[pulumi.Input[_builtins.str]] = None,
                 object_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 registered_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_path: Optional[pulumi.Input[_builtins.str]] = None,
                 serving_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_alert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vector_search_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_file_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionsArgs.__new__(PermissionsArgs)

            if access_controls is None and not opts.urn:
                raise TypeError("Missing required property 'access_controls'")
            __props__.__dict__["access_controls"] = access_controls
            __props__.__dict__["alert_v2_id"] = alert_v2_id
            __props__.__dict__["app_name"] = app_name
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["cluster_policy_id"] = cluster_policy_id
            __props__.__dict__["dashboard_id"] = dashboard_id
            __props__.__dict__["database_instance_name"] = database_instance_name
            __props__.__dict__["directory_id"] = directory_id
            __props__.__dict__["directory_path"] = directory_path
            __props__.__dict__["experiment_id"] = experiment_id
            __props__.__dict__["instance_pool_id"] = instance_pool_id
            __props__.__dict__["job_id"] = job_id
            __props__.__dict__["notebook_id"] = notebook_id
            __props__.__dict__["notebook_path"] = notebook_path
            __props__.__dict__["object_type"] = object_type
            __props__.__dict__["pipeline_id"] = pipeline_id
            __props__.__dict__["registered_model_id"] = registered_model_id
            __props__.__dict__["repo_id"] = repo_id
            __props__.__dict__["repo_path"] = repo_path
            __props__.__dict__["serving_endpoint_id"] = serving_endpoint_id
            __props__.__dict__["sql_alert_id"] = sql_alert_id
            __props__.__dict__["sql_dashboard_id"] = sql_dashboard_id
            __props__.__dict__["sql_endpoint_id"] = sql_endpoint_id
            __props__.__dict__["sql_query_id"] = sql_query_id
            __props__.__dict__["vector_search_endpoint_id"] = vector_search_endpoint_id
            __props__.__dict__["workspace_file_id"] = workspace_file_id
            __props__.__dict__["workspace_file_path"] = workspace_file_path
        super(Permissions, __self__).__init__(
            'databricks:index/permissions:Permissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_controls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PermissionsAccessControlArgs', 'PermissionsAccessControlArgsDict']]]]] = None,
            alert_v2_id: Optional[pulumi.Input[_builtins.str]] = None,
            app_name: Optional[pulumi.Input[_builtins.str]] = None,
            authorization: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
            database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            directory_id: Optional[pulumi.Input[_builtins.str]] = None,
            directory_path: Optional[pulumi.Input[_builtins.str]] = None,
            experiment_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            job_id: Optional[pulumi.Input[_builtins.str]] = None,
            notebook_id: Optional[pulumi.Input[_builtins.str]] = None,
            notebook_path: Optional[pulumi.Input[_builtins.str]] = None,
            object_type: Optional[pulumi.Input[_builtins.str]] = None,
            pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
            registered_model_id: Optional[pulumi.Input[_builtins.str]] = None,
            repo_id: Optional[pulumi.Input[_builtins.str]] = None,
            repo_path: Optional[pulumi.Input[_builtins.str]] = None,
            serving_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            sql_alert_id: Optional[pulumi.Input[_builtins.str]] = None,
            sql_dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
            sql_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            sql_query_id: Optional[pulumi.Input[_builtins.str]] = None,
            vector_search_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_file_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_file_path: Optional[pulumi.Input[_builtins.str]] = None) -> 'Permissions':
        """
        Get an existing Permissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] object_type: type of permissions.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PermissionsState.__new__(_PermissionsState)

        __props__.__dict__["access_controls"] = access_controls
        __props__.__dict__["alert_v2_id"] = alert_v2_id
        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_policy_id"] = cluster_policy_id
        __props__.__dict__["dashboard_id"] = dashboard_id
        __props__.__dict__["database_instance_name"] = database_instance_name
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["directory_path"] = directory_path
        __props__.__dict__["experiment_id"] = experiment_id
        __props__.__dict__["instance_pool_id"] = instance_pool_id
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["notebook_id"] = notebook_id
        __props__.__dict__["notebook_path"] = notebook_path
        __props__.__dict__["object_type"] = object_type
        __props__.__dict__["pipeline_id"] = pipeline_id
        __props__.__dict__["registered_model_id"] = registered_model_id
        __props__.__dict__["repo_id"] = repo_id
        __props__.__dict__["repo_path"] = repo_path
        __props__.__dict__["serving_endpoint_id"] = serving_endpoint_id
        __props__.__dict__["sql_alert_id"] = sql_alert_id
        __props__.__dict__["sql_dashboard_id"] = sql_dashboard_id
        __props__.__dict__["sql_endpoint_id"] = sql_endpoint_id
        __props__.__dict__["sql_query_id"] = sql_query_id
        __props__.__dict__["vector_search_endpoint_id"] = vector_search_endpoint_id
        __props__.__dict__["workspace_file_id"] = workspace_file_id
        __props__.__dict__["workspace_file_path"] = workspace_file_path
        return Permissions(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessControls")
    def access_controls(self) -> pulumi.Output[Sequence['outputs.PermissionsAccessControl']]:
        return pulumi.get(self, "access_controls")

    @_builtins.property
    @pulumi.getter(name="alertV2Id")
    def alert_v2_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "alert_v2_id")

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "authorization")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterPolicyId")
    def cluster_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "cluster_policy_id")

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "dashboard_id")

    @_builtins.property
    @pulumi.getter(name="databaseInstanceName")
    def database_instance_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "database_instance_name")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="directoryPath")
    def directory_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "directory_path")

    @_builtins.property
    @pulumi.getter(name="experimentId")
    def experiment_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "experiment_id")

    @_builtins.property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "instance_pool_id")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="notebookId")
    def notebook_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "notebook_id")

    @_builtins.property
    @pulumi.getter(name="notebookPath")
    def notebook_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "notebook_path")

    @_builtins.property
    @pulumi.getter(name="objectType")
    def object_type(self) -> pulumi.Output[_builtins.str]:
        """
        type of permissions.
        """
        return pulumi.get(self, "object_type")

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "pipeline_id")

    @_builtins.property
    @pulumi.getter(name="registeredModelId")
    def registered_model_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "registered_model_id")

    @_builtins.property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "repo_id")

    @_builtins.property
    @pulumi.getter(name="repoPath")
    def repo_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "repo_path")

    @_builtins.property
    @pulumi.getter(name="servingEndpointId")
    def serving_endpoint_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "serving_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="sqlAlertId")
    def sql_alert_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "sql_alert_id")

    @_builtins.property
    @pulumi.getter(name="sqlDashboardId")
    def sql_dashboard_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "sql_dashboard_id")

    @_builtins.property
    @pulumi.getter(name="sqlEndpointId")
    def sql_endpoint_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "sql_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="sqlQueryId")
    def sql_query_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "sql_query_id")

    @_builtins.property
    @pulumi.getter(name="vectorSearchEndpointId")
    def vector_search_endpoint_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "vector_search_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="workspaceFileId")
    def workspace_file_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "workspace_file_id")

    @_builtins.property
    @pulumi.getter(name="workspaceFilePath")
    def workspace_file_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "workspace_file_path")

