from yta_general_utils.tmp_processor import create_custom_tmp_filename
from image.edition.green_screen import remove_green_screen_from_image_file
from subprocess import run

def remove_green_screen_from_video_file(video_filename: str, output_filename: str):
    from moviepy.editor import VideoFileClip

    if not video_filename:
        return None
    
    if not output_filename:
        return None
    
    # Export all frames
    original_frames_array = []
    clip = VideoFileClip(video_filename)
    for frame in clip.iter_frames():
        frame_name = create_custom_tmp_filename('tmp_frame_' + str(len(original_frames_array)) + '.png')
        original_frames_array.append(frame_name)
    clip.write_images_sequence(create_custom_tmp_filename('tmp_frame_%01d.png'), logger = 'bar')

    # Remove green screen of each frame and store it
    processed_frames_array = []
    for index, frame in enumerate(original_frames_array):
        tmp_frame_filename = create_custom_tmp_filename('tmp_frame_processed_' + str(index) + '.png')
        processed_frames_array.append(tmp_frame_filename)
        remove_green_screen_from_image_file(frame, tmp_frame_filename)

    # Rebuild the video
        
    # https://stackoverflow.com/a/77608713
    #ImageSequenceClip(processed_frames_array, fps = clip.fps).set_audio(clip.audio).write_videofile(output_filename, codec = 'hap_alpha', ffmpeg_params = ['-c:v', 'hap', '-format', 'hap_alpha', '-vf', 'chromakey=black:0.1:0.1'])
    # https://superuser.com/questions/1779201/combine-pngs-images-with-transparency-into-a-video-and-merge-it-on-a-static-imag
    # ffmpeg -y -i src/tmp/%d.png -c:v libx264 -vf fps=25 -pix_fmt yuva420p land.mov
    
    #clip = ImageSequenceClip(processed_frames_array, fps = clip.fps).set_audio(clip.audio).write_videofile(output_filename, codec = 'libx264', audio_codec = 'aac', temp_audiofile = 'temp-audio.m4a', remove_temp = True)
    parameters = ['ffmpeg', '-y', '-i', create_custom_tmp_filename('tmp_frame_processed_%01d.png'), '-r', '30', '-pix_fmt', 'yuva420p', output_filename]
    run(parameters)