# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApplicationRegistrationArgs', 'ApplicationRegistration']

@pulumi.input_type
class ApplicationRegistrationArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 group_membership_claims: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 homepage_url: Optional[pulumi.Input[builtins.str]] = None,
                 implicit_access_token_issuance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 implicit_id_token_issuance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 logout_url: Optional[pulumi.Input[builtins.str]] = None,
                 marketing_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 privacy_statement_url: Optional[pulumi.Input[builtins.str]] = None,
                 requested_access_token_version: Optional[pulumi.Input[builtins.int]] = None,
                 service_management_reference: Optional[pulumi.Input[builtins.str]] = None,
                 sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 terms_of_service_url: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ApplicationRegistration resource.
        :param pulumi.Input[builtins.str] display_name: The display name for the application.
        :param pulumi.Input[builtins.str] description: A description of the application, as shown to end users.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_membership_claims: Configures the `groups` claim issued in a user or OAuth access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        :param pulumi.Input[builtins.str] homepage_url: Home page or landing page of the application.
        :param pulumi.Input[builtins.bool] implicit_access_token_issuance_enabled: Whether this web application can request an access token using OAuth implicit flow.
        :param pulumi.Input[builtins.bool] implicit_id_token_issuance_enabled: Whether this web application can request an ID token using OAuth implicit flow.
        :param pulumi.Input[builtins.str] logout_url: The URL that will be used by Microsoft's authorization service to sign out a user using front-channel, back-channel or SAML logout protocols.
        :param pulumi.Input[builtins.str] marketing_url: URL of the marketing page for the application.
        :param pulumi.Input[builtins.str] notes: User-specified notes relevant for the management of the application.
        :param pulumi.Input[builtins.str] privacy_statement_url: URL of the privacy statement for the application.
        :param pulumi.Input[builtins.int] requested_access_token_version: The access token version expected by this resource. Must be one of `1` or `2`, and must be `2` when `sign_in_audience` is either `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount` Defaults to `2`.
        :param pulumi.Input[builtins.str] service_management_reference: References application context information from a Service or Asset Management database.
        :param pulumi.Input[builtins.str] sign_in_audience: The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.
        :param pulumi.Input[builtins.str] support_url: URL of the support page for the application.
        :param pulumi.Input[builtins.str] terms_of_service_url: URL of the terms of service statement for the application.
        """
        pulumi.set(__self__, "display_name", display_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_membership_claims is not None:
            pulumi.set(__self__, "group_membership_claims", group_membership_claims)
        if homepage_url is not None:
            pulumi.set(__self__, "homepage_url", homepage_url)
        if implicit_access_token_issuance_enabled is not None:
            pulumi.set(__self__, "implicit_access_token_issuance_enabled", implicit_access_token_issuance_enabled)
        if implicit_id_token_issuance_enabled is not None:
            pulumi.set(__self__, "implicit_id_token_issuance_enabled", implicit_id_token_issuance_enabled)
        if logout_url is not None:
            pulumi.set(__self__, "logout_url", logout_url)
        if marketing_url is not None:
            pulumi.set(__self__, "marketing_url", marketing_url)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if privacy_statement_url is not None:
            pulumi.set(__self__, "privacy_statement_url", privacy_statement_url)
        if requested_access_token_version is not None:
            pulumi.set(__self__, "requested_access_token_version", requested_access_token_version)
        if service_management_reference is not None:
            pulumi.set(__self__, "service_management_reference", service_management_reference)
        if sign_in_audience is not None:
            pulumi.set(__self__, "sign_in_audience", sign_in_audience)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)
        if terms_of_service_url is not None:
            pulumi.set(__self__, "terms_of_service_url", terms_of_service_url)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name for the application.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the application, as shown to end users.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="groupMembershipClaims")
    def group_membership_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Configures the `groups` claim issued in a user or OAuth access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        """
        return pulumi.get(self, "group_membership_claims")

    @group_membership_claims.setter
    def group_membership_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "group_membership_claims", value)

    @property
    @pulumi.getter(name="homepageUrl")
    def homepage_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Home page or landing page of the application.
        """
        return pulumi.get(self, "homepage_url")

    @homepage_url.setter
    def homepage_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "homepage_url", value)

    @property
    @pulumi.getter(name="implicitAccessTokenIssuanceEnabled")
    def implicit_access_token_issuance_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this web application can request an access token using OAuth implicit flow.
        """
        return pulumi.get(self, "implicit_access_token_issuance_enabled")

    @implicit_access_token_issuance_enabled.setter
    def implicit_access_token_issuance_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "implicit_access_token_issuance_enabled", value)

    @property
    @pulumi.getter(name="implicitIdTokenIssuanceEnabled")
    def implicit_id_token_issuance_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this web application can request an ID token using OAuth implicit flow.
        """
        return pulumi.get(self, "implicit_id_token_issuance_enabled")

    @implicit_id_token_issuance_enabled.setter
    def implicit_id_token_issuance_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "implicit_id_token_issuance_enabled", value)

    @property
    @pulumi.getter(name="logoutUrl")
    def logout_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL that will be used by Microsoft's authorization service to sign out a user using front-channel, back-channel or SAML logout protocols.
        """
        return pulumi.get(self, "logout_url")

    @logout_url.setter
    def logout_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logout_url", value)

    @property
    @pulumi.getter(name="marketingUrl")
    def marketing_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the marketing page for the application.
        """
        return pulumi.get(self, "marketing_url")

    @marketing_url.setter
    def marketing_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "marketing_url", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-specified notes relevant for the management of the application.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="privacyStatementUrl")
    def privacy_statement_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the privacy statement for the application.
        """
        return pulumi.get(self, "privacy_statement_url")

    @privacy_statement_url.setter
    def privacy_statement_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privacy_statement_url", value)

    @property
    @pulumi.getter(name="requestedAccessTokenVersion")
    def requested_access_token_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The access token version expected by this resource. Must be one of `1` or `2`, and must be `2` when `sign_in_audience` is either `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount` Defaults to `2`.
        """
        return pulumi.get(self, "requested_access_token_version")

    @requested_access_token_version.setter
    def requested_access_token_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "requested_access_token_version", value)

    @property
    @pulumi.getter(name="serviceManagementReference")
    def service_management_reference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        References application context information from a Service or Asset Management database.
        """
        return pulumi.get(self, "service_management_reference")

    @service_management_reference.setter
    def service_management_reference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_management_reference", value)

    @property
    @pulumi.getter(name="signInAudience")
    def sign_in_audience(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.
        """
        return pulumi.get(self, "sign_in_audience")

    @sign_in_audience.setter
    def sign_in_audience(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sign_in_audience", value)

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the support page for the application.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "support_url", value)

    @property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the terms of service statement for the application.
        """
        return pulumi.get(self, "terms_of_service_url")

    @terms_of_service_url.setter
    def terms_of_service_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "terms_of_service_url", value)


@pulumi.input_type
class _ApplicationRegistrationState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled_by_microsoft: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 group_membership_claims: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 homepage_url: Optional[pulumi.Input[builtins.str]] = None,
                 implicit_access_token_issuance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 implicit_id_token_issuance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 logout_url: Optional[pulumi.Input[builtins.str]] = None,
                 marketing_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 object_id: Optional[pulumi.Input[builtins.str]] = None,
                 privacy_statement_url: Optional[pulumi.Input[builtins.str]] = None,
                 publisher_domain: Optional[pulumi.Input[builtins.str]] = None,
                 requested_access_token_version: Optional[pulumi.Input[builtins.int]] = None,
                 service_management_reference: Optional[pulumi.Input[builtins.str]] = None,
                 sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 terms_of_service_url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApplicationRegistration resources.
        :param pulumi.Input[builtins.str] client_id: The Client ID for the application, which is globally unique.
        :param pulumi.Input[builtins.str] description: A description of the application, as shown to end users.
        :param pulumi.Input[builtins.str] disabled_by_microsoft: Whether Microsoft has disabled the registered application. If the application is disabled, this will be a string indicating the status/reason, e.g. `DisabledDueToViolationOfServicesAgreement`
        :param pulumi.Input[builtins.str] display_name: The display name for the application.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_membership_claims: Configures the `groups` claim issued in a user or OAuth access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        :param pulumi.Input[builtins.str] homepage_url: Home page or landing page of the application.
        :param pulumi.Input[builtins.bool] implicit_access_token_issuance_enabled: Whether this web application can request an access token using OAuth implicit flow.
        :param pulumi.Input[builtins.bool] implicit_id_token_issuance_enabled: Whether this web application can request an ID token using OAuth implicit flow.
        :param pulumi.Input[builtins.str] logout_url: The URL that will be used by Microsoft's authorization service to sign out a user using front-channel, back-channel or SAML logout protocols.
        :param pulumi.Input[builtins.str] marketing_url: URL of the marketing page for the application.
        :param pulumi.Input[builtins.str] notes: User-specified notes relevant for the management of the application.
        :param pulumi.Input[builtins.str] object_id: The object ID of the application within the tenant.
        :param pulumi.Input[builtins.str] privacy_statement_url: URL of the privacy statement for the application.
        :param pulumi.Input[builtins.str] publisher_domain: The verified publisher domain for the application.
        :param pulumi.Input[builtins.int] requested_access_token_version: The access token version expected by this resource. Must be one of `1` or `2`, and must be `2` when `sign_in_audience` is either `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount` Defaults to `2`.
        :param pulumi.Input[builtins.str] service_management_reference: References application context information from a Service or Asset Management database.
        :param pulumi.Input[builtins.str] sign_in_audience: The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.
        :param pulumi.Input[builtins.str] support_url: URL of the support page for the application.
        :param pulumi.Input[builtins.str] terms_of_service_url: URL of the terms of service statement for the application.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled_by_microsoft is not None:
            pulumi.set(__self__, "disabled_by_microsoft", disabled_by_microsoft)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if group_membership_claims is not None:
            pulumi.set(__self__, "group_membership_claims", group_membership_claims)
        if homepage_url is not None:
            pulumi.set(__self__, "homepage_url", homepage_url)
        if implicit_access_token_issuance_enabled is not None:
            pulumi.set(__self__, "implicit_access_token_issuance_enabled", implicit_access_token_issuance_enabled)
        if implicit_id_token_issuance_enabled is not None:
            pulumi.set(__self__, "implicit_id_token_issuance_enabled", implicit_id_token_issuance_enabled)
        if logout_url is not None:
            pulumi.set(__self__, "logout_url", logout_url)
        if marketing_url is not None:
            pulumi.set(__self__, "marketing_url", marketing_url)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if privacy_statement_url is not None:
            pulumi.set(__self__, "privacy_statement_url", privacy_statement_url)
        if publisher_domain is not None:
            pulumi.set(__self__, "publisher_domain", publisher_domain)
        if requested_access_token_version is not None:
            pulumi.set(__self__, "requested_access_token_version", requested_access_token_version)
        if service_management_reference is not None:
            pulumi.set(__self__, "service_management_reference", service_management_reference)
        if sign_in_audience is not None:
            pulumi.set(__self__, "sign_in_audience", sign_in_audience)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)
        if terms_of_service_url is not None:
            pulumi.set(__self__, "terms_of_service_url", terms_of_service_url)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client ID for the application, which is globally unique.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the application, as shown to end users.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disabledByMicrosoft")
    def disabled_by_microsoft(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether Microsoft has disabled the registered application. If the application is disabled, this will be a string indicating the status/reason, e.g. `DisabledDueToViolationOfServicesAgreement`
        """
        return pulumi.get(self, "disabled_by_microsoft")

    @disabled_by_microsoft.setter
    def disabled_by_microsoft(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disabled_by_microsoft", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name for the application.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="groupMembershipClaims")
    def group_membership_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Configures the `groups` claim issued in a user or OAuth access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        """
        return pulumi.get(self, "group_membership_claims")

    @group_membership_claims.setter
    def group_membership_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "group_membership_claims", value)

    @property
    @pulumi.getter(name="homepageUrl")
    def homepage_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Home page or landing page of the application.
        """
        return pulumi.get(self, "homepage_url")

    @homepage_url.setter
    def homepage_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "homepage_url", value)

    @property
    @pulumi.getter(name="implicitAccessTokenIssuanceEnabled")
    def implicit_access_token_issuance_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this web application can request an access token using OAuth implicit flow.
        """
        return pulumi.get(self, "implicit_access_token_issuance_enabled")

    @implicit_access_token_issuance_enabled.setter
    def implicit_access_token_issuance_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "implicit_access_token_issuance_enabled", value)

    @property
    @pulumi.getter(name="implicitIdTokenIssuanceEnabled")
    def implicit_id_token_issuance_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this web application can request an ID token using OAuth implicit flow.
        """
        return pulumi.get(self, "implicit_id_token_issuance_enabled")

    @implicit_id_token_issuance_enabled.setter
    def implicit_id_token_issuance_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "implicit_id_token_issuance_enabled", value)

    @property
    @pulumi.getter(name="logoutUrl")
    def logout_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL that will be used by Microsoft's authorization service to sign out a user using front-channel, back-channel or SAML logout protocols.
        """
        return pulumi.get(self, "logout_url")

    @logout_url.setter
    def logout_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logout_url", value)

    @property
    @pulumi.getter(name="marketingUrl")
    def marketing_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the marketing page for the application.
        """
        return pulumi.get(self, "marketing_url")

    @marketing_url.setter
    def marketing_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "marketing_url", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-specified notes relevant for the management of the application.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object ID of the application within the tenant.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="privacyStatementUrl")
    def privacy_statement_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the privacy statement for the application.
        """
        return pulumi.get(self, "privacy_statement_url")

    @privacy_statement_url.setter
    def privacy_statement_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privacy_statement_url", value)

    @property
    @pulumi.getter(name="publisherDomain")
    def publisher_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The verified publisher domain for the application.
        """
        return pulumi.get(self, "publisher_domain")

    @publisher_domain.setter
    def publisher_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "publisher_domain", value)

    @property
    @pulumi.getter(name="requestedAccessTokenVersion")
    def requested_access_token_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The access token version expected by this resource. Must be one of `1` or `2`, and must be `2` when `sign_in_audience` is either `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount` Defaults to `2`.
        """
        return pulumi.get(self, "requested_access_token_version")

    @requested_access_token_version.setter
    def requested_access_token_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "requested_access_token_version", value)

    @property
    @pulumi.getter(name="serviceManagementReference")
    def service_management_reference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        References application context information from a Service or Asset Management database.
        """
        return pulumi.get(self, "service_management_reference")

    @service_management_reference.setter
    def service_management_reference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_management_reference", value)

    @property
    @pulumi.getter(name="signInAudience")
    def sign_in_audience(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.
        """
        return pulumi.get(self, "sign_in_audience")

    @sign_in_audience.setter
    def sign_in_audience(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sign_in_audience", value)

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the support page for the application.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "support_url", value)

    @property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the terms of service statement for the application.
        """
        return pulumi.get(self, "terms_of_service_url")

    @terms_of_service_url.setter
    def terms_of_service_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "terms_of_service_url", value)


@pulumi.type_token("azuread:index/applicationRegistration:ApplicationRegistration")
class ApplicationRegistration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 group_membership_claims: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 homepage_url: Optional[pulumi.Input[builtins.str]] = None,
                 implicit_access_token_issuance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 implicit_id_token_issuance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 logout_url: Optional[pulumi.Input[builtins.str]] = None,
                 marketing_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 privacy_statement_url: Optional[pulumi.Input[builtins.str]] = None,
                 requested_access_token_version: Optional[pulumi.Input[builtins.int]] = None,
                 service_management_reference: Optional[pulumi.Input[builtins.str]] = None,
                 sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 terms_of_service_url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an application registration within Azure Active Directory.

        For a more comprehensive alternative, please see the Application resource. Please note that this resource should not be used together with the `Application` resource when managing the same application.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires one of the following application roles: `Application.ReadWrite.OwnedBy` or `Application.ReadWrite.All`

        When authenticated with a user principal, this resource may require one of the following directory roles: `Application Administrator` or `Global Administrator`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.ApplicationRegistration("example",
            display_name="Example Application",
            description="My example application",
            sign_in_audience="AzureADMyOrg",
            homepage_url="https://app.example.com/",
            logout_url="https://app.example.com/logout",
            marketing_url="https://example.com/",
            privacy_statement_url="https://example.com/privacy",
            support_url="https://support.example.com/",
            terms_of_service_url="https://example.com/terms")
        ```

        ## Import

        Application Registrations can be imported using the object ID of the application, in the following format.

        ```sh
        $ pulumi import azuread:index/applicationRegistration:ApplicationRegistration example /applications/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description of the application, as shown to end users.
        :param pulumi.Input[builtins.str] display_name: The display name for the application.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_membership_claims: Configures the `groups` claim issued in a user or OAuth access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        :param pulumi.Input[builtins.str] homepage_url: Home page or landing page of the application.
        :param pulumi.Input[builtins.bool] implicit_access_token_issuance_enabled: Whether this web application can request an access token using OAuth implicit flow.
        :param pulumi.Input[builtins.bool] implicit_id_token_issuance_enabled: Whether this web application can request an ID token using OAuth implicit flow.
        :param pulumi.Input[builtins.str] logout_url: The URL that will be used by Microsoft's authorization service to sign out a user using front-channel, back-channel or SAML logout protocols.
        :param pulumi.Input[builtins.str] marketing_url: URL of the marketing page for the application.
        :param pulumi.Input[builtins.str] notes: User-specified notes relevant for the management of the application.
        :param pulumi.Input[builtins.str] privacy_statement_url: URL of the privacy statement for the application.
        :param pulumi.Input[builtins.int] requested_access_token_version: The access token version expected by this resource. Must be one of `1` or `2`, and must be `2` when `sign_in_audience` is either `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount` Defaults to `2`.
        :param pulumi.Input[builtins.str] service_management_reference: References application context information from a Service or Asset Management database.
        :param pulumi.Input[builtins.str] sign_in_audience: The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.
        :param pulumi.Input[builtins.str] support_url: URL of the support page for the application.
        :param pulumi.Input[builtins.str] terms_of_service_url: URL of the terms of service statement for the application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationRegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an application registration within Azure Active Directory.

        For a more comprehensive alternative, please see the Application resource. Please note that this resource should not be used together with the `Application` resource when managing the same application.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires one of the following application roles: `Application.ReadWrite.OwnedBy` or `Application.ReadWrite.All`

        When authenticated with a user principal, this resource may require one of the following directory roles: `Application Administrator` or `Global Administrator`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.ApplicationRegistration("example",
            display_name="Example Application",
            description="My example application",
            sign_in_audience="AzureADMyOrg",
            homepage_url="https://app.example.com/",
            logout_url="https://app.example.com/logout",
            marketing_url="https://example.com/",
            privacy_statement_url="https://example.com/privacy",
            support_url="https://support.example.com/",
            terms_of_service_url="https://example.com/terms")
        ```

        ## Import

        Application Registrations can be imported using the object ID of the application, in the following format.

        ```sh
        $ pulumi import azuread:index/applicationRegistration:ApplicationRegistration example /applications/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationRegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationRegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 group_membership_claims: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 homepage_url: Optional[pulumi.Input[builtins.str]] = None,
                 implicit_access_token_issuance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 implicit_id_token_issuance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 logout_url: Optional[pulumi.Input[builtins.str]] = None,
                 marketing_url: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 privacy_statement_url: Optional[pulumi.Input[builtins.str]] = None,
                 requested_access_token_version: Optional[pulumi.Input[builtins.int]] = None,
                 service_management_reference: Optional[pulumi.Input[builtins.str]] = None,
                 sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 terms_of_service_url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationRegistrationArgs.__new__(ApplicationRegistrationArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["group_membership_claims"] = group_membership_claims
            __props__.__dict__["homepage_url"] = homepage_url
            __props__.__dict__["implicit_access_token_issuance_enabled"] = implicit_access_token_issuance_enabled
            __props__.__dict__["implicit_id_token_issuance_enabled"] = implicit_id_token_issuance_enabled
            __props__.__dict__["logout_url"] = logout_url
            __props__.__dict__["marketing_url"] = marketing_url
            __props__.__dict__["notes"] = notes
            __props__.__dict__["privacy_statement_url"] = privacy_statement_url
            __props__.__dict__["requested_access_token_version"] = requested_access_token_version
            __props__.__dict__["service_management_reference"] = service_management_reference
            __props__.__dict__["sign_in_audience"] = sign_in_audience
            __props__.__dict__["support_url"] = support_url
            __props__.__dict__["terms_of_service_url"] = terms_of_service_url
            __props__.__dict__["client_id"] = None
            __props__.__dict__["disabled_by_microsoft"] = None
            __props__.__dict__["object_id"] = None
            __props__.__dict__["publisher_domain"] = None
        super(ApplicationRegistration, __self__).__init__(
            'azuread:index/applicationRegistration:ApplicationRegistration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disabled_by_microsoft: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            group_membership_claims: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            homepage_url: Optional[pulumi.Input[builtins.str]] = None,
            implicit_access_token_issuance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            implicit_id_token_issuance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            logout_url: Optional[pulumi.Input[builtins.str]] = None,
            marketing_url: Optional[pulumi.Input[builtins.str]] = None,
            notes: Optional[pulumi.Input[builtins.str]] = None,
            object_id: Optional[pulumi.Input[builtins.str]] = None,
            privacy_statement_url: Optional[pulumi.Input[builtins.str]] = None,
            publisher_domain: Optional[pulumi.Input[builtins.str]] = None,
            requested_access_token_version: Optional[pulumi.Input[builtins.int]] = None,
            service_management_reference: Optional[pulumi.Input[builtins.str]] = None,
            sign_in_audience: Optional[pulumi.Input[builtins.str]] = None,
            support_url: Optional[pulumi.Input[builtins.str]] = None,
            terms_of_service_url: Optional[pulumi.Input[builtins.str]] = None) -> 'ApplicationRegistration':
        """
        Get an existing ApplicationRegistration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] client_id: The Client ID for the application, which is globally unique.
        :param pulumi.Input[builtins.str] description: A description of the application, as shown to end users.
        :param pulumi.Input[builtins.str] disabled_by_microsoft: Whether Microsoft has disabled the registered application. If the application is disabled, this will be a string indicating the status/reason, e.g. `DisabledDueToViolationOfServicesAgreement`
        :param pulumi.Input[builtins.str] display_name: The display name for the application.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_membership_claims: Configures the `groups` claim issued in a user or OAuth access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        :param pulumi.Input[builtins.str] homepage_url: Home page or landing page of the application.
        :param pulumi.Input[builtins.bool] implicit_access_token_issuance_enabled: Whether this web application can request an access token using OAuth implicit flow.
        :param pulumi.Input[builtins.bool] implicit_id_token_issuance_enabled: Whether this web application can request an ID token using OAuth implicit flow.
        :param pulumi.Input[builtins.str] logout_url: The URL that will be used by Microsoft's authorization service to sign out a user using front-channel, back-channel or SAML logout protocols.
        :param pulumi.Input[builtins.str] marketing_url: URL of the marketing page for the application.
        :param pulumi.Input[builtins.str] notes: User-specified notes relevant for the management of the application.
        :param pulumi.Input[builtins.str] object_id: The object ID of the application within the tenant.
        :param pulumi.Input[builtins.str] privacy_statement_url: URL of the privacy statement for the application.
        :param pulumi.Input[builtins.str] publisher_domain: The verified publisher domain for the application.
        :param pulumi.Input[builtins.int] requested_access_token_version: The access token version expected by this resource. Must be one of `1` or `2`, and must be `2` when `sign_in_audience` is either `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount` Defaults to `2`.
        :param pulumi.Input[builtins.str] service_management_reference: References application context information from a Service or Asset Management database.
        :param pulumi.Input[builtins.str] sign_in_audience: The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.
        :param pulumi.Input[builtins.str] support_url: URL of the support page for the application.
        :param pulumi.Input[builtins.str] terms_of_service_url: URL of the terms of service statement for the application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationRegistrationState.__new__(_ApplicationRegistrationState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled_by_microsoft"] = disabled_by_microsoft
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["group_membership_claims"] = group_membership_claims
        __props__.__dict__["homepage_url"] = homepage_url
        __props__.__dict__["implicit_access_token_issuance_enabled"] = implicit_access_token_issuance_enabled
        __props__.__dict__["implicit_id_token_issuance_enabled"] = implicit_id_token_issuance_enabled
        __props__.__dict__["logout_url"] = logout_url
        __props__.__dict__["marketing_url"] = marketing_url
        __props__.__dict__["notes"] = notes
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["privacy_statement_url"] = privacy_statement_url
        __props__.__dict__["publisher_domain"] = publisher_domain
        __props__.__dict__["requested_access_token_version"] = requested_access_token_version
        __props__.__dict__["service_management_reference"] = service_management_reference
        __props__.__dict__["sign_in_audience"] = sign_in_audience
        __props__.__dict__["support_url"] = support_url
        __props__.__dict__["terms_of_service_url"] = terms_of_service_url
        return ApplicationRegistration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[builtins.str]:
        """
        The Client ID for the application, which is globally unique.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the application, as shown to end users.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disabledByMicrosoft")
    def disabled_by_microsoft(self) -> pulumi.Output[builtins.str]:
        """
        Whether Microsoft has disabled the registered application. If the application is disabled, this will be a string indicating the status/reason, e.g. `DisabledDueToViolationOfServicesAgreement`
        """
        return pulumi.get(self, "disabled_by_microsoft")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name for the application.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="groupMembershipClaims")
    def group_membership_claims(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Configures the `groups` claim issued in a user or OAuth access token that the app expects. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
        """
        return pulumi.get(self, "group_membership_claims")

    @property
    @pulumi.getter(name="homepageUrl")
    def homepage_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Home page or landing page of the application.
        """
        return pulumi.get(self, "homepage_url")

    @property
    @pulumi.getter(name="implicitAccessTokenIssuanceEnabled")
    def implicit_access_token_issuance_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether this web application can request an access token using OAuth implicit flow.
        """
        return pulumi.get(self, "implicit_access_token_issuance_enabled")

    @property
    @pulumi.getter(name="implicitIdTokenIssuanceEnabled")
    def implicit_id_token_issuance_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether this web application can request an ID token using OAuth implicit flow.
        """
        return pulumi.get(self, "implicit_id_token_issuance_enabled")

    @property
    @pulumi.getter(name="logoutUrl")
    def logout_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URL that will be used by Microsoft's authorization service to sign out a user using front-channel, back-channel or SAML logout protocols.
        """
        return pulumi.get(self, "logout_url")

    @property
    @pulumi.getter(name="marketingUrl")
    def marketing_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL of the marketing page for the application.
        """
        return pulumi.get(self, "marketing_url")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-specified notes relevant for the management of the application.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[builtins.str]:
        """
        The object ID of the application within the tenant.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="privacyStatementUrl")
    def privacy_statement_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL of the privacy statement for the application.
        """
        return pulumi.get(self, "privacy_statement_url")

    @property
    @pulumi.getter(name="publisherDomain")
    def publisher_domain(self) -> pulumi.Output[builtins.str]:
        """
        The verified publisher domain for the application.
        """
        return pulumi.get(self, "publisher_domain")

    @property
    @pulumi.getter(name="requestedAccessTokenVersion")
    def requested_access_token_version(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The access token version expected by this resource. Must be one of `1` or `2`, and must be `2` when `sign_in_audience` is either `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount` Defaults to `2`.
        """
        return pulumi.get(self, "requested_access_token_version")

    @property
    @pulumi.getter(name="serviceManagementReference")
    def service_management_reference(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        References application context information from a Service or Asset Management database.
        """
        return pulumi.get(self, "service_management_reference")

    @property
    @pulumi.getter(name="signInAudience")
    def sign_in_audience(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg`, `AzureADMultipleOrgs`, `AzureADandPersonalMicrosoftAccount` or `PersonalMicrosoftAccount`. Defaults to `AzureADMyOrg`.
        """
        return pulumi.get(self, "sign_in_audience")

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL of the support page for the application.
        """
        return pulumi.get(self, "support_url")

    @property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL of the terms of service statement for the application.
        """
        return pulumi.get(self, "terms_of_service_url")

