# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAccessPackageCatalogResult',
    'AwaitableGetAccessPackageCatalogResult',
    'get_access_package_catalog',
    'get_access_package_catalog_output',
]

@pulumi.output_type
class GetAccessPackageCatalogResult:
    """
    A collection of values returned by getAccessPackageCatalog.
    """
    def __init__(__self__, description=None, display_name=None, externally_visible=None, id=None, object_id=None, published=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if externally_visible and not isinstance(externally_visible, bool):
            raise TypeError("Expected argument 'externally_visible' to be a bool")
        pulumi.set(__self__, "externally_visible", externally_visible)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if object_id and not isinstance(object_id, str):
            raise TypeError("Expected argument 'object_id' to be a str")
        pulumi.set(__self__, "object_id", object_id)
        if published and not isinstance(published, bool):
            raise TypeError("Expected argument 'published' to be a bool")
        pulumi.set(__self__, "published", published)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the access package catalog.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externallyVisible")
    def externally_visible(self) -> builtins.bool:
        """
        Whether the access packages in this catalog can be requested by users outside the tenant.
        """
        return pulumi.get(self, "externally_visible")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> builtins.str:
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter
    def published(self) -> builtins.bool:
        """
        Whether the access packages in this catalog are available for management.
        """
        return pulumi.get(self, "published")


class AwaitableGetAccessPackageCatalogResult(GetAccessPackageCatalogResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessPackageCatalogResult(
            description=self.description,
            display_name=self.display_name,
            externally_visible=self.externally_visible,
            id=self.id,
            object_id=self.object_id,
            published=self.published)


def get_access_package_catalog(display_name: Optional[builtins.str] = None,
                               object_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessPackageCatalogResult:
    """
    i
    Use this resource to retrieve information for an existing access package catalog within Identity Governance in Azure Active Directory.

    ## API Permissions

    The following API permissions are required in order to use this data source.

    When authenticated with a service principal, this data source requires one of the following application roles: `EntitlementManagement.Read.All`, or `EntitlementManagement.ReadWrite.All`.

    When authenticated with a user principal, this data source requires one of the following directory roles: `Catalog owner`, `Catalog reader`, `Global Reader`, or `Global Administrator`.

    ## Example Usage

    *Look up by ID*

    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_access_package_catalog(object_id="00000000-0000-0000-0000-000000000000")
    ```

    *Look up by DisplayName*

    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_access_package_catalog(display_name="My access package Catalog")
    ```


    :param builtins.str display_name: The display name of the access package catalog.
    :param builtins.str object_id: The ID of this access package catalog.
           
           > One of `display_name` or `object_id` must be specified.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['objectId'] = object_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuread:index/getAccessPackageCatalog:getAccessPackageCatalog', __args__, opts=opts, typ=GetAccessPackageCatalogResult).value

    return AwaitableGetAccessPackageCatalogResult(
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        externally_visible=pulumi.get(__ret__, 'externally_visible'),
        id=pulumi.get(__ret__, 'id'),
        object_id=pulumi.get(__ret__, 'object_id'),
        published=pulumi.get(__ret__, 'published'))
def get_access_package_catalog_output(display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      object_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessPackageCatalogResult]:
    """
    i
    Use this resource to retrieve information for an existing access package catalog within Identity Governance in Azure Active Directory.

    ## API Permissions

    The following API permissions are required in order to use this data source.

    When authenticated with a service principal, this data source requires one of the following application roles: `EntitlementManagement.Read.All`, or `EntitlementManagement.ReadWrite.All`.

    When authenticated with a user principal, this data source requires one of the following directory roles: `Catalog owner`, `Catalog reader`, `Global Reader`, or `Global Administrator`.

    ## Example Usage

    *Look up by ID*

    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_access_package_catalog(object_id="00000000-0000-0000-0000-000000000000")
    ```

    *Look up by DisplayName*

    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_access_package_catalog(display_name="My access package Catalog")
    ```


    :param builtins.str display_name: The display name of the access package catalog.
    :param builtins.str object_id: The ID of this access package catalog.
           
           > One of `display_name` or `object_id` must be specified.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['objectId'] = object_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuread:index/getAccessPackageCatalog:getAccessPackageCatalog', __args__, opts=opts, typ=GetAccessPackageCatalogResult)
    return __ret__.apply(lambda __response__: GetAccessPackageCatalogResult(
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        externally_visible=pulumi.get(__response__, 'externally_visible'),
        id=pulumi.get(__response__, 'id'),
        object_id=pulumi.get(__response__, 'object_id'),
        published=pulumi.get(__response__, 'published')))
