# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAccessPackageCatalogRoleResult',
    'AwaitableGetAccessPackageCatalogRoleResult',
    'get_access_package_catalog_role',
    'get_access_package_catalog_role_output',
]

@pulumi.output_type
class GetAccessPackageCatalogRoleResult:
    """
    A collection of values returned by getAccessPackageCatalogRole.
    """
    def __init__(__self__, description=None, display_name=None, id=None, object_id=None, template_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if object_id and not isinstance(object_id, str):
            raise TypeError("Expected argument 'object_id' to be a str")
        pulumi.set(__self__, "object_id", object_id)
        if template_id and not isinstance(template_id, str):
            raise TypeError("Expected argument 'template_id' to be a str")
        pulumi.set(__self__, "template_id", template_id)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the role.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> builtins.str:
        """
        The object ID of the role.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> builtins.str:
        """
        The object ID of the role.
        """
        return pulumi.get(self, "template_id")


class AwaitableGetAccessPackageCatalogRoleResult(GetAccessPackageCatalogRoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessPackageCatalogRoleResult(
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            object_id=self.object_id,
            template_id=self.template_id)


def get_access_package_catalog_role(display_name: Optional[builtins.str] = None,
                                    object_id: Optional[builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessPackageCatalogRoleResult:
    """
    Gets information about an access package catalog role.

    ## API Permissions

    The following API permissions are required in order to use this data source.

    When authenticated with a service principal, this data source requires one of the following application roles: `EntitlementManagement.Read.All` or `Directory.Read.All`

    When authenticated with a user principal, this data source does not require any additional roles.

    ## Example Usage

    ### By Group Display Name)

    *Look up by display name*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_access_package_catalog_role(display_name="Catalog owner")
    ```

    *Look up by object ID*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_access_package_catalog_role(object_id="00000000-0000-0000-0000-000000000000")
    ```


    :param builtins.str display_name: Specifies the display name of the role.
    :param builtins.str object_id: Specifies the object ID of the role.
           
           > One of `display_name` or `object_id` must be specified.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['objectId'] = object_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuread:index/getAccessPackageCatalogRole:getAccessPackageCatalogRole', __args__, opts=opts, typ=GetAccessPackageCatalogRoleResult).value

    return AwaitableGetAccessPackageCatalogRoleResult(
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        object_id=pulumi.get(__ret__, 'object_id'),
        template_id=pulumi.get(__ret__, 'template_id'))
def get_access_package_catalog_role_output(display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                           object_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessPackageCatalogRoleResult]:
    """
    Gets information about an access package catalog role.

    ## API Permissions

    The following API permissions are required in order to use this data source.

    When authenticated with a service principal, this data source requires one of the following application roles: `EntitlementManagement.Read.All` or `Directory.Read.All`

    When authenticated with a user principal, this data source does not require any additional roles.

    ## Example Usage

    ### By Group Display Name)

    *Look up by display name*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_access_package_catalog_role(display_name="Catalog owner")
    ```

    *Look up by object ID*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_access_package_catalog_role(object_id="00000000-0000-0000-0000-000000000000")
    ```


    :param builtins.str display_name: Specifies the display name of the role.
    :param builtins.str object_id: Specifies the object ID of the role.
           
           > One of `display_name` or `object_id` must be specified.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['objectId'] = object_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuread:index/getAccessPackageCatalogRole:getAccessPackageCatalogRole', __args__, opts=opts, typ=GetAccessPackageCatalogRoleResult)
    return __ret__.apply(lambda __response__: GetAccessPackageCatalogRoleResult(
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        object_id=pulumi.get(__response__, 'object_id'),
        template_id=pulumi.get(__response__, 'template_id')))
