# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetApplicationPublishedAppIdsResult',
    'AwaitableGetApplicationPublishedAppIdsResult',
    'get_application_published_app_ids',
    'get_application_published_app_ids_output',
]

@pulumi.output_type
class GetApplicationPublishedAppIdsResult:
    """
    A collection of values returned by getApplicationPublishedAppIds.
    """
    def __init__(__self__, id=None, result=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if result and not isinstance(result, dict):
            raise TypeError("Expected argument 'result' to be a dict")
        pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def result(self) -> Mapping[str, builtins.str]:
        """
        A map of application names to application IDs.
        """
        return pulumi.get(self, "result")


class AwaitableGetApplicationPublishedAppIdsResult(GetApplicationPublishedAppIdsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationPublishedAppIdsResult(
            id=self.id,
            result=self.result)


def get_application_published_app_ids(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationPublishedAppIdsResult:
    """
    ## Example Usage

    *Listing well-known application IDs*

    ```python
    import pulumi
    import pulumi_azuread as azuread

    well_known = azuread.get_application_published_app_ids()
    pulumi.export("publishedAppIds", well_known.result)
    ```

    *Granting access to an application*

    ```python
    import pulumi
    import pulumi_azuread as azuread

    well_known = azuread.get_application_published_app_ids()
    msgraph = azuread.ServicePrincipal("msgraph",
        client_id=well_known.result["MicrosoftGraph"],
        use_existing=True)
    example = azuread.Application("example",
        display_name="example",
        required_resource_accesses=[{
            "resource_app_id": well_known.result["MicrosoftGraph"],
            "resource_accesses": [
                {
                    "id": msgraph.app_role_ids["User.Read.All"],
                    "type": "Role",
                },
                {
                    "id": msgraph.oauth2_permission_scope_ids["User.ReadWrite"],
                    "type": "Scope",
                },
            ],
        }])
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuread:index/getApplicationPublishedAppIds:getApplicationPublishedAppIds', __args__, opts=opts, typ=GetApplicationPublishedAppIdsResult).value

    return AwaitableGetApplicationPublishedAppIdsResult(
        id=pulumi.get(__ret__, 'id'),
        result=pulumi.get(__ret__, 'result'))
def get_application_published_app_ids_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationPublishedAppIdsResult]:
    """
    ## Example Usage

    *Listing well-known application IDs*

    ```python
    import pulumi
    import pulumi_azuread as azuread

    well_known = azuread.get_application_published_app_ids()
    pulumi.export("publishedAppIds", well_known.result)
    ```

    *Granting access to an application*

    ```python
    import pulumi
    import pulumi_azuread as azuread

    well_known = azuread.get_application_published_app_ids()
    msgraph = azuread.ServicePrincipal("msgraph",
        client_id=well_known.result["MicrosoftGraph"],
        use_existing=True)
    example = azuread.Application("example",
        display_name="example",
        required_resource_accesses=[{
            "resource_app_id": well_known.result["MicrosoftGraph"],
            "resource_accesses": [
                {
                    "id": msgraph.app_role_ids["User.Read.All"],
                    "type": "Role",
                },
                {
                    "id": msgraph.oauth2_permission_scope_ids["User.ReadWrite"],
                    "type": "Scope",
                },
            ],
        }])
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuread:index/getApplicationPublishedAppIds:getApplicationPublishedAppIds', __args__, opts=opts, typ=GetApplicationPublishedAppIdsResult)
    return __ret__.apply(lambda __response__: GetApplicationPublishedAppIdsResult(
        id=pulumi.get(__response__, 'id'),
        result=pulumi.get(__response__, 'result')))
