"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Artifacts definition for a CodeBuild Project.
 */
class Artifacts {
    static s3(props) {
        return new S3Artifacts(props);
    }
    constructor(props) {
        this.identifier = props.identifier;
    }
    bind(_scope, _project) {
        return {
            artifactsProperty: {
                artifactIdentifier: this.identifier,
                type: this.type,
            },
        };
    }
}
exports.Artifacts = Artifacts;
/**
 * S3 Artifact definition for a CodeBuild Project.
 */
class S3Artifacts extends Artifacts {
    constructor(props) {
        super(props);
        this.props = props;
        this.type = 'S3';
    }
    bind(_scope, project) {
        this.props.bucket.grantReadWrite(project);
        const superConfig = super.bind(_scope, project);
        return {
            artifactsProperty: {
                ...superConfig.artifactsProperty,
                location: this.props.bucket.bucketName,
                path: this.props.path,
                namespaceType: this.props.includeBuildId === false ? 'NONE' : 'BUILD_ID',
                name: this.props.name,
                packaging: this.props.packageZip === false ? 'NONE' : 'ZIP',
            }
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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