/**
 * Event fields for the CodeBuild "state change" event
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 */
export declare class StateChangeEvent {
    /**
     * The triggering build's status
     */
    static readonly buildStatus: string;
    /**
     * The triggering build's project name
     */
    static readonly projectName: string;
    /**
     * Return the build id
     */
    static readonly buildId: string;
    static readonly currentPhase: string;
    private constructor();
}
/**
 * Event fields for the CodeBuild "phase change" event
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 */
export declare class PhaseChangeEvent {
    /**
     * The triggering build's project name
     */
    static readonly projectName: string;
    /**
     * The triggering build's id
     */
    static readonly buildId: string;
    /**
     * The phase that was just completed
     */
    static readonly completedPhase: string;
    /**
     * The status of the completed phase
     */
    static readonly completedPhaseStatus: string;
    /**
     * The duration of the completed phase
     */
    static readonly completedPhaseDurationSeconds: string;
    /**
     * Whether the build is complete
     */
    static readonly buildComplete: string;
    private constructor();
}
