"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const source_1 = require("./source");
const source_types_1 = require("./source-types");
/**
 * A `NO_SOURCE` CodeBuild Project Source definition.
 * This is the default source type,
 * if none was specified when creating the Project.
 * *Note*: the `NO_SOURCE` type cannot be used as a secondary source,
 * and because of that, you're not allowed to specify an identifier for it.
 *
 * This class is private to the aws-codebuild package.
 */
class NoSource extends source_1.Source {
    constructor() {
        super({});
        this.type = source_types_1.NO_SOURCE_TYPE;
    }
}
exports.NoSource = NoSource;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm8tc291cmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibm8tc291cmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQWtDO0FBQ2xDLGlEQUFnRDtBQUVoRDs7Ozs7Ozs7R0FRRztBQUNILE1BQWEsUUFBUyxTQUFRLGVBQU07SUFHbEM7UUFDRSxLQUFLLENBQUMsRUFBRSxDQUFDLENBQUM7UUFISSxTQUFJLEdBQUcsNkJBQWMsQ0FBQztJQUl0QyxDQUFDO0NBQ0Y7QUFORCw0QkFNQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFNvdXJjZSB9IGZyb20gJy4vc291cmNlJztcbmltcG9ydCB7IE5PX1NPVVJDRV9UWVBFIH0gZnJvbSAnLi9zb3VyY2UtdHlwZXMnO1xuXG4vKipcbiAqIEEgYE5PX1NPVVJDRWAgQ29kZUJ1aWxkIFByb2plY3QgU291cmNlIGRlZmluaXRpb24uXG4gKiBUaGlzIGlzIHRoZSBkZWZhdWx0IHNvdXJjZSB0eXBlLFxuICogaWYgbm9uZSB3YXMgc3BlY2lmaWVkIHdoZW4gY3JlYXRpbmcgdGhlIFByb2plY3QuXG4gKiAqTm90ZSo6IHRoZSBgTk9fU09VUkNFYCB0eXBlIGNhbm5vdCBiZSB1c2VkIGFzIGEgc2Vjb25kYXJ5IHNvdXJjZSxcbiAqIGFuZCBiZWNhdXNlIG9mIHRoYXQsIHlvdSdyZSBub3QgYWxsb3dlZCB0byBzcGVjaWZ5IGFuIGlkZW50aWZpZXIgZm9yIGl0LlxuICpcbiAqIFRoaXMgY2xhc3MgaXMgcHJpdmF0ZSB0byB0aGUgYXdzLWNvZGVidWlsZCBwYWNrYWdlLlxuICovXG5leHBvcnQgY2xhc3MgTm9Tb3VyY2UgZXh0ZW5kcyBTb3VyY2Uge1xuICBwdWJsaWMgcmVhZG9ubHkgdHlwZSA9IE5PX1NPVVJDRV9UWVBFO1xuXG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIHN1cGVyKHt9KTtcbiAgfVxufVxuIl19