#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const codebuild = require("../lib");
const cache_1 = require("../lib/cache");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-codebuild');
const bucket = new s3.Bucket(stack, 'CacheBucket', {
    removalPolicy: cdk.RemovalPolicy.DESTROY
});
new codebuild.Project(stack, 'MyProject', {
    cache: cache_1.Cache.bucket(bucket),
    buildSpec: codebuild.BuildSpec.fromObject({
        build: {
            commands: ['echo Hello']
        },
        cache: {
            paths: ['/root/.cache/pip/**/*']
        }
    })
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY2FjaGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLmNhY2hpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0Esc0NBQXVDO0FBQ3ZDLHFDQUFzQztBQUN0QyxvQ0FBcUM7QUFDckMsd0NBQXFDO0FBRXJDLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztBQUV0RCxNQUFNLE1BQU0sR0FBRyxJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLGFBQWEsRUFBRTtJQUNqRCxhQUFhLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxPQUFPO0NBQ3pDLENBQUMsQ0FBQztBQUVILElBQUksU0FBUyxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFO0lBQ3hDLEtBQUssRUFBRSxhQUFLLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQztJQUMzQixTQUFTLEVBQUUsU0FBUyxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUM7UUFDeEMsS0FBSyxFQUFFO1lBQ0wsUUFBUSxFQUFFLENBQUMsWUFBWSxDQUFDO1NBQ3pCO1FBQ0QsS0FBSyxFQUFFO1lBQ0wsS0FBSyxFQUFFLENBQUMsdUJBQXVCLENBQUM7U0FDakM7S0FDRixDQUFDO0NBQ0gsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiIyEvdXNyL2Jpbi9lbnYgbm9kZVxuaW1wb3J0IHMzID0gcmVxdWlyZSgnQGF3cy1jZGsvYXdzLXMzJyk7XG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY29yZScpO1xuaW1wb3J0IGNvZGVidWlsZCA9IHJlcXVpcmUoJy4uL2xpYicpO1xuaW1wb3J0IHsgQ2FjaGUgfSBmcm9tICcuLi9saWIvY2FjaGUnO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWNkay1jb2RlYnVpbGQnKTtcblxuY29uc3QgYnVja2V0ID0gbmV3IHMzLkJ1Y2tldChzdGFjaywgJ0NhY2hlQnVja2V0Jywge1xuICByZW1vdmFsUG9saWN5OiBjZGsuUmVtb3ZhbFBvbGljeS5ERVNUUk9ZXG59KTtcblxubmV3IGNvZGVidWlsZC5Qcm9qZWN0KHN0YWNrLCAnTXlQcm9qZWN0Jywge1xuICBjYWNoZTogQ2FjaGUuYnVja2V0KGJ1Y2tldCksXG4gIGJ1aWxkU3BlYzogY29kZWJ1aWxkLkJ1aWxkU3BlYy5mcm9tT2JqZWN0KHtcbiAgICBidWlsZDoge1xuICAgICAgY29tbWFuZHM6IFsnZWNobyBIZWxsbyddXG4gICAgfSxcbiAgICBjYWNoZToge1xuICAgICAgcGF0aHM6IFsnL3Jvb3QvLmNhY2hlL3BpcC8qKi8qJ11cbiAgICB9XG4gIH0pXG59KTtcblxuYXBwLnN5bnRoKCk7XG4iXX0=