import { Test } from 'nodeunit';
declare const _default: {
    'default properties': {
        'with CodePipeline source'(test: Test): void;
        'with CodeCommit source'(test: Test): void;
        'with S3Bucket source'(test: Test): void;
        'with GitHub source'(test: Test): void;
        'with GitHubEnterprise source'(test: Test): void;
        'with Bitbucket source'(test: Test): void;
        'fail creating a Project when no build spec is given'(test: Test): void;
        'with VPC configuration'(test: Test): void;
        'without VPC configuration but security group identified'(test: Test): void;
        'with VPC configuration but allowAllOutbound identified'(test: Test): void;
        'without passing a VPC cannot access the connections property'(test: Test): void;
        'with a KMS Key adds decrypt permissions to the CodeBuild Role'(test: Test): void;
    };
    'using timeout and path in S3 artifacts sets it correctly'(test: Test): void;
    'secondary sources': {
        'require providing an identifier when creating a Project'(test: Test): void;
        'are not allowed for a Project with CodePipeline as Source'(test: Test): void;
        'added with an identifer after the Project has been created are rendered in the template'(test: Test): void;
    };
    'secondary artifacts': {
        'require providing an identifier when creating a Project'(test: Test): void;
        'are not allowed for a Project with CodePipeline as Source'(test: Test): void;
        'added with an identifier after the Project has been created are rendered in the template'(test: Test): void;
    };
    'artifacts': {
        'CodePipeline': {
            'both source and artifacs are set to CodePipeline'(test: Test): void;
        };
    };
    'events'(test: Test): void;
    'environment variables can be overridden at the project level'(test: Test): void;
    '.metricXxx() methods can be used to obtain Metrics for CodeBuild projects'(test: Test): void;
    'using ComputeType.Small with a Windows image fails validation'(test: Test): void;
    'badge support test'(test: Test): void;
    'webhook Filters': {
        'a Group cannot be created with an empty set of event actions'(test: Test): void;
        'cannot have base ref conditions if the Group contains the PUSH action'(test: Test): void;
        'cannot have file path conditions if the Group contains any action other than PUSH'(test: Test): void;
        'BitBucket sources do not support the PULL_REQUEST_REOPENED event action'(test: Test): void;
        'BitBucket sources do not support file path conditions'(test: Test): void;
    };
};
export = _default;
