"""Tests for the sportsreference player model class."""
import datetime
import os
import unittest

import requests_mock
from scrapesession.scrapesession import ScrapeSession
from sportsball.data.sportsreference.sportsreference_player_model import create_sportsreference_player_model
from sportsball.data.sex import Sex


class TestSportsReferencePlayerModel(unittest.TestCase):

    def setUp(self):
        self.session = ScrapeSession(backend="memory")
        self.dir = os.path.dirname(__file__)

    def test_field_goals(self):
        url = "https://www.basketball-reference.com/players/b/barnesc01.html"
        with requests_mock.Mocker() as m:
            with open(os.path.join(self.dir, "barnesc01.html"), "rb") as f:
                m.get(url, content=f.read())
            player_model = create_sportsreference_player_model(
                session=self.session,
                player_url=url,
                fg={"Scottie Barnes": 8},
                fga={},
                offensive_rebounds={},
                assists={},
                turnovers={},
                positions={},
                positions_validator={},
                sex=Sex.MALE,
                dt=datetime.datetime(2022, 10, 10),
                minutes_played={},
                three_point_field_goals={},
                three_point_field_goals_attempted={},
                free_throws={},
                free_throws_attempted={},
                defensive_rebounds={},
                steals={},
                blocks={},
                personal_fouls={},
                points={},
                game_scores={},
                point_differentials={},
                goals={},
                penalties_in_minutes={},
                even_strength_goals={},
                power_play_goals={},
                short_handed_goals={},
                game_winning_goals={},
                even_strength_assists={},
                power_play_assists={},
                short_handed_assists={},
                shots_on_goal={},
                shooting_percentage={},
                shifts={},
                time_on_ice={},
                decision={},
                goals_against={},
                shots_against={},
                saves={},
                save_percentage={},
                shutouts={},
                individual_corsi_for_events={},
                on_shot_ice_for_events={},
                on_shot_ice_against_events={},
                corsi_for_percentage={},
                relative_corsi_for_percentage={},
                offensive_zone_starts={},
                defensive_zone_starts={},
                offensive_zone_start_percentage={},
                hits={},
                true_shooting_percentage={},
                at_bats={},
                runs_scored={},
                runs_batted_in={},
                bases_on_balls={},
                strikeouts={},
                plate_appearances={},
                hits_at_bats={},
                obp={},
                slg={},
                ops={},
                pitches={},
                strikes={},
                win_probability_added={},
                average_leverage_index={},
                wpa_plus={},
                wpa_minus={},
                cwpa={},
                acli={},
                re24={},
                putouts={},
                innings_pitched={},
                earned_runs={},
                home_runs={},
                era={},
                batters_faced={},
                strikes_by_contact={},
                strikes_swinging={},
                strikes_looking={},
                ground_balls={},
                fly_balls={},
                line_drives={},
                inherited_runners={},
                inherited_scores={},
                effective_field_goal_percentage={},
                penalty_kicks_made={},
                penalty_kicks_attempted={},
                shots_total={},
                shots_on_target={},
                yellow_cards={},
                red_cards={},
                touches={},
                expected_goals={},
                non_penalty_expected_goals={},
                expected_assisted_goals={},
                shot_creating_actions={},
                goal_creating_actions={},
                passes_completed={},
                passes_attempted={},
                pass_completion={},
                progressive_passes={},
                carries={},
                progressive_carries={},
                take_ons_attempted={},
                successful_take_ons={},
                total_passing_distance={},
                progressive_passing_distance={},
                passes_completed_short={},
                passes_attempted_short={},
                pass_completion_short={},
                passes_completed_medium={},
                passes_attempted_medium={},
                pass_completion_medium={},
                passes_completed_long={},
                passes_attempted_long={},
                pass_completion_long={},
                expected_assists={},
                key_passes={},
                passes_into_final_third={},
                passes_into_penalty_area={},
                crosses_into_penalty_area={},
                live_ball_passes={},
                dead_ball_passes={},
                passes_from_free_kicks={},
                through_balls={},
                switches={},
                crosses={},
                throw_ins_taken={},
                corner_kicks={},
                inswinging_corner_kicks={},
                outswinging_corner_kicks={},
                straight_corner_kicks={},
                passes_offside={},
                passes_blocked={},
                tackles_won={},
                tackles_in_defensive_third={},
                tackles_in_middle_third={},
                tackles_in_attacking_third={},
                dribblers_tackled={},
                dribbles_challenged={},
                percent_of_dribblers_tackled={},
                challenges_lost={},
                shots_blocked={},
                tackles_plus_interceptions={},
                errors={},
                touches_in_defensive_penalty_area={},
                touches_in_defensive_third={},
                touches_in_middle_third={},
                touches_in_attacking_third={},
                touches_in_attacking_penalty_area={},
                live_ball_touches={},
                successful_take_on_percentage={},
                times_tackled_during_take_ons={},
                tackled_during_take_ons_percentage={},
                total_carrying_distance={},
                progressive_carrying_distance={},
                carries_into_final_third={},
                carries_into_penalty_area={},
                miscontrols={},
                dispossessed={},
                passes_received={},
                progressive_passes_received={},
                second_yellow_card={},
                fouls_committed={},
                fouls_drawn={},
                offsides={},
                penalty_kicks_won={},
                penalty_kicks_conceded={},
                own_goals={},
                ball_recoveries={},
                aerials_won={},
                aerials_lost={},
                percentage_of_aerials_won={},
                shots_on_target_against={},
                post_shot_expected_goals={},
                passes_attempted_minus_goal_kicks={},
                throws_attempted={},
                percentage_of_passes_that_were_launched={},
                average_pass_length={},
                goal_kicks_attempted={},
                percentage_of_goal_kicks_that_were_launched={},
                average_goal_kick_length={},
                crosses_faced={},
                crosses_stopped={},
                percentage_crosses_stopped={},
                defensive_actions_outside_penalty_area={},
                average_distance_of_defensive_actions={},
                three_point_attempt_rate={},
                tackles={},
                interceptions={},
                clearances={},
                free_throw_attempt_rate={},
                offensive_rebound_percentage={},
                defensive_rebound_percentage={},
                total_rebound_percentage={},
                assist_percentage={},
                steal_percentage={},
                block_percentage={},
                turnover_percentage={},
                usage_percentage={},
                offensive_rating={},
                defensive_rating={},
                box_plus_minus={},
            )
            self.assertEqual(player_model.field_goals, 8)
