"""Universal foreground color palette with carefully curated colors."""

from enum import Enum


class ForeUniversal(Enum):
  """Universal foreground color palette with carefully curated colors."""

  # Blues
  BLUE = 0x2196F3  # Material Blue 500
  OKABE_BLUE = 0x0072B2  # Okabe-Ito Blue
  INDIGO = 0x3F51B5  # Material Indigo 500
  SKY_BLUE = 0x56B4E9  # Sky Blue

  # Greens
  BLUISH_GREEN = 0x009E73  # Bluish Green
  GREEN = 0x4CAF50  # Material Green 500
  DARK_GREEN = 0x08780D  # Dark green
  TEAL = 0x009688  # Material Teal 500

  # Orange/Yellow
  ORANGE = 0xE69F00  # Okabe-Ito Orange
  MATERIAL_ORANGE = 0xFF9800  # Material Orange 500
  GOLD = 0xF39C12  # Muted Gold

  # Red/Magenta
  VERMILION = 0xD55E00  # Okabe-Ito Vermilion
  REDDISH_PURPLE = 0xCC79A7  # Reddish Purple

  # Purple
  PURPLE = 0x9C27B0  # Material Purple 500
  DEEP_PURPLE = 0x673AB7  # Material Deep Purple 500

  # Neutrals
  BLUE_GREY = 0x607D8B  # Material Blue Grey 500
  DARK_BROWN = 0x604030  # Material Brown 500
  BROWN = 0x795548  # Material Brown 500
  MEDIUM_GREY = 0x757575  # Medium Grey
  IBM_GREY = 0x8D8D8D  # IBM Gray 50
  LIGHT_GREY = 0xCCCCCC  # Light grey