## Problems and Limitations

### Meta-encoding based approach (ASP-Approach)

**Important Notes:**

- The Meta-encoding approach as it stands is not fully functional

**Problem:**

- In the meta encoding all facts (or a selection matching a certain signature)
  are transformed into assumptions which are then used as the assumption set
  for finding the MUC
- During the MUC search when subsets of this assumption set are fixed for
  satisfiability checking it is important that even though they are not fixed,
  the other assumptions are not assumed as false but as undefined
- This is currently not possible with the meta-encoding, since assumptions are
  chosen through a choice rule and all assumptions that aren't selected are
  defaulted to false
- This doesn't allow for properly checking if such subsets entail
  unsatisfiability and thus prevents us from finding the proper MUCs

### Specifying Assumption Set using only Signatures

**Important Notes:**

- clingo-explaid provides the `--muc` mode which gives you Minimal
  Unsatisfiable Cores for a given set of assumption signatures that can be
  defined with `-a`
- These signatures though allow not always for finding the best fitting MUC for
  a given encoding, compared to an assumption set generated by hand

**Problem:**

- Imagine this [example encoding](examples/misc/bad_mucs.lp):

```MATLAB
a(1..3).
:- a(X).

unsat.
:- unsat.
```

- So when I execute `clingexplaid examples/misc/bad_mucs.lp --muc 0` I get the
  MUCs:

```
MUC 1
a(3)
MUC 2
a(2)
MUC 3
a(1)
MUC 4
unsat
```

- So you would generally expect that executing
  `clingexplaid examples/misc/bad_mucs.lp --muc 0 -a/1` would return the first
  3 found MUCs from before
- But what actually happens is that there are no MUCs detected:

```
NO MUCS CONTAINED: The unsatisfiability of this program is not induced by the provided assumptions
UNSATISFIABLE
```

- This is actually due to an implicit `(unsat, False)` in the first 3 MUCs that
  isn't printed
- Since the standard mode of `--muc` converts all facts to choices when no `-a`
  is provided `a(1)`, `a(2)`, `a(3)`, and `unsat` are all converted to choices
- We know that for the program to become satisfiable `unsat` cannot be true
  (line 4)
- But since it is provided as a fact the choice rule conversion is necessary
  for the iterative deletion algorithm to find any MUCs
- This holds vice versa for the last MUC 4 just so that all `a/1` need to be
  converted to choice rules for the MUC to be found
