# Contributing to PortWatch

Thank you for your interest in contributing to PortWatch! ❤️

Whether you’re reporting a bug, suggesting a feature, or submitting code — we welcome your help.

---

## 🛠️ How to Contribute

### 1. Report Bugs or Suggest Features

Open an [Issue](https://github.com/yourusername/portwatch/issues) with:

- Clear title and description
- Steps to reproduce (for bugs)
- Expected vs actual behavior
- OS and Python version

### 2. Submit Code

1. Fork the repo
2. Create a feature branch: `git checkout -b feature/your-feature`
3. Commit your changes: `git commit -m "feat: your feature"`
4. Push to branch: `git push origin feature/your-feature`
5. Open a Pull Request

> ✅ Follow [Conventional Commits](https://www.conventionalcommits.org)  
> ✅ Write clear commit messages  
> ✅ Update `CHANGELOG.md` if needed

---

## 🧪 Development Setup

```bash
git clone https://github.com/yourusername/portwatch.git
cd portwatch
python -m venv venv
source venv/bin/activate    # Linux/macOS
venv\Scripts\activate       # Windows
pip install -e .