"""biar - batteries-included async requests tool for python."""

from biar.__metadata__ import (
    __author__,
    __description__,
    __license__,
    __title__,
    __url__,
    __version__,
)
from biar.errors import ContentCallbackError, PollError, ResponseEvaluationError
from biar.model import (
    Payload,
    PollConfig,
    ProxyConfig,
    RateLimiter,
    RequestConfig,
    Response,
    Retryer,
    StructuredResponse,
)
from biar.services import (
    get_ssl_context,
    is_host_reachable,
    poll,
    request,
    request_many,
    request_structured,
    request_structured_many,
)

__all__ = [
    "__title__",
    "__description__",
    "__version__",
    "__url__",
    "__author__",
    "__license__",
    "ProxyConfig",
    "RateLimiter",
    "Response",
    "RequestConfig",
    "Retryer",
    "StructuredResponse",
    "get_ssl_context",
    "is_host_reachable",
    "request",
    "request_structured",
    "request_structured_many",
    "ResponseEvaluationError",
    "request_many",
    "poll",
    "PollConfig",
    "PollError",
    "ContentCallbackError",
    "Payload",
]
