"""
`pytest` testing framework file for EQUiSat
"""

from satnogsdecoders import decoder
from tests.shared_methods import check_type, load_objects


def test_answer():  # pylint: disable=too-many-locals
    """
    `pytest` entry point
    """

    attitude = bytearray([
        0x57, 0x4c, 0x39, 0x58, 0x5a, 0x45, 0x7d, 0x6e, 0x00, 0x00, 0x21, 0xa5,
        0x09, 0x27, 0x02, 0xdf, 0xde, 0x58, 0x51, 0x04, 0x04, 0x27, 0x54, 0xe0,
        0xf1, 0xae, 0xb1, 0xb1, 0xb2, 0xe3, 0x39, 0xba, 0x39, 0xbf, 0x39, 0xaf,
        0x39, 0xa8, 0x39, 0x17, 0x3a, 0x56, 0x09, 0x82, 0x3f, 0x80, 0x82, 0x3f,
        0x81, 0x7f, 0x7f, 0x80, 0x77, 0x78, 0x79, 0x77, 0x78, 0x79, 0xe4, 0x6a,
        0x00, 0x00, 0xdd, 0x39, 0xbd, 0x39, 0xcb, 0x39, 0xaf, 0x39, 0xb7, 0x39,
        0x0b, 0x3a, 0x56, 0x09, 0x82, 0x3f, 0x81, 0x82, 0x3f, 0x80, 0x7f, 0x7f,
        0x80, 0x77, 0x78, 0x79, 0x77, 0x78, 0x79, 0x70, 0x66, 0x00, 0x00, 0xd4,
        0x39, 0xbb, 0x39, 0xc6, 0x39, 0xa1, 0x39, 0xac, 0x39, 0x03, 0x3a, 0x56,
        0x09, 0x82, 0x3f, 0x80, 0x82, 0x3f, 0x80, 0x7f, 0x7f, 0x80, 0x77, 0x78,
        0x79, 0x77, 0x78, 0x79, 0xfc, 0x61, 0x00, 0x00, 0xcf, 0x39, 0xb4, 0x39,
        0xbf, 0x39, 0x9b, 0x39, 0xa6, 0x39, 0xff, 0x39, 0x56, 0x09, 0x82, 0x3f,
        0x81, 0x82, 0x3f, 0x80, 0x7f, 0x7f, 0x80, 0x77, 0x78, 0x79, 0x77, 0x78,
        0x79, 0x88, 0x5d, 0x00, 0x00, 0xd5, 0x39, 0xac, 0x39, 0xac, 0x39, 0x9b,
        0x39, 0xa9, 0x39, 0xfb, 0x39, 0x56, 0x09, 0x82, 0x3f, 0x80, 0x82, 0x3f,
        0x80, 0x7f, 0x7f, 0x80, 0x77, 0x78, 0x79, 0x77, 0x78, 0x79, 0x14, 0x59,
        0x00, 0x00, 0xa7, 0x32, 0x52, 0x9b, 0x2a, 0x56, 0x9c, 0x2a, 0x56, 0x08,
        0x15, 0x00, 0x08, 0x15, 0x5a, 0x9c, 0x29, 0x5a, 0x9b, 0x30, 0x5e, 0x9b,
        0x30, 0x5e, 0xa2, 0x3e, 0x5e, 0x00, 0x00, 0xb8, 0xbf, 0x96, 0x6e, 0x88,
        0xd0, 0x86, 0x4f, 0x8b, 0xc4, 0xb6, 0x8a, 0x23, 0xf6, 0xa5, 0x4b, 0x58,
        0x5f, 0x5f, 0x84, 0x3d, 0x9d, 0xde, 0xd0, 0xc2, 0xe2, 0x52, 0xbd, 0xbe,
        0x1e, 0xbd, 0x85
    ])
    idle = bytearray([
        0x57, 0x4c, 0x39, 0x58, 0x5a, 0x45, 0x51, 0x36, 0x00, 0x00, 0x20, 0xa1,
        0x0b, 0x13, 0x02, 0xde, 0xe4, 0x51, 0x5d, 0x04, 0x04, 0x28, 0x54, 0xf0,
        0xb2, 0xaf, 0xb3, 0xae, 0xb1, 0x3e, 0xdf, 0xe3, 0x51, 0x5f, 0x04, 0x04,
        0x28, 0x54, 0xf0, 0xb2, 0x8f, 0x5a, 0x57, 0x57, 0x58, 0x56, 0x57, 0x58,
        0x8d, 0x34, 0x00, 0x00, 0x3e, 0xe2, 0xdf, 0x5d, 0x51, 0x04, 0x04, 0x28,
        0x54, 0xf0, 0xe1, 0x8f, 0x5a, 0x57, 0x57, 0x58, 0x56, 0x57, 0x58, 0x45,
        0x31, 0x00, 0x00, 0x3e, 0xdf, 0xe3, 0x51, 0x5c, 0x04, 0x04, 0x28, 0x54,
        0xf0, 0xb2, 0x8f, 0x5a, 0x57, 0x57, 0x58, 0x56, 0x57, 0x58, 0xfd, 0x2d,
        0x00, 0x00, 0x3e, 0xe1, 0xe4, 0x51, 0x5f, 0x04, 0x04, 0x28, 0x54, 0xf0,
        0xb2, 0x8f, 0x5a, 0x57, 0x57, 0x58, 0x56, 0x57, 0x58, 0xb5, 0x2a, 0x00,
        0x00, 0x3e, 0xe3, 0xe0, 0x5e, 0x51, 0x04, 0x04, 0x28, 0x55, 0xf0, 0xe1,
        0x8f, 0x5a, 0x57, 0x57, 0x58, 0x56, 0x57, 0x58, 0x6d, 0x27, 0x00, 0x00,
        0x3e, 0xdf, 0xe3, 0x51, 0x5c, 0x04, 0x04, 0x28, 0x54, 0xf0, 0xb2, 0x8f,
        0x5a, 0x57, 0x57, 0x58, 0x56, 0x57, 0x58, 0x25, 0x24, 0x00, 0x00, 0x3e,
        0xdf, 0xe3, 0x37, 0x60, 0x04, 0x04, 0x27, 0x4e, 0xf0, 0xb2, 0x8f, 0x5a,
        0x57, 0x57, 0x58, 0x56, 0x57, 0x58, 0xdd, 0x20, 0x00, 0x00, 0x08, 0x15,
        0x2a, 0x9c, 0x29, 0x2a, 0x9b, 0x30, 0x2e, 0x9b, 0x30, 0x2e, 0xa2, 0x3e,
        0x2e, 0xc6, 0x3e, 0x2e, 0xc6, 0x3e, 0x2e, 0xa2, 0x3e, 0x2e, 0x9b, 0x29,
        0x01, 0x9b, 0x29, 0x1a, 0x9b, 0x2a, 0x02, 0x30, 0xf0, 0x7b, 0x4a, 0x31,
        0x31, 0x2c, 0x9c, 0xf5, 0x12, 0x1e, 0xd6, 0xfe, 0xcc, 0xc6, 0xd0, 0x18,
        0x1e, 0x9e, 0xbe, 0x63, 0xeb, 0xa5, 0xe6, 0xb3, 0xd8, 0x95, 0xee, 0xb9,
        0xf5, 0xc2, 0xf1
    ])
    fb1 = bytearray([
        0x57, 0x4c, 0x39, 0x58, 0x5a, 0x45, 0x41, 0x00, 0x00, 0x00, 0x22, 0x97,
        0x0e, 0x3b, 0x02, 0xe2, 0xe0, 0x5c, 0x51, 0x04, 0x04, 0x28, 0x55, 0xf0,
        0xe1, 0xb1, 0xb4, 0xb1, 0xb4, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03,
        0x06, 0x03, 0x03, 0xd0, 0x39, 0xc8, 0x46, 0xd1, 0x39, 0xc9, 0x45, 0xd1,
        0x39, 0xc9, 0x45, 0xd1, 0x39, 0xc9, 0x45, 0x03, 0x06, 0x03, 0x03, 0x03,
        0x06, 0x03, 0x03, 0xb1, 0xb4, 0xb1, 0xb4, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2,
        0xa1, 0xa0, 0xa2, 0xa1, 0xa2, 0x9e, 0xa1, 0xa2, 0xa2, 0x9e, 0xa1, 0xaf,
        0xb3, 0xb3, 0xb2, 0xb1, 0xb3, 0xb0, 0xb3, 0x02, 0x02, 0x02, 0x00, 0x44,
        0x63, 0x4e, 0x3f, 0x47, 0x56, 0x4e, 0x3f, 0x5b, 0x58, 0x49, 0x3f, 0x42,
        0x53, 0x4e, 0x3c, 0x02, 0x02, 0x02, 0x00, 0x02, 0x02, 0x02, 0x00, 0x7f,
        0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
        0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x40, 0x00, 0x00, 0x00,
        0x9b, 0x30, 0x00, 0x9b, 0x30, 0x00, 0xa2, 0x3e, 0x00, 0xc6, 0x3e, 0x00,
        0xc6, 0x3e, 0x00, 0xa2, 0x3e, 0x00, 0x9b, 0x30, 0x00, 0x9b, 0x30, 0x00,
        0xa2, 0x3e, 0x00, 0xc6, 0x3e, 0x00, 0xc6, 0x3e, 0x00, 0xa2, 0x3e, 0x00,
        0x9b, 0x30, 0x00, 0x9b, 0x30, 0x00, 0x00, 0xc5, 0x1d, 0x74, 0x12, 0x02,
        0x14, 0xa6, 0x76, 0x9f, 0x81, 0x0b, 0x5a, 0xa7, 0x5f, 0x29, 0x02, 0x7a,
        0x5b, 0x14, 0x7d, 0xe2, 0x1a, 0xdd, 0x29, 0x33, 0x92, 0x05, 0x8b, 0x7e,
        0xf1, 0xcc, 0x0d
    ])
    fb2 = bytearray([
        0x57, 0x4c, 0x39, 0x58, 0x5a, 0x45, 0x41, 0x00, 0x00, 0x00, 0x22, 0x97,
        0x0e, 0x3b, 0x02, 0xe2, 0xe0, 0x5c, 0x51, 0x04, 0x04, 0x28, 0x55, 0xf0,
        0xe1, 0xb1, 0xb4, 0xb1, 0xb4, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03,
        0x06, 0x03, 0x03, 0xd0, 0x39, 0xc8, 0x46, 0xd1, 0x39, 0xc9, 0x45, 0xd1,
        0x39, 0xc9, 0x45, 0xd0, 0x39, 0xc9, 0x45, 0x03, 0x06, 0x03, 0x03, 0x03,
        0x06, 0x03, 0x03, 0xb1, 0xb3, 0xb1, 0xb4, 0xa2, 0xa2, 0xa3, 0xa0, 0xa2,
        0xa1, 0xa1, 0xa1, 0xa1, 0xa0, 0xa1, 0xa1, 0x9f, 0xa1, 0x9e, 0xa1, 0xb0,
        0xb3, 0xaf, 0xb2, 0xb2, 0xb3, 0xae, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x53,
        0x65, 0x49, 0x3f, 0x44, 0x5b, 0x47, 0x3f, 0x42, 0x56, 0x49, 0x37, 0x42,
        0x5d, 0x49, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f,
        0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
        0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x43, 0x00, 0x00, 0x00,
        0xa2, 0x3e, 0x00, 0xc6, 0x3e, 0x00, 0xc6, 0x3e, 0x00, 0xa2, 0x3e, 0x00,
        0x9b, 0x30, 0x00, 0x9b, 0x30, 0x00, 0xa2, 0x3e, 0x00, 0xc6, 0x3e, 0x00,
        0xc6, 0x3e, 0x00, 0xa2, 0x3e, 0x00, 0x9b, 0x30, 0x00, 0x9b, 0x30, 0x00,
        0xa2, 0x3e, 0x00, 0xc6, 0x3e, 0x00, 0x00, 0x86, 0x73, 0x8d, 0x67, 0x60,
        0xa8, 0x50, 0x99, 0xc7, 0xa5, 0xb6, 0xe5, 0xb9, 0x92, 0xa9, 0x5c, 0xc9,
        0x63, 0xc7, 0x70, 0x22, 0xf0, 0x71, 0x15, 0xf2, 0xc0, 0xe1, 0x4e, 0x89,
        0xcc, 0x0d, 0x1a
    ])
    fc1 = bytearray([
        0x57, 0x4c, 0x39, 0x58, 0x5a, 0x45, 0xd9, 0x03, 0x00, 0x00, 0x23, 0x96,
        0x0e, 0x27, 0x02, 0xe1, 0xe0, 0x5a, 0x51, 0x04, 0x04, 0x28, 0x55, 0xf0,
        0xe1, 0xb1, 0xb3, 0xaf, 0xb3, 0x39, 0x48, 0x3b, 0x30, 0x04, 0x04, 0xa7,
        0x2e, 0xa1, 0x38, 0xa3, 0xa4, 0xa3, 0xa4, 0x39, 0x48, 0x3b, 0x30, 0x77,
        0x78, 0x79, 0xc7, 0x03, 0x00, 0x00, 0x39, 0x48, 0x3b, 0x30, 0x04, 0x04,
        0xa7, 0x2e, 0xa1, 0x38, 0xa3, 0xa4, 0xa3, 0xa4, 0x39, 0x48, 0x3b, 0x30,
        0x77, 0x78, 0x79, 0xc7, 0x03, 0x00, 0x00, 0x39, 0x48, 0x3b, 0x30, 0x04,
        0x04, 0xa7, 0x2e, 0xa1, 0x38, 0xa3, 0xa4, 0xa3, 0xa4, 0x39, 0x48, 0x3b,
        0x30, 0x77, 0x78, 0x79, 0xc7, 0x03, 0x00, 0x00, 0x39, 0x48, 0x3b, 0x30,
        0x04, 0x04, 0xa7, 0x2e, 0xa1, 0x38, 0xa3, 0xa4, 0xa3, 0xa4, 0x39, 0x48,
        0x3b, 0x30, 0x77, 0x78, 0x79, 0xc7, 0x03, 0x00, 0x00, 0x39, 0x48, 0x3b,
        0x30, 0x04, 0x04, 0xa7, 0x2e, 0xa1, 0x38, 0xa3, 0xa4, 0xa3, 0xa4, 0x39,
        0x48, 0x3b, 0x30, 0x77, 0x78, 0x79, 0xc7, 0x03, 0x00, 0x00, 0x39, 0x48,
        0x3b, 0x30, 0x04, 0x04, 0xa7, 0x2e, 0xa1, 0x38, 0xa3, 0xa4, 0xa3, 0xa4,
        0x39, 0x48, 0x3b, 0x30, 0x77, 0x78, 0x79, 0xc7, 0x03, 0x00, 0x00, 0xa2,
        0x3e, 0x03, 0x9b, 0x30, 0x03, 0x9b, 0x30, 0x03, 0xa2, 0x3e, 0x03, 0xc6,
        0x3e, 0x03, 0xc6, 0x3e, 0x03, 0xa2, 0x3e, 0x03, 0x9b, 0x30, 0x03, 0x9b,
        0x30, 0x03, 0xa2, 0x3e, 0x03, 0xc6, 0x3e, 0x03, 0xc6, 0x3e, 0x03, 0xa2,
        0x3e, 0x03, 0x9b, 0x30, 0x03, 0x00, 0x00, 0x15, 0x2f, 0xaf, 0xcd, 0xb4,
        0xee, 0x49, 0x5e, 0xf2, 0x96, 0x9c, 0x22, 0x16, 0xbe, 0x05, 0xda, 0x81,
        0xca, 0x50, 0x49, 0xc4, 0x02, 0xdb, 0xbc, 0xd2, 0x17, 0x26, 0xb2, 0x10,
        0x1c, 0x06, 0xa4
    ])
    fc2 = bytearray([
        0x57, 0x4c, 0x39, 0x58, 0x5a, 0x45, 0x89, 0x71, 0x00, 0x00, 0x23, 0x96,
        0x0e, 0x27, 0x02, 0xe1, 0xdd, 0x60, 0x51, 0x04, 0x04, 0x28, 0x54, 0xf0,
        0xe1, 0xad, 0xb1, 0xb0, 0xb2, 0x3d, 0x48, 0x3b, 0x30, 0x04, 0x04, 0xa9,
        0x2c, 0xa2, 0x38, 0xa3, 0xa3, 0xa2, 0xa4, 0x3d, 0x48, 0x3b, 0x30, 0x77,
        0x78, 0x79, 0x87, 0x70, 0x00, 0x00, 0x3a, 0x48, 0x3b, 0x30, 0x04, 0x04,
        0xa8, 0x2d, 0xa3, 0x36, 0xa3, 0xa3, 0xa1, 0xa4, 0x3a, 0x48, 0x3b, 0x30,
        0x77, 0x78, 0x79, 0xc7, 0x6c, 0x00, 0x00, 0x38, 0x44, 0x39, 0x2d, 0x04,
        0x04, 0xa9, 0x2c, 0xa3, 0x34, 0xa3, 0xa3, 0xa2, 0xa3, 0x38, 0x44, 0x39,
        0x2d, 0x77, 0x78, 0x79, 0x07, 0x69, 0x00, 0x00, 0x39, 0x47, 0x39, 0x2d,
        0x04, 0x04, 0xaa, 0x2b, 0xa3, 0x35, 0xa2, 0xa3, 0xa1, 0xa4, 0x39, 0x47,
        0x39, 0x2d, 0x77, 0x78, 0x79, 0x47, 0x65, 0x00, 0x00, 0x33, 0x41, 0x36,
        0x2a, 0x04, 0x04, 0xaa, 0x2b, 0xa6, 0x32, 0xa2, 0xa3, 0xa0, 0xa3, 0x33,
        0x41, 0x36, 0x2a, 0x77, 0x78, 0x79, 0x87, 0x61, 0x00, 0x00, 0x35, 0x41,
        0x37, 0x2b, 0x04, 0x04, 0xaa, 0x2b, 0xa5, 0x32, 0xa3, 0xa3, 0xa0, 0xa3,
        0x35, 0x41, 0x37, 0x2b, 0x77, 0x78, 0x79, 0xc7, 0x5d, 0x00, 0x00, 0xa2,
        0x3e, 0x60, 0xc6, 0x3e, 0x60, 0xc6, 0x3e, 0x60, 0xa2, 0x3e, 0x60, 0x9b,
        0x29, 0x1c, 0x9b, 0x29, 0x4c, 0x9b, 0x2a, 0xff, 0x9c, 0x2a, 0x0c, 0x9c,
        0x29, 0x1c, 0xa7, 0x32, 0x54, 0x9b, 0x2a, 0x58, 0x9c, 0x2a, 0x58, 0x08,
        0x15, 0x01, 0x08, 0x15, 0x5c, 0x00, 0x00, 0x2f, 0x20, 0xf7, 0x71, 0xdb,
        0xa3, 0x61, 0x0d, 0x53, 0x3b, 0xf1, 0x30, 0x5a, 0x4f, 0x51, 0x6b, 0x74,
        0x8f, 0x0b, 0xcb, 0xb7, 0xa9, 0x4b, 0xe2, 0x1c, 0x79, 0x14, 0x49, 0x40,
        0x7d, 0x0d, 0xf8
    ])
    lp1 = bytearray([
        0x57, 0x4c, 0x39, 0x58, 0x5a, 0x45, 0x66, 0x00, 0x00, 0x00, 0x2c, 0x96,
        0x0e, 0x13, 0x01, 0x8f, 0x38, 0x58, 0x59, 0x04, 0x04, 0x00, 0x57, 0xfa,
        0xff, 0xe7, 0xe7, 0xe7, 0xe7, 0x1e, 0x90, 0x37, 0x58, 0x59, 0x04, 0x04,
        0x00, 0x57, 0xf2, 0xf6, 0x9a, 0x39, 0x9a, 0x39, 0x87, 0x39, 0x9b, 0x39,
        0xa6, 0x39, 0x8a, 0x39, 0x7f, 0x7f, 0x80, 0x65, 0x00, 0x00, 0x00, 0x1e,
        0xa3, 0x27, 0x58, 0x59, 0x04, 0x04, 0x00, 0x58, 0xf2, 0xf6, 0x9d, 0x39,
        0x9d, 0x39, 0x8d, 0x39, 0xa0, 0x39, 0xa8, 0x39, 0x8c, 0x39, 0x7f, 0x7f,
        0x80, 0x51, 0x00, 0x00, 0x00, 0x1e, 0xb6, 0x17, 0x58, 0x59, 0x04, 0x04,
        0x00, 0x58, 0xf2, 0xf6, 0x98, 0x39, 0x98, 0x39, 0x89, 0x39, 0x9a, 0x39,
        0xa8, 0x39, 0x8c, 0x39, 0x7f, 0x7f, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x1e,
        0xb6, 0x17, 0x58, 0x59, 0x04, 0x04, 0x00, 0x58, 0xf2, 0xf6, 0x9e, 0x39,
        0x9e, 0x39, 0x8c, 0x39, 0x97, 0x39, 0xab, 0x39, 0x89, 0x39, 0x7f, 0x7f,
        0x80, 0x3e, 0x00, 0x00, 0x00, 0x1e, 0xb7, 0x16, 0x58, 0x59, 0x04, 0x04,
        0x00, 0x58, 0xf2, 0xf6, 0x98, 0x39, 0x98, 0x39, 0x8c, 0x39, 0x98, 0x39,
        0xa8, 0x39, 0x8c, 0x39, 0x7f, 0x7f, 0x80, 0x3d, 0x00, 0x00, 0x00, 0xb4,
        0x4b, 0x00, 0xb3, 0x4b, 0x00, 0xc6, 0x40, 0x00, 0xa2, 0x40, 0x00, 0xa2,
        0x40, 0x00, 0x08, 0x15, 0x00, 0x08, 0x15, 0x00, 0x9b, 0x1a, 0xff, 0x9b,
        0x2b, 0xff, 0x9b, 0x2a, 0xff, 0x9b, 0x1a, 0x00, 0x0e, 0x02, 0x00, 0x9b,
        0x2b, 0x00, 0x9b, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00
    ])
    lp2 = bytearray([
        0x57, 0x4c, 0x39, 0x58, 0x5a, 0x45, 0xf6, 0x0b, 0x00, 0x00, 0x2c, 0x96,
        0x0e, 0xff, 0x01, 0xb7, 0xc5, 0x58, 0x59, 0x04, 0x04, 0x00, 0x57, 0xe8,
        0xff, 0xe7, 0xe7, 0x47, 0x47, 0x1e, 0xb8, 0xc5, 0x58, 0x59, 0x04, 0x04,
        0x00, 0x57, 0xe8, 0xf6, 0xa8, 0x39, 0xa8, 0x39, 0xa4, 0x39, 0xac, 0x39,
        0xb7, 0x39, 0xa4, 0x39, 0x7f, 0x7f, 0x80, 0xf5, 0x0b, 0x00, 0x00, 0x1e,
        0xc1, 0xc5, 0x58, 0x58, 0x04, 0x04, 0x00, 0x58, 0xe8, 0xf6, 0xa8, 0x39,
        0xa8, 0x39, 0xa3, 0x39, 0xa9, 0x39, 0xba, 0x39, 0xa4, 0x39, 0x7f, 0x7f,
        0x80, 0xe1, 0x0b, 0x00, 0x00, 0x1e, 0xb8, 0xc5, 0x58, 0x59, 0x04, 0x04,
        0x00, 0x57, 0xe8, 0xf6, 0xa8, 0x39, 0xa8, 0x39, 0xa4, 0x39, 0xac, 0x39,
        0xb7, 0x39, 0xa4, 0x39, 0x7f, 0x7f, 0x80, 0xf5, 0x0b, 0x00, 0x00, 0x1e,
        0xc1, 0xc5, 0x58, 0x58, 0x04, 0x04, 0x00, 0x58, 0xe8, 0xf6, 0xa8, 0x39,
        0xa8, 0x39, 0xa3, 0x39, 0xa9, 0x39, 0xba, 0x39, 0xa4, 0x39, 0x7f, 0x7f,
        0x80, 0xe1, 0x0b, 0x00, 0x00, 0x1e, 0xcb, 0xc5, 0x58, 0x58, 0x04, 0x04,
        0x00, 0x57, 0xe8, 0xf6, 0xa4, 0x39, 0xa4, 0x39, 0xa3, 0x39, 0xa8, 0x39,
        0xba, 0x39, 0xa0, 0x39, 0x7f, 0x7f, 0x80, 0xcd, 0x0b, 0x00, 0x00, 0x9b,
        0x30, 0x07, 0x9b, 0x31, 0x07, 0x9c, 0x31, 0x07, 0x25, 0x46, 0x07, 0xa7,
        0x33, 0x07, 0xa7, 0x29, 0x07, 0x36, 0x4e, 0x08, 0xb4, 0x4c, 0x08, 0xab,
        0x34, 0x08, 0x3b, 0x4b, 0x08, 0x08, 0x15, 0x08, 0x9b, 0x1a, 0xff, 0x9b,
        0x2b, 0xff, 0x9b, 0x2a, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00
    ])
    attitude_keys = 171
    idle_keys = 161
    fb_keys = 168
    fc_keys = 153
    lp_keys = 121
    packets = [attitude, idle, fb1, fb2, fc1, fc2, lp1, lp2]
    dut = 'Equisat'
    result = []

    for frame in packets:
        result = load_objects(decoder, dut, frame)
        count = check_type(result)
        if frame == attitude:
            assert count == attitude_keys
        if frame == idle:
            assert count == idle_keys
        if frame == fb1:
            assert count == fb_keys
        if frame == fb2:
            assert count == fb_keys
        if frame == fc1:
            assert count == fc_keys
        if frame == fc2:
            assert count == fc_keys
        if frame == lp1:
            assert count == lp_keys
        if frame == lp2:
            assert count == lp_keys
