# use pipenv-setup to generate the requirement list
# https://pypi.org/project/pipenv-setup/

from setuptools import setup


with open("README.md", "r") as f:
   long_description = f.read()



setup(
   name="github2pandas",
   version="1.0.1",
   packages=["github2pandas"],
   license="BSD 2",
   description="github2pandas supports the aggregation of project activities in a GitHub repository and makes them available in pandas dataframes",
   long_description = long_description,
   long_description_content_type="text/markdown",
   author="Maximilian Karl & Sebastian Zug",
   url="https://github.com/TUBAF-IFI-DiPiT/github2pandas",
   download_url="https://github.com/user/reponame/archive/v_01.tar.gz",
   keywords=["git", "github", "collaborative code development", "git mining"],
   install_requires=[
      "alabaster==0.7.12",
      "argon2-cffi==20.1.0",
      "argparse==1.4.0",
      "async-generator==1.10; python_version >= '3.5'",
      "attrs==20.3.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "babel==2.9.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "backcall==0.2.0",
      "bleach==3.3.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
      "cached-property==1.5.2",
      "certifi==2020.12.5",
      "cffi==1.14.5",
      "chardet==4.0.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
      "click==7.1.2; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
      "datetime==4.3",
      "decorator==5.0.5; python_version >= '3.5'",
      "defusedxml==0.7.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
      "deprecated==1.2.12; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "docutils==0.17; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
      "entrypoints==0.3; python_version >= '2.7'",
      "git2net==1.4.10",
      "gitdb==4.0.7; python_version >= '3.4'",
      "gitpython==3.1.14; python_version >= '3.4'",
      "human-id==0.1.0.post3",
      "idna==2.10; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "imagesize==1.2.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "ipykernel==5.5.3; python_version >= '3.5'",
      "ipython==7.22.0; python_version >= '3.3'",
      "ipython-genutils==0.2.0",
      "ipywidgets==7.6.3",
      "jedi==0.18.0; python_version >= '3.6'",
      "jinja2==2.11.3; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
      "jsonschema==3.2.0",
      "jupyter==1.0.0",
      "jupyter-client==6.1.12; python_version >= '3.5'",
      "jupyter-console==6.4.0; python_version >= '3.6'",
      "jupyter-core==4.7.1; python_version >= '3.6'",
      "jupyterlab-pygments==0.1.2",
      "jupyterlab-widgets==1.0.0; python_version >= '3.6'",
      "lizard==1.17.7",
      "m2r2==0.2.7",
      "markupsafe==1.1.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "mistune==0.8.4",
      "nbclient==0.5.3; python_full_version >= '3.6.1'",
      "nbconvert==6.0.7; python_version >= '3.6'",
      "nbformat==5.1.3; python_version >= '3.5'",
      "nest-asyncio==1.5.1; python_version >= '3.5'",
      "notebook==6.3.0; python_version >= '3.6'",
      "numpy==1.20.2; python_version >= '3.7'",
      "packaging==20.9; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "pandas==1.2.3",
      "pandocfilters==1.4.3",
      "parso==0.8.2; python_version >= '3.6'",
      "pathpy2==2.2.0; python_version >= '3.5'",
      "pexpect==4.8.0; sys_platform != 'win32'",
      "pickleshare==0.7.5",
      "prometheus-client==0.10.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "prompt-toolkit==3.0.18; python_full_version >= '3.6.1'",
      "ptyprocess==0.7.0; os_name != 'nt'",
      "pycparser==2.20; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "pydriller==1.15.2",
      "pygit2==1.5.0",
      "pygithub==1.54.1",
      "pygments==2.8.1; python_version >= '3.5'",
      "pyjwt==1.7.1",
      "pyparsing==2.4.7; python_version >= '2.6' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "pypiwin32==223; sys_platform == 'win32'",
      "pyrsistent==0.17.3; python_version >= '3.5'",
      "pysqlite3==0.4.6",
      "python-dateutil==2.8.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "python-dotenv==0.17.0",
      "python-levenshtein==0.12.2",
      "pytz==2021.1",
      "pyyaml==5.4.1",
      "pyzmq==22.0.3; python_version >= '3.6'",
      "qtconsole==5.0.3; python_version >= '3.6'",
      "qtpy==1.9.0",
      "requests==2.25.1",
      "scipy==1.6.2; python_version < '3.10' and python_version >= '3.7'",
      "selenium==3.141.0",
      "send2trash==1.5.0",
      "six==1.15.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "smmap==4.0.0; python_version >= '3.5'",
      "snowballstemmer==2.1.0",
      "sphinx==3.5.3",
      "sphinxcontrib-applehelp==1.0.2; python_version >= '3.5'",
      "sphinxcontrib-devhelp==1.0.2; python_version >= '3.5'",
      "sphinxcontrib-htmlhelp==1.0.3; python_version >= '3.5'",
      "sphinxcontrib-jsmath==1.0.1; python_version >= '3.5'",
      "sphinxcontrib-qthelp==1.0.3; python_version >= '3.5'",
      "sphinxcontrib-serializinghtml==1.1.4; python_version >= '3.5'",
      "terminado==0.9.4; python_version >= '3.6'",
      "testpath==0.4.4",
      "tornado==6.1; python_version >= '3.5'",
      "tqdm==4.60.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
      "traitlets==5.0.5; python_version >= '3.7'",
      "urllib3==1.26.4; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4' and python_version < '4'",
      "wcwidth==0.2.5",
      "webencodings==0.5.1",
      "widgetsnbextension==3.5.1",
      "wrapt==1.12.1",
      "zope.interface==5.3.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
   ], 
   classifiers=[
      "Programming Language :: Python :: 3",
      "Operating System :: OS Independent",
   ],
   python_requires=">=3.8"
)
