import React from "react";

export const IconSync = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      width="16"
      height="16"
      viewBox="0 0 16 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}>
      <g clipPath="url(#clip0_1479_25070)">
        <path
          d="M15.625 0.25H14.759C14.5484 0.25 14.3791 0.423375 14.3841 0.633937L14.4575 3.71441C13.0691 1.62634 10.6955 0.25 8 0.25C4.21291 0.25 1.06041 2.96638 0.38425 6.557C0.340875 6.78728 0.518875 7 0.753219 7H1.64622C1.82353 7 1.97566 6.87556 2.013 6.70222C2.60753 3.9415 5.05991 1.875 8 1.875C10.4858 1.875 12.6232 3.35256 13.5836 5.47819L9.63394 5.38416C9.42341 5.37916 9.25 5.54844 9.25 5.75906V6.625C9.25 6.83209 9.41791 7 9.625 7H15.625C15.8321 7 16 6.83209 16 6.625V0.625C16 0.417906 15.8321 0.25 15.625 0.25ZM15.2468 9H14.3538C14.1765 9 14.0243 9.12444 13.987 9.29778C13.3925 12.0585 10.9401 14.125 8 14.125C5.51419 14.125 3.37681 12.6474 2.41637 10.5218L6.36606 10.6158C6.57659 10.6208 6.75 10.4516 6.75 10.2409V9.375C6.75 9.16791 6.58209 9 6.375 9H0.375C0.167906 9 0 9.16791 0 9.375V15.375C0 15.5821 0.167906 15.75 0.375 15.75H1.24097C1.45156 15.75 1.62088 15.5766 1.61588 15.3661L1.54253 12.2856C2.93087 14.3737 5.3045 15.75 8 15.75C11.7871 15.75 14.9396 13.0336 15.6158 9.443C15.6591 9.21272 15.4811 9 15.2468 9Z"
          fill="currentColor"
        />
      </g>
      <defs>
        <clipPath id="clip0_1479_25070">
          <rect width="16" height="16" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
};
export const IconExport = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      width="16"
      height="16"
      viewBox="0 0 16 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}>
      <g clipPath="url(#clip0_1479_25102)">
        <path
          d="M-1.88399 8.72062L0.358816 6.46094C0.594752 6.22344 1.00006 6.39031 1.00006 6.725V8.2525H4.00005V4.12438C4.00005 3.7275 4.16161 3.34313 4.44286 3.06219L7.06441 0.440625C7.34566 0.159375 7.72691 0 8.12347 0H14.5003C15.3281 0.003125 16 0.675 16 1.50281V14.5003C16 15.3281 15.3281 16 14.5003 16H5.50223C4.67411 16 4.00005 15.3281 4.00005 14.5003V11.2522H5.50005V14.5003H14.5003V1.50281H9.50128V4.75219C9.50128 5.16781 9.1669 5.50187 8.75128 5.50187H5.50005V8.25219H10.625C10.8322 8.25219 11 8.42 11 8.62719V9.37719C11 9.58438 10.8322 9.75219 10.625 9.75219H1.00006V11.2797C1.00006 11.6144 0.594752 11.7813 0.358816 11.5438L-1.88399 9.28406C-2.03867 9.12813 -2.03867 8.87656 -1.88399 8.72062ZM8.0016 4.00219V1.62469L5.62379 4.00219H8.0016Z"
          fill="currentColor"
        />
      </g>
      <g clipPath="url(#clip1_1479_25102)">
        <path
          d="M0.103056 8.72062L2.09667 6.46094C2.30639 6.22344 2.66667 6.39031 2.66667 6.725V8.2525H5.33333V4.12438C5.33333 3.7275 5.47694 3.34313 5.72694 3.06219L8.05722 0.440625C8.30722 0.159375 8.64611 0 8.99861 0H14.6669C15.4028 0.003125 16 0.675 16 1.50281V14.5003C16 15.3281 15.4028 16 14.6669 16H6.66861C5.9325 16 5.33333 15.3281 5.33333 14.5003V11.2522H6.66667V14.5003H14.6669V1.50281H10.2233V4.75219C10.2233 5.16781 9.92611 5.50187 9.55667 5.50187H6.66667V8.25219H11.2222C11.4064 8.25219 11.5556 8.42 11.5556 8.62719V9.37719C11.5556 9.58438 11.4064 9.75219 11.2222 9.75219H2.66667V11.2797C2.66667 11.6144 2.30639 11.7813 2.09667 11.5438L0.103056 9.28406C-0.0344448 9.12813 -0.0344448 8.87656 0.103056 8.72062ZM8.89028 4.00219V1.62469L6.77666 4.00219H8.89028Z"
          fill="currentColor"
        />
      </g>
      <defs>
        <clipPath id="clip0_1479_25102">
          <rect width="13" height="16" fill="white" transform="matrix(-1 0 0 1 16 0)" />
        </clipPath>
        <clipPath id="clip1_1479_25102">
          <rect width="3" height="16" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
};

export const IconImport = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      width="16"
      height="16"
      viewBox="0 0 16 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}>
      <g clipPath="url(#clip0_1426_8619)">
        <path
          d="M15.5572 3.06188L12.9356 0.440625C12.6544 0.159375 12.2731 0 11.8766 0H5.49969C4.67188 0.003125 4 0.675 4 1.50281V8.25219H0.375C0.167812 8.25219 0 8.42 0 8.62719V9.37719C0 9.58438 0.167812 9.75219 0.375 9.75219H9V11.2797C9 11.6144 9.40531 11.7812 9.64125 11.5437L11.8841 9.28406C12.0388 9.12813 12.0388 8.87656 11.8841 8.72062L9.64125 6.46094C9.40531 6.22344 9 6.39031 9 6.725V8.2525H5.49969V1.50281H10.4987V4.75219C10.4987 5.16781 10.8331 5.50187 11.2487 5.50187H14.5V14.5003H5.49969V11.2522H4V14.5003C4 15.3281 4.67188 16 5.49969 16H14.4978C15.3259 16 16 15.3281 16 14.5003V4.12406C16 3.7275 15.8384 3.34313 15.5572 3.06188ZM11.9984 4.00219V1.62469L14.3763 4.00219H11.9984Z"
          fill="black"
        />
      </g>
      <defs>
        <clipPath id="clip0_1426_8619">
          <rect width="16" height="16" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
};

export const IconSave = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      width="16"
      height="16"
      viewBox="0 0 16 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}>
      <path
        d="M14.5607 4.06066L11.9393 1.43934C11.658 1.15804 11.2765 1 10.8787 1H2.5C1.67156 1 1 1.67156 1 2.5V13.5C1 14.3284 1.67156 15 2.5 15H13.5C14.3284 15 15 14.3284 15 13.5V5.12131C15 4.72349 14.842 4.34196 14.5607 4.06066ZM9.5 2.5V5H5.5V2.5H9.5ZM13.3125 13.5H2.6875C2.63777 13.5 2.59008 13.4802 2.55492 13.4451C2.51975 13.4099 2.5 13.3622 2.5 13.3125V2.6875C2.5 2.63777 2.51975 2.59008 2.55492 2.55492C2.59008 2.51975 2.63777 2.5 2.6875 2.5H4V5.75C4 6.16422 4.33578 6.5 4.75 6.5H10.25C10.6642 6.5 11 6.16422 11 5.75V2.62131L13.4451 5.06641C13.4625 5.08382 13.4763 5.10449 13.4857 5.12724C13.4952 5.14999 13.5 5.17438 13.5 5.199V13.3125C13.5 13.3622 13.4802 13.4099 13.4451 13.4451C13.4099 13.4802 13.3622 13.5 13.3125 13.5ZM8 7.25C6.48366 7.25 5.25 8.48366 5.25 10C5.25 11.5163 6.48366 12.75 8 12.75C9.51634 12.75 10.75 11.5163 10.75 10C10.75 8.48366 9.51634 7.25 8 7.25ZM8 11.25C7.31075 11.25 6.75 10.6892 6.75 10C6.75 9.31075 7.31075 8.75 8 8.75C8.68925 8.75 9.25 9.31075 9.25 10C9.25 10.6892 8.68925 11.25 8 11.25Z"
        fill="currentColor"
      />
    </svg>
  );
};
export const IconEdit = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      width="17"
      height="16"
      viewBox="0 0 17 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}>
      <path
        d="M15.9143 1.75812L14.7422 0.585938C14.3515 0.195312 13.8397 0 13.3278 0C12.8159 0 12.304 0.195312 11.9137 0.585625L9.58593 2.91344L8.5 3.99938L0.901592 11.5975L0.504719 15.1669C0.454719 15.6163 0.80878 16 1.24847 16C1.27628 16 1.3044 15.9984 1.33253 15.9953L4.89939 15.6012L12.5006 8L13.5862 6.91437L15.914 4.58656C16.6953 3.80531 16.6953 2.53906 15.9143 1.75812ZM4.21095 14.1684L2.09909 14.4016L2.3344 12.2863L9.56062 5.06L10.53 4.09062L12.4094 5.97L11.44 6.93937L4.21095 14.1684ZM14.8534 3.52562L13.4697 4.90938L11.5906 3.03L12.9744 1.64625C13.1019 1.51875 13.2506 1.49969 13.3278 1.49969C13.405 1.49969 13.554 1.51875 13.6812 1.64625L14.8534 2.81844C15.0484 3.01375 15.0484 3.33094 14.8534 3.52562Z"
        fill="currentColor"
      />
    </svg>
  );
};

export const IconInfo = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      width="16"
      height="16"
      viewBox="0 0 16 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}>
      <path
        d="M7.26326 6.5462H8.71794V12.3642H7.26326V6.5462ZM7.9906 3.1102C7.43278 3.1102 6.97888 3.5641 6.97888 4.12192C6.97888 4.67974 7.43278 5.13364 7.9906 5.13364C8.54842 5.13364 9.00232 4.67974 9.00232 4.12192C9.00232 3.5641 8.54842 3.1102 7.9906 3.1102ZM16 8C16 12.411 12.411 16 8 16C3.589 16 0 12.411 0 8C0 3.589 3.589 0 8 0C12.411 0 16 3.589 16 8ZM14.5453 8C14.5453 4.3906 11.6093 1.4546 7.99992 1.4546C4.39052 1.4546 1.45452 4.3914 1.45452 8.0006C1.45452 11.6098 4.39052 14.546 7.99992 14.546C11.6093 14.546 14.5453 11.6092 14.5453 8.0006V8Z"
        fill="currentColor"
      />
    </svg>
  );
};
