import { createSystem, defaultConfig } from "@chakra-ui/react";

export const system = createSystem(defaultConfig, {
  preflight: {
    scope: ".chakra-style-reset",
  },
  theme: {
    tokens: {
      colors: {
        iochmara: {
          50: { value: "#EAF3FB" },
          100: { value: "#C4DDF3" },
          200: { value: "#9EC6EB" },
          300: { value: "#79B0E2" },
          400: { value: "#5599D8" },
          DEFAULT: { value: "#3182CE" },
          500: { value: "#3182CE" },
          600: { value: "#2A6CA7" },
          700: { value: "#225581" },
          800: { value: "#193E5C" },
          900: { value: "#102638" },
          950: { value: "#060E14" },
        },
        cyan: {
          50: { value: "#ECFEFF" },
          100: { value: "#CFFAFE" },
          200: { value: "#A5F3FC" },
          300: { value: "#67E8F9" },
          400: { value: "#22D3EE" },
          DEFAULT: { value: "#06B6D4" },
          500: { value: "#06B6D4" },
          600: { value: "#0891B2" },
          700: { value: "#0E7490" },
          800: { value: "#155E75" },
          900: { value: "#164E63" },
          950: { value: "#083344" },
        },
        neutral: {
          50: { value: "#FAFAFA" },
          100: { value: "#F5F5F5" },
          200: { value: "#E5E5E5" },
          300: { value: "#D4D4D4" },
          400: { value: "#A3A3A3" },
          DEFAULT: { value: "#737373" },
          500: { value: "#737373" },
          600: { value: "#525252" },
          700: { value: "#404040" },
          800: { value: "#262626" },
          900: { value: "#171717" },
          950: { value: "#0A0A0A" },
        },
        amber: {
          50: { value: "#FFFBEB" },
          100: { value: "#FEF3C7" },
          200: { value: "#FDE68A" },
          300: { value: "#FCD34D" },
          400: { value: "#FBBF24" },
          DEFAULT: { value: "#F59E0B" },
          500: { value: "#F59E0B" },
          600: { value: "#D97706" },
          700: { value: "#B45309" },
          800: { value: "#92400E" },
          900: { value: "#78350F" },
          950: { value: "#431407" },
        },
        green: {
          50: { value: "#F0FDF4" },
          100: { value: "#DCFCE7" },
          200: { value: "#BBF7D0" },
          300: { value: "#86EFAC" },
          400: { value: "#4ADE80" },
          DEFAULT: { value: "#22C55E" },
          500: { value: "#22C55E" },
          600: { value: "#16A34A" },
          700: { value: "#15803D" },
          800: { value: "#166534" },
          900: { value: "#14532D" },
          950: { value: "#052E16" },
        },
        red: {
          50: { value: "#FEF2F2" },
          100: { value: "#FEE2E2" },
          200: { value: "#FECACA" },
          300: { value: "#FCA5A5" },
          400: { value: "#F87171" },
          DEFAULT: { value: "#EF4444" },
          500: { value: "#EF4444" },
          600: { value: "#DC2626" },
          700: { value: "#B91C1C" },
          800: { value: "#991B1B" },
          900: { value: "#7F1D1D" },
          950: { value: "#450A0A" },
        },
        rose: {
          50: { value: "#FFF1F2" },
          100: { value: "#FFE4E6" },
          200: { value: "#FECDD3" },
          300: { value: "#FDA4AF" },
          400: { value: "#FB7185" },
          DEFAULT: { value: "#F43F5E" },
          500: { value: "#F43F5E" },
          600: { value: "#E11D48" },
          700: { value: "#BE123C" },
          800: { value: "#9F1239" },
          900: { value: "#881337" },
          950: { value: "#4C0519" },
        },
        brand: {
          50: { value: "#FFDED5" },
          100: { value: "#FFC1B0" },
          200: { value: "#FFA58C" },
          300: { value: "#FF8967" },
          400: { value: "#FF6E42" },
          DEFAULT: { value: "#FD541E" },
          500: { value: "#FD541E" },
          600: { value: "#F04104" },
          700: { value: "#C93A06" },
          800: { value: "#A23206" },
          900: { value: "#7C2906" },
          950: { value: "#571E05" },
        },
      },
    },
    semanticTokens: {
      colors: {
        iochmara: {
          solid: { value: "{colors.iochmara.500}" },
          contrast: { value: "{colors.white}" },
          fg: { value: "{colors.iochmara.700}" },
          subtle: { value: "{colors.iochmara.100}" },
          muted: { value: "{colors.iochmara.200}" },
          emphasized: { value: "{colors.iochmara.300}" },
          focusRing: { value: "{colors.iochmara.400}" },
        },
        cyan: {
          solid: { value: "{colors.cyan.600}" },
          contrast: { value: "{colors.white}" },
          fg: { value: "{colors.cyan.700}" },
          subtle: { value: "{colors.cyan.100}" },
          muted: { value: "{colors.cyan.200}" },
          emphasized: { value: "{colors.cyan.300}" },
          focusRing: { value: "{colors.cyan.500}" },
        },
        neutral: {
          solid: { value: "{colors.neutral.900}" },
          contrast: { value: "{colors.white}" },
          fg: { value: "{colors.neutral.800}" },
          subtle: { value: "{colors.neutral.100}" },
          muted: { value: "{colors.neutral.200}" },
          emphasized: { value: "{colors.neutral.300}" },
          focusRing: { value: "{colors.neutral.400}" },
        },
        green: {
          solid: { value: "{colors.green.600}" },
          contrast: { value: "{colors.white}" },
          fg: { value: "{colors.green.700}" },
          subtle: { value: "{colors.green.100}" },
          muted: { value: "{colors.green.200}" },
          emphasized: { value: "{colors.green.300}" },
          focusRing: { value: "{colors.green.500}" },
        },
        amber: {
          solid: { value: "{colors.amber.500}" },
          contrast: { value: "{colors.white}" },
          fg: { value: "{colors.amber.700}" },
          subtle: { value: "{colors.amber.100}" },
          muted: { value: "{colors.amber.200}" },
          emphasized: { value: "{colors.amber.300}" },
          focusRing: { value: "{colors.amber.400}" },
        },
        red: {
          solid: { value: "{colors.red.600}" },
          contrast: { value: "{colors.white}" },
          fg: { value: "{colors.red.700}" },
          subtle: { value: "{colors.red.100}" },
          muted: { value: "{colors.red.200}" },
          emphasized: { value: "{colors.red.300}" },
          focusRing: { value: "{colors.red.500}" },
        },
        rose: {
          solid: { value: "{colors.rose.500}" },
          contrast: { value: "{colors.white}" },
          fg: { value: "{colors.rose.700}" },
          subtle: { value: "{colors.rose.100}" },
          muted: { value: "{colors.rose.200}" },
          emphasized: { value: "{colors.rose.300}" },
          focusRing: { value: "{colors.rose.400}" },
        },
        brand: {
          solid: { value: "{colors.brand.500}" },
          contrast: { value: "{colors.white}" },
          fg: { value: "{colors.brand.700}" },
          subtle: { value: "{colors.brand.100}" },
          muted: { value: "{colors.brand.200}" },
          emphasized: { value: "{colors.brand.300}" },
          focusRing: { value: "{colors.brand.500}" },
        },
        blue: {
          solid: { value: "{colors.iochmara.500}" },
          contrast: { value: "{colors.white}" },
          fg: { value: "{colors.iochmara.700}" },
          subtle: { value: "{colors.iochmara.100}" },
          muted: { value: "{colors.iochmara.200}" },
          emphasized: { value: "{colors.iochmara.300}" },
          focusRing: { value: "{colors.iochmara.400}" },
        },
        gray: {
          solid: { value: "{colors.neutral.900}" },
          contrast: { value: "{colors.white}" },
          fg: { value: "{colors.neutral.800}" },
          subtle: { value: "{colors.neutral.100}" },
          muted: { value: "{colors.neutral.200}" },
          emphasized: { value: "{colors.neutral.300}" },
          focusRing: { value: "{colors.neutral.400}" },
        },
        success: { value: "{colors.green}" },
        warning: { value: "{colors.amber}" },
        danger: { value: "{colors.red}" },
      },
    },
  },
});
