"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.APPMESH_ECR_ACCOUNTS = exports.DLC_REPOSITORY_ACCOUNTS = exports.ELBV2_ACCOUNTS = exports.PARTITION_MAP = exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = exports.AWS_CDK_METADATA = exports.AWS_OLDER_REGIONS = void 0;
exports.AWS_OLDER_REGIONS = new Set([
    'us-east-1',
    'us-west-1',
    'us-west-2',
    'us-gov-west-1',
    'ap-southeast-1',
    'ap-southeast-2',
    'ap-northeast-1',
    'sa-east-1',
    'eu-west-1',
]);
exports.AWS_CDK_METADATA = new Set([
    'us-east-2',
    'us-east-1',
    'us-west-1',
    'us-west-2',
    // 'us-gov-east-1',
    // 'us-gov-west-1',
    // 'us-iso-east-1',
    // 'us-isob-east-1',
    // 'af-south-1',
    'ap-south-1',
    'ap-east-1',
    // 'ap-northeast-3',
    'ap-northeast-2',
    'ap-southeast-1',
    'ap-southeast-2',
    'ap-northeast-1',
    'ca-central-1',
    'cn-north-1',
    'cn-northwest-1',
    'eu-central-1',
    'eu-west-1',
    'eu-west-2',
    'eu-west-3',
    'eu-north-1',
    // 'eu-south-1',
    'me-south-1',
    'sa-east-1',
]);
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * @see https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints
 */
exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = {
    'us-east-2': 'Z2O1EMRO9K5GLX',
    'us-east-1': 'Z3AQBSTGFYJSTF',
    'us-west-1': 'Z2F56UZL2M1ACD',
    'us-west-2': 'Z3BJ6K6RIION7M',
    'us-gov-east-1': 'Z2NIFVYYW2VKV1',
    'us-gov-west-1': 'Z31GFT0UA1I2HV',
    'af-south-1': 'Z11KHD8FBVPUYU',
    'ap-east-1': 'ZNB98KWMFR0R6',
    'ap-south-1': 'Z11RGJOFQNVJUP',
    'ap-northeast-3': 'Z2YQB5RD63NC85',
    'ap-northeast-2': 'Z3W03O7B5YMIYP',
    'ap-southeast-1': 'Z3O0J2DXBE1FTB',
    'ap-southeast-2': 'Z1WCIGYICN2BYD',
    'ap-northeast-1': 'Z2M4EHUR26P7ZW',
    'ca-central-1': 'Z1QDHH18159H29',
    'eu-central-1': 'Z21DNDUVLTQW6Q',
    'eu-west-1': 'Z1BKCTXD74EZPE',
    'eu-west-2': 'Z3GKZC51ZF0DB4',
    'eu-west-3': 'Z3R1K369G5AVDG',
    'eu-north-1': 'Z3BAZG2TWCNX0D',
    'eu-south-1': 'Z3IXVV8C73GIO3',
    'sa-east-1': 'Z7KQH4QJS55SO',
    'me-south-1': 'Z1MPMWCPA7YB62',
};
exports.PARTITION_MAP = {
    'default': { partition: 'aws', domainSuffix: 'amazonaws.com' },
    'cn-': { partition: 'aws-cn', domainSuffix: 'amazonaws.com.cn' },
    'us-gov-': { partition: 'aws-us-gov', domainSuffix: 'amazonaws.com' },
    'us-iso-': { partition: 'aws-iso', domainSuffix: 'c2s.ic.gov' },
    'us-isob-': { partition: 'aws-iso-b', domainSuffix: 'sc2s.sgov.gov' },
};
// https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-access-logs.html#access-logging-bucket-permissions
exports.ELBV2_ACCOUNTS = {
    'us-east-1': '127311923021',
    'us-east-2': '033677994240',
    'us-west-1': '027434742980',
    'us-west-2': '797873946194',
    'af-south-1': '098369216593',
    'ca-central-1': '985666609251',
    'eu-central-1': '054676820928',
    'eu-west-1': '156460612806',
    'eu-west-2': '652711504416',
    'eu-west-3': '009996457667',
    'eu-south-1': '635631232127',
    'eu-north-1': '897822967062',
    'ap-east-1': '754344448648',
    'ap-northeast-1': '582318560864',
    'ap-northeast-2': '600734575887',
    'ap-northeast-3': '383597477331',
    'ap-southeast-1': '114774131450',
    'ap-southeast-2': '783225319266',
    'ap-south-1': '718504428378',
    'me-south-1': '076674570225',
    'sa-east-1': '507241528517',
    'us-gov-west-1': '048591011584',
    'us-gov-east-1': '190560391635',
    'cn-north-1': '638102146993',
    'cn-northwest-1': '037604701340',
};
// https://aws.amazon.com/releasenotes/available-deep-learning-containers-images
exports.DLC_REPOSITORY_ACCOUNTS = {
    'us-east-1': '763104351884',
    'us-east-2': '763104351884',
    'us-west-1': '763104351884',
    'us-west-2': '763104351884',
    'ca-central-1': '763104351884',
    'eu-west-1': '763104351884',
    'eu-west-2': '763104351884',
    'eu-west-3': '763104351884',
    'eu-central-1': '763104351884',
    'eu-north-1': '763104351884',
    'sa-east-1': '763104351884',
    'ap-south-1': '763104351884',
    'ap-northeast-1': '763104351884',
    'ap-northeast-2': '763104351884',
    'ap-southeast-1': '763104351884',
    'ap-southeast-2': '763104351884',
    'ap-east-1': '871362719292',
    'me-south-1': '217643126080',
    'cn-north-1': '727897471807',
    'cn-northwest-1': '727897471807',
};
// https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html
exports.APPMESH_ECR_ACCOUNTS = {
    'ap-northeast-1': '840364872350',
    'ap-northeast-2': '840364872350',
    'ap-south-1': '840364872350',
    'ap-southeast-1': '840364872350',
    'ap-southeast-2': '840364872350',
    'ca-central-1': '840364872350',
    'eu-central-1': '840364872350',
    'eu-north-1': '840364872350',
    'eu-south-1': '422531588944',
    'eu-west-1': '840364872350',
    'eu-west-2': '840364872350',
    'eu-west-3': '840364872350',
    'sa-east-1': '840364872350',
    'us-east-1': '840364872350',
    'us-east-2': '840364872350',
    'us-west-1': '840364872350',
    'us-west-2': '840364872350',
    'me-south-1': '772975370895',
    'ap-east-1': '856666278305',
};
//# sourceMappingURL=data:application/json;base64,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