"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const fs = require("fs-extra");
const default_1 = require("../lib/default");
const aws_entities_1 = require("./aws-entities");
const fact_tables_1 = require("./fact-tables");
async function main() {
    const lines = [
        "import { Fact, FactName } from './fact';",
        '',
        '/* eslint-disable quote-props */',
        '/* eslint-disable max-len */',
        '',
        '/**',
        ' * Built-in regional information, re-generated by `npm run build`.',
        ' *',
        ` * @generated ${new Date().toISOString()}`,
        ' */',
        'export class BuiltIns {',
        '  /**',
        '   * Registers all the built in regional data in the RegionInfo database.',
        '   */',
        '  public static register(): void {',
    ];
    const defaultMap = 'default';
    for (const region of aws_entities_1.AWS_REGIONS) {
        let partition = fact_tables_1.PARTITION_MAP[defaultMap].partition;
        let domainSuffix = fact_tables_1.PARTITION_MAP[defaultMap].domainSuffix;
        for (const key in fact_tables_1.PARTITION_MAP) {
            if (region.startsWith(key)) {
                partition = fact_tables_1.PARTITION_MAP[key].partition;
                domainSuffix = fact_tables_1.PARTITION_MAP[key].domainSuffix;
            }
        }
        registerFact(region, 'PARTITION', partition);
        registerFact(region, 'DOMAIN_SUFFIX', domainSuffix);
        registerFact(region, 'CDK_METADATA_RESOURCE_AVAILABLE', fact_tables_1.AWS_CDK_METADATA.has(region) ? 'YES' : 'NO');
        registerFact(region, 'S3_STATIC_WEBSITE_ENDPOINT', fact_tables_1.AWS_OLDER_REGIONS.has(region)
            ? `s3-website-${region}.${domainSuffix}`
            : `s3-website.${region}.${domainSuffix}`);
        registerFact(region, 'S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID', fact_tables_1.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS[region] || '');
        registerFact(region, 'ELBV2_ACCOUNT', fact_tables_1.ELBV2_ACCOUNTS[region]);
        registerFact(region, 'DLC_REPOSITORY_ACCOUNT', fact_tables_1.DLC_REPOSITORY_ACCOUNTS[region]);
        registerFact(region, 'APPMESH_ECR_ACCOUNT', fact_tables_1.APPMESH_ECR_ACCOUNTS[region]);
        const vpcEndpointServiceNamePrefix = `${domainSuffix.split('.').reverse().join('.')}.vpce`;
        registerFact(region, 'VPC_ENDPOINT_SERVICE_NAME_PREFIX', vpcEndpointServiceNamePrefix);
        for (const service of aws_entities_1.AWS_SERVICES) {
            registerFact(region, ['servicePrincipal', service], default_1.Default.servicePrincipal(service, region, domainSuffix));
        }
    }
    lines.push('  }');
    lines.push('');
    lines.push('  private constructor() {}');
    lines.push('}');
    await fs.writeFile(path.resolve(__dirname, '..', 'lib', 'built-ins.generated.ts'), lines.join('\n'));
    function registerFact(region, name, value) {
        const factName = typeof name === 'string' ? name : `${name[0]}(${name.slice(1).map(s => JSON.stringify(s)).join(', ')})`;
        lines.push(`    Fact.register({ region: ${JSON.stringify(region)}, name: FactName.${factName}, value: ${JSON.stringify(value)} });`);
    }
}
main().catch(e => {
    // eslint-disable-next-line no-console
    console.error(e);
    process.exit(-1);
});
//# sourceMappingURL=data:application/json;base64,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