/**
 * (experimental) Provides default values for certain regional information points.
 *
 * @experimental
 */
export declare class Default {
    /**
     * (experimental) The default value for a VPC Endpoint Service name prefix, useful if you do not have a synthesize-time region literal available (all you have is `{ "Ref": "AWS::Region" }`).
     *
     * @experimental
     */
    static readonly VPC_ENDPOINT_SERVICE_NAME_PREFIX = "com.amazonaws.vpce";
    /**
     * (experimental) Computes a "standard" AWS Service principal for a given service, region and suffix.
     *
     * This is useful for example when
     * you need to compute a service principal name, but you do not have a synthesize-time region literal available (so
     * all you have is `{ "Ref": "AWS::Region" }`). This way you get the same defaulting behavior that is normally used
     * for built-in data.
     *
     * @param service the name of the service (s3, s3.amazonaws.com, ...).
     * @param region the region in which the service principal is needed.
     * @param urlSuffix the URL suffix for the partition in which the region is located.
     * @experimental
     */
    static servicePrincipal(service: string, region: string, urlSuffix: string): string;
    private constructor();
}
