"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Default = void 0;
/**
 * (experimental) Provides default values for certain regional information points.
 *
 * @experimental
 */
class Default {
    constructor() { }
    /**
     * (experimental) Computes a "standard" AWS Service principal for a given service, region and suffix.
     *
     * This is useful for example when
     * you need to compute a service principal name, but you do not have a synthesize-time region literal available (so
     * all you have is `{ "Ref": "AWS::Region" }`). This way you get the same defaulting behavior that is normally used
     * for built-in data.
     *
     * @param service the name of the service (s3, s3.amazonaws.com, ...).
     * @param region the region in which the service principal is needed.
     * @param urlSuffix the URL suffix for the partition in which the region is located.
     * @experimental
     */
    static servicePrincipal(service, region, urlSuffix) {
        const matches = service.match(/^([^.]+)(?:(?:\.amazonaws\.com(?:\.cn)?)|(?:\.c2s\.ic\.gov)|(?:\.sc2s\.sgov\.gov))?$/);
        if (!matches) {
            // Return "service" if it does not look like any of the following:
            // - s3
            // - s3.amazonaws.com
            // - s3.amazonaws.com.cn
            // - s3.c2s.ic.gov
            // - s3.sc2s.sgov.gov
            return service;
        }
        service = matches[1]; // Simplify the service name down to something like "s3"
        // Exceptions for Service Principals in us-iso-*
        const US_ISO_EXCEPTIONS = new Set([
            'cloudhsm',
            'config',
            'states',
            'workspaces',
        ]);
        // Exceptions for Service Principals in us-isob-*
        const US_ISOB_EXCEPTIONS = new Set([
            'dms',
            'states',
        ]);
        // Account for idiosyncratic Service Principals in `us-iso-*` regions
        if (region.startsWith('us-iso-') && US_ISO_EXCEPTIONS.has(service)) {
            switch (service) {
                // Services with universal principal
                case ('states'):
                    return `${service}.amazonaws.com`;
                // Services with a partitional principal
                default:
                    return `${service}.${urlSuffix}`;
            }
        }
        // Account for idiosyncratic Service Principals in `us-isob-*` regions
        if (region.startsWith('us-isob-') && US_ISOB_EXCEPTIONS.has(service)) {
            switch (service) {
                // Services with universal principal
                case ('states'):
                    return `${service}.amazonaws.com`;
                // Services with a partitional principal
                default:
                    return `${service}.${urlSuffix}`;
            }
        }
        switch (service) {
            // Services with a regional AND partitional principal
            case 'codedeploy':
            case 'logs':
                return `${service}.${region}.${urlSuffix}`;
            // Services with a regional principal
            case 'states':
                return `${service}.${region}.amazonaws.com`;
            // Services with a partitional principal
            case 'ec2':
                return `${service}.${urlSuffix}`;
            // Services with a universal principal across all regions/partitions (the default case)
            default:
                return `${service}.amazonaws.com`;
        }
    }
}
exports.Default = Default;
/**
 * (experimental) The default value for a VPC Endpoint Service name prefix, useful if you do not have a synthesize-time region literal available (all you have is `{ "Ref": "AWS::Region" }`).
 *
 * @experimental
 */
Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX = 'com.amazonaws.vpce';
//# sourceMappingURL=data:application/json;base64,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