/**
 * (experimental) Information pertaining to an AWS region.
 *
 * @experimental
 */
export declare class RegionInfo {
    readonly name: string;
    /**
     * @returns the list of names of AWS regions for which there is at least one registered fact. This
     * may not be an exaustive list of all available AWS regions.
     * @experimental
     */
    static get regions(): RegionInfo[];
    /**
     * (experimental) Retrieves a collection of all fact values for all regions that fact is defined in.
     *
     * @param factName the name of the fact to retrieve values for.
     * @returns a mapping with AWS region codes as the keys,
     * and the fact in the given region as the value for that key
     * @experimental
     */
    static regionMap(factName: string): {
        [region: string]: string;
    };
    /**
     * (experimental) Obtain region info for a given region name.
     *
     * @param name the name of the region (e.g: us-east-1).
     * @experimental
     */
    static get(name: string): RegionInfo;
    private constructor();
    /**
     * (experimental) Whether the `AWS::CDK::Metadata` CloudFormation Resource is available in this region or not.
     *
     * @experimental
     */
    get cdkMetadataResourceAvailable(): boolean;
    /**
     * (experimental) The domain name suffix (e.g: amazonaws.com) for this region.
     *
     * @experimental
     */
    get domainSuffix(): string | undefined;
    /**
     * (experimental) The name of the ARN partition for this region (e.g: aws).
     *
     * @experimental
     */
    get partition(): string | undefined;
    /**
     * (experimental) The endpoint used by S3 static website hosting in this region (e.g: s3-static-website-us-east-1.amazonaws.com).
     *
     * @experimental
     */
    get s3StaticWebsiteEndpoint(): string | undefined;
    /**
     * (experimental) The hosted zone ID used by Route 53 to alias a S3 static website in this region (e.g: Z2O1EMRO9K5GLX).
     *
     * @experimental
     */
    get s3StaticWebsiteHostedZoneId(): string | undefined;
    /**
     * (experimental) The prefix for VPC Endpoint Service names, cn.com.amazonaws.vpce for China regions, com.amazonaws.vpce otherwise.
     *
     * @experimental
     */
    get vpcEndpointServiceNamePrefix(): string | undefined;
    /**
     * (experimental) The name of the service principal for a given service in this region.
     *
     * @param service the service name (e.g: s3.amazonaws.com).
     * @experimental
     */
    servicePrincipal(service: string): string | undefined;
    /**
     * (experimental) The account ID for ELBv2 in this region.
     *
     * @experimental
     */
    get elbv2Account(): string | undefined;
    /**
     * (experimental) The ID of the AWS account that owns the public ECR repository containing the AWS Deep Learning Containers images in this region.
     *
     * @experimental
     */
    get dlcRepositoryAccount(): string | undefined;
    /**
     * (experimental) The ID of the AWS account that owns the public ECR repository that contains the AWS App Mesh Envoy Proxy images in a given region.
     *
     * @experimental
     */
    get appMeshRepositoryAccount(): string | undefined;
}
