from __future__ import annotations

import logging
from dataclasses import dataclass, field
from enum import Enum
from typing import Optional

from cimgraph.data_profile.identity import Identity

_log = logging.getLogger(__name__)
'''
    Annotated CIMantic Graphs data profile for Profile
    Generated by CIMTool http://cimtool.org
'''

BASE_URI = 'http://www.ucaiug.org/profile#'
ONTOLOGY_URI = 'http://iec.ch/TC57/2012/CIM-schema-cim16#'

@dataclass(repr=False)
class TapChangerTablePoint(Identity):
    '''
    '''

    ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The voltage ratio in per unit. Hence this is a value close to one.
    '''

    step: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The tap step.
    '''

    b: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The magnetizing branch susceptance deviation in percent of nominal value.
    The actual susceptance is calculated as follows:
    calculated magnetizing susceptance = b(nominal) * (1 + b(from this class)/100).
    The b(nominal) is defined as the static magnetizing susceptance on the
    associated power transformer end or ends. This model assumes the star impedance
    (pi model) form.
    '''

    g: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The magnetizing branch conductance deviation in percent of nominal value.
    The actual conductance is calculated as follows:
    calculated magnetizing conductance = g(nominal) * (1 + g(from this class)/100).
    The g(nominal) is defined as the static magnetizing conductance on the
    associated power transformer end or ends. This model assumes the star impedance
    (pi model) form.
    '''

    r: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The resistance deviation in percent of nominal value. The actual reactance
    is calculated as follows:
    calculated resistance = r(nominal) * (1 + r(from this class)/100). The
    r(nominal) is defined as the static resistance on the associated power
    transformer end or ends. This model assumes the star impedance (pi model)
    form.
    '''

    x: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The series reactance deviation in percent of nominal value. The actual
    reactance is calculated as follows:
    calculated reactance = x(nominal) * (1 + x(from this class)/100). The x(nominal)
    is defined as the static series reactance on the associated power transformer
    end or ends. This model assumes the star impedance (pi model) form.
    '''

@dataclass(repr=False)
class PhaseTapChangerTablePoint(TapChangerTablePoint):
    '''
    Describes each tap step in the phase tap changer tabular curve.
    '''

    angle: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The angle difference in degrees. A positive value indicates a positive
    phase shift from the winding where the tap is located to the other winding
    (for a two-winding transformer).
    '''

    PhaseTapChangerTable: Optional[PhaseTapChangerTable] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PhaseTapChangerTable.PhaseTapChangerTablePoint',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The table of this point.
    '''

@dataclass(repr=False)
class RatioTapChangerTablePoint(TapChangerTablePoint):
    '''
    Describes each tap step in the ratio tap changer tabular curve.
    '''

    RatioTapChangerTable: Optional[RatioTapChangerTable] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RatioTapChangerTable.RatioTapChangerTablePoint',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Table of this point.
    '''

@dataclass(repr=False)
class AltGeneratingUnitMeas(Identity):
    '''
    A prioritized measurement to be used for the generating unit in the control
    area specificaiton.
    '''

    priority: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Priority of a measurement usage. Lower numbers have first priority.
    '''

    AnalogValue: Optional[AnalogValue] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AnalogValue.AltGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The specific analog value used as a source.
    '''

    ControlAreaGeneratingUnit: Optional[ControlAreaGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ControlAreaGeneratingUnit.AltGeneratingUnitMeas',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The control aread generating unit to which the prioritized measurement
    assignment is applied.
    '''

@dataclass(repr=False)
class AltTieMeas(Identity):
    '''
    A prioritized measurement to be used for the tie flow as part of the control
    area specification.
    '''

    priority: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Priority of a measurement usage. Lower numbers have first priority.
    '''

    AnalogValue: Optional[AnalogValue] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AnalogValue.AltTieMeas',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The specific analog value used as a source.
    '''

    TieFlow: Optional[TieFlow] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TieFlow.AltTieMeas',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The tie flow of the alternate measurements.
    '''

@dataclass(repr=False)
class BranchGroupTerminal(Identity):
    '''
    A specific directed terminal flow for a branch group.
    '''

    positiveFlowIn: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The flow into the terminal is summed if set true. The flow out of the terminanl
    is summed if set false.
    '''

    BranchGroup: Optional[BranchGroup] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BranchGroup.BranchGroupTerminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The branch group to which the directed branch group terminals belong.
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.BranchGroupTerminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The terminal to be summed.
    '''

@dataclass(repr=False)
class ConnectDisconnectFunction(Identity):
    '''
    A function that will disconnect and reconnect the customer's load under
    defined conditions.
    '''

    eventCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Running cumulative count of connect or disconnect events, for the lifetime
    of this function or until the value is cleared.
    '''

    isConnected: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if this function is in the connected state.
    '''

    isDelayedDiscon: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If set true, the switch may disconnect the service at the end of a specified
    time delay after the disconnect signal has been given. If set false, the
    switch may disconnect the service immediately after the disconnect signal
    has been given. This is typically the case for over current circuit-breakers
    which are classified as either instantaneous or slow acting.
    '''

    isLocalAutoDisconOp: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If set true and if disconnection can be operated locally, the operation
    happens automatically. Otherwise it happens manually.
    '''

    isLocalAutoReconOp: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If set true and if reconnection can be operated locally, then the operation
    happens automatically. Otherwise, it happens manually.
    '''

    isRemoteAutoDisconOp: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If set true and if disconnection can be operated remotely, then the operation
    happens automatically. If set false and if disconnection can be operated
    remotely, then the operation happens manually.
    '''

    isRemoteAutoReconOp: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If set true and if reconnection can be operated remotely, then the operation
    happens automatically. If set false and if reconnection can be operated
    remotely, then the operation happens manually.
    '''

    Switches: list[Switch] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Switch.ConnectDisconnectFunctions',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class CurveData(Identity):
    '''
    Multi-purpose data points for defining a curve. The use of this generic
    class is discouraged if a more specific class can be used to specify the
    x and y axis values along with their specific data types.
    '''

    xvalue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The data value of the X-axis variable, depending on the X-axis units.
    '''

    y1value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The data value of the first Y-axis variable, depending on the Y-axis units.
    '''

    y2value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The data value of the second Y-axis variable (if present), depending on
    the Y-axis units.
    '''

    y3value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The data value of the third Y-axis variable (if present), depending on
    the Y-axis units.
    '''

    Curve: Optional[Curve] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Curve.CurveDatas',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The curve of this curve data point.
    '''

@dataclass(repr=False)
class DiagramObjectGluePoint(Identity):
    '''
    This is used for grouping diagram object points from different diagram
    objects that are considered to be glued together in a diagram even if they
    are not at the exact same coordinates.
    '''

    DiagramObjectPoints: list[DiagramObjectPoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DiagramObjectPoint.DiagramObjectGluePoint',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A diagram object glue point is associated with 2 or more object points
    that are considered to be 'glued' together.
    '''

@dataclass(repr=False)
class DiagramObjectPoint(Identity):
    '''
    A point in a given space defined by 3 coordinates and associated to a diagram
    object. The coordinates may be positive or negative as the origin does
    not have to be in the corner of a diagram.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The sequence position of the point, used for defining the order of points
    for diagram objects acting as a polyline or polygon with more than one
    point.
    '''

    xPosition: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The X coordinate of this point.
    '''

    yPosition: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Y coordinate of this point.
    '''

    zPosition: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Z coordinate of this point.
    '''

    DiagramObject: Optional[DiagramObject] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DiagramObject.DiagramObjectPoints',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The diagram object with which the points are associated.
    '''

    DiagramObjectGluePoint: Optional[DiagramObjectGluePoint] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DiagramObjectGluePoint.DiagramObjectPoints',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The 'glue' point to which this point is associated.
    '''

@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a root class to provide common identification for all classes needing
    identification and naming attributes.
    '''

    mRID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Master resource identifier issued by a model authority. The mRID is globally
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in RFC 4122, for the mRID. The use of UUID
    is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552 Edition
    1, the mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
    object elements.
    '''

    aliasName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The aliasName is free text human readable name of the object alternative
    to IdentifiedObject.name. It may be non unique and may not correlate to
    a naming hierarchy.
    The attribute aliasName is retained because of backwards compatibility
    between CIM relases. It is however recommended to replace aliasName with
    the Name class as aliasName is planned for retirement at a future time.
    '''

    description: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The description is a free human readable text describing or naming the
    object. It may be non unique and may not correlate to a naming hierarchy.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''

    DiagramObjects: list[DiagramObject] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DiagramObject.IdentifiedObject',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The diagram objects that are associated with the domain object.
    '''

    Names: list[Name] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Name.IdentifiedObject',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All names of this identified object.
    '''

@dataclass(repr=False)
class ACDCTerminal(IdentifiedObject):
    '''
    An electrical connection point (AC or DC) to a piece of conducting equipment.
    Terminals are connected at physical connection points called connectivity
    nodes.
    '''

    connected: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The connected status is related to a bus-branch model and the topological
    node to terminal relation. True implies the terminal is connected to the
    related topological node and false implies it is not.
    In a bus-branch model, the connected status is used to tell if equipment
    is disconnected without having to change the connectivity described by
    the topological node to terminal relation. A valid case is that conducting
    equipment can be connected in one end and open in the other. In particular
    for an AC line segment, where the reactive line charging can be significant,
    this is a relevant case.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The orientation of the terminal connections for a multiple terminal conducting
    equipment. The sequence numbering starts with 1 and additional terminals
    should follow in increasing order. The first terminal is the "starting
    point" for a two terminal branch.
    '''

    BusNameMarker: Optional[BusNameMarker] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BusNameMarker.Terminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The bus name marker used to name the bus (topological node).
    '''

    Measurements: list[Measurement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Measurement.Terminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Measurements associated with this terminal defining where the measurement
    is placed in the network topology. It may be used, for instance, to capture
    the sensor position, such as a voltage transformer (PT) at a busbar or
    a current transformer (CT) at the bar between a breaker and an isolator.
    '''

    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperationalLimitSet.Terminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The operational limit sets at the terminal.
    '''

@dataclass(repr=False)
class DCBaseTerminal(ACDCTerminal):
    '''
    An electrical connection point at a piece of DC conducting equipment. DC
    terminals are connected at one physical DC node that may have multiple
    DC terminals connected. A DC node is similar to an AC connectivity node.
    The model enforces that DC connections are distinct from AC connections.
    '''

    DCNode: Optional[DCNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DCNode.DCTerminals',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The DC connectivity node to which this DC base terminal connects with zero
    impedance.
    '''

    DCTopologicalNode: Optional[DCTopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DCTopologicalNode.DCTerminals',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The DC topological node associated with the DC base terminal.
    '''

@dataclass(repr=False)
class ACDCConverterDCTerminal(DCBaseTerminal):
    '''
    A DC electrical connection point at the AC/DC converter. The AC/DC converter
    is electrically connected also to the AC side. The AC connection is inherited
    from the AC conducting equipment in the same way as any other AC equipment.
    The AC/DC converter DC terminal is separate from generic DC terminal to
    restrict the connection with the AC side to AC/DC converter and so that
    no other DC conducting equipment can be connected to the AC side.
    '''

    polarity: Optional[ DCPolarityKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Represents the normal network polarity condition.
    '''

    DCConductingEquipment: Optional[ACDCConverter] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACDCConverter.DCTerminals',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A DC converter terminal belong to an DC converter.
    '''

@dataclass(repr=False)
class DCTerminal(DCBaseTerminal):
    '''
    An electrical connection point to generic DC conducting equipment.
    '''

    DCConductingEquipment: Optional[DCConductingEquipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DCConductingEquipment.DCTerminals',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    An DC terminal belong to a DC conducting equipment.
    '''

@dataclass(repr=False)
class Terminal(ACDCTerminal):
    '''
    An AC electrical connection point to a piece of conducting equipment. Terminals
    are connected at physical connection points called connectivity nodes.
    '''

    phases: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Represents the normal network phasing condition.
    If the attribute is missing three phases (ABC or ABCN) shall be assumed.
    '''

    AuxiliaryEquipment: list[AuxiliaryEquipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AuxiliaryEquipment.Terminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The auxiliary equipment connected to the terminal.
    '''

    Bushing: Optional[Bushing] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Bushing.Terminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    ConductingEquipment: Optional[ConductingEquipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConductingEquipment.Terminals',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The conducting equipment of the terminal. Conducting equipment have terminals
    that may be connected to other conducting equipment terminals via connectivity
    nodes or topological nodes.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConnectivityNode.Terminals',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The connectivity node to which this terminal connects with zero impedance.
    '''

    HasFirstMutualCoupling: list[MutualCoupling] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MutualCoupling.First_Terminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Mutual couplings associated with the branch as the first branch.
    '''

    HasSecondMutualCoupling: list[MutualCoupling] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MutualCoupling.Second_Terminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Mutual couplings with the branch associated as the first branch.
    '''

    RegulatingControl: list[RegulatingControl] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RegulatingControl.Terminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The controls regulating this terminal.
    '''

    SvPowerFlow: Optional[SvPowerFlow] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SvPowerFlow.Terminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The power flow state variable associated with the terminal.
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalNode.Terminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The topological node associated with the terminal. This can be used as
    an alternative to the connectivity node path to topological node, thus
    making it unneccesary to model connectivity nodes in some cases. Note that
    the if connectivity nodes are in the model, this association would probably
    not be used as an input specification.
    '''

    TransformerEnd: list[TransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEnd.Terminal',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All transformer ends connected at this terminal.
    '''

@dataclass(repr=False)
class ActivityRecord(IdentifiedObject):
    '''
    Records activity for an entity at a point in time; activity may be for
    an event that has already occurred or for a planned activity.
    '''

    createdDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date and time this activity record has been created (different from the
    'status.dateTime', which is the time of a status change of the associated
    object, if applicable).
    '''

    reason: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reason for event resulting in this activity record, typically supplied
    when user initiated.
    '''

    severity: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Severity level of event resulting in this activity record.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of event resulting in this activity record.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.ActivityRecords',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All assets for which this activity record has been created.
    '''

    Organisations: list[Organisation] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Organisation.ActivityRecords',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class ConfigurationEvent(ActivityRecord):
    '''
    Used to report details on creation, change or deletion of an entity or
    its configuration.
    '''

    effectiveDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date and time this event has or will become effective.
    '''

    modifiedBy: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Source/initiator of modification.
    '''

    remark: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Free text remarks.
    '''

    ChangedAsset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Asset whose change resulted in this configuration event.
    '''

    ChangedDocument: Optional[Document] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Document.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Document whose change resulted in this configuration event.
    '''

    ChangedLocation: Optional[Location] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Location.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Location whose change resulted in this configuration event.
    '''

    ChangedOrganisationRole: Optional[OrganisationRole] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OrganisationRole.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Organisation role whose change resulted in this configuration event.
    '''

    ChangedPersonRole: Optional[PersonRole] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PersonRole.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Person role whose change resulted in this configuration event.
    '''

    ChangedServiceCategory: Optional[ServiceCategory] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ServiceCategory.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Service category whose change resulted in this configuration event.
    '''

    ChangedUsagePoint: Optional[UsagePoint] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'UsagePoint.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Usage point whose change resulted in this configuration event.
    '''

@dataclass(repr=False)
class Appointment(IdentifiedObject):
    '''
    Meeting time and location.
    '''

    callAhead: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if requested to call customer when someone is about to arrive at their
    premises.
    '''

    Persons: list[PersonRole] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PersonRole.Appointments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All persons for this appointment.
    '''

    Works: list[Work] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Work.Appointments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All works for this appointment.
    '''

@dataclass(repr=False)
class Asset(IdentifiedObject):
    '''
    Tangible resource of the utility, including power system equipment, various
    end devices, cabinets, buildings, etc. For electrical network equipment,
    the role of the asset is defined through PowerSystemResource and its subclasses,
    defined mainly in the Wires model (refer to IEC61970-301 and model package
    IEC61970::Wires). Asset description places emphasis on the physical characteristics
    of the equipment fulfilling that role.
    '''

    critical: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if asset is considered critical for some reason (for example, a pole
    with critical attachments).
    '''

    initialCondition: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Condition of asset in inventory or at time of installation. Examples include
    new, rebuilt, overhaul required, other. Refer to inspection data for information
    on the most current condition of the asset.
    '''

    lotNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Lot number for this asset. Even for the same model and version number,
    many assets are manufactured in lots.
    '''

    serialNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Serial number of this asset.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Utility-specific classification of Asset and its subtypes, according to
    their corporate standards, practices, and existing IT systems (e.g., for
    management of assets, maintenance, work, outage, customers, etc.).
    '''

    utcNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Uniquely tracked commodity (UTC) number.
    '''

    initialLossOfLife: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Whenever an asset is reconditioned, percentage of expected life for the
    asset when it was new; zero for new devices.
    '''

    purchasePrice: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Purchase price of asset.
    '''

    AssetContainer: Optional[AssetContainer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetContainer.Assets',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Container of this asset.
    '''

    AssetInfo: Optional[AssetInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetInfo.Assets',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Data applicable to this asset.
    '''

    ErpInventory: Optional[ErpInventory] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ErpInventory.Asset',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    ErpItemMaster: Optional[ErpItemMaster] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ErpItemMaster.Asset',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    FinancialInfo: Optional[FinancialInfo] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'FinancialInfo.Asset',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    Location: Optional[Location] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Location.Assets',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Location of this asset.
    '''

    Measurements: list[Measurement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Measurement.Asset',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerSystemResource.Assets',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All power system resources used to electrically model this asset. For example,
    transformer asset is electrically modelled with a transformer and its windings
    and tap changer.
    '''

@dataclass(repr=False)
class AssetContainer(Asset):
    '''
    Asset that is aggregation of other assets such as conductors, transformers,
    switchgear, land, fences, buildings, equipment, vehicles, etc.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.AssetContainer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All assets within this container asset.
    '''

@dataclass(repr=False)
class DuctBank(AssetContainer):
    '''
    A duct contains individual wires in the layout as specified with associated
    wire spacing instances; number of them gives the number of conductors in
    this duct.
    '''

    circuitCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Number of circuits in duct bank. Refer to associations between a duct (ConductorAsset)
    and an ACLineSegment to understand which circuits are in which ducts.
    '''

    WireSpacingInfos: list[WireSpacingInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WireSpacingInfo.DuctBank',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class Structure(AssetContainer):
    '''
    Construction holding assets such as conductors, transformers, switchgear,
    etc. Where applicable, number of conductors can be derived from the number
    of associated wire spacing instances.
    '''

    height: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Visible height of structure above ground level for overhead construction
    (e.g., Pole or Tower) or below ground level for an underground vault, manhole,
    etc. Refer to associated DimensionPropertiesInfo for other types of dimensions.
    '''

    materialKind: Optional[ StructureMaterialKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Material this structure is made of.
    '''

@dataclass(repr=False)
class Bushing(Asset):
    '''
    Bushing asset.
    '''

    c1PowerFactor: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Factory measured insulation power factor, measured between the power factor
    tap and the bushing conductor.
    '''

    c2PowerFactor: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Factory measured insulation power factor, measured between the power factor
    tap and ground.
    '''

    c1Capacitance: Optional[ float | Capacitance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Factory measured capacitance, measured between the power factor tap and
    the bushing conductor.
    '''

    c2Capacitance: Optional[ float | Capacitance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Factory measured capacitance measured between the power factor tap and
    ground.
    '''

    insulationKind: Optional[ BushingInsulationKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of insulation.
    '''

    BushingInsulationPFs: list[BushingInsulationPF] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'BushingInsulationPF.Bushing',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.Bushing',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class ComMedia(Asset):
    '''
    Communication media such as fibre optic cable, power-line, telephone, etc.
    '''

@dataclass(repr=False)
class AssetFunction(IdentifiedObject):
    '''
    Function performed by an asset.
    '''

    configID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Configuration specified for this function.
    '''

    firmwareID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Firmware version.
    '''

    hardwareID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Hardware version.
    '''

    password: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Password needed to access this function.
    '''

    programID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Name of program.
    '''

@dataclass(repr=False)
class AssetInfo(IdentifiedObject):
    '''
    Set of attributes of an asset, representing typical datasheet information
    of a physical device that can be instantiated and shared in different data
    exchange contexts:
    - as attributes of an asset instance (installed or in stock)
    - as attributes of an asset model (product by a manufacturer)
    - as attributes of a type asset (generic type of an asset as used in designs/extension
    planning).
    '''

    AssetModel: Optional[AssetModel] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetModel.AssetInfo',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Asset model described by this data.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.AssetInfo',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All assets described by this data.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerSystemResource.AssetDatasheet',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All power system resources with this datasheet information.
    '''

@dataclass(repr=False)
class BusbarSectionInfo(AssetInfo):
    '''
    Busbar section data.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated current.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated voltage.
    '''

@dataclass(repr=False)
class PowerTransformerInfo(AssetInfo):
    '''
    Set of power transformer data, from an equipment library.
    '''

    TransformerTankInfos: list[TransformerTankInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerTankInfo.PowerTransformerInfo',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Data for all the tanks described by this power transformer data.
    '''

@dataclass(repr=False)
class ShuntCompensatorInfo(AssetInfo):
    '''
    Properties of shunt capacitor, shunt reactor or switchable bank of shunt
    capacitor or reactor assets.
    '''

    maxPowerLoss: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum allowed apparent power loss.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated current.
    '''

    ratedReactivePower: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated reactive power.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated voltage.
    '''

    ShuntCompensatorControl: Optional[ShuntCompensatorControl] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ShuntCompensatorControl.ShuntCompensatorInfo',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class SwitchInfo(AssetInfo):
    '''
    Switch data.
    '''

    isSinglePhase: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true, it is a single phase switch.
    '''

    isUnganged: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true, the switch is not ganged (i.e., a switch phase may be operated
    separately from other phases).
    '''

    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum fault current a breaking device can break safely under prescribed
    conditions of use.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated current.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated voltage.
    '''

@dataclass(repr=False)
class TapChangerInfo(AssetInfo):
    '''
    Tap changer data.
    '''

    ctRatio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Built-in current transducer ratio.
    '''

    highStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Highest possible tap step position, advance from neutral.
    '''

    isTcul: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Whether this tap changer has under load tap changing capabilities.
    '''

    lowStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Lowest possible tap step position, retard from neutral.
    '''

    neutralStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The neutral tap step position for the winding.
    '''

    ptRatio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Built-in voltage transducer ratio.
    '''

    bil: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Basic Insulation Level (BIL) expressed as the impulse crest voltage of
    a nominal wave, typically 1.2 X 50 microsecond. This is a measure of the
    ability of the insulation to withstand very high voltage surges.
    '''

    ctRating: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Built-in current transformer primary rating.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Frequency at which the ratings apply.
    '''

    neutralU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Voltage at which the winding operates at the neutral tap setting.
    '''

    ratedApparentPower: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated apparent power.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated current.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated voltage.
    '''

    stepPhaseIncrement: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase shift per step position.
    '''

    stepVoltageIncrement: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Tap step increment, in per cent of rated voltage, per step position.
    '''

@dataclass(repr=False)
class TransformerEndInfo(AssetInfo):
    '''
    Transformer end data.
    '''

    endNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Number for this transformer end, corresponding to the end's order in the
    PowerTransformer.vectorGroup attribute. Highest voltage winding should
    be 1.
    '''

    phaseAngleClock: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Winding phase angle where 360 degrees are represented with clock hours,
    so the valid values are {0, ..., 11}. For example, to express the second
    winding in code 'Dyn11', set attributes as follows: 'endNumber'=2, 'connectionKind'
    = Yn and 'phaseAngleClock' = 11.
    '''

    connectionKind: Optional[ WindingConnection ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of connection.
    '''

    emergencyS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Apparent power that the winding can carry under emergency conditions (also
    called long-term emergency power).
    '''

    insulationU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Basic insulation level voltage rating.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    DC resistance.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal apparent power rating.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated voltage: phase-phase for three-phase windings, and either phase-phase
    or phase-neutral for single-phase windings.
    '''

    shortTermS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Apparent power that this winding can carry for a short period of time (in
    emergency).
    '''

    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''

    EnergisedEndNoLoadTests: list[NoLoadTest] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NoLoadTest.EnergisedEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All no-load test measurements in which this transformer end was energised.
    '''

    EnergisedEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OpenCircuitTest.EnergisedEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All open-circuit test measurements in which this transformer end was excited.
    '''

    EnergisedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ShortCircuitTest.EnergisedEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All short-circuit test measurements in which this transformer end was energised.
    '''

    FromMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerMeshImpedance.FromTransformerEndInfo',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All mesh impedances between this 'to' and other 'from' transformer ends.
    '''

    GroundedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ShortCircuitTest.GroundedEnds',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All short-circuit test measurements in which this transformer end was short-circuited.
    '''

    OpenEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OpenCircuitTest.OpenEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All open-circuit test measurements in which this transformer end was not
    excited.
    '''

    ToMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerMeshImpedance.ToTransformerEndInfos',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All mesh impedances between this 'from' and other 'to' transformer ends.
    '''

    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerStarImpedance.TransformerEndInfo',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''

    TransformerTankInfo: Optional[TransformerTankInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerTankInfo.TransformerEndInfos',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer tank data that this end description is part of.
    '''

@dataclass(repr=False)
class TransformerTankInfo(AssetInfo):
    '''
    Set of transformer tank data, from an equipment library.
    '''

    PowerTransformerInfo: Optional[PowerTransformerInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerTransformerInfo.TransformerTankInfos',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Power transformer data that this tank description is part of.
    '''

    TransformerEndInfos: list[TransformerEndInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEndInfo.TransformerTankInfo',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Data for all the ends described by this transformer tank data.
    '''

@dataclass(repr=False)
class WireInfo(AssetInfo):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    coreStrandCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if used) Number of strands in the steel core.
    '''

    insulated: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if conductor is insulated.
    '''

    sizeDescription: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
    '''

    strandCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Number of strands in the conductor.
    '''

    coreRadius: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if there is a different core material) Radius of the central core.
    '''

    gmr: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Geometric mean radius. If we replace the conductor by a thin walled tube
    of radius GMR, then its reactance is identical to the reactance of the
    actual conductor.
    '''

    insulationMaterial: Optional[ WireInsulationKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if insulated conductor) Material used for insulation.
    '''

    insulationThickness: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if insulated conductor) Thickness of the insulation.
    '''

    material: Optional[ WireMaterialKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Conductor material.
    '''

    rAC25: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    AC resistance per unit length of the conductor at 25 �C.
    '''

    rAC50: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    AC resistance per unit length of the conductor at 50 �C.
    '''

    rAC75: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    AC resistance per unit length of the conductor at 75 �C.
    '''

    radius: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Outside radius of the wire.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Current carrying capacity of the wire under stated thermal conditions.
    '''

    rDC20: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    DC resistance per unit length of the conductor at 20 �C.
    '''

    PerLengthParameters: list[PerLengthLineParameter] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PerLengthLineParameter.WireInfos',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All per-length parameters calculated from this wire datasheet.
    '''

@dataclass(repr=False)
class CableInfo(WireInfo):
    '''
    Cable data.
    '''

    isStrandFill: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if wire strands are extruded in a way to fill the voids in the cable.
    '''

    sheathAsNeutral: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if sheath / shield is used as a neutral (i.e., bonded).
    '''

    constructionKind: Optional[ CableConstructionKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of construction of this cable.
    '''

    diameterOverCore: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Diameter over the core, including any semi-con screen; should be the insulating
    layer's inside diameter.
    '''

    diameterOverInsulation: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Diameter over the insulating layer, excluding outer screen.
    '''

    diameterOverJacket: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Diameter over the outermost jacketing layer.
    '''

    diameterOverScreen: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Diameter over the outer screen; should be the shield's inside diameter.
    '''

    nominalTemperature: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum nominal design operating temperature.
    '''

    outerJacketKind: Optional[ CableOuterJacketKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of outer jacket of this cable.
    '''

    shieldMaterial: Optional[ CableShieldMaterialKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Material of the shield.
    '''

@dataclass(repr=False)
class ConcentricNeutralCableInfo(CableInfo):
    '''
    Concentric neutral cable data.
    '''

    neutralStrandCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Number of concentric neutral strands.
    '''

    diameterOverNeutral: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Diameter over the concentric neutral strands.
    '''

    neutralStrandGmr: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Geometric mean radius of the neutral strand.
    '''

    neutralStrandRadius: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Outside radius of the neutral strand.
    '''

    neutralStrandRDC20: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    DC resistance per unit length of the neutral strand at 20 �C.
    '''

@dataclass(repr=False)
class TapeShieldCableInfo(CableInfo):
    '''
    Tape shield cable data.
    '''

    tapeLap: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Percentage of the tape shield width that overlaps in each wrap, typically
    10% to 25%.
    '''

    tapeThickness: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Thickness of the tape shield, before wrapping.
    '''

@dataclass(repr=False)
class OverheadWireInfo(WireInfo):
    '''
    Overhead wire data.
    '''

@dataclass(repr=False)
class WireSpacingInfo(AssetInfo):
    '''
    Wire spacing data that associates multiple wire positions with the line
    segment, and allows to calculate line segment impedances. Number of phases
    can be derived from the number of associated wire positions whose phase
    is not neutral.
    '''

    isCable: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true, this spacing data describes a cable.
    '''

    phaseWireCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Number of wire sub-conductors in the symmetrical bundle (typically between
    1 and 4).
    '''

    phaseWireSpacing: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Distance between wire sub-conductors in a symmetrical bundle.
    '''

    usage: Optional[ WireUsageKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Usage of the associated wires.
    '''

    DuctBank: Optional[DuctBank] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DuctBank.WireSpacingInfos',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    PerLengthParameters: list[PerLengthLineParameter] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PerLengthLineParameter.WireSpacingInfo',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All per-length parameters calculated from this wire spacing datasheet.
    '''

    Structures: list[Structure] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Structure.WireSpacingInfos',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    WirePositions: list[WirePosition] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WirePosition.WireSpacingInfo',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All positions of single wires (phase or neutral) making the conductor.
    '''

@dataclass(repr=False)
class AssetModel(IdentifiedObject):
    '''
    Model of an asset, either a product of a specific manufacturer or a generic
    asset model or material item. Datasheet characteristics are available through
    the associated AssetInfo subclass and can be shared with asset or power
    system resource instances.
    '''

    AssetInfo: Optional[AssetInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetInfo.AssetModel',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Data applicable to this asset model.
    '''

@dataclass(repr=False)
class GenericAssetModelOrMaterial(AssetModel):
    '''
    Generic asset or material item that may be used for planning, work or design
    purposes.
    '''

@dataclass(repr=False)
class ProductAssetModel(AssetModel):
    '''
    Asset model by a specific manufacturer.
    '''

    modelNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Manufacturer's model number.
    '''

    modelVersion: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Version number for product model, which indicates vintage of the product.
    '''

    corporateStandardKind: Optional[ CorporateStandardKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of corporate standard for this asset model.
    '''

    usageKind: Optional[ AssetModelUsageKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Intended usage for this asset model.
    '''

    weightTotal: Optional[ float | Weight ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Total manufactured weight of asset.
    '''

    AssetModelCatalogueItems: list[AssetModelCatalogueItem] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AssetModelCatalogueItem.AssetModel',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    GenericAssetModelOrMaterial: Optional[GenericAssetModelOrMaterial] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GenericAssetModelOrMaterial.ProductAssetModels',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Generic asset model or material satisified by this product asset model.
    '''

    Manufacturer: Optional[Manufacturer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Manufacturer.ProductAssetModels',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Manufacturer of this asset model.
    '''

@dataclass(repr=False)
class AsynchronousMachineDynamics(IdentifiedObject):
    '''
    Asynchronous machine whose behaviour is described by reference to a standard
    model expressed in either time constant reactance form or equivalent circuit
    form <font color="#0f0f0f">or by definition of a user-defined model.</font>
    Parameter details:
    <ol>
    <li>Asynchronous machine parameters such as <i>Xl, Xs,</i> etc. are actually
    used as inductances in the model, but are commonly referred to as reactances
    since, at nominal frequency, the PU values are the same. However, some
    references use the symbol <i>L</i> instead of <i>X</i>.</li>
    </ol>
    '''

    AsynchronousMachine: Optional[AsynchronousMachine] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AsynchronousMachine.AsynchronousMachineDynamics',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Asynchronous machine to which this asynchronous machine dynamics model
    applies.
    '''

@dataclass(repr=False)
class BaseFrequency(IdentifiedObject):
    '''
    The class describe a base frequency for a power system network. In case
    of multiple power networks with different frequencies, e.g. 50 or 60 Hertz
    each network will have it's own base frequency class. Hence it is assumed
    that power system objects having different base frequencies appear in separate
    documents where each document has a single base frequency instance.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The base frequency.
    '''

@dataclass(repr=False)
class BasePower(IdentifiedObject):
    '''
    The BasePower class defines the base power used in the per unit calculations.
    '''

    basePower: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Value used as base power.
    '''

@dataclass(repr=False)
class BaseVoltage(IdentifiedObject):
    '''
    Defines a system base voltage which is referenced.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The power system resource's base voltage.
    '''

    ConductingEquipment: list[ConductingEquipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConductingEquipment.BaseVoltage',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All conducting equipment with this base voltage. Use only when there is
    no voltage level container used and only one base voltage applies. For
    example, not used for transformers.
    '''

    TopologicalNode: list[TopologicalNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TopologicalNode.BaseVoltage',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The topological nodes at the base voltage.
    '''

    TransformerEnds: list[TransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEnd.BaseVoltage',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer ends at the base voltage. This is essential for PU calculation.
    '''

    VoltageLevel: list[VoltageLevel] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'VoltageLevel.BaseVoltage',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The voltage levels having this base voltage.
    '''

@dataclass(repr=False)
class BasicIntervalSchedule(IdentifiedObject):
    '''
    Schedule of values at points in time.
    '''

    startTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The time for the first time point.
    '''

    value1Multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Multiplier for value1.
    '''

    value1Unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Value1 units of measure.
    '''

    value2Multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Multiplier for value2.
    '''

    value2Unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Value2 units of measure.
    '''

@dataclass(repr=False)
class IrregularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them varies.
    '''

    TimePoints: list[IrregularTimePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'IrregularTimePoint.IntervalSchedule',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The point data values that define a curve.
    '''

@dataclass(repr=False)
class RegularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them is constant.
    '''

    endTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The time for the last time point.
    '''

    timeStep: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The time between each pair of subsequent regular time points in sequence
    order.
    '''

    TimePoints: list[RegularTimePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RegularTimePoint.IntervalSchedule',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The regular interval time point data values that define this schedule.
    '''

@dataclass(repr=False)
class GenUnitOpSchedule(RegularIntervalSchedule):
    '''
    The generating unit's Operator-approved current operating schedule (or
    plan), typically produced with the aid of unit commitment type analyses.
    The X-axis represents absolute time. The Y1-axis represents the status
    (0=off-line and unavailable: 1=available: 2=must run: 3=must run at fixed
    power value: etc.). The Y2-axis represents the must run fixed power value
    where required.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeneratingUnit.GenUnitOpSchedule',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''

@dataclass(repr=False)
class HydroPumpOpSchedule(RegularIntervalSchedule):
    '''
    The hydro pump's Operator-approved current operating schedule (or plan),
    typically produced with the aid of unit commitment type analyses.The unit's
    operating schedule status is typically given as: (0=unavailable) (1=avilable
    to startup or shutdown) (2=must pump).
    '''

    HydroPump: Optional[HydroPump] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroPump.HydroPumpOpSchedule',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''

@dataclass(repr=False)
class InflowForecast(RegularIntervalSchedule):
    '''
    Natural water inflow to a reservoir, usually forecasted from predicted
    rain and snowmelt. Typically in one hour increments for up to 10 days.
    The forecast is given in average cubic meters per second over the time
    increment.
    '''

    Reservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.InflowForecasts',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A reservoir may have a "natural" inflow forecast.
    '''

@dataclass(repr=False)
class SeasonDayTypeSchedule(RegularIntervalSchedule):
    '''
    A time schedule covering a 24 hour period, with curve data for a specific
    type of season and day.
    '''

    DayType: Optional[DayType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DayType.SeasonDayTypeSchedules',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    DayType for the Schedule.
    '''

    Season: Optional[Season] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Season.SeasonDayTypeSchedules',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Season for the Schedule.
    '''

@dataclass(repr=False)
class ConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    A curve of load versus time (X-axis) showing the active power values (Y1-axis)
    and reactive power (Y2-axis) for each unit of the period covered. This
    curve represents a typical pattern of load over the time period for a given
    day type and season.
    '''

    ConformLoadGroup: Optional[ConformLoadGroup] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConformLoadGroup.ConformLoadSchedules',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The ConformLoadGroup where the ConformLoadSchedule belongs.
    '''

@dataclass(repr=False)
class NonConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    An active power (Y1-axis) and reactive power (Y2-axis) schedule (curves)
    versus time (X-axis) for non-conforming loads, e.g., large industrial load
    or power station service (where modeled).
    '''

    NonConformLoadGroup: Optional[NonConformLoadGroup] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NonConformLoadGroup.NonConformLoadSchedules',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The NonConformLoadGroup where the NonConformLoadSchedule belongs.
    '''

@dataclass(repr=False)
class RegulationSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a controlled variable, e.g., busbar
    voltage.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RegulatingControl.RegulationSchedule',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Regulating controls that have this Schedule.
    '''

    VoltageControlZones: list[VoltageControlZone] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'VoltageControlZone.RegulationSchedule',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A VoltageControlZone may have a voltage regulation schedule.
    '''

@dataclass(repr=False)
class SwitchSchedule(SeasonDayTypeSchedule):
    '''
    A schedule of switch positions. If RegularTimePoint.value1 is 0, the switch
    is open. If 1, the switch is closed.
    '''

    Switch: Optional[Switch] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Switch.SwitchSchedules',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A SwitchSchedule is associated with a Switch.
    '''

@dataclass(repr=False)
class TapSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a tap step.
    '''

    TapChanger: Optional[TapChanger] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TapChanger.TapSchedules',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A TapSchedule is associated with a TapChanger.
    '''

@dataclass(repr=False)
class SteamSendoutSchedule(RegularIntervalSchedule):
    '''
    The cogeneration plant's steam sendout schedule in volume per time unit.
    '''

    CogenerationPlant: Optional[CogenerationPlant] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CogenerationPlant.SteamSendoutSchedule',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''

@dataclass(repr=False)
class BranchGroup(IdentifiedObject):
    '''
    A group of branch terminals whose directed flow summation is to be monitored.
    A branch group need not form a cutset of the network.
    '''

    monitorActivePower: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Monitor the active power flow.
    '''

    monitorReactivePower: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Monitor the reactive power flow.
    '''

    maximumActivePower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum active power flow.
    '''

    maximumReactivePower: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum reactive power flow.
    '''

    minimumActivePower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum active power flow.
    '''

    minimumReactivePower: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum reactive power flow.
    '''

    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'BranchGroupTerminal.BranchGroup',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The directed branch group terminals to be summed.
    '''

@dataclass(repr=False)
class BusNameMarker(IdentifiedObject):
    '''
    Used to apply user standard names to topology buses. Typically used for
    "bus/branch" case generation. Associated with one or more terminals that
    are normally connected with the bus name. The associated terminals are
    normally connected by non-retained switches. For a ring bus station configuration,
    all busbar terminals in the ring are typically associated. For a breaker
    and a half scheme, both busbars would normally be associated. For a ring
    bus, all busbars would normally be associated. For a "straight" busbar
    configuration, normally only the main terminal at the busbar would be associated.
    '''

    priority: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Priority of bus name marker for use as topology bus name. Use 0 for don
    t care. Use 1 for highest priority. Use 2 as priority is less than 1 and
    so on.
    '''

    ReportingGroup: Optional[ReportingGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReportingGroup.BusNameMarker',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reporting group to which this bus name marker belongs.
    '''

    Terminal: list[ACDCTerminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ACDCTerminal.BusNameMarker',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The terminals associated with this bus name marker.
    '''

@dataclass(repr=False)
class BushingInsulationPF(IdentifiedObject):
    '''
    Bushing insulation power factor condition as a result of a test.
    Typical status values are: Acceptable, Minor Deterioration or Moisture
    Absorption, Major Deterioration or Moisture Absorption, Failed.
    '''

    testKind: Optional[ BushingInsulationPfTestKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of test for this bushing.
    '''

    Bushing: Optional[Bushing] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Bushing.BushingInsulationPFs',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    TransformerObservation: Optional[TransformerObservation] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerObservation.BushingInsultationPFs',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class CSCDynamics(IdentifiedObject):
    '''
    CSC function block whose behaviour is described by reference to a standard
    model <font color="#0f0f0f">or by definition of a user-defined model.</font>
    '''

    CSConverter: Optional[CsConverter] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CsConverter.CSCDynamics',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Current source converter to which current source converter dynamics model
    applies.
    '''

@dataclass(repr=False)
class ConnectivityNode(IdentifiedObject):
    '''
    Connectivity nodes are points where terminals of AC conducting equipment
    are connected together with zero impedance.
    '''

    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConnectivityNodeContainer.ConnectivityNodes',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Container of this connectivity node.
    '''

    Terminals: list[Terminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Terminal.ConnectivityNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Terminals interconnected with zero impedance at a this connectivity node.
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalNode.ConnectivityNodes',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The topological node to which this connectivity node is assigned. May depend
    on the current state of switches in the network.
    '''

@dataclass(repr=False)
class Contingency(IdentifiedObject):
    '''
    An event threatening system reliability, consisting of one or more contingency
    elements.
    '''

    mustStudy: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Set true if must study this contingency.
    '''

    ContingencyElement: list[ContingencyElement] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ContingencyElement.Contingency',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A contingency can have any number of contingency elements.
    '''

@dataclass(repr=False)
class ContingencyElement(IdentifiedObject):
    '''
    An element of a system event to be studied by contingency analysis, representing
    a change in status of a single piece of equipment.
    '''

    Contingency: Optional[Contingency] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Contingency.ContingencyElement',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A contingency element belongs to one contingency.
    '''

@dataclass(repr=False)
class ContingencyEquipment(ContingencyElement):
    '''
    A equipment to which the in service status is to change such as a power
    transformer or AC line segment.
    '''

    contingentStatus: Optional[ ContingencyEquipmentStatusKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The status for the associated equipment when in the contingency state.
    This status is independent of the case to which the contingency is originally
    applied, but defines the equipment status when the contingency is applied.
    '''

    Equipment: Optional[Equipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Equipment.ContingencyEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The single piece of equipment to which to apply the contingency.
    '''

@dataclass(repr=False)
class Control(IdentifiedObject):
    '''
    Control is used for supervisory/device control. It represents control outputs
    that are used to change the state in a process, e.g. close or open breaker,
    a set point value or a raise lower command.
    '''

    controlType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Specifies the type of Control, e.g. BreakerOn/Off, GeneratorVoltageSetPoint,
    TieLineFlow etc. The ControlType.name shall be unique among all specified
    types and describe the type.
    '''

    operationInProgress: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates that a client is currently sending control commands that has
    not completed.
    '''

    timeStamp: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The last time a control output was sent.
    '''

    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit multiplier of the controlled quantity.
    '''

    unitSymbol: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit of measure of the controlled quantity.
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerSystemResource.Controls',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Regulating device governed by this control output.
    '''

    RemoteControl: Optional[RemoteControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RemoteControl.Control',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The remote point controlling the physical actuator.
    '''

@dataclass(repr=False)
class AccumulatorReset(Control):
    '''
    This command reset the counter value to zero.
    '''

    AccumulatorValue: Optional[AccumulatorValue] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AccumulatorValue.AccumulatorReset',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The accumulator value that is reset by the command.
    '''

@dataclass(repr=False)
class AnalogControl(Control):
    '''
    An analog control used for supervisory control.
    '''

    maxValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal value range maximum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''

    minValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal value range minimum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''

    AnalogValue: Optional[AnalogValue] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AnalogValue.AnalogControl',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The MeasurementValue that is controlled.
    '''

@dataclass(repr=False)
class RaiseLowerCommand(AnalogControl):
    '''
    An analog control that increase or decrease a set point value with pulses.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ValueAliasSet.RaiseLowerCommands',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''

@dataclass(repr=False)
class SetPoint(AnalogControl):
    '''
    An analog control that issue a set point value.
    '''

    normalValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''

    value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The value representing the actuator output.
    '''

@dataclass(repr=False)
class Command(Control):
    '''
    A Command is a discrete control used for supervisory control.
    '''

    normalValue: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The value representing the actuator output.
    '''

    DiscreteValue: Optional[DiscreteValue] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DiscreteValue.Command',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The MeasurementValue that is controlled.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ValueAliasSet.Commands',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''

@dataclass(repr=False)
class DiscreteCommand(Command):
    '''
    '''

@dataclass(repr=False)
class ControlAreaGeneratingUnit(IdentifiedObject):
    '''
    A control area generating unit. This class is needed so that alternate
    control area definitions may include the same generating unit. Note only
    one instance within a control area should reference a specific generating
    unit.
    '''

    AltGeneratingUnitMeas: list[AltGeneratingUnitMeas] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AltGeneratingUnitMeas.ControlAreaGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The link to prioritized measurements for this GeneratingUnit.
    '''

    ControlArea: Optional[ControlArea] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ControlArea.ControlAreaGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The parent control area for the generating unit specifications.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeneratingUnit.ControlAreaGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The generating unit specified for this control area. Note that a control
    area should include a GeneratingUnit only once.
    '''

@dataclass(repr=False)
class CoordinateSystem(IdentifiedObject):
    '''
    Coordinate reference system.
    '''

    crsUrn: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A Uniform Resource Name (URN) for the coordinate reference system (crs)
    used to define 'Location.PositionPoints'.
    An example would be the European Petroleum Survey Group (EPSG) code for
    a coordinate reference system, defined in URN under the Open Geospatial
    Consortium (OGC) namespace as: urn:ogc:def:uom:EPSG::XXXX, where XXXX is
    an EPSG code (a full list of codes can be found at the EPSG Registry web
    site http://www.epsg-registry.org/). To define the coordinate system as
    being WGS84 (latitude, longitude) using an EPSG OGC, this attribute would
    be urn:ogc:def:uom:EPSG::4236.
    A profile should limit this code to a set of allowed URNs agreed to by
    all sending and receiving parties.
    '''

    Locations: list[Location] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Location.CoordinateSystem',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All locations described with position points in this coordinate system.
    '''

@dataclass(repr=False)
class Crew(IdentifiedObject):
    '''
    Group of people with specific skills, tools, and vehicles.
    '''

    CrewMembers: list[CrewMember] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CrewMember.Crew',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All members of this crew.
    '''

    CrewType: Optional[CrewType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CrewType.Crews',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of this crew.
    '''

@dataclass(repr=False)
class CrewType(IdentifiedObject):
    '''
    Custom description of the type of crew. This may be used to determine the
    type of work the crew can be assigned to. Examples include repair, tree
    trimming, switching, etc.
    '''

    Crews: list[Crew] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Crew.CrewType',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All crews of this type.
    '''

@dataclass(repr=False)
class Curve(IdentifiedObject):
    '''
    A multi-purpose curve or functional relationship between an independent
    variable (X-axis) and dependent (Y-axis) variables.
    '''

    curveStyle: Optional[ CurveStyle ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The style or shape of the curve.
    '''

    xMultiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Multiplier for X-axis.
    '''

    xUnit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The X-axis units of measure.
    '''

    y1Multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Multiplier for Y1-axis.
    '''

    y1Unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Y1-axis units of measure.
    '''

    y2Multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Multiplier for Y2-axis.
    '''

    y2Unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Y2-axis units of measure.
    '''

    y3Multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Multiplier for Y3-axis.
    '''

    y3Unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Y3-axis units of measure.
    '''

    CurveDatas: list[CurveData] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CurveData.Curve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The point data values that define this curve.
    '''

@dataclass(repr=False)
class CTTempActivePowerCurve(Curve):
    '''
    Relationship between the combustion turbine's power output rating in gross
    active power (X-axis) and the ambient air temperature (Y-axis).
    '''

    CombustionTurbine: Optional[CombustionTurbine] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CombustionTurbine.CTTempActivePowerCurve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A combustion turbine may have an active power versus ambient temperature
    relationship.
    '''

@dataclass(repr=False)
class EmissionAccount(Curve):
    '''
    Accounts for tracking emissions usage and credits for thermal generating
    units. A unit may have zero or more emission accounts, and will typically
    have one for tracking usage and one for tracking credits.
    '''

    emissionType: Optional[ EmissionType ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
    of the curve contains the unit of measure (e.g. kg) and the emissionType
    is the type of emission (e.g. sulfer dioxide).
    '''

    emissionValueSource: Optional[ EmissionValueSource ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The source of the emission value.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.EmmissionAccounts',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have one or more emission allowance accounts.
    '''

@dataclass(repr=False)
class EmissionCurve(Curve):
    '''
    Relationship between the unit's emission rate in units of mass per hour
    (Y-axis) and output active power (X-axis) for a given type of emission.
    This curve applies when only one type of fuel is being burned.
    '''

    isNetGrossP: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    emissionContent: Optional[ float | Emission ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The emission content per quantity of fuel burned.
    '''

    emissionType: Optional[ EmissionType ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The type of emission, which also gives the production rate measurement
    unit. The y1AxisUnits of the curve contains the unit of measure (e.g. kg)
    and the emissionType is the type of emission (e.g. sulfer dioxide).
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.EmissionCurves',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have one or more emission curves.
    '''

@dataclass(repr=False)
class FuelAllocationSchedule(Curve):
    '''
    The amount of fuel of a given type which is allocated for consumption over
    a specified period of time.
    '''

    fuelAllocationEndDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The end time and date of the fuel allocation schedule.
    '''

    fuelAllocationStartDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The start time and date of the fuel allocation schedule.
    '''

    maxFuelAllocation: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum amount fuel that is allocated for consumption for the scheduled
    time period.
    '''

    minFuelAllocation: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum amount fuel that is allocated for consumption for the scheduled
    time period, e.g., based on a "take-or-pay" contract.
    '''

    fuelType: Optional[ FuelType ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The type of fuel, which also indicates the corresponding measurement unit.
    '''

    FossilFuel: Optional[FossilFuel] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'FossilFuel.FuelAllocationSchedules',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A fuel allocation schedule must have a fossil fuel.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.FuelAllocationSchedules',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''

@dataclass(repr=False)
class GenUnitOpCostCurve(Curve):
    '''
    Relationship between unit operating cost (Y-axis) and unit output active
    power (X-axis). The operating cost curve for thermal units is derived from
    heat input and fuel costs. The operating cost curve for hydro units is
    derived from water flow rates and equivalent water costs.
    '''

    isNetGrossP: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeneratingUnit.GenUnitOpCostCurves',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A generating unit may have one or more cost curves, depending upon fuel
    mixture and fuel cost.
    '''

@dataclass(repr=False)
class GrossToNetActivePowerCurve(Curve):
    '''
    Relationship between the generating unit's gross active power output on
    the X-axis (measured at the terminals of the machine(s)) and the generating
    unit's net active power output on the Y-axis (based on utility-defined
    measurements at the power station). Station service loads, when modeled,
    should be treated as non-conforming bus loads. There may be more than one
    curve, depending on the auxiliary equipment that is in service.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeneratingUnit.GrossToNetActivePowerCurves',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A generating unit may have a gross active power to net active power curve,
    describing the losses and auxiliary power requirements of the unit.
    '''

@dataclass(repr=False)
class HeatInputCurve(Curve):
    '''
    Relationship between unit heat input in energy per time for main fuel (Y1-axis)
    and supplemental fuel (Y2-axis) versus unit output in active power (X-axis).
    The quantity of main fuel used to sustain generation at this output level
    is prorated for throttling between definition points. The quantity of supplemental
    fuel used at this output level is fixed and not prorated.
    '''

    isNetGrossP: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    auxPowerMult: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Power output - auxiliary power multiplier adjustment factor.
    '''

    auxPowerOffset: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Power output - auxiliary power offset adjustment factor.
    '''

    heatInputEff: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Heat input - efficiency multiplier adjustment factor.
    '''

    heatInputOffset: Optional[ float | HeatRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Heat input - offset adjustment factor.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''

@dataclass(repr=False)
class HeatRateCurve(Curve):
    '''
    Relationship between unit heat rate per active power (Y-axis) and unit
    output (X-axis). The heat input is from all fuels.
    '''

    isNetGrossP: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''

@dataclass(repr=False)
class HydroGeneratingEfficiencyCurve(Curve):
    '''
    Relationship between unit efficiency in percent and unit output active
    power for a given net head in meters. The relationship between efficiency,
    discharge, head, and power output is expressed as follows: E =KP/HQ
    Where: (E=percentage) (P=active power) (H=height) (Q=volume/time unit)
    (K=constant)
    For example, a curve instance for a given net head could relate efficiency
    (Y-axis) versus active power output (X-axis) or versus discharge on the
    X-axis.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroGeneratingUnit.HydroGeneratingEfficiencyCurves',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A hydro generating unit has an efficiency curve.
    '''

@dataclass(repr=False)
class IncrementalHeatRateCurve(Curve):
    '''
    Relationship between unit incremental heat rate in (delta energy/time)
    per (delta active power) and unit output in active power. The IHR curve
    represents the slope of the HeatInputCurve. Note that the "incremental
    heat rate" and the "heat rate" have the same engineering units.
    '''

    isNetGrossP: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''

@dataclass(repr=False)
class LevelVsVolumeCurve(Curve):
    '''
    Relationship between reservoir volume and reservoir level. The volume is
    at the y-axis and the reservoir level at the x-axis.
    '''

    Reservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.LevelVsVolumeCurves',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A reservoir may have a level versus volume relationship.
    '''

@dataclass(repr=False)
class PenstockLossCurve(Curve):
    '''
    Relationship between penstock head loss (in meters) and total discharge
    through the penstock (in cubic meters per second). One or more turbines
    may be connected to the same penstock.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''

@dataclass(repr=False)
class ReactiveCapabilityCurve(Curve):
    '''
    Reactive power rating envelope versus the synchronous machine's active
    power, in both the generating and motoring modes. For each active power
    value there is a corresponding high and low reactive power limit value.
    Typically there will be a separate curve for each coolant condition, such
    as hydrogen pressure. The Y1 axis values represent reactive minimum and
    the Y2 axis values represent reactive maximum.
    '''

    coolantTemperature: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The machine's coolant temperature (e.g., ambient air or stator circulating
    water).
    '''

    hydrogenPressure: Optional[ float | Pressure ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The hydrogen coolant pressure
    '''

    EquivalentInjection: list[EquivalentInjection] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EquivalentInjection.ReactiveCapabilityCurve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The equivalent injection using this reactive capability curve.
    '''

    SynchronousMachines: list[SynchronousMachine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SynchronousMachine.ReactiveCapabilityCurves',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Synchronous machines using this curve.
    '''

@dataclass(repr=False)
class ShutdownCurve(Curve):
    '''
    Relationship between the rate in gross active power/minute (Y-axis) at
    which a unit should be shutdown and its present gross MW output (X-axis).
    '''

    shutdownDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The date and time of the most recent generating unit shutdown.
    '''

    shutdownCost: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fixed shutdown cost.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''

@dataclass(repr=False)
class StartIgnFuelCurve(Curve):
    '''
    The quantity of ignition fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    ignitionFuelType: Optional[ FuelType ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of ignition fuel.
    '''

    StartupModel: Optional[StartupModel] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartupModel.StartIgnFuelCurve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''

@dataclass(repr=False)
class StartMainFuelCurve(Curve):
    '''
    The quantity of main fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    mainFuelType: Optional[ FuelType ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of main fuel.
    '''

    StartupModel: Optional[StartupModel] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartupModel.StartMainFuelCurve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''

@dataclass(repr=False)
class StartRampCurve(Curve):
    '''
    Rate in gross active power/minute (Y-axis) at which a unit can be loaded
    versus the number of hours (X-axis) the unit was off line.
    '''

    hotStandbyRamp: Optional[ float | ActivePowerChangeRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The startup ramp rate in gross for a unit that is on hot standby.
    '''

    StartupModel: Optional[StartupModel] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartupModel.StartRampCurve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''

@dataclass(repr=False)
class TailbayLossCurve(Curve):
    '''
    Relationship between tailbay head loss hight (y-axis) and the total discharge
    into the power station's tailbay volume per time unit (x-axis) . There
    could be more than one curve depending on the level of the tailbay reservoir
    or river level.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroGeneratingUnit.TailbayLossCurve',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A hydro generating unit has a tailbay loss curve.
    '''

@dataclass(repr=False)
class TargetLevelSchedule(Curve):
    '''
    Reservoir water level targets from advanced studies or "rule curves". Typically
    in one hour increments for up to 10 days.
    '''

    highLevelLimit: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    High target level limit, above which the reservoir operation will be penalized.
    '''

    lowLevelLimit: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Low target level limit, below which the reservoir operation will be penalized.
    '''

    Reservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.TargetLevelSchedule',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A reservoir may have a water level target schedule.
    '''

@dataclass(repr=False)
class VsCapabilityCurve(Curve):
    '''
    The P-Q capability curve for a voltage source converter, with P on x-axis
    and Qmin and Qmax on y1-axis and y2-axis.
    '''

@dataclass(repr=False)
class DCNode(IdentifiedObject):
    '''
    DC nodes are points where terminals of DC conducting equipment are connected
    together with zero impedance.
    '''

    DCEquipmentContainer: Optional[DCEquipmentContainer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DCEquipmentContainer.DCNodes',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The DC container for the DC nodes.
    '''

    DCTerminals: list[DCBaseTerminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DCBaseTerminal.DCNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    DC base terminals interconnected with zero impedance at a this DC connectivity
    node.
    '''

    DCTopologicalNode: Optional[DCTopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DCTopologicalNode.DCNodes',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The DC topological node to which this DC connectivity node is assigned.
    May depend on the current state of switches in the network.
    '''

@dataclass(repr=False)
class DCTopologicalIsland(IdentifiedObject):
    '''
    An electrically connected subset of the network. DC topological islands
    can change as the current network state changes: e.g. due to
    - disconnect switches or breakers change state in a SCADA/EMS
    - manual creation, change or deletion of topological nodes in a planning
    tool.
    '''

    DCTopologicalNodes: list[DCTopologicalNode] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DCTopologicalNode.DCTopologicalIsland',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The DC topological nodes in a DC topological island.
    '''

@dataclass(repr=False)
class DCTopologicalNode(IdentifiedObject):
    '''
    DC bus.
    '''

    DCEquipmentContainer: Optional[DCEquipmentContainer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DCEquipmentContainer.DCTopologicalNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The connectivity node container to which the toplogical node belongs.
    '''

    DCNodes: list[DCNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DCNode.DCTopologicalNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The DC connectivity nodes combined together to form this DC topological
    node. May depend on the current state of switches in the network.
    '''

    DCTerminals: list[DCBaseTerminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DCBaseTerminal.DCTopologicalNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The DC base terminals associated with the DC topological node.
    '''

    DCTopologicalIsland: Optional[DCTopologicalIsland] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DCTopologicalIsland.DCTopologicalNodes',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A DC topological node belongs to a DC topological island.
    '''

@dataclass(repr=False)
class DayType(IdentifiedObject):
    '''
    Group of similar days. For example it could be used to represent weekdays,
    weekend, or holidays.
    '''

    SeasonDayTypeSchedules: list[SeasonDayTypeSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SeasonDayTypeSchedule.DayType',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Schedules that use this DayType.
    '''

@dataclass(repr=False)
class Diagram(IdentifiedObject):
    '''
    The diagram being exchanged. The coordinate system is a standard Cartesian
    coordinate system and the orientation attribute defines the orientation.
    '''

    x1InitialView: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    X coordinate of the first corner of the initial view.
    '''

    x2InitialView: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    X coordinate of the second corner of the initial view.
    '''

    y1InitialView: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Y coordinate of the first corner of the initial view.
    '''

    y2InitialView: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Y coordinate of the second corner of the initial view.
    '''

    orientation: Optional[ OrientationKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Coordinate system orientation of the diagram.
    '''

    DiagramElements: list[DiagramObject] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DiagramObject.Diagram',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A diagram is made up of multiple diagram objects.
    '''

    DiagramStyle: Optional[DiagramStyle] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DiagramStyle.Diagram',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A Diagram may have a DiagramStyle.
    '''

@dataclass(repr=False)
class DiagramObject(IdentifiedObject):
    '''
    An object that defines one or more points in a given space. This object
    can be associated with anything that specializes IdentifiedObject. For
    single line diagrams such objects typically include such items as analog
    values, breakers, disconnectors, power transformers, and transmission lines.
    '''

    drawingOrder: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The drawing order of this element. The higher the number, the later the
    element is drawn in sequence. This is used to ensure that elements that
    overlap are rendered in the correct order.
    '''

    isPolygon: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Defines whether or not the diagram objects points define the boundaries
    of a polygon or the routing of a polyline. If this value is true then a
    receiving application should consider the first and last points to be connected.
    '''

    offsetX: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The offset in the X direction. This is used for defining the offset from
    centre for rendering an icon (the default is that a single point specifies
    the centre of the icon).
    The offset is in per-unit with 0 indicating there is no offset from the
    horizontal centre of the icon. -0.5 indicates it is offset by 50% to the
    left and 0.5 indicates an offset of 50% to the right.
    '''

    offsetY: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The offset in the Y direction. This is used for defining the offset from
    centre for rendering an icon (the default is that a single point specifies
    the centre of the icon).
    The offset is in per-unit with 0 indicating there is no offset from the
    vertical centre of the icon. The offset direction is dependent on the orientation
    of the diagram, with -0.5 and 0.5 indicating an offset of +/- 50% on the
    vertical axis.
    '''

    rotation: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Sets the angle of rotation of the diagram object. Zero degrees is pointing
    to the top of the diagram. Rotation is clockwise.
    '''

    Diagram: Optional[Diagram] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Diagram.DiagramElements',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A diagram object is part of a diagram.
    '''

    DiagramObjectPoints: list[DiagramObjectPoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DiagramObjectPoint.DiagramObject',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A diagram object can have 0 or more points to reflect its layout position,
    routing (for polylines) or boundary (for polygons).
    '''

    DiagramObjectStyle: Optional[DiagramObjectStyle] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DiagramObjectStyle.StyledObjects',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A diagram object has a style associated that provides a reference for the
    style used in the originating system.
    '''

    IdentifiedObject: Optional[IdentifiedObject] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IdentifiedObject.DiagramObjects',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The domain object to which this diagram object is associated.
    '''

    VisibilityLayers: list[VisibilityLayer] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'VisibilityLayer.VisibleObjects',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A diagram object can be part of multiple visibility layers.
    '''

@dataclass(repr=False)
class TextDiagramObject(DiagramObject):
    '''
    A diagram object for placing free-text or text derived from an associated
    domain object.
    '''

    text: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The text that is displayed by this text diagram object.
    '''

@dataclass(repr=False)
class DiagramObjectStyle(IdentifiedObject):
    '''
    A reference to a style used by the originating system for a diagram object.
    A diagram object style describes information such as line thickness, shape
    such as circle or rectangle etc, and color.
    '''

    StyledObjects: list[DiagramObject] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DiagramObject.DiagramObjectStyle',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A style can be assigned to multiple diagram objects.
    '''

@dataclass(repr=False)
class DiagramStyle(IdentifiedObject):
    '''
    The diagram style refer to a style used by the originating system for a
    diagram. A diagram style describes information such as schematic, geographic,
    bus-branch etc.
    '''

    Diagram: list[Diagram] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Diagram.DiagramStyle',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A DiagramStyle can be used by many Diagrams.
    '''

@dataclass(repr=False)
class Document(IdentifiedObject):
    '''
    Parent class for different groupings of information collected and managed
    as a part of a business process. It will frequently contain references
    to other objects, such as assets, people and power system resources.
    '''

    authorName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Name of the author of this document.
    '''

    comment: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Free text comment.
    '''

    createdDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date and time that this document was created.
    '''

    lastModifiedDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date and time this document was last modified. Documents may potentially
    be modified many times during their lifetime.
    '''

    revisionNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Revision number for this document.
    '''

    subject: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Document subject.
    '''

    title: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Document title.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Utility-specific classification of this document, according to its corporate
    standards, practices, and existing IT systems (e.g., for management of
    assets, maintenance, work, outage, customers, etc.).
    '''

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConfigurationEvent.ChangedDocument',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All configuration events created for this document.
    '''

@dataclass(repr=False)
class Agreement(Document):
    '''
    Formal agreement between two parties defining the terms and conditions
    for a set of services. The specifics of the services are, in turn, defined
    via one or more service agreements.
    '''

    signDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date this agreement was consummated among associated persons and/or organisations.
    '''

@dataclass(repr=False)
class AssetModelCatalogueItem(Document):
    '''
    Provides pricing and other relevant information about a specific manufacturer's
    product (i.e., AssetModel), and its price from a given supplier. A single
    AssetModel may be availble from multiple suppliers. Note that manufacturer
    and supplier are both types of organisation, which the association is inherited
    from Document.
    '''

@dataclass(repr=False)
class OperationalRestriction(Document):
    '''
    A document that can be associated with equipment to describe any sort of
    restrictions compared with the original manufacturer's specification or
    with the usual operational practice e.g. temporary maximum loadings, maximum
    switching current, do not operate if bus couplers are open, etc.
    In the UK, for example, if a breaker or switch ever mal-operates, this
    is reported centrally and utilities use their asset systems to identify
    all the installed devices of the same manufacturer's type. They then apply
    operational restrictions in the operational systems to warn operators of
    potential problems. After appropriate inspection and maintenance, the operational
    restrictions may be removed.
    '''

    Equipments: list[Equipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Equipment.OperationalRestrictions',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All equipments to which this restriction applies.
    '''

    ProductAssetModel: Optional[ProductAssetModel] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ProductAssetModel.OperationalRestrictions',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Asset model to which this restriction applies.
    '''

@dataclass(repr=False)
class Outage(Document):
    '''
    Document describing details of an active or planned outage in a part of
    the electrical network.
    A non-planned outage may be created upon:
    - a breaker trip,
    - a fault indicator status change,
    - a meter event indicating customer outage,
    - a reception of one or more customer trouble calls, or
    - an operator command, reflecting information obtained from the field crew.
    Outage restoration may be performed using a switching plan which complements
    the outage information with detailed switching activities, including the
    relationship to the crew and work.
    A planned outage may be created upon:
    - a request for service, maintenance or construction work in the field,
    or
    - an operator-defined outage for what-if/contingency network analysis.
    '''

    cancelledDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date and time planned outage has been cancelled.
    '''

    cause: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    One or more causes of this outage.
    Note: At present, this is a free text; could be replaced with a separate
    associated class in case we have multiple causes (e.g. OutageCauseType,
    inheriting from IdentifiedObject).
    '''

    isPlanned: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if planned, false otherwise (for example due to a breaker trip).
    '''

    Equipments: list[Equipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Equipment.Outages',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All equipments associated with this outage.
    '''

    OpenedSwitches: list[Switch] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Switch.Outage',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All potentially open switches causing this outage. This realationship is
    meant to be used as "indication" for initiation of outage-related business
    processes, whereas for actual actions of switches, SwitchAction-Switch
    relationship should be used.
    '''

@dataclass(repr=False)
class Procedure(Document):
    '''
    Documented procedure for various types of work or work tasks on assets.
    '''

    instruction: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Textual description of this procedure.
    '''

    sequenceNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Sequence number in a sequence of procedures being performed.
    '''

    kind: Optional[ ProcedureKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of procedure.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.Procedures',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All assets to which this procedure applies.
    '''

    Limits: list[Limit] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Limit.Procedures',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    Measurements: list[Measurement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Measurement.Procedures',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Document containing this measurement.
    '''

    ProcedureDataSets: list[ProcedureDataSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProcedureDataSet.Procedure',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All data sets captured by this procedure.
    '''

@dataclass(repr=False)
class ProcedureDataSet(Document):
    '''
    A data set recorded each time a procedure is executed. Observed results
    are captured in associated measurement values and/or values for properties
    relevant to the type of procedure performed.
    '''

    completedDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date and time procedure was completed.
    '''

    MeasurementValues: list[MeasurementValue] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeasurementValue.ProcedureDataSets',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    Procedure: Optional[Procedure] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Procedure.ProcedureDataSets',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Procedure capturing this data set.
    '''

    Properties: list[UserAttribute] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UserAttribute.ProcedureDataSets',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    UserAttributes used to specify further properties of this procedure data
    set. Use 'name' to specify what kind of property it is, and 'value.value'
    attribute for the actual value.
    '''

    TransformerObservations: list[TransformerObservation] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerObservation.ProcedureDataSets',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class InspectionDataSet(ProcedureDataSet):
    '''
    Documents the result of one inspection, for a given attribute of an asset.
    '''

    locationCondition: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Description of the conditions of the location where the asset resides.
    '''

    AccordingToSchedules: list[ScheduledEventData] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ScheduledEventData.InspectionDataSet',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class Specification(Document):
    '''
    Specification can be used for various purposes relative to an asset, a
    logical device (PowerSystemResource), location, etc. Examples include documents
    supplied by manufacturers such as asset installation instructions, asset
    maintenance instructions, etc.
    '''

@dataclass(repr=False)
class SwitchingStepGroup(Document):
    '''
    A logical step, grouping atomic switching steps that are important to distinguish
    when they may change topology (e.g. placing a jumper between two cuts).
    '''

@dataclass(repr=False)
class TimeSchedule(Document):
    '''
    Description of anything that changes through time. Time schedule is used
    to perform a single-valued function of time. Use inherited 'type' attribute
    to give additional information on this schedule, such as: periodic (hourly,
    daily, weekly, monthly, etc.), day of the month, by date, calendar (specific
    times and dates).
    '''

    disabled: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if this schedule is deactivated (disabled).
    '''

    recurrencePattern: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Interval at which the scheduled action repeats (e.g., first Monday of every
    month, last day of the month, etc.).
    '''

    offset: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The offset from midnight (i.e., 0 h, 0 min, 0 s) for the periodic time
    points to begin. For example, for an interval meter that is set up for
    five minute intervals ('recurrencePeriod'=300=5 min), setting 'offset'=120=2
    min would result in scheduled events to read the meter executing at 2 min,
    7 min, 12 min, 17 min, 22 min, 27 min, 32 min, 37 min, 42 min, 47 min,
    52 min, and 57 min past each hour.
    '''

    recurrencePeriod: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Duration between time points, from the beginning of one period to the beginning
    of the next period. Note that a device like a meter may have multiple interval
    periods (e.g., 1 min, 5 min, 15 min, 30 min, or 60 min).
    '''

    TimePoints: list[TimePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TimePoint.TimeSchedule',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Sequence of time points belonging to this time schedule.
    '''

@dataclass(repr=False)
class EnergyArea(IdentifiedObject):
    '''
    Describes an area having energy production or consumption. Specializations
    are intended to support the load allocation function as typically required
    in energy management systems or planning studies to allocate hypothesized
    load levels to individual load points for power flow analysis. Often the
    energy area can be linked to both measured and forecast load levels.
    '''

    ControlArea: Optional[ControlArea] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ControlArea.EnergyArea',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The control area specification that is used for the load forecast.
    '''

@dataclass(repr=False)
class LoadArea(EnergyArea):
    '''
    The class is the root or first level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    SubLoadAreas: list[SubLoadArea] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SubLoadArea.LoadArea',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The SubLoadAreas in the LoadArea.
    '''

@dataclass(repr=False)
class SubLoadArea(EnergyArea):
    '''
    The class is the second level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    LoadArea: Optional[LoadArea] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'LoadArea.SubLoadAreas',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The LoadArea where the SubLoadArea belongs.
    '''

    LoadGroups: list[LoadGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'LoadGroup.SubLoadArea',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Loadgroups in the SubLoadArea.
    '''

@dataclass(repr=False)
class EnergySchedulingType(IdentifiedObject):
    '''
    Used to define the type of generation for scheduling purposes.
    '''

    EnergySource: list[EnergySource] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnergySource.EnergySchedulingType',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Energy Source of a particular Energy Scheduling Type
    '''

@dataclass(repr=False)
class EquipmentLimitSeriesComponent(IdentifiedObject):
    '''
    This represents one instance of an equipment that contributes to the calculation
    of an operational limit.
    '''

    Equipment: Optional[Equipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Equipment.EqiupmentLimitSeriesComponent',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Equipment contributing toward the series limit. The reference here is to
    Equipment rather than a specific limit on the equipment so the grouiping
    can be reused for multiple limits of different types on the same instance
    of equipment.
    '''

    SeriesEquipmentDependentLimit: Optional[SeriesEquipmentDependentLimit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SeriesEquipmentDependentLimit.EquipmentLimitSeriesComponent',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Calculation in which the refernce to equipment applies.
    '''

@dataclass(repr=False)
class ErpInventory(IdentifiedObject):
    '''
    Utility inventory-related information about an item or part (and not for
    description of the item and its attributes). It is used by ERP applications
    to enable the synchronization of Inventory data that exists on separate
    Item Master databases. This data is not the master data that describes
    the attributes of the item such as dimensions, weight, or unit of measure
    - it describes the item as it exists at a specific location.
    '''

    Asset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.ErpInventory',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class ErpItemMaster(IdentifiedObject):
    '''
    Any unique purchased part for manufactured product tracked by ERP systems
    for a utility.
    Item, as used by the OAG, refers to the basic information about an item,
    including its attributes, cost, and locations. It does not include item
    quantities. Compare to the Inventory, which includes all quantities and
    other location-specific information.
    '''

    Asset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.ErpItemMaster',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class Fault(IdentifiedObject):
    '''
    Abnormal condition causing current flow through conducting equipment, such
    as caused by equipment failure or short circuits from objects not typically
    modeled (for example, a tree falling on a line).
    '''

    kind: Optional[ PhaseConnectedFaultKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The kind of phase fault.
    '''

    phases: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The phases participating in the fault. The fault connections into these
    phases are further specified by the type of fault.
    '''

    FaultCauseTypes: list[FaultCauseType] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'FaultCauseType.Faults',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All types of fault cause.
    '''

    FaultyEquipment: Optional[Equipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Equipment.Faults',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Equipment carrying this fault.
    '''

    Outage: Optional[Outage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Outage.Faults',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Outage associated with this fault.
    '''

@dataclass(repr=False)
class EquipmentFault(Fault):
    '''
    A fault applied at the terminal, external to the equipment. This class
    is not used to specify faults internal to the equipment.
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.EquipmentFaults',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The terminal connecting to the bus to which the fault is applied.
    '''

@dataclass(repr=False)
class LineFault(Fault):
    '''
    A fault that occurs on an AC line segment at some point along the length.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The length to the place where the fault is located starting from terminal
    with sequence number 1 of the faulted line segment.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.LineFaults',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The line segment of this line fault.
    '''

@dataclass(repr=False)
class FaultCauseType(IdentifiedObject):
    '''
    Type of cause of the fault.
    '''

    Faults: list[Fault] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Fault.FaultCauseTypes',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All faults with this cause type.
    '''

@dataclass(repr=False)
class FinancialInfo(IdentifiedObject):
    '''
    Various current financial properties associated with a particular asset.
    Historical properties may be determined by ActivityRecords associated with
    the asset.
    '''

@dataclass(repr=False)
class FossilFuel(IdentifiedObject):
    '''
    The fossil fuel consumed by the non-nuclear thermal generating unit. For
    example, coal, oil, gas, etc. This a the specific fuels that the generating
    unit can consume.
    '''

    fuelHeatContent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The amount of heat per weight (or volume) of the given type of fuel.
    '''

    fossilFuelType: Optional[ FuelType ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The type of fossil fuel, such as coal, oil, or gas.
    '''

    fuelCost: Optional[ float | CostPerHeatUnit ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The cost in terms of heat value for the given type of fuel.
    '''

    fuelDispatchCost: Optional[ float | CostPerHeatUnit ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The cost of fuel used for economic dispatching which includes: fuel cost,
    transportation cost, and incremental maintenance cost.
    '''

    fuelEffFactor: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The efficiency factor for the fuel (per unit) in terms of the effective
    energy absorbed.
    '''

    fuelHandlingCost: Optional[ float | CostPerHeatUnit ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Handling and processing cost associated with this fuel.
    '''

    fuelMixture: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Relative amount of the given type of fuel, when multiple fuels are being
    consumed.
    '''

    fuelSulfur: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The fuel's fraction of pollution credit per unit of heat content.
    '''

    highBreakpointP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The active power output level of the unit at which the given type of fuel
    is switched on. This fuel (e.g., oil) is sometimes used to supplement the
    base fuel (e.g., coal) at high active power output levels.
    '''

    lowBreakpointP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The active power output level of the unit at which the given type of fuel
    is switched off. This fuel (e.g., oil) is sometimes used to stabilize the
    base fuel (e.g., coal) at low active power output levels.
    '''

    FuelAllocationSchedules: list[FuelAllocationSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'FuelAllocationSchedule.FossilFuel',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A fuel allocation schedule must have a fossil fuel.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.FossilFuels',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''

@dataclass(repr=False)
class GeographicalRegion(IdentifiedObject):
    '''
    A geographical region of a power system network model.
    '''

    Regions: list[SubGeographicalRegion] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SubGeographicalRegion.Region',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All sub-geograhpical regions within this geographical region.
    '''

@dataclass(repr=False)
class Hazard(IdentifiedObject):
    '''
    An object or a condition that is a danger for causing loss or perils to
    an asset and/or people.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of this hazard.
    '''

@dataclass(repr=False)
class AssetLocationHazard(Hazard):
    '''
    Potential hazard related to the location of an asset. Examples are trees
    growing under overhead power lines, a park being located by a substation
    (i.e., children climb fence to recover a ball), a lake near an overhead
    distribution line (fishing pole/line contacting power lines), dangerous
    neighbour, etc.
    '''

    Locations: list[Location] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Location.Hazards',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The location of this hazard.
    '''

@dataclass(repr=False)
class Limit(IdentifiedObject):
    '''
    Specifies one limit value for a Measurement. A Measurement typically has
    several limits that are kept together by the LimitSet class. The actual
    meaning and use of a Limit instance (i.e., if it is an alarm or warning
    limit or if it is a high or low limit) is not captured in the Limit class.
    However the name of a Limit instance may indicate both meaning and use.
    '''

    Procedures: list[Procedure] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Procedure.Limits',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class AccumulatorLimit(Limit):
    '''
    Limit values for Accumulator measurements.
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The value to supervise against. The value is positive.
    '''

    LimitSet: Optional[AccumulatorLimitSet] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AccumulatorLimitSet.Limits',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The set of limits.
    '''

@dataclass(repr=False)
class AnalogLimit(Limit):
    '''
    Limit values for Analog measurements.
    '''

    value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The value to supervise against.
    '''

    LimitSet: Optional[AnalogLimitSet] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AnalogLimitSet.Limits',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The set of limits.
    '''

@dataclass(repr=False)
class LimitDependency(IdentifiedObject):
    '''
    A limit calculation model used to compute an operational limit based on
    external input such as temperature. These are intended to be shared among
    operational limits with the same calculation form that apply to a piece
    of equipment..
    '''

    Equipment: Optional[Equipment] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Equipment.LimitDependencyModel',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The equipment for which this limit dependency model is organized under.
    '''

    OperationalLimit: list[OperationalLimit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperationalLimit.LimitDependencyModel',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The operational limits to which this limit dependency model applies.
    '''

@dataclass(repr=False)
class LimitScalingLimit(LimitDependency):
    '''
    Specifies an operational limit is calculated by scaling another operational
    limit.
    '''

@dataclass(repr=False)
class SeriesEquipmentDependentLimit(LimitDependency):
    '''
    Limit based on most restrictive series equipment limit.
    A specification of of equipment that determines the calculated operational
    limit values based upon other equipment and their ratings. The most restrictive
    limit connected in series within the group is used. The physical connection
    based on switch status for example may also impact which elements in the
    group are considered. Any equipment in the group that are presently connected
    in series with the equipment of the directly associated operational limit
    are used. This provides a means to indicate which potentially series equipment
    limits are considered for a computed operational limit. The operational
    limit of the same operational limit type is assumed to be used from the
    grouped equipment. It is also possible to make assumptions or calculations
    regarding how flow might split if the equipment is not simply in series.
    '''

    EquipmentLimitSeriesComponent: list[EquipmentLimitSeriesComponent] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EquipmentLimitSeriesComponent.SeriesEquipmentDependentLimit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Equipment linkages that participates in the limit calculation.
    '''

@dataclass(repr=False)
class LimitSet(IdentifiedObject):
    '''
    Specifies a set of Limits that are associated with a Measurement. A Measurement
    may have several LimitSets corresponding to seasonal or other changing
    conditions. The condition is captured in the name and description attributes.
    The same LimitSet may be used for several Measurements. In particular percentage
    limits are used this way.
    '''

    isPercentageLimits: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Tells if the limit values are in percentage of normalValue or the specified
    Unit for Measurements and Controls.
    '''

@dataclass(repr=False)
class AccumulatorLimitSet(LimitSet):
    '''
    An AccumulatorLimitSet specifies a set of Limits that are associated with
    an Accumulator measurement.
    '''

    Limits: list[AccumulatorLimit] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AccumulatorLimit.LimitSet',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The limit values used for supervision of Measurements.
    '''

    Measurements: list[Accumulator] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Accumulator.LimitSets',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Measurements using the LimitSet.
    '''

@dataclass(repr=False)
class AnalogLimitSet(LimitSet):
    '''
    An AnalogLimitSet specifies a set of Limits that are associated with an
    Analog measurement.
    '''

    Limits: list[AnalogLimit] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AnalogLimit.LimitSet',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The limit values used for supervision of Measurements.
    '''

    Measurements: list[Analog] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Analog.LimitSets',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Measurements using the LimitSet.
    '''

@dataclass(repr=False)
class LoadDynamics(IdentifiedObject):
    '''
    Load whose behaviour is described by reference to a standard model <font
    color="#0f0f0f">or by definition of a user-defined model.</font>
    A standard feature of dynamic load behaviour modelling is the ability to
    associate the same behaviour to multiple energy consumers by means of a
    single load definition. The load model is always applied to individual
    bus loads (energy consumers).
    '''

    EnergyConsumer: list[EnergyConsumer] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnergyConsumer.LoadDynamics',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Energy consumer to which this dynamics load model applies.
    '''

@dataclass(repr=False)
class LoadGroup(IdentifiedObject):
    '''
    The class is the third level in a hierarchical structure for grouping of
    loads for the purpose of load flow load scaling.
    '''

    SubLoadArea: Optional[SubLoadArea] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SubLoadArea.LoadGroups',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The SubLoadArea where the Loadgroup belongs.
    '''

@dataclass(repr=False)
class ConformLoadGroup(LoadGroup):
    '''
    A group of loads conforming to an allocation pattern.
    '''

    ConformLoadSchedules: list[ConformLoadSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConformLoadSchedule.ConformLoadGroup',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The ConformLoadSchedules in the ConformLoadGroup.
    '''

    EnergyConsumers: list[ConformLoad] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConformLoad.LoadGroup',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''

@dataclass(repr=False)
class NonConformLoadGroup(LoadGroup):
    '''
    Loads that do not follow a daily and seasonal load variation pattern.
    '''

    EnergyConsumers: list[NonConformLoad] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NonConformLoad.LoadGroup',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''

    NonConformLoadSchedules: list[NonConformLoadSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NonConformLoadSchedule.NonConformLoadGroup',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The NonConformLoadSchedules in the NonConformLoadGroup.
    '''

@dataclass(repr=False)
class LoadResponseCharacteristic(IdentifiedObject):
    '''
    Models the characteristic response of the load demand due to changes in
    system conditions such as voltage and frequency. This is not related to
    demand response.
    If LoadResponseCharacteristic.exponentModel is True, the voltage exponents
    are specified and used as to calculate:
    Active power component = Pnominal * (Voltage/cim:BaseVoltage.nominalVoltage)
    ** cim:LoadResponseCharacteristic.pVoltageExponent
    Reactive power component = Qnominal * (Voltage/cim:BaseVoltage.nominalVoltage)**
    cim:LoadResponseCharacteristic.qVoltageExponent
    Where * means "multiply" and ** is "raised to power of".
    '''

    exponentModel: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates the exponential voltage dependency model is to be used. If false,
    the coefficient model is to be used.
    The exponential voltage dependency model consist of the attributes
    - pVoltageExponent
    - qVoltageExponent.
    The coefficient model consist of the attributes
    - pConstantImpedance
    - pConstantCurrent
    - pConstantPower
    - qConstantImpedance
    - qConstantCurrent
    - qConstantPower.
    The sum of pConstantImpedance, pConstantCurrent and pConstantPower shall
    equal 1.
    The sum of qConstantImpedance, qConstantCurrent and qConstantPower shall
    equal 1.
    '''

    pConstantCurrent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Portion of active power load modeled as constant current.
    '''

    pConstantImpedance: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Portion of active power load modeled as constant impedance.
    '''

    pConstantPower: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Portion of active power load modeled as constant power.
    '''

    pFrequencyExponent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Exponent of per unit frequency effecting active power.
    '''

    pVoltageExponent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Exponent of per unit voltage effecting real power.
    '''

    qConstantCurrent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Portion of reactive power load modeled as constant current.
    '''

    qConstantImpedance: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Portion of reactive power load modeled as constant impedance.
    '''

    qConstantPower: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Portion of reactive power load modeled as constant power.
    '''

    qFrequencyExponent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Exponent of per unit frequency effecting reactive power.
    '''

    qVoltageExponent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Exponent of per unit voltage effecting reactive power.
    '''

    EnergyConsumer: list[EnergyConsumer] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnergyConsumer.LoadResponse',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The set of loads that have the response characteristics.
    '''

@dataclass(repr=False)
class Location(IdentifiedObject):
    '''
    The place, scene, or point of something where someone or something has
    been, is, and/or will be at a given moment in time. It can be defined with
    one or more postition points (coordinates) in a given coordinate system.
    '''

    direction: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if applicable) Direction that allows field crews to quickly find a given
    asset. For a given location, such as a street address, this is the relative
    direction in which to find the asset. For example, a streetlight may be
    located at the 'NW' (northwest) corner of the customer's site, or a usage
    point may be located on the second floor of an apartment building.
    '''

    geoInfoReference: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if applicable) Reference to geographical information source, often external
    to the utility.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Classification by utility's corporate standards and practices, relative
    to the location itself (e.g., geographical, functional accounting, etc.,
    not a given property that happens to exist at that location).
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.Location',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All assets at this location.
    '''

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConfigurationEvent.ChangedLocation',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All configuration events created for this location.
    '''

    CoordinateSystem: Optional[CoordinateSystem] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CoordinateSystem.Locations',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Coordinate system used to describe position points of this location.
    '''

    Hazards: list[AssetLocationHazard] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AssetLocationHazard.Locations',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All asset hazards at this location.
    '''

    Measurements: list[Measurement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Measurement.Locations',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    PositionPoints: list[PositionPoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PositionPoint.Location',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Sequence of position points describing this location, expressed in coordinate
    system 'Location.CoordinateSystem'.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerSystemResource.Location',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All power system resources at this location.
    '''

@dataclass(repr=False)
class Measurement(IdentifiedObject):
    '''
    A Measurement represents any measured, calculated or non-measured non-calculated
    quantity. Any piece of equipment may contain Measurements, e.g. a substation
    may have temperature measurements and door open indications, a transformer
    may have oil temperature and tank pressure measurements, a bay may contain
    a number of power flow measurements and a Breaker may contain a switch
    status measurement.
    The PSR - Measurement association is intended to capture this use of Measurement
    and is included in the naming hierarchy based on EquipmentContainer. The
    naming hierarchy typically has Measurements as leafs, e.g. Substation-VoltageLevel-Bay-Switch-Measurement.
    Some Measurements represent quantities related to a particular sensor location
    in the network, e.g. a voltage transformer (PT) at a busbar or a current
    transformer (CT) at the bar between a breaker and an isolator. The sensing
    position is not captured in the PSR - Measurement association. Instead
    it is captured by the Measurement - Terminal association that is used to
    define the sensing location in the network topology. The location is defined
    by the connection of the Terminal to ConductingEquipment.
    If both a Terminal and PSR are associated, and the PSR is of type ConductingEquipment,
    the associated Terminal should belong to that ConductingEquipment instance.
    When the sensor location is needed both Measurement-PSR and Measurement-Terminal
    are used. The Measurement-Terminal association is never used alone.
    '''

    measurementType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Specifies the type of measurement. For example, this specifies if the measurement
    represents an indoor temperature, outdoor temperature, bus voltage, line
    flow, etc.
    '''

    phases: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates to which phases the measurement applies and avoids the need to
    use 'measurementType' to also encode phase information (which would explode
    the types). The phase information in Measurement, along with 'measurementType'
    and 'phases' uniquely defines a Measurement for a device, based on normal
    network phase. Their meaning will not change when the computed energizing
    phasing is changed due to jumpers or other reasons.
    If the attribute is missing three phases (ABC) shall be assumed.
    '''

    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit multiplier of the measured quantity.
    '''

    unitSymbol: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit of measure of the measured quantity.
    '''

    Asset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.Measurements',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    Locations: list[Location] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Location.Measurements',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    MeasurementCalculatorInput: list[MeasurementCalculatorInput] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeasurementCalculatorInput.Measurement',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerSystemResource.Measurements',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The power system resource that contains the measurement.
    '''

    ProtectiveActionAdjustment: list[ProtectiveActionAdjustment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProtectiveActionAdjustment.Measurement',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    Terminal: Optional[ACDCTerminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACDCTerminal.Measurements',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    One or more measurements may be associated with a terminal in the network.
    '''

@dataclass(repr=False)
class Accumulator(Measurement):
    '''
    Accumulator represents an accumulated (counted) Measurement, e.g. an energy
    value.
    '''

    maxValue: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values. Used
    for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    AccumulatorValues: list[AccumulatorValue] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AccumulatorValue.Accumulator',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The values connected to this measurement.
    '''

    LimitSets: list[AccumulatorLimitSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AccumulatorLimitSet.Measurements',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A measurement may have zero or more limit ranges defined for it.
    '''

@dataclass(repr=False)
class Analog(Measurement):
    '''
    Analog represents an analog Measurement.
    '''

    maxValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values. Used
    for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    minValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal value range minimum for any of the MeasurementValue.values. Used
    for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    normalValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''

    positiveFlowIn: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true then this measurement is an active power, reactive power or current
    with the convention that a positive value measured at the Terminal means
    power is flowing into the related PowerSystemResource.
    '''

    AnalogValues: list[AnalogValue] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AnalogValue.Analog',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The values connected to this measurement.
    '''

    LimitSets: list[AnalogLimitSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AnalogLimitSet.Measurements',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A measurement may have zero or more limit ranges defined for it.
    '''

@dataclass(repr=False)
class Discrete(Measurement):
    '''
    Discrete represents a discrete Measurement, i.e. a Measurement representing
    discrete values, e.g. a Breaker position.
    '''

    maxValue: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values. Used
    for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    minValue: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal value range minimum for any of the MeasurementValue.values. Used
    for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    normalValue: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''

    DiscreteValues: list[DiscreteValue] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DiscreteValue.Discrete',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The values connected to this measurement.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ValueAliasSet.Discretes',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The ValueAliasSet used for translation of a MeasurementValue.value to a
    name.
    '''

@dataclass(repr=False)
class StringMeasurement(Measurement):
    '''
    StringMeasurement represents a measurement with values of type string.
    '''

    StringMeasurementValues: list[StringMeasurementValue] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'StringMeasurementValue.StringMeasurement',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The values connected to this measurement.
    '''

@dataclass(repr=False)
class MeasurementCalculator(IdentifiedObject):
    '''
    Result of a calculation of one or more measurement.
    '''

@dataclass(repr=False)
class MeasurementCalculatorInput(IdentifiedObject):
    '''
    Input to measurement calculation. Support Analog, Discrete and Accumulator.
    '''

    absoluteValue: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true, use the absolute value for the calculation.
    '''

    order: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive number that defines the order of the operant in the calculation.
    0 = default. The order is not relevant (e.g. summation).
    '''

    Measurement: Optional[Measurement] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Measurement.MeasurementCalculatorInput',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    MeasurementCalculator: Optional[MeasurementCalculator] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'MeasurementCalculator.MeasurementCalculatorInput',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class MeasurementValue(IdentifiedObject):
    '''
    The current state for a measurement. A state value is an instance of a
    measurement from a specific source. Measurements can be associated with
    many state values, each representing a different source for the measurement.
    '''

    timeStamp: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The time when the value was last updated
    '''

    sensorAccuracy: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The limit, expressed as a percentage of the sensor maximum, that errors
    will not exceed when the sensor is used under reference conditions.
    '''

    MeasurementValueQuality: Optional[MeasurementValueQuality] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'MeasurementValueQuality.MeasurementValue',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''

    MeasurementValueSource: Optional[MeasurementValueSource] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'MeasurementValueSource.MeasurementValues',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A reference to the type of source that updates the MeasurementValue, e.g.
    SCADA, CCLink, manual, etc. User conventions for the names of sources are
    contained in the introduction to IEC 61970-301.
    '''

    RemoteSource: Optional[RemoteSource] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RemoteSource.MeasurementValue',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Link to the physical telemetered point associated with this measurement.
    '''

@dataclass(repr=False)
class AccumulatorValue(MeasurementValue):
    '''
    AccumulatorValue represents an accumulated (counted) MeasurementValue.
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The value to supervise. The value is positive.
    '''

    Accumulator: Optional[Accumulator] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Accumulator.AccumulatorValues',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Measurement to which this value is connected.
    '''

    AccumulatorReset: Optional[AccumulatorReset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AccumulatorReset.AccumulatorValue',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The command that reset the accumulator value.
    '''

@dataclass(repr=False)
class AnalogValue(MeasurementValue):
    '''
    AnalogValue represents an analog MeasurementValue.
    '''

    value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The value to supervise.
    '''

    AltGeneratingUnit: list[AltGeneratingUnitMeas] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AltGeneratingUnitMeas.AnalogValue',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The alternate generating unit for which this measurement value applies.
    '''

    AltTieMeas: list[AltTieMeas] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AltTieMeas.AnalogValue',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The usage of the measurement within the control area specification.
    '''

    Analog: Optional[Analog] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Analog.AnalogValues',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Measurement to which this value is connected.
    '''

    AnalogControl: Optional[AnalogControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AnalogControl.AnalogValue',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''

@dataclass(repr=False)
class DiscreteValue(MeasurementValue):
    '''
    DiscreteValue represents a discrete MeasurementValue.
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The value to supervise.
    '''

    Command: Optional[Command] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Command.DiscreteValue',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''

    Discrete: Optional[Discrete] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Discrete.DiscreteValues',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Measurement to which this value is connected.
    '''

@dataclass(repr=False)
class StringMeasurementValue(MeasurementValue):
    '''
    StringMeasurementValue represents a measurement value of type string.
    '''

    value: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The value to supervise.
    '''

    StringMeasurement: Optional[StringMeasurement] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StringMeasurement.StringMeasurementValues',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Measurement to which this value is connected.
    '''

@dataclass(repr=False)
class MeasurementValueSource(IdentifiedObject):
    '''
    MeasurementValueSource describes the alternative sources updating a MeasurementValue.
    User conventions for how to use the MeasurementValueSource attributes are
    described in the introduction to IEC 61970-301.
    '''

    MeasurementValues: list[MeasurementValue] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeasurementValue.MeasurementValueSource',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The MeasurementValues updated by the source.
    '''

@dataclass(repr=False)
class MutualCoupling(IdentifiedObject):
    '''
    This class represents the zero sequence line mutual coupling.
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence mutual coupling shunt (charging) susceptance, uniformly distributed,
    of the entire line section.
    '''

    distance11: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Distance to the start of the coupled region from the first line's terminal
    having sequence number equal to 1.
    '''

    distance12: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Distance to the end of the coupled region from the first line's terminal
    with sequence number equal to 1.
    '''

    distance21: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Distance to the start of coupled region from the second line's terminal
    with sequence number equal to 1.
    '''

    distance22: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Distance to the end of coupled region from the second line's terminal with
    sequence number equal to 1.
    '''

    g0ch: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence mutual coupling shunt (charging) conductance, uniformly distributed,
    of the entire line section.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, resistance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, reactance.
    '''

    First_Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.HasFirstMutualCoupling',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The starting terminal for the calculation of distances along the first
    branch of the mutual coupling. Normally MutualCoupling would only be used
    for terminals of AC line segments. The first and second terminals of a
    mutual coupling should point to different AC line segments.
    '''

    Second_Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.HasSecondMutualCoupling',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The starting terminal for the calculation of distances along the second
    branch of the mutual coupling.
    '''

@dataclass(repr=False)
class OperatingParticipant(IdentifiedObject):
    '''
    An operator of multiple power system resource objects. Note multple operating
    participants may operate the same power system resource object. This can
    be used for modeling jointly owned units where each owner operates as a
    contractual share.
    '''

    OperatingShare: list[OperatingShare] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperatingShare.OperatingParticipant',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The operating shares of this operating participant. An operating participant
    can be resused for any number of power system resources.
    '''

@dataclass(repr=False)
class OperationalLimit(IdentifiedObject):
    '''
    A value associated with a specific kind of limit.
    The sub class value attribute shall be positive.
    The sub class value attribute is inversely proportional to OperationalLimitType.acceptableDuration
    (acceptableDuration for short). A pair of value_x and acceptableDuration_x
    are related to each other as follows:
    if value_1 &gt; value_2 &gt; value_3 &gt;... then
    acceptableDuration_1 &lt; acceptableDuration_2 &lt; acceptableDuration_3
    &lt; ...
    A value_x with direction="high" shall be greater than a value_y with direction="low".
    '''

    LimitDependencyModel: list[LimitDependency] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'LimitDependency.OperationalLimit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The limit dependency models which are used to calculate this limit. If
    no limit dependencies are specified then the native limit value is used.
    '''

    LimitScalingLimit: list[LimitScalingLimit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'LimitScalingLimit.SourceOperationalLimit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    OperationalLimitSet: Optional[OperationalLimitSet] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OperationalLimitSet.OperationalLimitValue',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The limit set to which the limit values belong.
    '''

    OperationalLimitType: Optional[OperationalLimitType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OperationalLimitType.OperationalLimit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The limit type associated with this limit.
    '''

@dataclass(repr=False)
class ActivePowerLimit(OperationalLimit):
    '''
    Limit on active power flow.
    '''

    value: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Value of active power limit.
    '''

@dataclass(repr=False)
class ApparentPowerLimit(OperationalLimit):
    '''
    Apparent power limit.
    '''

    value: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The apparent power limit.
    '''

@dataclass(repr=False)
class CurrentLimit(OperationalLimit):
    '''
    Operational limit on current.
    '''

    value: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Limit on current flow.
    '''

@dataclass(repr=False)
class VoltageLimit(OperationalLimit):
    '''
    Operational limit applied to voltage.
    '''

    value: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Limit on voltage. High or low limit nature of the limit depends upon the
    properties of the operational limit type.
    '''

@dataclass(repr=False)
class OperationalLimitSet(IdentifiedObject):
    '''
    A set of limits associated with equipment. Sets of limits might apply to
    a specific temperature, or season for example. A set of limits may contain
    different severities of limit levels that would apply to the same equipment.
    The set may contain limits of different types such as apparent power and
    current limits or high and low voltage limits that are logically applied
    together as a set.
    '''

    Equipment: Optional[Equipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Equipment.OperationalLimitSet',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The equipment to which the limit set applies.
    '''

    OperationalLimitValue: list[OperationalLimit] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperationalLimit.OperationalLimitSet',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Values of equipment limits.
    '''

    Terminal: Optional[ACDCTerminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACDCTerminal.OperationalLimitSet',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The terminal where the operational limit set apply.
    '''

@dataclass(repr=False)
class OperationalLimitType(IdentifiedObject):
    '''
    The operational meaning of a category of limits.
    '''

    acceptableDuration: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The nominal acceptable duration of the limit. Limits are commonly expressed
    in terms of the a time limit for which the limit is normally acceptable.
    The actual acceptable duration of a specific limit may depend on other
    local factors such as temperature or wind speed.
    '''

    direction: Optional[ OperationalLimitDirectionKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The direction of the limit.
    '''

    OperationalLimit: list[OperationalLimit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperationalLimit.OperationalLimitType',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The operational limits associated with this type of limit.
    '''

    SourceOperationalLimitTypeScaling: list[OperatonalLimitTypeScaling] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperatonalLimitTypeScaling.SourceOperationalLimitType',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    TargetOperationalLimitmTypeScaling: Optional[OperatonalLimitTypeScaling] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OperatonalLimitTypeScaling.TargetOperationalLimit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class Organisation(IdentifiedObject):
    '''
    Organisation that might have roles as utility, contractor, supplier, manufacturer,
    customer, etc.
    '''

@dataclass(repr=False)
class OrganisationRole(IdentifiedObject):
    '''
    Identifies a way in which an organisation may participate in the utility
    enterprise (e.g., customer, manufacturer, etc).
    '''

    Organisation: Optional[Organisation] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Organisation.Roles',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Organisation having this role.
    '''

@dataclass(repr=False)
class AssetOrganisationRole(OrganisationRole):
    '''
    Role an organisation plays with respect to asset.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.OrganisationRoles',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All assets for this organisation role.
    '''

@dataclass(repr=False)
class AssetOwner(AssetOrganisationRole):
    '''
    Owner of the asset.
    '''

    Ownerships: list[Ownership] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Ownership.AssetOwner',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All ownerships of this owner.
    '''

@dataclass(repr=False)
class AssetUser(AssetOrganisationRole):
    '''
    Organisation that is a user of the asset.
    '''

@dataclass(repr=False)
class Maintainer(AssetOrganisationRole):
    '''
    Organisation that maintains assets.
    '''

@dataclass(repr=False)
class Manufacturer(OrganisationRole):
    '''
    Organisation that manufactures asset products.
    '''

    ProductAssetModels: list[ProductAssetModel] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProductAssetModel.Manufacturer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All asset models by this manufacturer.
    '''

@dataclass(repr=False)
class Ownership(IdentifiedObject):
    '''
    Ownership of e.g. asset.
    '''

    share: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Share of this ownership.
    '''

    Asset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.Ownerships',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Asset that is object of this ownership.
    '''

    AssetOwner: Optional[AssetOwner] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetOwner.Ownerships',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Asset owner that is subject in this ownership.
    '''

@dataclass(repr=False)
class PSRType(IdentifiedObject):
    '''
    Classifying instances of the same class, e.g. overhead and underground
    ACLineSegments. This classification mechanism is intended to provide flexibility
    outside the scope of this standard, i.e. provide customisation that is
    non standard.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerSystemResource.PSRType',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Power system resources classified with this power system resource type.
    '''

@dataclass(repr=False)
class PerLengthLineParameter(IdentifiedObject):
    '''
    Common type for per-length electrical catalogues describing line parameters.
    '''

    WireInfos: list[WireInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WireInfo.PerLengthParameters',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All wire datasheets used to calculate this per-length parameter.
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WireSpacingInfo.PerLengthParameters',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Wire spacing datasheet used to calculate this per-length parameter.
    '''

@dataclass(repr=False)
class PerLengthDCLineParameter(PerLengthLineParameter):
    '''
    '''

    capacitance: Optional[ float | CapacitancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Capacitance per unit of length of the DC line segment; significant for
    cables only.
    '''

    inductance: Optional[ float | InductancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Inductance per unit of length of the DC line segment.
    '''

    resistance: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Resistance per length of the DC line segment.
    '''

    DCLineSegments: list[DCLineSegment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DCLineSegment.PerLengthParameter',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All line segments described by this set of per-length parameters.
    '''

@dataclass(repr=False)
class PerLengthImpedance(PerLengthLineParameter):
    '''
    Common type for per-length impedance electrical catalogues.
    '''

    ACLineSegments: list[ACLineSegment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ACLineSegment.PerLengthImpedance',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All line segments described by this per-length impedance.
    '''

@dataclass(repr=False)
class PerLengthPhaseImpedance(PerLengthImpedance):
    '''
    Impedance and admittance parameters per unit length for n-wire unbalanced
    lines, in matrix form.
    '''

    conductorCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Number of phase, neutral, and other wires retained. Constrains the number
    of matrix elements and the phase codes that can be used with this matrix.
    '''

    PhaseImpedanceData: list[PhaseImpedanceData] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PhaseImpedanceData.PhaseImpedance',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All data that belong to this conductor phase impedance.
    '''

@dataclass(repr=False)
class PerLengthSequenceImpedance(PerLengthImpedance):
    '''
    Sequence impedance and admittance parameters per unit length, for transposed
    lines of 1, 2, or 3 phases. For 1-phase lines, define x=x0=xself. For 2-phase
    lines, define x=xs-xm and x0=xs+xm.
    '''

    b0ch: Optional[ float | SusceptancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence shunt (charging) susceptance, per unit of length.
    '''

    bch: Optional[ float | SusceptancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt (charging) susceptance, per unit of length.
    '''

    g0ch: Optional[ float | ConductancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence shunt (charging) conductance, per unit of length.
    '''

    gch: Optional[ float | ConductancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt (charging) conductance, per unit of length.
    '''

    r: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series resistance, per unit of length.
    '''

    r0: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series resistance, per unit of length.
    '''

    x: Optional[ float | ReactancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series reactance, per unit of length.
    '''

    x0: Optional[ float | ReactancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series reactance, per unit of length.
    '''

@dataclass(repr=False)
class Person(IdentifiedObject):
    '''
    General purpose information for name and other information to contact people.
    '''

    firstName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Person's first name.
    '''

    lastName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Person's last (family, sir) name.
    '''

    mName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Middle name(s) or initial(s).
    '''

    prefix: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A prefix or title for the person's name, such as Miss, Mister, Doctor,
    etc.
    '''

    specialNeed: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Special service needs for the person (contact) are described; examples
    include life support, etc.
    '''

    suffix: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A suffix for the person's name, such as II, III, etc.
    '''

    Roles: list[PersonRole] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PersonRole.Person',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All roles of this person.
    '''

@dataclass(repr=False)
class PersonRole(IdentifiedObject):
    '''
    '''

    Person: Optional[Person] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Person.Roles',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Person having this role.
    '''

@dataclass(repr=False)
class OperationPersonRole(PersonRole):
    '''
    Person role in the context of utility operations.
    '''

@dataclass(repr=False)
class CrewMember(OperationPersonRole):
    '''
    Member of a crew.
    '''

    Crew: Optional[Crew] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Crew.CrewMembers',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Crew to which this crew member belongs.
    '''

@dataclass(repr=False)
class Operator(OperationPersonRole):
    '''
    Control room operator.
    '''

    SwitchingSteps: list[SwitchingStep] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SwitchingStep.Operator',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All switching steps this operator is responsible for.
    '''

@dataclass(repr=False)
class PhaseTapChangerTable(IdentifiedObject):
    '''
    Describes a tabular curve for how the phase angle difference and impedance
    varies with the tap step.
    '''

    PhaseTapChangerTablePoint: list[PhaseTapChangerTablePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PhaseTapChangerTablePoint.PhaseTapChangerTable',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The points of this table.
    '''

    PhaseTapChangerTabular: list[PhaseTapChangerTabular] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PhaseTapChangerTabular.PhaseTapChangerTable',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The phase tap changers to which this phase tap table applies.
    '''

@dataclass(repr=False)
class PowerSystemResource(IdentifiedObject):
    '''
    A power system resource can be an item of equipment such as a switch, an
    equipment container containing many individual items of equipment such
    as a substation, or an organisational entity such as sub-control area.
    Power system resources can have measurements associated.
    '''

    AssetDatasheet: Optional[AssetInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetInfo.PowerSystemResources',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Datasheet information for this power system resource.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.PowerSystemResources',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All assets represented by this power system resource. For example, multiple
    conductor assets are electrically modelled as a single AC line segment.
    '''

    Controls: list[Control] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Control.PowerSystemResource',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The controller outputs used to actually govern a regulating device, e.g.
    the magnetization of a synchronous machine or capacitor bank breaker actuator.
    '''

    Location: Optional[Location] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Location.PowerSystemResources',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Location of this power system resource.
    '''

    Measurements: list[Measurement] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Measurement.PowerSystemResource',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The measurements associated with this power system resource.
    '''

    PSRType: Optional[PSRType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PSRType.PowerSystemResources',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Custom classification for this power system resource.
    '''

    ReportingGroup: list[ReportingGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ReportingGroup.PowerSystemResource',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reporting groups to which this power system resource belongs.
    '''

@dataclass(repr=False)
class ACLineSegmentPhase(PowerSystemResource):
    '''
    Represents a single wire of an alternating current line segment.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The phase connection of the wire at both ends.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.ACLineSegmentPhases',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The line segment to which the phase belongs.
    '''

@dataclass(repr=False)
class AirCompressor(PowerSystemResource):
    '''
    Combustion turbine air compressor which is an integral part of a compressed
    air energy storage (CAES) plant.
    '''

    airCompressorRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rating of the CAES air compressor.
    '''

    CAESPlant: Optional[CAESPlant] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CAESPlant.AirCompressor',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    An air compressor may be a member of a compressed air energy storage plant.
    '''

    CombustionTurbine: Optional[CombustionTurbine] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CombustionTurbine.AirCompressor',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A CAES air compressor is driven by combustion turbine.
    '''

@dataclass(repr=False)
class CAESPlant(PowerSystemResource):
    '''
    Compressed air energy storage plant.
    '''

    energyStorageCapacity: Optional[ float | RealEnergy ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The rated energy storage capacity.
    '''

    ratedCapacityP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The CAES plant's gross rated generating capacity.
    '''

    AirCompressor: Optional[AirCompressor] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AirCompressor.CAESPlant',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    An air compressor may be a member of a compressed air energy storage plant.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.CAESPlant',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may be a member of a compressed air energy storage
    plant.
    '''

@dataclass(repr=False)
class CogenerationPlant(PowerSystemResource):
    '''
    A set of thermal generating units for the production of electrical energy
    and process steam (usually from the output of the steam turbines). The
    steam sendout is typically used for industrial purposes or for municipal
    heating and cooling.
    '''

    cogenHPSendoutRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The high pressure steam sendout.
    '''

    cogenHPSteamRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The high pressure steam rating.
    '''

    cogenLPSendoutRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The low pressure steam sendout.
    '''

    cogenLPSteamRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The low pressure steam rating.
    '''

    ratedP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The rated output active power of the cogeneration plant.
    '''

    SteamSendoutSchedule: Optional[SteamSendoutSchedule] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SteamSendoutSchedule.CogenerationPlant',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''

    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ThermalGeneratingUnit.CogenerationPlant',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may be a member of a cogeneration plant.
    '''

@dataclass(repr=False)
class CombinedCyclePlant(PowerSystemResource):
    '''
    A set of combustion turbines and steam turbines where the exhaust heat
    from the combustion turbines is recovered to make steam for the steam turbines,
    resulting in greater overall plant efficiency.
    '''

    combCyclePlantRating: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The combined cycle plant's active power output rating.
    '''

    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ThermalGeneratingUnit.CombinedCyclePlant',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may be a member of a combined cycle plant.
    '''

@dataclass(repr=False)
class CommunicationLink(PowerSystemResource):
    '''
    The connection to remote units is through one or more communication links.
    Reduntant links may exist. The CommunicationLink class inherit PowerSystemResource.
    The intention is to allow CommunicationLinks to have Measurements. These
    Measurements can be used to model link status as operational, out of service,
    unit failure etc.
    '''

    RemoteUnits: list[RemoteUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RemoteUnit.CommunicationLinks',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    RTUs may be attached to communication links.
    '''

@dataclass(repr=False)
class ConnectivityNodeContainer(PowerSystemResource):
    '''
    A base class for all objects that may contain connectivity nodes or topological
    nodes.
    '''

    ConnectivityNodes: list[ConnectivityNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConnectivityNode.ConnectivityNodeContainer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Connectivity nodes which belong to this connectivity node container.
    '''

    TopologicalNode: list[TopologicalNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TopologicalNode.ConnectivityNodeContainer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The topological nodes which belong to this connectivity node container.
    '''

@dataclass(repr=False)
class EquipmentContainer(ConnectivityNodeContainer):
    '''
    A modeling construct to provide a root class for containing equipment.
    '''

    Equipments: list[Equipment] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Equipment.EquipmentContainer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Contained equipment.
    '''

@dataclass(repr=False)
class Bay(EquipmentContainer):
    '''
    A collection of power system resources (within a given substation) including
    conducting equipment, protection relays, measurements, and telemetry. A
    bay typically represents a physical grouping related to modularization
    of equipment.
    '''

    bayEnergyMeasFlag: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates the presence/absence of energy measurements.
    '''

    bayPowerMeasFlag: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates the presence/absence of active/reactive power measurements.
    '''

    breakerConfiguration: Optional[ BreakerConfiguration ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Breaker configuration.
    '''

    busBarConfiguration: Optional[ BusbarConfiguration ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Bus bar configuration.
    '''

    Substation: Optional[Substation] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Substation.Bays',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Substation containing the bay.
    '''

    VoltageLevel: Optional[VoltageLevel] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'VoltageLevel.Bays',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The voltage level containing this bay.
    '''

@dataclass(repr=False)
class DCEquipmentContainer(EquipmentContainer):
    '''
    A modeling construct to provide a root class for containment of DC as well
    as AC equipment. The class differ from the EquipmentContaner for AC in
    that it may also contain DCNodes. Hence it can contain both AC and DC equipment.
    '''

    DCNodes: list[DCNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DCNode.DCEquipmentContainer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The DC nodes contained in the DC equipment container.
    '''

    DCTopologicalNode: list[DCTopologicalNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DCTopologicalNode.DCEquipmentContainer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The topological nodes which belong to this connectivity node container.
    '''

@dataclass(repr=False)
class DCConverterUnit(DCEquipmentContainer):
    '''
    Indivisible operative unit comprising all equipment between the point of
    common coupling on the AC side and the point of common coupling � DC side,
    essentially one or more converters, together with one or more converter
    transformers, converter control equipment, essential protective and switching
    devices and auxiliaries, if any, used for conversion.
    '''

    operationMode: Optional[ DCConverterOperatingModeKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    Substation: Optional[Substation] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Substation.DCConverterUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The containing substation of the DC converter unit.
    '''

@dataclass(repr=False)
class DCLine(DCEquipmentContainer):
    '''
    Overhead lines and/or cables connecting two or more HVDC substations.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SubGeographicalRegion.DCLines',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The SubGeographicalRegion containing the DC line.
    '''

@dataclass(repr=False)
class Line(EquipmentContainer):
    '''
    Contains equipment beyond a substation belonging to a power transmission
    line.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SubGeographicalRegion.Lines',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The sub-geographical region of the line.
    '''

@dataclass(repr=False)
class Plant(EquipmentContainer):
    '''
    A Plant is a collection of equipment for purposes of generation.
    '''

@dataclass(repr=False)
class Substation(EquipmentContainer):
    '''
    A collection of equipment for purposes other than generation or utilization,
    through which electric energy in bulk is passed for the purposes of switching
    or modifying its characteristics.
    '''

    Bays: list[Bay] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Bay.Substation',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Bays contained in the substation.
    '''

    DCConverterUnit: list[DCConverterUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DCConverterUnit.Substation',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The DC converter unit belonging of the substation.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SubGeographicalRegion.Substations',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The SubGeographicalRegion containing the substation.
    '''

    VoltageLevels: list[VoltageLevel] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'VoltageLevel.Substation',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The voltage levels within this substation.
    '''

@dataclass(repr=False)
class VoltageLevel(EquipmentContainer):
    '''
    A collection of equipment at one common system voltage forming a switchgear.
    The equipment typically consist of breakers, busbars, instrumentation,
    control, regulation and protection devices as well as assemblies of all
    these.
    '''

    highVoltageLimit: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The bus bar's high voltage limit
    '''

    lowVoltageLimit: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The bus bar's low voltage limit
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BaseVoltage.VoltageLevel',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The base voltage used for all equipment within the voltage level.
    '''

    Substation: Optional[Substation] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Substation.VoltageLevels',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The substation of the voltage level.
    '''

@dataclass(repr=False)
class EquivalentNetwork(ConnectivityNodeContainer):
    '''
    A class that represents an external meshed network that has been reduced
    to an electrically equivalent model. The ConnectivityNodes contained in
    the equivalent are intended to reflect internal nodes of the equivalent.
    The boundary Connectivity nodes where the equivalent connects outside itself
    are NOT contained by the equivalent.
    '''

    EquivalentEquipments: list[EquivalentEquipment] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EquivalentEquipment.EquivalentNetwork',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The associated reduced equivalents.
    '''

@dataclass(repr=False)
class ControlArea(PowerSystemResource):
    '''
    A control area<b> </b>is a grouping of generating units and/or loads and
    a cutset of tie lines (as terminals) which may be used for a variety of
    purposes including automatic generation control, powerflow solution area
    interchange control specification, and input to load forecasting. Note
    that any number of overlapping control area specifications can be superimposed
    on the physical model.
    '''

    netInterchange: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The specified positive net interchange into the control area, i.e. positive
    sign means flow in to the area.
    '''

    pTolerance: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power net interchange tolerance
    '''

    type: Optional[ ControlAreaTypeKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The primary type of control area definition used to determine if this is
    used for automatic generation control, for planning interchange control,
    or other purposes. A control area specified with primary type of automatic
    generation control could still be forecast and used as an interchange area
    in power flow analysis.
    '''

    EnergyArea: Optional[EnergyArea] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnergyArea.ControlArea',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The energy area that is forecast from this control area specification.
    '''

@dataclass(repr=False)
class EnergyConsumerPhase(PowerSystemResource):
    '''
    A single phase of an energy consumer.
    '''

    pfixed: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power of the load that is a fixed quantity. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    pfixedPct: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fixed active power as per cent of load group fixed active power. Load sign
    convention is used, i.e. positive sign means flow out from a node.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase of this energy consumer component. If the energy consumer is wye
    connected, the connection is from the indicated phase to the central ground
    or neutral point. If the energy consumer is delta connected, the phase
    indicates an energy consumer connected from the indicated phase to the
    next logical non-neutral phase.
    '''

    qfixed: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactive power of the load that is a fixed quantity. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    qfixedPct: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fixed reactive power as per cent of load group fixed reactive power. Load
    sign convention is used, i.e. positive sign means flow out from a node.
    '''

    EnergyConsumer: Optional[EnergyConsumer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnergyConsumer.EnergyConsumerPhase',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The energy consumer to which this phase belongs.
    '''

@dataclass(repr=False)
class Equipment(PowerSystemResource):
    '''
    The parts of a power system that are physical devices, electronic or mechanical.
    '''

    aggregate: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The single instance of equipment represents multiple pieces of equipment
    that have been modeled together as an aggregate. Examples would be power
    transformers or synchronous machines operating in parallel modeled as a
    single aggregate power transformer or aggregate synchronous machine. This
    is not to be used to indicate equipment that is part of a group of interdependent
    equipment produced by a network production program.
    '''

    normallyInService: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true, the equipment is normally in service.
    '''

    ContingencyEquipment: list[ContingencyEquipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ContingencyEquipment.Equipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The contingency equipments in which this equipment participates.
    '''

    EqiupmentLimitSeriesComponent: list[EquipmentLimitSeriesComponent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EquipmentLimitSeriesComponent.Equipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Equipment limit series calculation component to which this equipment contributes.
    '''

    EquipmentContainer: Optional[EquipmentContainer] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EquipmentContainer.Equipments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Container of this equipment.
    '''

    Faults: list[Fault] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Fault.FaultyEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All faults on this equipment.
    '''

    LimitDependencyModel: list[LimitDependency] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'LimitDependency.Equipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Limit dependencymodels organized under this equipment as a means for organizing
    the model in a tree view.
    '''

    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperationalLimitSet.Equipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The operational limit sets associated with this equipment.
    '''

    OperationalRestrictions: list[OperationalRestriction] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperationalRestriction.Equipments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All operational restrictions for this equipment.
    '''

    Outages: list[Outage] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Outage.Equipments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All outages in which this equipment is involved.
    '''

    ProtectiveActionEquipment: list[ProtectiveActionEquipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProtectiveActionEquipment.Equipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    UsagePoints: list[UsagePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UsagePoint.Equipments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All usage points connected to the electrical grid through this equipment.
    '''

    WeatherStation: list[WeatherStation] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WeatherStation.Equipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class AuxiliaryEquipment(Equipment):
    '''
    AuxiliaryEquipment describe equipment that is not performing any primary
    functions but support for the equipment performing the primary function.
    AuxiliaryEquipment is attached to primary eqipment via an association with
    Terminal.
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.AuxiliaryEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Terminal at the equipment where the AuxiliaryEquipment is attached.
    '''

@dataclass(repr=False)
class FaultIndicator(AuxiliaryEquipment):
    '''
    A FaultIndicator is typically only an indicator (which may or may not be
    remotely monitored), and not a piece of equipment that actually initiates
    a protection event. It is used for FLISR (Fault Location, Isolation and
    Restoration) purposes, assisting with the dispatch of crews to "most likely"
    part of the network (i.e. assists with determining circuit section where
    the fault most likely happened).
    '''

@dataclass(repr=False)
class Sensor(AuxiliaryEquipment):
    '''
    This class describe devices that transform a measured quantity into signals
    that can be presented at displays, used in control or be recorded.
    '''

@dataclass(repr=False)
class CurrentTransformer(Sensor):
    '''
    Instrument transformer used to measure electrical qualities of the circuit
    that is being protected and/or monitored. Typically used as current transducer
    for the purpose of metering or protection. A typical secondary current
    rating would be 5A.
    '''

    accuracyClass: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    CT accuracy classification.
    '''

    ctClass: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    CT classification; i.e. class 10P.
    '''

    usage: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Intended usage of the CT; i.e. metering, protection.
    '''

    accuracyLimit: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Percent of rated current for which the CT remains accurate within specified
    limits.
    '''

    coreBurden: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Power burden of the CT core.
    '''

@dataclass(repr=False)
class PostLineSensor(Sensor):
    '''
    A sensor used mainly in overhead distribution networks as the source of
    both current and voltage measurements.
    '''

@dataclass(repr=False)
class PotentialTransformer(Sensor):
    '''
    Instrument transformer (also known as Voltage Transformer) used to measure
    electrical qualities of the circuit that is being protected and/or monitored.
    Typically used as voltage transducer for the purpose of metering, protection,
    or sometimes auxiliary substation supply. A typical secondary voltage rating
    would be 120V.
    '''

    accuracyClass: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    PT accuracy classification.
    '''

    nominalRatio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Nominal ratio between the primary and secondary voltage.
    '''

    ptClass: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Potential transformer (PT) classification covering burden.
    '''

    type: Optional[ PotentialTransformerKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Potential transformer construction type.
    '''

@dataclass(repr=False)
class SurgeArrester(AuxiliaryEquipment):
    '''
    Shunt device, installed on the network, usually in the proximity of electrical
    equipment in order to protect the said equipment against transient voltage
    transients caused by lightning or switching activity.
    '''

@dataclass(repr=False)
class WaveTrap(AuxiliaryEquipment):
    '''
    Line traps are devices that impede high frequency power line carrier signals
    yet present a negligible impedance at the main power frequency.
    '''

@dataclass(repr=False)
class CompositeSwitch(Equipment):
    '''
    A model of a set of individual Switches normally enclosed within the same
    cabinet and possibly with interlocks that restrict the combination of switch
    positions. These are typically found in medium voltage distribution networks.
    A CompositeSwitch could represent a Ring-Main-Unit (RMU), or pad-mounted
    switchgear, with primitive internal devices such as an internal bus-bar
    plus 3 or 4 internal switches each of which may individually be open or
    closed. A CompositeSwitch and a set of contained Switches can also be used
    to represent a multi-position switch e.g. a switch that can connect a circuit
    to Ground, Open or Busbar.
    '''

    compositeSwitchType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    An alphanumeric code that can be used as a reference to extra information
    such as the description of the interlocking scheme if any.
    '''

    Switches: list[Switch] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Switch.CompositeSwitch',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Switches contained in this Composite switch.
    '''

@dataclass(repr=False)
class ConductingEquipment(Equipment):
    '''
    The parts of the AC power system that are designed to carry current or
    that are conductively connected through terminals.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BaseVoltage.ConductingEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Base voltage of this conducting equipment. Use only when there is no voltage
    level container used and only one base voltage applies. For example, not
    used for transformers.
    '''

    GroundingAction: Optional[GroundAction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GroundAction.GroundedEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Action involving grounding operation on this conducting equipment.
    '''

    JumpingAction: Optional[JumperAction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'JumperAction.JumpedEquipments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Jumper action involving jumping operation on this conducting equipment.
    '''

    ProtectionEquipments: list[ProtectionEquipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProtectionEquipment.ConductingEquipments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Protection equipment used to protect specific conducting equipment.
    '''

    ProtectiveActionAdjustment: list[ProtectiveActionAdjustment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProtectiveActionAdjustment.ConductingEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    SvStatus: Optional[SvStatus] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SvStatus.ConductingEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The status state variable associated with this conducting equipment.
    '''

    Terminals: list[Terminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Terminal.ConductingEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Conducting equipment have terminals that may be connected to other conducting
    equipment terminals via connectivity nodes or topological nodes.
    '''

@dataclass(repr=False)
class ACDCConverter(ConductingEquipment):
    '''
    A unit with valves for three phases, together with unit control equipment,
    essential protective and switching devices, DC storage capacitors, phase
    reactors and auxiliaries, if any, used for conversion.
    '''

    numberOfValves: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Number of valves in the converter. Used in loss calculations.
    '''

    baseS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Base apparent power of the converter pole.
    '''

    idc: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Converter DC current, also called Id. Converter state variable, result
    from power flow.
    '''

    idleLoss: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power loss in pole at no power transfer. Converter configuration
    data used in power flow.
    '''

    maxUdc: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum voltage on the DC side at which the converter should operate.
    Converter configuration data used in power flow.
    '''

    minUdc: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Min allowed converter DC voltage. Converter configuration data used in
    power flow.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power at the point of common coupling. Load sign convention is used,
    i.e. positive sign means flow out from a node.
    Starting value for a steady state solution in the case a simplified power
    flow model is used.
    '''

    poleLossP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The active power loss at a DC Pole
    = idleLoss + switchingLoss*|Idc| + resitiveLoss*Idc^2
    For lossless operation Pdc=Pac
    For rectifier operation with losses Pdc=Pac-lossP
    For inverter operation with losses Pdc=Pac+lossP
    Converter state variable used in power flow.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactive power at the point of common coupling. Load sign convention is
    used, i.e. positive sign means flow out from a node.
    Starting value for a steady state solution in the case a simplified power
    flow model is used.
    '''

    ratedUdc: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated converter DC voltage, also called UdN. Converter configuration data
    used in power flow.
    '''

    resistiveLoss: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Converter configuration data used in power flow. Refer to poleLossP.
    '''

    switchingLoss: Optional[ float | ActivePowerPerCurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Switching losses, relative to the base apparent power 'baseS'.
    Refer to poleLossP.
    '''

    targetPpcc: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Real power injection target in AC grid, at point of common coupling.
    '''

    targetUdc: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Target value for DC voltage magnitude.
    '''

    uc: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Line-to-line converter voltage, the voltage at the AC side of the valve.
    Converter state variable, result from power flow.
    '''

    udc: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Converter voltage at the DC side, also called Ud. Converter state variable,
    result from power flow.
    '''

    valveU0: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Valve threshold voltage, also called Uvalve. Forward voltage drop when
    the valve is conducting. Used in loss calculations, i.e. the switchLoss
    depends on numberOfValves * valveU0.
    '''

    DCTerminals: list[ACDCConverterDCTerminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ACDCConverterDCTerminal.DCConductingEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A DC converter have DC converter terminals. A converter has two DC converter
    terminals.
    '''

    PccTerminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.ConverterDCSides',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Point of common coupling terminal for this converter DC side. It is typically
    the terminal on the power transformer (or switch) closest to the AC network.
    The power flow measurement must be the sum of all flows into the transformer.
    '''

@dataclass(repr=False)
class CsConverter(ACDCConverter):
    '''
    DC side of the current source converter (CSC).
    '''

    alpha: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Firing angle, typical value between 10 and 18 degrees for a rectifier.
    CSC state variable, result from power flow.
    '''

    gamma: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Extinction angle. CSC state variable, result from power flow.
    '''

    maxAlpha: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum firing angle. CSC configuration data used in power flow.
    '''

    maxGamma: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum extinction angle. CSC configuration data used in power flow.
    '''

    maxIdc: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum direct current (Id) on the DC side at which the converter should
    operate. Converter configuration data use in power flow.
    '''

    minAlpha: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum firing angle. CSC configuration data used in power flow.
    '''

    minGamma: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum extinction angle. CSC configuration data used in power flow.
    '''

    minIdc: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum direct current (Id) on the DC side at which the converter should
    operate. CSC configuration data used in power flow.
    '''

    operatingMode: Optional[ CsOperatingModeKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates whether the DC pole is operating as an inverter or as a rectifier.
    CSC control variable used in power flow.
    '''

    pPccControl: Optional[ CsPpccControlKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of active power control.
    '''

    ratedIdc: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated converter DC current, also called IdN. Converter configuration data
    used in power flow.
    '''

    targetAlpha: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Target firing angle. CSC control variable used in power flow.
    '''

    targetGamma: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Target extinction angle. CSC control variable used in power flow.
    '''

    targetIdc: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    DC current target value. CSC control variable used in power flow.
    '''

    CSCDynamics: Optional[CSCDynamics] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CSCDynamics.CSConverter',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Current source converter dynamics model used to describe dynamic behavior
    of this converter.
    '''

@dataclass(repr=False)
class VsConverter(ACDCConverter):
    '''
    DC side of the voltage source converter (VSC).
    '''

    maxModulationIndex: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The max quotient between the AC converter voltage (Uc) and DC voltage (Ud).
    A factor typically less than 1. VSC configuration data used in power flow.
    '''

    delta: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Angle between uf and uc. Converter state variable used in power flow.
    '''

    droop: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Droop constant; pu value is obtained as D [kV/MW] x Sb / Ubdc.
    '''

    droopCompensation: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Compensation constant. Used to compensate for voltage drop when controlling
    voltage at a distant bus.
    '''

    maxValveCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum current through a valve. This current limit is the basis for
    calculating the capability diagram. VSC configuration data.
    '''

    pPccControl: Optional[ VsPpccControlKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of active power control.
    '''

    qPccControl: Optional[ VsQpccControlKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of reactive power control.
    '''

    qShare: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactive power sharing factor among parallel converters on Uac control.
    '''

    targetQpcc: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactive power injection target in AC grid, at point of common coupling.
    '''

    targetUpcc: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Voltage target in AC grid, at point of common coupling.
    '''

    uv: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Line-to-line voltage on the valve side of the converter transformer. Converter
    state variable, result from power flow.
    '''

    CapabilityCurve: Optional[VsCapabilityCurve] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'VsCapabilityCurve.VsConverterDCSides',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Capability curve of this converter.
    '''

    VSCDynamics: Optional[VSCDynamics] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'VSCDynamics.VsConverter',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Voltage source converter dynamics model used to describe dynamic behavior
    of this converter.
    '''

@dataclass(repr=False)
class Clamp(ConductingEquipment):
    '''
    A Clamp is a galvanic connection at a line segment where other equipment
    is connected. A Clamp does not cut the line segment.
    A Clamp is ConductingEquipment and has one Terminal with an associated
    ConnectivityNode. Any other ConductingEquipment can be connected to the
    Clamp ConnectivityNode.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The length to the place where the clamp is located starting from side one
    of the line segment, i.e. the line segment terminal with sequence number
    equal to 1.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.Clamp',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The line segment to which the clamp is connected.
    '''

@dataclass(repr=False)
class Conductor(ConductingEquipment):
    '''
    Combination of conducting material with consistent electrical characteristics,
    building a single electrical system, used to carry current between points
    in the power system.
    '''

    length: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Segment length for calculating line section capabilities
    '''

@dataclass(repr=False)
class ACLineSegment(Conductor):
    '''
    A wire or combination of wires, with consistent electrical characteristics,
    building a single electrical system, used to carry alternating current
    between points in the power system.
    For symmetrical, transposed 3ph lines, it is sufficient to use attributes
    of the line segment, which describe impedances and admittances for the
    entire length of the segment. Additionally impedances can be computed by
    using length and associated per length impedances.
    The BaseVoltage at the two ends of ACLineSegments in a Line shall have
    the same BaseVoltage.nominalVoltage. However, boundary lines may have slightly
    different BaseVoltage.nominalVoltages and variation is allowed. Larger
    voltage difference in general requires use of an equivalent branch.
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence shunt (charging) susceptance, uniformly distributed, of the
    entire line section.
    '''

    bch: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line section. This value represents the full charging over
    the full length of the line.
    '''

    g0ch: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence shunt (charging) conductance, uniformly distributed, of the
    entire line section.
    '''

    gch: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt (charging) conductance, uniformly distributed,
    of the entire line section.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series resistance of the entire line section.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series resistance of the entire line section.
    '''

    shortCircuitEndTemperature: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum permitted temperature at the end of SC for the calculation of minimum
    short-circuit currents. Used for short circuit data exchange according
    to IEC 60909
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series reactance of the entire line section.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series reactance of the entire line section.
    '''

    ACLineSegmentPhases: list[ACLineSegmentPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ACLineSegmentPhase.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The line segment phases which belong to the line segment.
    '''

    Clamp: list[Clamp] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Clamp.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The clamps connected to the line segment.
    '''

    Cut: list[Cut] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Cut.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Cuts applied to the line segment.
    '''

    LineFaults: list[LineFault] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'LineFault.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The line faults of the line segment.
    '''

    LineGroundingAction: Optional[GroundAction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GroundAction.AlongACLineSegment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Ground action involving clamp usage (for the case when the ground is applied
    along the line segment instead of at its terminals).
    '''

    LineJumpingAction: Optional[JumperAction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'JumperAction.AlongACLineSegments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Jumper action involving clamp usage (for the case when the jumper is applied
    along the line segment instead of at its terminals).
    '''

    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PerLengthImpedance.ACLineSegments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Per-length impedance of this line segment.
    '''

@dataclass(repr=False)
class Connector(ConductingEquipment):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation and are
    modelled with a single logical terminal.
    '''

@dataclass(repr=False)
class BusbarSection(Connector):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation.
    Voltage measurements are typically obtained from VoltageTransformers that
    are connected to busbar sections. A bus bar section may have many physical
    terminals but for analysis is modelled with exactly one logical terminal.
    '''

    ipMax: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum allowable peak short-circuit current of busbar (Ipmax in the IEC
    60909-0).
    Mechanical limit of the busbar in the substation itself. Used for short
    circuit data exchange according to IEC 60909
    '''

    VoltageControlZone: Optional[VoltageControlZone] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'VoltageControlZone.BusbarSection',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''

@dataclass(repr=False)
class Junction(Connector):
    '''
    A point where one or more conducting equipments are connected with zero
    resistance.
    '''

@dataclass(repr=False)
class EarthFaultCompensator(ConductingEquipment):
    '''
    A conducting equipment used to represent a connection to ground which is
    typically used to compensate earth faults.. An earth fault compensator
    device modeled with a single terminal implies a second terminal solidly
    connected to ground. If two terminals are modeled, the ground is not assumed
    and normal connection rules apply.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Nominal resistance of device.
    '''

@dataclass(repr=False)
class GroundingImpedance(EarthFaultCompensator):
    '''
    A fixed impedance device used for grounding.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactance of device.
    '''

@dataclass(repr=False)
class PetersenCoil(EarthFaultCompensator):
    '''
    A tunable impedance device normally used to offset line charging during
    single line faults in an ungrounded section of network.
    '''

    mode: Optional[ PetersenCoilModeKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The mode of operation of the Petersen coil.
    '''

    nominalU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The nominal voltage for which the coil is designed.
    '''

    offsetCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The offset current that the Petersen coil controller is operating from
    the resonant point. This is normally a fixed amount for which the controller
    is configured and could be positive or negative. Typically 0 to 60 Amperes
    depending on voltage and resonance conditions.
    '''

    positionCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The control current used to control the Petersen coil also known as the
    position current. Typically in the range of 20-200mA.
    '''

    xGroundMax: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum reactance.
    '''

    xGroundMin: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum reactance.
    '''

    xGroundNominal: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The nominal reactance. This is the operating point (normally over compensation)
    that is defined based on the resonance point in the healthy network condition.
    The impedance is calculated based on nominal voltage divided by position
    current.
    '''

@dataclass(repr=False)
class EnergyConsumer(ConductingEquipment):
    '''
    Generic user of energy - a point of consumption on the power system model.
    '''

    customerCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Number of individual customers represented by this demand.
    '''

    grounded: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Used for Yn and Zn connections. True if the neutral is solidly grounded.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    pfixed: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power of the load that is a fixed quantity. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    pfixedPct: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fixed active power as per cent of load group fixed active power. Load sign
    convention is used, i.e. positive sign means flow out from a node.
    '''

    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The type of phase connection, such as wye or delta.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    qfixed: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactive power of the load that is a fixed quantity. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    qfixedPct: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fixed reactive power as per cent of load group fixed reactive power. Load
    sign convention is used, i.e. positive sign means flow out from a node.
    '''

    EnergyConsumerPhase: list[EnergyConsumerPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnergyConsumerPhase.EnergyConsumer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The individual phase models for this energy consumer.
    '''

    LoadDynamics: Optional[LoadDynamics] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'LoadDynamics.EnergyConsumer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Load dynamics model used to describe dynamic behavior of this energy consumer.
    '''

    LoadResponse: Optional[LoadResponseCharacteristic] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'LoadResponseCharacteristic.EnergyConsumer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The load response characteristic of this load. If missing, this load is
    assumed to be constant power.
    '''

    PowerCutZone: Optional[PowerCutZone] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerCutZone.EnergyConsumers',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The energy consumer is assigned to this power cut zone.
    '''

@dataclass(repr=False)
class ConformLoad(EnergyConsumer):
    '''
    ConformLoad represent loads that follow a daily load change pattern where
    the pattern can be used to scale the load with a system load.
    '''

    LoadGroup: Optional[ConformLoadGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConformLoadGroup.EnergyConsumers',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Group of this ConformLoad.
    '''

@dataclass(repr=False)
class NonConformLoad(EnergyConsumer):
    '''
    NonConformLoad represent loads that do not follow a daily load change pattern
    and changes are not correlated with the daily load change pattern.
    '''

    LoadGroup: Optional[NonConformLoadGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NonConformLoadGroup.EnergyConsumers',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Group of this ConformLoad.
    '''

@dataclass(repr=False)
class StationSupply(EnergyConsumer):
    '''
    Station supply with load derived from the station output.
    '''

@dataclass(repr=False)
class EnergySource(ConductingEquipment):
    '''
    A generic equivalent for an energy supplier on a transmission or distribution
    voltage level.
    '''

    activePower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    High voltage source active injection. Load sign convention is used, i.e.
    positive sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase-to-phase nominal voltage.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence Thevenin resistance.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence Thevenin resistance.
    '''

    reactivePower: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    High voltage source reactive injection. Load sign convention is used, i.e.
    positive sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    rn: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence Thevenin resistance.
    '''

    voltageAngle: Optional[ float | AngleRadians ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase angle of a-phase open circuit.
    '''

    voltageMagnitude: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase-to-phase open circuit voltage magnitude.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence Thevenin reactance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence Thevenin reactance.
    '''

    xn: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence Thevenin reactance.
    '''

    EnergySchedulingType: Optional[EnergySchedulingType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnergySchedulingType.EnergySource',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Energy Scheduling Type of an Energy Source
    '''

    EnergySourceAction: Optional[EnergySourceAction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnergySourceAction.EnergySource',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Action taken with this energy source.
    '''

@dataclass(repr=False)
class EquivalentEquipment(ConductingEquipment):
    '''
    The class represents equivalent objects that are the result of a network
    reduction. The class is the base for equivalent objects of different types.
    '''

    EquivalentNetwork: Optional[EquivalentNetwork] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EquivalentNetwork.EquivalentEquipments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The equivalent where the reduced model belongs.
    '''

@dataclass(repr=False)
class EquivalentBranch(EquivalentEquipment):
    '''
    The class represents equivalent branches.
    '''

    negativeR12: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence series resistance from terminal sequence 1 to terminal
    sequence 2. Used for short circuit data exchange according to IEC 60909
    EquivalentBranch is a result of network reduction prior to the data exchange
    '''

    negativeR21: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence series resistance from terminal sequence 2 to terminal
    sequence 1. Used for short circuit data exchange according to IEC 60909
    EquivalentBranch is a result of network reduction prior to the data exchange
    '''

    negativeX12: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence series reactance from terminal sequence 1 to terminal
    sequence 2. Used for short circuit data exchange according to IEC 60909
    Usage : EquivalentBranch is a result of network reduction prior to the
    data exchange
    '''

    negativeX21: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence series reactance from terminal sequence 2 to terminal
    sequence 1. Used for short circuit data exchange according to IEC 60909.
    Usage: EquivalentBranch is a result of network reduction prior to the data
    exchange
    '''

    positiveR12: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series resistance from terminal sequence 1 to terminal
    sequence 2 . Used for short circuit data exchange according to IEC 60909.
    EquivalentBranch is a result of network reduction prior to the data exchange.
    '''

    positiveR21: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series resistance from terminal sequence 2 to terminal
    sequence 1. Used for short circuit data exchange according to IEC 60909
    EquivalentBranch is a result of network reduction prior to the data exchange
    '''

    positiveX12: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series reactance from terminal sequence 1 to terminal
    sequence 2. Used for short circuit data exchange according to IEC 60909
    Usage : EquivalentBranch is a result of network reduction prior to the
    data exchange
    '''

    positiveX21: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series reactance from terminal sequence 2 to terminal
    sequence 1. Used for short circuit data exchange according to IEC 60909
    Usage : EquivalentBranch is a result of network reduction prior to the
    data exchange
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series resistance of the reduced branch.
    '''

    r21: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Resistance from terminal sequence 2 to terminal sequence 1 .Used for steady
    state power flow. This attribute is optional and represent unbalanced network
    such as off-nominal phase shifter. If only EquivalentBranch.r is given,
    then EquivalentBranch.r21 is assumed equal to EquivalentBranch.r.
    Usage rule : EquivalentBranch is a result of network reduction prior to
    the data exchange.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series reactance of the reduced branch.
    '''

    x21: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactance from terminal sequence 2 to terminal sequence 1 .Used for steady
    state power flow. This attribute is optional and represent unbalanced network
    such as off-nominal phase shifter. If only EquivalentBranch.x is given,
    then EquivalentBranch.x21 is assumed equal to EquivalentBranch.x.
    Usage rule : EquivalentBranch is a result of network reduction prior to
    the data exchange.
    '''

    zeroR12: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series resistance from terminal sequence 1 to terminal sequence
    2. Used for short circuit data exchange according to IEC 60909
    EquivalentBranch is a result of network reduction prior to the data exchange
    '''

    zeroR21: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series resistance from terminal sequence 2 to terminal sequence
    1. Used for short circuit data exchange according to IEC 60909
    Usage : EquivalentBranch is a result of network reduction prior to the
    data exchange
    '''

    zeroX12: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series reactance from terminal sequence 1 to terminal sequence
    2. Used for short circuit data exchange according to IEC 60909
    Usage : EquivalentBranch is a result of network reduction prior to the
    data exchange
    '''

    zeroX21: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series reactance from terminal sequence 2 to terminal sequence
    1. Used for short circuit data exchange according to IEC 60909
    Usage : EquivalentBranch is a result of network reduction prior to the
    data exchange
    '''

@dataclass(repr=False)
class EquivalentInjection(EquivalentEquipment):
    '''
    This class represents equivalent injections (generation or load). Voltage
    regulation is allowed only at the point of connection.
    '''

    regulationCapability: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Specifies whether or not the EquivalentInjection has the capability to
    regulate the local voltage.
    '''

    regulationStatus: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Specifies the default regulation status of the EquivalentInjection. True
    is regulating. False is not regulating.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum active power of the injection.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Used for modeling of infeed for load flow exchange. Not used for short
    circuit modeling. If maxQ and minQ are not used ReactiveCapabilityCurve
    can be used.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum active power of the injection.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Used for modeling of infeed for load flow exchange. Not used for short
    circuit modeling. If maxQ and minQ are not used ReactiveCapabilityCurve
    can be used.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Equivalent active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Equivalent reactive power injection. Load sign convention is used, i.e.
    positive sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence resistance. Used to represent Extended-Ward (IEC 60909).
    Usage : Extended-Ward is a result of network reduction prior to the data
    exchange.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence resistance. Used to represent Extended-Ward (IEC 60909).
    Usage : Extended-Ward is a result of network reduction prior to the data
    exchange.
    '''

    r2: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence resistance. Used to represent Extended-Ward (IEC 60909).
    Usage : Extended-Ward is a result of network reduction prior to the data
    exchange.
    '''

    regulationTarget: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The target voltage for voltage regulation.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence reactance. Used to represent Extended-Ward (IEC 60909).
    Usage : Extended-Ward is a result of network reduction prior to the data
    exchange.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence reactance. Used to represent Extended-Ward (IEC 60909).
    Usage : Extended-Ward is a result of network reduction prior to the data
    exchange.
    '''

    x2: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence reactance. Used to represent Extended-Ward (IEC 60909).
    Usage : Extended-Ward is a result of network reduction prior to the data
    exchange.
    '''

    ReactiveCapabilityCurve: Optional[ReactiveCapabilityCurve] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReactiveCapabilityCurve.EquivalentInjection',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reactive capability curve used by this equivalent injection.
    '''

@dataclass(repr=False)
class EquivalentShunt(EquivalentEquipment):
    '''
    The class represents equivalent shunts.
    '''

    b: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt susceptance.
    '''

    g: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt conductance.
    '''

@dataclass(repr=False)
class Ground(ConductingEquipment):
    '''
    A point where the system is grounded used for connecting conducting equipment
    to ground. The power system model can have any number of grounds.
    '''

    GroundAction: Optional[GroundAction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GroundAction.Ground',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Action taken with this ground.
    '''

@dataclass(repr=False)
class PowerTransformer(ConductingEquipment):
    '''
    An electrical device consisting of two or more coupled windings, with or
    without a magnetic core, for introducing mutual coupling between electric
    circuits. Transformers can be used to control voltage and phase shift (active
    power flow).
    A power transformer may be composed of separate transformer tanks that
    need not be identical.
    A power transformer can be modeled with or without tanks and is intended
    for use in both balanced and unbalanced representations. A power transformer
    typically has two terminals, but may have one (grounding), three or more
    terminals.
    The inherited association ConductingEquipment.BaseVoltage should not be
    used. The association from TransformerEnd to BaseVoltage should be used
    instead.
    '''

    isPartOfGeneratorUnit: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates whether the machine is part of a power station unit. Used for
    short circuit data exchange according to IEC 60909
    '''

    operationalValuesConsidered: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    It is used to define if the data (other attributes related to short circuit
    data exchange) defines long term operational conditions or not. Used for
    short circuit data exchange according to IEC 60909.
    '''

    vectorGroup: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Vector group of the transformer for protective relaying, e.g., Dyn1. For
    unbalanced transformers, this may not be simply determined from the constituent
    winding connections and phase angle dispacements.
    The vectorGroup string consists of the following components in the order
    listed: high voltage winding connection, mid voltage winding connection
    (for three winding transformers), phase displacement clock number from
    0 to 11, low voltage winding connection
    phase displacement clock number from 0 to 11. The winding connections are
    D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag with
    neutral), A (auto transformer). Upper case means the high voltage, lower
    case mid or low. The high voltage winding always has clock postion 0 and
    is not included in the vector group string. Some examples: YNy0 (two winding
    wye to wye with no phase displacement), YNd11 (two winding wye to delta
    with 330 degrees phase displacement), YNyn0d5 (three winding transformer
    wye with neutral high voltgage, wye with neutral mid voltgage and no phase
    displacement, delta low voltage with 150 degrees displacement).
    Phase displacement is defined as the angular difference between the phasors
    representing the voltages between the neutral point (real or imaginary)
    and the corresponding terminals of two windings, a positive sequence voltage
    system being applied to the high-voltage terminals, following each other
    in alphabetical sequence if they are lettered, or in numerical sequence
    if they are numbered: the phasors are assumed to rotate in a counter-clockwise
    sense.
    '''

    beforeShCircuitHighestOperatingCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The highest operating current (Ib in the IEC 60909-0) before short circuit
    (depends on network configuration and relevant reliability philosophy).
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0.
    '''

    beforeShCircuitHighestOperatingVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The highest operating voltage (Ub in the IEC 60909-0) before short circuit.
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0. This is worst case voltage on the low side winding (Section
    3.7.1 in the standard). Used to define operating conditions.
    '''

    beforeShortCircuitAnglePf: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The angle of power factor before short circuit (phib in the IEC 60909-0).
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0. This is the worst case power factor. Used to define operating
    conditions.
    '''

    highSideMinOperatingU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum operating voltage (uQmin in the IEC 60909-0) at the high voltage
    side (Q side) of the unit transformer of the power station unit. A value
    well established from long-term operating experience of the system. It
    is used for calculation of the impedance correction factor KG defined in
    IEC 60909-0
    '''

    PowerTransformerEnd: list[PowerTransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerTransformerEnd.PowerTransformer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The ends of this power transformer.
    '''

    TransformerTanks: list[TransformerTank] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerTank.PowerTransformer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All transformers that belong to this bank.
    '''

@dataclass(repr=False)
class RegulatingCondEq(ConductingEquipment):
    '''
    A type of conducting equipment that can regulate a quantity (i.e. voltage
    or flow) at a specific point in the network.
    '''

    controlEnabled: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Specifies the regulation status of the equipment. True is regulating, false
    is not regulating.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RegulatingControl.RegulatingCondEq',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The regulating control scheme in which this equipment participates.
    '''

@dataclass(repr=False)
class ExternalNetworkInjection(RegulatingCondEq):
    '''
    This class represents external network and it is used for IEC 60909 calculations.
    '''

    ikSecond: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates whether initial symmetrical short-circuit current and power have
    been calculated according to IEC (Ik").
    '''

    maxR0ToX0Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum ratio of zero sequence resistance of Network Feeder to its zero
    sequence reactance (R(0)/X(0) max). Used for short circuit data exchange
    according to IEC 60909
    '''

    maxR1ToX1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum ratio of positive sequence resistance of Network Feeder to its
    positive sequence reactance (R(1)/X(1) max). Used for short circuit data
    exchange according to IEC 60909
    '''

    maxZ0ToZ1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) max). Used for short circuit data exchange according to IEC
    60909
    '''

    minR0ToX0Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates whether initial symmetrical short-circuit current and power have
    been calculated according to IEC (Ik"). Used for short circuit data exchange
    according to IEC 6090
    '''

    minR1ToX1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum ratio of positive sequence resistance of Network Feeder to its
    positive sequence reactance (R(1)/X(1) min). Used for short circuit data
    exchange according to IEC 60909
    '''

    minZ0ToZ1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) min). Used for short circuit data exchange according to IEC
    60909
    '''

    referencePriority: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Priority of unit for use as powerflow voltage phase angle reference bus
    selection. 0 = don t care (default) 1 = highest priority. 2 is less than
    1 and so on.
    '''

    governorSCD: Optional[ float | ActivePowerPerFrequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Power Frequency Bias. This is the change in power injection divided by
    the change in frequency and negated. A positive value of the power frequency
    bias provides additional power injection upon a drop in frequency.
    '''

    maxInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum initial symmetrical short-circuit currents (Ik" max) in A (Ik"
    = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according to
    IEC 60909
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum active power of the injection.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Not for short circuit modelling; It is used for modelling of infeed for
    load flow exchange. If maxQ and minQ are not used ReactiveCapabilityCurve
    can be used
    '''

    minInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum initial symmetrical short-circuit currents (Ik" min) in A (Ik"
    = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according to
    IEC 60909
    '''

    minP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum active power of the injection.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Not for short circuit modelling; It is used for modelling of infeed for
    load flow exchange. If maxQ and minQ are not used ReactiveCapabilityCurve
    can be used
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for steady state solutions.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for steady state solutions.
    '''

    voltageFactor: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Voltage factor in pu, which was used to calculate short-circuit current
    Ik" and power Sk".
    '''

@dataclass(repr=False)
class FrequencyConverter(RegulatingCondEq):
    '''
    A device to convert from one frequency to another (e.g., frequency F1 to
    F2) comprises a pair of FrequencyConverter instances. One converts from
    F1 to DC, the other converts the DC to F2.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Frequency on the AC side.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum active power on the DC side at which the frequence converter
    should operate.
    '''

    maxU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum voltage on the DC side at which the frequency converter should
    operate.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum active power on the DC side at which the frequence converter
    should operate.
    '''

    minU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum voltage on the DC side at which the frequency converter should
    operate.
    '''

@dataclass(repr=False)
class PowerElectronicsConnection(RegulatingCondEq):
    '''
    A connection to the AC network for energy production or consumption that
    uses power electronics rather than rotating machines.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit for
    the unit.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum reactive power limit for the unit. This is the minimum (nameplate)
    limit for the unit.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Equivalent resistance (RG) of generator. RG is considered for the calculation
    of all currents, except for the calculation of the peak current ip. Used
    for short circuit data exchange according to IEC 60909.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence resistance of the synchronous machine.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
    for short circuit data exchange according to IEC 60909.
    '''

    rn: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence Thevenin resistance.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence Thevenin reactance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence Thevenin reactance.
    '''

    xn: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence Thevenin reactance.
    '''

    PowerElectronicsUnit: list[PowerElectronicsUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerElectronicsUnit.PowerElectronicsConnection',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    An AC network connection may have several power electronics units connecting
    through it.
    '''

    WindTurbineType3or4Dynamics: Optional[WindTurbineType3or4Dynamics] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WindTurbineType3or4Dynamics.PowerElectronicsConnection',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The wind turbine type 3 or type 4 dynamics model associated with this power
    electronics connection.
    '''

@dataclass(repr=False)
class RotatingMachine(RegulatingCondEq):
    '''
    A rotating machine which may be used as a generator or motor.
    '''

    ratedPowerFactor: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Power factor (nameplate data). It is primarily used for short circuit data
    exchange according to IEC 60909.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
    for short circuit data exchange according to IEC 60909.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeneratingUnit.RotatingMachine',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A synchronous machine may operate as a generator and as such becomes a
    member of a generating unit.
    '''

    HydroPump: Optional[HydroPump] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroPump.RotatingMachine',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The synchronous machine drives the turbine which moves the water from a
    low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''

@dataclass(repr=False)
class AsynchronousMachine(RotatingMachine):
    '''
    A rotating machine whose shaft rotates asynchronously with the electrical
    field. Also known as an induction machine with no external connection to
    the rotor windings, e.g squirrel-cage induction machine.
    '''

    converterFedDrive: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates whether the machine is a converter fed drive. Used for short
    circuit data exchange according to IEC 60909
    '''

    iaIrRatio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Ratio of locked-rotor current to the rated current of the motor (Ia/Ir).
    Used for short circuit data exchange according to IEC 60909
    '''

    polePairNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Number of pole pairs of stator. Used for short circuit data exchange according
    to IEC 60909
    '''

    reversible: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates for converter drive motors if the power can be reversible. Used
    for short circuit data exchange according to IEC 60909
    '''

    rxLockedRotorRatio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Locked rotor ratio (R/X). Used for short circuit data exchange according
    to IEC 60909
    '''

    asynchronousMachineType: Optional[ AsynchronousMachineKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates the type of Asynchronous Machine (motor or generator).
    '''

    efficiency: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Efficiency of the asynchronous machine at nominal operation in percent.
    Indicator for converter drive motors. Used for short circuit data exchange
    according to IEC 60909
    '''

    nominalFrequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Nameplate data indicates if the machine is 50 or 60 Hz.
    '''

    nominalSpeed: Optional[ float | RotationSpeed ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Nameplate data. Depends on the slip and number of pole pairs.
    '''

    ratedMechanicalPower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated mechanical power (Pr in the IEC 60909-0). Used for short circuit
    data exchange according to IEC 60909.
    '''

    rr1: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Damper 1 winding resistance.
    '''

    rr2: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Damper 2 winding resistance.
    '''

    tpo: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transient rotor time constant (greater than tppo).
    '''

    tppo: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Sub-transient rotor time constant (greater than 0).
    '''

    xlr1: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Damper 1 winding leakage reactance.
    '''

    xlr2: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Damper 2 winding leakage reactance.
    '''

    xm: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Magnetizing reactance.
    '''

    xp: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transient reactance (unsaturated) (greater than or equal to xpp).
    '''

    xpp: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Sub-transient reactance (unsaturated) (greather than Xl).
    '''

    xs: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Synchronous reactance (greather than xp).
    '''

    AsynchronousMachineDynamics: Optional[AsynchronousMachineDynamics] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AsynchronousMachineDynamics.AsynchronousMachine',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Asynchronous machine dynamics model used to describe dynamic behavior of
    this asynchronous machine.
    '''

@dataclass(repr=False)
class SynchronousMachine(RotatingMachine):
    '''
    An electromechanical device that operates with shaft rotating synchronously
    with the network. It is a single machine operating either as a generator
    or synchronous condenser or pump.
    '''

    coolantCondition: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Temperature or pressure of coolant medium
    '''

    earthing: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates whether or not the generator is earthed. Used for short circuit
    data exchange according to IEC 60909
    '''

    mu: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Factor to calculate the breaking current (Section 4.5.2.1 in the IEC 60909-0).
    Used only for single fed short circuit on a generator (Section 4.3.4.2.
    in the IEC 60909-0).
    '''

    referencePriority: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Priority of unit for use as powerflow voltage phase angle reference bus
    selection. 0 = don t care (default) 1 = highest priority. 2 is less than
    1 and so on.
    '''

    aVRToManualLag: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Time delay required when switching from Automatic Voltage Regulation (AVR)
    to Manual for a lagging MVAr violation.
    '''

    aVRToManualLead: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Time delay required when switching from Automatic Voltage Regulation (AVR)
    to Manual for a leading MVAr violation.
    '''

    baseQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Default base reactive power value. This value represents the initial reactive
    power that can be used by any application function.
    '''

    condenserP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power consumed when in condenser mode operation.
    '''

    coolantType: Optional[ CoolantType ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Method of cooling the machine.
    '''

    earthingStarPointR: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Generator star point earthing resistance (Re). Used for short circuit data
    exchange according to IEC 60909
    '''

    earthingStarPointX: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Generator star point earthing reactance (Xe). Used for short circuit data
    exchange according to IEC 60909
    '''

    ikk: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Steady-state short-circuit current (in A for the profile) of generator
    with compound excitation during 3-phase short circuit.
    - Ikk=0: Generator with no compound excitation.
    - Ikk?0: Generator with compound excitation.
    Ikk is used to calculate the minimum steady-state short-circuit current
    for generators with compound excitation
    (Section 4.6.1.2 in the IEC 60909-0)
    Used only for single fed short circuit on a generator. (Section 4.3.4.2.
    in the IEC 60909-0)
    '''

    manualToAVR: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Time delay required when switching from Manual to Automatic Voltage Regulation.
    This value is used in the accelerating power reference frame for powerflow
    solutions
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit for
    the unit.
    '''

    maxU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum voltage limit for the unit.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum reactive power limit for the unit.
    '''

    minU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum voltage limit for the unit.
    '''

    operatingMode: Optional[ SynchronousMachineOperatingMode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Current mode of operation.
    '''

    qPercent: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Part of the coordinated reactive control that comes from this machine.
    The attribute is used as a participation factor not necessarily summing
    up to 100% for the devices participating in the control.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Equivalent resistance (RG) of generator. RG is considered for the calculation
    of all currents, except for the calculation of the peak current ip. Used
    for short circuit data exchange according to IEC 60909
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence resistance of the synchronous machine.
    '''

    r2: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence resistance.
    '''

    satDirectSubtransX: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Direct-axis subtransient reactance saturated, also known as Xd"sat.
    '''

    satDirectSyncX: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Direct-axes saturated synchronous reactance (xdsat); reciprocal of short-circuit
    ration. Used for short circuit data exchange, only for single fed short
    circuit on a generator. (Section 4.3.4.2. in the IEC 60909-0).
    '''

    satDirectTransX: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Saturated Direct-axis transient reactance. The attribute is primarily used
    for short circuit calculations according to ANSI.
    '''

    shortCircuitRotorType: Optional[ ShortCircuitRotorKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of rotor, used by short circuit applications, only for single fed
    short circuit according to IEC 60909.
    '''

    type: Optional[ SynchronousMachineKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Modes that this synchronous machine can operate in.
    '''

    voltageRegulationRange: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Range of generator voltage regulation (PG in the IEC 60909-0) used for
    calculation of the impedance correction factor KG defined in IEC 60909-0
    This attribute is used to describe the operating voltage of the generating
    unit.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence reactance of the synchronous machine.
    '''

    x2: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Negative sequence reactance.
    '''

    InitialReactiveCapabilityCurve: Optional[ReactiveCapabilityCurve] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReactiveCapabilityCurve.InitiallyUsedBySynchronousMachines',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The default reactive capability curve for use by a synchronous machine.
    '''

    PrimeMovers: list[PrimeMover] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PrimeMover.SynchronousMachines',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Prime movers that drive this SynchronousMachine.
    '''

    ReactiveCapabilityCurves: list[ReactiveCapabilityCurve] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ReactiveCapabilityCurve.SynchronousMachines',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All available reactive capability curves for this synchronous machine.
    '''

    SynchronousMachineDynamics: Optional[SynchronousMachineDynamics] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SynchronousMachineDynamics.SynchronousMachine',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Synchronous machine dynamics model used to describe dynamic behavior of
    this synchronous machine.
    '''

@dataclass(repr=False)
class ShuntCompensator(RegulatingCondEq):
    '''
    A shunt capacitor or reactor or switchable bank of shunt capacitors or
    reactors. A section of a shunt compensator is an individual capacitor or
    reactor. A negative value for reactivePerSection indicates that the compensator
    is a reactor. ShuntCompensator is a single terminal device. Ground is implied.
    '''

    grounded: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Used for Yn and Zn connections. True if the neutral is solidly grounded.
    '''

    maximumSections: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum number of sections that may be switched in.
    '''

    normalSections: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The normal number of sections switched in.
    '''

    sections: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Shunt compensator sections in use.
    Starting value for steady state solution. Non integer values are allowed
    to support continuous variables. The reasons for continuous value are to
    support study cases where no discrete shunt compensators has yet been designed,
    a solutions where a narrow voltage band force the sections to oscillate
    or accommodate for a continuous solution as input.
    '''

    switchOnCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The switch on count since the capacitor count was last reset or initialized.
    '''

    switchOnDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The date and time when the capacitor bank was last switched on.
    '''

    aVRDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Time delay required for the device to be connected or disconnected by automatic
    voltage regulation (AVR).
    '''

    nomU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The voltage at which the nominal reactive power may be calculated. This
    should normally be within 10% of the voltage at which the capacitor is
    connected to the network.
    '''

    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The type of phase connection, such as wye or delta.
    '''

    voltageSensitivity: Optional[ float | VoltagePerReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Voltage sensitivity required for the device to regulate the bus voltage,
    in voltage/reactive power.
    '''

    ShuntCompensatorPhase: list[ShuntCompensatorPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ShuntCompensatorPhase.ShuntCompensator',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The individual phases models for the shunt compensator.
    '''

    SvShuntCompensatorSections: Optional[SvShuntCompensatorSections] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SvShuntCompensatorSections.ShuntCompensator',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The state for the number of shunt compensator sections in service.
    '''

@dataclass(repr=False)
class LinearShuntCompensator(ShuntCompensator):
    '''
    A linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    b0PerSection: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence shunt (charging) susceptance per section
    '''

    bPerSection: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt (charging) susceptance per section
    '''

    g0PerSection: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence shunt (charging) conductance per section
    '''

    gPerSection: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt (charging) conductance per section
    '''

@dataclass(repr=False)
class NonlinearShuntCompensator(ShuntCompensator):
    '''
    A non linear shunt compensator has bank or section admittance values that
    differs.
    '''

    NonlinearShuntCompensatorPoints: list[NonlinearShuntCompensatorPoint] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NonlinearShuntCompensatorPoint.NonlinearShuntCompensator',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All points of the non-linear shunt compensator.
    '''

@dataclass(repr=False)
class StaticVarCompensator(RegulatingCondEq):
    '''
    A facility for providing variable and controllable shunt reactive power.
    The SVC typically consists of a stepdown transformer, filter, thyristor-controlled
    reactor, and thyristor-switched capacitor arms.
    The SVC may operate in fixed MVar output mode or in voltage control mode.
    When in voltage control mode, the output of the SVC will be proportional
    to the deviation of voltage at the controlled bus from the voltage setpoint.
    The SVC characteristic slope defines the proportion. If the voltage at
    the controlled bus is equal to the voltage setpoint, the SVC MVar output
    is zero.
    '''

    capacitiveRating: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum available capacitive reactance.
    '''

    inductiveRating: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum available inductive reactance.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    slope: Optional[ float | VoltagePerReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The characteristics slope of an SVC defines how the reactive power output
    changes in proportion to the difference between the regulated bus voltage
    and the voltage setpoint.
    '''

    sVCControlMode: Optional[ SVCControlMode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    SVC control mode.
    '''

    voltageSetPoint: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reactive power output of the SVC is proportional to the difference
    between the voltage at the regulated bus and the voltage setpoint. When
    the regulated bus voltage is equal to the voltage setpoint, the reactive
    power output is zero.
    '''

    StaticVarCompensatorDynamics: Optional[StaticVarCompensatorDynamics] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StaticVarCompensatorDynamics.StaticVarCompensator',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Static Var Compensator dynamics model used to describe dynamic behavior
    of this Static Var Compensator.
    '''

@dataclass(repr=False)
class SeriesCompensator(ConductingEquipment):
    '''
    A Series Compensator is a series capacitor or reactor or an AC transmission
    line without charging susceptance. It is a two terminal device.
    '''

    varistorPresent: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Describe if a metal oxide varistor (mov) for over voltage protection is
    configured at the series compensator.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence resistance.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence resistance.
    '''

    varistorRatedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum current the varistor is designed to handle at specified duration.
    '''

    varistorVoltageThreshold: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The dc voltage at which the varistor start conducting.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence reactance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence reactance.
    '''

@dataclass(repr=False)
class Switch(ConductingEquipment):
    '''
    A generic device designed to close, or open, or both, one or more electric
    circuits. All switches are two terminal devices including grounding switches.
    '''

    normalOpen: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The attribute is used in cases when no Measurement for the status value
    is present. If the Switch has a status measurement the Discrete.normalValue
    is expected to match with the Switch.normalOpen.
    '''

    open: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The attribute tells if the switch is considered open when used as input
    to topology processing.
    '''

    retained: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Branch is retained in a bus branch model. The flow through retained switches
    will normally be calculated in power flow.
    '''

    switchOnCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The switch on count since the switch was last reset or initialized.
    '''

    switchOnDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The date and time when the switch was last switched on.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum continuous current carrying capacity in amps governed by the
    device material and construction.
    '''

    CompositeSwitch: Optional[CompositeSwitch] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CompositeSwitch.Switches',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Composite switch to which this Switch belongs.
    '''

    ConnectDisconnectFunctions: list[ConnectDisconnectFunction] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConnectDisconnectFunction.Switches',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    Outage: Optional[Outage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Outage.OpenedSwitches',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Current outage of this protective device.
    '''

    SwitchAction: Optional[SwitchAction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SwitchAction.OperatedSwitch',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Action changing status of this switch.
    '''

    SwitchPhase: list[SwitchPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SwitchPhase.Switch',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The individual switch phases for the switch.
    '''

    SwitchSchedules: list[SwitchSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SwitchSchedule.Switch',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A Switch can be associated with SwitchSchedules.
    '''

@dataclass(repr=False)
class Cut(Switch):
    '''
    A cut separates a line segment into two parts. The cut appears as a switch
    inserted between these two parts and connects them together. As the cut
    is normally open there is no galvanic connection between the two line segment
    parts. But it is possible to close the cut to get galvanic connection.
    The cut terminals are oriented towards the line segment terminals with
    the same sequence number. Hence the cut terminal with sequence number equal
    to 1 is oriented to the line segment's terminal with sequence number equal
    to 1.
    The cut terminals also act as connection points for jumpers and other equipment,
    e.g. a mobile generator. To enable this, connectivity nodes are placed
    at the cut terminals. Once the connectivity nodes are in place any conducting
    equipment can be connected at them.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The length to the place where the cut is located starting from side one
    of the cut line segment, i.e. the line segment Terminal with sequenceNumber
    equal to 1.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.Cut',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The line segment to which the cut is applied.
    '''

    CutAction: Optional[CutAction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CutAction.Cut',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Action taken with this cut.
    '''

@dataclass(repr=False)
class Disconnector(Switch):
    '''
    A manually operated or motor operated mechanical switching device used
    for changing the connections in a circuit, or for isolating a circuit or
    equipment from a source of power. It is required to open or close circuits
    when negligible current is broken or made.
    '''

@dataclass(repr=False)
class Fuse(Switch):
    '''
    An overcurrent protective device with a circuit opening fusible part that
    is heated and severed by the passage of overcurrent through it. A fuse
    is considered a switching device because it breaks current.
    '''

@dataclass(repr=False)
class GroundDisconnector(Switch):
    '''
    A manually operated or motor operated mechanical switching device used
    for isolating a circuit or equipment from ground.
    '''

@dataclass(repr=False)
class Jumper(Switch):
    '''
    A short section of conductor with negligible impedance which can be manually
    removed and replaced if the circuit is de-energized. Note that zero-impedance
    branches can potentially be modeled by other equipment types.
    '''

    JumperAction: Optional[JumperAction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'JumperAction.Jumper',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Action taken with this jumper.
    '''

@dataclass(repr=False)
class ProtectedSwitch(Switch):
    '''
    A ProtectedSwitch is a switching device that can be operated by ProtectionEquipment.
    '''

    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum fault current a breaking device can break safely under prescribed
    conditions of use.
    '''

    OperatedByProtectionEquipment: list[ProtectionEquipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProtectionEquipment.ProtectedSwitches',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Protection equipments that operate this ProtectedSwitch.
    '''

    RecloseSequences: list[RecloseSequence] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RecloseSequence.ProtectedSwitch',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A breaker may have zero or more automatic reclosures after a trip occurs.
    '''

@dataclass(repr=False)
class Breaker(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal circuit conditions and also making, carrying for
    a specified time, and breaking currents under specified abnormal circuit
    conditions e.g. those of short circuit.
    '''

    inTransitTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The transition time from open to close.
    '''

@dataclass(repr=False)
class LoadBreakSwitch(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal operating conditions.
    '''

@dataclass(repr=False)
class Recloser(ProtectedSwitch):
    '''
    Pole-mounted fault interrupter with built-in phase and ground relays, current
    transformer (CT), and supplemental controls.
    '''

@dataclass(repr=False)
class Sectionaliser(Switch):
    '''
    Automatic switch that will lock open to isolate a faulted section. It may,
    or may not, have load breaking capability. Its primary purpose is to provide
    fault sectionalising at locations where the fault current is either too
    high, or too low, for proper coordination of fuses.
    '''

@dataclass(repr=False)
class DCConductingEquipment(Equipment):
    '''
    The parts of the DC power system that are designed to carry current or
    that are conductively connected through DC terminals.
    '''

    DCTerminals: list[DCTerminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DCTerminal.DCConductingEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A DC conducting equipment has DC terminals.
    '''

    ProtectiveActionAdjustment: list[ProtectiveActionAdjustment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProtectiveActionAdjustment.DCConductingEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class DCBusbar(DCConductingEquipment):
    '''
    A busbar within a DC system.
    '''

@dataclass(repr=False)
class DCChopper(DCConductingEquipment):
    '''
    Low resistance equipment used in the internal DC circuit to balance voltages.
    It has typically positive and negative pole terminals and a ground.
    '''

@dataclass(repr=False)
class DCGround(DCConductingEquipment):
    '''
    A ground within a DC system.
    '''

    inductance: Optional[ float | Inductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Inductance to ground.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Resistance to ground.
    '''

@dataclass(repr=False)
class DCLineSegment(DCConductingEquipment):
    '''
    A wire or combination of wires not insulated from one another, with consistent
    electrical characteristics, used to carry direct current between points
    in the DC region of the power system.
    '''

    capacitance: Optional[ float | Capacitance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Capacitance of the DC line segment. Significant for cables only.
    '''

    inductance: Optional[ float | Inductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Inductance of the DC line segment. Neglectable compared with DCSeriesDevice
    used for smoothing.
    '''

    length: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Segment length for calculating line section capabilities.
    '''

    resistance: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Resistance of the DC line segment.
    '''

    PerLengthParameter: Optional[PerLengthDCLineParameter] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PerLengthDCLineParameter.DCLineSegments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Set of per-length parameters for this line segment.
    '''

@dataclass(repr=False)
class DCSeriesDevice(DCConductingEquipment):
    '''
    A series device within the DC system, typically a reactor used for filtering
    or smoothing. Needed for transient and short circuit studies.
    '''

    inductance: Optional[ float | Inductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Inductance of the device.
    '''

    ratedUdc: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated DC device voltage. Converter configuration data used in power flow.
    '''

    resistance: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Resistance of the DC device.
    '''

@dataclass(repr=False)
class DCShunt(DCConductingEquipment):
    '''
    A shunt device within the DC system, typically used for filtering. Needed
    for transient and short circuit studies.
    '''

    capacitance: Optional[ float | Capacitance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Capacitance of the DC shunt.
    '''

    ratedUdc: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated DC device voltage. Converter configuration data used in power flow.
    '''

    resistance: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Resistance of the DC device.
    '''

@dataclass(repr=False)
class DCSwitch(DCConductingEquipment):
    '''
    A switch within the DC system.
    '''

@dataclass(repr=False)
class DCBreaker(DCSwitch):
    '''
    A breaker within a DC system.
    '''

@dataclass(repr=False)
class DCDisconnector(DCSwitch):
    '''
    A disconnector within a DC system.
    '''

@dataclass(repr=False)
class GeneratingUnit(Equipment):
    '''
    A single or set of synchronous machines for converting mechanical power
    into alternating-current power. For example, individual machines within
    a set may be defined for scheduling purposes while a single control signal
    is derived for the set. In this case there would be a GeneratingUnit for
    each member of the set and an additional GeneratingUnit corresponding to
    the set.
    '''

    longPF: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Generating unit long term economic participation factor.
    '''

    normalPF: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Generating unit economic participation factor.
    '''

    penaltyFactor: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Defined as: 1 / ( 1 - Incremental Transmission Loss); with the Incremental
    Transmission Loss expressed as a plus or minus value. The typical range
    of penalty factors is (0.9 to 1.1).
    '''

    shortPF: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Generating unit short term economic participation factor.
    '''

    tieLinePF: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Generating unit economic participation factor.
    '''

    allocSpinResP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The planned unused capacity (spinning reserve) which can be used to support
    emergency load.
    '''

    autoCntrlMarginP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The planned unused capacity which can be used to support automatic control
    overruns.
    '''

    baseP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    For dispatchable units, this value represents the economic active power
    basepoint, for units that are not dispatchable, this value represents the
    fixed generation value. The value must be between the operating low and
    high limits.
    '''

    controlDeadband: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Unit control error deadband. When a unit's desired active power change
    is less than this deadband, then no control pulses will be sent to the
    unit.
    '''

    controlPulseHigh: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pulse high limit which is the largest control pulse that the unit can respond
    to.
    '''

    controlPulseLow: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pulse low limit which is the smallest control pulse that the unit can respond
    to.
    '''

    controlResponseRate: Optional[ float | ActivePowerChangeRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Unit response rate which specifies the active power change for a control
    pulse of one second in the most responsive loading level of the unit.
    '''

    efficiency: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The efficiency of the unit in converting mechanical energy, from the prime
    mover, into electrical energy.
    '''

    genControlMode: Optional[ GeneratorControlMode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit control mode.
    '''

    genControlSource: Optional[ GeneratorControlSource ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The source of controls for a generating unit.
    '''

    governorMPL: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Governor motor position limit.
    '''

    governorSCD: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Governor Speed Changer Droop. This is the change in generator power output
    divided by the change in frequency normalized by the nominal power of the
    generator and the nominal frequency and expressed in percent and negated.
    A positive value of speed change droop provides additional generator output
    upon a drop in frequency.
    '''

    highControlLimit: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    High limit for secondary (AGC) control.
    '''

    initialP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Default initial active power which is used to store a powerflow result
    for the initial active power for this unit in this network configuration.
    '''

    lowControlLimit: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Low limit for secondary (AGC) control.
    '''

    lowerRampRate: Optional[ float | ActivePowerChangeRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The normal maximum rate the generating unit active power output can be
    lowered by control actions.
    '''

    maxEconomicP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum high economic active power limit, that should not exceed the maximum
    operating active power limit.
    '''

    maximumAllowableSpinningReserve: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum allowable spinning reserve. Spinning reserve will never be considered
    greater than this value regardless of the current operating point.
    '''

    maxOperatingP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    This is the maximum operating active power limit the dispatcher can enter
    for this unit.
    '''

    minEconomicP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Low economic active power limit that must be greater than or equal to the
    minimum operating active power limit.
    '''

    minimumOffTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum time interval between unit shutdown and startup.
    '''

    minOperatingP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    This is the minimum operating active power limit the dispatcher can enter
    for this unit.
    '''

    modelDetail: Optional[ int | Classification ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Detail level of the generator model data.
    '''

    nominalP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The nominal power of the generating unit. Used to give precise meaning
    to percentage based attributes such as the governor speed change droop
    (governorSCD attribute).
    The attribute shall be a positive value equal or less than RotatingMachine.ratedS.
    '''

    raiseRampRate: Optional[ float | ActivePowerChangeRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The normal maximum rate the generating unit active power output can be
    raised by control actions.
    '''

    ratedGrossMaxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit's gross rated maximum capacity (book value).
    '''

    ratedGrossMinP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The gross rated minimum generation level which the unit can safely operate
    at while delivering power to the transmission grid.
    '''

    ratedNetMaxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The net rated maximum capacity determined by subtracting the auxiliary
    power used to operate the internal plant machinery from the rated gross
    maximum capacity.
    '''

    startupCost: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The initial startup cost incurred for each start of the GeneratingUnit.
    '''

    startupTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Time it takes to get the unit on-line, from the time that the prime mover
    mechanical power is applied.
    '''

    totalEfficiency: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The efficiency of the unit in converting the fuel into electrical energy.
    '''

    variableCost: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The variable cost component of production per unit of ActivePower.
    '''

    ControlAreaGeneratingUnit: list[ControlAreaGeneratingUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ControlAreaGeneratingUnit.GeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    ControlArea specifications for this generating unit.
    '''

    GenUnitOpCostCurves: list[GenUnitOpCostCurve] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'GenUnitOpCostCurve.GeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A generating unit may have one or more cost curves, depending upon fuel
    mixture and fuel cost.
    '''

    GenUnitOpSchedule: Optional[GenUnitOpSchedule] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GenUnitOpSchedule.GeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''

    GrossToNetActivePowerCurves: list[GrossToNetActivePowerCurve] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'GrossToNetActivePowerCurve.GeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A generating unit may have a gross active power to net active power curve,
    describing the losses and auxiliary power requirements of the unit.
    '''

    RotatingMachine: list[RotatingMachine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RotatingMachine.GeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A synchronous machine may operate as a generator and as such becomes a
    member of a generating unit.
    '''

@dataclass(repr=False)
class HydroGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover is a hydraulic turbine (e.g., Francis,
    Pelton, Kaplan).
    '''

    energyConversionCapability: Optional[ HydroEnergyConversionKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Energy conversion capability for generating.
    '''

    hydroUnitWaterCost: Optional[ float | CostPerVolume ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The equivalent cost of water that drives the hydro turbine.
    '''

    HydroPowerPlant: Optional[HydroPowerPlant] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroPowerPlant.HydroGeneratingUnits',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The hydro generating unit belongs to a hydro power plant.
    '''

    PenstockLossCurve: Optional[PenstockLossCurve] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PenstockLossCurve.HydroGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''

@dataclass(repr=False)
class NuclearGeneratingUnit(GeneratingUnit):
    '''
    A nuclear generating unit.
    '''

@dataclass(repr=False)
class SolarGeneratingUnit(GeneratingUnit):
    '''
    A solar thermal generating unit.
    '''

@dataclass(repr=False)
class ThermalGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover could be a steam turbine, combustion
    turbine, or diesel engine.
    '''

    oMCost: Optional[ float | CostPerHeatUnit ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Operating and maintenance cost for the thermal unit.
    '''

    CAESPlant: Optional[CAESPlant] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CAESPlant.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may be a member of a compressed air energy storage
    plant.
    '''

    CogenerationPlant: Optional[CogenerationPlant] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CogenerationPlant.ThermalGeneratingUnits',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may be a member of a cogeneration plant.
    '''

    CombinedCyclePlant: Optional[CombinedCyclePlant] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CombinedCyclePlant.ThermalGeneratingUnits',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may be a member of a combined cycle plant.
    '''

    HeatInputCurve: Optional[HeatInputCurve] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HeatInputCurve.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''

    HeatRateCurve: Optional[HeatRateCurve] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HeatRateCurve.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''

    IncrementalHeatRateCurve: Optional[IncrementalHeatRateCurve] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IncrementalHeatRateCurve.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''

    ShutdownCurve: Optional[ShutdownCurve] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ShutdownCurve.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''

    StartupModel: Optional[StartupModel] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartupModel.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have a startup model.
    '''

@dataclass(repr=False)
class WindGeneratingUnit(GeneratingUnit):
    '''
    A wind driven generating unit. May be used to represent a single turbine
    or an aggregation.
    '''

    windGenUnitType: Optional[ WindGenUnitKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The kind of wind generating unit
    '''

@dataclass(repr=False)
class HydroPump(Equipment):
    '''
    A synchronous motor-driven pump, typically associated with a pumped storage
    plant.
    '''

    pumpDischAtMaxHead: Optional[ float | VolumeFlowRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The pumping discharge under maximum head conditions, usually at full gate.
    '''

    pumpDischAtMinHead: Optional[ float | VolumeFlowRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The pumping discharge under minimum head conditions, usually at full gate.
    '''

    pumpPowerAtMaxHead: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The pumping power under maximum head conditions, usually at full gate.
    '''

    pumpPowerAtMinHead: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The pumping power under minimum head conditions, usually at full gate.
    '''

    HydroPowerPlant: Optional[HydroPowerPlant] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroPowerPlant.HydroPumps',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The hydro pump may be a member of a pumped storage plant or a pump for
    distributing water.
    '''

    HydroPumpOpSchedule: Optional[HydroPumpOpSchedule] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroPumpOpSchedule.HydroPump',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''

    RotatingMachine: Optional[RotatingMachine] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RotatingMachine.HydroPump',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The synchronous machine drives the turbine which moves the water from a
    low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''

@dataclass(repr=False)
class PowerElectronicsUnit(Equipment):
    '''
    A generating unit or battery or aggregation that connects to the AC network
    using power electronics rather than rotating machines.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum active power limit. This is the maximum (nameplate) limit for the
    unit.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Minimum active power limit. This is the minimum (nameplate) limit for the
    unit.
    '''

    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerElectronicsConnection.PowerElectronicsUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A power electronics unit have a connection to the AC network.
    '''

@dataclass(repr=False)
class PowerElectronicsWindUnit(PowerElectronicsUnit):
    '''
    A wind generating unit that connects to the AC network with power electronics
    rather than rotating machines or an aggregation of such units.
    '''

@dataclass(repr=False)
class ProtectionEquipment(Equipment):
    '''
    An electrical device designed to respond to input conditions in a prescribed
    manner and after specified conditions are met to cause contact operation
    or similar abrupt change in associated electric control circuits, or simply
    to display the detected condition. Protection equipment are associated
    with conducting equipment and usually operate circuit breakers.
    '''

    highLimit: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum allowable value.
    '''

    lowLimit: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum allowable value.
    '''

    powerDirectionFlag: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Direction same as positive active power flow value.
    '''

    relayDelayTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The time delay from detection of abnormal conditions to relay operation.
    '''

    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit multiplier of the value.
    '''

    unitSymbol: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit of measure of the value.
    '''

    ConductingEquipments: list[ConductingEquipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConductingEquipment.ProtectionEquipments',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Protection equipment may be used to protect specific conducting equipment.
    '''

    ProtectedSwitches: list[ProtectedSwitch] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProtectedSwitch.OperatedByProtectionEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Protected switches operated by this ProtectionEquipment.
    '''

    ProtectiveAction: list[ProtectiveAction] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProtectiveAction.ProtectionEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class CurrentRelay(ProtectionEquipment):
    '''
    A device that checks current flow values in any direction or designated
    direction.
    '''

    inverseTimeFlag: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Set true if the current relay has inverse time characteristic.
    '''

    currentLimit1: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Current limit number one 1 for inverse time pickup.
    '''

    currentLimit2: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Current limit number 2 for inverse time pickup.
    '''

    currentLimit3: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Current limit number 3 for inverse time pickup.
    '''

    timeDelay1: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Inverse time delay number 1 for current limit number 1.
    '''

    timeDelay2: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Inverse time delay number 2 for current limit number 2.
    '''

    timeDelay3: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Inverse time delay number 3 for current limit number 3.
    '''

@dataclass(repr=False)
class SynchrocheckRelay(ProtectionEquipment):
    '''
    A device that operates when two AC circuits are within the desired limits
    of frequency, phase angle, and voltage, to permit or to cause the paralleling
    of these two circuits. Used to prevent the paralleling of non-synchronous
    topological islands.
    '''

    maxAngleDiff: Optional[ float | AngleRadians ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum allowable voltage vector phase angle difference across the
    open device.
    '''

    maxFreqDiff: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum allowable frequency difference across the open device.
    '''

    maxVoltDiff: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum allowable difference voltage across the open device.
    '''

@dataclass(repr=False)
class TransformerTank(Equipment):
    '''
    An assembly of two or more coupled windings that transform electrical power
    between voltage levels. These windings are bound on a common core and place
    in the same tank. Transformer tank can be used to model both single-phase
    and 3-phase transformers.
    '''

    PowerTransformer: Optional[PowerTransformer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerTransformer.TransformerTanks',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Bank this transformer belongs to.
    '''

    TransformerObservations: list[TransformerObservation] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerObservation.Transformer',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    TransformerTankEnds: list[TransformerTankEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerTankEnd.TransformerTank',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All windings of this transformer.
    '''

@dataclass(repr=False)
class HydroPowerPlant(PowerSystemResource):
    '''
    A hydro power station which can generate or pump. When generating, the
    generator turbines receive water from an upper reservoir. When pumping,
    the pumps receive their water from a lower reservoir.
    '''

    penstockType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type and configuration of hydro plant penstock(s).
    '''

    surgeTankCode: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A code describing the type (or absence) of surge tank that is associated
    with the hydro power plant.
    '''

    dischargeTravelDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Water travel delay from tailbay to next downstream hydro power station.
    '''

    genRatedP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The hydro plant's generating rating active power for rated head conditions.
    '''

    hydroPlantStorageType: Optional[ HydroPlantStorageKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The type of hydro power plant water storage.
    '''

    plantDischargeCapacity: Optional[ float | VolumeFlowRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Total plant discharge capacity.
    '''

    plantRatedHead: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The plant's rated gross head.
    '''

    pumpRatedP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The hydro plant's pumping rating active power for rated head conditions.
    '''

    surgeTankCrestLevel: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The level at which the surge tank spills.
    '''

    GenSourcePumpDischargeReservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.UpstreamFromHydroPowerPlants',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Generators are supplied water from or pumps discharge water to an upstream
    reservoir.
    '''

    HydroGeneratingUnits: list[HydroGeneratingUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'HydroGeneratingUnit.HydroPowerPlant',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The hydro generating unit belongs to a hydro power plant.
    '''

    HydroPumps: list[HydroPump] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'HydroPump.HydroPowerPlant',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The hydro pump may be a member of a pumped storage plant or a pump for
    distributing water.
    '''

    Reservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.HydroPowerPlants',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Generators discharge water to or pumps are supplied water from a downstream
    reservoir.
    '''

@dataclass(repr=False)
class PowerCutZone(PowerSystemResource):
    '''
    An area or zone of the power system which is used for load shedding purposes.
    '''

    cutLevel1: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    First level (amount) of load to cut as a percentage of total zone load.
    '''

    cutLevel2: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Second level (amount) of load to cut as a percentage of total zone load.
    '''

    EnergyConsumers: list[EnergyConsumer] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnergyConsumer.PowerCutZone',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Energy consumer is assigned to the power cut zone.
    '''

@dataclass(repr=False)
class PrimeMover(PowerSystemResource):
    '''
    The machine used to develop mechanical energy used to drive a generator.
    '''

    primeMoverRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rating of prime mover.
    '''

    SynchronousMachines: list[SynchronousMachine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SynchronousMachine.PrimeMovers',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Synchronous machines this Prime mover drives.
    '''

@dataclass(repr=False)
class CombustionTurbine(PrimeMover):
    '''
    A prime mover that is typically fueled by gas or light oil.
    '''

    heatRecoveryFlag: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Flag that is set to true if the combustion turbine is associated with a
    heat recovery boiler.
    '''

    ambientTemp: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Default ambient temperature to be used in modeling applications.
    '''

    auxPowerVersusFrequency: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Off-nominal frequency effect on turbine auxiliaries. Per unit reduction
    in auxiliary active power consumption versus per unit reduction in frequency
    (from rated frequency).
    '''

    auxPowerVersusVoltage: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Off-nominal voltage effect on turbine auxiliaries. Per unit reduction in
    auxiliary active power consumption versus per unit reduction in auxiliary
    bus voltage (from a specified voltage level).
    '''

    capabilityVersusFrequency: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Off-nominal frequency effect on turbine capability. Per unit reduction
    in unit active power capability versus per unit reduction in frequency
    (from rated frequency).
    '''

    powerVariationByTemp: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Per unit change in power per (versus) unit change in ambient temperature.
    '''

    referenceTemp: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reference temperature at which the output of the turbine was defined.
    '''

    timeConstant: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The time constant for the turbine.
    '''

    AirCompressor: Optional[AirCompressor] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AirCompressor.CombustionTurbine',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A CAES air compressor is driven by combustion turbine.
    '''

    CTTempActivePowerCurve: Optional[CTTempActivePowerCurve] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CTTempActivePowerCurve.CombustionTurbine',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A combustion turbine may have an active power versus ambient temperature
    relationship.
    '''

    HeatRecoveryBoiler: Optional[HeatRecoveryBoiler] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HeatRecoveryBoiler.CombustionTurbines',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A combustion turbine may have a heat recovery boiler for making steam.
    '''

@dataclass(repr=False)
class HydroTurbine(PrimeMover):
    '''
    A water driven prime mover. Typical turbine types are: Francis, Kaplan,
    and Pelton.
    '''

    gateRateLimit: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Gate rate limit.
    '''

    gateUpperLimit: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Gate upper limit.
    '''

    maxHeadMaxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum efficiency active power at maximum head conditions.
    '''

    minHeadMaxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum efficiency active power at minimum head conditions.
    '''

    speedRating: Optional[ float | RotationSpeed ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated speed in number of revolutions.
    '''

    speedRegulation: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Speed regulation.
    '''

    transientDroopTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transient droop time constant.
    '''

    transientRegulation: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transient regulation.
    '''

    turbineRating: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated turbine active power.
    '''

    turbineType: Optional[ TurbineType ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of turbine.
    '''

    waterStartingTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Water starting time.
    '''

@dataclass(repr=False)
class SteamTurbine(PrimeMover):
    '''
    Steam turbine.
    '''

    shaft1PowerHP: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fraction of power from shaft 1 high pressure turbine output.
    '''

    shaft1PowerIP: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fraction of power from shaft 1 intermediate pressure turbine output.
    '''

    shaft1PowerLP1: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fraction of power from shaft 1 first low pressure turbine output.
    '''

    shaft1PowerLP2: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fraction of power from shaft 1 second low pressure turbine output.
    '''

    shaft2PowerHP: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fraction of power from shaft 2 high pressure turbine output.
    '''

    shaft2PowerIP: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fraction of power from shaft 2 intermediate pressure turbine output.
    '''

    shaft2PowerLP1: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fraction of power from shaft 2 first low pressure turbine output.
    '''

    shaft2PowerLP2: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fraction of power from shaft 2 second low pressure turbine output.
    '''

    crossoverTC: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Crossover time constant.
    '''

    reheater1TC: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    First reheater time constant.
    '''

    reheater2TC: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Second reheater time constant.
    '''

    steamChestTC: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Steam chest time constant.
    '''

    SteamSupplys: list[SteamSupply] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SteamSupply.SteamTurbines',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Steam turbines may have steam supplied by a steam supply.
    '''

@dataclass(repr=False)
class RegulatingControl(PowerSystemResource):
    '''
    Specifies a set of equipment that works together to control a power system
    quantity such as voltage or flow.
    Remote bus voltage control is possible by specifying the controlled terminal
    located at some place remote from the controlling equipment.
    In case multiple equipment, possibly of different types, control same terminal
    there must be only one RegulatingControl at that terminal. The most specific
    subtype of RegulatingControl shall be used in case such equipment participate
    in the control, e.g. TapChangerControl for tap changers.
    For flow control load sign convention is used, i.e. positive sign means
    flow out from a TopologicalNode (bus) into the conducting equipment.
    '''

    discrete: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The regulation is performed in a discrete mode. This applies to equipment
    with discrete controls, e.g. tap changers and shunt compensators.
    '''

    enabled: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The flag tells if regulation is enabled.
    '''

    targetDeadband: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    This is a deadband used with discrete control to avoid excessive update
    of controls like tap changers and shunt compensator banks while regulating.
    The units of those appropriate for the mode.
    '''

    targetValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The target value specified for case input. This value can be used for the
    target value without the use of schedules. The value has the units appropriate
    to the mode attribute.
    '''

    mode: Optional[ RegulatingControlModeKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The regulating control mode presently available. This specification allows
    for determining the kind of regulation without need for obtaining the units
    from a schedule.
    '''

    monitoredPhase: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase voltage controlling this regulator, measured at regulator location.
    '''

    targetValueUnitMultiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Specify the multiplier for used for the targetValue.
    '''

    ProtectiveActionRegulation: list[ProtectiveActionRegulation] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProtectiveActionRegulation.RegulatingControl',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    RegulatingCondEq: list[RegulatingCondEq] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RegulatingCondEq.RegulatingControl',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The equipment that participates in this regulating control scheme.
    '''

    RegulationSchedule: list[RegulationSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RegulationSchedule.RegulatingControl',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Schedule for this Regulating regulating control.
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.RegulatingControl',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The terminal associated with this regulating control. The terminal is associated
    instead of a node, since the terminal could connect into either a topological
    node (bus in bus-branch model) or a connectivity node (detailed switch
    model). Sometimes it is useful to model regulation at a terminal of a bus
    bar object since the bus bar can be present in both a bus-branch model
    or a model with switch detail.
    '''

@dataclass(repr=False)
class ShuntCompensatorControl(RegulatingControl):
    '''
    Distribution capacitor bank control settings.
    '''

    branchDirect: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    For VAR, amp, or power factor locally controlled shunt impedances, the
    flow direction: in, out.
    '''

    localOffLevel: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Upper control setting.
    '''

    localOnLevel: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Lower control setting.
    '''

    localOverride: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if the locally controlled capacitor has voltage override capability.
    '''

    maxSwitchOperationCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    IdmsShuntImpedanceData.maxNumSwitchOps.
    '''

    normalOpen: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if open is normal status for a fixed capacitor bank, otherwise normal
    status is closed.
    '''

    regBranch: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    For VAR, amp, or power factor locally controlled shunt impedances, the
    index of the regulation branch.
    '''

    regBranchEnd: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    For VAR, amp, or power factor locally controlled shunt impedances, the
    end of the branch that is regulated. The field has the following values:
    from side, to side, and tertiary (only if the branch is a transformer).
    '''

    vRegLineLine: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if regulated voltages are measured line to line, otherwise they are
    measured line to ground.
    '''

    cellSize: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The size of the individual units that make up the bank.
    '''

    controlKind: Optional[ ShuntImpedanceControlKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of control (if any).
    '''

    highVoltageOverride: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    For locally controlled shunt impedances which have a voltage override feature,
    the high voltage override value. If the voltage is above this value, the
    shunt impedance will be turned off regardless of the other local controller
    settings.
    '''

    localControlKind: Optional[ ShuntImpedanceLocalControlKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of local controller.
    '''

    lowVoltageOverride: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    For locally controlled shunt impedances which have a voltage override feature,
    the low voltage override value. If the voltage is below this value, the
    shunt impedance will be turned on regardless of the other local controller
    settings.
    '''

    regBranchKind: Optional[ RegulationBranchKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (For VAR, amp, or power factor locally controlled shunt impedances) Kind
    of regulation branch.
    '''

    sensingPhaseCode: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phases that are measured for controlling the device.
    '''

    switchOperationCycle: Optional[ float | Hours ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Time interval between consecutive switching operations.
    '''

    ShuntCompensatorInfo: Optional[ShuntCompensatorInfo] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ShuntCompensatorInfo.ShuntCompensatorControl',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class TapChangerControl(RegulatingControl):
    '''
    Describes behavior specific to tap changers, e.g. how the voltage at the
    end of a line varies with the load level and compensation of the voltage
    drop by tap adjustment.
    '''

    lineDropCompensation: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true, the line drop compensation is to be applied.
    '''

    limitVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Maximum allowed regulated voltage on the PT secondary, regardless of line
    drop compensation. Sometimes referred to as first-house protection.
    '''

    lineDropR: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Line drop compensator resistance setting for normal (forward) power flow.
    '''

    lineDropX: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Line drop compensator reactance setting for normal (forward) power flow.
    '''

    reverseLineDropR: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Line drop compensator resistance setting for reverse power flow.
    '''

    reverseLineDropX: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Line drop compensator reactance setting for reverse power flow.
    '''

    TapChanger: list[TapChanger] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TapChanger.TapChangerControl',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The tap changers that participates in this regulating tap control scheme.
    '''

@dataclass(repr=False)
class RemoteUnit(PowerSystemResource):
    '''
    A remote unit can be a RTU, IED, substation control system, control center
    etc. The communication with the remote unit can be through various standard
    protocols (e.g. IEC 61870, IEC 61850) or non standard protocols (e.g. DNP,
    RP570 etc.). A remote unit contain remote data points that might be telemetered,
    collected or calculated. The RemoteUnit class inherit PowerSystemResource.
    The intention is to allow RemotUnits to have Measurements. These Measurements
    can be used to model unit status as operational, out of service, unit failure
    etc.
    '''

    remoteUnitType: Optional[ RemoteUnitType ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of remote unit.
    '''

    CommunicationLinks: list[CommunicationLink] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CommunicationLink.RemoteUnits',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    RTUs may be attached to communication links.
    '''

    RemotePoints: list[RemotePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RemotePoint.RemoteUnit',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Remote points this Remote unit contains.
    '''

@dataclass(repr=False)
class Reservoir(PowerSystemResource):
    '''
    A water storage facility within a hydro system, including: ponds, lakes,
    lagoons, and rivers. The storage is usually behind some type of dam.
    '''

    energyStorageRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reservoir's energy storage rating in energy for given head conditions.
    '''

    riverOutletWorks: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    River outlet works for riparian right releases or other purposes.
    '''

    spillwayCapacity: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The flow capacity of the spillway in cubic meters per second.
    '''

    spillWayGateType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of spillway gate, including parameters.
    '''

    activeStorageCapacity: Optional[ float | Volume ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Storage volume between the full supply level and the normal minimum operating
    level.
    '''

    fullSupplyLevel: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Full supply level, above which water will spill. This can be the spillway
    crest level or the top of closed gates.
    '''

    grossCapacity: Optional[ float | Volume ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Total capacity of reservoir.
    '''

    normalMinOperateLevel: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal minimum operating level below which the penstocks will draw air.
    '''

    spillTravelDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The spillway water travel delay to the next downstream reservoir.
    '''

    spillwayCrestLength: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The length of the spillway crest.
    '''

    spillwayCrestLevel: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Spillway crest level above which water will spill.
    '''

    HydroPowerPlants: list[HydroPowerPlant] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'HydroPowerPlant.Reservoir',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Generators discharge water to or pumps are supplied water from a downstream
    reservoir.
    '''

    SpillsFromReservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.SpillsIntoReservoirs',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A reservoir may spill into a downstream reservoir.
    '''

    TargetLevelSchedule: Optional[TargetLevelSchedule] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TargetLevelSchedule.Reservoir',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A reservoir may have a water level target schedule.
    '''

@dataclass(repr=False)
class ShuntCompensatorPhase(PowerSystemResource):
    '''
    Single phase of a multi-phase shunt compensator when its attributes might
    be different per phase.
    '''

    maximumSections: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum number of sections that may be switched in for this phase.
    '''

    normalSections: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    For the capacitor phase, the normal number of sections switched in.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase of this shunt compensator component. If the shunt compensator is
    wye connected, the connection is from the indicated phase to the central
    ground or neutral point. If the shunt compensator is delta connected, the
    phase indicates a shunt compensator connected from the indicated phase
    to the next logical non-neutral phase.
    '''

    ShuntCompensator: Optional[ShuntCompensator] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ShuntCompensator.ShuntCompensatorPhase',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Shunt compensator of this shunt compensator phase.
    '''

@dataclass(repr=False)
class LinearShuntCompensatorPhase(ShuntCompensatorPhase):
    '''
    A per phase linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    bPerSection: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Susceptance per section of the phase if shunt compensator is wye connected.
    Susceptance per section phase to phase if shunt compensator is delta connected.
    '''

    gPerSection: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Conductance per section for this phase if shunt compensator is wye connected.
    Conductance per section phase to phase if shunt compensator is delta connected.
    '''

@dataclass(repr=False)
class NonlinearShuntCompensatorPhase(ShuntCompensatorPhase):
    '''
    A per phase non linear shunt compensator has bank or section admittance
    values that differs.
    '''

    NonlinearShuntCompensatorPhasePoints: list[NonlinearShuntCompensatorPhasePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NonlinearShuntCompensatorPhasePoint.NonlinearShuntCompensatorPhase',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All points of the non-linear shunt compensator phase.
    '''

@dataclass(repr=False)
class SteamSupply(PowerSystemResource):
    '''
    Steam supply for steam turbine.
    '''

    steamSupplyRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rating of steam supply.
    '''

    SteamTurbines: list[SteamTurbine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SteamTurbine.SteamSupplys',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Steam turbines may have steam supplied by a steam supply.
    '''

@dataclass(repr=False)
class BWRSteamSupply(SteamSupply):
    '''
    Boiling water reactor used as a steam supply to a steam turbine.
    '''

    integralGain: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Integral gain.
    '''

    pressureSetpointGA: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pressure setpoint gain adjuster.
    '''

    proportionalGain: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Proportional gain.
    '''

    rodPatternConstant: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Constant associated with rod pattern.
    '''

    highPowerLimit: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    High power limit.
    '''

    inCoreThermalTC: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    In-core thermal time constant.
    '''

    lowerLimit: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Initial lower limit.
    '''

    lowPowerLimit: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Low power limit.
    '''

    pressureLimit: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pressure limit.
    '''

    pressureSetpointTC1: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pressure setpoint time constant.
    '''

    pressureSetpointTC2: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pressure setpoint time constant.
    '''

    rfAux1: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Coefficient for modeling the effect of off-nominal frequency and voltage
    on recirculation and core flow, which affects the BWR power output.
    '''

    rfAux2: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Coefficient for modeling the effect of off-nominal frequency and voltage
    on recirculation and core flow, which affects the BWR power output.
    '''

    rfAux3: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Coefficient for modeling the effect of off-nominal frequency and voltage
    on recirculation and core flow, which affects the BWR power output.
    '''

    rfAux4: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Coefficient for modeling the effect of off-nominal frequency and voltage
    on recirculation and core flow, which affects the BWR power output.
    '''

    rfAux5: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Coefficient for modeling the effect of off-nominal frequency and voltage
    on recirculation and core flow, which affects the BWR power output.
    '''

    rfAux6: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Coefficient for modeling the effect of off-nominal frequency and voltage
    on recirculation and core flow, which affects the BWR power output.
    '''

    rfAux7: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Coefficient for modeling the effect of off-nominal frequency and voltage
    on recirculation and core flow, which affects the BWR power output.
    '''

    rfAux8: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Coefficient for modeling the effect of off-nominal frequency and voltage
    on recirculation and core flow, which affects the BWR power output.
    '''

    rodPattern: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rod pattern.
    '''

    upperLimit: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Initial upper limit.
    '''

@dataclass(repr=False)
class FossilSteamSupply(SteamSupply):
    '''
    Fossil fueled boiler (e.g., coal, oil, gas).
    '''

    controlErrorBiasP: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power error bias ratio.
    '''

    controlIC: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Integral constant.
    '''

    controlPC: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Proportional constant.
    '''

    controlPEB: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pressure error bias ratio.
    '''

    controlTC: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Time constant.
    '''

    feedWaterIG: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Feedwater integral gain ratio.
    '''

    feedWaterPG: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Feedwater proportional gain ratio.
    '''

    maxErrorRateP: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power maximum error rate limit.
    '''

    minErrorRateP: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power minimum error rate limit.
    '''

    pressureCtrlDG: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pressure control derivative gain ratio.
    '''

    pressureCtrlIG: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pressure control integral gain ratio.
    '''

    pressureCtrlPG: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pressure control proportional gain ratio.
    '''

    pressureFeedback: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pressure feedback indicator.
    '''

    superHeater1Capacity: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Drum/primary superheater capacity.
    '''

    superHeater2Capacity: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Secondary superheater capacity.
    '''

    superHeaterPipePD: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Superheater pipe pressure drop constant.
    '''

    auxPowerVersusFrequency: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Off nominal frequency effect on auxiliary real power. Per unit active power
    variation versus per unit frequency variation.
    '''

    auxPowerVersusVoltage: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Off nominal voltage effect on auxiliary real power. Per unit active power
    variation versus per unit voltage variation.
    '''

    boilerControlMode: Optional[ BoilerControlMode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The control mode of the boiler.
    '''

    controlPED: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pressure error deadband.
    '''

    feedWaterTC: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Feedwater time constant rato.
    '''

    fuelDemandLimit: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fuel demand limit.
    '''

    fuelSupplyDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fuel delay.
    '''

    fuelSupplyTC: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fuel supply time constant.
    '''

    mechPowerSensorLag: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Mechanical power sensor lag.
    '''

    throttlePressureSP: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Throttle pressure setpoint.
    '''

@dataclass(repr=False)
class DrumBoiler(FossilSteamSupply):
    '''
    Drum boiler.
    '''

    drumBoilerRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rating of drum boiler in steam units.
    '''

@dataclass(repr=False)
class HeatRecoveryBoiler(FossilSteamSupply):
    '''
    The heat recovery system associated with combustion turbines in order to
    produce steam for combined cycle plants.
    '''

    steamSupplyRating2: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The steam supply rating in kilopounds per hour, if dual pressure boiler.
    '''

    CombustionTurbines: list[CombustionTurbine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CombustionTurbine.HeatRecoveryBoiler',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A combustion turbine may have a heat recovery boiler for making steam.
    '''

@dataclass(repr=False)
class Subcritical(FossilSteamSupply):
    '''
    Once-through subcritical boiler.
    '''

@dataclass(repr=False)
class Supercritical(FossilSteamSupply):
    '''
    Once-through supercritical boiler.
    '''

@dataclass(repr=False)
class PWRSteamSupply(SteamSupply):
    '''
    Pressurized water reactor used as a steam supply to a steam turbine.
    '''

    coldLegFBLagTC: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Cold leg feedback lag time constant.
    '''

    coldLegFBLeadTC1: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Cold leg feedback lead time constant.
    '''

    coldLegFBLeadTC2: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Cold leg feedback lead time constant.
    '''

    coldLegFG1: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Cold leg feedback gain 1.
    '''

    coldLegFG2: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Cold leg feedback gain 2.
    '''

    coldLegLagTC: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Cold leg lag time constant.
    '''

    coreHTLagTC1: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Core heat transfer lag time constant.
    '''

    coreHTLagTC2: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Core heat transfer lag time constant.
    '''

    coreNeutronicsEffTC: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Core neutronics effective time constant.
    '''

    coreNeutronicsHT: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Core neutronics and heat transfer.
    '''

    feedbackFactor: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Feedback factor.
    '''

    hotLegLagTC: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Hot leg lag time constant.
    '''

    hotLegSteamGain: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Hot leg steam gain.
    '''

    hotLegToColdLegGain: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Hot leg to cold leg gain.
    '''

    pressureCG: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pressure control gain.
    '''

    steamFlowFG: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Steam flow feedback gain.
    '''

    steamPressureDropLagTC: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Steam pressure drop lag time constant.
    '''

    steamPressureFG: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Steam pressure feedback gain.
    '''

    throttlePressureFactor: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Throttle pressure factor.
    '''

    throttlePressureSP: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Throttle pressure setpoint.
    '''

@dataclass(repr=False)
class SwitchPhase(PowerSystemResource):
    '''
    Single phase of a multi-phase switch when its attributes might be different
    per phase.
    '''

    closed: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The attribute tells if the switch is considered closed when used as input
    to topology processing.
    '''

    normalOpen: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Used in cases when no Measurement for the status value is present. If the
    SwitchPhase has a status measurement the Discrete.normalValue is expected
    to match with this value.
    '''

    phaseSide1: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase of this SwitchPhase on the side with terminal sequence number equal
    1. Should be a phase contained in that terminal&rsquo;s phases attribute.
    '''

    phaseSide2: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase of this SwitchPhase on the side with terminal sequence number equal
    2. Should be a phase contained in that terminal&rsquo;s Terminal.phases
    attribute.
    '''

    Switch: Optional[Switch] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Switch.SwitchPhase',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The switch of the switch phase.
    '''

@dataclass(repr=False)
class TapChanger(PowerSystemResource):
    '''
    Mechanism for changing transformer winding tap positions.
    '''

    controlEnabled: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Specifies the regulation status of the equipment. True is regulating, false
    is not regulating.
    '''

    highStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Highest possible tap step position, advance from neutral.
    The attribute shall be greater than lowStep.
    '''

    lowStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Lowest possible tap step position, retard from neutral
    '''

    ltcFlag: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Specifies whether or not a TapChanger has load tap changing capabilities.
    '''

    neutralStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The neutral tap step position for this winding.
    The attribute shall be equal or greater than lowStep and equal or less
    than highStep.
    '''

    normalStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The tap step position used in "normal" network operation for this winding.
    For a "Fixed" tap changer indicates the current physical tap setting.
    The attribute shall be equal or greater than lowStep and equal or less
    than highStep.
    '''

    step: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Tap changer position.
    Starting step for a steady state solution. Non integer values are allowed
    to support continuous tap variables. The reasons for continuous value are
    to support study cases where no discrete tap changers has yet been designed,
    a solutions where a narrow voltage band force the tap step to oscillate
    or accommodate for a continuous solution as input.
    The attribute shall be equal or greater than lowStep and equal or less
    than highStep.
    '''

    initialDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    For an LTC, the delay for initial tap changer operation (first step change)
    '''

    neutralU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Voltage at which the winding operates at the neutral tap setting.
    '''

    subsequentDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    For an LTC, the delay for subsequent tap changer operation (second and
    later step changes)
    '''

    SvTapStep: Optional[SvTapStep] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SvTapStep.TapChanger',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The tap step state associated with the tap changer.
    '''

    TapChangerControl: Optional[TapChangerControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TapChangerControl.TapChanger',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The regulating control scheme in which this tap changer participates.
    '''

    TapSchedules: list[TapSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TapSchedule.TapChanger',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A TapChanger can have TapSchedules.
    '''

@dataclass(repr=False)
class PhaseTapChanger(TapChanger):
    '''
    A transformer phase shifting tap model that controls the phase angle difference
    across the power transformer and potentially the active power flow through
    the power transformer. This phase tap model may also impact the voltage
    magnitude.
    '''

    TransformerEnd: Optional[TransformerEnd] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEnd.PhaseTapChanger',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer end to which this phase tap changer belongs.
    '''

@dataclass(repr=False)
class PhaseTapChangerLinear(PhaseTapChanger):
    '''
    Describes a tap changer with a linear relation between the tap step and
    the phase angle difference across the transformer. This is a mathematical
    model that is an approximation of a real phase tap changer.
    The phase angle is computed as stepPhaseShitfIncrement times the tap position.
    The secondary side voltage magnitude is the same as at the primary side.
    '''

    stepPhaseShiftIncrement: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase shift per step position. A positive value indicates a positive phase
    shift from the winding where the tap is located to the other winding (for
    a two-winding transformer).
    The actual phase shift increment might be more accurately computed from
    the symmetrical or asymmetrical models or a tap step table lookup if those
    are available.
    '''

    xMax: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reactance depend on the tap position according to a "u" shaped curve.
    The maximum reactance (xMax) appear at the low and high tap positions.
    '''

    xMin: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reactance depend on the tap position according to a "u" shaped curve.
    The minimum reactance (xMin) appear at the mid tap position.
    '''

@dataclass(repr=False)
class PhaseTapChangerNonLinear(PhaseTapChanger):
    '''
    The non-linear phase tap changer describes the non-linear behavior of a
    phase tap changer. This is a base class for the symmetrical and asymmetrical
    phase tap changer models. The details of these models can be found in the
    IEC 61970-301 document.
    '''

    voltageStepIncrement: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The voltage step increment on the out of phase winding specified in percent
    of nominal voltage of the transformer end.
    '''

    xMax: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reactance depend on the tap position according to a "u" shaped curve.
    The maximum reactance (xMax) appear at the low and high tap positions.
    '''

    xMin: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reactance depend on the tap position according to a "u" shaped curve.
    The minimum reactance (xMin) appear at the mid tap position.
    '''

@dataclass(repr=False)
class PhaseTapChangerAsymmetrical(PhaseTapChangerNonLinear):
    '''
    Describes the tap model for an asymmetrical phase shifting transformer
    in which the difference voltage vector adds to the primary side voltage.
    The angle between the primary side voltage and the difference voltage is
    named the winding connection angle. The phase shift depends on both the
    difference voltage magnitude and the winding connection angle.
    '''

    windingConnectionAngle: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The phase angle between the in-phase winding and the out-of -phase winding
    used for creating phase shift. The out-of-phase winding produces what is
    known as the difference voltage. Setting this angle to 90 degrees is not
    the same as a symmemtrical transformer.
    '''

@dataclass(repr=False)
class PhaseTapChangerSymmetrical(PhaseTapChangerNonLinear):
    '''
    Describes a symmetrical phase shifting transformer tap model in which the
    secondary side voltage magnitude is the same as at the primary side. The
    difference voltage magnitude is the base in an equal-sided triangle where
    the sides corresponds to the primary and secondary voltages. The phase
    angle difference corresponds to the top angle and can be expressed as twice
    the arctangent of half the total difference voltage.
    '''

@dataclass(repr=False)
class PhaseTapChangerTabular(PhaseTapChanger):
    '''
    '''

    PhaseTapChangerTable: Optional[PhaseTapChangerTable] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PhaseTapChangerTable.PhaseTapChangerTabular',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The phase tap changer table for this phase tap changer.
    '''

@dataclass(repr=False)
class RatioTapChanger(TapChanger):
    '''
    A tap changer that changes the voltage ratio impacting the voltage magnitude
    but not the phase angle across the transformer.
    '''

    stepVoltageIncrement: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Tap step increment, in per cent of nominal voltage, per step position.
    '''

    tculControlMode: Optional[ TransformerControlMode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Specifies the regulation control mode (voltage or reactive) of the RatioTapChanger.
    '''

    RatioTapChangerTable: Optional[RatioTapChangerTable] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RatioTapChangerTable.RatioTapChanger',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The tap ratio table for this ratio tap changer.
    '''

    TransformerEnd: Optional[TransformerEnd] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEnd.RatioTapChanger',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer end to which this ratio tap changer belongs.
    '''

@dataclass(repr=False)
class VoltageControlZone(PowerSystemResource):
    '''
    An area of the power system network which is defined for secondary voltage
    control purposes. A voltage control zone consists of a collection of substations
    with a designated bus bar section whose voltage will be controlled.
    '''

    BusbarSection: Optional[BusbarSection] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BusbarSection.VoltageControlZone',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''

    RegulationSchedule: Optional[RegulationSchedule] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RegulationSchedule.VoltageControlZones',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A VoltageControlZone may have a voltage regulation schedule.
    '''

@dataclass(repr=False)
class WeatherStation(PowerSystemResource):
    '''
    This represents a source of ambient temperature.
    '''

    Equipment: list[Equipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Equipment.WeatherStation',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class ProtectiveAction(IdentifiedObject):
    '''
    A protective action for supporting the integrity of the power system.
    '''

@dataclass(repr=False)
class ProtectiveActionAdjustment(ProtectiveAction):
    '''
    Protective actions on non-switching equipment. The operating condition
    is adjusted.
    '''

    byValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The adjustment is given in value of the active value.
    '''

    reduce: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true, the adjusted value is an reduction. Other wise it is an increase
    in the value.
    '''

    setValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The adjustment is given by a new active value.
    '''

    byPercentage: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The adjustment is given in percent of the active value.
    '''

    kind: Optional[ ProtectiveActionAdjustmentKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Defines the kind of adjustment that should be done. With this value the
    correct attribute containing the value needs to be used.
    '''

    ConductingEquipment: Optional[ConductingEquipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConductingEquipment.ProtectiveActionAdjustment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    DCConductingEquipment: Optional[DCConductingEquipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DCConductingEquipment.ProtectiveActionAdjustment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    Measurement: Optional[Measurement] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Measurement.ProtectiveActionAdjustment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class ProtectiveActionEquipment(ProtectiveAction):
    '''
    Protective action to put an Equipment in-service/out-of-service.
    '''

    inService: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true the equipment is put in-service, otherwise out-of-service.
    '''

    Equipment: Optional[Equipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Equipment.ProtectiveActionEquipment',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class ProtectiveActionRegulation(ProtectiveAction):
    '''
    Protective action to change regulation to Equipment.
    '''

    isRegulating: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true the regulator is put in-service, otherwise out-of-service (no regulation).
    '''

    targetValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The target value specified the new case input for the regulator. The value
    has the units appropriate to the mode attribute. The protective action
    does not change the mode attribute.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RegulatingControl.ProtectiveActionRegulation',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class RatioTapChangerTable(IdentifiedObject):
    '''
    Describes a curve for how the voltage magnitude and impedance varies with
    the tap step.
    '''

    RatioTapChanger: list[RatioTapChanger] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RatioTapChanger.RatioTapChangerTable',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The ratio tap changer of this tap ratio table.
    '''

    RatioTapChangerTablePoint: list[RatioTapChangerTablePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RatioTapChangerTablePoint.RatioTapChangerTable',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Points of this table.
    '''

@dataclass(repr=False)
class RecloseSequence(IdentifiedObject):
    '''
    A reclose sequence (open and close) is defined for each possible reclosure
    of a breaker.
    '''

    recloseStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates the ordinal position of the reclose step relative to other steps
    in the sequence.
    '''

    recloseDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Indicates the time lapse before the reclose step will execute a reclose.
    '''

    ProtectedSwitch: Optional[ProtectedSwitch] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ProtectedSwitch.RecloseSequences',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A breaker may have zero or more automatic reclosures after a trip occurs.
    '''

@dataclass(repr=False)
class RemotePoint(IdentifiedObject):
    '''
    For a RTU remote points correspond to telemetered values or control outputs.
    Other units (e.g. control centers) usually also contain calculated values.
    '''

    RemoteUnit: Optional[RemoteUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RemoteUnit.RemotePoints',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Remote unit this point belongs to.
    '''

@dataclass(repr=False)
class RemoteControl(RemotePoint):
    '''
    Remote controls are ouputs that are sent by the remote unit to actuators
    in the process.
    '''

    actuatorMaximum: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum set point value accepted by the remote control point.
    '''

    actuatorMinimum: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum set point value accepted by the remote control point.
    '''

    remoteControlled: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Set to true if the actuator is remotely controlled.
    '''

    Control: Optional[Control] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Control.RemoteControl',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The Control for the RemoteControl point.
    '''

@dataclass(repr=False)
class RemoteSource(RemotePoint):
    '''
    Remote sources are state variables that are telemetered or calculated within
    the remote unit.
    '''

    deadband: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The smallest change in value to be reported.
    '''

    sensorMaximum: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The maximum value the telemetry item can return.
    '''

    sensorMinimum: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum value the telemetry item can return.
    '''

    scanInterval: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The time interval between scans.
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'MeasurementValue.RemoteSource',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Link to the physical telemetered point associated with this measurement.
    '''

@dataclass(repr=False)
class ReportingGroup(IdentifiedObject):
    '''
    A reporting group is used for various ad-hoc groupings used for reporting.
    '''

    BusNameMarker: list[BusNameMarker] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'BusNameMarker.ReportingGroup',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The bus name markers that belong to this reporting group.
    '''

    PowerSystemResource: list[PowerSystemResource] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerSystemResource.ReportingGroup',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Power system resources which belong to this reporting group.
    '''

    ReportingSuperGroup: Optional[ReportingSuperGroup] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReportingSuperGroup.ReportingGroup',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reporting super group to which this reporting group belongs.
    '''

    TopologicalNode: list[TopologicalNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TopologicalNode.ReportingGroup',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The topological nodes that belong to the reporting group.
    '''

@dataclass(repr=False)
class ReportingSuperGroup(IdentifiedObject):
    '''
    A reporting super group, groups reporting groups for a higher level report.
    '''

    ReportingGroup: list[ReportingGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ReportingGroup.ReportingSuperGroup',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reporting groups that are grouped under this super group.
    '''

@dataclass(repr=False)
class ScheduledEvent(IdentifiedObject):
    '''
    An event to trigger one or more activities, such as reading a meter, recalculating
    a bill, requesting work, when generating units must be scheduled for maintenance,
    when a transformer is scheduled to be refurbished, etc.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of scheduled event.
    '''

    duration: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Duration of the scheduled event, for example, the time to ramp between
    values.
    '''

    ScheduledEventData: Optional[ScheduledEventData] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ScheduledEventData.ScheduledEvents',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Specification for this scheduled event.
    '''

@dataclass(repr=False)
class Seal(IdentifiedObject):
    '''
    Physically controls access to AssetContainers.
    '''

    appliedDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date and time this seal has been applied.
    '''

    sealNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (reserved word) Seal number.
    '''

    condition: Optional[ SealConditionKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Condition of seal.
    '''

    kind: Optional[ SealKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of seal.
    '''

    AssetContainer: Optional[AssetContainer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetContainer.Seals',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Asset container to which this seal is applied.
    '''

@dataclass(repr=False)
class Season(IdentifiedObject):
    '''
    A specified time period of the year.
    '''

    endDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date season ends.
    '''

    startDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date season starts.
    '''

@dataclass(repr=False)
class ServiceCategory(IdentifiedObject):
    '''
    Category of service provided to the customer.
    '''

    kind: Optional[ ServiceKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of service.
    '''

@dataclass(repr=False)
class StartupModel(IdentifiedObject):
    '''
    Unit start up characteristics depending on how long the unit has been off
    line.
    '''

    startupDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The date and time of the most recent generating unit startup.
    '''

    startupPriority: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Startup priority within control area where lower numbers indicate higher
    priorities. More than one unit in an area may be assigned the same priority.
    '''

    fixedMaintCost: Optional[ float | CostRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Fixed maintenance cost.
    '''

    hotStandbyHeat: Optional[ float | HeatRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The amount of heat input per time uint required for hot standby operation.
    '''

    incrementalMaintCost: Optional[ float | CostPerEnergyUnit ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Incremental maintenance cost.
    '''

    minimumDownTime: Optional[ float | Hours ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum number of hours the unit must be down before restart.
    '''

    minimumRunTime: Optional[ float | Hours ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The minimum number of hours the unit must be operating before being allowed
    to shut down.
    '''

    riskFactorCost: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The opportunity cost associated with the return in monetary unit. This
    represents the restart's "share" of the unit depreciation and risk of an
    event which would damage the unit.
    '''

    startupCost: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Total miscellaneous start up costs.
    '''

    stbyAuxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit's auxiliary active power consumption to maintain standby mode.
    '''

    StartIgnFuelCurve: Optional[StartIgnFuelCurve] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartIgnFuelCurve.StartupModel',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''

    StartMainFuelCurve: Optional[StartMainFuelCurve] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartMainFuelCurve.StartupModel',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''

    StartRampCurve: Optional[StartRampCurve] = field(
        default = None,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartRampCurve.StartupModel',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.StartupModel',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A thermal generating unit may have a startup model.
    '''

@dataclass(repr=False)
class StaticVarCompensatorDynamics(IdentifiedObject):
    '''
    Static var compensator whose behaviour is described by reference to a standard
    model <font color="#0f0f0f">or by definition of a user-defined model.</font>
    '''

    StaticVarCompensator: Optional[StaticVarCompensator] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StaticVarCompensator.StaticVarCompensatorDynamics',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Static Var Compensator to which Static Var Compensator dynamics model applies.
    '''

@dataclass(repr=False)
class SubGeographicalRegion(IdentifiedObject):
    '''
    A subset of a geographical region of a power system network model.
    '''

    DCLines: list[DCLine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DCLine.Region',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The DC lines in this sub-geographical region.
    '''

    Lines: list[Line] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Line.Region',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The lines within the sub-geographical region.
    '''

    Region: Optional[GeographicalRegion] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeographicalRegion.Regions',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The geographical region to which this sub-geographical region is within.
    '''

    Substations: list[Substation] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Substation.Region',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The substations in this sub-geographical region.
    '''

@dataclass(repr=False)
class SynchronousMachineDynamics(IdentifiedObject):
    '''
    Synchronous machine whose behaviour is described by reference to a standard
    model expressed in one of the following forms:
    - simplified (or classical), where a group of generators or motors is not
    modelled in detail;
    - detailed, in equivalent circuit form;
    - detailed, in time constant reactance form; or
    <font color="#0f0f0f">- by definition of a user-defined model.</font>
    <font color="#0f0f0f">It is a common practice to represent small generators
    by a negative load rather than by a dynamic generator model when performing
    dynamics simulations. In this case, a SynchronousMachine in the static
    model is not represented by anything in the dynamics model, instead it
    is treated as an ordinary load.</font>
    <font color="#0f0f0f">Parameter details:</font>
    <ol>
    <li><font color="#0f0f0f">Synchronous machine parameters such as <i>Xl,
    Xd, Xp</i> etc. are actually used as inductances in the models,</font>
    but are commonly referred to as reactances since, at nominal frequency,
    the PU values are the same. However, some references use the symbol <i>L</i>
    instead of <i>X</i>.</li>
    </ol>
    '''

@dataclass(repr=False)
class TimePoint(IdentifiedObject):
    '''
    A point in time within a sequence of points in time relative to a time
    schedule.
    '''

    dateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Absolute date and time for this time point. For calendar-based time point,
    it is typically manually entered, while for interval-based or sequence-based
    time point it is derived.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if sequence-based) Relative sequence number for this time point.
    '''

    relativeTimeInterval: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if interval-based) A point in time relative to scheduled start time in
    'TimeSchedule.scheduleInterval.start'.
    '''

    TimeSchedule: Optional[TimeSchedule] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TimeSchedule.TimePoints',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Time schedule owning this time point.
    '''

@dataclass(repr=False)
class TopologicalIsland(IdentifiedObject):
    '''
    An electrically connected subset of the network. Topological islands can
    change as the current network state changes: e.g. due to
    - disconnect switches or breakers change state in a SCADA/EMS
    - manual creation, change or deletion of topological nodes in a planning
    tool.
    '''

    AngleRefTopologicalNode: Optional[TopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalNode.AngleRefTopologicalIsland',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The angle reference for the island. Normally there is one TopologicalNode
    that is selected as the angle reference for each island. Other reference
    schemes exist, so the association is typically optional.
    '''

    TopologicalNodes: list[TopologicalNode] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TopologicalNode.TopologicalIsland',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A topological node belongs to a topological island.
    '''

@dataclass(repr=False)
class TopologicalNode(IdentifiedObject):
    '''
    For a detailed substation model a topological node is a set of connectivity
    nodes that, in the current network state, are connected together through
    any type of closed switches, including jumpers. Topological nodes change
    as the current network state changes (i.e., switches, breakers, etc. change
    state).
    For a planning model, switch statuses are not used to form topological
    nodes. Instead they are manually created or deleted in a model builder
    tool. Topological nodes maintained this way are also called "busses".
    '''

    pInjection: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The active power injected into the bus at this location in addition to
    injections from equipment. Positive sign means injection into the TopologicalNode
    (bus).
    Starting value for a steady state solution.
    '''

    qInjection: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reactive power injected into the bus at this location in addition to
    injections from equipment. Positive sign means injection into the TopologicalNode
    (bus).
    Starting value for a steady state solution.
    '''

    AngleRefTopologicalIsland: Optional[TopologicalIsland] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalIsland.AngleRefTopologicalNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The island for which the node is an angle reference. Normally there is
    one angle reference node for each island.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BaseVoltage.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The base voltage of the topologocial node.
    '''

    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConnectivityNodeContainer.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The connectivity node container to which the toplogical node belongs.
    '''

    ConnectivityNodes: list[ConnectivityNode] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConnectivityNode.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The connectivity nodes combined together to form this topological node.
    May depend on the current state of switches in the network.
    '''

    ReportingGroup: Optional[ReportingGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReportingGroup.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reporting group to which the topological node belongs.
    '''

    SvInjection: Optional[SvInjection] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SvInjection.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The injection flows state variables associated with the topological node.
    '''

    SvVoltage: Optional[SvVoltage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SvVoltage.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The state voltage associated with the topological node.
    '''

    Terminal: list[Terminal] = field(
        default_factory = list,
        metadata = {
            'type': 'AggregateOf',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Terminal.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The terminals associated with the topological node. This can be used as
    an alternative to the connectivity node path to terminal, thus making it
    unneccesary to model connectivity nodes in some cases. Note that if connectivity
    nodes are in the model, this association would probably not be used as
    an input specification.
    '''

    TopologicalIsland: Optional[TopologicalIsland] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalIsland.TopologicalNodes',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A topological node belongs to a topological island.
    '''

@dataclass(repr=False)
class Transaction(IdentifiedObject):
    '''
    The record of details of payment for service or token sale.
    '''

@dataclass(repr=False)
class TransformerCoreAdmittance(IdentifiedObject):
    '''
    The transformer core admittance. Used to specify the core admittance of
    a transformer in a manner that can be shared among power transformers.
    '''

    b: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Magnetizing branch susceptance (B mag). The value can be positive or negative.
    '''

    b0: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence magnetizing branch susceptance.
    '''

    g: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Magnetizing branch conductance (G mag).
    '''

    g0: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence magnetizing branch conductance.
    '''

    TransformerEnd: list[TransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEnd.CoreAdmittance',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All transformer ends having this core admittance.
    '''

    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.CoreAdmittance',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer end datasheet used to calculate this core admittance.
    '''

@dataclass(repr=False)
class TransformerEnd(IdentifiedObject):
    '''
    A conducting connection point of a power transformer. It corresponds to
    a physical transformer winding terminal. In earlier CIM versions, the TransformerWinding
    class served a similar purpose, but this class is more flexible because
    it associates to terminal but is not a specialization of ConductingEquipment.
    '''

    endNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Number for this transformer end, corresponding to the end's order in the
    power transformer vector group or phase angle clock number. Highest voltage
    winding should be 1. Each end within a power transformer should have a
    unique subsequent end number. Note the transformer end number need not
    match the terminal sequence number.
    '''

    grounded: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (for Yn and Zn connections) True if the neutral is solidly grounded.
    '''

    bmagSat: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Core shunt magnetizing susceptance in the saturation region.
    '''

    magBaseU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reference voltage at which the magnetizing saturation measurements
    were made
    '''

    magSatFlux: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Core magnetizing saturation curve knee flux level.
    '''

    rground: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (for Yn and Zn connections) Resistance part of neutral impedance where
    'grounded' is true.
    '''

    xground: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (for Yn and Zn connections) Reactive part of neutral impedance where 'grounded'
    is true.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BaseVoltage.TransformerEnds',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Base voltage of the transformer end. This is essential for PU calculation.
    '''

    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerCoreAdmittance.TransformerEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Core admittance of this transformer end, representing magnetising current
    and core losses. The full values of the transformer should be supplied
    for one transformer end only.
    '''

    FromMeshImpedance: list[TransformerMeshImpedance] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerMeshImpedance.FromTransformerEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All mesh impedances between this 'to' and other 'from' transformer ends.
    '''

    FromWindingInsulations: list[WindingInsulation] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WindingInsulation.FromWinding',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    PhaseTapChanger: Optional[PhaseTapChanger] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PhaseTapChanger.TransformerEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase tap changer associated with this transformer end.
    '''

    RatioTapChanger: Optional[RatioTapChanger] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RatioTapChanger.TransformerEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Ratio tap changer associated with this transformer end.
    '''

    StarImpedance: Optional[TransformerStarImpedance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerStarImpedance.TransformerEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (accurate for 2- or 3-winding transformers only) Pi-model impedances of
    this transformer end. By convention, for a two winding transformer, the
    full values of the transformer should be entered on the high voltage end
    (endNumber=1).
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.TransformerEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Terminal of the power transformer to which this transformer end belongs.
    '''

    ToMeshImpedance: list[TransformerMeshImpedance] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerMeshImpedance.ToTransformerEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All mesh impedances between this 'from' and other 'to' transformer ends.
    '''

    ToWindingInsulations: list[WindingInsulation] = field(
        default_factory = list,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WindingInsulation.ToWinding',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class PowerTransformerEnd(TransformerEnd):
    '''
    A PowerTransformerEnd is associated with each Terminal of a PowerTransformer.
    The impedance values r, r0, x, and x0 of a PowerTransformerEnd represents
    a star equivalent as follows
    1) for a two Terminal PowerTransformer the high voltage (TransformerEnd.endNumber=1)
    PowerTransformerEnd has non zero values on r, r0, x, and x0 while the low
    voltage (TransformerEnd.endNumber=0) PowerTransformerEnd has zero values
    for r, r0, x, and x0.
    2) for a three Terminal PowerTransformer the three PowerTransformerEnds
    represents a star equivalent with each leg in the star represented by r,
    r0, x, and x0 values.
    3) For a three Terminal transformer each PowerTransformerEnd shall have
    g, g0, b and b0 values corresponding the no load losses distributed on
    the three PowerTransformerEnds. The total no load loss shunt impedances
    may also be placed at one of the PowerTransformerEnds, preferably the end
    numbered 1, having the shunt values on end 1 is the preferred way.
    4) for a PowerTransformer with more than three Terminals the PowerTransformerEnd
    impedance values cannot be used. Instead use the TransformerMeshImpedance
    or split the transformer into multiple PowerTransformers.
    '''

    phaseAngleClock: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Terminal voltage phase angle displacement where 360 degrees are represented
    with clock hours. The valid values are 0 to 11. For example, for the secondary
    side end of a transformer with vector group code of 'Dyn11', specify the
    connection kind as wye with neutral and specify the phase angle of the
    clock as 11. The clock value of the transformer end number specified as
    1, is assumed to be zero. Note the transformer end number is not assumed
    to be the same as the terminal sequence number.
    '''

    b: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Magnetizing branch susceptance (B mag). The value can be positive or negative.
    '''

    b0: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence magnetizing branch susceptance.
    '''

    connectionKind: Optional[ WindingConnection ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Kind of connection.
    '''

    g: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Magnetizing branch conductance.
    '''

    g0: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence magnetizing branch conductance (star-model).
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Resistance (star-model) of the transformer end.
    The attribute shall be equal or greater than zero for non-equivalent transformers.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series resistance (star-model) of the transformer end.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Normal apparent power rating.
    The attribute shall be a positive value. For a two-winding transformer
    the values for the high and low voltage sides shall be identical.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Rated voltage: phase-phase for three-phase windings, and either phase-phase
    or phase-neutral for single-phase windings.
    A high voltage side, as given by TransformerEnd.endNumber, shall have a
    ratedU that is greater or equal than ratedU for the lower voltage sides.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series reactance (star-model) of the transformer end.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series reactance of the transformer end.
    '''

    PowerTransformer: Optional[PowerTransformer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerTransformer.PowerTransformerEnd',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The power transformer of this power transformer end.
    '''

@dataclass(repr=False)
class TransformerTankEnd(TransformerEnd):
    '''
    Transformer tank end represents an individual winding for unbalanced models
    or for transformer tanks connected into a bank (and bank is modelled with
    the PowerTransformer).
    '''

    phases: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Describes the phases carried by a conducting equipment.
    '''

    TransformerTank: Optional[TransformerTank] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerTank.TransformerTankEnds',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer this winding belongs to.
    '''

@dataclass(repr=False)
class TransformerMeshImpedance(IdentifiedObject):
    '''
    Transformer mesh impedance (Delta-model) between transformer ends.
    The typical case is that this class describes the impedance between two
    transformer ends pair-wise, i.e. the cardinalities at both tranformer end
    associations are 1. But in cases where two or more transformer ends are
    modeled the cardinalities are larger than 1.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Resistance between the 'from' and the 'to' end, seen from the 'from' end.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero-sequence resistance between the 'from' and the 'to' end, seen from
    the 'from' end.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactance between the 'from' and the 'to' end, seen from the 'from' end.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero-sequence reactance between the 'from' and the 'to' end, seen from
    the 'from' end.
    '''

    FromTransformerEnd: Optional[TransformerEnd] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEnd.FromMeshImpedance',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    From end this mesh impedance is connected to. It determines the voltage
    reference.
    '''

    FromTransformerEndInfo: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.FromMeshImpedances',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    'from' transformer end datasheet this mesh impedance is calculated from.
    It determines the voltage reference.
    '''

    ToTransformerEnd: list[TransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEnd.ToMeshImpedance',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All transformer ends this mesh impedance is connected to.
    '''

    ToTransformerEndInfos: list[TransformerEndInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEndInfo.ToMeshImpedances',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All 'to' transformer end datasheets this mesh impedance for 'from' transformer
    end is calculated from.
    '''

@dataclass(repr=False)
class TransformerObservation(IdentifiedObject):
    '''
    Common information captured during transformer inspections and/or diagnostics.
    Note that some properties may be measured through other means and therefore
    have measurement values in addition to the observed values recorded here.
    '''

    dga: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Dissolved Gas Analysis. Typical values are: Acceptable, Overheating, Corona,
    Sparking, Arcing.
    '''

    freqResp: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Frequency Response Analysis. Typical values are: acceptable, slight movement,
    significant movement, failed, near failure. A graphic of the response diagram,
    which is a type of document, may be associated with this analysis through
    the recursive document relationship of the ProcedureDataSet.
    '''

    furfuralDP: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Overall measure of furfural in oil and mechanical strength of paper. DP,
    the degree of polymerization, is the strength of the paper. Furfural is
    a measure of furfural compounds, often expressed in parts per million.
    '''

    oilColor: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Oil Quality Analysis-Color.
    '''

    oilIFT: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Oil Quality Analysis- inter facial tension (IFT) - number-Dynes/CM.
    '''

    oilLevel: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The level of oil in the transformer.
    '''

    oilNeutralizationNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Oil Quality Analysis-Neutralization Number - Number - Mg KOH.
    '''

    pumpVibration: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pump vibration, with typical values being: nominal, high.
    '''

    waterContent: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Water Content expressed in parts per million.
    '''

    bushingTemp: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Bushing temperature.
    '''

    hotSpotTemp: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Hotspot oil temperature.
    '''

    oilDielectricStrength: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Oil Quality Analysis-Dielectric Strength.
    '''

    topOilTemp: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Top oil temperature.
    '''

    Transformer: Optional[TransformerTank] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerTank.TransformerObservations',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class TransformerStarImpedance(IdentifiedObject):
    '''
    Transformer star impedance (Pi-model) that accurately reflects impedance
    for transformers with 2 or 3 windings. For transformers with 4 or more
    windings, you must use TransformerMeshImpedance class.
    For transmission networks use PowerTransformerEnd impedances (r, r0, x,
    x0, b, b0, g and g0).
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Resistance of the transformer end.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series resistance of the transformer end.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence series reactance of the transformer end.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence series reactance of the transformer end.
    '''

    TransformerEnd: list[TransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEnd.StarImpedance',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All transformer ends having this star impedance.
    '''

    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.TransformerStarImpedance',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer end datasheet used to calculate this transformer star impedance.
    '''

@dataclass(repr=False)
class TransformerTest(IdentifiedObject):
    '''
    Test result for transformer ends, such as short-circuit, open-circuit (excitation)
    or no-load test.
    '''

    basePower: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Base power at which the tests are conducted, usually equal to the rateds
    of one of the involved transformer ends.
    '''

    temperature: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Temperature at which the test is conducted.
    '''

@dataclass(repr=False)
class NoLoadTest(TransformerTest):
    '''
    No-load test results determine core admittance parameters. They include
    exciting current and core loss measurements from applying voltage to one
    winding. The excitation may be positive sequence or zero sequence. The
    test may be repeated at different voltages to measure saturation.
    '''

    energisedEndVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Voltage applied to the winding (end) during test.
    '''

    excitingCurrent: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Exciting current measured from a positive-sequence or single-phase excitation
    test.
    '''

    excitingCurrentZero: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Exciting current measured from a zero-sequence open-circuit excitation
    test.
    '''

    loss: Optional[ float | KiloActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Losses measured from a positive-sequence or single-phase excitation test.
    '''

    lossZero: Optional[ float | KiloActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Losses measured from a zero-sequence excitation test.
    '''

    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.EnergisedEndNoLoadTests',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer end that current is applied to in this no-load test.
    '''

@dataclass(repr=False)
class OpenCircuitTest(TransformerTest):
    '''
    Open-circuit test results verify winding turn ratios and phase shifts.
    They include induced voltage and phase shift measurements on open-circuit
    windings, with voltage applied to the energised end. For three-phase windings,
    the excitation can be a positive sequence (the default) or a zero sequence.
    '''

    energisedEndStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Tap step number for the energised end of the test pair.
    '''

    openEndStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Tap step number for the open end of the test pair.
    '''

    energisedEndVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Voltage applied to the winding (end) during test.
    '''

    openEndVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Voltage measured at the open-circuited end, with the energised end set
    to rated voltage and all other ends open.
    '''

    phaseShift: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase shift measured at the open end with the energised end set to rated
    voltage and all other ends open.
    '''

    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.EnergisedEndOpenCircuitTests',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer end that current is applied to in this open-circuit test.
    '''

    OpenEnd: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.OpenEndOpenCircuitTests',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer end measured for induced voltage and angle in this open-circuit
    test.
    '''

@dataclass(repr=False)
class ShortCircuitTest(TransformerTest):
    '''
    Short-circuit test results determine mesh impedance parameters. They include
    load losses and leakage impedances. For three-phase windings, the excitation
    can be a positive sequence (the default) or a zero sequence. There shall
    be at least one grounded winding.
    '''

    energisedEndStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Tap step number for the energised end of the test pair.
    '''

    groundedEndStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Tap step number for the grounded end of the test pair.
    '''

    leakageImpedance: Optional[ float | Impedance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Leakage impedance measured from a positive-sequence or single-phase short-circuit
    test.
    '''

    leakageImpedanceZero: Optional[ float | Impedance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Leakage impedance measured from a zero-sequence short-circuit test.
    '''

    loss: Optional[ float | KiloActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Load losses from a positive-sequence or single-phase short-circuit test.
    '''

    lossZero: Optional[ float | KiloActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Load losses from a zero-sequence short-circuit test.
    '''

    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.EnergisedEndShortCircuitTests',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transformer end that voltage is applied to in this short-circuit test.
    The test voltage is chosen to induce rated current in the energised end.
    '''

    GroundedEnds: list[TransformerEndInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEndInfo.GroundedEndShortCircuitTests',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All ends short-circuited in this short-circuit test.
    '''

@dataclass(repr=False)
class UsagePoint(IdentifiedObject):
    '''
    Logical or physical point in the network to which readings or events may
    be attributed. Used at the place where a physical or virtual meter may
    be located; however, it is not required that a meter be present.
    '''

    checkBilling: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if as a result of an inspection or otherwise, there is a reason to
    suspect that a previous billing may have been performed with erroneous
    data. Value should be reset once this potential discrepancy has been resolved.
    '''

    grounded: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if grounded.
    '''

    isSdp: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true, this usage point is a service delivery point, i.e., a usage point
    where the ownership of the service changes hands.
    '''

    isVirtual: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true, this usage point is virtual, i.e., no physical location exists
    in the network where a meter could be located to collect the meter readings.
    For example, one may define a virtual usage point to serve as an aggregation
    of usage for all of a company's premises distributed widely across the
    distribution territory. Otherwise, the usage point is physical, i.e., there
    is a logical point in the network where a meter could be located to collect
    meter readings.
    '''

    minimalUsageExpected: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    If true, minimal or zero usage is expected at this usage point for situations
    such as premises vacancy, logical or physical disconnect. It is used for
    readings validation and estimation.
    '''

    outageRegion: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Outage region in which this usage point is located.
    '''

    readCycle: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Cycle day on which the meter for this usage point will normally be read.
    Usually correlated with the billing cycle.
    '''

    readRoute: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Identifier of the route to which this usage point is assigned for purposes
    of meter reading. Typically used to configure hand held meter reading systems
    prior to collection of reads.
    '''

    serviceDeliveryRemark: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Remarks about this usage point, for example the reason for it being rated
    with a non-nominal priority.
    '''

    servicePriority: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Priority of service for this usage point. Note that usage points at the
    same service location can have different priorities.
    '''

    amiBillingReady: Optional[ AmiBillingReadyKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Tracks the lifecycle of the metering installation at a usage point with
    respect to readiness for billing via advanced metering infrastructure reads.
    '''

    connectionState: Optional[ UsagePointConnectedKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    State of the usage point with respect to connection to the network.
    '''

    estimatedLoad: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Estimated load.
    '''

    nominalServiceVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Nominal service voltage.
    '''

    phaseCode: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Phase code. Number of wires and specific nominal phases can be deduced
    from enumeration literal values. For example, ABCN is three-phase, four-wire,
    s12n (splitSecondary12N) is single-phase, three-wire, and s1n and s2n are
    single-phase, two-wire.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Current flow that this usage point is configured to deliver.
    '''

    ratedPower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Active power that this usage point is configured to deliver.
    '''

    Equipments: list[Equipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Equipment.UsagePoints',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All equipment connecting this usage point to the electrical grid.
    '''

@dataclass(repr=False)
class VSCDynamics(IdentifiedObject):
    '''
    VSC function block whose behaviour is described by reference to a standard
    model <font color="#0f0f0f">or by definition of a user-defined model.</font>
    '''

@dataclass(repr=False)
class ValueAliasSet(IdentifiedObject):
    '''
    Describes the translation of a set of values into a name and is intendend
    to facilitate cusom translations. Each ValueAliasSet has a name, description
    etc. A specific Measurement may represent a discrete state like Open, Closed,
    Intermediate etc. This requires a translation from the MeasurementValue.value
    number to a string, e.g. 0-&gt;"Invalid", 1-&gt;"Open", 2-&gt;"Closed",
    3-&gt;"Intermediate". Each ValueToAlias member in ValueAliasSet.Value describe
    a mapping for one particular value to a name.
    '''

@dataclass(repr=False)
class ValueToAlias(IdentifiedObject):
    '''
    Describes the translation of one particular value into a name, e.g. 1 as
    "Open".
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The value that is mapped.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ValueAliasSet.Values',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The ValueAliasSet having the ValueToAlias mappings.
    '''

@dataclass(repr=False)
class VisibilityLayer(IdentifiedObject):
    '''
    Layers are typically used for grouping diagram objects according to themes
    and scales. Themes are used to display or hide certain information (e.g.,
    lakes, borders), while scales are used for hiding or displaying information
    depending on the current zoom level (hide text when it is too small to
    be read, or when it exceeds the screen size). This is also called de-cluttering.
    CIM based graphics exchange will support an m:n relationship between diagram
    objects and layers. It will be the task of the importing system to convert
    an m:n case into an appropriate 1:n representation if the importing system
    does not support m:n.
    '''

    drawingOrder: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The drawing order for this layer. The higher the number, the later the
    layer and the objects within it are rendered.
    '''

    VisibleObjects: list[DiagramObject] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DiagramObject.VisibilityLayers',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A visibility layer can contain one or more diagram objects.
    '''

@dataclass(repr=False)
class WindTurbineType3or4Dynamics(IdentifiedObject):
    '''
    Parent class supporting relationships to wind turbines type 3 and type
    4 and wind plant including their control models.
    '''

    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerElectronicsConnection.WindTurbineType3or4Dynamics',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The power electronics connection associated with this wind turbine type
    3 or type 4 dynamics model.
    '''

@dataclass(repr=False)
class WindingInsulation(IdentifiedObject):
    '''
    Winding insulation condition as a result of a test.
    '''

@dataclass(repr=False)
class WirePosition(IdentifiedObject):
    '''
    Identification, spacing and configuration of the wires of a conductor with
    respect to a structure.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Single phase or neutral designation for the wire with this position.
    '''

    xCoord: Optional[ float | Displacement ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Signed horizontal distance from the wire at this position to a common reference
    point.
    '''

    yCoord: Optional[ float | Displacement ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Signed vertical distance from the wire at this position: above ground (positive
    value) or burial depth below ground (negative value).
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WireSpacingInfo.WirePositions',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Wire spacing data this wire position belongs to.
    '''

@dataclass(repr=False)
class IrregularTimePoint(Identity):
    '''
    TimePoints for a schedule where the time between the points varies.
    '''

    value1: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The first value at the time. The meaning of the value is defined by the
    derived type of the associated schedule.
    '''

    value2: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The second value at the time. The meaning of the value is defined by the
    derived type of the associated schedule.
    '''

    time: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The time is relative to the schedule starting time.
    '''

    IntervalSchedule: Optional[IrregularIntervalSchedule] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IrregularIntervalSchedule.TimePoints',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    An IrregularTimePoint belongs to an IrregularIntervalSchedule.
    '''

@dataclass(repr=False)
class Name(Identity):
    '''
    The Name class provides the means to define any number of human readable
    names for an object. A name is <b>not</b> to be used for defining inter-object
    relationships. For inter-object relationships instead use the object identification
    'mRID'.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Any free text that name the object.
    '''

    IdentifiedObject: Optional[IdentifiedObject] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IdentifiedObject.Names',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Identified object that this name designates.
    '''

    NameType: Optional[NameType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NameType.Names',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of this name.
    '''

@dataclass(repr=False)
class NameType(Identity):
    '''
    Type of name. Possible values for attribute 'name' are implementation dependent
    but standard profiles may specify types. An enterprise may have multiple
    IT systems each having its own local name for the same object, e.g. a planning
    system may have different names from an EMS. An object may also have different
    names within the same IT system, e.g. localName as defined in CIM version
    14. The definition from CIM14 is:
    The localName is a human readable name of the object. It is a free text
    name local to a node in a naming hierarchy similar to a file directory
    structure. A power system related naming hierarchy may be: Substation,
    VoltageLevel, Equipment etc. Children of the same parent in such a hierarchy
    have names that typically are unique among them.
    '''

    description: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Description of the name type.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Name of the name type.
    '''

    Names: list[Name] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Name.NameType',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All names of this type.
    '''

    NameTypeAuthority: Optional[NameTypeAuthority] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NameTypeAuthority.NameTypes',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Authority responsible for managing names of this type.
    '''

@dataclass(repr=False)
class NameTypeAuthority(Identity):
    '''
    Authority responsible for creation and management of names of a given type;
    typically an organization or an enterprise system.
    '''

    description: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Description of the name type authority.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Name of the name type authority.
    '''

    NameTypes: list[NameType] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NameType.NameTypeAuthority',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All name types managed by this authority.
    '''

@dataclass(repr=False)
class NonlinearShuntCompensatorPhasePoint(Identity):
    '''
    A per phase non linear shunt compensator bank or section admittance value.
    '''

    sectionNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The number of the section.
    '''

    b: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt (charging) susceptance per section
    '''

    g: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt (charging) conductance per section
    '''

    NonlinearShuntCompensatorPhase: Optional[NonlinearShuntCompensatorPhase] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NonlinearShuntCompensatorPhase.NonlinearShuntCompensatorPhasePoints',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Non-linear shunt compensator phase owning this point.
    '''

@dataclass(repr=False)
class NonlinearShuntCompensatorPoint(Identity):
    '''
    A non linear shunt compensator bank or section admittance value.
    '''

    sectionNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The number of the section.
    '''

    b: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt (charging) susceptance per section
    '''

    b0: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence shunt (charging) susceptance per section
    '''

    g: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Positive sequence shunt (charging) conductance per section
    '''

    g0: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero sequence shunt (charging) conductance per section
    '''

    NonlinearShuntCompensator: Optional[NonlinearShuntCompensator] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NonlinearShuntCompensator.NonlinearShuntCompensatorPoints',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Non-linear shunt compensator owning this point.
    '''

@dataclass(repr=False)
class OperatingShare(Identity):
    '''
    Specifies the operations contract relationship between a power system resource
    and a contract participant.
    '''

    percentage: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Percentage operational ownership between the pair (power system resource
    and operatging participant) associated with this share. The total percentage
    ownership for a power system resource should add to 100%.
    '''

    OperatingParticipant: Optional[OperatingParticipant] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OperatingParticipant.OperatingShare',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The operating participant having this share with the associated power system
    resource.
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerSystemResource.OperatingShare',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The power system resource to which the share applies.
    '''

@dataclass(repr=False)
class OperatonalLimitTypeScaling(Identity):
    '''
    One operational limit type scales values of another operational limit type
    when under the same operational limit set. This applies to any operational
    limit assigned to the target operational limit type and without other limit
    dependency models.
    '''

    scalingPercent: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The percentage scaling of the source limit to compute the target limit.
    Applys to operational limits within an operaitonal limit set when both
    source and target operational limit types exist.
    '''

    SourceOperationalLimitType: Optional[OperationalLimitType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OperationalLimitType.SourceOperationalLimitTypeScaling',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    TargetOperationalLimit: Optional[OperationalLimitType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OperationalLimitType.TargetOperationalLimitmTypeScaling',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class PhaseImpedanceData(Identity):
    '''
    Triplet of resistance, reactance, and susceptance matrix element values.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Column-wise element index, assuming a symmetrical matrix. Ranges from 1
    to N + N*(N-1)/2.
    '''

    b: Optional[ float | SusceptancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Susceptance matrix element value, per length of unit.
    '''

    r: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Resistance matrix element value, per length of unit.
    '''

    x: Optional[ float | ReactancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reactance matrix element value, per length of unit.
    '''

    PhaseImpedance: Optional[PerLengthPhaseImpedance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PerLengthPhaseImpedance.PhaseImpedanceData',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Conductor phase impedance to which this data belongs.
    '''

@dataclass(repr=False)
class PositionPoint(Identity):
    '''
    Set of spatial coordinates that determine a point, defined in the coordinate
    system specified in 'Location.CoordinateSystem'. Use a single position
    point instance to desribe a point-oriented location. Use a sequence of
    position points to describe a line-oriented object (physical location of
    non-point oriented objects like cables or lines), or area of an object
    (like a substation or a geographical zone - in this case, have first and
    last position point with the same values).
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Zero-relative sequence number of this point within a series of points.
    '''

    xPosition: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    X axis position.
    '''

    yPosition: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Y axis position.
    '''

    zPosition: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if applicable) Z axis position.
    '''

    Location: Optional[Location] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Location.PositionPoints',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Location described by this position point.
    '''

@dataclass(repr=False)
class Quality61850(Identity):
    '''
    Quality flags in this class are as defined in IEC 61850, except for estimatorReplaced,
    which has been included in this class for convenience.
    '''

    badReference: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Measurement value may be incorrect due to a reference being out of calibration.
    '''

    estimatorReplaced: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Value has been replaced by State Estimator. estimatorReplaced is not an
    IEC61850 quality bit but has been put in this class for convenience.
    '''

    failure: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    This identifier indicates that a supervision function has detected an internal
    or external failure, e.g. communication failure.
    '''

    oldData: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Measurement value is old and possibly invalid, as it has not been successfully
    updated during a specified time interval.
    '''

    operatorBlocked: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Measurement value is blocked and hence unavailable for transmission.
    '''

    oscillatory: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    To prevent some overload of the communication it is sensible to detect
    and suppress oscillating (fast changing) binary inputs. If a signal changes
    in a defined time (tosc) twice in the same direction (from 0 to 1 or from
    1 to 0) then oscillation is detected and the detail quality identifier
    "oscillatory" is set. If it is detected a configured numbers of transient
    changes could be passed by. In this time the validity status "questionable"
    is set. If after this defined numbers of changes the signal is still in
    the oscillating state the value shall be set either to the opposite state
    of the previous stable value or to a defined default value. In this case
    the validity status "questionable" is reset and "invalid" is set as long
    as the signal is oscillating. If it is configured such that no transient
    changes should be passed by then the validity status "invalid" is set immediately
    in addition to the detail quality identifier "oscillatory" (used for status
    information only).
    '''

    outOfRange: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Measurement value is beyond a predefined range of value.
    '''

    overFlow: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Measurement value is beyond the capability of being represented properly.
    For example, a counter value overflows from maximum count back to a value
    of zero.
    '''

    suspect: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A correlation function has detected that the value is not consitent with
    other values. Typically set by a network State Estimator.
    '''

    test: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Measurement value is transmitted for test purposes.
    '''

    source: Optional[ Source ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Source gives information related to the origin of a value. The value may
    be acquired from the process, defaulted or substituted.
    '''

    validity: Optional[ Validity ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Validity of the measurement value.
    '''

@dataclass(repr=False)
class MeasurementValueQuality(Quality61850):
    '''
    Measurement quality flags. Bits 0-10 are defined for substation automation
    in draft IEC 61850 part 7-3. Bits 11-15 are reserved for future expansion
    by that document. Bits 16-31 are reserved for EMS applications.
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'MeasurementValue.MeasurementValueQuality',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''

@dataclass(repr=False)
class RegularTimePoint(Identity):
    '''
    Time point for a schedule where the time between the consecutive points
    is constant.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The position of the regular time point in the sequence. Note that time
    points don't have to be sequential, i.e. time points may be omitted. The
    actual time for a RegularTimePoint is computed by multiplying the associated
    regular interval schedule's time step with the regular time point sequence
    number and adding the associated schedules start time.
    '''

    value1: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The first value at the time. The meaning of the value is defined by the
    derived type of the associated schedule.
    '''

    value2: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The second value at the time. The meaning of the value is defined by the
    derived type of the associated schedule.
    '''

    IntervalSchedule: Optional[RegularIntervalSchedule] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RegularIntervalSchedule.TimePoints',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Regular interval schedule containing this time point.
    '''

@dataclass(repr=False)
class ScheduledEventData(Identity):
    '''
    Schedule parameters for an activity that is to occur, is occurring, or
    has completed.
    '''

    InspectionDataSet: Optional[InspectionDataSet] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'InspectionDataSet.AccordingToSchedules',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    ScheduledEvents: list[ScheduledEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ScheduledEvent.ScheduledEventData',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    All scheduled events with this specification.
    '''

@dataclass(repr=False)
class StateVariable(Identity):
    '''
    An abstract class for state variables.
    '''

@dataclass(repr=False)
class SvInjection(StateVariable):
    '''
    The SvInjection is reporting the calculated bus injection minus the sum
    of the terminal flows. The terminal flow is positive out from the bus (load
    sign convention) and bus injection has positive flow into the bus. SvInjection
    may have the remainder after state estimation or slack after power flow
    calculation.
    '''

    pInjection: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The active power mismatch between calculated injection and initial injection.
    Positive sign means injection into the TopologicalNode (bus).
    '''

    qInjection: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reactive power mismatch between calculated injection and initial injection.
    Positive sign means injection into the TopologicalNode (bus).
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalNode.SvInjection',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The topological node associated with the flow injection state variable.
    '''

@dataclass(repr=False)
class SvPowerFlow(StateVariable):
    '''
    State variable for power flow. Load convention is used for flow direction.
    This means flow out from the TopologicalNode into the equipment is positive.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The active power flow. Load sign convention is used, i.e. positive sign
    means flow out from a TopologicalNode (bus) into the conducting equipment.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reactive power flow. Load sign convention is used, i.e. positive sign
    means flow out from a TopologicalNode (bus) into the conducting equipment.
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.SvPowerFlow',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The terminal associated with the power flow state variable.
    '''

@dataclass(repr=False)
class SvShuntCompensatorSections(StateVariable):
    '''
    State variable for the number of sections in service for a shunt compensator.
    '''

    sections: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The number of sections in service as a continous variable. To get integer
    value scale with ShuntCompensator.bPerSection.
    '''

    ShuntCompensator: Optional[ShuntCompensator] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ShuntCompensator.SvShuntCompensatorSections',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The shunt compensator for which the state applies.
    '''

@dataclass(repr=False)
class SvStatus(StateVariable):
    '''
    State variable for status.
    '''

    inService: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The in service status as a result of topology processing.
    '''

    ConductingEquipment: Optional[ConductingEquipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConductingEquipment.SvStatus',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The conducting equipment associated with the status state variable.
    '''

@dataclass(repr=False)
class SvTapStep(StateVariable):
    '''
    State variable for transformer tap step.
    '''

    position: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The floating point tap position. This is not the tap ratio, but rather
    the tap step position as defined by the related tap changer model and normally
    is constrained to be within the range of minimum and maximum tap positions.
    '''

    TapChanger: Optional[TapChanger] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TapChanger.SvTapStep',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The tap changer associated with the tap step state.
    '''

@dataclass(repr=False)
class SvVoltage(StateVariable):
    '''
    State variable for voltage.
    '''

    angle: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The voltage angle of the topological node complex voltage with respect
    to system reference.
    '''

    v: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The voltage magnitude of the topological node.
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalNode.SvVoltage',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The topological node associated with the voltage state.
    '''

@dataclass(repr=False)
class SwitchingStep(Identity):
    '''
    Atomic switching step; can be part of a switching step group, or of the
    switching plan.
    '''

@dataclass(repr=False)
class CutAction(SwitchingStep):
    '''
    Action on cut as a switching step.
    '''

    kind: Optional[ TempEquipActionKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Switching action to perform.
    '''

    Cut: Optional[Cut] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Cut.CutAction',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Cut on which this action is taken.
    '''

    SwitchingStepGroup: Optional[SwitchingStepGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SwitchingStepGroup.CutActions',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Group to which this step belongs.
    '''

@dataclass(repr=False)
class EnergySourceAction(SwitchingStep):
    '''
    Action on energy source as a switching step.
    '''

    kind: Optional[ TempEquipActionKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Switching action to perform.
    '''

    EnergySource: Optional[EnergySource] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnergySource.EnergySourceAction',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Energy source on which this action is taken.
    '''

    SwitchingStepGroup: Optional[SwitchingStepGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SwitchingStepGroup.EnergySourceActions',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Group to which this step belongs.
    '''

@dataclass(repr=False)
class GroundAction(SwitchingStep):
    '''
    Action on ground as a switching step.
    '''

    kind: Optional[ TempEquipActionKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Switching action to perform.
    '''

    AlongACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.LineGroundingAction',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The line segment that this ground action will affect. This is the only
    way to access relationship to clamp in case the ground needs to be placed
    along the line segment.
    '''

    Ground: Optional[Ground] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Ground.GroundAction',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Ground on which this action is taken.
    '''

    GroundedEquipment: Optional[ConductingEquipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConductingEquipment.GroundingAction',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Equipment being grounded with this operation. In case of placing a ground
    anywhere along a line segment, you must use the clamp (to get the distance
    from one terminal), so use the explicit relation with line segment. In
    all other cases (including placing the ground at a line segment terminal),
    reference to one or more conducting equipment is sufficient.
    '''

    SwitchingStepGroup: Optional[SwitchingStepGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SwitchingStepGroup.GroundActions',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Group to which this step belongs.
    '''

@dataclass(repr=False)
class JumperAction(SwitchingStep):
    '''
    Action on jumper as a switching step.
    '''

    kind: Optional[ TempEquipActionKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Switching action to perform.
    '''

    AlongACLineSegments: list[ACLineSegment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ACLineSegment.LineJumpingAction',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The line segment that this jumper action will affect. This is the only
    way to access relationship to clamp in case the jumper needs to connect
    along the line segment.
    '''

    JumpedEquipments: list[ConductingEquipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConductingEquipment.JumpingAction',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The conducting equipment that this jumper action will affect. In case of
    placing a jumper anywhere along a line segment, you must use the clamp
    (to get the distance from one terminal), so use the explicit relation with
    line segment. In all other cases (including placing the jumper at a line
    segment terminal), reference to one or more conducting equipment is sufficient.
    '''

    Jumper: Optional[Jumper] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Jumper.JumperAction',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Jumper on which this action is taken.
    '''

    SwitchingStepGroup: Optional[SwitchingStepGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SwitchingStepGroup.JumperActions',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Group to which this step belongs.
    '''

@dataclass(repr=False)
class SwitchAction(SwitchingStep):
    '''
    Action on switch as a switching step.
    '''

    kind: Optional[ SwitchActionKind ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Switching action to perform.
    '''

    OperatedSwitch: Optional[Switch] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Switch.SwitchAction',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Switch that is the object of this switch action.
    '''

@dataclass(repr=False)
class TieFlow(Identity):
    '''
    A flow specification in terms of location and direction for a control area.
    '''

    positiveFlowIn: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if the flow into the terminal (load convention) is also flow into
    the control area. For example, this attribute should be true if using the
    tie line terminal further away from the control area. For example to represent
    a tie to a shunt component (like a load or generator) in another area,
    this is the near end of a branch and this attribute would be specified
    as false.
    '''

    ControlArea: Optional[ControlArea] = field(
        default = None,
        metadata = {
            'type': 'OfAggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ControlArea.TieFlow',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The control area of the tie flows.
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.TieFlow',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The terminal to which this tie flow belongs.
    '''

@dataclass(repr=False)
class UserAttribute(Identity):
    '''
    Generic name-value pair class, with optional sequence number and units
    for value; can be used to model parts of information exchange when concrete
    types are not known in advance.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Name of an attribute.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Sequence number for this attribute in a list of attributes.
    '''

    PropertySpecification: Optional[Specification] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Specification.AssetProperites',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    RatingSpecification: Optional[Specification] = field(
        default = None,
        metadata = {
            'type': 'informative',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Specification.Ratings',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    Transaction: Optional[Transaction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Transaction.UserAttributes',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Transaction for which this snapshot has been recorded.
    '''

@dataclass(repr=False)
class Work(Identity):
    '''
    Document used to request, initiate, track and record work.
    '''

class AmiBillingReadyKind(Enum):
    '''
    Lifecycle states of the metering installation at a usage point with respect
    to readiness for billing via advanced metering infrastructure reads.
    '''

    amiCapable = 'amiCapable'
    '''
    Usage point is equipped with an AMI capable meter that is not yet currently
    equipped with a communications module.
    '''

    amiDisabled = 'amiDisabled'
    '''
    Usage point is equipped with an AMI capable meter; however, the AMI functionality
    has been disabled or is not being used.
    '''

    billingApproved = 'billingApproved'
    '''
    Usage point is equipped with an operating AMI capable meter and accuracy
    has been certified for billing purposes.
    '''

    enabled = 'enabled'
    '''
    Usage point is equipped with an AMI capable meter having communications
    capability.
    '''

    nonAmi = 'nonAmi'
    '''
    Usage point is equipped with a non AMI capable meter.
    '''

    nonMetered = 'nonMetered'
    '''
    Usage point is not currently equipped with a meter.
    '''

    operable = 'operable'
    '''
    Usage point is equipped with an AMI capable meter that is functioning and
    communicating with the AMI network.
    '''

class AssetModelUsageKind(Enum):
    '''
    Usage for an asset model.
    '''

    customerSubstation = 'customerSubstation'
    '''
    Asset model is intended for use in customer substation.
    '''

    distributionOverhead = 'distributionOverhead'
    '''
    Asset model is intended for use in distribution overhead network.
    '''

    distributionUnderground = 'distributionUnderground'
    '''
    Asset model is intended for use in underground distribution network.
    '''

    other = 'other'
    '''
    Other kind of asset model usage.
    '''

    streetlight = 'streetlight'
    '''
    Asset model is intended for use as streetlight.
    '''

    substation = 'substation'
    '''
    Asset model is intended for use in substation.
    '''

    transmission = 'transmission'
    '''
    Asset model is intended for use in transmission network.
    '''

    unknown = 'unknown'
    '''
    Usage of the asset model is unknown.
    '''

class AsynchronousMachineKind(Enum):
    '''
    Kind of Asynchronous Machine.
    '''

    generator = 'generator'
    '''
    The Asynchronous Machine is a generator.
    '''

    motor = 'motor'
    '''
    The Asynchronous Machine is a motor.
    '''

class BoilerControlMode(Enum):
    '''
    Boiler control mode.
    '''

    coordinated = 'coordinated'
    '''
    Coordinated.
    '''

    following = 'following'
    '''
    Following.
    '''

class BreakerConfiguration(Enum):
    '''
    Switching arrangement for bay.
    '''

    breakerAndAHalf = 'breakerAndAHalf'
    '''
    Breaker and a half.
    '''

    doubleBreaker = 'doubleBreaker'
    '''
    Double breaker.
    '''

    noBreaker = 'noBreaker'
    '''
    No breaker.
    '''

    singleBreaker = 'singleBreaker'
    '''
    Single breaker.
    '''

class BusbarConfiguration(Enum):
    '''
    Busbar layout for bay.
    '''

    doubleBus = 'doubleBus'
    '''
    Double bus.
    '''

    mainWithTransfer = 'mainWithTransfer'
    '''
    Main bus with transfer bus.
    '''

    ringBus = 'ringBus'
    '''
    Ring bus.
    '''

    singleBus = 'singleBus'
    '''
    Single bus.
    '''

class BushingInsulationKind(Enum):
    '''
    Insulation kind for bushings.
    '''

    compound = 'compound'
    '''
    '''

    other = 'other'
    '''
    '''

    paperoil = 'paperoil'
    '''
    '''

    solidPorcelain = 'solidPorcelain'
    '''
    '''

class BushingInsulationPfTestKind(Enum):
    '''
    Kind of PF test for bushing insulation.
    '''

    c1 = 'c1'
    '''
    Power factor tap-to-ground.
    '''

    c2 = 'c2'
    '''
    Power factor tap-to-conductor.
    '''

class CableConstructionKind(Enum):
    '''
    Kind of cable construction.
    '''

    compacted = 'compacted'
    '''
    Compacted cable.
    '''

    compressed = 'compressed'
    '''
    Compressed cable.
    '''

    other = 'other'
    '''
    Other kind of cable construction.
    '''

    sector = 'sector'
    '''
    Sector cable.
    '''

    segmental = 'segmental'
    '''
    Segmental cable.
    '''

    solid = 'solid'
    '''
    Solid cable.
    '''

    stranded = 'stranded'
    '''
    Stranded cable.
    '''

class CableOuterJacketKind(Enum):
    '''
    Kind of cable outer jacket.
    '''

    insulating = 'insulating'
    '''
    Insulating cable outer jacket.
    '''

    linearLowDensityPolyethylene = 'linearLowDensityPolyethylene'
    '''
    Linear low density polyethylene cable outer jacket.
    '''

    none = 'none'
    '''
    Cable has no outer jacket.
    '''

    other = 'other'
    '''
    Pther kind of cable outer jacket.
    '''

    polyethylene = 'polyethylene'
    '''
    Polyethylene cable outer jacket.
    '''

    pvc = 'pvc'
    '''
    PVC cable outer jacket.
    '''

    semiconducting = 'semiconducting'
    '''
    Semiconducting cable outer jacket.
    '''

class CableShieldMaterialKind(Enum):
    '''
    Kind of cable shield material.
    '''

    aluminum = 'aluminum'
    '''
    Aluminum cable shield.
    '''

    copper = 'copper'
    '''
    Copper cable shield.
    '''

    lead = 'lead'
    '''
    Lead cable shield.
    '''

    other = 'other'
    '''
    Other kind of cable shield material.
    '''

    steel = 'steel'
    '''
    Steel cable shield.
    '''

class ContingencyEquipmentStatusKind(Enum):
    '''
    Indicates the state which the contingency equipment is to be in when the
    contingency is applied.
    '''

    inService = 'inService'
    '''
    The equipment is in service.
    '''

    outOfService = 'outOfService'
    '''
    The equipment is to be taken out of service.
    '''

class ControlAreaTypeKind(Enum):
    '''
    The type of control area.
    '''

    AGC = 'AGC'
    '''
    Used for automatic generation control.
    '''

    Forecast = 'Forecast'
    '''
    Used for load forecast.
    '''

    Interchange = 'Interchange'
    '''
    Used for interchange specification or control.
    '''

class CoolantType(Enum):
    '''
    Method of cooling a machine.
    '''

    air = 'air'
    '''
    Air.
    '''

    hydrogenGas = 'hydrogenGas'
    '''
    Hydrogen gas.
    '''

    water = 'water'
    '''
    Water.
    '''

class CorporateStandardKind(Enum):
    '''
    Kind of corporate standard.
    '''

    experimental = 'experimental'
    '''
    Asset model is used experimentally.
    '''

    other = 'other'
    '''
    Other kind of corporate standard for the asset model.
    '''

    standard = 'standard'
    '''
    Asset model is used as corporate standard.
    '''

    underEvaluation = 'underEvaluation'
    '''
    Asset model usage is under evaluation.
    '''

class CsOperatingModeKind(Enum):
    '''
    Operating mode for HVDC line operating as Current Source Converter.
    '''

    inverter = 'inverter'
    '''
    Operating as inverter
    '''

    rectifier = 'rectifier'
    '''
    Operating as rectifier.
    '''

class CsPpccControlKind(Enum):
    '''
    Active power control modes for HVDC line operating as Current Source Converter.
    '''

    activePower = 'activePower'
    '''
    Active power control at AC side.
    '''

    dcCurrent = 'dcCurrent'
    '''
    DC current control
    '''

    dcVoltage = 'dcVoltage'
    '''
    DC voltage control.
    '''

class Currency(Enum):
    '''
    Monetary currencies. Apologies for this list not being exhaustive.
    '''

    AUD = 'AUD'
    '''
    Australian dollar
    '''

    CAD = 'CAD'
    '''
    Canadian dollar
    '''

    CHF = 'CHF'
    '''
    Swiss francs
    '''

    CNY = 'CNY'
    '''
    Chinese yuan renminbi
    '''

    DKK = 'DKK'
    '''
    Danish crown
    '''

    EUR = 'EUR'
    '''
    European euro
    '''

    GBP = 'GBP'
    '''
    British pound
    '''

    INR = 'INR'
    '''
    India rupees
    '''

    JPY = 'JPY'
    '''
    Japanese yen
    '''

    NOK = 'NOK'
    '''
    Norwegian crown
    '''

    RUR = 'RUR'
    '''
    Russian ruble
    '''

    SEK = 'SEK'
    '''
    Swedish crown
    '''

    USD = 'USD'
    '''
    US dollar
    '''

    other = 'other'
    '''
    Another type of currency.
    '''

class CurveStyle(Enum):
    '''
    Style or shape of curve.
    '''

    constantYValue = 'constantYValue'
    '''
    The Y-axis values are assumed constant until the next curve point and prior
    to the first curve point.
    '''

    straightLineYValues = 'straightLineYValues'
    '''
    The Y-axis values are assumed to be a straight line between values. Also
    known as linear interpolation.
    '''

class DCConverterOperatingModeKind(Enum):
    '''
    The operating mode of an HVDC bipole.
    '''

    bipolar = 'bipolar'
    '''
    Bipolar operation.
    '''

    monopolarGroundReturn = 'monopolarGroundReturn'
    '''
    Monopolar operation with ground return
    '''

    monopolarMetallicReturn = 'monopolarMetallicReturn'
    '''
    Monopolar operation with metallic return
    '''

class DCPolarityKind(Enum):
    '''
    Polarity for DC circuits.
    '''

    middle = 'middle'
    '''
    Middle pole, potentially grounded.
    '''

    negative = 'negative'
    '''
    Negative pole.
    '''

    positive = 'positive'
    '''
    Positive pole.
    '''

class EmissionType(Enum):
    '''
    The type of emission.
    '''

    carbonDioxide = 'carbonDioxide'
    '''
    Carbon diaoxide.
    '''

    carbonDisulfide = 'carbonDisulfide'
    '''
    Carbon disulfide.
    '''

    chlorine = 'chlorine'
    '''
    Clorine.
    '''

    hydrogenSulfide = 'hydrogenSulfide'
    '''
    Hydrogen sulfide.
    '''

    nitrogenOxide = 'nitrogenOxide'
    '''
    Nitrogen oxide.
    '''

    sulfurDioxide = 'sulfurDioxide'
    '''
    Sulfer dioxide.
    '''

class EmissionValueSource(Enum):
    '''
    The source of the emission value.
    '''

    calculated = 'calculated'
    '''
    Calculated.
    '''

    measured = 'measured'
    '''
    Measured.
    '''

class FuelType(Enum):
    '''
    Type of fuel.
    '''

    coal = 'coal'
    '''
    Generic coal, not including lignite type.
    '''

    gas = 'gas'
    '''
    Natural gas.
    '''

    hardCoal = 'hardCoal'
    '''
    Hard coal
    '''

    lignite = 'lignite'
    '''
    The fuel is lignite coal. Note that this is a special type of coal, so
    the other enum of coal is reserved for hard coal types or if the exact
    type of coal is not known.
    '''

    oil = 'oil'
    '''
    Oil.
    '''

    oilShale = 'oilShale'
    '''
    Oil Shale
    '''

class GeneratorControlMode(Enum):
    '''
    Unit control modes.
    '''

    pulse = 'pulse'
    '''
    Pulse control mode.
    '''

    setpoint = 'setpoint'
    '''
    Setpoint control mode.
    '''

class GeneratorControlSource(Enum):
    '''
    The source of controls for a generating unit.
    '''

    offAGC = 'offAGC'
    '''
    Off of automatic generation control (AGC).
    '''

    onAGC = 'onAGC'
    '''
    On automatic generation control (AGC).
    '''

    plantControl = 'plantControl'
    '''
    Plant is controlling.
    '''

    unavailable = 'unavailable'
    '''
    Not available.
    '''

class HydroEnergyConversionKind(Enum):
    '''
    Specifies the capability of the hydro generating unit to convert energy
    as a generator or pump.
    '''

    generator = 'generator'
    '''
    Able to generate power, but not able to pump water for energy storage.
    '''

    pumpAndGenerator = 'pumpAndGenerator'
    '''
    Able to both generate power and pump water for energy storage.
    '''

class HydroPlantStorageKind(Enum):
    '''
    The type of hydro power plant.
    '''

    pumpedStorage = 'pumpedStorage'
    '''
    Pumped storage.
    '''

    runOfRiver = 'runOfRiver'
    '''
    Run of river.
    '''

    storage = 'storage'
    '''
    Storage.
    '''

class OperationalLimitDirectionKind(Enum):
    '''
    The direction attribute describes the side of a limit that is a violation.
    '''

    absoluteValue = 'absoluteValue'
    '''
    An absoluteValue limit means that a monitored absolute value above the
    limit value is a violation.
    '''

    high = 'high'
    '''
    High means that a monitored value above the limit value is a violation.
    If applied to a terminal flow, the positive direction is into the terminal.
    '''

    low = 'low'
    '''
    Low means a monitored value below the limit is a violation. If applied
    to a terminal flow, the positive direction is into the terminal.
    '''

class OrientationKind(Enum):
    '''
    The orientation of the coordinate system with respect to top, left, and
    the coordinate number system.
    '''

    negative = 'negative'
    '''
    For 2D diagrams, a negative orientation gives the left-hand orientation
    (favoured by computer graphics displays) with X values increasing from
    left to right and Y values increasing from top to bottom. This is also
    known as a left hand orientation.
    '''

    positive = 'positive'
    '''
    For 2D diagrams, a positive orientation will result in X values increasing
    from left to right and Y values increasing from bottom to top. This is
    also known as a right hand orientation.
    '''

class PetersenCoilModeKind(Enum):
    '''
    The mode of operation for a Petersen coil.
    '''

    automaticPositioning = 'automaticPositioning'
    '''
    Automatic positioning.
    '''

    fixed = 'fixed'
    '''
    Fixed position.
    '''

    manual = 'manual'
    '''
    Manual positioning.
    '''

class PhaseCode(Enum):
    '''
    Enumeration of phase identifiers. Allows designation of phases for both
    transmission and distribution equipment, circuits and loads.
    Residential and small commercial loads are often served from single-phase,
    or split-phase, secondary circuits. For example of s12N, phases 1 and 2
    refer to hot wires that are 180 degrees out of phase, while N refers to
    the neutral wire. Through single-phase transformer connections, these secondary
    circuits may be served from one or two of the primary phases A, B, and
    C. For three-phase loads, use the A, B, C phase codes instead of s12N.
    '''

    A = 'A'
    '''
    Phase A.
    '''

    AB = 'AB'
    '''
    Phases A and B.
    '''

    ABC = 'ABC'
    '''
    Phases A, B, and C.
    '''

    ABCN = 'ABCN'
    '''
    Phases A, B, C, and N.
    '''

    ABN = 'ABN'
    '''
    Phases A, B, and neutral.
    '''

    AC = 'AC'
    '''
    Phases A and C.
    '''

    ACN = 'ACN'
    '''
    Phases A, C and neutral.
    '''

    AN = 'AN'
    '''
    Phases A and neutral.
    '''

    B = 'B'
    '''
    Phase B.
    '''

    BC = 'BC'
    '''
    Phases B and C.
    '''

    BCN = 'BCN'
    '''
    Phases B, C, and neutral.
    '''

    BN = 'BN'
    '''
    Phases B and neutral.
    '''

    C = 'C'
    '''
    Phase C.
    '''

    CN = 'CN'
    '''
    Phases C and neutral.
    '''

    N = 'N'
    '''
    Neutral phase.
    '''

    s1 = 's1'
    '''
    Secondary phase 1.
    '''

    s12 = 's12'
    '''
    Secondary phase 1 and 2.
    '''

    s12N = 's12N'
    '''
    Secondary phases 1, 2, and neutral.
    '''

    s1N = 's1N'
    '''
    Secondary phase 1 and neutral.
    '''

    s2 = 's2'
    '''
    Secondary phase 2.
    '''

    s2N = 's2N'
    '''
    Secondary phase 2 and neutral.
    '''

class PhaseConnectedFaultKind(Enum):
    '''
    The type of fault connection among phases.
    '''

    lineToGround = 'lineToGround'
    '''
    The fault connects the indicated phases to ground. The line to line fault
    impedance is not used and assumed infinite. The full ground impedance is
    connected between each phase specified in the fault and ground, but not
    between the phases.
    '''

    lineToLine = 'lineToLine'
    '''
    The fault connects the specified phases together without a connection to
    ground. The ground impedance of this fault is ignored. The line to line
    impedance is connected between each of the phases specified in the fault.
    For example three times for a three phase fault, one time for a two phase
    fault. A single phase fault should not be specified.
    '''

    lineToLineToGround = 'lineToLineToGround'
    '''
    The fault connects the indicated phases to ground and to each other. The
    line to line impedance is connected between each of the phases specified
    in the fault in a full mesh. For example three times for a three phase
    fault, one time for a two phase fault. A single phase fault should not
    be specified. The full ground impedance is connected between each phase
    specified in the fault and ground.
    '''

class PhaseShuntConnectionKind(Enum):
    '''
    The configuration of phase connections for a single terminal device such
    as a load or capactitor.
    '''

    D = 'D'
    '''
    Delta connection.
    '''

    I = 'I'
    '''
    Independent winding, for single-phase connections.
    '''

    Y = 'Y'
    '''
    Wye connection.
    '''

    Yn = 'Yn'
    '''
    Wye, with neutral brought out for grounding.
    '''

class PotentialTransformerKind(Enum):
    '''
    The construction kind of the potential transformer.
    '''

    capacitiveCoupling = 'capacitiveCoupling'
    '''
    The potential transformer is using capacitive coupling to create secondary
    voltage.
    '''

    inductive = 'inductive'
    '''
    The potential transformer is using induction coils to create secondary
    voltage.
    '''

class ProcedureKind(Enum):
    '''
    Kind of procedure.
    '''

    diagnosis = 'diagnosis'
    '''
    '''

    inspection = 'inspection'
    '''
    '''

    maintenance = 'maintenance'
    '''
    '''

    other = 'other'
    '''
    '''

    test = 'test'
    '''
    '''

class ProtectiveActionAdjustmentKind(Enum):
    '''
    Categorisation of different protective action adjustments that can be performed
    on equipment.
    '''

    byPercentage = 'byPercentage'
    '''
    The adjustment is in percentage of the active value.
    '''

    byValue = 'byValue'
    '''
    The adjustment is in given by a value that defined the changes that will
    be done to the active value.
    '''

    measurement = 'measurement'
    '''
    The equipment will operating on a value given by a measurement.
    '''

    setValue = 'setValue'
    '''
    The equipment will operate on the new value.
    '''

class RegulatingControlModeKind(Enum):
    '''
    The kind of regulation model. For example regulating voltage, reactive
    power, active power, etc.
    '''

    activePower = 'activePower'
    '''
    Active power is specified.
    '''

    admittance = 'admittance'
    '''
    Admittance is specified.
    '''

    currentFlow = 'currentFlow'
    '''
    Current flow is specified.
    '''

    powerFactor = 'powerFactor'
    '''
    Power factor is specified.
    '''

    reactivePower = 'reactivePower'
    '''
    Reactive power is specified.
    '''

    temperature = 'temperature'
    '''
    Control switches on/off based on the local temperature (i.e., a thermostat).
    '''

    timeScheduled = 'timeScheduled'
    '''
    Control switches on/off by time of day. The times may change on the weekend,
    or in different seasons.
    '''

    voltage = 'voltage'
    '''
    Voltage is specified.
    '''

class RegulationBranchKind(Enum):
    '''
    Kind of regulation branch for shunt impedance.
    '''

    breaker = 'breaker'
    '''
    '''

    fuse = 'fuse'
    '''
    '''

    line = 'line'
    '''
    '''

    other = 'other'
    '''
    '''

    recloser = 'recloser'
    '''
    '''

    sectionner = 'sectionner'
    '''
    '''

    switch = 'switch'
    '''
    '''

    transformer = 'transformer'
    '''
    '''

class RemoteUnitType(Enum):
    '''
    Type of remote unit.
    '''

    ControlCenter = 'ControlCenter'
    '''
    Control center.
    '''

    IED = 'IED'
    '''
    Intelligent electronic device (IED).
    '''

    RTU = 'RTU'
    '''
    Remote terminal unit.
    '''

    SubstationControlSystem = 'SubstationControlSystem'
    '''
    Substation control system.
    '''

class SVCControlMode(Enum):
    '''
    Static VAr Compensator control mode.
    '''

    reactivePower = 'reactivePower'
    '''
    '''

    voltage = 'voltage'
    '''
    '''

class SealConditionKind(Enum):
    '''
    Kind of seal condition.
    '''

    broken = 'broken'
    '''
    Seal is broken.
    '''

    locked = 'locked'
    '''
    Seal is locked.
    '''

    missing = 'missing'
    '''
    Seal is missing.
    '''

    open = 'open'
    '''
    Seal is open.
    '''

    other = 'other'
    '''
    Other kind of seal condition.
    '''

class SealKind(Enum):
    '''
    Kind of seal.
    '''

    lead = 'lead'
    '''
    Lead seal.
    '''

    lock = 'lock'
    '''
    Lock seal.
    '''

    other = 'other'
    '''
    Other kind of seal.
    '''

    steel = 'steel'
    '''
    Steel seal.
    '''

class ServiceKind(Enum):
    '''
    Kind of service.
    '''

    electricity = 'electricity'
    '''
    Electricity service.
    '''

    gas = 'gas'
    '''
    Gas service.
    '''

    heat = 'heat'
    '''
    Heat service.
    '''

    internet = 'internet'
    '''
    Internet service.
    '''

    other = 'other'
    '''
    Other kind of service.
    '''

    rates = 'rates'
    '''
    Rates (e.g. tax, charge, toll, duty, tariff, etc.) service.
    '''

    refuse = 'refuse'
    '''
    Refuse (waster) service.
    '''

    sewerage = 'sewerage'
    '''
    Sewerage service.
    '''

    time = 'time'
    '''
    Time service.
    '''

    tvLicence = 'tvLicence'
    '''
    TV license service.
    '''

    water = 'water'
    '''
    Water service.
    '''

class ShortCircuitRotorKind(Enum):
    '''
    Type of rotor, used by short circuit applications.
    '''

    salientPole1 = 'salientPole1'
    '''
    Salient pole 1 in the IEC 60909
    '''

    salientPole2 = 'salientPole2'
    '''
    Salient pole 2 in IEC 60909
    '''

    turboSeries1 = 'turboSeries1'
    '''
    Turbo Series 1 in the IEC 60909
    '''

    turboSeries2 = 'turboSeries2'
    '''
    Turbo series 2 in IEC 60909
    '''

class ShuntImpedanceControlKind(Enum):
    '''
    Kind of control for shunt impedance.
    '''

    fixed = 'fixed'
    '''
    '''

    localOnly = 'localOnly'
    '''
    '''

    remoteOnly = 'remoteOnly'
    '''
    '''

    remoteWithLocalOverride = 'remoteWithLocalOverride'
    '''
    '''

class ShuntImpedanceLocalControlKind(Enum):
    '''
    Kind of local control for shunt impedance.
    '''

    current = 'current'
    '''
    '''

    none = 'none'
    '''
    '''

    powerFactor = 'powerFactor'
    '''
    '''

    reactivePower = 'reactivePower'
    '''
    '''

    temperature = 'temperature'
    '''
    '''

    time = 'time'
    '''
    '''

    voltage = 'voltage'
    '''
    '''

class SinglePhaseKind(Enum):
    '''
    Enumeration of single phase identifiers. Allows designation of single phases
    for both transmission and distribution equipment, circuits and loads.
    '''

    A = 'A'
    '''
    Phase A.
    '''

    B = 'B'
    '''
    Phase B.
    '''

    C = 'C'
    '''
    Phase C.
    '''

    N = 'N'
    '''
    Neutral.
    '''

    s1 = 's1'
    '''
    Secondary phase 1.
    '''

    s2 = 's2'
    '''
    Secondary phase 2.
    '''

class Source(Enum):
    '''
    Source gives information related to the origin of a value.
    '''

    DEFAULTED = 'DEFAULTED'
    '''
    The value contains a default value.
    '''

    PROCESS = 'PROCESS'
    '''
    The value is provided by input from the process I/O or being calculated
    from some function.
    '''

    SUBSTITUTED = 'SUBSTITUTED'
    '''
    The value is provided by input of an operator or by an automatic source.
    '''

class StructureMaterialKind(Enum):
    '''
    Kind of material used for structures.
    '''

    concrete = 'concrete'
    '''
    '''

    other = 'other'
    '''
    '''

    steel = 'steel'
    '''
    '''

    wood = 'wood'
    '''
    '''

class SwitchActionKind(Enum):
    '''
    Kind of action on switch.
    '''

    close = 'close'
    '''
    Close the switch.
    '''

    disableReclosing = 'disableReclosing'
    '''
    Disable (automatic) switch reclosing.
    '''

    enableReclosing = 'enableReclosing'
    '''
    Enable (automatic) switch reclosing.
    '''

    open = 'open'
    '''
    Open the switch.
    '''

class SynchronousMachineKind(Enum):
    '''
    Synchronous machine type.
    '''

    condenser = 'condenser'
    '''
    '''

    generator = 'generator'
    '''
    '''

    generatorOrCondenser = 'generatorOrCondenser'
    '''
    '''

    generatorOrCondenserOrMotor = 'generatorOrCondenserOrMotor'
    '''
    '''

    generatorOrMotor = 'generatorOrMotor'
    '''
    '''

    motor = 'motor'
    '''
    '''

    motorOrCondenser = 'motorOrCondenser'
    '''
    '''

class SynchronousMachineOperatingMode(Enum):
    '''
    Synchronous machine operating mode.
    '''

    condenser = 'condenser'
    '''
    '''

    generator = 'generator'
    '''
    '''

    motor = 'motor'
    '''
    '''

class TempEquipActionKind(Enum):
    '''
    Kind of action on temporary equipment (such as cut, jumper, ground, energy
    source).
    '''

    place = 'place'
    '''
    Place the jumper (close) or the cut (open).
    '''

    remove = 'remove'
    '''
    Remove the jumper (open) or the cut (close).
    '''

class TransformerControlMode(Enum):
    '''
    Control modes for a transformer.
    '''

    reactive = 'reactive'
    '''
    Reactive power flow control
    '''

    volt = 'volt'
    '''
    Voltage control
    '''

class TurbineType(Enum):
    '''
    Type of turbine.
    '''

    francis = 'francis'
    '''
    Francis.
    '''

    kaplan = 'kaplan'
    '''
    Kaplan.
    '''

    pelton = 'pelton'
    '''
    Pelton.
    '''

class UnitMultiplier(Enum):
    '''
    The unit multipliers defined for the CIM.
    '''

    G = 'G'
    '''
    Giga 10**9.
    '''

    M = 'M'
    '''
    Mega 10**6.
    '''

    T = 'T'
    '''
    Tera 10**12.
    '''

    c = 'c'
    '''
    Centi 10**-2.
    '''

    d = 'd'
    '''
    Deci 10**-1.
    '''

    k = 'k'
    '''
    Kilo 10**3.
    '''

    m = 'm'
    '''
    Milli 10**-3.
    '''

    micro = 'micro'
    '''
    Micro 10**-6.
    '''

    n = 'n'
    '''
    Nano 10**-9.
    '''

    none = 'none'
    '''
    No multiplier or equivalently multiply by 1.
    '''

    p = 'p'
    '''
    Pico 10**-12.
    '''

class UnitSymbol(Enum):
    '''
    The units defined for usage in the CIM.
    '''

    A = 'A'
    '''
    Current in ampere.
    '''

    F = 'F'
    '''
    Capacitance in farad.
    '''

    H = 'H'
    '''
    Inductance in henry.
    '''

    Hz = 'Hz'
    '''
    Frequency in hertz.
    '''

    J = 'J'
    '''
    Energy in joule.
    '''

    N = 'N'
    '''
    Force in newton.
    '''

    Pa = 'Pa'
    '''
    Pressure in pascal (n/m2).
    '''

    S = 'S'
    '''
    Conductance in siemens.
    '''

    V = 'V'
    '''
    Voltage in volt.
    '''

    VA = 'VA'
    '''
    Apparent power in volt ampere.
    '''

    VAh = 'VAh'
    '''
    Apparent energy in volt ampere hours.
    '''

    VAr = 'VAr'
    '''
    Reactive power in volt ampere reactive.
    '''

    VArh = 'VArh'
    '''
    Reactive energy in volt ampere reactive hours.
    '''

    W = 'W'
    '''
    Active power in watt.
    '''

    Wh = 'Wh'
    '''
    Real energy in what hours.
    '''

    deg = 'deg'
    '''
    Plane angle in degrees.
    '''

    degC = 'degC'
    '''
    Relative temperature in degrees Celsius. In the SI unit system the symbol
    is �C. Electric charge is measured in coulomb that has the unit symbol
    C. To distinguish degree Celsius form coulomb the symbol used in the UML
    is degC. Reason for not using �C is the special character � is difficult
    to manage in software.
    '''

    g = 'g'
    '''
    Mass in gram.
    '''

    h = 'h'
    '''
    Time in hours.
    '''

    m = 'm'
    '''
    Length in meter.
    '''

    m2 = 'm2'
    '''
    Area in square meters.
    '''

    m3 = 'm3'
    '''
    Volume in cubic meters.
    '''

    min = 'min'
    '''
    Time in minutes.
    '''

    none = 'none'
    '''
    Dimension less quantity, e.g. count, per unit, etc.
    '''

    ohm = 'ohm'
    '''
    Resistance in ohm.
    '''

    rad = 'rad'
    '''
    Plane angle in radians.
    '''

    s = 's'
    '''
    Time in seconds.
    '''

class UsagePointConnectedKind(Enum):
    '''
    State of the usage point with respect to connection to the network.
    '''

    connected = 'connected'
    '''
    The usage point is connected to the network and able to receive or send
    the applicable commodity (electricity, gas, water, etc.).
    '''

    logicallyDisconnected = 'logicallyDisconnected'
    '''
    The usage point has been disconnected through operation of a disconnect
    function within the meter present at the usage point. The usage point is
    unable to receive or send the applicable commodity (electricity, gas, water,
    etc.) A logical disconnect can often be achieved without utilising a field
    crew.
    '''

    physicallyDisconnected = 'physicallyDisconnected'
    '''
    The usage point has been disconnected from the network at a point upstream
    of the meter. The usage point is unable to receive or send the applicable
    commodity (electricity, gas, water, etc.). A physical disconnect is often
    achieved by utilising a field crew.
    '''

class Validity(Enum):
    '''
    Validity for MeasurementValue.
    '''

    GOOD = 'GOOD'
    '''
    The value is marked good if no abnormal condition of the acquisition function
    or the information source is detected.
    '''

    INVALID = 'INVALID'
    '''
    The value is marked invalid when a supervision function recognises abnormal
    conditions of the acquisition function or the information source (missing
    or non-operating updating devices). The value is not defined under this
    condition. The mark invalid is used to indicate to the client that the
    value may be incorrect and shall not be used.
    '''

    QUESTIONABLE = 'QUESTIONABLE'
    '''
    The value is marked questionable if a supervision function detects an abnormal
    behaviour, however the value could still be valid. The client is responsible
    for determining whether or not values marked "questionable" should be used.
    '''

class VsPpccControlKind(Enum):
    '''
    Types applicable to the control of real power and/or DC voltage by voltage
    source converter.
    '''

    pPcc = 'pPcc'
    '''
    Control variable (target) is real power at PCC bus.
    '''

    pPccAndUdcDroop = 'pPccAndUdcDroop'
    '''
    Control variables (targets) are both active power at point of common coupling
    and local DC voltage, with the droop.
    '''

    pPccAndUdcDroopPilot = 'pPccAndUdcDroopPilot'
    '''
    Control variables (targets) are both active power at point of common coupling
    and the pilot DC voltage, with the droop.
    '''

    pPccAndUdcDroopWithCompensation = 'pPccAndUdcDroopWithCompensation'
    '''
    Control variables (targets) are both active power at point of common coupling
    and compensated DC voltage, with the droop; compensation factor is the
    resistance, as an approximation of the DC voltage of a common (real or
    virtual) node in the DC network.
    '''

    udc = 'udc'
    '''
    Control variable (target) is DC voltage and real power at PCC bus is derived.
    '''

class VsQpccControlKind(Enum):
    '''
    '''

    powerFactorPcc = 'powerFactorPcc'
    '''
    '''

    reactivePcc = 'reactivePcc'
    '''
    '''

    voltagePcc = 'voltagePcc'
    '''
    '''

class WindGenUnitKind(Enum):
    '''
    Kind of wind generating unit.
    '''

    offshore = 'offshore'
    '''
    The wind generating unit is located offshore.
    '''

    onshore = 'onshore'
    '''
    The wind generating unit is located onshore.
    '''

class WindingConnection(Enum):
    '''
    Winding connection type.
    '''

    A = 'A'
    '''
    Autotransformer common winding
    '''

    D = 'D'
    '''
    Delta
    '''

    I = 'I'
    '''
    Independent winding, for single-phase connections
    '''

    Y = 'Y'
    '''
    Wye
    '''

    Yn = 'Yn'
    '''
    Wye, with neutral brought out for grounding.
    '''

    Z = 'Z'
    '''
    ZigZag
    '''

    Zn = 'Zn'
    '''
    ZigZag, with neutral brought out for grounding.
    '''

class WireInsulationKind(Enum):
    '''
    Kind of wire insulation.
    '''

    asbestosAndVarnishedCambric = 'asbestosAndVarnishedCambric'
    '''
    Asbestos and varnished cambric wire insulation.
    '''

    beltedPilc = 'beltedPilc'
    '''
    Belted pilc wire insulation.
    '''

    butyl = 'butyl'
    '''
    Butyl wire insulation.
    '''

    crosslinkedPolyethylene = 'crosslinkedPolyethylene'
    '''
    Crosslinked polyethylene wire insulation.
    '''

    ethylenePropyleneRubber = 'ethylenePropyleneRubber'
    '''
    Ethylene propylene rubber wire insulation.
    '''

    highMolecularWeightPolyethylene = 'highMolecularWeightPolyethylene'
    '''
    High nolecular weight polyethylene wire insulation.
    '''

    highPressureFluidFilled = 'highPressureFluidFilled'
    '''
    High pressure fluid filled wire insulation.
    '''

    lowCapacitanceRubber = 'lowCapacitanceRubber'
    '''
    Low capacitance rubber wire insulation.
    '''

    oilPaper = 'oilPaper'
    '''
    Oil paper wire insulation.
    '''

    other = 'other'
    '''
    Other kind of wire insulation.
    '''

    ozoneResistantRubber = 'ozoneResistantRubber'
    '''
    Ozone resistant rubber wire insulation.
    '''

    rubber = 'rubber'
    '''
    Rubber wire insulation.
    '''

    siliconRubber = 'siliconRubber'
    '''
    Silicon rubber wire insulation.
    '''

    treeResistantHighMolecularWeightPolyethylene = 'treeResistantHighMolecularWeightPolyethylene'
    '''
    Tree resistant high molecular weight polyethylene wire insulation.
    '''

    treeRetardantCrosslinkedPolyethylene = 'treeRetardantCrosslinkedPolyethylene'
    '''
    Tree retardant crosslinked polyethylene wire insulation.
    '''

    unbeltedPilc = 'unbeltedPilc'
    '''
    Unbelted pilc wire insulation.
    '''

    varnishedCambricCloth = 'varnishedCambricCloth'
    '''
    Varnished cambric cloth wire insulation.
    '''

    varnishedDacronGlass = 'varnishedDacronGlass'
    '''
    Varnished dacron glass wire insulation.
    '''

class WireMaterialKind(Enum):
    '''
    Kind of wire material.
    '''

    aaac = 'aaac'
    '''
    Aluminum-alloy conductor steel reinforced.
    '''

    acsr = 'acsr'
    '''
    Aluminum conductor steel reinforced.
    '''

    aluminum = 'aluminum'
    '''
    Aluminum wire.
    '''

    aluminumAlloy = 'aluminumAlloy'
    '''
    Aluminum-alloy wire.
    '''

    aluminumAlloySteel = 'aluminumAlloySteel'
    '''
    Aluminum-alloy-steel wire.
    '''

    aluminumSteel = 'aluminumSteel'
    '''
    Aluminum-steel wire.
    '''

    copper = 'copper'
    '''
    Copper wire.
    '''

    other = 'other'
    '''
    Other wire material.
    '''

    steel = 'steel'
    '''
    Steel wire.
    '''

class WireUsageKind(Enum):
    '''
    Kind of wire usage.
    '''

    distribution = 'distribution'
    '''
    Wire is used in medium voltage network.
    '''

    other = 'other'
    '''
    Other kind of wire usage.
    '''

    secondary = 'secondary'
    '''
    Wire is used in low voltage circuit.
    '''

    transmission = 'transmission'
    '''
    Wire is used in extra-high voltage or high voltage network.
    '''

@dataclass
class ActivePower():
    value: float = field(default=None)
    '''
    Product of RMS value of the voltage and the RMS value of the in-phase component
    of the current.
    '''

@dataclass
class ActivePowerChangeRate():
    value: float = field(default=None)
    '''
    Rate of change of active power per time.
    '''

@dataclass
class ActivePowerPerCurrentFlow():
    value: float = field(default=None)
    '''
    '''

@dataclass
class ActivePowerPerFrequency():
    value: float = field(default=None)
    '''
    Active power variation with frequency.
    '''

@dataclass
class AngleDegrees():
    value: float = field(default=None)
    '''
    Measurement of angle in degrees.
    '''

@dataclass
class AngleRadians():
    value: float = field(default=None)
    '''
    Phase angle in radians.
    '''

@dataclass
class ApparentPower():
    value: float = field(default=None)
    '''
    Product of the RMS value of the voltage and the RMS value of the current.
    '''

@dataclass
class Capacitance():
    value: float = field(default=None)
    '''
    Capacitive part of reactance (imaginary part of impedance), at rated frequency.
    '''

@dataclass
class CapacitancePerLength():
    value: float = field(default=None)
    '''
    Capacitance per unit of length.
    '''

@dataclass
class Classification():
    value: int = field(default=None)
    '''
    Classification of level. Specify as 1..n, with 1 being the most detailed,
    highest priority, etc as described on the attribue using this data type.
    '''

@dataclass
class Conductance():
    value: float = field(default=None)
    '''
    Factor by which voltage must be multiplied to give corresponding power
    lost from a circuit. Real part of admittance.
    '''

@dataclass
class ConductancePerLength():
    value: float = field(default=None)
    '''
    Real part of admittance per unit of length.
    '''

@dataclass
class CostPerEnergyUnit():
    value: float = field(default=None)
    '''
    Cost, in units of currency, per quantity of electrical energy generated.
    '''

@dataclass
class CostPerHeatUnit():
    value: float = field(default=None)
    '''
    Cost, in units of currency, per quantity of heat generated.
    '''

@dataclass
class CostPerVolume():
    value: float = field(default=None)
    '''
    Cost per unit volume.
    '''

@dataclass
class CostRate():
    value: float = field(default=None)
    '''
    Cost, in units of currency, per elapsed time.
    '''

@dataclass
class CurrentFlow():
    value: float = field(default=None)
    '''
    Electrical current with sign convention: positive flow is out of the conducting
    equipment into the connectivity node. Can be both AC and DC.
    '''

@dataclass
class Displacement():
    value: float = field(default=None)
    '''
    Unit of displacement relative a reference position, hence can be negative.
    '''

@dataclass
class Emission():
    value: float = field(default=None)
    '''
    Quantity of emission per fuel heat content.
    '''

@dataclass
class Frequency():
    value: float = field(default=None)
    '''
    Cycles per second.
    '''

@dataclass
class HeatRate():
    value: float = field(default=None)
    '''
    Heat generated, in energy pertime unit of elapsed time.
    '''

@dataclass
class Hours():
    value: float = field(default=None)
    '''
    Time specified in hours.
    '''

@dataclass
class Impedance():
    value: float = field(default=None)
    '''
    Ratio of voltage to current.
    '''

@dataclass
class Inductance():
    value: float = field(default=None)
    '''
    Inductive part of reactance (imaginary part of impedance), at rated frequency.
    '''

@dataclass
class InductancePerLength():
    value: float = field(default=None)
    '''
    Inductance per unit of length.
    '''

@dataclass
class KiloActivePower():
    value: float = field(default=None)
    '''
    Active power in kilowatts.
    '''

@dataclass
class Length():
    value: float = field(default=None)
    '''
    Unit of length. Never negative.
    '''

@dataclass
class Money():
    value: str = field(default=None)
    '''
    Amount of money.
    '''

@dataclass
class PU():
    value: float = field(default=None)
    '''
    Per Unit - a positive or negative value referred to a defined base. Values
    typically range from -10 to +10.
    '''

@dataclass
class PerCent():
    value: float = field(default=None)
    '''
    Percentage on a defined base. For example, specify as 100 to indicate at
    the defined base.
    '''

@dataclass
class Pressure():
    value: float = field(default=None)
    '''
    Pressure in Pascal.
    '''

@dataclass
class Reactance():
    value: float = field(default=None)
    '''
    Reactance (imaginary part of impedance), at rated frequency.
    '''

@dataclass
class ReactancePerLength():
    value: float = field(default=None)
    '''
    Reactance (imaginary part of impedance) per unit of length, at rated frequency.
    '''

@dataclass
class ReactivePower():
    value: float = field(default=None)
    '''
    Product of RMS value of the voltage and the RMS value of the quadrature
    component of the current.
    '''

@dataclass
class RealEnergy():
    value: float = field(default=None)
    '''
    Real electrical energy.
    '''

@dataclass
class Resistance():
    value: float = field(default=None)
    '''
    Resistance (real part of impedance).
    '''

@dataclass
class ResistancePerLength():
    value: float = field(default=None)
    '''
    Resistance (real part of impedance) per unit of length.
    '''

@dataclass
class RotationSpeed():
    value: float = field(default=None)
    '''
    Number of revolutions per second.
    '''

@dataclass
class Seconds():
    value: float = field(default=None)
    '''
    Time, in seconds.
    '''

@dataclass
class Susceptance():
    value: float = field(default=None)
    '''
    Imaginary part of admittance.
    '''

@dataclass
class SusceptancePerLength():
    value: float = field(default=None)
    '''
    Imaginary part of admittance per unit of length.
    '''

@dataclass
class Temperature():
    value: float = field(default=None)
    '''
    Value of temperature in degrees Celsius.
    '''

@dataclass
class Voltage():
    value: float = field(default=None)
    '''
    Electrical voltage, can be both AC and DC.
    '''

@dataclass
class VoltagePerReactivePower():
    value: float = field(default=None)
    '''
    Voltage variation with reactive power.
    '''

@dataclass
class Volume():
    value: float = field(default=None)
    '''
    Volume.
    '''

@dataclass
class VolumeFlowRate():
    value: float = field(default=None)
    '''
    Volume per time.
    '''

@dataclass
class WaterLevel():
    value: float = field(default=None)
    '''
    Reservoir water level referred to a given datum such as mean sea level.
    '''

@dataclass
class Weight():
    value: float = field(default=None)
    '''
    The weight of an object.
    '''

@dataclass(repr=False)
class AcceptanceTest(Identity):
    '''
    Acceptance test for assets.
    '''

    dateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date and time the asset was last tested using the 'type' of test and yielding
    the current status in 'success' attribute.
    '''

    success: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if asset has passed acceptance test and may be placed in or is in
    service. It is set to false if asset is removed from service and is required
    to be tested again before being placed back in service, possibly in a new
    location. Since asset may go through multiple tests during its lifecycle,
    the date of each acceptance test may be recorded in 'Asset.ActivityRecord.status.dateTime'.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of test or group of tests that was conducted on 'dateTime'.
    '''

@dataclass(repr=False)
class DateInterval(Identity):
    '''
    Interval between two dates.
    '''

    end: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    End date of this interval.
    '''

    start: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Start date of this interval.
    '''

@dataclass(repr=False)
class DateTimeInterval(Identity):
    '''
    Interval between two date and time points.
    '''

    end: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    End date and time of this interval.
    '''

    start: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Start date and time of this interval.
    '''

@dataclass(repr=False)
class DecimalQuantity(Identity):
    '''
    '''

    value: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    currency: Optional[ Currency ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Quantity with decimal value and associated unit or currency information.
    '''

    multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class ElectronicAddress(Identity):
    '''
    Electronic address information.
    '''

    email1: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Primary email address.
    '''

    email2: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Alternate email address.
    '''

    lan: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Address on local area network.
    '''

    mac: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    MAC (Media Access Control) address.
    '''

    password: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Password needed to log in.
    '''

    radio: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Radio address.
    '''

    userID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    User ID needed to log in, which can be for an individual person, an organisation,
    a location, etc.
    '''

    web: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    World wide web address.
    '''

@dataclass(repr=False)
class FaultImpedance(Identity):
    '''
    Impedance description for the fault.
    '''

    rGround: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The resistance of the fault between phases and ground.
    '''

    rLineToLine: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The resistance of the fault between phases.
    '''

    xGround: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reactance of the fault between phases and ground.
    '''

    xLineToLine: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    The reactance of the fault between phases.
    '''

@dataclass(repr=False)
class FloatQuantity(Identity):
    '''
    Quantity with float value and associated unit information.
    '''

    value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class IntegerQuantity(Identity):
    '''
    Quantity with integer value and associated unit information.
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class LifecycleDate(Identity):
    '''
    Dates for lifecycle events of an asset.
    '''

    installationDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if applicable) Date current installation was completed, which may not
    be the same as the in-service date. Asset may have been installed at other
    locations previously. Ignored if asset is (1) not currently installed (e.g.,
    stored in a depot) or (2) not intended to be installed (e.g., vehicle,
    tool).
    '''

    manufacturedDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date the asset was manufactured.
    '''

    purchaseDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date the asset was purchased. Note that even though an asset may have been
    purchased, it may not have been received into inventory at the time of
    purchase.
    '''

    receivedDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date the asset was received and first placed into inventory.
    '''

    removalDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if applicable) Date when the asset was last removed from service. Ignored
    if (1) not intended to be in service, or (2) currently in service.
    '''

    retiredDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if applicable) Date the asset is permanently retired from service and
    may be scheduled for disposal. Ignored if asset is (1) currently in service,
    or (2) permanently removed from service.
    '''

@dataclass(repr=False)
class MonthDayInterval(Identity):
    '''
    Interval between two times specified as mont and date.
    '''

    end: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    End time of this interval.
    '''

    start: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Start time of this interval.
    '''

@dataclass(repr=False)
class PostalAddress(Identity):
    '''
    General purpose postal address information.
    '''

    poBox: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Post office box.
    '''

    postalCode: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Postal code for the address.
    '''

@dataclass(repr=False)
class Priority(Identity):
    '''
    Priority definition.
    '''

    justification: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Justification for 'rank'.
    '''

    rank: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Priority level; usually, lower number means high priority, but the details
    are provided in 'type'.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type describing 'rank'; e.g., high, emergency, etc.
    '''

@dataclass(repr=False)
class Status(Identity):
    '''
    Current status information relevant to an entity.
    '''

    dateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Date and time for which status 'value' applies.
    '''

    reason: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Reason code or explanation for why an object went to the current status
    'value'.
    '''

    remark: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Pertinent information regarding the current 'value', as free form text.
    '''

    value: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Status value at 'dateTime'; prior status changes may have been kept in
    instances of activity records associated with the object to which this
    status applies.
    '''

@dataclass(repr=False)
class StreetAddress(Identity):
    '''
    General purpose street address information.
    '''

@dataclass(repr=False)
class StreetDetail(Identity):
    '''
    Street details, in the context of address.
    '''

    addressGeneral: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Additional address information, for example a mailstop.
    '''

    buildingName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if applicable) In certain cases the physical location of the place of
    interest does not have a direct point of entry from the street, but may
    be located inside a larger structure such as a building, complex, office
    block, apartment, etc.
    '''

    code: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if applicable) Utilities often make use of external reference systems,
    such as those of the town-planner's department or surveyor general's mapping
    system, that allocate global reference codes to streets.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Name of the street.
    '''

    number: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Designator of the specific location on the street.
    '''

    prefix: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Prefix to the street name. For example: North, South, East, West.
    '''

    suffix: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Suffix to the street name. For example: North, South, East, West.
    '''

    suiteNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Number of the apartment or suite.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Type of street. Examples include: street, circle, boulevard, avenue, road,
    drive, etc.
    '''

    withinTownLimits: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    True if this street is within the legal geographical boundaries of the
    specified town (default).
    '''

@dataclass(repr=False)
class StringQuantity(Identity):
    '''
    Quantity with string value (when it is not important whether it is an integral
    or a floating point number) and associated unit information.
    '''

    value: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

    unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    '''

@dataclass(repr=False)
class TelephoneNumber(Identity):
    '''
    Telephone number.
    '''

    areaCode: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Area or region code.
    '''

    cityCode: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if applicable) City code.
    '''

    countryCode: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Country code.
    '''

    extension: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    (if applicable) Extension for this telephone number.
    '''

    localNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Main (local) part of this telephone number.
    '''

@dataclass(repr=False)
class TimeInterval(Identity):
    '''
    Interval between two times.
    '''

    end: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    End time of this interval.
    '''

    start: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Start time of this interval.
    '''

@dataclass(repr=False)
class TownDetail(Identity):
    '''
    Town details, in the context of address.
    '''

    code: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Town code.
    '''

    country: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Name of the country.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Town name.
    '''

    section: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Town section. For example, it is common for there to be 36 sections per
    township.
    '''

    stateOrProvince: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/2012/CIM-schema-cim16#'
        })
    '''
    Name of the state or province.
    '''
