from __future__ import annotations
import logging
from dataclasses import dataclass, field
from typing import Optional
from enum import Enum
from cimgraph.data_profile.identity import Identity, stereotype
from cimgraph.data_profile.units import CIMUnit, UnitSymbol, UnitMultiplier
_log = logging.getLogger(__name__)
'''
Annotated CIMantic Graphs data profile for canonical
Generated by CIMTool http://cimtool.org
'''

class CIMStereotype(Enum):
    AggregateOf = "AggregateOf"
    Attribute = "Attribute"
    CIMDatatype = "CIMDatatype"
    GridAPPSD = "GridAPPSD"
    OfAggregate = "OfAggregate"
    Primitive = "Primitive"
    ShadowExtension = "ShadowExtension"
    deprecated = "deprecated"
    enumeration = "enumeration"
    harmonization = "harmonization"
    informative = "informative"

BASE_URI = 'http://www.gridappsd.org/CIM#'
ONTOLOGY_URI = 'http://iec.ch/TC57/CIM100#'

@dataclass(repr=False)
class BranchGroupTerminal(Identity):
    '''
    A specific directed terminal flow for a branch group.
    '''

    positiveFlowIn: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The flow into the terminal is summed if set true. The flow out of the terminal
            is summed if set false.
            '''
        
        })
    '''
    The flow into the terminal is summed if set true. The flow out of the
    terminal is summed if set false.
    '''
    
    BranchGroup: Optional[BranchGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BranchGroup.BranchGroupTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The branch group to which the directed branch group terminals belong.
            '''
        
        })
    '''
    The branch group to which the directed branch group terminals belong.
    '''
    
    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.BranchGroupTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The terminal to be summed.
            '''
        
        })
    '''
    The terminal to be summed.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CableArmorInfo(Identity):
    '''
    '''

    materialName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    numberOfTapes: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    strandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    diameterOverArmor: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    layLength: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    strandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    tapeLap: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    tapeThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TapeWidth: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Thickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CapacitorBankInfo(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CapacitorBankPhaseInfo(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CapacitorCanInfo(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ChangeSetMember(Identity):
    '''
    A CRUD-style data object.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    PropertiesObject: Optional[IdentifiedObject] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IdentifiedObject.PropertiesCIMDataObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The CIM object holding the properties of this dataset context. Sometimes
            properties are not required and only the reference to the registered object
            is required.
            '''
        
        })
    '''
    The CIM object holding the properties of this dataset context. Sometimes
    properties are not required and only the reference to the registered
    object is required.
    '''
    
@dataclass(repr=False)
class Crossarm(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CurveData(Identity):
    '''
    Multi-purpose data points for defining a curve. The use of this generic
    class is discouraged if a more specific class can be used to specify the
    X and Y axis values along with their specific data types.
    '''

    xvalue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The data value of the X-axis variable, depending on the X-axis units.
            '''
        
        })
    '''
    The data value of the X-axis variable, depending on the X-axis units.
    '''
    
    y1value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The data value of the first Y-axis variable, depending on the Y-axis units.
            '''
        
        })
    '''
    The data value of the first Y-axis variable, depending on the Y-axis
    units.
    '''
    
    y2value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The data value of the second Y-axis variable (if present), depending on
            the Y-axis units.
            '''
        
        })
    '''
    The data value of the second Y-axis variable (if present), depending
    on the Y-axis units.
    '''
    
    y3value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The data value of the third Y-axis variable (if present), depending on
            the Y-axis units.
            '''
        
        })
    '''
    The data value of the third Y-axis variable (if present), depending
    on the Y-axis units.
    '''
    
    Curve: Optional[Curve] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Curve.CurveDatas',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The curve of this curve data point.
            '''
        
        })
    '''
    The curve of this curve data point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a root class to provide common identification for all classes needing
    identification and naming attributes.
    '''

    mRID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Master resource identifier issued by a model authority. The mRID is unique
            within an exchange context. Global uniqueness is easily achieved by using
            a UUID, as specified in RFC 4122, for the mRID. The use of UUID is strongly
            recommended.
            For CIMXML data files in RDF syntax conforming to IEC 61970-552, the mRID
            is mapped to rdf:ID or rdf:about attributes that identify CIM object elements.
            '''
        
        })
    '''
    Master resource identifier issued by a model authority. The mRID is
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in RFC 4122, for the mRID. The use of
    UUID is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552, the
    mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
    object elements.
    '''
    
    aliasName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The aliasName is free text human readable name of the object alternative
            to IdentifiedObject.name. It may be non unique and may not correlate to
            a naming hierarchy.
            The attribute aliasName is retained because of backwards compatibility
            between CIM relases. It is however recommended to replace aliasName with
            the Name class as aliasName is planned for retirement at a future time.
            '''
        
        })
    '''
    The aliasName is free text human readable name of the object alternative
    to IdentifiedObject.name. It may be non unique and may not correlate
    to a naming hierarchy.
    The attribute aliasName is retained because of backwards compatibility
    between CIM relases. It is however recommended to replace aliasName
    with the Name class as aliasName is planned for retirement at a future
    time.
    '''
    
    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''
        
        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''
    
    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The name is any free human readable and possibly non unique text naming
            the object.
            '''
        
        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''
    
    InstanceSet: Optional[InstanceSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InstanceSet.InstanceSetMember',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Dataset containing the data objects.
            '''
        
        })
    '''
    Dataset containing the data objects.
    '''
    
    PropertiesCIMDataObject: Optional[ChangeSetMember] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ChangeSetMember.PropertiesObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The single CIM data object in the appropriate dataset context.
            '''
        
        })
    '''
    The single CIM data object in the appropriate dataset context.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    Names: list[Name] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Name.IdentifiedObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All names of this identified object.
            '''
        
        })
    '''
    All names of this identified object.
    '''
    
@dataclass(repr=False)
class ACDCTerminal(IdentifiedObject):
    '''
    An electrical connection point (AC or DC) to a piece of conducting equipment.
    Terminals are connected at physical connection points called connectivity
    nodes.
    '''

    connected: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The connected status is related to a bus-branch model and the topological
            node to terminal relation. True implies the terminal is connected to the
            related topological node and false implies it is not.
            In a bus-branch model, the connected status is used to tell if equipment
            is disconnected without having to change the connectivity described by
            the topological node to terminal relation. A valid case is that conducting
            equipment can be connected in one end and open in the other. In particular
            for an AC line segment, where the reactive line charging can be significant,
            this is a relevant case.
            '''
        
        })
    '''
    The connected status is related to a bus-branch model and the topological
    node to terminal relation. True implies the terminal is connected to
    the related topological node and false implies it is not.
    In a bus-branch model, the connected status is used to tell if equipment
    is disconnected without having to change the connectivity described
    by the topological node to terminal relation. A valid case is that
    conducting equipment can be connected in one end and open in the other.
    In particular for an AC line segment, where the reactive line charging
    can be significant, this is a relevant case.
    '''
    
    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The orientation of the terminal connections for a multiple terminal conducting
            equipment. The sequence numbering starts with 1 and additional terminals
            should follow in increasing order. The first terminal is the "starting
            point" for a two terminal branch.
            '''
        
        })
    '''
    The orientation of the terminal connections for a multiple terminal
    conducting equipment. The sequence numbering starts with 1 and additional
    terminals should follow in increasing order. The first terminal is
    the "starting point" for a two terminal branch.
    '''
    
    BusNameMarker: Optional[BusNameMarker] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BusNameMarker.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The bus name marker used to name the bus (topological node).
            '''
        
        })
    '''
    The bus name marker used to name the bus (topological node).
    '''
    
    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Measurements associated with this terminal defining where the measurement
            is placed in the network topology. It may be used, for instance, to capture
            the sensor position, such as a voltage transformer (PT) at a busbar or
            a current transformer (CT) at the bar between a breaker and an isolator.
            '''
        
        })
    '''
    Measurements associated with this terminal defining where the measurement
    is placed in the network topology. It may be used, for instance, to
    capture the sensor position, such as a voltage transformer (PT) at
    a busbar or a current transformer (CT) at the bar between a breaker
    and an isolator.
    '''
    
    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The operational limit sets at the terminal.
            '''
        
        })
    '''
    The operational limit sets at the terminal.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCBaseTerminal(ACDCTerminal):
    '''
    An electrical connection point at a piece of DC conducting equipment. DC
    terminals are connected at one physical DC node that may have multiple
    DC terminals connected. A DC node is similar to an AC connectivity node.
    The model requires that DC connections are distinct from AC connections.
    '''

    DCNode: Optional[DCNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCNode.DCTerminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The DC connectivity node to which this DC base terminal connects with zero
            impedance.
            '''
        
        })
    '''
    The DC connectivity node to which this DC base terminal connects with
    zero impedance.
    '''
    
    DCTopologicalNode: Optional[DCTopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTopologicalNode.DCTerminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            See association end Terminal.TopologicalNode.
            '''
        
        })
    '''
    See association end Terminal.TopologicalNode.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ACDCConverterDCTerminal(DCBaseTerminal):
    '''
    A DC electrical connection point at the AC/DC converter. The AC/DC converter
    is electrically connected also to the AC side. The AC connection is inherited
    from the AC conducting equipment in the same way as any other AC equipment.
    The AC/DC converter DC terminal is separate from generic DC terminal to
    restrict the connection with the AC side to AC/DC converter and so that
    no other DC conducting equipment can be connected to the AC side.
    '''

    polarity: Optional[ DCPolarityKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Represents the normal network polarity condition. Depending on the converter
            configuration the value shall be set as follows:
            - For a monopole with two converter terminals use DCPolarityKind �positive�
            and �negative�.
            - For a bi-pole or symmetric monopole with three converter terminals use
            DCPolarityKind �positive�, �middle� and �negative�.
            '''
        
        })
    '''
    Represents the normal network polarity condition. Depending on the
    converter configuration the value shall be set as follows:
    - For a monopole with two converter terminals use DCPolarityKind �positive�
    and �negative�.
    - For a bi-pole or symmetric monopole with three converter terminals
    use DCPolarityKind �positive�, �middle� and �negative�.
    '''
    
    DCConductingEquipment: Optional[ACDCConverter] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCConverter.DCTerminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A DC converter terminal belong to an DC converter.
            '''
        
        })
    '''
    A DC converter terminal belong to an DC converter.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCTerminal(DCBaseTerminal):
    '''
    An electrical connection point to generic DC conducting equipment.
    '''

    DCConductingEquipment: Optional[DCConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCConductingEquipment.DCTerminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            An DC terminal belong to a DC conducting equipment.
            '''
        
        })
    '''
    An DC terminal belong to a DC conducting equipment.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Terminal(ACDCTerminal):
    '''
    An AC electrical connection point to a piece of conducting equipment. Terminals
    are connected at physical connection points called connectivity nodes.
    '''

    phases: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Represents the normal network phasing condition. If the attribute is missing,
            three phases (ABC) shall be assumed, except for terminals of grounding
            classes (specializations of EarthFaultCompensator, GroundDisconnector,
            and Ground) which will be assumed to be N. Therefore, phase code ABCN is
            explicitly declared when needed, e.g. for star point grounding equipment.
            The phase code on terminals connecting same ConnectivityNode or same TopologicalNode
            as well as for equipment between two terminals shall be consistent.
            '''
        
        })
    '''
    Represents the normal network phasing condition. If the attribute is
    missing, three phases (ABC) shall be assumed, except for terminals
    of grounding classes (specializations of EarthFaultCompensator, GroundDisconnector,
    and Ground) which will be assumed to be N. Therefore, phase code ABCN
    is explicitly declared when needed, e.g. for star point grounding equipment.
    The phase code on terminals connecting same ConnectivityNode or same
    TopologicalNode as well as for equipment between two terminals shall
    be consistent.
    '''
    
    Bushing: Optional[Bushing] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Bushing.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Circuit: Optional[Circuit] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Circuit.EndTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ConductingEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.Terminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The conducting equipment of the terminal. Conducting equipment have terminals
            that may be connected to other conducting equipment terminals via connectivity
            nodes or topological nodes.
            '''
        
        })
    '''
    The conducting equipment of the terminal. Conducting equipment have
    terminals that may be connected to other conducting equipment terminals
    via connectivity nodes or topological nodes.
    '''
    
    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.Terminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The connectivity node to which this terminal connects with zero impedance.
            '''
        
        })
    '''
    The connectivity node to which this terminal connects with zero impedance.
    '''
    
    NormalHeadFeeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.NormalHeadTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The feeder that this terminal normally feeds. Only specified for the terminals
            at head of feeders.
            '''
        
        })
    '''
    The feeder that this terminal normally feeds. Only specified for the
    terminals at head of feeders.
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The topological node associated with the terminal. This can be used as
            an alternative to the connectivity node path to topological node, thus
            making it unnecessary to model connectivity nodes in some cases. Note that
            the if connectivity nodes are in the model, this association would probably
            not be used as an input specification.
            '''
        
        })
    '''
    The topological node associated with the terminal. This can be used
    as an alternative to the connectivity node path to topological node,
    thus making it unnecessary to model connectivity nodes in some cases.
    Note that the if connectivity nodes are in the model, this association
    would probably not be used as an input specification.
    '''
    
    ConverterDCSides: list[ACDCConverter] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACDCConverter.PccTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All converters' DC sides linked to this point of common coupling terminal.
            '''
        
        })
    '''
    All converters' DC sides linked to this point of common coupling terminal.
    '''
    
    AuxiliaryEquipment: list[AuxiliaryEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AuxiliaryEquipment.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The auxiliary equipment connected to the terminal.
            '''
        
        })
    '''
    The auxiliary equipment connected to the terminal.
    '''
    
    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BranchGroupTerminal.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The directed branch group terminals for which this terminal is monitored.
            '''
        
        })
    '''
    The directed branch group terminals for which this terminal is monitored.
    '''
    
    HasFirstMutualCoupling: list[MutualCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MutualCoupling.First_Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Mutual couplings associated with the branch as the first branch.
            '''
        
        })
    '''
    Mutual couplings associated with the branch as the first branch.
    '''
    
    HasSecondMutualCoupling: list[MutualCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MutualCoupling.Second_Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Mutual couplings with the branch associated as the first branch.
            '''
        
        })
    '''
    Mutual couplings with the branch associated as the first branch.
    '''
    
    RegulatingControl: list[RegulatingControl] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulatingControl.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The controls regulating this terminal.
            '''
        
        })
    '''
    The controls regulating this terminal.
    '''
    
    SvPowerFlow: list[SvPowerFlow] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvPowerFlow.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The power flow state variable associated with the terminal.
            '''
        
        })
    '''
    The power flow state variable associated with the terminal.
    '''
    
    TransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All transformer ends connected at this terminal.
            '''
        
        })
    '''
    All transformer ends connected at this terminal.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Asset(IdentifiedObject):
    '''
    Tangible resource of the utility, including power system equipment, various
    end devices, cabinets, buildings, etc. For electrical network equipment,
    the role of the asset is defined through PowerSystemResource and its subclasses,
    defined mainly in the Wires model (refer to IEC61970-301 and model package
    IEC61970::Wires). Asset description places emphasis on the physical characteristics
    of the equipment fulfilling that role.
    '''

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Measurement related to this asset.
            '''
        
        })
    '''
    Measurement related to this asset.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Bushing(Asset):
    '''
    Bushing asset.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.Bushing',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Terminal to which this bushing is attached.
            '''
        
        })
    '''
    Terminal to which this bushing is attached.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class DuctBank(Asset):
    '''
    A duct contains individual wires in the layout as specified with associated
    wire spacing instances; number of them gives the number of conductors in
    this duct.
    '''

    WireSpacingInfos: list[WireSpacingInfo] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireSpacingInfo.DuctBank',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssetInfo(IdentifiedObject):
    '''
    Set of attributes of an asset, representing typical datasheet information
    of a physical device that can be instantiated and shared in different data
    exchange contexts:
    - as attributes of an asset instance (installed or in stock)
    - as attributes of an asset model (product by a manufacturer)
    - as attributes of a type asset (generic type of an asset as used in designs/extension
    planning).
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.AssetDatasheet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All power system resources with this datasheet information.
            '''
        
        })
    '''
    All power system resources with this datasheet information.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BusbarSectionInfo(AssetInfo):
    '''
    Busbar section data.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BushingInfo(AssetInfo):
    '''
    Bushing datasheet information.
    '''

    c1Capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Factory measured capacitance, measured between the power factor tap and
            the bushing conductor.
            '''
        
        })
    '''
    Factory measured capacitance, measured between the power factor tap
    and the bushing conductor.
    '''
    
    c1PowerFactor: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Factory measured insulation power factor, measured between the power factor
            tap and the bushing conductor.
            '''
        
        })
    '''
    Factory measured insulation power factor, measured between the power
    factor tap and the bushing conductor.
    '''
    
    c2Capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Factory measured capacitance measured between the power factor tap and
            ground.
            '''
        
        })
    '''
    Factory measured capacitance measured between the power factor tap
    and ground.
    '''
    
    c2PowerFactor: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Factory measured insulation power factor, measured between the power factor
            tap and ground.
            '''
        
        })
    '''
    Factory measured insulation power factor, measured between the power
    factor tap and ground.
    '''
    
    insulationKind: Optional[ BushingInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of insulation.
            '''
        
        })
    '''
    Kind of insulation.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current for bushing as installed.
            '''
        
        })
    '''
    Rated current for bushing as installed.
    '''
    
    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
            '''
        
        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''
    
    ratedLineToGroundVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated line-to-ground voltage. Also referred to as Uy on bushing nameplate.
            '''
        
        })
    '''
    Rated line-to-ground voltage. Also referred to as Uy on bushing nameplate.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage. Can be referred to as Um, system voltage or class on bushing
            nameplate.
            '''
        
        })
    '''
    Rated voltage. Can be referred to as Um, system voltage or class on
    bushing nameplate.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class InterrupterUnitInfo(AssetInfo):
    '''
    Interrupter datasheet information.
    '''

    interruptingMedium: Optional[ InterruptingMediumKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Interrupting medium.
            '''
        
        })
    '''
    Interrupting medium.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperatingMechanismInfo(AssetInfo):
    '''
    Breaker operating mechanism datasheet information.
    '''

    closeAmps: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Close current (nominal).
            '''
        
        })
    '''
    Close current (nominal).
    '''
    
    closeVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Close voltage in volts DC.
            '''
        
        })
    '''
    Close voltage in volts DC.
    '''
    
    mechanismKind: Optional[ OperatingMechanismKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of breaker operating mechanism.
            '''
        
        })
    '''
    Kind of breaker operating mechanism.
    '''
    
    motorRunCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated motor run current in amps.
            '''
        
        })
    '''
    Rated motor run current in amps.
    '''
    
    motorStartCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated motor start current in amps.
            '''
        
        })
    '''
    Rated motor start current in amps.
    '''
    
    motorVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Nominal motor voltage in volts DC.
            '''
        
        })
    '''
    Nominal motor voltage in volts DC.
    '''
    
    tripAmps: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Trip current (nominal).
            '''
        
        })
    '''
    Trip current (nominal).
    '''
    
    tripVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Trip voltage in volts DC.
            '''
        
        })
    '''
    Trip voltage in volts DC.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseToPhaseSpacing(AssetInfo):
    '''
    Distance from
    '''

    sequenceNumberWire1: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    sequenceNumberWire2: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    distance: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    fromPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    toPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.PhaseSpacing',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerTransformerInfo(AssetInfo):
    '''
    Set of power transformer data, from an equipment library.
    '''

    TransformerTankInfos: list[TransformerTankInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTankInfo.PowerTransformerInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Data for all the tanks described by this power transformer data.
            '''
        
        })
    '''
    Data for all the tanks described by this power transformer data.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ShuntCompensatorInfo(AssetInfo):
    '''
    Properties of shunt capacitor, shunt reactor or switchable bank of shunt
    capacitor or reactor assets.
    '''

    maxPowerLoss: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum allowed apparent power loss.
            '''
        
        })
    '''
    Maximum allowed apparent power loss.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated reactive power.
            '''
        
        })
    '''
    Rated reactive power.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    ShuntCompensatorControl: Optional[ShuntCompensatorControl] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorControl.ShuntCompensatorInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SwitchInfo(AssetInfo):
    '''
    <was Switch data.>
    Switch datasheet information.
    '''

    isSinglePhase: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, it is a single phase switch.
            '''
        
        })
    '''
    If true, it is a single phase switch.
    '''
    
    isUnganged: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, the switch is not ganged (i.e., a switch phase may be operated
            separately from other phases).
            '''
        
        })
    '''
    If true, the switch is not ganged (i.e., a switch phase may be operated
    separately from other phases).
    '''
    
    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum fault current a breaking device can break safely under prescribed
            conditions of use.
            '''
        
        })
    '''
    The maximum fault current a breaking device can break safely under
    prescribed conditions of use.
    '''
    
    gasWeightPerTank: Optional[ float | Mass ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Weight of gas in each tank of SF6 dead tank breaker.
            '''
        
        })
    '''
    Weight of gas in each tank of SF6 dead tank breaker.
    '''
    
    lowPressureAlarm: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Gas or air pressure at or below which a low pressure alarm is generated.
            '''
        
        })
    '''
    Gas or air pressure at or below which a low pressure alarm is generated.
    '''
    
    lowPressureLockOut: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Gas or air pressure below which the breaker will not open.
            '''
        
        })
    '''
    Gas or air pressure below which the breaker will not open.
    '''
    
    oilVolumePerTank: Optional[ float | Volume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Volume of oil in each tank of bulk oil breaker.
            '''
        
        })
    '''
    Volume of oil in each tank of bulk oil breaker.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Frequency for which switch is rated.
            '''
        
        })
    '''
    Frequency for which switch is rated.
    '''
    
    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
            '''
        
        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''
    
    ratedInterruptingTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Switch rated interrupting time in seconds.
            '''
        
        })
    '''
    Switch rated interrupting time in seconds.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapChangerInfo(AssetInfo):
    '''
    Tap changer data.
    '''

    ctRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Built-in current transducer ratio.
            '''
        
        })
    '''
    Built-in current transducer ratio.
    '''
    
    highStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Highest possible tap step position, advance from neutral.
            '''
        
        })
    '''
    Highest possible tap step position, advance from neutral.
    '''
    
    isTcul: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Whether this tap changer has under load tap changing capabilities.
            '''
        
        })
    '''
    Whether this tap changer has under load tap changing capabilities.
    '''
    
    lowStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Lowest possible tap step position, retard from neutral.
            '''
        
        })
    '''
    Lowest possible tap step position, retard from neutral.
    '''
    
    neutralStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The neutral tap step position for the winding.
            '''
        
        })
    '''
    The neutral tap step position for the winding.
    '''
    
    ptRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Built-in voltage transducer ratio.
            '''
        
        })
    '''
    Built-in voltage transducer ratio.
    '''
    
    bil: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Basic Insulation Level (BIL) expressed as the impulse crest voltage of
            a nominal wave, typically 1.2 X 50 microsecond. This is a measure of the
            ability of the insulation to withstand very high voltage surges.
            '''
        
        })
    '''
    Basic Insulation Level (BIL) expressed as the impulse crest voltage
    of a nominal wave, typically 1.2 X 50 microsecond. This is a measure
    of the ability of the insulation to withstand very high voltage surges.
    '''
    
    ctRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Built-in current transformer primary rating.
            '''
        
        })
    '''
    Built-in current transformer primary rating.
    '''
    
    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Frequency at which the ratings apply.
            '''
        
        })
    '''
    Frequency at which the ratings apply.
    '''
    
    neutralU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Voltage at which the winding operates at the neutral tap setting.
            '''
        
        })
    '''
    Voltage at which the winding operates at the neutral tap setting.
    '''
    
    ratedApparentPower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated apparent power.
            '''
        
        })
    '''
    Rated apparent power.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    stepPhaseIncrement: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase shift per step position.
            '''
        
        })
    '''
    Phase shift per step position.
    '''
    
    stepVoltageIncrement: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Tap step increment, in per cent of rated voltage, per step position.
            '''
        
        })
    '''
    Tap step increment, in per cent of rated voltage, per step position.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerEndInfo(AssetInfo):
    '''
    Transformer end data.
    '''

    endNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number for this transformer end, corresponding to the end's order in the
            PowerTransformer.vectorGroup attribute. Highest voltage winding should
            be 1.
            '''
        
        })
    '''
    Number for this transformer end, corresponding to the end's order in
    the PowerTransformer.vectorGroup attribute. Highest voltage winding
    should be 1.
    '''
    
    phaseAngleClock: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Winding phase angle where 360 degrees are represented with clock hours,
            so the valid values are {0, ..., 11}. For example, to express the second
            winding in code 'Dyn11', set attributes as follows: 'endNumber'=2, 'connectionKind'
            = Yn and 'phaseAngleClock' = 11.
            '''
        
        })
    '''
    Winding phase angle where 360 degrees are represented with clock hours,
    so the valid values are {0, ..., 11}. For example, to express the second
    winding in code 'Dyn11', set attributes as follows: 'endNumber'=2,
    'connectionKind' = Yn and 'phaseAngleClock' = 11.
    '''
    
    connectionKind: Optional[ WindingConnection ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of connection.
            '''
        
        })
    '''
    Kind of connection.
    '''
    
    emergencyS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Apparent power that the winding can carry under emergency conditions (also
            called long-term emergency power).
            '''
        
        })
    '''
    Apparent power that the winding can carry under emergency conditions
    (also called long-term emergency power).
    '''
    
    insulationU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Basic insulation level voltage rating.
            '''
        
        })
    '''
    Basic insulation level voltage rating.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            DC resistance.
            '''
        
        })
    '''
    DC resistance.
    '''
    
    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal apparent power rating.
            '''
        
        })
    '''
    Normal apparent power rating.
    '''
    
    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage: phase-phase for three-phase windings, and either phase-phase
            or phase-neutral for single-phase windings.
            '''
        
        })
    '''
    Rated voltage: phase-phase for three-phase windings, and either phase-phase
    or phase-neutral for single-phase windings.
    '''
    
    shortTermS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Apparent power that this winding can carry for a short period of time (in
            emergency).
            '''
        
        })
    '''
    Apparent power that this winding can carry for a short period of time
    (in emergency).
    '''
    
    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Core admittance calculated from this transformer end datasheet, representing
            magnetising current and core losses. The full values of the transformer
            should be supplied for one transformer end info only.
            '''
        
        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''
    
    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer star impedance calculated from this transformer end datasheet.
            '''
        
        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''
    
    TransformerTankInfo: Optional[TransformerTankInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerTankInfo.TransformerEndInfos',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer tank data that this end description is part of.
            '''
        
        })
    '''
    Transformer tank data that this end description is part of.
    '''
    
    EnergisedEndNoLoadTests: list[NoLoadTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NoLoadTest.EnergisedEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All no-load test measurements in which this transformer end was energised.
            '''
        
        })
    '''
    All no-load test measurements in which this transformer end was energised.
    '''
    
    EnergisedEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OpenCircuitTest.EnergisedEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All open-circuit test measurements in which this transformer end was excited.
            '''
        
        })
    '''
    All open-circuit test measurements in which this transformer end was
    excited.
    '''
    
    OpenEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OpenCircuitTest.OpenEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All open-circuit test measurements in which this transformer end was not
            excited.
            '''
        
        })
    '''
    All open-circuit test measurements in which this transformer end was
    not excited.
    '''
    
    EnergisedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitTest.EnergisedEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All short-circuit test measurements in which this transformer end was energised.
            '''
        
        })
    '''
    All short-circuit test measurements in which this transformer end was
    energised.
    '''
    
    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Core admittance calculated from this transformer end datasheet, representing
            magnetising current and core losses. The full values of the transformer
            should be supplied for one transformer end info only.
            '''
        
        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''
    
    FromMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerMeshImpedance.FromTransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All mesh impedances between this 'to' and other 'from' transformer ends.
            '''
        
        })
    '''
    All mesh impedances between this 'to' and other 'from' transformer
    ends.
    '''
    
    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Transformer star impedance calculated from this transformer end datasheet.
            '''
        
        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerTankInfo(AssetInfo):
    '''
    Set of transformer tank data, from an equipment library.
    '''

    PowerTransformerInfo: Optional[PowerTransformerInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerTransformerInfo.TransformerTankInfos',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power transformer data that this tank description is part of.
            '''
        
        })
    '''
    Power transformer data that this tank description is part of.
    '''
    
    TransformerEndInfos: list[TransformerEndInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEndInfo.TransformerTankInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Data for all the ends described by this transformer tank data.
            '''
        
        })
    '''
    Data for all the ends described by this transformer tank data.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.GridAPPSD)
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class WireAssemblyInfo(AssetInfo):
    '''
    Describes the construction of a multi-conductor wire.
    '''

    numberOfPhases: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    installationType: Optional[ WireInstallationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration GridAPPSD Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    usage: Optional[ WireUsageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    EarthResistivity: Optional[EarthResistivity] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EarthResistivity.WireAssemblyInfos',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthImpedance.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthImpedance.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PerLengthLineParameter: list[PerLengthLineParameter] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PerLengthLineParameter.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Per length line parameter associated with this wire assembly.
            '''
        
        })
    '''
    Per length line parameter associated with this wire assembly.
    '''
    
    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Wire phase information associated with this wire assembly.
            '''
        
        })
    '''
    Wire phase information associated with this wire assembly.
    '''
    
    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WireBundleInfo(AssetInfo):
    '''
    '''

    wireCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    gmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Equivalent geometric mean radius of the symmetric conductor bundle, calculated
            from the radius
            '''
        
        })
    '''
    Equivalent geometric mean radius of the symmetric conductor bundle,
    calculated from the radius
    '''
    
    radius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Equivalent radius of the conductor
            '''
        
        })
    '''
    Equivalent radius of the conductor
    '''
    
    wireSpacing: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Distance between wire sub-conductors in a symmetrical bundle.
            '''
        
        })
    '''
    Distance between wire sub-conductors in a symmetrical bundle.
    '''
    
    WireInfo: Optional[WireInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireInfo.WireBundleInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class WireInfo(AssetInfo):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    coreStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if used) Number of strands in the steel core.
            '''
        
        })
    '''
    (if used) Number of strands in the steel core.
    '''
    
    insulated: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if conductor is insulated.
            '''
        
        })
    '''
    True if conductor is insulated.
    '''
    
    sizeDescription: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
            '''
        
        })
    '''
    Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
    '''
    
    strandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of strands in the conductor.
            '''
        
        })
    '''
    Number of strands in the conductor.
    '''
    
    constructionKind: Optional[ WireMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    coreRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if there is a different core material) Radius of the central core.
            '''
        
        })
    '''
    (if there is a different core material) Radius of the central core.
    '''
    
    coreStrandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    gmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Geometric mean radius. If we replace the conductor by a thin walled tube
            of radius GMR, then its reactance is identical to the reactance of the
            actual conductor.
            '''
        
        })
    '''
    Geometric mean radius. If we replace the conductor by a thin walled
    tube of radius GMR, then its reactance is identical to the reactance
    of the actual conductor.
    '''
    
    insulationMaterial: Optional[ WireInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if insulated conductor) Material used for insulation.
            '''
        
        })
    '''
    (if insulated conductor) Material used for insulation.
    '''
    
    insulationThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if insulated conductor) Thickness of the insulation.
            '''
        
        })
    '''
    (if insulated conductor) Thickness of the insulation.
    '''
    
    material: Optional[ WireMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Conductor material.
            '''
        
        })
    '''
    Conductor material.
    '''
    
    rAC25: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            AC resistance per unit length of the conductor at 25 �C.
            '''
        
        })
    '''
    AC resistance per unit length of the conductor at 25 �C.
    '''
    
    rAC50: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            AC resistance per unit length of the conductor at 50 �C.
            '''
        
        })
    '''
    AC resistance per unit length of the conductor at 50 �C.
    '''
    
    rAC75: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            AC resistance per unit length of the conductor at 75 �C.
            '''
        
        })
    '''
    AC resistance per unit length of the conductor at 75 �C.
    '''
    
    radius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Outside radius of the wire.
            '''
        
        })
    '''
    Outside radius of the wire.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Current carrying capacity of the wire under stated thermal conditions.
            '''
        
        })
    '''
    Current carrying capacity of the wire under stated thermal conditions.
    '''
    
    rDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            DC resistance per unit length of the conductor at 20 �C.
            '''
        
        })
    '''
    DC resistance per unit length of the conductor at 20 �C.
    '''
    
    strandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ACLineSegmentPhase: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.WireInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            AC line segment phase information associated with this wire information.
            '''
        
        })
    '''
    AC line segment phase information associated with this wire information.
    '''
    
    WireBundleInfo: list[WireBundleInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireBundleInfo.WireInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Wire phase information associated with this wire information.
            '''
        
        })
    '''
    Wire phase information associated with this wire information.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class CableInfo(WireInfo):
    '''
    Cable data.
    '''

    isStrandFill: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if wire strands are extruded in a way to fill the voids in the cable.
            '''
        
        })
    '''
    True if wire strands are extruded in a way to fill the voids in the
    cable.
    '''
    
    sheathAsNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if sheath / shield is used as a neutral (i.e., bonded).
            '''
        
        })
    '''
    True if sheath / shield is used as a neutral (i.e., bonded).
    '''
    
    constructionKind: Optional[ CableConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of construction of this cable.
            '''
        
        })
    '''
    Kind of construction of this cable.
    '''
    
    diameterOverCore: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter over the core, including any semi-con screen; should be the insulating
            layer's inside diameter.
            '''
        
        })
    '''
    Diameter over the core, including any semi-con screen; should be the
    insulating layer's inside diameter.
    '''
    
    diameterOverInsulation: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter over the insulating layer, excluding outer screen.
            '''
        
        })
    '''
    Diameter over the insulating layer, excluding outer screen.
    '''
    
    diameterOverJacket: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter over the outermost jacketing layer.
            '''
        
        })
    '''
    Diameter over the outermost jacketing layer.
    '''
    
    diameterOverScreen: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter over the outer screen; should be the shield's inside diameter.
            '''
        
        })
    '''
    Diameter over the outer screen; should be the shield's inside diameter.
    '''
    
    nominalTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum nominal design operating temperature.
            '''
        
        })
    '''
    Maximum nominal design operating temperature.
    '''
    
    outerJacketKind: Optional[ CableOuterJacketKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of outer jacket of this cable.
            '''
        
        })
    '''
    Kind of outer jacket of this cable.
    '''
    
    shieldMaterial: Optional[ CableShieldMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Material of the shield.
            '''
        
        })
    '''
    Material of the shield.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConcentricNeutralCableInfo(CableInfo):
    '''
    Concentric neutral cable data.
    '''

    neutralStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of concentric neutral strands.
            '''
        
        })
    '''
    Number of concentric neutral strands.
    '''
    
    diameterOverNeutral: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter over the concentric neutral strands.
            '''
        
        })
    '''
    Diameter over the concentric neutral strands.
    '''
    
    neutralStrandGmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Geometric mean radius of the neutral strand.
            '''
        
        })
    '''
    Geometric mean radius of the neutral strand.
    '''
    
    neutralStrandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Outside radius of the neutral strand.
            '''
        
        })
    '''
    Outside radius of the neutral strand.
    '''
    
    neutralStrandRDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            DC resistance per unit length of the neutral strand at 20 �C.
            '''
        
        })
    '''
    DC resistance per unit length of the neutral strand at 20 �C.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapeShieldCableInfo(CableInfo):
    '''
    Tape shield cable data.
    '''

    tapeLap: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Percentage of the tape shield width that overlaps in each wrap, typically
            10% to 25%.
            '''
        
        })
    '''
    Percentage of the tape shield width that overlaps in each wrap, typically
    10% to 25%.
    '''
    
    tapeThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Thickness of the tape shield, before wrapping.
            '''
        
        })
    '''
    Thickness of the tape shield, before wrapping.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class OverheadWireInfo(WireInfo):
    '''
    Overhead wire data.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WireSpacingInfo(AssetInfo):
    '''
    Wire spacing data that associates multiple wire positions with the line
    segment, and allows to calculate line segment impedances. Number of phases
    can be derived from the number of associated wire positions whose phase
    is not neutral.
    '''

    isCable: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, this spacing data describes a cable.
            '''
        
        })
    '''
    If true, this spacing data describes a cable.
    '''
    
    phaseWireCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of wire sub-conductors in the symmetrical bundle (typically between
            1 and 4).
            '''
        
        })
    '''
    Number of wire sub-conductors in the symmetrical bundle (typically
    between 1 and 4).
    '''
    
    phaseWireSpacing: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Distance between wire sub-conductors in a symmetrical bundle.
            '''
        
        })
    '''
    Distance between wire sub-conductors in a symmetrical bundle.
    '''
    
    usage: Optional[ WireUsageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Usage of the associated wires.
            '''
        
        })
    '''
    Usage of the associated wires.
    '''
    
    DuctBank: Optional[DuctBank] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DuctBank.WireSpacingInfos',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ACLineSegment: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The AC line segment defined by the wire spacing information
            '''
        
        })
    '''
    The AC line segment defined by the wire spacing information
    '''
    
    PhaseSpacing: list[PhaseToPhaseSpacing] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseToPhaseSpacing.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WirePositions: list[WirePosition] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePosition.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All positions of single wires (phase or neutral) making the conductor.
            '''
        
        })
    '''
    All positions of single wires (phase or neutral) making the conductor.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AsynchronousMachineDynamics(IdentifiedObject):
    '''
    Asynchronous machine whose behaviour is described by reference to a standard
    model expressed in either time constant reactance form or equivalent circuit
    form <font color="#0f0f0f">or by definition of a user-defined model.</font>
    Parameter details:
    <ol>
    <li>Asynchronous machine parameters such as <i>Xl, Xs,</i> etc. are actually
    used as inductances in the model, but are commonly referred to as reactances
    since, at nominal frequency, the PU values are the same. However, some
    references use the symbol <i>L</i> instead of <i>X</i>.</li>
    </ol>
    '''

    AsynchronousMachine: Optional[AsynchronousMachine] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AsynchronousMachine.AsynchronousMachineDynamics',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Asynchronous machine to which this asynchronous machine dynamics model
            applies.
            '''
        
        })
    '''
    Asynchronous machine to which this asynchronous machine dynamics model
    applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AsynchronousMachineDynamics'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BaseFrequency(IdentifiedObject):
    '''
    The BaseFrequency class describes a base frequency for a power system network.
    In case of multiple power networks with different frequencies, e.g. 50
    Hz or 60 Hz each network will have its own base frequency class. Hence
    it is assumed that power system objects having different base frequencies
    appear in separate documents where each document has a single base frequency
    instance.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The base frequency.
            '''
        
        })
    '''
    The base frequency.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BasePower(IdentifiedObject):
    '''
    The BasePower class defines the base power used in the per unit calculations.
    '''

    basePower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Value used as base power.
            '''
        
        })
    '''
    Value used as base power.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BaseVoltage(IdentifiedObject):
    '''
    Defines a system base voltage which is referenced.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The power system resource's base voltage. Shall be a positive value and
            not zero.
            '''
        
        })
    '''
    The power system resource's base voltage. Shall be a positive value
    and not zero.
    '''
    
    ConductingEquipment: list[ConductingEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConductingEquipment.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All conducting equipment with this base voltage. Use only when there is
            no voltage level container used and only one base voltage applies. For
            example, not used for transformers.
            '''
        
        })
    '''
    All conducting equipment with this base voltage. Use only when there
    is no voltage level container used and only one base voltage applies.
    For example, not used for transformers.
    '''
    
    TopologicalNode: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The topological nodes at the base voltage.
            '''
        
        })
    '''
    The topological nodes at the base voltage.
    '''
    
    TransformerEnds: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Transformer ends at the base voltage. This is essential for PU calculation.
            '''
        
        })
    '''
    Transformer ends at the base voltage. This is essential for PU calculation.
    '''
    
    VoltageLevel: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The voltage levels having this base voltage.
            '''
        
        })
    '''
    The voltage levels having this base voltage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BasicIntervalSchedule(IdentifiedObject):
    '''
    Schedule of values at points in time.
    '''

    startTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The time for the first time point. The value can be a time of day, not
            a specific date.
            '''
        
        })
    '''
    The time for the first time point. The value can be a time of day,
    not a specific date.
    '''
    
    value1Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for value1.
            '''
        
        })
    '''
    Multiplier for value1.
    '''
    
    value1Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Value1 units of measure.
            '''
        
        })
    '''
    Value1 units of measure.
    '''
    
    value2Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for value2.
            '''
        
        })
    '''
    Multiplier for value2.
    '''
    
    value2Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Value2 units of measure.
            '''
        
        })
    '''
    Value2 units of measure.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class IrregularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them varies.
    '''

    TimePoints: list[IrregularTimePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IrregularTimePoint.IntervalSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The point data values that define a curve.
            '''
        
        })
    '''
    The point data values that define a curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class RegularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them is constant.
    '''

    endTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The time for the last time point. The value can be a time of day, not a
            specific date.
            '''
        
        })
    '''
    The time for the last time point. The value can be a time of day, not
    a specific date.
    '''
    
    timeStep: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The time between each pair of subsequent regular time points in sequence
            order.
            '''
        
        })
    '''
    The time between each pair of subsequent regular time points in sequence
    order.
    '''
    
    TimePoints: list[RegularTimePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegularTimePoint.IntervalSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The regular interval time point data values that define this schedule.
            '''
        
        })
    '''
    The regular interval time point data values that define this schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class GenUnitOpSchedule(RegularIntervalSchedule):
    '''
    The generating unit's Operator-approved current operating schedule (or
    plan), typically produced with the aid of unit commitment type analyses.
    The X-axis represents absolute time. The Y1-axis represents the status
    (0=off-line and unavailable: 1=available: 2=must run: 3=must run at fixed
    power value: etc.). The Y2-axis represents the must run fixed power value
    where required.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''
        
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''
        
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HydroPumpOpSchedule(RegularIntervalSchedule):
    '''
    The hydro pump's Operator-approved current operating schedule (or plan),
    typically produced with the aid of unit commitment type analyses. The unit's
    operating schedule status is typically given as: (0=unavailable) (1=available
    to startup or shutdown) (2=must pump).
    '''

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.HydroPumpOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''
        
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.HydroPumpOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''
        
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class InflowForecast(RegularIntervalSchedule):
    '''
    Natural water inflow to a reservoir, usually forecasted from predicted
    rain and snowmelt. Typically in one hour increments for up to 10 days.
    The forecast is given in average cubic meters per second over the time
    increment.
    '''

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.InflowForecasts',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A reservoir may have a "natural" inflow forecast.
            '''
        
        })
    '''
    A reservoir may have a "natural" inflow forecast.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SeasonDayTypeSchedule(RegularIntervalSchedule):
    '''
    A time schedule covering a 24 hour period, with curve data for a specific
    type of season and day.
    '''

    DayType: Optional[DayType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DayType.SeasonDayTypeSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            DayType for the Schedule.
            '''
        
        })
    '''
    DayType for the Schedule.
    '''
    
    Season: Optional[Season] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Season.SeasonDayTypeSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Season for the Schedule.
            '''
        
        })
    '''
    Season for the Schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    A curve of load versus time (X-axis) showing the active power values (Y1-axis)
    and reactive power (Y2-axis) for each unit of the period covered. This
    curve represents a typical pattern of load over the time period for a given
    day type and season.
    '''

    ConformLoadGroup: Optional[ConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConformLoadGroup.ConformLoadSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The ConformLoadGroup where the ConformLoadSchedule belongs.
            '''
        
        })
    '''
    The ConformLoadGroup where the ConformLoadSchedule belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class NonConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    An active power (Y1-axis) and reactive power (Y2-axis) schedule (curves)
    versus time (X-axis) for non-conforming loads, e.g., large industrial load
    or power station service (where modelled).
    '''

    NonConformLoadGroup: Optional[NonConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NonConformLoadGroup.NonConformLoadSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The NonConformLoadGroup where the NonConformLoadSchedule belongs.
            '''
        
        })
    '''
    The NonConformLoadGroup where the NonConformLoadSchedule belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RegulationSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a controlled variable, e.g., busbar
    voltage.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegulatingControl.RegulationSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Regulating controls that have this schedule.
            '''
        
        })
    '''
    Regulating controls that have this schedule.
    '''
    
    VoltageControlZones: list[VoltageControlZone] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageControlZone.RegulationSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A VoltageControlZone may have a voltage regulation schedule.
            '''
        
        })
    '''
    A VoltageControlZone may have a voltage regulation schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SwitchSchedule(SeasonDayTypeSchedule):
    '''
    A schedule of switch positions. If RegularTimePoint.value1 is 0, the switch
    is open. If 1, the switch is closed.
    '''

    Switch: Optional[Switch] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Switch.SwitchSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A SwitchSchedule is associated with a Switch.
            '''
        
        })
    '''
    A SwitchSchedule is associated with a Switch.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a tap step.
    '''

    TapChanger: Optional[TapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChanger.TapSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A TapSchedule is associated with a TapChanger.
            '''
        
        })
    '''
    A TapSchedule is associated with a TapChanger.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class SteamSendoutSchedule(RegularIntervalSchedule):
    '''
    The cogeneration plant's steam sendout schedule in volume per time unit.
    '''

    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.SteamSendoutSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''
        
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.SteamSendoutSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''
        
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BilateralExchangeActor(IdentifiedObject):
    '''
    BilateralExchangeActor describes an actor that provides ICCP data, consumes
    ICCP data or both. The ICCP data provider lists the data it makes available
    to an ICCP data consumer. This data is described by ProvidedBilateralPoints.
    The relation between an ICCP data provider and a consumer is established
    by a BilateralExchangeAgreement. It is up to the ICCP data consumer to
    select what ProvidedBilateralPoints to use. The selection made is not described
    in this information model.
    '''

    CommunicationLink: list[CommunicationLink] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CommunicationLink.BilateralExchangeActor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Communication addressing for a Bilateral Table used by a ICCP data provider
            or consumer.
            '''
        
        })
    '''
    Communication addressing for a Bilateral Table used by a ICCP data
    provider or consumer.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ICCPConfiguration'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class BranchGroup(IdentifiedObject):
    '''
    A group of branch terminals whose directed flow summation is to be monitored.
    A branch group need not form a cutset of the network.
    '''

    monitorActivePower: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Monitor the active power flow.
            '''
        
        })
    '''
    Monitor the active power flow.
    '''
    
    monitorReactivePower: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Monitor the reactive power flow.
            '''
        
        })
    '''
    Monitor the reactive power flow.
    '''
    
    maximumActivePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum active power flow.
            '''
        
        })
    '''
    The maximum active power flow.
    '''
    
    maximumReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum reactive power flow.
            '''
        
        })
    '''
    The maximum reactive power flow.
    '''
    
    minimumActivePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum active power flow.
            '''
        
        })
    '''
    The minimum active power flow.
    '''
    
    minimumReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum reactive power flow.
            '''
        
        })
    '''
    The minimum reactive power flow.
    '''
    
    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BranchGroupTerminal.BranchGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The directed branch group terminals to be summed.
            '''
        
        })
    '''
    The directed branch group terminals to be summed.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BusNameMarker(IdentifiedObject):
    '''
    Used to apply user standard names to TopologicalNodes. Associated with
    one or more terminals that are normally connected with the bus name. The
    associated terminals are normally connected by non-retained switches. For
    a ring bus station configuration, all BusbarSection terminals in the ring
    are typically associated. For a breaker and a half scheme, both BusbarSections
    would normally be associated. For a ring bus, all BusbarSections would
    normally be associated. For a "straight" busbar configuration, normally
    only the main terminal at the BusbarSection would be associated.
    '''

    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Priority of bus name marker for use as topology bus name. Use 0 for do
            not care. Use 1 for highest priority. Use 2 as priority is less than 1
            and so on.
            '''
        
        })
    '''
    Priority of bus name marker for use as topology bus name. Use 0 for
    do not care. Use 1 for highest priority. Use 2 as priority is less
    than 1 and so on.
    '''
    
    ReportingGroup: Optional[ReportingGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReportingGroup.BusNameMarker',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reporting group to which this bus name marker belongs.
            '''
        
        })
    '''
    The reporting group to which this bus name marker belongs.
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.BusNameMarker',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A user defined topological node that was originally defined in a planning
            model not yet having topology described by ConnectivityNodes. Once ConnectivityNodes
            has been created they may linked to user defined ToplogicalNdes using BusNameMarkers.
            '''
        
        })
    '''
    A user defined topological node that was originally defined in a planning
    model not yet having topology described by ConnectivityNodes. Once
    ConnectivityNodes has been created they may linked to user defined
    ToplogicalNdes using BusNameMarkers.
    '''
    
    Terminal: list[ACDCTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACDCTerminal.BusNameMarker',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The terminals associated with this bus name marker.
            '''
        
        })
    '''
    The terminals associated with this bus name marker.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Topology'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CSCDynamics(IdentifiedObject):
    '''
    CSC function block whose behaviour is described by reference to a standard
    model <font color="#0f0f0f">or by definition of a user-defined model.</font>
    '''

    CSConverter: Optional[CsConverter] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CsConverter.CSCDynamics',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Current source converter to which current source converter dynamics model
            applies.
            '''
        
        })
    '''
    Current source converter to which current source converter dynamics
    model applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'HVDCDynamics'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.harmonization)
@dataclass(repr=False)
class CalculationMethodHierarchy(IdentifiedObject):
    '''
    The hierarchy of calculation methods used to derive this measurement.
    .
    '''

    Measurement: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.CalculationMethodHierarchy',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Measurement to which this calculation method hierarchy applies.
            '''
        
        })
    '''
    Measurement to which this calculation method hierarchy applies.
    '''
    
    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.CalculationMethodHierarchy',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Measurement value to which this calculation method hierarchy applies.
            '''
        
        })
    '''
    Measurement value to which this calculation method hierarchy applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetMeas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ClampAction(IdentifiedObject):
    '''
    Action on Clamp as a switching step
    '''

    Clamp: Optional[Clamp] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Clamp.ClampAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The clamp that the clamp action is performed on
            '''
        
        })
    '''
    The clamp that the clamp action is performed on
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConnectivityNode(IdentifiedObject):
    '''
    Connectivity nodes are points where terminals of AC conducting equipment
    are connected together with zero impedance.
    '''

    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNodeContainer.ConnectivityNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Container of this connectivity node.
            '''
        
        })
    '''
    Container of this connectivity node.
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.ConnectivityNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The topological node to which this connectivity node is assigned. May depend
            on the current state of switches in the network.
            '''
        
        })
    '''
    The topological node to which this connectivity node is assigned. May
    depend on the current state of switches in the network.
    '''
    
    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Terminals interconnected with zero impedance at a this connectivity node.
            '''
        
        })
    '''
    Terminals interconnected with zero impedance at a this connectivity
    node.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Contingency(IdentifiedObject):
    '''
    An event threatening system reliability, consisting of one or more contingency
    elements.
    '''

    mustStudy: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Set true if must study this contingency.
            '''
        
        })
    '''
    Set true if must study this contingency.
    '''
    
    ContingencyElement: list[ContingencyElement] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ContingencyElement.Contingency',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A contingency can have any number of contingency elements.
            '''
        
        })
    '''
    A contingency can have any number of contingency elements.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Contingency'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ContingencyElement(IdentifiedObject):
    '''
    An element of a system event to be studied by contingency analysis, representing
    a change in status of a single piece of equipment.
    '''

    Contingency: Optional[Contingency] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Contingency.ContingencyElement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A contingency element belongs to one contingency.
            '''
        
        })
    '''
    A contingency element belongs to one contingency.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Contingency'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ContingencyEquipment(ContingencyElement):
    '''
    Equipment whose in service status is to change, such as a power transformer
    or AC line segment.
    '''

    contingentStatus: Optional[ ContingencyEquipmentStatusKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The status for the associated equipment when in the contingency state.
            This status is independent of the case to which the contingency is originally
            applied, but defines the equipment status when the contingency is applied.
            '''
        
        })
    '''
    The status for the associated equipment when in the contingency state.
    This status is independent of the case to which the contingency is
    originally applied, but defines the equipment status when the contingency
    is applied.
    '''
    
    Equipment: Optional[Equipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Equipment.ContingencyEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The single piece of equipment to which to apply the contingency.
            '''
        
        })
    '''
    The single piece of equipment to which to apply the contingency.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Contingency'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ControlAction(IdentifiedObject):
    '''
    Control executed as a switching step.
    '''

    Control: Optional[Control] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Control.ControlAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The control that the control action is performed on.
            '''
        
        })
    '''
    The control that the control action is performed on.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Curve(IdentifiedObject):
    '''
    A multi-purpose curve or functional relationship between an independent
    variable (X-axis) and dependent (Y-axis) variables.
    '''

    curveStyle: Optional[ CurveStyle ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The style or shape of the curve.
            '''
        
        })
    '''
    The style or shape of the curve.
    '''
    
    xMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for X-axis.
            '''
        
        })
    '''
    Multiplier for X-axis.
    '''
    
    xUnit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The X-axis units of measure.
            '''
        
        })
    '''
    The X-axis units of measure.
    '''
    
    y1Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for Y1-axis.
            '''
        
        })
    '''
    Multiplier for Y1-axis.
    '''
    
    y1Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Y1-axis units of measure.
            '''
        
        })
    '''
    The Y1-axis units of measure.
    '''
    
    y2Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for Y2-axis.
            '''
        
        })
    '''
    Multiplier for Y2-axis.
    '''
    
    y2Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Y2-axis units of measure.
            '''
        
        })
    '''
    The Y2-axis units of measure.
    '''
    
    y3Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for Y3-axis.
            '''
        
        })
    '''
    Multiplier for Y3-axis.
    '''
    
    y3Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Y3-axis units of measure.
            '''
        
        })
    '''
    The Y3-axis units of measure.
    '''
    
    CurveDatas: list[CurveData] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CurveData.Curve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The point data values that define this curve.
            '''
        
        })
    '''
    The point data values that define this curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EmissionAccount(Curve):
    '''
    Accounts for tracking emissions usage and credits for thermal generating
    units. A unit may have zero or more emission accounts, and will typically
    have one for tracking usage and one for tracking credits.
    '''

    emissionType: Optional[ EmissionType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
            of the curve contains the unit of measure (e.g. kg) and the emissionType
            is the type of emission (e.g. sulfur dioxide).
            '''
        
        })
    '''
    The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
    of the curve contains the unit of measure (e.g. kg) and the emissionType
    is the type of emission (e.g. sulfur dioxide).
    '''
    
    emissionValueSource: Optional[ EmissionValueSource ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The source of the emission value.
            '''
        
        })
    '''
    The source of the emission value.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.EmmissionAccounts',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have one or more emission allowance accounts.
            '''
        
        })
    '''
    A thermal generating unit may have one or more emission allowance accounts.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EmissionCurve(Curve):
    '''
    Relationship between the unit's emission rate in units of mass per hour
    (Y-axis) and output active power (X-axis) for a given type of emission.
    This curve applies when only one type of fuel is being burned.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    emissionContent: Optional[ float | Emission ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The emission content per quantity of fuel burned.
            '''
        
        })
    '''
    The emission content per quantity of fuel burned.
    '''
    
    emissionType: Optional[ EmissionType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of emission, which also gives the production rate measurement
            unit. The y1AxisUnits of the curve contains the unit of measure (e.g. kg)
            and the emissionType is the type of emission (e.g. sulfur dioxide).
            '''
        
        })
    '''
    The type of emission, which also gives the production rate measurement
    unit. The y1AxisUnits of the curve contains the unit of measure (e.g.
    kg) and the emissionType is the type of emission (e.g. sulfur dioxide).
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.EmissionCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have one or more emission curves.
            '''
        
        })
    '''
    A thermal generating unit may have one or more emission curves.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FuelAllocationSchedule(Curve):
    '''
    The amount of fuel of a given type which is allocated for consumption over
    a specified period of time.
    '''

    fuelAllocationEndDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The end time and date of the fuel allocation schedule.
            '''
        
        })
    '''
    The end time and date of the fuel allocation schedule.
    '''
    
    fuelAllocationStartDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The start time and date of the fuel allocation schedule.
            '''
        
        })
    '''
    The start time and date of the fuel allocation schedule.
    '''
    
    maxFuelAllocation: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum amount of fuel that is allocated for consumption for the scheduled
            time period.
            '''
        
        })
    '''
    The maximum amount of fuel that is allocated for consumption for the
    scheduled time period.
    '''
    
    minFuelAllocation: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum amount of fuel that is allocated for consumption for the scheduled
            time period, e.g., based on a "take-or-pay" contract.
            '''
        
        })
    '''
    The minimum amount of fuel that is allocated for consumption for the
    scheduled time period, e.g., based on a "take-or-pay" contract.
    '''
    
    fuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of fuel, which also indicates the corresponding measurement unit.
            '''
        
        })
    '''
    The type of fuel, which also indicates the corresponding measurement
    unit.
    '''
    
    FossilFuel: Optional[FossilFuel] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FossilFuel.FuelAllocationSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A fuel allocation schedule shall have a fossil fuel.
            '''
        
        })
    '''
    A fuel allocation schedule shall have a fossil fuel.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.FuelAllocationSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have one or more fuel allocation schedules.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GenUnitOpCostCurve(Curve):
    '''
    Relationship between unit operating cost (Y-axis) and unit output active
    power (X-axis). The operating cost curve for thermal units is derived from
    heat input and fuel costs. The operating cost curve for hydro units is
    derived from water flow rates and equivalent water costs.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpCostCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A generating unit may have one or more cost curves, depending upon fuel
            mixture and fuel cost.
            '''
        
        })
    '''
    A generating unit may have one or more cost curves, depending upon
    fuel mixture and fuel cost.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GrossToNetActivePowerCurve(Curve):
    '''
    Relationship between the generating unit's gross active power output on
    the X-axis (measured at the terminals of the machine(s)) and the generating
    unit's net active power output on the Y-axis (based on utility-defined
    measurements at the power station). Station service loads, when modelled,
    should be treated as non-conforming bus loads. There may be more than one
    curve, depending on the auxiliary equipment that is in service.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GrossToNetActivePowerCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A generating unit may have a gross active power to net active power curve,
            describing the losses and auxiliary power requirements of the unit.
            '''
        
        })
    '''
    A generating unit may have a gross active power to net active power
    curve, describing the losses and auxiliary power requirements of the
    unit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HeatInputCurve(Curve):
    '''
    Relationship between unit heat input in energy per time for main fuel (Y1-axis)
    and supplemental fuel (Y2-axis) versus unit output in active power (X-axis).
    The quantity of main fuel used to sustain generation at this output level
    is prorated for throttling between definition points. The quantity of supplemental
    fuel used at this output level is fixed and not prorated.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    auxPowerMult: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power output - auxiliary power multiplier adjustment factor.
            '''
        
        })
    '''
    Power output - auxiliary power multiplier adjustment factor.
    '''
    
    auxPowerOffset: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power output - auxiliary power offset adjustment factor.
            '''
        
        })
    '''
    Power output - auxiliary power offset adjustment factor.
    '''
    
    heatInputEff: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Heat input - efficiency multiplier adjustment factor.
            '''
        
        })
    '''
    Heat input - efficiency multiplier adjustment factor.
    '''
    
    heatInputOffset: Optional[ float | HeatRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Heat input - offset adjustment factor.
            '''
        
        })
    '''
    Heat input - offset adjustment factor.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HeatRateCurve(Curve):
    '''
    Relationship between unit heat rate per active power (Y-axis) and unit
    output (X-axis). The heat input is from all fuels.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class HydroGeneratingEfficiencyCurve(Curve):
    '''
    Relationship between unit efficiency as percentage and unit output active
    power for a given net head in meters. The relationship between efficiency,
    discharge, head, and power output is expressed as follows: E =KP/HQ
    where: E is the efficiency, as a percentage; P is the active power; H is
    the height; Q is the discharge, volume/time unit; K is a constant.
    For example, a curve instance for a given net head could show efficiency
    (Y-axis) versus active power output (X-axis) or versus discharge on the
    X-axis.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.HydroGeneratingEfficiencyCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A hydro generating unit has an efficiency curve.
            '''
        
        })
    '''
    A hydro generating unit has an efficiency curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class IncrementalHeatRateCurve(Curve):
    '''
    Relationship between unit incremental heat rate in (delta energy/time)
    per (delta active power) and unit output in active power. The IHR curve
    represents the slope of the HeatInputCurve. Note that the "incremental
    heat rate" and the "heat rate" have the same engineering units.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LevelVsVolumeCurve(Curve):
    '''
    Relationship between reservoir volume and reservoir level. The volume is
    at the Y-axis and the reservoir level at the X-axis.
    '''

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.LevelVsVolumeCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A reservoir may have a level versus volume relationship.
            '''
        
        })
    '''
    A reservoir may have a level versus volume relationship.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class PenstockLossCurve(Curve):
    '''
    Relationship between penstock head loss (in meters) and total discharge
    through the penstock (in cubic meters per second). One or more turbines
    may be connected to the same penstock.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ReactiveCapabilityCurve(Curve):
    '''
    Reactive power rating envelope versus the synchronous machine's active
    power, in both the generating and motoring modes. For each active power
    value there is a corresponding high and low reactive power limit value.
    Typically there will be a separate curve for each coolant condition, such
    as hydrogen pressure. The Y1 axis values represent reactive minimum and
    the Y2 axis values represent reactive maximum.
    '''

    coolantTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The machine's coolant temperature (e.g., ambient air or stator circulating
            water).
            '''
        
        })
    '''
    The machine's coolant temperature (e.g., ambient air or stator circulating
    water).
    '''
    
    hydrogenPressure: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The hydrogen coolant pressure.
            '''
        
        })
    '''
    The hydrogen coolant pressure.
    '''
    
    InitiallyUsedBySynchronousMachines: list[SynchronousMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SynchronousMachine.InitialReactiveCapabilityCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Synchronous machines using this curve as default.
            '''
        
        })
    '''
    Synchronous machines using this curve as default.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class ShutdownCurve(Curve):
    '''
    Relationship between the rate in gross active power/minute (Y-axis) at
    which a unit should be shutdown and its present gross MW output (X-axis).
    '''

    shutdownDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The date and time of the most recent generating unit shutdown.
            '''
        
        })
    '''
    The date and time of the most recent generating unit shutdown.
    '''
    
    shutdownCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fixed shutdown cost.
            '''
        
        })
    '''
    Fixed shutdown cost.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''
        
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''
        
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartIgnFuelCurve(Curve):
    '''
    The quantity of ignition fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    ignitionFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of ignition fuel.
            '''
        
        })
    '''
    Type of ignition fuel.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartIgnFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartIgnFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartMainFuelCurve(Curve):
    '''
    The quantity of main fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    mainFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of main fuel.
            '''
        
        })
    '''
    Type of main fuel.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartMainFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartMainFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartRampCurve(Curve):
    '''
    Rate in gross active power per minute (Y-axis) at which a unit can be loaded
    versus the number of hours (X-axis) the unit was off line.
    '''

    hotStandbyRamp: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The startup ramp rate in gross for a unit that is on hot standby.
            '''
        
        })
    '''
    The startup ramp rate in gross for a unit that is on hot standby.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartRampCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartRampCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TailbayLossCurve(Curve):
    '''
    Relationship between tailbay head loss height (Y-axis) and the total discharge
    into the power station's tailbay volume per time unit (X-axis) . There
    could be more than one curve depending on the level of the tailbay reservoir
    or river level.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.TailbayLossCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A hydro generating unit has a tailbay loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a tailbay loss curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class TargetLevelSchedule(Curve):
    '''
    Reservoir water level targets from advanced studies or "rule curves". Typically
    in one hour increments for up to 10 days.
    '''

    highLevelLimit: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            High target level limit, above which the reservoir operation will be penalized.
            '''
        
        })
    '''
    High target level limit, above which the reservoir operation will be
    penalized.
    '''
    
    lowLevelLimit: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Low target level limit, below which the reservoir operation will be penalized.
            '''
        
        })
    '''
    Low target level limit, below which the reservoir operation will be
    penalized.
    '''
    
    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.TargetLevelSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''
        
        })
    '''
    A reservoir may have a water level target schedule.
    '''
    
    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.TargetLevelSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''
        
        })
    '''
    A reservoir may have a water level target schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class VsCapabilityCurve(Curve):
    '''
    The P-Q capability curve for a voltage source converter, with P on X-axis
    and Qmin and Qmax on Y1-axis and Y2-axis.
    '''

    VsConverterDCSides: list[VsConverter] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VsConverter.CapabilityCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All converters with this capability curve.
            '''
        
        })
    '''
    All converters with this capability curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CutAction(IdentifiedObject):
    '''
    Action on cut as a switching step.
    '''

    Cut: Optional[Cut] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Cut.CutAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Cut on which this action is taken.
            '''
        
        })
    '''
    Cut on which this action is taken.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCNode(IdentifiedObject):
    '''
    DC nodes are points where terminals of DC conducting equipment are connected
    together with zero impedance.
    '''

    DCEquipmentContainer: Optional[DCEquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCEquipmentContainer.DCNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The DC container for the DC nodes.
            '''
        
        })
    '''
    The DC container for the DC nodes.
    '''
    
    DCTopologicalNode: Optional[DCTopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTopologicalNode.DCNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The DC topological node to which this DC connectivity node is assigned.
            May depend on the current state of switches in the network.
            '''
        
        })
    '''
    The DC topological node to which this DC connectivity node is assigned.
    May depend on the current state of switches in the network.
    '''
    
    DCTerminals: list[DCBaseTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCBaseTerminal.DCNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            DC base terminals interconnected with zero impedance at a this DC connectivity
            node.
            '''
        
        })
    '''
    DC base terminals interconnected with zero impedance at a this DC connectivity
    node.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class DCTopologicalIsland(IdentifiedObject):
    '''
    An electrically connected subset of the network. DC topological islands
    can change as the current network state changes, e.g. due to:
    - disconnect switches or breakers changing state in a SCADA/EMS.
    - manual creation, change or deletion of topological nodes in a planning
    tool.
    Only energised TopologicalNode-s shall be part of the topological island.
    '''

    DCTopologicalNodes: list[DCTopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCTopologicalNode.DCTopologicalIsland',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The DC topological nodes in a DC topological island.
            '''
        
        })
    '''
    The DC topological nodes in a DC topological island.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCTopologicalNode(IdentifiedObject):
    '''
    DC bus.
    '''

    DCEquipmentContainer: Optional[DCEquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCEquipmentContainer.DCTopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The connectivity node container to which the topological node belongs.
            '''
        
        })
    '''
    The connectivity node container to which the topological node belongs.
    '''
    
    DCTopologicalIsland: Optional[DCTopologicalIsland] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTopologicalIsland.DCTopologicalNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A DC topological node belongs to a DC topological island.
            '''
        
        })
    '''
    A DC topological node belongs to a DC topological island.
    '''
    
    DCTerminals: list[DCBaseTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCBaseTerminal.DCTopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            See association end TopologicalNode.Terminal.
            '''
        
        })
    '''
    See association end TopologicalNode.Terminal.
    '''
    
    DCNodes: list[DCNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCNode.DCTopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The DC connectivity nodes combined together to form this DC topological
            node. May depend on the current state of switches in the network.
            '''
        
        })
    '''
    The DC connectivity nodes combined together to form this DC topological
    node. May depend on the current state of switches in the network.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DayType(IdentifiedObject):
    '''
    Group of similar days. For example it could be used to represent weekdays,
    weekend, or holidays.
    '''

    SeasonDayTypeSchedules: list[SeasonDayTypeSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SeasonDayTypeSchedule.DayType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Schedules that use this DayType.
            '''
        
        })
    '''
    Schedules that use this DayType.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class EarthResistivity(IdentifiedObject):
    '''
    Resistance of earth (soil)
    '''

    earthModelType: Optional[ EarthModelKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration GridAPPSD Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    earthReturnGMR: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Geometry mean radius of a set of hypothetical conductors with same impedance
            as the earth return, per Carson's Equations
            '''
        
        })
    '''
    Geometry mean radius of a set of hypothetical conductors with same
    impedance as the earth return, per Carson's Equations
    '''
    
    rho: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ACLineSegments: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.EarthResistivity',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WireAssemblyInfos: list[WireAssemblyInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireAssemblyInfo.EarthResistivity',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'WiresEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergyArea(IdentifiedObject):
    '''
    Describes an area having energy production or consumption. Specializations
    are intended to support the load allocation function as typically required
    in energy management systems or planning studies to allocate hypothesized
    load levels to individual load points for power flow analysis. Often the
    energy area can be linked to both measured and forecast load levels.
    '''

    ControlArea: Optional[ControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlArea.EnergyArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The control area specification that is used for the load forecast.
            '''
        
        })
    '''
    The control area specification that is used for the load forecast.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class LoadArea(EnergyArea):
    '''
    The class is the root or first level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    SubLoadAreas: list[SubLoadArea] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SubLoadArea.LoadArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The SubLoadAreas in the LoadArea.
            '''
        
        })
    '''
    The SubLoadAreas in the LoadArea.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class SubLoadArea(EnergyArea):
    '''
    The class is the second level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    LoadArea: Optional[LoadArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadArea.SubLoadAreas',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The LoadArea where the SubLoadArea belongs.
            '''
        
        })
    '''
    The LoadArea where the SubLoadArea belongs.
    '''
    
    LoadGroups: list[LoadGroup] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LoadGroup.SubLoadArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The Loadgroups in the SubLoadArea.
            '''
        
        })
    '''
    The Loadgroups in the SubLoadArea.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergyConsumerAction(IdentifiedObject):
    '''
    Action to connect or disconnect the Energy Consumer from its Terminal
    '''

    EnergyConsumer: Optional[EnergyConsumer] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumer.EnergyConsumerAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The energy consumer that the energy consumer action is performed on
            '''
        
        })
    '''
    The energy consumer that the energy consumer action is performed on
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergySchedulingType(IdentifiedObject):
    '''
    Used to define the type of generation for scheduling purposes.
    '''

    EnergySource: list[EnergySource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergySource.EnergySchedulingType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Energy Source of a particular Energy Scheduling Type.
            '''
        
        })
    '''
    Energy Source of a particular Energy Scheduling Type.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergySourceAction(IdentifiedObject):
    '''
    Action on energy source as a switching step.
    '''

    EnergySource: Optional[EnergySource] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergySource.EnergySourceAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Energy source on which this action is taken.
            '''
        
        })
    '''
    Energy source on which this action is taken.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FossilFuel(IdentifiedObject):
    '''
    The fossil fuel consumed by the non-nuclear thermal generating unit. For
    example, coal, oil, gas, etc. These are the specific fuels that the generating
    unit can consume.
    '''

    fuelHeatContent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The amount of heat per weight (or volume) of the given type of fuel.
            '''
        
        })
    '''
    The amount of heat per weight (or volume) of the given type of fuel.
    '''
    
    fossilFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of fossil fuel, such as coal, oil, or gas.
            '''
        
        })
    '''
    The type of fossil fuel, such as coal, oil, or gas.
    '''
    
    fuelCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The cost in terms of heat value for the given type of fuel.
            '''
        
        })
    '''
    The cost in terms of heat value for the given type of fuel.
    '''
    
    fuelDispatchCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The cost of fuel used for economic dispatching which includes: fuel cost,
            transportation cost, and incremental maintenance cost.
            '''
        
        })
    '''
    The cost of fuel used for economic dispatching which includes: fuel
    cost, transportation cost, and incremental maintenance cost.
    '''
    
    fuelEffFactor: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The efficiency factor for the fuel (per unit) in terms of the effective
            energy absorbed.
            '''
        
        })
    '''
    The efficiency factor for the fuel (per unit) in terms of the effective
    energy absorbed.
    '''
    
    fuelHandlingCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Handling and processing cost associated with this fuel.
            '''
        
        })
    '''
    Handling and processing cost associated with this fuel.
    '''
    
    fuelMixture: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Relative amount of the given type of fuel, when multiple fuels are being
            consumed.
            '''
        
        })
    '''
    Relative amount of the given type of fuel, when multiple fuels are
    being consumed.
    '''
    
    fuelSulfur: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The fuel's fraction of pollution credit per unit of heat content.
            '''
        
        })
    '''
    The fuel's fraction of pollution credit per unit of heat content.
    '''
    
    highBreakpointP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The active power output level of the unit at which the given type of fuel
            is switched on. This fuel (e.g., oil) is sometimes used to supplement the
            base fuel (e.g., coal) at high active power output levels.
            '''
        
        })
    '''
    The active power output level of the unit at which the given type of
    fuel is switched on. This fuel (e.g., oil) is sometimes used to supplement
    the base fuel (e.g., coal) at high active power output levels.
    '''
    
    lowBreakpointP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The active power output level of the unit at which the given type of fuel
            is switched off. This fuel (e.g., oil) is sometimes used to stabilize the
            base fuel (e.g., coal) at low active power output levels.
            '''
        
        })
    '''
    The active power output level of the unit at which the given type of
    fuel is switched off. This fuel (e.g., oil) is sometimes used to stabilize
    the base fuel (e.g., coal) at low active power output levels.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.FossilFuels',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have one or more fossil fuels.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''
    
    FuelAllocationSchedules: list[FuelAllocationSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FuelAllocationSchedule.FossilFuel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A fuel allocation schedule shall have a fossil fuel.
            '''
        
        })
    '''
    A fuel allocation schedule shall have a fossil fuel.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class GeographicalRegion(IdentifiedObject):
    '''
    A geographical region of a power system network model.
    '''

    Regions: list[SubGeographicalRegion] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SubGeographicalRegion.Region',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All sub-geographical regions within this geographical region.
            '''
        
        })
    '''
    All sub-geographical regions within this geographical region.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GroundAction(IdentifiedObject):
    '''
    Action on ground as a switching step.
    '''

    AlongACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.LineGroundingAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The line segment that this ground action will affect. This is the only
            way to access relationship to clamp in case the ground needs to be placed
            along the line segment.
            '''
        
        })
    '''
    The line segment that this ground action will affect. This is the only
    way to access relationship to clamp in case the ground needs to be
    placed along the line segment.
    '''
    
    GroundedEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.GroundingAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Equipment being grounded with this operation. In case of placing a ground
            anywhere along a line segment, you must use the clamp (to get the distance
            from one terminal), so use the explicit relation with line segment. In
            all other cases (including placing the ground at a line segment terminal),
            reference to one or more conducting equipment is sufficient.
            '''
        
        })
    '''
    Equipment being grounded with this operation. In case of placing a
    ground anywhere along a line segment, you must use the clamp (to get
    the distance from one terminal), so use the explicit relation with
    line segment. In all other cases (including placing the ground at a
    line segment terminal), reference to one or more conducting equipment
    is sufficient.
    '''
    
    Ground: Optional[Ground] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Ground.GroundAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Ground on which this action is taken.
            '''
        
        })
    '''
    Ground on which this action is taken.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IOPoint(IdentifiedObject):
    '''
    The class describe a measurement or control value. The purpose is to enable
    having attributes and associations common for measurement and control.
    '''

    IOPointSource: Optional[IOPointSource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IOPointSource.IOPoint',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Local merasurement value source for an ICCP point.
            '''
        
        })
    '''
    Local merasurement value source for an ICCP point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Control(IOPoint):
    '''
    Control is used for supervisory/device control. It represents control outputs
    that are used to change the state in a process, e.g. close or open breaker,
    a set point value or a raise lower command.
    '''

    controlType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the type of Control. For example, this specifies if the Control
            represents BreakerOpen, BreakerClose, GeneratorVoltageSetPoint, GeneratorRaise,
            GeneratorLower, etc.
            '''
        
        })
    '''
    Specifies the type of Control. For example, this specifies if the Control
    represents BreakerOpen, BreakerClose, GeneratorVoltageSetPoint, GeneratorRaise,
    GeneratorLower, etc.
    '''
    
    operationInProgress: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates that a client is currently sending control commands that has
            not completed.
            '''
        
        })
    '''
    Indicates that a client is currently sending control commands that
    has not completed.
    '''
    
    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The last time a control output was sent.
            '''
        
        })
    '''
    The last time a control output was sent.
    '''
    
    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit multiplier of the controlled quantity.
            '''
        
        })
    '''
    The unit multiplier of the controlled quantity.
    '''
    
    unitSymbol: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit of measure of the controlled quantity.
            '''
        
        })
    '''
    The unit of measure of the controlled quantity.
    '''
    
    ControlAction: Optional[ControlAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlAction.Control',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The control action that is performed on the control
            '''
        
        })
    '''
    The control action that is performed on the control
    '''
    
    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.Controls',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Regulating device governed by this control output.
            '''
        
        })
    '''
    Regulating device governed by this control output.
    '''
    
    RemoteControl: Optional[RemoteControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RemoteControl.Control',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The remote point controlling the physical actuator.
            '''
        
        })
    '''
    The remote point controlling the physical actuator.
    '''
    
    RemoteControl: Optional[RemoteControl] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RemoteControl.Control',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The remote point controlling the physical actuator.
            '''
        
        })
    '''
    The remote point controlling the physical actuator.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AccumulatorReset(Control):
    '''
    This command resets the counter value to zero.
    '''

    AccumulatorValue: Optional[AccumulatorValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorValue.AccumulatorReset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The accumulator value that is reset by the command.
            '''
        
        })
    '''
    The accumulator value that is reset by the command.
    '''
    
    AccumulatorValue: Optional[AccumulatorValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorValue.AccumulatorReset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The accumulator value that is reset by the command.
            '''
        
        })
    '''
    The accumulator value that is reset by the command.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AnalogControl(Control):
    '''
    An analog control used for supervisory control.
    '''

    maxValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal value range maximum for any of the Control.value. Used for scaling,
            e.g. in bar graphs.
            '''
        
        })
    '''
    Normal value range maximum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''
    
    minValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal value range minimum for any of the Control.value. Used for scaling,
            e.g. in bar graphs.
            '''
        
        })
    '''
    Normal value range minimum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''
    
    AnalogValue: Optional[AnalogValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AnalogControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''
        
        })
    '''
    The MeasurementValue that is controlled.
    '''
    
    AnalogValue: Optional[AnalogValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AnalogControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''
        
        })
    '''
    The MeasurementValue that is controlled.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RaiseLowerCommand(AnalogControl):
    '''
    An analog control that increases or decreases a set point value with pulses.
    Unless otherwise specified, one pulse moves the set point by one.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.RaiseLowerCommands',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The ValueAliasSet used for translation of a Control value to a name.
            '''
        
        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SetPoint(AnalogControl):
    '''
    An analog control that issues a set point value.
    '''

    normalValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal value for Control.value e.g. used for percentage scaling.
            '''
        
        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''
    
    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The value representing the actuator output.
            '''
        
        })
    '''
    The value representing the actuator output.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Command(Control):
    '''
    A Command is a discrete control used for supervisory control.
    '''

    normalValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal value for Control.value e.g. used for percentage scaling.
            '''
        
        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''
    
    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The value representing the actuator output.
            '''
        
        })
    '''
    The value representing the actuator output.
    '''
    
    DiscreteValue: Optional[DiscreteValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiscreteValue.Command',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''
        
        })
    '''
    The MeasurementValue that is controlled.
    '''
    
    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.Commands',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The ValueAliasSet used for translation of a Control value to a name.
            '''
        
        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''
    
    DiscreteValue: Optional[DiscreteValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiscreteValue.Command',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''
        
        })
    '''
    The MeasurementValue that is controlled.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class MeasurementValue(IOPoint):
    '''
    The current state for a measurement. A state value is an instance of a
    measurement from a specific source. Measurements can be associated with
    many state values, each representing a different source for the measurement.
    '''

    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The time when the value was last updated.
            '''
        
        })
    '''
    The time when the value was last updated.
    '''
    
    sensorAccuracy: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The limit, expressed as a percentage of the sensor maximum, that errors
            will not exceed when the sensor is used under reference conditions.
            '''
        
        })
    '''
    The limit, expressed as a percentage of the sensor maximum, that errors
    will not exceed when the sensor is used under reference conditions.
    '''
    
    CalculationMethodHierarchy: Optional[CalculationMethodHierarchy] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CalculationMethodHierarchy.MeasurementValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ErpPerson: Optional[OldPerson] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OldPerson.MeasurementValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MeasurementValueQuality: Optional[MeasurementValueQuality] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueQuality.MeasurementValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''
        
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''
    
    MeasurementValueSource: Optional[MeasurementValueSource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueSource.MeasurementValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A reference to the type of source that updates the MeasurementValue, e.g.
            SCADA, CCLink, manual, etc. User conventions for the names of sources are
            contained in the introduction to IEC 61970-301.
            '''
        
        })
    '''
    A reference to the type of source that updates the MeasurementValue,
    e.g. SCADA, CCLink, manual, etc. User conventions for the names of
    sources are contained in the introduction to IEC 61970-301.
    '''
    
    RemoteSource: Optional[RemoteSource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RemoteSource.MeasurementValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Link to the physical telemetered point associated with this measurement.
            '''
        
        })
    '''
    Link to the physical telemetered point associated with this measurement.
    '''
    
    MeasurementValueQuality: Optional[MeasurementValueQuality] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueQuality.MeasurementValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''
        
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''
    
    RemoteSource: Optional[RemoteSource] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RemoteSource.MeasurementValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Link to the physical telemetered point associated with this measurement.
            '''
        
        })
    '''
    Link to the physical telemetered point associated with this measurement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AccumulatorValue(MeasurementValue):
    '''
    AccumulatorValue represents an accumulated (counted) MeasurementValue.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The value to supervise. The value is positive.
            '''
        
        })
    '''
    The value to supervise. The value is positive.
    '''
    
    Accumulator: Optional[Accumulator] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Accumulator.AccumulatorValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Measurement to which this value is connected.
            '''
        
        })
    '''
    Measurement to which this value is connected.
    '''
    
    AccumulatorReset: Optional[AccumulatorReset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorReset.AccumulatorValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The command that resets the accumulator value.
            '''
        
        })
    '''
    The command that resets the accumulator value.
    '''
    
    AccumulatorReset: Optional[AccumulatorReset] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorReset.AccumulatorValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The command that resets the accumulator value.
            '''
        
        })
    '''
    The command that resets the accumulator value.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AnalogValue(MeasurementValue):
    '''
    AnalogValue represents an analog MeasurementValue.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The value to supervise.
            '''
        
        })
    '''
    The value to supervise.
    '''
    
    Analog: Optional[Analog] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Analog.AnalogValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Measurement to which this value is connected.
            '''
        
        })
    '''
    Measurement to which this value is connected.
    '''
    
    AnalogControl: Optional[AnalogControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogControl.AnalogValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''
        
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''
    
    AnalogControl: Optional[AnalogControl] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogControl.AnalogValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''
        
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DiscreteValue(MeasurementValue):
    '''
    DiscreteValue represents a discrete MeasurementValue.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The value to supervise.
            '''
        
        })
    '''
    The value to supervise.
    '''
    
    Command: Optional[Command] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Command.DiscreteValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''
        
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''
    
    Discrete: Optional[Discrete] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Discrete.DiscreteValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Measurement to which this value is connected.
            '''
        
        })
    '''
    Measurement to which this value is connected.
    '''
    
    Command: Optional[Command] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Command.DiscreteValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''
        
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StringMeasurementValue(MeasurementValue):
    '''
    StringMeasurementValue represents a measurement value of type string.
    '''

    value: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The value to supervise.
            '''
        
        })
    '''
    The value to supervise.
    '''
    
    StringMeasurement: Optional[StringMeasurement] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StringMeasurement.StringMeasurementValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Measurement to which this value is connected.
            '''
        
        })
    '''
    Measurement to which this value is connected.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class JumperAction(IdentifiedObject):
    '''
    Action on jumper as a switching step.
    '''

    ACLineSegments: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.LineJumpingAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The line segment that this jumper action will affect. This is the only
            way to access relationship to clamp in case the jumper needs to connect
            along the line segment.
            '''
        
        })
    '''
    The line segment that this jumper action will affect. This is the only
    way to access relationship to clamp in case the jumper needs to connect
    along the line segment.
    '''
    
    Clamp: Optional[Clamp] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Clamp.JumperAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Clamp on which this action is taken.
            '''
        
        })
    '''
    Clamp on which this action is taken.
    '''
    
    JumpedEquipments: list[ConductingEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConductingEquipment.JumpingAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Conducting equipment is affected when the jumper action connects one or
            both ends of a jumper to the conducting equipment. If the jumper action
            involves placing one or both ends of a jumper anywhere along a line segment,
            you must use the clamp (to get the distance from one terminal), using the
            explicit relation with clamp. In the case of placing one or both ends of
            the jumper at a line segment terminal, reference to one or more line segments
            is sufficient.
            '''
        
        })
    '''
    Conducting equipment is affected when the jumper action connects one
    or both ends of a jumper to the conducting equipment. If the jumper
    action involves placing one or both ends of a jumper anywhere along
    a line segment, you must use the clamp (to get the distance from one
    terminal), using the explicit relation with clamp. In the case of placing
    one or both ends of the jumper at a line segment terminal, reference
    to one or more line segments is sufficient.
    '''
    
    Jumper: Optional[Jumper] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Jumper.JumperAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Jumper on which this action is taken.
            '''
        
        })
    '''
    Jumper on which this action is taken.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Limit(IdentifiedObject):
    '''
    Specifies one limit value for a Measurement. A Measurement typically has
    several limits that are kept together by the LimitSet class. The actual
    meaning and use of a Limit instance (i.e., if it is an alarm or warning
    limit or if it is a high or low limit) is not captured in the Limit class.
    However the name of a Limit instance may indicate both meaning and use.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AccumulatorLimit(Limit):
    '''
    Limit values for Accumulator measurements.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The value to supervise against. The value is positive.
            '''
        
        })
    '''
    The value to supervise against. The value is positive.
    '''
    
    LimitSet: Optional[AccumulatorLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorLimitSet.Limits',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The set of limits.
            '''
        
        })
    '''
    The set of limits.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AnalogLimit(Limit):
    '''
    Limit values for Analog measurements.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The value to supervise against.
            '''
        
        })
    '''
    The value to supervise against.
    '''
    
    LimitSet: Optional[AnalogLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogLimitSet.Limits',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The set of limits.
            '''
        
        })
    '''
    The set of limits.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LimitSet(IdentifiedObject):
    '''
    Specifies a set of Limits that are associated with a Measurement. A Measurement
    may have several LimitSets corresponding to seasonal or other changing
    conditions. The condition is captured in the name and description attributes.
    The same LimitSet may be used for several Measurements. In particular percentage
    limits are used this way.
    '''

    isPercentageLimits: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Tells if the limit values are in percentage of normalValue or the specified
            Unit for Measurements and Controls.
            '''
        
        })
    '''
    Tells if the limit values are in percentage of normalValue or the specified
    Unit for Measurements and Controls.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class AccumulatorLimitSet(LimitSet):
    '''
    An AccumulatorLimitSet specifies a set of Limits that are associated with
    an Accumulator measurement.
    '''

    Limits: list[AccumulatorLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AccumulatorLimit.LimitSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The limit values used for supervision of Measurements.
            '''
        
        })
    '''
    The limit values used for supervision of Measurements.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class AnalogLimitSet(LimitSet):
    '''
    An AnalogLimitSet specifies a set of Limits that are associated with an
    Analog measurement.
    '''

    Limits: list[AnalogLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalogLimit.LimitSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The limit values used for supervision of Measurements.
            '''
        
        })
    '''
    The limit values used for supervision of Measurements.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LoadDynamics(IdentifiedObject):
    '''
    Load whose behaviour is described by reference to a standard model <font
    color="#0f0f0f">or by definition of a user-defined model.</font>
    A standard feature of dynamic load behaviour modelling is the ability to
    associate the same behaviour to multiple energy consumers by means of a
    single load definition. The load model is always applied to individual
    bus loads (energy consumers).
    '''

    EnergyConsumer: list[EnergyConsumer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumer.LoadDynamics',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Energy consumer to which this dynamics load model applies.
            '''
        
        })
    '''
    Energy consumer to which this dynamics load model applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadDynamics'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LoadGroup(IdentifiedObject):
    '''
    The class is the third level in a hierarchical structure for grouping of
    loads for the purpose of load flow load scaling.
    '''

    SubLoadArea: Optional[SubLoadArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubLoadArea.LoadGroups',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The SubLoadArea where the Loadgroup belongs.
            '''
        
        })
    '''
    The SubLoadArea where the Loadgroup belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ConformLoadGroup(LoadGroup):
    '''
    A group of loads conforming to an allocation pattern.
    '''

    EnergyConsumers: list[ConformLoad] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConformLoad.LoadGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Conform loads assigned to this ConformLoadGroup.
            '''
        
        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''
    
    ConformLoadSchedules: list[ConformLoadSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConformLoadSchedule.ConformLoadGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The ConformLoadSchedules in the ConformLoadGroup.
            '''
        
        })
    '''
    The ConformLoadSchedules in the ConformLoadGroup.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class NonConformLoadGroup(LoadGroup):
    '''
    Loads that do not follow a daily and seasonal load variation pattern.
    '''

    EnergyConsumers: list[NonConformLoad] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonConformLoad.LoadGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Conform loads assigned to this ConformLoadGroup.
            '''
        
        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''
    
    NonConformLoadSchedules: list[NonConformLoadSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonConformLoadSchedule.NonConformLoadGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The NonConformLoadSchedules in the NonConformLoadGroup.
            '''
        
        })
    '''
    The NonConformLoadSchedules in the NonConformLoadGroup.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LoadResponseCharacteristic(IdentifiedObject):
    '''
    Models the characteristic response of the load demand due to changes in
    system conditions such as voltage and frequency. It is not related to demand
    response.
    If LoadResponseCharacteristic.exponentModel is True, the exponential voltage
    or frequency dependent models are specified and used as to calculate active
    and reactive power components of the load model.
    The equations to calculate active and reactive power components of the
    load model are internal to the power flow calculation, hence they use different
    quantities depending on the use case of the data exchange.
    The equations for exponential voltage dependent load model injected power
    are:
    pInjection= Pnominal* (Voltage/cim:BaseVoltage.nominalVoltage) ** cim:LoadResponseCharacteristic.pVoltageExponent
    qInjection= Qnominal* (Voltage/cim:BaseVoltage.nominalVoltage) ** cim:LoadResponseCharacteristic.qVoltageExponent
    Where:
    1) * means "multiply" and ** is "raised to power of";
    2) Pnominal and Qnominal represent the active power and reactive power
    at nominal voltage as any load described by the voltage exponential model
    shall be given at nominal voltage. This means that EnergyConsumer.p and
    EnergyConsumer.q are at nominal voltage.
    3) After power flow is solved:
    -pInjection and qInjection correspond to SvPowerflow.p and SvPowerflow.q
    respectively.
    - Voltage corresponds to SvVoltage.v at the TopologicalNode where the load
    is connected.
    '''

    exponentModel: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates the exponential voltage dependency model is to be used. If false,
            the coefficient model is to be used.
            The exponential voltage dependency model consist of the attributes:
            - pVoltageExponent
            - qVoltageExponent
            - pFrequencyExponent
            - qFrequencyExponent.
            The coefficient model consist of the attributes:
            - pConstantImpedance
            - pConstantCurrent
            - pConstantPower
            - qConstantImpedance
            - qConstantCurrent
            - qConstantPower.
            The sum of pConstantImpedance, pConstantCurrent and pConstantPower shall
            equal 1.
            The sum of qConstantImpedance, qConstantCurrent and qConstantPower shall
            equal 1.
            '''
        
        })
    '''
    Indicates the exponential voltage dependency model is to be used. If
    false, the coefficient model is to be used.
    The exponential voltage dependency model consist of the attributes:
    - pVoltageExponent
    - qVoltageExponent
    - pFrequencyExponent
    - qFrequencyExponent.
    The coefficient model consist of the attributes:
    - pConstantImpedance
    - pConstantCurrent
    - pConstantPower
    - qConstantImpedance
    - qConstantCurrent
    - qConstantPower.
    The sum of pConstantImpedance, pConstantCurrent and pConstantPower
    shall equal 1.
    The sum of qConstantImpedance, qConstantCurrent and qConstantPower
    shall equal 1.
    '''
    
    pConstantCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Portion of active power load modelled as constant current.
            '''
        
        })
    '''
    Portion of active power load modelled as constant current.
    '''
    
    pConstantImpedance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Portion of active power load modelled as constant impedance.
            '''
        
        })
    '''
    Portion of active power load modelled as constant impedance.
    '''
    
    pConstantPower: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Portion of active power load modelled as constant power.
            '''
        
        })
    '''
    Portion of active power load modelled as constant power.
    '''
    
    pFrequencyExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Exponent of per unit frequency effecting active power.
            '''
        
        })
    '''
    Exponent of per unit frequency effecting active power.
    '''
    
    pVoltageExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Exponent of per unit voltage effecting real power.
            '''
        
        })
    '''
    Exponent of per unit voltage effecting real power.
    '''
    
    qConstantCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Portion of reactive power load modelled as constant current.
            '''
        
        })
    '''
    Portion of reactive power load modelled as constant current.
    '''
    
    qConstantImpedance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Portion of reactive power load modelled as constant impedance.
            '''
        
        })
    '''
    Portion of reactive power load modelled as constant impedance.
    '''
    
    qConstantPower: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Portion of reactive power load modelled as constant power.
            '''
        
        })
    '''
    Portion of reactive power load modelled as constant power.
    '''
    
    qFrequencyExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Exponent of per unit frequency effecting reactive power.
            '''
        
        })
    '''
    Exponent of per unit frequency effecting reactive power.
    '''
    
    qVoltageExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Exponent of per unit voltage effecting reactive power.
            '''
        
        })
    '''
    Exponent of per unit voltage effecting reactive power.
    '''
    
    EnergyConsumer: list[EnergyConsumer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumer.LoadResponse',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The set of loads that have the response characteristics.
            '''
        
        })
    '''
    The set of loads that have the response characteristics.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Location(IdentifiedObject):
    '''
    The place, scene, or point of something where someone or something has
    been, is, and/or will be at a given moment in time. It can be defined with
    one or more position points (coordinates) in a given coordinate system.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.Location',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All power system resources at this location.
            '''
        
        })
    '''
    All power system resources at this location.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Measurement(IdentifiedObject):
    '''
    A Measurement represents any measured, calculated or non-measured non-calculated
    quantity. Any piece of equipment may contain Measurements, e.g. a substation
    may have temperature measurements and door open indications, a transformer
    may have oil temperature and tank pressure measurements, a bay may contain
    a number of power flow measurements and a Breaker may contain a switch
    status measurement.
    The PSR - Measurement association is intended to capture this use of Measurement
    and is included in the naming hierarchy based on EquipmentContainer. The
    naming hierarchy typically has Measurements as leaves, e.g. Substation-VoltageLevel-Bay-Switch-Measurement.
    Some Measurements represent quantities related to a particular sensor location
    in the network, e.g. a voltage transformer (VT) or potential transformer
    (PT) at a busbar or a current transformer (CT) at the bar between a breaker
    and an isolator. The sensing position is not captured in the PSR - Measurement
    association. Instead it is captured by the Measurement - Terminal association
    that is used to define the sensing location in the network topology. The
    location is defined by the connection of the Terminal to ConductingEquipment.
    If both a Terminal and PSR are associated, and the PSR is of type ConductingEquipment,
    the associated Terminal should belong to that ConductingEquipment instance.
    When the sensor location is needed both Measurement-PSR and Measurement-Terminal
    are used. The Measurement-Terminal association is never used alone.
    '''

    measurementType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the type of measurement. For example, this specifies if the measurement
            represents an indoor temperature, outdoor temperature, bus voltage, line
            flow, etc.
            When the measurementType is set to "Specialization", the type of Measurement
            is defined in more detail by the specialized class which inherits from
            Measurement.
            '''
        
        })
    '''
    Specifies the type of measurement. For example, this specifies if the
    measurement represents an indoor temperature, outdoor temperature,
    bus voltage, line flow, etc.
    When the measurementType is set to "Specialization", the type of Measurement
    is defined in more detail by the specialized class which inherits from
    Measurement.
    '''
    
    phases: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates to which phases the measurement applies and avoids the need to
            use 'measurementType' to also encode phase information (which would explode
            the types). The phase information in Measurement, along with 'measurementType'
            and 'phases' uniquely defines a Measurement for a device, based on normal
            network phase. Their meaning will not change when the computed energizing
            phasing is changed due to jumpers or other reasons.
            If the attribute is missing three phases (ABC) shall be assumed.
            '''
        
        })
    '''
    Indicates to which phases the measurement applies and avoids the need
    to use 'measurementType' to also encode phase information (which would
    explode the types). The phase information in Measurement, along with
    'measurementType' and 'phases' uniquely defines a Measurement for a
    device, based on normal network phase. Their meaning will not change
    when the computed energizing phasing is changed due to jumpers or other
    reasons.
    If the attribute is missing three phases (ABC) shall be assumed.
    '''
    
    sourceType: Optional[ MeasurementSourceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit multiplier of the measured quantity.
            '''
        
        })
    '''
    The unit multiplier of the measured quantity.
    '''
    
    unitSymbol: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit of measure of the measured quantity.
            '''
        
        })
    '''
    The unit of measure of the measured quantity.
    '''
    
    Asset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.Measurements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Asset that has a measurement
            '''
        
        })
    '''
    Asset that has a measurement
    '''
    
    CalculationMethodHierarchy: Optional[CalculationMethodHierarchy] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CalculationMethodHierarchy.Measurement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Calculation method hierarchy which applies to this analog.
            '''
        
        })
    '''
    Calculation method hierarchy which applies to this analog.
    '''
    
    MeasurementAction: Optional[MeasurementAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementAction.Measurement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The measurement action that is performed on the measurement
            '''
        
        })
    '''
    The measurement action that is performed on the measurement
    '''
    
    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.Measurements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The power system resource that contains the measurement.
            '''
        
        })
    '''
    The power system resource that contains the measurement.
    '''
    
    Terminal: Optional[ACDCTerminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCTerminal.Measurements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            One or more measurements may be associated with a terminal in the network.
            '''
        
        })
    '''
    One or more measurements may be associated with a terminal in the network.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MeasEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Accumulator(Measurement):
    '''
    Accumulator represents an accumulated (counted) Measurement, e.g. an energy
    value.
    '''

    maxValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''
        
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''
    
    AccumulatorValues: list[AccumulatorValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AccumulatorValue.Accumulator',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The values connected to this measurement.
            '''
        
        })
    '''
    The values connected to this measurement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Analog(Measurement):
    '''
    Analog represents an analog Measurement.
    '''

    maxValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''
        
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''
    
    minValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal value range minimum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''
        
        })
    '''
    Normal value range minimum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''
    
    normalValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal measurement value, e.g., used for percentage calculations.
            '''
        
        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''
    
    positiveFlowIn: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true then this measurement is an active power, reactive power or current
            with the convention that a positive value measured at the Terminal means
            power is flowing into the related PowerSystemResource.
            '''
        
        })
    '''
    If true then this measurement is an active power, reactive power or
    current with the convention that a positive value measured at the Terminal
    means power is flowing into the related PowerSystemResource.
    '''
    
    AnalogValues: list[AnalogValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalogValue.Analog',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The values connected to this measurement.
            '''
        
        })
    '''
    The values connected to this measurement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Discrete(Measurement):
    '''
    Discrete represents a discrete Measurement, i.e. a Measurement representing
    discrete values, e.g. a Breaker position.
    '''

    maxValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''
        
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''
    
    minValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal value range minimum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''
        
        })
    '''
    Normal value range minimum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''
    
    normalValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal measurement value, e.g., used for percentage calculations.
            '''
        
        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''
    
    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.Discretes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The ValueAliasSet used for translation of a MeasurementValue.value to a
            name.
            '''
        
        })
    '''
    The ValueAliasSet used for translation of a MeasurementValue.value
    to a name.
    '''
    
    DiscreteValues: list[DiscreteValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiscreteValue.Discrete',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The values connected to this measurement.
            '''
        
        })
    '''
    The values connected to this measurement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class StringMeasurement(Measurement):
    '''
    StringMeasurement represents a measurement with values of type string.
    '''

    StringMeasurementValues: list[StringMeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'StringMeasurementValue.StringMeasurement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The values connected to this measurement.
            '''
        
        })
    '''
    The values connected to this measurement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MeasurementAction(IdentifiedObject):
    '''
    Measurement taken as a switching step.
    '''

    Measurement: Optional[Measurement] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Measurement.MeasurementAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The measurement that the measurement action is performed on
            '''
        
        })
    '''
    The measurement that the measurement action is performed on
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MeasurementValueSource(IdentifiedObject):
    '''
    MeasurementValueSource describes the alternative sources updating a MeasurementValue.
    User conventions for how to use the MeasurementValueSource attributes are
    defined in IEC 61970-301.
    '''

    MeasurementValues: list[MeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeasurementValue.MeasurementValueSource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The MeasurementValues updated by the source.
            '''
        
        })
    '''
    The MeasurementValues updated by the source.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IOPointSource(MeasurementValueSource):
    '''
    Indicates the point source for an IO Point.
    '''

    IOPoint: list[IOPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IOPoint.IOPointSource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            ICCP point for a local measurement value source.
            '''
        
        })
    '''
    ICCP point for a local measurement value source.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ICCPConfiguration'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MutualCoupling(IdentifiedObject):
    '''
    This class represents the zero sequence line mutual coupling.
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence mutual coupling shunt (charging) susceptance, uniformly distributed,
            of the entire line section.
            '''
        
        })
    '''
    Zero sequence mutual coupling shunt (charging) susceptance, uniformly
    distributed, of the entire line section.
    '''
    
    distance11: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Distance to the start of the coupled region from the first line's terminal
            having sequence number equal to 1.
            '''
        
        })
    '''
    Distance to the start of the coupled region from the first line's terminal
    having sequence number equal to 1.
    '''
    
    distance12: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Distance to the end of the coupled region from the first line's terminal
            with sequence number equal to 1.
            '''
        
        })
    '''
    Distance to the end of the coupled region from the first line's terminal
    with sequence number equal to 1.
    '''
    
    distance21: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Distance to the start of coupled region from the second line's terminal
            with sequence number equal to 1.
            '''
        
        })
    '''
    Distance to the start of coupled region from the second line's terminal
    with sequence number equal to 1.
    '''
    
    distance22: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Distance to the end of coupled region from the second line's terminal with
            sequence number equal to 1.
            '''
        
        })
    '''
    Distance to the end of coupled region from the second line's terminal
    with sequence number equal to 1.
    '''
    
    g0ch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence mutual coupling shunt (charging) conductance, uniformly distributed,
            of the entire line section.
            '''
        
        })
    '''
    Zero sequence mutual coupling shunt (charging) conductance, uniformly
    distributed, of the entire line section.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence branch-to-branch mutual impedance coupling, resistance.
            '''
        
        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, resistance.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence branch-to-branch mutual impedance coupling, reactance.
            '''
        
        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, reactance.
    '''
    
    First_Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.HasFirstMutualCoupling',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The starting terminal for the calculation of distances along the first
            branch of the mutual coupling. Normally MutualCoupling would only be used
            for terminals of AC line segments. The first and second terminals of a
            mutual coupling should point to different AC line segments.
            '''
        
        })
    '''
    The starting terminal for the calculation of distances along the first
    branch of the mutual coupling. Normally MutualCoupling would only be
    used for terminals of AC line segments. The first and second terminals
    of a mutual coupling should point to different AC line segments.
    '''
    
    Second_Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.HasSecondMutualCoupling',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The starting terminal for the calculation of distances along the second
            branch of the mutual coupling.
            '''
        
        })
    '''
    The starting terminal for the calculation of distances along the second
    branch of the mutual coupling.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class OldPerson(IdentifiedObject):
    '''
    General purpose information for name and other information to contact people.
    '''

    MeasurementValues: list[MeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeasurementValue.ErpPerson',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfCommon'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperatingParticipant(IdentifiedObject):
    '''
    An operator of multiple power system resource objects. Note multple operating
    participants may operate the same power system resource object. This can
    be used for modeling jointly owned units where each owner operates as a
    contractual share.
    '''

    OperatingShare: list[OperatingShare] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperatingShare.OperatingParticipant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The operating shares of this operating participant. An operating participant
            can be resused for any number of power system resources.
            '''
        
        })
    '''
    The operating shares of this operating participant. An operating participant
    can be resused for any number of power system resources.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperationalLimit(IdentifiedObject):
    '''
    A value and normal value associated with a specific kind of limit.
    The sub class value and normalValue attributes vary inversely to the associated
    OperationalLimitType.acceptableDuration (acceptableDuration for short).
    If a particular piece of equipment has multiple operational limits of the
    same kind (apparent power, current, etc.), the limit with the greatest
    acceptableDuration shall have the smallest limit value and the limit with
    the smallest acceptableDuration shall have the largest limit value. Note:
    A large current can only be allowed to flow through a piece of equipment
    for a short duration without causing damage, but a lesser current can be
    allowed to flow for a longer duration.
    '''

    OperationalLimitSet: Optional[OperationalLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperationalLimitSet.OperationalLimitValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The limit set to which the limit values belong.
            '''
        
        })
    '''
    The limit set to which the limit values belong.
    '''
    
    OperationalLimitType: Optional[OperationalLimitType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperationalLimitType.OperationalLimit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The limit type associated with this limit.
            '''
        
        })
    '''
    The limit type associated with this limit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ActivePowerLimit(OperationalLimit):
    '''
    Limit on active power flow.
    '''

    normalValue: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The normal value of active power limit. The attribute shall be a positive
            value or zero.
            '''
        
        })
    '''
    The normal value of active power limit. The attribute shall be a positive
    value or zero.
    '''
    
    value: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Value of active power limit. The attribute shall be a positive value or
            zero.
            '''
        
        })
    '''
    Value of active power limit. The attribute shall be a positive value
    or zero.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ApparentPowerLimit(OperationalLimit):
    '''
    Apparent power limit.
    '''

    normalValue: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The normal apparent power limit. The attribute shall be a positive value
            or zero.
            '''
        
        })
    '''
    The normal apparent power limit. The attribute shall be a positive
    value or zero.
    '''
    
    value: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The apparent power limit. The attribute shall be a positive value or zero.
            '''
        
        })
    '''
    The apparent power limit. The attribute shall be a positive value or
    zero.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CurrentLimit(OperationalLimit):
    '''
    Operational limit on current.
    '''

    normalValue: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The normal value for limit on current flow. The attribute shall be a positive
            value or zero.
            '''
        
        })
    '''
    The normal value for limit on current flow. The attribute shall be
    a positive value or zero.
    '''
    
    value: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Limit on current flow. The attribute shall be a positive value or zero.
            '''
        
        })
    '''
    Limit on current flow. The attribute shall be a positive value or zero.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class VoltageLimit(OperationalLimit):
    '''
    Operational limit applied to voltage.
    The use of operational VoltageLimit is preferred instead of limits defined
    at VoltageLevel. The operational VoltageLimits are used, if present.
    '''

    normalValue: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The normal limit on voltage. High or low limit nature of the limit depends
            upon the properties of the operational limit type. The attribute shall
            be a positive value or zero.
            '''
        
        })
    '''
    The normal limit on voltage. High or low limit nature of the limit
    depends upon the properties of the operational limit type. The attribute
    shall be a positive value or zero.
    '''
    
    value: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Limit on voltage. High or low limit nature of the limit depends upon the
            properties of the operational limit type. The attribute shall be a positive
            value or zero.
            '''
        
        })
    '''
    Limit on voltage. High or low limit nature of the limit depends upon
    the properties of the operational limit type. The attribute shall be
    a positive value or zero.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class OperationalLimitSet(IdentifiedObject):
    '''
    A set of limits associated with equipment. Sets of limits might apply to
    a specific temperature, or season for example. A set of limits may contain
    different severities of limit levels that would apply to the same equipment.
    The set may contain limits of different types such as apparent power and
    current limits or high and low voltage limits that are logically applied
    together as a set.
    '''

    Equipment: Optional[Equipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Equipment.OperationalLimitSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The equipment to which the limit set applies.
            '''
        
        })
    '''
    The equipment to which the limit set applies.
    '''
    
    Terminal: Optional[ACDCTerminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCTerminal.OperationalLimitSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The terminal where the operational limit set apply.
            '''
        
        })
    '''
    The terminal where the operational limit set apply.
    '''
    
    OperationalLimitValue: list[OperationalLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimit.OperationalLimitSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Values of equipment limits.
            '''
        
        })
    '''
    Values of equipment limits.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperationalLimitType(IdentifiedObject):
    '''
    The operational meaning of a category of limits.
    '''

    isInfiniteDuration: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Defines if the operational limit type has infinite duration. If true, the
            limit has infinite duration. If false, the limit has definite duration
            which is defined by the attribute acceptableDuration.
            '''
        
        })
    '''
    Defines if the operational limit type has infinite duration. If true,
    the limit has infinite duration. If false, the limit has definite duration
    which is defined by the attribute acceptableDuration.
    '''
    
    acceptableDuration: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The nominal acceptable duration of the limit. Limits are commonly expressed
            in terms of the time limit for which the limit is normally acceptable.
            The actual acceptable duration of a specific limit may depend on other
            local factors such as temperature or wind speed. The attribute has meaning
            only if the flag isInfiniteDuration is set to false, hence it shall not
            be exchanged when isInfiniteDuration is set to true.
            '''
        
        })
    '''
    The nominal acceptable duration of the limit. Limits are commonly expressed
    in terms of the time limit for which the limit is normally acceptable.
    The actual acceptable duration of a specific limit may depend on other
    local factors such as temperature or wind speed. The attribute has
    meaning only if the flag isInfiniteDuration is set to false, hence
    it shall not be exchanged when isInfiniteDuration is set to true.
    '''
    
    direction: Optional[ OperationalLimitDirectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The direction of the limit.
            '''
        
        })
    '''
    The direction of the limit.
    '''
    
    TargetOperationalLimitmTypeScaling: Optional[OperatonalLimitTypeScaling] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperatonalLimitTypeScaling.TargetOperationalLimit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    OperationalLimit: list[OperationalLimit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimit.OperationalLimitType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The operational limits associated with this type of limit.
            '''
        
        })
    '''
    The operational limits associated with this type of limit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Outage(IdentifiedObject):
    '''
    Document describing details of an active or planned outage in a part of
    the electrical network.
    A non-planned outage may be created upon:
    - a breaker trip,
    - a fault indicator status change,
    - a meter event indicating customer outage,
    - a reception of one or more customer trouble calls, or
    - an operator command, reflecting information obtained from the field crew.
    Outage restoration may be performed using a switching plan which complements
    the outage information with detailed switching activities, including the
    relationship to the crew and work.
    A planned outage may be created upon:
    - a request for service, maintenance or construction work in the field,
    or
    - an operator-defined outage for what-if/contingency network analysis.
    '''

    OutageIsolationEquipment: list[ConductingEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConductingEquipment.Outage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The equipment that isolates this outage
            '''
        
        })
    '''
    The equipment that isolates this outage
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PMUConfiguration(IdentifiedObject):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MeasEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PSRType(IdentifiedObject):
    '''
    Classifying instances of the same class, e.g. overhead and underground
    ACLineSegments. This classification mechanism is intended to provide flexibility
    outside the scope of this document, i.e. provide customisation that is
    non standard.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.PSRType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Power system resources classified with this power system resource type.
            '''
        
        })
    '''
    Power system resources classified with this power system resource type.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PerLengthLineParameter(IdentifiedObject):
    '''
    Common type for per-length electrical catalogues describing line parameters.
    '''

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.PerLengthLineParameter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PerLengthDCLineParameter(PerLengthLineParameter):
    '''
    Common type for per-length electrical catalogues describing DC line parameters.
    '''

    capacitance: Optional[ float | CapacitancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Capacitance per unit of length of the DC line segment; significant for
            cables only.
            '''
        
        })
    '''
    Capacitance per unit of length of the DC line segment; significant
    for cables only.
    '''
    
    inductance: Optional[ float | InductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Inductance per unit of length of the DC line segment.
            '''
        
        })
    '''
    Inductance per unit of length of the DC line segment.
    '''
    
    resistance: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Resistance per length of the DC line segment.
            '''
        
        })
    '''
    Resistance per length of the DC line segment.
    '''
    
    DCLineSegments: list[DCLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCLineSegment.PerLengthParameter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All line segments described by this set of per-length parameters.
            '''
        
        })
    '''
    All line segments described by this set of per-length parameters.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.GridAPPSD)
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class PerLengthImpedance(PerLengthLineParameter):
    '''
    Common type for per-length impedance electrical catalogues.
    '''

    isUserDefined: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    calculatedFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    calculatedTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    rg: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Carson earth return resistance per unit length used to compute impedance
            values at base frequency. Used for making better adjustments of line impedance
            values for frequency for harmonics studies.
            '''
        
        })
    '''
    Carson earth return resistance per unit length used to compute impedance
    values at base frequency. Used for making better adjustments of line
    impedance values for frequency for harmonics studies.
    '''
    
    xg: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Carson earth return reactance per unit length used to compute impedance
            values at base frequency. Used for making better adjustments of line impedance
            values for frequency for harmonics studies.
            '''
        
        })
    '''
    Carson earth return reactance per unit length used to compute impedance
    values at base frequency. Used for making better adjustments of line
    impedance values for frequency for harmonics studies.
    '''
    
    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.PerLengthImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ACLineSegments: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.PerLengthImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All line segments described by this per-length impedance.
            '''
        
        })
    '''
    All line segments described by this per-length impedance.
    '''
    
    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.PerLengthImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.ShadowExtension)
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class PerLengthPhaseImpedance(PerLengthImpedance):
    '''
    Impedance and admittance parameters per unit length for n-wire unbalanced
    lines, in matrix form.
    '''

    conductorCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of phase, neutral, and other wires retained. Constrains the number
            of matrix elements and the phase codes that can be used with this matrix.
            '''
        
        })
    '''
    Number of phase, neutral, and other wires retained. Constrains the
    number of matrix elements and the phase codes that can be used with
    this matrix.
    '''
    
    PhaseImpedanceData: list[PhaseImpedanceData] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseImpedanceData.PhaseImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All data that belong to this conductor phase impedance.
            '''
        
        })
    '''
    All data that belong to this conductor phase impedance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.GridAPPSD)
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class PerLengthSequenceImpedance(PerLengthImpedance):
    '''
    Sequence impedance and admittance parameters per unit length, for transposed
    lines of 1, 2, or 3 phases. For 1-phase lines, define x=x0=xself. For 2-phase
    lines, define x=xs-xm and x0=xs+xm.
    '''

    b0ch: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance, per unit of length.
            '''
        
        })
    '''
    Zero sequence shunt (charging) susceptance, per unit of length.
    '''
    
    bch: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance, per unit of length.
            '''
        
        })
    '''
    Positive sequence shunt (charging) susceptance, per unit of length.
    '''
    
    g0ch: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence shunt (charging) conductance, per unit of length.
            '''
        
        })
    '''
    Zero sequence shunt (charging) conductance, per unit of length.
    '''
    
    gch: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence shunt (charging) conductance, per unit of length.
            '''
        
        })
    '''
    Positive sequence shunt (charging) conductance, per unit of length.
    '''
    
    r: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence series resistance, per unit of length.
            '''
        
        })
    '''
    Positive sequence series resistance, per unit of length.
    '''
    
    r0: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence series resistance, per unit of length.
            '''
        
        })
    '''
    Zero sequence series resistance, per unit of length.
    '''
    
    x: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence series reactance, per unit of length.
            '''
        
        })
    '''
    Positive sequence series reactance, per unit of length.
    '''
    
    x0: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence series reactance, per unit of length.
            '''
        
        })
    '''
    Zero sequence series reactance, per unit of length.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseImpedanceData(IdentifiedObject):
    '''
    Impedance and conductance matrix element values.
    The diagonal elements are described by the elements having the same toPhase
    and fromPhase value and the off diagonal elements have different toPhase
    and fromPhase values. The matrix can also be stored in symmetric lower
    triangular format using the row and column attributes, which map to ACLineSegmentPhase.sequenceNumber.
    '''

    column: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The matrix element's column number, in the range 1 to row. Only the lower
            triangle needs to be stored. This column number matches ACLineSegmentPhase.sequenceNumber.
            '''
        
        })
    '''
    The matrix element's column number, in the range 1 to row. Only the
    lower triangle needs to be stored. This column number matches ACLineSegmentPhase.sequenceNumber.
    '''
    
    row: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The matrix element�s row number, in the range 1 to PerLengthPhaseImpedance.conductorCount.
            Only the lower triangle needs to be stored. This row number matches ACLineSegmentPhase.sequenceNumber.
            '''
        
        })
    '''
    The matrix element�s row number, in the range 1 to PerLengthPhaseImpedance.conductorCount.
    Only the lower triangle needs to be stored. This row number matches
    ACLineSegmentPhase.sequenceNumber.
    '''
    
    b: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Susceptance matrix element value, per length of unit.
            '''
        
        })
    '''
    Susceptance matrix element value, per length of unit.
    '''
    
    fromPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Refer to the class description.
            '''
        
        })
    '''
    Refer to the class description.
    '''
    
    g: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Conductance matrix element value, per length of unit.
            '''
        
        })
    '''
    Conductance matrix element value, per length of unit.
    '''
    
    r: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Resistance matrix element value, per length of unit.
            '''
        
        })
    '''
    Resistance matrix element value, per length of unit.
    '''
    
    toPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Refer to the class description.
            '''
        
        })
    '''
    Refer to the class description.
    '''
    
    x: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactance matrix element value, per length of unit.
            '''
        
        })
    '''
    Reactance matrix element value, per length of unit.
    '''
    
    PhaseImpedance: Optional[PerLengthPhaseImpedance] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension GridAPPSD',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthPhaseImpedance.PhaseImpedanceData',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Conductor phase impedance to which this data belongs.
            '''
        
        })
    '''
    Conductor phase impedance to which this data belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'WiresEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerTable(IdentifiedObject):
    '''
    Describes a tabular curve for how the phase angle difference and impedance
    varies with the tap step.
    '''

    PhaseTapChangerTablePoint: list[PhaseTapChangerTablePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseTapChangerTablePoint.PhaseTapChangerTable',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The points of this table.
            '''
        
        })
    '''
    The points of this table.
    '''
    
    PhaseTapChangerTabular: list[PhaseTapChangerTabular] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseTapChangerTabular.PhaseTapChangerTable',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The phase tap changers to which this phase tap table applies.
            '''
        
        })
    '''
    The phase tap changers to which this phase tap table applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class PowerSystemResource(IdentifiedObject):
    '''
    A power system resource (PSR) can be an item of equipment such as a switch,
    an equipment container containing many individual items of equipment such
    as a substation, or an organisational entity such as sub-control area.
    Power system resources can have measurements associated.
    '''

    AssetDatasheet: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.PowerSystemResources',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Datasheet information for this power system resource.
            '''
        
        })
    '''
    Datasheet information for this power system resource.
    '''
    
    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.PowerSystemResources',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Location of this power system resource.
            '''
        
        })
    '''
    Location of this power system resource.
    '''
    
    PSRType: Optional[PSRType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PSRType.PowerSystemResources',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Custom classification for this power system resource.
            '''
        
        })
    '''
    Custom classification for this power system resource.
    '''
    
    Controls: list[Control] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Control.PowerSystemResource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The controller outputs used to actually govern a regulating device, e.g.
            the magnetization of a synchronous machine or capacitor bank breaker actuator.
            '''
        
        })
    '''
    The controller outputs used to actually govern a regulating device,
    e.g. the magnetization of a synchronous machine or capacitor bank breaker
    actuator.
    '''
    
    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.PowerSystemResource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The measurements associated with this power system resource.
            '''
        
        })
    '''
    The measurements associated with this power system resource.
    '''
    
    OperatingShare: list[OperatingShare] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperatingShare.PowerSystemResource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The operating shares of this power system resource.
            '''
        
        })
    '''
    The operating shares of this power system resource.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ACLineSegmentPhase(PowerSystemResource):
    '''
    Represents a single wire of an alternating current line segment.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number designation for this line segment phase. Each line segment phase
            within a line segment should have a unique sequence number. This is useful
            for unbalanced modelling to bind the mathematical model (PhaseImpedanceData
            of PerLengthPhaseImpedance) with the connectivity model (this class) and
            the physical model (WirePosition) without tight coupling.
            '''
        
        })
    '''
    Number designation for this line segment phase. Each line segment phase
    within a line segment should have a unique sequence number. This is
    useful for unbalanced modelling to bind the mathematical model (PhaseImpedanceData
    of PerLengthPhaseImpedance) with the connectivity model (this class)
    and the physical model (WirePosition) without tight coupling.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The phase connection of the wire at both ends.
            '''
        
        })
    '''
    The phase connection of the wire at both ends.
    '''
    
    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.ACLineSegmentPhases',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The line segment to which the phase belongs.
            '''
        
        })
    '''
    The line segment to which the phase belongs.
    '''
    
    WireInfo: Optional[WireInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireInfo.ACLineSegmentPhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Wire information contributing to this AC line segment phase information.
            '''
        
        })
    '''
    Wire information contributing to this AC line segment phase information.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class AirCompressor(PowerSystemResource):
    '''
    Combustion turbine air compressor which is an integral part of a compressed
    air energy storage (CAES) plant.
    '''

    airCompressorRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rating of the CAES air compressor.
            '''
        
        })
    '''
    Rating of the CAES air compressor.
    '''
    
    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.AirCompressor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''
        
        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''
    
    CombustionTurbine: Optional[CombustionTurbine] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CombustionTurbine.AirCompressor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A CAES air compressor is driven by combustion turbine.
            '''
        
        })
    '''
    A CAES air compressor is driven by combustion turbine.
    '''
    
    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.AirCompressor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''
        
        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CAESPlant(PowerSystemResource):
    '''
    Compressed air energy storage plant.
    '''

    energyStorageCapacity: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The rated energy storage capacity. The attribute shall be a positive value.
            '''
        
        })
    '''
    The rated energy storage capacity. The attribute shall be a positive
    value.
    '''
    
    ratedCapacityP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The CAES plant's gross rated generating capacity. The attribute shall be
            a positive value.
            '''
        
        })
    '''
    The CAES plant's gross rated generating capacity. The attribute shall
    be a positive value.
    '''
    
    AirCompressor: Optional[AirCompressor] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AirCompressor.CAESPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''
        
        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.CAESPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
    AirCompressor: Optional[AirCompressor] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AirCompressor.CAESPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''
        
        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.CAESPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CogenerationPlant(PowerSystemResource):
    '''
    A set of thermal generating units for the production of electrical energy
    and process steam (usually from the output of the steam turbines). The
    steam sendout is typically used for industrial purposes or for municipal
    heating and cooling.
    '''

    cogenHPSendoutRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The high pressure steam sendout.
            '''
        
        })
    '''
    The high pressure steam sendout.
    '''
    
    cogenHPSteamRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The high pressure steam rating.
            '''
        
        })
    '''
    The high pressure steam rating.
    '''
    
    cogenLPSendoutRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The low pressure steam sendout.
            '''
        
        })
    '''
    The low pressure steam sendout.
    '''
    
    cogenLPSteamRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The low pressure steam rating.
            '''
        
        })
    '''
    The low pressure steam rating.
    '''
    
    ratedP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The rated output active power of the cogeneration plant.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The rated output active power of the cogeneration plant.
    The attribute shall be a positive value.
    '''
    
    SteamSendoutSchedule: Optional[SteamSendoutSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SteamSendoutSchedule.CogenerationPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''
        
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
    SteamSendoutSchedule: Optional[SteamSendoutSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SteamSendoutSchedule.CogenerationPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''
        
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ThermalGeneratingUnit.CogenerationPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may be a member of a cogeneration plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a cogeneration plant.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CombinedCyclePlant(PowerSystemResource):
    '''
    A set of combustion turbines and steam turbines where the exhaust heat
    from the combustion turbines is recovered to make steam for the steam turbines,
    resulting in greater overall plant efficiency.
    '''

    combCyclePlantRating: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The combined cycle plant's active power output rating.
            '''
        
        })
    '''
    The combined cycle plant's active power output rating.
    '''
    
    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ThermalGeneratingUnit.CombinedCyclePlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may be a member of a combined cycle plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a combined cycle plant.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CombustionTurbine(PowerSystemResource):
    '''
    A prime mover that is typically fuelled by gas or light oil.
    '''

    AirCompressor: Optional[AirCompressor] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AirCompressor.CombustionTurbine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A CAES air compressor is driven by combustion turbine.
            '''
        
        })
    '''
    A CAES air compressor is driven by combustion turbine.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenerationTrainingSimulation'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CommunicationLink(PowerSystemResource):
    '''
    The connection to remote units is through one or more communication links.
    Reduntant links may exist. The CommunicationLink class inherits PowerSystemResource.
    The intention is to allow CommunicationLinks to have Measurements. These
    Measurements can be used to model link status as operational, out of service,
    unit failure etc.
    '''

    BilateralExchangeActor: Optional[BilateralExchangeActor] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BilateralExchangeActor.CommunicationLink',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            ICCP data provider or consumer using communication addressing for a Bilateral
            table.
            '''
        
        })
    '''
    ICCP data provider or consumer using communication addressing for a
    Bilateral table.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'SCADA'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConnectivityNodeContainer(PowerSystemResource):
    '''
    A base class for all objects that may contain connectivity nodes or topological
    nodes.
    '''

    ConnectivityNodes: list[ConnectivityNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConnectivityNode.ConnectivityNodeContainer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Connectivity nodes which belong to this connectivity node container.
            '''
        
        })
    '''
    Connectivity nodes which belong to this connectivity node container.
    '''
    
    TopologicalNode: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.ConnectivityNodeContainer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The topological nodes which belong to this connectivity node container.
            '''
        
        })
    '''
    The topological nodes which belong to this connectivity node container.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class EquipmentContainer(ConnectivityNodeContainer):
    '''
    A modelling construct to provide a root class for containing equipment.
    '''

    Equipments: list[Equipment] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Equipment.EquipmentContainer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Contained equipment.
            '''
        
        })
    '''
    Contained equipment.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Bay(EquipmentContainer):
    '''
    A collection of power system resources (within a given substation) including
    conducting equipment, protection relays, measurements, and telemetry. A
    bay typically represents a physical grouping related to modularization
    of equipment.
    '''

    bayEnergyMeasFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates the presence/absence of energy measurements.
            '''
        
        })
    '''
    Indicates the presence/absence of energy measurements.
    '''
    
    bayPowerMeasFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates the presence/absence of active/reactive power measurements.
            '''
        
        })
    '''
    Indicates the presence/absence of active/reactive power measurements.
    '''
    
    breakerConfiguration: Optional[ BreakerConfiguration ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Breaker configuration.
            '''
        
        })
    '''
    Breaker configuration.
    '''
    
    busBarConfiguration: Optional[ BusbarConfiguration ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Busbar configuration.
            '''
        
        })
    '''
    Busbar configuration.
    '''
    
    Circuit: Optional[Circuit] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Circuit.EndBay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.Bays',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Substation containing the bay.
            '''
        
        })
    '''
    Substation containing the bay.
    '''
    
    VoltageLevel: Optional[VoltageLevel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageLevel.Bays',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The voltage level containing this bay.
            '''
        
        })
    '''
    The voltage level containing this bay.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCEquipmentContainer(EquipmentContainer):
    '''
    A modelling construct to provide a root class for containment of DC as
    well as AC equipment. The class differ from the EquipmentContaner for AC
    in that it may also contain DCNode-s. Hence it can contain both AC and
    DC equipment.
    '''

    DCNodes: list[DCNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCNode.DCEquipmentContainer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The DC nodes contained in the DC equipment container.
            '''
        
        })
    '''
    The DC nodes contained in the DC equipment container.
    '''
    
    DCTopologicalNode: list[DCTopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCTopologicalNode.DCEquipmentContainer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The topological nodes which belong to this connectivity node container.
            '''
        
        })
    '''
    The topological nodes which belong to this connectivity node container.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCConverterUnit(DCEquipmentContainer):
    '''
    Indivisible operative unit comprising all equipment between the point of
    common coupling on the AC side and the point of common coupling � DC side,
    essentially one or more converters, together with one or more converter
    transformers, converter control equipment, essential protective and switching
    devices and auxiliaries, if any, used for conversion.
    '''

    operationMode: Optional[ DCConverterOperatingModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The operating mode of an HVDC bipole (bipolar, monopolar metallic return,
            etc).
            '''
        
        })
    '''
    The operating mode of an HVDC bipole (bipolar, monopolar metallic return,
    etc).
    '''
    
    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.DCConverterUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The containing substation of the DC converter unit.
            '''
        
        })
    '''
    The containing substation of the DC converter unit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCLine(DCEquipmentContainer):
    '''
    Overhead lines and/or cables connecting two or more HVDC substations.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubGeographicalRegion.DCLines',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The SubGeographicalRegion containing the DC line.
            '''
        
        })
    '''
    The SubGeographicalRegion containing the DC line.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Feeder(EquipmentContainer):
    '''
    A collection of equipment for organizational purposes, used for grouping
    distribution resources.
    The organization a feeder does not necessarily reflect connectivity or
    current operation state.
    '''

    NormalEnergizingSubstation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.NormalEnergizedFeeder',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The substation that nominally energizes the feeder. Also used for naming
            purposes.
            '''
        
        })
    '''
    The substation that nominally energizes the feeder. Also used for naming
    purposes.
    '''
    
    NamingSecondarySubstation: list[Substation] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Substation.NamingFeeder',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The secondary substations that are normally energized from the feeder.
            Used for naming purposes. Should be consistent with the other associations
            for energizing terminal specification and the feeder energization specification.
            '''
        
        })
    '''
    The secondary substations that are normally energized from the feeder.
    Used for naming purposes. Should be consistent with the other associations
    for energizing terminal specification and the feeder energization specification.
    '''
    
    NormalHeadTerminal: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.NormalHeadFeeder',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The normal head terminal or terminals of the feeder.
            '''
        
        })
    '''
    The normal head terminal or terminals of the feeder.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Line(EquipmentContainer):
    '''
    Contains equipment beyond a substation belonging to a power transmission
    line.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubGeographicalRegion.Lines',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The sub-geographical region of the line.
            '''
        
        })
    '''
    The sub-geographical region of the line.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class Circuit(Line):
    '''
    '''

    EndBay: list[Bay] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bay.Circuit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    EndTerminal: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.Circuit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Feeder'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Plant(EquipmentContainer):
    '''
    A Plant is a collection of equipment for purposes of generation.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Substation(EquipmentContainer):
    '''
    A collection of equipment for purposes other than generation or utilization,
    through which electric energy in bulk is passed for the purposes of switching
    or modifying its characteristics.
    '''

    NamingFeeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.NamingSecondarySubstation',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The primary feeder that normally energizes the secondary substation. Used
            for naming purposes. Either this association or the substation to subgeographical
            region should be used for hierarchical containment specification.
            '''
        
        })
    '''
    The primary feeder that normally energizes the secondary substation.
    Used for naming purposes. Either this association or the substation
    to subgeographical region should be used for hierarchical containment
    specification.
    '''
    
    Region: Optional[SubGeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubGeographicalRegion.Substations',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The SubGeographicalRegion containing the substation.
            '''
        
        })
    '''
    The SubGeographicalRegion containing the substation.
    '''
    
    Bays: list[Bay] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bay.Substation',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Bays contained in the substation.
            '''
        
        })
    '''
    Bays contained in the substation.
    '''
    
    DCConverterUnit: list[DCConverterUnit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCConverterUnit.Substation',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The DC converter unit belonging of the substation.
            '''
        
        })
    '''
    The DC converter unit belonging of the substation.
    '''
    
    NormalEnergizedFeeder: list[Feeder] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Feeder.NormalEnergizingSubstation',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The normal energized feeders of the substation. Also used for naming purposes.
            '''
        
        })
    '''
    The normal energized feeders of the substation. Also used for naming
    purposes.
    '''
    
    VoltageLevels: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.Substation',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The voltage levels within this substation.
            '''
        
        })
    '''
    The voltage levels within this substation.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class VoltageLevel(EquipmentContainer):
    '''
    A collection of equipment at one common system voltage forming a switchgear.
    The equipment typically consists of breakers, busbars, instrumentation,
    control, regulation and protection devices as well as assemblies of all
    these.
    '''

    highVoltageLimit: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The bus bar's high voltage limit.
            The limit applies to all equipment and nodes contained in a given VoltageLevel.
            It is not required that it is exchanged in pair with lowVoltageLimit. It
            is preferable to use operational VoltageLimit, which prevails, if present.
            '''
        
        })
    '''
    The bus bar's high voltage limit.
    The limit applies to all equipment and nodes contained in a given VoltageLevel.
    It is not required that it is exchanged in pair with lowVoltageLimit.
    It is preferable to use operational VoltageLimit, which prevails, if
    present.
    '''
    
    lowVoltageLimit: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The bus bar's low voltage limit.
            The limit applies to all equipment and nodes contained in a given VoltageLevel.
            It is not required that it is exchanged in pair with highVoltageLimit.
            It is preferable to use operational VoltageLimit, which prevails, if present.
            '''
        
        })
    '''
    The bus bar's low voltage limit.
    The limit applies to all equipment and nodes contained in a given VoltageLevel.
    It is not required that it is exchanged in pair with highVoltageLimit.
    It is preferable to use operational VoltageLimit, which prevails, if
    present.
    '''
    
    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.VoltageLevel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The base voltage used for all equipment within the voltage level.
            '''
        
        })
    '''
    The base voltage used for all equipment within the voltage level.
    '''
    
    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.VoltageLevels',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The substation of the voltage level.
            '''
        
        })
    '''
    The substation of the voltage level.
    '''
    
    Bays: list[Bay] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bay.VoltageLevel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The bays within this voltage level.
            '''
        
        })
    '''
    The bays within this voltage level.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ControlArea(PowerSystemResource):
    '''
    A control area is a grouping of generating units and/or loads and a cutset
    of tie lines (as terminals) which may be used for a variety of purposes
    including automatic generation control, power flow solution area interchange
    control specification, and input to load forecasting. All generation and
    load within the area defined by the terminals on the border are considered
    in the area interchange control. Note that any number of overlapping control
    area specifications can be superimposed on the physical model. The following
    general principles apply to ControlArea:
    1. The control area orientation for net interchange is positive for an
    import, negative for an export.
    2. The control area net interchange is determined by summing flows in Terminals.
    The Terminals are identified by creating a set of TieFlow objects associated
    with a ControlArea object. Each TieFlow object identifies one Terminal.
    3. In a single network model, a tie between two control areas must be modelled
    in both control area specifications, such that the two representations
    of the tie flow sum to zero.
    4. The normal orientation of Terminal flow is positive for flow into the
    conducting equipment that owns the Terminal. (i.e. flow from a bus into
    a device is positive.) However, the orientation of each flow in the control
    area specification must align with the control area convention, i.e. import
    is positive. If the orientation of the Terminal flow referenced by a TieFlow
    is positive into the control area, then this is confirmed by setting TieFlow.positiveFlowIn
    flag TRUE. If not, the orientation must be reversed by setting the TieFlow.positiveFlowIn
    flag FALSE.
    '''

    EnergyArea: Optional[EnergyArea] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyArea.ControlArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The energy area that is forecast from this control area specification.
            '''
        
        })
    '''
    The energy area that is forecast from this control area specification.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ControlArea'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergyConsumerPhase(PowerSystemResource):
    '''
    A single phase of an energy consumer.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power of the load. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''
    
    pfixed: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power of the load that is a fixed quantity. Load sign convention
            is used, i.e. positive sign means flow out from a node.
            '''
        
        })
    '''
    Active power of the load that is a fixed quantity. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''
    
    pfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fixed active power as per cent of load group fixed active power. Load sign
            convention is used, i.e. positive sign means flow out from a node.
            '''
        
        })
    '''
    Fixed active power as per cent of load group fixed active power. Load
    sign convention is used, i.e. positive sign means flow out from a node.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase of this energy consumer component. If the energy consumer is wye
            connected, the connection is from the indicated phase to the central ground
            or neutral point. If the energy consumer is delta connected, the phase
            indicates an energy consumer connected from the indicated phase to the
            next logical non-neutral phase.
            '''
        
        })
    '''
    Phase of this energy consumer component. If the energy consumer is
    wye connected, the connection is from the indicated phase to the central
    ground or neutral point. If the energy consumer is delta connected,
    the phase indicates an energy consumer connected from the indicated
    phase to the next logical non-neutral phase.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power of the load. Load sign convention is used, i.e. positive
            sign means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''
    
    qfixed: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power of the load that is a fixed quantity. Load sign convention
            is used, i.e. positive sign means flow out from a node.
            '''
        
        })
    '''
    Reactive power of the load that is a fixed quantity. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''
    
    qfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fixed reactive power as per cent of load group fixed reactive power. Load
            sign convention is used, i.e. positive sign means flow out from a node.
            '''
        
        })
    '''
    Fixed reactive power as per cent of load group fixed reactive power.
    Load sign convention is used, i.e. positive sign means flow out from
    a node.
    '''
    
    EnergyConsumer: Optional[EnergyConsumer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumer.EnergyConsumerPhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The energy consumer to which this phase belongs.
            '''
        
        })
    '''
    The energy consumer to which this phase belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergySourcePhase(PowerSystemResource):
    '''
    Represents the single phase information of an unbalanced energy source.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase of this energy source component. If the energy source wye connected,
            the connection is from the indicated phase to the central ground or neutral
            point. If the energy source is delta connected, the phase indicates an
            energy source connected from the indicated phase to the next logical non-neutral
            phase.
            '''
        
        })
    '''
    Phase of this energy source component. If the energy source wye connected,
    the connection is from the indicated phase to the central ground or
    neutral point. If the energy source is delta connected, the phase indicates
    an energy source connected from the indicated phase to the next logical
    non-neutral phase.
    '''
    
    EnergySource: Optional[EnergySource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergySource.EnergySourcePhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The energy sourceto which the phase belongs.
            '''
        
        })
    '''
    The energy sourceto which the phase belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Equipment(PowerSystemResource):
    '''
    The parts of a power system that are physical devices, electronic or mechanical.
    '''

    aggregate: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The aggregate flag provides an alternative way of representing an aggregated
            (equivalent) element. It is applicable in cases when the dedicated classes
            for equivalent equipment do not have all of the attributes necessary to
            represent the required level of detail. In case the flag is set to �true�
            the single instance of equipment represents multiple pieces of equipment
            that have been modelled together as an aggregate equivalent obtained by
            a network reduction procedure. Examples would be power transformers or
            synchronous machines operating in parallel modelled as a single aggregate
            power transformer or aggregate synchronous machine.
            The attribute is not used for EquivalentBranch, EquivalentShunt and EquivalentInjection.
            '''
        
        })
    '''
    The aggregate flag provides an alternative way of representing an aggregated
    (equivalent) element. It is applicable in cases when the dedicated
    classes for equivalent equipment do not have all of the attributes
    necessary to represent the required level of detail. In case the flag
    is set to �true� the single instance of equipment represents multiple
    pieces of equipment that have been modelled together as an aggregate
    equivalent obtained by a network reduction procedure. Examples would
    be power transformers or synchronous machines operating in parallel
    modelled as a single aggregate power transformer or aggregate synchronous
    machine.
    The attribute is not used for EquivalentBranch, EquivalentShunt and
    EquivalentInjection.
    '''
    
    inService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the availability of the equipment. True means the equipment is
            available for topology processing, which determines if the equipment is
            energized or not. False means that the equipment is treated by network
            applications as if it is not in the model.
            '''
        
        })
    '''
    Specifies the availability of the equipment. True means the equipment
    is available for topology processing, which determines if the equipment
    is energized or not. False means that the equipment is treated by network
    applications as if it is not in the model.
    '''
    
    networkAnalysisEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The equipment is enabled to participate in network analysis. If unspecified,
            the value is assumed to be true.
            '''
        
        })
    '''
    The equipment is enabled to participate in network analysis. If unspecified,
    the value is assumed to be true.
    '''
    
    normallyInService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the availability of the equipment under normal operating conditions.
            True means the equipment is available for topology processing, which determines
            if the equipment is energized or not. False means that the equipment is
            treated by network applications as if it is not in the model.
            '''
        
        })
    '''
    Specifies the availability of the equipment under normal operating
    conditions. True means the equipment is available for topology processing,
    which determines if the equipment is energized or not. False means
    that the equipment is treated by network applications as if it is not
    in the model.
    '''
    
    EquipmentContainer: Optional[EquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EquipmentContainer.Equipments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Container of this equipment.
            '''
        
        })
    '''
    Container of this equipment.
    '''
    
    ContingencyEquipment: list[ContingencyEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ContingencyEquipment.Equipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The contingency equipments in which this equipment participates.
            '''
        
        })
    '''
    The contingency equipments in which this equipment participates.
    '''
    
    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.Equipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The operational limit sets associated with this equipment.
            '''
        
        })
    '''
    The operational limit sets associated with this equipment.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AuxiliaryEquipment(Equipment):
    '''
    AuxiliaryEquipment describe equipment that is not performing any primary
    functions but support for the equipment performing the primary function.
    AuxiliaryEquipment is attached to primary equipment via an association
    with Terminal.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.AuxiliaryEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Terminal at the equipment where the AuxiliaryEquipment is attached.
            '''
        
        })
    '''
    The Terminal at the equipment where the AuxiliaryEquipment is attached.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxiliaryEquipment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FaultIndicator(AuxiliaryEquipment):
    '''
    A FaultIndicator is typically only an indicator (which may or may not be
    remotely monitored), and not a piece of equipment that actually initiates
    a protection event. It is used for FLISR (Fault Location, Isolation and
    Restoration) purposes, assisting with the dispatch of crews to "most likely"
    part of the network (i.e. assists with determining circuit section where
    the fault most likely happened).
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxiliaryEquipment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Sensor(AuxiliaryEquipment):
    '''
    This class describe devices that transform a measured quantity into signals
    that can be presented at displays, used in control or be recorded.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxiliaryEquipment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CurrentTransformer(Sensor):
    '''
    Instrument transformer used to measure electrical qualities of the circuit
    that is being protected and/or monitored. Typically used as current transducer
    for the purpose of metering or protection. A typical secondary current
    rating would be 5A.
    '''

    accuracyClass: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            CT accuracy classification.
            '''
        
        })
    '''
    CT accuracy classification.
    '''
    
    ctClass: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            CT classification; i.e. class 10P.
            '''
        
        })
    '''
    CT classification; i.e. class 10P.
    '''
    
    usage: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Intended usage of the CT; i.e. metering, protection.
            '''
        
        })
    '''
    Intended usage of the CT; i.e. metering, protection.
    '''
    
    accuracyLimit: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Percent of rated current for which the CT remains accurate within specified
            limits.
            '''
        
        })
    '''
    Percent of rated current for which the CT remains accurate within specified
    limits.
    '''
    
    coreBurden: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power burden of the CT core.
            '''
        
        })
    '''
    Power burden of the CT core.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxiliaryEquipment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DigitalFaultRecorder(Sensor):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxEqEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MergingUnit(Sensor):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxEqEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhasorMeasurementUnit(Sensor):
    '''
    '''

    reportingRate: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            For periodic data frames, PMUs shall support data reporting (by recording
            or output) at sub-multiples of the
            nominal power system frequency. Required rates are provided in Table 18
            in
            '''
        
        })
    '''
    For periodic data frames, PMUs shall support data reporting (by recording
    or output) at sub-multiples of the
    nominal power system frequency. Required rates are provided in Table
    18 in
    '''
    
    timeSourceType: Optional[ TimeSourceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            PMU must have a time source, which may be a dedicated GPS antenna for each
            PMU or an alternate source (used to prevent vulnerabilities from GPS spoofing).
            The PMU can only use one time source at a time.
            '''
        
        })
    '''
    PMU must have a time source, which may be a dedicated GPS antenna for
    each PMU or an alternate source (used to prevent vulnerabilities from
    GPS spoofing). The PMU can only use one time source at a time.
    '''
    
    usageType: Optional[ SynchrophaserUsageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            P-type units use a single electrical cycle for protection applications.
            M-type units use 5 or more cycles for higher quality frequency measurements.
            '''
        
        })
    '''
    P-type units use a single electrical cycle for protection applications.
    M-type units use 5 or more cycles for higher quality frequency measurements.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxEqEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class DisturbanceRecorder(PhasorMeasurementUnit):
    '''
    PMU that is also capable of collecting point-on-wave data
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxEqEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PointOnWaveSensor(Sensor):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxEqEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PostLineSensor(Sensor):
    '''
    A sensor used mainly in overhead distribution networks as the source of
    both current and voltage measurements.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxiliaryEquipment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PotentialTransformer(Sensor):
    '''
    Instrument transformer (also known as Voltage Transformer) used to measure
    electrical qualities of the circuit that is being protected and/or monitored.
    Typically used as voltage transducer for the purpose of metering, protection,
    or sometimes auxiliary substation supply. A typical secondary voltage rating
    would be 120V.
    '''

    accuracyClass: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            PT accuracy classification.
            '''
        
        })
    '''
    PT accuracy classification.
    '''
    
    nominalRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Nominal ratio between the primary and secondary voltage.
            '''
        
        })
    '''
    Nominal ratio between the primary and secondary voltage.
    '''
    
    ptClass: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Potential transformer (PT) classification covering burden.
            '''
        
        })
    '''
    Potential transformer (PT) classification covering burden.
    '''
    
    type: Optional[ PotentialTransformerKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Potential transformer construction type.
            '''
        
        })
    '''
    Potential transformer construction type.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxiliaryEquipment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SurgeArrester(AuxiliaryEquipment):
    '''
    Shunt device, installed on the network, usually in the proximity of electrical
    equipment in order to protect the said equipment against transient voltage
    transients caused by lightning or switching activity.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxiliaryEquipment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WaveTrap(AuxiliaryEquipment):
    '''
    Line traps are devices that impede high frequency power line carrier signals
    yet present a negligible impedance at the main power frequency.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AuxiliaryEquipment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CompositeSwitch(Equipment):
    '''
    A model of a set of individual Switches normally enclosed within the same
    cabinet and possibly with interlocks that restrict the combination of switch
    positions. These are typically found in medium voltage distribution networks.
    A CompositeSwitch could represent a Ring-Main-Unit (RMU), or pad-mounted
    switchgear, with primitive internal devices such as an internal bus-bar
    plus 3 or 4 internal switches each of which may individually be open or
    closed. A CompositeSwitch and a set of contained Switches can also be used
    to represent a multi-position switch e.g. a switch that can connect a circuit
    to Ground, Open or Busbar.
    '''

    compositeSwitchType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            An alphanumeric code that can be used as a reference to extra information
            such as the description of the interlocking scheme if any.
            '''
        
        })
    '''
    An alphanumeric code that can be used as a reference to extra information
    such as the description of the interlocking scheme if any.
    '''
    
    Switches: list[Switch] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Switch.CompositeSwitch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Switches contained in this Composite switch.
            '''
        
        })
    '''
    Switches contained in this Composite switch.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConductingEquipment(Equipment):
    '''
    The parts of the AC power system that are designed to carry current or
    that are conductively connected through terminals.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.ConductingEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Base voltage of this conducting equipment. Use only when there is no voltage
            level container used and only one base voltage applies. For example, not
            used for transformers.
            '''
        
        })
    '''
    Base voltage of this conducting equipment. Use only when there is no
    voltage level container used and only one base voltage applies. For
    example, not used for transformers.
    '''
    
    GroundingAction: Optional[GroundAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GroundAction.GroundedEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Action involving grounding operation on this conducting equipment.
            '''
        
        })
    '''
    Action involving grounding operation on this conducting equipment.
    '''
    
    JumpingAction: Optional[JumperAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'JumperAction.JumpedEquipments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Jumper action involving jumping operation on this conducting equipment.
            '''
        
        })
    '''
    Jumper action involving jumping operation on this conducting equipment.
    '''
    
    Outage: Optional[Outage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Outage.OutageIsolationEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The outage that is isolated by the outage isolation equipment.
            '''
        
        })
    '''
    The outage that is isolated by the outage isolation equipment.
    '''
    
    SvStatus: list[SvStatus] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvStatus.ConductingEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The status state variable associated with this conducting equipment.
            '''
        
        })
    '''
    The status state variable associated with this conducting equipment.
    '''
    
    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConductingEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Conducting equipment have terminals that may be connected to other conducting
            equipment terminals via connectivity nodes or topological nodes.
            '''
        
        })
    '''
    Conducting equipment have terminals that may be connected to other
    conducting equipment terminals via connectivity nodes or topological
    nodes.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ACDCConverter(ConductingEquipment):
    '''
    A unit with valves for three phases, together with unit control equipment,
    essential protective and switching devices, DC storage capacitors, phase
    reactors and auxiliaries, if any, used for conversion.
    '''

    numberOfValves: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of valves in the converter. Used in loss calculations.
            '''
        
        })
    '''
    Number of valves in the converter. Used in loss calculations.
    '''
    
    baseS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Base apparent power of the converter pole. The attribute shall be a positive
            value.
            '''
        
        })
    '''
    Base apparent power of the converter pole. The attribute shall be a
    positive value.
    '''
    
    idc: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Converter DC current, also called Id. It is converter�s state variable,
            result from power flow.
            '''
        
        })
    '''
    Converter DC current, also called Id. It is converter�s state variable,
    result from power flow.
    '''
    
    idleLoss: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power loss in pole at no power transfer. It is converter�s configuration
            data used in power flow. The attribute shall be a positive value.
            '''
        
        })
    '''
    Active power loss in pole at no power transfer. It is converter�s configuration
    data used in power flow. The attribute shall be a positive value.
    '''
    
    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum active power limit. The value is overwritten by values of VsCapabilityCurve,
            if present.
            '''
        
        })
    '''
    Maximum active power limit. The value is overwritten by values of VsCapabilityCurve,
    if present.
    '''
    
    maxUdc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum voltage on the DC side at which the converter should operate.
            It is converter�s configuration data used in power flow. The attribute
            shall be a positive value.
            '''
        
        })
    '''
    The maximum voltage on the DC side at which the converter should operate.
    It is converter�s configuration data used in power flow. The attribute
    shall be a positive value.
    '''
    
    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum active power limit. The value is overwritten by values of VsCapabilityCurve,
            if present.
            '''
        
        })
    '''
    Minimum active power limit. The value is overwritten by values of VsCapabilityCurve,
    if present.
    '''
    
    minUdc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum voltage on the DC side at which the converter should operate.
            It is converter�s configuration data used in power flow. The attribute
            shall be a positive value.
            '''
        
        })
    '''
    The minimum voltage on the DC side at which the converter should operate.
    It is converter�s configuration data used in power flow. The attribute
    shall be a positive value.
    '''
    
    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power at the point of common coupling. Load sign convention is used,
            i.e. positive sign means flow out from a node.
            Starting value for a steady state solution in the case a simplified power
            flow model is used.
            '''
        
        })
    '''
    Active power at the point of common coupling. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    Starting value for a steady state solution in the case a simplified
    power flow model is used.
    '''
    
    poleLossP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The active power loss at a DC Pole
            = idleLoss + switchingLoss*|Idc| + resitiveLoss*Idc^2.
            For lossless operation Pdc=Pac.
            For rectifier operation with losses Pdc=Pac-lossP.
            For inverter operation with losses Pdc=Pac+lossP.
            It is converter�s state variable used in power flow. The attribute shall
            be a positive value.
            '''
        
        })
    '''
    The active power loss at a DC Pole
    = idleLoss + switchingLoss*|Idc| + resitiveLoss*Idc^2.
    For lossless operation Pdc=Pac.
    For rectifier operation with losses Pdc=Pac-lossP.
    For inverter operation with losses Pdc=Pac+lossP.
    It is converter�s state variable used in power flow. The attribute
    shall be a positive value.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power at the point of common coupling. Load sign convention is
            used, i.e. positive sign means flow out from a node.
            Starting value for a steady state solution in the case a simplified power
            flow model is used.
            '''
        
        })
    '''
    Reactive power at the point of common coupling. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    Starting value for a steady state solution in the case a simplified
    power flow model is used.
    '''
    
    ratedUdc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated converter DC voltage, also called UdN. The attribute shall be a positive
            value. It is converter�s configuration data used in power flow. For instance
            a bipolar HVDC link with value 200 kV has a 400kV difference between the
            dc lines.
            '''
        
        })
    '''
    Rated converter DC voltage, also called UdN. The attribute shall be
    a positive value. It is converter�s configuration data used in power
    flow. For instance a bipolar HVDC link with value 200 kV has a 400kV
    difference between the dc lines.
    '''
    
    resistiveLoss: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            It is converter�s configuration data used in power flow. Refer to poleLossP.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    It is converter�s configuration data used in power flow. Refer to poleLossP.
    The attribute shall be a positive value.
    '''
    
    switchingLoss: Optional[ float | ActivePowerPerCurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Switching losses, relative to the base apparent power 'baseS'. Refer to
            poleLossP. The attribute shall be a positive value.
            '''
        
        })
    '''
    Switching losses, relative to the base apparent power 'baseS'. Refer
    to poleLossP. The attribute shall be a positive value.
    '''
    
    targetPpcc: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Real power injection target in AC grid, at point of common coupling. Load
            sign convention is used, i.e. positive sign means flow out from a node.
            '''
        
        })
    '''
    Real power injection target in AC grid, at point of common coupling.
    Load sign convention is used, i.e. positive sign means flow out from
    a node.
    '''
    
    targetUdc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Target value for DC voltage magnitude. The attribute shall be a positive
            value.
            '''
        
        })
    '''
    Target value for DC voltage magnitude. The attribute shall be a positive
    value.
    '''
    
    uc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Line-to-line converter voltage, the voltage at the AC side of the valve.
            It is converter�s state variable, result from power flow. The attribute
            shall be a positive value.
            '''
        
        })
    '''
    Line-to-line converter voltage, the voltage at the AC side of the valve.
    It is converter�s state variable, result from power flow. The attribute
    shall be a positive value.
    '''
    
    udc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Converter voltage at the DC side, also called Ud. It is converter�s state
            variable, result from power flow. The attribute shall be a positive value.
            '''
        
        })
    '''
    Converter voltage at the DC side, also called Ud. It is converter�s
    state variable, result from power flow. The attribute shall be a positive
    value.
    '''
    
    valveU0: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Valve threshold voltage, also called Uvalve. Forward voltage drop when
            the valve is conducting. Used in loss calculations, i.e. the switchLoss
            depend on numberOfValves * valveU0.
            '''
        
        })
    '''
    Valve threshold voltage, also called Uvalve. Forward voltage drop when
    the valve is conducting. Used in loss calculations, i.e. the switchLoss
    depend on numberOfValves * valveU0.
    '''
    
    PccTerminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.ConverterDCSides',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Point of common coupling terminal for this converter DC side. It is typically
            the terminal on the power transformer (or switch) closest to the AC network.
            '''
        
        })
    '''
    Point of common coupling terminal for this converter DC side. It is
    typically the terminal on the power transformer (or switch) closest
    to the AC network.
    '''
    
    DCTerminals: list[ACDCConverterDCTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACDCConverterDCTerminal.DCConductingEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A DC converter have DC converter terminals. A converter has two DC converter
            terminals.
            '''
        
        })
    '''
    A DC converter have DC converter terminals. A converter has two DC
    converter terminals.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CsConverter(ACDCConverter):
    '''
    DC side of the current source converter (CSC).
    The firing angle controls the dc voltage at the converter, both for rectifier
    and inverter. The difference between the dc voltages of the rectifier and
    inverter determines the dc current. The extinction angle is used to limit
    the dc voltage at the inverter, if needed, and is not used in active power
    control. The firing angle, transformer tap position and number of connected
    filters are the primary means to control a current source dc line. Higher
    level controls are built on top, e.g. dc voltage, dc current and active
    power. From a steady state perspective it is sufficient to specify the
    wanted active power transfer (ACDCConverter.targetPpcc) and the control
    functions will set the dc voltage, dc current, firing angle, transformer
    tap position and number of connected filters to meet this. Therefore attributes
    targetAlpha and targetGamma are not applicable in this case.
    The reactive power consumed by the converter is a function of the firing
    angle, transformer tap position and number of connected filter, which can
    be approximated with half of the active power. The losses is a function
    of the dc voltage and dc current.
    The attributes minAlpha and maxAlpha define the range of firing angles
    for rectifier operation between which no discrete tap changer action takes
    place. The range is typically 10-18 degrees.
    The attributes minGamma and maxGamma define the range of extinction angles
    for inverter operation between which no discrete tap changer action takes
    place. The range is typically 17-20 degrees.
    '''

    alpha: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Firing angle that determines the dc voltage at the converter dc terminal.
            Typical value between 10 degrees and 18 degrees for a rectifier. It is
            converter�s state variable, result from power flow. The attribute shall
            be a positive value.
            '''
        
        })
    '''
    Firing angle that determines the dc voltage at the converter dc terminal.
    Typical value between 10 degrees and 18 degrees for a rectifier. It
    is converter�s state variable, result from power flow. The attribute
    shall be a positive value.
    '''
    
    gamma: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Extinction angle. It is used to limit the dc voltage at the inverter if
            needed. Typical value between 17 degrees and 20 degrees for an inverter.
            It is converter�s state variable, result from power flow. The attribute
            shall be a positive value.
            '''
        
        })
    '''
    Extinction angle. It is used to limit the dc voltage at the inverter
    if needed. Typical value between 17 degrees and 20 degrees for an inverter.
    It is converter�s state variable, result from power flow. The attribute
    shall be a positive value.
    '''
    
    maxAlpha: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum firing angle. It is converter�s configuration data used in power
            flow. The attribute shall be a positive value.
            '''
        
        })
    '''
    Maximum firing angle. It is converter�s configuration data used in
    power flow. The attribute shall be a positive value.
    '''
    
    maxGamma: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum extinction angle. It is converter�s configuration data used in
            power flow. The attribute shall be a positive value.
            '''
        
        })
    '''
    Maximum extinction angle. It is converter�s configuration data used
    in power flow. The attribute shall be a positive value.
    '''
    
    maxIdc: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum direct current (Id) on the DC side at which the converter should
            operate. It is converter�s configuration data use in power flow. The attribute
            shall be a positive value.
            '''
        
        })
    '''
    The maximum direct current (Id) on the DC side at which the converter
    should operate. It is converter�s configuration data use in power flow.
    The attribute shall be a positive value.
    '''
    
    minAlpha: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum firing angle. It is converter�s configuration data used in power
            flow. The attribute shall be a positive value.
            '''
        
        })
    '''
    Minimum firing angle. It is converter�s configuration data used in
    power flow. The attribute shall be a positive value.
    '''
    
    minGamma: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum extinction angle. It is converter�s configuration data used in
            power flow. The attribute shall be a positive value.
            '''
        
        })
    '''
    Minimum extinction angle. It is converter�s configuration data used
    in power flow. The attribute shall be a positive value.
    '''
    
    minIdc: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum direct current (Id) on the DC side at which the converter should
            operate. It is converter�s configuration data used in power flow. The attribute
            shall be a positive value.
            '''
        
        })
    '''
    The minimum direct current (Id) on the DC side at which the converter
    should operate. It is converter�s configuration data used in power
    flow. The attribute shall be a positive value.
    '''
    
    operatingMode: Optional[ CsOperatingModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates whether the DC pole is operating as an inverter or as a rectifier.
            It is converter�s control variable used in power flow.
            '''
        
        })
    '''
    Indicates whether the DC pole is operating as an inverter or as a rectifier.
    It is converter�s control variable used in power flow.
    '''
    
    pPccControl: Optional[ CsPpccControlKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of active power control.
            '''
        
        })
    '''
    Kind of active power control.
    '''
    
    ratedIdc: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated converter DC current, also called IdN. The attribute shall be a positive
            value. It is converter�s configuration data used in power flow.
            '''
        
        })
    '''
    Rated converter DC current, also called IdN. The attribute shall be
    a positive value. It is converter�s configuration data used in power
    flow.
    '''
    
    targetAlpha: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Target firing angle. It is converter�s control variable used in power flow.
            It is only applicable for rectifier if continuous tap changer control is
            used. Allowed values are within the range minAlpha&lt;=targetAlpha&lt;=maxAlpha.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    Target firing angle. It is converter�s control variable used in power
    flow. It is only applicable for rectifier if continuous tap changer
    control is used. Allowed values are within the range minAlpha&lt;=targetAlpha&lt;=maxAlpha.
    The attribute shall be a positive value.
    '''
    
    targetGamma: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Target extinction angle. It is converter�s control variable used in power
            flow. It is only applicable for inverter if continuous tap changer control
            is used. Allowed values are within the range minGamma&lt;=targetGamma&lt;=maxGamma.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    Target extinction angle. It is converter�s control variable used in
    power flow. It is only applicable for inverter if continuous tap changer
    control is used. Allowed values are within the range minGamma&lt;=targetGamma&lt;=maxGamma.
    The attribute shall be a positive value.
    '''
    
    targetIdc: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            DC current target value. It is converter�s control variable used in power
            flow. The attribute shall be a positive value.
            '''
        
        })
    '''
    DC current target value. It is converter�s control variable used in
    power flow. The attribute shall be a positive value.
    '''
    
    CSCDynamics: Optional[CSCDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CSCDynamics.CSConverter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Current source converter dynamics model used to describe dynamic behaviour
            of this converter.
            '''
        
        })
    '''
    Current source converter dynamics model used to describe dynamic behaviour
    of this converter.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class VsConverter(ACDCConverter):
    '''
    DC side of the voltage source converter (VSC).
    '''

    maxModulationIndex: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum quotient between the AC converter voltage (Uc) and DC voltage
            (Ud). A factor typically less than 1. It is converter�s configuration data
            used in power flow.
            '''
        
        })
    '''
    The maximum quotient between the AC converter voltage (Uc) and DC voltage
    (Ud). A factor typically less than 1. It is converter�s configuration
    data used in power flow.
    '''
    
    targetPowerFactorPcc: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power factor target at the AC side, at point of common coupling. The attribute
            shall be a positive value.
            '''
        
        })
    '''
    Power factor target at the AC side, at point of common coupling. The
    attribute shall be a positive value.
    '''
    
    targetPWMfactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Magnitude of pulse-modulation factor. The attribute shall be a positive
            value.
            '''
        
        })
    '''
    Magnitude of pulse-modulation factor. The attribute shall be a positive
    value.
    '''
    
    delta: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Angle between VsConverter.uv and ACDCConverter.uc. It is converter�s state
            variable used in power flow. The attribute shall be a positive value or
            zero.
            '''
        
        })
    '''
    Angle between VsConverter.uv and ACDCConverter.uc. It is converter�s
    state variable used in power flow. The attribute shall be a positive
    value or zero.
    '''
    
    droop: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Droop constant. The pu value is obtained as D [kV/MW] x Sb / Ubdc. The
            attribute shall be a positive value.
            '''
        
        })
    '''
    Droop constant. The pu value is obtained as D [kV/MW] x Sb / Ubdc.
    The attribute shall be a positive value.
    '''
    
    droopCompensation: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Compensation constant. Used to compensate for voltage drop when controlling
            voltage at a distant bus. The attribute shall be a positive value.
            '''
        
        })
    '''
    Compensation constant. Used to compensate for voltage drop when controlling
    voltage at a distant bus. The attribute shall be a positive value.
    '''
    
    maxValveCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum current through a valve. It is converter�s configuration data.
            '''
        
        })
    '''
    The maximum current through a valve. It is converter�s configuration
    data.
    '''
    
    pPccControl: Optional[ VsPpccControlKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of control of real power and/or DC voltage.
            '''
        
        })
    '''
    Kind of control of real power and/or DC voltage.
    '''
    
    qPccControl: Optional[ VsQpccControlKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of reactive power control.
            '''
        
        })
    '''
    Kind of reactive power control.
    '''
    
    qShare: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power sharing factor among parallel converters on Uac control.
            The attribute shall be a positive value or zero.
            '''
        
        })
    '''
    Reactive power sharing factor among parallel converters on Uac control.
    The attribute shall be a positive value or zero.
    '''
    
    targetPhasePcc: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase target at AC side, at point of common coupling. The attribute shall
            be a positive value.
            '''
        
        })
    '''
    Phase target at AC side, at point of common coupling. The attribute
    shall be a positive value.
    '''
    
    targetQpcc: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power injection target in AC grid, at point of common coupling.
            Load sign convention is used, i.e. positive sign means flow out from a
            node.
            '''
        
        })
    '''
    Reactive power injection target in AC grid, at point of common coupling.
    Load sign convention is used, i.e. positive sign means flow out from
    a node.
    '''
    
    targetUpcc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Voltage target in AC grid, at point of common coupling. The attribute shall
            be a positive value.
            '''
        
        })
    '''
    Voltage target in AC grid, at point of common coupling. The attribute
    shall be a positive value.
    '''
    
    uv: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Line-to-line voltage on the valve side of the converter transformer. It
            is converter�s state variable, result from power flow. The attribute shall
            be a positive value.
            '''
        
        })
    '''
    Line-to-line voltage on the valve side of the converter transformer.
    It is converter�s state variable, result from power flow. The attribute
    shall be a positive value.
    '''
    
    CapabilityCurve: Optional[VsCapabilityCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VsCapabilityCurve.VsConverterDCSides',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Capability curve of this converter.
            '''
        
        })
    '''
    Capability curve of this converter.
    '''
    
    VSCDynamics: Optional[VSCDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VSCDynamics.VsConverter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Voltage source converter dynamics model used to describe dynamic behaviour
            of this converter.
            '''
        
        })
    '''
    Voltage source converter dynamics model used to describe dynamic behaviour
    of this converter.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Clamp(ConductingEquipment):
    '''
    A Clamp is a galvanic connection at a line segment where other equipment
    is connected. A Clamp does not cut the line segment.
    A Clamp is ConductingEquipment and has one Terminal with an associated
    ConnectivityNode. Any other ConductingEquipment can be connected to the
    Clamp ConnectivityNode.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The length to the place where the clamp is located starting from side one
            of the line segment, i.e. the line segment terminal with sequence number
            equal to 1.
            '''
        
        })
    '''
    The length to the place where the clamp is located starting from side
    one of the line segment, i.e. the line segment terminal with sequence
    number equal to 1.
    '''
    
    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.Clamp',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The line segment to which the clamp is connected.
            '''
        
        })
    '''
    The line segment to which the clamp is connected.
    '''
    
    ClampAction: Optional[ClampAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ClampAction.Clamp',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The clamp action that is performed on the clamp
            '''
        
        })
    '''
    The clamp action that is performed on the clamp
    '''
    
    JumperAction: Optional[JumperAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'JumperAction.Clamp',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Action taken with this jumper.
            '''
        
        })
    '''
    Action taken with this jumper.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Conductor(ConductingEquipment):
    '''
    Combination of conducting material with consistent electrical characteristics,
    building a single electrical system, used to carry current between points
    in the power system.
    '''

    length: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Segment length for calculating line section capabilities.
            '''
        
        })
    '''
    Segment length for calculating line section capabilities.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ACLineSegment(Conductor):
    '''
    A wire or combination of wires, with consistent electrical characteristics,
    building a single electrical system, used to carry alternating current
    between points in the power system.
    For symmetrical, transposed three phase lines, it is sufficient to use
    attributes of the line segment, which describe impedances and admittances
    for the entire length of the segment. Additionally impedances can be computed
    by using length and associated per length impedances.
    The BaseVoltage at the two ends of ACLineSegments in a Line shall have
    the same BaseVoltage.nominalVoltage. However, boundary lines may have slightly
    different BaseVoltage.nominalVoltages and variation is allowed. Larger
    voltage difference in general requires use of an equivalent branch.
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance, uniformly distributed, of the
            entire line section.
            '''
        
        })
    '''
    Zero sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line section.
    '''
    
    bch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance, uniformly distributed,
            of the entire line section. This value represents the full charging over
            the full length of the line.
            '''
        
        })
    '''
    Positive sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line section. This value represents the full charging
    over the full length of the line.
    '''
    
    g0ch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence shunt (charging) conductance, uniformly distributed, of the
            entire line section.
            '''
        
        })
    '''
    Zero sequence shunt (charging) conductance, uniformly distributed,
    of the entire line section.
    '''
    
    gch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence shunt (charging) conductance, uniformly distributed,
            of the entire line section.
            '''
        
        })
    '''
    Positive sequence shunt (charging) conductance, uniformly distributed,
    of the entire line section.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence series resistance of the entire line section.
            '''
        
        })
    '''
    Positive sequence series resistance of the entire line section.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence series resistance of the entire line section.
            '''
        
        })
    '''
    Zero sequence series resistance of the entire line section.
    '''
    
    shortCircuitEndTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum permitted temperature at the end of SC for the calculation of minimum
            short-circuit currents. Used for short circuit data exchange according
            to IEC 60909.
            '''
        
        })
    '''
    Maximum permitted temperature at the end of SC for the calculation
    of minimum short-circuit currents. Used for short circuit data exchange
    according to IEC 60909.
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence series reactance of the entire line section.
            '''
        
        })
    '''
    Positive sequence series reactance of the entire line section.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence series reactance of the entire line section.
            '''
        
        })
    '''
    Zero sequence series reactance of the entire line section.
    '''
    
    EarthResistivity: Optional[EarthResistivity] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EarthResistivity.ACLineSegments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    LineGroundingAction: Optional[GroundAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GroundAction.AlongACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Ground action involving clamp usage (for the case when the ground is applied
            along the line segment instead of at its terminals).
            '''
        
        })
    '''
    Ground action involving clamp usage (for the case when the ground is
    applied along the line segment instead of at its terminals).
    '''
    
    LineJumpingAction: Optional[JumperAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'JumperAction.ACLineSegments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Jumper action involving clamp usage (for the case when the jumper is applied
            along the line segment instead of at its terminals).
            '''
        
        })
    '''
    Jumper action involving clamp usage (for the case when the jumper is
    applied along the line segment instead of at its terminals).
    '''
    
    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthImpedance.ACLineSegments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Per-length impedance of this line segment.
            '''
        
        })
    '''
    Per-length impedance of this line segment.
    '''
    
    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The wire spacing information that applies to this AC line segment
            '''
        
        })
    '''
    The wire spacing information that applies to this AC line segment
    '''
    
    ACLineSegmentPhases: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The line segment phases which belong to the line segment.
            '''
        
        })
    '''
    The line segment phases which belong to the line segment.
    '''
    
    Clamp: list[Clamp] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Clamp.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The clamps connected to the line segment.
            '''
        
        })
    '''
    The clamps connected to the line segment.
    '''
    
    Cut: list[Cut] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Cut.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Cuts applied to the line segment.
            '''
        
        })
    '''
    Cuts applied to the line segment.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WireSegment(Conductor):
    '''
    A two terminal and power conducting device of negligible impedance and
    length represented as zero impedance device that can be used to connect
    auxiliary equipment to its terminals.
    '''

    WireSegmentPhases: list[WireSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireSegmentPhase.WireSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The wire segment phases which belong to the wire segment.
            '''
        
        })
    '''
    The wire segment phases which belong to the wire segment.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Connector(ConductingEquipment):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation and are
    modelled with a single logical terminal.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BusbarSection(Connector):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation.
    Voltage measurements are typically obtained from voltage transformers that
    are connected to busbar sections. A bus bar section may have many physical
    terminals but for analysis is modelled with exactly one logical terminal.
    '''

    ipMax: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum allowable peak short-circuit current of busbar (Ipmax in IEC 60909-0).
            Mechanical limit of the busbar in the substation itself. Used for short
            circuit data exchange according to IEC 60909.
            '''
        
        })
    '''
    Maximum allowable peak short-circuit current of busbar (Ipmax in IEC
    60909-0).
    Mechanical limit of the busbar in the substation itself. Used for short
    circuit data exchange according to IEC 60909.
    '''
    
    VoltageControlZone: Optional[VoltageControlZone] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageControlZone.BusbarSection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''
        
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''
    
    VoltageControlZone: Optional[VoltageControlZone] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageControlZone.BusbarSection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''
        
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Junction(Connector):
    '''
    A point where one or more conducting equipments are connected with zero
    resistance.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EarthFaultCompensator(ConductingEquipment):
    '''
    A conducting equipment used to represent a connection to ground which is
    typically used to compensate earth faults. An earth fault compensator device
    modelled with a single terminal implies a second terminal solidly connected
    to ground. If two terminals are modelled, the ground is not assumed and
    normal connection rules apply.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Nominal resistance of device.
            '''
        
        })
    '''
    Nominal resistance of device.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GroundingImpedance(EarthFaultCompensator):
    '''
    A fixed impedance device used for grounding.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactance of device.
            '''
        
        })
    '''
    Reactance of device.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PetersenCoil(EarthFaultCompensator):
    '''
    A variable impedance device normally used to offset line charging during
    single line faults in an ungrounded section of network.
    '''

    mode: Optional[ PetersenCoilModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The mode of operation of the Petersen coil.
            '''
        
        })
    '''
    The mode of operation of the Petersen coil.
    '''
    
    nominalU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The nominal voltage for which the coil is designed.
            '''
        
        })
    '''
    The nominal voltage for which the coil is designed.
    '''
    
    offsetCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The offset current that the Petersen coil controller is operating from
            the resonant point. This is normally a fixed amount for which the controller
            is configured and could be positive or negative. Typically 0 to 60 A depending
            on voltage and resonance conditions.
            '''
        
        })
    '''
    The offset current that the Petersen coil controller is operating from
    the resonant point. This is normally a fixed amount for which the controller
    is configured and could be positive or negative. Typically 0 to 60
    A depending on voltage and resonance conditions.
    '''
    
    positionCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The control current used to control the Petersen coil also known as the
            position current. Typically in the range of 20 mA to 200 mA.
            '''
        
        })
    '''
    The control current used to control the Petersen coil also known as
    the position current. Typically in the range of 20 mA to 200 mA.
    '''
    
    xGroundMax: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum reactance.
            '''
        
        })
    '''
    The maximum reactance.
    '''
    
    xGroundMin: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum reactance.
            '''
        
        })
    '''
    The minimum reactance.
    '''
    
    xGroundNominal: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The nominal reactance. This is the operating point (normally over compensation)
            that is defined based on the resonance point in the healthy network condition.
            The impedance is calculated based on nominal voltage divided by position
            current.
            '''
        
        })
    '''
    The nominal reactance. This is the operating point (normally over compensation)
    that is defined based on the resonance point in the healthy network
    condition. The impedance is calculated based on nominal voltage divided
    by position current.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergyConnection(ConductingEquipment):
    '''
    A connection of energy generation or consumption on the power system model.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergyConsumer(EnergyConnection):
    '''
    Generic user of energy - a point of consumption on the power system model.
    EnergyConsumer.pfixed, .qfixed, .pfixedPct and .qfixedPct have meaning
    only if there is no LoadResponseCharacteristic associated with EnergyConsumer
    or if LoadResponseCharacteristic.exponentModel is set to False.
    '''

    customerCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of individual customers represented by this demand.
            '''
        
        })
    '''
    Number of individual customers represented by this demand.
    '''
    
    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Used for Yn and Zn connections. True if the neutral is solidly grounded.
            '''
        
        })
    '''
    Used for Yn and Zn connections. True if the neutral is solidly grounded.
    '''
    
    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power of the load. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''
    
    pfixed: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power of the load that is a fixed quantity and does not vary as
            load group value varies. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            '''
        
        })
    '''
    Active power of the load that is a fixed quantity and does not vary
    as load group value varies. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    '''
    
    pfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fixed active power as a percentage of load group fixed active power. Used
            to represent the time-varying components. Load sign convention is used,
            i.e. positive sign means flow out from a node.
            '''
        
        })
    '''
    Fixed active power as a percentage of load group fixed active power.
    Used to represent the time-varying components. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''
    
    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of phase connection, such as wye or delta.
            '''
        
        })
    '''
    The type of phase connection, such as wye or delta.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power of the load. Load sign convention is used, i.e. positive
            sign means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''
    
    qfixed: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power of the load that is a fixed quantity and does not vary as
            load group value varies. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            '''
        
        })
    '''
    Reactive power of the load that is a fixed quantity and does not vary
    as load group value varies. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    '''
    
    qfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fixed reactive power as a percentage of load group fixed reactive power.
            Used to represent the time-varying components. Load sign convention is
            used, i.e. positive sign means flow out from a node.
            '''
        
        })
    '''
    Fixed reactive power as a percentage of load group fixed reactive power.
    Used to represent the time-varying components. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''
    
    EnergyConsumerAction: Optional[EnergyConsumerAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumerAction.EnergyConsumer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The energy consumer action that is performed on the energy consumer
            '''
        
        })
    '''
    The energy consumer action that is performed on the energy consumer
    '''
    
    LoadDynamics: Optional[LoadDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadDynamics.EnergyConsumer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Load dynamics model used to describe dynamic behaviour of this energy consumer.
            '''
        
        })
    '''
    Load dynamics model used to describe dynamic behaviour of this energy
    consumer.
    '''
    
    LoadResponse: Optional[LoadResponseCharacteristic] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadResponseCharacteristic.EnergyConsumer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The load response characteristic of this load. If missing, this load is
            assumed to be constant power.
            '''
        
        })
    '''
    The load response characteristic of this load. If missing, this load
    is assumed to be constant power.
    '''
    
    PowerCutZone: Optional[PowerCutZone] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerCutZone.EnergyConsumers',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The energy consumer is assigned to this power cut zone.
            '''
        
        })
    '''
    The energy consumer is assigned to this power cut zone.
    '''
    
    EnergyConsumerPhase: list[EnergyConsumerPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumerPhase.EnergyConsumer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The individual phase models for this energy consumer.
            '''
        
        })
    '''
    The individual phase models for this energy consumer.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConformLoad(EnergyConsumer):
    '''
    ConformLoad represent loads that follow a daily load change pattern where
    the pattern can be used to scale the load with a system load.
    '''

    LoadGroup: Optional[ConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConformLoadGroup.EnergyConsumers',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Group of this ConformLoad.
            '''
        
        })
    '''
    Group of this ConformLoad.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class NonConformLoad(EnergyConsumer):
    '''
    NonConformLoad represents loads that do not follow a daily load change
    pattern and whose changes are not correlated with the daily load change
    pattern.
    '''

    LoadGroup: Optional[NonConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NonConformLoadGroup.EnergyConsumers',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Group of this ConformLoad.
            '''
        
        })
    '''
    Group of this ConformLoad.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StationSupply(EnergyConsumer):
    '''
    Station supply with load derived from the station output.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergySource(EnergyConnection):
    '''
    A generic equivalent for an energy supplier on a transmission or distribution
    voltage level.
    '''

    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    activePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            High voltage source active injection. Load sign convention is used, i.e.
            positive sign means flow out from a node.
            Starting value for steady state solutions.
            '''
        
        })
    '''
    High voltage source active injection. Load sign convention is used,
    i.e. positive sign means flow out from a node.
    Starting value for steady state solutions.
    '''
    
    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase-to-phase nominal voltage.
            '''
        
        })
    '''
    Phase-to-phase nominal voltage.
    '''
    
    pMax: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This is the maximum active power that can be produced by the source. Load
            sign convention is used, i.e. positive sign means flow out from a TopologicalNode
            (bus) into the conducting equipment.
            '''
        
        })
    '''
    This is the maximum active power that can be produced by the source.
    Load sign convention is used, i.e. positive sign means flow out from
    a TopologicalNode (bus) into the conducting equipment.
    '''
    
    pMin: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This is the minimum active power that can be produced by the source. Load
            sign convention is used, i.e. positive sign means flow out from a TopologicalNode
            (bus) into the conducting equipment.
            '''
        
        })
    '''
    This is the minimum active power that can be produced by the source.
    Load sign convention is used, i.e. positive sign means flow out from
    a TopologicalNode (bus) into the conducting equipment.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence Thevenin resistance.
            '''
        
        })
    '''
    Positive sequence Thevenin resistance.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence Thevenin resistance.
            '''
        
        })
    '''
    Zero sequence Thevenin resistance.
    '''
    
    reactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            High voltage source reactive injection. Load sign convention is used, i.e.
            positive sign means flow out from a node.
            Starting value for steady state solutions.
            '''
        
        })
    '''
    High voltage source reactive injection. Load sign convention is used,
    i.e. positive sign means flow out from a node.
    Starting value for steady state solutions.
    '''
    
    rn: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Negative sequence Thevenin resistance.
            '''
        
        })
    '''
    Negative sequence Thevenin resistance.
    '''
    
    voltageAngle: Optional[ float | AngleRadians ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase angle of a-phase open circuit used when voltage characteristics need
            to be imposed at the node associated with the terminal of the energy source,
            such as when voltages and angles from the transmission level are used as
            input to the distribution network. The attribute shall be a positive value
            or zero.
            '''
        
        })
    '''
    Phase angle of a-phase open circuit used when voltage characteristics
    need to be imposed at the node associated with the terminal of the
    energy source, such as when voltages and angles from the transmission
    level are used as input to the distribution network. The attribute
    shall be a positive value or zero.
    '''
    
    voltageMagnitude: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase-to-phase open circuit voltage magnitude used when voltage characteristics
            need to be imposed at the node associated with the terminal of the energy
            source, such as when voltages and angles from the transmission level are
            used as input to the distribution network. The attribute shall be a positive
            value or zero.
            '''
        
        })
    '''
    Phase-to-phase open circuit voltage magnitude used when voltage characteristics
    need to be imposed at the node associated with the terminal of the
    energy source, such as when voltages and angles from the transmission
    level are used as input to the distribution network. The attribute
    shall be a positive value or zero.
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence Thevenin reactance.
            '''
        
        })
    '''
    Positive sequence Thevenin reactance.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence Thevenin reactance.
            '''
        
        })
    '''
    Zero sequence Thevenin reactance.
    '''
    
    xn: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Negative sequence Thevenin reactance.
            '''
        
        })
    '''
    Negative sequence Thevenin reactance.
    '''
    
    EnergySchedulingType: Optional[EnergySchedulingType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergySchedulingType.EnergySource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Energy Scheduling Type of an Energy Source.
            '''
        
        })
    '''
    Energy Scheduling Type of an Energy Source.
    '''
    
    EnergySourceAction: Optional[EnergySourceAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergySourceAction.EnergySource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Action taken with this energy source.
            '''
        
        })
    '''
    Action taken with this energy source.
    '''
    
    EnergySourcePhase: list[EnergySourcePhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergySourcePhase.EnergySource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The individual phase information of the energy source.
            '''
        
        })
    '''
    The individual phase information of the energy source.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RegulatingCondEq(EnergyConnection):
    '''
    A type of conducting equipment that can regulate a quantity (i.e. voltage
    or flow) at a specific point in the network.
    '''

    controlEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the regulation status of the equipment. True is regulating, false
            is not regulating.
            '''
        
        })
    '''
    Specifies the regulation status of the equipment. True is regulating,
    false is not regulating.
    '''
    
    RegulatingControl: Optional[RegulatingControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegulatingControl.RegulatingCondEq',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The regulating control scheme in which this equipment participates.
            '''
        
        })
    '''
    The regulating control scheme in which this equipment participates.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ExternalNetworkInjection(RegulatingCondEq):
    '''
    This class represents the external network and it is used for IEC 60909
    calculations.
    '''

    ikSecond: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates whether initial symmetrical short-circuit current and power have
            been calculated according to IEC (Ik"). Used only if short circuit calculations
            are done according to superposition method.
            '''
        
        })
    '''
    Indicates whether initial symmetrical short-circuit current and power
    have been calculated according to IEC (Ik"). Used only if short circuit
    calculations are done according to superposition method.
    '''
    
    maxR0ToX0Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum ratio of zero sequence resistance of Network Feeder to its zero
            sequence reactance (R(0)/X(0) max). Used for short circuit data exchange
            according to IEC 60909.
            '''
        
        })
    '''
    Maximum ratio of zero sequence resistance of Network Feeder to its
    zero sequence reactance (R(0)/X(0) max). Used for short circuit data
    exchange according to IEC 60909.
    '''
    
    maxR1ToX1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum ratio of positive sequence resistance of Network Feeder to its
            positive sequence reactance (R(1)/X(1) max). Used for short circuit data
            exchange according to IEC 60909.
            '''
        
        })
    '''
    Maximum ratio of positive sequence resistance of Network Feeder to
    its positive sequence reactance (R(1)/X(1) max). Used for short circuit
    data exchange according to IEC 60909.
    '''
    
    maxZ0ToZ1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum ratio of zero sequence impedance to its positive sequence impedance
            (Z(0)/Z(1) max). Used for short circuit data exchange according to IEC
            60909.
            '''
        
        })
    '''
    Maximum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) max). Used for short circuit data exchange according to
    IEC 60909.
    '''
    
    minR0ToX0Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates whether initial symmetrical short-circuit current and power have
            been calculated according to IEC (Ik"). Used for short circuit data exchange
            according to IEC 6090.
            '''
        
        })
    '''
    Indicates whether initial symmetrical short-circuit current and power
    have been calculated according to IEC (Ik"). Used for short circuit
    data exchange according to IEC 6090.
    '''
    
    minR1ToX1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum ratio of positive sequence resistance of Network Feeder to its
            positive sequence reactance (R(1)/X(1) min). Used for short circuit data
            exchange according to IEC 60909.
            '''
        
        })
    '''
    Minimum ratio of positive sequence resistance of Network Feeder to
    its positive sequence reactance (R(1)/X(1) min). Used for short circuit
    data exchange according to IEC 60909.
    '''
    
    minZ0ToZ1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum ratio of zero sequence impedance to its positive sequence impedance
            (Z(0)/Z(1) min). Used for short circuit data exchange according to IEC
            60909.
            '''
        
        })
    '''
    Minimum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) min). Used for short circuit data exchange according to
    IEC 60909.
    '''
    
    referencePriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Priority of unit for use as powerflow voltage phase angle reference bus
            selection. 0 = don t care (default) 1 = highest priority. 2 is less than
            1 and so on.
            '''
        
        })
    '''
    Priority of unit for use as powerflow voltage phase angle reference
    bus selection. 0 = don t care (default) 1 = highest priority. 2 is
    less than 1 and so on.
    '''
    
    governorSCD: Optional[ float | ActivePowerPerFrequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power Frequency Bias. This is the change in power injection divided by
            the change in frequency and negated. A positive value of the power frequency
            bias provides additional power injection upon a drop in frequency.
            '''
        
        })
    '''
    Power Frequency Bias. This is the change in power injection divided
    by the change in frequency and negated. A positive value of the power
    frequency bias provides additional power injection upon a drop in frequency.
    '''
    
    maxInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum initial symmetrical short-circuit currents (Ik" max) in A (Ik"
            = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according to
            IEC 60909.
            '''
        
        })
    '''
    Maximum initial symmetrical short-circuit currents (Ik" max) in A (Ik"
    = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according
    to IEC 60909.
    '''
    
    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum active power of the injection.
            '''
        
        })
    '''
    Maximum active power of the injection.
    '''
    
    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum reactive power limit. It is used for modelling of infeed for load
            flow exchange and not for short circuit modelling.
            '''
        
        })
    '''
    Maximum reactive power limit. It is used for modelling of infeed for
    load flow exchange and not for short circuit modelling.
    '''
    
    minInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum initial symmetrical short-circuit currents (Ik" min) in A (Ik"
            = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according to
            IEC 60909.
            '''
        
        })
    '''
    Minimum initial symmetrical short-circuit currents (Ik" min) in A (Ik"
    = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according
    to IEC 60909.
    '''
    
    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum active power of the injection.
            '''
        
        })
    '''
    Minimum active power of the injection.
    '''
    
    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum reactive power limit. It is used for modelling of infeed for load
            flow exchange and not for short circuit modelling.
            '''
        
        })
    '''
    Minimum reactive power limit. It is used for modelling of infeed for
    load flow exchange and not for short circuit modelling.
    '''
    
    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for steady state solutions.
            '''
        
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for steady state solutions.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for steady state solutions.
            '''
        
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for steady state solutions.
    '''
    
    voltageFactor: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Voltage factor in pu, which was used to calculate short-circuit current
            Ik" and power Sk". Used only if short circuit calculations are done according
            to superposition method.
            '''
        
        })
    '''
    Voltage factor in pu, which was used to calculate short-circuit current
    Ik" and power Sk". Used only if short circuit calculations are done
    according to superposition method.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FrequencyConverter(RegulatingCondEq):
    '''
    A device to convert from one frequency to another (e.g., frequency F1 to
    F2) comprises a pair of FrequencyConverter instances. One converts from
    F1 to DC, the other converts the DC to F2.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Frequency on the AC side.
            '''
        
        })
    '''
    Frequency on the AC side.
    '''
    
    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum active power on the DC side at which the frequency converter
            should operate.
            '''
        
        })
    '''
    The maximum active power on the DC side at which the frequency converter
    should operate.
    '''
    
    maxU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum voltage on the DC side at which the frequency converter should
            operate.
            '''
        
        })
    '''
    The maximum voltage on the DC side at which the frequency converter
    should operate.
    '''
    
    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum active power on the DC side at which the frequency converter
            should operate.
            '''
        
        })
    '''
    The minimum active power on the DC side at which the frequency converter
    should operate.
    '''
    
    minU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum voltage on the DC side at which the frequency converter should
            operate.
            '''
        
        })
    '''
    The minimum voltage on the DC side at which the frequency converter
    should operate.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerElectronicsConnection(RegulatingCondEq):
    '''
    A connection to the AC network for energy production or consumption that
    uses power electronics rather than rotating machines.
    '''

    inSafeMode: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates whether the inverter entered (true) or not (false) into Safe
            Mode.
            '''
        
        })
    '''
    Indicates whether the inverter entered (true) or not (false) into Safe
    Mode.
    '''
    
    isGridForming: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    maxIFault: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum fault current this device will contribute, in per-unit of rated
            current, before the converter protection will trip or bypass.
            '''
        
        })
    '''
    Maximum fault current this device will contribute, in per-unit of rated
    current, before the converter protection will trip or bypass.
    '''
    
    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum reactive power limit. This is the maximum (nameplate) limit for
            the unit.
            '''
        
        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit
    for the unit.
    '''
    
    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum reactive power limit for the unit. This is the minimum (nameplate)
            limit for the unit.
            '''
        
        })
    '''
    Minimum reactive power limit for the unit. This is the minimum (nameplate)
    limit for the unit.
    '''
    
    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Equivalent resistance (RG) of generator. RG is considered for the calculation
            of all currents, except for the calculation of the peak current ip. Used
            for short circuit data exchange according to IEC 60909.
            '''
        
        })
    '''
    Equivalent resistance (RG) of generator. RG is considered for the calculation
    of all currents, except for the calculation of the peak current ip.
    Used for short circuit data exchange according to IEC 60909.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence resistance of the synchronous machine.
            '''
        
        })
    '''
    Zero sequence resistance of the synchronous machine.
    '''
    
    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Nameplate apparent power rating for the unit.
            The attribute shall have a positive value.
            '''
        
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''
    
    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
            for short circuit data exchange according to IEC 60909.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily
    used for short circuit data exchange according to IEC 60909.
    The attribute shall be a positive value.
    '''
    
    rn: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Negative sequence Thevenin resistance.
            '''
        
        })
    '''
    Negative sequence Thevenin resistance.
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence Thevenin reactance.
            '''
        
        })
    '''
    Positive sequence Thevenin reactance.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence Thevenin reactance.
            '''
        
        })
    '''
    Zero sequence Thevenin reactance.
    '''
    
    xn: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Negative sequence Thevenin reactance.
            '''
        
        })
    '''
    Negative sequence Thevenin reactance.
    '''
    
    WindTurbineType3or4Dynamics: Optional[WindTurbineType3or4Dynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WindTurbineType3or4Dynamics.PowerElectronicsConnection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The wind turbine type 3 or type 4 dynamics model associated with this power
            electronics connection.
            '''
        
        })
    '''
    The wind turbine type 3 or type 4 dynamics model associated with this
    power electronics connection.
    '''
    
    PowerElectronicsConnectionPhase: list[PowerElectronicsConnectionPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnectionPhase.PowerElectronicsConnection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The individual phases models for the power electronics connection.
            '''
        
        })
    '''
    The individual phases models for the power electronics connection.
    '''
    
    PowerElectronicsUnit: list[PowerElectronicsUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsUnit.PowerElectronicsConnection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            An AC network connection may have several power electronics units connecting
            through it.
            '''
        
        })
    '''
    An AC network connection may have several power electronics units connecting
    through it.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RotatingMachine(RegulatingCondEq):
    '''
    A rotating machine which may be used as a generator or motor.
    '''

    ratedPowerFactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power factor (nameplate data). It is primarily used for short circuit data
            exchange according to IEC 60909. The attribute cannot be a negative value.
            '''
        
        })
    '''
    Power factor (nameplate data). It is primarily used for short circuit
    data exchange according to IEC 60909. The attribute cannot be a negative
    value.
    '''
    
    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Nameplate apparent power rating for the unit.
            The attribute shall have a positive value.
            '''
        
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''
    
    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
            for short circuit data exchange according to IEC 60909.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily
    used for short circuit data exchange according to IEC 60909.
    The attribute shall be a positive value.
    '''
    
    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.RotatingMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A synchronous machine may operate as a generator and as such becomes a
            member of a generating unit.
            '''
        
        })
    '''
    A synchronous machine may operate as a generator and as such becomes
    a member of a generating unit.
    '''
    
    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.RotatingMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''
        
        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''
    
    RotatingMachinePhase: Optional[RotatingMachinePhase] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachinePhase.RotatingMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.RotatingMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''
        
        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''
    
    RotatingMachinePhase: Optional[RotatingMachinePhase] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachinePhase.RotatingMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.GridAPPSD)
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class AsynchronousMachine(RotatingMachine):
    '''
    A rotating machine whose shaft rotates asynchronously with the electrical
    field. Also known as an induction machine with no external connection to
    the rotor windings, e.g. squirrel-cage induction machine.
    '''

    converterFedDrive: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates whether the machine is a converter fed drive. Used for short
            circuit data exchange according to IEC 60909.
            '''
        
        })
    '''
    Indicates whether the machine is a converter fed drive. Used for short
    circuit data exchange according to IEC 60909.
    '''
    
    iaIrRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Ratio of locked-rotor current to the rated current of the motor (Ia/Ir).
            Used for short circuit data exchange according to IEC 60909.
            '''
        
        })
    '''
    Ratio of locked-rotor current to the rated current of the motor (Ia/Ir).
    Used for short circuit data exchange according to IEC 60909.
    '''
    
    polePairNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of pole pairs of stator. Used for short circuit data exchange according
            to IEC 60909.
            '''
        
        })
    '''
    Number of pole pairs of stator. Used for short circuit data exchange
    according to IEC 60909.
    '''
    
    reversible: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates for converter drive motors if the power can be reversible. Used
            for short circuit data exchange according to IEC 60909.
            '''
        
        })
    '''
    Indicates for converter drive motors if the power can be reversible.
    Used for short circuit data exchange according to IEC 60909.
    '''
    
    rxLockedRotorRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Locked rotor ratio (R/X). Used for short circuit data exchange according
            to IEC 60909.
            '''
        
        })
    '''
    Locked rotor ratio (R/X). Used for short circuit data exchange according
    to IEC 60909.
    '''
    
    asynchronousMachineType: Optional[ AsynchronousMachineKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates the type of Asynchronous Machine (motor or generator).
            '''
        
        })
    '''
    Indicates the type of Asynchronous Machine (motor or generator).
    '''
    
    efficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Efficiency of the asynchronous machine at nominal operation as a percentage.
            Indicator for converter drive motors. Used for short circuit data exchange
            according to IEC 60909.
            '''
        
        })
    '''
    Efficiency of the asynchronous machine at nominal operation as a percentage.
    Indicator for converter drive motors. Used for short circuit data exchange
    according to IEC 60909.
    '''
    
    nominalFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Nameplate data indicates if the machine is 50 Hz or 60 Hz.
            '''
        
        })
    '''
    Nameplate data indicates if the machine is 50 Hz or 60 Hz.
    '''
    
    nominalSpeed: Optional[ float | RotationSpeed ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Nameplate data. Depends on the slip and number of pole pairs.
            '''
        
        })
    '''
    Nameplate data. Depends on the slip and number of pole pairs.
    '''
    
    ratedMechanicalPower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated mechanical power (Pr in IEC 60909-0). Used for short circuit data
            exchange according to IEC 60909.
            '''
        
        })
    '''
    Rated mechanical power (Pr in IEC 60909-0). Used for short circuit
    data exchange according to IEC 60909.
    '''
    
    rr1: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Damper 1 winding resistance.
            '''
        
        })
    '''
    Damper 1 winding resistance.
    '''
    
    rr2: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Damper 2 winding resistance.
            '''
        
        })
    '''
    Damper 2 winding resistance.
    '''
    
    tpo: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transient rotor time constant (greater than tppo).
            '''
        
        })
    '''
    Transient rotor time constant (greater than tppo).
    '''
    
    tppo: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Sub-transient rotor time constant (greater than 0).
            '''
        
        })
    '''
    Sub-transient rotor time constant (greater than 0).
    '''
    
    xlr1: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Damper 1 winding leakage reactance.
            '''
        
        })
    '''
    Damper 1 winding leakage reactance.
    '''
    
    xlr2: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Damper 2 winding leakage reactance.
            '''
        
        })
    '''
    Damper 2 winding leakage reactance.
    '''
    
    xm: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Magnetizing reactance.
            '''
        
        })
    '''
    Magnetizing reactance.
    '''
    
    xp: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transient reactance (unsaturated) (greater than or equal to xpp).
            '''
        
        })
    '''
    Transient reactance (unsaturated) (greater than or equal to xpp).
    '''
    
    xpp: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Sub-transient reactance (unsaturated).
            '''
        
        })
    '''
    Sub-transient reactance (unsaturated).
    '''
    
    xs: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Synchronous reactance (greater than xp).
            '''
        
        })
    '''
    Synchronous reactance (greater than xp).
    '''
    
    AsynchronousMachineDynamics: Optional[AsynchronousMachineDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AsynchronousMachineDynamics.AsynchronousMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Asynchronous machine dynamics model used to describe dynamic behaviour
            of this asynchronous machine.
            '''
        
        })
    '''
    Asynchronous machine dynamics model used to describe dynamic behaviour
    of this asynchronous machine.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.GridAPPSD)
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class SynchronousMachine(RotatingMachine):
    '''
    An electromechanical device that operates with shaft rotating synchronously
    with the network. It is a single machine operating either as a generator
    or synchronous condenser or pump.
    '''

    coolantCondition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Temperature or pressure of coolant medium.
            '''
        
        })
    '''
    Temperature or pressure of coolant medium.
    '''
    
    earthing: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates whether or not the generator is earthed. Used for short circuit
            data exchange according to IEC 60909.
            '''
        
        })
    '''
    Indicates whether or not the generator is earthed. Used for short circuit
    data exchange according to IEC 60909.
    '''
    
    mu: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Factor to calculate the breaking current (Section 4.5.2.1 in IEC 60909-0).
            Used only for single fed short circuit on a generator (Section 4.3.4.2.
            in IEC 60909-0).
            '''
        
        })
    '''
    Factor to calculate the breaking current (Section 4.5.2.1 in IEC 60909-0).
    Used only for single fed short circuit on a generator (Section 4.3.4.2.
    in IEC 60909-0).
    '''
    
    referencePriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Priority of unit for use as powerflow voltage phase angle reference bus
            selection. 0 = don t care (default) 1 = highest priority. 2 is less than
            1 and so on.
            '''
        
        })
    '''
    Priority of unit for use as powerflow voltage phase angle reference
    bus selection. 0 = don t care (default) 1 = highest priority. 2 is
    less than 1 and so on.
    '''
    
    aVRToManualLag: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time delay required when switching from Automatic Voltage Regulation (AVR)
            to Manual for a lagging MVAr violation.
            '''
        
        })
    '''
    Time delay required when switching from Automatic Voltage Regulation
    (AVR) to Manual for a lagging MVAr violation.
    '''
    
    aVRToManualLead: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time delay required when switching from Automatic Voltage Regulation (AVR)
            to Manual for a leading MVAr violation.
            '''
        
        })
    '''
    Time delay required when switching from Automatic Voltage Regulation
    (AVR) to Manual for a leading MVAr violation.
    '''
    
    baseQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Default base reactive power value. This value represents the initial reactive
            power that can be used by any application function.
            '''
        
        })
    '''
    Default base reactive power value. This value represents the initial
    reactive power that can be used by any application function.
    '''
    
    condenserP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power consumed when in condenser mode operation.
            '''
        
        })
    '''
    Active power consumed when in condenser mode operation.
    '''
    
    coolantType: Optional[ CoolantType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Method of cooling the machine.
            '''
        
        })
    '''
    Method of cooling the machine.
    '''
    
    earthingStarPointR: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Generator star point earthing resistance (Re). Used for short circuit data
            exchange according to IEC 60909.
            '''
        
        })
    '''
    Generator star point earthing resistance (Re). Used for short circuit
    data exchange according to IEC 60909.
    '''
    
    earthingStarPointX: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Generator star point earthing reactance (Xe). Used for short circuit data
            exchange according to IEC 60909.
            '''
        
        })
    '''
    Generator star point earthing reactance (Xe). Used for short circuit
    data exchange according to IEC 60909.
    '''
    
    ikk: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Steady-state short-circuit current (in A for the profile) of generator
            with compound excitation during 3-phase short circuit.
            - Ikk=0: Generator with no compound excitation.
            - Ikk&lt;&gt;0: Generator with compound excitation.
            Ikk is used to calculate the minimum steady-state short-circuit current
            for generators with compound excitation.
            (4.6.1.2 in IEC 60909-0:2001).
            Used only for single fed short circuit on a generator. (4.3.4.2. in IEC
            60909-0:2001).
            '''
        
        })
    '''
    Steady-state short-circuit current (in A for the profile) of generator
    with compound excitation during 3-phase short circuit.
    - Ikk=0: Generator with no compound excitation.
    - Ikk&lt;&gt;0: Generator with compound excitation.
    Ikk is used to calculate the minimum steady-state short-circuit current
    for generators with compound excitation.
    (4.6.1.2 in IEC 60909-0:2001).
    Used only for single fed short circuit on a generator. (4.3.4.2. in
    IEC 60909-0:2001).
    '''
    
    manualToAVR: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time delay required when switching from Manual to Automatic Voltage Regulation.
            This value is used in the accelerating power reference frame for powerflow
            solutions.
            '''
        
        })
    '''
    Time delay required when switching from Manual to Automatic Voltage
    Regulation. This value is used in the accelerating power reference
    frame for powerflow solutions.
    '''
    
    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum reactive power limit. This is the maximum (nameplate) limit for
            the unit.
            '''
        
        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit
    for the unit.
    '''
    
    maxU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum voltage limit for the unit.
            '''
        
        })
    '''
    Maximum voltage limit for the unit.
    '''
    
    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum reactive power limit for the unit.
            '''
        
        })
    '''
    Minimum reactive power limit for the unit.
    '''
    
    minU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum voltage limit for the unit.
            '''
        
        })
    '''
    Minimum voltage limit for the unit.
    '''
    
    operatingMode: Optional[ SynchronousMachineOperatingMode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Current mode of operation.
            '''
        
        })
    '''
    Current mode of operation.
    '''
    
    qPercent: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Part of the coordinated reactive control that comes from this machine.
            The attribute is used as a participation factor not necessarily summing
            up to 100% for the participating devices in the control.
            '''
        
        })
    '''
    Part of the coordinated reactive control that comes from this machine.
    The attribute is used as a participation factor not necessarily summing
    up to 100% for the participating devices in the control.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Equivalent resistance (RG) of generator. RG is considered for the calculation
            of all currents, except for the calculation of the peak current ip. Used
            for short circuit data exchange according to IEC 60909.
            '''
        
        })
    '''
    Equivalent resistance (RG) of generator. RG is considered for the calculation
    of all currents, except for the calculation of the peak current ip.
    Used for short circuit data exchange according to IEC 60909.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence resistance of the synchronous machine.
            '''
        
        })
    '''
    Zero sequence resistance of the synchronous machine.
    '''
    
    r2: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Negative sequence resistance.
            '''
        
        })
    '''
    Negative sequence resistance.
    '''
    
    satDirectSubtransX: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Direct-axis subtransient reactance saturated, also known as Xd"sat.
            '''
        
        })
    '''
    Direct-axis subtransient reactance saturated, also known as Xd"sat.
    '''
    
    satDirectSyncX: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Direct-axes saturated synchronous reactance (xdsat); reciprocal of short-circuit
            ration. Used for short circuit data exchange, only for single fed short
            circuit on a generator. (4.3.4.2. in IEC 60909-0:2001).
            '''
        
        })
    '''
    Direct-axes saturated synchronous reactance (xdsat); reciprocal of
    short-circuit ration. Used for short circuit data exchange, only for
    single fed short circuit on a generator. (4.3.4.2. in IEC 60909-0:2001).
    '''
    
    satDirectTransX: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Saturated Direct-axis transient reactance. The attribute is primarily used
            for short circuit calculations according to ANSI.
            '''
        
        })
    '''
    Saturated Direct-axis transient reactance. The attribute is primarily
    used for short circuit calculations according to ANSI.
    '''
    
    shortCircuitRotorType: Optional[ ShortCircuitRotorKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of rotor, used by short circuit applications, only for single fed
            short circuit according to IEC 60909.
            '''
        
        })
    '''
    Type of rotor, used by short circuit applications, only for single
    fed short circuit according to IEC 60909.
    '''
    
    type: Optional[ SynchronousMachineKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Modes that this synchronous machine can operate in.
            '''
        
        })
    '''
    Modes that this synchronous machine can operate in.
    '''
    
    voltageRegulationRange: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Range of generator voltage regulation (PG in IEC 60909-0) used for calculation
            of the impedance correction factor KG defined in IEC 60909-0.
            This attribute is used to describe the operating voltage of the generating
            unit.
            '''
        
        })
    '''
    Range of generator voltage regulation (PG in IEC 60909-0) used for
    calculation of the impedance correction factor KG defined in IEC 60909-0.
    This attribute is used to describe the operating voltage of the generating
    unit.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence reactance of the synchronous machine.
            '''
        
        })
    '''
    Zero sequence reactance of the synchronous machine.
    '''
    
    x2: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Negative sequence reactance.
            '''
        
        })
    '''
    Negative sequence reactance.
    '''
    
    InitialReactiveCapabilityCurve: Optional[ReactiveCapabilityCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReactiveCapabilityCurve.InitiallyUsedBySynchronousMachines',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The default reactive capability curve for use by a synchronous machine.
            '''
        
        })
    '''
    The default reactive capability curve for use by a synchronous machine.
    '''
    
    SynchronousMachineDynamics: Optional[SynchronousMachineDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SynchronousMachineDynamics.SynchronousMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Synchronous machine dynamics model used to describe dynamic behaviour of
            this synchronous machine.
            '''
        
        })
    '''
    Synchronous machine dynamics model used to describe dynamic behaviour
    of this synchronous machine.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ShuntCompensator(RegulatingCondEq):
    '''
    A shunt capacitor or reactor or switchable bank of shunt capacitors or
    reactors. A section of a shunt compensator is an individual capacitor or
    reactor. A negative value for bPerSection indicates that the compensator
    is a reactor. ShuntCompensator is a single terminal device. Ground is implied.
    '''

    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Used for Yn and Zn connections. True if the neutral is solidly grounded.
            '''
        
        })
    '''
    Used for Yn and Zn connections. True if the neutral is solidly grounded.
    '''
    
    maximumSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum number of sections that may be switched in.
            '''
        
        })
    '''
    The maximum number of sections that may be switched in.
    '''
    
    normalSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The normal number of sections switched in. The value shall be between zero
            and ShuntCompensator.maximumSections.
            '''
        
        })
    '''
    The normal number of sections switched in. The value shall be between
    zero and ShuntCompensator.maximumSections.
    '''
    
    sections: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Shunt compensator sections in use. Starting value for steady state solution.
            The attribute shall be a positive value or zero. Non integer values are
            allowed to support continuous variables. The reasons for continuous value
            are to support study cases where no discrete shunt compensators has yet
            been designed, a solutions where a narrow voltage band force the sections
            to oscillate or accommodate for a continuous solution as input.
            For LinearShuntConpensator the value shall be between zero and ShuntCompensator.maximumSections.
            At value zero the shunt compensator conductance and admittance is zero.
            Linear interpolation of conductance and admittance between the previous
            and next integer section is applied in case of non-integer values.
            For NonlinearShuntCompensator-s shall only be set to one of the NonlinearShuntCompenstorPoint.sectionNumber.
            There is no interpolation between NonlinearShuntCompenstorPoint-s.
            '''
        
        })
    '''
    Shunt compensator sections in use. Starting value for steady state
    solution. The attribute shall be a positive value or zero. Non integer
    values are allowed to support continuous variables. The reasons for
    continuous value are to support study cases where no discrete shunt
    compensators has yet been designed, a solutions where a narrow voltage
    band force the sections to oscillate or accommodate for a continuous
    solution as input.
    For LinearShuntConpensator the value shall be between zero and ShuntCompensator.maximumSections.
    At value zero the shunt compensator conductance and admittance is zero.
    Linear interpolation of conductance and admittance between the previous
    and next integer section is applied in case of non-integer values.
    For NonlinearShuntCompensator-s shall only be set to one of the NonlinearShuntCompenstorPoint.sectionNumber.
    There is no interpolation between NonlinearShuntCompenstorPoint-s.
    '''
    
    switchOnCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The switch on count since the capacitor count was last reset or initialized.
            '''
        
        })
    '''
    The switch on count since the capacitor count was last reset or initialized.
    '''
    
    switchOnDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The date and time when the capacitor bank was last switched on.
            '''
        
        })
    '''
    The date and time when the capacitor bank was last switched on.
    '''
    
    aVRDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            An automatic voltage regulation delay (AVRDelay) which is the time delay
            from a change in voltage to when the capacitor is allowed to change state.
            This filters out temporary changes in voltage.
            '''
        
        })
    '''
    An automatic voltage regulation delay (AVRDelay) which is the time
    delay from a change in voltage to when the capacitor is allowed to
    change state. This filters out temporary changes in voltage.
    '''
    
    nomU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The voltage at which the nominal reactive power may be calculated. This
            should normally be within 10% of the voltage at which the capacitor is
            connected to the network.
            '''
        
        })
    '''
    The voltage at which the nominal reactive power may be calculated.
    This should normally be within 10% of the voltage at which the capacitor
    is connected to the network.
    '''
    
    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of phase connection, such as wye or delta.
            '''
        
        })
    '''
    The type of phase connection, such as wye or delta.
    '''
    
    voltageSensitivity: Optional[ float | VoltagePerReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Voltage sensitivity required for the device to regulate the bus voltage,
            in voltage/reactive power.
            '''
        
        })
    '''
    Voltage sensitivity required for the device to regulate the bus voltage,
    in voltage/reactive power.
    '''
    
    ShuntCompensatorAction: Optional[ShuntCompensatorAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorAction.ShuntCompensator',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The shunt compensator action that is performed on the shunt compensator
            '''
        
        })
    '''
    The shunt compensator action that is performed on the shunt compensator
    '''
    
    ShuntCompensatorPhase: list[ShuntCompensatorPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShuntCompensatorPhase.ShuntCompensator',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The individual phases models for the shunt compensator.
            '''
        
        })
    '''
    The individual phases models for the shunt compensator.
    '''
    
    SvShuntCompensatorSections: list[SvShuntCompensatorSections] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvShuntCompensatorSections.ShuntCompensator',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The state for the number of shunt compensator sections in service.
            '''
        
        })
    '''
    The state for the number of shunt compensator sections in service.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LinearShuntCompensator(ShuntCompensator):
    '''
    A linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    b0PerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance per section.
            '''
        
        })
    '''
    Zero sequence shunt (charging) susceptance per section.
    '''
    
    bPerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance per section.
            '''
        
        })
    '''
    Positive sequence shunt (charging) susceptance per section.
    '''
    
    g0PerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence shunt (charging) conductance per section.
            '''
        
        })
    '''
    Zero sequence shunt (charging) conductance per section.
    '''
    
    gPerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence shunt (charging) conductance per section.
            '''
        
        })
    '''
    Positive sequence shunt (charging) conductance per section.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class NonlinearShuntCompensator(ShuntCompensator):
    '''
    A non linear shunt compensator has bank or section admittance values that
    differ. The attributes g, b, g0 and b0 of the associated NonlinearShuntCompensatorPoint
    describe the total conductance and admittance of a NonlinearShuntCompensatorPoint
    at a section number specified by NonlinearShuntCompensatorPoint.sectionNumber.
    '''

    NonlinearShuntCompensatorPoints: list[NonlinearShuntCompensatorPoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonlinearShuntCompensatorPoint.NonlinearShuntCompensator',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All points of the non-linear shunt compensator.
            '''
        
        })
    '''
    All points of the non-linear shunt compensator.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StaticVarCompensator(RegulatingCondEq):
    '''
    A facility for providing variable and controllable shunt reactive power.
    The SVC typically consists of a stepdown transformer, filter, thyristor-controlled
    reactor, and thyristor-switched capacitor arms.
    The SVC may operate in fixed MVar output mode or in voltage control mode.
    When in voltage control mode, the output of the SVC will be proportional
    to the deviation of voltage at the controlled bus from the voltage setpoint.
    The SVC characteristic slope defines the proportion. If the voltage at
    the controlled bus is equal to the voltage setpoint, the SVC MVar output
    is zero.
    '''

    capacitiveRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Capacitive reactance at maximum capacitive reactive power. Shall always
            be positive.
            '''
        
        })
    '''
    Capacitive reactance at maximum capacitive reactive power. Shall always
    be positive.
    '''
    
    inductiveRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Inductive reactance at maximum inductive reactive power. Shall always be
            negative.
            '''
        
        })
    '''
    Inductive reactance at maximum inductive reactive power. Shall always
    be negative.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    slope: Optional[ float | VoltagePerReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The characteristics slope of an SVC defines how the reactive power output
            changes in proportion to the difference between the regulated bus voltage
            and the voltage setpoint.
            The attribute shall be a positive value or zero.
            '''
        
        })
    '''
    The characteristics slope of an SVC defines how the reactive power
    output changes in proportion to the difference between the regulated
    bus voltage and the voltage setpoint.
    The attribute shall be a positive value or zero.
    '''
    
    sVCControlMode: Optional[ SVCControlMode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            SVC control mode.
            '''
        
        })
    '''
    SVC control mode.
    '''
    
    voltageSetPoint: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reactive power output of the SVC is proportional to the difference
            between the voltage at the regulated bus and the voltage setpoint. When
            the regulated bus voltage is equal to the voltage setpoint, the reactive
            power output is zero.
            '''
        
        })
    '''
    The reactive power output of the SVC is proportional to the difference
    between the voltage at the regulated bus and the voltage setpoint.
    When the regulated bus voltage is equal to the voltage setpoint, the
    reactive power output is zero.
    '''
    
    StaticVarCompensatorDynamics: Optional[StaticVarCompensatorDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StaticVarCompensatorDynamics.StaticVarCompensator',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Static Var Compensator dynamics model used to describe dynamic behaviour
            of this Static Var Compensator.
            '''
        
        })
    '''
    Static Var Compensator dynamics model used to describe dynamic behaviour
    of this Static Var Compensator.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Ground(ConductingEquipment):
    '''
    A point where the system is grounded used for connecting conducting equipment
    to ground. The power system model can have any number of grounds.
    '''

    GroundAction: Optional[GroundAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GroundAction.Ground',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Action taken with this ground.
            '''
        
        })
    '''
    Action taken with this ground.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerTransformer(ConductingEquipment):
    '''
    An electrical device consisting of two or more coupled windings, with or
    without a magnetic core, for introducing mutual coupling between electric
    circuits. Transformers can be used to control voltage and phase shift (active
    power flow).
    A power transformer may be composed of separate transformer tanks that
    need not be identical.
    A power transformer can be modelled with or without tanks and is intended
    for use in both balanced and unbalanced representations. A power transformer
    typically has two terminals, but may have one (grounding), three or more
    terminals.
    The inherited association ConductingEquipment.BaseVoltage should not be
    used. The association from TransformerEnd to BaseVoltage should be used
    instead.
    '''

    isPartOfGeneratorUnit: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicates whether the machine is part of a power station unit. Used for
            short circuit data exchange according to IEC 60909. It has an impact on
            how the correction factors are calculated for transformers, since the transformer
            is not necessarily part of a synchronous machine and generating unit. It
            is not always possible to derive this information from the model. This
            is why the attribute is necessary.
            '''
        
        })
    '''
    Indicates whether the machine is part of a power station unit. Used
    for short circuit data exchange according to IEC 60909. It has an impact
    on how the correction factors are calculated for transformers, since
    the transformer is not necessarily part of a synchronous machine and
    generating unit. It is not always possible to derive this information
    from the model. This is why the attribute is necessary.
    '''
    
    operationalValuesConsidered: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            It is used to define if the data (other attributes related to short circuit
            data exchange) defines long term operational conditions or not. Used for
            short circuit data exchange according to IEC 60909.
            '''
        
        })
    '''
    It is used to define if the data (other attributes related to short
    circuit data exchange) defines long term operational conditions or
    not. Used for short circuit data exchange according to IEC 60909.
    '''
    
    vectorGroup: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Vector group of the transformer for protective relaying, e.g., Dyn1. For
            unbalanced transformers, this may not be simply determined from the constituent
            winding connections and phase angle displacements.
            The vectorGroup string consists of the following components in the order
            listed: high voltage winding connection, mid voltage winding connection
            (for three winding transformers), phase displacement clock number from
            0 to 11, low voltage winding connection
            phase displacement clock number from 0 to 11. The winding connections are
            D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag with
            neutral), A (auto transformer). Upper case means the high voltage, lower
            case mid or low. The high voltage winding always has clock position 0 and
            is not included in the vector group string. Some examples: YNy0 (two winding
            wye to wye with no phase displacement), YNd11 (two winding wye to delta
            with 330 degrees phase displacement), YNyn0d5 (three winding transformer
            wye with neutral high voltage, wye with neutral mid voltage and no phase
            displacement, delta low voltage with 150 degrees displacement).
            Phase displacement is defined as the angular difference between the phasors
            representing the voltages between the neutral point (real or imaginary)
            and the corresponding terminals of two windings, a positive sequence voltage
            system being applied to the high-voltage terminals, following each other
            in alphabetical sequence if they are lettered, or in numerical sequence
            if they are numbered: the phasors are assumed to rotate in a counter-clockwise
            sense.
            '''
        
        })
    '''
    Vector group of the transformer for protective relaying, e.g., Dyn1.
    For unbalanced transformers, this may not be simply determined from
    the constituent winding connections and phase angle displacements.
    The vectorGroup string consists of the following components in the
    order listed: high voltage winding connection, mid voltage winding
    connection (for three winding transformers), phase displacement clock
    number from 0 to 11, low voltage winding connection
    phase displacement clock number from 0 to 11. The winding connections
    are D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag
    with neutral), A (auto transformer). Upper case means the high voltage,
    lower case mid or low. The high voltage winding always has clock position
    0 and is not included in the vector group string. Some examples: YNy0
    (two winding wye to wye with no phase displacement), YNd11 (two winding
    wye to delta with 330 degrees phase displacement), YNyn0d5 (three winding
    transformer wye with neutral high voltage, wye with neutral mid voltage
    and no phase displacement, delta low voltage with 150 degrees displacement).
    Phase displacement is defined as the angular difference between the
    phasors representing the voltages between the neutral point (real or
    imaginary) and the corresponding terminals of two windings, a positive
    sequence voltage system being applied to the high-voltage terminals,
    following each other in alphabetical sequence if they are lettered,
    or in numerical sequence if they are numbered: the phasors are assumed
    to rotate in a counter-clockwise sense.
    '''
    
    beforeShCircuitHighestOperatingCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The highest operating current (Ib in IEC 60909-0) before short circuit
            (depends on network configuration and relevant reliability philosophy).
            It is used for calculation of the impedance correction factor KT defined
            in IEC 60909-0.
            '''
        
        })
    '''
    The highest operating current (Ib in IEC 60909-0) before short circuit
    (depends on network configuration and relevant reliability philosophy).
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0.
    '''
    
    beforeShCircuitHighestOperatingVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The highest operating voltage (Ub in IEC 60909-0) before short circuit.
            It is used for calculation of the impedance correction factor KT defined
            in IEC 60909-0. This is worst case voltage on the low side winding (3.7.1
            of IEC 60909:2001). Used to define operating conditions.
            '''
        
        })
    '''
    The highest operating voltage (Ub in IEC 60909-0) before short circuit.
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0. This is worst case voltage on the low side winding
    (3.7.1 of IEC 60909:2001). Used to define operating conditions.
    '''
    
    beforeShortCircuitAnglePf: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The angle of power factor before short circuit (phib in IEC 60909-0). It
            is used for calculation of the impedance correction factor KT defined in
            IEC 60909-0. This is the worst case power factor. Used to define operating
            conditions.
            '''
        
        })
    '''
    The angle of power factor before short circuit (phib in IEC 60909-0).
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0. This is the worst case power factor. Used to define
    operating conditions.
    '''
    
    highSideMinOperatingU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum operating voltage (uQmin in IEC 60909-0) at the high voltage
            side (Q side) of the unit transformer of the power station unit. A value
            well established from long-term operating experience of the system. It
            is used for calculation of the impedance correction factor KG defined in
            IEC 60909-0.
            '''
        
        })
    '''
    The minimum operating voltage (uQmin in IEC 60909-0) at the high voltage
    side (Q side) of the unit transformer of the power station unit. A
    value well established from long-term operating experience of the system.
    It is used for calculation of the impedance correction factor KG defined
    in IEC 60909-0.
    '''
    
    PowerTransformerEnd: list[PowerTransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerTransformerEnd.PowerTransformer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The ends of this power transformer.
            '''
        
        })
    '''
    The ends of this power transformer.
    '''
    
    TransformerTanks: list[TransformerTank] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTank.PowerTransformer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All transformers that belong to this bank.
            '''
        
        })
    '''
    All transformers that belong to this bank.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SeriesCompensator(ConductingEquipment):
    '''
    A Series Compensator is a series capacitor or reactor or an AC transmission
    line without charging susceptance. It is a two terminal device.
    '''

    varistorPresent: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Describe if a metal oxide varistor (mov) for over voltage protection is
            configured in parallel with the series compensator. It is used for short
            circuit calculations.
            '''
        
        })
    '''
    Describe if a metal oxide varistor (mov) for over voltage protection
    is configured in parallel with the series compensator. It is used for
    short circuit calculations.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence resistance.
            '''
        
        })
    '''
    Positive sequence resistance.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence resistance.
            '''
        
        })
    '''
    Zero sequence resistance.
    '''
    
    varistorRatedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum current the varistor is designed to handle at specified duration.
            It is used for short circuit calculations and exchanged only if SeriesCompensator.varistorPresent
            is true.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The maximum current the varistor is designed to handle at specified
    duration. It is used for short circuit calculations and exchanged only
    if SeriesCompensator.varistorPresent is true.
    The attribute shall be a positive value.
    '''
    
    varistorVoltageThreshold: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The dc voltage at which the varistor starts conducting. It is used for
            short circuit calculations and exchanged only if SeriesCompensator.varistorPresent
            is true.
            '''
        
        })
    '''
    The dc voltage at which the varistor starts conducting. It is used
    for short circuit calculations and exchanged only if SeriesCompensator.varistorPresent
    is true.
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence reactance.
            '''
        
        })
    '''
    Positive sequence reactance.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence reactance.
            '''
        
        })
    '''
    Zero sequence reactance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Switch(ConductingEquipment):
    '''
    A generic device designed to close, or open, or both, one or more electric
    circuits. All switches are two terminal devices including grounding switches.
    The ACDCTerminal.connected at the two sides of the switch shall not be
    considered for assessing switch connectivity, i.e. only Switch.open, .normalOpen
    and .locked are relevant.
    '''

    locked: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, the switch is locked. The resulting switch state is a combination
            of locked and Switch.open attributes as follows:
            <ul>
            <li>locked=true and Switch.open=true. The resulting state is open and locked;</li>
            <li>locked=false and Switch.open=true. The resulting state is open;</li>
            <li>locked=false and Switch.open=false. The resulting state is closed.</li>
            </ul>
            '''
        
        })
    '''
    If true, the switch is locked. The resulting switch state is a combination
    of locked and Switch.open attributes as follows:
    <ul>
    <li>locked=true and Switch.open=true. The resulting state is open and
    locked;</li>
    <li>locked=false and Switch.open=true. The resulting state is open;</li>
    <li>locked=false and Switch.open=false. The resulting state is closed.</li>
    </ul>
    '''
    
    normalOpen: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The attribute is used in cases when no Measurement for the status value
            is present. If the Switch has a status measurement the Discrete.normalValue
            is expected to match with the Switch.normalOpen.
            '''
        
        })
    '''
    The attribute is used in cases when no Measurement for the status value
    is present. If the Switch has a status measurement the Discrete.normalValue
    is expected to match with the Switch.normalOpen.
    '''
    
    open: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The attribute tells if the switch is considered open when used as input
            to topology processing.
            '''
        
        })
    '''
    The attribute tells if the switch is considered open when used as input
    to topology processing.
    '''
    
    retained: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Branch is retained in the topological solution. The flow through retained
            switches will normally be calculated in power flow.
            '''
        
        })
    '''
    Branch is retained in the topological solution. The flow through retained
    switches will normally be calculated in power flow.
    '''
    
    switchOnCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The switch on count since the switch was last reset or initialized.
            '''
        
        })
    '''
    The switch on count since the switch was last reset or initialized.
    '''
    
    switchOnDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The date and time when the switch was last switched on.
            '''
        
        })
    '''
    The date and time when the switch was last switched on.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum continuous current carrying capacity in amps governed by the
            device material and construction.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The maximum continuous current carrying capacity in amps governed by
    the device material and construction.
    The attribute shall be a positive value.
    '''
    
    CompositeSwitch: Optional[CompositeSwitch] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CompositeSwitch.Switches',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Composite switch to which this Switch belongs.
            '''
        
        })
    '''
    Composite switch to which this Switch belongs.
    '''
    
    SwitchAction: Optional[SwitchAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SwitchAction.OperatedSwitch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Action changing status of this switch.
            '''
        
        })
    '''
    Action changing status of this switch.
    '''
    
    SvSwitch: list[SvSwitch] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvSwitch.Switch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The switch state associated with the switch.
            '''
        
        })
    '''
    The switch state associated with the switch.
    '''
    
    SwitchPhase: list[SwitchPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SwitchPhase.Switch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The individual switch phases for the switch.
            '''
        
        })
    '''
    The individual switch phases for the switch.
    '''
    
    SwitchSchedules: list[SwitchSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SwitchSchedule.Switch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A Switch can be associated with SwitchSchedules.
            '''
        
        })
    '''
    A Switch can be associated with SwitchSchedules.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Cut(Switch):
    '''
    A cut separates a line segment into two parts. The cut appears as a switch
    inserted between these two parts and connects them together. As the cut
    is normally open there is no galvanic connection between the two line segment
    parts. But it is possible to close the cut to get galvanic connection.
    The cut terminals are oriented towards the line segment terminals with
    the same sequence number. Hence the cut terminal with sequence number equal
    to 1 is oriented to the line segment's terminal with sequence number equal
    to 1.
    The cut terminals also act as connection points for jumpers and other equipment,
    e.g. a mobile generator. To enable this, connectivity nodes are placed
    at the cut terminals. Once the connectivity nodes are in place any conducting
    equipment can be connected at them.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The length to the place where the cut is located starting from side one
            of the cut line segment, i.e. the line segment Terminal with sequenceNumber
            equal to 1.
            '''
        
        })
    '''
    The length to the place where the cut is located starting from side
    one of the cut line segment, i.e. the line segment Terminal with sequenceNumber
    equal to 1.
    '''
    
    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.Cut',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The line segment to which the cut is applied.
            '''
        
        })
    '''
    The line segment to which the cut is applied.
    '''
    
    CutAction: Optional[CutAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CutAction.Cut',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Action taken with this cut.
            '''
        
        })
    '''
    Action taken with this cut.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Disconnector(Switch):
    '''
    A manually operated or motor operated mechanical switching device used
    for changing the connections in a circuit, or for isolating a circuit or
    equipment from a source of power. It is required to open or close circuits
    when negligible current is broken or made.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Fuse(Switch):
    '''
    An overcurrent protective device with a circuit opening fusible part that
    is heated and severed by the passage of overcurrent through it. A fuse
    is considered a switching device because it breaks current.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GroundDisconnector(Switch):
    '''
    A manually operated or motor operated mechanical switching device used
    for isolating a circuit or equipment from ground.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Jumper(Switch):
    '''
    A short section of conductor with negligible impedance which can be manually
    removed and replaced if the circuit is de-energized. Note that zero-impedance
    branches can potentially be modelled by other equipment types.
    '''

    JumperAction: Optional[JumperAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'JumperAction.Jumper',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Action taken with this jumper.
            '''
        
        })
    '''
    Action taken with this jumper.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ProtectedSwitch(Switch):
    '''
    A ProtectedSwitch is a switching device that can be operated by ProtectionEquipment.
    '''

    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum fault current a breaking device can break safely under prescribed
            conditions of use.
            '''
        
        })
    '''
    The maximum fault current a breaking device can break safely under
    prescribed conditions of use.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Breaker(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal circuit conditions and also making, carrying for
    a specified time, and breaking currents under specified abnormal circuit
    conditions e.g. those of short circuit.
    '''

    inTransitTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The transition time from open to close.
            '''
        
        })
    '''
    The transition time from open to close.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DisconnectingCircuitBreaker(Breaker):
    '''
    A circuit breaking device including disconnecting function, eliminating
    the need for separate disconnectors.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LoadBreakSwitch(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal operating conditions.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Recloser(ProtectedSwitch):
    '''
    Pole-mounted fault interrupter with built-in phase and ground relays, current
    transformer (CT), and supplemental controls.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Sectionaliser(Switch):
    '''
    Automatic switch that will lock open to isolate a faulted section. It may,
    or may not, have load breaking capability. Its primary purpose is to provide
    fault sectionalising at locations where the fault current is either too
    high, or too low, for proper coordination of fuses.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCConductingEquipment(Equipment):
    '''
    The parts of the DC power system that are designed to carry current or
    that are conductively connected through DC terminals.
    '''

    ratedUdc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated DC device voltage. The attribute shall be a positive value. It is
            configuration data used in power flow.
            '''
        
        })
    '''
    Rated DC device voltage. The attribute shall be a positive value. It
    is configuration data used in power flow.
    '''
    
    DCTerminals: list[DCTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCTerminal.DCConductingEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A DC conducting equipment has DC terminals.
            '''
        
        })
    '''
    A DC conducting equipment has DC terminals.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCBusbar(DCConductingEquipment):
    '''
    A busbar within a DC system.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCChopper(DCConductingEquipment):
    '''
    Low resistance equipment used in the internal DC circuit to balance voltages.
    It has typically positive and negative pole terminals and a ground.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCGround(DCConductingEquipment):
    '''
    A ground within a DC system.
    '''

    inductance: Optional[ float | Inductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Inductance to ground.
            '''
        
        })
    '''
    Inductance to ground.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Resistance to ground.
            '''
        
        })
    '''
    Resistance to ground.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCLineSegment(DCConductingEquipment):
    '''
    A wire or combination of wires not insulated from one another, with consistent
    electrical characteristics, used to carry direct current between points
    in the DC region of the power system.
    '''

    capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Capacitance of the DC line segment. Significant for cables only.
            '''
        
        })
    '''
    Capacitance of the DC line segment. Significant for cables only.
    '''
    
    inductance: Optional[ float | Inductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Inductance of the DC line segment. Negligible compared with DCSeriesDevice
            used for smoothing.
            '''
        
        })
    '''
    Inductance of the DC line segment. Negligible compared with DCSeriesDevice
    used for smoothing.
    '''
    
    length: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Segment length for calculating line section capabilities.
            '''
        
        })
    '''
    Segment length for calculating line section capabilities.
    '''
    
    resistance: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Resistance of the DC line segment.
            '''
        
        })
    '''
    Resistance of the DC line segment.
    '''
    
    PerLengthParameter: Optional[PerLengthDCLineParameter] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthDCLineParameter.DCLineSegments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Set of per-length parameters for this line segment.
            '''
        
        })
    '''
    Set of per-length parameters for this line segment.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCSeriesDevice(DCConductingEquipment):
    '''
    A series device within the DC system, typically a reactor used for filtering
    or smoothing. Needed for transient and short circuit studies.
    '''

    inductance: Optional[ float | Inductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Inductance of the device.
            '''
        
        })
    '''
    Inductance of the device.
    '''
    
    resistance: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Resistance of the DC device.
            '''
        
        })
    '''
    Resistance of the DC device.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCShunt(DCConductingEquipment):
    '''
    A shunt device within the DC system, typically used for filtering. Needed
    for transient and short circuit studies.
    '''

    capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Capacitance of the DC shunt.
            '''
        
        })
    '''
    Capacitance of the DC shunt.
    '''
    
    resistance: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Resistance of the DC device.
            '''
        
        })
    '''
    Resistance of the DC device.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCSwitch(DCConductingEquipment):
    '''
    A switch within the DC system.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCBreaker(DCSwitch):
    '''
    A breaker within a DC system.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCDisconnector(DCSwitch):
    '''
    A disconnector within a DC system.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class GeneratingUnit(Equipment):
    '''
    A single or set of synchronous machines for converting mechanical power
    into alternating-current power. For example, individual machines within
    a set may be defined for scheduling purposes while a single control signal
    is derived for the set. In this case there would be a GeneratingUnit for
    each member of the set and an additional GeneratingUnit corresponding to
    the set.
    '''

    longPF: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Generating unit long term economic participation factor.
            '''
        
        })
    '''
    Generating unit long term economic participation factor.
    '''
    
    normalPF: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Generating unit economic participation factor. The sum of the participation
            factors across generating units does not have to sum to one. It is used
            for representing distributed slack participation factor. The attribute
            shall be a positive value or zero.
            '''
        
        })
    '''
    Generating unit economic participation factor. The sum of the participation
    factors across generating units does not have to sum to one. It is
    used for representing distributed slack participation factor. The attribute
    shall be a positive value or zero.
    '''
    
    penaltyFactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Defined as: 1 / ( 1 - Incremental Transmission Loss); with the Incremental
            Transmission Loss expressed as a plus or minus value. The typical range
            of penalty factors is (0.9 to 1.1).
            '''
        
        })
    '''
    Defined as: 1 / ( 1 - Incremental Transmission Loss); with the Incremental
    Transmission Loss expressed as a plus or minus value. The typical range
    of penalty factors is (0.9 to 1.1).
    '''
    
    shortPF: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Generating unit short term economic participation factor.
            '''
        
        })
    '''
    Generating unit short term economic participation factor.
    '''
    
    tieLinePF: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Generating unit economic participation factor.
            '''
        
        })
    '''
    Generating unit economic participation factor.
    '''
    
    allocSpinResP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The planned unused capacity (spinning reserve) which can be used to support
            emergency load.
            '''
        
        })
    '''
    The planned unused capacity (spinning reserve) which can be used to
    support emergency load.
    '''
    
    autoCntrlMarginP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The planned unused capacity which can be used to support automatic control
            overruns.
            '''
        
        })
    '''
    The planned unused capacity which can be used to support automatic
    control overruns.
    '''
    
    baseP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            For dispatchable units, this value represents the economic active power
            basepoint, for units that are not dispatchable, this value represents the
            fixed generation value. The value shall be between the operating low and
            high limits.
            '''
        
        })
    '''
    For dispatchable units, this value represents the economic active power
    basepoint, for units that are not dispatchable, this value represents
    the fixed generation value. The value shall be between the operating
    low and high limits.
    '''
    
    controlDeadband: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Unit control error deadband. When a unit's desired active power change
            is less than this deadband, then no control pulses will be sent to the
            unit.
            '''
        
        })
    '''
    Unit control error deadband. When a unit's desired active power change
    is less than this deadband, then no control pulses will be sent to
    the unit.
    '''
    
    controlPulseHigh: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Pulse high limit which is the largest control pulse that the unit can respond
            to.
            '''
        
        })
    '''
    Pulse high limit which is the largest control pulse that the unit can
    respond to.
    '''
    
    controlPulseLow: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Pulse low limit which is the smallest control pulse that the unit can respond
            to.
            '''
        
        })
    '''
    Pulse low limit which is the smallest control pulse that the unit can
    respond to.
    '''
    
    controlResponseRate: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Unit response rate which specifies the active power change for a control
            pulse of one second in the most responsive loading level of the unit.
            '''
        
        })
    '''
    Unit response rate which specifies the active power change for a control
    pulse of one second in the most responsive loading level of the unit.
    '''
    
    efficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The efficiency of the unit in converting mechanical energy, from the prime
            mover, into electrical energy.
            '''
        
        })
    '''
    The efficiency of the unit in converting mechanical energy, from the
    prime mover, into electrical energy.
    '''
    
    genControlMode: Optional[ GeneratorControlMode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit control mode.
            '''
        
        })
    '''
    The unit control mode.
    '''
    
    genControlSource: Optional[ GeneratorControlSource ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The source of controls for a generating unit. Defines the control status
            of the generating unit.
            '''
        
        })
    '''
    The source of controls for a generating unit. Defines the control status
    of the generating unit.
    '''
    
    governorMPL: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Governor motor position limit.
            '''
        
        })
    '''
    Governor motor position limit.
    '''
    
    governorSCD: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Governor Speed Changer Droop. This is the change in generator power output
            divided by the change in frequency normalized by the nominal power of the
            generator and the nominal frequency and expressed in percent and negated.
            A positive value of speed change droop provides additional generator output
            upon a drop in frequency.
            '''
        
        })
    '''
    Governor Speed Changer Droop. This is the change in generator power
    output divided by the change in frequency normalized by the nominal
    power of the generator and the nominal frequency and expressed in percent
    and negated. A positive value of speed change droop provides additional
    generator output upon a drop in frequency.
    '''
    
    highControlLimit: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            High limit for secondary (AGC) control.
            '''
        
        })
    '''
    High limit for secondary (AGC) control.
    '''
    
    initialP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Default initial active power which is used to store a powerflow result
            for the initial active power for this unit in this network configuration.
            '''
        
        })
    '''
    Default initial active power which is used to store a powerflow result
    for the initial active power for this unit in this network configuration.
    '''
    
    lowControlLimit: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Low limit for secondary (AGC) control.
            '''
        
        })
    '''
    Low limit for secondary (AGC) control.
    '''
    
    lowerRampRate: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The normal maximum rate the generating unit active power output can be
            lowered by control actions.
            '''
        
        })
    '''
    The normal maximum rate the generating unit active power output can
    be lowered by control actions.
    '''
    
    maxEconomicP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum high economic active power limit, that should not exceed the maximum
            operating active power limit.
            '''
        
        })
    '''
    Maximum high economic active power limit, that should not exceed the
    maximum operating active power limit.
    '''
    
    maximumAllowableSpinningReserve: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum allowable spinning reserve. Spinning reserve will never be considered
            greater than this value regardless of the current operating point.
            '''
        
        })
    '''
    Maximum allowable spinning reserve. Spinning reserve will never be
    considered greater than this value regardless of the current operating
    point.
    '''
    
    maxOperatingP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This is the maximum operating active power limit the dispatcher can enter
            for this unit.
            '''
        
        })
    '''
    This is the maximum operating active power limit the dispatcher can
    enter for this unit.
    '''
    
    minEconomicP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Low economic active power limit that shall be greater than or equal to
            the minimum operating active power limit.
            '''
        
        })
    '''
    Low economic active power limit that shall be greater than or equal
    to the minimum operating active power limit.
    '''
    
    minimumOffTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum time interval between unit shutdown and startup.
            '''
        
        })
    '''
    Minimum time interval between unit shutdown and startup.
    '''
    
    minOperatingP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This is the minimum operating active power limit the dispatcher can enter
            for this unit.
            '''
        
        })
    '''
    This is the minimum operating active power limit the dispatcher can
    enter for this unit.
    '''
    
    modelDetail: Optional[ int | Classification ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Detail level of the generator model data.
            '''
        
        })
    '''
    Detail level of the generator model data.
    '''
    
    nominalP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The nominal power of the generating unit. Used to give precise meaning
            to percentage based attributes such as the governor speed change droop
            (governorSCD attribute).
            The attribute shall be a positive value equal to or less than RotatingMachine.ratedS.
            '''
        
        })
    '''
    The nominal power of the generating unit. Used to give precise meaning
    to percentage based attributes such as the governor speed change droop
    (governorSCD attribute).
    The attribute shall be a positive value equal to or less than RotatingMachine.ratedS.
    '''
    
    raiseRampRate: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The normal maximum rate the generating unit active power output can be
            raised by control actions.
            '''
        
        })
    '''
    The normal maximum rate the generating unit active power output can
    be raised by control actions.
    '''
    
    ratedGrossMaxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit's gross rated maximum capacity (book value).
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The unit's gross rated maximum capacity (book value).
    The attribute shall be a positive value.
    '''
    
    ratedGrossMinP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The gross rated minimum generation level which the unit can safely operate
            at while delivering power to the transmission grid.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The gross rated minimum generation level which the unit can safely
    operate at while delivering power to the transmission grid.
    The attribute shall be a positive value.
    '''
    
    ratedNetMaxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The net rated maximum capacity determined by subtracting the auxiliary
            power used to operate the internal plant machinery from the rated gross
            maximum capacity.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The net rated maximum capacity determined by subtracting the auxiliary
    power used to operate the internal plant machinery from the rated gross
    maximum capacity.
    The attribute shall be a positive value.
    '''
    
    startupCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The initial startup cost incurred for each start of the GeneratingUnit.
            '''
        
        })
    '''
    The initial startup cost incurred for each start of the GeneratingUnit.
    '''
    
    startupTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time it takes to get the unit on-line, from the time that the prime mover
            mechanical power is applied.
            '''
        
        })
    '''
    Time it takes to get the unit on-line, from the time that the prime
    mover mechanical power is applied.
    '''
    
    totalEfficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The efficiency of the unit in converting the fuel into electrical energy.
            '''
        
        })
    '''
    The efficiency of the unit in converting the fuel into electrical energy.
    '''
    
    variableCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The variable cost component of production per unit of ActivePower.
            '''
        
        })
    '''
    The variable cost component of production per unit of ActivePower.
    '''
    
    GenUnitOpSchedule: Optional[GenUnitOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GenUnitOpSchedule.GeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''
        
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
    GenUnitOpCostCurves: list[GenUnitOpCostCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GenUnitOpCostCurve.GeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A generating unit may have one or more cost curves, depending upon fuel
            mixture and fuel cost.
            '''
        
        })
    '''
    A generating unit may have one or more cost curves, depending upon
    fuel mixture and fuel cost.
    '''
    
    GenUnitOpSchedule: Optional[GenUnitOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GenUnitOpSchedule.GeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''
        
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
    GrossToNetActivePowerCurves: list[GrossToNetActivePowerCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GrossToNetActivePowerCurve.GeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A generating unit may have a gross active power to net active power curve,
            describing the losses and auxiliary power requirements of the unit.
            '''
        
        })
    '''
    A generating unit may have a gross active power to net active power
    curve, describing the losses and auxiliary power requirements of the
    unit.
    '''
    
    RotatingMachine: list[RotatingMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RotatingMachine.GeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A synchronous machine may operate as a generator and as such becomes a
            member of a generating unit.
            '''
        
        })
    '''
    A synchronous machine may operate as a generator and as such becomes
    a member of a generating unit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class HydroGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover is a hydraulic turbine (e.g., Francis,
    Pelton, Kaplan).
    '''

    dropHeight: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The height water drops from the reservoir mid-point to the turbine.
            '''
        
        })
    '''
    The height water drops from the reservoir mid-point to the turbine.
    '''
    
    energyConversionCapability: Optional[ HydroEnergyConversionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Energy conversion capability for generating.
            '''
        
        })
    '''
    Energy conversion capability for generating.
    '''
    
    hydroUnitWaterCost: Optional[ float | CostPerVolume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The equivalent cost of water that drives the hydro turbine.
            '''
        
        })
    '''
    The equivalent cost of water that drives the hydro turbine.
    '''
    
    turbineType: Optional[ HydroTurbineKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of turbine.
            '''
        
        })
    '''
    Type of turbine.
    '''
    
    HydroPowerPlant: Optional[HydroPowerPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPowerPlant.HydroGeneratingUnits',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The hydro generating unit belongs to a hydro power plant.
            '''
        
        })
    '''
    The hydro generating unit belongs to a hydro power plant.
    '''
    
    PenstockLossCurve: Optional[PenstockLossCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PenstockLossCurve.HydroGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
    HydroGeneratingEfficiencyCurves: list[HydroGeneratingEfficiencyCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroGeneratingEfficiencyCurve.HydroGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A hydro generating unit has an efficiency curve.
            '''
        
        })
    '''
    A hydro generating unit has an efficiency curve.
    '''
    
    PenstockLossCurve: Optional[PenstockLossCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PenstockLossCurve.HydroGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
    TailbayLossCurve: list[TailbayLossCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TailbayLossCurve.HydroGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A hydro generating unit has a tailbay loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a tailbay loss curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class NuclearGeneratingUnit(GeneratingUnit):
    '''
    A nuclear generating unit.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SolarGeneratingUnit(GeneratingUnit):
    '''
    A solar thermal generating unit, connected to the grid by means of a rotating
    machine. This class does not represent photovoltaic (PV) generation.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ThermalGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover could be a steam turbine, combustion
    turbine, or diesel engine.
    '''

    oMCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Operating and maintenance cost for the thermal unit.
            '''
        
        })
    '''
    Operating and maintenance cost for the thermal unit.
    '''
    
    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.ThermalGeneratingUnits',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may be a member of a cogeneration plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a cogeneration plant.
    '''
    
    CombinedCyclePlant: Optional[CombinedCyclePlant] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CombinedCyclePlant.ThermalGeneratingUnits',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may be a member of a combined cycle plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a combined cycle plant.
    '''
    
    HeatInputCurve: Optional[HeatInputCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatInputCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
    HeatRateCurve: Optional[HeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''
    
    IncrementalHeatRateCurve: Optional[IncrementalHeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IncrementalHeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''
    
    ShutdownCurve: Optional[ShutdownCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShutdownCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''
        
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have a startup model.
            '''
        
        })
    '''
    A thermal generating unit may have a startup model.
    '''
    
    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
    EmmissionAccounts: list[EmissionAccount] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EmissionAccount.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have one or more emission allowance accounts.
            '''
        
        })
    '''
    A thermal generating unit may have one or more emission allowance accounts.
    '''
    
    EmissionCurves: list[EmissionCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EmissionCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have one or more emission curves.
            '''
        
        })
    '''
    A thermal generating unit may have one or more emission curves.
    '''
    
    FossilFuels: list[FossilFuel] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FossilFuel.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have one or more fossil fuels.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''
    
    FuelAllocationSchedules: list[FuelAllocationSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FuelAllocationSchedule.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have one or more fuel allocation schedules.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''
    
    HeatInputCurve: Optional[HeatInputCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatInputCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
    HeatRateCurve: Optional[HeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''
    
    IncrementalHeatRateCurve: Optional[IncrementalHeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IncrementalHeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''
    
    ShutdownCurve: Optional[ShutdownCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShutdownCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''
        
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have a startup model.
            '''
        
        })
    '''
    A thermal generating unit may have a startup model.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WindGeneratingUnit(GeneratingUnit):
    '''
    A wind driven generating unit, connected to the grid by means of a rotating
    machine. May be used to represent a single turbine or an aggregation.
    '''

    windGenUnitType: Optional[ WindGenUnitKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The kind of wind generating unit.
            '''
        
        })
    '''
    The kind of wind generating unit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class HydroPump(Equipment):
    '''
    A synchronous motor-driven pump, typically associated with a pumped storage
    plant.
    '''

    pumpDischAtMaxHead: Optional[ float | VolumeFlowRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The pumping discharge under maximum head conditions, usually at full gate.
            '''
        
        })
    '''
    The pumping discharge under maximum head conditions, usually at full
    gate.
    '''
    
    pumpDischAtMinHead: Optional[ float | VolumeFlowRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The pumping discharge under minimum head conditions, usually at full gate.
            '''
        
        })
    '''
    The pumping discharge under minimum head conditions, usually at full
    gate.
    '''
    
    pumpPowerAtMaxHead: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The pumping power under maximum head conditions, usually at full gate.
            '''
        
        })
    '''
    The pumping power under maximum head conditions, usually at full gate.
    '''
    
    pumpPowerAtMinHead: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The pumping power under minimum head conditions, usually at full gate.
            '''
        
        })
    '''
    The pumping power under minimum head conditions, usually at full gate.
    '''
    
    HydroPowerPlant: Optional[HydroPowerPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPowerPlant.HydroPumps',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The hydro pump may be a member of a pumped storage plant or a pump for
            distributing water.
            '''
        
        })
    '''
    The hydro pump may be a member of a pumped storage plant or a pump
    for distributing water.
    '''
    
    HydroPumpOpSchedule: Optional[HydroPumpOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPumpOpSchedule.HydroPump',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''
        
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
    RotatingMachine: Optional[RotatingMachine] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachine.HydroPump',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''
        
        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''
    
    HydroPumpOpSchedule: Optional[HydroPumpOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPumpOpSchedule.HydroPump',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''
        
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
    RotatingMachine: Optional[RotatingMachine] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachine.HydroPump',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''
        
        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerElectronicsUnit(Equipment):
    '''
    A generating unit or battery or aggregation that connects to the AC network
    using power electronics rather than rotating machines.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum active power limit. This is the maximum (nameplate) limit for the
            unit.
            '''
        
        })
    '''
    Maximum active power limit. This is the maximum (nameplate) limit for
    the unit.
    '''
    
    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum active power limit. This is the minimum (nameplate) limit for the
            unit.
            '''
        
        })
    '''
    Minimum active power limit. This is the minimum (nameplate) limit for
    the unit.
    '''
    
    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsConnection.PowerElectronicsUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A power electronics unit has a connection to the AC network.
            '''
        
        })
    '''
    A power electronics unit has a connection to the AC network.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BatteryUnit(PowerElectronicsUnit):
    '''
    An electrochemical energy storage device.
    '''

    batteryState: Optional[ BatteryStateKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The current state of the battery (charging, full, etc.).
            '''
        
        })
    '''
    The current state of the battery (charging, full, etc.).
    '''
    
    chargingEfficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    dischargingEfficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    idlingP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Real power consumed while idling
            '''
        
        })
    '''
    Real power consumed while idling
    '''
    
    idlingQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power consumed while idling
            &lt;&lt;conversion note&gt;&gt;
            DSS equivalent is %Idlingkvar, Percent of rated kW consumed as reactive
            power (kvar) while idling. Default =
            '''
        
        })
    '''
    Reactive power consumed while idling
    &lt;&lt;conversion note&gt;&gt;
    DSS equivalent is %Idlingkvar, Percent of rated kW consumed as reactive
    power (kvar) while idling. Default =
    '''
    
    minimumE: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Percent of rated kWh storage capacity to be held in reserve for normal
            operation. This is treated as the minimum energy discharge level unless
            there is an emergency. For emergency operation set this property lower.
            Cannot be less than zero.
            '''
        
        })
    '''
    Percent of rated kWh storage capacity to be held in reserve for normal
    operation. This is treated as the minimum energy discharge level unless
    there is an emergency. For emergency operation set this property lower.
    Cannot be less than zero.
    '''
    
    ratedE: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Full energy storage capacity of the battery. The attribute shall be a positive
            value.
            '''
        
        })
    '''
    Full energy storage capacity of the battery. The attribute shall be
    a positive value.
    '''
    
    storedE: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Amount of energy currently stored. The attribute shall be a positive value
            or zero and lower than BatteryUnit.ratedE.
            '''
        
        })
    '''
    Amount of energy currently stored. The attribute shall be a positive
    value or zero and lower than BatteryUnit.ratedE.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ProductionEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhotoVoltaicUnit(PowerElectronicsUnit):
    '''
    A photovoltaic device or an aggregation of such devices.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerElectronicsWindUnit(PowerElectronicsUnit):
    '''
    A wind generating unit that connects to the AC network with power electronics
    rather than rotating machines or an aggregation of such units.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerTank(Equipment):
    '''
    An assembly of two or more coupled windings that transform electrical power
    between voltage levels. These windings are bound on a common core and placed
    in the same tank. Transformer tank can be used to model both single-phase
    and 3-phase transformers.
    '''

    PowerTransformer: Optional[PowerTransformer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerTransformer.TransformerTanks',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Bank this transformer belongs to.
            '''
        
        })
    '''
    Bank this transformer belongs to.
    '''
    
    TransformerTankEnds: list[TransformerTankEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTankEnd.TransformerTank',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All windings of this transformer.
            '''
        
        })
    '''
    All windings of this transformer.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class HydroPowerPlant(PowerSystemResource):
    '''
    A hydro power station which can generate or pump. When generating, the
    generator turbines receive water from an upper reservoir. When pumping,
    the pumps receive their water from a lower reservoir.
    '''

    penstockType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type and configuration of hydro plant penstock(s).
            '''
        
        })
    '''
    Type and configuration of hydro plant penstock(s).
    '''
    
    surgeTankCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A code describing the type (or absence) of surge tank that is associated
            with the hydro power plant.
            '''
        
        })
    '''
    A code describing the type (or absence) of surge tank that is associated
    with the hydro power plant.
    '''
    
    dischargeTravelDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Water travel delay from tailbay to next downstream hydro power station.
            '''
        
        })
    '''
    Water travel delay from tailbay to next downstream hydro power station.
    '''
    
    genRatedP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The hydro plant's generating rating active power for rated head conditions.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The hydro plant's generating rating active power for rated head conditions.
    The attribute shall be a positive value.
    '''
    
    hydroPlantStorageType: Optional[ HydroPlantStorageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of hydro power plant water storage.
            '''
        
        })
    '''
    The type of hydro power plant water storage.
    '''
    
    plantDischargeCapacity: Optional[ float | VolumeFlowRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Total plant discharge capacity.
            '''
        
        })
    '''
    Total plant discharge capacity.
    '''
    
    plantRatedHead: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The plant's rated gross head.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The plant's rated gross head.
    The attribute shall be a positive value.
    '''
    
    pumpRatedP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The hydro plant's pumping rating active power for rated head conditions.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The hydro plant's pumping rating active power for rated head conditions.
    The attribute shall be a positive value.
    '''
    
    surgeTankCrestLevel: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The level at which the surge tank spills.
            '''
        
        })
    '''
    The level at which the surge tank spills.
    '''
    
    GenSourcePumpDischargeReservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.UpstreamFromHydroPowerPlants',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Generators are supplied water from or pumps discharge water to an upstream
            reservoir.
            '''
        
        })
    '''
    Generators are supplied water from or pumps discharge water to an upstream
    reservoir.
    '''
    
    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.HydroPowerPlants',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Generators discharge water to or pumps are supplied water from a downstream
            reservoir.
            '''
        
        })
    '''
    Generators discharge water to or pumps are supplied water from a downstream
    reservoir.
    '''
    
    HydroGeneratingUnits: list[HydroGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroGeneratingUnit.HydroPowerPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The hydro generating unit belongs to a hydro power plant.
            '''
        
        })
    '''
    The hydro generating unit belongs to a hydro power plant.
    '''
    
    HydroPumps: list[HydroPump] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroPump.HydroPowerPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The hydro pump may be a member of a pumped storage plant or a pump for
            distributing water.
            '''
        
        })
    '''
    The hydro pump may be a member of a pumped storage plant or a pump
    for distributing water.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class PowerCutZone(PowerSystemResource):
    '''
    An area or zone of the power system which is used for load shedding purposes.
    '''

    cutLevel1: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            First level (amount) of load to cut as a percentage of total zone load.
            '''
        
        })
    '''
    First level (amount) of load to cut as a percentage of total zone load.
    '''
    
    cutLevel2: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Second level (amount) of load to cut as a percentage of total zone load.
            '''
        
        })
    '''
    Second level (amount) of load to cut as a percentage of total zone
    load.
    '''
    
    EnergyConsumers: list[EnergyConsumer] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumer.PowerCutZone',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Energy consumer is assigned to the power cut zone.
            '''
        
        })
    '''
    Energy consumer is assigned to the power cut zone.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerElectronicsConnectionPhase(PowerSystemResource):
    '''
    A single phase of a power electronics connection.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow into the equipment from the network.
            '''
        
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow into the equipment from the network.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase of this energy producer component. If the energy producer is wye
            connected, the connection is from the indicated phase to the central ground
            or neutral point. If the energy producer is delta connected, the phase
            indicates an energy producer connected from the indicated phase to the
            next logical non-neutral phase.
            '''
        
        })
    '''
    Phase of this energy producer component. If the energy producer is
    wye connected, the connection is from the indicated phase to the central
    ground or neutral point. If the energy producer is delta connected,
    the phase indicates an energy producer connected from the indicated
    phase to the next logical non-neutral phase.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow into the equipment from the network.
            '''
        
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow into the equipment from the network.
    '''
    
    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsConnection.PowerElectronicsConnectionPhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power electronics connection of this power electronics connection phase.
            '''
        
        })
    '''
    Power electronics connection of this power electronics connection phase.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RegulatingControl(PowerSystemResource):
    '''
    Specifies a set of equipment that works together to control a power system
    quantity such as voltage or flow.
    Remote bus voltage control is possible by specifying the controlled terminal
    located at some place remote from the controlling equipment.
    The specified terminal shall be associated with the connectivity node of
    the controlled point. The most specific subtype of RegulatingControl shall
    be used in case such equipment participate in the control, e.g. TapChangerControl
    for tap changers.
    For flow control, load sign convention is used, i.e. positive sign means
    flow out from a TopologicalNode (bus) into the conducting equipment.
    The attribute minAllowedTargetValue and maxAllowedTargetValue are required
    in the following cases:
    - For a power generating module operated in power factor control mode to
    specify maximum and minimum power factor values;
    - Whenever it is necessary to have an off center target voltage for the
    tap changer regulator. For instance, due to long cables to off shore wind
    farms and the need to have a simpler setup at the off shore transformer
    platform, the voltage is controlled from the land at the connection point
    for the off shore wind farm. Since there usually is a voltage rise along
    the cable, there is typical and overvoltage of up 3-4 kV compared to the
    on shore station. Thus in normal operation the tap changer on the on shore
    station is operated with a target set point, which is in the lower parts
    of the dead band.
    The attributes minAllowedTargetValue and maxAllowedTargetValue are not
    related to the attribute targetDeadband and thus they are not treated as
    an alternative of the targetDeadband. They are needed due to limitations
    in the local substation controller. The attribute targetDeadband is used
    to prevent the power flow from move the tap position in circles (hunting)
    that is to be used regardless of the attributes minAllowedTargetValue and
    maxAllowedTargetValue.
    '''

    enabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The flag tells if regulation is enabled.
            '''
        
        })
    '''
    The flag tells if regulation is enabled.
    '''
    
    maxAllowedTargetValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum allowed target value (RegulatingControl.targetValue).
            '''
        
        })
    '''
    Maximum allowed target value (RegulatingControl.targetValue).
    '''
    
    minAllowedTargetValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum allowed target value (RegulatingControl.targetValue).
            '''
        
        })
    '''
    Minimum allowed target value (RegulatingControl.targetValue).
    '''
    
    targetDeadband: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This is a deadband used with discrete control to avoid excessive update
            of controls like tap changers and shunt compensator banks while regulating.
            The units of those appropriate for the mode. The attribute shall be a positive
            value or zero. If RegulatingControl.discrete is set to "false", the RegulatingControl.targetDeadband
            is to be ignored.
            Note that for instance, if the targetValue is 100 kV and the targetDeadband
            is 2 kV the range is from 99 to 101 kV.
            '''
        
        })
    '''
    This is a deadband used with discrete control to avoid excessive update
    of controls like tap changers and shunt compensator banks while regulating.
    The units of those appropriate for the mode. The attribute shall be
    a positive value or zero. If RegulatingControl.discrete is set to "false",
    the RegulatingControl.targetDeadband is to be ignored.
    Note that for instance, if the targetValue is 100 kV and the targetDeadband
    is 2 kV the range is from 99 to 101 kV.
    '''
    
    targetValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The target value specified for case input. This value can be used for the
            target value without the use of schedules. The value has the units appropriate
            to the mode attribute.
            '''
        
        })
    '''
    The target value specified for case input. This value can be used for
    the target value without the use of schedules. The value has the units
    appropriate to the mode attribute.
    '''
    
    mode: Optional[ RegulatingControlModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The regulating control mode presently available. This specification allows
            for determining the kind of regulation without need for obtaining the units
            from a schedule.
            '''
        
        })
    '''
    The regulating control mode presently available. This specification
    allows for determining the kind of regulation without need for obtaining
    the units from a schedule.
    '''
    
    monitoredPhase: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase voltage controlling this regulator, measured at regulator location.
            '''
        
        })
    '''
    Phase voltage controlling this regulator, measured at regulator location.
    '''
    
    targetValueUnitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specify the multiplier for used for the targetValue.
            '''
        
        })
    '''
    Specify the multiplier for used for the targetValue.
    '''
    
    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.RegulatingControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The terminal associated with this regulating control. The terminal is associated
            instead of a node, since the terminal could connect into either a topological
            node or a connectivity node. Sometimes it is useful to model regulation
            at a terminal of a bus bar object.
            '''
        
        })
    '''
    The terminal associated with this regulating control. The terminal
    is associated instead of a node, since the terminal could connect into
    either a topological node or a connectivity node. Sometimes it is useful
    to model regulation at a terminal of a bus bar object.
    '''
    
    RegulatingCondEq: list[RegulatingCondEq] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulatingCondEq.RegulatingControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The equipment that participates in this regulating control scheme.
            '''
        
        })
    '''
    The equipment that participates in this regulating control scheme.
    '''
    
    RegulationSchedule: list[RegulationSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulationSchedule.RegulatingControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Schedule for this regulating control.
            '''
        
        })
    '''
    Schedule for this regulating control.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class ShuntCompensatorControl(RegulatingControl):
    '''
    Distribution capacitor bank control settings.
    '''

    ShuntCompensatorInfo: Optional[ShuntCompensatorInfo] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorInfo.ShuntCompensatorControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfWiresExt'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapChangerControl(RegulatingControl):
    '''
    Describes behaviour specific to tap changers, e.g. how the voltage at the
    end of a line varies with the load level and compensation of the voltage
    drop by tap adjustment.
    '''

    lineDropCompensation: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, the line drop compensation is to be applied.
            '''
        
        })
    '''
    If true, the line drop compensation is to be applied.
    '''
    
    limitVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum allowed regulated voltage on the PT secondary, regardless of line
            drop compensation. Sometimes referred to as first-house protection.
            '''
        
        })
    '''
    Maximum allowed regulated voltage on the PT secondary, regardless of
    line drop compensation. Sometimes referred to as first-house protection.
    '''
    
    lineDropR: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Line drop compensator resistance setting for normal (forward) power flow.
            '''
        
        })
    '''
    Line drop compensator resistance setting for normal (forward) power
    flow.
    '''
    
    lineDropX: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Line drop compensator reactance setting for normal (forward) power flow.
            '''
        
        })
    '''
    Line drop compensator reactance setting for normal (forward) power
    flow.
    '''
    
    reverseLineDropR: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Line drop compensator resistance setting for reverse power flow.
            '''
        
        })
    '''
    Line drop compensator resistance setting for reverse power flow.
    '''
    
    reverseLineDropX: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Line drop compensator reactance setting for reverse power flow.
            '''
        
        })
    '''
    Line drop compensator reactance setting for reverse power flow.
    '''
    
    TapChanger: list[TapChanger] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TapChanger.TapChangerControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The tap changers that participates in this regulating tap control scheme.
            '''
        
        })
    '''
    The tap changers that participates in this regulating tap control scheme.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class RemoteUnit(PowerSystemResource):
    '''
    A remote unit can be an RTU, IED, substation control system, control centre,
    etc. The communication with the remote unit can be through various standard
    protocols (e.g. IEC 61870, IEC 61850) or non standard protocols (e.g. DNP,
    RP570, etc.). A remote unit contains remote data points that might be telemetered,
    collected or calculated. The RemoteUnit class inherits PowerSystemResource.
    The intention is to allow RemoteUnits to have Measurements. These Measurements
    can be used to model unit status as operational, out of service, unit failure,
    etc.
    '''

    remoteUnitType: Optional[ RemoteUnitType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of remote unit.
            '''
        
        })
    '''
    Type of remote unit.
    '''
    
    RemotePoints: list[RemotePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RemotePoint.RemoteUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Remote points this Remote unit contains.
            '''
        
        })
    '''
    Remote points this Remote unit contains.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'SCADA'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Reservoir(PowerSystemResource):
    '''
    A water storage facility within a hydro system, including: ponds, lakes,
    lagoons, and rivers. The storage is usually behind some type of dam.
    '''

    energyStorageRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reservoir's energy storage rating in energy for given head conditions.
            '''
        
        })
    '''
    The reservoir's energy storage rating in energy for given head conditions.
    '''
    
    riverOutletWorks: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            River outlet works for riparian right releases or other purposes.
            '''
        
        })
    '''
    River outlet works for riparian right releases or other purposes.
    '''
    
    spillwayCapacity: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The flow capacity of the spillway in cubic meters per second.
            '''
        
        })
    '''
    The flow capacity of the spillway in cubic meters per second.
    '''
    
    spillWayGateType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of spillway gate, including parameters.
            '''
        
        })
    '''
    Type of spillway gate, including parameters.
    '''
    
    activeStorageCapacity: Optional[ float | Volume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Storage volume between the full supply level and the normal minimum operating
            level.
            '''
        
        })
    '''
    Storage volume between the full supply level and the normal minimum
    operating level.
    '''
    
    fullSupplyLevel: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Full supply level, above which water will spill. This can be the spillway
            crest level or the top of closed gates.
            '''
        
        })
    '''
    Full supply level, above which water will spill. This can be the spillway
    crest level or the top of closed gates.
    '''
    
    grossCapacity: Optional[ float | Volume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Total capacity of reservoir.
            '''
        
        })
    '''
    Total capacity of reservoir.
    '''
    
    normalMinOperateLevel: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal minimum operating level below which the penstocks will draw air.
            '''
        
        })
    '''
    Normal minimum operating level below which the penstocks will draw
    air.
    '''
    
    spillTravelDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The spillway water travel delay to the next downstream reservoir.
            '''
        
        })
    '''
    The spillway water travel delay to the next downstream reservoir.
    '''
    
    spillwayCrestLength: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The length of the spillway crest.
            '''
        
        })
    '''
    The length of the spillway crest.
    '''
    
    spillwayCrestLevel: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Spillway crest level above which water will spill.
            '''
        
        })
    '''
    Spillway crest level above which water will spill.
    '''
    
    SpillsFromReservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.SpillsIntoReservoirs',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A reservoir may spill into a downstream reservoir.
            '''
        
        })
    '''
    A reservoir may spill into a downstream reservoir.
    '''
    
    TargetLevelSchedule: Optional[TargetLevelSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TargetLevelSchedule.Reservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''
        
        })
    '''
    A reservoir may have a water level target schedule.
    '''
    
    UpstreamFromHydroPowerPlants: list[HydroPowerPlant] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroPowerPlant.GenSourcePumpDischargeReservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Generators are supplied water from or pumps discharge water to an upstream
            reservoir.
            '''
        
        })
    '''
    Generators are supplied water from or pumps discharge water to an upstream
    reservoir.
    '''
    
    HydroPowerPlants: list[HydroPowerPlant] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroPowerPlant.Reservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Generators discharge water to or pumps are supplied water from a downstream
            reservoir.
            '''
        
        })
    '''
    Generators discharge water to or pumps are supplied water from a downstream
    reservoir.
    '''
    
    InflowForecasts: list[InflowForecast] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'InflowForecast.Reservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A reservoir may have a "natural" inflow forecast.
            '''
        
        })
    '''
    A reservoir may have a "natural" inflow forecast.
    '''
    
    LevelVsVolumeCurves: list[LevelVsVolumeCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LevelVsVolumeCurve.Reservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A reservoir may have a level versus volume relationship.
            '''
        
        })
    '''
    A reservoir may have a level versus volume relationship.
    '''
    
    SpillsIntoReservoirs: list[Reservoir] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Reservoir.SpillsFromReservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A reservoir may spill into a downstream reservoir.
            '''
        
        })
    '''
    A reservoir may spill into a downstream reservoir.
    '''
    
    TargetLevelSchedule: Optional[TargetLevelSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TargetLevelSchedule.Reservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''
        
        })
    '''
    A reservoir may have a water level target schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class RotatingMachinePhase(PowerSystemResource):
    '''
    Represents a single-phase motor or generator. The specifics of the RotatingMachinePhase
    (e.g. type) are determined by the associated asynchronous or synchronous
    machine along with the specific generating unit associated to the rotating
    machine.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    RotatingMachine: Optional[RotatingMachine] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachine.RotatingMachinePhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RotatingMachine: Optional[RotatingMachine] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachine.RotatingMachinePhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'WiresEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ShuntCompensatorPhase(PowerSystemResource):
    '''
    Single phase of a multi-phase shunt compensator when its attributes might
    be different per phase.
    '''

    maximumSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum number of sections that may be switched in for this phase.
            '''
        
        })
    '''
    The maximum number of sections that may be switched in for this phase.
    '''
    
    normalSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            For the capacitor phase, the normal number of sections switched in. The
            value shall be between zero and ShuntCompensatorPhase.maximumSections.
            '''
        
        })
    '''
    For the capacitor phase, the normal number of sections switched in.
    The value shall be between zero and ShuntCompensatorPhase.maximumSections.
    '''
    
    sections: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Shunt compensator sections in use. Starting value for steady state solution.
            The attribute shall be a positive value or zero. Non integer values are
            allowed to support continuous variables. The reasons for continuous value
            are to support study cases where no discrete shunt compensators has yet
            been designed, a solutions where a narrow voltage band force the sections
            to oscillate or accommodate for a continuous solution as input.
            For LinearShuntConpensator the value shall be between zero and ShuntCompensatorPhase.maximumSections.
            At value zero the shunt compensator conductance and admittance is zero.
            Linear interpolation of conductance and admittance between the previous
            and next integer section is applied in case of non-integer values.
            For NonlinearShuntCompensator-s shall only be set to one of the NonlinearShuntCompenstorPhasePoint.sectionNumber.
            There is no interpolation between NonlinearShuntCompenstorPhasePoint-s.
            '''
        
        })
    '''
    Shunt compensator sections in use. Starting value for steady state
    solution. The attribute shall be a positive value or zero. Non integer
    values are allowed to support continuous variables. The reasons for
    continuous value are to support study cases where no discrete shunt
    compensators has yet been designed, a solutions where a narrow voltage
    band force the sections to oscillate or accommodate for a continuous
    solution as input.
    For LinearShuntConpensator the value shall be between zero and ShuntCompensatorPhase.maximumSections.
    At value zero the shunt compensator conductance and admittance is zero.
    Linear interpolation of conductance and admittance between the previous
    and next integer section is applied in case of non-integer values.
    For NonlinearShuntCompensator-s shall only be set to one of the NonlinearShuntCompenstorPhasePoint.sectionNumber.
    There is no interpolation between NonlinearShuntCompenstorPhasePoint-s.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase of this shunt compensator component. If the shunt compensator is
            wye connected, the connection is from the indicated phase to the central
            ground or neutral point. If the shunt compensator is delta connected, the
            phase indicates a shunt compensator connected from the indicated phase
            to the next logical non-neutral phase.
            '''
        
        })
    '''
    Phase of this shunt compensator component. If the shunt compensator
    is wye connected, the connection is from the indicated phase to the
    central ground or neutral point. If the shunt compensator is delta
    connected, the phase indicates a shunt compensator connected from the
    indicated phase to the next logical non-neutral phase.
    '''
    
    ShuntCompensator: Optional[ShuntCompensator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensator.ShuntCompensatorPhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Shunt compensator of this shunt compensator phase.
            '''
        
        })
    '''
    Shunt compensator of this shunt compensator phase.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LinearShuntCompensatorPhase(ShuntCompensatorPhase):
    '''
    A per phase linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    bPerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Susceptance per section of the phase if shunt compensator is wye connected.
            Susceptance per section phase to phase if shunt compensator is delta connected.
            '''
        
        })
    '''
    Susceptance per section of the phase if shunt compensator is wye connected.
    Susceptance per section phase to phase if shunt compensator is delta
    connected.
    '''
    
    gPerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Conductance per section for this phase if shunt compensator is wye connected.
            Conductance per section phase to phase if shunt compensator is delta connected.
            '''
        
        })
    '''
    Conductance per section for this phase if shunt compensator is wye
    connected. Conductance per section phase to phase if shunt compensator
    is delta connected.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class NonlinearShuntCompensatorPhase(ShuntCompensatorPhase):
    '''
    A per phase non linear shunt compensator has bank or section admittance
    values that differ. The attributes g and b of the associated NonlinearShuntCompensatorPhasePoint
    describe the total conductance and admittance of a NonlinearShuntCompensatorPhasePoint
    at a section number specified by NonlinearShuntCompensatorPhasePoint.sectionNumber.
    '''

    NonlinearShuntCompensatorPhasePoints: list[NonlinearShuntCompensatorPhasePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonlinearShuntCompensatorPhasePoint.NonlinearShuntCompensatorPhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All points of the non-linear shunt compensator phase.
            '''
        
        })
    '''
    All points of the non-linear shunt compensator phase.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SwitchPhase(PowerSystemResource):
    '''
    Single phase of a multi-phase switch when its attributes might be different
    per phase.
    '''

    closed: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The attribute tells if the switch is considered closed when used as input
            to topology processing.
            '''
        
        })
    '''
    The attribute tells if the switch is considered closed when used as
    input to topology processing.
    '''
    
    normalOpen: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Used in cases when no Measurement for the status value is present. If the
            SwitchPhase has a status measurement the Discrete.normalValue is expected
            to match with this value.
            '''
        
        })
    '''
    Used in cases when no Measurement for the status value is present.
    If the SwitchPhase has a status measurement the Discrete.normalValue
    is expected to match with this value.
    '''
    
    open: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    phaseSide1: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase of this SwitchPhase on the side with terminal sequence number equal
            to 1. Should be a phase contained in that terminal�s phases attribute.
            '''
        
        })
    '''
    Phase of this SwitchPhase on the side with terminal sequence number
    equal to 1. Should be a phase contained in that terminal�s phases attribute.
    '''
    
    phaseSide2: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase of this SwitchPhase on the side with terminal sequence number equal
            to 2. Should be a phase contained in that terminal�s Terminal.phases attribute.
            '''
        
        })
    '''
    Phase of this SwitchPhase on the side with terminal sequence number
    equal to 2. Should be a phase contained in that terminal�s Terminal.phases
    attribute.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum continuous current carrying capacity in amps governed by the
            device material and construction.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The maximum continuous current carrying capacity in amps governed by
    the device material and construction.
    The attribute shall be a positive value.
    '''
    
    Switch: Optional[Switch] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Switch.SwitchPhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The switch of the switch phase.
            '''
        
        })
    '''
    The switch of the switch phase.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'WiresEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapChanger(PowerSystemResource):
    '''
    Mechanism for changing transformer winding tap positions.
    '''

    controlEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the regulation status of the equipment. True is regulating, false
            is not regulating.
            '''
        
        })
    '''
    Specifies the regulation status of the equipment. True is regulating,
    false is not regulating.
    '''
    
    highStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Highest possible tap step position, advance from neutral.
            The attribute shall be greater than lowStep.
            '''
        
        })
    '''
    Highest possible tap step position, advance from neutral.
    The attribute shall be greater than lowStep.
    '''
    
    lowStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Lowest possible tap step position, retard from neutral.
            '''
        
        })
    '''
    Lowest possible tap step position, retard from neutral.
    '''
    
    ltcFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies whether or not a TapChanger has load tap changing capabilities.
            '''
        
        })
    '''
    Specifies whether or not a TapChanger has load tap changing capabilities.
    '''
    
    neutralStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The neutral tap step position for this winding.
            The attribute shall be equal to or greater than lowStep and equal or less
            than highStep.
            It is the step position where the voltage is neutralU when the other terminals
            of the transformer are at the ratedU. If there are other tap changers on
            the transformer those taps are kept constant at their neutralStep.
            '''
        
        })
    '''
    The neutral tap step position for this winding.
    The attribute shall be equal to or greater than lowStep and equal or
    less than highStep.
    It is the step position where the voltage is neutralU when the other
    terminals of the transformer are at the ratedU. If there are other
    tap changers on the transformer those taps are kept constant at their
    neutralStep.
    '''
    
    normalStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The tap step position used in "normal" network operation for this winding.
            For a "Fixed" tap changer indicates the current physical tap setting.
            The attribute shall be equal to or greater than lowStep and equal to or
            less than highStep.
            '''
        
        })
    '''
    The tap step position used in "normal" network operation for this winding.
    For a "Fixed" tap changer indicates the current physical tap setting.
    The attribute shall be equal to or greater than lowStep and equal to
    or less than highStep.
    '''
    
    step: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Tap changer position.
            Starting step for a steady state solution. Non integer values are allowed
            to support continuous tap variables. The reasons for continuous value are
            to support study cases where no discrete tap changer has yet been designed,
            a solution where a narrow voltage band forces the tap step to oscillate
            or to accommodate for a continuous solution as input.
            The attribute shall be equal to or greater than lowStep and equal to or
            less than highStep.
            '''
        
        })
    '''
    Tap changer position.
    Starting step for a steady state solution. Non integer values are allowed
    to support continuous tap variables. The reasons for continuous value
    are to support study cases where no discrete tap changer has yet been
    designed, a solution where a narrow voltage band forces the tap step
    to oscillate or to accommodate for a continuous solution as input.
    The attribute shall be equal to or greater than lowStep and equal to
    or less than highStep.
    '''
    
    initialDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            For an LTC, the delay for initial tap changer operation (first step change).
            '''
        
        })
    '''
    For an LTC, the delay for initial tap changer operation (first step
    change).
    '''
    
    neutralU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Voltage at which the winding operates at the neutral tap setting. It is
            the voltage at the terminal of the PowerTransformerEnd associated with
            the tap changer when all tap changers on the transformer are at their neutralStep
            position. Normally neutralU of the tap changer is the same as ratedU of
            the PowerTransformerEnd, but it can differ in special cases such as when
            the tapping mechanism is separate from the winding more common on lower
            voltage transformers.
            This attribute is not relevant for PhaseTapChangerAsymmetrical, PhaseTapChangerSymmetrical
            and PhaseTapChangerLinear.
            '''
        
        })
    '''
    Voltage at which the winding operates at the neutral tap setting. It
    is the voltage at the terminal of the PowerTransformerEnd associated
    with the tap changer when all tap changers on the transformer are at
    their neutralStep position. Normally neutralU of the tap changer is
    the same as ratedU of the PowerTransformerEnd, but it can differ in
    special cases such as when the tapping mechanism is separate from the
    winding more common on lower voltage transformers.
    This attribute is not relevant for PhaseTapChangerAsymmetrical, PhaseTapChangerSymmetrical
    and PhaseTapChangerLinear.
    '''
    
    subsequentDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            For an LTC, the delay for subsequent tap changer operation (second and
            later step changes).
            '''
        
        })
    '''
    For an LTC, the delay for subsequent tap changer operation (second
    and later step changes).
    '''
    
    SvTapStep: Optional[SvTapStep] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SvTapStep.TapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The tap step state associated with the tap changer.
            '''
        
        })
    '''
    The tap step state associated with the tap changer.
    '''
    
    TapChangerControl: Optional[TapChangerControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChangerControl.TapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The regulating control scheme in which this tap changer participates.
            '''
        
        })
    '''
    The regulating control scheme in which this tap changer participates.
    '''
    
    SvTapStep: Optional[SvTapStep] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SvTapStep.TapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The tap step state associated with the tap changer.
            '''
        
        })
    '''
    The tap step state associated with the tap changer.
    '''
    
    TapSchedules: list[TapSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TapSchedule.TapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A TapChanger can have TapSchedules.
            '''
        
        })
    '''
    A TapChanger can have TapSchedules.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChanger(TapChanger):
    '''
    A transformer phase shifting tap model that controls the phase angle difference
    across the power transformer and potentially the active power flow through
    the power transformer. This phase tap model may also impact the voltage
    magnitude.
    '''

    TransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.PhaseTapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer end to which this phase tap changer belongs.
            '''
        
        })
    '''
    Transformer end to which this phase tap changer belongs.
    '''
    
    TransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.PhaseTapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Transformer end to which this phase tap changer belongs.
            '''
        
        })
    '''
    Transformer end to which this phase tap changer belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerLinear(PhaseTapChanger):
    '''
    Describes a tap changer with a linear relation between the tap step and
    the phase angle difference across the transformer. This is a mathematical
    model that is an approximation of a real phase tap changer.
    The phase angle is computed as stepPhaseShiftIncrement times the tap position.
    The voltage magnitude of both sides is the same.
    '''

    stepPhaseShiftIncrement: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase shift per step position. A positive value indicates a positive angle
            variation from the Terminal at the PowerTransformerEnd, where the TapChanger
            is located, into the transformer.
            The actual phase shift increment might be more accurately computed from
            the symmetrical or asymmetrical models or a tap step table lookup if those
            are available.
            '''
        
        })
    '''
    Phase shift per step position. A positive value indicates a positive
    angle variation from the Terminal at the PowerTransformerEnd, where
    the TapChanger is located, into the transformer.
    The actual phase shift increment might be more accurately computed
    from the symmetrical or asymmetrical models or a tap step table lookup
    if those are available.
    '''
    
    xMax: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reactance depends on the tap position according to a "u" shaped curve.
            The maximum reactance (xMax) appears at the low and high tap positions.
            Depending on the �u� curve the attribute can be either higher or lower
            than PowerTransformerEnd.x.
            '''
        
        })
    '''
    The reactance depends on the tap position according to a "u" shaped
    curve. The maximum reactance (xMax) appears at the low and high tap
    positions. Depending on the �u� curve the attribute can be either higher
    or lower than PowerTransformerEnd.x.
    '''
    
    xMin: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reactance depends on the tap position according to a "u" shaped curve.
            The minimum reactance (xMin) appears at the mid tap position. PowerTransformerEnd.x
            shall be consistent with PhaseTapChangerLinear.xMin and PhaseTapChangerNonLinear.xMin.
            In case of inconsistency, PowerTransformerEnd.x shall be used.
            '''
        
        })
    '''
    The reactance depends on the tap position according to a "u" shaped
    curve. The minimum reactance (xMin) appears at the mid tap position.
    PowerTransformerEnd.x shall be consistent with PhaseTapChangerLinear.xMin
    and PhaseTapChangerNonLinear.xMin. In case of inconsistency, PowerTransformerEnd.x
    shall be used.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerNonLinear(PhaseTapChanger):
    '''
    The non-linear phase tap changer describes the non-linear behaviour of
    a phase tap changer. This is a base class for the symmetrical and asymmetrical
    phase tap changer models. The details of these models can be found in IEC
    61970-301.
    '''

    voltageStepIncrement: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The voltage step increment on the out of phase winding (the PowerTransformerEnd
            where the TapChanger is located) specified in percent of rated voltage
            of the PowerTransformerEnd. A positive value means a positive voltage variation
            from the Terminal at the PowerTransformerEnd, where the TapChanger is located,
            into the transformer.
            When the increment is negative, the voltage decreases when the tap step
            increases.
            '''
        
        })
    '''
    The voltage step increment on the out of phase winding (the PowerTransformerEnd
    where the TapChanger is located) specified in percent of rated voltage
    of the PowerTransformerEnd. A positive value means a positive voltage
    variation from the Terminal at the PowerTransformerEnd, where the TapChanger
    is located, into the transformer.
    When the increment is negative, the voltage decreases when the tap
    step increases.
    '''
    
    xMax: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reactance depends on the tap position according to a "u" shaped curve.
            The maximum reactance (xMax) appears at the low and high tap positions.
            Depending on the �u� curve the attribute can be either higher or lower
            than PowerTransformerEnd.x.
            '''
        
        })
    '''
    The reactance depends on the tap position according to a "u" shaped
    curve. The maximum reactance (xMax) appears at the low and high tap
    positions. Depending on the �u� curve the attribute can be either higher
    or lower than PowerTransformerEnd.x.
    '''
    
    xMin: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reactance depend on the tap position according to a "u" shaped curve.
            The minimum reactance (xMin) appear at the mid tap position. PowerTransformerEnd.x
            shall be consistent with PhaseTapChangerLinear.xMin and PhaseTapChangerNonLinear.xMin.
            In case of inconsistency, PowerTransformerEnd.x shall be used.
            '''
        
        })
    '''
    The reactance depend on the tap position according to a "u" shaped
    curve. The minimum reactance (xMin) appear at the mid tap position.
    PowerTransformerEnd.x shall be consistent with PhaseTapChangerLinear.xMin
    and PhaseTapChangerNonLinear.xMin. In case of inconsistency, PowerTransformerEnd.x
    shall be used.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerAsymmetrical(PhaseTapChangerNonLinear):
    '''
    Describes the tap model for an asymmetrical phase shifting transformer
    in which the difference voltage vector adds to the in-phase winding. The
    out-of-phase winding is the transformer end where the tap changer is located.
    The angle between the in-phase and out-of-phase windings is named the winding
    connection angle. The phase shift depends on both the difference voltage
    magnitude and the winding connection angle.
    '''

    windingConnectionAngle: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The phase angle between the in-phase winding and the out-of -phase winding
            used for creating phase shift. The out-of-phase winding produces what is
            known as the difference voltage. Setting this angle to 90 degrees is not
            the same as a symmetrical transformer. The attribute can only be multiples
            of 30 degrees. The allowed range is -150 degrees to 150 degrees excluding
            0.
            '''
        
        })
    '''
    The phase angle between the in-phase winding and the out-of -phase
    winding used for creating phase shift. The out-of-phase winding produces
    what is known as the difference voltage. Setting this angle to 90 degrees
    is not the same as a symmetrical transformer. The attribute can only
    be multiples of 30 degrees. The allowed range is -150 degrees to 150
    degrees excluding 0.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerSymmetrical(PhaseTapChangerNonLinear):
    '''
    Describes a symmetrical phase shifting transformer tap model in which the
    voltage magnitude of both sides is the same. The difference voltage magnitude
    is the base in an equal-sided triangle where the sides corresponds to the
    primary and secondary voltages. The phase angle difference corresponds
    to the top angle and can be expressed as twice the arctangent of half the
    total difference voltage.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerTabular(PhaseTapChanger):
    '''
    Describes a tap changer with a table defining the relation between the
    tap step and the phase angle difference across the transformer.
    '''

    PhaseTapChangerTable: Optional[PhaseTapChangerTable] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhaseTapChangerTable.PhaseTapChangerTabular',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The phase tap changer table for this phase tap changer.
            '''
        
        })
    '''
    The phase tap changer table for this phase tap changer.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RatioTapChanger(TapChanger):
    '''
    A tap changer that changes the voltage ratio impacting the voltage magnitude
    but not the phase angle across the transformer.
    Angle sign convention (general): Positive value indicates a positive phase
    shift from the winding where the tap is located to the other winding (for
    a two-winding transformer).
    '''

    stepVoltageIncrement: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Tap step increment, in per cent of rated voltage of the power transformer
            end, per step position.
            When the increment is negative, the voltage decreases when the tap step
            increases.
            '''
        
        })
    '''
    Tap step increment, in per cent of rated voltage of the power transformer
    end, per step position.
    When the increment is negative, the voltage decreases when the tap
    step increases.
    '''
    
    tculControlMode: Optional[ TransformerControlMode ] = field(
        default=None,
        metadata={
        'type': 'enumeration deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the regulation control mode (voltage or reactive) of the RatioTapChanger.
            '''
        
        })
    '''
    Specifies the regulation control mode (voltage or reactive) of the
    RatioTapChanger.
    '''
    
    RatioTapChangerTable: Optional[RatioTapChangerTable] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RatioTapChangerTable.RatioTapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The tap ratio table for this ratio tap changer.
            '''
        
        })
    '''
    The tap ratio table for this ratio tap changer.
    '''
    
    TransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.RatioTapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer end to which this ratio tap changer belongs.
            '''
        
        })
    '''
    Transformer end to which this ratio tap changer belongs.
    '''
    
    TransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.RatioTapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Transformer end to which this ratio tap changer belongs.
            '''
        
        })
    '''
    Transformer end to which this ratio tap changer belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class VoltageControlZone(PowerSystemResource):
    '''
    An area of the power system network which is defined for secondary voltage
    control purposes. A voltage control zone consists of a collection of substations
    with a designated bus bar section whose voltage will be controlled.
    '''

    BusbarSection: Optional[BusbarSection] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BusbarSection.VoltageControlZone',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''
        
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''
    
    RegulationSchedule: Optional[RegulationSchedule] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegulationSchedule.VoltageControlZones',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A VoltageControlZone may have a voltage regulation schedule.
            '''
        
        })
    '''
    A VoltageControlZone may have a voltage regulation schedule.
    '''
    
    BusbarSection: Optional[BusbarSection] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BusbarSection.VoltageControlZone',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''
        
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WireSegmentPhase(PowerSystemResource):
    '''
    Represents a single wire of an alternating current wire segment.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number designation for this wire segment phase. Each wire segment phase
            within a wire segment should have a unique sequence number.
            '''
        
        })
    '''
    Number designation for this wire segment phase. Each wire segment phase
    within a wire segment should have a unique sequence number.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The phase connection of the wire at both ends.
            '''
        
        })
    '''
    The phase connection of the wire at both ends.
    '''
    
    WireSegment: Optional[WireSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSegment.WireSegmentPhases',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The wire segment to which the phase belongs.
            '''
        
        })
    '''
    The wire segment to which the phase belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RatioTapChangerTable(IdentifiedObject):
    '''
    Describes a curve for how the voltage magnitude and impedance varies with
    the tap step.
    '''

    RatioTapChanger: list[RatioTapChanger] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RatioTapChanger.RatioTapChangerTable',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The ratio tap changer of this tap ratio table.
            '''
        
        })
    '''
    The ratio tap changer of this tap ratio table.
    '''
    
    RatioTapChangerTablePoint: list[RatioTapChangerTablePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RatioTapChangerTablePoint.RatioTapChangerTable',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Points of this table.
            '''
        
        })
    '''
    Points of this table.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RemotePoint(IdentifiedObject):
    '''
    For an RTU, remote points correspond to telemetered values or control outputs.
    Other units (e.g. control centres) usually also contain calculated values.
    '''

    RemoteUnit: Optional[RemoteUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RemoteUnit.RemotePoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Remote unit this point belongs to.
            '''
        
        })
    '''
    Remote unit this point belongs to.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'SCADA'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RemoteControl(RemotePoint):
    '''
    Remote controls are outputs that are sent by the remote unit to actuators
    in the process.
    '''

    actuatorMaximum: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum set point value accepted by the remote control point.
            '''
        
        })
    '''
    The maximum set point value accepted by the remote control point.
    '''
    
    actuatorMinimum: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum set point value accepted by the remote control point.
            '''
        
        })
    '''
    The minimum set point value accepted by the remote control point.
    '''
    
    remoteControlled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Set to true if the actuator is remotely controlled.
            '''
        
        })
    '''
    Set to true if the actuator is remotely controlled.
    '''
    
    Control: Optional[Control] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Control.RemoteControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Control for the RemoteControl point.
            '''
        
        })
    '''
    The Control for the RemoteControl point.
    '''
    
    Control: Optional[Control] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Control.RemoteControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The Control for the RemoteControl point.
            '''
        
        })
    '''
    The Control for the RemoteControl point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'SCADA'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RemoteSource(RemotePoint):
    '''
    Remote sources are state variables that are telemetered or calculated within
    the remote unit.
    '''

    deadband: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The smallest change in value to be reported.
            '''
        
        })
    '''
    The smallest change in value to be reported.
    '''
    
    sensorMaximum: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum value the telemetry item can return.
            '''
        
        })
    '''
    The maximum value the telemetry item can return.
    '''
    
    sensorMinimum: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum value the telemetry item can return.
            '''
        
        })
    '''
    The minimum value the telemetry item can return.
    '''
    
    scanInterval: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The time interval between scans.
            '''
        
        })
    '''
    The time interval between scans.
    '''
    
    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.RemoteSource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Link to the physical telemetered point associated with this measurement.
            '''
        
        })
    '''
    Link to the physical telemetered point associated with this measurement.
    '''
    
    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.RemoteSource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Link to the physical telemetered point associated with this measurement.
            '''
        
        })
    '''
    Link to the physical telemetered point associated with this measurement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'SCADA'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ReportingGroup(IdentifiedObject):
    '''
    A reporting group is used for various ad-hoc groupings used for reporting.
    '''

    ReportingSuperGroup: Optional[ReportingSuperGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReportingSuperGroup.ReportingGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reporting super group to which this reporting group belongs.
            '''
        
        })
    '''
    Reporting super group to which this reporting group belongs.
    '''
    
    BusNameMarker: list[BusNameMarker] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BusNameMarker.ReportingGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The bus name markers that belong to this reporting group.
            '''
        
        })
    '''
    The bus name markers that belong to this reporting group.
    '''
    
    TopologicalNode: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.ReportingGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The topological nodes that belong to the reporting group.
            '''
        
        })
    '''
    The topological nodes that belong to the reporting group.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ReportingSuperGroup(IdentifiedObject):
    '''
    A reporting super group, groups reporting groups for a higher level report.
    '''

    ReportingGroup: list[ReportingGroup] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ReportingGroup.ReportingSuperGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Reporting groups that are grouped under this super group.
            '''
        
        })
    '''
    Reporting groups that are grouped under this super group.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Season(IdentifiedObject):
    '''
    A specified time period of the year.
    '''

    endDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date season ends.
            '''
        
        })
    '''
    Date season ends.
    '''
    
    startDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date season starts.
            '''
        
        })
    '''
    Date season starts.
    '''
    
    SeasonDayTypeSchedules: list[SeasonDayTypeSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SeasonDayTypeSchedule.Season',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Schedules that use this Season.
            '''
        
        })
    '''
    Schedules that use this Season.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ShuntCompensatorAction(IdentifiedObject):
    '''
    '''

    ShuntCompensator: Optional[ShuntCompensator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensator.ShuntCompensatorAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The shunt compensator that the shunt compensator action is performed on
            '''
        
        })
    '''
    The shunt compensator that the shunt compensator action is performed
    on
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartupModel(IdentifiedObject):
    '''
    Unit start up characteristics depending on how long the unit has been off
    line.
    '''

    startupDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The date and time of the most recent generating unit startup.
            '''
        
        })
    '''
    The date and time of the most recent generating unit startup.
    '''
    
    startupPriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Startup priority within control area where lower numbers indicate higher
            priorities. More than one unit in an area may be assigned the same priority.
            '''
        
        })
    '''
    Startup priority within control area where lower numbers indicate higher
    priorities. More than one unit in an area may be assigned the same
    priority.
    '''
    
    fixedMaintCost: Optional[ float | CostRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fixed maintenance cost.
            '''
        
        })
    '''
    Fixed maintenance cost.
    '''
    
    hotStandbyHeat: Optional[ float | HeatRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The amount of heat input per time unit required for hot standby operation.
            '''
        
        })
    '''
    The amount of heat input per time unit required for hot standby operation.
    '''
    
    incrementalMaintCost: Optional[ float | CostPerEnergyUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Incremental maintenance cost.
            '''
        
        })
    '''
    Incremental maintenance cost.
    '''
    
    minimumDownTime: Optional[ float | Hours ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum number of hours the unit must be down before restart.
            '''
        
        })
    '''
    The minimum number of hours the unit must be down before restart.
    '''
    
    minimumRunTime: Optional[ float | Hours ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum number of hours the unit must be operating before being allowed
            to shut down.
            '''
        
        })
    '''
    The minimum number of hours the unit must be operating before being
    allowed to shut down.
    '''
    
    riskFactorCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The opportunity cost associated with the return in monetary unit. This
            represents the restart's "share" of the unit depreciation and risk of an
            event which would damage the unit.
            '''
        
        })
    '''
    The opportunity cost associated with the return in monetary unit. This
    represents the restart's "share" of the unit depreciation and risk
    of an event which would damage the unit.
    '''
    
    startupCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Total miscellaneous start up costs.
            '''
        
        })
    '''
    Total miscellaneous start up costs.
    '''
    
    stbyAuxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit's auxiliary active power consumption to maintain standby mode.
            '''
        
        })
    '''
    The unit's auxiliary active power consumption to maintain standby mode.
    '''
    
    StartIgnFuelCurve: Optional[StartIgnFuelCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartIgnFuelCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''
    
    StartMainFuelCurve: Optional[StartMainFuelCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartMainFuelCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''
    
    StartRampCurve: Optional[StartRampCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartRampCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have a startup model.
            '''
        
        })
    '''
    A thermal generating unit may have a startup model.
    '''
    
    StartIgnFuelCurve: Optional[StartIgnFuelCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartIgnFuelCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''
    
    StartMainFuelCurve: Optional[StartMainFuelCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartMainFuelCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''
    
    StartRampCurve: Optional[StartRampCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartRampCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have a startup model.
            '''
        
        })
    '''
    A thermal generating unit may have a startup model.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StaticVarCompensatorDynamics(IdentifiedObject):
    '''
    Static var compensator whose behaviour is described by reference to a standard
    model <font color="#0f0f0f">or by definition of a user-defined model.</font>
    '''

    StaticVarCompensator: Optional[StaticVarCompensator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StaticVarCompensator.StaticVarCompensatorDynamics',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Static Var Compensator to which Static Var Compensator dynamics model applies.
            '''
        
        })
    '''
    Static Var Compensator to which Static Var Compensator dynamics model
    applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StaticVarCompensatorDynamics'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class SubGeographicalRegion(IdentifiedObject):
    '''
    A subset of a geographical region of a power system network model.
    '''

    Region: Optional[GeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeographicalRegion.Regions',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The geographical region which this sub-geographical region is within.
            '''
        
        })
    '''
    The geographical region which this sub-geographical region is within.
    '''
    
    DCLines: list[DCLine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCLine.Region',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The DC lines in this sub-geographical region.
            '''
        
        })
    '''
    The DC lines in this sub-geographical region.
    '''
    
    Lines: list[Line] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Line.Region',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The lines within the sub-geographical region.
            '''
        
        })
    '''
    The lines within the sub-geographical region.
    '''
    
    Substations: list[Substation] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Substation.Region',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The substations in this sub-geographical region.
            '''
        
        })
    '''
    The substations in this sub-geographical region.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SwitchAction(IdentifiedObject):
    '''
    Action on switch as a switching step.
    '''

    OperatedSwitch: Optional[Switch] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Switch.SwitchAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Switch that is the object of this switch action.
            '''
        
        })
    '''
    Switch that is the object of this switch action.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SynchronousMachineDynamics(IdentifiedObject):
    '''
    Synchronous machine whose behaviour is described by reference to a standard
    model expressed in one of the following forms:
    - simplified (or classical), where a group of generators or motors is not
    modelled in detail;
    - detailed, in equivalent circuit form;
    - detailed, in time constant reactance form; or
    <font color="#0f0f0f">- by definition of a user-defined model.</font>
    <font color="#0f0f0f">It is a common practice to represent small generators
    by a negative load rather than by a dynamic generator model when performing
    dynamics simulations. In this case, a SynchronousMachine in the static
    model is not represented by anything in the dynamics model, instead it
    is treated as an ordinary load.</font>
    <font color="#0f0f0f">Parameter details:</font>
    <ol>
    <li><font color="#0f0f0f">Synchronous machine parameters such as <i>Xl,
    Xd, Xp</i> etc. are actually used as inductances in the models,</font>
    but are commonly referred to as reactances since, at nominal frequency,
    the PU values are the same. However, some references use the symbol <i>L</i>
    instead of <i>X</i>.</li>
    </ol>
    '''

    SynchronousMachine: Optional[SynchronousMachine] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SynchronousMachine.SynchronousMachineDynamics',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Synchronous machine to which synchronous machine dynamics model applies.
            '''
        
        })
    '''
    Synchronous machine to which synchronous machine dynamics model applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'SynchronousMachineDynamics'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class TopologicalIsland(IdentifiedObject):
    '''
    An electrically connected subset of the network. Topological islands can
    change as the current network state changes, e.g. due to:
    - disconnect switches or breakers changing state in a SCADA/EMS.
    - manual creation, change or deletion of topological nodes in a planning
    tool.
    Only energised TopologicalNode-s shall be part of the topological island.
    '''

    AngleRefTopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.AngleRefTopologicalIsland',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The angle reference for the island. Normally there is one TopologicalNode
            that is selected as the angle reference for each island. Other reference
            schemes exist, so the association is typically optional.
            '''
        
        })
    '''
    The angle reference for the island. Normally there is one TopologicalNode
    that is selected as the angle reference for each island. Other reference
    schemes exist, so the association is typically optional.
    '''
    
    AngleRefTopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.AngleRefTopologicalIsland',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The angle reference for the island. Normally there is one TopologicalNode
            that is selected as the angle reference for each island. Other reference
            schemes exist, so the association is typically optional.
            '''
        
        })
    '''
    The angle reference for the island. Normally there is one TopologicalNode
    that is selected as the angle reference for each island. Other reference
    schemes exist, so the association is typically optional.
    '''
    
    TopologicalNodes: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.TopologicalIsland',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A topological node belongs to a topological island.
            '''
        
        })
    '''
    A topological node belongs to a topological island.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Topology'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class TopologicalNode(IdentifiedObject):
    '''
    For a detailed substation model a topological node is a set of connectivity
    nodes that, in the current network state, are connected together through
    any type of closed switches, including jumpers. Topological nodes change
    as the current network state changes (i.e., switches, breakers, etc. change
    state).
    For a planning model, switch statuses are not used to form topological
    nodes. Instead they are manually created or deleted in a model builder
    tool. Topological nodes maintained this way are also called "busses".
    '''

    pInjection: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The active power injected into the bus at this location in addition to
            injections from equipment. Positive sign means injection into the TopologicalNode
            (bus).
            Starting value for a steady state solution.
            '''
        
        })
    '''
    The active power injected into the bus at this location in addition
    to injections from equipment. Positive sign means injection into the
    TopologicalNode (bus).
    Starting value for a steady state solution.
    '''
    
    qInjection: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reactive power injected into the bus at this location in addition to
            injections from equipment. Positive sign means injection into the TopologicalNode
            (bus).
            Starting value for a steady state solution.
            '''
        
        })
    '''
    The reactive power injected into the bus at this location in addition
    to injections from equipment. Positive sign means injection into the
    TopologicalNode (bus).
    Starting value for a steady state solution.
    '''
    
    AngleRefTopologicalIsland: Optional[TopologicalIsland] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalIsland.AngleRefTopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The island for which the node is an angle reference. Normally there is
            one angle reference node for each island.
            '''
        
        })
    '''
    The island for which the node is an angle reference. Normally there
    is one angle reference node for each island.
    '''
    
    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The base voltage of the topological node.
            '''
        
        })
    '''
    The base voltage of the topological node.
    '''
    
    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNodeContainer.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The connectivity node container to which the topological node belongs.
            '''
        
        })
    '''
    The connectivity node container to which the topological node belongs.
    '''
    
    ReportingGroup: Optional[ReportingGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReportingGroup.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reporting group to which the topological node belongs.
            '''
        
        })
    '''
    The reporting group to which the topological node belongs.
    '''
    
    TopologicalIsland: Optional[TopologicalIsland] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalIsland.TopologicalNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A topological node belongs to a topological island.
            '''
        
        })
    '''
    A topological node belongs to a topological island.
    '''
    
    BusNameMarker: list[BusNameMarker] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BusNameMarker.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            BusnameMarkers that may refer to a pre defined TopologicalNode.
            '''
        
        })
    '''
    BusnameMarkers that may refer to a pre defined TopologicalNode.
    '''
    
    ConnectivityNodes: list[ConnectivityNode] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConnectivityNode.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The connectivity nodes combine together to form this topological node.
            May depend on the current state of switches in the network.
            '''
        
        })
    '''
    The connectivity nodes combine together to form this topological node.
    May depend on the current state of switches in the network.
    '''
    
    SvInjection: list[SvInjection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvInjection.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The injection flows state variables associated with the topological node.
            '''
        
        })
    '''
    The injection flows state variables associated with the topological
    node.
    '''
    
    SvVoltage: list[SvVoltage] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvVoltage.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The state voltage associated with the topological node.
            '''
        
        })
    '''
    The state voltage associated with the topological node.
    '''
    
    Terminal: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The terminals associated with the topological node. This can be used as
            an alternative to the connectivity node path to terminal, thus making it
            unnecessary to model connectivity nodes in some cases. Note that if connectivity
            nodes are in the model, this association would probably not be used as
            an input specification.
            '''
        
        })
    '''
    The terminals associated with the topological node. This can be used
    as an alternative to the connectivity node path to terminal, thus making
    it unnecessary to model connectivity nodes in some cases. Note that
    if connectivity nodes are in the model, this association would probably
    not be used as an input specification.
    '''
    
    AngleRefTopologicalIsland: Optional[TopologicalIsland] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalIsland.AngleRefTopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The island for which the node is an angle reference. Normally there is
            one angle reference node for each island.
            '''
        
        })
    '''
    The island for which the node is an angle reference. Normally there
    is one angle reference node for each island.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Topology'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerCoreAdmittance(IdentifiedObject):
    '''
    The transformer core admittance. Used to specify the core admittance of
    a transformer in a manner that can be shared among power transformers.
    '''

    b: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Magnetizing branch susceptance (B mag). The value can be positive or negative.
            '''
        
        })
    '''
    Magnetizing branch susceptance (B mag). The value can be positive or
    negative.
    '''
    
    b0: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence magnetizing branch susceptance.
            '''
        
        })
    '''
    Zero sequence magnetizing branch susceptance.
    '''
    
    g: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Magnetizing branch conductance (G mag).
            '''
        
        })
    '''
    Magnetizing branch conductance (G mag).
    '''
    
    g0: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence magnetizing branch conductance.
            '''
        
        })
    '''
    Zero sequence magnetizing branch conductance.
    '''
    
    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.CoreAdmittance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer end datasheet used to calculate this core admittance.
            '''
        
        })
    '''
    Transformer end datasheet used to calculate this core admittance.
    '''
    
    TransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.CoreAdmittance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All transformer ends having this core admittance.
            '''
        
        })
    '''
    All transformer ends having this core admittance.
    '''
    
    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.CoreAdmittance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Transformer end datasheet used to calculate this core admittance.
            '''
        
        })
    '''
    Transformer end datasheet used to calculate this core admittance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerEnd(IdentifiedObject):
    '''
    A conducting connection point of a power transformer. It corresponds to
    a physical transformer winding terminal. In earlier CIM versions, the TransformerWinding
    class served a similar purpose, but this class is more flexible because
    it associates to terminal but is not a specialization of ConductingEquipment.
    '''

    endNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number for this transformer end, corresponding to the end's order in the
            power transformer vector group or phase angle clock number. Highest voltage
            winding should be 1. Each end within a power transformer should have a
            unique subsequent end number. Note the transformer end number need not
            match the terminal sequence number.
            '''
        
        })
    '''
    Number for this transformer end, corresponding to the end's order in
    the power transformer vector group or phase angle clock number. Highest
    voltage winding should be 1. Each end within a power transformer should
    have a unique subsequent end number. Note the transformer end number
    need not match the terminal sequence number.
    '''
    
    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (for Yn and Zn connections) True if the neutral is solidly grounded.
            '''
        
        })
    '''
    (for Yn and Zn connections) True if the neutral is solidly grounded.
    '''
    
    bmagSat: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Core shunt magnetizing susceptance in the saturation region.
            '''
        
        })
    '''
    Core shunt magnetizing susceptance in the saturation region.
    '''
    
    magBaseU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reference voltage at which the magnetizing saturation measurements
            were made.
            '''
        
        })
    '''
    The reference voltage at which the magnetizing saturation measurements
    were made.
    '''
    
    magSatFlux: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Core magnetizing saturation curve knee flux level.
            '''
        
        })
    '''
    Core magnetizing saturation curve knee flux level.
    '''
    
    rground: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (for Yn and Zn connections) Resistance part of neutral impedance where
            'grounded' is true.
            '''
        
        })
    '''
    (for Yn and Zn connections) Resistance part of neutral impedance where
    'grounded' is true.
    '''
    
    xground: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (for Yn and Zn connections) Reactive part of neutral impedance where 'grounded'
            is true.
            '''
        
        })
    '''
    (for Yn and Zn connections) Reactive part of neutral impedance where
    'grounded' is true.
    '''
    
    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.TransformerEnds',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Base voltage of the transformer end. This is essential for PU calculation.
            '''
        
        })
    '''
    Base voltage of the transformer end. This is essential for PU calculation.
    '''
    
    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Core admittance of this transformer end, representing magnetising current
            and core losses. The full values of the transformer should be supplied
            for one transformer end only.
            '''
        
        })
    '''
    Core admittance of this transformer end, representing magnetising current
    and core losses. The full values of the transformer should be supplied
    for one transformer end only.
    '''
    
    PhaseTapChanger: Optional[PhaseTapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhaseTapChanger.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase tap changer associated with this transformer end.
            '''
        
        })
    '''
    Phase tap changer associated with this transformer end.
    '''
    
    RatioTapChanger: Optional[RatioTapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RatioTapChanger.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Ratio tap changer associated with this transformer end.
            '''
        
        })
    '''
    Ratio tap changer associated with this transformer end.
    '''
    
    StarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (accurate for 2- or 3-winding transformers only) Pi-model impedances of
            this transformer end. By convention, for a two winding transformer, the
            full values of the transformer should be entered on the high voltage end
            (endNumber=1).
            '''
        
        })
    '''
    (accurate for 2- or 3-winding transformers only) Pi-model impedances
    of this transformer end. By convention, for a two winding transformer,
    the full values of the transformer should be entered on the high voltage
    end (endNumber=1).
    '''
    
    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Terminal of the power transformer to which this transformer end belongs.
            '''
        
        })
    '''
    Terminal of the power transformer to which this transformer end belongs.
    '''
    
    PhaseTapChanger: Optional[PhaseTapChanger] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhaseTapChanger.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Phase tap changer associated with this transformer end.
            '''
        
        })
    '''
    Phase tap changer associated with this transformer end.
    '''
    
    RatioTapChanger: Optional[RatioTapChanger] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RatioTapChanger.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Ratio tap changer associated with this transformer end.
            '''
        
        })
    '''
    Ratio tap changer associated with this transformer end.
    '''
    
    FromMeshImpedance: list[TransformerMeshImpedance] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerMeshImpedance.FromTransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All mesh impedances between this 'to' and other 'from' transformer ends.
            '''
        
        })
    '''
    All mesh impedances between this 'to' and other 'from' transformer
    ends.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerTransformerEnd(TransformerEnd):
    '''
    A PowerTransformerEnd is associated with each Terminal of a PowerTransformer.
    The impedance values r, r0, x, and x0 of a PowerTransformerEnd represents
    a star equivalent as follows.
    1) for a two Terminal PowerTransformer the high voltage (TransformerEnd.endNumber=1)
    PowerTransformerEnd has non zero values on r, r0, x, and x0 while the low
    voltage (TransformerEnd.endNumber=2) PowerTransformerEnd has zero values
    for r, r0, x, and x0. Parameters are always provided, even if the PowerTransformerEnds
    have the same rated voltage. In this case, the parameters are provided
    at the PowerTransformerEnd which has TransformerEnd.endNumber equal to
    1.
    2) for a three Terminal PowerTransformer the three PowerTransformerEnds
    represent a star equivalent with each leg in the star represented by r,
    r0, x, and x0 values.
    3) For a three Terminal transformer each PowerTransformerEnd shall have
    g, g0, b and b0 values corresponding to the no load losses distributed
    on the three PowerTransformerEnds. The total no load loss shunt impedances
    may also be placed at one of the PowerTransformerEnds, preferably the end
    numbered 1, having the shunt values on end 1. This is the preferred way.
    4) for a PowerTransformer with more than three Terminals the PowerTransformerEnd
    impedance values cannot be used. Instead use the TransformerMeshImpedance
    or split the transformer into multiple PowerTransformers.
    Each PowerTransformerEnd must be contained by a PowerTransformer. Because
    a PowerTransformerEnd (or any other object) can not be contained by more
    than one parent, a PowerTransformerEnd can not have an association to an
    EquipmentContainer (Substation, VoltageLevel, etc).
    '''

    phaseAngleClock: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Terminal voltage phase angle displacement where 360 degrees are represented
            with clock hours. The valid values are 0 to 11. For example, for the secondary
            side end of a transformer with vector group code of 'Dyn11', specify the
            connection kind as wye with neutral and specify the phase angle of the
            clock as 11. The clock value of the transformer end number specified as
            1, is assumed to be zero. Note the transformer end number is not assumed
            to be the same as the terminal sequence number.
            '''
        
        })
    '''
    Terminal voltage phase angle displacement where 360 degrees are represented
    with clock hours. The valid values are 0 to 11. For example, for the
    secondary side end of a transformer with vector group code of 'Dyn11',
    specify the connection kind as wye with neutral and specify the phase
    angle of the clock as 11. The clock value of the transformer end number
    specified as 1, is assumed to be zero. Note the transformer end number
    is not assumed to be the same as the terminal sequence number.
    '''
    
    b: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Magnetizing branch susceptance (B mag). The value can be positive or negative.
            '''
        
        })
    '''
    Magnetizing branch susceptance (B mag). The value can be positive or
    negative.
    '''
    
    b0: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence magnetizing branch susceptance.
            '''
        
        })
    '''
    Zero sequence magnetizing branch susceptance.
    '''
    
    connectionKind: Optional[ WindingConnection ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of connection.
            '''
        
        })
    '''
    Kind of connection.
    '''
    
    g: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Magnetizing branch conductance.
            '''
        
        })
    '''
    Magnetizing branch conductance.
    '''
    
    g0: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence magnetizing branch conductance (star-model).
            '''
        
        })
    '''
    Zero sequence magnetizing branch conductance (star-model).
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Resistance (star-model) of the transformer end.
            The attribute shall be equal to or greater than zero for non-equivalent
            transformers.
            '''
        
        })
    '''
    Resistance (star-model) of the transformer end.
    The attribute shall be equal to or greater than zero for non-equivalent
    transformers.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence series resistance (star-model) of the transformer end.
            '''
        
        })
    '''
    Zero sequence series resistance (star-model) of the transformer end.
    '''
    
    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal apparent power rating.
            The attribute shall be a positive value. For a two-winding transformer
            the values for the high and low voltage sides shall be identical.
            '''
        
        })
    '''
    Normal apparent power rating.
    The attribute shall be a positive value. For a two-winding transformer
    the values for the high and low voltage sides shall be identical.
    '''
    
    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage: phase-phase for three-phase windings, and either phase-phase
            or phase-neutral for single-phase windings.
            A high voltage side, as given by TransformerEnd.endNumber, shall have a
            ratedU that is greater than or equal to ratedU for the lower voltage sides.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    Rated voltage: phase-phase for three-phase windings, and either phase-phase
    or phase-neutral for single-phase windings.
    A high voltage side, as given by TransformerEnd.endNumber, shall have
    a ratedU that is greater than or equal to ratedU for the lower voltage
    sides.
    The attribute shall be a positive value.
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence series reactance (star-model) of the transformer end.
            '''
        
        })
    '''
    Positive sequence series reactance (star-model) of the transformer
    end.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence series reactance of the transformer end.
            '''
        
        })
    '''
    Zero sequence series reactance of the transformer end.
    '''
    
    PowerTransformer: Optional[PowerTransformer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerTransformer.PowerTransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The power transformer of this power transformer end.
            '''
        
        })
    '''
    The power transformer of this power transformer end.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerTankEnd(TransformerEnd):
    '''
    Transformer tank end represents an individual winding for unbalanced models
    or for transformer tanks connected into a bank (and bank is modelled with
    the PowerTransformer).
    '''

    phases: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Describes the phases carried by a conducting equipment.
            '''
        
        })
    '''
    Describes the phases carried by a conducting equipment.
    '''
    
    TransformerTank: Optional[TransformerTank] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerTank.TransformerTankEnds',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer this winding belongs to.
            '''
        
        })
    '''
    Transformer this winding belongs to.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerMeshImpedance(IdentifiedObject):
    '''
    Transformer mesh impedance (Delta-model) between transformer ends.
    The typical case is that this class describes the impedance between two
    transformer ends pair-wise, i.e. the cardinalities at both transformer
    end associations are 1. However, in cases where two or more transformer
    ends are modelled the cardinalities are larger than 1.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Resistance between the 'from' and the 'to' end, seen from the 'from' end.
            '''
        
        })
    '''
    Resistance between the 'from' and the 'to' end, seen from the 'from'
    end.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero-sequence resistance between the 'from' and the 'to' end, seen from
            the 'from' end.
            '''
        
        })
    '''
    Zero-sequence resistance between the 'from' and the 'to' end, seen
    from the 'from' end.
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reactance between the 'from' and the 'to' end, seen from the 'from' end.
            '''
        
        })
    '''
    Reactance between the 'from' and the 'to' end, seen from the 'from'
    end.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero-sequence reactance between the 'from' and the 'to' end, seen from
            the 'from' end.
            '''
        
        })
    '''
    Zero-sequence reactance between the 'from' and the 'to' end, seen from
    the 'from' end.
    '''
    
    FromTransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.FromMeshImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            From end this mesh impedance is connected to. It determines the voltage
            reference.
            '''
        
        })
    '''
    From end this mesh impedance is connected to. It determines the voltage
    reference.
    '''
    
    FromTransformerEndInfo: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.FromMeshImpedances',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            'from' transformer end datasheet this mesh impedance is calculated from.
            It determines the voltage reference.
            '''
        
        })
    '''
    'from' transformer end datasheet this mesh impedance is calculated
    from. It determines the voltage reference.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerStarImpedance(IdentifiedObject):
    '''
    Transformer star impedance (Pi-model) that accurately reflects impedance
    for transformers with 2 or 3 windings. For transformers with 4 or more
    windings, TransformerMeshImpedance class shall be used.
    For transmission networks use PowerTransformerEnd impedances (r, r0, x,
    x0, b, b0, g and g0).
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Resistance of the transformer end.
            '''
        
        })
    '''
    Resistance of the transformer end.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence series resistance of the transformer end.
            '''
        
        })
    '''
    Zero sequence series resistance of the transformer end.
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence series reactance of the transformer end.
            '''
        
        })
    '''
    Positive sequence series reactance of the transformer end.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence series reactance of the transformer end.
            '''
        
        })
    '''
    Zero sequence series reactance of the transformer end.
    '''
    
    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.TransformerStarImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer end datasheet used to calculate this transformer star impedance.
            '''
        
        })
    '''
    Transformer end datasheet used to calculate this transformer star impedance.
    '''
    
    TransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.StarImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All transformer ends having this star impedance.
            '''
        
        })
    '''
    All transformer ends having this star impedance.
    '''
    
    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.TransformerStarImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Transformer end datasheet used to calculate this transformer star impedance.
            '''
        
        })
    '''
    Transformer end datasheet used to calculate this transformer star impedance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerTest(IdentifiedObject):
    '''
    Test result for transformer ends, such as short-circuit, open-circuit (excitation)
    or no-load test.
    '''

    basePower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Base power at which the tests are conducted, usually equal to the rateds
            of one of the involved transformer ends.
            '''
        
        })
    '''
    Base power at which the tests are conducted, usually equal to the rateds
    of one of the involved transformer ends.
    '''
    
    temperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Temperature at which the test is conducted.
            '''
        
        })
    '''
    Temperature at which the test is conducted.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class NoLoadTest(TransformerTest):
    '''
    No-load test results determine core admittance parameters. They include
    exciting current and core loss measurements from applying voltage to one
    winding. The excitation may be positive sequence or zero sequence. The
    test may be repeated at different voltages to measure saturation.
    '''

    energisedEndVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Voltage applied to the winding (end) during test.
            '''
        
        })
    '''
    Voltage applied to the winding (end) during test.
    '''
    
    excitingCurrent: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Exciting current measured from a positive-sequence or single-phase excitation
            test.
            '''
        
        })
    '''
    Exciting current measured from a positive-sequence or single-phase
    excitation test.
    '''
    
    excitingCurrentZero: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Exciting current measured from a zero-sequence open-circuit excitation
            test.
            '''
        
        })
    '''
    Exciting current measured from a zero-sequence open-circuit excitation
    test.
    '''
    
    loss: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Losses measured from a positive-sequence or single-phase excitation test.
            '''
        
        })
    '''
    Losses measured from a positive-sequence or single-phase excitation
    test.
    '''
    
    lossZero: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Losses measured from a zero-sequence excitation test.
            '''
        
        })
    '''
    Losses measured from a zero-sequence excitation test.
    '''
    
    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.EnergisedEndNoLoadTests',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer end that current is applied to in this no-load test.
            '''
        
        })
    '''
    Transformer end that current is applied to in this no-load test.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OpenCircuitTest(TransformerTest):
    '''
    Open-circuit test results verify winding turn ratios and phase shifts.
    They include induced voltage and phase shift measurements on open-circuit
    windings, with voltage applied to the energised end. For three-phase windings,
    the excitation can be a positive sequence (the default) or a zero sequence.
    '''

    energisedEndStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Tap step number for the energised end of the test pair.
            '''
        
        })
    '''
    Tap step number for the energised end of the test pair.
    '''
    
    openEndStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Tap step number for the open end of the test pair.
            '''
        
        })
    '''
    Tap step number for the open end of the test pair.
    '''
    
    energisedEndVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Voltage applied to the winding (end) during test.
            '''
        
        })
    '''
    Voltage applied to the winding (end) during test.
    '''
    
    openEndVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Voltage measured at the open-circuited end, with the energised end set
            to rated voltage and all other ends open.
            '''
        
        })
    '''
    Voltage measured at the open-circuited end, with the energised end
    set to rated voltage and all other ends open.
    '''
    
    phaseShift: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase shift measured at the open end with the energised end set to rated
            voltage and all other ends open.
            '''
        
        })
    '''
    Phase shift measured at the open end with the energised end set to
    rated voltage and all other ends open.
    '''
    
    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.EnergisedEndOpenCircuitTests',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer end that current is applied to in this open-circuit test.
            '''
        
        })
    '''
    Transformer end that current is applied to in this open-circuit test.
    '''
    
    OpenEnd: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.OpenEndOpenCircuitTests',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer end measured for induced voltage and angle in this open-circuit
            test.
            '''
        
        })
    '''
    Transformer end measured for induced voltage and angle in this open-circuit
    test.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ShortCircuitTest(TransformerTest):
    '''
    Short-circuit test results determine mesh impedance parameters. They include
    load losses and leakage impedances. For three-phase windings, the excitation
    can be a positive sequence (the default) or a zero sequence. There shall
    be at least one grounded winding.
    '''

    energisedEndStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Tap step number for the energised end of the test pair.
            '''
        
        })
    '''
    Tap step number for the energised end of the test pair.
    '''
    
    groundedEndStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Tap step number for the grounded end of the test pair.
            '''
        
        })
    '''
    Tap step number for the grounded end of the test pair.
    '''
    
    current: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Short circuit current..
            '''
        
        })
    '''
    Short circuit current..
    '''
    
    leakageImpedance: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Leakage impedance measured from a positive-sequence or single-phase short-circuit
            test.
            '''
        
        })
    '''
    Leakage impedance measured from a positive-sequence or single-phase
    short-circuit test.
    '''
    
    leakageImpedanceZero: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Leakage impedance measured from a zero-sequence short-circuit test.
            '''
        
        })
    '''
    Leakage impedance measured from a zero-sequence short-circuit test.
    '''
    
    loss: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Load losses from a positive-sequence or single-phase short-circuit test.
            '''
        
        })
    '''
    Load losses from a positive-sequence or single-phase short-circuit
    test.
    '''
    
    lossZero: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Load losses from a zero-sequence short-circuit test.
            '''
        
        })
    '''
    Load losses from a zero-sequence short-circuit test.
    '''
    
    power: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Short circuit apparent power.
            '''
        
        })
    '''
    Short circuit apparent power.
    '''
    
    voltage: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Short circuit voltage..
            '''
        
        })
    '''
    Short circuit voltage..
    '''
    
    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.EnergisedEndShortCircuitTests',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer end that voltage is applied to in this short-circuit test.
            The test voltage is chosen to induce rated current in the energised end.
            '''
        
        })
    '''
    Transformer end that voltage is applied to in this short-circuit test.
    The test voltage is chosen to induce rated current in the energised
    end.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class VSCDynamics(IdentifiedObject):
    '''
    VSC function block whose behaviour is described by reference to a standard
    model <font color="#0f0f0f">or by definition of a user-defined model.</font>
    '''

    VsConverter: Optional[VsConverter] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VsConverter.VSCDynamics',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Voltage source converter to which voltage source converter dynamics model
            applies.
            '''
        
        })
    '''
    Voltage source converter to which voltage source converter dynamics
    model applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'HVDCDynamics'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ValueAliasSet(IdentifiedObject):
    '''
    Describes the translation of a set of values into a name and is intendend
    to facilitate custom translations. Each ValueAliasSet has a name, description
    etc. A specific Measurement may represent a discrete state like Open, Closed,
    Intermediate etc. This requires a translation from the MeasurementValue.value
    number to a string, e.g. 0-&gt;"Invalid", 1-&gt;"Open", 2-&gt;"Closed",
    3-&gt;"Intermediate". Each ValueToAlias member in ValueAliasSet.Value describe
    a mapping for one particular value to a name.
    '''

    Commands: list[Command] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Command.ValueAliasSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The Commands using the set for translation.
            '''
        
        })
    '''
    The Commands using the set for translation.
    '''
    
    Discretes: list[Discrete] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Discrete.ValueAliasSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The Measurements using the set for translation.
            '''
        
        })
    '''
    The Measurements using the set for translation.
    '''
    
    RaiseLowerCommands: list[RaiseLowerCommand] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RaiseLowerCommand.ValueAliasSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The Commands using the set for translation.
            '''
        
        })
    '''
    The Commands using the set for translation.
    '''
    
    Values: list[ValueToAlias] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ValueToAlias.ValueAliasSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The ValueToAlias mappings included in the set.
            '''
        
        })
    '''
    The ValueToAlias mappings included in the set.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ValueToAlias(IdentifiedObject):
    '''
    Describes the translation of one particular value into a name, e.g. 1 as
    "Open".
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The value that is mapped.
            '''
        
        })
    '''
    The value that is mapped.
    '''
    
    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.Values',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The ValueAliasSet having the ValueToAlias mappings.
            '''
        
        })
    '''
    The ValueAliasSet having the ValueToAlias mappings.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WindTurbineType3or4Dynamics(IdentifiedObject):
    '''
    Parent class supporting relationships to wind turbines type 3 and type
    4 and wind plant including their control models.
    '''

    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsConnection.WindTurbineType3or4Dynamics',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The power electronics connection associated with this wind turbine type
            3 or type 4 dynamics model.
            '''
        
        })
    '''
    The power electronics connection associated with this wind turbine
    type 3 or type 4 dynamics model.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'WindDynamics'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WirePosition(IdentifiedObject):
    '''
    Identification, spacing and configuration of the wires of a conductor with
    respect to a structure.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Numbering for wires on a WireSpacingInfo. Neutrals should be numbered last.
            '''
        
        })
    '''
    Numbering for wires on a WireSpacingInfo. Neutrals should be numbered
    last.
    '''
    
    xCoord: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Signed horizontal distance from the wire at this position to a common reference
            point.
            '''
        
        })
    '''
    Signed horizontal distance from the wire at this position to a common
    reference point.
    '''
    
    yCoord: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Signed vertical distance from the wire at this position: above ground (positive
            value) or burial depth below ground (negative value).
            '''
        
        })
    '''
    Signed vertical distance from the wire at this position: above ground
    (positive value) or burial depth below ground (negative value).
    '''
    
    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.WirePositions',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Wire spacing data this wire position belongs to.
            '''
        
        })
    '''
    Wire spacing data this wire position belongs to.
    '''
    
    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WirePosition',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Wire phase information for this wire position.
            '''
        
        })
    '''
    Wire phase information for this wire position.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class InstanceSet(Identity):
    '''
    Instance of a version of a model part. This corresponds to a payload of
    instance data.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    InstanceSetMember: list[IdentifiedObject] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IdentifiedObject.InstanceSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Data objects contained in the dataset.
            '''
        
        })
    '''
    Data objects contained in the dataset.
    '''
    
@dataclass(repr=False)
class InsulationInfo(Identity):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    insulated: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if conductor is insulated.
            '''
        
        })
    '''
    True if conductor is insulated.
    '''
    
    insulationMaterial: Optional[ WireInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if insulated conductor) Material used for insulation.
            '''
        
        })
    '''
    (if insulated conductor) Material used for insulation.
    '''
    
    insulationThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if insulated conductor) Thickness of the insulation.
            '''
        
        })
    '''
    (if insulated conductor) Thickness of the insulation.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IrregularTimePoint(Identity):
    '''
    TimePoints for a schedule where the time between the points varies.
    '''

    value1: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The first value at the time. The meaning of the value is defined by the
            derived type of the associated schedule.
            '''
        
        })
    '''
    The first value at the time. The meaning of the value is defined by
    the derived type of the associated schedule.
    '''
    
    value2: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The second value at the time. The meaning of the value is defined by the
            derived type of the associated schedule.
            '''
        
        })
    '''
    The second value at the time. The meaning of the value is defined by
    the derived type of the associated schedule.
    '''
    
    time: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The time is relative to the schedule starting time.
            '''
        
        })
    '''
    The time is relative to the schedule starting time.
    '''
    
    IntervalSchedule: Optional[IrregularIntervalSchedule] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IrregularIntervalSchedule.TimePoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            An IrregularTimePoint belongs to an IrregularIntervalSchedule.
            '''
        
        })
    '''
    An IrregularTimePoint belongs to an IrregularIntervalSchedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MeasurementVector(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MeasEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MeterEquipment(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'WiresEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Name(Identity):
    '''
    The Name class provides the means to define any number of human readable
    names for an object. A name is <b>not</b> to be used for defining inter-object
    relationships. For inter-object relationships instead use the object identification
    'mRID'.
    '''

    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Any free text that name the object.
            '''
        
        })
    '''
    Any free text that name the object.
    '''
    
    IdentifiedObject: Optional[IdentifiedObject] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IdentifiedObject.Names',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Identified object that this name designates.
            '''
        
        })
    '''
    Identified object that this name designates.
    '''
    
    NameType: Optional[NameType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NameType.Names',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of this name.
            '''
        
        })
    '''
    Type of this name.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class NameType(Identity):
    '''
    Type of name. Possible values for attribute 'name' are implementation dependent
    but standard profiles may specify types. An enterprise may have multiple
    IT systems each having its own local name for the same object, e.g. a planning
    system may have different names from an EMS. An object may also have different
    names within the same IT system, e.g. localName as defined in CIM version
    14. The definition from CIM14 is:
    The localName is a human readable name of the object. It is a free text
    name local to a node in a naming hierarchy similar to a file directory
    structure. A power system related naming hierarchy may be: Substation,
    VoltageLevel, Equipment etc. Children of the same parent in such a hierarchy
    have names that typically are unique among them.
    '''

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Description of the name type.
            '''
        
        })
    '''
    Description of the name type.
    '''
    
    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Name of the name type.
            '''
        
        })
    '''
    Name of the name type.
    '''
    
    NameTypeAuthority: Optional[NameTypeAuthority] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NameTypeAuthority.NameTypes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Authority responsible for managing names of this type.
            '''
        
        })
    '''
    Authority responsible for managing names of this type.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    Names: list[Name] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Name.NameType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All names of this type.
            '''
        
        })
    '''
    All names of this type.
    '''
    
@dataclass(repr=False)
class NameTypeAuthority(Identity):
    '''
    Authority responsible for creation and management of names of a given type;
    typically an organization or an enterprise system.
    '''

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Description of the name type authority.
            '''
        
        })
    '''
    Description of the name type authority.
    '''
    
    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Name of the name type authority.
            '''
        
        })
    '''
    Name of the name type authority.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    NameTypes: list[NameType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NameType.NameTypeAuthority',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All name types managed by this authority.
            '''
        
        })
    '''
    All name types managed by this authority.
    '''
    
@dataclass(repr=False)
class NonlinearShuntCompensatorPhasePoint(Identity):
    '''
    A per phase non linear shunt compensator bank or section admittance value.
    The number of NonlinearShuntCompenstorPhasePoint instances associated with
    a NonlinearShuntCompensatorPhase shall be equal to ShuntCompensatorPhase.maximumSections.
    ShuntCompensator.sections shall only be set to one of the NonlinearShuntCompenstorPhasePoint.sectionNumber.
    There is no interpolation between NonlinearShuntCompenstorPhasePoint-s.
    '''

    sectionNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The number of the section.
            '''
        
        })
    '''
    The number of the section.
    '''
    
    b: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance per section.
            '''
        
        })
    '''
    Positive sequence shunt (charging) susceptance per section.
    '''
    
    g: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence shunt (charging) conductance per section.
            '''
        
        })
    '''
    Positive sequence shunt (charging) conductance per section.
    '''
    
    NonlinearShuntCompensatorPhase: Optional[NonlinearShuntCompensatorPhase] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NonlinearShuntCompensatorPhase.NonlinearShuntCompensatorPhasePoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Non-linear shunt compensator phase owning this point.
            '''
        
        })
    '''
    Non-linear shunt compensator phase owning this point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class NonlinearShuntCompensatorPoint(Identity):
    '''
    A non linear shunt compensator bank or section admittance value. The number
    of NonlinearShuntCompenstorPoint instances associated with a NonlinearShuntCompensator
    shall be equal to ShuntCompensator.maximumSections. ShuntCompensator.sections
    shall only be set to one of the NonlinearShuntCompenstorPoint.sectionNumber.
    There is no interpolation between NonlinearShuntCompenstorPoint-s.
    '''

    sectionNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The number of the section.
            '''
        
        })
    '''
    The number of the section.
    '''
    
    b: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance per section.
            '''
        
        })
    '''
    Positive sequence shunt (charging) susceptance per section.
    '''
    
    b0: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance per section.
            '''
        
        })
    '''
    Zero sequence shunt (charging) susceptance per section.
    '''
    
    g: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Positive sequence shunt (charging) conductance per section.
            '''
        
        })
    '''
    Positive sequence shunt (charging) conductance per section.
    '''
    
    g0: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Zero sequence shunt (charging) conductance per section.
            '''
        
        })
    '''
    Zero sequence shunt (charging) conductance per section.
    '''
    
    NonlinearShuntCompensator: Optional[NonlinearShuntCompensator] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NonlinearShuntCompensator.NonlinearShuntCompensatorPoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Non-linear shunt compensator owning this point.
            '''
        
        })
    '''
    Non-linear shunt compensator owning this point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperatingShare(Identity):
    '''
    Specifies the operations contract relationship between a power system resource
    and a contract participant.
    '''

    percentage: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Percentage operational ownership between the pair (power system resource
            and operating participant) associated with this share. The total percentage
            ownership for a power system resource should add to 100%.
            '''
        
        })
    '''
    Percentage operational ownership between the pair (power system resource
    and operating participant) associated with this share. The total percentage
    ownership for a power system resource should add to 100%.
    '''
    
    OperatingParticipant: Optional[OperatingParticipant] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperatingParticipant.OperatingShare',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The operating participant having this share with the associated power system
            resource.
            '''
        
        })
    '''
    The operating participant having this share with the associated power
    system resource.
    '''
    
    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.OperatingShare',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The power system resource to which the share applies.
            '''
        
        })
    '''
    The power system resource to which the share applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class OperatonalLimitTypeScaling(Identity):
    '''
    One operational limit type scales values of another operational limit type
    when under the same operational limit set. This applies to any operational
    limit assigned to the target operational limit type and without other limit
    dependency models.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfOperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    TargetOperationalLimit: Optional[OperationalLimitType] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperationalLimitType.TargetOperationalLimitmTypeScaling',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class PMUStream(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MeasEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PMUValueConcentration(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MeasEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhasorDataConcentrator(Identity):
    '''
    '''

    timeSourceType: Optional[ TimeSourceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            PDC may or may not have its own dedicated time source. The timestamp issued
            by PDC will not supersede the timestamp from individual PMUs.
            '''
        
        })
    '''
    PDC may or may not have its own dedicated time source. The timestamp
    issued by PDC will not supersede the timestamp from individual PMUs.
    '''
    
    CentralPDC: Optional[PhasorDataConcentrator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhasorDataConcentrator.LocalPDC',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MeasEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    LocalPDC: list[PhasorDataConcentrator] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhasorDataConcentrator.CentralPDC',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class PhasorMeasurementValue(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MeasEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerElectronicsConnectionController(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ControlEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Quality61850(Identity):
    '''
    Quality flags in this class are as defined in IEC 61850, except for estimatorReplaced,
    which has been included in this class for convenience.
    '''

    badReference: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Measurement value may be incorrect due to a reference being out of calibration.
            '''
        
        })
    '''
    Measurement value may be incorrect due to a reference being out of
    calibration.
    '''
    
    estimatorReplaced: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Value has been replaced by State Estimator. estimatorReplaced is not an
            IEC61850 quality bit but has been put in this class for convenience.
            '''
        
        })
    '''
    Value has been replaced by State Estimator. estimatorReplaced is not
    an IEC61850 quality bit but has been put in this class for convenience.
    '''
    
    failure: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This identifier indicates that a supervision function has detected an internal
            or external failure, e.g. communication failure.
            '''
        
        })
    '''
    This identifier indicates that a supervision function has detected
    an internal or external failure, e.g. communication failure.
    '''
    
    oldData: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Measurement value is old and possibly invalid, as it has not been successfully
            updated during a specified time interval.
            '''
        
        })
    '''
    Measurement value is old and possibly invalid, as it has not been successfully
    updated during a specified time interval.
    '''
    
    operatorBlocked: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Measurement value is blocked and hence unavailable for transmission.
            '''
        
        })
    '''
    Measurement value is blocked and hence unavailable for transmission.
    '''
    
    oscillatory: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            To prevent some overload of the communication it is sensible to detect
            and suppress oscillating (fast changing) binary inputs. If a signal changes
            in a defined time twice in the same direction (from 0 to 1 or from 1 to
            0) then oscillation is detected and the detail quality identifier "oscillatory"
            is set. If it is detected a configured numbers of transient changes could
            be passed by. In this time the validity status "questionable" is set. If
            after this defined numbers of changes the signal is still in the oscillating
            state the value shall be set either to the opposite state of the previous
            stable value or to a defined default value. In this case the validity status
            "questionable" is reset and "invalid" is set as long as the signal is oscillating.
            If it is configured such that no transient changes should be passed by
            then the validity status "invalid" is set immediately in addition to the
            detail quality identifier "oscillatory" (used for status information only).
            '''
        
        })
    '''
    To prevent some overload of the communication it is sensible to detect
    and suppress oscillating (fast changing) binary inputs. If a signal
    changes in a defined time twice in the same direction (from 0 to 1
    or from 1 to 0) then oscillation is detected and the detail quality
    identifier "oscillatory" is set. If it is detected a configured numbers
    of transient changes could be passed by. In this time the validity
    status "questionable" is set. If after this defined numbers of changes
    the signal is still in the oscillating state the value shall be set
    either to the opposite state of the previous stable value or to a defined
    default value. In this case the validity status "questionable" is reset
    and "invalid" is set as long as the signal is oscillating. If it is
    configured such that no transient changes should be passed by then
    the validity status "invalid" is set immediately in addition to the
    detail quality identifier "oscillatory" (used for status information
    only).
    '''
    
    outOfRange: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Measurement value is beyond a predefined range of value.
            '''
        
        })
    '''
    Measurement value is beyond a predefined range of value.
    '''
    
    overFlow: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Measurement value is beyond the capability of being represented properly.
            For example, a counter value overflows from maximum count back to a value
            of zero.
            '''
        
        })
    '''
    Measurement value is beyond the capability of being represented properly.
    For example, a counter value overflows from maximum count back to a
    value of zero.
    '''
    
    suspect: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A correlation function has detected that the value is not consistent with
            other values. Typically set by a network State Estimator.
            '''
        
        })
    '''
    A correlation function has detected that the value is not consistent
    with other values. Typically set by a network State Estimator.
    '''
    
    test: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Measurement value is transmitted for test purposes.
            '''
        
        })
    '''
    Measurement value is transmitted for test purposes.
    '''
    
    source: Optional[ Source ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Source gives information related to the origin of a value. The value may
            be acquired from the process, defaulted or substituted.
            '''
        
        })
    '''
    Source gives information related to the origin of a value. The value
    may be acquired from the process, defaulted or substituted.
    '''
    
    validity: Optional[ Validity ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Validity of the measurement value.
            '''
        
        })
    '''
    Validity of the measurement value.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class MeasurementValueQuality(Quality61850):
    '''
    Measurement quality flags. Bits 0-10 are defined for substation automation
    in IEC 61850-7-3. Bits 11-15 are reserved for future expansion by that
    document. Bits 16-31 are reserved for EMS applications.
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.MeasurementValueQuality',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''
        
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''
    
    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.MeasurementValueQuality',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''
        
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RegularTimePoint(Identity):
    '''
    Time point for a schedule where the time between the consecutive points
    is constant.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The position of the regular time point in the sequence. Note that time
            points don't have to be sequential, i.e. time points may be omitted. The
            actual time for a RegularTimePoint is computed by multiplying the associated
            regular interval schedule's time step with the regular time point sequence
            number and adding the associated schedules start time. To specify values
            for the start time, use sequence number 0. The sequence number cannot be
            negative.
            '''
        
        })
    '''
    The position of the regular time point in the sequence. Note that time
    points don't have to be sequential, i.e. time points may be omitted.
    The actual time for a RegularTimePoint is computed by multiplying the
    associated regular interval schedule's time step with the regular time
    point sequence number and adding the associated schedules start time.
    To specify values for the start time, use sequence number 0. The sequence
    number cannot be negative.
    '''
    
    value1: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The first value at the time. The meaning of the value is defined by the
            derived type of the associated schedule.
            '''
        
        })
    '''
    The first value at the time. The meaning of the value is defined by
    the derived type of the associated schedule.
    '''
    
    value2: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The second value at the time. The meaning of the value is defined by the
            derived type of the associated schedule.
            '''
        
        })
    '''
    The second value at the time. The meaning of the value is defined by
    the derived type of the associated schedule.
    '''
    
    IntervalSchedule: Optional[RegularIntervalSchedule] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegularIntervalSchedule.TimePoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Regular interval schedule containing this time point.
            '''
        
        })
    '''
    Regular interval schedule containing this time point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StateVariable(Identity):
    '''
    An abstract class for state variables.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvInjection(StateVariable):
    '''
    The SvInjection reports the calculated bus injection minus the sum of the
    terminal flows. The terminal flow is positive out from the bus (load sign
    convention) and bus injection has positive flow into the bus. SvInjection
    may have the remainder after state estimation or slack after power flow
    calculation.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The terminal phase at which the connection is applied. If missing, the
            injection is assumed to be balanced among non-neutral phases.
            '''
        
        })
    '''
    The terminal phase at which the connection is applied. If missing,
    the injection is assumed to be balanced among non-neutral phases.
    '''
    
    pInjection: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The active power mismatch between calculated injection and initial injection.
            Positive sign means injection into the TopologicalNode (bus).
            '''
        
        })
    '''
    The active power mismatch between calculated injection and initial
    injection. Positive sign means injection into the TopologicalNode (bus).
    '''
    
    qInjection: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reactive power mismatch between calculated injection and initial injection.
            Positive sign means injection into the TopologicalNode (bus).
            '''
        
        })
    '''
    The reactive power mismatch between calculated injection and initial
    injection. Positive sign means injection into the TopologicalNode (bus).
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.SvInjection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The topological node associated with the flow injection state variable.
            '''
        
        })
    '''
    The topological node associated with the flow injection state variable.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvPowerFlow(StateVariable):
    '''
    State variable for power flow. Load convention is used for flow direction.
    This means flow out from the TopologicalNode into the equipment is positive.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The active power flow. Load sign convention is used, i.e. positive sign
            means flow out from a TopologicalNode (bus) into the conducting equipment.
            '''
        
        })
    '''
    The active power flow. Load sign convention is used, i.e. positive
    sign means flow out from a TopologicalNode (bus) into the conducting
    equipment.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The individual phase of the flow. If unspecified, then assumed to be balanced
            among phases.
            '''
        
        })
    '''
    The individual phase of the flow. If unspecified, then assumed to be
    balanced among phases.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reactive power flow. Load sign convention is used, i.e. positive sign
            means flow out from a TopologicalNode (bus) into the conducting equipment.
            '''
        
        })
    '''
    The reactive power flow. Load sign convention is used, i.e. positive
    sign means flow out from a TopologicalNode (bus) into the conducting
    equipment.
    '''
    
    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.SvPowerFlow',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The terminal associated with the power flow state variable.
            '''
        
        })
    '''
    The terminal associated with the power flow state variable.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvShuntCompensatorSections(StateVariable):
    '''
    State variable for the number of sections in service for a shunt compensator.
    '''

    sections: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The number of sections in service as a continuous variable. The attribute
            shall be a positive value or zero. To get integer value scale with ShuntCompensator.bPerSection.
            '''
        
        })
    '''
    The number of sections in service as a continuous variable. The attribute
    shall be a positive value or zero. To get integer value scale with
    ShuntCompensator.bPerSection.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The terminal phase at which the connection is applied. If missing, the
            injection is assumed to be balanced among non-neutral phases.
            '''
        
        })
    '''
    The terminal phase at which the connection is applied. If missing,
    the injection is assumed to be balanced among non-neutral phases.
    '''
    
    ShuntCompensator: Optional[ShuntCompensator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensator.SvShuntCompensatorSections',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The shunt compensator for which the state applies.
            '''
        
        })
    '''
    The shunt compensator for which the state applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvStatus(StateVariable):
    '''
    State variable for status.
    '''

    inService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The in service status as a result of topology processing. It indicates
            if the equipment is considered as energized by the power flow. It reflects
            if the equipment is connected within a solvable island. It does not necessarily
            reflect whether or not the island was solved by the power flow.
            '''
        
        })
    '''
    The in service status as a result of topology processing. It indicates
    if the equipment is considered as energized by the power flow. It reflects
    if the equipment is connected within a solvable island. It does not
    necessarily reflect whether or not the island was solved by the power
    flow.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The individual phase status. If the attribute is unspecified, then three
            phase model is assumed.
            '''
        
        })
    '''
    The individual phase status. If the attribute is unspecified, then
    three phase model is assumed.
    '''
    
    ConductingEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.SvStatus',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The conducting equipment associated with the status state variable.
            '''
        
        })
    '''
    The conducting equipment associated with the status state variable.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvSwitch(StateVariable):
    '''
    State variable for switch.
    '''

    open: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The attribute tells if the computed state of the switch is considered open.
            '''
        
        })
    '''
    The attribute tells if the computed state of the switch is considered
    open.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The terminal phase at which the connection is applied. If missing, the
            injection is assumed to be balanced among non-neutral phases.
            '''
        
        })
    '''
    The terminal phase at which the connection is applied. If missing,
    the injection is assumed to be balanced among non-neutral phases.
    '''
    
    Switch: Optional[Switch] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Switch.SvSwitch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The switch associated with the switch state.
            '''
        
        })
    '''
    The switch associated with the switch state.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvTapStep(StateVariable):
    '''
    State variable for transformer tap step.
    '''

    position: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The floating point tap position. This is not the tap ratio, but rather
            the tap step position as defined by the related tap changer model and normally
            is constrained to be within the range of minimum and maximum tap positions.
            '''
        
        })
    '''
    The floating point tap position. This is not the tap ratio, but rather
    the tap step position as defined by the related tap changer model and
    normally is constrained to be within the range of minimum and maximum
    tap positions.
    '''
    
    TapChanger: Optional[TapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChanger.SvTapStep',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The tap changer associated with the tap step state.
            '''
        
        })
    '''
    The tap changer associated with the tap step state.
    '''
    
    TapChanger: Optional[TapChanger] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChanger.SvTapStep',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The tap changer associated with the tap step state.
            '''
        
        })
    '''
    The tap changer associated with the tap step state.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvVoltage(StateVariable):
    '''
    State variable for voltage.
    '''

    angle: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The voltage angle of the topological node complex voltage with respect
            to system reference.
            '''
        
        })
    '''
    The voltage angle of the topological node complex voltage with respect
    to system reference.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If specified the voltage is the line to ground voltage of the individual
            phase. If unspecified, then the voltage is assumed balanced.
            '''
        
        })
    '''
    If specified the voltage is the line to ground voltage of the individual
    phase. If unspecified, then the voltage is assumed balanced.
    '''
    
    v: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The voltage magnitude at the topological node. The attribute shall be a
            positive value.
            '''
        
        })
    '''
    The voltage magnitude at the topological node. The attribute shall
    be a positive value.
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.SvVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The topological node associated with the voltage state.
            '''
        
        })
    '''
    The topological node associated with the voltage state.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SynchrophaserFrame(Identity):
    '''
    Two-byte frame synchronization word following series of bits defined in
    Table 1 of IEEE c37.118-2024
    '''

    chk: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            From IEEE c37.118, CRC-CCITT, 16-bit unsigned integer.
            '''
        
        })
    '''
    From IEEE c37.118, CRC-CCITT, 16-bit unsigned integer.
    '''
    
    fracsec: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            From c37.118, Fraction of second time of measurement for all data frames
            or time of frame transmission for non-data frames. It is an unsigned 24-bit
            integer number.
            '''
        
        })
    '''
    From c37.118, Fraction of second time of measurement for all data frames
    or time of frame transmission for non-data frames. It is an unsigned
    24-bit integer number.
    '''
    
    framesize: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            From IEEEc37.118: Total number of bytes in the transmitted frame, including
            CHK.
            16-bit unsigned integer. Range = maximum 65 535.
            '''
        
        })
    '''
    From IEEEc37.118: Total number of bytes in the transmitted frame, including
    CHK.
    16-bit unsigned integer. Range = maximum 65 535.
    '''
    
    soc: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Unix timestamp, 32-bit integer
            '''
        
        })
    '''
    Unix timestamp, 32-bit integer
    '''
    
    streamId: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            From IEEE c37.118: Data stream ID number, 16-bit unsigned integer, assigned
            by user, 1 to 65534
            (0 and 65535 are reserved). Identifies destination data stream for commands
            and source data stream for other messages
            '''
        
        })
    '''
    From IEEE c37.118: Data stream ID number, 16-bit unsigned integer,
    assigned by user, 1 to 65534
    (0 and 65535 are reserved). Identifies destination data stream for
    commands
    and source data stream for other messages
    '''
    
    sync: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Frame synchronization word from IEEE c37.118
            '''
        
        })
    '''
    Frame synchronization word from IEEE c37.118
    '''
    
    leapByte: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Leap second information from IEEE c37.118
            '''
        
        })
    '''
    Leap second information from IEEE c37.118
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MeasEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class PMUConfigurationFrame(SynchrophaserFrame):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MeasEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapChangerTablePoint(Identity):
    '''
    Describes each tap step in the tabular curve.
    '''

    ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The voltage at the tap step divided by rated voltage of the transformer
            end having the tap changer. Hence this is a value close to one.
            For example, if the ratio at step 1 is 1.01, and the rated voltage of the
            transformer end is 110kV, then the voltage obtained by setting the tap
            changer to step 1 to is 111.1kV.
            '''
        
        })
    '''
    The voltage at the tap step divided by rated voltage of the transformer
    end having the tap changer. Hence this is a value close to one.
    For example, if the ratio at step 1 is 1.01, and the rated voltage
    of the transformer end is 110kV, then the voltage obtained by setting
    the tap changer to step 1 to is 111.1kV.
    '''
    
    step: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The tap step.
            '''
        
        })
    '''
    The tap step.
    '''
    
    b: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The magnetizing branch susceptance deviation as a percentage of nominal
            value. The actual susceptance is calculated as follows:
            calculated magnetizing susceptance = b(nominal) * (1 + b(from this class)/100).
            The b(nominal) is defined as the static magnetizing susceptance on the
            associated power transformer end or ends. This model assumes the star impedance
            (pi model) form.
            '''
        
        })
    '''
    The magnetizing branch susceptance deviation as a percentage of nominal
    value. The actual susceptance is calculated as follows:
    calculated magnetizing susceptance = b(nominal) * (1 + b(from this
    class)/100). The b(nominal) is defined as the static magnetizing susceptance
    on the associated power transformer end or ends. This model assumes
    the star impedance (pi model) form.
    '''
    
    g: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The magnetizing branch conductance deviation as a percentage of nominal
            value. The actual conductance is calculated as follows:
            calculated magnetizing conductance = g(nominal) * (1 + g(from this class)/100).
            The g(nominal) is defined as the static magnetizing conductance on the
            associated power transformer end or ends. This model assumes the star impedance
            (pi model) form.
            '''
        
        })
    '''
    The magnetizing branch conductance deviation as a percentage of nominal
    value. The actual conductance is calculated as follows:
    calculated magnetizing conductance = g(nominal) * (1 + g(from this
    class)/100). The g(nominal) is defined as the static magnetizing conductance
    on the associated power transformer end or ends. This model assumes
    the star impedance (pi model) form.
    '''
    
    r: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The resistance deviation as a percentage of nominal value. The actual reactance
            is calculated as follows:
            calculated resistance = r(nominal) * (1 + r(from this class)/100). The
            r(nominal) is defined as the static resistance on the associated power
            transformer end or ends. This model assumes the star impedance (pi model)
            form.
            '''
        
        })
    '''
    The resistance deviation as a percentage of nominal value. The actual
    reactance is calculated as follows:
    calculated resistance = r(nominal) * (1 + r(from this class)/100).
    The r(nominal) is defined as the static resistance on the associated
    power transformer end or ends. This model assumes the star impedance
    (pi model) form.
    '''
    
    x: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The series reactance deviation as a percentage of nominal value. The actual
            reactance is calculated as follows:
            calculated reactance = x(nominal) * (1 + x(from this class)/100). The x(nominal)
            is defined as the static series reactance on the associated power transformer
            end or ends. This model assumes the star impedance (pi model) form.
            '''
        
        })
    '''
    The series reactance deviation as a percentage of nominal value. The
    actual reactance is calculated as follows:
    calculated reactance = x(nominal) * (1 + x(from this class)/100). The
    x(nominal) is defined as the static series reactance on the associated
    power transformer end or ends. This model assumes the star impedance
    (pi model) form.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerTablePoint(TapChangerTablePoint):
    '''
    Describes each tap step in the phase tap changer tabular curve.
    '''

    angle: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The angle difference in degrees. A positive value indicates a positive
            angle variation from the Terminal at the PowerTransformerEnd, where the
            TapChanger is located, into the transformer.
            '''
        
        })
    '''
    The angle difference in degrees. A positive value indicates a positive
    angle variation from the Terminal at the PowerTransformerEnd, where
    the TapChanger is located, into the transformer.
    '''
    
    PhaseTapChangerTable: Optional[PhaseTapChangerTable] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhaseTapChangerTable.PhaseTapChangerTablePoint',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The table of this point.
            '''
        
        })
    '''
    The table of this point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RatioTapChangerTablePoint(TapChangerTablePoint):
    '''
    Describes each tap step in the ratio tap changer tabular curve.
    '''

    RatioTapChangerTable: Optional[RatioTapChangerTable] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RatioTapChangerTable.RatioTapChangerTablePoint',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Table of this point.
            '''
        
        })
    '''
    Table of this point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WirePhaseInfo(Identity):
    '''
    Information on a wire carrying a single phase.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    phaseInfo: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
