from __future__ import annotations
import logging
from dataclasses import dataclass, field
from typing import Optional
from enum import Enum
from cimgraph.data_profile.identity import Identity, stereotype
from cimgraph.data_profile.units import CIMUnit, UnitSymbol, UnitMultiplier
_log = logging.getLogger(__name__)
'''
Annotated CIMantic Graphs data profile for CIM17v40
Generated by CIMTool http://cimtool.org
'''

class CIMStereotype(Enum):
    AggregateOf = "AggregateOf"
    Attribute = "Attribute"
    CIMDatatype = "CIMDatatype"
    Compound = "Compound"
    IRCDR = "IRCDR"
    OfAggregate = "OfAggregate"
    Primitive = "Primitive"
    deprecated = "deprecated"
    enumeration = "enumeration"
    harmonization = "harmonization"
    informative = "informative"

BASE_URI = 'http://www.ucaiug.org/profile#'
ONTOLOGY_URI = 'http://iec.ch/TC57/CIM100#'

@dataclass(repr=False)
class ASRequirements(Identity):
    '''
    Models Ancillary Service Requirements. Describes interval for which the
    requirement is applicable.
    '''

    intervalStartTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The start of the time interval for which requirement is defined.
            '''
        
        })
    '''
    The start of the time interval for which requirement is defined.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    ReserveDemandCurve: list[ReserveDemandCurve] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ReserveDemandCurve.ASRequirements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class AccountNotification(Identity):
    '''
    Notifications for move-in, move-out, delinquencies, etc.
    '''

    customerNotificationType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Notifications for move-in, move-out, delinquencies, planned outage, demand
            response programs, time of use, etc.
            '''
        
        })
    '''
    Notifications for move-in, move-out, delinquencies, planned outage,
    demand response programs, time of use, etc.
    '''
    
    methodType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            method of notification such as phone call, email, letter, door hanger,
            text message, etc.
            '''
        
        })
    '''
    method of notification such as phone call, email, letter, door hanger,
    text message, etc.
    '''
    
    note: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Free form text characterizing the notification.
            '''
        
        })
    '''
    Free form text characterizing the notification.
    '''
    
    time: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time of notification - this is the time the notification was sent.
            '''
        
        })
    '''
    Time of notification - this is the time the notification was sent.
    '''
    
    CustomerAccount: Optional[CustomerAccount] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CustomerAccount.AccountNotification',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The customer account for which a notification is made
            '''
        
        })
    '''
    The customer account for which a notification is made
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Customers'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AceTariffType(Identity):
    '''
    The Area Control Error tariff type that is applied or used.
    '''

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The coded type of an ACE tariff.
            '''
        
        })
    '''
    The coded type of an ACE tariff.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketManagement'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ActionRequest(Identity):
    '''
    Action request against an existing Trade.
    '''

    actionName: Optional[ ActionType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Action name type for the action request.
            '''
        
        })
    '''
    Action name type for the action request.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    Bid: list[Bid] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bid.ActionRequest',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Trade: list[Trade] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Trade.ActionRequest',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class AllocationResult(Identity):
    '''
    Models Market clearing results. Indicates market horizon, interval based.
    Used by a market quality system for billing and settlement purposes.
    '''

    intervalStartTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    updateTimeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    updateUser: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketQualitySystem'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    AllocationResultValues: list[AllocationResultValues] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AllocationResultValues.AllocationResult',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class AllocationResultValues(Identity):
    '''
    Models Market clearing results in terms of price and MW values.
    '''

    aggregateType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            "1" -- "Detail",
            "2" -- "Aggregate by Market service type", in which case, the "AllocationEnergyType"
            field will not be filled;
            "3" -- "Aggregate by "AllocationEnergyType", in which case "MarketServiceType"
            will not be filled.
            '''
        
        })
    '''
    "1" -- "Detail",
    "2" -- "Aggregate by Market service type", in which case, the "AllocationEnergyType"
    field will not be filled;
    "3" -- "Aggregate by "AllocationEnergyType", in which case "MarketServiceType"
    will not be filled.
    '''
    
    allocationMwHour: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    allocationPrice: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    energyTypeCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    marketServiceType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Choices are:
            ME - Market Energy Capacity;
            SR - Spinning Reserve Capacity;
            NR - Non-Spinning Reserve Capacity;
            DAC - Day Ahead Capacity;
            DEC - Derate Capacity
            '''
        
        })
    '''
    Choices are:
    ME - Market Energy Capacity;
    SR - Spinning Reserve Capacity;
    NR - Non-Spinning Reserve Capacity;
    DAC - Day Ahead Capacity;
    DEC - Derate Capacity
    '''
    
    AllocationResult: Optional[AllocationResult] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AllocationResult.AllocationResultValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredResource: Optional[RegisteredResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredResource.AllocationResultValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketQualitySystem'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class AreaReserveSpec(Identity):
    '''
    The control area's reserve specification.
    '''

    Description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Description of the object or instance.
            '''
        
        })
    '''
    Description of the object or instance.
    '''
    
    lowerRegMarginReqt: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Lower regulating margin requirement in MW, the amount of generation that
            can be dropped by control in 10 minutes
            '''
        
        })
    '''
    Lower regulating margin requirement in MW, the amount of generation
    that can be dropped by control in 10 minutes
    '''
    
    opReserveReqt: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Operating reserve requirement in MW, where operating reserve is the generating
            capability that is fully available within 30 minutes. Operating reserve
            is composed of primary reserve (t less than 10 min) and secondary reserve
            (10 less than t less than 30 min).
            '''
        
        })
    '''
    Operating reserve requirement in MW, where operating reserve is the
    generating capability that is fully available within 30 minutes. Operating
    reserve is composed of primary reserve (t less than 10 min) and secondary
    reserve (10 less than t less than 30 min).
    '''
    
    primaryReserveReqt: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Primary reserve requirement in MW, where primary reserve is generating
            capability that is fully available within 10 minutes. Primary reserve is
            composed of spinning reserve and quick-start reserve.
            '''
        
        })
    '''
    Primary reserve requirement in MW, where primary reserve is generating
    capability that is fully available within 10 minutes. Primary reserve
    is composed of spinning reserve and quick-start reserve.
    '''
    
    raiseRegMarginReqt: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Raise regulating margin requirement in MW, the amount of generation that
            can be picked up by control in 10 minutes
            '''
        
        })
    '''
    Raise regulating margin requirement in MW, the amount of generation
    that can be picked up by control in 10 minutes
    '''
    
    spinningReserveReqt: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Spinning reserve requirement in MW, spinning reserve is generating capability
            that is presently synchronized to the network and is fully available within
            10 minutes
            '''
        
        })
    '''
    Spinning reserve requirement in MW, spinning reserve is generating
    capability that is presently synchronized to the network and is fully
    available within 10 minutes
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfEnergyScheduling'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    SubControlArea: list[SubControlArea] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SubControlArea.AreaReserveSpecification',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class AttributeInstanceComponent(Identity):
    '''
    A class used to provide information about an attribute.
    '''

    attribute: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The identification of the formal name of an attribute.
            '''
        
        })
    '''
    The identification of the formal name of an attribute.
    '''
    
    attributeValue: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The instance value of the attribute.
            '''
        
        })
    '''
    The instance value of the attribute.
    '''
    
    position: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A sequential value representing a relative sequence number.
            '''
        
        })
    '''
    A sequential value representing a relative sequence number.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketManagement'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AttributeProperty(Identity):
    '''
    Property for a particular attribute that contains name and value.
    '''

    propertyName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    propertyValue: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    sequence: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MktUserAttribute: Optional[MktUserAttribute] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MktUserAttribute.AttributeProperty',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class AuxiliaryCost(Identity):
    '''
    Models Market clearing results for Auxiliary costs.
    '''

    intervalStartTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    updateTimeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    updateUser: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    marketType: Optional[ MarketType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketQualitySystem'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    AuxillaryValues: list[AuxiliaryValues] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AuxiliaryValues.AuxillaryCost',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class AuxiliaryObject(Identity):
    '''
    Models Auxiliary Values.
    '''

    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.AuxillaryObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredLoad: Optional[RegisteredLoad] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredLoad.AuxillaryObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketQualitySystem'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AuxiliaryValues(AuxiliaryObject):
    '''
    Models Auxiliary Values.
    '''

    availUndispatchedQ: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    incrementalORAvail: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    maxExpostCapacity: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    minExpostCapacity: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    noLoadCost: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    startUpCost: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    noLoadCostEligibilityFlag: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    startUpCostEligibilityFlag: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    AuxillaryCost: Optional[AuxiliaryCost] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AuxiliaryCost.AuxillaryValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    FiveMinAuxillaryData: Optional[FiveMinAuxiliaryData] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'FiveMinAuxiliaryData.AuxillaryValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TenMinAuxillaryData: Optional[TenMinAuxiliaryData] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'TenMinAuxiliaryData.AuxillaryData',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketQualitySystem'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BidDistributionFactor(Identity):
    '''
    This class allows SC to input different time intervals for distribution
    factors.
    '''

    timeIntervalEnd: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            End of the time interval n which bid is valid (yyyy-mm-dd hh24: mi: ss)
            '''
        
        })
    '''
    End of the time interval n which bid is valid (yyyy-mm-dd hh24: mi:
    ss)
    '''
    
    timeIntervalStart: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Start of the time interval in which bid is valid (yyyy-mm-dd hh24: mi:
            ss).
            '''
        
        })
    '''
    Start of the time interval in which bid is valid (yyyy-mm-dd hh24:
    mi: ss).
    '''
    
    ProductBid: Optional[ProductBid] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ProductBid.BidDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    PnodeDistributionFactor: list[PnodeDistributionFactor] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PnodeDistributionFactor.BidDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class BidPriceCap(Identity):
    '''
    This class represent the bid price cap.
    '''

    bidCeiling: Optional[ float | CostPerEnergyUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Bid Ceiling ($/MWH)
            '''
        
        })
    '''
    Bid Ceiling ($/MWH)
    '''
    
    bidCeilingAS: Optional[ float | CostPerEnergyUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Bid Ceiling ($/MWH) for generic AS versus a specific market product
            '''
        
        })
    '''
    Bid Ceiling ($/MWH) for generic AS versus a specific market product
    '''
    
    bidFloor: Optional[ float | CostPerEnergyUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Bid Floor, ($/MWH)
            '''
        
        })
    '''
    Bid Floor, ($/MWH)
    '''
    
    bidFloorAS: Optional[ float | CostPerEnergyUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Bid Floor ($/MWH) for generic AS versus a specific market product
            '''
        
        })
    '''
    Bid Floor ($/MWH) for generic AS versus a specific market product
    '''
    
    defaultPrice: Optional[ float | CostPerEnergyUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Bid Default Price($/MWH)
            '''
        
        })
    '''
    Bid Default Price($/MWH)
    '''
    
    marketType: Optional[ MarketType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Market Type of the cap (DAM or RTM)
            '''
        
        })
    '''
    Market Type of the cap (DAM or RTM)
    '''
    
    MarketProduct: Optional[MarketProduct] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MarketProduct.BidPriceCap',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BilateralTransaction(Identity):
    '''
    Bilateral transaction
    '''

    curtailTimeMax: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum curtailment time in number of trading intervals
            '''
        
        })
    '''
    Maximum curtailment time in number of trading intervals
    '''
    
    curtailTimeMin: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum curtailment time in number of trading intervals
            '''
        
        })
    '''
    Minimum curtailment time in number of trading intervals
    '''
    
    marketType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Market type (default=DA)
            DA - Day Ahead
            RT - Real Time
            HA - Hour Ahead
            '''
        
        })
    '''
    Market type (default=DA)
    DA - Day Ahead
    RT - Real Time
    HA - Hour Ahead
    '''
    
    purchaseTimeMax: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum purchase time in number of trading intervals
            '''
        
        })
    '''
    Maximum purchase time in number of trading intervals
    '''
    
    purchaseTimeMin: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum purchase time in number of trading intervals
            '''
        
        })
    '''
    Minimum purchase time in number of trading intervals
    '''
    
    scope: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transaction scope:
            'Internal' (default)
            'External'
            '''
        
        })
    '''
    Transaction scope:
    'Internal' (default)
    'External'
    '''
    
    transactionType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transaction type (default 1)
            1 - Fixed
            2 - Dispatchable continuous
            3 - Dispatchable block-loading
            '''
        
        })
    '''
    Transaction type (default 1)
    1 - Fixed
    2 - Dispatchable continuous
    3 - Dispatchable block-loading
    '''
    
    totalTranChargeMax: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum total transmission (congestion) charges in monetary units
            '''
        
        })
    '''
    Maximum total transmission (congestion) charges in monetary units
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfMarketOperations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class BlockingFunction(Identity):
    '''
    '''

    Delay: Optional[Delay] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Delay.BlockingFunction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    VSCtype1: Optional[VSCtype1] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VSCtype1.BlockingFunction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'VSC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    Delay: Optional[Delay] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Delay.BlockingFunction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    VSCtype1: Optional[VSCtype1] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VSCtype1.BlockingFunction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class BranchEndFlow(Identity):
    '''
    Dynamic flows and ratings associated with a branch end.
    '''

    loadDumpRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Load Dump Rating for the branch
            '''
        
        })
    '''
    The Load Dump Rating for the branch
    '''
    
    longTermRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Long Term Rating for the branch
            '''
        
        })
    '''
    The Long Term Rating for the branch
    '''
    
    mVARFlow: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The MVAR flow on the branch
            Attribute Usage: Reactive power flow at the series device, transformer,
            phase shifter, or line end
            '''
        
        })
    '''
    The MVAR flow on the branch
    Attribute Usage: Reactive power flow at the series device, transformer,
    phase shifter, or line end
    '''
    
    mwFlow: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The MW flow on the branch
            Attribute Usage: Active power flow at the series device, transformer, phase
            shifter, or line end
            '''
        
        })
    '''
    The MW flow on the branch
    Attribute Usage: Active power flow at the series device, transformer,
    phase shifter, or line end
    '''
    
    normalRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Normal Rating for the branch
            '''
        
        })
    '''
    The Normal Rating for the branch
    '''
    
    shortTermRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Short Term Rating for the branch
            '''
        
        })
    '''
    The Short Term Rating for the branch
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    MktACLineSegmentEndAFlow: list[MktACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MktACLineSegment.EndAFlow',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MktACLineSegmentEndBFlow: list[MktACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MktACLineSegment.EndBFlow',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MktPowerTransformerEndAFlow: list[MktPowerTransformer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MktPowerTransformer.EndAFlow',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MktPowerTransformerEndBFlow: list[MktPowerTransformer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MktPowerTransformer.EndBFlow',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MktSeriresCompensatorEndAFlow: list[MktSeriesCompensator] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MktSeriesCompensator.EndAFlow',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MktSeriesCompensatorEndBFlow: list[MktSeriesCompensator] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MktSeriesCompensator.EndBFlow',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class BranchGroupTerminal(Identity):
    '''
    A specific directed terminal flow for a branch group.
    '''

    positiveFlowIn: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The flow into the terminal is summed if set true. The flow out of the terminal
            is summed if set false.
            '''
        
        })
    '''
    The flow into the terminal is summed if set true. The flow out of the
    terminal is summed if set false.
    '''
    
    BranchGroup: Optional[BranchGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'BranchGroup.BranchGroupTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The branch group to which the directed branch group terminals belong.
            '''
        
        })
    '''
    The branch group to which the directed branch group terminals belong.
    '''
    
    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Terminal.BranchGroupTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The terminal to be summed.
            '''
        
        })
    '''
    The terminal to be summed.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CCAinverter(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'CSC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CCArectifierControl(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'CSC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CalculationMethodOrder(Identity):
    '''
    The order of this calculation method in a hierarchy of calculation methods.
    '''

    order: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Order of the statistical calculation method within the calculation method
            hierarchy.
            '''
        
        })
    '''
    Order of the statistical calculation method within the calculation
    method hierarchy.
    '''
    
    CalculationMethodHierarchy: Optional[CalculationMethodHierarchy] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CalculationMethodHierarchy.CalculationMethodOrder',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The calculation method hierarchy of which this order of statistical calculation
            is a member.
            '''
        
        })
    '''
    The calculation method hierarchy of which this order of statistical
    calculation is a member.
    '''
    
    StatisicalCalculation: Optional[StatisticalCalculation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'StatisticalCalculation.CalculationMethodOrder',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The statistical calculation done at this order.
            '''
        
        })
    '''
    The statistical calculation done at this order.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetMeas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Card(Identity):
    '''
    Documentation of the tender when it is a type of card (credit, debit, etc).
    '''

    accountHolderName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Name of account holder.
            '''
        
        })
    '''
    Name of account holder.
    '''
    
    cvNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The card verification number.
            '''
        
        })
    '''
    The card verification number.
    '''
    
    expiryDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The date when this card expires.
            '''
        
        })
    '''
    The date when this card expires.
    '''
    
    pan: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The primary account number.
            '''
        
        })
    '''
    The primary account number.
    '''
    
    Tender: Optional[Tender] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Tender.Card',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Payment tender this card is being used for.
            '''
        
        })
    '''
    Payment tender this card is being used for.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'PaymentMetering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    Tender: Optional[Tender] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Tender.Card',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Payment tender this card is being used for.
            '''
        
        })
    '''
    Payment tender this card is being used for.
    '''
    
@dataclass(repr=False)
class ChangeSetMember(Identity):
    '''
    A CRUD-style data object.
    '''

    Changeset: Optional[ChangeSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ChangeSet.ChangeSetMember',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Dataset containing the data objects.
            '''
        
        })
    '''
    Dataset containing the data objects.
    '''
    
    PropertiesObject: Optional[IdentifiedObject] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IdentifiedObject.PropertiesCIMDataObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The CIM object holding the properties of this dataset context. Sometimes
            properties are not required and only the reference to the registered object
            is required.
            '''
        
        })
    '''
    The CIM object holding the properties of this dataset context. Sometimes
    properties are not required and only the reference to the registered
    object is required.
    '''
    
    TargetObject: Optional[IdentifiedObject] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'IdentifiedObject.TargetingCIMDataObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The registered CIM object.
            '''
        
        })
    '''
    The registered CIM object.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    PropertiesObject: Optional[IdentifiedObject] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IdentifiedObject.PropertiesCIMDataObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The CIM object holding the properties of this dataset context. Sometimes
            properties are not required and only the reference to the registered object
            is required.
            '''
        
        })
    '''
    The CIM object holding the properties of this dataset context. Sometimes
    properties are not required and only the reference to the registered
    object is required.
    '''
    
@dataclass(repr=False)
class ObjectCreation(ChangeSetMember):
    '''
    An object is to be created in the context.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ObjectDeletion(ChangeSetMember):
    '''
    An object is to be deleted in the context.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ObjectModification(ChangeSetMember):
    '''
    The object already exists and is to be modified.
    '''

    ObjectReverseModification: Optional[ObjectReverseModification] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ObjectReverseModification.ObjectModification',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The data object holding preconditions of updates.
            '''
        
        })
    '''
    The data object holding preconditions of updates.
    '''
    
    ObjectReverseModification: Optional[ObjectReverseModification] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ObjectReverseModification.ObjectModification',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The data object holding preconditions of updates.
            '''
        
        })
    '''
    The data object holding preconditions of updates.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ObjectReverseModification(ChangeSetMember):
    '''
    Used to specify precondition properties for a preconditioned update.
    '''

    ObjectModification: Optional[ObjectModification] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ObjectModification.ObjectReverseModification',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The associated data object representing the update. Normally the associaiton
            is specifed, but in the case of a proxy object where the association is
            removed, we might not reference any data object as it would only reference
            a proxy data object with no associations.
            '''
        
        })
    '''
    The associated data object representing the update. Normally the associaiton
    is specifed, but in the case of a proxy object where the association
    is removed, we might not reference any data object as it would only
    reference a proxy data object with no associations.
    '''
    
    ObjectModification: Optional[ObjectModification] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ObjectModification.ObjectReverseModification',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The associated data object representing the update. Normally the associaiton
            is specifed, but in the case of a proxy object where the association is
            removed, we might not reference any data object as it would only reference
            a proxy data object with no associations.
            '''
        
        })
    '''
    The associated data object representing the update. Normally the associaiton
    is specifed, but in the case of a proxy object where the association
    is removed, we might not reference any data object as it would only
    reference a proxy data object with no associations.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ChargeProfileData(Identity):
    '''
    Model of various charges associated with an energy profile to support billing
    and settlement.
    '''

    sequence: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The sequence number of the profile.
            '''
        
        })
    '''
    The sequence number of the profile.
    '''
    
    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The date and time of an interval.
            '''
        
        })
    '''
    The date and time of an interval.
    '''
    
    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The value of an interval given a profile type (amount, price, or quantity),
            subject to the UOM.
            '''
        
        })
    '''
    The value of an interval given a profile type (amount, price, or quantity),
    subject to the UOM.
    '''
    
    BillDeterminant: Optional[BillDeterminant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BillDeterminant.ChargeProfileData',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ChargeProfile: Optional[ChargeProfile] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ChargeProfile.ChargeProfileData',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Cheque(Identity):
    '''
    The actual tender when it is a type of cheque.
    '''

    chequeNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Cheque reference number as printed on the cheque.
            '''
        
        })
    '''
    Cheque reference number as printed on the cheque.
    '''
    
    date: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date when cheque becomes valid.
            '''
        
        })
    '''
    Date when cheque becomes valid.
    '''
    
    micrNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The magnetic ink character recognition number printed on the cheque.
            '''
        
        })
    '''
    The magnetic ink character recognition number printed on the cheque.
    '''
    
    kind: Optional[ ChequeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of cheque.
            '''
        
        })
    '''
    Kind of cheque.
    '''
    
    Tender: Optional[Tender] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Tender.Cheque',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Payment tender the cheque is being used for.
            '''
        
        })
    '''
    Payment tender the cheque is being used for.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'PaymentMetering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    Tender: Optional[Tender] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Tender.Cheque',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Payment tender the cheque is being used for.
            '''
        
        })
    '''
    Payment tender the cheque is being used for.
    '''
    
@dataclass(repr=False)
class CombinedCycleTransitionState(Identity):
    '''
    Defines the available from and to Transition States for the Combine Cycle
    Configurations.
    '''

    upTransition: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag indicating whether this is an UP transition.
            If not, it is a DOWN transition.
            '''
        
        })
    '''
    Flag indicating whether this is an UP transition.
    If not, it is a DOWN transition.
    '''
    
    FromConfiguration: Optional[CombinedCycleConfiguration] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CombinedCycleConfiguration.FromTransitionState',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ToConfiguration: Optional[CombinedCycleConfiguration] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CombinedCycleConfiguration.ToTransitionState',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Commitments(Identity):
    '''
    Provides the necessary information (on a resource basis) to capture the
    Startup/Shutdown commitment results. This information is relevant to all
    markets.
    '''

    instructionCost: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Total cost associated with changing the status of the resource.
            '''
        
        })
    '''
    Total cost associated with changing the status of the resource.
    '''
    
    intervalEndTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            End time for the commitment period. This will be on an interval boundary.
            '''
        
        })
    '''
    End time for the commitment period. This will be on an interval boundary.
    '''
    
    intervalStartTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Start time for the commitment period. This will be on an interval boundary.
            '''
        
        })
    '''
    Start time for the commitment period. This will be on an interval boundary.
    '''
    
    minStatusChangeTime: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            SCUC commitment period start-up time. Calculated start up time based on
            the StartUpTimeCurve provided with the Bid.
            This is a combination of StartUp time bid and Unit down time.
            Units is minutes
            '''
        
        })
    '''
    SCUC commitment period start-up time. Calculated start up time based
    on the StartUpTimeCurve provided with the Bid.
    This is a combination of StartUp time bid and Unit down time.
    Units is minutes
    '''
    
    noLoadCost: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Unit no load cost in case of energy commodity
            '''
        
        })
    '''
    Unit no load cost in case of energy commodity
    '''
    
    updateTimeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    updateUser: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    commitmentType: Optional[ CommitmentType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            the type of UC status (self commitment, ISO commitment, or SCUC commitment)
            '''
        
        })
    '''
    the type of UC status (self commitment, ISO commitment, or SCUC commitment)
    '''
    
    instructionType: Optional[ AutomaticDispInstTypeCommitment ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicator of either a Start-Up or a Shut-Down.
            '''
        
        })
    '''
    Indicator of either a Start-Up or a Shut-Down.
    '''
    
    updateType: Optional[ MQSCHGType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredResource: Optional[RegisteredResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RegisteredResource.Commitments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CommodityPrice(Identity):
    '''
    The CommodityPrice class is used to define the price of a commodity during
    a given time interval. The interval may be long, e.g. a year, or very short,
    e.g. 5 minutes. There will be many instances of the CommodityPrice class
    for each instance of the CommodityDefinition to which it is associated.
    Note that there may be more than once price associated with a given interval
    and these variances are described by the association (or associations)
    with the PriceDescriptor class.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The price of the Commodity, expressed as a floating point value with the
            currency and unit of measure defined in the associated CommodityDefinition
            class.
            '''
        
        })
    '''
    The price of the Commodity, expressed as a floating point value with
    the currency and unit of measure defined in the associated CommodityDefinition
    class.
    '''
    
    CommodityDefinition: Optional[CommodityDefinition] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CommodityDefinition.CommodityPrice',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PnodeClearing: Optional[PnodeClearing] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PnodeClearing.CommodityPrice',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PriceDescriptor: Optional[PriceDescriptor] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'PriceDescriptor.CommodityPrice',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConstraintDuration(Identity):
    '''
    Duration constraint to activate, to put in operation, to deactivate, ...
    a given event.
    '''

    duration: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The duration of the constraint.
            '''
        
        })
    '''
    The duration of the constraint.
    '''
    
    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of the constraint.
            '''
        
        })
    '''
    The type of the constraint.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketManagement'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConsumptionTariffInterval(Identity):
    '''
    One of a sequence of intervals defined in terms of consumption quantity
    of a service such as electricity, water, gas, etc. It is typically used
    in association with TariffProfile to define the steps or blocks in a step
    tariff structure, where startValue simultaneously defines the entry value
    of this step and the closing value of the previous step. Where consumption
    is >= startValue it falls within this interval and where consumption is
    < startValue it falls within the previous interval.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A sequential reference that defines the identity of this interval and its
            relative position with respect to other intervals in a sequence of intervals.
            '''
        
        })
    '''
    A sequential reference that defines the identity of this interval and
    its relative position with respect to other intervals in a sequence
    of intervals.
    '''
    
    startValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The lowest level of consumption that defines the starting point of this
            interval. The interval extends to the start of the next interval or until
            it is reset to the start of the first interval by TariffProfile.tariffCycle.
            '''
        
        })
    '''
    The lowest level of consumption that defines the starting point of
    this interval. The interval extends to the start of the next interval
    or until it is reset to the start of the first interval by TariffProfile.tariffCycle.
    '''
    
    ReadingType: Optional[ReadingType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReadingType.ConsumptionTariffIntervals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reading type for 'startValue'.
            '''
        
        })
    '''
    Reading type for 'startValue'.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'PaymentMetering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ContractDistributionFactor(Identity):
    '''
    Distribution among resources at the sink point or source point.
    '''

    factor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            MW value that this resource provides to the overall contract.
            '''
        
        })
    '''
    MW value that this resource provides to the overall contract.
    '''
    
    sinkFlag: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This value will be set to YES if the referenced Cnode is defined as the
            sink point in the contract.
            '''
        
        })
    '''
    This value will be set to YES if the referenced Cnode is defined as
    the sink point in the contract.
    '''
    
    sourceFlag: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This value will be set to YES if the referenced Cnode is defined as the
            source point in the contract.
            '''
        
        })
    '''
    This value will be set to YES if the referenced Cnode is defined as
    the source point in the contract.
    '''
    
    Flowgate: Optional[Flowgate] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Flowgate.ContractDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredResource: Optional[RegisteredResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredResource.ContractDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TransmissionContractRight: Optional[ContractRight] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ContractRight.ContractDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ControlAreaDesignation(Identity):
    '''
    Indicates Control Area associated with self-schedule.
    '''

    attained: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Attained.
            '''
        
        })
    '''
    Attained.
    '''
    
    native: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Native.
            '''
        
        })
    '''
    Native.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ControlAreaSolutionData(Identity):
    '''
    State Estimator Solution Pool Interchange and Losses.
    '''

    solvedInterchange: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Pool MW Interchange
            Attribute Usage: The active power interchange of the pool
            '''
        
        })
    '''
    Pool MW Interchange
    Attribute Usage: The active power interchange of the pool
    '''
    
    solvedLosses: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Pool Losses MW
            Attribute Usage: The active power losses of the pool in MW
            '''
        
        })
    '''
    Pool Losses MW
    Attribute Usage: The active power losses of the pool in MW
    '''
    
    MktControlArea: Optional[MktControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MktControlArea.ControlAreaSolutionData',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class CurrentScheduledInterchange(Identity):
    '''
    Control area current net tie (scheduled interchange) sent to real time
    dispatch.
    '''

    currentNetTieMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Current control area net tie MW (the sum of the tie line flows, i.e the
            sum of flows into and out of the control area), the current instantaneous
            scheduled interchange.
            '''
        
        })
    '''
    Current control area net tie MW (the sum of the tie line flows, i.e
    the sum of flows into and out of the control area), the current instantaneous
    scheduled interchange.
    '''
    
    useEmergencySchedule: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Use Emergency Schedule
            Attribute Usage: Emergency use indicator, false = Emergency Schedular OFF,
            true = Emergency Schedular ON.
            '''
        
        })
    '''
    Use Emergency Schedule
    Attribute Usage: Emergency use indicator, false = Emergency Schedular
    OFF, true = Emergency Schedular ON.
    '''
    
    InternalControlArea: Optional[InternalControlArea] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'InternalControlArea.CurrentScheduledInterchange',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfEnergyScheduling'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    InternalControlArea: Optional[InternalControlArea] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InternalControlArea.CurrentScheduledInterchange',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class CurveData(Identity):
    '''
    Multi-purpose data points for defining a curve. The use of this generic
    class is discouraged if a more specific class can be used to specify the
    X and Y axis values along with their specific data types.
    '''

    xvalue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The data value of the X-axis variable, depending on the X-axis units.
            '''
        
        })
    '''
    The data value of the X-axis variable, depending on the X-axis units.
    '''
    
    y1value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The data value of the first Y-axis variable, depending on the Y-axis units.
            '''
        
        })
    '''
    The data value of the first Y-axis variable, depending on the Y-axis
    units.
    '''
    
    y2value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The data value of the second Y-axis variable (if present), depending on
            the Y-axis units.
            '''
        
        })
    '''
    The data value of the second Y-axis variable (if present), depending
    on the Y-axis units.
    '''
    
    y3value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The data value of the third Y-axis variable (if present), depending on
            the Y-axis units.
            '''
        
        })
    '''
    The data value of the third Y-axis variable (if present), depending
    on the Y-axis units.
    '''
    
    Curve: Optional[Curve] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Curve.CurveDatas',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The curve of this curve data point.
            '''
        
        })
    '''
    The curve of this curve data point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DefaultBidCurveData(CurveData):
    '''
    Curve data for default bid curve and startup cost curve.
    '''

    bidSegmentCalcType: Optional[ BidCalculationBasis ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of calculation basis used to define the default bid segment curve.
            '''
        
        })
    '''
    Type of calculation basis used to define the default bid segment curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CustomerNotification(Identity):
    '''
    Conditions for notifying the customer about the changes in the status of
    their service (e.g., outage restore, estimated restoration time, tariff
    or service level change, etc.)
    '''

    contactType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of contact (e.g., phone, email, etc.).
            '''
        
        })
    '''
    Type of contact (e.g., phone, email, etc.).
    '''
    
    contactValue: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Value of contact type (e.g., phone number, email address, etc.).
            '''
        
        })
    '''
    Value of contact type (e.g., phone number, email address, etc.).
    '''
    
    earliestDateTimeToCall: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Earliest date time to call the customer.
            '''
        
        })
    '''
    Earliest date time to call the customer.
    '''
    
    latestDateTimeToCall: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Latest date time to call the customer.
            '''
        
        })
    '''
    Latest date time to call the customer.
    '''
    
    trigger: Optional[ NotificationTriggerKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Trigger for this notification.
            '''
        
        })
    '''
    Trigger for this notification.
    '''
    
    Customer: Optional[Customer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Customer.CustomerNotifications',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Customer requiring this notification.
            '''
        
        })
    '''
    Customer requiring this notification.
    '''
    
    Incident: Optional[Incident] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Incident.CustomerNotifications',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Incident as a subject of this customer notification.
            '''
        
        })
    '''
    Incident as a subject of this customer notification.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Customers'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class DCvoltageControl(Identity):
    '''
    DC voltage control used for voltage regulation.
    '''

    kivdc: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Integral gain of the DC voltage regulator (Kivdc).
            '''
        
        })
    '''
    Integral gain of the DC voltage regulator (Kivdc).
    '''
    
    kpvdc: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Proportional gain of the DC voltage regulator (Kpvdc).
            '''
        
        })
    '''
    Proportional gain of the DC voltage regulator (Kpvdc).
    '''
    
    vdcmax: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum DC voltage (Vdcmax).
            '''
        
        })
    '''
    Maximum DC voltage (Vdcmax).
    '''
    
    vdcmin: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum DC voltage (Vdcmin).
            '''
        
        })
    '''
    Minimum DC voltage (Vdcmin).
    '''
    
    Delay: Optional[Delay] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Delay.DCvoltageControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    VSCtype1: Optional[VSCtype1] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VSCtype1.DCvoltageControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'VSC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    Delay: Optional[Delay] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Delay.DCvoltageControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    VSCtype1: Optional[VSCtype1] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VSCtype1.DCvoltageControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class DERCurveData(Identity):
    '''
    The DER curve data class provides the nominal, maximum and minimum values
    for a DER Monitorable parameter for a series of time intervals defined
    by the DER DispatchSchedule.
    '''

    intervalNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The sequence number of a time interval defined by the DispatchSchedule.
            '''
        
        })
    '''
    The sequence number of a time interval defined by the DispatchSchedule.
    '''
    
    maxYValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum value of the DERMonitorableParameter during the time interval.
            '''
        
        })
    '''
    The maximum value of the DERMonitorableParameter during the time interval.
    '''
    
    minYValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum value of the DERMonitorableParameter during the time interval.
            '''
        
        })
    '''
    The minimum value of the DERMonitorableParameter during the time interval.
    '''
    
    nominalYValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The nominal value of the DERMonitorableParameter during the time interval.
            '''
        
        })
    '''
    The nominal value of the DERMonitorableParameter during the time interval.
    '''
    
    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The start time of the interval
            '''
        
        })
    '''
    The start time of the interval
    '''
    
    DERMonitorableParameter: Optional[DERMonitorableParameter] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'DERMonitorableParameter.DERCurveData',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The DER monitorable parameter for which a time dependent curve has been
            created.
            '''
        
        })
    '''
    The DER monitorable parameter for which a time dependent curve has
    been created.
    '''
    
    DispatchSchedule: Optional[DispatchSchedule] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DispatchSchedule.DERCurveData',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The schedule used for dispatching or forecasting the values of DER monitorable
            parameters over time.
            '''
        
        })
    '''
    The schedule used for dispatching or forecasting the values of DER
    monitorable parameters over time.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DER'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    DERMonitorableParameter: Optional[DERMonitorableParameter] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERMonitorableParameter.DERCurveData',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The DER monitorable parameter for which a time dependent curve has been
            created.
            '''
        
        })
    '''
    The DER monitorable parameter for which a time dependent curve has
    been created.
    '''
    
@dataclass(repr=False)
class DERFunction(Identity):
    '''
    Specifies the list of functions that are supported.
    '''

    connectDisconnect: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set to TRUE, the connect/disconnect function is supported.
            '''
        
        })
    '''
    If set to TRUE, the connect/disconnect function is supported.
    '''
    
    frequencyWattCurveFunction: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    maxRealPowerLimiting: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set to TRUE, the maxRealPowerLimiting function is supported.
            '''
        
        })
    '''
    If set to TRUE, the maxRealPowerLimiting function is supported.
    '''
    
    rampRateControl: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set to TRUE, the rampRateControl function is supported.
            '''
        
        })
    '''
    If set to TRUE, the rampRateControl function is supported.
    '''
    
    reactivePowerDispatch: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set to TRUE, the reactivePowerDispatch function is supported.
            '''
        
        })
    '''
    If set to TRUE, the reactivePowerDispatch function is supported.
    '''
    
    realPowerDispatch: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set to TRUE, the realPowerDispatch function is supported.
            '''
        
        })
    '''
    If set to TRUE, the realPowerDispatch function is supported.
    '''
    
    voltageRegulation: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set to TRUE, the voltageRegulation function is supported.
            '''
        
        })
    '''
    If set to TRUE, the voltageRegulation function is supported.
    '''
    
    voltVarCurveFunction: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set to TRUE, the voltVARCurveFunction is supported.
            '''
        
        })
    '''
    If set to TRUE, the voltVARCurveFunction is supported.
    '''
    
    voltWattCurveFunction: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set to TRUE, the voltWattCurveFunction is supported.
            '''
        
        })
    '''
    If set to TRUE, the voltWattCurveFunction is supported.
    '''
    
    EndDeviceGroup: Optional[EndDeviceGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EndDeviceGroup.DER_Function',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The DER Group supporting the DER functions.
            '''
        
        })
    '''
    The DER Group supporting the DER functions.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DER'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    EndDeviceGroup: Optional[EndDeviceGroup] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EndDeviceGroup.DERFunction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The DER Group supporting the DER functions.
            '''
        
        })
    '''
    The DER Group supporting the DER functions.
    '''
    
@dataclass(repr=False)
class DERMonitorableParameter(Identity):
    '''
    To define the DER monitorable parameters that will be forecasted and dispatched
    for a DER Group. Each parameter is represented as a Y Value at a point
    in time or on a curve as a function of time, which is represented on the
    X axis.
    '''

    yUnitInstalledMax: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum value of the DERMonitorableParameter based on the installed
            capacity.
            '''
        
        })
    '''
    The maximum value of the DERMonitorableParameter based on the installed
    capacity.
    '''
    
    yUnitInstalledMin: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum value of the DERMonitorableParameter based on the installed
            capacity.
            '''
        
        })
    '''
    The minimum value of the DERMonitorableParameter based on the installed
    capacity.
    '''
    
    DERParameter: Optional[ DERParameterKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Defines the specific engineering value being forecasted or dispatched.
            '''
        
        })
    '''
    Defines the specific engineering value being forecasted or dispatched.
    '''
    
    flowDirection: Optional[ FlowDirectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of flow direction for reading/measured values proper to some commodities
            such as, for example, energy, power, demand.
            '''
        
        })
    '''
    Kind of flow direction for reading/measured values proper to some commodities
    such as, for example, energy, power, demand.
    '''
    
    yMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The UnitMultiplier that is applied to the DERMonitorableParameter.
            '''
        
        })
    '''
    The UnitMultiplier that is applied to the DERMonitorableParameter.
    '''
    
    yUnit: Optional[ DERUnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The DERUnitSymbol that is applied to the DERMonitorableParameter
            '''
        
        })
    '''
    The DERUnitSymbol that is applied to the DERMonitorableParameter
    '''
    
    DERCurveData: Optional[DERCurveData] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERCurveData.DERMonitorableParameter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the time dependent curve for a DER monitorable parameter
            '''
        
        })
    '''
    Specifies the time dependent curve for a DER monitorable parameter
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DER'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    DERCurveData: Optional[DERCurveData] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERCurveData.DERMonitorableParameter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Specifies the time dependent curve for a DER monitorable parameter
            '''
        
        })
    '''
    Specifies the time dependent curve for a DER monitorable parameter
    '''
    
    DispatchSchedule: list[DispatchSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DispatchSchedule.DERMonitorableParameter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The schedule used for dispatching or forecasting the values of DER monitorable
            parameters over time.
            '''
        
        })
    '''
    The schedule used for dispatching or forecasting the values of DER
    monitorable parameters over time.
    '''
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class DataSet(Identity):
    '''
    A generic container of a version of instance data. The MRID can be used
    in an audit trail, not in reusable script intended to work with new versions
    of data.
    A dataset could be serialized multiple times and in multiple technologies,
    yet retain the same identity.
    '''

    mRID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Master resource identifier issued by a model authority. The mRID is unique
            within an exchange context. Global uniqueness is easily achieved by using
            a UUID, as specified in RFC 4122, for the mRID. The use of UUID is strongly
            recommended.
            For CIMXML data files in RDF syntax conforming to IEC 61970-552 Edition
            1, the mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
            object elements.
            '''
        
        })
    '''
    Master resource identifier issued by a model authority. The mRID is
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in RFC 4122, for the mRID. The use of
    UUID is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552 Edition
    1, the mRID is mapped to rdf:ID or rdf:about attributes that identify
    CIM object elements.
    '''
    
    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''
        
        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''
    
    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The name is any free human readable and possibly non unique text naming
            the object.
            '''
        
        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''
    
    AlternateModel: Optional[AlternateModel] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AlternateModel.Dataset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The alternate model using the data.
            '''
        
        })
    '''
    The alternate model using the data.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    AlternateModel: Optional[AlternateModel] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AlternateModel.Dataset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The alternate model using the data.
            '''
        
        })
    '''
    The alternate model using the data.
    '''
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class ChangeSet(DataSet):
    '''
    Describes a set of changes that can be applied in different situations.
    A given registered target object MRID may only be referenced once by the
    contained change set members.
    '''

    NMProjectStage: Optional[NetworkModelProjectStage] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NetworkModelProjectStage.ChangeSets',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ChangeSetMember: list[ChangeSetMember] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ChangeSetMember.Changeset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Data objects contained in the dataset.
            '''
        
        })
    '''
    Data objects contained in the dataset.
    '''
    
    IncrementalDatasetArg: list[IncrementalDatasetArg] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IncrementalDatasetArg.IncrementalDataset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    NetworkModelProjectChangeVersion: list[NetworkModelProjectChangeVersion] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NetworkModelProjectChangeVersion.ChangeSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The project of the details of model changes.
            '''
        
        })
    '''
    The project of the details of model changes.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class InstanceSet(DataSet):
    '''
    Instance of a version of a model part. This corresponds to a payload of
    instance data.
    '''

    DatasetArg: list[DatasetArg] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DatasetArg.Dataset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The role of a dataset in the context of an operation.
            '''
        
        })
    '''
    The role of a dataset in the context of an operation.
    '''
    
    InstanceSetMember: list[IdentifiedObject] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IdentifiedObject.InstanceSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Data objects contained in the dataset.
            '''
        
        })
    '''
    Data objects contained in the dataset.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DateAndOrTime(Identity):
    '''
    The date and/or the time.
    '''

    date: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date as "yyyy-mm-dd", which conforms with ISO 8601
            '''
        
        })
    '''
    Date as "yyyy-mm-dd", which conforms with ISO 8601
    '''
    
    time: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time as "hh:mm:ss.sssZ", which conforms with ISO 8601.
            '''
        
        })
    '''
    Time as "hh:mm:ss.sssZ", which conforms with ISO 8601.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketManagement'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class Delay(Identity):
    '''
    All the measurements are filtered by a first lag element with a time constant
    TM.
    '''

    tm: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time constant.
            '''
        
        })
    '''
    Time constant.
    '''
    
    BlockingFunction: Optional[BlockingFunction] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BlockingFunction.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    DCvoltageControl: Optional[DCvoltageControl] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCvoltageControl.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Pcontrol: Optional[Pcontrol] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Pcontrol.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PFmode: Optional[PFmode] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PFmode.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Qlimiter: Optional[Qlimiter] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Qlimiter.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Qmode: Optional[Qmode] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Qmode.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Qregulator: Optional[Qregulator] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Qregulator.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Umode: Optional[Umode] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Umode.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfHVDCDynamics'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    BlockingFunction: Optional[BlockingFunction] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BlockingFunction.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    DCvoltageControl: Optional[DCvoltageControl] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCvoltageControl.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PFmode: Optional[PFmode] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PFmode.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Pcontrol: Optional[Pcontrol] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Pcontrol.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Qlimiter: Optional[Qlimiter] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Qlimiter.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Qmode: Optional[Qmode] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Qmode.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Qregulator: Optional[Qregulator] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Qregulator.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Umode: Optional[Umode] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Umode.Delay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class DiagramObjectGluePoint(Identity):
    '''
    This is used for grouping diagram object points from different diagram
    objects that are considered to be glued together in a diagram even if they
    are not at the exact same coordinates.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DiagramLayout'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    DiagramObjectPoints: list[DiagramObjectPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObjectPoint.DiagramObjectGluePoint',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A diagram object glue point is associated with 2 or more object points
            that are considered to be 'glued' together.
            '''
        
        })
    '''
    A diagram object glue point is associated with 2 or more object points
    that are considered to be 'glued' together.
    '''
    
@dataclass(repr=False)
class DiagramObjectPoint(Identity):
    '''
    A point in a given space defined by 3 coordinates and associated to a diagram
    object. The coordinates may be positive or negative as the origin does
    not have to be in the corner of a diagram.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The sequence position of the point, used for defining the order of points
            for diagram objects acting as a polyline or polygon with more than one
            point. The attribute shall be a positive value.
            '''
        
        })
    '''
    The sequence position of the point, used for defining the order of
    points for diagram objects acting as a polyline or polygon with more
    than one point. The attribute shall be a positive value.
    '''
    
    xPosition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The X coordinate of this point.
            '''
        
        })
    '''
    The X coordinate of this point.
    '''
    
    yPosition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Y coordinate of this point.
            '''
        
        })
    '''
    The Y coordinate of this point.
    '''
    
    zPosition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Z coordinate of this point.
            '''
        
        })
    '''
    The Z coordinate of this point.
    '''
    
    DiagramObject: Optional[DiagramObject] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'DiagramObject.DiagramObjectPoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The diagram object with which the points are associated.
            '''
        
        })
    '''
    The diagram object with which the points are associated.
    '''
    
    DiagramObjectGluePoint: Optional[DiagramObjectGluePoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiagramObjectGluePoint.DiagramObjectPoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The 'glue' point to which this point is associated.
            '''
        
        })
    '''
    The 'glue' point to which this point is associated.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DiagramLayout'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DifferentialModel(Identity):
    '''
    A set of statements describing the changes in the network model. The statement
    is defined in the incremental model.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'NetworkModelProjects'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DispatchSchedule(Identity):
    '''
    Specifies the characteristics of the time schedule over which DERMonitorableParameters
    are dispatched.
    '''

    numberOfIntervals: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Used to specify the number of intervals when requesting a forecast or a
            dispatch.
            '''
        
        })
    '''
    Used to specify the number of intervals when requesting a forecast
    or a dispatch.
    '''
    
    startTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The start time of the first interval in the dispatch schedule
            '''
        
        })
    '''
    The start time of the first interval in the dispatch schedule
    '''
    
    timeIntervalDuration: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The length of time for each interval in the dispatch schedule.
            '''
        
        })
    '''
    The length of time for each interval in the dispatch schedule.
    '''
    
    confidence: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A value set by the system, function, algorithm or person creating a prediction
            as to how accurate the prediction is.
            '''
        
        })
    '''
    A value set by the system, function, algorithm or person creating a
    prediction as to how accurate the prediction is.
    '''
    
    curveStyleKind: Optional[ CurveStyle ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Used to specify whether the values over an interval are constant (constantYValue)
            or linearly interpolated (straightLineYValues)
            '''
        
        })
    '''
    Used to specify whether the values over an interval are constant (constantYValue)
    or linearly interpolated (straightLineYValues)
    '''
    
    timeIntervalUnit: Optional[ TimeIntervalKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit of measure for the time axis of the dispatch schedule.
            '''
        
        })
    '''
    The unit of measure for the time axis of the dispatch schedule.
    '''
    
    DERMonitorableParameter: Optional[DERMonitorableParameter] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'DERMonitorableParameter.DispatchSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The DER monitorable parameter included in the DER dispatch schedule.
            '''
        
        })
    '''
    The DER monitorable parameter included in the DER dispatch schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DER'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    DERCurveData: list[DERCurveData] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DERCurveData.DispatchSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Specifies the time dependent curve for a DER monitorable parameter in the
            DER dispatch schedule.
            '''
        
        })
    '''
    Specifies the time dependent curve for a DER monitorable parameter
    in the DER dispatch schedule.
    '''
    
@dataclass(repr=False)
class DistributionFactorSet(Identity):
    '''
    A containing class that groups all the distribution factors within a market.
    This is calculated daily for DA factors and hourly for RT factors.
    '''

    intervalEndTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The end of the time interval for which requirement is defined.
            '''
        
        })
    '''
    The end of the time interval for which requirement is defined.
    '''
    
    intervalStartTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The start of the time interval for which requirement is defined.
            '''
        
        })
    '''
    The start of the time interval for which requirement is defined.
    '''
    
    marketType: Optional[ MarketType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Market type.
            '''
        
        })
    '''
    Market type.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DopInstruction(Identity):
    '''
    Provides the necessary information (on a resource basis) to capture the
    Dispatch Operating Point (DOP) results on a Dispatch interval. This information
    is only relevant to the RT interval market.
    '''

    plotPriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A value used to establish priority of the DOP when plotting. This is only
            applicable when two DOPs exist for the same time, but with different MW
            values. E.g. when indicating a step in the curve. Its used to determine
            if the curve steps up or down.
            '''
        
        })
    '''
    A value used to establish priority of the DOP when plotting. This is
    only applicable when two DOPs exist for the same time, but with different
    MW values. E.g. when indicating a step in the curve. Its used to determine
    if the curve steps up or down.
    '''
    
    timestampDOP: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            DOP time stamp
            '''
        
        })
    '''
    DOP time stamp
    '''
    
    updateTimeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    updateUser: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    mwDOP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Dispatched Operating Point (MW)
            '''
        
        })
    '''
    Dispatched Operating Point (MW)
    '''
    
    runIndicatorDOP: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indication of DOP validity.
            Shows the DOP is calculated from the latest run (YES). A NO indicator shows
            that the DOP is copied from a previous execution.
            Up to 2 intervals can be missed.
            '''
        
        })
    '''
    Indication of DOP validity.
    Shows the DOP is calculated from the latest run (YES). A NO indicator
    shows that the DOP is copied from a previous execution.
    Up to 2 intervals can be missed.
    '''
    
    updateType: Optional[ MQSCHGType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredResouce: Optional[RegisteredResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredResource.DopInstruction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DotInstruction(Identity):
    '''
    Provides the necessary information (on a resource basis) to capture the
    Dispatch Operating Target (DOT) results on a Dispatch interval. This information
    is only relevant to the RT interval market.
    '''

    actualRampRate: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Actual ramp rate.
            '''
        
        })
    '''
    Actual ramp rate.
    '''
    
    DOT: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Dispatch operating target value.
            '''
        
        })
    '''
    Dispatch operating target value.
    '''
    
    economicMaxOverride: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Economic Max Limit override for unit, this value is null, if it is not,
            this value overrides the Energy column value.
            Allows dispatcher to override the unit's energy value.
            '''
        
        })
    '''
    Economic Max Limit override for unit, this value is null, if it is
    not, this value overrides the Energy column value.
    Allows dispatcher to override the unit's energy value.
    '''
    
    expectedEnergy: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Expected energy.
            '''
        
        })
    '''
    Expected energy.
    '''
    
    generatorPerformanceDegree: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Degree of Generator Performance (DGP) used for the unit. Measure of
            how a generator responds to raise /lower signals. Calculated every five
            minutes.
            '''
        
        })
    '''
    The Degree of Generator Performance (DGP) used for the unit. Measure
    of how a generator responds to raise /lower signals. Calculated every
    five minutes.
    '''
    
    hourAheadSchedEnergy: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            HASP results.
            '''
        
        })
    '''
    HASP results.
    '''
    
    hourlySchedule: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Hourly Schedule (DA Energy Schedule).
            '''
        
        })
    '''
    Hourly Schedule (DA Energy Schedule).
    '''
    
    instructionTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The date/time for the instruction.
            '''
        
        })
    '''
    The date/time for the instruction.
    '''
    
    maximumEmergencyInd: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if maximum emergency limit activated; false otherwise. If unit is
            requested to move up to its max emergency limit., this flag is set to true.
            '''
        
        })
    '''
    True if maximum emergency limit activated; false otherwise. If unit
    is requested to move up to its max emergency limit., this flag is set
    to true.
    '''
    
    meterLoadFollowing: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Meter Sub System Load Following.
            '''
        
        })
    '''
    Meter Sub System Load Following.
    '''
    
    nonRampRestrictedMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Desired MW that is not ramp restricted. If no ramp rate limit existed for
            the unit, this is the MW value tha t the unit was requested to move to.
            '''
        
        })
    '''
    Desired MW that is not ramp restricted. If no ramp rate limit existed
    for the unit, this is the MW value tha t the unit was requested to
    move to.
    '''
    
    nonSpinReserve: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Non Spin Reserve used to procure energy.
            '''
        
        })
    '''
    Non Spin Reserve used to procure energy.
    '''
    
    previousDOTTimeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Timestamp when the previous DOT value was issued.
            '''
        
        })
    '''
    Timestamp when the previous DOT value was issued.
    '''
    
    rampRateLimit: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The ramp rate limit for the unit in MWs per minute. Participant bidding
            data.
            '''
        
        })
    '''
    The ramp rate limit for the unit in MWs per minute. Participant bidding
    data.
    '''
    
    spinReserve: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Spin Reserve used to procure energy.
            '''
        
        })
    '''
    Spin Reserve used to procure energy.
    '''
    
    standardRampEnergy: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Standard ramping energy (MWH).
            '''
        
        })
    '''
    Standard ramping energy (MWH).
    '''
    
    supplementalEnergy: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Supplemental Energy procure by Real Time Dispatch.
            '''
        
        })
    '''
    Supplemental Energy procure by Real Time Dispatch.
    '''
    
    unitStatus: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Output results from the case identifying the reason the unit was committed
            by the software.
            '''
        
        })
    '''
    Output results from the case identifying the reason the unit was committed
    by the software.
    '''
    
    compliantIndicator: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag indicating whether or not the resource was in compliance with the
            instruction (plus/minus 10%).
            Directs if a unit is allowed to set the price (ex-post pricing).
            '''
        
        })
    '''
    Flag indicating whether or not the resource was in compliance with
    the instruction (plus/minus 10%).
    Directs if a unit is allowed to set the price (ex-post pricing).
    '''
    
    regulationStatus: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Regulation Status (Yes/No).
            '''
        
        })
    '''
    Regulation Status (Yes/No).
    '''
    
    RegisteredResource: Optional[RegisteredResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredResource.DotInstruction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EndDeviceAction(Identity):
    '''
    Action/command performed by an end device on a device other than the end
    device.
    '''

    command: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Command text.
            '''
        
        })
    '''
    Command text.
    '''
    
    durationIndefinite: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if the action of this control is indefinite.
            '''
        
        })
    '''
    True if the action of this control is indefinite.
    '''
    
    startDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Start date and time for action of this control.
            '''
        
        })
    '''
    Start date and time for action of this control.
    '''
    
    duration: Optional[ float | Minutes ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Amount of time the action of this control is to remain active.
            '''
        
        })
    '''
    Amount of time the action of this control is to remain active.
    '''
    
    EndDeviceControl: Optional[EndDeviceControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EndDeviceControl.EndDeviceAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            End device control issuing this end device action.
            '''
        
        })
    '''
    End device control issuing this end device action.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    EndDeviceControl: Optional[EndDeviceControl] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EndDeviceControl.EndDeviceAction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            End device control issuing this end device action.
            '''
        
        })
    '''
    End device control issuing this end device action.
    '''
    
@dataclass(repr=False)
class PanDemandResponse(EndDeviceAction):
    '''
    PAN control used to issue action/command to PAN devices during a demand
    response/load control event.
    '''

    cancelControlMode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Encoding of cancel control.
            '''
        
        })
    '''
    Encoding of cancel control.
    '''
    
    cancelDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Timestamp when a canceling of the event is scheduled to start.
            '''
        
        })
    '''
    Timestamp when a canceling of the event is scheduled to start.
    '''
    
    cancelNow: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, a canceling of the event should start immediately.
            '''
        
        })
    '''
    If true, a canceling of the event should start immediately.
    '''
    
    criticalityLevel: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Level of criticality for the action of this control. The action taken by
            load control devices for an event can be solely based on this value, or
            in combination with other load control event fields supported by the device.
            '''
        
        })
    '''
    Level of criticality for the action of this control. The action taken
    by load control devices for an event can be solely based on this value,
    or in combination with other load control event fields supported by
    the device.
    '''
    
    enrollmentGroup: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Provides a mechanism to direct load control actions to groups of PAN devices.
            It can be used in conjunction with the PAN device types.
            '''
        
        })
    '''
    Provides a mechanism to direct load control actions to groups of PAN
    devices. It can be used in conjunction with the PAN device types.
    '''
    
    avgLoadAdjustment: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Used to define a maximum energy usage limit as a percentage of the client
            implementations specific average energy usage. The load adjustment percentage
            is added to 100% creating a percentage limit applied to the client implementations
            specific average energy usage. A -10% load adjustment percentage will establish
            an energy usage limit equal to 90% of the client implementations specific
            average energy usage. Each load adjustment percentage is referenced to
            the client implementations specific average energy usage. There are no
            cumulative effects.
            The range of this field is -100% to +100% with a resolution of 1. A -100%
            value equals a total load shed. A +100% value will limit the energy usage
            to the client implementations specific average energy usage.
            '''
        
        })
    '''
    Used to define a maximum energy usage limit as a percentage of the
    client implementations specific average energy usage. The load adjustment
    percentage is added to 100% creating a percentage limit applied to
    the client implementations specific average energy usage. A -10% load
    adjustment percentage will establish an energy usage limit equal to
    90% of the client implementations specific average energy usage. Each
    load adjustment percentage is referenced to the client implementations
    specific average energy usage. There are no cumulative effects.
    The range of this field is -100% to +100% with a resolution of 1. A
    -100% value equals a total load shed. A +100% value will limit the
    energy usage to the client implementations specific average energy
    usage.
    '''
    
    coolingOffset: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Requested offset to apply to the normal cooling setpoint at the time of
            the start of the event. It represents a temperature change that will be
            applied to the associated cooling set point. The temperature offsets will
            be calculated per the local temperature in the thermostat. The calculated
            temperature will be interpreted as the number of degrees to be added to
            the cooling set point. Sequential demand response events are not cumulative.
            The offset shall be applied to the normal setpoint.
            '''
        
        })
    '''
    Requested offset to apply to the normal cooling setpoint at the time
    of the start of the event. It represents a temperature change that
    will be applied to the associated cooling set point. The temperature
    offsets will be calculated per the local temperature in the thermostat.
    The calculated temperature will be interpreted as the number of degrees
    to be added to the cooling set point. Sequential demand response events
    are not cumulative. The offset shall be applied to the normal setpoint.
    '''
    
    coolingSetpoint: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Requested cooling set point. Temperature set point is typically defined
            and calculated based on local temperature.
            '''
        
        })
    '''
    Requested cooling set point. Temperature set point is typically defined
    and calculated based on local temperature.
    '''
    
    dutyCycle: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum "on" state duty cycle as a percentage of time. For example, if
            the value is 80, the device would be in an "on" state for 80% of the time
            for the duration of the action.
            '''
        
        })
    '''
    Maximum "on" state duty cycle as a percentage of time. For example,
    if the value is 80, the device would be in an "on" state for 80% of
    the time for the duration of the action.
    '''
    
    heatingOffset: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Requested offset to apply to the normal heating setpoint at the time of
            the start of the event. It represents a temperature change that will be
            applied to the associated heating set point. The temperature offsets will
            be calculated per the local temperature in the thermostat. The calculated
            temperature will be interpreted as the number of degrees to be subtracted
            from the heating set point. Sequential demand response events are not cumulative.
            The offset shall be applied to the normal setpoint.
            '''
        
        })
    '''
    Requested offset to apply to the normal heating setpoint at the time
    of the start of the event. It represents a temperature change that
    will be applied to the associated heating set point. The temperature
    offsets will be calculated per the local temperature in the thermostat.
    The calculated temperature will be interpreted as the number of degrees
    to be subtracted from the heating set point. Sequential demand response
    events are not cumulative. The offset shall be applied to the normal
    setpoint.
    '''
    
    heatingSetpoint: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Requested heating set point. Temperature set point is typically defined
            and calculated based on local temperature.
            '''
        
        })
    '''
    Requested heating set point. Temperature set point is typically defined
    and calculated based on local temperature.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PanDisplay(EndDeviceAction):
    '''
    PAN action/command used to issue the displaying of text messages on PAN
    devices.
    '''

    confirmationRequired: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, the requesting entity (e.g. retail electric provider) requires
            confirmation of the successful display of the text message.
            '''
        
        })
    '''
    If true, the requesting entity (e.g. retail electric provider) requires
    confirmation of the successful display of the text message.
    '''
    
    priority: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Priority associated with the text message to be displayed.
            '''
        
        })
    '''
    Priority associated with the text message to be displayed.
    '''
    
    textMessage: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Text to be displayed by a PAN device.
            '''
        
        })
    '''
    Text to be displayed by a PAN device.
    '''
    
    transmissionMode: Optional[ TransmissionModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transmission mode to be used for this PAN display control.
            '''
        
        })
    '''
    Transmission mode to be used for this PAN display control.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PanPricing(EndDeviceAction):
    '''
    PAN action/command used to issue pricing information to a PAN device.
    '''

    providerID: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Unique identifier for the commodity provider.
            '''
        
        })
    '''
    Unique identifier for the commodity provider.
    '''
    
    PanPricingDetails: list[PanPricingDetail] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PanPricingDetail.PanPricing',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All pricing details issued by this PAN pricing command/action.
            '''
        
        })
    '''
    All pricing details issued by this PAN pricing command/action.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EndDeviceEventDetail(Identity):
    '''
    Name-value pair, specific to end device events.
    '''

    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Name.
            '''
        
        })
    '''
    Name.
    '''
    
    EndDeviceEvent: Optional[EndDeviceEvent] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EndDeviceEvent.EndDeviceEventDetails',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            End device owning this detail.
            '''
        
        })
    '''
    End device owning this detail.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class EnergyPriceCurve(Identity):
    '''
    Relationship between a price in $(or other monetary unit) /hour (Y-axis)
    and a MW value (X-axis).
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    FTRs: list[FTR] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FTR.EnergyPriceCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class EnvironmentalLocationType(Identity):
    '''
    Type of environmental location. Used when an environmental alert or phenomenon
    has multiple locations associated with it.
    '''

    kind: Optional[ LocationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The kind of location. Typical values might be center, extent, primary,
            secondary, etc.
            '''
        
        })
    '''
    The kind of location. Typical values might be center, extent, primary,
    secondary, etc.
    '''
    
    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.EnvironmentalLocationKind',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Location of this instance of ths kind of environmental location.
            '''
        
        })
    '''
    Location of this instance of ths kind of environmental location.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnvironmentalPhenomenon(Identity):
    '''
    The actual or forecast characteristics of an environmental phenomenon at
    a specific point in time (or during a specific time interval) that may
    have both a center and area/line location.
    '''

    EnvironmentalInformation: Optional[EnvironmentalInformation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnvironmentalInformation.EnvironmentalPhenomenon',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The forecast or observation of which this phenomenon description is a part.
            '''
        
        })
    '''
    The forecast or observation of which this phenomenon description is
    a part.
    '''
    
    PhenomenonClassification: Optional[PhenomenonClassification] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhenomenonClassification.EnvironmentalPhenomenon',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The classification of this phenomenon.
            '''
        
        })
    '''
    The classification of this phenomenon.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AtmosphericPhenomenon(EnvironmentalPhenomenon):
    '''
    An atmospheric phenomenon with a base and altitude providing the vertical
    coverage (combined with the Location to provide three dimensional space).
    '''

    direction: Optional[ float | Bearing ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The direction the phenomenon is moving.
            '''
        
        })
    '''
    The direction the phenomenon is moving.
    '''
    
    maxCoverage: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum percentage coverage
            '''
        
        })
    '''
    The maximum percentage coverage
    '''
    
    minCoverage: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum percentage coverage
            '''
        
        })
    '''
    The minimum percentage coverage
    '''
    
    speed: Optional[ float | Speed ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The speed of the phenomenon
            '''
        
        })
    '''
    The speed of the phenomenon
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CloudCondition(AtmosphericPhenomenon):
    '''
    A classified cloud phenomenon with a type.
    '''

    kind: Optional[ CloudKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of the cloud as defined by the CloudKind enumeration.
            '''
        
        })
    '''
    The type of the cloud as defined by the CloudKind enumeration.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Cyclone(AtmosphericPhenomenon):
    '''
    A cyclone (or tropical cyclone), a rapidly-rotating storm system characterized
    by a low-pressure center, strong winds, and a spiral arrangement of thunderstorms
    that produce heavy rain.
    '''

    windForce: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Wind Force as classified on the Beaufort Scale (0-12) during the time interval.
            '''
        
        })
    '''
    Wind Force as classified on the Beaufort Scale (0-12) during the time
    interval.
    '''
    
    centralPressure: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The central pressure of the cyclone during the time interval.
            '''
        
        })
    '''
    The central pressure of the cyclone during the time interval.
    '''
    
    maxSurfaceWindSpeed: Optional[ float | Speed ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum surface wind speed of the cyclone during the time interval.
            '''
        
        })
    '''
    The maximum surface wind speed of the cyclone during the time interval.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Hurricane(Cyclone):
    '''
    A hurricane, a subtype of cyclone occurring in the North Atlantic Ocean
    or North-eastern Pacific Ocean whose intensity is measured using the Saffir-Simpson
    Hurricane Scale.
    '''

    category: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The hurricane's category during the time interval, using Saffir-Simpson
            Hurricane Wind Scale, a 1 to 5 rating based on a hurricane's sustained
            wind speed.
            '''
        
        })
    '''
    The hurricane's category during the time interval, using Saffir-Simpson
    Hurricane Wind Scale, a 1 to 5 rating based on a hurricane's sustained
    wind speed.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TropicalCycloneAustralia(Cyclone):
    '''
    A tropical cyclone, a subtype of cyclone that forms to the east of 90�E
    in the Southern Hemisphere whose intensity is measured by the Australian
    tropical cyclone intensity scale.
    '''

    category: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Strength of tropical cyclone during the time interval, based on Australian
            Bureau of Meteorology Category System where:
            1 - tropical cyclone, with typical gusts over flat land 90-125 km/h
            2 - tropical cyclone, with typical gusts over flat land 125-164 km/h
            3 - severe tropical cyclone, with typical gusts over flat land 165-224
            km/h
            4 - severe tropical cyclone, with typical gusts over flat land 225-279
            km/h
            5 - severe tropical cyclone, with typical gusts over flat land greater
            than 280 km/h.
            '''
        
        })
    '''
    Strength of tropical cyclone during the time interval, based on Australian
    Bureau of Meteorology Category System where:
    1 - tropical cyclone, with typical gusts over flat land 90-125 km/h
    2 - tropical cyclone, with typical gusts over flat land 125-164 km/h
    3 - severe tropical cyclone, with typical gusts over flat land 165-224
    km/h
    4 - severe tropical cyclone, with typical gusts over flat land 225-279
    km/h
    5 - severe tropical cyclone, with typical gusts over flat land greater
    than 280 km/h.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Tornado(AtmosphericPhenomenon):
    '''
    A tornado, a violent destructive whirling wind accompanied by a funnel-shaped
    cloud that progresses in a narrow path over the land.
    '''

    fScale: Optional[ FScale ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fujita scale (referred to as EF-scale starting in 2007) for the tornado.
            '''
        
        })
    '''
    Fujita scale (referred to as EF-scale starting in 2007) for the tornado.
    '''
    
    width: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Width of the tornado during the time interval.
            '''
        
        })
    '''
    Width of the tornado during the time interval.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class VolcanicAshCloud(AtmosphericPhenomenon):
    '''
    An ash cloud formed as a result of a volcanic eruption.
    '''

    density: Optional[ float | ParticulateDensity ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Particulate density of the ash cloud during the time interval.
            '''
        
        })
    '''
    Particulate density of the ash cloud during the time interval.
    '''
    
    particleSize: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The diameter of the particles during the time interval.
            '''
        
        })
    '''
    The diameter of the particles during the time interval.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GeosphericPhenomenon(EnvironmentalPhenomenon):
    '''
    A geospheric phenomenon.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Earthquake(GeosphericPhenomenon):
    '''
    An earthquake.
    '''

    intensity: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The intensity of the earthquake as defined by the Modified Mercalli Intensity
            (MMI) scale. Possible values are 1-12, corresponding to I-XII.
            '''
        
        })
    '''
    The intensity of the earthquake as defined by the Modified Mercalli
    Intensity (MMI) scale. Possible values are 1-12, corresponding to I-XII.
    '''
    
    magnitude: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The magnitude of the earthquake as defined on the Moment Magnitude (M<sub>w</sub>)
            scale, which measures the size of earthquakes in terms of the energy released.
            Must be greater than zero.
            '''
        
        })
    '''
    The magnitude of the earthquake as defined on the Moment Magnitude
    (M<sub>w</sub>) scale, which measures the size of earthquakes in terms
    of the energy released. Must be greater than zero.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Fire(GeosphericPhenomenon):
    '''
    A fire, often uncontrolled, covering an area of land which typically contains
    combustible vegetation. Associated location information is assumed to describe
    the total area burned as of a specified time.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Landslide(GeosphericPhenomenon):
    '''
    A landslide, a large mass of rocks and earth that suddenly and quickly
    moves down the side of a mountain or hill.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LightningStrike(GeosphericPhenomenon):
    '''
    A cloud-to-ground lightning strike at a particular location.
    '''

    negativePolarity: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The polarity of the strike, with T meaning negative. About 90% of all lightning
            strokes are negative strokes, meaning that they were initiated by a large
            concentration of negative charge in the cloud-base; this tends to induce
            an area of positive charge on the ground.
            '''
        
        })
    '''
    The polarity of the strike, with T meaning negative. About 90% of all
    lightning strokes are negative strokes, meaning that they were initiated
    by a large concentration of negative charge in the cloud-base; this
    tends to induce an area of positive charge on the ground.
    '''
    
    errorEllipseConfidence: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Likelihood that strike fell within errorEllipse.
            '''
        
        })
    '''
    Likelihood that strike fell within errorEllipse.
    '''
    
    errorEllipseMajorSemiAxis: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Length of major semi-axis (longest radius) of the error ellipse.
            '''
        
        })
    '''
    Length of major semi-axis (longest radius) of the error ellipse.
    '''
    
    errorEllipseMinorSemiAxis: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Length of minor semi-axis (shortest radius) of the error ellipse.
            '''
        
        })
    '''
    Length of minor semi-axis (shortest radius) of the error ellipse.
    '''
    
    errorEllipseOrientation: Optional[ float | Bearing ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The orientation of the major semi- axis in degrees from True North.
            '''
        
        })
    '''
    The orientation of the major semi- axis in degrees from True North.
    '''
    
    peakAmplitude: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Peak current of strike.
            '''
        
        })
    '''
    Peak current of strike.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class HydrosphericPhenomenon(EnvironmentalPhenomenon):
    '''
    A hydrospheric phenomenon.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Flood(HydrosphericPhenomenon):
    '''
    A flood, an overflowing of a large amount of water beyond its normal confines,
    esp. over what is normally dry land.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Tsunami(HydrosphericPhenomenon):
    '''
    A tsunami (tidal wave), a long high sea wave caused by an earthquake, submarine
    landslide, or other disturbance.
    '''

    intensity: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Tsunami intensity on the Papadopoulos-Imamura tsunami intensity scale.
            Possible values are 1-12, corresponding to I-XII.
            '''
        
        })
    '''
    Tsunami intensity on the Papadopoulos-Imamura tsunami intensity scale.
    Possible values are 1-12, corresponding to I-XII.
    '''
    
    magnitude: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Tsunami magnitude in the Tsunami Magnitude Scale (Mt). Is greater than
            zero.
            '''
        
        })
    '''
    Tsunami magnitude in the Tsunami Magnitude Scale (Mt). Is greater than
    zero.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Whirlpool(HydrosphericPhenomenon):
    '''
    A whirlpool, a rapidly rotating mass of water in a river or sea into which
    objects may be drawn, typically caused by the meeting of conflicting currents.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SpacePhenomenon(EnvironmentalPhenomenon):
    '''
    An extra-terrestrial phenomenon.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MagneticStorm(SpacePhenomenon):
    '''
    A magnetic storm, a temporary disturbance of the earth's magnetic field,
    induced by radiation and streams of charged particles from the sun.
    '''

    changeDst: Optional[ float | MagneticField ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Change in the disturbance - storm time (Dst) index. The size of a geomagnetic
            storm is classified as:
            - moderate ( -50 nT &gt;minimum of Dst &gt; -100 nT)
            - intense (-100 nT &gt; minimum Dst &gt; -250 nT) or
            - super-storm ( minimum of Dst &lt; -250 nT).
            '''
        
        })
    '''
    Change in the disturbance - storm time (Dst) index. The size of a geomagnetic
    storm is classified as:
    - moderate ( -50 nT &gt;minimum of Dst &gt; -100 nT)
    - intense (-100 nT &gt; minimum Dst &gt; -250 nT) or
    - super-storm ( minimum of Dst &lt; -250 nT).
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EstimatedRestorationTime(Identity):
    '''
    The Estimated Restoration Time (ERT) for a single outage
    '''

    ert: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            estimated time the outage will be restored
            '''
        
        })
    '''
    estimated time the outage will be restored
    '''
    
    ertSource: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            defines the source that provided the ERT value.
            '''
        
        })
    '''
    defines the source that provided the ERT value.
    '''
    
    confidenceKind: Optional[ ERTConfidenceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            provides the confidence level that this ERT can be accomplished. This may
            be changed/updated as needed.
            '''
        
        })
    '''
    provides the confidence level that this ERT can be accomplished. This
    may be changed/updated as needed.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    Outage: list[Outage] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Outage.EstimatedRestorationTime',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The outage associated with the estimated time the power will be restored.
            '''
        
        })
    '''
    The outage associated with the estimated time the power will be restored.
    '''
    
@dataclass(repr=False)
class ExPostLossResults(Identity):
    '''
    Model results of ex-post calculation of MW losses. Summarizes loss in two
    categories losses on the the extra high voltage transmission and total
    losses. Calculated for each subcontrol area.
    '''

    ehvLossMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            EHV MW losses in the company
            Attribute Usage: Information purposes - Output of LPA engine.
            '''
        
        })
    '''
    EHV MW losses in the company
    Attribute Usage: Information purposes - Output of LPA engine.
    '''
    
    totalLossMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Total MW losses in the company
            Attribute Usage: Information purposes - Output of LPA engine.
            '''
        
        })
    '''
    Total MW losses in the company
    Attribute Usage: Information purposes - Output of LPA engine.
    '''
    
    ExPostLoss: Optional[ExPostLoss] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ExPostLoss.ExPostLossResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SubControlArea: Optional[SubControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubControlArea.ExPostLossResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ExPostMarketRegionResults(Identity):
    '''
    Model of expost calculation of cleared MW on a region basis. Includes cleared
    price.
    '''

    exPostClearedPrice: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ExPostMarketRegion: Optional[ExPostMarketRegion] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ExPostMarketRegion.ExPostMarketRegionResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MarketRegion: Optional[MarketRegion] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MarketRegion.ExPostMarketRegionResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    ExPostMarketRegion: Optional[ExPostMarketRegion] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ExPostMarketRegion.ExPostMarketRegionResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class ExPostPricingResults(Identity):
    '''
    Model of ex-post pricing of nodes. Includes LMP information, pnode based.
    '''

    congestLMP: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Congestion component of Location Marginal Price (LMP) in monetary units
            per MW; congestion component of the hourly LMP at a specific pricing node
            Attribute Usage: Result of the Security, Pricing, and Dispatch(SPD)/Simultaneous
            Feasibility Test(SFT) software and denotes the hourly congestion component
            of LMP for each pricing node.
            '''
        
        })
    '''
    Congestion component of Location Marginal Price (LMP) in monetary units
    per MW; congestion component of the hourly LMP at a specific pricing
    node
    Attribute Usage: Result of the Security, Pricing, and Dispatch(SPD)/Simultaneous
    Feasibility Test(SFT) software and denotes the hourly congestion component
    of LMP for each pricing node.
    '''
    
    lmp: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            5 min weighted average LMP; the Location Marginal Price of the Pnode for
            which price calculation is carried out.
            Attribute Usage: 5 min weighted average LMP to be displayed on UI
            '''
        
        })
    '''
    5 min weighted average LMP; the Location Marginal Price of the Pnode
    for which price calculation is carried out.
    Attribute Usage: 5 min weighted average LMP to be displayed on UI
    '''
    
    lossLMP: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Loss component of Location Marginal Price (LMP) in monetary units per MW;
            loss component of the hourly LMP at a specific pricing node
            Attribute Usage: Result of the Security, Pricing, and Dispatch(SPD)/Simultaneous
            Feasibility Test(SFT) software and denotes the hourly loss component of
            LMP for each pricing node.
            '''
        
        })
    '''
    Loss component of Location Marginal Price (LMP) in monetary units per
    MW; loss component of the hourly LMP at a specific pricing node
    Attribute Usage: Result of the Security, Pricing, and Dispatch(SPD)/Simultaneous
    Feasibility Test(SFT) software and denotes the hourly loss component
    of LMP for each pricing node.
    '''
    
    ExPostPricing: Optional[ExPostPricing] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ExPostPricing.ExPostResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Pnode: Optional[Pnode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Pnode.ExPostResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ExPostResourceResults(Identity):
    '''
    Model of ex-post pricing of resources contains components of LMPs: energy,
    congestion, loss. Resource based.
    '''

    congestionLMP: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            LMP component in USD (deprecated)
            '''
        
        })
    '''
    LMP component in USD (deprecated)
    '''
    
    desiredMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Desired output of unit
            '''
        
        })
    '''
    Desired output of unit
    '''
    
    dispatchRate: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Unit Dispatch rate from real time unit dispatch.
            '''
        
        })
    '''
    Unit Dispatch rate from real time unit dispatch.
    '''
    
    lmp: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            LMP (Local Marginal Price) in USD at the equipment (deprecated)
            '''
        
        })
    '''
    LMP (Local Marginal Price) in USD at the equipment (deprecated)
    '''
    
    lossLMP: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            loss lmp (deprecated)
            '''
        
        })
    '''
    loss lmp (deprecated)
    '''
    
    maxEconomicMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Economic Maximum MW
            '''
        
        })
    '''
    Economic Maximum MW
    '''
    
    minEconomicMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Economic Minimum MW
            '''
        
        })
    '''
    Economic Minimum MW
    '''
    
    resourceMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Current MW output of the equipment
            Attribute Usage: Information purposes - Information purposes - Output of
            LPA engine.
            '''
        
        })
    '''
    Current MW output of the equipment
    Attribute Usage: Information purposes - Information purposes - Output
    of LPA engine.
    '''
    
    status: Optional[ EquipmentStatusType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Status of equipment
            '''
        
        })
    '''
    Status of equipment
    '''
    
    ExPostResource: Optional[ExPostResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ExPostResource.ExPostResourceResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredResource: Optional[RegisteredResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredResource.ExPostResourceResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ExpectedEnergy(Identity):
    '''
    Model Expected Energy from Market Clearing, interval based.
    '''

    intervalStartTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    updateTimeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    updateUser: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketQualitySystem'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    ExpectedEnergyValues: list[ExpectedEnergyValues] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ExpectedEnergyValues.ExpectedEnergy',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class ExpectedEnergyValues(Identity):
    '''
    Model Expected Energy from Market Clearing.
    '''

    energyTypeCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    expectedMwh: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ExpectedEnergy: Optional[ExpectedEnergy] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ExpectedEnergy.ExpectedEnergyValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredResource: Optional[RegisteredResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredResource.ExpectedEnergyValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketQualitySystem'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FieldDispatchStep(Identity):
    '''
    Details of the step in the field dispatch history.
    '''

    occurredDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The date and time at which the dispatch status occurred.
            '''
        
        })
    '''
    The date and time at which the dispatch status occurred.
    '''
    
    remarks: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            freeform comments related to the dispatch to perform field work.
            '''
        
        })
    '''
    freeform comments related to the dispatch to perform field work.
    '''
    
    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The sequence number of the field dispatch step within the field dispatch
            history. Begins with 1 and increments up.
            '''
        
        })
    '''
    The sequence number of the field dispatch step within the field dispatch
    history. Begins with 1 and increments up.
    '''
    
    dispatchStatus: Optional[ CrewStatusKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The status of one or more crews dispatched to perform field work at one
            or more work sites
            '''
        
        })
    '''
    The status of one or more crews dispatched to perform field work at
    one or more work sites
    '''
    
    FieldDispatchHistory: Optional[FieldDispatchHistory] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'FieldDispatchHistory.FieldDispatchStep',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The dispatch history associated with the field dispatch step
            '''
        
        })
    '''
    The dispatch history associated with the field dispatch step
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class FiveMinAuxiliaryData(Identity):
    '''
    Models 5-Minutes Auxiliary Data.
    '''

    intervalStartTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    updateTimeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    updateUser: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketQualitySystem'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    AuxillaryValues: list[AuxiliaryValues] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AuxiliaryValues.FiveMinAuxillaryData',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class FlowDirection(Identity):
    '''
    The coded identification of the direction of energy flow.
    '''

    direction: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The coded identification of the direction of energy flow.
            '''
        
        })
    '''
    The coded identification of the direction of energy flow.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketManagement'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FlowgateRelief(Identity):
    '''
    IDC (Interchange Distribution Calulator) sends data for a TLR (Transmission
    Loading Relief).
    '''

    effectiveDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date/Time when record becomes effective
            Used to determine when a record becomes effective.
            '''
        
        })
    '''
    Date/Time when record becomes effective
    Used to determine when a record becomes effective.
    '''
    
    idcTargetMktFlow: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Energy Flow level that should be maintained according to the TLR rules
            as specified by the IDC.
            For Realtime Markets use in dispatch to control constraints under TLR and
            calculate unconstrained market flows
            '''
        
        })
    '''
    Energy Flow level that should be maintained according to the TLR rules
    as specified by the IDC.
    For Realtime Markets use in dispatch to control constraints under TLR
    and calculate unconstrained market flows
    '''
    
    terminateDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date/Time when record is no longer effective
            Used to determine when a record is no longer effective
            '''
        
        })
    '''
    Date/Time when record is no longer effective
    Used to determine when a record is no longer effective
    '''
    
    Flowgate: Optional[Flowgate] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Flowgate.FlowgateRelief',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FlowgateValue(Identity):
    '''
    Day Ahead, Network Native Load, Economic Dispatch, values used for calculation
    of Network Native Load (NNL) Determinator process.
    '''

    economicDispatchLimit: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Limit for Economic Dispatch priority 6 energy flow on the specified flowgate
            for the specified time period.
            '''
        
        })
    '''
    Limit for Economic Dispatch priority 6 energy flow on the specified
    flowgate for the specified time period.
    '''
    
    effectiveDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date/Time when record becomes effective
            Used to determine when a record becomes effective
            '''
        
        })
    '''
    Date/Time when record becomes effective
    Used to determine when a record becomes effective
    '''
    
    firmNetworkLimit: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Limit for firm flow on the specified flowgate for the specified time period.
            The amount of energy flow over a specifed flowgate due to generation in
            the market which can be classified as Firm Network priority.
            '''
        
        })
    '''
    Limit for firm flow on the specified flowgate for the specified time
    period. The amount of energy flow over a specifed flowgate due to generation
    in the market which can be classified as Firm Network priority.
    '''
    
    mktFlow: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The amount of energy flow over a specifed flowgate due to generation in
            the market.
            '''
        
        })
    '''
    The amount of energy flow over a specifed flowgate due to generation
    in the market.
    '''
    
    netFirmNetworkLimit: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Net Energy flow in flowgate for the associated FlowgatePartner
            '''
        
        })
    '''
    Net Energy flow in flowgate for the associated FlowgatePartner
    '''
    
    flowDirectionFlag: Optional[ FlowDirectionType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the direction of energy flow in the flowgate
            '''
        
        })
    '''
    Specifies the direction of energy flow in the flowgate
    '''
    
    Flowgate: Optional[Flowgate] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Flowgate.FlowgateValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    FlowgatePartner: Optional[FlowgatePartner] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FlowgatePartner.FlowgateValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    FlowgatePartner: Optional[FlowgatePartner] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FlowgatePartner.FlowgateValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class GasPrice(Identity):
    '''
    Price of gas in monetary units.
    '''

    gasPriceIndex: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The average natural gas price at a defined fuel region.
            '''
        
        })
    '''
    The average natural gas price at a defined fuel region.
    '''
    
    FuelRegion: Optional[FuelRegion] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'FuelRegion.GasPrice',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    FuelRegion: Optional[FuelRegion] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuelRegion.GasPrice',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class GenDistributionFactor(Identity):
    '''
    This class models the generation distribution factors. This class needs
    to be used along with the AggregatedPnode and the IndividualPnode to show
    the distribution of each individual party.
    '''

    factor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Used to calculate generation "participation" of an individual pnond in
            an AggregatePnode.
            '''
        
        })
    '''
    Used to calculate generation "participation" of an individual pnond
    in an AggregatePnode.
    '''
    
    AggregatedPnode: Optional[AggregatedPnode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AggregatedPnode.GenDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    IndividualPnode: Optional[IndividualPnode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IndividualPnode.GenDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    IndividualPnode: Optional[IndividualPnode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IndividualPnode.GenDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class GeneralClearingResults(Identity):
    '''
    Provides the adjusted load forecast value on a load forecast zone basis.
    '''

    totalLoad: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Amount of load in the control zone
            Attribute Usage: hourly load value for the specific area
            '''
        
        })
    '''
    Amount of load in the control zone
    Attribute Usage: hourly load value for the specific area
    '''
    
    totalNetInterchange: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Amount of interchange for the control zone
            Attribute Usage: hourly interchange value for the specific area
            '''
        
        })
    '''
    Amount of interchange for the control zone
    Attribute Usage: hourly interchange value for the specific area
    '''
    
    loadForecast: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Load Prediction/Forecast (MW), by Time Period (5', 10', 15')
            '''
        
        })
    '''
    Load Prediction/Forecast (MW), by Time Period (5', 10', 15')
    '''
    
    GeneralClearing: Optional[GeneralClearing] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneralClearing.GeneralClearingResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SubControlArea: Optional[SubControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubControlArea.GeneralClearingResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GeneratingUnitDynamicValues(Identity):
    '''
    Optimal Power Flow or State Estimator Unit Data for Operator Training Simulator.
    This is used for RealTime, Study and Maintenance Users.
    '''

    lossFactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Loss Factor
            '''
        
        })
    '''
    Loss Factor
    '''
    
    maximumMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum active power generation of the unit in MW
            '''
        
        })
    '''
    The maximum active power generation of the unit in MW
    '''
    
    minimumMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum active power generation of the unit in MW
            '''
        
        })
    '''
    The minimum active power generation of the unit in MW
    '''
    
    mVAR: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Unit reactive power generation in MVAR
            '''
        
        })
    '''
    Unit reactive power generation in MVAR
    '''
    
    mw: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Unit active power generation in MW
            '''
        
        })
    '''
    Unit active power generation in MW
    '''
    
    sensitivity: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Unit sencivity factor. The distribution factors (DFAX) for the unit
            '''
        
        })
    '''
    Unit sencivity factor. The distribution factors (DFAX) for the unit
    '''
    
    Flowgate: Optional[Flowgate] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Flowgate.GeneratingUnitDynamicValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MktGeneratingUnit: Optional[MktGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MktGeneratingUnit.GeneratingUnitDynamicValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GenericDataSetVersion(Identity):
    '''
    '''

    majorVersion: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The universal CIM version name describing a consistent set of packages.
            '''
        
        })
    '''
    The universal CIM version name describing a consistent set of packages.
    '''
    
    minorVersion: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Describe minor updates and error corrections.
            '''
        
        })
    '''
    Describe minor updates and error corrections.
    '''
    
    published: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The date when the complete CIM canonical model is published and made available
            for use,
            After the publication the major version and name space are updated.
            '''
        
        })
    '''
    The date when the complete CIM canonical model is published and made
    available for use,
    After the publication the major version and name space are updated.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class HVDCLookUpTable(Identity):
    '''
    '''

    input: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    output: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    sequence: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    functionKind: Optional[ LookUpTableFunctionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Qregulator: Optional[Qregulator] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Qregulator.HVDClookUpTable',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfHVDCDynamics'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IEC61968CIMVersion(Identity):
    '''
    IEC 61968 version number assigned to this UML model.
    '''

    date: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (const=2016-10-31) Form is YYYY-MM-DD for example for January 5, 2009 it
            is 2009-01-05.
            '''
        
        })
    '''
    (const=2016-10-31) Form is YYYY-MM-DD for example for January 5, 2009
    it is 2009-01-05.
    '''
    
    version: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (const=IEC61968CIM13v09) Form is IEC61968CIMXXvYY[a-z] where XX is the
            major CIM package version and the YY is the minor version. For example
            IEC61968CIM10v17a.
            The letter on the version number indicates the changes are due to National
            Committee comments.
            '''
        
        })
    '''
    (const=IEC61968CIM13v09) Form is IEC61968CIMXXvYY[a-z] where XX is
    the major CIM package version and the YY is the minor version. For
    example IEC61968CIM10v17a.
    The letter on the version number indicates the changes are due to National
    Committee comments.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'IEC61968'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IEC61970CIMVersion(Identity):
    '''
    This is the IEC 61970 CIM version number assigned to this UML model.
    '''

    date: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Form is YYYY-MM-DD for example for January 5, 2009 it is 2009-01-05.
            '''
        
        })
    '''
    Form is YYYY-MM-DD for example for January 5, 2009 it is 2009-01-05.
    '''
    
    version: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Form is IEC61970CIMXXvYY where XX is the major CIM package version and
            the YY is the minor version. For example IEC61970CIM13v18.
            '''
        
        })
    '''
    Form is IEC61970CIMXXvYY where XX is the major CIM package version
    and the YY is the minor version. For example IEC61970CIM13v18.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'IEC61970'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IEC62325CIMVersion(Identity):
    '''
    IEC 62325 version number assigned to this UML model.
    '''

    date: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Form is YYYY-MM-DD for example for January 5, 2009 it is 2009-01-05.
            '''
        
        })
    '''
    Form is YYYY-MM-DD for example for January 5, 2009 it is 2009-01-05.
    '''
    
    version: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Form is IEC62325CIMXXvYY where XX is the major CIM package version and
            the YY is the minor version. For example IEC62325CIM10v03.
            '''
        
        })
    '''
    Form is IEC62325CIMXXvYY where XX is the major CIM package version
    and the YY is the minor version. For example IEC62325CIM10v03.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'IEC62325'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IdcInverterControl(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'CSC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a root class to provide common identification for all classes needing
    identification and naming attributes.
    '''

    mRID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Master resource identifier issued by a model authority. The mRID is unique
            within an exchange context. Global uniqueness is easily achieved by using
            a UUID, as specified in RFC 4122, for the mRID. The use of UUID is strongly
            recommended.
            For CIMXML data files in RDF syntax conforming to IEC 61970-552, the mRID
            is mapped to rdf:ID or rdf:about attributes that identify CIM object elements.
            '''
        
        })
    '''
    Master resource identifier issued by a model authority. The mRID is
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in RFC 4122, for the mRID. The use of
    UUID is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552, the
    mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
    object elements.
    '''
    
    aliasName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The aliasName is free text human readable name of the object alternative
            to IdentifiedObject.name. It may be non unique and may not correlate to
            a naming hierarchy.
            The attribute aliasName is retained because of backwards compatibility
            between CIM relases. It is however recommended to replace aliasName with
            the Name class as aliasName is planned for retirement at a future time.
            '''
        
        })
    '''
    The aliasName is free text human readable name of the object alternative
    to IdentifiedObject.name. It may be non unique and may not correlate
    to a naming hierarchy.
    The attribute aliasName is retained because of backwards compatibility
    between CIM relases. It is however recommended to replace aliasName
    with the Name class as aliasName is planned for retirement at a future
    time.
    '''
    
    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''
        
        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''
    
    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The name is any free human readable and possibly non unique text naming
            the object.
            '''
        
        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''
    
    InstanceSet: Optional[InstanceSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'InstanceSet.InstanceSetMember',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Dataset containing the data objects.
            '''
        
        })
    '''
    Dataset containing the data objects.
    '''
    
    PropertiesCIMDataObject: Optional[ChangeSetMember] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ChangeSetMember.PropertiesObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The single CIM data object in the appropriate dataset context.
            '''
        
        })
    '''
    The single CIM data object in the appropriate dataset context.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    PropertiesCIMDataObject: Optional[ChangeSetMember] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ChangeSetMember.PropertiesObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The single CIM data object in the appropriate dataset context.
            '''
        
        })
    '''
    The single CIM data object in the appropriate dataset context.
    '''
    
    TargetingCIMDataObject: list[ChangeSetMember] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ChangeSetMember.TargetObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Data objects registered.
            '''
        
        })
    '''
    Data objects registered.
    '''
    
    DiagramObjects: list[DiagramObject] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObject.IdentifiedObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The diagram objects that are associated with the domain object.
            '''
        
        })
    '''
    The diagram objects that are associated with the domain object.
    '''
    
    Names: list[Name] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Name.IdentifiedObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All names of this identified object.
            '''
        
        })
    '''
    All names of this identified object.
    '''
    
@dataclass(repr=False)
class ACDCTerminal(IdentifiedObject):
    '''
    An electrical connection point (AC or DC) to a piece of conducting equipment.
    Terminals are connected at physical connection points called connectivity
    nodes.
    '''

    connected: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The connected status is related to a bus-branch model and the topological
            node to terminal relation. True implies the terminal is connected to the
            related topological node and false implies it is not.
            In a bus-branch model, the connected status is used to tell if equipment
            is disconnected without having to change the connectivity described by
            the topological node to terminal relation. A valid case is that conducting
            equipment can be connected in one end and open in the other. In particular
            for an AC line segment, where the reactive line charging can be significant,
            this is a relevant case.
            '''
        
        })
    '''
    The connected status is related to a bus-branch model and the topological
    node to terminal relation. True implies the terminal is connected to
    the related topological node and false implies it is not.
    In a bus-branch model, the connected status is used to tell if equipment
    is disconnected without having to change the connectivity described
    by the topological node to terminal relation. A valid case is that
    conducting equipment can be connected in one end and open in the other.
    In particular for an AC line segment, where the reactive line charging
    can be significant, this is a relevant case.
    '''
    
    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The orientation of the terminal connections for a multiple terminal conducting
            equipment. The sequence numbering starts with 1 and additional terminals
            should follow in increasing order. The first terminal is the "starting
            point" for a two terminal branch.
            '''
        
        })
    '''
    The orientation of the terminal connections for a multiple terminal
    conducting equipment. The sequence numbering starts with 1 and additional
    terminals should follow in increasing order. The first terminal is
    the "starting point" for a two terminal branch.
    '''
    
    BusNameMarker: Optional[BusNameMarker] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BusNameMarker.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The bus name marker used to name the bus (topological node).
            '''
        
        })
    '''
    The bus name marker used to name the bus (topological node).
    '''
    
    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Measurements associated with this terminal defining where the measurement
            is placed in the network topology. It may be used, for instance, to capture
            the sensor position, such as a voltage transformer (PT) at a busbar or
            a current transformer (CT) at the bar between a breaker and an isolator.
            '''
        
        })
    '''
    Measurements associated with this terminal defining where the measurement
    is placed in the network topology. It may be used, for instance, to
    capture the sensor position, such as a voltage transformer (PT) at
    a busbar or a current transformer (CT) at the bar between a breaker
    and an isolator.
    '''
    
    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The operational limit sets at the terminal.
            '''
        
        })
    '''
    The operational limit sets at the terminal.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCBaseTerminal(ACDCTerminal):
    '''
    An electrical connection point at a piece of DC conducting equipment. DC
    terminals are connected at one physical DC node that may have multiple
    DC terminals connected. A DC node is similar to an AC connectivity node.
    The model requires that DC connections are distinct from AC connections.
    '''

    DCNode: Optional[DCNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCNode.DCTerminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The DC connectivity node to which this DC base terminal connects with zero
            impedance.
            '''
        
        })
    '''
    The DC connectivity node to which this DC base terminal connects with
    zero impedance.
    '''
    
    DCTopologicalNode: Optional[DCTopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTopologicalNode.DCTerminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            See association end Terminal.TopologicalNode.
            '''
        
        })
    '''
    See association end Terminal.TopologicalNode.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ACDCConverterDCTerminal(DCBaseTerminal):
    '''
    A DC electrical connection point at the AC/DC converter. The AC/DC converter
    is electrically connected also to the AC side. The AC connection is inherited
    from the AC conducting equipment in the same way as any other AC equipment.
    The AC/DC converter DC terminal is separate from generic DC terminal to
    restrict the connection with the AC side to AC/DC converter and so that
    no other DC conducting equipment can be connected to the AC side.
    '''

    polarity: Optional[ DCPolarityKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Represents the normal network polarity condition. Depending on the converter
            configuration the value shall be set as follows:
            - For a monopole with two converter terminals use DCPolarityKind �positive�
            and �negative�.
            - For a bi-pole or symmetric monopole with three converter terminals use
            DCPolarityKind �positive�, �middle� and �negative�.
            '''
        
        })
    '''
    Represents the normal network polarity condition. Depending on the
    converter configuration the value shall be set as follows:
    - For a monopole with two converter terminals use DCPolarityKind �positive�
    and �negative�.
    - For a bi-pole or symmetric monopole with three converter terminals
    use DCPolarityKind �positive�, �middle� and �negative�.
    '''
    
    DCConductingEquipment: Optional[ACDCConverter] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ACDCConverter.DCTerminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A DC converter terminal belong to an DC converter.
            '''
        
        })
    '''
    A DC converter terminal belong to an DC converter.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCTerminal(DCBaseTerminal):
    '''
    An electrical connection point to generic DC conducting equipment.
    '''

    DCConductingEquipment: Optional[DCConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'DCConductingEquipment.DCTerminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            An DC terminal belong to a DC conducting equipment.
            '''
        
        })
    '''
    An DC terminal belong to a DC conducting equipment.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class Terminal(ACDCTerminal):
    '''
    An AC electrical connection point to a piece of conducting equipment. Terminals
    are connected at physical connection points called connectivity nodes.
    '''

    phases: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Represents the normal network phasing condition. If the attribute is missing,
            three phases (ABC) shall be assumed, except for terminals of grounding
            classes (specializations of EarthFaultCompensator, GroundDisconnector,
            and Ground) which will be assumed to be N. Therefore, phase code ABCN is
            explicitly declared when needed, e.g. for star point grounding equipment.
            The phase code on terminals connecting same ConnectivityNode or same TopologicalNode
            as well as for equipment between two terminals shall be consistent.
            '''
        
        })
    '''
    Represents the normal network phasing condition. If the attribute is
    missing, three phases (ABC) shall be assumed, except for terminals
    of grounding classes (specializations of EarthFaultCompensator, GroundDisconnector,
    and Ground) which will be assumed to be N. Therefore, phase code ABCN
    is explicitly declared when needed, e.g. for star point grounding equipment.
    The phase code on terminals connecting same ConnectivityNode or same
    TopologicalNode as well as for equipment between two terminals shall
    be consistent.
    '''
    
    Bushing: Optional[Bushing] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Bushing.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Circuit: Optional[Circuit] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Circuit.EndTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ConductingEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.Terminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The conducting equipment of the terminal. Conducting equipment have terminals
            that may be connected to other conducting equipment terminals via connectivity
            nodes or topological nodes.
            '''
        
        })
    '''
    The conducting equipment of the terminal. Conducting equipment have
    terminals that may be connected to other conducting equipment terminals
    via connectivity nodes or topological nodes.
    '''
    
    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.Terminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The connectivity node to which this terminal connects with zero impedance.
            '''
        
        })
    '''
    The connectivity node to which this terminal connects with zero impedance.
    '''
    
    NormalHeadFeeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.NormalHeadTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The feeder that this terminal normally feeds. Only specified for the terminals
            at head of feeders.
            '''
        
        })
    '''
    The feeder that this terminal normally feeds. Only specified for the
    terminals at head of feeders.
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The topological node associated with the terminal. This can be used as
            an alternative to the connectivity node path to topological node, thus
            making it unnecessary to model connectivity nodes in some cases. Note that
            the if connectivity nodes are in the model, this association would probably
            not be used as an input specification.
            '''
        
        })
    '''
    The topological node associated with the terminal. This can be used
    as an alternative to the connectivity node path to topological node,
    thus making it unnecessary to model connectivity nodes in some cases.
    Note that the if connectivity nodes are in the model, this association
    would probably not be used as an input specification.
    '''
    
    ConverterDCSides: list[ACDCConverter] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACDCConverter.PccTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All converters' DC sides linked to this point of common coupling terminal.
            '''
        
        })
    '''
    All converters' DC sides linked to this point of common coupling terminal.
    '''
    
    AuxiliaryEquipment: list[AuxiliaryEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AuxiliaryEquipment.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The auxiliary equipment connected to the terminal.
            '''
        
        })
    '''
    The auxiliary equipment connected to the terminal.
    '''
    
    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BranchGroupTerminal.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The directed branch group terminals for which this terminal is monitored.
            '''
        
        })
    '''
    The directed branch group terminals for which this terminal is monitored.
    '''
    
    Bushing: Optional[Bushing] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Bushing.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    EquipmentFaults: list[EquipmentFault] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EquipmentFault.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The equipment faults at this terminal.
            '''
        
        })
    '''
    The equipment faults at this terminal.
    '''
    
    HasFirstMutualCoupling: list[MutualCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MutualCoupling.First_Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Mutual couplings associated with the branch as the first branch.
            '''
        
        })
    '''
    Mutual couplings associated with the branch as the first branch.
    '''
    
    HasSecondMutualCoupling: list[MutualCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MutualCoupling.Second_Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Mutual couplings with the branch associated as the first branch.
            '''
        
        })
    '''
    Mutual couplings with the branch associated as the first branch.
    '''
    
    PinTerminal: list[PinTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PinTerminal.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegulatingControl: list[RegulatingControl] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulatingControl.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The controls regulating this terminal.
            '''
        
        })
    '''
    The controls regulating this terminal.
    '''
    
    RemoteInputSignal: list[RemoteInputSignal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RemoteInputSignal.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Input signal coming from this terminal.
            '''
        
        })
    '''
    Input signal coming from this terminal.
    '''
    
    SvPowerFlow: list[SvPowerFlow] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvPowerFlow.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The power flow state variable associated with the terminal.
            '''
        
        })
    '''
    The power flow state variable associated with the terminal.
    '''
    
    TieFlow: list[TieFlow] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TieFlow.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The control area tie flows to which this terminal associates.
            '''
        
        })
    '''
    The control area tie flows to which this terminal associates.
    '''
    
    TransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All transformer ends connected at this terminal.
            '''
        
        })
    '''
    All transformer ends connected at this terminal.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MktTerminal(Terminal):
    '''
    Subclass of IEC61970:Core:Terminal.
    '''

    Flowgate: Optional[Flowgate] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Flowgate.MktTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TerminalConstraintTerm: list[TerminalConstraintTerm] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TerminalConstraintTerm.MktTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketOpCommon'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ActivityRecord(IdentifiedObject):
    '''
    Records activity for an entity at a point in time; activity may be for
    an event that has already occurred or for a planned activity.
    '''

    createdDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date and time this activity record has been created (different from the
            'status.dateTime', which is the time of a status change of the associated
            object, if applicable).
            '''
        
        })
    '''
    Date and time this activity record has been created (different from
    the 'status.dateTime', which is the time of a status change of the
    associated object, if applicable).
    '''
    
    reason: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reason for event resulting in this activity record, typically supplied
            when user initiated.
            '''
        
        })
    '''
    Reason for event resulting in this activity record, typically supplied
    when user initiated.
    '''
    
    severity: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Severity level of event resulting in this activity record.
            '''
        
        })
    '''
    Severity level of event resulting in this activity record.
    '''
    
    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of event resulting in this activity record.
            '''
        
        })
    '''
    Type of event resulting in this activity record.
    '''
    
    Author: Optional[Author] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Author.ActivityRecords',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Author of this activity record.
            '''
        
        })
    '''
    Author of this activity record.
    '''
    
    Document: Optional[Document] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Document.ActivityRecord',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The document having associated activity records
            '''
        
        })
    '''
    The document having associated activity records
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssetHealthEvent(ActivityRecord):
    '''
    An asset health-related event that is created by an analytic. The event
    is a record of a change in asset health.
    '''

    actionRecommendation: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Recommendation for action.
            '''
        
        })
    '''
    Recommendation for action.
    '''
    
    actionTimeline: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time horizon for action.
            '''
        
        })
    '''
    Time horizon for action.
    '''
    
    effectiveDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The date and time when the event is effective.
            '''
        
        })
    '''
    The date and time when the event is effective.
    '''
    
    Analytic: Optional[Analytic] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Analytic.AssetHealthEvent',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Analytic that initiated this asset health event.
            '''
        
        })
    '''
    Analytic that initiated this asset health event.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ComplianceEvent(ActivityRecord):
    '''
    Compliance events are used for reporting regulatory or contract compliance
    issues and/or variances. These might be created as a consequence of local
    business processes and associated rules. It is anticipated that this class
    will be customised extensively to meet local implementation needs.
    Use inherited 'type' to indicate that, for example, expected performance
    will not be met or reported as mandated.
    '''

    deadline: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The deadline for compliance.
            '''
        
        })
    '''
    The deadline for compliance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfCustomers'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConfigurationEvent(ActivityRecord):
    '''
    Used to report details on creation, change or deletion of an entity or
    its configuration.
    '''

    effectiveDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date and time this event has or will become effective.
            '''
        
        })
    '''
    Date and time this event has or will become effective.
    '''
    
    modifiedBy: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Source/initiator of modification.
            '''
        
        })
    '''
    Source/initiator of modification.
    '''
    
    remark: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Free text remarks.
            '''
        
        })
    '''
    Free text remarks.
    '''
    
    ChangedAsset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.ConfigurationEvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Asset whose change resulted in this configuration event.
            '''
        
        })
    '''
    Asset whose change resulted in this configuration event.
    '''
    
    ChangedDocument: Optional[Document] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Document.ConfigurationEvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Document whose change resulted in this configuration event.
            '''
        
        })
    '''
    Document whose change resulted in this configuration event.
    '''
    
    ChangedLocation: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.ConfigurationEvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Location whose change resulted in this configuration event.
            '''
        
        })
    '''
    Location whose change resulted in this configuration event.
    '''
    
    ChangedOrganisationRole: Optional[OrganisationRole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OrganisationRole.ConfigurationEvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Organisation role whose change resulted in this configuration event.
            '''
        
        })
    '''
    Organisation role whose change resulted in this configuration event.
    '''
    
    ChangedPersonRole: Optional[PersonRole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PersonRole.ConfigurationEvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Person role whose change resulted in this configuration event.
            '''
        
        })
    '''
    Person role whose change resulted in this configuration event.
    '''
    
    ChangedServiceCategory: Optional[ServiceCategory] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ServiceCategory.ConfigurationEvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Service category whose change resulted in this configuration event.
            '''
        
        })
    '''
    Service category whose change resulted in this configuration event.
    '''
    
    ChangedUsagePoint: Optional[UsagePoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'UsagePoint.ConfigurationEvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Usage point whose change resulted in this configuration event.
            '''
        
        })
    '''
    Usage point whose change resulted in this configuration event.
    '''
    
    FaultCauseType: Optional[FaultCauseType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'FaultCauseType.ConfigurationEvent',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fault cause type whose change resulted in this configuration event.
            '''
        
        })
    '''
    Fault cause type whose change resulted in this configuration event.
    '''
    
    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.ConfigurationEvent',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power system resource whose change resulted in this configuration event.
            '''
        
        })
    '''
    Power system resource whose change resulted in this configuration event.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EndDeviceEvent(ActivityRecord):
    '''
    Event detected by a device function associated with the end device.
    '''

    issuerID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Unique identifier of the business entity originating an end device control.
            '''
        
        })
    '''
    Unique identifier of the business entity originating an end device
    control.
    '''
    
    issuerTrackingID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Identifier assigned by the initiator (e.g. retail electric provider) of
            an end device control action to uniquely identify the demand response event,
            text message, or other subject of the control action. Can be used when
            cancelling an event or text message request or to identify the originating
            event or text message in a consequential end device event.
            '''
        
        })
    '''
    Identifier assigned by the initiator (e.g. retail electric provider)
    of an end device control action to uniquely identify the demand response
    event, text message, or other subject of the control action. Can be
    used when cancelling an event or text message request or to identify
    the originating event or text message in a consequential end device
    event.
    '''
    
    userID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if user initiated) ID of user who initiated this end device event.
            '''
        
        })
    '''
    (if user initiated) ID of user who initiated this end device event.
    '''
    
    EndDevice: Optional[EndDevice] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EndDevice.EndDeviceEvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            End device that reported this end device event.
            '''
        
        })
    '''
    End device that reported this end device event.
    '''
    
    EndDeviceEventType: Optional[EndDeviceEventType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'EndDeviceEventType.EndDeviceEvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of this end device event.
            '''
        
        })
    '''
    Type of this end device event.
    '''
    
    MeterReading: Optional[MeterReading] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeterReading.EndDeviceEvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Set of measured values to which this event applies.
            '''
        
        })
    '''
    Set of measured values to which this event applies.
    '''
    
    UsagePoint: Optional[UsagePoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'UsagePoint.EndDeviceEvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Usage point for which this end device event is reported.
            '''
        
        })
    '''
    Usage point for which this end device event is reported.
    '''
    
    EndDeviceEventDetails: list[EndDeviceEventDetail] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EndDeviceEventDetail.EndDeviceEvent',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All details of this end device event.
            '''
        
        })
    '''
    All details of this end device event.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnvironmentalAlert(ActivityRecord):
    '''
    An environmental alert issued by a provider or system.
    '''

    alertType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of the issued alert which is drawn from the specified alert type
            list.
            '''
        
        })
    '''
    The type of the issued alert which is drawn from the specified alert
    type list.
    '''
    
    cancelledDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time and date alert cancelled. Used only if alert is cancelled before it
            expires.
            '''
        
        })
    '''
    Time and date alert cancelled. Used only if alert is cancelled before
    it expires.
    '''
    
    headline: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            An abbreviated textual description of the alert issued.
            Note: the full text of the alert appears in the .description attribute
            (inherited from IdentifiedObject).
            '''
        
        })
    '''
    An abbreviated textual description of the alert issued.
    Note: the full text of the alert appears in the .description attribute
    (inherited from IdentifiedObject).
    '''
    
    AlertTypeList: Optional[AlertTypeList] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AlertTypeList.EnvironmentalAlert',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The list of alert types from which the type of this alert is drawn.
            '''
        
        })
    '''
    The list of alert types from which the type of this alert is drawn.
    '''
    
    EnvironmentalDataProvider: Optional[EnvironmentalDataProvider] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnvironmentalDataProvider.EnvironmentalAlert',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Environmental data provider for this alert.
            '''
        
        })
    '''
    Environmental data provider for this alert.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnvironmentalEvent(ActivityRecord):
    '''
    An environmental event to which one or more forecasts or observations may
    be tied and which may relate to or affect one or more assets.
    This class is intended to be used as a means of grouping forecasts and/or
    observations and could be used for a variety of purposes, including:
    <ul>
    <li>to define a 'named' event like Hurricane Katrina and allow the historic
    (or forecast) values for phenomena and measurements (precipitation, temperature)
    across time to be associated with it</li>
    <li>to identify assets that were (or are forecast to be) affected by a
    phenomenon or set of measurements</li>
    </ul>
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FailureEvent(ActivityRecord):
    '''
    An event where an asset has failed to perform its functions within specified
    parameters. This class is intended to reflect the failure itself. Additional
    information resulting from forensic analysis could be captured by a diagnosis
    data set.
    '''

    corporateCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Code for asset failure.
            '''
        
        })
    '''
    Code for asset failure.
    '''
    
    failureDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time and date of asset failure.
            '''
        
        })
    '''
    Time and date of asset failure.
    '''
    
    faultLocatingMethod: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The method used for locating the faulted part of the asset. For example,
            cable options include: Cap Discharge-Thumping, Bridge Method, Visual Inspection,
            Other.
            '''
        
        })
    '''
    The method used for locating the faulted part of the asset. For example,
    cable options include: Cap Discharge-Thumping, Bridge Method, Visual
    Inspection, Other.
    '''
    
    location: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Failure location on an object.
            '''
        
        })
    '''
    Failure location on an object.
    '''
    
    rootCause: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Root cause of asset failure.
            '''
        
        })
    '''
    Root cause of asset failure.
    '''
    
    breakerFailureReason: Optional[ BreakerFailureReasonKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reason for breaker failure.
            '''
        
        })
    '''
    Reason for breaker failure.
    '''
    
    failureClassification: Optional[ AssetFailureClassification ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Classification of failure.
            '''
        
        })
    '''
    Classification of failure.
    '''
    
    failureIsolationMethod: Optional[ FailureIsolationMethodKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            How the asset failure was isolated from the system.
            '''
        
        })
    '''
    How the asset failure was isolated from the system.
    '''
    
    failureMode: Optional[ AssetFailureMode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            What asset failed to be able to do.
            '''
        
        })
    '''
    What asset failed to be able to do.
    '''
    
    transformerFailureReason: Optional[ TransformerFailureReasonKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reason for transformer failure.
            '''
        
        })
    '''
    Reason for transformer failure.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MktActivityRecord(ActivityRecord):
    '''
    Subclass of IEC61968: Common:ActivityRecord.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketOpCommon'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PSREvent(ActivityRecord):
    '''
    Event recording the change in operational status of a power system resource
    (PSR); may be for an event that has already occurred or for a planned activity.
    '''

    kind: Optional[ PSREventKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of event.
            '''
        
        })
    '''
    Kind of event.
    '''
    
    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.PSREvents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power system resource that generated this event.
            '''
        
        })
    '''
    Power system resource that generated this event.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SwitchingEvent(ActivityRecord):
    '''
    Event indicating the completion (success or fail) of any switching action
    (jumper action, cut action, tag action, etc). The switching action may
    or may not be a consequential event in response to a request to complete
    the action.
    '''

    SwitchingAction: Optional[SwitchingAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'SwitchingAction.SwitchingEvent',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The switching action that is performed on the switching event
            '''
        
        })
    '''
    The switching action that is performed on the switching event
    '''
    
    SwitchingAction: Optional[SwitchingAction] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SwitchingAction.SwitchingEvent',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The switching action that is performed on the switching event
            '''
        
        })
    '''
    The switching action that is performed on the switching event
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Operations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WorkActivityRecord(ActivityRecord):
    '''
    Records information about the status of work or work task at a point in
    time.
    '''

    percentComplete: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Estimated percentage of completion of this individual work task or overall
            work order.
            '''
        
        })
    '''
    Estimated percentage of completion of this individual work task or
    overall work order.
    '''
    
    BaseWork: Optional[BaseWork] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseWork.WorkActivityRecords',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Base work that this activity record tracks.
            '''
        
        })
    '''
    Base work that this activity record tracks.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Work'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AdjacentCASet(IdentifiedObject):
    '''
    Groups Adjacent Control Areas.
    '''

    lossPercentage: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Loss percentage
            '''
        
        })
    '''
    Loss percentage
    '''
    
    HostControlArea: Optional[HostControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HostControlArea.AdjacentCASet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RTO: Optional[RTO] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RTO.AdjacentCASet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    BidSelfSched: list[BidSelfSched] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BidSelfSched.AdjacentCASet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    HostControlArea: Optional[HostControlArea] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HostControlArea.AdjacentCASet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredResource: list[RegisteredResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegisteredResource.AdjacentCASet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SubControlArea: list[SubControlArea] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SubControlArea.AdjacentCASet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AggregateNode(IdentifiedObject):
    '''
    An aggregated node can define a typed grouping further defined by the AnodeType
    enumeratuion. Types range from System Zone/Regions to Market Energy Regions
    to Aggregated Loads and Aggregated Generators.
    '''

    qualifASOrder: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Processing Order for AS self-provisions for this region. The priority of
            this attribute directs the awards of any resource that resides in overlapping
            regions. The regions are processed in priority manner.
            '''
        
        })
    '''
    Processing Order for AS self-provisions for this region. The priority
    of this attribute directs the awards of any resource that resides in
    overlapping regions. The regions are processed in priority manner.
    '''
    
    anodeType: Optional[ AnodeType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of aggregated node
            '''
        
        })
    '''
    Type of aggregated node
    '''
    
    RTO: Optional[RTO] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RTO.AggregateNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    AreaLoadCurve: list[AreaLoadCurve] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AreaLoadCurve.AggregateNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    CnodeDistributionFactor: list[CnodeDistributionFactor] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CnodeDistributionFactor.AggregateNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Instruction: list[Instructions] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Instructions.AggregateNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredResource: list[RegisteredResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegisteredResource.AggregateNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A RegisteredResource can be associated to only one AggregateNode if not
            connected to a Pnode or MktConnectivityNode.
            '''
        
        })
    '''
    A RegisteredResource can be associated to only one AggregateNode if
    not connected to a Pnode or MktConnectivityNode.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LoadAggregationPoint(AggregateNode):
    '''
    A specialized class of type AggregatedNode type. Defines Load Aggregation
    Points.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MSSZone(AggregateNode):
    '''
    Model to define a zone within a Metered Sub System.
    '''

    lossFactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This is the default loss factor for the Metered Sub-System (MSS) zone.
            The actual losses are calculated during the RT market.
            '''
        
        })
    '''
    This is the default loss factor for the Metered Sub-System (MSS) zone.
    The actual losses are calculated during the RT market.
    '''
    
    ignoreLosses: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Provides an indication if losses are to be ignored for this metered subsystem
            zone.
            '''
        
        })
    '''
    Provides an indication if losses are to be ignored for this metered
    subsystem zone.
    '''
    
    rucGrossSettlement: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Metered Sub-System (MSS) Load Following may select Net vs. Gross settlement.
            Net Settlement requires the net Demand settled at the Metered Sub-Sustem
            (MSS) Load Aggregation Point (LAP) and Net Supply needs to settle at the
            equivalent to the weighted average price of the MSS generation. Gross load
            will be settled at the System LAP and the Gross supply will be settled
            at the LMP. MSS Aggregation that elects gross settlement shall have to
            identify if its resources are Load Following or not.
            '''
        
        })
    '''
    Metered Sub-System (MSS) Load Following may select Net vs. Gross settlement.
    Net Settlement requires the net Demand settled at the Metered Sub-Sustem
    (MSS) Load Aggregation Point (LAP) and Net Supply needs to settle at
    the equivalent to the weighted average price of the MSS generation.
    Gross load will be settled at the System LAP and the Gross supply will
    be settled at the LMP. MSS Aggregation that elects gross settlement
    shall have to identify if its resources are Load Following or not.
    '''
    
    MeteredSubSystem: Optional[MeteredSubSystem] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeteredSubSystem.MSSZone',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MarketRegion(AggregateNode):
    '''
    A specialized class of AggregatedNode type. Defines the MarketRegions.
    Regions could be system Market Regions, Energy Regions or Ancillary Service
    Regions.
    '''

    ExPostMarketRegionResults: list[ExPostMarketRegionResults] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ExPostMarketRegionResults.MarketRegion',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MarketRegionResults: list[MarketRegionResults] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MarketRegionResults.MarketRegion',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ReserveDemandCurve: list[ReserveDemandCurve] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ReserveDemandCurve.MarketRegion',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RUCZone(AggregateNode):
    '''
    A specialized class of type AggregatedNode type. Defines RUC Zones. A forecast
    region represents a collection of Nodes for which the Market operator has
    developed sufficient historical demand and relevant weather data to perform
    a demand forecast for such area. The Market Operator may further adjust
    this forecast to ensure that the Reliability Unit Commitment produces adequate
    local capacity procurement.
    '''

    LossClearingResults: list[LossClearingResults] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LossClearingResults.RUCZone',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AlertTypeList(IdentifiedObject):
    '''
    A named list of alert types.
    Note: the name of the list is reflected in the .name attribute (inherited
    from IdentifiedObject).
    '''

    version: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The version of the named list of alert types.
            '''
        
        })
    '''
    The version of the named list of alert types.
    '''
    
    EnvironmentalDataAuthority: Optional[EnvironmentalDataAuthority] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnvironmentalDataAuthority.AlertTypeList',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The environmental data authority responsible for publishing this list of
            alert types.
            '''
        
        })
    '''
    The environmental data authority responsible for publishing this list
    of alert types.
    '''
    
    EnvironmentalAlert: list[EnvironmentalAlert] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnvironmentalAlert.AlertTypeList',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            An alert whose type is drawn from this alert type list.
            '''
        
        })
    '''
    An alert whose type is drawn from this alert type list.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AltGeneratingUnitMeas(IdentifiedObject):
    '''
    A prioritized measurement to be used for the generating unit in the control
    area specification.
    '''

    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Priority of a measurement usage. Lower numbers have first priority.
            '''
        
        })
    '''
    Priority of a measurement usage. Lower numbers have first priority.
    '''
    
    AnalogValue: Optional[AnalogValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AltGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The specific analog value used as a source.
            '''
        
        })
    '''
    The specific analog value used as a source.
    '''
    
    ControlAreaGeneratingUnit: Optional[ControlAreaGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ControlAreaGeneratingUnit.AltGeneratingUnitMeas',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The control area generating unit to which the prioritized measurement assignment
            is applied.
            '''
        
        })
    '''
    The control area generating unit to which the prioritized measurement
    assignment is applied.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ControlArea'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AltTieMeas(IdentifiedObject):
    '''
    A prioritized measurement to be used for the tie flow as part of the control
    area specification.
    '''

    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Priority of a measurement usage. Lower numbers have first priority.
            '''
        
        })
    '''
    Priority of a measurement usage. Lower numbers have first priority.
    '''
    
    AnalogValue: Optional[AnalogValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AltTieMeas',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The specific analog value used as a source.
            '''
        
        })
    '''
    The specific analog value used as a source.
    '''
    
    TieFlow: Optional[TieFlow] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'TieFlow.AltTieMeas',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The tie flow of the alternate measurements.
            '''
        
        })
    '''
    The tie flow of the alternate measurements.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ControlArea'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class AlternateModel(IdentifiedObject):
    '''
    '''

    AlternateModelGroup: Optional[AlternateModelGroup] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AlternateModelGroup.AlternateModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The group of alternate models for which one alternate is used.
            '''
        
        })
    '''
    The group of alternate models for which one alternate is used.
    '''
    
    Dataset: Optional[DataSet] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'DataSet.AlternateModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The data belonging to the alternate model.
            '''
        
        })
    '''
    The data belonging to the alternate model.
    '''
    
    Dataset: Optional[DataSet] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DataSet.AlternateModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The data belonging to the alternate model.
            '''
        
        })
    '''
    The data belonging to the alternate model.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AlternateModels'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class AlternateModelGroup(IdentifiedObject):
    '''
    '''

    AlternateModel: list[AlternateModel] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AlternateModel.AlternateModelGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            An alternate model that can be one possiblity among alternates.
            '''
        
        })
    '''
    An alternate model that can be one possiblity among alternates.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AlternateModels'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AnalyticScore(IdentifiedObject):
    '''
    An indicative scoring by an analytic that can be used to characterize the
    health of or the risk associated with one or more assets. The analytic
    score reflects the results of an execution of an analytic against an asset
    or group of assets.
    '''

    calculationDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Timestamp of when the score was calculated.
            '''
        
        })
    '''
    Timestamp of when the score was calculated.
    '''
    
    effectiveDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date-time for when the score applies.
            '''
        
        })
    '''
    Date-time for when the score applies.
    '''
    
    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Asset health score value.
            '''
        
        })
    '''
    Asset health score value.
    '''
    
    Analytic: Optional[Analytic] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Analytic.AnalyticScore',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Analytic which was executed to arrive at this analytic score..
            '''
        
        })
    '''
    Analytic which was executed to arrive at this analytic score..
    '''
    
    Asset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.AnalyticScore',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Asset to which this analytic score applies.
            '''
        
        })
    '''
    Asset to which this analytic score applies.
    '''
    
    AssetAggregateScore: Optional[AggregateScore] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AggregateScore.AnalyticScore',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Aggregate score to which this analytic score contributed.
            '''
        
        })
    '''
    Aggregate score to which this analytic score contributed.
    '''
    
    AssetGroup: Optional[AssetGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetGroup.AnalyticScore',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Asset group to which this analytic score applies..
            '''
        
        })
    '''
    Asset group to which this analytic score applies..
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AggregateScore(AnalyticScore):
    '''
    An aggregated indicative scoring by an analytic, which is based on other
    analytic scores, that can be used to characterize the health of or the
    risk associated with one or more assets.
    '''

    AnalyticScore: list[AnalyticScore] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalyticScore.AssetAggregateScore',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Analytic score contributing to this aggregate score.
            '''
        
        })
    '''
    Analytic score contributing to this aggregate score.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class HealthScore(AggregateScore):
    '''
    Score that is indicative of the health of one or more assets.
    '''

    AssetRiskScore: Optional[RiskScore] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RiskScore.AssetHealthScore',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Risk score with which this health score is associated.
            '''
        
        })
    '''
    Risk score with which this health score is associated.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RiskScore(AggregateScore):
    '''
    Score that is indicative of the risk associated with one or more assets.
    '''

    kind: Optional[ RiskScoreKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The risk kind, such as CustomerRisk, FinancialRisk, SafetyRisk, etc.
            '''
        
        })
    '''
    The risk kind, such as CustomerRisk, FinancialRisk, SafetyRisk, etc.
    '''
    
    AssetHealthScore: list[HealthScore] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HealthScore.AssetRiskScore',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Individual health score associated with this risk score.
            '''
        
        })
    '''
    Individual health score associated with this risk score.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class AnnotatedProjectDependency(IdentifiedObject):
    '''
    '''

    dependencyType: Optional[ DependencyKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    DependentOnStage: Optional[NetworkModelProjectStage] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'NetworkModelProjectStage.DependencyDependentOnStage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    DependingStage: Optional[NetworkModelProjectStage] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'NetworkModelProjectStage.DenpendecyDependingStage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    DependentOnStage: Optional[NetworkModelProjectStage] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NetworkModelProjectStage.DependencyDependentOnStage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'NetworkModelProjects'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Appointment(IdentifiedObject):
    '''
    Meeting time and location.
    '''

    callAhead: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if requested to call customer when someone is about to arrive at their
            premises.
            '''
        
        })
    '''
    True if requested to call customer when someone is about to arrive
    at their premises.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssemblyDescription(IdentifiedObject):
    '''
    A description for how to assemble model parts for a specific purpose.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'NetworkModelFrames'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssemblyManifest(IdentifiedObject):
    '''
    A collection of model parts when combined form a case or part of a case.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'NetworkModelFrames'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class Asset(IdentifiedObject):
    '''
    Tangible resource of the utility, including power system equipment, various
    end devices, cabinets, buildings, etc. For electrical network equipment,
    the role of the asset is defined through PowerSystemResource and its subclasses,
    defined mainly in the Wires model (refer to IEC61970-301 and model package
    IEC61970::Wires). Asset description places emphasis on the physical characteristics
    of the equipment fulfilling that role.
    '''

    critical: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if asset is considered critical for some reason (for example, a pole
            with critical attachments).
            '''
        
        })
    '''
    True if asset is considered critical for some reason (for example,
    a pole with critical attachments).
    '''
    
    initialCondition: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Condition of asset at last baseline. Examples include new, rebuilt, overhaul
            required, other. Refer to inspection data for information on the most current
            condition of the asset.
            '''
        
        })
    '''
    Condition of asset at last baseline. Examples include new, rebuilt,
    overhaul required, other. Refer to inspection data for information
    on the most current condition of the asset.
    '''
    
    lotNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Lot number for this asset. Even for the same model and version number,
            many assets are manufactured in lots.
            '''
        
        })
    '''
    Lot number for this asset. Even for the same model and version number,
    many assets are manufactured in lots.
    '''
    
    position: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Position of asset or asset component. May often be in relation to other
            assets or components.
            '''
        
        })
    '''
    Position of asset or asset component. May often be in relation to other
    assets or components.
    '''
    
    serialNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Serial number of this asset.
            '''
        
        })
    '''
    Serial number of this asset.
    '''
    
    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Utility-specific classification of Asset and its subtypes, according to
            their corporate standards, practices, and existing IT systems (e.g., for
            management of assets, maintenance, work, outage, customers, etc.).
            '''
        
        })
    '''
    Utility-specific classification of Asset and its subtypes, according
    to their corporate standards, practices, and existing IT systems (e.g.,
    for management of assets, maintenance, work, outage, customers, etc.).
    '''
    
    utcNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Uniquely tracked commodity (UTC) number.
            '''
        
        })
    '''
    Uniquely tracked commodity (UTC) number.
    '''
    
    initialLossOfLife: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Percentage of initial life expectancy that has been lost as of the last
            life expectancy baseline. Represents
            (initial life expectancy - current life expectancy) / initial life expectancy.
            '''
        
        })
    '''
    Percentage of initial life expectancy that has been lost as of the
    last life expectancy baseline. Represents
    (initial life expectancy - current life expectancy) / initial life
    expectancy.
    '''
    
    inUseState: Optional[ InUseStateKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indication of whether asset is currently deployed (in use), ready to be
            put into use or not available for use.
            '''
        
        })
    '''
    Indication of whether asset is currently deployed (in use), ready to
    be put into use or not available for use.
    '''
    
    kind: Optional[ AssetKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of asset. Used in description of asset components in asset instance
            templates.
            '''
        
        })
    '''
    Kind of asset. Used in description of asset components in asset instance
    templates.
    '''
    
    lifecycleState: Optional[ AssetLifecycleStateKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Current lifecycle state of asset.
            '''
        
        })
    '''
    Current lifecycle state of asset.
    '''
    
    purchasePrice: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Purchase price of asset.
            '''
        
        })
    '''
    Purchase price of asset.
    '''
    
    retiredReason: Optional[ RetiredReasonKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reason asset retired.
            '''
        
        })
    '''
    Reason asset retired.
    '''
    
    AssetContainer: Optional[AssetContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetContainer.Assets',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Container of this asset.
            '''
        
        })
    '''
    Container of this asset.
    '''
    
    AssetDeployment: Optional[AssetDeployment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetDeployment.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This asset's deployment.
            '''
        
        })
    '''
    This asset's deployment.
    '''
    
    AssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.Assets',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Data applicable to this asset.
            '''
        
        })
    '''
    Data applicable to this asset.
    '''
    
    BreakerOperation: Optional[SwitchOperationSummary] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SwitchOperationSummary.Breaker',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Breaker operation information for this breaker.
            '''
        
        })
    '''
    Breaker operation information for this breaker.
    '''
    
    ErpInventory: Optional[ErpInventory] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ErpInventory.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ErpItemMaster: Optional[ErpItemMaster] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ErpItemMaster.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    FinancialInfo: Optional[FinancialInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FinancialInfo.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Financial information related to this asset.
            '''
        
        })
    '''
    Financial information related to this asset.
    '''
    
    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.Assets',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Location of this asset.
            '''
        
        })
    '''
    Location of this asset.
    '''
    
    ProductAssetModel: Optional[ProductAssetModel] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ProductAssetModel.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The model of this asset.
            '''
        
        })
    '''
    The model of this asset.
    '''
    
    ServiceLocation: Optional[ServiceLocation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ServiceLocation.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The sevice location at which the assets exist
            '''
        
        })
    '''
    The sevice location at which the assets exist
    '''
    
    AnalyticScore: list[AnalyticScore] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalyticScore.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Analytic result related to this asset.
            '''
        
        })
    '''
    Analytic result related to this asset.
    '''
    
    AssetDeployment: Optional[AssetDeployment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetDeployment.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            This asset's deployment.
            '''
        
        })
    '''
    This asset's deployment.
    '''
    
    AssetFunction: list[AssetFunction] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AssetFunction.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Function performed by this asset.
            '''
        
        })
    '''
    Function performed by this asset.
    '''
    
    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConfigurationEvent.ChangedAsset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All configuration events created for this asset.
            '''
        
        })
    '''
    All configuration events created for this asset.
    '''
    
    ErpInventory: Optional[ErpInventory] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ErpInventory.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ErpItemMaster: Optional[ErpItemMaster] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ErpItemMaster.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    FinancialInfo: Optional[FinancialInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FinancialInfo.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Financial information related to this asset.
            '''
        
        })
    '''
    Financial information related to this asset.
    '''
    
    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Measurement related to this asset.
            '''
        
        })
    '''
    Measurement related to this asset.
    '''
    
    OperationalTags: list[OperationalTag] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalTag.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All operational tags placed on this asset.
            '''
        
        })
    '''
    All operational tags placed on this asset.
    '''
    
    Ownerships: list[Ownership] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Ownership.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All ownerships of this asset.
            '''
        
        })
    '''
    All ownerships of this asset.
    '''
    
    ProcedureDataSet: list[ProcedureDataSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProcedureDataSet.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Procedure data set that applies to this asset.
            '''
        
        })
    '''
    Procedure data set that applies to this asset.
    '''
    
    Reconditionings: list[Reconditioning] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Reconditioning.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    BreakerOperation: Optional[SwitchOperationSummary] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SwitchOperationSummary.Breaker',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Breaker operation information for this breaker.
            '''
        
        })
    '''
    Breaker operation information for this breaker.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssetContainer(Asset):
    '''
    Asset that is aggregation of other assets such as conductors, transformers,
    switchgear, land, fences, buildings, equipment, vehicles, etc.
    '''

    Assets: list[Asset] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Asset.AssetContainer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All assets within this container asset.
            '''
        
        })
    '''
    All assets within this container asset.
    '''
    
    Seals: list[Seal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Seal.AssetContainer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All seals applied to this asset container.
            '''
        
        })
    '''
    All seals applied to this asset container.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Cabinet(AssetContainer):
    '''
    Enclosure that offers protection to the equipment it contains and/or safety
    to people/animals outside it.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class DuctBank(AssetContainer):
    '''
    A duct contains individual wires in the layout as specified with associated
    wire spacing instances; number of them gives the number of conductors in
    this duct.
    '''

    circuitCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of circuits in duct bank. Refer to associations between a duct (ConductorAsset)
            and an ACLineSegment to understand which circuits are in which ducts.
            '''
        
        })
    '''
    Number of circuits in duct bank. Refer to associations between a duct
    (ConductorAsset) and an ACLineSegment to understand which circuits
    are in which ducts.
    '''
    
    WireSpacingInfos: list[WireSpacingInfo] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireSpacingInfo.DuctBank',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EndDevice(AssetContainer):
    '''
    Asset container that performs one or more end device functions. One type
    of end device is a meter which can perform metering, load management, connect/disconnect,
    accounting functions, etc. Some end devices, such as ones monitoring and
    controlling air conditioners, refrigerators, pool pumps may be connected
    to a meter. All end devices may have communication capability defined by
    the associated communication function(s). An end device may be owned by
    a consumer, a service provider, utility or otherwise.
    There may be a related end device function that identifies a sensor or
    control point within a metering application or communications systems (e.g.,
    water, gas, electricity).
    Some devices may use an optical port that conforms to the ANSI C12.18 standard
    for communications.
    '''

    amrSystem: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Automated meter reading (AMR) or other communication system responsible
            for communications to this end device.
            '''
        
        })
    '''
    Automated meter reading (AMR) or other communication system responsible
    for communications to this end device.
    '''
    
    installCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Installation code.
            '''
        
        })
    '''
    Installation code.
    '''
    
    isPan: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, this is a premises area network (PAN) device.
            '''
        
        })
    '''
    If true, this is a premises area network (PAN) device.
    '''
    
    isSmartInverter: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, there is a communicating inverter present.
            '''
        
        })
    '''
    If true, there is a communicating inverter present.
    '''
    
    isVirtual: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, there is no physical device. As an example, a virtual meter can
            be defined to aggregate the consumption for two or more physical meters.
            Otherwise, this is a physical hardware device.
            '''
        
        })
    '''
    If true, there is no physical device. As an example, a virtual meter
    can be defined to aggregate the consumption for two or more physical
    meters. Otherwise, this is a physical hardware device.
    '''
    
    timeZoneOffset: Optional[ float | Minutes ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time zone offset relative to GMT for the location of this end device.
            '''
        
        })
    '''
    Time zone offset relative to GMT for the location of this end device.
    '''
    
    Customer: Optional[Customer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Customer.EndDevices',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Customer owning this end device.
            '''
        
        })
    '''
    Customer owning this end device.
    '''
    
    EndDeviceInfo: Optional[EndDeviceInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EndDeviceInfo.EndDevices',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            End device data.
            '''
        
        })
    '''
    End device data.
    '''
    
    MeterReadSchedule: Optional[MeterReadSchedule] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeterReadSchedule.EndDevice',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Meter read schedule that applies to the end device
            '''
        
        })
    '''
    Meter read schedule that applies to the end device
    '''
    
    ServiceLocation: Optional[ServiceLocation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ServiceLocation.EndDevices',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Service location whose service delivery is measured by this end device.
            '''
        
        })
    '''
    Service location whose service delivery is measured by this end device.
    '''
    
    UsagePoint: Optional[UsagePoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'UsagePoint.EndDevices',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Usage point to which this end device belongs.
            '''
        
        })
    '''
    Usage point to which this end device belongs.
    '''
    
    EndDeviceEvents: list[EndDeviceEvent] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EndDeviceEvent.EndDevice',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All events reported by this end device.
            '''
        
        })
    '''
    All events reported by this end device.
    '''
    
    EndDeviceFunctions: list[EndDeviceFunction] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EndDeviceFunction.EndDevice',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All end device functions this end device performs.
            '''
        
        })
    '''
    All end device functions this end device performs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Meter(EndDevice):
    '''
    Physical asset that performs the metering role of the usage point. Used
    for measuring consumption and detection of events.
    '''

    connectionCategory: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A code used to specify the connection category, e.g. low voltage, where
            the meter operates.
            '''
        
        })
    '''
    A code used to specify the connection category, e.g. low voltage, where
    the meter operates.
    '''
    
    formNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Meter form designation per ANSI C12.10 or other applicable standard. An
            alphanumeric designation denoting the circuit arrangement for which the
            meter is applicable and its specific terminal arrangement.
            '''
        
        })
    '''
    Meter form designation per ANSI C12.10 or other applicable standard.
    An alphanumeric designation denoting the circuit arrangement for which
    the meter is applicable and its specific terminal arrangement.
    '''
    
    MeterMultipliers: list[MeterMultiplier] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeterMultiplier.Meter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All multipliers applied at this meter.
            '''
        
        })
    '''
    All multipliers applied at this meter.
    '''
    
    MeterReadings: list[MeterReading] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeterReading.Meter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All meter readings provided by this meter.
            '''
        
        })
    '''
    All meter readings provided by this meter.
    '''
    
    MeterServiceWorkTask: list[MeterWorkTask] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeterWorkTask.Meter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All non-replacement work tasks on this meter.
            '''
        
        })
    '''
    All non-replacement work tasks on this meter.
    '''
    
    MeterReplacementWorkTasks: list[MeterWorkTask] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeterWorkTask.OldMeter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All work tasks on replacement of this old meter.
            '''
        
        })
    '''
    All work tasks on replacement of this old meter.
    '''
    
    VendingTransactions: list[Transaction] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Transaction.Meter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All vending transactions on this meter.
            '''
        
        })
    '''
    All vending transactions on this meter.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Facility(AssetContainer):
    '''
    A facility may contain buildings, storage facilities, switching facilities,
    power generation, manufacturing facilities, maintenance facilities, etc.
    '''

    kind: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of this facility.
            '''
        
        })
    '''
    Kind of this facility.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Structure(AssetContainer):
    '''
    Construction holding assets such as conductors, transformers, switchgear,
    etc. Where applicable, number of conductors can be derived from the number
    of associated wire spacing instances.
    '''

    fumigantAppliedDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date fumigant was last applied.
            '''
        
        })
    '''
    Date fumigant was last applied.
    '''
    
    fumigantName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Name of fumigant.
            '''
        
        })
    '''
    Name of fumigant.
    '''
    
    removeWeed: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if weeds are to be removed around asset.
            '''
        
        })
    '''
    True if weeds are to be removed around asset.
    '''
    
    weedRemovedDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date weed were last removed.
            '''
        
        })
    '''
    Date weed were last removed.
    '''
    
    height: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Visible height of structure above ground level for overhead construction
            (e.g., Pole or Tower) or below ground level for an underground vault, manhole,
            etc. Refer to associated DimensionPropertiesInfo for other types of dimensions.
            '''
        
        })
    '''
    Visible height of structure above ground level for overhead construction
    (e.g., Pole or Tower) or below ground level for an underground vault,
    manhole, etc. Refer to associated DimensionPropertiesInfo for other
    types of dimensions.
    '''
    
    materialKind: Optional[ StructureMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Material this structure is made of.
            '''
        
        })
    '''
    Material this structure is made of.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum rated voltage of the equipment that can be mounted on/contained
            within the structure.
            '''
        
        })
    '''
    Maximum rated voltage of the equipment that can be mounted on/contained
    within the structure.
    '''
    
    StructureSupports: list[StructureSupport] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'StructureSupport.SecuredStructure',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Structure support for this structure.
            '''
        
        })
    '''
    Structure support for this structure.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class Pole(Structure):
    '''
    Pole asset.
    '''

    breastBlock: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if a block of material has been attached to base of pole in ground
            for stability. This technique is used primarily when anchors can not be
            used.
            '''
        
        })
    '''
    True if a block of material has been attached to base of pole in ground
    for stability. This technique is used primarily when anchors can not
    be used.
    '''
    
    classification: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Pole class: 1, 2, 3, 4, 5, 6, 7, H1, H2, Other, Unknown.
            '''
        
        })
    '''
    Pole class: 1, 2, 3, 4, 5, 6, 7, H1, H2, Other, Unknown.
    '''
    
    construction: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The framing structure mounted on the pole.
            '''
        
        })
    '''
    The framing structure mounted on the pole.
    '''
    
    jpaReference: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Joint pole agreement reference number.
            '''
        
        })
    '''
    Joint pole agreement reference number.
    '''
    
    speciesType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Pole species. Aluminum, Aluminum Davit, Concrete, Fiberglass, Galvanized
            Davit, Galvanized, Steel Davit Primed, Steel Davit, Steel Standard Primed,
            Steel, Truncated, Wood-Treated, Wood-Hard, Wood-Salt Treated, Wood-Soft,
            Wood, Other, Unknown.
            '''
        
        })
    '''
    Pole species. Aluminum, Aluminum Davit, Concrete, Fiberglass, Galvanized
    Davit, Galvanized, Steel Davit Primed, Steel Davit, Steel Standard
    Primed, Steel, Truncated, Wood-Treated, Wood-Hard, Wood-Salt Treated,
    Wood-Soft, Wood, Other, Unknown.
    '''
    
    treatedDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date and time pole was last treated with preservative.
            '''
        
        })
    '''
    Date and time pole was last treated with preservative.
    '''
    
    baseKind: Optional[ PoleBaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of base for this pole.
            '''
        
        })
    '''
    Kind of base for this pole.
    '''
    
    diameter: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter of the pole.
            '''
        
        })
    '''
    Diameter of the pole.
    '''
    
    length: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Length of the pole (inclusive of any section of the pole that may be underground
            post-installation).
            '''
        
        })
    '''
    Length of the pole (inclusive of any section of the pole that may be
    underground post-installation).
    '''
    
    preservativeKind: Optional[ PolePreservativeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of preservative for this pole.
            '''
        
        })
    '''
    Kind of preservative for this pole.
    '''
    
    treatmentKind: Optional[ PoleTreatmentKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of treatment for this pole.
            '''
        
        })
    '''
    Kind of treatment for this pole.
    '''
    
    Streetlights: list[Streetlight] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Streetlight.Pole',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All streetlights attached to this pole.
            '''
        
        })
    '''
    All streetlights attached to this pole.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Tower(Structure):
    '''
    Tower asset. Dimensions of the Tower are specified in associated DimensionsInfo
    class.
    When used for planning purposes, a transmission tower carrying two 3-phase
    circuits will have 2 instances of Connection, each of which will have 3
    MountingPoint instances, one for each phase all with coordinates relative
    to a common origin on the tower. (It may also have a 3rd Connection with
    a single MountingPoint for the Neutral line).
    '''

    constructionKind: Optional[ TowerConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Construction structure on the tower.
            '''
        
        })
    '''
    Construction structure on the tower.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class UndergroundStructure(Structure):
    '''
    Underground structure.
    '''

    hasVentilation: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if vault is ventilating.
            '''
        
        })
    '''
    True if vault is ventilating.
    '''
    
    material: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Primary material of underground structure.
            '''
        
        })
    '''
    Primary material of underground structure.
    '''
    
    sealingWarrantyExpiresDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date sealing warranty expires.
            '''
        
        })
    '''
    Date sealing warranty expires.
    '''
    
    kind: Optional[ UndergroundStructureKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if vault is ventilating.
            '''
        
        })
    '''
    True if vault is ventilating.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class Bushing(Asset):
    '''
    Bushing asset.
    '''

    FixedContact: Optional[InterrupterUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InterrupterUnit.Bushing',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fixed contact of interrupter to which this bushing is attached.
            '''
        
        })
    '''
    Fixed contact of interrupter to which this bushing is attached.
    '''
    
    MovingContact: Optional[InterrupterUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InterrupterUnit.Bushing',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Moving contact of interrupter to which this bushing is attached.
            '''
        
        })
    '''
    Moving contact of interrupter to which this bushing is attached.
    '''
    
    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.Bushing',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Terminal to which this bushing is attached.
            '''
        
        })
    '''
    Terminal to which this bushing is attached.
    '''
    
    BushingInsulationPFs: list[BushingInsulationPF] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BushingInsulationPF.Bushing',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.Bushing',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Terminal to which this bushing is attached.
            '''
        
        })
    '''
    Terminal to which this bushing is attached.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ComMedia(Asset):
    '''
    Communication media such as fibre optic cable, power-line, telephone, etc.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ComModule(Asset):
    '''
    An asset having communications capabilities that can be paired with a meter
    or other end device to provide the device with communication ability, through
    associated communication function. An end device that has communications
    capabilities through embedded hardware can use that function directly (without
    the communication module), or combine embedded communication function with
    additional communication functions provided through an external communication
    module (e.g. zigbee).
    '''

    amrSystem: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Automated meter reading (AMR) system communicating with this com module.
            '''
        
        })
    '''
    Automated meter reading (AMR) system communicating with this com module.
    '''
    
    supportsAutonomousDst: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, autonomous daylight saving time (DST) function is supported.
            '''
        
        })
    '''
    If true, autonomous daylight saving time (DST) function is supported.
    '''
    
    timeZoneOffset: Optional[ float | Minutes ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time zone offset relative to GMT for the location of this com module.
            '''
        
        })
    '''
    Time zone offset relative to GMT for the location of this com module.
    '''
    
    ComFunctions: list[ComFunction] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ComFunction.ComModule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All functions this communication module performs.
            '''
        
        })
    '''
    All functions this communication module performs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FACTSDevice(Asset):
    '''
    FACTS device asset.
    '''

    kind: Optional[ FACTSDeviceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of FACTS device.
            '''
        
        })
    '''
    Kind of FACTS device.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class InterrupterUnit(Asset):
    '''
    Breaker interrupter.
    Some interrupters have one fixed and one moving contact, some have 2 fixed
    contacts, some 2 moving contacts. An interrupter will have relationships
    with 2 bushings and those relationships may be any combination of the FixedContact
    and MovingContact associations.
    '''

    OperatingMechanism: Optional[OperatingMechanism] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperatingMechanism.InterrupterUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Breaker mechanism controlling this interrupter.
            '''
        
        })
    '''
    Breaker mechanism controlling this interrupter.
    '''
    
    Bushing: list[Bushing] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bushing.FixedContact',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Bushing(s) to which the fixed contact(s) of this interrupter is(are) attached.
            Some interrupters have one fixed and one moving contact, some have 2 fixed
            contacts, some 2 moving contacts. An interrupter will have relationships
            with 2 bushings and those relationships may be any combination of the FixedContact
            and MovingContact associations.
            '''
        
        })
    '''
    Bushing(s) to which the fixed contact(s) of this interrupter is(are)
    attached. Some interrupters have one fixed and one moving contact,
    some have 2 fixed contacts, some 2 moving contacts. An interrupter
    will have relationships with 2 bushings and those relationships may
    be any combination of the FixedContact and MovingContact associations.
    '''
    
    Bushing: list[Bushing] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bushing.MovingContact',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Bushing(s) to which the fixed contact(s) of this interrupter is(are) attached.
            Some interrupters have one fixed and one moving contact, some have 2 fixed
            contacts, some 2 moving contacts. An interrupter will have relationships
            with 2 bushings and those relationships may be any combination of the FixedContact
            and MovingContact associations.
            '''
        
        })
    '''
    Bushing(s) to which the fixed contact(s) of this interrupter is(are)
    attached. Some interrupters have one fixed and one moving contact,
    some have 2 fixed contacts, some 2 moving contacts. An interrupter
    will have relationships with 2 bushings and those relationships may
    be any combination of the FixedContact and MovingContact associations.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Joint(Asset):
    '''
    Joint connects two or more cables. It includes the portion of cable under
    wipes, welds, or other seals.
    '''

    insulation: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of insulation around the joint, classified according to the utility's
            asset management standards and practices.
            '''
        
        })
    '''
    The type of insulation around the joint, classified according to the
    utility's asset management standards and practices.
    '''
    
    configurationKind: Optional[ JointConfigurationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Configuration of joint.
            '''
        
        })
    '''
    Configuration of joint.
    '''
    
    fillKind: Optional[ JointFillKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Material used to fill the joint.
            '''
        
        })
    '''
    Material used to fill the joint.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperatingMechanism(Asset):
    '''
    Breaker mechanism.
    '''

    InterrupterUnit: list[InterrupterUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'InterrupterUnit.OperatingMechanism',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Interrupter controlled by this mechanism.
            '''
        
        })
    '''
    Interrupter controlled by this mechanism.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Streetlight(Asset):
    '''
    Streetlight asset.
    '''

    armLength: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Length of arm. Note that a new light may be placed on an existing arm.
            '''
        
        })
    '''
    Length of arm. Note that a new light may be placed on an existing arm.
    '''
    
    lampKind: Optional[ StreetlightLampKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Lamp kind.
            '''
        
        })
    '''
    Lamp kind.
    '''
    
    lightRating: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power rating of light.
            '''
        
        })
    '''
    Power rating of light.
    '''
    
    Pole: Optional[Pole] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Pole.Streetlights',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Pole to which thiss streetlight is attached.
            '''
        
        })
    '''
    Pole to which thiss streetlight is attached.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StructureSupport(Asset):
    '''
    Support for structure assets.
    '''

    anchorRodCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if anchor) Number of rods used.
            '''
        
        })
    '''
    (if anchor) Number of rods used.
    '''
    
    size: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Size of this support structure.
            '''
        
        })
    '''
    Size of this support structure.
    '''
    
    anchorKind: Optional[ AnchorKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if anchor) Kind of anchor.
            '''
        
        })
    '''
    (if anchor) Kind of anchor.
    '''
    
    anchorRodLength: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if anchor) Length of rod used.
            '''
        
        })
    '''
    (if anchor) Length of rod used.
    '''
    
    direction: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Direction of this support structure.
            '''
        
        })
    '''
    Direction of this support structure.
    '''
    
    kind: Optional[ StructureSupportKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of structure support.
            '''
        
        })
    '''
    Kind of structure support.
    '''
    
    length: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Length of this support structure.
            '''
        
        })
    '''
    Length of this support structure.
    '''
    
    SecuredStructure: Optional[Structure] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Structure.StructureSupports',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The secured structure supported by this structure support.
            '''
        
        })
    '''
    The secured structure supported by this structure support.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class WorkAsset(Asset):
    '''
    Asset used to perform work.
    '''

    Crew: Optional[Crew] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Crew.WorkAssets',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Crew using this work asset.
            '''
        
        })
    '''
    Crew using this work asset.
    '''
    
    CUWorkEquipmentAsset: Optional[CUWorkEquipmentItem] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CUWorkEquipmentItem.TypeAsset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    CUWorkEquipmentAsset: Optional[CUWorkEquipmentItem] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CUWorkEquipmentItem.TypeAsset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Work'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Tool(WorkAsset):
    '''
    Tool asset.
    '''

    lastCalibrationDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if applicable) Date the tool was last calibrated.
            '''
        
        })
    '''
    (if applicable) Date the tool was last calibrated.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Work'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Vehicle(WorkAsset):
    '''
    Vehicle asset.
    '''

    odometerReadDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date and time the last odometer reading was recorded.
            '''
        
        })
    '''
    Date and time the last odometer reading was recorded.
    '''
    
    odometerReading: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Odometer reading of this vehicle as of the 'odometerReadingDateTime'. Refer
            to associated ActivityRecords for earlier readings.
            '''
        
        })
    '''
    Odometer reading of this vehicle as of the 'odometerReadingDateTime'.
    Refer to associated ActivityRecords for earlier readings.
    '''
    
    usageKind: Optional[ VehicleUsageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of usage of the vehicle.
            '''
        
        })
    '''
    Kind of usage of the vehicle.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Work'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssetDeployment(IdentifiedObject):
    '''
    Deployment of asset deployment in a power system resource role.
    '''

    likelihoodOfFailure: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Likelihood of asset failure on a scale of 1(low) to 100 (high).
            '''
        
        })
    '''
    Likelihood of asset failure on a scale of 1(low) to 100 (high).
    '''
    
    breakerApplication: Optional[ BreakerApplicationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of network role breaker is playing in this deployment (applies to
            breaker assets only).
            '''
        
        })
    '''
    Type of network role breaker is playing in this deployment (applies
    to breaker assets only).
    '''
    
    deploymentState: Optional[ DeploymentStateKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Current deployment state of asset.
            '''
        
        })
    '''
    Current deployment state of asset.
    '''
    
    facilityKind: Optional[ FacilityKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of facility (like substation or pole or building or plant or service
            center) at which asset deployed.
            '''
        
        })
    '''
    Kind of facility (like substation or pole or building or plant or service
    center) at which asset deployed.
    '''
    
    transformerApplication: Optional[ TransformerApplicationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of network role transformer is playing in this deployment (applies
            to transformer assets only).
            '''
        
        })
    '''
    Type of network role transformer is playing in this deployment (applies
    to transformer assets only).
    '''
    
    Asset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.AssetDeployment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Asset in this deployment.
            '''
        
        })
    '''
    Asset in this deployment.
    '''
    
    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.NetworkAssetDeployment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Base voltage of this network asset deployment.
            '''
        
        })
    '''
    Base voltage of this network asset deployment.
    '''
    
    Asset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.AssetDeployment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Asset in this deployment.
            '''
        
        })
    '''
    Asset in this deployment.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssetFunction(IdentifiedObject):
    '''
    Function performed by an asset.
    '''

    configID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Configuration specified for this function.
            '''
        
        })
    '''
    Configuration specified for this function.
    '''
    
    firmwareID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Firmware version.
            '''
        
        })
    '''
    Firmware version.
    '''
    
    hardwareID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Hardware version.
            '''
        
        })
    '''
    Hardware version.
    '''
    
    password: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Password needed to access this function.
            '''
        
        })
    '''
    Password needed to access this function.
    '''
    
    programID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Name of program.
            '''
        
        })
    '''
    Name of program.
    '''
    
    Asset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.AssetFunction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Asset on which this function can be performed.
            '''
        
        })
    '''
    Asset on which this function can be performed.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EndDeviceFunction(AssetFunction):
    '''
    Function performed by an end device such as a meter, communication equipment,
    controllers, etc.
    '''

    enabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if the function is enabled.
            '''
        
        })
    '''
    True if the function is enabled.
    '''
    
    EndDevice: Optional[EndDevice] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EndDevice.EndDeviceFunctions',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            End device that performs this function.
            '''
        
        })
    '''
    End device that performs this function.
    '''
    
    Registers: list[Register] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Register.EndDeviceFunction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All registers for quantities metered by this end device function.
            '''
        
        })
    '''
    All registers for quantities metered by this end device function.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ComFunction(EndDeviceFunction):
    '''
    Communication function of communication equipment or a device such as a
    meter.
    '''

    amrAddress: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Communication ID number (e.g. serial number, IP address, telephone number,
            etc.) of the AMR module which serves this meter.
            '''
        
        })
    '''
    Communication ID number (e.g. serial number, IP address, telephone
    number, etc.) of the AMR module which serves this meter.
    '''
    
    amrRouter: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Communication ID number (e.g. port number, serial number, data collector
            ID, etc.) of the parent device associated to this AMR module.
            '''
        
        })
    '''
    Communication ID number (e.g. port number, serial number, data collector
    ID, etc.) of the parent device associated to this AMR module.
    '''
    
    direction: Optional[ ComDirectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of communication direction.
            '''
        
        })
    '''
    Kind of communication direction.
    '''
    
    technology: Optional[ ComTechnologyKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of communication technology.
            '''
        
        })
    '''
    Kind of communication technology.
    '''
    
    ComModule: Optional[ComModule] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ComModule.ComFunctions',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Module performing this communication function.
            '''
        
        })
    '''
    Module performing this communication function.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConnectDisconnectFunction(EndDeviceFunction):
    '''
    A function that will disconnect and reconnect the customer's load under
    defined conditions.
    '''

    eventCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Running cumulative count of connect or disconnect events, for the lifetime
            of this function or until the value is cleared.
            '''
        
        })
    '''
    Running cumulative count of connect or disconnect events, for the lifetime
    of this function or until the value is cleared.
    '''
    
    isConnected: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if this function is in the connected state.
            '''
        
        })
    '''
    True if this function is in the connected state.
    '''
    
    isDelayedDiscon: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set true, the switch may disconnect the service at the end of a specified
            time delay after the disconnect signal has been given. If set false, the
            switch may disconnect the service immediately after the disconnect signal
            has been given. This is typically the case for over current circuit-breakers
            which are classified as either instantaneous or slow acting.
            '''
        
        })
    '''
    If set true, the switch may disconnect the service at the end of a
    specified time delay after the disconnect signal has been given. If
    set false, the switch may disconnect the service immediately after
    the disconnect signal has been given. This is typically the case for
    over current circuit-breakers which are classified as either instantaneous
    or slow acting.
    '''
    
    isLocalAutoDisconOp: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set true and if disconnection can be operated locally, the operation
            happens automatically. Otherwise it happens manually.
            '''
        
        })
    '''
    If set true and if disconnection can be operated locally, the operation
    happens automatically. Otherwise it happens manually.
    '''
    
    isLocalAutoReconOp: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set true and if reconnection can be operated locally, then the operation
            happens automatically. Otherwise, it happens manually.
            '''
        
        })
    '''
    If set true and if reconnection can be operated locally, then the operation
    happens automatically. Otherwise, it happens manually.
    '''
    
    isRemoteAutoDisconOp: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set true and if disconnection can be operated remotely, then the operation
            happens automatically. If set false and if disconnection can be operated
            remotely, then the operation happens manually.
            '''
        
        })
    '''
    If set true and if disconnection can be operated remotely, then the
    operation happens automatically. If set false and if disconnection
    can be operated remotely, then the operation happens manually.
    '''
    
    isRemoteAutoReconOp: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If set true and if reconnection can be operated remotely, then the operation
            happens automatically. If set false and if reconnection can be operated
            remotely, then the operation happens manually.
            '''
        
        })
    '''
    If set true and if reconnection can be operated remotely, then the
    operation happens automatically. If set false and if reconnection can
    be operated remotely, then the operation happens manually.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadControl'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SimpleEndDeviceFunction(EndDeviceFunction):
    '''
    Simple end device function distinguished by 'kind'. Use this class for
    instances that cannot be represented by another end device function specialisations.
    '''

    kind: Optional[ EndDeviceFunctionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of this function.
            '''
        
        })
    '''
    Kind of this function.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssetInfo(IdentifiedObject):
    '''
    Set of attributes of an asset, representing typical datasheet information
    of a physical device that can be instantiated and shared in different data
    exchange contexts:
    - as attributes of an asset instance (installed or in stock)
    - as attributes of an asset model (product by a manufacturer)
    - as attributes of a type asset (generic type of an asset as used in designs/extension
    planning).
    '''

    CatalogAssetType: Optional[CatalogAssetType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CatalogAssetType.AssetInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Asset information (nameplate) for this catalog asset type.
            '''
        
        })
    '''
    Asset information (nameplate) for this catalog asset type.
    '''
    
    ProductAssetModel: Optional[ProductAssetModel] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ProductAssetModel.AssetInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Product asset model which conforms to this catalog asset type.
            '''
        
        })
    '''
    Product asset model which conforms to this catalog asset type.
    '''
    
    Assets: list[Asset] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Asset.AssetInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All assets described by this data.
            '''
        
        })
    '''
    All assets described by this data.
    '''
    
    CatalogAssetType: Optional[CatalogAssetType] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CatalogAssetType.AssetInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Asset information (nameplate) for this catalog asset type.
            '''
        
        })
    '''
    Asset information (nameplate) for this catalog asset type.
    '''
    
    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.AssetDatasheet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All power system resources with this datasheet information.
            '''
        
        })
    '''
    All power system resources with this datasheet information.
    '''
    
    ProductAssetModel: Optional[ProductAssetModel] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ProductAssetModel.AssetInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Product asset model which conforms to this catalog asset type.
            '''
        
        })
    '''
    Product asset model which conforms to this catalog asset type.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BusbarSectionInfo(AssetInfo):
    '''
    Busbar section data.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BushingInfo(AssetInfo):
    '''
    Bushing datasheet information.
    '''

    c1Capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Factory measured capacitance, measured between the power factor tap and
            the bushing conductor.
            '''
        
        })
    '''
    Factory measured capacitance, measured between the power factor tap
    and the bushing conductor.
    '''
    
    c1PowerFactor: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Factory measured insulation power factor, measured between the power factor
            tap and the bushing conductor.
            '''
        
        })
    '''
    Factory measured insulation power factor, measured between the power
    factor tap and the bushing conductor.
    '''
    
    c2Capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Factory measured capacitance measured between the power factor tap and
            ground.
            '''
        
        })
    '''
    Factory measured capacitance measured between the power factor tap
    and ground.
    '''
    
    c2PowerFactor: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Factory measured insulation power factor, measured between the power factor
            tap and ground.
            '''
        
        })
    '''
    Factory measured insulation power factor, measured between the power
    factor tap and ground.
    '''
    
    insulationKind: Optional[ BushingInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of insulation.
            '''
        
        })
    '''
    Kind of insulation.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current for bushing as installed.
            '''
        
        })
    '''
    Rated current for bushing as installed.
    '''
    
    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
            '''
        
        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''
    
    ratedLineToGroundVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated line-to-ground voltage. Also referred to as Uy on bushing nameplate.
            '''
        
        })
    '''
    Rated line-to-ground voltage. Also referred to as Uy on bushing nameplate.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage. Can be referred to as Um, system voltage or class on bushing
            nameplate.
            '''
        
        })
    '''
    Rated voltage. Can be referred to as Um, system voltage or class on
    bushing nameplate.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CompositeSwitchInfo(AssetInfo):
    '''
    Properties of a composite switch.
    '''

    ganged: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if multi-phase switch controls all phases concurrently.
            '''
        
        })
    '''
    True if multi-phase switch controls all phases concurrently.
    '''
    
    initOpMode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Initial operating mode, with the following values: Automatic, Manual.
            '''
        
        })
    '''
    Initial operating mode, with the following values: Automatic, Manual.
    '''
    
    phaseCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Supported number of phases, typically 0, 1 or 3.
            '''
        
        })
    '''
    Supported number of phases, typically 0, 1 or 3.
    '''
    
    remote: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if device is capable of being operated by remote control.
            '''
        
        })
    '''
    True if device is capable of being operated by remote control.
    '''
    
    switchStateCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of switch states represented by the composite switch.
            '''
        
        })
    '''
    Number of switch states represented by the composite switch.
    '''
    
    interruptingRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Breaking capacity, or short circuit rating, is the maximum rated current
            which the device can safely interrupt at the rated voltage.
            '''
        
        })
    '''
    Breaking capacity, or short circuit rating, is the maximum rated current
    which the device can safely interrupt at the rated voltage.
    '''
    
    kind: Optional[ CompositeSwitchKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of composite switch.
            '''
        
        })
    '''
    Kind of composite switch.
    '''
    
    phaseCode: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phases carried, if applicable.
            '''
        
        })
    '''
    Phases carried, if applicable.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CurrentTransformerInfo(AssetInfo):
    '''
    Properties of current transformer asset.
    '''

    accuracyClass: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            CT accuracy classification.
            '''
        
        })
    '''
    CT accuracy classification.
    '''
    
    coreCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of cores.
            '''
        
        })
    '''
    Number of cores.
    '''
    
    ctClass: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    usage: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Usage: eg. metering, protection, etc.
            '''
        
        })
    '''
    Usage: eg. metering, protection, etc.
    '''
    
    accuracyLimit: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Accuracy limit.
            '''
        
        })
    '''
    Accuracy limit.
    '''
    
    kneePointCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum primary current where the CT still displays linear characteristicts.
            '''
        
        })
    '''
    Maximum primary current where the CT still displays linear characteristicts.
    '''
    
    kneePointVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum voltage across the secondary terminals where the CT still displays
            linear characteristicts.
            '''
        
        })
    '''
    Maximum voltage across the secondary terminals where the CT still displays
    linear characteristicts.
    '''
    
    primaryFlsRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Full load secondary (FLS) rating for primary winding.
            '''
        
        })
    '''
    Full load secondary (FLS) rating for primary winding.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current on the primary side.
            '''
        
        })
    '''
    Rated current on the primary side.
    '''
    
    secondaryFlsRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Full load secondary (FLS) rating for secondary winding.
            '''
        
        })
    '''
    Full load secondary (FLS) rating for secondary winding.
    '''
    
    tertiaryFlsRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Full load secondary (FLS) rating for tertiary winding.
            '''
        
        })
    '''
    Full load secondary (FLS) rating for tertiary winding.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EndDeviceInfo(AssetInfo):
    '''
    End device data.
    '''

    isSolidState: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, this is a solid state end device (as opposed to a mechanical or
            electromechanical device).
            '''
        
        })
    '''
    If true, this is a solid state end device (as opposed to a mechanical
    or electromechanical device).
    '''
    
    phaseCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of potential phases the end device supports, typically 0, 1 or 3.
            '''
        
        })
    '''
    Number of potential phases the end device supports, typically 0, 1
    or 3.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    EndDevices: list[EndDevice] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EndDevice.EndDeviceInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All end devices described with this data.
            '''
        
        })
    '''
    All end devices described with this data.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FaultIndicatorInfo(AssetInfo):
    '''
    Parameters of fault indicator asset.
    '''

    resetKind: Optional[ FaultIndicatorResetKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of reset mechanisim of this fault indicator.
            '''
        
        })
    '''
    Kind of reset mechanisim of this fault indicator.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class InterrupterUnitInfo(AssetInfo):
    '''
    Interrupter datasheet information.
    '''

    interruptingMedium: Optional[ InterruptingMediumKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Interrupting medium.
            '''
        
        })
    '''
    Interrupting medium.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperatingMechanismInfo(AssetInfo):
    '''
    Breaker operating mechanism datasheet information.
    '''

    closeAmps: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Close current (nominal).
            '''
        
        })
    '''
    Close current (nominal).
    '''
    
    closeVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Close voltage in volts DC.
            '''
        
        })
    '''
    Close voltage in volts DC.
    '''
    
    mechanismKind: Optional[ OperatingMechanismKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of breaker operating mechanism.
            '''
        
        })
    '''
    Kind of breaker operating mechanism.
    '''
    
    motorRunCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated motor run current in amps.
            '''
        
        })
    '''
    Rated motor run current in amps.
    '''
    
    motorStartCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated motor start current in amps.
            '''
        
        })
    '''
    Rated motor start current in amps.
    '''
    
    motorVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Nominal motor voltage in volts DC.
            '''
        
        })
    '''
    Nominal motor voltage in volts DC.
    '''
    
    tripAmps: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Trip current (nominal).
            '''
        
        })
    '''
    Trip current (nominal).
    '''
    
    tripVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Trip voltage in volts DC.
            '''
        
        })
    '''
    Trip voltage in volts DC.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PotentialTransformerInfo(AssetInfo):
    '''
    Properties of potential transformer asset.
    '''

    accuracyClass: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ptClass: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage on the primary side.
            '''
        
        })
    '''
    Rated voltage on the primary side.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerTransformerInfo(AssetInfo):
    '''
    Set of power transformer data, from an equipment library.
    '''

    TransformerTankInfos: list[TransformerTankInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTankInfo.PowerTransformerInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Data for all the tanks described by this power transformer data.
            '''
        
        })
    '''
    Data for all the tanks described by this power transformer data.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ProtectionEquipmentInfo(AssetInfo):
    '''
    Properties of protection equipment asset.
    '''

    groundTrip: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Actual ground trip for this type of relay, if applicable.
            '''
        
        })
    '''
    Actual ground trip for this type of relay, if applicable.
    '''
    
    phaseTrip: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Actual phase trip for this type of relay, if applicable.
            '''
        
        })
    '''
    Actual phase trip for this type of relay, if applicable.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class ShuntCompensatorInfo(AssetInfo):
    '''
    Properties of shunt capacitor, shunt reactor or switchable bank of shunt
    capacitor or reactor assets.
    '''

    maxPowerLoss: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum allowed apparent power loss.
            '''
        
        })
    '''
    Maximum allowed apparent power loss.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated reactive power.
            '''
        
        })
    '''
    Rated reactive power.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    ShuntCompensatorControl: Optional[ShuntCompensatorControl] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorControl.ShuntCompensatorInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ShuntCompensatorControl: Optional[ShuntCompensatorControl] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorControl.ShuntCompensatorInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SurgeArresterInfo(AssetInfo):
    '''
    Properties of surge arrester.
    '''

    isPolymer: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, the arrester has a polymer housing, porcelain otherwise.
            '''
        
        })
    '''
    If true, the arrester has a polymer housing, porcelain otherwise.
    '''
    
    lineDischargeClass: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Determines the arrester energy discharge capability. Choices are limited
            to 0 (none) through 5 (highest) by IEC 60099. Classes 1..3 require a 10-kA
            nominal discharge current. Classes 4..5 require a 20-kA nominal discharge
            current. Lower nominal discharge currents must use class 0.
            '''
        
        })
    '''
    Determines the arrester energy discharge capability. Choices are limited
    to 0 (none) through 5 (highest) by IEC 60099. Classes 1..3 require
    a 10-kA nominal discharge current. Classes 4..5 require a 20-kA nominal
    discharge current. Lower nominal discharge currents must use class
    0.
    '''
    
    continuousOperatingVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum continuous power frequency voltage allowed on the surge arrester.
            '''
        
        })
    '''
    Maximum continuous power frequency voltage allowed on the surge arrester.
    '''
    
    lightningImpulseDischargeVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Residual voltage during an 8x20 microsecond current impulse at the nominal
            discharge current level.
            '''
        
        })
    '''
    Residual voltage during an 8x20 microsecond current impulse at the
    nominal discharge current level.
    '''
    
    nominalDischargeCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The lightning discharge current used to classify the arrester. Choices
            are limited to 1.5, 2.5, 5, 10, and 20 kA by IEC 60099.
            '''
        
        })
    '''
    The lightning discharge current used to classify the arrester. Choices
    are limited to 1.5, 2.5, 5, 10, and 20 kA by IEC 60099.
    '''
    
    pressureReliefClass: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fault current level at which all parts of the failed arrester lie within
            a circle prescribed by IEC 60099.
            '''
        
        })
    '''
    Fault current level at which all parts of the failed arrester lie within
    a circle prescribed by IEC 60099.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The temporary overvoltage (TOV) level at power frequency that the surge
            arrester withstands for 10 seconds.
            '''
        
        })
    '''
    The temporary overvoltage (TOV) level at power frequency that the surge
    arrester withstands for 10 seconds.
    '''
    
    steepFrontDischargeVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Residual voltage during a current impulse with front time of 1 microsecond,
            and magnitude equal to the nominal discharge current level.
            '''
        
        })
    '''
    Residual voltage during a current impulse with front time of 1 microsecond,
    and magnitude equal to the nominal discharge current level.
    '''
    
    switchingImpulseDischargeVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Residual voltage during a current impulse with front time of at least 30
            microseconds, and magnitude specified in IEC 60099 for the line discharge
            class. Does not apply to line discharge class 0.
            '''
        
        })
    '''
    Residual voltage during a current impulse with front time of at least
    30 microseconds, and magnitude specified in IEC 60099 for the line
    discharge class. Does not apply to line discharge class 0.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SwitchInfo(AssetInfo):
    '''
    <was Switch data.>
    Switch datasheet information.
    '''

    isSinglePhase: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, it is a single phase switch.
            '''
        
        })
    '''
    If true, it is a single phase switch.
    '''
    
    isUnganged: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, the switch is not ganged (i.e., a switch phase may be operated
            separately from other phases).
            '''
        
        })
    '''
    If true, the switch is not ganged (i.e., a switch phase may be operated
    separately from other phases).
    '''
    
    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum fault current a breaking device can break safely under prescribed
            conditions of use.
            '''
        
        })
    '''
    The maximum fault current a breaking device can break safely under
    prescribed conditions of use.
    '''
    
    gasWeightPerTank: Optional[ float | Mass ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Weight of gas in each tank of SF6 dead tank breaker.
            '''
        
        })
    '''
    Weight of gas in each tank of SF6 dead tank breaker.
    '''
    
    lowPressureAlarm: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Gas or air pressure at or below which a low pressure alarm is generated.
            '''
        
        })
    '''
    Gas or air pressure at or below which a low pressure alarm is generated.
    '''
    
    lowPressureLockOut: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Gas or air pressure below which the breaker will not open.
            '''
        
        })
    '''
    Gas or air pressure below which the breaker will not open.
    '''
    
    oilVolumePerTank: Optional[ float | Volume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Volume of oil in each tank of bulk oil breaker.
            '''
        
        })
    '''
    Volume of oil in each tank of bulk oil breaker.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Frequency for which switch is rated.
            '''
        
        })
    '''
    Frequency for which switch is rated.
    '''
    
    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
            '''
        
        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''
    
    ratedInterruptingTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Switch rated interrupting time in seconds.
            '''
        
        })
    '''
    Switch rated interrupting time in seconds.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OldSwitchInfo(SwitchInfo):
    '''
    Properties of switch assets.
    '''

    loadBreak: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if switch has load breaking capabiity. Unless specified false, this
            is always assumed to be true for breakers and reclosers.
            '''
        
        })
    '''
    True if switch has load breaking capabiity. Unless specified false,
    this is always assumed to be true for breakers and reclosers.
    '''
    
    poleCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of poles (i.e. of current carrying conductors that are switched).
            '''
        
        })
    '''
    Number of poles (i.e. of current carrying conductors that are switched).
    '''
    
    remote: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if device is capable of being operated by remote control.
            '''
        
        })
    '''
    True if device is capable of being operated by remote control.
    '''
    
    dielectricStrength: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum rms voltage that may be applied across an open contact without
            breaking down the dielectric properties of the switch in the open position.
            '''
        
        })
    '''
    The maximum rms voltage that may be applied across an open contact
    without breaking down the dielectric properties of the switch in the
    open position.
    '''
    
    makingCapacity: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The highest value of current the switch can make at the rated voltage under
            specified operating conditions without suffering significant deterioration
            of its performance.
            '''
        
        })
    '''
    The highest value of current the switch can make at the rated voltage
    under specified operating conditions without suffering significant
    deterioration of its performance.
    '''
    
    minimumCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The lowest value of current that the switch can make, carry and break in
            uninterrupted duty at the rated voltage under specified operating conditions
            without suffering significant deterioration of its performance.
            '''
        
        })
    '''
    The lowest value of current that the switch can make, carry and break
    in uninterrupted duty at the rated voltage under specified operating
    conditions without suffering significant deterioration of its performance.
    '''
    
    withstandCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The highest value of current the switch can carry in the closed position
            at the rated voltage under specified operating conditions without suffering
            significant deterioration of its performance.
            '''
        
        })
    '''
    The highest value of current the switch can carry in the closed position
    at the rated voltage under specified operating conditions without suffering
    significant deterioration of its performance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BreakerInfo(OldSwitchInfo):
    '''
    Properties of breaker assets.
    '''

    phaseTrip: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase trip rating.
            '''
        
        })
    '''
    Phase trip rating.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RecloserInfo(OldSwitchInfo):
    '''
    Properties of recloser assets.
    '''

    groundTripCapable: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if device has ground trip capability.
            '''
        
        })
    '''
    True if device has ground trip capability.
    '''
    
    groundTripNormalEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if normal status of ground trip is enabled.
            '''
        
        })
    '''
    True if normal status of ground trip is enabled.
    '''
    
    recloseLockoutCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Total number of phase reclose operations.
            '''
        
        })
    '''
    Total number of phase reclose operations.
    '''
    
    groundTripRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Ground trip rating.
            '''
        
        })
    '''
    Ground trip rating.
    '''
    
    phaseTripRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase trip rating.
            '''
        
        })
    '''
    Phase trip rating.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapChangerInfo(AssetInfo):
    '''
    Tap changer data.
    '''

    ctRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Built-in current transducer ratio.
            '''
        
        })
    '''
    Built-in current transducer ratio.
    '''
    
    highStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Highest possible tap step position, advance from neutral.
            '''
        
        })
    '''
    Highest possible tap step position, advance from neutral.
    '''
    
    isTcul: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Whether this tap changer has under load tap changing capabilities.
            '''
        
        })
    '''
    Whether this tap changer has under load tap changing capabilities.
    '''
    
    lowStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Lowest possible tap step position, retard from neutral.
            '''
        
        })
    '''
    Lowest possible tap step position, retard from neutral.
    '''
    
    neutralStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The neutral tap step position for the winding.
            '''
        
        })
    '''
    The neutral tap step position for the winding.
    '''
    
    ptRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Built-in voltage transducer ratio.
            '''
        
        })
    '''
    Built-in voltage transducer ratio.
    '''
    
    bil: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Basic Insulation Level (BIL) expressed as the impulse crest voltage of
            a nominal wave, typically 1.2 X 50 microsecond. This is a measure of the
            ability of the insulation to withstand very high voltage surges.
            '''
        
        })
    '''
    Basic Insulation Level (BIL) expressed as the impulse crest voltage
    of a nominal wave, typically 1.2 X 50 microsecond. This is a measure
    of the ability of the insulation to withstand very high voltage surges.
    '''
    
    ctRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Built-in current transformer primary rating.
            '''
        
        })
    '''
    Built-in current transformer primary rating.
    '''
    
    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Frequency at which the ratings apply.
            '''
        
        })
    '''
    Frequency at which the ratings apply.
    '''
    
    neutralU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Voltage at which the winding operates at the neutral tap setting.
            '''
        
        })
    '''
    Voltage at which the winding operates at the neutral tap setting.
    '''
    
    ratedApparentPower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated apparent power.
            '''
        
        })
    '''
    Rated apparent power.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    stepPhaseIncrement: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phase shift per step position.
            '''
        
        })
    '''
    Phase shift per step position.
    '''
    
    stepVoltageIncrement: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Tap step increment, in per cent of rated voltage, per step position.
            '''
        
        })
    '''
    Tap step increment, in per cent of rated voltage, per step position.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerEndInfo(AssetInfo):
    '''
    Transformer end data.
    '''

    endNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number for this transformer end, corresponding to the end's order in the
            PowerTransformer.vectorGroup attribute. Highest voltage winding should
            be 1.
            '''
        
        })
    '''
    Number for this transformer end, corresponding to the end's order in
    the PowerTransformer.vectorGroup attribute. Highest voltage winding
    should be 1.
    '''
    
    phaseAngleClock: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Winding phase angle where 360 degrees are represented with clock hours,
            so the valid values are {0, ..., 11}. For example, to express the second
            winding in code 'Dyn11', set attributes as follows: 'endNumber'=2, 'connectionKind'
            = Yn and 'phaseAngleClock' = 11.
            '''
        
        })
    '''
    Winding phase angle where 360 degrees are represented with clock hours,
    so the valid values are {0, ..., 11}. For example, to express the second
    winding in code 'Dyn11', set attributes as follows: 'endNumber'=2,
    'connectionKind' = Yn and 'phaseAngleClock' = 11.
    '''
    
    connectionKind: Optional[ WindingConnection ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of connection.
            '''
        
        })
    '''
    Kind of connection.
    '''
    
    emergencyS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Apparent power that the winding can carry under emergency conditions (also
            called long-term emergency power).
            '''
        
        })
    '''
    Apparent power that the winding can carry under emergency conditions
    (also called long-term emergency power).
    '''
    
    insulationU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Basic insulation level voltage rating.
            '''
        
        })
    '''
    Basic insulation level voltage rating.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            DC resistance.
            '''
        
        })
    '''
    DC resistance.
    '''
    
    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Normal apparent power rating.
            '''
        
        })
    '''
    Normal apparent power rating.
    '''
    
    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Rated voltage: phase-phase for three-phase windings, and either phase-phase
            or phase-neutral for single-phase windings.
            '''
        
        })
    '''
    Rated voltage: phase-phase for three-phase windings, and either phase-phase
    or phase-neutral for single-phase windings.
    '''
    
    shortTermS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Apparent power that this winding can carry for a short period of time (in
            emergency).
            '''
        
        })
    '''
    Apparent power that this winding can carry for a short period of time
    (in emergency).
    '''
    
    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Core admittance calculated from this transformer end datasheet, representing
            magnetising current and core losses. The full values of the transformer
            should be supplied for one transformer end info only.
            '''
        
        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''
    
    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer star impedance calculated from this transformer end datasheet.
            '''
        
        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''
    
    TransformerTankInfo: Optional[TransformerTankInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'TransformerTankInfo.TransformerEndInfos',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transformer tank data that this end description is part of.
            '''
        
        })
    '''
    Transformer tank data that this end description is part of.
    '''
    
    EnergisedEndNoLoadTests: list[NoLoadTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NoLoadTest.EnergisedEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All no-load test measurements in which this transformer end was energised.
            '''
        
        })
    '''
    All no-load test measurements in which this transformer end was energised.
    '''
    
    EnergisedEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OpenCircuitTest.EnergisedEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All open-circuit test measurements in which this transformer end was excited.
            '''
        
        })
    '''
    All open-circuit test measurements in which this transformer end was
    excited.
    '''
    
    OpenEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OpenCircuitTest.OpenEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All open-circuit test measurements in which this transformer end was not
            excited.
            '''
        
        })
    '''
    All open-circuit test measurements in which this transformer end was
    not excited.
    '''
    
    EnergisedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitTest.EnergisedEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All short-circuit test measurements in which this transformer end was energised.
            '''
        
        })
    '''
    All short-circuit test measurements in which this transformer end was
    energised.
    '''
    
    GroundedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitTest.GroundedEnds',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All short-circuit test measurements in which this transformer end was short-circuited.
            '''
        
        })
    '''
    All short-circuit test measurements in which this transformer end was
    short-circuited.
    '''
    
    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Core admittance calculated from this transformer end datasheet, representing
            magnetising current and core losses. The full values of the transformer
            should be supplied for one transformer end info only.
            '''
        
        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''
    
    FromMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerMeshImpedance.FromTransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All mesh impedances between this 'to' and other 'from' transformer ends.
            '''
        
        })
    '''
    All mesh impedances between this 'to' and other 'from' transformer
    ends.
    '''
    
    ToMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerMeshImpedance.ToTransformerEndInfos',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All mesh impedances between this 'from' and other 'to' transformer ends.
            '''
        
        })
    '''
    All mesh impedances between this 'from' and other 'to' transformer
    ends.
    '''
    
    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Transformer star impedance calculated from this transformer end datasheet.
            '''
        
        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OldTransformerEndInfo(TransformerEndInfo):
    '''
    '''

    dayOverLoadRating: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Overload rating for 24 hours.
            '''
        
        })
    '''
    Overload rating for 24 hours.
    '''
    
    hourOverLoadRating: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Overload rating for 1 hour.
            '''
        
        })
    '''
    Overload rating for 1 hour.
    '''
    
    solidInsulationWeight: Optional[ float | Mass ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Weight of solid insultation in transformer.
            '''
        
        })
    '''
    Weight of solid insultation in transformer.
    '''
    
    windingInsulationKind: Optional[ WindingInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of insultation used for transformer windings.
            '''
        
        })
    '''
    Type of insultation used for transformer windings.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerTankInfo(AssetInfo):
    '''
    Set of transformer tank data, from an equipment library.
    '''

    PowerTransformerInfo: Optional[PowerTransformerInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'PowerTransformerInfo.TransformerTankInfos',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power transformer data that this tank description is part of.
            '''
        
        })
    '''
    Power transformer data that this tank description is part of.
    '''
    
    TransformerEndInfos: list[TransformerEndInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEndInfo.TransformerTankInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Data for all the ends described by this transformer tank data.
            '''
        
        })
    '''
    Data for all the ends described by this transformer tank data.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OldTransformerTankInfo(TransformerTankInfo):
    '''
    '''

    constructionKind: Optional[ TransformerConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of construction for this transformer.
            '''
        
        })
    '''
    Kind of construction for this transformer.
    '''
    
    coreCoilsWeight: Optional[ float | Mass ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Weight of core and coils in transformer.
            '''
        
        })
    '''
    Weight of core and coils in transformer.
    '''
    
    coreKind: Optional[ TransformerCoreKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Core kind of this transformer product.
            '''
        
        })
    '''
    Core kind of this transformer product.
    '''
    
    function: Optional[ TransformerFunctionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Function of this transformer.
            '''
        
        })
    '''
    Function of this transformer.
    '''
    
    neutralBIL: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Basic insulation level of neutral.
            '''
        
        })
    '''
    Basic insulation level of neutral.
    '''
    
    oilPreservationKind: Optional[ OilPreservationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of oil preservation system.
            '''
        
        })
    '''
    Kind of oil preservation system.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WireAssemblyInfo(AssetInfo):
    '''
    Describes the construction of a multi-conductor wire.
    '''

    PerLengthLineParameter: list[PerLengthLineParameter] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PerLengthLineParameter.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Per length line parameter associated with this wire assembly.
            '''
        
        })
    '''
    Per length line parameter associated with this wire assembly.
    '''
    
    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Wire phase information associated with this wire assembly.
            '''
        
        })
    '''
    Wire phase information associated with this wire assembly.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WireInfo(AssetInfo):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    coreStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if used) Number of strands in the steel core.
            '''
        
        })
    '''
    (if used) Number of strands in the steel core.
    '''
    
    insulated: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if conductor is insulated.
            '''
        
        })
    '''
    True if conductor is insulated.
    '''
    
    sizeDescription: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
            '''
        
        })
    '''
    Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
    '''
    
    strandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of strands in the conductor.
            '''
        
        })
    '''
    Number of strands in the conductor.
    '''
    
    coreRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if there is a different core material) Radius of the central core.
            '''
        
        })
    '''
    (if there is a different core material) Radius of the central core.
    '''
    
    gmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Geometric mean radius. If we replace the conductor by a thin walled tube
            of radius GMR, then its reactance is identical to the reactance of the
            actual conductor.
            '''
        
        })
    '''
    Geometric mean radius. If we replace the conductor by a thin walled
    tube of radius GMR, then its reactance is identical to the reactance
    of the actual conductor.
    '''
    
    insulationMaterial: Optional[ WireInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if insulated conductor) Material used for insulation.
            '''
        
        })
    '''
    (if insulated conductor) Material used for insulation.
    '''
    
    insulationThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            (if insulated conductor) Thickness of the insulation.
            '''
        
        })
    '''
    (if insulated conductor) Thickness of the insulation.
    '''
    
    material: Optional[ WireMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Conductor material.
            '''
        
        })
    '''
    Conductor material.
    '''
    
    rAC25: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            AC resistance per unit length of the conductor at 25 �C.
            '''
        
        })
    '''
    AC resistance per unit length of the conductor at 25 �C.
    '''
    
    rAC50: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            AC resistance per unit length of the conductor at 50 �C.
            '''
        
        })
    '''
    AC resistance per unit length of the conductor at 50 �C.
    '''
    
    rAC75: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            AC resistance per unit length of the conductor at 75 �C.
            '''
        
        })
    '''
    AC resistance per unit length of the conductor at 75 �C.
    '''
    
    radius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Outside radius of the wire.
            '''
        
        })
    '''
    Outside radius of the wire.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Current carrying capacity of the wire under stated thermal conditions.
            '''
        
        })
    '''
    Current carrying capacity of the wire under stated thermal conditions.
    '''
    
    rDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            DC resistance per unit length of the conductor at 20 �C.
            '''
        
        })
    '''
    DC resistance per unit length of the conductor at 20 �C.
    '''
    
    ACLineSegmentPhase: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.WireInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            AC line segment phase information associated with this wire information.
            '''
        
        })
    '''
    AC line segment phase information associated with this wire information.
    '''
    
    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Wire phase information associated with this wire information.
            '''
        
        })
    '''
    Wire phase information associated with this wire information.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CableInfo(WireInfo):
    '''
    Cable data.
    '''

    isStrandFill: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if wire strands are extruded in a way to fill the voids in the cable.
            '''
        
        })
    '''
    True if wire strands are extruded in a way to fill the voids in the
    cable.
    '''
    
    sheathAsNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if sheath / shield is used as a neutral (i.e., bonded).
            '''
        
        })
    '''
    True if sheath / shield is used as a neutral (i.e., bonded).
    '''
    
    constructionKind: Optional[ CableConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of construction of this cable.
            '''
        
        })
    '''
    Kind of construction of this cable.
    '''
    
    diameterOverCore: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter over the core, including any semi-con screen; should be the insulating
            layer's inside diameter.
            '''
        
        })
    '''
    Diameter over the core, including any semi-con screen; should be the
    insulating layer's inside diameter.
    '''
    
    diameterOverInsulation: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter over the insulating layer, excluding outer screen.
            '''
        
        })
    '''
    Diameter over the insulating layer, excluding outer screen.
    '''
    
    diameterOverJacket: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter over the outermost jacketing layer.
            '''
        
        })
    '''
    Diameter over the outermost jacketing layer.
    '''
    
    diameterOverScreen: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter over the outer screen; should be the shield's inside diameter.
            '''
        
        })
    '''
    Diameter over the outer screen; should be the shield's inside diameter.
    '''
    
    nominalTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum nominal design operating temperature.
            '''
        
        })
    '''
    Maximum nominal design operating temperature.
    '''
    
    outerJacketKind: Optional[ CableOuterJacketKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of outer jacket of this cable.
            '''
        
        })
    '''
    Kind of outer jacket of this cable.
    '''
    
    shieldMaterial: Optional[ CableShieldMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Material of the shield.
            '''
        
        })
    '''
    Material of the shield.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConcentricNeutralCableInfo(CableInfo):
    '''
    Concentric neutral cable data.
    '''

    neutralStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of concentric neutral strands.
            '''
        
        })
    '''
    Number of concentric neutral strands.
    '''
    
    diameterOverNeutral: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter over the concentric neutral strands.
            '''
        
        })
    '''
    Diameter over the concentric neutral strands.
    '''
    
    neutralStrandGmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Geometric mean radius of the neutral strand.
            '''
        
        })
    '''
    Geometric mean radius of the neutral strand.
    '''
    
    neutralStrandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Outside radius of the neutral strand.
            '''
        
        })
    '''
    Outside radius of the neutral strand.
    '''
    
    neutralStrandRDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            DC resistance per unit length of the neutral strand at 20 �C.
            '''
        
        })
    '''
    DC resistance per unit length of the neutral strand at 20 �C.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapeShieldCableInfo(CableInfo):
    '''
    Tape shield cable data.
    '''

    tapeLap: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Percentage of the tape shield width that overlaps in each wrap, typically
            10% to 25%.
            '''
        
        })
    '''
    Percentage of the tape shield width that overlaps in each wrap, typically
    10% to 25%.
    '''
    
    tapeThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Thickness of the tape shield, before wrapping.
            '''
        
        })
    '''
    Thickness of the tape shield, before wrapping.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OverheadWireInfo(WireInfo):
    '''
    Overhead wire data.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WireSpacingInfo(AssetInfo):
    '''
    Wire spacing data that associates multiple wire positions with the line
    segment, and allows to calculate line segment impedances. Number of phases
    can be derived from the number of associated wire positions whose phase
    is not neutral.
    '''

    isCable: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, this spacing data describes a cable.
            '''
        
        })
    '''
    If true, this spacing data describes a cable.
    '''
    
    phaseWireCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Number of wire sub-conductors in the symmetrical bundle (typically between
            1 and 4).
            '''
        
        })
    '''
    Number of wire sub-conductors in the symmetrical bundle (typically
    between 1 and 4).
    '''
    
    phaseWireSpacing: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Distance between wire sub-conductors in a symmetrical bundle.
            '''
        
        })
    '''
    Distance between wire sub-conductors in a symmetrical bundle.
    '''
    
    usage: Optional[ WireUsageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Usage of the associated wires.
            '''
        
        })
    '''
    Usage of the associated wires.
    '''
    
    DuctBank: Optional[DuctBank] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DuctBank.WireSpacingInfos',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ACLineSegment: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The AC line segment defined by the wire spacing information
            '''
        
        })
    '''
    The AC line segment defined by the wire spacing information
    '''
    
    WirePositions: list[WirePosition] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePosition.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All positions of single wires (phase or neutral) making the conductor.
            '''
        
        })
    '''
    All positions of single wires (phase or neutral) making the conductor.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class AssetModelCatalogue(IdentifiedObject):
    '''
    Catalogue of available types of products and materials that are used to
    build or install, maintain or operate an Asset. Each catalogue item is
    for a specific product (AssetModel) available from a specific supplier.
    '''

    AssetModelCatalogueItems: list[AssetModelCatalogueItem] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AssetModelCatalogueItem.AssetModelCatalogue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Auction(IdentifiedObject):
    '''
    A class providing the identification and type of an auction.
    '''

    allocationMode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Identification of the method of allocation in an auction.
            '''
        
        })
    '''
    Identification of the method of allocation in an auction.
    '''
    
    cancelled: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            An indicator that signifies that the auction has been cancelled.
            '''
        
        })
    '''
    An indicator that signifies that the auction has been cancelled.
    '''
    
    category: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The product category of an auction.
            '''
        
        })
    '''
    The product category of an auction.
    '''
    
    paymentTerms: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The terms which dictate the determination of the bid payment price.
            '''
        
        })
    '''
    The terms which dictate the determination of the bid payment price.
    '''
    
    rights: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The rights of use the transmission capacity acquired in an auction.
            '''
        
        })
    '''
    The rights of use the transmission capacity acquired in an auction.
    '''
    
    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The kind of the Auction (e.g. implicit, explicit ...).
            '''
        
        })
    '''
    The kind of the Auction (e.g. implicit, explicit ...).
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketManagement'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AvailablityPlan(IdentifiedObject):
    '''
    The collection of all the availability schedules for a given time range.
    Only one availability plan shall be valid for the same period.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAvailabilityPlans'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BaseFrequency(IdentifiedObject):
    '''
    The BaseFrequency class describes a base frequency for a power system network.
    In case of multiple power networks with different frequencies, e.g. 50
    Hz or 60 Hz each network will have its own base frequency class. Hence
    it is assumed that power system objects having different base frequencies
    appear in separate documents where each document has a single base frequency
    instance.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The base frequency.
            '''
        
        })
    '''
    The base frequency.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BasePower(IdentifiedObject):
    '''
    The BasePower class defines the base power used in the per unit calculations.
    '''

    basePower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Value used as base power.
            '''
        
        })
    '''
    Value used as base power.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BaseVoltage(IdentifiedObject):
    '''
    Defines a system base voltage which is referenced.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The power system resource's base voltage. Shall be a positive value and
            not zero.
            '''
        
        })
    '''
    The power system resource's base voltage. Shall be a positive value
    and not zero.
    '''
    
    NetworkAssetDeployment: list[AssetDeployment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AssetDeployment.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A network asset deployment at this base voltage level.
            '''
        
        })
    '''
    A network asset deployment at this base voltage level.
    '''
    
    ConductingEquipment: list[ConductingEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConductingEquipment.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All conducting equipment with this base voltage. Use only when there is
            no voltage level container used and only one base voltage applies. For
            example, not used for transformers.
            '''
        
        })
    '''
    All conducting equipment with this base voltage. Use only when there
    is no voltage level container used and only one base voltage applies.
    For example, not used for transformers.
    '''
    
    TopologicalNode: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The topological nodes at the base voltage.
            '''
        
        })
    '''
    The topological nodes at the base voltage.
    '''
    
    TransformerEnds: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Transformer ends at the base voltage. This is essential for PU calculation.
            '''
        
        })
    '''
    Transformer ends at the base voltage. This is essential for PU calculation.
    '''
    
    VoltageLevel: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The voltage levels having this base voltage.
            '''
        
        })
    '''
    The voltage levels having this base voltage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BasicIntervalSchedule(IdentifiedObject):
    '''
    Schedule of values at points in time.
    '''

    startTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The time for the first time point. The value can be a time of day, not
            a specific date.
            '''
        
        })
    '''
    The time for the first time point. The value can be a time of day,
    not a specific date.
    '''
    
    value1Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for value1.
            '''
        
        })
    '''
    Multiplier for value1.
    '''
    
    value1Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Value1 units of measure.
            '''
        
        })
    '''
    Value1 units of measure.
    '''
    
    value2Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for value2.
            '''
        
        })
    '''
    Multiplier for value2.
    '''
    
    value2Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Value2 units of measure.
            '''
        
        })
    '''
    Value2 units of measure.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DynamicSchedule(BasicIntervalSchedule):
    '''
    A continuously variable component of a control area's MW net interchange
    schedule. Dynamic schedules are sent and received by control areas.
    '''

    dynSchedSignRev: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Dynamic schedule sign reversal required (true/false)
            '''
        
        })
    '''
    Dynamic schedule sign reversal required (true/false)
    '''
    
    dynSchedStatus: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The "active" or "inactive" status of the dynamic schedule
            '''
        
        })
    '''
    The "active" or "inactive" status of the dynamic schedule
    '''
    
    MktMeasurement: Optional[MktMeasurement] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MktMeasurement.DynamicSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Receive_SubControlArea: Optional[SubControlArea] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'SubControlArea.Receive_DynamicSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A control area can receive dynamic schedules from other control areas
            '''
        
        })
    '''
    A control area can receive dynamic schedules from other control areas
    '''
    
    Send_SubControlArea: Optional[SubControlArea] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'SubControlArea.Send_DynamicSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A control area can send dynamic schedules to other control areas
            '''
        
        })
    '''
    A control area can send dynamic schedules to other control areas
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfEnergyScheduling'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class IrregularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them varies.
    '''

    TimePoints: list[IrregularTimePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IrregularTimePoint.IntervalSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The point data values that define a curve.
            '''
        
        })
    '''
    The point data values that define a curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class RegularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them is constant.
    '''

    endTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The time for the last time point. The value can be a time of day, not a
            specific date.
            '''
        
        })
    '''
    The time for the last time point. The value can be a time of day, not
    a specific date.
    '''
    
    timeStep: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The time between each pair of subsequent regular time points in sequence
            order.
            '''
        
        })
    '''
    The time between each pair of subsequent regular time points in sequence
    order.
    '''
    
    TimePoints: list[RegularTimePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegularTimePoint.IntervalSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The regular interval time point data values that define this schedule.
            '''
        
        })
    '''
    The regular interval time point data values that define this schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AreaLoadCurve(RegularIntervalSchedule):
    '''
    Area load curve definition.
    '''

    forecastType: Optional[ LoadForecastType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Load forecast area type.
            '''
        
        })
    '''
    Load forecast area type.
    '''
    
    AggregateNode: Optional[AggregateNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AggregateNode.AreaLoadCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TACArea: Optional[TACArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TACArea.AreaLoadCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BidHourlyProductSchedule(RegularIntervalSchedule):
    '''
    Containment for bid parameters that are dependent on a market product type.
    '''

    ProductBid: Optional[ProductBid] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ProductBid.BidHourlyProductSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PumpingCostSchedule(BidHourlyProductSchedule):
    '''
    The operating cost of a Pump Storage Hydro Unit operating as a hydro pump.
    This schedule is assocated with the hourly parameters in a resource bid
    associated with a specific product within the bid.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PumpingLevelSchedule(BidHourlyProductSchedule):
    '''
    The fixed operating level of a Pump Storage Hydro Unit operating as a hydro
    pump. Associated with the energy market product type.
    This schedule is assocated with the hourly parameters in a resource bid
    associated with a specific product within the bid.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PumpingShutDownCostSchedule(BidHourlyProductSchedule):
    '''
    The cost to shutdown a Pump Storage Hydro Unit (in pump mode) or a pump.
    This schedule is assocated with the hourly parameters in a resource bid
    associated with a specific product within the bid.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BidHourlySchedule(RegularIntervalSchedule):
    '''
    Containment for bid hourly parameters that are not product dependent.
    '''

    Bid: Optional[Bid] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Bid.BidHourlySchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class HourlyPreDispatchSchedule(BidHourlySchedule):
    '''
    An indicator specifying that a resource shall have an Hourly Pre-Dispatch.
    The resource could be a RegisteredGenerator or a RegisteredInterTie.
    This schedule is assocated with the hourly parameters in a resource bid.
    '''

    value: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag defining that for this hour in the resource bid the resource shall
            have an hourly pre-dispatch.
            '''
        
        })
    '''
    Flag defining that for this hour in the resource bid the resource shall
    have an hourly pre-dispatch.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OpenTieSchedule(BidHourlySchedule):
    '''
    Result of bid validation against conditions that may exist on an interchange
    that becomes disconnected or is heavily discounted with respect the MW
    flow.
    This schedule is assocated with the hourly parameters in a resource bid.
    '''

    value: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WheelingReferenceSchedule(BidHourlySchedule):
    '''
    A unique identifier of a wheeling transaction. A wheeling transaction is
    a balanced Energy exchange among Supply and Demand Resources.
    This schedule is assocated with the hourly parameters in a resource bid.
    '''

    value: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BidPriceSchedule(RegularIntervalSchedule):
    '''
    Defines bid schedules to allow a product bid to use specified bid price
    curves for different time intervals.
    '''

    bidType: Optional[ BidMitigationType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            BID Type:
            I - Initial Bid;
            F - Final Bid
            '''
        
        })
    '''
    BID Type:
    I - Initial Bid;
    F - Final Bid
    '''
    
    mitigationStatus: Optional[ BidMitigationStatus ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Mitigation Status:
            'S' - Mitigated by SMPM because of "misconduct"
            'L; - Mitigated by LMPM because of "misconduct"
            'R' - Modified by LMPM because of RMR rules
            'M' - Mitigated because of "misconduct" both by SMPM and LMPM
            'B' - Mitigated because of "misconduct" both by SMPM and modified by LMLM
            because of RMR rules
            'O' - original
            '''
        
        })
    '''
    Mitigation Status:
    'S' - Mitigated by SMPM because of "misconduct"
    'L; - Mitigated by LMPM because of "misconduct"
    'R' - Modified by LMPM because of RMR rules
    'M' - Mitigated because of "misconduct" both by SMPM and LMPM
    'B' - Mitigated because of "misconduct" both by SMPM and modified by
    LMLM because of RMR rules
    'O' - original
    '''
    
    BidPriceCurve: Optional[BidPriceCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'BidPriceCurve.BidSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ProductBid: Optional[ProductBid] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ProductBid.BidSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BidSelfSched(RegularIntervalSchedule):
    '''
    Defines self schedule values to be used for specified time intervals.
    '''

    pumpSelfSchedMw: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Contains the PriceTaker, ExistingTransmissionContract, TransmissionOwnershipRights
            pumping self schedule quantity. If this value is not null, then the unit
            is in pumping mode.
            '''
        
        })
    '''
    Contains the PriceTaker, ExistingTransmissionContract, TransmissionOwnershipRights
    pumping self schedule quantity. If this value is not null, then the
    unit is in pumping mode.
    '''
    
    selfSchedMw: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Self scheduled value
            '''
        
        })
    '''
    Self scheduled value
    '''
    
    selfSchedSptResource: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Price Taker Export Self Sched Support Resource
            '''
        
        })
    '''
    Price Taker Export Self Sched Support Resource
    '''
    
    wheelingTransactionReference: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A unique identifier of a wheeling transaction. A wheeling transaction is
            a balanced Energy exchange among Supply and Demand Resources.
            '''
        
        })
    '''
    A unique identifier of a wheeling transaction. A wheeling transaction
    is a balanced Energy exchange among Supply and Demand Resources.
    '''
    
    balancingFlag: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This is a Y/N flag for a self-schedule of a resource per market per date
            and hour, using a specific TR ID. It indicates whether a self-schedule
            using a TR is balanced with another self-schedule using the same TR ID.
            '''
        
        })
    '''
    This is a Y/N flag for a self-schedule of a resource per market per
    date and hour, using a specific TR ID. It indicates whether a self-schedule
    using a TR is balanced with another self-schedule using the same TR
    ID.
    '''
    
    bidType: Optional[ BidTypeRMR ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            bidType has two types as the required output of requirements and qualified
            pre-dispatch.
            '''
        
        })
    '''
    bidType has two types as the required output of requirements and qualified
    pre-dispatch.
    '''
    
    priorityFlag: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This is a Y/N flag for a self-schedule of a resource per market per date
            and hour, using a specific TR ID. It indicates whether a self-schedule
            using a TR has scheduling priority in DAM/RTM.
            '''
        
        })
    '''
    This is a Y/N flag for a self-schedule of a resource per market per
    date and hour, using a specific TR ID. It indicates whether a self-schedule
    using a TR has scheduling priority in DAM/RTM.
    '''
    
    referenceType: Optional[ SelfSchedReferenceType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indication of which type of self schedule is being referenced.
            '''
        
        })
    '''
    Indication of which type of self schedule is being referenced.
    '''
    
    selfSchedType: Optional[ MarketProductSelfSchedType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This attribute is used to specify if a bid includes a self sched bid. If
            so what self sched type is it. The possible values are shown as follow
            but not limited to:
            'ETC' - Existing transmission contract
            'TOR' - Transmission ownership right
            'RMR' - Reliability must run
            'RGMR' - Regulatory must run
            "RMT" - Relaiability must take
            "PT" - Price taker
            "LPT" - Low price taker
            "SP" - Self provision
            "RA" - Resource adequacy
            This attribute is originally defined in the BidSelfSched class
            '''
        
        })
    '''
    This attribute is used to specify if a bid includes a self sched bid.
    If so what self sched type is it. The possible values are shown as
    follow but not limited to:
    'ETC' - Existing transmission contract
    'TOR' - Transmission ownership right
    'RMR' - Reliability must run
    'RGMR' - Regulatory must run
    "RMT" - Relaiability must take
    "PT" - Price taker
    "LPT" - Low price taker
    "SP" - Self provision
    "RA" - Resource adequacy
    This attribute is originally defined in the BidSelfSched class
    '''
    
    updateType: Optional[ MQSCHGType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    AdjacentCASet: Optional[AdjacentCASet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AdjacentCASet.BidSelfSched',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    HostControlArea: Optional[HostControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HostControlArea.BidSelfSched',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ProductBid: Optional[ProductBid] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ProductBid.BidSelfSched',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SubControlArea: Optional[SubControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubControlArea.BidSelfSched',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TransmissionContractRight: Optional[ContractRight] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ContractRight.BidSelfSched',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class GenUnitOpSchedule(RegularIntervalSchedule):
    '''
    The generating unit's Operator-approved current operating schedule (or
    plan), typically produced with the aid of unit commitment type analyses.
    The X-axis represents absolute time. The Y1-axis represents the status
    (0=off-line and unavailable: 1=available: 2=must run: 3=must run at fixed
    power value: etc.). The Y2-axis represents the must run fixed power value
    where required.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''
        
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''
        
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HydroPumpOpSchedule(RegularIntervalSchedule):
    '''
    The hydro pump's Operator-approved current operating schedule (or plan),
    typically produced with the aid of unit commitment type analyses. The unit's
    operating schedule status is typically given as: (0=unavailable) (1=available
    to startup or shutdown) (2=must pump).
    '''

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'HydroPump.HydroPumpOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''
        
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.HydroPumpOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''
        
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class InflowForecast(RegularIntervalSchedule):
    '''
    Natural water inflow to a reservoir, usually forecasted from predicted
    rain and snowmelt. Typically in one hour increments for up to 10 days.
    The forecast is given in average cubic meters per second over the time
    increment.
    '''

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Reservoir.InflowForecasts',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A reservoir may have a "natural" inflow forecast.
            '''
        
        })
    '''
    A reservoir may have a "natural" inflow forecast.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ResourcePerformanceTimeSeriesFactor(RegularIntervalSchedule):
    '''
    Represents the performance of a resource as time series data for a specified
    time period, time interval, and evaluation criteria.
    '''

    timeSeriesDataType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of the time series data, e.g. baseline data, meter read data, computed
            performance data.
            '''
        
        })
    '''
    Type of the time series data, e.g. baseline data, meter read data,
    computed performance data.
    '''
    
    timeSeriesDescription: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Optional description of the time series data, e.g. baseline data, meter
            read data, computed performance data.
            '''
        
        })
    '''
    Optional description of the time series data, e.g. baseline data, meter
    read data, computed performance data.
    '''
    
    value1Description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Description for the value1 contained within the TimeSeriesFactor.
            '''
        
        })
    '''
    Description for the value1 contained within the TimeSeriesFactor.
    '''
    
    value2Description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Description for the value2 contained within the TimeSeriesFactor.
            '''
        
        })
    '''
    Description for the value2 contained within the TimeSeriesFactor.
    '''
    
    ResourcePerformanceEvaluation: Optional[ResourcePerformanceEvaluation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ResourcePerformanceEvaluation.ResourcePerformanceTimeSeriesFactors',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SeasonDayTypeSchedule(RegularIntervalSchedule):
    '''
    A time schedule covering a 24 hour period, with curve data for a specific
    type of season and day.
    '''

    DayType: Optional[DayType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DayType.SeasonDayTypeSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            DayType for the Schedule.
            '''
        
        })
    '''
    DayType for the Schedule.
    '''
    
    Season: Optional[Season] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Season.SeasonDayTypeSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Season for the Schedule.
            '''
        
        })
    '''
    Season for the Schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    A curve of load versus time (X-axis) showing the active power values (Y1-axis)
    and reactive power (Y2-axis) for each unit of the period covered. This
    curve represents a typical pattern of load over the time period for a given
    day type and season.
    '''

    ConformLoadGroup: Optional[ConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ConformLoadGroup.ConformLoadSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The ConformLoadGroup where the ConformLoadSchedule belongs.
            '''
        
        })
    '''
    The ConformLoadGroup where the ConformLoadSchedule belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class NonConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    An active power (Y1-axis) and reactive power (Y2-axis) schedule (curves)
    versus time (X-axis) for non-conforming loads, e.g., large industrial load
    or power station service (where modelled).
    '''

    NonConformLoadGroup: Optional[NonConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'NonConformLoadGroup.NonConformLoadSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The NonConformLoadGroup where the NonConformLoadSchedule belongs.
            '''
        
        })
    '''
    The NonConformLoadGroup where the NonConformLoadSchedule belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RegulationSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a controlled variable, e.g., busbar
    voltage.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RegulatingControl.RegulationSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Regulating controls that have this schedule.
            '''
        
        })
    '''
    Regulating controls that have this schedule.
    '''
    
    VoltageControlZones: list[VoltageControlZone] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageControlZone.RegulationSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A VoltageControlZone may have a voltage regulation schedule.
            '''
        
        })
    '''
    A VoltageControlZone may have a voltage regulation schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SwitchSchedule(SeasonDayTypeSchedule):
    '''
    A schedule of switch positions. If RegularTimePoint.value1 is 0, the switch
    is open. If 1, the switch is closed.
    '''

    Switch: Optional[Switch] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Switch.SwitchSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A SwitchSchedule is associated with a Switch.
            '''
        
        })
    '''
    A SwitchSchedule is associated with a Switch.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a tap step.
    '''

    TapChanger: Optional[TapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'TapChanger.TapSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A TapSchedule is associated with a TapChanger.
            '''
        
        })
    '''
    A TapSchedule is associated with a TapChanger.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class SteamSendoutSchedule(RegularIntervalSchedule):
    '''
    The cogeneration plant's steam sendout schedule in volume per time unit.
    '''

    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.SteamSendoutSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''
        
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.SteamSendoutSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''
        
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BidError(IdentifiedObject):
    '''
    This class represent the error information for a bid that is detected during
    bid validation.
    '''

    componentType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    endTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            hour wihthin the bid for which the error applies
            '''
        
        })
    '''
    hour wihthin the bid for which the error applies
    '''
    
    errMessage: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            error message
            '''
        
        })
    '''
    error message
    '''
    
    errPriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Priority number for the error message
            '''
        
        })
    '''
    Priority number for the error message
    '''
    
    logTimeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    msgLevel: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ruleID: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    startTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            hour wihthin the bid for which the error applies
            '''
        
        })
    '''
    hour wihthin the bid for which the error applies
    '''
    
    MarketProduct: Optional[MarketProduct] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MarketProduct.BidError',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class BidSet(IdentifiedObject):
    '''
    As set of mutually exclusive bids for which a maximum of one may be scheduled.
    Of these generating bids, only one generating bid can be scheduled at a
    time.
    '''

    GeneratingBids: list[GeneratingBid] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GeneratingBid.BidSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BilateralExchangeActor(IdentifiedObject):
    '''
    BilateralExchangeActor describes an actor that provides ICCP data, consumes
    ICCP data or both. The ICCP data provider lists the data it makes available
    to an ICCP data consumer. This data is described by ProvidedBilateralPoints.
    The relation between an ICCP data provider and a consumer is established
    by a BilateralExchangeAgreement. It is up to the ICCP data consumer to
    select what ProvidedBilateralPoints to use. The selection made is not described
    in this information model.
    '''

    ConsumerBilateralExchange: list[BilateralExchangeAgreement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BilateralExchangeAgreement.Consumer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Agreement to information subscriber.
            '''
        
        })
    '''
    Agreement to information subscriber.
    '''
    
    ProviderBilateralExchange: list[BilateralExchangeAgreement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BilateralExchangeAgreement.Provider',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Agreement to information provider.
            '''
        
        })
    '''
    Agreement to information provider.
    '''
    
    CommunicationLink: list[CommunicationLink] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CommunicationLink.BilateralExchangeActor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Communication addressing for a Bilateral Table used by a ICCP data provider
            or consumer.
            '''
        
        })
    '''
    Communication addressing for a Bilateral Table used by a ICCP data
    provider or consumer.
    '''
    
    ProvidedBilateralIOPoint: list[ProvidedBilateralPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProvidedBilateralPoint.BilateralExchangeActor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            ICCP information in a Bilateral table that will be exposed to a remote
            peer.
            '''
        
        })
    '''
    ICCP information in a Bilateral table that will be exposed to a remote
    peer.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ICCPConfiguration'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ICCPVCC(BilateralExchangeActor):
    '''
    Indicates that the ICCP information is global in nature and normally is
    available to all authorized peers.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ICCPConfiguration'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ICCPVirtualControlCentre(BilateralExchangeActor):
    '''
    This contains the information that a particular actor exposes for a particular
    agreed upon ICCP Bilateral Table.
    '''

    calling: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Used to indicate if the Provider is responsible for initiating the TASE.2
            connection. If the value is TRUE, the provider is responsible for establishing
            the association. If the value is FALSE, the peer provider of the Bilateral
            Table will need to establish the association.
            '''
        
        })
    '''
    Used to indicate if the Provider is responsible for initiating the
    TASE.2 connection. If the value is TRUE, the provider is responsible
    for establishing the association. If the value is FALSE, the peer provider
    of the Bilateral Table will need to establish the association.
    '''
    
    clientAndServer: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If True the value indicates that the entity represented by the bilateral
            table is capable of issuing requests and responding to request (e.g. bidirectional
            support of ICCP requests).
            If False, this indicates that a calling entity (e.g. calling = True) will
            not be able to respond to ICCP requests. If False, and calling=False, this
            indicates that the entity will only respond to ICCP requests and not issue
            ICCP requests.
            '''
        
        })
    '''
    If True the value indicates that the entity represented by the bilateral
    table is capable of issuing requests and responding to request (e.g.
    bidirectional support of ICCP requests).
    If False, this indicates that a calling entity (e.g. calling = True)
    will not be able to respond to ICCP requests. If False, and calling=False,
    this indicates that the entity will only respond to ICCP requests and
    not issue ICCP requests.
    '''
    
    minimumUpdateInterval: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the fastest update interval that can be provided for integrity
            information and Transfer Set creation. The value is in seconds.
            '''
        
        })
    '''
    Specifies the fastest update interval that can be provided for integrity
    information and Transfer Set creation. The value is in seconds.
    '''
    
    nameOfLocalICC: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the ICC scope name that the remote can use to access the information
            in the Bilateral Table if the information is not VCC scoped. This value
            may not be null.
            '''
        
        })
    '''
    Specifies the ICC scope name that the remote can use to access the
    information in the Bilateral Table if the information is not VCC scoped.
    This value may not be null.
    '''
    
    supportForBlock1: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Per IEC 60870-6-702: If true indicates support for basic services. Must
            always be true.
            '''
        
        })
    '''
    Per IEC 60870-6-702: If true indicates support for basic services.
    Must always be true.
    '''
    
    supportForBlock2: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Per IEC 60870-6-702: If true indicates support for extended conditions.
            '''
        
        })
    '''
    Per IEC 60870-6-702: If true indicates support for extended conditions.
    '''
    
    supportForBlock3: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Per IEC 60870-6-702: If true indicates support for blocked transfers.
            '''
        
        })
    '''
    Per IEC 60870-6-702: If true indicates support for blocked transfers.
    '''
    
    supportForBlock4: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Per IEC 60870-6-702: If true indicates support for information messages.
            '''
        
        })
    '''
    Per IEC 60870-6-702: If true indicates support for information messages.
    '''
    
    supportForBlock5: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Per IEC 60870-6-702: If true indicates support for device control.
            '''
        
        })
    '''
    Per IEC 60870-6-702: If true indicates support for device control.
    '''
    
    supportForDepriciatedBlock8: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Per IEC 60870-6-702: If true indicates support for accounts. The use of
            this block was deprecated in Edition 3.
            '''
        
        })
    '''
    Per IEC 60870-6-702: If true indicates support for accounts. The use
    of this block was deprecated in Edition 3.
    '''
    
    transportSecurityRequirement: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, then transport level security as specified by IEC 62351-6 is required.
            '''
        
        })
    '''
    If true, then transport level security as specified by IEC 62351-6
    is required.
    '''
    
    applicationSecurityRequirement: Optional[ ApplicationSecurityKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the expected security mechanism, per IEC 62351-4, to be utilized.
            '''
        
        })
    '''
    Specifies the expected security mechanism, per IEC 62351-4, to be utilized.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ICCPConfiguration'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BilateralExchangeAgreement(IdentifiedObject):
    '''
    This is the representation of the information exchange agreement between
    peers.
    '''

    Consumer: Optional[BilateralExchangeActor] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BilateralExchangeActor.ConsumerBilateralExchange',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Subscriber of information from a remote peer.
            '''
        
        })
    '''
    Subscriber of information from a remote peer.
    '''
    
    Provider: Optional[BilateralExchangeActor] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'BilateralExchangeActor.ProviderBilateralExchange',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Provider of information to a remote peer.
            '''
        
        })
    '''
    Provider of information to a remote peer.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ICCPConfiguration'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TASE2BilateralTable(BilateralExchangeAgreement):
    '''
    This class describe the sending (providing) side in a bilateral ICCP data
    exchange. Hence the ICCP bilateral (table) descriptions are created by
    exchanging ICCP Provider data between the parties.
    '''

    bilateralTableID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the version of the Bilateral Table configuration that is being
            exchanged.
            '''
        
        })
    '''
    Specifies the version of the Bilateral Table configuration that is
    being exchanged.
    '''
    
    bilateralTableVersion: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Version attribute identifies a unique version of the Bilateral Table.
            If any changes are made to a Bilateral Table, then a new unique value for
            this attribute shall be generated.
            '''
        
        })
    '''
    The Version attribute identifies a unique version of the Bilateral
    Table. If any changes are made to a Bilateral Table, then a new unique
    value for this attribute shall be generated.
    '''
    
    tase2version: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Specifies the version of the TASE.2 that is needed to access the Bilateral
            Table information via TASE.2.
            In order for a link to be established, both sides must have the same value.
            '''
        
        })
    '''
    Specifies the version of the TASE.2 that is needed to access the Bilateral
    Table information via TASE.2.
    In order for a link to be established, both sides must have the same
    value.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ICCPConfiguration'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BlockDispatchInstruction(IdentifiedObject):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'EnergyArea'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BlockDispatchOrder(IdentifiedObject):
    '''
    '''

    sequence: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'EnergyArea'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class BranchGroup(IdentifiedObject):
    '''
    A group of branch terminals whose directed flow summation is to be monitored.
    A branch group need not form a cutset of the network.
    '''

    monitorActivePower: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Monitor the active power flow.
            '''
        
        })
    '''
    Monitor the active power flow.
    '''
    
    monitorReactivePower: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Monitor the reactive power flow.
            '''
        
        })
    '''
    Monitor the reactive power flow.
    '''
    
    maximumActivePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum active power flow.
            '''
        
        })
    '''
    The maximum active power flow.
    '''
    
    maximumReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum reactive power flow.
            '''
        
        })
    '''
    The maximum reactive power flow.
    '''
    
    minimumActivePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum active power flow.
            '''
        
        })
    '''
    The minimum active power flow.
    '''
    
    minimumReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum reactive power flow.
            '''
        
        })
    '''
    The minimum reactive power flow.
    '''
    
    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BranchGroupTerminal.BranchGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The directed branch group terminals to be summed.
            '''
        
        })
    '''
    The directed branch group terminals to be summed.
    '''
    
    PinBranchGroup: list[PinBranchGroup] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PinBranchGroup.BranchGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BusNameMarker(IdentifiedObject):
    '''
    Used to apply user standard names to TopologicalNodes. Associated with
    one or more terminals that are normally connected with the bus name. The
    associated terminals are normally connected by non-retained switches. For
    a ring bus station configuration, all BusbarSection terminals in the ring
    are typically associated. For a breaker and a half scheme, both BusbarSections
    would normally be associated. For a ring bus, all BusbarSections would
    normally be associated. For a "straight" busbar configuration, normally
    only the main terminal at the BusbarSection would be associated.
    '''

    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Priority of bus name marker for use as topology bus name. Use 0 for do
            not care. Use 1 for highest priority. Use 2 as priority is less than 1
            and so on.
            '''
        
        })
    '''
    Priority of bus name marker for use as topology bus name. Use 0 for
    do not care. Use 1 for highest priority. Use 2 as priority is less
    than 1 and so on.
    '''
    
    ReportingGroup: Optional[ReportingGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReportingGroup.BusNameMarker',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The reporting group to which this bus name marker belongs.
            '''
        
        })
    '''
    The reporting group to which this bus name marker belongs.
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.BusNameMarker',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A user defined topological node that was originally defined in a planning
            model not yet having topology described by ConnectivityNodes. Once ConnectivityNodes
            has been created they may linked to user defined ToplogicalNdes using BusNameMarkers.
            '''
        
        })
    '''
    A user defined topological node that was originally defined in a planning
    model not yet having topology described by ConnectivityNodes. Once
    ConnectivityNodes has been created they may linked to user defined
    ToplogicalNdes using BusNameMarkers.
    '''
    
    Terminal: list[ACDCTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACDCTerminal.BusNameMarker',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The terminals associated with this bus name marker.
            '''
        
        })
    '''
    The terminals associated with this bus name marker.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Topology'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BushingInsulationPF(IdentifiedObject):
    '''
    Bushing insulation power factor condition as a result of a test.
    Typical status values are: Acceptable, Minor Deterioration or Moisture
    Absorption, Major Deterioration or Moisture Absorption, Failed.
    '''

    testKind: Optional[ BushingInsulationPfTestKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of test for this bushing.
            '''
        
        })
    '''
    Kind of test for this bushing.
    '''
    
    Bushing: Optional[Bushing] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Bushing.BushingInsulationPFs',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TransformerObservation: Optional[TransformerObservation] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerObservation.BushingInsultationPFs',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CRRSegment(IdentifiedObject):
    '''
    CRRSegment represents a segment of a CRR in a particular time frame.
    The segment class contains amount, clearing price, start date and time,
    end date and time.
    '''

    endDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            segment end date time
            '''
        
        })
    '''
    segment end date time
    '''
    
    quantity: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The MW amount associated with the CRR
            '''
        
        })
    '''
    The MW amount associated with the CRR
    '''
    
    startDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            segment start date time
            '''
        
        })
    '''
    segment start date time
    '''
    
    amount: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Dollar amount = quantity x clearingPrice
            '''
        
        })
    '''
    Dollar amount = quantity x clearingPrice
    '''
    
    clearingPrice: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Clearing price of a CRR
            '''
        
        })
    '''
    Clearing price of a CRR
    '''
    
    CongestionRevenueRight: Optional[CongestionRevenueRight] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CongestionRevenueRight.CRRSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'CongestionRevenueRights'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.harmonization)
@dataclass(repr=False)
class CalculationMethodHierarchy(IdentifiedObject):
    '''
    The hierarchy of calculation methods used to derive this measurement.
    .
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.CalculationMethodHierarchy',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Measurement value to which this calculation method hierarchy applies.
            '''
        
        })
    '''
    Measurement value to which this calculation method hierarchy applies.
    '''
    
    CalculationMethodOrder: list[CalculationMethodOrder] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CalculationMethodOrder.CalculationMethodHierarchy',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Order of a statistical calculation associated with this calculation method
            hierarchy.
            '''
        
        })
    '''
    Order of a statistical calculation associated with this calculation
    method hierarchy.
    '''
    
    Measurement: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.CalculationMethodHierarchy',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Measurement to which this calculation method hierarchy applies.
            '''
        
        })
    '''
    Measurement to which this calculation method hierarchy applies.
    '''
    
    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.CalculationMethodHierarchy',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Measurement value to which this calculation method hierarchy applies.
            '''
        
        })
    '''
    Measurement value to which this calculation method hierarchy applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetMeas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Cashier(IdentifiedObject):
    '''
    The operator of the point of sale for the duration of CashierShift. Cashier
    is under the exclusive management control of Vendor.
    '''

    CashierShifts: list[CashierShift] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CashierShift.Cashier',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All shifts operated by this cashier.
            '''
        
        })
    '''
    All shifts operated by this cashier.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'PaymentMetering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class CatalogAssetType(IdentifiedObject):
    '''
    a Assets that may be used for planning, work or design purposes.
    '''

    stockItem: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if item is a stock item (default).
            '''
        
        })
    '''
    True if item is a stock item (default).
    '''
    
    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Description of type of asset.
            '''
        
        })
    '''
    Description of type of asset.
    '''
    
    estimatedUnitCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Estimated unit cost (or cost per unit length) of this type of asset. It
            does not include labor to install, construct or configure it.
            '''
        
        })
    '''
    Estimated unit cost (or cost per unit length) of this type of asset.
    It does not include labor to install, construct or configure it.
    '''
    
    kind: Optional[ AssetKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of asset (from enumerated list).
            '''
        
        })
    '''
    Kind of asset (from enumerated list).
    '''
    
    AssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.CatalogAssetType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Generic nameplate information associated with this catalog asset type.
            '''
        
        })
    '''
    Generic nameplate information associated with this catalog asset type.
    '''
    
    TypeAssetCatalogue: Optional[TypeAssetCatalogue] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TypeAssetCatalogue.TypeAssets',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    AssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.CatalogAssetType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Generic nameplate information associated with this catalog asset type.
            '''
        
        })
    '''
    Generic nameplate information associated with this catalog asset type.
    '''
    
    CompatibleUnits: list[CompatibleUnit] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CompatibleUnit.GenericAssetModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ErpBomItemDatas: list[ErpBomItemData] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ErpBomItemData.TypeAsset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ErpInventoryIssues: list[ErpIssueInventory] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ErpIssueInventory.TypeAsset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ErpReqLineItems: list[ErpReqLineItem] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ErpReqLineItem.TypeAsset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ProductAssetModel: list[ProductAssetModel] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProductAssetModel.CatalogAssetType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Product asset model conforming to this catalog asset type.
            '''
        
        })
    '''
    Product asset model conforming to this catalog asset type.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GeneratorTypeAsset(CatalogAssetType):
    '''
    Generic generation equipment that may be used for various purposes such
    as work planning. It defines both the Real and Reactive power properties
    (modelled at the PSR level as a GeneratingUnit + SynchronousMachine).
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum real power limit.
            '''
        
        })
    '''
    Maximum real power limit.
    '''
    
    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum reactive power limit.
            '''
        
        })
    '''
    Maximum reactive power limit.
    '''
    
    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum real power generated.
            '''
        
        })
    '''
    Minimum real power generated.
    '''
    
    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum reactive power generated.
            '''
        
        })
    '''
    Minimum reactive power generated.
    '''
    
    rDirectSubtrans: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Direct-axis subtransient resistance.
            '''
        
        })
    '''
    Direct-axis subtransient resistance.
    '''
    
    rDirectSync: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Direct-axis synchronous resistance.
            '''
        
        })
    '''
    Direct-axis synchronous resistance.
    '''
    
    rDirectTrans: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Direct-axis transient resistance.
            '''
        
        })
    '''
    Direct-axis transient resistance.
    '''
    
    rQuadSubtrans: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Quadrature-axis subtransient resistance.
            '''
        
        })
    '''
    Quadrature-axis subtransient resistance.
    '''
    
    rQuadSync: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Quadrature-axis synchronous resistance.
            '''
        
        })
    '''
    Quadrature-axis synchronous resistance.
    '''
    
    rQuadTrans: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Quadrature-axis transient resistance.
            '''
        
        })
    '''
    Quadrature-axis transient resistance.
    '''
    
    xDirectSubtrans: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Direct-axis subtransient reactance.
            '''
        
        })
    '''
    Direct-axis subtransient reactance.
    '''
    
    xDirectSync: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Direct-axis synchronous reactance.
            '''
        
        })
    '''
    Direct-axis synchronous reactance.
    '''
    
    xDirectTrans: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Direct-axis transient reactance.
            '''
        
        })
    '''
    Direct-axis transient reactance.
    '''
    
    xQuadSubtrans: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Quadrature-axis subtransient reactance.
            '''
        
        })
    '''
    Quadrature-axis subtransient reactance.
    '''
    
    xQuadSync: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Quadrature-axis synchronous reactance.
            '''
        
        })
    '''
    Quadrature-axis synchronous reactance.
    '''
    
    xQuadTrans: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Quadrature-axis transient reactance.
            '''
        
        })
    '''
    Quadrature-axis transient reactance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfTypeAsset'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Channel(IdentifiedObject):
    '''
    A single path for the collection or reporting of register values over a
    period of time. For example, a register which measures forward energy can
    have two channels, one providing bulk quantity readings and the other providing
    interval readings of a fixed interval size.
    '''

    isVirtual: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, the data is being calculated by an enterprise system rather than
            metered directly.
            '''
        
        })
    '''
    If true, the data is being calculated by an enterprise system rather
    than metered directly.
    '''
    
    ReadingType: Optional[ReadingType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReadingType.Channel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reading type for register values reported/collected by this channel.
            '''
        
        })
    '''
    Reading type for register values reported/collected by this channel.
    '''
    
    Register: Optional[Register] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Register.Channels',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Register whose values are collected/reported by this channel.
            '''
        
        })
    '''
    Register whose values are collected/reported by this channel.
    '''
    
    ReadingType: Optional[ReadingType] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReadingType.Channel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Reading type for register values reported/collected by this channel.
            '''
        
        })
    '''
    Reading type for register values reported/collected by this channel.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Charge(IdentifiedObject):
    '''
    A charge element associated with other entities such as tariff structures,
    auxiliary agreements or other charge elements. The total charge amount
    applicable to this instance of charge is the sum of fixed and variable
    portion.
    '''

    kind: Optional[ ChargeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The kind of charge to be applied.
            '''
        
        })
    '''
    The kind of charge to be applied.
    '''
    
    variablePortion: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The variable portion of this charge element, calculated as a percentage
            of the total amount of a parent charge.
            '''
        
        })
    '''
    The variable portion of this charge element, calculated as a percentage
    of the total amount of a parent charge.
    '''
    
    ParentCharge: Optional[Charge] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Charge.ChildCharges',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Parent of this charge sub-component.
            '''
        
        })
    '''
    Parent of this charge sub-component.
    '''
    
    ChildCharges: list[Charge] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Charge.ParentCharge',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All sub-components of this complex charge.
            '''
        
        })
    '''
    All sub-components of this complex charge.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'PaymentMetering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ChargeComponent(IdentifiedObject):
    '''
    A Charge Component is a list of configurable charge quality items to feed
    into settlement calculation and/or bill determinants.
    '''

    deleteStatus: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    effectiveDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    equation: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    message: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    roundOff: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    sum: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    terminationDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ChargeGroup(IdentifiedObject):
    '''
    Charge Group is the grouping of Charge Types for settlement invoicing purpose.
    Examples such as Ancillary Services, Interests, etc.
    '''

    effectiveDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    marketCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    terminationDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ChargeGroupParent: Optional[ChargeGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ChargeGroup.ChargeGroupChild',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A ChargeGroup instance can have relationships with other ChargeGroup instances.
            '''
        
        })
    '''
    A ChargeGroup instance can have relationships with other ChargeGroup
    instances.
    '''
    
    ChargeGroupChild: list[ChargeGroup] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ChargeGroup.ChargeGroupParent',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A ChargeGroup instance can have relationships with other ChargeGroup instances.
            '''
        
        })
    '''
    A ChargeGroup instance can have relationships with other ChargeGroup
    instances.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ClassificationCondition(IdentifiedObject):
    '''
    A classification condition used to define preconditions that must be met
    by a phenomena classification.
    '''

    duration: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The duration of the of the condition in seconds
            '''
        
        })
    '''
    The duration of the of the condition in seconds
    '''
    
    test: Optional[ TestKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The test applied to the value.
            '''
        
        })
    '''
    The test applied to the value.
    '''
    
    PhenomenonClassification: Optional[PhenomenonClassification] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhenomenonClassification.ClassificationCondition',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Phenomenon classification to which this condition relates.
            '''
        
        })
    '''
    Phenomenon classification to which this condition relates.
    '''
    
    EnvironmentalAnalog: list[EnvironmentalAnalog] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnvironmentalAnalog.ClassificationCondition',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Analog which contributes to the definition of this classification condition.
            '''
        
        })
    '''
    Analog which contributes to the definition of this classification condition.
    '''
    
    EnvironmentalStringMeasurement: list[EnvironmentalStringMeasurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnvironmentalStringMeasurement.ClassificationCondition',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            String measurement which contributes to the definition of this classification
            condition.
            '''
        
        })
    '''
    String measurement which contributes to the definition of this classification
    condition.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Environmental'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CnodeDistributionFactor(IdentifiedObject):
    '''
    Participation factors per Cnode. Used to calculate "participation" of Cnode
    in an AggregateNode. Each Cnode associated to an AggregateNode would be
    assigned a participation factor for its participation within the AggregateNode.
    '''

    factor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Used to calculate "participation" of Cnode in an AggregateNode
            '''
        
        })
    '''
    Used to calculate "participation" of Cnode in an AggregateNode
    '''
    
    podLossFactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Point of delivery loss factor
            '''
        
        })
    '''
    Point of delivery loss factor
    '''
    
    AggregateNode: Optional[AggregateNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AggregateNode.CnodeDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    HostControlArea: Optional[HostControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HostControlArea.CnodeDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MktConnectivityNode: Optional[MktConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MktConnectivityNode.CnodeDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SubControlArea: Optional[SubControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubControlArea.CnodeDistributionFactor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CombinedCycleConfigurationMember(IdentifiedObject):
    '''
    Configuration Member of CCP Configuration.
    '''

    primary: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            primary configuration.
            '''
        
        })
    '''
    primary configuration.
    '''
    
    steam: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Steam plant.
            '''
        
        })
    '''
    Steam plant.
    '''
    
    CombinedCycleConfiguration: Optional[CombinedCycleConfiguration] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CombinedCycleConfiguration.CombinedCycleConfigurationMember',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MktThermalGeneratingUnit: Optional[MktThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MktThermalGeneratingUnit.CombinedCycleConfigurationMember',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CombinedCycleLogicalConfiguration(IdentifiedObject):
    '''
    Logical Configuration of a Combined Cycle plant.
    Operating Combined Cycle Plant (CCP) configurations are represented as
    Logical CCP Resources. Logical representation shall be used for Market
    applications to optimize and control Market Operations. Logical representation
    is also necessary for controlling the number of CCP configurations and
    to temper performance issues that may otherwise occur.
    For example,(2CT configuration),(1CT + 1ST configuration) are examples
    of logical configuration, without specifying the specific CT and ST participating
    in the configuration.
    '''

    MktCombinedCyclePlant: Optional[MktCombinedCyclePlant] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MktCombinedCyclePlant.CombinedCycleLogicalConfiguration',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    CombinedCycleConfiguration: list[CombinedCycleConfiguration] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CombinedCycleConfiguration.CombinedCycleLogicalConfiguration',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CommodityDefinition(IdentifiedObject):
    '''
    Commodities in the context of IEC 62325 are MarketProducts (energy, regulation,
    reserve, etc) traded at a specific location, which in this case is a Pnode
    (either a specific pricing node or a pricing area or zone defined as a
    collection of pricing nodes). The CommodityDefinition is a container for
    these two parameters, plus the unit of measure and the currency in which
    the Commodity is traded. Each CommodityDefinition should be relatively
    static; defined once and rarely changed.
    '''

    commodityCurrency: Optional[ Currency ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The currency in which the Commodity is traded, using the standard conventions
            associated with the Currency enumeration.
            '''
        
        })
    '''
    The currency in which the Commodity is traded, using the standard conventions
    associated with the Currency enumeration.
    '''
    
    commodityUnit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit of measure in which the Commodity is traded, using the standard
            conventions associated with the UnitSymbol enumeration.
            '''
        
        })
    '''
    The unit of measure in which the Commodity is traded, using the standard
    conventions associated with the UnitSymbol enumeration.
    '''
    
    commodityUnitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit multiplier, e.g. "k" to convert the unit "W-h" to "kW-h", using
            the standard conventions associated with the UnitMultiplier enumeration.
            '''
        
        })
    '''
    The unit multiplier, e.g. "k" to convert the unit "W-h" to "kW-h",
    using the standard conventions associated with the UnitMultiplier enumeration.
    '''
    
    MarketProduct: Optional[MarketProduct] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MarketProduct.CommodityDefinition',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Pnode: Optional[Pnode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Pnode.CommodityDefinition',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RTO: Optional[RTO] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RTO.CommodityDefinition',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    CommodityPrice: list[CommodityPrice] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CommodityPrice.CommodityDefinition',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketPlan'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConnectivityNode(IdentifiedObject):
    '''
    Connectivity nodes are points where terminals of AC conducting equipment
    are connected together with zero impedance.
    '''

    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNodeContainer.ConnectivityNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Container of this connectivity node.
            '''
        
        })
    '''
    Container of this connectivity node.
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.ConnectivityNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The topological node to which this connectivity node is assigned. May depend
            on the current state of switches in the network.
            '''
        
        })
    '''
    The topological node to which this connectivity node is assigned. May
    depend on the current state of switches in the network.
    '''
    
    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Terminals interconnected with zero impedance at a this connectivity node.
            '''
        
        })
    '''
    Terminals interconnected with zero impedance at a this connectivity
    node.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MktConnectivityNode(ConnectivityNode):
    '''
    Subclass of IEC61970:Topology:ConnectivityNode.
    '''

    IndividualPnode: Optional[IndividualPnode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IndividualPnode.MktConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RTO: Optional[RTO] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RTO.MktConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SysLoadDistribuFactor: Optional[SysLoadDistributionFactor] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SysLoadDistributionFactor.MktConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    CnodeDistributionFactor: list[CnodeDistributionFactor] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CnodeDistributionFactor.MktConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    IndividualPnode: Optional[IndividualPnode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IndividualPnode.MktConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    LossPenaltyFactor: list[LossSensitivity] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LossSensitivity.MktConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    NodeConstraintTerm: list[NodeConstraintTerm] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NodeConstraintTerm.MktConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredResource: list[RegisteredResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegisteredResource.MktConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SysLoadDistribuFactor: Optional[SysLoadDistributionFactor] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SysLoadDistributionFactor.MktConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketOpCommon'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConstraintResults(IdentifiedObject):
    '''
    Provides the Market results for the constraint processing for either the
    DAM or RTM. The data includes the constraint type (binding or violated),
    the solved value for the constraint, and the associated shadow price.
    '''

    baseFlow: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Branch base Power Flow.
            '''
        
        })
    '''
    Branch base Power Flow.
    '''
    
    BGLimit: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This value is determined in DA and RTM. The SCUC optimization ensures that
            the MW flow on the Branch Group will not exceed this limit in the relevant
            direction.
            '''
        
        })
    '''
    This value is determined in DA and RTM. The SCUC optimization ensures
    that the MW flow on the Branch Group will not exceed this limit in
    the relevant direction.
    '''
    
    BGTRResCap: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Branch Group TR Reservation Capacity - This value is determined in DA and
            RTM. It is the amount of spare transmission capacity that is left for the
            TR holder to use.
            '''
        
        })
    '''
    Branch Group TR Reservation Capacity - This value is determined in
    DA and RTM. It is the amount of spare transmission capacity that is
    left for the TR holder to use.
    '''
    
    bindingLimit: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            MW Limit.
            '''
        
        })
    '''
    MW Limit.
    '''
    
    clearedValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Cleared MW.
            '''
        
        })
    '''
    Cleared MW.
    '''
    
    overloadMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transmission overload MW.
            '''
        
        })
    '''
    Transmission overload MW.
    '''
    
    percentMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Actual MW flow as percent of limit.
            '''
        
        })
    '''
    Actual MW flow as percent of limit.
    '''
    
    shadowPrice: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Shadow Price ($/MW) for the commodity. Shadow price for the corresponding
            constraint.
            '''
        
        })
    '''
    Shadow Price ($/MW) for the commodity. Shadow price for the corresponding
    constraint.
    '''
    
    updateTimeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Update time stamp.
            '''
        
        })
    '''
    Update time stamp.
    '''
    
    updateUser: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Updated user.
            '''
        
        })
    '''
    Updated user.
    '''
    
    competitivePathConstraint: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Non-competitive path constraint Flag"(Y/N) indicating whether the shadow
            price on a non-competitive path was non-zero.
            '''
        
        })
    '''
    Non-competitive path constraint Flag"(Y/N) indicating whether the shadow
    price on a non-competitive path was non-zero.
    '''
    
    constraintType: Optional[ ResultsConstraintType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of constraint.
            '''
        
        })
    '''
    Type of constraint.
    '''
    
    limitFlag: Optional[ ConstraintLimitType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Limit flag ('Maximum', 'Minimum').
            '''
        
        })
    '''
    Limit flag ('Maximum', 'Minimum').
    '''
    
    optimizationFlag: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Included in optimization Y/N.
            '''
        
        })
    '''
    Included in optimization Y/N.
    '''
    
    updateType: Optional[ MQSCHGType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            MQS change type.
            '''
        
        })
    '''
    MQS change type.
    '''
    
    ConstraintClearing: Optional[ConstraintClearing] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConstraintClearing.ConstraintResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Flowgate: Optional[Flowgate] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Flowgate.ConstraintResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MktContingency: Optional[MktContingency] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MktContingency.ConstraintResults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'MarketResults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConstraintTerm(IdentifiedObject):
    '''
    A constraint term is one element of a linear constraint.
    '''

    factor: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    function: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The function is an enumerated value that can be 'active', 'reactive', or
            'VA' to indicate the type of flow.
            '''
        
        })
    '''
    The function is an enumerated value that can be 'active', 'reactive',
    or 'VA' to indicate the type of flow.
    '''
    
    SecurityConstraintSum: Optional[SecurityConstraintSum] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'SecurityConstraintSum.ConstraintTerms',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class NodeConstraintTerm(ConstraintTerm):
    '''
    To be used only to constrain a quantity that cannot be associated with
    a terminal. For example, a registered generating unit that is not electrically
    connected to the network.
    '''

    MktConnectivityNode: Optional[MktConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MktConnectivityNode.NodeConstraintTerm',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TerminalConstraintTerm(ConstraintTerm):
    '''
    A constraint term associated with a specific terminal on a physical piece
    of equipment.
    '''

    MktTerminal: Optional[MktTerminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MktTerminal.TerminalConstraintTerm',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Contingency(IdentifiedObject):
    '''
    An event threatening system reliability, consisting of one or more contingency
    elements.
    '''

    mustStudy: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Set true if must study this contingency.
            '''
        
        })
    '''
    Set true if must study this contingency.
    '''
    
    ContingencyElement: list[ContingencyElement] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ContingencyElement.Contingency',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A contingency can have any number of contingency elements.
            '''
        
        })
    '''
    A contingency can have any number of contingency elements.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Contingency'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MktContingency(Contingency):
    '''
    Subclass of IEC 61970:Contingency.
    '''

    loadRolloverFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            load change flag
            Flag that indicates whether load rollover and load pickup should be processed
            for this contingency
            '''
        
        })
    '''
    load change flag
    Flag that indicates whether load rollover and load pickup should be
    processed for this contingency
    '''
    
    ltcControlFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            ltc enable flag
            Flag that indicates if LTCs regulate voltage during the solution of the
            contingency
            '''
        
        })
    '''
    ltc enable flag
    Flag that indicates if LTCs regulate voltage during the solution of
    the contingency
    '''
    
    participationFactorSet: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Participation Factor flag
            An indication which set of generator participation factors should be used
            to re-allocate generation in this contingency
            '''
        
        })
    '''
    Participation Factor flag
    An indication which set of generator participation factors should be
    used to re-allocate generation in this contingency
    '''
    
    screeningFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            sceening flag for outage
            Flag that indicated whether screening is bypassed for the contingency
            '''
        
        })
    '''
    sceening flag for outage
    Flag that indicated whether screening is bypassed for the contingency
    '''
    
    TransferInterfaceSolutionA: Optional[TransferInterfaceSolution] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransferInterfaceSolution.MktContingencyA',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TransferInterfaceSolutionB: Optional[TransferInterfaceSolution] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransferInterfaceSolution.MktContingencyB',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ConstraintResults: list[ConstraintResults] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConstraintResults.MktContingency',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ContingencyConstraintLimit: list[ContingencyConstraintLimit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ContingencyConstraintLimit.MktContingency',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TransferInterfaceSolutionA: Optional[TransferInterfaceSolution] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransferInterfaceSolution.MktContingencyA',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TransferInterfaceSolutionB: Optional[TransferInterfaceSolution] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransferInterfaceSolution.MktContingencyB',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ContingencyElement(IdentifiedObject):
    '''
    An element of a system event to be studied by contingency analysis, representing
    a change in status of a single piece of equipment.
    '''

    Contingency: Optional[Contingency] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Contingency.ContingencyElement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A contingency element belongs to one contingency.
            '''
        
        })
    '''
    A contingency element belongs to one contingency.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Contingency'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ContingencyEquipment(ContingencyElement):
    '''
    Equipment whose in service status is to change, such as a power transformer
    or AC line segment.
    '''

    contingentStatus: Optional[ ContingencyEquipmentStatusKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The status for the associated equipment when in the contingency state.
            This status is independent of the case to which the contingency is originally
            applied, but defines the equipment status when the contingency is applied.
            '''
        
        })
    '''
    The status for the associated equipment when in the contingency state.
    This status is independent of the case to which the contingency is
    originally applied, but defines the equipment status when the contingency
    is applied.
    '''
    
    Equipment: Optional[Equipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Equipment.ContingencyEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The single piece of equipment to which to apply the contingency.
            '''
        
        })
    '''
    The single piece of equipment to which to apply the contingency.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Contingency'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ContractRight(IdentifiedObject):
    '''
    Provides definition of Transmission Ownership Right and Existing Transmission
    Contract identifiers for use by SCUC. RMR contract hosting: Startup lead
    time, Contract Service Limits, Max Service Hours, Max MWhs, Max Start-ups,
    Ramp Rate, Max Net Dependable Capacity, Min Capacity and Unit Substitution
    for DAM/RTM to retrieve.
    '''

    chainOrder: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            When used in conjunction with a Transmission Right contract chain, this
            is the precedence for the contracts.
            '''
        
        })
    '''
    When used in conjunction with a Transmission Right contract chain,
    this is the precedence for the contracts.
    '''
    
    contractMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            MW value of the contract
            '''
        
        })
    '''
    MW value of the contract
    '''
    
    contractPriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Priority for the contract. This should be unique amoung all contracts for
            a specific resource. This value is the directive for the SCUC algorithm
            on the order to satisfy/cut contracts.
            '''
        
        })
    '''
    Priority for the contract. This should be unique amoung all contracts
    for a specific resource. This value is the directive for the SCUC algorithm
    on the order to satisfy/cut contracts.
    '''
    
    contractStatus: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Contract status
            '''
        
        })
    '''
    Contract status
    '''
    
    fuelAdder: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Estimated Fuel Adder
            '''
        
        })
    '''
    Estimated Fuel Adder
    '''
    
    latestSchedMinutes: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This indicates the latest schedule minutes (e.g. t - xx) that this resource
            can be notified to respond. This attribute is only used if the market type
            is not supplied.
            '''
        
        })
    '''
    This indicates the latest schedule minutes (e.g. t - xx) that this
    resource can be notified to respond. This attribute is only used if
    the market type is not supplied.
    '''
    
    maximumScheduleQuantity: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum schedule MW quantity
            '''
        
        })
    '''
    Maximum schedule MW quantity
    '''
    
    maximumServiceHours: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum service hours
            '''
        
        })
    '''
    Maximum service hours
    '''
    
    maximumStartups: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum startups
            '''
        
        })
    '''
    Maximum startups
    '''
    
    maxNetDependableCapacity: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum Net Dependable Capacity
            '''
        
        })
    '''
    Maximum Net Dependable Capacity
    '''
    
    minimumLoad: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum Load
            '''
        
        })
    '''
    Minimum Load
    '''
    
    minimumScheduleQuantity: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum schedule quanity
            '''
        
        })
    '''
    Minimum schedule quanity
    '''
    
    startupLeadTime: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Start up lead time
            '''
        
        })
    '''
    Start up lead time
    '''
    
    contractPrice: Optional[ float | CostPerEnergyUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Financial value of the contract
            '''
        
        })
    '''
    Financial value of the contract
    '''
    
    contractType: Optional[ ContractType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            type of the contract. Possible values are but not limited by:
            ETC, TOR or RMR and RMT self schedules
            '''
        
        })
    '''
    type of the contract. Possible values are but not limited by:
    ETC, TOR or RMR and RMT self schedules
    '''
    
    financialLocation: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Indicator if the location associated with this contract is financial (e.g.
            pricing nodes) or physical (e.g. connectivity nodes).
            '''
        
        })
    '''
    Indicator if the location associated with this contract is financial
    (e.g. pricing nodes) or physical (e.g. connectivity nodes).
    '''
    
    financialRightsDAM: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag to indicate this contract provides financial rights in the DA Market
            '''
        
        })
    '''
    Flag to indicate this contract provides financial rights in the DA
    Market
    '''
    
    financialRightsRTM: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag to indicate this contract provides financial rights in the RT Market
            '''
        
        })
    '''
    Flag to indicate this contract provides financial rights in the RT
    Market
    '''
    
    latestSchedMktType: Optional[ MarketType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            This indicates the latest schedule market type a contract can be applied
            to. This is used in conjunction with the latestSchedMinutes attribute to
            determine the latest time this contract can be called in. The possible
            values for this attribute are: DAM, RTM or it can be omitted. If omitted,
            the latestSchedMinutes attribute defines the value.
            '''
        
        })
    '''
    This indicates the latest schedule market type a contract can be applied
    to. This is used in conjunction with the latestSchedMinutes attribute
    to determine the latest time this contract can be called in. The possible
    values for this attribute are: DAM, RTM or it can be omitted. If omitted,
    the latestSchedMinutes attribute defines the value.
    '''
    
    physicalRightsDAM: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag to indicate this contract provides physical rights in the DA Market
            '''
        
        })
    '''
    Flag to indicate this contract provides physical rights in the DA Market
    '''
    
    physicalRightsRTM: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag to indicate this contract provides physical rights in the RT Market
            '''
        
        })
    '''
    Flag to indicate this contract provides physical rights in the RT Market
    '''
    
    TRType: Optional[ TRType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Transmission Right type - is this an individual contract right or a chain
            contract right. Types = CHAIN or INDIVIDUAL
            '''
        
        })
    '''
    Transmission Right type - is this an individual contract right or a
    chain contract right. Types = CHAIN or INDIVIDUAL
    '''
    
    Chain_TransmissionRightChain: Optional[TransmissionRightChain] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransmissionRightChain.Chain_ContractRight',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Ind_TransmissionRightChain: Optional[TransmissionRightChain] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransmissionRightChain.Ind_ContractRight',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RTO: Optional[RTO] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RTO.TransmissionContractRight',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SchedulingCoordinator: Optional[SchedulingCoordinator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'SchedulingCoordinator.TransmissionContractRight',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    BidSelfSched: list[BidSelfSched] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BidSelfSched.TransmissionContractRight',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ContractDistributionFactor: list[ContractDistributionFactor] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ContractDistributionFactor.TransmissionContractRight',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SubstitutionResourceList: list[SubstitutionResourceList] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SubstitutionResourceList.TransmissionContractRight',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TREntitlement: list[TREntitlement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TREntitlement.TransmissionContractRight',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TransmissionInterfaceEntitlement: list[TransmissionInterfaceRightEntitlement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransmissionInterfaceRightEntitlement.ContractRight',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Chain_TransmissionRightChain: Optional[TransmissionRightChain] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransmissionRightChain.Chain_ContractRight',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ControlAreaGeneratingUnit(IdentifiedObject):
    '''
    A control area generating unit. This class is needed so that alternate
    control area definitions may include the same generating unit. It should
    be noted that only one instance within a control area should reference
    a specific generating unit.
    '''

    ControlArea: Optional[ControlArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ControlArea.ControlAreaGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The parent control area for the generating unit specifications.
            '''
        
        })
    '''
    The parent control area for the generating unit specifications.
    '''
    
    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.ControlAreaGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The generating unit specified for this control area. Note that a control
            area should include a GeneratingUnit only once.
            '''
        
        })
    '''
    The generating unit specified for this control area. Note that a control
    area should include a GeneratingUnit only once.
    '''
    
    AltGeneratingUnitMeas: list[AltGeneratingUnitMeas] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AltGeneratingUnitMeas.ControlAreaGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The link to prioritized measurements for this GeneratingUnit.
            '''
        
        })
    '''
    The link to prioritized measurements for this GeneratingUnit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ControlArea'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CoolingPowerRating(IdentifiedObject):
    '''
    There are often stages of power which are associated with stages of cooling.
    For instance, a transformer may be rated 121kV on the primary, 15kV on
    the secondary and 4kV on the tertiary winding. These are voltage ratings
    and the power ratings are generally the same for all three windings and
    independent of the voltage ratings, there are instances where the tertiary
    may have a lower power rating.
    For example, for three stages, the power rating may be 15/20/25 MVA and
    the cooling is OA/FA/FOA. The 15 MVA rating goes with the OA cooling (Oil
    and Air cooling). This is called the self cooled rating as there are no
    external cooling enhancements. The 20 MVA rating goes with the FA cooling
    (Forced Air cooling), this means that when the fans are running and thus
    enhancing the cooling characteristics, the transformer can operate at a
    power level of 20 MVA. The 25 MVA rating goes with the FOA cooling (Forced
    Oil and Air cooling), this means that when the fans and pumps are running
    and thus enhancing the cooling characteristics even more than before, the
    transformer can operate at a power level of 25 MVA. This 15/20/25 MVA does
    not state how the power is split between the various windings. It may be
    25 MVA input on the primary, 25 MVA output on the secondary and 0 MVA output
    on the tertiary. It may also operate at 25 MVA input on the primary, 17
    MVA output on the secondary and 8 MVA output on the tertiary.
    '''

    stage: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Stage of cooling and associated power rating.
            '''
        
        })
    '''
    Stage of cooling and associated power rating.
    '''
    
    coolingKind: Optional[ CoolingKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of cooling system.
            '''
        
        })
    '''
    Kind of cooling system.
    '''
    
    powerRating: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The power rating associated with type of cooling specified for this stage.
            '''
        
        })
    '''
    The power rating associated with type of cooling specified for this
    stage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CoordinateSystem(IdentifiedObject):
    '''
    Coordinate reference system.
    '''

    crsUrn: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A Uniform Resource Name (URN) for the coordinate reference system (crs)
            used to define 'Location.PositionPoints'.
            An example would be the European Petroleum Survey Group (EPSG) code for
            a coordinate reference system, defined in URN under the Open Geospatial
            Consortium (OGC) namespace as: urn:ogc:def:crs:EPSG::XXXX, where XXXX is
            an EPSG code (a full list of codes can be found at the EPSG Registry web
            site http://www.epsg-registry.org/). To define the coordinate system as
            being WGS84 (latitude, longitude) using an EPSG OGC, this attribute would
            be urn:ogc:def:crs:EPSG::4.3.2.6
            A profile should limit this code to a set of allowed URNs agreed to by
            all sending and receiving parties.
            '''
        
        })
    '''
    A Uniform Resource Name (URN) for the coordinate reference system (crs)
    used to define 'Location.PositionPoints'.
    An example would be the European Petroleum Survey Group (EPSG) code
    for a coordinate reference system, defined in URN under the Open Geospatial
    Consortium (OGC) namespace as: urn:ogc:def:crs:EPSG::XXXX, where XXXX
    is an EPSG code (a full list of codes can be found at the EPSG Registry
    web site http://www.epsg-registry.org/). To define the coordinate system
    as being WGS84 (latitude, longitude) using an EPSG OGC, this attribute
    would be urn:ogc:def:crs:EPSG::4.3.2.6
    A profile should limit this code to a set of allowed URNs agreed to
    by all sending and receiving parties.
    '''
    
    Locations: list[Location] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Location.CoordinateSystem',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All locations described with position points in this coordinate system.
            '''
        
        })
    '''
    All locations described with position points in this coordinate system.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Craft(IdentifiedObject):
    '''
    Craft of a person or a crew. Examples include overhead electric, underground
    electric, high pressure gas, etc. This ensures necessary knowledge and
    skills before being allowed to perform certain types of work.
    '''

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Classification by utility's work mangement standards and practices.
            '''
        
        })
    '''
    Classification by utility's work mangement standards and practices.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfCommon'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Crew(IdentifiedObject):
    '''
    Group of people with specific skills, tools, and vehicles.
    '''

    CrewType: Optional[CrewType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CrewType.Crews',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of this crew.
            '''
        
        })
    '''
    Type of this crew.
    '''
    
    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.Crew',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The location this crew is assigned to.
            '''
        
        })
    '''
    The location this crew is assigned to.
    '''
    
    SwitchingAction: Optional[SwitchingAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'SwitchingAction.Crew',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The switching action that is assigned to this crew.
            '''
        
        })
    '''
    The switching action that is assigned to this crew.
    '''
    
    CrewMembers: list[CrewMember] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CrewMember.Crew',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All members of this crew.
            '''
        
        })
    '''
    All members of this crew.
    '''
    
    FieldDispatchHistory: list[FieldDispatchHistory] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FieldDispatchHistory.Crew',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The dispatch history associated with the crew.
            '''
        
        })
    '''
    The dispatch history associated with the crew.
    '''
    
    WorkAssets: list[WorkAsset] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WorkAsset.Crew',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All work assets used by this crew.
            '''
        
        })
    '''
    All work assets used by this crew.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class OldCrew(Crew):
    '''
    A crew is a group of people with specific skills, tools, and vehicles.
    '''

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Classification by utility's work management standards and practices.
            '''
        
        })
    '''
    Classification by utility's work management standards and practices.
    '''
    
    Route: Optional[Route] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Route.Crews',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Capabilities: list[Capability] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Capability.Crew',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfCommon'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CrewType(IdentifiedObject):
    '''
    Custom description of the type of crew. This may be used to determine the
    type of work the crew can be assigned to. Examples include repair, tree
    trimming, switching, etc.
    '''

    Crews: list[Crew] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Crew.CrewType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All crews of this type.
            '''
        
        })
    '''
    All crews of this type.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CurrentEmergencyScheduledInterchange(IdentifiedObject):
    '''
    Control area emergency schedules
    '''

    emergencyScheduleMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Net tie MW. These are three entries, the current emergency schedule interchange
            and the two future schedules if they exist.
            '''
        
        })
    '''
    Net tie MW. These are three entries, the current emergency schedule
    interchange and the two future schedules if they exist.
    '''
    
    emergencyScheduleRampTime: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Ramp time, the ramping time for a schedule. This is calculated as the remaining
            time to ramp if a schedule is ramping. Measured in seconds, but can be
            negattive.
            '''
        
        })
    '''
    Ramp time, the ramping time for a schedule. This is calculated as the
    remaining time to ramp if a schedule is ramping. Measured in seconds,
    but can be negattive.
    '''
    
    emergencyScheduleStartTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Net tie time, the start time for a schedule. This is calculated as the
            current time if a schedule is ramping.
            '''
        
        })
    '''
    Net tie time, the start time for a schedule. This is calculated as
    the current time if a schedule is ramping.
    '''
    
    InternalControlArea: Optional[InternalControlArea] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'InternalControlArea.CurrentEmergencySI',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfEnergyScheduling'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CurrentState(IdentifiedObject):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'NetworkModelProjects'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Curve(IdentifiedObject):
    '''
    A multi-purpose curve or functional relationship between an independent
    variable (X-axis) and dependent (Y-axis) variables.
    '''

    curveStyle: Optional[ CurveStyle ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The style or shape of the curve.
            '''
        
        })
    '''
    The style or shape of the curve.
    '''
    
    xMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for X-axis.
            '''
        
        })
    '''
    Multiplier for X-axis.
    '''
    
    xUnit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The X-axis units of measure.
            '''
        
        })
    '''
    The X-axis units of measure.
    '''
    
    y1Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for Y1-axis.
            '''
        
        })
    '''
    Multiplier for Y1-axis.
    '''
    
    y1Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Y1-axis units of measure.
            '''
        
        })
    '''
    The Y1-axis units of measure.
    '''
    
    y2Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for Y2-axis.
            '''
        
        })
    '''
    Multiplier for Y2-axis.
    '''
    
    y2Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Y2-axis units of measure.
            '''
        
        })
    '''
    The Y2-axis units of measure.
    '''
    
    y3Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Multiplier for Y3-axis.
            '''
        
        })
    '''
    Multiplier for Y3-axis.
    '''
    
    y3Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Y3-axis units of measure.
            '''
        
        })
    '''
    The Y3-axis units of measure.
    '''
    
    CurveDatas: list[CurveData] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CurveData.Curve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The point data values that define this curve.
            '''
        
        })
    '''
    The point data values that define this curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssetPropertyCurve(Curve):
    '''
    An Asset Property that is described through curves rather than as a data
    point. The relationship is to be defined between an independent variable
    (X-axis) and one or two dependent variables (Y1-axis and Y2-axis).
    '''

    Specification: Optional[Specification] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Specification.AssetPropertyCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BaseCaseConstraintLimit(Curve):
    '''
    Possibly time-varying max MW or MVA and optionally Min MW limit or MVA
    limit (Y1 and Y2, respectively) assigned to a contingency analysis base
    case. Use CurveSchedule XAxisUnits to specify MW or MVA. To be used only
    if the BaseCaseConstraintLimit differs from the DefaultConstraintLimit.
    '''

    SecurityConstraintSum: Optional[SecurityConstraintSum] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'SecurityConstraintSum.BaseCaseConstraintLimit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SecurityConstraintSum: Optional[SecurityConstraintSum] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SecurityConstraintSum.BaseCaseConstraintLimit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BidPriceCurve(Curve):
    '''
    Relationship between unit operating price in $/hour (Y-axis) and unit output
    in MW (X-axis).
    '''

    BidSchedule: list[BidPriceSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BidPriceSchedule.BidPriceCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class CTTempActivePowerCurve(Curve):
    '''
    Relationship between the combustion turbine's power output rating in gross
    active power (X-axis) and the ambient air temperature (Y-axis).
    '''

    CombustionTurbine: Optional[CombustionTurbine] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CombustionTurbine.CTTempActivePowerCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A combustion turbine may have an active power versus ambient temperature
            relationship.
            '''
        
        })
    '''
    A combustion turbine may have an active power versus ambient temperature
    relationship.
    '''
    
    CombustionTurbine: Optional[CombustionTurbine] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CombustionTurbine.CTTempActivePowerCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A combustion turbine may have an active power versus ambient temperature
            relationship.
            '''
        
        })
    '''
    A combustion turbine may have an active power versus ambient temperature
    relationship.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'GenerationTrainingSimulation'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ContingencyConstraintLimit(Curve):
    '''
    Possibly time-varying max MW or MVA and optionally Min MW limit or MVA
    limit (Y1 and Y2, respectively) assigned to a constraint for a specific
    contingency. Use CurveSchedule XAxisUnits to specify MW or MVA.
    '''

    MktContingency: Optional[MktContingency] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MktContingency.ContingencyConstraintLimit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MWLimitSchedules: Optional[MWLimitSchedule] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MWLimitSchedule.SecurityConstraintLimit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SecurityConstraintSum: Optional[SecurityConstraintSum] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'SecurityConstraintSum.ContingencyConstraintLimits',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MWLimitSchedules: Optional[MWLimitSchedule] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MWLimitSchedule.SecurityConstraintLimit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DefaultBidCurve(Curve):
    '''
    Default bid curve for default energy bid curve and default startup curves
    (cost and time).
    '''

    curveType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            To indicate a type used for a default energy bid curve, such as LMP, cost
            or consultative based.
            '''
        
        })
    '''
    To indicate a type used for a default energy bid curve, such as LMP,
    cost or consultative based.
    '''
    
    debAdderFlag: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Default energy bid adder flag
            '''
        
        })
    '''
    Default energy bid adder flag
    '''
    
    DefaultBid: Optional[DefaultBid] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DefaultBid.DefaultBidCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    DefaultBid: Optional[DefaultBid] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DefaultBid.DefaultBidCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DefaultConstraintLimit(Curve):
    '''
    Possibly time-varying max MW or MVA and optionally Min MW limit or MVA
    limit (Y1 and Y2, respectively) applied as a default value if no specific
    constraint limits are specified for a contingency analysis. Use CurveSchedule
    XAxisUnits to specify MW or MVA.
    '''

    SecurityConstraintSum: Optional[SecurityConstraintSum] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'SecurityConstraintSum.DefaultConstraintLimit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SecurityConstraintSum: Optional[SecurityConstraintSum] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SecurityConstraintSum.DefaultConstraintLimit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EmissionAccount(Curve):
    '''
    Accounts for tracking emissions usage and credits for thermal generating
    units. A unit may have zero or more emission accounts, and will typically
    have one for tracking usage and one for tracking credits.
    '''

    emissionType: Optional[ EmissionType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
            of the curve contains the unit of measure (e.g. kg) and the emissionType
            is the type of emission (e.g. sulfur dioxide).
            '''
        
        })
    '''
    The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
    of the curve contains the unit of measure (e.g. kg) and the emissionType
    is the type of emission (e.g. sulfur dioxide).
    '''
    
    emissionValueSource: Optional[ EmissionValueSource ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The source of the emission value.
            '''
        
        })
    '''
    The source of the emission value.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.EmmissionAccounts',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have one or more emission allowance accounts.
            '''
        
        })
    '''
    A thermal generating unit may have one or more emission allowance accounts.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EmissionCurve(Curve):
    '''
    Relationship between the unit's emission rate in units of mass per hour
    (Y-axis) and output active power (X-axis) for a given type of emission.
    This curve applies when only one type of fuel is being burned.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    emissionContent: Optional[ float | Emission ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The emission content per quantity of fuel burned.
            '''
        
        })
    '''
    The emission content per quantity of fuel burned.
    '''
    
    emissionType: Optional[ EmissionType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of emission, which also gives the production rate measurement
            unit. The y1AxisUnits of the curve contains the unit of measure (e.g. kg)
            and the emissionType is the type of emission (e.g. sulfur dioxide).
            '''
        
        })
    '''
    The type of emission, which also gives the production rate measurement
    unit. The y1AxisUnits of the curve contains the unit of measure (e.g.
    kg) and the emissionType is the type of emission (e.g. sulfur dioxide).
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.EmissionCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have one or more emission curves.
            '''
        
        })
    '''
    A thermal generating unit may have one or more emission curves.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FuelAllocationSchedule(Curve):
    '''
    The amount of fuel of a given type which is allocated for consumption over
    a specified period of time.
    '''

    fuelAllocationEndDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The end time and date of the fuel allocation schedule.
            '''
        
        })
    '''
    The end time and date of the fuel allocation schedule.
    '''
    
    fuelAllocationStartDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The start time and date of the fuel allocation schedule.
            '''
        
        })
    '''
    The start time and date of the fuel allocation schedule.
    '''
    
    maxFuelAllocation: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The maximum amount of fuel that is allocated for consumption for the scheduled
            time period.
            '''
        
        })
    '''
    The maximum amount of fuel that is allocated for consumption for the
    scheduled time period.
    '''
    
    minFuelAllocation: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum amount of fuel that is allocated for consumption for the scheduled
            time period, e.g., based on a "take-or-pay" contract.
            '''
        
        })
    '''
    The minimum amount of fuel that is allocated for consumption for the
    scheduled time period, e.g., based on a "take-or-pay" contract.
    '''
    
    fuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of fuel, which also indicates the corresponding measurement unit.
            '''
        
        })
    '''
    The type of fuel, which also indicates the corresponding measurement
    unit.
    '''
    
    FossilFuel: Optional[FossilFuel] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'FossilFuel.FuelAllocationSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A fuel allocation schedule shall have a fossil fuel.
            '''
        
        })
    '''
    A fuel allocation schedule shall have a fossil fuel.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.FuelAllocationSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have one or more fuel allocation schedules.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FuelCostCurve(Curve):
    '''
    Relationship between unit fuel cost in $/kWh(Y-axis) and unit output in
    MW (X-axis).
    '''

    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.FuelCostCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.FuelCostCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GenUnitOpCostCurve(Curve):
    '''
    Relationship between unit operating cost (Y-axis) and unit output active
    power (X-axis). The operating cost curve for thermal units is derived from
    heat input and fuel costs. The operating cost curve for hydro units is
    derived from water flow rates and equivalent water costs.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpCostCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A generating unit may have one or more cost curves, depending upon fuel
            mixture and fuel cost.
            '''
        
        })
    '''
    A generating unit may have one or more cost curves, depending upon
    fuel mixture and fuel cost.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GrossToNetActivePowerCurve(Curve):
    '''
    Relationship between the generating unit's gross active power output on
    the X-axis (measured at the terminals of the machine(s)) and the generating
    unit's net active power output on the Y-axis (based on utility-defined
    measurements at the power station). Station service loads, when modelled,
    should be treated as non-conforming bus loads. There may be more than one
    curve, depending on the auxiliary equipment that is in service.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GrossToNetActivePowerCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A generating unit may have a gross active power to net active power curve,
            describing the losses and auxiliary power requirements of the unit.
            '''
        
        })
    '''
    A generating unit may have a gross active power to net active power
    curve, describing the losses and auxiliary power requirements of the
    unit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HeatInputCurve(Curve):
    '''
    Relationship between unit heat input in energy per time for main fuel (Y1-axis)
    and supplemental fuel (Y2-axis) versus unit output in active power (X-axis).
    The quantity of main fuel used to sustain generation at this output level
    is prorated for throttling between definition points. The quantity of supplemental
    fuel used at this output level is fixed and not prorated.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    auxPowerMult: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power output - auxiliary power multiplier adjustment factor.
            '''
        
        })
    '''
    Power output - auxiliary power multiplier adjustment factor.
    '''
    
    auxPowerOffset: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Power output - auxiliary power offset adjustment factor.
            '''
        
        })
    '''
    Power output - auxiliary power offset adjustment factor.
    '''
    
    heatInputEff: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Heat input - efficiency multiplier adjustment factor.
            '''
        
        })
    '''
    Heat input - efficiency multiplier adjustment factor.
    '''
    
    heatInputOffset: Optional[ float | HeatRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Heat input - offset adjustment factor.
            '''
        
        })
    '''
    Heat input - offset adjustment factor.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HeatRateCurve(Curve):
    '''
    Relationship between unit heat rate per active power (Y-axis) and unit
    output (X-axis). The heat input is from all fuels.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MktHeatRateCurve(HeatRateCurve):
    '''
    Subclass of IEC 61970: Generation: Production:HeatRateCurve.
    '''

    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.MktHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ResourceVerifiableCosts: Optional[ResourceVerifiableCosts] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ResourceVerifiableCosts.MktHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.MktHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ResourceVerifiableCosts: Optional[ResourceVerifiableCosts] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ResourceVerifiableCosts.MktHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class HydroGeneratingEfficiencyCurve(Curve):
    '''
    Relationship between unit efficiency as percentage and unit output active
    power for a given net head in meters. The relationship between efficiency,
    discharge, head, and power output is expressed as follows: E =KP/HQ
    where: E is the efficiency, as a percentage; P is the active power; H is
    the height; Q is the discharge, volume/time unit; K is a constant.
    For example, a curve instance for a given net head could show efficiency
    (Y-axis) versus active power output (X-axis) or versus discharge on the
    X-axis.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.HydroGeneratingEfficiencyCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A hydro generating unit has an efficiency curve.
            '''
        
        })
    '''
    A hydro generating unit has an efficiency curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class IncrementalHeatRateCurve(Curve):
    '''
    Relationship between unit incremental heat rate in (delta energy/time)
    per (delta active power) and unit output in active power. The IHR curve
    represents the slope of the HeatInputCurve. Note that the "incremental
    heat rate" and the "heat rate" have the same engineering units.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class InterchangeSchedule(Curve):
    '''
    Interchange schedule class to hold information for interchange schedules
    such as import export type, energy type, and etc.
    '''

    intervalLength: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Interval length.
            '''
        
        })
    '''
    Interval length.
    '''
    
    operatingDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Operating date, hour.
            '''
        
        })
    '''
    Operating date, hour.
    '''
    
    outOfMarketType: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            To indicate an out-of-market (OOM) schedule.
            '''
        
        })
    '''
    To indicate an out-of-market (OOM) schedule.
    '''
    
    wcrID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Wheeling Counter-Resource ID (required when Schedule Type=Wheel).
            '''
        
        })
    '''
    Wheeling Counter-Resource ID (required when Schedule Type=Wheel).
    '''
    
    checkOutType: Optional[ CheckOutType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            To indicate a check out type such as adjusted capacity or dispatch capacity.
            '''
        
        })
    '''
    To indicate a check out type such as adjusted capacity or dispatch
    capacity.
    '''
    
    directionType: Optional[ InterTieDirection ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Import or export.
            '''
        
        })
    '''
    Import or export.
    '''
    
    energyType: Optional[ MarketProductType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Energy product type.
            '''
        
        })
    '''
    Energy product type.
    '''
    
    marketType: Optional[ MarketType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Market type.
            '''
        
        })
    '''
    Market type.
    '''
    
    scheduleType: Optional[ EnergyProductType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Schedule type.
            '''
        
        })
    '''
    Schedule type.
    '''
    
    InterTie: Optional[SchedulingPoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SchedulingPoint.InterchangeSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredInterTie: Optional[RegisteredInterTie] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredInterTie.InterchangeSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    InterchangeETCData: list[InterchangeETCData] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'InterchangeETCData.InterchangeSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LevelVsVolumeCurve(Curve):
    '''
    Relationship between reservoir volume and reservoir level. The volume is
    at the Y-axis and the reservoir level at the X-axis.
    '''

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Reservoir.LevelVsVolumeCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A reservoir may have a level versus volume relationship.
            '''
        
        })
    '''
    A reservoir may have a level versus volume relationship.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LoadReductionPriceCurve(Curve):
    '''
    This is the price sensitivity that bidder expresses for allowing market
    load interruption. Relationship between price (Y1-axis) vs. MW (X-axis).
    '''

    LoadBid: Optional[LoadBid] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'LoadBid.LoadReductionPriceCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LoadReductionTimeCurve(Curve):
    '''
    This is the cureve that describes the load reduction time. Relationship
    between time (Y1-axis) vs. MW (X-axis).
    '''

    loadReductionTimeCurveType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            type of the curve: Possible values are but not limited to:
            Max, Min,
            '''
        
        })
    '''
    type of the curve: Possible values are but not limited to:
    Max, Min,
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MaxStartUpCostCurve(Curve):
    '''
    The maximum Startup costs and time as a function of down time. Relationship
    between unit startup cost (Y1-axis) vs. unit elapsed down time (X-axis).
    This is used to validate the information provided in the Bid.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class NotificationTimeCurve(Curve):
    '''
    Notification time curve as a function of down time. Relationship between
    crew notification time (Y1-axis) and unit startup time (Y2-axis) vs. unit
    elapsed down time (X-axis).
    '''

    GeneratingBids: list[GeneratingBid] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GeneratingBid.NotificationTimeCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class PenstockLossCurve(Curve):
    '''
    Relationship between penstock head loss (in meters) and total discharge
    through the penstock (in cubic meters per second). One or more turbines
    may be connected to the same penstock.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RMRHeatRateCurve(Curve):
    '''
    Model to support processing of reliability must run units.
    '''

    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.RMRHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.RMRHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RMRStartUpCostCurve(Curve):
    '''
    Model to support processing of reliability must run units.
    '''

    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.RMRStartUpCostCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.RMRStartUpCostCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RMRStartUpEnergyCurve(Curve):
    '''
    Model to support processing of reliability must run units.
    '''

    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.RMRStartUpEnergyCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.RMRStartUpEnergyCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RMRStartUpFuelCurve(Curve):
    '''
    Model to support processing of reliability must run units.
    '''

    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.RMRStartUpFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.RMRStartUpFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RMRStartUpTimeCurve(Curve):
    '''
    Model to support processing of reliability must run units.
    '''

    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.RMRStartUpTimeCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.RMRStartUpTimeCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RampRateCurve(Curve):
    '''
    Ramp rate as a function of resource MW output.
    '''

    condition: Optional[ RampRateCondition ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            condition for the ramp rate
            '''
        
        })
    '''
    condition for the ramp rate
    '''
    
    constraintRampType: Optional[ ConstraintRampType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The condition that identifies whether a Generating Resource should be constrained
            from Ancillary Service provision if its Schedule or Dispatch change across
            Trading Hours or Trading Intervals requires more than a specified fraction
            of the duration of the Trading Hour or Trading Interval.
            Valid values are Fast/Slow
            '''
        
        })
    '''
    The condition that identifies whether a Generating Resource should
    be constrained from Ancillary Service provision if its Schedule or
    Dispatch change across Trading Hours or Trading Intervals requires
    more than a specified fraction of the duration of the Trading Hour
    or Trading Interval.
    Valid values are Fast/Slow
    '''
    
    rampRateType: Optional[ RampRateType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            How ramp rate is applied (e.g. raise or lower, as when applied to a generation
            resource)
            '''
        
        })
    '''
    How ramp rate is applied (e.g. raise or lower, as when applied to a
    generation resource)
    '''
    
    GeneratingBid: Optional[GeneratingBid] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingBid.RampRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    InterTieBid: Optional[InterTieBid] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InterTieBid.RampRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    LoadBid: Optional[LoadBid] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadBid.RampRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ReactiveCapabilityCurve(Curve):
    '''
    Reactive power rating envelope versus the synchronous machine's active
    power, in both the generating and motoring modes. For each active power
    value there is a corresponding high and low reactive power limit value.
    Typically there will be a separate curve for each coolant condition, such
    as hydrogen pressure. The Y1 axis values represent reactive minimum and
    the Y2 axis values represent reactive maximum.
    '''

    coolantTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The machine's coolant temperature (e.g., ambient air or stator circulating
            water).
            '''
        
        })
    '''
    The machine's coolant temperature (e.g., ambient air or stator circulating
    water).
    '''
    
    hydrogenPressure: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The hydrogen coolant pressure.
            '''
        
        })
    '''
    The hydrogen coolant pressure.
    '''
    
    EquivalentInjection: list[EquivalentInjection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EquivalentInjection.ReactiveCapabilityCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The equivalent injection using this reactive capability curve.
            '''
        
        })
    '''
    The equivalent injection using this reactive capability curve.
    '''
    
    InitiallyUsedBySynchronousMachines: list[SynchronousMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SynchronousMachine.InitialReactiveCapabilityCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Synchronous machines using this curve as default.
            '''
        
        })
    '''
    Synchronous machines using this curve as default.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ReserveDemandCurve(Curve):
    '''
    Reserve demand curve. Models maximum quantities of reserve required per
    Market Region and models a reserve demand curve for the minimum quantities
    of reserve. The ReserveDemandCurve is a relationship between unit operating
    reserve price in $/MWhr (Y-axis) and unit reserves in MW (X-axis).
    '''

    reqMaxMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Region requirement maximum limit
            '''
        
        })
    '''
    Region requirement maximum limit
    '''
    
    reserveRequirementType: Optional[ ReserveRequirementType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Reserve requirement type that the max and curve apply to. For example,
            operating reserve, regulation and contingency.
            '''
        
        })
    '''
    Reserve requirement type that the max and curve apply to. For example,
    operating reserve, regulation and contingency.
    '''
    
    ASRequirements: Optional[ASRequirements] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ASRequirements.ReserveDemandCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MarketRegion: Optional[MarketRegion] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MarketRegion.ReserveDemandCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class ReserveReqCurve(Curve):
    '''
    A curve relating reserve requirement versus time, showing the values of
    a specific reserve requirement for each unit of the period covered. The
    curve can be based on "absolute" time or on "normalized' time.
    X is time, typically expressed in absolute time
    Y1 is reserve requirement, typically expressed in MW
    '''

    ReserveReq: Optional[ReserveReq] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ReserveReq.ReserveReqCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ReserveReq: Optional[ReserveReq] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReserveReq.ReserveReqCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ResourceOperationMaintenanceCost(Curve):
    '''
    To model the Operation and Maintenance (O and M) costs of a generation
    resource.
    '''

    omCostColdStartup: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Verifiable O&amp;M Cost ($), Cold Startup
            '''
        
        })
    '''
    Verifiable O&amp;M Cost ($), Cold Startup
    '''
    
    omCostHotStartup: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Verifiable O&amp;M Cost ($), Hot Startup
            '''
        
        })
    '''
    Verifiable O&amp;M Cost ($), Hot Startup
    '''
    
    omCostIntermediateStartup: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Verifiable O&amp;M Cost ($), Intermediate Startup
            '''
        
        })
    '''
    Verifiable O&amp;M Cost ($), Intermediate Startup
    '''
    
    omCostLowSustainedLimit: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Verifiable O&amp;M Cost ($/MWh), LSL
            '''
        
        })
    '''
    Verifiable O&amp;M Cost ($/MWh), LSL
    '''
    
    gasPercentAboveLowSustainedLimit: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Percentage of Fuel Index Price (gas) for operating above Low Sustained
            Limit (LSL)
            '''
        
        })
    '''
    Percentage of Fuel Index Price (gas) for operating above Low Sustained
    Limit (LSL)
    '''
    
    oilPercentAboveLowSustainedLimit: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Percentage of Fuel Oil Price (FOP) for operating above Low Sustained Limit
            (LSL)
            '''
        
        })
    '''
    Percentage of Fuel Oil Price (FOP) for operating above Low Sustained
    Limit (LSL)
    '''
    
    solidfuelPercentAboveLowSustainedLimit: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Percentage of Solid Fuel for operating above Low Sustained Limit (LSL)
            '''
        
        })
    '''
    Percentage of Solid Fuel for operating above Low Sustained Limit (LSL)
    '''
    
    ResourceVerifiableCosts: Optional[ResourceVerifiableCosts] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ResourceVerifiableCosts.ResourceOperationMaintenanceCost',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ResourceVerifiableCosts: Optional[ResourceVerifiableCosts] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ResourceVerifiableCosts.ResourceOperationMaintenanceCost',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class SensitivityPriceCurve(Curve):
    '''
    Optionally, this curve expresses elasticity of the associated requirement.
    For example, used to reduce requirements when clearing price exceeds reasonable
    values when the supply quantity becomes scarce. For example, a single point
    value of $1000/MW for a spinning reserve will cause a reduction in the
    required spinning reserve.
    X axis is constrained quantity (e.g., MW)
    Y1 axis is money per constrained quantity
    '''

    ReserveReq: Optional[ReserveReq] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReserveReq.SensitivityPriceCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ReserveReq: Optional[ReserveReq] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReserveReq.SensitivityPriceCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class ShutdownCurve(Curve):
    '''
    Relationship between the rate in gross active power/minute (Y-axis) at
    which a unit should be shutdown and its present gross MW output (X-axis).
    '''

    shutdownDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The date and time of the most recent generating unit shutdown.
            '''
        
        })
    '''
    The date and time of the most recent generating unit shutdown.
    '''
    
    shutdownCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fixed shutdown cost.
            '''
        
        })
    '''
    Fixed shutdown cost.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''
        
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''
        
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartIgnFuelCurve(Curve):
    '''
    The quantity of ignition fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    ignitionFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of ignition fuel.
            '''
        
        })
    '''
    Type of ignition fuel.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartIgnFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartIgnFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartMainFuelCurve(Curve):
    '''
    The quantity of main fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    mainFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of main fuel.
            '''
        
        })
    '''
    Type of main fuel.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartMainFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartMainFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartRampCurve(Curve):
    '''
    Rate in gross active power per minute (Y-axis) at which a unit can be loaded
    versus the number of hours (X-axis) the unit was off line.
    '''

    hotStandbyRamp: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The startup ramp rate in gross for a unit that is on hot standby.
            '''
        
        })
    '''
    The startup ramp rate in gross for a unit that is on hot standby.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartRampCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartRampCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StartUpCostCurve(Curve):
    '''
    Startup costs and time as a function of down time. Relationship between
    unit startup cost (Y1-axis) vs. unit elapsed down time (X-axis).
    '''

    GeneratingBid: list[GeneratingBid] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GeneratingBid.StartUpCostCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StartUpEnergyCurve(Curve):
    '''
    The energy consumption of a generating resource to complete a start-up
    from the StartUpEnergyCurve. Definition of the StartUpEnergyCurve includes,
    xvalue as the cooling time and y1value as the MW value.
    '''

    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.StartUpEnergyCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.StartUpEnergyCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StartUpFuelCurve(Curve):
    '''
    The fuel consumption of a Generating Resource to complete a Start-Up.(x=cooling
    time) Form Startup Fuel Curve. xAxisData -&gt; cooling time, y1AxisData
    -&gt; MBtu.
    '''

    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.StartUpFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.StartUpFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ReferenceData'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StartUpTimeCurve(Curve):
    '''
    Startup time curve as a function of down time, where time is specified
    in minutes. Relationship between unit startup time (Y1-axis) vs. unit elapsed
    down time (X-axis).
    '''

    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.StartUpTimeCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    GeneratingBid: list[GeneratingBid] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GeneratingBid.StartUpTimeCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredGenerator: Optional[RegisteredGenerator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredGenerator.StartUpTimeCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SubscribePowerCurve(Curve):
    '''
    Price curve for specifying the cost of energy (X) at points in time (y1)
    according to a prcing structure, which is based on a tariff.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfCustomers'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TailbayLossCurve(Curve):
    '''
    Relationship between tailbay head loss height (Y-axis) and the total discharge
    into the power station's tailbay volume per time unit (X-axis) . There
    could be more than one curve depending on the level of the tailbay reservoir
    or river level.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.TailbayLossCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A hydro generating unit has a tailbay loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a tailbay loss curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class TargetLevelSchedule(Curve):
    '''
    Reservoir water level targets from advanced studies or "rule curves". Typically
    in one hour increments for up to 10 days.
    '''

    highLevelLimit: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            High target level limit, above which the reservoir operation will be penalized.
            '''
        
        })
    '''
    High target level limit, above which the reservoir operation will be
    penalized.
    '''
    
    lowLevelLimit: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Low target level limit, below which the reservoir operation will be penalized.
            '''
        
        })
    '''
    Low target level limit, below which the reservoir operation will be
    penalized.
    '''
    
    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Reservoir.TargetLevelSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''
        
        })
    '''
    A reservoir may have a water level target schedule.
    '''
    
    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.TargetLevelSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''
        
        })
    '''
    A reservoir may have a water level target schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class VsCapabilityCurve(Curve):
    '''
    The P-Q capability curve for a voltage source converter, with P on X-axis
    and Qmin and Qmax on Y1-axis and Y2-axis.
    '''

    VsConverterDCSides: list[VsConverter] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VsConverter.CapabilityCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All converters with this capability curve.
            '''
        
        })
    '''
    All converters with this capability curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCNode(IdentifiedObject):
    '''
    DC nodes are points where terminals of DC conducting equipment are connected
    together with zero impedance.
    '''

    DCEquipmentContainer: Optional[DCEquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'DCEquipmentContainer.DCNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The DC container for the DC nodes.
            '''
        
        })
    '''
    The DC container for the DC nodes.
    '''
    
    DCTopologicalNode: Optional[DCTopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTopologicalNode.DCNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The DC topological node to which this DC connectivity node is assigned.
            May depend on the current state of switches in the network.
            '''
        
        })
    '''
    The DC topological node to which this DC connectivity node is assigned.
    May depend on the current state of switches in the network.
    '''
    
    DCTerminals: list[DCBaseTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCBaseTerminal.DCNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            DC base terminals interconnected with zero impedance at a this DC connectivity
            node.
            '''
        
        })
    '''
    DC base terminals interconnected with zero impedance at a this DC connectivity
    node.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class DCTopologicalIsland(IdentifiedObject):
    '''
    An electrically connected subset of the network. DC topological islands
    can change as the current network state changes, e.g. due to:
    - disconnect switches or breakers changing state in a SCADA/EMS.
    - manual creation, change or deletion of topological nodes in a planning
    tool.
    Only energised TopologicalNode-s shall be part of the topological island.
    '''

    DCTopologicalNodes: list[DCTopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCTopologicalNode.DCTopologicalIsland',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The DC topological nodes in a DC topological island.
            '''
        
        })
    '''
    The DC topological nodes in a DC topological island.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DCTopologicalNode(IdentifiedObject):
    '''
    DC bus.
    '''

    DCEquipmentContainer: Optional[DCEquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCEquipmentContainer.DCTopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The connectivity node container to which the topological node belongs.
            '''
        
        })
    '''
    The connectivity node container to which the topological node belongs.
    '''
    
    DCTopologicalIsland: Optional[DCTopologicalIsland] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTopologicalIsland.DCTopologicalNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A DC topological node belongs to a DC topological island.
            '''
        
        })
    '''
    A DC topological node belongs to a DC topological island.
    '''
    
    DCTerminals: list[DCBaseTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCBaseTerminal.DCTopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            See association end TopologicalNode.Terminal.
            '''
        
        })
    '''
    See association end TopologicalNode.Terminal.
    '''
    
    DCNodes: list[DCNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCNode.DCTopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The DC connectivity nodes combined together to form this DC topological
            node. May depend on the current state of switches in the network.
            '''
        
        })
    '''
    The DC connectivity nodes combined together to form this DC topological
    node. May depend on the current state of switches in the network.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DC'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DERGroupDispatch(IdentifiedObject):
    '''
    Specifies the capabilities of the DER Group that are to be dispatched according
    to a schedule. Each dispatch identifies a DER Group and the specific monitorable
    parameter to be dispatched over a specific time interval.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DER'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DERGroupForecast(IdentifiedObject):
    '''
    Specifies the forecasted values of the DERMonitorableParameters for a DER
    Group over a specific time interval.
    '''

    predictionCreationDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The timestamp for when the DER Group forecast was created
            '''
        
        })
    '''
    The timestamp for when the DER Group forecast was created
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DER'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DayType(IdentifiedObject):
    '''
    Group of similar days. For example it could be used to represent weekdays,
    weekend, or holidays.
    '''

    SeasonDayTypeSchedules: list[SeasonDayTypeSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SeasonDayTypeSchedule.DayType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Schedules that use this DayType.
            '''
        
        })
    '''
    Schedules that use this DayType.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DemandResponseProgram(IdentifiedObject):
    '''
    Demand response program.
    '''

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of demand response program; examples are CPP (critical-peak pricing),
            RTP (real-time pricing), DLC (direct load control), DBP (demand bidding
            program), BIP (base interruptible program). Note that possible types change
            a lot and it would be impossible to enumerate them all.
            '''
        
        })
    '''
    Type of demand response program; examples are CPP (critical-peak pricing),
    RTP (real-time pricing), DLC (direct load control), DBP (demand bidding
    program), BIP (base interruptible program). Note that possible types
    change a lot and it would be impossible to enumerate them all.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Diagram(IdentifiedObject):
    '''
    The diagram being exchanged. The coordinate system is a standard Cartesian
    coordinate system and the orientation attribute defines the orientation.
    The initial view related attributes can be used to specify an initial view
    with the x,y coordinates of the diagonal points.
    '''

    x1InitialView: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            X coordinate of the first corner of the initial view.
            '''
        
        })
    '''
    X coordinate of the first corner of the initial view.
    '''
    
    x2InitialView: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            X coordinate of the second corner of the initial view.
            '''
        
        })
    '''
    X coordinate of the second corner of the initial view.
    '''
    
    y1InitialView: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Y coordinate of the first corner of the initial view.
            '''
        
        })
    '''
    Y coordinate of the first corner of the initial view.
    '''
    
    y2InitialView: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Y coordinate of the second corner of the initial view.
            '''
        
        })
    '''
    Y coordinate of the second corner of the initial view.
    '''
    
    orientation: Optional[ OrientationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Coordinate system orientation of the diagram. A positive orientation gives
            standard �right-hand� orientation, with negative orientation indicating
            a �left-hand� orientation. For 2D diagrams, a positive orientation will
            result in X values increasing from left to right and Y values increasing
            from bottom to top. A negative orientation gives the �left-hand� orientation
            (favoured by computer graphics displays) with X values increasing from
            left to right and Y values increasing from top to bottom.
            '''
        
        })
    '''
    Coordinate system orientation of the diagram. A positive orientation
    gives standard �right-hand� orientation, with negative orientation
    indicating a �left-hand� orientation. For 2D diagrams, a positive orientation
    will result in X values increasing from left to right and Y values
    increasing from bottom to top. A negative orientation gives the �left-hand�
    orientation (favoured by computer graphics displays) with X values
    increasing from left to right and Y values increasing from top to bottom.
    '''
    
    DiagramStyle: Optional[DiagramStyle] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiagramStyle.Diagram',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A Diagram may have a DiagramStyle.
            '''
        
        })
    '''
    A Diagram may have a DiagramStyle.
    '''
    
    DiagramElements: list[DiagramObject] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObject.Diagram',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A diagram is made up of multiple diagram objects.
            '''
        
        })
    '''
    A diagram is made up of multiple diagram objects.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DiagramLayout'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DiagramObject(IdentifiedObject):
    '''
    An object that defines one or more points in a given space. This object
    can be associated with anything that specializes IdentifiedObject. For
    single line diagrams such objects typically include such items as analog
    values, breakers, disconnectors, power transformers, and transmission lines.
    '''

    drawingOrder: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The drawing order of this element. The higher the number, the later the
            element is drawn in sequence. This is used to ensure that elements that
            overlap are rendered in the correct order.
            '''
        
        })
    '''
    The drawing order of this element. The higher the number, the later
    the element is drawn in sequence. This is used to ensure that elements
    that overlap are rendered in the correct order.
    '''
    
    isPolygon: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Defines whether or not the diagram objects points define the boundaries
            of a polygon or the routing of a polyline. If this value is true then a
            receiving application should consider the first and last points to be connected.
            '''
        
        })
    '''
    Defines whether or not the diagram objects points define the boundaries
    of a polygon or the routing of a polyline. If this value is true then
    a receiving application should consider the first and last points to
    be connected.
    '''
    
    offsetX: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The offset in the X direction. This is used for defining the offset from
            centre for rendering an icon (the default is that a single point specifies
            the centre of the icon).
            The offset is in per-unit with 0 indicating there is no offset from the
            horizontal centre of the icon. -0.5 indicates it is offset by 50% to the
            left and 0.5 indicates an offset of 50% to the right.
            '''
        
        })
    '''
    The offset in the X direction. This is used for defining the offset
    from centre for rendering an icon (the default is that a single point
    specifies the centre of the icon).
    The offset is in per-unit with 0 indicating there is no offset from
    the horizontal centre of the icon. -0.5 indicates it is offset by 50%
    to the left and 0.5 indicates an offset of 50% to the right.
    '''
    
    offsetY: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The offset in the Y direction. This is used for defining the offset from
            centre for rendering an icon (the default is that a single point specifies
            the centre of the icon).
            The offset is in per-unit with 0 indicating there is no offset from the
            vertical centre of the icon. The offset direction is dependent on the orientation
            of the diagram, with -0.5 and 0.5 indicating an offset of +/- 50% on the
            vertical axis.
            '''
        
        })
    '''
    The offset in the Y direction. This is used for defining the offset
    from centre for rendering an icon (the default is that a single point
    specifies the centre of the icon).
    The offset is in per-unit with 0 indicating there is no offset from
    the vertical centre of the icon. The offset direction is dependent
    on the orientation of the diagram, with -0.5 and 0.5 indicating an
    offset of +/- 50% on the vertical axis.
    '''
    
    rotation: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Sets the angle of rotation of the diagram object. Zero degrees is pointing
            to the top of the diagram. Rotation is clockwise. DiagramObject.rotation=0
            has the following meaning: The connection point of an element which has
            one terminal is pointing to the top side of the diagram. The connection
            point "From side" of an element which has more than one terminal is pointing
            to the top side of the diagram.
            DiagramObject.rotation=90 has the following meaning: The connection point
            of an element which has one terminal is pointing to the right hand side
            of the diagram. The connection point "From side" of an element which has
            more than one terminal is pointing to the right hand side of the diagram.
            '''
        
        })
    '''
    Sets the angle of rotation of the diagram object. Zero degrees is pointing
    to the top of the diagram. Rotation is clockwise. DiagramObject.rotation=0
    has the following meaning: The connection point of an element which
    has one terminal is pointing to the top side of the diagram. The connection
    point "From side" of an element which has more than one terminal is
    pointing to the top side of the diagram.
    DiagramObject.rotation=90 has the following meaning: The connection
    point of an element which has one terminal is pointing to the right
    hand side of the diagram. The connection point "From side" of an element
    which has more than one terminal is pointing to the right hand side
    of the diagram.
    '''
    
    Diagram: Optional[Diagram] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Diagram.DiagramElements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A diagram object is part of a diagram.
            '''
        
        })
    '''
    A diagram object is part of a diagram.
    '''
    
    DiagramObjectStyle: Optional[DiagramObjectStyle] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiagramObjectStyle.StyledObjects',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A diagram object has a style associated that provides a reference for the
            style used in the originating system.
            '''
        
        })
    '''
    A diagram object has a style associated that provides a reference for
    the style used in the originating system.
    '''
    
    IdentifiedObject: Optional[IdentifiedObject] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IdentifiedObject.DiagramObjects',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The domain object to which this diagram object is associated.
            '''
        
        })
    '''
    The domain object to which this diagram object is associated.
    '''
    
    DiagramObjectPoints: list[DiagramObjectPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObjectPoint.DiagramObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A diagram object can have 0 or more points to reflect its layout position,
            routing (for polylines) or boundary (for polygons).
            '''
        
        })
    '''
    A diagram object can have 0 or more points to reflect its layout position,
    routing (for polylines) or boundary (for polygons).
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DiagramLayout'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TextDiagramObject(DiagramObject):
    '''
    A diagram object for placing free-text or text derived from an associated
    domain object.
    '''

    text: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The text that is displayed by this text diagram object.
            '''
        
        })
    '''
    The text that is displayed by this text diagram object.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DiagramLayout'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DiagramObjectStyle(IdentifiedObject):
    '''
    A reference to a style used by the originating system for a diagram object.
    A diagram object style describes information such as line thickness, shape
    such as circle or rectangle etc, and colour.
    '''

    StyledObjects: list[DiagramObject] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObject.DiagramObjectStyle',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A style can be assigned to multiple diagram objects.
            '''
        
        })
    '''
    A style can be assigned to multiple diagram objects.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DiagramLayout'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DiagramStyle(IdentifiedObject):
    '''
    The diagram style refers to a style used by the originating system for
    a diagram. A diagram style describes information such as schematic, geographic,
    etc.
    '''

    Diagram: list[Diagram] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Diagram.DiagramStyle',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A DiagramStyle can be used by many Diagrams.
            '''
        
        })
    '''
    A DiagramStyle can be used by many Diagrams.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DiagramLayout'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DimensionsInfo(IdentifiedObject):
    '''
    As applicable, the basic linear, area, or volume dimensions of an asset,
    asset type (AssetModel) or other type of object (such as land area). Units
    and multipliers are specified per dimension.
    '''

    orientation: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A description of the orientation of the object relative to the dimensions.
            As an example, a vault may have north-south orientation for the sizeLength
            measurement and sizeDepth may be the height of the vault.
            '''
        
        })
    '''
    A description of the orientation of the object relative to the dimensions.
    As an example, a vault may have north-south orientation for the sizeLength
    measurement and sizeDepth may be the height of the vault.
    '''
    
    sizeDepth: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Depth measurement.
            '''
        
        })
    '''
    Depth measurement.
    '''
    
    sizeDiameter: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Diameter measurement.
            '''
        
        })
    '''
    Diameter measurement.
    '''
    
    sizeLength: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Length measurement.
            '''
        
        })
    '''
    Length measurement.
    '''
    
    sizeWidth: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Width measurement.
            '''
        
        })
    '''
    Width measurement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DispatchInstReply(IdentifiedObject):
    '''
    Response from registered resource acknowledging receipt of dispatch instructions.
    '''

    certificationName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Subject DN is the X509 Certificate Subject DN. This is the essentially
            the certificate name presented by the client. In the case of ADS Certificates,
            this will be the user name. It may be from an API Client or the MP Client
            (GUI).
            The Subject ID normally includes more than just the user name (Common Name),
            it can also contain information such as City, Company ID, etc.
            '''
        
        })
    '''
    The Subject DN is the X509 Certificate Subject DN. This is the essentially
    the certificate name presented by the client. In the case of ADS Certificates,
    this will be the user name. It may be from an API Client or the MP
    Client (GUI).
    The Subject ID normally includes more than just the user name (Common
    Name), it can also contain information such as City, Company ID, etc.
    '''
    
    instructionTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The target date/time for the received instruction.
            '''
        
        })
    '''
    The target date/time for the received instruction.
    '''
    
    instructionType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            instruction type:
            commitment
            out of sequence
            dispatch
            '''
        
        })
    '''
    instruction type:
    commitment
    out of sequence
    dispatch
    '''
    
    receivedTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Timestamp indicating the time at which the instruction was received.
            '''
        
        })
    '''
    Timestamp indicating the time at which the instruction was received.
    '''
    
    startTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            start time
            '''
        
        })
    '''
    start time
    '''
    
    acceptMW: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The accepted mw amount by the responder. aka response mw.
            '''
        
        })
    '''
    The accepted mw amount by the responder. aka response mw.
    '''
    
    acceptStatus: Optional[ DispatchResponseType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The accept status submitted by the responder. enumeration type needs to
            be defined
            '''
        
        })
    '''
    The accept status submitted by the responder. enumeration type needs
    to be defined
    '''
    
    clearedMW: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            MW amount associated with instruction. For 5 minute binding dispatches,
            this is the Goto MW or DOT
            '''
        
        })
    '''
    MW amount associated with instruction. For 5 minute binding dispatches,
    this is the Goto MW or DOT
    '''
    
    passIndicator: Optional[ PassIndicatorType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The type of run for the market clearing.
            '''
        
        })
    '''
    The type of run for the market clearing.
    '''
    
    RegisteredResource: Optional[RegisteredResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RegisteredResource.DispatchInstReply',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Document(IdentifiedObject):
    '''
    Parent class for different groupings of information collected and managed
    as a part of a business process. It will frequently contain references
    to other objects, such as assets, people and power system resources.
    '''

    authorName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Name of the author of this document.
            '''
        
        })
    '''
    Name of the author of this document.
    '''
    
    comment: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Free text comment.
            '''
        
        })
    '''
    Free text comment.
    '''
    
    createdDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date and time that this document was created.
            '''
        
        })
    '''
    Date and time that this document was created.
    '''
    
    lastModifiedDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date and time this document was last modified. Documents may potentially
            be modified many times during their lifetime.
            '''
        
        })
    '''
    Date and time this document was last modified. Documents may potentially
    be modified many times during their lifetime.
    '''
    
    revisionNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Revision number for this document.
            '''
        
        })
    '''
    Revision number for this document.
    '''
    
    subject: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Document subject.
            '''
        
        })
    '''
    Document subject.
    '''
    
    title: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Document title.
            '''
        
        })
    '''
    Document title.
    '''
    
    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Utility-specific classification of this document, according to its corporate
            standards, practices, and existing IT systems (e.g., for management of
            assets, maintenance, work, outage, customers, etc.).
            '''
        
        })
    '''
    Utility-specific classification of this document, according to its
    corporate standards, practices, and existing IT systems (e.g., for
    management of assets, maintenance, work, outage, customers, etc.).
    '''
    
    Approver: Optional[Approver] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Approver.Documents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Approver of this document.
            '''
        
        })
    '''
    Approver of this document.
    '''
    
    Author: Optional[Author] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Author.Documents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Author of this document.
            '''
        
        })
    '''
    Author of this document.
    '''
    
    Editor: Optional[Editor] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Editor.Documents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Editor of this document.
            '''
        
        })
    '''
    Editor of this document.
    '''
    
    Issuer: Optional[Issuer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Issuer.Documents',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Issuer of this document.
            '''
        
        })
    '''
    Issuer of this document.
    '''
    
    ActivityRecord: list[ActivityRecord] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ActivityRecord.Document',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The activity record for a document
            '''
        
        })
    '''
    The activity record for a document
    '''
    
    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConfigurationEvent.ChangedDocument',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All configuration events created for this document.
            '''
        
        })
    '''
    All configuration events created for this document.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Agreement(Document):
    '''
    Formal agreement between two parties defining the terms and conditions
    for a set of services. The specifics of the services are, in turn, defined
    via one or more service agreements.
    '''

    signDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date this agreement was consummated among associated persons and/or organisations.
            '''
        
        })
    '''
    Date this agreement was consummated among associated persons and/or
    organisations.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AuxiliaryAgreement(Agreement):
    '''
    An ad-hoc auxiliary account agreement associated with a customer agreement,
    not part of the customer's account, but typically subject to formal agreement
    between customer and supplier (utility). Typically this is used to collect
    revenue owed by the customer for other services or arrears accrued with
    the utility for other services. It is typically linked to a prepaid token
    purchase transaction, thus forcing the customer to make a payment towards
    settlement of the auxiliary account balance whenever the customer needs
    to purchase a prepaid token for electricity.
    The present status of the auxiliary agreement can be defined in the context
    of the utility's business rules, for example: enabled, disabled, pending,
    over recovered, under recovered, written off, etc.
    '''

    auxCycle: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The frequency for automatically recurring auxiliary charges, where 'AuxiliaryAccount.initialCharge'
            is recursively added to 'AuxiliaryAccount.dueCurrent' at the start of each
            'auxCycle'. For example: on a specified date and time; hourly; daily; weekly;
            monthly; 3-monthly; 6-monthly; 12-monthly; etc.
            '''
        
        })
    '''
    The frequency for automatically recurring auxiliary charges, where
    'AuxiliaryAccount.initialCharge' is recursively added to 'AuxiliaryAccount.dueCurrent'
    at the start of each 'auxCycle'. For example: on a specified date and
    time; hourly; daily; weekly; monthly; 3-monthly; 6-monthly; 12-monthly;
    etc.
    '''
    
    auxPriorityCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The coded priority indicating the priority that this auxiliary agreement
            has above other auxiliary agreements (associated with the same customer
            agreement) when it comes to competing for settlement from a payment transaction
            or token purchase.
            '''
        
        })
    '''
    The coded priority indicating the priority that this auxiliary agreement
    has above other auxiliary agreements (associated with the same customer
    agreement) when it comes to competing for settlement from a payment
    transaction or token purchase.
    '''
    
    payCycle: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The contractually expected payment frequency (by the customer). Examples
            are: ad-hoc; on specified date; hourly, daily, weekly, monthly. etc.
            '''
        
        })
    '''
    The contractually expected payment frequency (by the customer). Examples
    are: ad-hoc; on specified date; hourly, daily, weekly, monthly. etc.
    '''
    
    subType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Sub-classification of the inherited 'type' for this AuxiliaryAgreement.
            '''
        
        })
    '''
    Sub-classification of the inherited 'type' for this AuxiliaryAgreement.
    '''
    
    arrearsInterest: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The interest per annum to be charged prorata on 'AuxiliaryAccount.dueArrears'
            at the end of each 'payCycle'.
            '''
        
        })
    '''
    The interest per annum to be charged prorata on 'AuxiliaryAccount.dueArrears'
    at the end of each 'payCycle'.
    '''
    
    fixedAmount: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The fixed amount that has to be collected from each vending transaction
            towards settlement of this auxiliary agreement. Note that there may be
            multiple tokens vended per vending transaction, but this is not relevant.
            '''
        
        })
    '''
    The fixed amount that has to be collected from each vending transaction
    towards settlement of this auxiliary agreement. Note that there may
    be multiple tokens vended per vending transaction, but this is not
    relevant.
    '''
    
    minAmount: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The minimum amount that has to be paid at any transaction towards settling
            this auxiliary agreement or reducing the balance.
            '''
        
        })
    '''
    The minimum amount that has to be paid at any transaction towards settling
    this auxiliary agreement or reducing the balance.
    '''
    
    vendPortion: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The percentage of the transaction amount that has to be collected from
            each vending transaction towards settlement of this auxiliary agreement
            when payments are not in arrears. Note that there may be multiple tokens
            vended per vending transaction, but this is not relevant.
            '''
        
        })
    '''
    The percentage of the transaction amount that has to be collected from
    each vending transaction towards settlement of this auxiliary agreement
    when payments are not in arrears. Note that there may be multiple tokens
    vended per vending transaction, but this is not relevant.
    '''
    
    vendPortionArrear: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The percentage of the transaction amount that has to be collected from
            each vending transaction towards settlement of this auxiliary agreement
            when payments are in arrears. Note that there may be multiple tokens vended
            per vending transaction, but this is not relevant.
            '''
        
        })
    '''
    The percentage of the transaction amount that has to be collected from
    each vending transaction towards settlement of this auxiliary agreement
    when payments are in arrears. Note that there may be multiple tokens
    vended per vending transaction, but this is not relevant.
    '''
    
    CustomerAgreement: Optional[CustomerAgreement] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CustomerAgreement.AuxiliaryAgreements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Customer agreement this (non-service related) auxiliary agreement refers
            to.
            '''
        
        })
    '''
    Customer agreement this (non-service related) auxiliary agreement refers
    to.
    '''
    
    AuxiliaryAccounts: list[AuxiliaryAccount] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AuxiliaryAccount.AuxiliaryAgreement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All auxiliary accounts regulated by this agreement.
            '''
        
        })
    '''
    All auxiliary accounts regulated by this agreement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'PaymentMetering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CustomerAgreement(Agreement):
    '''
    Agreement between the customer and the service supplier to pay for service
    at a specific service location. It records certain billing information
    about the type of service provided at the service location and is used
    during charge creation to determine the type of service.
    '''

    isPrePay: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If true, the customer is a pre-pay customer for the specified service.
            '''
        
        })
    '''
    If true, the customer is a pre-pay customer for the specified service.
    '''
    
    loadMgmt: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Load management code.
            '''
        
        })
    '''
    Load management code.
    '''
    
    shutOffDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Final date and time the service will be billed to the previous customer.
            '''
        
        })
    '''
    Final date and time the service will be billed to the previous customer.
    '''
    
    Customer: Optional[Customer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Customer.CustomerAgreements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Customer for this agreement.
            '''
        
        })
    '''
    Customer for this agreement.
    '''
    
    CustomerAccount: Optional[CustomerAccount] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CustomerAccount.CustomerAgreements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Customer account owning this agreement.
            '''
        
        })
    '''
    Customer account owning this agreement.
    '''
    
    MeterReadSchedule: Optional[MeterReadSchedule] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeterReadSchedule.CustomerAgreement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Meter read schedule that applies to the customer agreement
            '''
        
        })
    '''
    Meter read schedule that applies to the customer agreement
    '''
    
    ServiceCategory: Optional[ServiceCategory] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ServiceCategory.CustomerAgreements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Service category for this agreement.
            '''
        
        })
    '''
    Service category for this agreement.
    '''
    
    ServiceSupplier: Optional[ServiceSupplier] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ServiceSupplier.CustomerAgreements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Service supplier for this customer agreement.
            '''
        
        })
    '''
    Service supplier for this customer agreement.
    '''
    
    StandardIndustryCode: Optional[StandardIndustryCode] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StandardIndustryCode.CustomerAgreements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    AuxiliaryAgreements: list[AuxiliaryAgreement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AuxiliaryAgreement.CustomerAgreement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All (non-service related) auxiliary agreements that refer to this customer
            agreement.
            '''
        
        })
    '''
    All (non-service related) auxiliary agreements that refer to this customer
    agreement.
    '''
    
    MeterReadings: list[MeterReading] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeterReading.CustomerAgreement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            (could be deprecated in the future) All meter readings for this customer
            agreement.
            '''
        
        })
    '''
    (could be deprecated in the future) All meter readings for this customer
    agreement.
    '''
    
    UsagePoints: list[UsagePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'UsagePoint.CustomerAgreement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All service delivery points regulated by this customer agreement.
            '''
        
        })
    '''
    All service delivery points regulated by this customer agreement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Customers'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class EnergyProduct(Agreement):
    '''
    An EnergyProduct is offered commercially as a ContractOrTariff.
    '''

    GenerationProvider: Optional[GenerationProvider] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'GenerationProvider.ProvidedBy',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TitleHeldBy_Marketer: Optional[Marketer] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Marketer.HoldsTitleTo_EnergyProducts',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A Marketer holds title to an EnergyProduct.
            '''
        
        })
    '''
    A Marketer holds title to an EnergyProduct.
    '''
    
    EnergyTransactions: list[EnergyTransaction] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyTransaction.EnergyProduct',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The "Source" for an EnergyTransaction is an EnergyProduct which is injected
            into a ControlArea. Typically this is a ServicePoint.
            '''
        
        })
    '''
    The "Source" for an EnergyTransaction is an EnergyProduct which is
    injected into a ControlArea. Typically this is a ServicePoint.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfEnergyScheduling'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ExternalCustomerAgreement(Agreement):
    '''
    A type of customer agreement involving an external agency. For example,
    a customer may form a contracts with an Energy Service Supplier if Direct
    Access is permitted.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfCustomers'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FTR(Agreement):
    '''
    Financial Transmission Rights (FTR) regarding transmission capacity at
    a flowgate.
    '''

    action: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Buy, Sell
            '''
        
        })
    '''
    Buy, Sell
    '''
    
    _class: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Peak, Off-peak, 24-hour
            '''
        
        })
    '''
    Peak, Off-peak, 24-hour
    '''
    
    ftrType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Type of rights being offered (product) allowed to be auctioned (option,
            obligation).
            '''
        
        })
    '''
    Type of rights being offered (product) allowed to be auctioned (option,
    obligation).
    '''
    
    optimized: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Fixed (covers re-configuration, grandfathering) or Optimized (up for sale/purchase
            '''
        
        })
    '''
    Fixed (covers re-configuration, grandfathering) or Optimized (up for
    sale/purchase
    '''
    
    baseEnergy: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Quantity, typically MWs - Seller owns all rights being offered, MWs over
            time on same Point of Receipt, Point of Delivery, or Resource.
            '''
        
        })
    '''
    Quantity, typically MWs - Seller owns all rights being offered, MWs
    over time on same Point of Receipt, Point of Delivery, or Resource.
    '''
    
    EnergyPriceCurve: Optional[EnergyPriceCurve] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyPriceCurve.FTRs',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Flowgate: Optional[Flowgate] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Flowgate.FTRs',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfCongestionRevenueRights'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IntSchedAgreement(Agreement):
    '''
    A type of agreement that provides the default method by which interchange
    schedules are to be integrated to obtain hourly MWh schedules for accounting.
    '''

    defaultIntegrationMethod: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The default method by which interchange schedules are to be integrated
            to obtain hourly MWh schedules for accounting. Method #1 is to integrate
            the instantaneous schedule between the hourly boundaries. Method #2 compensates
            for any up/down ramping that occurs across the hourly boundary (this is
            called block accounting).
            '''
        
        })
    '''
    The default method by which interchange schedules are to be integrated
    to obtain hourly MWh schedules for accounting. Method #1 is to integrate
    the instantaneous schedule between the hourly boundaries. Method #2
    compensates for any up/down ramping that occurs across the hourly boundary
    (this is called block accounting).
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfFinancial'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LocationGrant(Agreement):
    '''
    A grant provides a right, as defined by type, for a parcel of land. Note
    that the association to Location, Asset, Organisation, etc. for the Grant
    is inherited from Agreement, a type of Document.
    '''

    propertyData: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Property related information that describes the Grant's land parcel. For
            example, it may be a deed book number, deed book page number, and parcel
            number.
            '''
        
        })
    '''
    Property related information that describes the Grant's land parcel.
    For example, it may be a deed book number, deed book page number, and
    parcel number.
    '''
    
    LandProperty: Optional[LandProperty] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LandProperty.LocationGrants',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Land property this location grant applies to.
            '''
        
        })
    '''
    Land property this location grant applies to.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfLocations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MerchantAgreement(Agreement):
    '''
    A formal controlling contractual agreement between supplier and merchant,
    in terms of which the merchant is authorised to vend tokens and receipt
    payments on behalf of the supplier. The merchant is accountable to the
    supplier for revenue collected at point of sale.
    '''

    MerchantAccounts: list[MerchantAccount] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MerchantAccount.MerchantAgreement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All merchant accounts instantiated as a result of this merchant agreement.
            '''
        
        })
    '''
    All merchant accounts instantiated as a result of this merchant agreement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'PaymentMetering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OpenAccessProduct(Agreement):
    '''
    Contracts for services offered commercially.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfFinancial'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RightOfWay(Agreement):
    '''
    A right-of-way (ROW) is for land where it is lawful to use for a public
    road, an electric power line, etc. Note that the association to Location,
    Asset, Organisation, etc. for the Grant is inherited from Agreement, a
    type of Document.
    '''

    propertyData: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Property related information that describes the ROW's land parcel. For
            example, it may be a deed book number, deed book page number, and parcel
            number.
            '''
        
        })
    '''
    Property related information that describes the ROW's land parcel.
    For example, it may be a deed book number, deed book page number, and
    parcel number.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfLocations'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Analytic(Document):
    '''
    An algorithm or calculation for making an assessment about an asset or
    asset grouping for lifecycle decision making.
    '''

    bestValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Value that indicates best possible numeric value.
            '''
        
        })
    '''
    Value that indicates best possible numeric value.
    '''
    
    worstValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Value that indicates worst possible numeric value.
            '''
        
        })
    '''
    Value that indicates worst possible numeric value.
    '''
    
    kind: Optional[ AnalyticKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of analytic this analytic is.
            '''
        
        })
    '''
    Kind of analytic this analytic is.
    '''
    
    scaleKind: Optional[ ScaleKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The scoring scale kind.
            '''
        
        })
    '''
    The scoring scale kind.
    '''
    
    AnalyticScore: list[AnalyticScore] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalyticScore.Analytic',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Analytic score produced by this analytic.
            '''
        
        })
    '''
    Analytic score produced by this analytic.
    '''
    
    AssetHealthEvent: list[AssetHealthEvent] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AssetHealthEvent.Analytic',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Asset health event which can be generated by this analytic.
            '''
        
        })
    '''
    Asset health event which can be generated by this analytic.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssetGroup(Document):
    '''
    A grouping of assets created for a purpose such as fleet analytics, inventory
    or compliance management.
    '''

    kind: Optional[ AssetGroupKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of asset group this asset group is.
            '''
        
        })
    '''
    Kind of asset group this asset group is.
    '''
    
    AnalyticScore: list[AnalyticScore] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalyticScore.AssetGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Analytic score for this asset group.
            '''
        
        })
    '''
    Analytic score for this asset group.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class AssetModelCatalogueItem(Document):
    '''
    Provides pricing and other relevant information about a specific manufacturer's
    product (i.e., AssetModel), and its price from a given supplier. A single
    AssetModel may be availble from multiple suppliers. Note that manufacturer
    and supplier are both types of organisation, which the association is inherited
    from Document.
    '''

    unitCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Unit cost for an asset model from a specific supplier, either for a unit
            cost or cost per unit length. Cost is for material or asset only and does
            not include labor to install/construct or configure it.
            '''
        
        })
    '''
    Unit cost for an asset model from a specific supplier, either for a
    unit cost or cost per unit length. Cost is for material or asset only
    and does not include labor to install/construct or configure it.
    '''
    
    AssetModel: Optional[ProductAssetModel] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ProductAssetModel.AssetModelCatalogueItems',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    AssetModelCatalogue: Optional[AssetModelCatalogue] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AssetModelCatalogue.AssetModelCatalogueItems',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ErpPOLineItems: list[ErpPOLineItem] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ErpPOLineItem.AssetModelCatalogueItem',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ErpQuoteLineItems: list[ErpQuoteLineItem] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ErpQuoteLineItem.AssetModelCatalogueItem',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfAssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AuxiliaryAccount(Document):
    '''
    Variable and dynamic part of auxiliary agreement, generally representing
    the current state of the account related to the outstanding balance defined
    in auxiliary agreement.
    '''

    balance: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The total amount currently remaining on this account that is required to
            be paid in order to settle the account to zero. This excludes any due amounts
            not yet paid.
            '''
        
        })
    '''
    The total amount currently remaining on this account that is required
    to be paid in order to settle the account to zero. This excludes any
    due amounts not yet paid.
    '''
    
    principleAmount: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The initial principle amount, with which this account was instantiated.
            '''
        
        })
    '''
    The initial principle amount, with which this account was instantiated.
    '''
    
    AuxiliaryAgreement: Optional[AuxiliaryAgreement] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AuxiliaryAgreement.AuxiliaryAccounts',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Auxiliary agreement regulating this account.
            '''
        
        })
    '''
    Auxiliary agreement regulating this account.
    '''
    
    PaymentTransactions: list[Transaction] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Transaction.AuxiliaryAccount',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All payments against this account.
            '''
        
        })
    '''
    All payments against this account.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'PaymentMetering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BankAccount(Document):
    '''
    Bank account.
    '''

    accountNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Account reference number.
            '''
        
        })
    '''
    Account reference number.
    '''
    
    Bank: Optional[Bank] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Bank.BankAccounts',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Bank that provides this BankAccount.
            '''
        
        })
    '''
    Bank that provides this BankAccount.
    '''
    
    ServiceSupplier: Optional[ServiceSupplier] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ServiceSupplier.BankAccounts',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            ServiceSupplier that is owner of this BankAccount.
            '''
        
        })
    '''
    ServiceSupplier that is owner of this BankAccount.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfCommon'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ErpBankAccount(BankAccount):
    '''
    Relationship under a particular name, usually evidenced by a deposit against
    which withdrawals can be made. Types of bank accounts include: demand,
    time, custodial, joint, trustee, corporate, special, and regular accounts.
    A statement of transactions during a fiscal period and the resulting balance
    is maintained on each account.
    For Payment metering, the account is associated with Bank and Supplier,
    reflecting details of the bank account used for depositing revenue collected
    by TokenVendor. The name of the account holder should be specified in 'name'
    attribute.
    '''

    bankABA: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Bank ABA.
            '''
        
        })
    '''
    Bank ABA.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfERPSupport'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BaseWork(Document):
    '''
    Common representation for work and work tasks.
    '''

    kind: Optional[ ServiceRequestKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of work.
            '''
        
        })
    '''
    Kind of work.
    '''
    
    statusKind: Optional[ WorkStatusKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of work status.
            '''
        
        })
    '''
    Kind of work status.
    '''
    
    WorkLocation: Optional[WorkLocation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WorkLocation.BaseWorks',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Location for this work/task.
            '''
        
        })
    '''
    Location for this work/task.
    '''
    
    WorkActivityRecords: list[WorkActivityRecord] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WorkActivityRecord.BaseWork',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All activity records for this work or work task.
            '''
        
        })
    '''
    All activity records for this work or work task.
    '''
    
    TimeSchedules: list[WorkTimeSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WorkTimeSchedule.BaseWork',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All time schedules for this work or work task.
            '''
        
        })
    '''
    All time schedules for this work or work task.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Work'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class Work(BaseWork):
    '''
    Document used to request, initiate, track and record work.
    '''

    requestDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date and time work was requested.
            '''
        
        })
    '''
    Date and time work was requested.
    '''
    
    workOrderNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Work order number (or other unique identifying information) for this work.
            '''
        
        })
    '''
    Work order number (or other unique identifying information) for this
    work.
    '''
    
    BusinessCase: Optional[BusinessCase] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BusinessCase.Works',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ErpProjectAccounting: Optional[ErpProjectAccounting] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ErpProjectAccounting.Works',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Project: Optional[Project] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Project.Works',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WorkBillingInfo: Optional[WorkBillingInfo] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WorkBillingInfo.Works',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Designs: list[Design] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Design.Work',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WorkFlowSteps: list[WorkFlowStep] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WorkFlowStep.Work',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WorkTasks: list[WorkTask] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WorkTask.Work',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            All tasks in this work.
            '''
        
        })
    '''
    All tasks in this work.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Work'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WorkTask(BaseWork):
    '''
    A task within a set of work.
    '''

    completedDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date and time work task was completed.
            '''
        
        })
    '''
    Date and time work task was completed.
    '''
    
    crewETA: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Estimated time of arrival, so that customer or police/fire department can
            be informed when the crew will arrive.
            '''
        
        })
    '''
    Estimated time of arrival, so that customer or police/fire department
    can be informed when the crew will arrive.
    '''
    
    estimatedCompletionTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Time and Date when the work task will be completed.
            '''
        
        })
    '''
    Time and Date when the work task will be completed.
    '''
    
    instruction: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Instructions for performing this task.
            '''
        
        })
    '''
    Instructions for performing this task.
    '''
    
    schedOverride: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            If specified, override schedule and perform this task in accordance with
            instructions specified here.
            '''
        
        })
    '''
    If specified, override schedule and perform this task in accordance
    with instructions specified here.
    '''
    
    startedDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Date and time work task was started.
            '''
        
        })
    '''
    Date and time work task was started.
    '''
    
    contractorCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Total contractor costs associated with the work task.
            '''
        
        })
    '''
    Total contractor costs associated with the work task.
    '''
    
    laborCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Total labor costs associated with the work task.
            '''
        
        })
    '''
    Total labor costs associated with the work task.
    '''
    
    laborHours: Optional[ float | Hours ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Hours of labor expended under work task.
            '''
        
        })
    '''
    Hours of labor expended under work task.
    '''
    
    materiallCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Total material costs associated with the work task.
            '''
        
        })
    '''
    Total material costs associated with the work task.
    '''
    
    taskKind: Optional[ WorkTaskKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of work.
            '''
        
        })
    '''
    Kind of work.
    '''
    
    toolCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Total tool costs associated with the work task.
            '''
        
        })
    '''
    Total tool costs associated with the work task.
    '''
    
    SwitchingPlan: Optional[SwitchingPlan] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SwitchingPlan.WorkTasks',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Switching plan executed by this work task.
            '''
        
        })
    '''
    Switching plan executed by this work task.
    '''
    
    TroubleOrder: Optional[TroubleOrder] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TroubleOrder.WorkTask',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The trouble order that contains the work tasks.
            '''
        
        })
    '''
    The trouble order that contains the work tasks.
    '''
    
    Work: Optional[Work] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Work.WorkTasks',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Work this task belongs to.
            '''
        
        })
    '''
    Work this task belongs to.
    '''
    
    MaterialItems: list[MaterialItem] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MaterialItem.WorkTask',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            The material items that are required to perform the work task.
            '''
        
        })
    '''
    The material items that are required to perform the work task.
    '''
    
    ProcedureDataSet: list[ProcedureDataSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProcedureDataSet.WorkTask',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            Procedure data set associated with this work task.
            '''
        
        })
    '''
    Procedure data set associated with this work task.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Work'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MaintenanceWorkTask(WorkTask):
    '''
    Maintenance work task. Costs associated with this are considered preventive
    maintenance (PM) costs.
    '''

    breakerMaintenanceKind: Optional[ BreakerMaintenanceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of breaker maintenance performed by this maintenance work task.
            '''
        
        })
    '''
    Kind of breaker maintenance performed by this maintenance work task.
    '''
    
    transformerMaintenanceKind: Optional[ TransformerMaintenanceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Kind of transformer maintenance performed by this maintenance work task.
            '''
        
        })
    '''
    Kind of transformer maintenance performed by this maintenance work
    task.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Work'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MeterWorkTask(WorkTask):
    '''
    Work task involving meters.
    '''

    Meter: Optional[Meter] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Meter.MeterServiceWorkTask',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Meter on which this non-replacement work task is performed.
            '''
        
        })
    '''
    Meter on which this non-replacement work task is performed.
    '''
    
    OldMeter: Optional[Meter] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Meter.MeterReplacementWorkTasks',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Old meter replaced by this work task.
            '''
        
        })
    '''
    Old meter replaced by this work task.
    '''
    
    UsagePoint: Optional[UsagePoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'UsagePoint.MeterServiceWorkTasks',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Usage point to which this meter service work task applies.
            '''
        
        })
    '''
    Usage point to which this meter service work task applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class OldWorkTask(WorkTask):
    '''
    A set of tasks is required to implement a design.
    '''

    Design: Optional[Design] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Design.WorkTasks',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    OverheadCost: Optional[OverheadCost] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OverheadCost.WorkTasks',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WorkFlowStep: Optional[WorkFlowStep] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WorkFlowStep.WorkTasks',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ContractorItems: list[ContractorItem] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ContractorItem.WorkTask',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    LaborItems: list[LaborItem] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LaborItem.WorkTask',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MiscCostItems: list[MiscCostItem] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MiscCostItem.WorkTask',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Usages: list[Usage] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Usage.WorkTask',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WorkCostDetails: list[WorkCostDetail] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WorkCostDetail.WorkTask',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'InfWork'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RepairWorkTask(WorkTask):
    '''
    Work task for asset repair. Costs associated with this are considered corrective
    maintenance (CM) costs.
    '''

    emergency: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Repair work is emergency.
            '''
        
        })
    '''
    Repair work is emergency.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Work'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Bid(Document):
    '''
    Represents both bids to purchase and offers to sell energy or ancillary
    services in an RTO-sponsored market.
    '''

    startTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Start time and date for which bid applies.
            '''
        
        })
    '''
    Start time and date for which bid applies.
    '''
    
    stopTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Stop time and date for which bid is applicable.
            '''
        
        })
    '''
    Stop time and date for which bid is applicable.
    '''
    
    marketType: Optional[ MarketType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The market type, DAM or RTM.
            '''
        
        })
    '''
    The market type, DAM or RTM.
    '''
    
    ActionRequest: Optional[ActionRequest] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ActionRequest.Bid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    EnergyMarket: Optional[EnergyMarket] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'EnergyMarket.Bids',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MarketParticipant: Optional[MarketParticipant] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MarketParticipant.Bid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    BidHourlySchedule: list[BidHourlySchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BidHourlySchedule.Bid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ChargeProfiles: list[ChargeProfile] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ChargeProfile.Bid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MitigatedBid: list[MitigatedBid] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MitigatedBid.Bid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    MitigatedBidSegment: list[MitigatedBidSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MitigatedBidSegment.Bid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ProductBids: list[ProductBid] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProductBid.Bid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            A bid comprises one or more product bids of market products
            '''
        
        })
    '''
    A bid comprises one or more product bids of market products
    '''
    
    RMRDetermination: list[RMRDetermination] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RMRDetermination.Bid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AreaLoadBid(Bid):
    '''
    AreaLoadBid is not submitted by a market participant into the Markets.
    Instead, it is simply an aggregation of all LoadBids contained wtihin a
    specific SubControlArea. This entity should inherit from Bid for representation
    of the timeframe (startTime, stopTime) and the market type.
    '''

    demandBidMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            The Demand Bid Megawatt for the area case.
            Attribute Usage: This is Scheduled demand MW in Day Ahead
            '''
        
        })
    '''
    The Demand Bid Megawatt for the area case.
    Attribute Usage: This is Scheduled demand MW in Day Ahead
    '''
    
    LoadBid: list[LoadBid] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LoadBid.AreaLoadBid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DefaultBid(Bid):
    '''
    DefaultBid is a generic class to hold Default Energy Bid, Default Startup
    Bid, and Default Minimum Load Bid:
    Default Energy Bid
    A Default Energy Bid is a monotonically increasing staircase function consisting
    at maximum 10 economic bid segments, or 10 ($/MW, MW) pairs. There are
    three methods for determining the Default Energy Bid:
    <ul>
    <li>Cost Based: derived from the Heat Rate or Average Cost multiplied by
    the Gas Price Index plus 10%.</li>
    <li>LMP Based: a weighted average of LMPs in the preceding 90 days.</li>
    <li>Negotiated: an amount negotiated with the designated Independent Entity.</li>
    </ul>
    Default Startup Bid
    A Default Startup Bid (DSUB) shall be calculated for each RMR unit based
    on the Startup Cost stored in the Master File and the applicable GPI and
    EPI.
    Default Minimum Load Bid
    A Default Minimum Load Bid (DMLB) shall be calculated for each RMR unit
    based on the Minimum Load Cost stored in the Master File and the applicable
    GPI.
    '''

    bidType: Optional[ BidType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Default bid type such as Default Energy Bid, Default Minimum Load Bid,
            and Default Startup Bid
            '''
        
        })
    '''
    Default bid type such as Default Energy Bid, Default Minimum Load Bid,
    and Default Startup Bid
    '''
    
    minLoadCost: Optional[ float | CostRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum load cost in $/hr
            '''
        
        })
    '''
    Minimum load cost in $/hr
    '''
    
    peakFlag: Optional[ OnOff ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            on-peak, off-peak, or all
            '''
        
        })
    '''
    on-peak, off-peak, or all
    '''
    
    DefaultBidCurve: Optional[DefaultBidCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DefaultBidCurve.DefaultBid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredResource: Optional[RegisteredResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RegisteredResource.DefaultBid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    DefaultBidCurve: Optional[DefaultBidCurve] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DefaultBidCurve.DefaultBid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RegisteredResource: Optional[RegisteredResource] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredResource.DefaultBid',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': False,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ExternalInputs'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ResourceBid(Bid):
    '''
    Energy bid for generation, load, or virtual type for the whole of the market-trading
    period (i.e., one day in day ahead market or one hour in the real time
    market).
    '''

    aggregationFlag: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Aggregation flag
            0: individual resource level
            1: Aggregated node location
            2: Aggregated price location)
            '''
        
        })
    '''
    Aggregation flag
    0: individual resource level
    1: Aggregated node location
    2: Aggregated price location)
    '''
    
    bidStatus: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    commodityType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Energy product (commodity) type:
            'En' - Energy
            'Ru' - Regulation Up
            'Rd' - Regulation Dn
            'Sr' - Spinning Reserve
            'Nr' - Non-Spinning Reserve
            'Or' - Operating Reserve
            '''
        
        })
    '''
    Energy product (commodity) type:
    'En' - Energy
    'Ru' - Regulation Up
    'Rd' - Regulation Dn
    'Sr' - Spinning Reserve
    'Nr' - Non-Spinning Reserve
    'Or' - Operating Reserve
    '''
    
    energyMaxDay: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum amount of energy per day which can be produced during the trading
            period in MWh
            '''
        
        })
    '''
    Maximum amount of energy per day which can be produced during the trading
    period in MWh
    '''
    
    energyMinDay: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Minimum amount of energy per day which has to be produced during the trading
            period in MWh
            '''
        
        })
    '''
    Minimum amount of energy per day which has to be produced during the
    trading period in MWh
    '''
    
    marketSepFlag: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Market Separation Flag
            'Y' - Enforce market separation constraints for this bid
            'N' - Don't enforce market separation constraints for this bid.
            '''
        
        })
    '''
    Market Separation Flag
    'Y' - Enforce market separation constraints for this bid
    'N' - Don't enforce market separation constraints for this bid.
    '''
    
    minDispatchTime: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            minimum number of consecutive hours a resource shall be dispatched if bid
            is accepted
            '''
        
        })
    '''
    minimum number of consecutive hours a resource shall be dispatched
    if bid is accepted
    '''
    
    resourceLoadingType: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Resource loading curve type
            1 - step-wise continuous loading
            2 - piece-wise linear continuous loading
            3 - block loading
            '''
        
        })
    '''
    Resource loading curve type
    1 - step-wise continuous loading
    2 - piece-wise linear continuous loading
    3 - block loading
    '''
    
    shutDownsMaxDay: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum number of shutdowns per day.
            '''
        
        })
    '''
    Maximum number of shutdowns per day.
    '''
    
    shutDownsMaxWeek: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum number of shutdowns per week.
            '''
        
        })
    '''
    Maximum number of shutdowns per week.
    '''
    
    startUpsMaxDay: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum number of startups per day.
            '''
        
        })
    '''
    Maximum number of startups per day.
    '''
    
    startUpsMaxWeek: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum number of startups per week.
            '''
        
        })
    '''
    Maximum number of startups per week.
    '''
    
    virtual: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            True if bid is virtual. Bid is assumed to be non-virtual if attribute is
            absent
            '''
        
        })
    '''
    True if bid is virtual. Bid is assumed to be non-virtual if attribute
    is absent
    '''
    
    contingencyAvailFlag: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            contingent operating reserve availiability (Yes/No). Resource is availiable
            to participate with capacity only in contingency dispatch.
            '''
        
        })
    '''
    contingent operating reserve availiability (Yes/No). Resource is availiable
    to participate with capacity only in contingency dispatch.
    '''
    
    createdISO: Optional[ YesNo ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            A Yes indicates that this bid was created by the ISO.
            '''
        
        })
    '''
    A Yes indicates that this bid was created by the ISO.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'ParticipantInterfaces'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GeneratingBid(ResourceBid):
    '''
    Offer to supply energy/ancillary services from a generating unit or resource.
    '''

    combinedCycleUnitOffer: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Will indicate if the unit is part of a CC offer or not
            '''
        
        })
    '''
    Will indicate if the unit is part of a CC offer or not
    '''
    
    downTimeMax: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum down time.
            '''
        
        })
    '''
    Maximum down time.
    '''
    
    installedCapacity: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Installed Capacity value
            '''
        
        })
    '''
    Installed Capacity value
    '''
    
    maximumEconomicMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'serialize': True,
        'docstring':
            '''
            Maximum high economic MW limit, that should not exceed the maximum operating
            MW limit
            '''
        
        })
    '''
    Maximum high economic MW limit, that should not exceed the maximum
    operating MW limit
    '''
    
    minimumEconomicMW: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccu