from __future__ import annotations

import logging
from dataclasses import dataclass, field
from enum import Enum
from typing import Optional

from cimgraph.data_profile.identity import Identity, stereotype
from cimgraph.data_profile.units import CIMUnit, UnitMultiplier, UnitSymbol

_log = logging.getLogger(__name__)
'''
Annotated CIMantic Graphs data profile for CIM18v15
Generated by CIMTool http://cimtool.org
'''

class CIMStereotype(Enum):
    AggregateOf = 'AggregateOf'
    Attribute = 'Attribute'
    CIMDatatype = 'CIMDatatype'
    Compound = 'Compound'
    Concrete = 'Concrete'
    European = 'European'
    Extension = 'Extension'
    GB = 'GB'
    GridAPPSD = 'GridAPPSD'
    NC = 'NC'
    NeedsWork = 'NeedsWork'
    OfAggregate = 'OfAggregate'
    Primitive = 'Primitive'
    ShadowExtension = 'ShadowExtension'
    ToBeRemoved = 'ToBeRemoved'
    add = 'add'
    archive = 'archive'
    deprecated = 'deprecated'
    enumeration = 'enumeration'
    gmdm = 'gmdm'
    harmonization = 'harmonization'
    informative = 'informative'
    modify = 'modify'
    move = 'move'
    moved = 'moved'
    profcim = 'profcim'
    remove = 'remove'

BASE_URI = 'http://www.gridappsd.org/CIM101#'
ONTOLOGY_URI = 'http://cim.ucaiug.io/CIM101/draft#'

@dataclass(repr=False)
class AutomationBlockGroup(Identity):
    '''
    Grouping of function block that are operated with the same priority as
    settings.
    '''

    FunctionBlock: list[FunctionBlock] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionBlock.AutomationBlockGroup',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Function block which belongs to an automation block group.
            '''
        
        })
    '''
    Function block which belongs to an automation block group.
    '''
    
    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value 0 means ignore priority. 1 means the highest priority, 2 is the second
            highest priority.
            '''

        })
    '''
    Value 0 means ignore priority. 1 means the highest priority, 2 is the
    second highest priority.
    '''

    AutomationFunction: Optional[AutomationFunction] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AutomationFunction.AutomationBlockGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Automation function which has automation block group.
            '''

        })
    '''
    Automation function which has automation block group.
    '''
    
@dataclass(repr=False)
class BranchGroupTerminal(Identity):
    '''
    A specific directed terminal flow for a branch group.
    '''

    positiveFlowIn: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The flow into the terminal is summed if set true. The flow out of the terminal
            is summed if set false.
            '''

        })
    '''
    The flow into the terminal is summed if set true. The flow out of the
    terminal is summed if set false.
    '''

    BranchGroup: Optional[BranchGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'BranchGroup.BranchGroupTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The branch group to which the directed branch group terminals belong.
            '''

        })
    '''
    The branch group to which the directed branch group terminals belong.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Terminal.BranchGroupTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminal to be summed.
            '''

        })
    '''
    The terminal to be summed.
    '''
    
@dataclass(repr=False)
class CableArmorInfo(Identity):
    '''
    '''

    materialName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    numberOfTapes: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    strandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    diameterOverArmor: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    layLength: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    strandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    tapeLap: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    tapeThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    TapeWidth: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Thickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class CapacitorBankPhaseInfo(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://gridappsd.org/CIM/extension#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ChangeSetMember(Identity):
    '''
    A CRUD-style data object.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'GenericDataSet'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ComModuleInfo(Identity):
    '''
    Communication module asset informtion
    '''

    direction: Optional[ ComDirectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Communication direction.
            '''

        })
    '''
    Communication direction.
    '''

    technology: Optional[ ComTechnologyKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Communication technology.
            '''

        })
    '''
    Communication technology.
    '''
    
@dataclass(repr=False)
class CurveData(Identity):
    '''
    Multi-purpose data points for defining a curve. The use of this generic
    class is discouraged if a more specific class can be used to specify the
    X and Y axis values along with their specific data types.
    '''

    xvalue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The data value of the X-axis variable, depending on the X-axis units.
            '''

        })
    '''
    The data value of the X-axis variable, depending on the X-axis units.
    '''

    y1value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The data value of the first Y-axis variable, depending on the Y-axis units.
            '''

        })
    '''
    The data value of the first Y-axis variable, depending on the Y-axis
    units.
    '''

    y2value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The data value of the second Y-axis variable (if present), depending on
            the Y-axis units.
            '''

        })
    '''
    The data value of the second Y-axis variable (if present), depending
    on the Y-axis units.
    '''

    y3value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The data value of the third Y-axis variable (if present), depending on
            the Y-axis units.
            '''

        })
    '''
    The data value of the third Y-axis variable (if present), depending
    on the Y-axis units.
    '''

    Curve: Optional[Curve] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Curve.CurveDatas',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The curve of this curve data point.
            '''

        })
    '''
    The curve of this curve data point.
    '''
    
@dataclass(repr=False)
class EVSE(Identity):
    '''
    '''

@dataclass(repr=False)
class FrequencyMonitoringTerminal(Identity):
    '''
    Frequency monitoring terminal provides location in the model where the
    frequency is monitored for the purpose of power frequency control.
    '''

    mRID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Master resource identifier issued by a model authority. The mRID is unique
            within an exchange context. Global uniqueness is easily achieved by using
            a UUID, as specified in RFC 4122, for the mRID. The use of UUID is strongly
            recommended.
            For CIMXML data files in RDF syntax conforming to IEC 61970-552, the mRID
            is mapped to rdf:ID or rdf:about attributes that identify CIM object elements.
            '''

        })
    '''
    Master resource identifier issued by a model authority. The mRID is
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in RFC 4122, for the mRID. The use of
    UUID is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552, the
    mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
    object elements.
    '''

    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value 0 means ignore priority. 1 means the highest priority, 2 is the second
            highest priority.
            '''

        })
    '''
    Value 0 means ignore priority. 1 means the highest priority, 2 is the
    second highest priority.
    '''

    PowerFrequencyController: Optional[PowerFrequencyController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerFrequencyController.FrequencyMonitoringTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power frequency controller that has this frequency monitoring terminal.
            '''

        })
    '''
    Power frequency controller that has this frequency monitoring terminal.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.FrequencyMonitoringTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminal for this frequency monitoring terminal.
            '''

        })
    '''
    The terminal for this frequency monitoring terminal.
    '''
    
@dataclass(repr=False)
class FunctionFunctionLink(Identity):
    '''
    Class to represent links between the inputs and outputs of generic FunctionBlock
    instances as defined in their associated FunctionBlockType instances. The
    destinationParameterName and sourceParameterName attributes must be dfined
    in the instances of the FunctionTypeInput and FunctionTypesOutput classes
    that are associated to the FunctionBlockType.
    '''

    destinationParameterName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name this link takes as input to a function block.
            '''

        })
    '''
    Name this link takes as input to a function block.
    '''

    sourceParameterName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name this link takes as output from a function block.
            '''

        })
    '''
    Name this link takes as output from a function block.
    '''

    DestinationFunctionBlock: Optional[FunctionBlock] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'FunctionBlock.DestinationSideLink',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Function block receiving an input from a FunctionFunctionLink instance
            associated to another function block.
            '''

        })
    '''
    Function block receiving an input from a FunctionFunctionLink instance
    associated to another function block.
    '''

    SourceFunctionBlock: Optional[FunctionBlock] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'FunctionBlock.SourceSideLink',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Function block providing an output to a FunctionFunctionLink instance associated
            to another function block.
            '''

        })
    '''
    Function block providing an output to a FunctionFunctionLink instance
    associated to another function block.
    '''
    
@dataclass(repr=False)
class FunctionLogicDescription(Identity):
    '''
    Class providing a logic description for a FunctionBlockType instance.
    '''

    functionDefinition: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The declaration of this function. Must be consistent with the chosen programLanguage
            attribute.
            '''

        })
    '''
    The declaration of this function. Must be consistent with the chosen
    programLanguage attribute.
    '''

    otherLanguage: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            To be used when the programmingLanguage attribute is in the options defined
            in ProgrammingLanguageKind.
            '''

        })
    '''
    To be used when the programmingLanguage attribute is in the options
    defined in ProgrammingLanguageKind.
    '''

    language: Optional[ ProgrammingLanguageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The programming language used to define the input types, output types and
            declaration of this function.
            '''

        })
    '''
    The programming language used to define the input types, output types
    and declaration of this function.
    '''

    FunctionBlockType: Optional[FunctionBlockType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'FunctionBlockType.FunctionLogicDescriptions',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Function block type whose logic is described by a FunctionLogicDescription
            instance.
            '''

        })
    '''
    Function block type whose logic is described by a FunctionLogicDescription
    instance.
    '''
    
@dataclass(repr=False)
class FunctionTypeInput(Identity):
    '''
    Class to define the inputs to a FunctionBlockType instance. Its parameterType
    and initialValue attributes are defined as strings but must be consistent
    with the programLanguage attribute of the FunctionLogicDescription class
    instance associated to the FunctionBlockType.
    '''

    initialValue: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The initial value defined for this input.Must be consistent with the type
            and the programLanguage attribute of the associated FunctionLogicDescription.
            '''

        })
    '''
    The initial value defined for this input.Must be consistent with the
    type and the programLanguage attribute of the associated FunctionLogicDescription.
    '''

    parameterName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name to this input. This name should be used in instances of FunctionFunctionLink.
            '''

        })
    '''
    Name to this input. This name should be used in instances of FunctionFunctionLink.
    '''

    parameterType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of this input. This type must be consistent with the programLanguage
            attribute of the FunctionLogicDescription class instance associated to
            the FunctionBlockType.
            '''

        })
    '''
    Type of this input. This type must be consistent with the programLanguage
    attribute of the FunctionLogicDescription class instance associated
    to the FunctionBlockType.
    '''

    FunctionBlockType: Optional[FunctionBlockType] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'FunctionBlockType.FunctionTypeInputs',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Function block type receiving this input
            '''

        })
    '''
    Function block type receiving this input
    '''
    
@dataclass(repr=False)
class FunctionTypeOutput(Identity):
    '''
    Class to define the outputs from a FunctionBlockType instance. Its parameterType
    attribute is defined as a string but must be consistent with the programLanguage
    attribute of the FunctionLogicDescription class instance associated to
    the FunctionBlockType.
    '''

    parameterName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name to this output. This name should be used in instances of FunctionFunctionLink.
            '''

        })
    '''
    Name to this output. This name should be used in instances of FunctionFunctionLink.
    '''

    parameterType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of this output. This type must be consistent with the programLanguage
            attribute of the FunctionLogicDescription class instance associated to
            the FunctionBlockType.
            '''

        })
    '''
    Type of this output. This type must be consistent with the programLanguage
    attribute of the FunctionLogicDescription class instance associated
    to the FunctionBlockType.
    '''

    FunctionBlockType: Optional[FunctionBlockType] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'FunctionBlockType.FunctionTypeOutputs',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Function block type providing this output
            '''

        })
    '''
    Function block type providing this output
    '''
    
@dataclass(repr=False)
class FuseInfo(Identity):
    '''
    Fuse datasheet information.
    '''

    MinimumMeltCurve: Optional[FuseCharacteristicCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseCharacteristicCurve.FuseInfoMinimumMelt',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Curves that define the time-current operation of this fuse (Minimum Melt)
            '''

        })
    '''
    Curves that define the time-current operation of this fuse (Minimum
    Melt)
    '''

    TotalClearingTimeCurve: Optional[FuseCharacteristicCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseCharacteristicCurve.FusInfoTotalClearing',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Curves that define the time-current operation of this fuse (Total Clearing
            Time Curves)
            '''

        })
    '''
    Curves that define the time-current operation of this fuse (Total Clearing
    Time Curves)
    '''
    
    MinimumMeltCurve: Optional[FuseCharacteristicCurve] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseCharacteristicCurve.FuseInfoMinimumMelt',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Curves that define the time-current operation of this fuse (Minimum Melt)
            '''

        })
    '''
    Curves that define the time-current operation of this fuse (Minimum
    Melt)
    '''

    TotalClearingTimeCurve: Optional[FuseCharacteristicCurve] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseCharacteristicCurve.FusInfoTotalClearing',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Curves that define the time-current operation of this fuse (Total Clearing
            Time Curves)
            '''

        })
    '''
    Curves that define the time-current operation of this fuse (Total Clearing
    Time Curves)
    '''

@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a class that provides common identification for all classes needing
    identification and naming attributes.
    '''

    mRID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Master resource identifier issued by a model authority. The mRID is unique
            within an exchange context. Global uniqueness is easily achieved by using
            a UUID, as specified in IETF RFC 4122, for the mRID. The use of UUID is
            strongly recommended.
            For CIMXML data files in RDF syntax conforming to IEC 61970-552, the mRID
            is mapped to rdf:ID or rdf:about attributes that identify CIM object elements.
            '''

        })
    '''
    Master resource identifier issued by a model authority. The mRID is
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in IETF RFC 4122, for the mRID. The use
    of UUID is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552, the
    mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
    object elements.
    '''

    aliasName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The aliasName is free text human readable name of the object alternative
            to IdentifiedObject.name. It may be non unique and may not correlate to
            a naming hierarchy.
            The attribute aliasName is retained because of backwards compatibility
            between CIM releases. It is however recommended to replace aliasName with
            the Name class as aliasName is planned for retirement at a future time.
            '''

        })
    '''
    The aliasName is free text human readable name of the object alternative
    to IdentifiedObject.name. It may be non unique and may not correlate
    to a naming hierarchy.
    The attribute aliasName is retained because of backwards compatibility
    between CIM releases. It is however recommended to replace aliasName
    with the Name class as aliasName is planned for retirement at a future
    time.
    '''

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''

        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''

    energyIdentCodeEic: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The attribute is used for an exchange of the EIC code (Energy identification
            Code). The length of the string is 16 characters as defined by the EIC
            code. For details on EIC scheme please refer to ENTSO-E web site.
            '''

        })
    '''
    The attribute is used for an exchange of the EIC code (Energy identification
    Code). The length of the string is 16 characters as defined by the
    EIC code. For details on EIC scheme please refer to ENTSO-E web site.
    '''

    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The name is any free human readable and possibly non unique text naming
            the object.
            '''

        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''

    shortName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The attribute is used for an exchange of a human readable short name with
            length of the string 12 characters maximum.
            '''

        })
    '''
    The attribute is used for an exchange of a human readable short name
    with length of the string 12 characters maximum.
    '''
    
@dataclass(repr=False)
class ACDCTerminal(IdentifiedObject):
    '''
    An electrical connection point (AC or DC) to a piece of conducting equipment.
    Terminals are connected at physical connection points called connectivity
    nodes.
    '''

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Terminal',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurements associated with this terminal defining where the measurement
            is placed in the network topology. It may be used, for instance, to capture
            the sensor position, such as a voltage transformer (PT) at a busbar or
            a current transformer (CT) at the bar between a breaker and an isolator.
            '''
        
        })
    '''
    Measurements associated with this terminal defining where the measurement
    is placed in the network topology. It may be used, for instance, to
    capture the sensor position, such as a voltage transformer (PT) at
    a busbar or a current transformer (CT) at the bar between a breaker
    and an isolator.
    '''
    
    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.Terminal',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit sets at the terminal.
            '''
        
        })
    '''
    The operational limit sets at the terminal.
    '''
    
    connected: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The connected status is related to a bus-branch model and the topological
            node to terminal relation. True implies the terminal is connected to the
            related topological node and false implies it is not.
            In a bus-branch model, the connected status is used to tell if equipment
            is disconnected without having to change the connectivity described by
            the topological node to terminal relation. A valid case is that conducting
            equipment can be connected in one end and open in the other. In particular
            for an AC line segment, where the reactive line charging can be significant,
            this is a relevant case.
            '''

        })
    '''
    The connected status is related to a bus-branch model and the topological
    node to terminal relation. True implies the terminal is connected to
    the related topological node and false implies it is not.
    In a bus-branch model, the connected status is used to tell if equipment
    is disconnected without having to change the connectivity described
    by the topological node to terminal relation. A valid case is that
    conducting equipment can be connected in one end and open in the other.
    In particular for an AC line segment, where the reactive line charging
    can be significant, this is a relevant case.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The orientation of the terminal connections for a multiple terminal conducting
            equipment. The sequence numbering starts with 1 and additional terminals
            should follow in increasing order. The first terminal is the "starting
            point" for a two terminal branch.
            '''

        })
    '''
    The orientation of the terminal connections for a multiple terminal
    conducting equipment. The sequence numbering starts with 1 and additional
    terminals should follow in increasing order. The first terminal is
    the "starting point" for a two terminal branch.
    '''

    BusNameMarker: Optional[BusNameMarker] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BusNameMarker.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The bus name marker used to name the bus (topological node).
            '''

        })
    '''
    The bus name marker used to name the bus (topological node).
    '''
    
@dataclass(repr=False)
class Terminal(ACDCTerminal):
    '''
    An AC electrical connection point to a piece of conducting equipment. Terminals
    are connected at physical connection points called connectivity nodes.
    '''

    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurements associated with this terminal defining where the measurement
            is placed in the network topology. It may be used, for instance, to capture
            the sensor position, such as a voltage transformer (PT) at a busbar or
            a current transformer (CT) at the bar between a breaker and an isolator.
            '''

        })
    '''
    Measurements associated with this terminal defining where the measurement
    is placed in the network topology. It may be used, for instance, to
    capture the sensor position, such as a voltage transformer (PT) at
    a busbar or a current transformer (CT) at the bar between a breaker
    and an isolator.
    '''
    
    FrequencyMonitoringTerminal: list[FrequencyMonitoringTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit sets at the terminal.
            '''

        })
    '''
    The operational limit sets at the terminal.
    '''
    
    HasFirstMutualCoupling: list[MutualCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MutualCoupling.First_Terminal',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Mutual couplings associated with the branch as the first branch.
            '''
        
        })
    '''
    Mutual couplings associated with the branch as the first branch.
    '''
    
    HasSecondMutualCoupling: list[MutualCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MutualCoupling.Second_Terminal',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Mutual couplings with the branch associated as the first branch.
            '''
        
        })
    '''
    Mutual couplings with the branch associated as the first branch.
    '''
    
    ProtectionFunctionBlock: list[ProtectionFunctionBlock] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionFunctionBlock.MonitoredTerminal',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The protection function blocks are connected to the monitored terminal.
            '''
        
        })
    '''
    The protection function blocks are connected to the monitored terminal.
    '''
    
    RegulatingControl: list[RegulatingControl] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulatingControl.Terminal',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The controls regulating this terminal.
            '''
        
        })
    '''
    The controls regulating this terminal.
    '''
    
    TransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.Terminal',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All transformer ends connected at this terminal.
            '''
        
        })
    '''
    All transformer ends connected at this terminal.
    '''
    
    UsagePoint: Optional[UsagePoint] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'UsagePoint.Terminal',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    VoltageAngleLimit: list[VoltageAngleLimit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageAngleLimit.AngleReferenceTerminal',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage angle limit which has this reference angle terminal.
            '''
        
        })
    '''
    The voltage angle limit which has this reference angle terminal.
    '''

    phases: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Represents the normal network phasing condition. If the attribute is missing,
            three phases (ABC) shall be assumed, except for terminals of grounding
            classes (specializations of EarthFaultCompensator, GroundDisconnector,
            and Ground) which will be assumed to be N. Therefore, phase code ABCN is
            explicitly declared when needed, e.g. for star point grounding equipment.
            The phase code on terminals connecting the same ConnectivityNode or TopologicalNode
            as well as for equipment between two terminals shall be consistent.
            '''

        })
    '''
    Represents the normal network phasing condition. If the attribute is
    missing, three phases (ABC) shall be assumed, except for terminals
    of grounding classes (specializations of EarthFaultCompensator, GroundDisconnector,
    and Ground) which will be assumed to be N. Therefore, phase code ABCN
    is explicitly declared when needed, e.g. for star point grounding equipment.
    The phase code on terminals connecting the same ConnectivityNode or
    TopologicalNode as well as for equipment between two terminals shall
    be consistent.
    '''

    BoundedContainer: Optional[ResourceContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ResourceContainer.BoundaryTerminals',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Bushing: Optional[Bushing] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Bushing.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ConductingEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.Terminals',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The conducting equipment of the terminal. Conducting equipment have terminals
            that may be connected to other conducting equipment terminals via connectivity
            nodes or topological nodes.
            '''

        })
    '''
    The conducting equipment of the terminal. Conducting equipment have
    terminals that may be connected to other conducting equipment terminals
    via connectivity nodes or topological nodes.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.Terminals',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The connectivity node to which this terminal connects with zero impedance.
            '''

        })
    '''
    The connectivity node to which this terminal connects with zero impedance.
    '''

    HasFromTerminalSVSMO4: Optional[SVSMO4] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SVSMO4.FromTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SVSMO4 model that has this FromTerminal.
            '''

        })
    '''
    The SVSMO4 model that has this FromTerminal.
    '''

    HasToTerminalSVSMO4: Optional[SVSMO4] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SVSMO4.ToTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SVSMO4 model that has this ToTerminal.
            '''

        })
    '''
    The SVSMO4 model that has this ToTerminal.
    '''

    NormalHeadFeeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.NormalHeadTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The feeder that this terminal normally feeds. Only specified for the terminals
            at head of feeders.
            '''

        })
    '''
    The feeder that this terminal normally feeds. Only specified for the
    terminals at head of feeders.
    '''

    StateShortCircuitResult: Optional[StateShortCircuitResult] = field(
        default=None,
        metadata={
        'type': 'GB',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StateShortCircuitResult.Terminal',
        'namespace': 'http://GB/placeholder/ext#',
        'docstring':
            '''
            The short-circuit result for the terminal.
            '''

        })
    '''
    The short-circuit result for the terminal.
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The topological node associated with the terminal. This can be used as
            an alternative to the connectivity node path to topological node, thus
            making it unnecessary to model connectivity nodes in some cases. Note that
            the if connectivity nodes are in the model, this association would probably
            not be used as an input specification.
            '''

        })
    '''
    The topological node associated with the terminal. This can be used
    as an alternative to the connectivity node path to topological node,
    thus making it unnecessary to model connectivity nodes in some cases.
    Note that the if connectivity nodes are in the model, this association
    would probably not be used as an input specification.
    '''

    UsagePoint: Optional[UsagePoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'UsagePoint.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WeccREPCC: Optional[WeccREPCC] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WeccREPCC.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The WECC REPCC model that has frequency measured at this Terminal.
            '''

        })
    '''
    The WECC REPCC model that has frequency measured at this Terminal.
    '''

    WeccWTGIBFFRA: Optional[WeccWTGIBFFRA] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WeccWTGIBFFRA.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The WECC WTGIBFFRA model that has frequency measured at this Terminal.
            '''

        })
    '''
    The WECC WTGIBFFRA model that has frequency measured at this Terminal.
    '''

    WindPlantDynamics: Optional[WindPlantDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WindPlantDynamics.PointOfConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The wind plant that has point of connection.
            '''

        })
    '''
    The wind plant that has point of connection.
    '''
    
@dataclass(repr=False)
class Asset(IdentifiedObject):
    '''
    Tangible resource of the utility, including power system equipment, various
    end devices, cabinets, buildings, etc. For electrical network equipment,
    the role of the asset is defined through PowerSystemResource and its subclasses,
    defined mainly in the Wires model (refer to IEC61970-301 and model package
    IEC61970::Wires). Asset description places emphasis on the physical characteristics
    of the equipment fulfilling that role.
    '''

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Asset',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement related to this asset.
            '''

        })
    '''
    Measurement related to this asset.
    '''
    
@dataclass(repr=False)
class BatterySystem(Asset):
    '''
    '''

    cycleCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Number of completed charge cycles
            '''

        })
    '''
    Number of completed charge cycles
    '''

    stateOfHealth: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class Bushing(Asset):
    '''
    Bushing asset.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.Bushing',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Terminal to which this bushing is attached.
            '''

        })
    '''
    Terminal to which this bushing is attached.
    '''
    
@dataclass(repr=False)
class ChargingStation(Asset):
    '''
    Physical equipment consisting of one or more EV supply equipment managing
    the energy transfer to and from EVs. [IEC 63382-1]
    '''

    networkProvider: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    operatorName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    paymentMethods: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    phoneSupport: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    weatherProtection: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ChargingConnector: Optional[ChargingConnectorInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ChargingConnectorInfo.ChargingStation',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class Crossarm(Asset):
    '''
    Cross arm
    '''

    material: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Material
            '''

        })
    '''
    Material
    '''

    OverheadStructure: Optional[OverheadStructure] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OverheadStructure.Crossarm',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class DuctBank(Asset):
    '''
    A duct contains individual wires in the layout as specified with associated
    wire spacing instances; number of them gives the number of conductors in
    this duct.
    '''

    WireSpacingInfos: list[WireSpacingInfo] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireSpacingInfo.DuctBank',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class ElectricVehicle(Asset):
    '''
    An electric vehicle (EV) represents a mobile energy storage and load resource
    capable of connecting to the distribution system via an electric vehicle
    supply equipment (EVSE). The EV class captures essential identifying information,
    vehicle characteristics, and operational attributes relevant to grid integration.
    EVs may participate in grid-supporting functions such as controlled charging,
    smart charging, or bidirectional power flow (V2G) when supported. The model
    associates the vehicle with its physical and operational characteristics
    (make, model, year, battery, connectors) and its state of charge (SOC)
    dynamics.
    '''

    licensePlate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Vehicle�s registration/license plate number.
            '''

        })
    '''
    Vehicle�s registration/license plate number.
    '''

    vinNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class OverheadStructure(Asset):
    '''
    A structure is an element of an electric transmission or distribution system
    that supports the overhead conductors and associated equipment used for
    the transmission of electricity.
    '''

    Crossarm: list[Crossarm] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Crossarm.OverheadStructure',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Pole: list[Pole] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Pole.OverheadStructure',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class Pole(Asset):
    '''
    Pole asset.
    '''

    breastBlock: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if a block of material has been attached to base of pole in ground
            for stability. This technique is used primarily when anchors can not be
            used.
            '''

        })
    '''
    True if a block of material has been attached to base of pole in ground
    for stability. This technique is used primarily when anchors can not
    be used.
    '''

    classification: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Pole class: 1, 2, 3, 4, 5, 6, 7, H1, H2, Other, Unknown.
            '''

        })
    '''
    Pole class: 1, 2, 3, 4, 5, 6, 7, H1, H2, Other, Unknown.
    '''

    construction: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The framing structure mounted on the pole.
            '''

        })
    '''
    The framing structure mounted on the pole.
    '''

    jpaReference: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Joint pole agreement reference number.
            '''

        })
    '''
    Joint pole agreement reference number.
    '''

    speciesType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Pole species. Aluminum, Aluminum Davit, Concrete, Fiberglass, Galvanized
            Davit, Galvanized, Steel Davit Primed, Steel Davit, Steel Standard Primed,
            Steel, Truncated, Wood-Treated, Wood-Hard, Wood-Salt Treated, Wood-Soft,
            Wood, Other, Unknown.
            '''

        })
    '''
    Pole species. Aluminum, Aluminum Davit, Concrete, Fiberglass, Galvanized
    Davit, Galvanized, Steel Davit Primed, Steel Davit, Steel Standard
    Primed, Steel, Truncated, Wood-Treated, Wood-Hard, Wood-Salt Treated,
    Wood-Soft, Wood, Other, Unknown.
    '''

    treatedDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Date and time pole was last treated with preservative.
            '''

        })
    '''
    Date and time pole was last treated with preservative.
    '''

    baseKind: Optional[ PoleBaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of base for this pole.
            '''

        })
    '''
    Kind of base for this pole.
    '''

    diameter: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Diameter of the pole.
            '''

        })
    '''
    Diameter of the pole.
    '''

    length: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Length of the pole (inclusive of any section of the pole that may be underground
            post-installation).
            '''

        })
    '''
    Length of the pole (inclusive of any section of the pole that may be
    underground post-installation).
    '''

    preservativeKind: Optional[ PolePreservativeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of preservative for this pole.
            '''

        })
    '''
    Kind of preservative for this pole.
    '''

    treatmentKind: Optional[ PoleTreatmentKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of treatment for this pole.
            '''

        })
    '''
    Kind of treatment for this pole.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.Poles',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    OverheadStructure: Optional[OverheadStructure] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OverheadStructure.Pole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class AssetInfo(IdentifiedObject):
    '''
    Set of attributes of an asset, representing typical datasheet information
    of a physical device that can be instantiated and shared in different data
    exchange contexts:
    - as attributes of an asset instance (installed or in stock)
    - as attributes of an asset model (product by a manufacturer)
    - as attributes of a type asset (generic type of an asset as used in designs/extension
    planning).
    '''

    AssetRequirement: Optional[AssetRequirement] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetRequirement.AssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    ChildAssetInfoComponent: Optional[AssetInfoComponent] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CatalogAssetType.AssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asset information (nameplate) for this catalog asset type.
            '''

        })
    '''
    Asset information (nameplate) for this catalog asset type.
    '''
    
    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfoComponent.ParentAssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    AssetRequirement: Optional[AssetRequirement] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfoComponent.ChildAssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    CatalogAssetType: Optional[CatalogAssetType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ProductAssetModel.AssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Product asset model which conforms to this catalog asset type.
            '''

        })
    '''
    Product asset model which conforms to this catalog asset type.
    '''
    
    ChildAssetInfoComponent: Optional[AssetInfoComponent] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfoComponent.ChildAssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    ParentAssetInfoComponent: Optional[AssetInfoComponent] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfoComponent.ParentAssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    ProductAssetModel: Optional[ProductAssetModel] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.AssetDatasheet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All power system resources with this datasheet information.
            '''

        })
    '''
    All power system resources with this datasheet information.
    '''
    
@dataclass(repr=False)
class CapacitorBankInfo(AssetInfo):
    '''
    Capacitor bank asset information
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'AssetInfoEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ChargingConnectorInfo(AssetInfo):
    '''
    Datasheet for charging connectors used within a charging station and electric
    vehicles
    '''

    ChargingStation: list[ChargingStation] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ChargingStation.ChargingConnector',
        'namespace': 'http://epri.com/GridAPPSD#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    hasLockingMechanism: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Whether the connector supports a locking mechanism to prevent accidental
            removal
            '''

        })
    '''
    Whether the connector supports a locking mechanism to prevent accidental
    removal
    '''

    connectorType: Optional[ ConnectorTypeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Type of connector (e.g., CCS, CHAdeMO, Type 2).
            '''

        })
    '''
    Type of connector (e.g., CCS, CHAdeMO, Type 2).
    '''
    
@dataclass(repr=False)
class ConductingAssetInfo(AssetInfo):
    '''
    Generic information for conducting asset
    '''

    ShortCircuitRespone: list[ShortCircuitResponse] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ChargingStation.ChargingConnector',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    phaseCount: Optional[ PhaseCountKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of phases
            '''

        })
    '''
    Number of phases
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated current.
            '''

        })
    '''
    Rated current.
    '''

    ratedFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated frequency such as 50Hz or 60Hz
            '''

        })
    '''
    Rated frequency such as 50Hz or 60Hz
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage.
            '''

        })
    '''
    Rated voltage.
    '''
    
@dataclass(repr=False)
class BundledCableInfo(ConductingAssetInfo):
    '''
    Bundling two or more conductors, at most one bare wire.
    '''

    additionalConductorCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Additional conductor count
            '''

        })
    '''
    Additional conductor count
    '''

    hasNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if neutral
            '''

        })
    '''
    True if neutral
    '''

    insulatedNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if neutral wire is insulated
            '''

        })
    '''
    True if neutral wire is insulated
    '''

    neutralSizeDescription: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral wire size description
            '''

        })
    '''
    Neutral wire size description
    '''

    neutralStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral wire strand count
            '''

        })
    '''
    Neutral wire strand count
    '''

    neutralStrandRDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral strand DC resistance per unit length of the conductor at 20 &#176;C
            '''

        })
    '''
    Neutral strand DC resistance per unit length of the conductor at 20
    &#176;C
    '''
    
@dataclass(repr=False)
class BusbarSectionInfo(ConductingAssetInfo):
    '''
    Busbar section data.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BushingInfo(ConductingAssetInfo):
    '''
    Bushing datasheet information.
    '''

    c1Capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Factory measured capacitance, measured between the power factor tap and
            the bushing conductor.
            '''

        })
    '''
    Factory measured capacitance, measured between the power factor tap
    and the bushing conductor.
    '''

    c1PowerFactor: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Factory measured insulation power factor, measured between the power factor
            tap and the bushing conductor.
            '''

        })
    '''
    Factory measured insulation power factor, measured between the power
    factor tap and the bushing conductor.
    '''

    c2Capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Factory measured capacitance measured between the power factor tap and
            ground.
            '''

        })
    '''
    Factory measured capacitance measured between the power factor tap
    and ground.
    '''

    c2PowerFactor: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Factory measured insulation power factor, measured between the power factor
            tap and ground.
            '''

        })
    '''
    Factory measured insulation power factor, measured between the power
    factor tap and ground.
    '''

    insulationKind: Optional[ BushingInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of insulation.
            '''

        })
    '''
    Kind of insulation.
    '''

    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
            '''

        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''

    ratedLineToGroundVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated line-to-ground voltage. Also referred to as Uy on bushing nameplate.
            '''

        })
    '''
    Rated line-to-ground voltage. Also referred to as Uy on bushing nameplate.
    '''
    
@dataclass(repr=False)
class CapacitorCanInfo(ConductingAssetInfo):
    '''
    A CapacitorCan info class is used to store asset info data for the small
    2.4 - 25 KV capacitor units which make up a capacitor bank. These cans
    are connected in series to equal the energized voltage and connected in
    parallel groups to create the desired Mvar ratings.
    '''

    dielectricFluidType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of dielectric fluid used for the capacitors (ex. WEMCOL, DPO, AROCLOR,
            etc.).
            '''

        })
    '''
    Type of dielectric fluid used for the capacitors (ex. WEMCOL, DPO,
    AROCLOR, etc.).
    '''

    dielectricFluidVolume: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Volume of dielectric fluid (oil) in litres.
            '''

        })
    '''
    Volume of dielectric fluid (oil) in litres.
    '''

    ratedCapacitance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The factory rating of the capacitor cans in uF (Farads). All the capacitors
            in a capacitor bank have more or less equal capacitance coming out of factory.
            '''

        })
    '''
    The factory rating of the capacitor cans in uF (Farads). All the capacitors
    in a capacitor bank have more or less equal capacitance coming out
    of factory.
    '''

    ratedReactiveRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reactive power rating of the capacitor cans in KVAR at the can rated
            voltage.
            '''

        })
    '''
    The reactive power rating of the capacitor cans in KVAR at the can
    rated voltage.
    '''

    weight: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total weight of one capacitor can (i.e., 20kG).
            '''

        })
    '''
    Total weight of one capacitor can (i.e., 20kG).
    '''

    dischargeResistorType: Optional[ DischargeResistorKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            discharge resister installed, what type is it? (i.e. internal, external
            or not installed)
            '''

        })
    '''
    discharge resister installed, what type is it? (i.e. internal, external
    or not installed)
    '''

    fusingType: Optional[ CapacitorCanFusingKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of fusing used (i.e. internal or external). Fuses may be included
            inside the can or attached to the external terminal of the can.
            '''

        })
    '''
    The type of fusing used (i.e. internal or external). Fuses may be included
    inside the can or attached to the external terminal of the can.
    '''

    terminalConnectionType: Optional[ TerminalConnectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminal connection of the capacitor cans (i.e. single bushing double
            bushing or triple bushing).
            '''

        })
    '''
    The terminal connection of the capacitor cans (i.e. single bushing
    double bushing or triple bushing).
    '''
    
@dataclass(repr=False)
class CompensatorInfo(ConductingAssetInfo):
    '''
    Data sheet for compensation devices which can be used in a shunt or series
    application.
    Compensator can be specialized to Capacitor or Reactor.
    '''

    maxPowerLoss: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum allowed apparent power loss.
            '''

        })
    '''
    Maximum allowed apparent power loss.
    '''

    ratedReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive Power produced by the bank at rated voltage
            '''

        })
    '''
    Reactive Power produced by the bank at rated voltage
    '''
    
@dataclass(repr=False)
class CapacitorInfo(CompensatorInfo):
    '''
    Common properties of capacitor asset which can be used in a shunt or series
    application.
    Also named as capacitor bank by IEC 60050
    '''

    maxAmbientTempRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum Operating ambient temperature (i.e., +85 DEG C).
            '''

        })
    '''
    Maximum Operating ambient temperature (i.e., +85 DEG C).
    '''

    minAmbientTempRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum Operating ambient temperature (i.e., -40 DEG C).
            '''

        })
    '''
    Minimum Operating ambient temperature (i.e., -40 DEG C).
    '''

    numberOfCansPerPhase: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total number of cans per phase in the capacitor bank
            '''

        })
    '''
    Total number of cans per phase in the capacitor bank
    '''

    parallelUnitsPerPhase: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Per phase how many elements are connected in parallel units per series
            group.
            '''

        })
    '''
    Per phase how many elements are connected in parallel units per series
    group.
    '''

    seriesGroupsPerPhase: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Per phase how many series groups (or sections) in the capacitor unit are
            connected.
            '''

        })
    '''
    Per phase how many series groups (or sections) in the capacitor unit
    are connected.
    '''

    capacitorRackType: Optional[ CapacitorRackKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rack type used (ie. Enclosed Rack or Open Rack).
            '''

        })
    '''
    Rack type used (ie. Enclosed Rack or Open Rack).
    '''

    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Basic Insulation Level voltage in kilovolts (lightening impulse withstand
            voltage).
            '''

        })
    '''
    Basic Insulation Level voltage in kilovolts (lightening impulse withstand
    voltage).
    '''
    
@dataclass(repr=False)
class SeriesCapacitorInfo(CapacitorInfo):
    '''
    Class for specializing CapacitorInfo when used as in a series application.
    This specialization does not require any attributes.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ShuntCapacitorInfo(CapacitorInfo):
    '''
    Class for specializing CapacitorInfo when used as in a shunt application
    and adding attributes for this specialization.
    '''

    connectionKind: Optional[ CompensatorConnectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Connection type of the capacitor bank (i.e. wye, grounded wye or delta).
            '''

        })
    '''
    Connection type of the capacitor bank (i.e. wye, grounded wye or delta).
    '''
    
@dataclass(repr=False)
class FACTSInfo(CompensatorInfo):
    '''
    Flexible alternating current transmission system
    High speed reactive compensation device
    '''

    appliedHarmonicFiltering: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Description of the harmonic filtering applied in the FACTS (5th order,
            7th order, etc.) There may be multiple harmonics which are filtered
            '''

        })
    '''
    Description of the harmonic filtering applied in the FACTS (5th order,
    7th order, etc.) There may be multiple harmonics which are filtered
    '''

    coolingType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The cooling type of the FACTS Device Thyristors
            ex. Air Cooled, Water Cooled
            '''

        })
    '''
    The cooling type of the FACTS Device Thyristors
    ex. Air Cooled, Water Cooled
    '''

    capacitorHarmonicFilterRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total Capacitor Harmonic Filter Rating in Reactance (imaginary part of
            impedance), at rated frequency provided in the applied harmonic filtering
            '''

        })
    '''
    Total Capacitor Harmonic Filter Rating in Reactance (imaginary part
    of impedance), at rated frequency provided in the applied harmonic
    filtering
    '''

    maxCapacitiveReactance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Capacitive Reactance - Maximum Capacitive reactive impedance the FACTS
            can supply
            '''

        })
    '''
    Capacitive Reactance - Maximum Capacitive reactive impedance the FACTS
    can supply
    '''

    maxInductiveReactance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive Reactance - Maximum inductive reactive impedance the FACTS can
            supply
            '''

        })
    '''
    Reactive Reactance - Maximum inductive reactive impedance the FACTS
    can supply
    '''

    maxMechanicalSwitchedCapacitance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total capacitor's reactive impedance of mechanically switched Capacitors
            under the control of the FACTS. Capacitors may be switched by breakers
            or circuit switchers.
            '''

        })
    '''
    Total capacitor's reactive impedance of mechanically switched Capacitors
    under the control of the FACTS. Capacitors may be switched by breakers
    or circuit switchers.
    '''

    maxMechanicalSwitchedReactance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total inductor's reactive impedance of mechanically switched Reactors under
            the control of the FACTS. Reactors may be switched by breakers or circuit
            switchers.
            '''

        })
    '''
    Total inductor's reactive impedance of mechanically switched Reactors
    under the control of the FACTS. Reactors may be switched by breakers
    or circuit switchers.
    '''

    nomU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated Voltage for the shunt capacitors and reactors in the FACTS device.
            '''

        })
    '''
    Rated Voltage for the shunt capacitors and reactors in the FACTS device.
    '''

    reactorHarmonicFilterRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total Reactor Harmonic Filter Rating in Reactance (imaginary part of impedance),
            at rated frequency provided in the applied harmonic filtering.
            '''

        })
    '''
    Total Reactor Harmonic Filter Rating in Reactance (imaginary part of
    impedance), at rated frequency provided in the applied harmonic filtering.
    '''
    
@dataclass(repr=False)
class SVCInfo(FACTSInfo):
    '''
    Static Var Compensator - High speed switched reactor and capacitor.
    '''

    svcReactiveControlType: Optional[ SVCReactiveControlKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An SVC can either be set to control the voltage of a bus or provide contant
            Mvar to the bus.
            '''

        })
    '''
    An SVC can either be set to control the voltage of a bus or provide
    contant Mvar to the bus.
    '''

    tcrRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rating in reactance if the Static Var Compensator has a Thyristor Switched
            Reactor
            '''

        })
    '''
    Rating in reactance if the Static Var Compensator has a Thyristor Switched
    Reactor
    '''

    tscRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rating in reactance if the Static Var Compensator has a Thyristor Switched
            Capacitor
            '''

        })
    '''
    Rating in reactance if the Static Var Compensator has a Thyristor Switched
    Capacitor
    '''
    
@dataclass(repr=False)
class SelfSaturatedReactorInfo(SVCInfo):
    '''
    Inductor made up of a transformer like core. The secondary winding is driven
    by a DC source to saturate the AC winding.
    Shunt Capacitor in addition to saturated inductor provide Mvars to increase
    and decrease voltage.
    This is pretty old technology.
    '''

    fixedSeriesCapacitance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Slope correcting capacitor rating in reactance which is connected in series
            with the self saturated reactor.
            '''

        })
    '''
    Slope correcting capacitor rating in reactance which is connected in
    series with the self saturated reactor.
    '''

    fixedShuntCapacitance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Shunt connected capacitors rating in reactance which are used to provide
            negative reactance for voltage support.
            '''

        })
    '''
    Shunt connected capacitors rating in reactance which are used to provide
    negative reactance for voltage support.
    '''
    
@dataclass(repr=False)
class StatComInfo(FACTSInfo):
    '''
    StatCom - Static Synchronous Compensator High speed continuous reactor
    and capacitor.
    '''

    activePowerSourceType: Optional[ ActivePowerSourceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Enumeration used to designate the type of Active power source used by the
            STATCOM.
            '''

        })
    '''
    Enumeration used to designate the type of Active power source used
    by the STATCOM.
    '''

    dcConverterType: Optional[ STATCOMKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type DC to AC converter unit providing the AC compensation
            '''

        })
    '''
    The type DC to AC converter unit providing the AC compensation
    '''

    maxNegativeMW: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If an active power source is available in the STATCOM, the Maximum MW that
            the STATCOM can absorb from the grid
            '''

        })
    '''
    If an active power source is available in the STATCOM, the Maximum
    MW that the STATCOM can absorb from the grid
    '''

    maxPositiveMW: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If an active power source is available in the STATCOM, the Maximum MW that
            the STATCOM can provide to the grid
            '''

        })
    '''
    If an active power source is available in the STATCOM, the Maximum
    MW that the STATCOM can provide to the grid
    '''

    powerElectronicsGateType: Optional[ PowerElectronicsGateKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of electronics used for the series gates.
            '''

        })
    '''
    Type of electronics used for the series gates.
    '''
    
@dataclass(repr=False)
class ReactorInfo(CompensatorInfo):
    '''
    Common properties of reactor asset which can be used in a shunt or series
    application. Reactors may be dry type or oil filled.
    '''

    coreCoilsWeight: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Weight of the core and coils of the device in kilograms.
            '''

        })
    '''
    Weight of the core and coils of the device in kilograms.
    '''

    oilType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type or designation of oil used for the dielectric medium (ex. VoltEsso,
            Nynas, Luminol, etc.).
            '''

        })
    '''
    Type or designation of oil used for the dielectric medium (ex. VoltEsso,
    Nynas, Luminol, etc.).
    '''

    oilWeight: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Weight of all the oil in the device in kilograms.
            '''

        })
    '''
    Weight of all the oil in the device in kilograms.
    '''

    ratedInductance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Inductance of device in mH - Milli-Henry.
            '''

        })
    '''
    Inductance of device in mH - Milli-Henry.
    '''

    ratedMechanicalCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The amount of current that creates the maximum allowable force in the conductor
            of a reactor.
            '''

        })
    '''
    The amount of current that creates the maximum allowable force in the
    conductor of a reactor.
    '''

    ratedThermalCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'NeedsWork Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum current the device can withstand for a period of one second.
            '''

        })
    '''
    Maximum current the device can withstand for a period of one second.
    '''

    tankAndFittingsWeight: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Weight of the tanks and fittings of the device in kilograms.
            '''

        })
    '''
    Weight of the tanks and fittings of the device in kilograms.
    '''

    temperatureClass: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Insulation class based on temperature (ie: Y, A, E, B, F, N, H, C).
            '''

        })
    '''
    Insulation class based on temperature (ie: Y, A, E, B, F, N, H, C).
    '''

    temperatureRise: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Temperature rise of equipment over ambient in degrees Celsius.
            '''

        })
    '''
    Temperature rise of equipment over ambient in degrees Celsius.
    '''

    volumeOfOil: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Volume of oil in litres.
            '''

        })
    '''
    Volume of oil in litres.
    '''

    circulationAndCoolingType: Optional[ CirculationAndCoolingKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The method used to cool the shunt reactor, O: oil; A: air; N: natural;
            F: forced (ie: ON, ONAN, ONAF or OFAF).
            '''

        })
    '''
    The method used to cool the shunt reactor, O: oil; A: air; N: natural;
    F: forced (ie: ON, ONAN, ONAF or OFAF).
    '''

    coreType: Optional[ ReactorCoreKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of core of the reactor. Example Air, steel, concrete
            '''

        })
    '''
    The type of core of the reactor. Example Air, steel, concrete
    '''

    insulationMedium: Optional[ ReactorInsulationMediumKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This property denotes whether the reactor is air or oil.
            '''

        })
    '''
    This property denotes whether the reactor is air or oil.
    '''

    oilPreservationType: Optional[ OilPreservationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of oil preservation.
            '''

        })
    '''
    Kind of oil preservation.
    '''

    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Basic Insulation Level voltage in kilovolts (lightening impulse withstand
            voltage).
            '''

        })
    '''
    Basic Insulation Level voltage in kilovolts (lightening impulse withstand
    voltage).
    '''
    
@dataclass(repr=False)
class SeriesReactorInfo(ReactorInfo):
    '''
    Class for specializing ReactorInfo when used as in a series application.
    This specialization does not require any attributes.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ShuntReactorInfo(ReactorInfo):
    '''
    Class for specializing ReactorInfo when used as in a shunt application
    and adding attributes for this specialization.
    '''

    TapChangerInfo: Optional[TapChangerInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChangerInfo.ShuntReactorInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class CompositeSwitchInfo(ConductingAssetInfo):
    '''
    Properties of a composite switch.
    '''

    ganged: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if multi-phase switch controls all phases concurrently.
            '''

        })
    '''
    True if multi-phase switch controls all phases concurrently.
    '''

    initOpMode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Initial operating mode, with the following values: Automatic, Manual.
            '''

        })
    '''
    Initial operating mode, with the following values: Automatic, Manual.
    '''

    phaseCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Supported number of phases, typically 0, 1 or 3.
            '''

        })
    '''
    Supported number of phases, typically 0, 1 or 3.
    '''

    remote: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if device is capable of being operated by remote control.
            '''

        })
    '''
    True if device is capable of being operated by remote control.
    '''

    switchStateCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of switch states represented by the composite switch.
            '''

        })
    '''
    Number of switch states represented by the composite switch.
    '''

    interruptingRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Breaking capacity, or short circuit rating, is the maximum rated current
            which the device can safely interrupt at the rated voltage.
            '''

        })
    '''
    Breaking capacity, or short circuit rating, is the maximum rated current
    which the device can safely interrupt at the rated voltage.
    '''

    kind: Optional[ CompositeSwitchKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of composite switch.
            '''

        })
    '''
    Kind of composite switch.
    '''

    phaseCode: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phases carried, if applicable.
            '''

        })
    '''
    Phases carried, if applicable.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage.
            '''

        })
    '''
    Rated voltage.
    '''
    
@dataclass(repr=False)
class ConductorInfo(ConductingAssetInfo):
    '''
    Common class for rigid and flexible conductors.
    [IEC 826-14-06]: Conductive part intended to carry a specified electric
    current
    '''

    purpose: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase, neutral, lighting, or something else
            '''

        })
    '''
    Phase, neutral, lighting, or something else
    '''

    crossSection: Optional[ float | Area ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Area of conducting material cross section
            '''

        })
    '''
    Area of conducting material cross section
    '''

    massPerLength: Optional[ float | MassPerLength ] = field(
        default=None,
        metadata={
        'type': 'NeedsWork Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Area of conducting material cross section
            '''

        })
    '''
    Area of conducting material cross section
    '''

    material: Optional[ WireMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conductor material.
            '''

        })
    '''
    Conductor material.
    '''

    rAC25: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 25 �C.
            '''

        })
    '''
    AC resistance per unit length of the conductor at 25 �C.
    '''

    rAC50: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 50 �C.
            '''

        })
    '''
    AC resistance per unit length of the conductor at 50 �C.
    '''

    rAC75: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 75 �C.
            '''

        })
    '''
    AC resistance per unit length of the conductor at 75 �C.
    '''

    rDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC resistance per unit length of the conductor at 20 �C.
            '''

        })
    '''
    DC resistance per unit length of the conductor at 20 �C.
    '''
    
@dataclass(repr=False)
class RigidBusbarInfo(ConductorInfo):
    '''
    Rigid busbar information.
    <u>Definition</u>
    [IEC 605-02-21]: A substation busbar which is made up with metallic tubes
    or bars and which is supported by insulator posts
    https://www.electropedia.org/iev/iev.nsf/display?openform&amp;ievref=605-02-21
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AngleBusbarInfo(RigidBusbarInfo):
    '''
    L-shape bar with both legs of uniform thickness and same width
    '''

    crossSectionWidth: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cross section width of the conductor
            '''

        })
    '''
    Cross section width of the conductor
    '''

    thickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Thickness of the angle bus bar
            '''

        })
    '''
    Thickness of the angle bus bar
    '''
    
@dataclass(repr=False)
class BarBusbarInfo(RigidBusbarInfo):
    '''
    One rectangular slab with uniform thickness and width
    '''

    crossSectionWidth: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cross section width of the conductor
            '''

        })
    '''
    Cross section width of the conductor
    '''

    thickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Thickness of bar busbar
            '''

        })
    '''
    Thickness of bar busbar
    '''
    
@dataclass(repr=False)
class IntegralWebBusbarInfo(RigidBusbarInfo):
    '''
    I-beam type of conductor with the outer edges, turned into each other.
    '''

    crossSectionHeight: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cross section width of the conductor
            '''

        })
    '''
    Cross section width of the conductor
    '''

    crossSectionWidth: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cross section width of the conductor
            '''

        })
    '''
    Cross section width of the conductor
    '''

    thickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Thickness
            '''

        })
    '''
    Thickness
    '''
    
@dataclass(repr=False)
class TubeBusbarInfo(RigidBusbarInfo):
    '''
    Tube busbar information
    '''

    outerDiameter: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Outer diameter
            '''

        })
    '''
    Outer diameter
    '''

    wallThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Wall thickness
            '''

        })
    '''
    Wall thickness
    '''
    
@dataclass(repr=False)
class PipeBusbarInfo(TubeBusbarInfo):
    '''
    Pipe busbar information
    '''

    pipeType: Optional[ PipeBusbarKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            For cylindrical hollow rigid conductor only. Rigid cylindrical conductor
            comes in two types. Pipe Type cylindrical bus is based around schedule
            types such as Schedule 40 and schedule 80. The wall thickness is determined
            by the schedule number. Currently schedule 40 and schedule 80 are commonly
            used.
            '''

        })
    '''
    For cylindrical hollow rigid conductor only. Rigid cylindrical conductor
    comes in two types. Pipe Type cylindrical bus is based around schedule
    types such as Schedule 40 and schedule 80. The wall thickness is determined
    by the schedule number. Currently schedule 40 and schedule 80 are commonly
    used.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class WireInfo(ConductorInfo):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    ACLineSegmentPhase: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.WireInfo',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WireBundleInfo: list[WireBundleInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireBundleInfo.WireInfo',
        'namespace': 'http://epri.com/GridAPPSD#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireInfo',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Wire phase information associated with this wire information.
            '''
        
        })
    '''
    Wire phase information associated with this wire information.
    '''
    
    coreStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if used) Number of strands in the steel core.
            '''

        })
    '''
    (if used) Number of strands in the steel core.
    '''

    insulated: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if conductor is insulated.
            '''

        })
    '''
    True if conductor is insulated.
    '''

    sizeDescription: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
            '''

        })
    '''
    Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
    '''

    strandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of strands in the conductor.
            '''

        })
    '''
    Number of strands in the conductor.
    '''

    constructionKind: Optional[ WireMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    coreRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if there is a different core material) Radius of the central core.
            '''

        })
    '''
    (if there is a different core material) Radius of the central core.
    '''

    coreStrandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    gmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Geometric mean radius. If we replace the conductor by a thin walled tube
            of radius GMR, then its reactance is identical to the reactance of the
            actual conductor.
            '''

        })
    '''
    Geometric mean radius. If we replace the conductor by a thin walled
    tube of radius GMR, then its reactance is identical to the reactance
    of the actual conductor.
    '''

    insulationMaterial: Optional[ WireInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if insulated conductor) Material used for insulation.
            '''

        })
    '''
    (if insulated conductor) Material used for insulation.
    '''

    insulationThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if insulated conductor) Thickness of the insulation.
            '''

        })
    '''
    (if insulated conductor) Thickness of the insulation.
    '''

    radius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Outside radius of the wire.
            '''

        })
    '''
    Outside radius of the wire.
    '''

    ratedStrength: Optional[ float | Force ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    strandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class BareWireInfo(WireInfo):
    '''
    Bare wire data.
    '''

    wireConstructionKind: Optional[ WireConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireBundleInfo.WireInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    Kind of wire construction
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class BareWireInfo(WireInfo):
    '''
    Bare wire data.
    '''

    wireConstructionKind: Optional[ WireConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of wire construction
            '''

        })
    '''
    Kind of wire construction
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class CableInfo(WireInfo):
    '''
    Cable data.
    '''

    isStrandFill: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if wire strands are extruded in a way to fill the voids in the cable.
            '''

        })
    '''
    True if wire strands are extruded in a way to fill the voids in the
    cable.
    '''

    sheathAsNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if sheath / shield is used as a neutral (i.e., bonded).
            '''

        })
    '''
    True if sheath / shield is used as a neutral (i.e., bonded).
    '''

    constructionKind: Optional[ CableConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of construction of this cable.
            '''

        })
    '''
    Kind of construction of this cable.
    '''

    diameterOverCore: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Diameter over the core, including any semi-con screen; should be the insulating
            layer's inside diameter.
            '''

        })
    '''
    Diameter over the core, including any semi-con screen; should be the
    insulating layer's inside diameter.
    '''

    diameterOverInsulation: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Diameter over the insulating layer, excluding outer screen.
            '''

        })
    '''
    Diameter over the insulating layer, excluding outer screen.
    '''

    diameterOverJacket: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Diameter over the outermost jacketing layer.
            '''

        })
    '''
    Diameter over the outermost jacketing layer.
    '''

    diameterOverScreen: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Diameter over the outer screen; should be the shield's inside diameter.
            '''

        })
    '''
    Diameter over the outer screen; should be the shield's inside diameter.
    '''

    nominalTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum nominal design operating temperature.
            '''

        })
    '''
    Maximum nominal design operating temperature.
    '''

    outerJacketKind: Optional[ CableOuterJacketKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of outer jacket of this cable.
            '''

        })
    '''
    Kind of outer jacket of this cable.
    '''

    shieldMaterial: Optional[ CableShieldMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Material of the shield.
            '''

        })
    '''
    Material of the shield.
    '''
    
    InsulationInfo: Optional[InsulationInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InsulationInfo.CableInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''

    InsulationInfo: Optional[InsulationInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InsulationInfo.CableInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class ConcentricNeutralCableInfo(CableInfo):
    '''
    Concentric neutral cable data.
    '''

    neutralStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of concentric neutral strands.
            '''

        })
    '''
    Number of concentric neutral strands.
    '''

    diameterOverNeutral: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Diameter over the concentric neutral strands.
            '''

        })
    '''
    Diameter over the concentric neutral strands.
    '''

    neutralStrandGmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Geometric mean radius of the neutral strand.
            '''

        })
    '''
    Geometric mean radius of the neutral strand.
    '''

    neutralStrandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Outside radius of the neutral strand.
            '''

        })
    '''
    Outside radius of the neutral strand.
    '''

    neutralStrandRDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC resistance per unit length of the neutral strand at 20 �C.
            '''

        })
    '''
    DC resistance per unit length of the neutral strand at 20 �C.
    '''
    
@dataclass(repr=False)
class MultiCoreCableInfo(CableInfo):
    '''
    Multi core cable information
    '''

    hasNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if neutral is included
            '''

        })
    '''
    True if neutral is included
    '''

    neutralSizeDescription: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral wire size description
            '''

        })
    '''
    Neutral wire size description
    '''

    neutralStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral wire strand count
            '''

        })
    '''
    Neutral wire strand count
    '''

    phaseCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase count
            '''

        })
    '''
    Phase count
    '''

    neutralStrandRDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral strand DC resistance per unit length of the conductor at 20 &#176;C
            '''

        })
    '''
    Neutral strand DC resistance per unit length of the conductor at 20
    &#176;C
    '''
    
@dataclass(repr=False)
class TapeShieldCableInfo(CableInfo):
    '''
    Tape shield cable data.
    '''

    tapeLap: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Percentage of the tape shield width that overlaps in each wrap, typically
            10% to 25%.
            '''

        })
    '''
    Percentage of the tape shield width that overlaps in each wrap, typically
    10% to 25%.
    '''

    tapeThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Thickness of the tape shield, before wrapping.
            '''

        })
    '''
    Thickness of the tape shield, before wrapping.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class OverheadWireInfo(WireInfo):
    '''
    Overhead wire data.
    '''

    wireConstructionKind: Optional[ WireConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute add',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class GridEdgeDeviceInfo(ConductingAssetInfo):
    '''
    A Grid Edge Device is any device that is connected to the power grid with
    the ability to produce, store, and/or variably consume electricity. This
    include devices like local generation (solar photovoltaic and wind), storage
    (chemical or electrical batteries), flexible loads (heading, cooling, lighting
    systems), and electric vehicles (essentially a combination of storage and
    flexible load)
    '''

    apparentPowerMaximum: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Apparent power maximum rating</i>
            <i>
            </i>Maximum apparent power rating in voltamperes
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Apparent power maximum rating</i>
    <i>
    </i>Maximum apparent power rating in voltamperes
    '''

    ratedVoltageMax: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>AC voltage maximum rating</i>
            Maximum AC voltage rating in RMS volts
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>AC voltage maximum rating</i>
    Maximum AC voltage rating in RMS volts
    '''

    ratedVoltageMin: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>AC voltage minimum rating</i>
            Minimum AC voltage rating in RMS volts
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>AC voltage minimum rating</i>
    Minimum AC voltage rating in RMS volts
    '''
    
@dataclass(repr=False)
class BatteryInfo(GridEdgeDeviceInfo):
    '''
    '''

    cellChemistry: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    cellChemistry: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    numberOfCells: Optional[int] = field(
        default=None,
        metadata={
        'type': 'enumeration GridAPPSD Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    batteryType: Optional[ BatteryTypeKind ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    ratedCapacity: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ElectricVehicleInfo.BatteryInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class InverterInfo(GridEdgeDeviceInfo):
    '''
    Inverter-based devices are a type of Grid Edge Device which convert DC
    sources (and/or sinks) into AC sources (and/or sinks) allowing for the
    power to be synchronized to the grid.
    '''

    operatingCategoryAbnormal: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Abnormal operating performance category</i>
            Indication of voltage and frequency ride-through capability
            Values = Category I, Category II, Category III
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Abnormal operating performance category</i>
    Indication of voltage and frequency ride-through capability
    Values = Category I, Category II, Category III
    '''

    operatingCategoryNormal: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Normal operating performance category</i>
            Indication of reactive power and voltage/power control capability.
            Values = Category A, Category B
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Normal operating performance category</i>
    Indication of reactive power and voltage/power control capability.
    Values = Category A, Category B
    '''

    powerFactorOverExcited: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Specified over-excited power factor</i>
            Over-excited power factor
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Specified over-excited power factor</i>
    Over-excited power factor
    '''

    powerFactorUnderExcited: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Specified under-excited power factor</i>
            Under-excited power factor
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Specified under-excited power factor</i>
    Under-excited power factor
    '''

    activePowerRatingOverExcited: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Active power rating at specified over-excited power factor</i>
            Active power rating in watts at specified over-excited power factor
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Active power rating at specified over-excited power factor</i>
    Active power rating in watts at specified over-excited power factor
    '''

    activePowerRatingUnderExcited: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Active power rating at specified under-excited power factor</i>
            Active power rating in watts at specified under-excited power factor
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Active power rating at specified under-excited power factor</i>
    Active power rating in watts at specified under-excited power factor
    '''

    activePowerRatingUnityPowerFactor: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Active power rating at unity power factor (nameplate active power rating)</i>
            Active power rating in watts at unity power factor
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Active power rating at unity power factor (nameplate active power
    rating)</i>
    Active power rating in watts at unity power factor
    '''

    reactivePowerAbsorbedMax: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Reactive power absorbed maximum rating</i>
            Maximum absorbed reactive power rating in vars
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Reactive power absorbed maximum rating</i>
    Maximum absorbed reactive power rating in vars
    '''

    reactivePowerInjectedMax: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Reactive power injected maximum rating</i>
            Maximum injected reactive power rating in vars
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Reactive power injected maximum rating</i>
    Maximum injected reactive power rating in vars
    '''

    susceptanceOffline: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Reactive susceptance that remains connected to the Area EPS in the cease
            to energize and trip state</i>
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Reactive susceptance that remains connected to the Area EPS in the
    cease to energize and trip state</i>
    '''

    InverterCapabilites: Optional[InverterCapabilities] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InverterCapabilities.IntervalInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class GenerationInverterInfo(InverterInfo):
    '''
    A Generation Inverter is an inverter backed by a source that is capable
    of generating electricity from an external source such as solar radiation,
    wind, or other fuels.
    '''

    generationCategory: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of Distribution Generation.
            Examples include:
            <ul>
            <li>Photovoltaic (PV)</li>
            <li>Combined Heat Power (CHP)</li>
            <li>Fuel Cells</li>
            <li>Small Wind Power</li>
            </ul>
            '''

        })
    '''
    Type of Distribution Generation.
    Examples include:
    <ul>
    <li>Photovoltaic (PV)</li>
    <li>Combined Heat Power (CHP)</li>
    <li>Fuel Cells</li>
    <li>Small Wind Power</li>
    </ul>
    '''
    
@dataclass(repr=False)
class StorageInverterInfo(InverterInfo):
    '''
    A Storage Inverter is an inverter backed by a device that is capable of
    storing and later discharging electric energy.
    '''

    storageCategory: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of Distribution Storage.
            Examples include:
            <ul>
            <li>Lead�Acid Battery</li>
            <li>Nickel�Cadmium (NiCd) Battery</li>
            <li>Nickel�Metal Hydride (NiMH) Battery</li>
            <li>Lithium-Ion Battery</li>
            <li>Lithium-Ion Polymer (LiPo) Battery</li>
            <li>Aluminum-Sulfur Battery</li>
            <li>Flow Battery</li>
            <li>Mechanical Flywheel</li>
            <li>Mechanical Gravitational</li>
            </ul>
            '''

        })
    '''
    Type of Distribution Storage.
    Examples include:
    <ul>
    <li>Lead�Acid Battery</li>
    <li>Nickel�Cadmium (NiCd) Battery</li>
    <li>Nickel�Metal Hydride (NiMH) Battery</li>
    <li>Lithium-Ion Battery</li>
    <li>Lithium-Ion Polymer (LiPo) Battery</li>
    <li>Aluminum-Sulfur Battery</li>
    <li>Flow Battery</li>
    <li>Mechanical Flywheel</li>
    <li>Mechanical Gravitational</li>
    </ul>
    '''

    chargeRateActiveMax: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Active power charge maximum rating</i>
            Maximum active power charge rating in watts
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Active power charge maximum rating</i>
    Maximum active power charge rating in watts
    '''

    chargeRateReactiveMax: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Apparent power charge maximum rating</i>
            Maximum apparent power charge rating in voltamperes. May differ from the
            apparent power maximum rating
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Apparent power charge maximum rating</i>
    Maximum apparent power charge rating in voltamperes. May differ from
    the apparent power maximum rating
    '''

    storageCapacity: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class SwitchInfo(ConductingAssetInfo):
    '''
    Switch datasheet information.
    '''

    isSinglePhase: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, it is a single phase switch.
            '''

        })
    '''
    If true, it is a single phase switch.
    '''

    isUnganged: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, the switch is not ganged (i.e., a switch phase may be operated
            separately from other phases).
            '''

        })
    '''
    If true, the switch is not ganged (i.e., a switch phase may be operated
    separately from other phases).
    '''

    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum fault current a breaking device can break safely under prescribed
            conditions of use.
            '''

        })
    '''
    The maximum fault current a breaking device can break safely under
    prescribed conditions of use.
    '''

    gasWeightPerTank: Optional[ float | Mass ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Weight of gas in each tank of SF6 dead tank breaker.
            '''

        })
    '''
    Weight of gas in each tank of SF6 dead tank breaker.
    '''

    lowPressureAlarm: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Gas or air pressure at or below which a low pressure alarm is generated.
            '''

        })
    '''
    Gas or air pressure at or below which a low pressure alarm is generated.
    '''

    lowPressureLockOut: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Gas or air pressure below which the breaker will not open.
            '''

        })
    '''
    Gas or air pressure below which the breaker will not open.
    '''

    oilVolumePerTank: Optional[ float | Volume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Volume of oil in each tank of bulk oil breaker.
            '''

        })
    '''
    Volume of oil in each tank of bulk oil breaker.
    '''

    ratedFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Frequency for which switch is rated.
            '''

        })
    '''
    Frequency for which switch is rated.
    '''

    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
            '''

        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''

    ratedInterruptingTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Switch rated interrupting time in seconds.
            '''

        })
    '''
    Switch rated interrupting time in seconds.
    '''
    
@dataclass(repr=False)
class TapChangerInfo(ConductingAssetInfo):
    '''
    Tap changer data.
    '''

    ShuntReactorInfo: list[ShuntReactorInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShuntReactorInfo.TapChangerInfo',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ctRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Built-in current transducer ratio.
            '''

        })
    '''
    Built-in current transducer ratio.
    '''

    highStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Highest possible tap step position, advance from neutral.
            '''

        })
    '''
    Highest possible tap step position, advance from neutral.
    '''

    isTcul: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Whether this tap changer has under load tap changing capabilities.
            '''

        })
    '''
    Whether this tap changer has under load tap changing capabilities.
    '''

    lowStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Lowest possible tap step position, retard from neutral.
            '''

        })
    '''
    Lowest possible tap step position, retard from neutral.
    '''

    neutralStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The neutral tap step position for the winding.
            '''

        })
    '''
    The neutral tap step position for the winding.
    '''

    ptRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Built-in voltage transducer ratio.
            '''

        })
    '''
    Built-in voltage transducer ratio.
    '''

    bil: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Basic Insulation Level (BIL) expressed as the impulse crest voltage of
            a nominal wave, typically 1.2 X 50 microsecond. This is a measure of the
            ability of the insulation to withstand very high voltage surges.
            '''

        })
    '''
    Basic Insulation Level (BIL) expressed as the impulse crest voltage
    of a nominal wave, typically 1.2 X 50 microsecond. This is a measure
    of the ability of the insulation to withstand very high voltage surges.
    '''

    ctRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Built-in current transformer primary rating.
            '''

        })
    '''
    Built-in current transformer primary rating.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Frequency at which the ratings apply.
            '''

        })
    '''
    Frequency at which the ratings apply.
    '''

    neutralU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Voltage at which the winding operates at the neutral tap setting.
            '''

        })
    '''
    Voltage at which the winding operates at the neutral tap setting.
    '''

    ratedApparentPower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated apparent power.
            '''

        })
    '''
    Rated apparent power.
    '''

    stepPhaseIncrement: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase shift per step position.
            '''

        })
    '''
    Phase shift per step position.
    '''

    stepReactiveIncrement: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Tap step increment, in per cent of rated Mvar, per step position.
            '''

        })
    '''
    Tap step increment, in per cent of rated Mvar, per step position.
    '''

    stepVoltageIncrement: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Tap step increment, in per cent of rated voltage, per step position.
            '''

        })
    '''
    Tap step increment, in per cent of rated voltage, per step position.
    '''
    
@dataclass(repr=False)
class TransformerEndInfo(ConductingAssetInfo):
    '''
    Transformer end data.
    '''

    EnergisedEndNoLoadTests: list[NoLoadTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShuntReactorInfo.TapChangerInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    All no-load test measurements in which this transformer end was energised.
    '''
    
    EnergisedEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number for this transformer end, corresponding to the end's order in the
            PowerTransformer.vectorGroup attribute. Highest voltage winding should
            be 1.
            '''

        })
    '''
    Number for this transformer end, corresponding to the end's order in
    the PowerTransformer.vectorGroup attribute. Highest voltage winding
    should be 1.
    '''
    
    OpenEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Winding phase angle where 360 degrees are represented with clock hours,
            so the valid values are {0, ..., 11}. For example, to express the second
            winding in code 'Dyn11', set attributes as follows: 'endNumber'=2, 'connectionKind'
            = Yn and 'phaseAngleClock' = 11.
            '''

        })
    '''
    Winding phase angle where 360 degrees are represented with clock hours,
    so the valid values are {0, ..., 11}. For example, to express the second
    winding in code 'Dyn11', set attributes as follows: 'endNumber'=2,
    'connectionKind' = Yn and 'phaseAngleClock' = 11.
    '''
    
    EnergisedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of connection.
            '''

        })
    '''
    Kind of connection.
    '''
    
    GroundedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Apparent power that the winding can carry under emergency conditions (also
            called long-term emergency power).
            '''

        })
    '''
    Apparent power that the winding can carry under emergency conditions
    (also called long-term emergency power).
    '''
    
    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Basic insulation level voltage rating.
            '''

        })
    '''
    Basic insulation level voltage rating.
    '''
    
    FromMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC resistance.
            '''

        })
    '''
    DC resistance.
    '''
    
    ToMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal apparent power rating.
            '''

        })
    '''
    Normal apparent power rating.
    '''
    
    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Apparent power that this winding can carry for a short period of time (in
            emergency).
            '''

        })
    '''
    Apparent power that this winding can carry for a short period of time
    (in emergency).
    '''
    
    endNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Core admittance calculated from this transformer end datasheet, representing
            magnetising current and core losses. The full values of the transformer
            should be supplied for one transformer end info only.
            '''

        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''
    
    phaseAngleClock: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEndInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer star impedance calculated from this transformer end datasheet.
            '''

        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''
    
    connectionKind: Optional[ WindingConnection ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'TransformerTankInfo.TransformerEndInfos',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer tank data that this end description is part of.
            '''

        })
    '''
    Transformer tank data that this end description is part of.
    '''
    
    emergencyS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NoLoadTest.EnergisedEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All no-load test measurements in which this transformer end was energised.
            '''

        })
    '''
    All no-load test measurements in which this transformer end was energised.
    '''
    
    insulationU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OpenCircuitTest.EnergisedEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All open-circuit test measurements in which this transformer end was excited.
            '''

        })
    '''
    All open-circuit test measurements in which this transformer end was
    excited.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OpenCircuitTest.OpenEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All open-circuit test measurements in which this transformer end was not
            excited.
            '''

        })
    '''
    All open-circuit test measurements in which this transformer end was
    not excited.
    '''
    
    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitTest.EnergisedEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All short-circuit test measurements in which this transformer end was energised.
            '''

        })
    '''
    All short-circuit test measurements in which this transformer end was
    energised.
    '''
    
    shortTermS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitTest.GroundedEnds',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All short-circuit test measurements in which this transformer end was short-circuited.
            '''

        })
    '''
    All short-circuit test measurements in which this transformer end was
    short-circuited.
    '''

    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Core admittance calculated from this transformer end datasheet, representing
            magnetising current and core losses. The full values of the transformer
            should be supplied for one transformer end info only.
            '''

        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''
    
    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerMeshImpedance.FromTransformerEndInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All mesh impedances between this 'to' and other 'from' transformer ends.
            '''

        })
    '''
    All mesh impedances between this 'to' and other 'from' transformer
    ends.
    '''
    
    ToMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerMeshImpedance.ToTransformerEndInfos',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All mesh impedances between this 'from' and other 'to' transformer ends.
            '''
        
        })
    '''
    All mesh impedances between this 'from' and other 'to' transformer
    ends.
    '''
    
    TransformerTankInfo: Optional[TransformerTankInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEndInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer star impedance calculated from this transformer end datasheet.
            '''

        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''
    
@dataclass(repr=False)
class CoolingInfo(AssetInfo):
    '''
    Cooling information
    '''

    typeOfCooling: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of cooling.
            '''

        })
    '''
    Type of cooling.
    '''

    Specification: Optional[Specification] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Specification.CoolingInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class CrossarmInfo(AssetInfo):
    '''
    Cross arm information
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DamperInfo(AssetInfo):
    '''
    Damper asset information
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class InsulationInfo(AssetInfo):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    CableInfo: Optional[CableInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CableInfo.InsulationInfo',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    insulated: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if conductor is insulated.
            '''

        })
    '''
    True if conductor is insulated.
    '''

    insulationMaterial: Optional[ WireInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if insulated conductor) Material used for insulation.
            '''

        })
    '''
    (if insulated conductor) Material used for insulation.
    '''

    insulationThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if insulated conductor) Thickness of the insulation.
            '''

        })
    '''
    (if insulated conductor) Thickness of the insulation.
    '''

    CableInfo: Optional[CableInfo] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CableInfo.InsulationInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class InsulatorInfo(AssetInfo):
    '''
    Insulator information
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class InterrupterUnitInfo(AssetInfo):
    '''
    Interrupter datasheet information.
    '''

    interruptingMedium: Optional[ InterruptingMediumKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Interrupting medium.
            '''

        })
    '''
    Interrupting medium.
    '''
    
@dataclass(repr=False)
class OperatingMechanismInfo(AssetInfo):
    '''
    Breaker operating mechanism datasheet information.
    '''

    closeAmps: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Close current (nominal).
            '''

        })
    '''
    Close current (nominal).
    '''

    closeVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Close voltage in volts DC.
            '''

        })
    '''
    Close voltage in volts DC.
    '''

    mechanismKind: Optional[ OperatingMechanismKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of breaker operating mechanism.
            '''

        })
    '''
    Kind of breaker operating mechanism.
    '''

    motorRunCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated motor run current in amps.
            '''

        })
    '''
    Rated motor run current in amps.
    '''

    motorStartCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated motor start current in amps.
            '''

        })
    '''
    Rated motor start current in amps.
    '''

    motorVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nominal motor voltage in volts DC.
            '''

        })
    '''
    Nominal motor voltage in volts DC.
    '''

    tripAmps: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Trip current (nominal).
            '''

        })
    '''
    Trip current (nominal).
    '''

    tripVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Trip voltage in volts DC.
            '''

        })
    '''
    Trip voltage in volts DC.
    '''
    
@dataclass(repr=False)
class PhaseToPhaseSpacing(AssetInfo):
    '''
    Distance from
    '''

    sequenceNumberWire1: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    sequenceNumberWire2: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    distance: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    fromPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    toPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.PhaseSpacing',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class PoleAssetInfo(AssetInfo):
    '''
    Pole asset data sheet.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerTransformerInfo(AssetInfo):
    '''
    Set of power transformer data, from an equipment library.
    '''

    TransformerTankInfos: list[TransformerTankInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTankInfo.PowerTransformerInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Data for all the tanks described by this power transformer data.
            '''

        })
    '''
    Data for all the tanks described by this power transformer data.
    '''
    
@dataclass(repr=False)
class ShuntCompensatorInfo(AssetInfo):
    '''
    Properties of shunt capacitor, shunt reactor or switchable bank of shunt
    capacitor or reactor assets.
    '''

    maxPowerLoss: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum allowed apparent power loss.
            '''

        })
    '''
    Maximum allowed apparent power loss.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated current.
            '''

        })
    '''
    Rated current.
    '''

    ratedReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated reactive power.
            '''

        })
    '''
    Rated reactive power.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage.
            '''

        })
    '''
    Rated voltage.
    '''

    ShuntCompensatorControl: Optional[ShuntCompensatorControl] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorControl.ShuntCompensatorInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class SoundInfo(AssetInfo):
    '''
    Sound information
    '''

    minSoundPressureLevel: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum sound pressure level.
            '''

        })
    '''
    Minimum sound pressure level.
    '''

    Specification: Optional[Specification] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Specification.SoundInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class StructureInfo(AssetInfo):
    '''
    Structure information
    '''

    hasTemperatureMeasurement: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if structure includes a temperature measurement.
            '''

        })
    '''
    True if structure includes a temperature measurement.
    '''

    hasVentilation: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if vault is ventilating.
            '''

        })
    '''
    True if vault is ventilating.
    '''

    material: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Material this structure is made of.
            '''

        })
    '''
    Material this structure is made of.
    '''

    materialKind: Optional[ StructureMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Material this structure is made of.
            '''

        })
    '''
    Material this structure is made of.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum rated voltage of the equipment that can be mounted on/contained
            within the structure.
            '''

        })
    '''
    Maximum rated voltage of the equipment that can be mounted on/contained
    within the structure.
    '''

    ConstructedDimensions: Optional[Dimension] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Dimension.ConstructedStructureInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    TransportDimensionsInfo: Optional[DimensionsInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Dimension.TransportStructureInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class MarineStructureInfo(StructureInfo):
    '''
    Marine structure information.
    '''

    kind: Optional[ MarineStructureKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of submarine structure.
            '''

        })
    '''
    Type of submarine structure.
    '''
    
@dataclass(repr=False)
class OverheadStructureInfo(StructureInfo):
    '''
    Overhead structure information
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class UndergroundStructureInfo(StructureInfo):
    '''
    Underground structure information
    '''

    kind: Optional[ UndergroundStructureKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of underground structure
            '''

        })
    '''
    Kind of underground structure
    '''
    
@dataclass(repr=False)
class SurfaceTreatmentInfo(AssetInfo):
    '''
    Surface treatment information
    '''

    galvanizationThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Galvanization thickness.
            '''

        })
    '''
    Galvanization thickness.
    '''

    paintThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Paint thickness.
            '''

        })
    '''
    Paint thickness.
    '''

    Specification: Optional[Specification] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Specification.SurfaceTreatmentInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class ToolInfo(AssetInfo):
    '''
    Type of tool needed to perform a certain type of work.
    '''

    toolType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of the tool
            '''

        })
    '''
    Type of the tool
    '''
    
@dataclass(repr=False)
class TransformerTankInfo(AssetInfo):
    '''
    Set of transformer tank data, from an equipment library.
    '''

    PowerTransformerInfo: Optional[PowerTransformerInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'PowerTransformerInfo.TransformerTankInfos',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power transformer data that this tank description is part of.
            '''

        })
    '''
    Power transformer data that this tank description is part of.
    '''
    
    TransformerTanks: list[TransformerTank] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEndInfo.TransformerTankInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Data for all the ends described by this transformer tank data.
            '''

        })
    '''
    Data for all the ends described by this transformer tank data.
    '''
    
    PowerTransformerInfo: Optional[PowerTransformerInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTank.TransformerTankInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    Power transformer data that this tank description is part of.
    '''
    
@dataclass(repr=False)
class VehicleInfo(AssetInfo):
    '''
    Type of vehicle needed to perform certain type of work.
    '''

    make: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Vehicle manufacturer (OEM)
            '''

        })
    '''
    Vehicle manufacturer (OEM)
    '''

    model: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Vehicle model name
            '''

        })
    '''
    Vehicle model name
    '''

    vehicleType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of vehicle.
            '''

        })
    '''
    Type of vehicle.
    '''

    year: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Model year of the vehicle
            '''

        })
    '''
    Model year of the vehicle
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class ElectricVehicleInfo(VehicleInfo):
    '''
    The ElectricVehicleInfo class associates the vehicle with its physical
    and operational characteristics (make, model, year, battery, connectors)
    and its state of charge (SOC) dynamics.
    '''

    v2gCapable: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    batteryCapacity: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    evType: Optional[ EVTypeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Type of EV (e.g., BEV, PHEV, bus, truck, motorcycle).
            '''

        })
    '''
    Type of EV (e.g., BEV, PHEV, bus, truck, motorcycle).
    '''

    maxChargingRate: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    BatteryInfo: Optional[BatteryInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BatteryInfo.ElectricVehicleInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class WireAssemblyInfo(AssetInfo):
    '''
    Describes the construction of a multi-conductor wire.<-NOTE: period missing.
    '''

    numberOfPhases: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default=None,
        metadata={
        'type': 'enumeration GridAPPSD Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    PerLengthLineParameter: list[PerLengthLineParameter] = field(
        default_factory=list,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EarthResistivity.WireAssemblyInfos',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthImpedance.WireAssemblyInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    numberOfPhases: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.WireAssemblyInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    installationType: Optional[ WireInstallationKind ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.WireAssemblyInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    usage: Optional[ WireUsageKind ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthImpedance.WireAssemblyInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    EarthResistivity: Optional[EarthResistivity] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PerLengthLineParameter.WireAssemblyInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Per length line parameter associated with this wire assembly.
            '''

        })
    '''
    Per length line parameter associated with this wire assembly.
    '''
    
    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireAssemblyInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Wire phase information associated with this wire assembly.
            '''

        })
    '''
    Wire phase information associated with this wire assembly.
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.WireAssemblyInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class WireBundleInfo(AssetInfo):
    '''
    '''

    WirePhaseInfos: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireBundleInfo',
        'namespace': 'http://epri.com/GridAPPSD#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    wireCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    gmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Equivalent geometric mean radius of the symmetric conductor bundle, calculated
            from the radius
            '''

        })
    '''
    Equivalent geometric mean radius of the symmetric conductor bundle,
    calculated from the radius
    '''

    radius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Equivalent radius of the conductor
            '''

        })
    '''
    Equivalent radius of the conductor
    '''

    wireSpacing: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Distance between wire sub-conductors in a symmetrical bundle.
            '''

        })
    '''
    Distance between wire sub-conductors in a symmetrical bundle.
    '''

    WireInfo: Optional[WireInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireInfo.WireBundleInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.deprecated)
@dataclass(repr=False)
class WireSpacingInfo(AssetInfo):
    '''
    Wire spacing data that associates multiple wire positions with the line
    segment, and allows to calculate line segment impedances. Number of phases
    can be derived from the number of associated wire positions whose phase
    is not neutral.
    '''

    isCable: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, this spacing data describes a cable.
            '''

        })
    '''
    If true, this spacing data describes a cable.
    '''
    
    PhaseSpacing: list[PhaseToPhaseSpacing] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'modify Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of wire sub-conductors in the symmetrical bundle (typically between
            1 and 4).
            '''

        })
    '''
    Number of wire sub-conductors in the symmetrical bundle (typically
    between 1 and 4).
    '''
    
    WirePositions: list[WirePosition] = field(
        default_factory=list,
        metadata={
        'type': 'modify Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Distance between wire sub-conductors in a symmetrical bundle.
            '''

        })
    '''
    Distance between wire sub-conductors in a symmetrical bundle.
    '''
    
    isCable: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'enumeration GridAPPSD Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    isUnderground: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Usage of the associated wires.
            '''

        })
    '''
    Usage of the associated wires.
    '''
    
    phaseWireCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DuctBank.WireSpacingInfos',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    phaseWireSpacing: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.WireSpacingInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    spacingType: Optional[ WireSpacingKind ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.WireSpacingInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    usage: Optional[ WireUsageKind ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseToPhaseSpacing.WireSpacingInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    DuctBank: Optional[DuctBank] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.WireSpacingInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePosition.WireSpacingInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All positions of single wires (phase or neutral) making the conductor.
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class AssetInfoComponent(IdentifiedObject):
    '''
    Components of an asset info
    '''

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of component
            '''

        })
    '''
    Type of component
    '''

    ChildAssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.ParentAssetInfoComponent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.ChildAssetInfoComponent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    ChildAssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.ChildAssetInfoComponent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    ParentAssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.ParentAssetInfoComponent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class AssetRequirement(IdentifiedObject):
    '''
    This is an asset requirement information defined by designed (product procurer).
    It is related to AssetInfo.
    '''

    AssetInfo: list[AssetInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AssetInfo.AssetRequirement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class AsynchronousMachineDynamics(IdentifiedObject):
    '''
    Asynchronous machine whose behaviour is described by reference to a standard
    model expressed in either time constant reactance form or equivalent circuit
    form <font color="#0f0f0f">or by definition of a user-defined model.</font>
    Parameter details:
    <ol>
    <li>Asynchronous machine parameters such as <i>Xl, Xs,</i> etc. are actually
    used as inductances in the model, but are commonly referred to as reactances
    since, at nominal frequency, the PU values are the same. However, some
    references use the symbol <i>L</i> instead of <i>X</i>.</li>
    </ol>
    '''

    AsynchronousMachine: Optional[AsynchronousMachine] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AsynchronousMachine.AsynchronousMachineDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asynchronous machine to which this asynchronous machine dynamics model
            applies.
            '''

        })
    '''
    Asynchronous machine to which this asynchronous machine dynamics model
    applies.
    '''
    
@dataclass(repr=False)
class BaseFrequency(IdentifiedObject):
    '''
    The BaseFrequency class describes a base frequency for a power system network.
    In case of multiple power networks with different frequencies, e.g. 50
    Hz or 60 Hz each network will have its own base frequency class. Hence
    it is assumed that power system objects having different base frequencies
    appear in separate documents where each document has a single base frequency
    instance.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The base frequency.
            '''

        })
    '''
    The base frequency.
    '''
    
@dataclass(repr=False)
class BasePower(IdentifiedObject):
    '''
    The BasePower class defines the base power used in the per unit calculations.
    '''

    basePower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value used as base power.
            '''

        })
    '''
    Value used as base power.
    '''
    
@dataclass(repr=False)
class BaseVoltage(IdentifiedObject):
    '''
    Defines a system base voltage which is referenced. This may be different
    than the rated voltage.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The power system resource's base voltage, expressed on a phase-to-phase
            (line-to-line) basis. Shall be a positive value and not zero.
            '''
        
        })
    '''
    The power system resource's base voltage, expressed on a phase-to-phase
    (line-to-line) basis. Shall be a positive value and not zero.
    '''
    
    ConductingEquipment: list[ConductingEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConductingEquipment.BaseVoltage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All conducting equipment with this base voltage. Use only when there is
            no voltage level container used and only one base voltage applies. For
            example, not used for transformers.
            '''

        })
    '''
    All conducting equipment with this base voltage. Use only when there
    is no voltage level container used and only one base voltage applies.
    For example, not used for transformers.
    '''

    TopologicalNode: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.BaseVoltage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The topological nodes at the base voltage.
            '''

        })
    '''
    The topological nodes at the base voltage.
    '''

    TransformerEnds: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.BaseVoltage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer ends at the base voltage. This is essential for PU calculation.
            '''

        })
    '''
    Transformer ends at the base voltage. This is essential for PU calculation.
    '''

    VoltageLevel: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.BaseVoltage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage levels having this base voltage.
            '''

        })
    '''
    The voltage levels having this base voltage.
    '''
    
    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The power system resource's base voltage, expressed on a phase-to-phase
            (line-to-line) basis. Shall be a positive value and not zero.
            '''
        
        })
    '''
    The power system resource's base voltage, expressed on a phase-to-phase
    (line-to-line) basis. Shall be a positive value and not zero.
    '''
    
@dataclass(repr=False)
class BasicIntervalSchedule(IdentifiedObject):
    '''
    Schedule of values at points in time.
    '''

    startTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time for the first time point. The value can be a time of day, not
            a specific date.
            '''

        })
    '''
    The time for the first time point. The value can be a time of day,
    not a specific date.
    '''

    value1Description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Description for value1.
            '''

        })
    '''
    Description for value1.
    '''

    value2Description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Description for value2.
            '''

        })
    '''
    Description for value2.
    '''

    value3Description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Description for value3.
            '''

        })
    '''
    Description for value3.
    '''

    value1Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for value1.
            '''

        })
    '''
    Multiplier for value1.
    '''

    value1Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value1 units of measure.
            '''

        })
    '''
    Value1 units of measure.
    '''

    value2Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for value2.
            '''

        })
    '''
    Multiplier for value2.
    '''

    value2Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value2 units of measure.
            '''

        })
    '''
    Value2 units of measure.
    '''

    value3Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for value3.
            '''

        })
    '''
    Multiplier for value3.
    '''

    value3Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value3 units of measure.
            '''

        })
    '''
    Value3 units of measure.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class IrregularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them varies.
    '''

    TimePoints: list[IrregularTimePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IrregularTimePoint.IntervalSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The point data values that define a curve.
            '''

        })
    '''
    The point data values that define a curve.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class RegularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them is constant.
    '''

    TimePoints: list[RegularTimePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegularTimePoint.IntervalSchedule',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The regular interval time point data values that define this schedule.
            '''
        
        })
    '''
    The regular interval time point data values that define this schedule.
    '''
    
    endTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time for the last time point. The value can be a time of day, not a
            specific date.
            '''

        })
    '''
    The time for the last time point. The value can be a time of day, not
    a specific date.
    '''

    timeStep: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time between each pair of subsequent regular time points in sequence
            order.
            '''

        })
    '''
    The time between each pair of subsequent regular time points in sequence
    order.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class GenUnitOpSchedule(RegularIntervalSchedule):
    '''
    The generating unit's Operator-approved current operating schedule (or
    plan), typically produced with the aid of unit commitment type analyses.
    The X-axis represents absolute time. The Y1-axis represents the status
    (0=off-line and unavailable: 1=available: 2=must run: 3=must run at fixed
    power value: etc.). The Y2-axis represents the must run fixed power value
    where required.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'NC OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''

        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''

        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HydroPumpOpSchedule(RegularIntervalSchedule):
    '''
    The hydro pump's Operator-approved current operating schedule (or plan),
    typically produced with the aid of unit commitment type analyses. The unit's
    operating schedule status is typically given as: (0=unavailable) (1=available
    to startup or shutdown) (2=must pump).
    '''

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'NC OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'HydroPump.HydroPumpOpSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''

        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.HydroPumpOpSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''

        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
@dataclass(repr=False)
class InflowForecast(RegularIntervalSchedule):
    '''
    Natural water inflow to a reservoir, usually forecasted from predicted
    rain and snowmelt. Typically in one hour increments for up to 10 days.
    The forecast is given in average cubic meters per second over the time
    increment.
    '''

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Reservoir.InflowForecasts',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reservoir may have a "natural" inflow forecast.
            '''

        })
    '''
    A reservoir may have a "natural" inflow forecast.
    '''
    
@dataclass(repr=False)
class SeasonDayTypeSchedule(RegularIntervalSchedule):
    '''
    A time schedule covering a 24 hour period, with curve data for a specific
    type of season and day.
    '''

    DayType: Optional[DayType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DayType.SeasonDayTypeSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DayType for the Schedule.
            '''

        })
    '''
    DayType for the Schedule.
    '''

    Season: Optional[Season] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Season.SeasonDayTypeSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Season for the Schedule.
            '''

        })
    '''
    Season for the Schedule.
    '''
    
@dataclass(repr=False)
class ConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    A curve of load versus time (X-axis) showing the active power values (Y1-axis)
    and reactive power (Y2-axis) for each unit of the period covered. This
    curve represents a typical pattern of load over the time period for a given
    day type and season.
    '''

    ConformLoadGroup: Optional[ConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ConformLoadGroup.ConformLoadSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ConformLoadGroup where the ConformLoadSchedule belongs.
            '''

        })
    '''
    The ConformLoadGroup where the ConformLoadSchedule belongs.
    '''
    
@dataclass(repr=False)
class NonConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    An active power (Y1-axis) and reactive power (Y2-axis) schedule (curves)
    versus time (X-axis) for non-conforming loads, e.g., large industrial load
    or power station service (where modelled).
    '''

    NonConformLoadGroup: Optional[NonConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'NonConformLoadGroup.NonConformLoadSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The NonConformLoadGroup where the NonConformLoadSchedule belongs.
            '''

        })
    '''
    The NonConformLoadGroup where the NonConformLoadSchedule belongs.
    '''
    
@dataclass(repr=False)
class RegulationSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a controlled variable, e.g., busbar
    voltage.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RegulatingControl.RegulationSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Regulating controls that have this schedule.
            '''

        })
    '''
    Regulating controls that have this schedule.
    '''
    
    RegulatingControl: Optional[RegulatingControl] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageControlZone.RegulationSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A VoltageControlZone may have a voltage regulation schedule.
            '''

        })
    '''
    A VoltageControlZone may have a voltage regulation schedule.
    '''
    
@dataclass(repr=False)
class SwitchSchedule(SeasonDayTypeSchedule):
    '''
    A schedule of switch positions. If RegularTimePoint.value1 is 0, the switch
    is open. If 1, the switch is closed.
    '''

    Switch: Optional[Switch] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Switch.SwitchSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A SwitchSchedule is associated with a Switch.
            '''

        })
    '''
    A SwitchSchedule is associated with a Switch.
    '''
    
@dataclass(repr=False)
class TapSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a tap step.
    '''

    TapChanger: Optional[TapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'TapChanger.TapSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A TapSchedule is associated with a TapChanger.
            '''

        })
    '''
    A TapSchedule is associated with a TapChanger.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class SteamSendoutSchedule(RegularIntervalSchedule):
    '''
    The cogeneration plant's steam sendout schedule in volume per time unit.
    '''

    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.SteamSendoutSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''

        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''

    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.SteamSendoutSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''

        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
@dataclass(repr=False)
class BilateralExchangeActor(IdentifiedObject):
    '''
    BilateralExchangeActor describes an actor that provides ICCP data, consumes
    ICCP data or both. The ICCP data provider lists the data it makes available
    to an ICCP data consumer. This data is described by ProvidedBilateralPoints.
    The relation between an ICCP data provider and a consumer is established
    by a BilateralExchangeAgreement. It is up to the ICCP data consumer to
    select what ProvidedBilateralPoints to use. The selection made is not described
    in this information model.
    '''

    CommunicationLink: list[CommunicationLink] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CommunicationLink.BilateralExchangeActor',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Communication addressing for a Bilateral Table used by a ICCP data provider
            or consumer.
            '''

        })
    '''
    Communication addressing for a Bilateral Table used by a ICCP data
    provider or consumer.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class BranchGroup(IdentifiedObject):
    '''
    A group of branch terminals whose directed flow summation is to be monitored.
    A branch group need not form a cutset of the network.
    '''

    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BranchGroupTerminal.BranchGroup',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The directed branch group terminals to be summed.
            '''
        
        })
    '''
    The directed branch group terminals to be summed.
    '''
    
    monitorActivePower: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Monitor the active power flow.
            '''

        })
    '''
    Monitor the active power flow.
    '''

    monitorReactivePower: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Monitor the reactive power flow.
            '''

        })
    '''
    Monitor the reactive power flow.
    '''

    maximumActivePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum active power flow.
            '''

        })
    '''
    The maximum active power flow.
    '''

    maximumReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum reactive power flow.
            '''

        })
    '''
    The maximum reactive power flow.
    '''

    minimumActivePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum active power flow.
            '''

        })
    '''
    The minimum active power flow.
    '''

    minimumReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum reactive power flow.
            '''

        })
    '''
    The minimum reactive power flow.
    '''
    
@dataclass(repr=False)
class BusNameMarker(IdentifiedObject):
    '''
    Used to apply user standard names to TopologicalNodes. Associated with
    one or more terminals that are normally connected with the bus name. The
    associated terminals are normally connected by non-retained switches. For
    a ring bus station configuration, all BusbarSection terminals in the ring
    are typically associated. For a breaker and a half scheme, both BusbarSections
    would normally be associated. For a ring bus, all BusbarSections would
    normally be associated. For a "straight" busbar configuration, normally
    only the main terminal at the BusbarSection would be associated.
    '''

    Terminal: list[ACDCTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACDCTerminal.BusNameMarker',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminals associated with this bus name marker.
            '''
        
        })
    '''
    The terminals associated with this bus name marker.
    '''
    
    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Priority of bus name marker for use as topology bus name. Use 0 for do
            not care. Use 1 for highest priority. Use 2 as priority is less than 1
            and so on.
            '''

        })
    '''
    Priority of bus name marker for use as topology bus name. Use 0 for
    do not care. Use 1 for highest priority. Use 2 as priority is less
    than 1 and so on.
    '''

    ReportingGroup: Optional[ReportingGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReportingGroup.BusNameMarker',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reporting group to which this bus name marker belongs.
            '''

        })
    '''
    The reporting group to which this bus name marker belongs.
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.BusNameMarker',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A user defined topological node that was originally defined in a planning
            model not yet having topology described by ConnectivityNodes. Once ConnectivityNodes
            have been created they may be linked to user defined ToplogicalNodes using
            BusNameMarkers.
            '''

        })
    '''
    A user defined topological node that was originally defined in a planning
    model not yet having topology described by ConnectivityNodes. Once
    ConnectivityNodes have been created they may be linked to user defined
    ToplogicalNodes using BusNameMarkers.
    '''
    
@stereotype(CIMStereotype.harmonization)
@dataclass(repr=False)
class CalculationMethodHierarchy(IdentifiedObject):
    '''
    The hierarchy of calculation methods used to derive this measurement.
    '''

    Measurement: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.CalculationMethodHierarchy',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement to which this calculation method hierarchy applies.
            '''

        })
    '''
    Measurement to which this calculation method hierarchy applies.
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.CalculationMethodHierarchy',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement value to which this calculation method hierarchy applies.
            '''

        })
    '''
    Measurement value to which this calculation method hierarchy applies.
    '''
    
@dataclass(repr=False)
class CatalogAssetType(IdentifiedObject):
    '''
    a Assets that may be used for planning, work or design purposes.
    '''

    AssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.CatalogAssetType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generic nameplate information associated with this catalog asset type.
            '''

        })
    '''
    Generic nameplate information associated with this catalog asset type.
    '''
    
@dataclass(repr=False)
class ChargingZone(IdentifiedObject):
    '''
    Power management concept representing a group of one or more charging stations
    within a particular charging park (typically with a relationship with the
    electrical arrangement)
    A small park will only have one charging zone
    '''

    @property
    def __namespace__(self):
        return 'http://gridappsd.org/CIM/extension#'
    @property
    def __package__(self):
        return 'CustomerEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ClampAction(IdentifiedObject):
    '''
    Action on Clamp as a switching step
    '''

    Clamp: Optional[Clamp] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Clamp.ClampAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.European)
@dataclass(repr=False)
class ConnectivityNode(IdentifiedObject):
    '''
    Connectivity nodes are points where terminals of AC conducting equipment
    are connected together with zero impedance.
    '''

    ACPointOfCommonCoupling: Optional[ACPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACPointOfCommonCoupling.ConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Identifies this ConnectivityNode as a point of common coupling AC.
            '''

        })
    '''
    Identifies this ConnectivityNode as a point of common coupling AC.
    '''

    BoundaryPoint: Optional[BoundaryPoint] = field(
        default=None,
        metadata={
        'type': 'European',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BoundaryPoint.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The boundary point associated with the connectivity node.
            '''

        })
    '''
    The boundary point associated with the connectivity node.
    '''
    
    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNodeContainer.ConnectivityNodes',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Container of this connectivity node.
            '''

        })
    '''
    Container of this connectivity node.
    '''
    
    ACPointOfCommonCoupling: Optional[ACPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IndividualPnode.ConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    BoundaryPoint: Optional[BoundaryPoint] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.ConnectivityNodes',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The topological node to which this connectivity node is assigned. May depend
            on the current state of switches in the network.
            '''

        })
    '''
    The topological node to which this connectivity node is assigned. May
    depend on the current state of switches in the network.
    '''
    
    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACPointOfCommonCoupling.ConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Identifies this ConnectivityNode as a point of common coupling AC.
            '''

        })
    '''
    Identifies this ConnectivityNode as a point of common coupling AC.
    '''
    
    IndividualPnode: Optional[IndividualPnode] = field(
        default=None,
        metadata={
        'type': 'European',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BoundaryPoint.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The boundary point associated with the connectivity node.
            '''

        })
    '''
    The boundary point associated with the connectivity node.
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Terminals interconnected with zero impedance at a this connectivity node.
            '''

        })
    '''
    The topological node to which this connectivity node is assigned. May
    depend on the current state of switches in the network.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@stereotype(CIMStereotype.NC)
@dataclass(repr=False)
class Contingency(IdentifiedObject):
    '''
    An event threatening system reliability, consisting of one or more contingency
    elements.
    '''

    ContingencyElement: list[ContingencyElement] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ContingencyElement.Contingency',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A contingency can have any number of contingency elements.
            '''
        
        })
    '''
    A contingency can have any number of contingency elements.
    '''
    
    mustStudy: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Set true if must study this contingency.
            '''

        })
    '''
    Set true if must study this contingency.
    '''

    EquipmentOperator: Optional[SystemOperator] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SystemOperator.Contingency',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            System operator that is operating the equipment that is being run a contingency
            on.
            '''

        })
    '''
    System operator that is operating the equipment that is being run a
    contingency on.
    '''
    
@dataclass(repr=False)
class ContingencyElement(IdentifiedObject):
    '''
    An element of a system event to be studied by contingency analysis, representing
    a change in status of a single piece of equipment.
    '''

    Contingency: Optional[Contingency] = field(
        default=None,
        metadata={
        'type': 'NC OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Contingency.ContingencyElement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A contingency element belongs to one contingency.
            '''

        })
    '''
    A contingency element belongs to one contingency.
    '''
    
@dataclass(repr=False)
class ContingencyEquipment(ContingencyElement):
    '''
    Equipment whose in service status is to change, such as a power transformer
    or AC line segment.
    '''

    contingentStatus: Optional[ ContingencyEquipmentStatusKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The status for the associated equipment when in the contingency state.
            This status is independent of the case to which the contingency is originally
            applied, but defines the equipment status when the contingency is applied.
            '''

        })
    '''
    The status for the associated equipment when in the contingency state.
    This status is independent of the case to which the contingency is
    originally applied, but defines the equipment status when the contingency
    is applied.
    '''

    Equipment: Optional[Equipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Equipment.ContingencyEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The single piece of equipment to which to apply the contingency.
            '''

        })
    '''
    The single piece of equipment to which to apply the contingency.
    '''
    
@dataclass(repr=False)
class ControlAction(IdentifiedObject):
    '''
    Control executed as a switching step.
    '''

    Control: Optional[Control] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Control.ControlAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class CoupledLineSegmentGroup(IdentifiedObject):
    '''
    Aggregates a set of line segments that are on the same tower, or in the
    same right-of-way, close enough that mutual coupling impedances between
    the lines need to be included in network analysis.
    '''

    LineSegmentCoupling: list[LineSegmentCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LineSegmentCoupling.CoupledLineSegmentGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A coupled line in this coupled group of lines.
            '''

        })
    '''
    A coupled line in this coupled group of lines.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Curve(IdentifiedObject):
    '''
    A multi-purpose curve or functional relationship between an independent
    variable (X-axis) and dependent (Y-axis) variables.
    '''

    CurveDatas: list[CurveData] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CurveData.Curve',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The point data values that define this curve.
            '''
        
        })
    '''
    The point data values that define this curve.
    '''
    
    curveStyle: Optional[ CurveStyle ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The style or shape of the curve.
            '''

        })
    '''
    The style or shape of the curve.
    '''

    xMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for X-axis.
            '''

        })
    '''
    Multiplier for X-axis.
    '''

    xUnit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The X-axis units of measure.
            '''

        })
    '''
    The X-axis units of measure.
    '''

    y1Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for Y1-axis.
            '''

        })
    '''
    Multiplier for Y1-axis.
    '''

    y1Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Y1-axis units of measure.
            '''

        })
    '''
    The Y1-axis units of measure.
    '''

    y2Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for Y2-axis.
            '''

        })
    '''
    Multiplier for Y2-axis.
    '''

    y2Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Y2-axis units of measure.
            '''

        })
    '''
    The Y2-axis units of measure.
    '''

    y3Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for Y3-axis.
            '''

        })
    '''
    Multiplier for Y3-axis.
    '''

    y3Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Y3-axis units of measure.
            '''

        })
    '''
    The Y3-axis units of measure.
    '''
    
@dataclass(repr=False)
class AmbientTemperatureDependencyCurve(Curve):
    '''
    A curve or functional relationship between the ambient temperature independent
    variable (X-axis) and relative temperature dependent (Y-axis) variables.
    '''

    OperationalLimitType: list[OperationalLimitType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitType.PermanentAmbientTemperatureDependencyCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit type that has this permanent ambient temperature
            dependency curve.
            '''

        })
    '''
    The operational limit type that has this permanent ambient temperature
    dependency curve.
    '''
    
@dataclass(repr=False)
class BaseOverloadLimitCurve(Curve):
    '''
    A curve or functional relationship between
    - the relative loading - current loading over permanent loading (PATL)
    independent variable (X-axis), and
    - temporary overloading (TATL) limiting dependent (Y-axis) variables.
    '''

    OperationalLimitType: list[OperationalLimitType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitType.TemporaryBaseOverloadLimitCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit type that has this temporary base overload limit
            curve.
            '''

        })
    '''
    The operational limit type that has this temporary base overload limit
    curve.
    '''
    
@dataclass(repr=False)
class DurationOverloadLimitCurve(Curve):
    '''
    A curve or functional relationship between
    - the overload duration independent variable (X-axis), and
    - temporary overloading (TATL) limiting dependent (Y-axis) variables.
    '''

    OperationalLimitType: list[OperationalLimitType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitType.TemporaryDurationOverloadLimitCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit type that has this temporary duration overload limit
            curve.
            '''

        })
    '''
    The operational limit type that has this temporary duration overload
    limit curve.
    '''
    
@dataclass(repr=False)
class EmissionAccount(Curve):
    '''
    Accounts for tracking emissions usage and credits for thermal generating
    units. A unit may have zero or more emission accounts, and will typically
    have one for tracking usage and one for tracking credits.
    '''

    emissionType: Optional[ EmissionType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
            of the curve contains the unit of measure (e.g. kg) and the emissionType
            is the type of emission (e.g. sulfur dioxide).
            '''

        })
    '''
    The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
    of the curve contains the unit of measure (e.g. kg) and the emissionType
    is the type of emission (e.g. sulfur dioxide).
    '''

    emissionValueSource: Optional[ EmissionValueSource ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The source of the emission value.
            '''

        })
    '''
    The source of the emission value.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.EmmissionAccounts',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more emission allowance accounts.
            '''

        })
    '''
    A thermal generating unit may have one or more emission allowance accounts.
    '''
    
@dataclass(repr=False)
class EmissionCurve(Curve):
    '''
    Relationship between the unit's emission rate in units of mass per hour
    (Y-axis) and output active power (X-axis) for a given type of emission.
    This curve applies when only one type of fuel is being burned.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''

        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    emissionContent: Optional[ float | Emission ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The emission content per quantity of fuel burned.
            '''

        })
    '''
    The emission content per quantity of fuel burned.
    '''

    emissionType: Optional[ EmissionType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of emission, which also gives the production rate measurement
            unit. The y1AxisUnits of the curve contains the unit of measure (e.g. kg)
            and the emissionType is the type of emission (e.g. sulfur dioxide).
            '''

        })
    '''
    The type of emission, which also gives the production rate measurement
    unit. The y1AxisUnits of the curve contains the unit of measure (e.g.
    kg) and the emissionType is the type of emission (e.g. sulfur dioxide).
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.EmissionCurves',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more emission curves.
            '''

        })
    '''
    A thermal generating unit may have one or more emission curves.
    '''
    
@dataclass(repr=False)
class FuelAllocationSchedule(Curve):
    '''
    The amount of fuel of a given type which is allocated for consumption over
    a specified period of time.
    '''

    fuelAllocationEndDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The end time and date of the fuel allocation schedule.
            '''

        })
    '''
    The end time and date of the fuel allocation schedule.
    '''

    fuelAllocationStartDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The start time and date of the fuel allocation schedule.
            '''

        })
    '''
    The start time and date of the fuel allocation schedule.
    '''

    maxFuelAllocation: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum amount of fuel that is allocated for consumption for the scheduled
            time period.
            '''

        })
    '''
    The maximum amount of fuel that is allocated for consumption for the
    scheduled time period.
    '''

    minFuelAllocation: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum amount of fuel that is allocated for consumption for the scheduled
            time period, e.g., based on a "take-or-pay" contract.
            '''

        })
    '''
    The minimum amount of fuel that is allocated for consumption for the
    scheduled time period, e.g., based on a "take-or-pay" contract.
    '''

    fuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of fuel, which also indicates the corresponding measurement unit.
            '''

        })
    '''
    The type of fuel, which also indicates the corresponding measurement
    unit.
    '''

    FossilFuel: Optional[FossilFuel] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'FossilFuel.FuelAllocationSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A fuel allocation schedule shall have a fossil fuel.
            '''

        })
    '''
    A fuel allocation schedule shall have a fossil fuel.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.FuelAllocationSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more fuel allocation schedules.
            '''

        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''
    
@dataclass(repr=False)
class GenUnitOpCostCurve(Curve):
    '''
    Relationship between unit operating cost (Y-axis) and unit output active
    power (X-axis). The operating cost curve for thermal units is derived from
    heat input and fuel costs. The operating cost curve for hydro units is
    derived from water flow rates and equivalent water costs.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''

        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'NC OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpCostCurves',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have one or more cost curves, depending upon fuel
            mixture and fuel cost.
            '''

        })
    '''
    A generating unit may have one or more cost curves, depending upon
    fuel mixture and fuel cost.
    '''
    
@dataclass(repr=False)
class GrossToNetActivePowerCurve(Curve):
    '''
    Relationship between the generating unit's gross active power output on
    the X-axis (measured at the terminals of the machine(s)) and the generating
    unit's net active power output on the Y-axis (based on utility-defined
    measurements at the power station). Station service loads, when modelled,
    should be treated as non-conforming bus loads. There may be more than one
    curve, depending on the auxiliary equipment that is in service.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'NC OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GrossToNetActivePowerCurves',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have a gross active power to net active power curve,
            describing the losses and auxiliary power requirements of the unit.
            '''

        })
    '''
    A generating unit may have a gross active power to net active power
    curve, describing the losses and auxiliary power requirements of the
    unit.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HeatInputCurve(Curve):
    '''
    Relationship between unit heat input in energy per time for main fuel (Y1-axis)
    and supplemental fuel (Y2-axis) versus unit output in active power (X-axis).
    The quantity of main fuel used to sustain generation at this output level
    is prorated for throttling between definition points. The quantity of supplemental
    fuel used at this output level is fixed and not prorated.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''

        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    auxPowerMult: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power output - auxiliary power multiplier adjustment factor.
            '''

        })
    '''
    Power output - auxiliary power multiplier adjustment factor.
    '''

    auxPowerOffset: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power output - auxiliary power offset adjustment factor.
            '''

        })
    '''
    Power output - auxiliary power offset adjustment factor.
    '''

    heatInputEff: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Heat input - efficiency multiplier adjustment factor.
            '''

        })
    '''
    Heat input - efficiency multiplier adjustment factor.
    '''

    heatInputOffset: Optional[ float | HeatRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Heat input - offset adjustment factor.
            '''

        })
    '''
    Heat input - offset adjustment factor.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''

        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HeatRateCurve(Curve):
    '''
    Relationship between unit heat rate per active power (Y-axis) and unit
    output (X-axis). The heat input is from all fuels.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''

        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''
    
@dataclass(repr=False)
class HydroGeneratingEfficiencyCurve(Curve):
    '''
    Relationship between unit efficiency as percentage and unit output active
    power for a given net head in meters. The relationship between efficiency,
    discharge, head, and power output is expressed as follows: E =KP/HQ
    where: E is the efficiency, as a percentage; P is the active power; H is
    the height; Q is the discharge, volume/time unit; K is a constant.
    For example, a curve instance for a given net head could show efficiency
    (Y-axis) versus active power output (X-axis) or versus discharge on the
    X-axis.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.HydroGeneratingEfficiencyCurves',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A hydro generating unit has an efficiency curve.
            '''

        })
    '''
    A hydro generating unit has an efficiency curve.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class IncrementalHeatRateCurve(Curve):
    '''
    Relationship between unit incremental heat rate in (delta energy/time)
    per (delta active power) and unit output in active power. The IHR curve
    represents the slope of the HeatInputCurve. Note that the "incremental
    heat rate" and the "heat rate" have the same engineering units.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''

        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''
    
@dataclass(repr=False)
class LevelVsVolumeCurve(Curve):
    '''
    Relationship between reservoir volume and reservoir level. The volume is
    at the Y-axis and the reservoir level at the X-axis.
    '''

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Reservoir.LevelVsVolumeCurves',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reservoir may have a level versus volume relationship.
            '''

        })
    '''
    A reservoir may have a level versus volume relationship.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class PenstockLossCurve(Curve):
    '''
    Relationship between penstock head loss (in meters) and total discharge
    through the penstock (in cubic meters per second). One or more turbines
    may be connected to the same penstock.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''

        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''

        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
@dataclass(repr=False)
class ReactiveCapabilityCurve(Curve):
    '''
    Reactive power rating envelope versus the synchronous machine's active
    power, in both the generating and motoring modes. For each active power
    value there is a corresponding high and low reactive power limit value.
    Typically there will be a separate curve for each coolant condition, such
    as hydrogen pressure. The Y1 axis values represent reactive minimum and
    the Y2 axis values represent reactive maximum.
    '''

    InitiallyUsedBySynchronousMachine: list[SynchronousMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SynchronousMachine.InitialReactiveCapabilityCurve',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Synchronous machines using this curve as default.
            '''
        
        })
    '''
    Synchronous machines using this curve as default.
    '''
    
    coolantTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The machine's coolant temperature (e.g., ambient air or stator circulating
            water).
            '''

        })
    '''
    The machine's coolant temperature (e.g., ambient air or stator circulating
    water).
    '''

    hydrogenPressure: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydrogen coolant pressure.
            '''

        })
    '''
    The hydrogen coolant pressure.
    '''

    referenceVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reference voltage for which the capability curve is valid.
            '''

        })
    '''
    The reference voltage for which the capability curve is valid.
    '''

    ExtendedWardEquivalent: Optional[ExtendedWardEquivalent] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ExtendedWardEquivalent.ReactiveCapabilityCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The extended ward equivalent using this reactive capability curve.
            '''

        })
    '''
    The extended ward equivalent using this reactive capability curve.
    '''

    SynchronousMachine: Optional[SynchronousMachine] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SynchronousMachine.ReactiveCapabilityCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The synchronous machine using this curve.
            '''

        })
    '''
    The synchronous machine using this curve.
    '''
    
@dataclass(repr=False)
class RecoveryOverloadLimitCurve(Curve):
    '''
    The relation between the recovery time and an overload limit.
    '''

    OperationalLimitType: list[OperationalLimitType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitType.RecoveryOverloadLimitCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit type which has recovery time characteristic.
            '''

        })
    '''
    The operational limit type which has recovery time characteristic.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class ShutdownCurve(Curve):
    '''
    Relationship between the rate in gross active power/minute (Y-axis) at
    which a unit should be shutdown and its present gross MW output (X-axis).
    '''

    shutdownDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The date and time of the most recent generating unit shutdown.
            '''

        })
    '''
    The date and time of the most recent generating unit shutdown.
    '''
    
    shutdownDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fixed shutdown cost.
            '''

        })
    '''
    Fixed shutdown cost.
    '''
    
    shutdownCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''

        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''

        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''
    
@dataclass(repr=False)
class SolarRadiationDependencyCurve(Curve):
    '''
    A curve or functional relationship between
    - the solar radiation independent variable (X-axis), and
    - relative dependent (Y-axis) variables.
    '''

    OperationalLimitType: list[OperationalLimitType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitType.PermanentSolarRadiationCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit type that has this permanent solar radiation curve.
            '''

        })
    '''
    The operational limit type that has this permanent solar radiation
    curve.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartIgnFuelCurve(Curve):
    '''
    The quantity of ignition fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    ignitionFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of ignition fuel.
            '''

        })
    '''
    Type of ignition fuel.
    '''
    
    ignitionFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartIgnFuelCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''

        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''

    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartIgnFuelCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''

        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartMainFuelCurve(Curve):
    '''
    The quantity of main fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    mainFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of main fuel.
            '''

        })
    '''
    Type of main fuel.
    '''
    
    mainFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartMainFuelCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''

        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''

    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartMainFuelCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''

        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartRampCurve(Curve):
    '''
    Rate in gross active power per minute (Y-axis) at which a unit can be loaded
    versus the number of hours (X-axis) the unit was off line.
    '''

    hotStandbyRamp: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The startup ramp rate in gross for a unit that is on hot standby.
            '''

        })
    '''
    The startup ramp rate in gross for a unit that is on hot standby.
    '''
    
    hotStandbyRamp: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartRampCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''

        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''

    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartRampCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''

        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''
    
@dataclass(repr=False)
class TailbayLossCurve(Curve):
    '''
    Relationship between tailbay head loss height (Y-axis) and the total discharge
    into the power station's tailbay volume per time unit (X-axis) . There
    could be more than one curve depending on the level of the tailbay reservoir
    or river level.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.TailbayLossCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A hydro generating unit has a tailbay loss curve.
            '''

        })
    '''
    A hydro generating unit has a tailbay loss curve.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class TargetLevelSchedule(Curve):
    '''
    Reservoir water level targets from advanced studies or "rule curves". Typically
    in one hour increments for up to 10 days.
    '''

    highLevelLimit: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            High target level limit, above which the reservoir operation will be penalized.
            '''

        })
    '''
    High target level limit, above which the reservoir operation will be
    penalized.
    '''
    
    highLevelLimit: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Low target level limit, below which the reservoir operation will be penalized.
            '''

        })
    '''
    Low target level limit, below which the reservoir operation will be
    penalized.
    '''
    
    lowLevelLimit: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Reservoir.TargetLevelSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''

        })
    '''
    A reservoir may have a water level target schedule.
    '''

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.TargetLevelSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''

        })
    '''
    A reservoir may have a water level target schedule.
    '''
    
@dataclass(repr=False)
class TimeCurrentCurve(Curve):
    '''
    Specialization of Curve class to restrict the usage to Time in the y-axis
    and CurrentFlow in the x-axis. Serves as base to many special use-cases,
    particularly in the protection coordination context.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConductorCharacteristicCurve(TimeCurrentCurve):
    '''
    Class to associate damage curves to conductors or to their datasheets.
    '''

    Conductor: list[Conductor] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Conductor.DamageCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A conductor can have a damage curve associated to it.
            '''

        })
    '''
    A conductor can have a damage curve associated to it.
    '''
    
@dataclass(repr=False)
class FuseCharacteristicCurve(TimeCurrentCurve):
    '''
    This class represents the characteristic curve of fuse.
    '''

    FuseInfoMinimumMelt: Optional[FuseInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseInfo.MinimumMeltCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            FuseInfo this curve is associated to.
            '''

        })
    '''
    FuseInfo this curve is associated to.
    '''
    
    FuseTotalClearing: Optional[Fuse] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Fuse.MiinimumMeltCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fuse this curve is associated to.
            '''

        })
    '''
    Fuse this curve is associated to.
    '''
    
    FuseInfoMinimumMelt: Optional[FuseInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Fuse.TotalClearingTimeCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fuse this curve is associated to.
            '''

        })
    '''
    Fuse this curve is associated to.
    '''

    FusInfoTotalClearing: Optional[FuseInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseInfo.TotalClearingTimeCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            FuseInfo this curve is associated to.
            '''

        })
    '''
    FuseInfo this curve is associated to.
    '''
    
    FuseInfoMinimumMelt: Optional[FuseInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Fuse.MiinimumMeltCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fuse this curve is associated to.
            '''

        })
    '''
    Fuse this curve is associated to.
    '''
    
    FuseMinimumMelt: Optional[Fuse] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Fuse.TotalClearingTimeCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fuse this curve is associated to.
            '''

        })
    '''
    Fuse this curve is associated to.
    '''
    
    FuseTotalClearing: Optional[Fuse] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseInfo.MinimumMeltCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            FuseInfo this curve is associated to.
            '''

        })
    '''
    FuseInfo this curve is associated to.
    '''

    FusInfoTotalClearing: Optional[FuseInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseInfo.TotalClearingTimeCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            FuseInfo this curve is associated to.
            '''

        })
    '''
    FuseInfo this curve is associated to.
    '''
    
@dataclass(repr=False)
class ProtectionOperationCharacteristicCurve(TimeCurrentCurve):
    '''
    This class expthe base class of characteristic curve of protection relay
    functions.
    '''

    ProtectionOperationCharacteristicType: Optional[ ProtectionOperationCharacteristicKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attributes means the type of protection operation characteristic curves.
            '''

        })
    '''
    This attributes means the type of protection operation characteristic
    curves.
    '''

    ProtectionFunctionBlock: Optional[ProtectionFunctionBlock] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ProtectionFunctionBlock.ProtectionOperationCharacteristicCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Several operation characteristic curves for protection are possessed by
            this ProtectionFunctionBlock.
            '''

        })
    '''
    Several operation characteristic curves for protection are possessed
    by this ProtectionFunctionBlock.
    '''
    
@dataclass(repr=False)
class TransformerCharacteristicCurve(TimeCurrentCurve):
    '''
    Class to associate damage or inrush curves (or points) to transformers
    or to their datasheets.
    '''

    transformerCurveType: Optional[ TransformerCharacteristicCurveKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class CustomerAgreement(IdentifiedObject):
    '''
    Agreement between the customer and the service supplier to pay for service
    at a specific service location. It records certain billing information
    about the type of service provided at the service location and is used
    during charge creation to determine the type of service.
    '''

    UsagePoints: list[UsagePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'UsagePoint.CustomerAgreement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All service delivery points regulated by this customer agreement.
            '''

        })
    '''
    All service delivery points regulated by this customer agreement.
    '''
    
@dataclass(repr=False)
class CutAction(IdentifiedObject):
    '''
    Action on cut as a switching step.
    '''

    Cut: Optional[Cut] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Cut.CutAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cut on which this action is taken.
            '''

        })
    '''
    Cut on which this action is taken.
    '''
    
@dataclass(repr=False)
class DCNode(IdentifiedObject):
    '''
    DC nodes are points where terminals of DC conducting equipment are connected
    together with zero impedance.
    '''

    DCPointOfCommonCoupling: Optional[DCPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCPointOfCommonCoupling.DCNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Identifies that this DC node is a point of common coupling DC.
            '''

        })
    '''
    Identifies that this DC node is a point of common coupling DC.
    '''
    
@dataclass(repr=False)
class DERDynamics(IdentifiedObject):
    '''
    Parent class supporting relationships to DER dynamics models.
    '''

    AsynchronousMachine: list[AsynchronousMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AsynchronousMachine.DERDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asynchronous machine model with which this DER dynamics model is associated.
            '''

        })
    '''
    Asynchronous machine model with which this DER dynamics model is associated.
    '''

    PowerElectronicsConnection: list[PowerElectronicsConnection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnection.DERDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power electronics connection with which this DER dynamics model is associated.
            '''

        })
    '''
    Power electronics connection with which this DER dynamics model is
    associated.
    '''

    SynchronousMachine: list[SynchronousMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SynchronousMachine.DERDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Synchronous machine model with which this DER dynamics model is associated.
            '''

        })
    '''
    Synchronous machine model with which this DER dynamics model is associated.
    '''
    
@dataclass(repr=False)
class DayType(IdentifiedObject):
    '''
    Group of similar days. For example it could be used to represent weekdays,
    weekend, or holidays.
    '''

    SeasonDayTypeSchedules: list[SeasonDayTypeSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SeasonDayTypeSchedule.DayType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Schedules that use this DayType.
            '''

        })
    '''
    Schedules that use this DayType.
    '''
    
@dataclass(repr=False)
class DesignElement(IdentifiedObject):
    '''
    An element of a design that places a compatible unit or an asset at a specific
    design location
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.DesignElement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An existing or future PSR affected by the conceptual design
            '''

        })
    '''
    An existing or future PSR affected by the conceptual design
    '''
    
@dataclass(repr=False)
class Dimension(IdentifiedObject):
    '''
    As applicable, the basic linear, area, or volume dimensions of an asset,
    asset type (AssetModel) or other type of object (such as land area). Units
    and multipliers are specified per dimension.
    '''

    ConstructedStructureInfo: list[StructureInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'StructureInfo.ConstructedDimensions',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class DimensionsInfo(IdentifiedObject):
    '''
    As applicable, the basic linear, area, or volume dimensions of an asset,
    asset type (AssetModel) or other type of object (such as land area). Units
    and multipliers are specified per dimension.
    '''

    TransportStructureInfo: list[StructureInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'StructureInfo.TransportDimensionsInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class EarthResistivity(IdentifiedObject):
    '''
    Resistance of earth (soil)
    '''

    earthModelType: Optional[ EarthModelKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration GridAPPSD Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    WireAssemblyInfos: list[WireAssemblyInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Geometry mean radius of a set of hypothetical conductors with same impedance
            as the earth return, per Carson's Equations
            '''

        })
    '''
    Geometry mean radius of a set of hypothetical conductors with same
    impedance as the earth return, per Carson's Equations
    '''
    
    earthModelType: Optional[ EarthModelKind ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    earthReturnGMR: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.EarthResistivity',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    rho: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireAssemblyInfo.EarthResistivity',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class EnergyArea(IdentifiedObject):
    '''
    Describes an area having energy production or consumption. Specializations
    are intended to support the load allocation function as typically required
    in energy management systems or planning studies to allocate hypothesized
    load levels to individual load points for power flow analysis. Often the
    energy area can be linked to both measured and forecast load levels.
    '''

    ControlArea: Optional[ControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlArea.EnergyArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The control area specification that is used for the load forecast.
            '''

        })
    '''
    The control area specification that is used for the load forecast.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class LoadArea(EnergyArea):
    '''
    The class is the root or first level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    SubLoadAreas: list[SubLoadArea] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SubLoadArea.LoadArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SubLoadAreas in the LoadArea.
            '''

        })
    '''
    The SubLoadAreas in the LoadArea.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class SubLoadArea(EnergyArea):
    '''
    The class is the second level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    LoadArea: Optional[LoadArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'LoadArea.SubLoadAreas',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The LoadArea where the SubLoadArea belongs.
            '''

        })
    '''
    The LoadArea where the SubLoadArea belongs.
    '''
    
    LoadArea: Optional[LoadArea] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LoadGroup.SubLoadArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Loadgroups in the SubLoadArea.
            '''

        })
    '''
    The Loadgroups in the SubLoadArea.
    '''
    
@dataclass(repr=False)
class EnergyConsumerAction(IdentifiedObject):
    '''
    Action to connect or disconnect the Energy Consumer from its Terminal
    '''

    EnergyConsumer: Optional[EnergyConsumer] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumer.EnergyConsumerAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class EnergySchedulingType(IdentifiedObject):
    '''
    Used to define the type of generation for scheduling purposes.
    '''

    EnergySource: list[EnergySource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergySource.EnergySchedulingType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Energy Source of a particular Energy Scheduling Type.
            '''

        })
    '''
    Energy Source of a particular Energy Scheduling Type.
    '''
    
@dataclass(repr=False)
class EnergySourceAction(IdentifiedObject):
    '''
    Action on energy source as a switching step.
    '''

    EnergySource: Optional[EnergySource] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergySource.EnergySourceAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Energy source on which this action is taken.
            '''

        })
    '''
    Energy source on which this action is taken.
    '''
    
@dataclass(repr=False)
class EnvironmentalMonitoringStation(IdentifiedObject):
    '''
    An environmental monitoring station, examples of which could be a weather
    station or a seismic monitoring station.
    '''

    UsagePoint: list[UsagePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'UsagePoint.EnvironmentalMonitoringStation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class FossilFuel(IdentifiedObject):
    '''
    The fossil fuel consumed by the non-nuclear thermal generating unit. For
    example, coal, oil, gas, etc. These are the specific fuels that the generating
    unit can consume.
    '''

    FuelAllocationSchedules: list[FuelAllocationSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FuelAllocationSchedule.FossilFuel',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A fuel allocation schedule shall have a fossil fuel.
            '''
        
        })
    '''
    A fuel allocation schedule shall have a fossil fuel.
    '''
    
    fuelHeatContent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The amount of heat per weight (or volume) of the given type of fuel.
            '''

        })
    '''
    The amount of heat per weight (or volume) of the given type of fuel.
    '''

    fossilFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of fossil fuel, such as coal, oil, or gas.
            '''

        })
    '''
    The type of fossil fuel, such as coal, oil, or gas.
    '''

    fuelCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The cost in terms of heat value for the given type of fuel.
            '''

        })
    '''
    The cost in terms of heat value for the given type of fuel.
    '''

    fuelDispatchCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The cost of fuel used for economic dispatching which includes: fuel cost,
            transportation cost, and incremental maintenance cost.
            '''

        })
    '''
    The cost of fuel used for economic dispatching which includes: fuel
    cost, transportation cost, and incremental maintenance cost.
    '''

    fuelEffFactor: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The efficiency factor for the fuel (per unit) in terms of the effective
            energy absorbed.
            '''

        })
    '''
    The efficiency factor for the fuel (per unit) in terms of the effective
    energy absorbed.
    '''

    fuelHandlingCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Handling and processing cost associated with this fuel.
            '''

        })
    '''
    Handling and processing cost associated with this fuel.
    '''

    fuelMixture: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Relative amount of the given type of fuel, when multiple fuels are being
            consumed.
            '''

        })
    '''
    Relative amount of the given type of fuel, when multiple fuels are
    being consumed.
    '''

    fuelSulfur: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The fuel's fraction of pollution credit per unit of heat content.
            '''

        })
    '''
    The fuel's fraction of pollution credit per unit of heat content.
    '''

    highBreakpointP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The active power output level of the unit at which the given type of fuel
            is switched on. This fuel (e.g., oil) is sometimes used to supplement the
            base fuel (e.g., coal) at high active power output levels.
            '''

        })
    '''
    The active power output level of the unit at which the given type of
    fuel is switched on. This fuel (e.g., oil) is sometimes used to supplement
    the base fuel (e.g., coal) at high active power output levels.
    '''

    lowBreakpointP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The active power output level of the unit at which the given type of fuel
            is switched off. This fuel (e.g., oil) is sometimes used to stabilize the
            base fuel (e.g., coal) at low active power output levels.
            '''

        })
    '''
    The active power output level of the unit at which the given type of
    fuel is switched off. This fuel (e.g., oil) is sometimes used to stabilize
    the base fuel (e.g., coal) at low active power output levels.
    '''

    FuelStorage: Optional[FuelStorage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuelStorage.FossilFuel',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fuel storage that store fossil fuels.
            '''

        })
    '''
    Fuel storage that store fossil fuels.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.FossilFuels',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more fossil fuels.
            '''

        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class FunctionBlock(IdentifiedObject):
    '''
    Function block is a function described as a set of elementary blocks. The
    blocks describe the function between input variables and output variables.
    '''

    enabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True, if the function block is enabled (active). Otherwise false.
            '''

        })
    '''
    True, if the function block is enabled (active). Otherwise false.
    '''
    
    SourceSideLink: list[FunctionFunctionLink] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True, if the function block is normally enabled (active). Otherwise false.
            '''

        })
    '''
    True, if the function block is normally enabled (active). Otherwise
    false.
    '''
    
    Input: list[FunctionInputVariable] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AutomationBlockGroup.FunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Automation block group which has function blocks.
            '''

        })
    '''
    Automation block group which has function blocks.
    '''
    
    FunctionOutputVariable: list[FunctionOutputVariable] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AutomationFunction.FunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Automation function describe automation that this function block is part
            of.
            '''

        })
    '''
    Automation function describe automation that this function block is
    part of.
    '''
    
    enabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FunctionBlockType.FunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            FunctionBlockType defining the behaviour inputs and outputs of generic
            FunctionBlock.
            '''

        })
    '''
    FunctionBlockType defining the behaviour inputs and outputs of generic
    FunctionBlock.
    '''
    
    normalEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionFunctionLink.DestinationFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            FunctionFunctionLink providing a function block input from another function
            block output.
            '''

        })
    '''
    FunctionFunctionLink providing a function block input from another
    function block output.
    '''
    
    AutomationBlockGroup: Optional[AutomationBlockGroup] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionFunctionLink.SourceFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            FunctionFunctionLink providing a function block output to another function
            block as input.
            '''

        })
    '''
    FunctionFunctionLink providing a function block output to another function
    block as input.
    '''
    
    AutomationFunction: Optional[AutomationFunction] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionInputVariable.Function',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Function input variable describe the input or domain to the function block.
            '''

        })
    '''
    Function input variable describe the input or domain to the function
    block.
    '''
    
    FunctionBlockType: Optional[FunctionBlockType] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionOutputVariable.FunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Function output variable describe the output or codomain to the function
            block.
            '''

        })
    '''
    FunctionBlockType defining the behaviour inputs and outputs of generic
    FunctionBlock.
    '''
    
@dataclass(repr=False)
class BooleanLogic(FunctionBlock):
    '''
    Specialization of FunctionBlock class intended to define a boolean logic
    gate. Its inputs should be specified by FunctionFunctionLink instances.
    If the comparisonValue attribute is defined, operate against the comparisonValue
    (same number of inputs as outputs).
    '''

    comparisonValue: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If provided, compare all inputs against this value and provide as many
            outputs. Inputs and outputs should be defined by FunctionFunctionLink instances
            if the inputs are coming or going to other FunctionBlock instances.
            '''

        })
    '''
    If provided, compare all inputs against this value and provide as many
    outputs. Inputs and outputs should be defined by FunctionFunctionLink
    instances if the inputs are coming or going to other FunctionBlock
    instances.
    '''

    gateLogicType: Optional[ GateLogicKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of boolean gate.
            '''

        })
    '''
    Type of boolean gate.
    '''
    
@dataclass(repr=False)
class ConstantFunctionBlock(FunctionBlock):
    '''
    Class to define a function block containing a constant value. A FunctionBlockType
    should be associated along with a FunctionLogicDescription with an specified
    language attribute. The typeConstant attribute should be aligned with available
    data types in the chosen programing language.
    '''

    nameConstant: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name of the constant.
            '''

        })
    '''
    Name of the constant.
    '''

    typeConstant: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Defined the data type of the value in this constant. Should be aligned
            with available data types in the chosen programing language.
            '''

        })
    '''
    Defined the data type of the value in this constant. Should be aligned
    with available data types in the chosen programing language.
    '''

    valueConstant: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value attached to the constant.
            '''

        })
    '''
    Value attached to the constant.
    '''
    
@dataclass(repr=False)
class ControlFunctionBlock(FunctionBlock):
    '''
    Control function block is a function block that contains an algorithm for
    controlling the equipment.
    '''

    isDiscrete: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True, if the control function is discrete. This applies to equipment with
            discrete controls, e.g. tap changers and shunt compensators.
            '''

        })
    '''
    True, if the control function is discrete. This applies to equipment
    with discrete controls, e.g. tap changers and shunt compensators.
    '''

    targetDeadband: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target deadband is used with discrete control to avoid excessive update
            of controls like tap changers and shunt compensator banks while regulating.
            The attribute shall be a positive value or zero. If isDiscrete is set to
            "false", the targetDeadband is to be ignored.
            Note that for instance, if the targetValue is 100 kV and the targetDeadband
            is 2 kV the range is from 99 to 101 kV.
            '''

        })
    '''
    Target deadband is used with discrete control to avoid excessive update
    of controls like tap changers and shunt compensator banks while regulating.
    The attribute shall be a positive value or zero. If isDiscrete is set
    to "false", the targetDeadband is to be ignored.
    Note that for instance, if the targetValue is 100 kV and the targetDeadband
    is 2 kV the range is from 99 to 101 kV.
    '''

    maxAllowedTargetValue: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum allowed target value given by the percent of target value.
            The allowed value range is [0,100].
            '''

        })
    '''
    Maximum allowed target value given by the percent of target value.
    The allowed value range is [0,100].
    '''

    minAllowedTargetValue: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum allowed target value given by the percent of target value.
            The allowed value range is [0,100].
            '''

        })
    '''
    Minimum allowed target value given by the percent of target value.
    The allowed value range is [0,100].
    '''

    normalMaxAllowedTargetValue: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal maximum allowed target value given by the percent of target value.
            The allowed value range is [0,100].
            '''

        })
    '''
    Normal maximum allowed target value given by the percent of target
    value.
    The allowed value range is [0,100].
    '''

    normalMinAllowedTargetValue: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal minimum allowed target value given by the percent of target value.
            The allowed value range is [0,100].
            '''

        })
    '''
    Normal minimum allowed target value given by the percent of target
    value.
    The allowed value range is [0,100].
    '''
    
@dataclass(repr=False)
class ACEmulationControlFunction(ControlFunctionBlock):
    '''
    The AC emulation control function is used when AC emulation model is activated
    for a DC system. It consists in computing the active power set point of
    the DC system as a function of the voltage angle difference between both
    points of common coupling with the AC network in order to mimic the behavior
    of an AC transmission line. This control mode enables the automatic adjustment
    of the active power reference following variations of the AC system operational
    point.
    The setpoint of the DC system is calculated by Psetpoint=Pref+Kdc*(angle1-angle2),
    where
    - Pref is the existing active power setpoint;
    - Kdc is the control system gain and
    - angle1 and angle2 are the phase angle measurement (measured at points
    of common coupling with the AC network) respectively at the side 1 and
    2 of the DC system.
    '''

    gain: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Control system gain in AC transmission emulation control measured in MW/deg.
            It plays the role of an admittance of the equivalent AC transmission line
            that the control is emulating the higher is the gain the higher is the
            active power transfer at steady state.
            '''

        })
    '''
    Control system gain in AC transmission emulation control measured in
    MW/deg. It plays the role of an admittance of the equivalent AC transmission
    line that the control is emulating the higher is the gain the higher
    is the active power transfer at steady state.
    '''

    referenceP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Existing active power setpoint used to calculate the active power setpoint
            of the AC emulation control.
            '''

        })
    '''
    Existing active power setpoint used to calculate the active power setpoint
    of the AC emulation control.
    '''

    timeConstant: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Control system time constant in AC transmission emulation control. It affects
            the time needed to
            reach a new steady state equilibrium point after a network perturbation
            extremely important to guarantee N-1 relief related to an interconnection.
            The higher is time constant the slower is the DC system dynamic.
            '''

        })
    '''
    Control system time constant in AC transmission emulation control.
    It affects the time needed to
    reach a new steady state equilibrium point after a network perturbation
    extremely important to guarantee N-1 relief related to an interconnection.
    The higher is time constant the slower is the DC system dynamic.
    '''
    
@dataclass(repr=False)
class ActivePowerControlFunction(ControlFunctionBlock):
    '''
    Active power control function is a function block that calculates operating
    point of the controlled equipment to achieve the target active power.
    '''

    targetValue: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for the active power that the control function is calculating
            to achieve by adjusting the operational setting to the controlled equipment.
            '''

        })
    '''
    Target value for the active power that the control function is calculating
    to achieve by adjusting the operational setting to the controlled equipment.
    '''
    
@dataclass(repr=False)
class CurrentControlFunction(ControlFunctionBlock):
    '''
    Current control function is a function block that calculates the operating
    point of the controlled equipment to achieve the target current.
    '''

    targetValue: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for the current that the control function is calculating to
            achieve by adjusting the operational setting to the controlled equipment.
            '''

        })
    '''
    Target value for the current that the control function is calculating
    to achieve by adjusting the operational setting to the controlled equipment.
    '''
    
@dataclass(repr=False)
class DCCurrentControlFunction(ControlFunctionBlock):
    '''
    DC current control function is a function block that calculates the operating
    point of the controlled equipment to achieve the target current.
    '''

    droop: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Droop constant. The pu value is obtained as D [kV/MW] x Sb / Ubdc. The
            attribute shall be a positive value.
            '''

        })
    '''
    Droop constant. The pu value is obtained as D [kV/MW] x Sb / Ubdc.
    The attribute shall be a positive value.
    '''

    droopCompensation: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Compensation constant. Used to compensate for voltage drop when controlling
            voltage at a distant bus. The attribute shall be a positive value.
            '''

        })
    '''
    Compensation constant. Used to compensate for voltage drop when controlling
    voltage at a distant bus. The attribute shall be a positive value.
    '''

    targetValue: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for the current that the control function is calculating to
            achieve by adjusting the operational setting to the controlled equipment.
            '''

        })
    '''
    Target value for the current that the control function is calculating
    to achieve by adjusting the operational setting to the controlled equipment.
    '''
    
@dataclass(repr=False)
class DCVoltageControlFunction(ControlFunctionBlock):
    '''
    DC voltage control function is a function block that calculate the operating
    point of the controlled equipment to achieve the target voltage.
    '''

    targetValue: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for the voltage that the control function is calculating to
            achieve by adjusting the operational setting to the controlled equipment.
            '''

        })
    '''
    Target value for the voltage that the control function is calculating
    to achieve by adjusting the operational setting to the controlled equipment.
    '''
    
@dataclass(repr=False)
class FrequencyControlFunction(ControlFunctionBlock):
    '''
    Frequency control function is a function block that calculate the operating
    point of the controlled equipment to achieve the target frequency.
    '''

    frequencyBias: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for the active power that the control function is calculating
            to achieve by adjusting the operational setting to the controlled equipment.
            '''

        })
    '''
    Target value for the active power that the control function is calculating
    to achieve by adjusting the operational setting to the controlled equipment.
    '''

    targetValue: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for the frequency that the control function is calculating
            to achieve by adjusting the operational setting to the controlled equipment.
            '''

        })
    '''
    Target value for the frequency that the control function is calculating
    to achieve by adjusting the operational setting to the controlled equipment.
    '''
    
@dataclass(repr=False)
class ImpedanceControlFunction(ControlFunctionBlock):
    '''
    Impedance control function is a function block that calculates the operating
    point of the controlled equipment to achieve the target impedance.
    '''

    targetValue: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for the impedance that the control function is calculating
            to achieve by adjusting the operational setting to the controlled equipment.
            '''

        })
    '''
    Target value for the impedance that the control function is calculating
    to achieve by adjusting the operational setting to the controlled equipment.
    '''
    
@dataclass(repr=False)
class PhaseControlFunction(ControlFunctionBlock):
    '''
    Phase control function is a function block that calculate the operating
    point of the controlled equipment to achieve the target voltage.
    '''

    targetValue: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for the phase that the control function is calculating to
            achieve by adjusting the operational setting to the controlled equipment.
            '''

        })
    '''
    Target value for the phase that the control function is calculating
    to achieve by adjusting the operational setting to the controlled equipment.
    '''
    
@dataclass(repr=False)
class PowerFactorControlFunction(ControlFunctionBlock):
    '''
    Power factor control function is a function block that calculates the operating
    point of the controlled equipment to achieve the target power factor.
    '''

    targetValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for the power factor that the control function is calculating
            to achieve by adjusting the operational setting to the controlled equipment.
            '''

        })
    '''
    Target value for the power factor that the control function is calculating
    to achieve by adjusting the operational setting to the controlled equipment.
    '''
    
@dataclass(repr=False)
class ReactivePowerControlFunction(ControlFunctionBlock):
    '''
    Reactive power control function is a function block that calculate the
    operating point of the controlled equipment to achieve the target reactive
    power.
    '''

    targetValue: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for the reactive power that the control function is calculating
            to achieve by adjusting the operational setting to the controlled equipment.
            '''

        })
    '''
    Target value for the reactive power that the control function is calculating
    to achieve by adjusting the operational setting to the controlled equipment.
    '''
    
@dataclass(repr=False)
class VoltageControlFunction(ControlFunctionBlock):
    '''
    Voltage control function is a function block that calculate the operating
    point of the controlled equipment to achieve the target voltage.
    '''

    targetValue: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for the voltage that the control function is calculating to
            achieve by adjusting the operational setting to the controlled equipment.
            '''

        })
    '''
    Target value for the voltage that the control function is calculating
    to achieve by adjusting the operational setting to the controlled equipment.
    '''
    
@dataclass(repr=False)
class DelayTimer(FunctionBlock):
    '''
    Class to define a DelayTimer. Behavior matches that of the On Delay Timer
    and Off Delay Timer standard function blocks from IEC 61131-3.
    '''

    onDelayTimer: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Set to True (or leave undefined) to tell if the timer's output is to be
            turned ON after delay. Otherwise, assume the timer's output is to be turned
            OFF after the delay.
            '''

        })
    '''
    Set to True (or leave undefined) to tell if the timer's output is to
    be turned ON after delay. Otherwise, assume the timer's output is to
    be turned OFF after the delay.
    '''

    delay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class EdgeDetector(FunctionBlock):
    '''
    Class to define an Edge detector. Similar to the R_TRIG and F_TRIG standard
    function blocks from IEC 61131-3.
    '''

    risingEdge: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Set to True (or leave undefined) to model a rising edge detector. Otherwise,
            this is a falling edge detector.
            '''

        })
    '''
    Set to True (or leave undefined) to model a rising edge detector. Otherwise,
    this is a falling edge detector.
    '''
    
@dataclass(repr=False)
class FlipFlop(FunctionBlock):
    '''
    Class to define a Flipflop. Behavior matches that of the SR or RS Bistable
    standard function blocks from IEC 61131-3.
    '''

    setDominant: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Set to True (or leave undefined) to model a Set-dominant bi-stable. Otherwise,
            this is a Reset-dominant bi-stable.
            '''

        })
    '''
    Set to True (or leave undefined) to model a Set-dominant bi-stable.
    Otherwise, this is a Reset-dominant bi-stable.
    '''
    
@dataclass(repr=False)
class LogicalOperation(FunctionBlock):
    '''
    Specialization of FunctionBlock class intended to define a logical operation.
    Its inputs should be specified by FunctionFunctionLink instances. If the
    comparisonValue attribute is defined, operate against the comparisonValue
    (same number of inputs as outputs).
    '''

    comparisonValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If provided, compare all inputs against this value and provide as many
            outputs. Inputs and outputs should be defined by FunctionFunctionLink instances
            if the inputs are coming or going to other FunctionBlock instances.
            '''

        })
    '''
    If provided, compare all inputs against this value and provide as many
    outputs. Inputs and outputs should be defined by FunctionFunctionLink
    instances if the inputs are coming or going to other FunctionBlock
    instances.
    '''

    operationType: Optional[ LogicalOperatorsKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of logic operation.
            '''

        })
    '''
    Type of logic operation.
    '''
    
@dataclass(repr=False)
class NumericOperation(FunctionBlock):
    '''
    Class to represent a numerical operation.
    '''

    numericOperationType: Optional[ CalculationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ProtectionFunctionBlock(FunctionBlock):
    '''
    Protection function block is a function block that contains an algorithm
    for protecting the equipment.
    '''

    ProprietarySettingValue: list[ProprietarySettingValue] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProprietarySettingValue.ProtectionFunctionBlock',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Application-specific setting value may be possessed by this ProtectionFunctionBlock.
            '''
        
        })
    '''
    Application-specific setting value may be possessed by this ProtectionFunctionBlock.
    '''
    
    ProtectionOperationCharacteristicCurve: list[ProtectionOperationCharacteristicCurve] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionOperationCharacteristicCurve.ProtectionFunctionBlock',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Protection function block may have several operation characteristic curves
            for protection.
            '''
        
        })
    '''
    Protection function block may have several operation characteristic
    curves for protection.
    '''
    
    usage: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attributes means the usage of protection relay functions.
            For example, one of transmission line protection scheme consists of distance
            relay functions and each distance relay is used for detecting short circuit
            and grounding.
            This attribute should be used when users would like to represent the usage
            of protection relay functions.
            '''

        })
    '''
    This attributes means the usage of protection relay functions.
    For example, one of transmission line protection scheme consists of
    distance relay functions and each distance relay is used for detecting
    short circuit and grounding.
    This attribute should be used when users would like to represent the
    usage of protection relay functions.
    '''

    operateDelaytime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attributes means the operate delay time which is defined in Clause
            3 of IEC 60225-181 and so on.
            &lt;&lt;IEC 60255-181 Ed. 1.0&gt;&gt;
            3 Terms and definition
            3.9 operate delay time
            operate delay time
            Intentional time delay defined by a user setting which is activated by
            the start signal to assert the operate signal.
            '''

        })
    '''
    This attributes means the operate delay time which is defined in Clause
    3 of IEC 60225-181 and so on.
    &lt;&lt;IEC 60255-181 Ed. 1.0&gt;&gt;
    3 Terms and definition
    3.9 operate delay time
    operate delay time
    Intentional time delay defined by a user setting which is activated
    by the start signal to assert the operate signal.
    '''

    operateTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attributes means the operate time which is defined in Clause 3 of
            IEC 60225-181 and so on.
            &lt;&lt;IEC 60255-181 Ed. 1.0&gt;&gt;
            3 Terms and definition
            3.7 start time
            operate time
            time interval between the instant a specified change is made in the value(s)
            of the input energizing quantity(ies) which will cause the measuring relay
            or protection equipment in initial condition or reset condition to operate
            and the instant it operates.
            '''

        })
    '''
    This attributes means the operate time which is defined in Clause 3
    of IEC 60225-181 and so on.
    &lt;&lt;IEC 60255-181 Ed. 1.0&gt;&gt;
    3 Terms and definition
    3.7 start time
    operate time
    time interval between the instant a specified change is made in the
    value(s) of the input energizing quantity(ies) which will cause the
    measuring relay or protection equipment in initial condition or reset
    condition to operate and the instant it operates.
    '''

    operatingQuantityType: Optional[ ProtectionOperatingQuantityKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Attribute to specify an operating quantity when the phases attribute is
            defined as ABC. Required for current and voltage protection function blocks
            to clearly identify which quantity to operate on.
            '''

        })
    '''
    Attribute to specify an operating quantity when the phases attribute
    is defined as ABC. Required for current and voltage protection function
    blocks to clearly identify which quantity to operate on.
    '''

    phases: Optional[ PhaseCodeProtection ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Operating phase quantities. If ABC, operatingQuantityType must be specified
            for voltage and current elements to precise the operating quantity.
            '''

        })
    '''
    Operating phase quantities. If ABC, operatingQuantityType must be specified
    for voltage and current elements to precise the operating quantity.
    '''

    resetDelayTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    resetTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attributes means the operate delay time which is defined in Clause
            3 of IEC 60225-181 and so on.
            &lt;&lt;IEC 60255-181 Ed. 1.0&gt;&gt;
            3 Terms and definition
            3.11 reset time
            reset time
            duration between the instant a specified change is made in the value(s)
            of the input
            energizing quantity(ies) which will cause the measuring relay or protection
            equipment to reset and the instant it resets
            '''

        })
    '''
    This attributes means the operate delay time which is defined in Clause
    3 of IEC 60225-181 and so on.
    &lt;&lt;IEC 60255-181 Ed. 1.0&gt;&gt;
    3 Terms and definition
    3.11 reset time
    reset time
    duration between the instant a specified change is made in the value(s)
    of the input
    energizing quantity(ies) which will cause the measuring relay or protection
    equipment to reset and the instant it resets
    '''

    startTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attributes means the start time which is defined in Clause 3 of IEC
            60225-181 and so on.
            &lt;&lt;IEC 60255-181 Ed. 1.0&gt;&gt;
            3 Terms and definition
            3.7 start time
            time interval between the instant a specified change is made in the value(s)
            of the input energizing quantity(ies) which will cause the measuring relay
            or protection equipment in initial condition or reset condition to start
            and the instant it starts
            '''

        })
    '''
    This attributes means the start time which is defined in Clause 3 of
    IEC 60225-181 and so on.
    &lt;&lt;IEC 60255-181 Ed. 1.0&gt;&gt;
    3 Terms and definition
    3.7 start time
    time interval between the instant a specified change is made in the
    value(s) of the input energizing quantity(ies) which will cause the
    measuring relay or protection equipment in initial condition or reset
    condition to start and the instant it starts
    '''

    MonitoredTerminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.ProtectionFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminal is monitored by multiple protection function blocks.
            '''

        })
    '''
    The terminal is monitored by multiple protection function blocks.
    '''

    ProtectionEquipment: Optional[ProtectionEquipment] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ProtectionEquipment.ProtectionFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Protection equipment may contain protection function blocks.
            '''

        })
    '''
    Protection equipment may contain protection function blocks.
    '''

    ProtectionSettingsGroup: Optional[ProtectionSettingsGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ProtectionSettingsGroup.ProtectionFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            ProtectionSettingsGroup can combine setting values possessed by several
            instances of ProtectionFunctionBlocks that constitutes a certain protection
            function.
            '''

        })
    '''
    ProtectionSettingsGroup can combine setting values possessed by several
    instances of ProtectionFunctionBlocks that constitutes a certain protection
    function.
    '''
    
@dataclass(repr=False)
class FaultClearanceProtectionFunctionBlock(ProtectionFunctionBlock):
    '''
    This class is the base class of protection function blocks for fault clearance.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CurrentProtectionFunctionBlock(FaultClearanceProtectionFunctionBlock):
    '''
    This class is the base class of current relay function.
    '''

    operateValue: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class OverCurrentProtectionFunctionBlock(CurrentProtectionFunctionBlock):
    '''
    This class represents a function for over current protection.
    '''

    currentValueMultiplier: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Current value multiplier setting for time over current curves.
            '''

        })
    '''
    Current value multiplier setting for time over current curves.
    '''

    timeDial: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Time dial setting for time over current curves.
            '''

        })
    '''
    Time dial setting for time over current curves.
    '''

    timeValueMultiplier: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Additional time multiplier setting for time over current curves.
            '''

        })
    '''
    Additional time multiplier setting for time over current curves.
    '''

    currentValueAdder: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Current value adder setting for time over current curves.
            '''

        })
    '''
    Current value adder setting for time over current curves.
    '''

    timeValueAdder: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Time adder setting for time over current curves.
            '''

        })
    '''
    Time adder setting for time over current curves.
    '''

    OverCurrentTypeFunctionBlock: Optional[OverCurrentTypeFunctionBlock] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OverCurrentTypeFunctionBlock.OverCurrentProtectionFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiple over current protection functions compose the over current type
            of over load protection function.
            '''

        })
    '''
    Multiple over current protection functions compose the over current
    type of over load protection function.
    '''
    
@dataclass(repr=False)
class UnderCurrentProtectionFunctionBlock(CurrentProtectionFunctionBlock):
    '''
    This class represents a function for under current protection.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DifferentialProtectionFuntionBlock(FaultClearanceProtectionFunctionBlock):
    '''
    This class represents a function for differential protection and has some
    attributes based on IEC 60255-187-1.
    '''

    highOperatingValue: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute means the high setting of differential current in IEC 60255-187-1.
            '''

        })
    '''
    This attribute means the high setting of differential current in IEC
    60255-187-1.
    '''

    lowOperatingValue: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute means the low setting of differential current in IEC 60255-187-1.
            '''

        })
    '''
    This attribute means the low setting of differential current in IEC
    60255-187-1.
    '''

    nominalCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute may be necessaty when converting the operate value to percent
            notation instead of current.
            '''

        })
    '''
    This attribute may be necessaty when converting the operate value to
    percent notation instead of current.
    '''

    slopeValue1: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attributes mean the slope between first break point of restraining
            current to second break point of ones.
            '''

        })
    '''
    This attributes mean the slope between first break point of restraining
    current to second break point of ones.
    '''

    slopeValue1BreakPoint: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The break point of slopeValue1.
            '''

        })
    '''
    The break point of slopeValue1.
    '''

    slopeValue2: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attributes mean the slope between second break point of restraining
            current to high setting point of differential current.
            '''

        })
    '''
    This attributes mean the slope between second break point of restraining
    current to high setting point of differential current.
    '''

    slopeValue2BreakPoint: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The break point of slopeValue2.
            '''

        })
    '''
    The break point of slopeValue2.
    '''
    
@dataclass(repr=False)
class DirectionalProtectionFunctionBlock(FaultClearanceProtectionFunctionBlock):
    '''
    This class is the base class of directional relay function.
    '''

    directionType: Optional[ DirectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class OverPowerDirectionProtectionFunctionBlock(DirectionalProtectionFunctionBlock):
    '''
    This class represents a function for over power direction protection.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class UnderPowerDirectionProtectionFunctionBlock(DirectionalProtectionFunctionBlock):
    '''
    This class represents a function for under power direction protection.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DistanceProtectionFunctionBlock(FaultClearanceProtectionFunctionBlock):
    '''
    This class represents a function for distance protection.
    '''

    generalOffset: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents offset from zero for analog value for all setting
            values in distance relay function and can be mapped onto "Ofs" of PDIS
            in IEC 61850-7-4 Ed. 2.1.
            '''

        })
    '''
    This attribute represents offset from zero for analog value for all
    setting values in distance relay function and can be mapped onto "Ofs"
    of PDIS in IEC 61850-7-4 Ed. 2.1.
    '''

    characteristicAngle: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents the line/feeder impedance angle and can be mapped
            onto "LinAng" of PDIS in IEC 61850-7-4 Ed. 2.1.
            '''

        })
    '''
    This attribute represents the line/feeder impedance angle and can be
    mapped onto "LinAng" of PDIS in IEC 61850-7-4 Ed. 2.1.
    '''

    directionOperatePhaseAngle1: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents characteristic angle measured counter clockwise
            from the positive R-axis.
            '''

        })
    '''
    This attribute represents characteristic angle measured counter clockwise
    from the positive R-axis.
    '''

    directionOperatePhaseAngle2: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents characteristic angle measured clockwise from
            the positive R-axis.
            '''

        })
    '''
    This attribute represents characteristic angle measured clockwise from
    the positive R-axis.
    '''

    loadAreaAngle: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents angle setting for load area and can be mapped
            onto "AngLod" of PDIS in IEC 61850-7-4 Ed. 2.1.
            '''

        })
    '''
    This attribute represents angle setting for load area and can be mapped
    onto "AngLod" of PDIS in IEC 61850-7-4 Ed. 2.1.
    '''

    loadAreaReachValue: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents resistive reach for load area and can be mapped
            onto "RisLod" of PDIS in IEC 61850-7-4 Ed. 2.1.
            '''

        })
    '''
    This attribute represents resistive reach for load area and can be
    mapped onto "RisLod" of PDIS in IEC 61850-7-4 Ed. 2.1.
    '''

    mhoOffsetValue: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents distance characteristic offset related to the
            line length and can be mapped onto "PctOfs" of PDIS in IEC 61850-7-4 Ed.
            2.1.
            '''

        })
    '''
    This attribute represents distance characteristic offset related to
    the line length and can be mapped onto "PctOfs" of PDIS in IEC 61850-7-4
    Ed. 2.1.
    '''

    mhoPolarReachValue: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents polar reach related to line length, i.e. the
            diameter of the Mho diagram, and can be mapped onto "PoRch" of PDIS in
            IEC 61850-7-4 Ed. 2.1.
            '''

        })
    '''
    This attribute represents polar reach related to line length, i.e.
    the diameter of the Mho diagram, and can be mapped onto "PoRch" of
    PDIS in IEC 61850-7-4 Ed. 2.1.
    '''

    mhoReachValue: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents distance characteristic reach related to the
            line length and can be mapped onto "PctRch" of PDIS in IEC 61850-7-4 Ed.
            2.1.
            '''

        })
    '''
    This attribute represents distance characteristic reach related to
    the line length and can be mapped onto "PctRch" of PDIS in IEC 61850-7-4
    Ed. 2.1.
    '''

    reactanceReachValue: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents positive sequence line reactance and can be mapped
            onto "X1" of PDIS in IEC 61850-7-4 Ed. 2.1.
            '''

        })
    '''
    This attribute represents positive sequence line reactance and can
    be mapped onto "X1" of PDIS in IEC 61850-7-4 Ed. 2.1.
    '''

    ImpedanceLocusTypeFunctionBlock: Optional[ImpedanceLocusTypeFunctionBlock] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ImpedanceLocusTypeFunctionBlock.DistanceProtectionFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Impedance locus type of out-of-step relay function is composed by multiple
            distance relay elements.
            '''

        })
    '''
    Impedance locus type of out-of-step relay function is composed by multiple
    distance relay elements.
    '''
    
@dataclass(repr=False)
class GroundDistanceProtectionFunctionBlock(DistanceProtectionFunctionBlock):
    '''
    This class represents a function for ground distance protection.
    '''

    residualCompensationFactorMagnitude: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents the magnitude of the mutual coupling compensation
            factor. It can be mapped onto "K0Fact" of PDIS in IEC 61850-7-4 Ed. 2.1.
            '''

        })
    '''
    This attribute represents the magnitude of the mutual coupling compensation
    factor. It can be mapped onto "K0Fact" of PDIS in IEC 61850-7-4 Ed.
    2.1.
    '''

    residualCompensationFactorAngle: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute represents the angle of the mutual coupling compensation
            factor. It can be mapped onto "K0FactAng" of PDIS in IEC 61850-7-4 Ed.
            2.1.
            '''

        })
    '''
    This attribute represents the angle of the mutual coupling compensation
    factor. It can be mapped onto "K0FactAng" of PDIS in IEC 61850-7-4
    Ed. 2.1.
    '''
    
@dataclass(repr=False)
class VoltageProtectionFunctionBlock(FaultClearanceProtectionFunctionBlock):
    '''
    This class is the base class of voltage relay function.
    '''

    operateValue: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class OverVoltageProtectionFunctionBlock(VoltageProtectionFunctionBlock):
    '''
    This class represents a function for over voltage protection.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class UnderVoltageProtectionFunctionBlock(VoltageProtectionFunctionBlock):
    '''
    This class represents a function for under voltage protection.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ProtectionTripConditioningFunctionBlock(ProtectionFunctionBlock):
    '''
    A protection function block concept borrowed from 61850-7-4. The intention
    of this class is to serve as a point of compilation of the operate outputs
    of multiple ProtectionFunctionBlock instances. It is also use here to establish
    a logical combination of the inputs and outputs of protection and protection-related
    function blocks.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WideAreaProtectionFunctionBlock(ProtectionFunctionBlock):
    '''
    This class is the base class of protection blocks for wide area protection.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FrequencyProtectionFunctionBlock(WideAreaProtectionFunctionBlock):
    '''
    This class is the base class of frequency protections.
    '''

    voltageBlockValue: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute may be used in frequency protections as a voltage block.
            '''

        })
    '''
    This attribute may be used in frequency protections as a voltage block.
    '''
    
@dataclass(repr=False)
class OverFrequencyProtectionFunctionBlock(FrequencyProtectionFunctionBlock):
    '''
    This class represents a function for over frequency protection.
    '''

    operateValue: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute means a threshold value of frequency in the over frequency
            protection function.
            '''

        })
    '''
    This attribute means a threshold value of frequency in the over frequency
    protection function.
    '''
    
@dataclass(repr=False)
class RateOfChangeOfFrequencyProtectionFunction(FrequencyProtectionFunctionBlock):
    '''
    This class represents a function for rate-of-change of frequency protection.
    '''

    operateValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute means a threshold value of frequency in rate-of-change of
            frequency protection.
            '''

        })
    '''
    This attribute means a threshold value of frequency in rate-of-change
    of frequency protection.
    '''

    unitSymbol: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit of measure of the value.
            '''

        })
    '''
    The unit of measure of the value.
    '''
    
@dataclass(repr=False)
class UnderFrequencyProtectionFunctionBlock(FrequencyProtectionFunctionBlock):
    '''
    This class represents a function for under frequency protection.
    '''

    operateValue: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute means a threshold value of frequency in the under frequency
            protection function.
            '''

        })
    '''
    This attribute means a threshold value of frequency in the under frequency
    protection function.
    '''
    
@dataclass(repr=False)
class OutOfStepProtectionFunctionBlock(WideAreaProtectionFunctionBlock):
    '''
    This class is the base class for out-of-step protection function.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ImpedanceLocusTypeFunctionBlock(OutOfStepProtectionFunctionBlock):
    '''
    This class represents impedance locus type for out-of-step protection function.
    '''

    DistanceProtectionFunctionBlock: list[DistanceProtectionFunctionBlock] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DistanceProtectionFunctionBlock.ImpedanceLocusTypeFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The distance relay elements may compose a impedance locus type of out-of-step
            relay function.
            '''

        })
    '''
    The distance relay elements may compose a impedance locus type of out-of-step
    relay function.
    '''
    
@dataclass(repr=False)
class VoltagePhaseComparisontypeFunctionBlock(OutOfStepProtectionFunctionBlock):
    '''
    This class represents voltage phase comparison type for out-of-step protection
    function.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OverLoadProtectionFunctionBlock(WideAreaProtectionFunctionBlock):
    '''
    This class is the base class for over load protection function.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OverCurrentTypeFunctionBlock(OverLoadProtectionFunctionBlock):
    '''
    This class represents over current type for over load protection function.
    '''

    OverCurrentProtectionFunctionBlock: list[OverCurrentProtectionFunctionBlock] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OverCurrentProtectionFunctionBlock.OverCurrentTypeFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Over current type of over load protection function is composed by multiple
            over current relay functions.
            '''

        })
    '''
    Over current type of over load protection function is composed by multiple
    over current relay functions.
    '''
    
@dataclass(repr=False)
class TemperatureCalculationTypeFunctionBlock(OverLoadProtectionFunctionBlock):
    '''
    This class represents temperature calculation type for over load protection
    function.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ProtectionRelatedFunctionBlock(FunctionBlock):
    '''
    Protection related functions that do not have an operate output but can
    be part of a protection scheme or logic.
    '''

    ProprietarySettingValue: list[ProprietarySettingValue] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProprietarySettingValue.ProtectionRelatedFunctionBlock',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Application-specific setting value may be possessed by this ProtectionRelatedFunctionBlock.
            '''
        
        })
    '''
    Application-specific setting value may be possessed by this ProtectionRelatedFunctionBlock.
    '''
    
    operatingQuantityType: Optional[ ProtectionOperatingQuantityKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Attribute to specify an operating quantity when the phases attribute is
            defined as ABC.
            '''

        })
    '''
    Attribute to specify an operating quantity when the phases attribute
    is defined as ABC.
    '''

    phases: Optional[ PhaseCodeProtection ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Operating phase quantities.
            '''

        })
    '''
    Operating phase quantities.
    '''

    ProtectionEquipment: Optional[ProtectionEquipment] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ProtectionEquipment.ProtectionRelatedFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Protection equipment may contain protection related function blocks.
            '''

        })
    '''
    Protection equipment may contain protection related function blocks.
    '''

    ProtectionSettingsGroup: Optional[ProtectionSettingsGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ProtectionSettingsGroup.ProtectionRelatedFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            ProtectionSettingsGroup can combine setting values possessed by several
            instances of ProtectionRelatedFunctionBlocks that constitutes a certain
            protection function.
            '''

        })
    '''
    ProtectionSettingsGroup can combine setting values possessed by several
    instances of ProtectionRelatedFunctionBlocks that constitutes a certain
    protection function.
    '''
    
@dataclass(repr=False)
class AutoreclosingFunctionBlock(ProtectionRelatedFunctionBlock):
    '''
    This class represents a function for auto-reclosing.
    '''

    RecloseSequences: list[RecloseSequence] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProprietarySettingValue.ProtectionRelatedFunctionBlock',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Application-specific setting value may be possessed by this ProtectionRelatedFunctionBlock.
            '''

        })
    '''
    Application-specific setting value may be possessed by this ProtectionRelatedFunctionBlock.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AutoreclosingFunctionBlock(ProtectionRelatedFunctionBlock):
    '''
    This class represents a function for auto-reclosing.
    '''

    resetTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Time at which this function resets.
            '''

        })
    '''
    Time at which this function resets.
    '''
    
@dataclass(repr=False)
class BreakerFailureFunctionBlock(ProtectionRelatedFunctionBlock):
    '''
    This class represents a breaker failure function.
    '''

    additionalBacktripTimeDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Extra time delay used on top of timeDelay to allow for extra maximum clearing
            fault time. Used to allow extra coordination time between three-pole and
            single-pole breakers.
            '''

        })
    '''
    Extra time delay used on top of timeDelay to allow for extra maximum
    clearing fault time. Used to allow extra coordination time between
    three-pole and single-pole breakers.
    '''

    backtripTimeDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum clearing time considered to declared a cleared fault.
            '''

        })
    '''
    Maximum clearing time considered to declared a cleared fault.
    '''

    currentThreshold: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Current threshold used to declare a cleared fault. If the detection mode
            only considers breaker status, this attribute should be left undefined
            (same as voltageThreshold).
            '''

        })
    '''
    Current threshold used to declare a cleared fault. If the detection
    mode only considers breaker status, this attribute should be left undefined
    (same as voltageThreshold).
    '''

    retripTimeDelaySinglePole: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            From 61850-7-4, single pole time delay before the function tries to retrip
            the failed breaker.
            '''

        })
    '''
    From 61850-7-4, single pole time delay before the function tries to
    retrip the failed breaker.
    '''

    retripTimeDelayThreePole: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            From 61850-7-4, three pole time delay before the function tries to retrip
            the failed breaker.
            '''

        })
    '''
    From 61850-7-4, three pole time delay before the function tries to
    retrip the failed breaker.
    '''

    voltageThreshold: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Voltage threshold used to declare a cleared fault. If the detection mode
            only considers breaker status, this attribute should be left undefined
            (same as currentThreshold).
            '''

        })
    '''
    Voltage threshold used to declare a cleared fault. If the detection
    mode only considers breaker status, this attribute should be left undefined
    (same as currentThreshold).
    '''
    
@dataclass(repr=False)
class SynchrocheckFunctionBlock(ProtectionRelatedFunctionBlock):
    '''
    This class represents a function for check of synchronism.
    '''

    angleDifference: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Setting defining phase angle difference between two measured values.
            '''

        })
    '''
    Setting defining phase angle difference between two measured values.
    '''

    frequencyDifference: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Setting defining frequency difference between two measured values.
            '''

        })
    '''
    Setting defining frequency difference between two measured values.
    '''

    voltageDifference: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Setting defining voltage difference between two measured values.
            '''

        })
    '''
    Setting defining voltage difference between two measured values.
    '''
    
@dataclass(repr=False)
class UpDownCounter(FunctionBlock):
    '''
    Class to define a rising or falling edge counter. Similar to the CTU and
    CTD standard function blocks from IEC 61131-3.
    '''

    counterLimitValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The highest value the counter can go to. Similar to the PV input for CTU
            or CTD in IEC 61131-3.
            '''

        })
    '''
    The highest value the counter can go to. Similar to the PV input for
    CTU or CTD in IEC 61131-3.
    '''

    risingEdge: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Set to True (or leave undefined) to model a rising edge counter. Otherwise,
            this is a falling edge counter.
            '''

        })
    '''
    Set to True (or leave undefined) to model a rising edge counter. Otherwise,
    this is a falling edge counter.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class FunctionBlockType(IdentifiedObject):
    '''
    Class used to specify the behavior of one or many instances of the FunctionBlock
    class.
    '''

    FunctionBlock: list[FunctionBlock] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionBlock.FunctionBlockType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generic FunctionBlock with behavior, inputs and outputs defined by a FunctionBlockType.
            '''

        })
    '''
    Generic FunctionBlock with behavior, inputs and outputs defined by
    a FunctionBlockType.
    '''

    FunctionLogicDescriptions: list[FunctionLogicDescription] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionLogicDescription.FunctionBlockType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Funcion logic description for a function block type.
            '''

        })
    '''
    Funcion logic description for a function block type.
    '''

    FunctionTypeInputs: list[FunctionTypeInput] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionTypeInput.FunctionBlockType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Input to a function block type
            '''

        })
    '''
    Input to a function block type
    '''

    FunctionTypeOutputs: list[FunctionTypeOutput] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionTypeOutput.FunctionBlockType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Output from a function block type
            '''

        })
    '''
    Output from a function block type
    '''
    
@dataclass(repr=False)
class FunctionInputVariable(IdentifiedObject):
    '''
    Functional input variable defines the domain of the function.
    '''

    Function: Optional[FunctionBlock] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FunctionBlock.Input',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Function block describe the function that function input variable provides
            the domain for.
            '''

        })
    '''
    Function block describe the function that function input variable provides
    the domain for.
    '''
    
@dataclass(repr=False)
class FunctionOutputVariable(IdentifiedObject):
    '''
    Functional output variable defines the codomain of the function.
    '''

    FunctionBlock: Optional[FunctionBlock] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FunctionBlock.FunctionOutputVariable',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Function block describe the function that function output variable provides
            the codomain for.
            '''

        })
    '''
    Function block describe the function that function output variable
    provides the codomain for.
    '''

    PropertyReference: Optional[PropertyReference] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PropertyReference.FunctionOutputVariable',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Property reference refers to a given class and property that is populated
            by the function output variable.
            '''

        })
    '''
    Property reference refers to a given class and property that is populated
    by the function output variable.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class GeographicalRegion(IdentifiedObject):
    '''
    A geographical region of a power system network model.
    '''

    Regions: list[SubGeographicalRegion] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SubGeographicalRegion.Region',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All sub-geographical regions within this geographical region.
            '''

        })
    '''
    All sub-geographical regions within this geographical region.
    '''
    
@dataclass(repr=False)
class GroundAction(IdentifiedObject):
    '''
    Action on ground as a switching step.
    '''

    AlongACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.LineGroundingAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line segment that this ground action will affect. This is the only
            way to access relationship to clamp in case the ground needs to be placed
            along the line segment.
            '''

        })
    '''
    The line segment that this ground action will affect. This is the only
    way to access relationship to clamp in case the ground needs to be
    placed along the line segment.
    '''

    GroundedEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.GroundingAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Equipment being grounded with this operation. In case of placing a ground
            anywhere along a line segment, you must use the clamp (to get the distance
            from one terminal), so use the explicit relation with line segment. In
            all other cases (including placing the ground at a line segment terminal),
            reference to one or more conducting equipment is sufficient.
            '''

        })
    '''
    Equipment being grounded with this operation. In case of placing a
    ground anywhere along a line segment, you must use the clamp (to get
    the distance from one terminal), so use the explicit relation with
    line segment. In all other cases (including placing the ground at a
    line segment terminal), reference to one or more conducting equipment
    is sufficient.
    '''

    Ground: Optional[Ground] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Ground.GroundAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Ground on which this action is taken.
            '''

        })
    '''
    Ground on which this action is taken.
    '''
    
@dataclass(repr=False)
class IOPoint(IdentifiedObject):
    '''
    The class describe a measurement or control value. The purpose is to enable
    having attributes and associations common for measurement and control.
    '''

    IOPointSource: Optional[IOPointSource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IOPointSource.IOPoint',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Local merasurement value source for an ICCP point.
            '''

        })
    '''
    Local merasurement value source for an ICCP point.
    '''
    
@dataclass(repr=False)
class Control(IOPoint):
    '''
    Control is used for supervisory/device control. It represents control outputs
    that are used to change the state in a process, e.g. close or open breaker,
    a set point value or a raise lower command.
    '''

    controlType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the type of Control. For example, this specifies if the Control
            represents BreakerOpen, BreakerClose, GeneratorVoltageSetPoint, GeneratorRaise,
            GeneratorLower, etc.
            '''

        })
    '''
    Specifies the type of Control. For example, this specifies if the Control
    represents BreakerOpen, BreakerClose, GeneratorVoltageSetPoint, GeneratorRaise,
    GeneratorLower, etc.
    '''

    operationInProgress: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates that a client is currently sending control commands that has
            not completed.
            '''

        })
    '''
    Indicates that a client is currently sending control commands that
    has not completed.
    '''

    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The last time a control output was sent.
            '''

        })
    '''
    The last time a control output was sent.
    '''

    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit multiplier of the controlled quantity.
            '''

        })
    '''
    The unit multiplier of the controlled quantity.
    '''

    unitSymbol: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit of measure of the controlled quantity.
            '''

        })
    '''
    The unit of measure of the controlled quantity.
    '''

    ControlAction: Optional[ControlAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlAction.Control',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.Controls',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Regulating device governed by this control output.
            '''

        })
    '''
    Regulating device governed by this control output.
    '''

    RemoteControl: Optional[RemoteControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RemoteControl.Control',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The remote point controlling the physical actuator.
            '''

        })
    '''
    The remote point controlling the physical actuator.
    '''
    
@dataclass(repr=False)
class AccumulatorReset(Control):
    '''
    This command resets the counter value to zero.
    '''

    AccumulatorValue: Optional[AccumulatorValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AccumulatorValue.AccumulatorReset',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The accumulator value that is reset by the command.
            '''

        })
    '''
    The accumulator value that is reset by the command.
    '''

    AccumulatorValue: Optional[AccumulatorValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorValue.AccumulatorReset',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The accumulator value that is reset by the command.
            '''

        })
    '''
    The accumulator value that is reset by the command.
    '''
    
@dataclass(repr=False)
class AnalogControl(Control):
    '''
    An analog control used for supervisory control.
    '''

    maxValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range maximum for any of the Control.value. Used for scaling,
            e.g. in bar graphs.
            '''

        })
    '''
    Normal value range maximum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''
    
    maxValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range minimum for any of the Control.value. Used for scaling,
            e.g. in bar graphs.
            '''

        })
    '''
    Normal value range minimum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''
    
    minValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AnalogControl',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''

        })
    '''
    The MeasurementValue that is controlled.
    '''

    AnalogValue: Optional[AnalogValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AnalogControl',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''

        })
    '''
    The MeasurementValue that is controlled.
    '''
    
@dataclass(repr=False)
class RaiseLowerCommand(AnalogControl):
    '''
    An analog control that increases or decreases a set point value with pulses.
    Unless otherwise specified, one pulse moves the set point by one.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.RaiseLowerCommands',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ValueAliasSet used for translation of a Control value to a name.
            '''

        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''
    
@dataclass(repr=False)
class SetPoint(AnalogControl):
    '''
    An analog control that issues a set point value.
    '''

    normalValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value for Control.value e.g. used for percentage scaling.
            '''

        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value representing the actuator output.
            '''

        })
    '''
    The value representing the actuator output.
    '''
    
@dataclass(repr=False)
class Command(Control):
    '''
    A Command is a discrete control used for supervisory control.
    '''

    DiscreteValue: Optional[DiscreteValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiscreteValue.Command',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''
        
        })
    '''
    The MeasurementValue that is controlled.
    '''
    
    normalValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value for Control.value e.g. used for percentage scaling.
            '''

        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value representing the actuator output.
            '''

        })
    '''
    The value representing the actuator output.
    '''

    DiscreteValue: Optional[DiscreteValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'DiscreteValue.Command',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''

        })
    '''
    The MeasurementValue that is controlled.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.Commands',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ValueAliasSet used for translation of a Control value to a name.
            '''

        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class MeasurementValue(IOPoint):
    '''
    The current state for a measurement. A state value is an instance of a
    measurement from a specific source. Measurements can be associated with
    many state values, each representing a different source for the measurement.
    '''

    MeasurementValueQuality: Optional[MeasurementValueQuality] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiscreteValue.Command',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''

        })
    '''
    The MeasurementValue that is controlled.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class MeasurementValue(IOPoint):
    '''
    The current state for a measurement. A state value is an instance of a
    measurement from a specific source. Measurements can be associated with
    many state values, each representing a different source for the measurement.
    '''

    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time when the value was last updated.
            '''

        })
    '''
    The time when the value was last updated.
    '''

    sensorAccuracy: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The limit, expressed as a percentage of the sensor maximum, that errors
            will not exceed when the sensor is used under reference conditions.
            '''

        })
    '''
    The limit, expressed as a percentage of the sensor maximum, that errors
    will not exceed when the sensor is used under reference conditions.
    '''

    CalculationMethodHierarchy: Optional[CalculationMethodHierarchy] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CalculationMethodHierarchy.MeasurementValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ErpPerson: Optional[OldPerson] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OldPerson.MeasurementValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    MeasurementValueQuality: Optional[MeasurementValueQuality] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueQuality.MeasurementValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''

        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''

    MeasurementValueSource: Optional[MeasurementValueSource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueSource.MeasurementValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reference to the type of source that updates the MeasurementValue, e.g.
            SCADA, CCLink, manual, etc. User conventions for the names of sources are
            contained in the introduction to IEC 61970-301.
            '''

        })
    '''
    A reference to the type of source that updates the MeasurementValue,
    e.g. SCADA, CCLink, manual, etc. User conventions for the names of
    sources are contained in the introduction to IEC 61970-301.
    '''

    RemoteSource: Optional[RemoteSource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RemoteSource.MeasurementValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Link to the physical telemetered point associated with this measurement.
            '''

        })
    '''
    Link to the physical telemetered point associated with this measurement.
    '''
    
@dataclass(repr=False)
class AccumulatorValue(MeasurementValue):
    '''
    AccumulatorValue represents an accumulated (counted) MeasurementValue.
    '''

    AccumulatorReset: Optional[AccumulatorReset] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueQuality.MeasurementValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''

        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AccumulatorValue(MeasurementValue):
    '''
    AccumulatorValue represents an accumulated (counted) MeasurementValue.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise. The value is positive.
            '''

        })
    '''
    The value to supervise. The value is positive.
    '''

    Accumulator: Optional[Accumulator] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Accumulator.AccumulatorValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''

        })
    '''
    Measurement to which this value is connected.
    '''

    AccumulatorReset: Optional[AccumulatorReset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorReset.AccumulatorValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The command that resets the accumulator value.
            '''

        })
    '''
    The command that resets the accumulator value.
    '''
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class AnalogValue(MeasurementValue):
    '''
    AnalogValue represents an analog MeasurementValue.
    '''

    AnalogControl: Optional[AnalogControl] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorReset.AccumulatorValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The command that resets the accumulator value.
            '''

        })
    '''
    The command that resets the accumulator value.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class AnalogValue(MeasurementValue):
    '''
    AnalogValue represents an analog MeasurementValue.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise.
            '''

        })
    '''
    The value to supervise.
    '''

    Analog: Optional[Analog] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Analog.AnalogValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''

        })
    '''
    Measurement to which this value is connected.
    '''

    AnalogControl: Optional[AnalogControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogControl.AnalogValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''

        })
    '''
    The Control variable associated with the MeasurementValue.
    '''
    
@dataclass(repr=False)
class DiscreteValue(MeasurementValue):
    '''
    DiscreteValue represents a discrete MeasurementValue.
    '''

    Command: Optional[Command] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogControl.AnalogValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''

        })
    '''
    The Control variable associated with the MeasurementValue.
    '''
    
    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise.
            '''

        })
    '''
    The value to supervise.
    '''

    Command: Optional[Command] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Command.DiscreteValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''

        })
    '''
    The Control variable associated with the MeasurementValue.
    '''

    Discrete: Optional[Discrete] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Discrete.DiscreteValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''

        })
    '''
    Measurement to which this value is connected.
    '''
    
@dataclass(repr=False)
class MeasurementVector(MeasurementValue):
    '''
    '''

    angle: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    magnitude: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class PhasorMeasurementValue(MeasurementVector):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://gridappsd.org/CIM/extension#'
    @property
    def __package__(self):
        return 'MeasEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StringMeasurementValue(MeasurementValue):
    '''
    StringMeasurementValue represents a measurement value of type string.
    '''

    value: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise.
            '''

        })
    '''
    The value to supervise.
    '''

    StringMeasurement: Optional[StringMeasurement] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'StringMeasurement.StringMeasurementValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''

        })
    '''
    Measurement to which this value is connected.
    '''
    
@dataclass(repr=False)
class ImpedanceTapChangerTable(IdentifiedObject):
    '''
    Describes a curve for how the power transformer end impedance varies with
    the tap step.
    '''

    ImpedanceTapChangerTablePoint: list[ImpedanceTapChangerTablePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ImpedanceTapChangerTablePoint.ImpedanceTapChangerTable',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The points of this table.
            '''

        })
    '''
    The points of this table.
    '''

    ImpedanceTapChangerTabular: list[ImpedanceTapChangerTabular] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ImpedanceTapChangerTabular.ImpedanceTapChangerTable',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The impedance tap changer to which this impedance tap table applies.
            '''

        })
    '''
    The impedance tap changer to which this impedance tap table applies.
    '''
    
@dataclass(repr=False)
class IndividualPnode(IdentifiedObject):
    '''
    Individual pricing node based on Pnode.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.IndividualPnode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class IntraphaseSpacing(IdentifiedObject):
    '''
    Wire spacing data that associates multiple wire positions with the line
    segment, and allows to calculate line segment impedances. Number of phases
    can be derived from the number of associated wire positions whose phase
    is not neutral.
    '''

    ACLineSegmentPhase: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.IntraphaseSpacing',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class JumperAction(IdentifiedObject):
    '''
    Action on jumper as a switching step.
    '''

    ACLineSegments: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.LineJumpingAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line segment that this jumper action will affect. This is the only
            way to access relationship to clamp in case the jumper needs to connect
            along the line segment.
            '''

        })
    '''
    The line segment that this jumper action will affect. This is the only
    way to access relationship to clamp in case the jumper needs to connect
    along the line segment.
    '''

    Clamp: Optional[Clamp] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Clamp.JumperAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    JumpedEquipments: list[ConductingEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConductingEquipment.JumpingAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conducting equipment is affected when the jumper action connects one or
            both ends of a jumper to the conducting equipment. If the jumper action
            involves placing one or both ends of a jumper anywhere along a line segment,
            you must use the clamp (to get the distance from one terminal), using the
            explicit relation with clamp. In the case of placing one or both ends of
            the jumper at a line segment terminal, reference to one or more line segments
            is sufficient.
            '''

        })
    '''
    Conducting equipment is affected when the jumper action connects one
    or both ends of a jumper to the conducting equipment. If the jumper
    action involves placing one or both ends of a jumper anywhere along
    a line segment, you must use the clamp (to get the distance from one
    terminal), using the explicit relation with clamp. In the case of placing
    one or both ends of the jumper at a line segment terminal, reference
    to one or more line segments is sufficient.
    '''

    Jumper: Optional[Jumper] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Jumper.JumperAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Jumper on which this action is taken.
            '''

        })
    '''
    Jumper on which this action is taken.
    '''
    
@dataclass(repr=False)
class Limit(IdentifiedObject):
    '''
    Specifies one limit value for a Measurement. A Measurement typically has
    several limits that are kept together by the LimitSet class. The actual
    meaning and use of a Limit instance (i.e., if it is an alarm or warning
    limit or if it is a high or low limit) is not captured in the Limit class.
    However the name of a Limit instance may indicate both meaning and use.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AccumulatorLimit(Limit):
    '''
    Limit values for Accumulator measurements.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise against. The value is positive.
            '''

        })
    '''
    The value to supervise against. The value is positive.
    '''

    LimitSet: Optional[AccumulatorLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AccumulatorLimitSet.Limits',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The set of limits.
            '''

        })
    '''
    The set of limits.
    '''
    
@dataclass(repr=False)
class AnalogLimit(Limit):
    '''
    Limit values for Analog measurements.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise against.
            '''

        })
    '''
    The value to supervise against.
    '''

    LimitSet: Optional[AnalogLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AnalogLimitSet.Limits',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The set of limits.
            '''

        })
    '''
    The set of limits.
    '''
    
@dataclass(repr=False)
class LimitSet(IdentifiedObject):
    '''
    Specifies a set of Limits that are associated with a Measurement. A Measurement
    may have several LimitSets corresponding to seasonal or other changing
    conditions. The condition is captured in the name and description attributes.
    The same LimitSet may be used for several Measurements. In particular percentage
    limits are used this way.
    '''

    isPercentageLimits: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Tells if the limit values are in percentage of normalValue or the specified
            Unit for Measurements and Controls.
            '''

        })
    '''
    Tells if the limit values are in percentage of normalValue or the specified
    Unit for Measurements and Controls.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class AccumulatorLimitSet(LimitSet):
    '''
    An AccumulatorLimitSet specifies a set of Limits that are associated with
    an Accumulator measurement.
    '''

    Limits: list[AccumulatorLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AccumulatorLimit.LimitSet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The limit values used for supervision of Measurements.
            '''

        })
    '''
    The limit values used for supervision of Measurements.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class AnalogLimitSet(LimitSet):
    '''
    An AnalogLimitSet specifies a set of Limits that are associated with an
    Analog measurement.
    '''

    Limits: list[AnalogLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalogLimit.LimitSet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The limit values used for supervision of Measurements.
            '''

        })
    '''
    The limit values used for supervision of Measurements.
    '''
    
@dataclass(repr=False)
class LineSegmentCoupling(IdentifiedObject):
    '''
    Describes the relationship of a line in a coupled group to the reference
    line in the group. (Reference line has a coupledLineNumber = 1.)
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.LineSegmentCoupling',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line whose relationship in a coupled group is described.
            '''
        
        })
    '''
    The line whose relationship in a coupled group is described.
    '''
    
    coupledLineNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sequence number of coupled line. Value of 1 indicates that line is the
            reference line. Valid value range is from 1 to number of coupled lines
            in the group.
            '''

        })
    '''
    Sequence number of coupled line. Value of 1 indicates that line is
    the reference line. Valid value range is from 1 to number of coupled
    lines in the group.
    '''

    reverseFlow: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indication of whether the reference end of a line in a coupled group is
            the same as the reference end of the reference line.
            Set reverseFlow to True for any lines that do not have their Terminal with
            sequenceNumber = 1 at the same end as the reference line.
            Set reverseFlow to False for the reference line and for any lines that
            have their Terminal with sequenceNumber = 1 at the same end as the reference
            line.
            The sign of the coupled voltage drop of an ACLineSegment reverses when
            two coupled lines have their Terminals with sequenceNumber = 1 at opposite
            ends.
            '''

        })
    '''
    Indication of whether the reference end of a line in a coupled group
    is the same as the reference end of the reference line.
    Set reverseFlow to True for any lines that do not have their Terminal
    with sequenceNumber = 1 at the same end as the reference line.
    Set reverseFlow to False for the reference line and for any lines that
    have their Terminal with sequenceNumber = 1 at the same end as the
    reference line.
    The sign of the coupled voltage drop of an ACLineSegment reverses when
    two coupled lines have their Terminals with sequenceNumber = 1 at opposite
    ends.
    '''

    xOffset: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The horizontal offset between the horizontal reference point of a coupled
            line and the horizontal reference point of the reference line in the group.
            The horizontal reference point for a line is established by the line's
            WireAssembly. It is the zero x position on which the xCoord values of WirePositions
            in the WireAssembly are based.
            '''

        })
    '''
    The horizontal offset between the horizontal reference point of a coupled
    line and the horizontal reference point of the reference line in the
    group.
    The horizontal reference point for a line is established by the line's
    WireAssembly. It is the zero x position on which the xCoord values
    of WirePositions in the WireAssembly are based.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.LineSegmentCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line whose relationship in a coupled group is described.
            '''

        })
    '''
    The line whose relationship in a coupled group is described.
    '''

    CoupledLineSegmentGroup: Optional[CoupledLineSegmentGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CoupledLineSegmentGroup.LineSegmentCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The coupled group of lines with which this coupled line has relationships.
            '''

        })
    '''
    The coupled group of lines with which this coupled line has relationships.
    '''
    
@dataclass(repr=False)
class LoadDynamics(IdentifiedObject):
    '''
    Load whose behaviour is described by reference to a standard model <font
    color="#0f0f0f">or by definition of a user-defined model.</font>
    A standard feature of dynamic load behaviour modelling is the ability to
    associate the same behaviour to multiple energy consumers by means of a
    single load definition. The load model is always applied to individual
    bus loads (energy consumers).
    '''

    EnergyConsumer: list[EnergyConsumer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumer.LoadDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Energy consumer to which this dynamics load model applies.
            '''

        })
    '''
    Energy consumer to which this dynamics load model applies.
    '''
    
@dataclass(repr=False)
class LoadGroup(IdentifiedObject):
    '''
    The class is the third level in a hierarchical structure for grouping of
    loads for the purpose of load flow load scaling.
    '''

    SubLoadArea: Optional[SubLoadArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'SubLoadArea.LoadGroups',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SubLoadArea where the Loadgroup belongs.
            '''

        })
    '''
    The SubLoadArea where the Loadgroup belongs.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ConformLoadGroup(LoadGroup):
    '''
    A group of loads conforming to an allocation pattern.
    '''

    EnergyConsumers: list[ConformLoad] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConformLoad.LoadGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conform loads assigned to this ConformLoadGroup.
            '''

        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''

    ConformLoadSchedules: list[ConformLoadSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConformLoadSchedule.ConformLoadGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ConformLoadSchedules in the ConformLoadGroup.
            '''

        })
    '''
    The ConformLoadSchedules in the ConformLoadGroup.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class NonConformLoadGroup(LoadGroup):
    '''
    Loads that do not follow a daily and seasonal load variation pattern.
    '''

    EnergyConsumers: list[NonConformLoad] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonConformLoad.LoadGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conform loads assigned to this ConformLoadGroup.
            '''

        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''

    NonConformLoadSchedules: list[NonConformLoadSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonConformLoadSchedule.NonConformLoadGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The NonConformLoadSchedules in the NonConformLoadGroup.
            '''

        })
    '''
    The NonConformLoadSchedules in the NonConformLoadGroup.
    '''
    
@dataclass(repr=False)
class LoadResponseCharacteristic(IdentifiedObject):
    '''
    Models the characteristic response of the load demand due to changes in
    system conditions such as voltage and frequency. It is not related to demand
    response.
    If LoadResponseCharacteristic.exponentModel is True, the exponential voltage
    or frequency dependent models are specified and used as to calculate active
    and reactive power components of the load model.
    The equations to calculate active and reactive power components of the
    load model are internal to the power flow calculation, hence they use different
    quantities depending on the use case of the data exchange.
    The equations for exponential voltage dependent load model injected power
    are:
    pInjection= Pnominal* (Voltage/cim:BaseVoltage.nominalVoltage) ** cim:LoadResponseCharacteristic.pVoltageExponent
    qInjection= Qnominal* (Voltage/cim:BaseVoltage.nominalVoltage) ** cim:LoadResponseCharacteristic.qVoltageExponent
    pInjection = Pnominal* (Frequency/(Nominal frequency))**cim:LoadResponseCharacteristic.pFrequencyExponent
    qInjection = Qnominal* (Frequency/(Nominal frequency))**cim:LoadResponseCharacteristic.qFrequencyExponent
    Note that both voltage and frequency exponents could be used together so
    the full equation would be:
    pInjection = Pnominal* (Voltage/(cim:BaseVoltage.nominalVoltage))**cim:LoadResponseCharacteristic.pVoltageExponent
    * (Frequency/(base frequency))**cim:LoadResponseCharacteristic.pFrequencyExponent
    qInjection = Qnominal* (Voltage/(cim:BaseVoltage.nominalVoltage))**cim:LoadResponseCharacteristic.qVoltageExponent
    * (Frequency/(base frequency))**cim:LoadResponseCharacteristic.qFrequencyExponent
    The voltage and frequency expressed in the equation are values obtained
    from solved power flow. Base voltage and base frequency are those derived
    from the connectivity of the static network model.
    Where:
    1) * means "multiply" and ** is "raised to the power of";
    2) Pnominal and Qnominal represent the active power and reactive power
    at nominal voltage as any load described by the voltage exponential model
    shall be given at nominal voltage. This means that EnergyConsumer.p and
    EnergyConsumer.q are at nominal voltage.
    3) After power flow is solved:
    -pInjection and qInjection correspond to SvPowerflow.p and SvPowerflow.q
    respectively.
    - Voltage corresponds to SvVoltage.v at the TopologicalNode where the load
    is connected.
    '''

    EnergyConsumer: list[EnergyConsumer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumer.LoadResponse',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The set of loads that have the response characteristics.
            '''
        
        })
    '''
    The set of loads that have the response characteristics.
    '''
    
    exponentModel: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates the exponential voltage dependency model is to be used. If false,
            the coefficient model is to be used.
            The exponential voltage dependency model consist of the attributes:
            - pVoltageExponent
            - qVoltageExponent
            - pFrequencyExponent
            - qFrequencyExponent.
            The coefficient model consist of the attributes:
            - pConstantImpedance
            - pConstantCurrent
            - pConstantPower
            - qConstantImpedance
            - qConstantCurrent
            - qConstantPower.
            The sum of pConstantImpedance, pConstantCurrent and pConstantPower shall
            equal 1.
            The sum of qConstantImpedance, qConstantCurrent and qConstantPower shall
            equal 1.
            '''

        })
    '''
    Indicates the exponential voltage dependency model is to be used. If
    false, the coefficient model is to be used.
    The exponential voltage dependency model consist of the attributes:
    - pVoltageExponent
    - qVoltageExponent
    - pFrequencyExponent
    - qFrequencyExponent.
    The coefficient model consist of the attributes:
    - pConstantImpedance
    - pConstantCurrent
    - pConstantPower
    - qConstantImpedance
    - qConstantCurrent
    - qConstantPower.
    The sum of pConstantImpedance, pConstantCurrent and pConstantPower
    shall equal 1.
    The sum of qConstantImpedance, qConstantCurrent and qConstantPower
    shall equal 1.
    '''

    pConstantCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of active power load modelled as constant current.
            '''

        })
    '''
    Portion of active power load modelled as constant current.
    '''

    pConstantImpedance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of active power load modelled as constant impedance.
            '''

        })
    '''
    Portion of active power load modelled as constant impedance.
    '''

    pConstantPower: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of active power load modelled as constant power.
            '''

        })
    '''
    Portion of active power load modelled as constant power.
    '''

    pFrequencyExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit frequency effecting active power.
            '''

        })
    '''
    Exponent of per unit frequency effecting active power.
    '''

    pVoltageExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit voltage effecting real power.
            '''

        })
    '''
    Exponent of per unit voltage effecting real power.
    '''

    qConstantCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of reactive power load modelled as constant current.
            '''

        })
    '''
    Portion of reactive power load modelled as constant current.
    '''

    qConstantImpedance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of reactive power load modelled as constant impedance.
            '''

        })
    '''
    Portion of reactive power load modelled as constant impedance.
    '''

    qConstantPower: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of reactive power load modelled as constant power.
            '''

        })
    '''
    Portion of reactive power load modelled as constant power.
    '''

    qFrequencyExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit frequency effecting reactive power.
            '''

        })
    '''
    Exponent of per unit frequency effecting reactive power.
    '''

    qVoltageExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit voltage effecting reactive power.
            '''

        })
    '''
    Exponent of per unit voltage effecting reactive power.
    '''
    
@dataclass(repr=False)
class Location(IdentifiedObject):
    '''
    The place, scene, or point of something where someone or something has
    been, is, and/or will be at a given moment in time. It can be defined with
    one or more position points (coordinates) in a given coordinate system.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All power system resources at this location.
            '''

        })
    '''
    All power system resources at this location.
    '''
    
@dataclass(repr=False)
class ServiceLocation(Location):
    '''
    A real estate location, commonly referred to as premises.
    '''

    UsagePoints: list[UsagePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'UsagePoint.ServiceLocation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All usage points delivering service (of the same type) to this service
            location.
            '''

        })
    '''
    All usage points delivering service (of the same type) to this service
    location.
    '''
    
@dataclass(repr=False)
class ChargingPark(ServiceLocation):
    '''
    geographical area that encloses one or more charging stations with one
    operator
    [From : IEC 63110-1 and ISO]
    '''

    @property
    def __namespace__(self):
        return 'http://gridappsd.org/CIM/extension#'
    @property
    def __package__(self):
        return 'CustomerEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class UsagePointLocation(Location):
    '''
    Location of an individual usage point.
    '''

    UsagePoints: list[UsagePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'UsagePoint.UsagePointLocation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All usage points at this location.
            '''

        })
    '''
    All usage points at this location.
    '''
    
@dataclass(repr=False)
class Measurement(IdentifiedObject):
    '''
    A Measurement represents any measured, calculated or non-measured non-calculated
    quantity. Any piece of equipment may contain Measurements, e.g. a substation
    may have temperature measurements and door open indications, a transformer
    may have oil temperature and tank pressure measurements, a bay may contain
    a number of power flow measurements and a Breaker may contain a switch
    status measurement.
    The PSR - Measurement association is intended to capture this use of Measurement
    and is included in the naming hierarchy based on EquipmentContainer. The
    naming hierarchy typically has Measurements as leaves, e.g. Substation-VoltageLevel-Bay-Switch-Measurement.
    Some Measurements represent quantities related to a particular sensor location
    in the network, e.g. a voltage transformer (VT) or potential transformer
    (PT) at a busbar or a current transformer (CT) at the bar between a breaker
    and an isolator. The sensing position is not captured in the PSR - Measurement
    association. Instead it is captured by the Measurement - Terminal association
    that is used to define the sensing location in the network topology. The
    location is defined by the connection of the Terminal to ConductingEquipment.
    If both a Terminal and PSR are associated, and the PSR is of type ConductingEquipment,
    the associated Terminal should belong to that ConductingEquipment instance.
    When the sensor location is needed both Measurement-PSR and Measurement-Terminal
    are used. The Measurement-Terminal association is never used alone.
    '''

    measurementType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the type of measurement. For example, this specifies if the measurement
            represents an indoor temperature, outdoor temperature, bus voltage, line
            flow, etc.
            When the measurementType is set to "Specialization", the type of Measurement
            is defined in more detail by the specialized class which inherits from
            Measurement.
            '''

        })
    '''
    Specifies the type of measurement. For example, this specifies if the
    measurement represents an indoor temperature, outdoor temperature,
    bus voltage, line flow, etc.
    When the measurementType is set to "Specialization", the type of Measurement
    is defined in more detail by the specialized class which inherits from
    Measurement.
    '''

    phases: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates to which phases the measurement applies and avoids the need to
            use 'measurementType' to also encode phase information (which would explode
            the types). The phase information in Measurement, along with 'measurementType'
            and 'phases' uniquely defines a Measurement for a device, based on normal
            network phase. Their meaning will not change when the computed energizing
            phasing is changed due to jumpers or other reasons.
            If the attribute is missing three phases (ABC) shall be assumed.
            '''

        })
    '''
    Indicates to which phases the measurement applies and avoids the need
    to use 'measurementType' to also encode phase information (which would
    explode the types). The phase information in Measurement, along with
    'measurementType' and 'phases' uniquely defines a Measurement for a
    device, based on normal network phase. Their meaning will not change
    when the computed energizing phasing is changed due to jumpers or other
    reasons.
    If the attribute is missing three phases (ABC) shall be assumed.
    '''

    sourceType: Optional[ MeasurementSourceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration GridAPPSD Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit multiplier of the measured quantity.
            '''

        })
    '''
    The unit multiplier of the measured quantity.
    '''

    unitSymbol: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit of measure of the measured quantity.
            '''

        })
    '''
    The unit of measure of the measured quantity.
    '''

    Asset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.Measurements',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    CalculationMethodHierarchy: Optional[CalculationMethodHierarchy] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CalculationMethodHierarchy.Measurement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Calculation method hierarchy which applies to this analog.
            '''

        })
    '''
    Calculation method hierarchy which applies to this analog.
    '''

    MeasurementAction: Optional[MeasurementAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementAction.Measurement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    MeasurementSystem: Optional[MeasurementSystem] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementSystem.Measurements',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.Measurements',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The power system resource that contains the measurement.
            '''

        })
    '''
    The power system resource that contains the measurement.
    '''

    Terminal: Optional[ACDCTerminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCTerminal.Measurements',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            One or more measurements may be associated with a terminal in the network.
            '''

        })
    '''
    One or more measurements may be associated with a terminal in the network.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Accumulator(Measurement):
    '''
    Accumulator represents an accumulated (counted) Measurement, e.g. an energy
    value.
    '''

    AccumulatorValues: list[AccumulatorValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AccumulatorValue.Accumulator',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The values connected to this measurement.
            '''
        
        })
    '''
    The values connected to this measurement.
    '''
    
    maxValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''
    
@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Analog(Measurement):
    '''
    Analog represents an analog Measurement.
    '''

    AnalogValues: list[AnalogValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AccumulatorValue.Accumulator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The values connected to this measurement.
            '''

        })
    '''
    The values connected to this measurement.
    '''
    
    maxValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    minValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range minimum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range minimum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    normalValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal measurement value, e.g., used for percentage calculations.
            '''

        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''

    positiveFlowIn: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates the direction of positive flow relative to the primary equipment
            connectivity.
            The attribute is applicable for measurements of flow such as active power,
            reactive power or current.
            TRUE means a positive measurement value at the terminal, where the measurement
            is located, indicates power is flowing into the related PowerSystemResource.
            FALSE means a positive measurement value at the terminal, where the measurement
            is located, indicates power is flowing out of the related PowerSystemResource.
            '''

        })
    '''
    Indicates the direction of positive flow relative to the primary equipment
    connectivity.
    The attribute is applicable for measurements of flow such as active
    power, reactive power or current.
    TRUE means a positive measurement value at the terminal, where the
    measurement is located, indicates power is flowing into the related
    PowerSystemResource.
    FALSE means a positive measurement value at the terminal, where the
    measurement is located, indicates power is flowing out of the related
    PowerSystemResource.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Discrete(Measurement):
    '''
    Discrete represents a discrete Measurement, i.e. a Measurement representing
    discrete values, e.g. a Breaker position.
    '''

    DiscreteValues: list[DiscreteValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalogValue.Analog',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The values connected to this measurement.
            '''

        })
    '''
    The values connected to this measurement.
    '''
    
    maxValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    minValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range minimum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range minimum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    normalValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal measurement value, e.g., used for percentage calculations.
            '''

        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.Discretes',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ValueAliasSet used for translation of a MeasurementValue.value to a
            name.
            '''

        })
    '''
    The ValueAliasSet used for translation of a MeasurementValue.value
    to a name.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class StringMeasurement(Measurement):
    '''
    StringMeasurement represents a measurement with values of type string.
    '''

    StringMeasurementValues: list[StringMeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'StringMeasurementValue.StringMeasurement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The values connected to this measurement.
            '''

        })
    '''
    The values connected to this measurement.
    '''
    
@dataclass(repr=False)
class MeasurementAction(IdentifiedObject):
    '''
    Measurement taken as a switching step.
    '''

    Measurement: Optional[Measurement] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Measurement.MeasurementAction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class MeasurementValueSource(IdentifiedObject):
    '''
    MeasurementValueSource describes the alternative sources updating a MeasurementValue.
    User conventions for how to use the MeasurementValueSource attributes are
    defined in IEC 61970-301.
    '''

    MeasurementValues: list[MeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeasurementValue.MeasurementValueSource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The MeasurementValues updated by the source.
            '''

        })
    '''
    The MeasurementValues updated by the source.
    '''
    
@dataclass(repr=False)
class IOPointSource(MeasurementValueSource):
    '''
    Indicates the point source for an IO Point.
    '''

    IOPoint: list[IOPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IOPoint.IOPointSource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            ICCP point for a local measurement value source.
            '''

        })
    '''
    ICCP point for a local measurement value source.
    '''
    
@dataclass(repr=False)
class MutualCoupling(IdentifiedObject):
    '''
    This class represents the zero sequence line mutual coupling.
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence mutual coupling shunt (charging) susceptance, uniformly distributed,
            of the entire line section.
            '''

        })
    '''
    Zero sequence mutual coupling shunt (charging) susceptance, uniformly
    distributed, of the entire line section.
    '''

    distance11: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Distance to the start of the coupled region from the first line's terminal
            having sequence number equal to 1.
            '''

        })
    '''
    Distance to the start of the coupled region from the first line's terminal
    having sequence number equal to 1.
    '''

    distance12: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Distance to the end of the coupled region from the first line's terminal
            with sequence number equal to 1.
            '''

        })
    '''
    Distance to the end of the coupled region from the first line's terminal
    with sequence number equal to 1.
    '''

    distance21: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Distance to the start of coupled region from the second line's terminal
            with sequence number equal to 1.
            '''

        })
    '''
    Distance to the start of coupled region from the second line's terminal
    with sequence number equal to 1.
    '''

    distance22: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Distance to the end of coupled region from the second line's terminal with
            sequence number equal to 1.
            '''

        })
    '''
    Distance to the end of coupled region from the second line's terminal
    with sequence number equal to 1.
    '''

    g0ch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence mutual coupling shunt (charging) conductance, uniformly distributed,
            of the entire line section.
            '''

        })
    '''
    Zero sequence mutual coupling shunt (charging) conductance, uniformly
    distributed, of the entire line section.
    '''

    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence branch-to-branch mutual impedance coupling, resistance.
            '''

        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, resistance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence branch-to-branch mutual impedance coupling, reactance.
            '''

        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, reactance.
    '''

    First_Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Terminal.HasFirstMutualCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The starting terminal for the calculation of distances along the first
            branch of the mutual coupling. Normally MutualCoupling would only be used
            for terminals of AC line segments. The first and second terminals of a
            mutual coupling should point to different AC line segments.
            '''

        })
    '''
    The starting terminal for the calculation of distances along the first
    branch of the mutual coupling. Normally MutualCoupling would only be
    used for terminals of AC line segments. The first and second terminals
    of a mutual coupling should point to different AC line segments.
    '''

    Second_Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Terminal.HasSecondMutualCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The starting terminal for the calculation of distances along the second
            branch of the mutual coupling.
            '''

        })
    '''
    The starting terminal for the calculation of distances along the second
    branch of the mutual coupling.
    '''
    
@stereotype(CIMStereotype.informative)
@stereotype(CIMStereotype.deprecated)
@dataclass(repr=False)
class OldPerson(IdentifiedObject):
    '''
    General purpose information for name and other information to contact people.
    '''

    MeasurementValues: list[MeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeasurementValue.ErpPerson',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class OperatingParticipant(IdentifiedObject):
    '''
    An operator of multiple power system resource objects. Note multiple operating
    participants may operate the same power system resource object. This can
    be used for modeling jointly owned units where each owner operates as a
    contractual share.
    '''

    OperatingShare: list[OperatingShare] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperatingShare.OperatingParticipant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operating shares of this operating participant. An operating participant
            can be resused for any number of power system resources.
            '''

        })
    '''
    The operating shares of this operating participant. An operating participant
    can be resused for any number of power system resources.
    '''
    
@dataclass(repr=False)
class OperationalLimit(IdentifiedObject):
    '''
    A value and normal value associated with a specific kind of limit.
    The sub class value and normalValue attributes vary inversely to the associated
    OperationalLimitType.acceptableDuration (acceptableDuration for short).
    If a particular piece of equipment has multiple operational limits of the
    same kind (apparent power, current, etc.), the limit with the greatest
    acceptableDuration shall have the smallest limit value and the limit with
    the smallest acceptableDuration shall have the largest limit value. Note:
    A large current can only be allowed to flow through a piece of equipment
    for a short duration without causing damage, but a lesser current can be
    allowed to flow for a longer duration.
    '''

    OperationalLimitSet: Optional[OperationalLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'OperationalLimitSet.OperationalLimitValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The limit set to which the limit values belong.
            '''

        })
    '''
    The limit set to which the limit values belong.
    '''

    OperationalLimitType: Optional[OperationalLimitType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperationalLimitType.OperationalLimit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The limit type associated with this limit.
            '''

        })
    '''
    The limit type associated with this limit.
    '''

    StepOperationalLimitTable: Optional[StepOperationalLimitTable] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StepOperationalLimitTable.OperationalLimit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The step operational limit table for this operational limit.
            '''

        })
    '''
    The step operational limit table for this operational limit.
    '''
    
@dataclass(repr=False)
class ActivePowerLimit(OperationalLimit):
    '''
    Limit on active power flow.
    '''

    normalValue: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal value of active power limit. The attribute shall be a positive
            value or zero.
            '''

        })
    '''
    The normal value of active power limit. The attribute shall be a positive
    value or zero.
    '''

    value: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value of active power limit. The attribute shall be a positive value or
            zero.
            '''

        })
    '''
    Value of active power limit. The attribute shall be a positive value
    or zero.
    '''
    
@dataclass(repr=False)
class ApparentPowerLimit(OperationalLimit):
    '''
    Apparent power limit.
    '''

    normalValue: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal apparent power limit. The attribute shall be a positive value
            or zero.
            '''

        })
    '''
    The normal apparent power limit. The attribute shall be a positive
    value or zero.
    '''

    value: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The apparent power limit. The attribute shall be a positive value or zero.
            '''

        })
    '''
    The apparent power limit. The attribute shall be a positive value or
    zero.
    '''
    
@dataclass(repr=False)
class CurrentLimit(OperationalLimit):
    '''
    Operational limit on current.
    '''

    normalValue: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal value for limit on current flow. The attribute shall be a positive
            value or zero.
            '''

        })
    '''
    The normal value for limit on current flow. The attribute shall be
    a positive value or zero.
    '''

    value: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Limit on current flow. The attribute shall be a positive value or zero.
            '''

        })
    '''
    Limit on current flow. The attribute shall be a positive value or zero.
    '''
    
@dataclass(repr=False)
class VoltageAngleLimit(OperationalLimit):
    '''
    Voltage angle limit between two terminals. The association end OperationalLimitSet.Terminal
    defines one end and the host of the limit. The association end VoltageAngleLimit.AngleReferenceTerminal
    defines the reference terminal.
    '''

    isFlowToRefTerminal: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if the flow is from the operating limit terminal to the angle reference
            terminal. False means that the flow is the other direction. When it is
            not given, the limit is the same for both directions.
            '''

        })
    '''
    True if the flow is from the operating limit terminal to the angle
    reference terminal. False means that the flow is the other direction.
    When it is not given, the limit is the same for both directions.
    '''

    normalValue: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The difference in angle degrees between referenced by the association end
            OperationalLimitSet.Terminal and the Terminal referenced by the association
            end VoltageAngleLimit.AngleReferenceTerminal. The value shall be positive
            (greater than zero).
            '''

        })
    '''
    The difference in angle degrees between referenced by the association
    end OperationalLimitSet.Terminal and the Terminal referenced by the
    association end VoltageAngleLimit.AngleReferenceTerminal. The value
    shall be positive (greater than zero).
    '''

    value: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The difference in angle degrees between referenced by the association end
            OperationalLimitSet.Terminal and the Terminal referenced by the association
            end VoltageAngleLimit.AngleReferenceTerminal. The value shall be positive
            (greater than zero).
            '''

        })
    '''
    The difference in angle degrees between referenced by the association
    end OperationalLimitSet.Terminal and the Terminal referenced by the
    association end VoltageAngleLimit.AngleReferenceTerminal. The value
    shall be positive (greater than zero).
    '''

    AngleReferenceTerminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.VoltageAngleLimit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The angle reference terminal for the voltage angle limit.
            '''

        })
    '''
    The angle reference terminal for the voltage angle limit.
    '''
    
@dataclass(repr=False)
class VoltageLimit(OperationalLimit):
    '''
    Operational limit applied to voltage.
    The use of operational VoltageLimit is preferred instead of limits defined
    at VoltageLevel. The operational VoltageLimits are used, if present.
    '''

    normalValue: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal limit on voltage. High or low limit nature of the limit depends
            upon the properties of the operational limit type. The attribute shall
            be a positive value or zero.
            '''

        })
    '''
    The normal limit on voltage. High or low limit nature of the limit
    depends upon the properties of the operational limit type. The attribute
    shall be a positive value or zero.
    '''

    value: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Limit on voltage. High or low limit nature of the limit depends upon the
            properties of the operational limit type. The attribute shall be a positive
            value or zero.
            '''

        })
    '''
    Limit on voltage. High or low limit nature of the limit depends upon
    the properties of the operational limit type. The attribute shall be
    a positive value or zero.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class OperationalLimitSet(IdentifiedObject):
    '''
    A set of limits associated with equipment. Sets of limits might apply to
    a specific temperature, or season for example. A set of limits may contain
    different severities of limit levels that would apply to the same equipment.
    The set may contain limits of different types such as apparent power and
    current limits or high and low voltage limits that are logically applied
    together as a set.
    '''

    OperationalLimitValue: list[OperationalLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimit.OperationalLimitSet',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Values of equipment limits.
            '''
        
        })
    '''
    Values of equipment limits.
    '''
    
    Equipment: Optional[Equipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Equipment.OperationalLimitSet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The equipment to which the limit set applies.
            '''

        })
    '''
    The equipment to which the limit set applies.
    '''

    PowerTransferCorridor: Optional[PowerTransferCorridor] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerTransferCorridor.OperationalLimitSet',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The power transfer corridor that has this operational limit set.
            '''

        })
    '''
    The power transfer corridor that has this operational limit set.
    '''

    Terminal: Optional[ACDCTerminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCTerminal.OperationalLimitSet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminal where the operational limit set apply.
            '''

        })
    '''
    The terminal where the operational limit set apply.
    '''
    
@dataclass(repr=False)
class OperationalLimitType(IdentifiedObject):
    '''
    The operational meaning of a category of limits.
    '''

    OperationalLimit: list[OperationalLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimit.OperationalLimitSet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Values of equipment limits.
            '''

        })
    '''
    Values of equipment limits.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperationalLimitType(IdentifiedObject):
    '''
    The operational meaning of a category of limits.
    '''

    isInfiniteDuration: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Defines if the operational limit type has infinite duration. If true, the
            limit has infinite duration. If false, the limit has definite duration
            which is defined by the attribute acceptableDuration.
            '''

        })
    '''
    Defines if the operational limit type has infinite duration. If true,
    the limit has infinite duration. If false, the limit has definite duration
    which is defined by the attribute acceptableDuration.
    '''

    isMinimum: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'NC Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Defines if the operational limit type is minimum. If true, the value is
            a minimum value of the same kind. This applies to stability and PATL. If
            false, the limit has the normal behaviour. OperationalLimitType.direction
            attribute shall be absoluteValue.
            '''

        })
    '''
    Defines if the operational limit type is minimum. If true, the value
    is a minimum value of the same kind. This applies to stability and
    PATL. If false, the limit has the normal behaviour. OperationalLimitType.direction
    attribute shall be absoluteValue.
    '''

    acceptableDuration: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The nominal acceptable duration of the limit. Limits are commonly expressed
            in terms of the time limit for which the limit is normally acceptable.
            The actual acceptable duration of a specific limit may depend on other
            local factors such as temperature or wind speed. The attribute has meaning
            only if the flag isInfiniteDuration is set to false, hence it shall not
            be exchanged when isInfiniteDuration is set to true.
            '''

        })
    '''
    The nominal acceptable duration of the limit. Limits are commonly expressed
    in terms of the time limit for which the limit is normally acceptable.
    The actual acceptable duration of a specific limit may depend on other
    local factors such as temperature or wind speed. The attribute has
    meaning only if the flag isInfiniteDuration is set to false, hence
    it shall not be exchanged when isInfiniteDuration is set to true.
    '''

    direction: Optional[ OperationalLimitDirectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The direction of the limit.
            '''

        })
    '''
    The direction of the limit.
    '''

    kind: Optional[ LimitKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            Types of limits defined in the ENTSO-E Operational Handbook Policy 3.
            '''

        })
    '''
    Types of limits defined in the ENTSO-E Operational Handbook Policy
    3.
    '''

    PermanentAmbientTemperatureDependencyCurve: Optional[AmbientTemperatureDependencyCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AmbientTemperatureDependencyCurve.OperationalLimitType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The permanent ambient temperature dependency curve for this operational
            limit type.
            '''

        })
    '''
    The permanent ambient temperature dependency curve for this operational
    limit type.
    '''

    PermanentSolarRadiationCurve: Optional[SolarRadiationDependencyCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SolarRadiationDependencyCurve.OperationalLimitType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The permanent solar radiation curve for this operational limit type.
            '''

        })
    '''
    The permanent solar radiation curve for this operational limit type.
    '''

    RecoveryOverloadLimitCurve: Optional[RecoveryOverloadLimitCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RecoveryOverloadLimitCurve.OperationalLimitType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This is the curve which provides the recovery time information for this
            limit type.
            '''

        })
    '''
    This is the curve which provides the recovery time information for
    this limit type.
    '''

    TemporaryBaseOverloadLimitCurve: Optional[BaseOverloadLimitCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseOverloadLimitCurve.OperationalLimitType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The temporary base overload limit curve for this operational limit type.
            '''

        })
    '''
    The temporary base overload limit curve for this operational limit
    type.
    '''

    TemporaryDurationOverloadLimitCurve: Optional[DurationOverloadLimitCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DurationOverloadLimitCurve.OperationalLimitType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The temporary duration overload limit curve for this operational limit
            type.
            '''

        })
    '''
    The temporary duration overload limit curve for this operational limit
    type.
    '''
    
@dataclass(repr=False)
class Outage(IdentifiedObject):
    '''
    Document describing details of an active or planned outage in a part of
    the electrical network.
    A non-planned outage may be created upon:
    - a breaker trip,
    - a fault indicator status change,
    - a meter event indicating customer outage,
    - a reception of one or more customer trouble calls, or
    - an operator command, reflecting information obtained from the field crew.
    Outage restoration may be performed using a switching plan which complements
    the outage information with detailed switching activities, including the
    relationship to the crew and work.
    A planned outage may be created upon:
    - a request for service, maintenance or construction work in the field,
    or
    - an operator-defined outage for what-if/contingency network analysis.
    '''

    OutageIsolationEquipment: list[ConductingEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConductingEquipment.Outage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class PMUConfiguration(IdentifiedObject):
    '''
    PMU Configuration Frame data from IEEE Std. C37.118
    '''

    PhasorMeasurementUnit: Optional[PhasorMeasurementUnit] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhasorMeasurementUnit.PMUConfiguration',
        'namespace': 'http://epri.com/GridAPPSD#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    anNmr: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Number of analog values
            '''

        })
    '''
    Number of analog values
    '''

    anScale: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Conversion factor for analog channels. Same as for FRSCALE
            '''

        })
    '''
    Conversion factor for analog channels. Same as for FRSCALE
    '''

    cfgCnt: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    chNam: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    dfdtNmr: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Number of ROCOF df/dt signals
            '''

        })
    '''
    Number of ROCOF df/dt signals
    '''

    dfdtScale: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Conversion factor for ROCOF channels. Same as for FRSCALE
            '''

        })
    '''
    Conversion factor for ROCOF channels. Same as for FRSCALE
    '''

    format: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Data format within the periodic data frame given by Table 4 of IEEE Std.
            C37.118
            '''

        })
    '''
    Data format within the periodic data frame given by Table 4 of IEEE
    Std. C37.118
    '''

    frNmr: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Number of frequency signals
            '''

        })
    '''
    Number of frequency signals
    '''

    frScale: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Conversion factor for frequency channels. If frequency values are transmitted
            in floating-point format and scaled
            already, these values shall be set to 1.0, and 0.0, respectively.
            '''

        })
    '''
    Conversion factor for frequency channels. If frequency values are transmitted
    in floating-point format and scaled
    already, these values shall be set to 1.0, and 0.0, respectively.
    '''

    grpDly: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Phasor measurement group delay including all filters and estimation windows
            in effect. Value is in �s
            '''

        })
    '''
    Phasor measurement group delay including all filters and estimation
    windows in effect. Value is in �s
    '''

    phNmr: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Number of phasors
            '''

        })
    '''
    Number of phasors
    '''

    phScale: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Conversion factor for phasor channels with flags.
            Magnitude and angle scaling for phasors with data flags. This factor has
            four 4-B long words: The first is bit-mapped flags, the second is a magnitude
            scale factor, the third is an angle offset, and the fourth is voltage class
            '''

        })
    '''
    Conversion factor for phasor channels with flags.
    Magnitude and angle scaling for phasors with data flags. This factor
    has four 4-B long words: The first is bit-mapped flags, the second
    is a magnitude scale factor, the third is an angle offset, and the
    fourth is voltage class
    '''

    pmuDataRate: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Rate of data transmissions from this PMU. 2-B integer word (�32 767 to
            +32 767) e.g., PMU_DATA_RATE = 15 is 15 frames per second
            '''

        })
    '''
    Rate of data transmissions from this PMU. 2-B integer word (�32 767
    to +32 767) e.g., PMU_DATA_RATE = 15 is 15 frames per second
    '''

    streamDataRate: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Rate of data transmission for the composite frame in this stream
            '''

        })
    '''
    Rate of data transmission for the composite frame in this stream
    '''

    waitTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            PDC wait time, milliseconds
            '''

        })
    '''
    PDC wait time, milliseconds
    '''

    window: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Phasor measurement window length including all filters and estimation windows
            in effect. Value is in �s
            '''

        })
    '''
    Phasor measurement window length including all filters and estimation
    windows in effect. Value is in �s
    '''

    PhasorMeasurementUnit: Optional[PhasorMeasurementUnit] = field(
        default=None,
        metadata={
        'type': 'GridAPPSD',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhasorMeasurementUnit.PMUConfiguration',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PMUConfigurationFrame: Optional[PMUConfigurationFrame] = field(
        default=None,
        metadata={
        'type': 'OfAggregate GridAPPSD',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PMUConfigurationFrame.PMUConfigurations',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class PSRType(IdentifiedObject):
    '''
    Classifying instances of the same class, e.g. overhead and underground
    ACLineSegments. This classification mechanism is intended to provide flexibility
    outside the scope of this document, i.e. provide customisation that is
    non standard.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.PSRType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power system resources classified with this power system resource type.
            '''

        })
    '''
    Power system resources classified with this power system resource type.
    '''
    
@dataclass(repr=False)
class PerLengthLineParameter(IdentifiedObject):
    '''
    Common type for per-length electrical line parameters.
    '''

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.PerLengthLineParameter',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class PerLengthImpedance(PerLengthLineParameter):
    '''
    Common type for per-length electrical impedances.
    '''

    isUserDefined: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    isUserDefined: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    calculatedFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Carson earth return resistance per unit length used to compute impedance
            values at base frequency. Used for making better adjustments of line impedance
            values for frequency for harmonics studies.
            '''

        })
    '''
    Carson earth return resistance per unit length used to compute impedance
    values at base frequency. Used for making better adjustments of line
    impedance values for frequency for harmonics studies.
    '''
    
    calculatedTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Carson earth return reactance per unit length used to compute impedance
            values at base frequency. Used for making better adjustments of line impedance
            values for frequency for harmonics studies.
            '''

        })
    '''
    Carson earth return reactance per unit length used to compute impedance
    values at base frequency. Used for making better adjustments of line
    impedance values for frequency for harmonics studies.
    '''
    
    rg: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.PerLengthImpedance',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    xg: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.PerLengthImpedance',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All line segments described by this per-length impedance.
            '''

        })
    '''
    All line segments described by this per-length impedance.
    '''

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.PerLengthImpedance',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class PerLengthPhaseImpedance(PerLengthImpedance):
    '''
    The per length phase impedance matrix expresses impedance and admittance
    parameters per unit length for n-conductor unbalanced line segments. A
    phase impedance matrix contains both self impedances for each phase and
    mutual impedances between pairs of phases. The matrix is stored in symmetric
    lower triangular format where the diagonal entries represent self-impedances
    (and have the same value in row and column) and the off diagonal entries
    represent phase-to-phase impedances (and have different row and column
    values).
    The matrix can be use to express impedances for both non-coupled and coupled
    line segments. Coupled line segments share a single per length phase impedance
    matrix whose entries reflect the self and mutual impedances of all the
    phases of all the wires.
    '''

    PhaseImpedanceData: list[PhaseImpedanceData] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseImpedanceData.PhaseImpedance',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All data that belong to this conductor phase impedance.
            '''
        
        })
    '''
    All data that belong to this conductor phase impedance.
    '''
    
    conductorCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conductor count identifies the number of phase, neutral, and other wires
            represented in the phase impedance matrix and constrains the number of
            elements in the matrix. Typically, Kron reduction is used for incorporating
            effects of neutral impedance in the phase conductor values (so conductor
            count only considers phase wires), but neutrals can be included in the
            matrix (in which case conductor count would include the neutral wire(s)).
            For a phase impedance matrix associated with the lines of a coupled line
            segment group, the conductor count reflects the total of the conductors
            associated with all the coupled line segments in the group.
            '''

        })
    '''
    Conductor count identifies the number of phase, neutral, and other
    wires represented in the phase impedance matrix and constrains the
    number of elements in the matrix. Typically, Kron reduction is used
    for incorporating effects of neutral impedance in the phase conductor
    values (so conductor count only considers phase wires), but neutrals
    can be included in the matrix (in which case conductor count would
    include the neutral wire(s)). For a phase impedance matrix associated
    with the lines of a coupled line segment group, the conductor count
    reflects the total of the conductors associated with all the coupled
    line segments in the group.
    '''
    
@dataclass(repr=False)
class PerLengthSequenceImpedance(PerLengthImpedance):
    '''
    Sequence impedance and admittance parameters per unit length, for transposed
    line segments of 1, 2, or 3 phases. For 1-phase line segments, define x
    = x0 = xself. For 2-phase line segments, define x = xself - xmutual and
    x0 = xself + xmutual.
    '''

    b0ch: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance, per unit of length.
            '''

        })
    '''
    Zero sequence shunt (charging) susceptance, per unit of length.
    '''

    bch: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance, per unit of length.
            '''

        })
    '''
    Positive sequence shunt (charging) susceptance, per unit of length.
    '''

    g0ch: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance, per unit of length.
            '''

        })
    '''
    Zero sequence shunt (charging) conductance, per unit of length.
    '''

    gch: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance, per unit of length.
            '''

        })
    '''
    Positive sequence shunt (charging) conductance, per unit of length.
    '''

    r: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence series resistance, per unit of length.
            '''

        })
    '''
    Positive sequence series resistance, per unit of length.
    '''

    r0: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence series resistance, per unit of length.
            '''

        })
    '''
    Zero sequence series resistance, per unit of length.
    '''

    x: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence series reactance, per unit of length.
            '''

        })
    '''
    Positive sequence series reactance, per unit of length.
    '''

    x0: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence series reactance, per unit of length.
            '''

        })
    '''
    Zero sequence series reactance, per unit of length.
    '''
    
@dataclass(repr=False)
class PhaseImpedanceData(IdentifiedObject):
    '''
    Per length phase impedance matrix entry describes impedance and conductance
    matrix element values for a specific row and column of the matrix.
    The phases to which each entry applies can be determined by means of the
    row and column attributes which bind to a sequence number provided in either
    ACLineSegmentPhase or WirePosition (which also specify phase). Due to physical
    symmetry that is reflected in the matrix, only the lower triangle of the
    matrix is populated with the row and column method. That is, the column
    attribute is always less than or equal to the row attribute.
    '''

    column: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The matrix entry's column number has a range of possible values from 1
            to the conductor count of the matrix, but due to symmetry, only entries
            in the lower triangle (including diagonal) of the matrix need be defined.
            Column number binds to the sequence number in either ACLineSegmentPhase
            or WirePosition, which then identifies the phase for this entry.
            '''

        })
    '''
    The matrix entry's column number has a range of possible values from
    1 to the conductor count of the matrix, but due to symmetry, only entries
    in the lower triangle (including diagonal) of the matrix need be defined.
    Column number binds to the sequence number in either ACLineSegmentPhase
    or WirePosition, which then identifies the phase for this entry.
    '''

    row: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The matrix entry's row number has a range of possible values from 1 to
            the conductor count of the matrix, but due to symmetry, only entries in
            the lower triangle (including diagonal) of the matrix need be defined.
            Row number binds to the sequence number in either ACLineSegmentPhase or
            WirePosition, which then identifies the phase for this entry.
            '''

        })
    '''
    The matrix entry's row number has a range of possible values from 1
    to the conductor count of the matrix, but due to symmetry, only entries
    in the lower triangle (including diagonal) of the matrix need be defined.
    Row number binds to the sequence number in either ACLineSegmentPhase
    or WirePosition, which then identifies the phase for this entry.
    '''

    b: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Susceptance matrix entry value, per length of unit.
            '''

        })
    '''
    Susceptance matrix entry value, per length of unit.
    '''

    fromPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Refer to the class description.
            '''

        })
    '''
    Refer to the class description.
    '''

    g: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conductance matrix entry value, per length of unit.
            '''

        })
    '''
    Conductance matrix entry value, per length of unit.
    '''

    r: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Resistance matrix entry value, per length of unit.
            '''

        })
    '''
    Resistance matrix entry value, per length of unit.
    '''

    toPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Refer to the class description.
            '''

        })
    '''
    Refer to the class description.
    '''

    x: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactance matrix entry value, per length of unit.
            '''

        })
    '''
    Reactance matrix entry value, per length of unit.
    '''

    PhaseImpedance: Optional[PerLengthPhaseImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'PerLengthPhaseImpedance.PhaseImpedanceData',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conductor phase impedance to which this data belongs.
            '''

        })
    '''
    Conductor phase impedance to which this data belongs.
    '''
    
@dataclass(repr=False)
class PhaseTapChangerTable(IdentifiedObject):
    '''
    Describes a tabular curve for how the phase angle difference and impedance
    varies with the tap step.
    '''

    PhaseTapChangerTablePoint: list[PhaseTapChangerTablePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseTapChangerTablePoint.PhaseTapChangerTable',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The points of this table.
            '''

        })
    '''
    The points of this table.
    '''

    PhaseTapChangerTabular: list[PhaseTapChangerTabular] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseTapChangerTabular.PhaseTapChangerTable',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The phase tap changers to which this phase tap table applies.
            '''

        })
    '''
    The phase tap changers to which this phase tap table applies.
    '''
    
@dataclass(repr=False)
class ConnectionAngleTapChangerTable(PhaseTapChangerTable):
    '''
    Describes a tabular curve for how the connection angle varies with the
    tap step. This table is used when its winding connection angle matches
    the operating angle of the tap changer. There must be an instance of this
    table for each winding connection angle that can be used.
    '''

    windingConnectionAngle: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The phase angle between the in-phase winding and the out-of -phase winding
            used for creating phase shift. The out-of-phase winding produces what is
            known as the difference voltage. Setting this angle to 90 degrees is not
            the same as a symmetrical transformer. In this scenario you will still
            treat the 90-degree angle as a phase shifting transformer. The attribute
            can only be multiples of 30 degrees. When 0 degree is used the asymmetrical
            phase tap changer acts as ratio tap changer controlling voltage.
            '''

        })
    '''
    The phase angle between the in-phase winding and the out-of -phase
    winding used for creating phase shift. The out-of-phase winding produces
    what is known as the difference voltage. Setting this angle to 90 degrees
    is not the same as a symmetrical transformer. In this scenario you
    will still treat the 90-degree angle as a phase shifting transformer.
    The attribute can only be multiples of 30 degrees. When 0 degree is
    used the asymmetrical phase tap changer acts as ratio tap changer controlling
    voltage.
    '''

    ConnectionAngleTapChanger: Optional[ConnectionAngleTapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectionAngleTapChanger.ConnectionAngleTapChangerTable',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The connection angle tap changer that has this connection angle tap changer
            table.
            '''

        })
    '''
    The connection angle tap changer that has this connection angle tap
    changer table.
    '''
    
@dataclass(repr=False)
class PointOfCommonCoupling(IdentifiedObject):
    '''
    Point of Common Coupling (PCC) refers to the location where multiple electrical
    sources or loads are electrically connected and provide a reference point
    where the voltages and currents from different parts of the system are
    considered to be common. The PCC is used to support system analysis, control,
    and monitoring, as it provides a reference for understanding the interactions
    and power flow between various components within the system. It is also
    relevant to define the requirement and responsibility between different
    actors in operating a power system.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ACPointOfCommonCoupling(PointOfCommonCoupling):
    '''
    Point of interconnection of the DC converter station to the adjacent AC
    system (IEC 60633).
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.ACPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Connectivity node which is a point of common coupling AC.
            '''

        })
    '''
    Connectivity node which is a point of common coupling AC.
    '''
    
    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCConverterUnit.ACPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC converter unit that has AC point of common coupling.
            '''

        })
    '''
    DC converter unit that has AC point of common coupling.
    '''
    
    DCConverterUnit: Optional[DCConverterUnit] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.ACPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Connectivity node which is a point of common coupling AC.
            '''

        })
    '''
    Connectivity node which is a point of common coupling AC.
    '''
    
@dataclass(repr=False)
class DCPointOfCommonCoupling(PointOfCommonCoupling):
    '''
    Point of interconnection of the DC converter station to the DC transmission
    line (IEC 60633).
    '''

    DCConverterUnit: Optional[DCConverterUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCConverterUnit.DCPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC converter unit that has DC point of common coupling.
            '''

        })
    '''
    DC converter unit that has DC point of common coupling.
    '''

    DCNode: Optional[DCNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCNode.DCPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DCNode that is a point of common coupling DC.
            '''

        })
    '''
    The DCNode that is a point of common coupling DC.
    '''
    
@stereotype(CIMStereotype.NC)
@dataclass(repr=False)
class PowerShiftKeyDistribution(IdentifiedObject):
    '''
    Distribution of the bid action on the power shift keys.
    '''

    PowerElectronicsUnit: list[PowerElectronicsUnit] = field(
        default_factory=list,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsUnit.PowerShiftKeyDistribution',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Power electronics unit distribution for a given bid.
            '''

        })
    '''
    Power electronics unit distribution for a given bid.
    '''
    
@stereotype(CIMStereotype.NC)
@dataclass(repr=False)
class PowerShiftKeyStrategy(IdentifiedObject):
    '''
    Strategy of the power shift key.
    '''

    PowerFrequencyController: list[PowerFrequencyController] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerFrequencyController.PowerShiftKeyStrategy',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Power frequency controller that has power shift key strategy.
            '''

        })
    '''
    Power frequency controller that has power shift key strategy.
    '''
    
@dataclass(repr=False)
class PowerSystemResource(IdentifiedObject):
    '''
    A power system resource (PSR) can be an item of equipment such as a switch,
    an equipment container containing many individual items of equipment such
    as a substation, or an organisational entity such as sub-control area.
    Power system resources can have measurements associated.
    '''

    AssetDatasheet: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.PowerSystemResources',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Datasheet information for this power system resource.
            '''

        })
    '''
    Datasheet information for this power system resource.
    '''
    
    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DesignElement.PowerSystemResource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Operation to be performed with the resource in context of a particular
            design
            '''

        })
    '''
    Operation to be performed with the resource in context of a particular
    design
    '''
    
    OperatingShare: list[OperatingShare] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.PowerSystemResources',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Location of this power system resource.
            '''

        })
    '''
    Location of this power system resource.
    '''
    
    AssetDatasheet: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PSRType.PowerSystemResources',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Custom classification for this power system resource.
            '''

        })
    '''
    Custom classification for this power system resource.
    '''
    
    DesignElement: Optional[DesignElement] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Control.PowerSystemResource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The controller outputs used to actually govern a regulating device, e.g.
            the magnetization of a synchronous machine or capacitor bank breaker actuator.
            '''

        })
    '''
    The controller outputs used to actually govern a regulating device,
    e.g. the magnetization of a synchronous machine or capacitor bank breaker
    actuator.
    '''
    
    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.PowerSystemResource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The measurements associated with this power system resource.
            '''

        })
    '''
    The measurements associated with this power system resource.
    '''
    
    PSRType: Optional[PSRType] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperatingShare.PowerSystemResource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operating shares of this power system resource.
            '''

        })
    '''
    The operating shares of this power system resource.
    '''
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ACLineSegmentPhase(PowerSystemResource):
    '''
    A line segment phase represents one phase (or optionally the neutral) of
    an alternating current line segment.
    Under most circumstances there is not a line segment phase for the neutral.
    However, if a wire assembly is being used and it does not specify phase,
    a line segment phase must exist for each position in the assembly (including
    the neutral).
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sequence number provides the numbering for this line segment phase. When
            impedance is directly described, sequence number binds the phase to the
            column and row for entries in the per length phase impedance matrix (PhaseImpedanceData
            of PerLengthPhaseImpedance). When used in conjunction with a wire assembly
            description, sequence number associates the line segment phase to a position.
            For a line segment not a part of a parallel line segment group, sequence
            number starts at one and increments by one through each line segment phase
            associated with the line segment. If there is a line segment phase for
            neutral, it is numbered last.
            '''

        })
    '''
    Sequence number provides the numbering for this line segment phase.
    When impedance is directly described, sequence number binds the phase
    to the column and row for entries in the per length phase impedance
    matrix (PhaseImpedanceData of PerLengthPhaseImpedance). When used in
    conjunction with a wire assembly description, sequence number associates
    the line segment phase to a position.
    For a line segment not a part of a parallel line segment group, sequence
    number starts at one and increments by one through each line segment
    phase associated with the line segment. If there is a line segment
    phase for neutral, it is numbered last.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase identifies the phase or neutral connection of the conductor at both
            ends.
            '''

        })
    '''
    Phase identifies the phase or neutral connection of the conductor at
    both ends.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.ACLineSegmentPhases',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line segment to which the phase belongs.
            '''

        })
    '''
    The line segment to which the phase belongs.
    '''

    IntraphaseSpacing: Optional[IntraphaseSpacing] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IntraphaseSpacing.ACLineSegmentPhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireInfo: Optional[WireInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireInfo.ACLineSegmentPhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class ACTieCorridor(PowerSystemResource):
    '''
    A collection of one or more AC tie lines that connect two different control
    areas.
    '''

    Line: list[Line] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Line.ACTieCorridor',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Line that is part of the ACTieCorridor.
            '''

        })
    '''
    Line that is part of the ACTieCorridor.
    '''
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class AirCompressor(PowerSystemResource):
    '''
    Combustion turbine air compressor which is an integral part of a compressed
    air energy storage (CAES) plant.
    '''

    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.AirCompressor',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''
        
        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''
    
    airCompressorRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rating of the CAES air compressor.
            '''

        })
    '''
    Rating of the CAES air compressor.
    '''

    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.AirCompressor',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''

        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''

    CombustionTurbine: Optional[CombustionTurbine] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'CombustionTurbine.AirCompressor',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A CAES air compressor is driven by combustion turbine.
            '''

        })
    '''
    A CAES air compressor is driven by combustion turbine.
    '''
    
@stereotype(CIMStereotype.NC)
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class AreaDispatchableUnit(PowerSystemResource):
    '''
    Allocates a given producing or consuming unit, including direct current
    corridor and collection of units, to a given control area (through the
    scheduling area) for supporting the control of the given area through dispatch
    instruction.
    '''

    EnergyConsumer: Optional[EnergyConsumer] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumer.AreaDispatchableUnit',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Energy consumer for this area dispatchable unit.
            '''

        })
    '''
    Energy consumer for this area dispatchable unit.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'NC OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.AreaDispatchableUnit',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The generating unit that belongs to area dispatchable unit.
            '''

        })
    '''
    The generating unit that belongs to area dispatchable unit.
    '''

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.AreaDispatchableUnit',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Hydro Pump which is associated with the area dispatchable unit.
            '''

        })
    '''
    Hydro Pump which is associated with the area dispatchable unit.
    '''

    PowerElectronicsUnit: Optional[PowerElectronicsUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsUnit.AreaDispatchableUnit',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The power electronics unit that belongs to this area dispatchable unit.
            '''

        })
    '''
    The power electronics unit that belongs to this area dispatchable unit.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class AutomationFunction(PowerSystemResource):
    '''
    Automation function is a collection of functional block or other automation
    function that can be executed as a work cycle program as part of an automated
    system.
    '''

    enabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True, if the automation function is enabled (active). Otherwise false.
            '''

        })
    '''
    True, if the automation function is enabled (active). Otherwise false.
    '''
    
    HasPart: list[AutomationFunction] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True, if the automation function is normally enabled (active). Otherwise
            false.
            '''

        })
    '''
    True, if the automation function is normally enabled (active). Otherwise
    false.
    '''
    
    FunctionBlock: list[FunctionBlock] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of automation function.
            '''

        })
    '''
    Type of automation function.
    '''
    
    enabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AutomationFunction.HasPart',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Automation function is part of this automation function.
            '''

        })
    '''
    Automation function is part of this automation function.
    '''
    
    normalEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AutomationBlockGroup.AutomationFunction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Automation block group which belongs to an automation function.
            '''

        })
    '''
    Automation block group which belongs to an automation function.
    '''
    
    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AutomationFunction.PartOf',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Automation function has this automation function as a part.
            '''

        })
    '''
    Automation function has this automation function as a part.
    '''
    
    PartOf: Optional[AutomationFunction] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionBlock.AutomationFunction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Function block is part of this automation function.
            '''

        })
    '''
    Function block is part of this automation function.
    '''
    
@dataclass(repr=False)
class EquipmentController(AutomationFunction):
    '''
    Equipment controller is an automation function that can control one or
    multiple equipment function to achieve all the targets inside the given
    tolerance.
    '''

    SystemControl: Optional[SystemControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SystemControl.EquipmentController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            System control which controls this equipment controller.
            '''

        })
    '''
    System control which controls this equipment controller.
    '''
    
    SystemControl: Optional[SystemControl] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulatingCondEq.EquipmentController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All regulating conducting equipment that belongs to this equipment controller.
            '''

        })
    '''
    All regulating conducting equipment that belongs to this equipment
    controller.
    '''
    
@dataclass(repr=False)
class CompensatorController(EquipmentController):
    '''
    Compensator controller is controlling the equipment to optimize the use
    of the compensators.
    '''

    mode: Optional[ CompensatorControlModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Mode of the compensator controller.
            '''

        })
    '''
    Mode of the compensator controller.
    '''
    
@dataclass(repr=False)
class DirectCurrentEquipmentController(EquipmentController):
    '''
    Direct current equipment controller used to control different parts of
    the hierarchical structure of the DC control system defined by IEC 60633.
    '''

    mode: Optional[ DCControlModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Mode of the dc controller.
            '''

        })
    '''
    Mode of the dc controller.
    '''
    
@dataclass(repr=False)
class ACDCConverterController(DirectCurrentEquipmentController):
    '''
    ACDC converter unit control. According to IEC 60633, it is the control
    system used for the controlling, monitoring and protection of a single
    converter unit.
    '''

    ACDCConverter: Optional[ACDCConverter] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ACDCConverter.ACDCConverterController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            ACDC converter controlled by the direct current controller.
            '''

        })
    '''
    ACDC converter controlled by the direct current controller.
    '''

    DirectCurrentPoleController: Optional[DirectCurrentPoleController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentPoleController.ACDCConverterController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC pole controller that controls this ACDC controller.
            '''

        })
    '''
    DC pole controller that controls this ACDC controller.
    '''
    
@dataclass(repr=False)
class DirectCurrentBipoleController(DirectCurrentEquipmentController):
    '''
    DC system bipole control that is the control system of a bipole in accordance
    with IEC 60633.
    '''

    DirectCurrentMasterController: Optional[DirectCurrentMasterController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentMasterController.DirectCurrentBipoleController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Direct current master controller which has direct current bipole controllers.
            '''

        })
    '''
    Direct current master controller which has direct current bipole controllers.
    '''
    
    DirectCurrentMasterController: Optional[DirectCurrentMasterController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DirectCurrentPoleController.DirectCurrentBipoleController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC pole controller that is controlled by a DC bipole controller.
            '''

        })
    '''
    DC pole controller that is controlled by a DC bipole controller.
    '''
    
@dataclass(repr=False)
class DirectCurrentMasterController(DirectCurrentEquipmentController):
    '''
    Direct current system control is a control system which governs the operation
    of an entire DC system consisting of more than one DC substation and performs
    those functions of controlling, monitoring and protection which require
    information from more than one substation. This can also be a multiterminal
    control which is a DC system control for more that two DC substations or
    a DC master control, which is a general concept for control coordination
    of a DC system. The DC master control may be implemented at the bipole
    and/or pole level as defined in IEC 60633.
    The DC system control/multiterminal control/master control is part of the
    hierarchical structure of an HVDC control system that has an integrated
    AC/DC system control as the highest level of control which governs the
    integrated operation of AC and DC systems of a power system. This control
    system is under the responsibility of the system operator.
    '''

    DCTieCorridor: Optional[DCTieCorridor] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTieCorridor.DirectCurrentMasterController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DCTieCorridor controlled by this direct current master controller.
            '''
        
        })
    '''
    DCTieCorridor controlled by this direct current master controller.
    '''
    
    DirectCurrentBipoleController: list[DirectCurrentBipoleController] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DirectCurrentBipoleController.DirectCurrentMasterController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Direct current bipole controller which belongs to a direct current master
            controller.
            '''

        })
    '''
    Direct current bipole controller which belongs to a direct current
    master controller.
    '''

    DirectCurrentPoleController: list[DirectCurrentPoleController] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DirectCurrentPoleController.DirectCurrentMasterController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC pole controller that is controlled by this DC master controller.
            '''

        })
    '''
    DC pole controller that is controlled by this DC master controller.
    '''

    DirectCurrentSubstationController: list[DirectCurrentSubstationController] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DirectCurrentSubstationController.MultiterminalControl',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation controller controlled by a multiterminal control.
            '''

        })
    '''
    DC substation controller controlled by a multiterminal control.
    '''
    
    DCTieCorridor: Optional[DCTieCorridor] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTieCorridor.DirectCurrentMasterController',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DCTieCorridor controlled by this direct current master controller.
            '''
        
        })
    '''
    DCTieCorridor controlled by this direct current master controller.
    '''
    
@dataclass(repr=False)
class DirectCurrentPoleController(DirectCurrentEquipmentController):
    '''
    DC system pole control, which is the control system of a pole in accordance
    with IEC 60633.
    '''

    ACDCConverterController: list[ACDCConverterController] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACDCConverterController.DirectCurrentPoleController',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            ACDC converter controller that is controlled by a DC pole controller.
            '''
        
        })
    '''
    ACDC converter controller that is controlled by a DC pole controller.
    '''
    
    DCPole: Optional[DCPole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'DCPole.DirectCurrentPoleController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC pole that is controlled by a DC pole controller.
            '''

        })
    '''
    DC pole that is controlled by a DC pole controller.
    '''

    DirectCurrentBipoleController: Optional[DirectCurrentBipoleController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentBipoleController.DirectCurrentPoleController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC bipole controller that controls this DC pole controller.
            '''

        })
    '''
    DC bipole controller that controls this DC pole controller.
    '''

    DirectCurrentMasterController: Optional[DirectCurrentMasterController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentMasterController.DirectCurrentPoleController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC master controller that has a DC pole controller.
            '''

        })
    '''
    DC master controller that has a DC pole controller.
    '''
    
@dataclass(repr=False)
class DirectCurrentSubstationController(DirectCurrentEquipmentController):
    '''
    Control system used for the controlling, monitoring and protection within
    a DC substation (IEC 60633). A DC substation control may be implemented
    at the bipole and/or pole level and may be referred to as local control.
    '''

    MultiterminalControl: Optional[DirectCurrentMasterController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentMasterController.DirectCurrentSubstationController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiterminal control that controls more than two DC substation controllers.
            '''

        })
    '''
    Multiterminal control that controls more than two DC substation controllers.
    '''
    
@dataclass(repr=False)
class DirectCurrentSubstationBipoleController(DirectCurrentSubstationController):
    '''
    Control system of a substation bipole (IEC 60633).
    '''

    DCSubstationBipole: Optional[DCSubstationBipole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'DCSubstationBipole.DirectCurrentSubstationBipoleController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation bipole that is controlled by a DC substation bipole controller.
            '''

        })
    '''
    DC substation bipole that is controlled by a DC substation bipole controller.
    '''
    
@dataclass(repr=False)
class DirectCurrentSubstationPoleController(DirectCurrentSubstationController):
    '''
    Control system of a substation pole (IEC 60633).
    '''

    DCSubstationPole: Optional[DCSubstationPole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'DCSubstationPole.DirectCurrentSubstationPoleController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation pole that is controlled by a DC substation pole controller.
            '''

        })
    '''
    DC substation pole that is controlled by a DC substation pole controller.
    '''
    
@dataclass(repr=False)
class InjectionController(EquipmentController):
    '''
    Injection controller is controlling the equipment which represents an injection
    or an external network.
    '''

    mode: Optional[ InjectionControlModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Mode of the injection controller.
            '''

        })
    '''
    Mode of the injection controller.
    '''
    
@dataclass(repr=False)
class PowerElectronicsConnectionController(EquipmentController):
    '''
    Power electronics connection controller is controlling the equipment to
    optimize the power electronics connection.
    '''

    PowerElectronicsUnitController: list[PowerElectronicsUnitController] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsUnitController.PowerElectronicsConnectionController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power electronics unit controller that has this power electronics connection
            controller.
            '''

        })
    '''
    Power electronics unit controller that has this power electronics connection
    controller.
    '''
    
@dataclass(repr=False)
class PowerElectronicsUnitController(EquipmentController):
    '''
    Power electronics unit controller is controlling the equipment to optimize
    the power electronics unit.
    '''

    PowerElectronicsConnectionController: Optional[PowerElectronicsConnectionController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsConnectionController.PowerElectronicsUnitController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power electronics connection controller for the power electronics unit
            controller.
            '''

        })
    '''
    Power electronics connection controller for the power electronics unit
    controller.
    '''
    
    PowerElectronicsConnectionController: Optional[PowerElectronicsConnectionController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsUnit.PowerElectronicsUnitController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power electronics unit that has this power electronics unit controller.
            '''

        })
    '''
    Power electronics unit that has this power electronics unit controller.
    '''
    
@dataclass(repr=False)
class BatteryUnitContoller(PowerElectronicsUnitController):
    '''
    '''

    maxAllowedSOC: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    minAllowedSOC: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class PowerPlantController(EquipmentController):
    '''
    Power plant controller is controlling the equipment of a power plant.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Control'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RotatingMachineController(EquipmentController):
    '''
    Rotating machine controller is controlling the equipment which may be used
    as a generator or motor.
    '''

    mode: Optional[ RotatingMachineControlModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Mode of the rotating machine controller.
            '''

        })
    '''
    Mode of the rotating machine controller.
    '''
    
@dataclass(repr=False)
class ScheduleResourceController(EquipmentController):
    '''
    Schedule resource controller is controlling the equipment to optimize the
    schedule resource.
    '''

    ScheduleResource: Optional[ScheduleResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ScheduleResource.ScheduleResourceController',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Schedule resource that has a schedule resource controller.
            '''

        })
    '''
    Schedule resource that has a schedule resource controller.
    '''
    
@dataclass(repr=False)
class SubstationController(EquipmentController):
    '''
    Substation controller is controlling the equipment to optimize the use
    of the controlling equipment within a substation.
    '''

    mode: Optional[ SubstationControllerModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Mode of the substation controller.
            '''

        })
    '''
    Mode of the substation controller.
    '''
    
@dataclass(repr=False)
class TCSCController(EquipmentController):
    '''
    TCSC controller is controlling the equipment to optimize the performance
    of the TCSC.
    '''

    mode: Optional[ TCSCControlModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Mode of the TCSC controller.
            '''

        })
    '''
    Mode of the TCSC controller.
    '''
    
@dataclass(repr=False)
class TapChangerController(EquipmentController):
    '''
    Tap changer controller is an equipment controller that controls a tap changer,
    e.g. how the voltage at the end of a line varies with the load level and
    compensation of the voltage drop by tap adjustment.
    '''

    TapChanger: list[TapChanger] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TapChanger.TapChangeController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All tap changers controlled by this controller.
            '''

        })
    '''
    All tap changers controlled by this controller.
    '''
    
@dataclass(repr=False)
class UnifiedPowerFlowController(EquipmentController):
    '''
    Unified power flow controller (UPFC) is providing fast-acting reactive
    power compensation on high-voltage electricity transmission networks.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Control'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ProtectionFunction(AutomationFunction):
    '''
    Protection function is an automation function that can protect one or multiple
    equipment.
    '''

    ProtectionSettingsGroup: list[ProtectionSettingsGroup] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionSettingsGroup.ProtectionFunction',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Protection-settings group can be defined 0 to many for a protection function.
            '''
        
        })
    '''
    Protection-settings group can be defined 0 to many for a protection
    function.
    '''
    
    protectionFunctionRoleType: Optional[ ProtectionFunctionRoleKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute means the role of ProtectionFunction instance.
            '''

        })
    '''
    This attribute means the role of ProtectionFunction instance.
    '''

    protectionFunctionSchemeType: Optional[ ProtectionFunctionSchemeKInd ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attibute means the kind of protection relay scheme, e.g busbar protection,
            generation protection and so on.
            '''

        })
    '''
    This attibute means the kind of protection relay scheme, e.g busbar
    protection, generation protection and so on.
    '''

    ProtectionEquipment: Optional[ProtectionEquipment] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ProtectionEquipment.ProtectionFunction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Protection equipment may contain protection functions.
            '''

        })
    '''
    Protection equipment may contain protection functions.
    '''

    RelayDynamics: Optional[RelayDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RelayDynamics.ProtectionFunction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The relay dynamics may represent the detail logic of the ProtectionFunction.
            '''

        })
    '''
    The relay dynamics may represent the detail logic of the ProtectionFunction.
    '''
    
@dataclass(repr=False)
class SystemControl(AutomationFunction):
    '''
    System control is the management and regulation of various parameters within
    the electrical grid to ensure its stable and reliable operation. The primary
    goal of system control is to maintain the balance between electricity generation
    and consumption, while also managing factors such as voltage, frequency,
    and power quality. This involves the use of control devices, automation,
    and monitoring systems to respond to changes in the grid and maintain its
    overall stability.
    This serves as Integrated AC and DC control system (IEC 60633) which governs
    the integrated operation of AC and DC systems of a power system.
    '''

    EquipmentController: list[EquipmentController] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EquipmentController.SystemControl',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Equipment controller controlles by this system control
            '''

        })
    '''
    Equipment controller controlles by this system control
    '''
    
@dataclass(repr=False)
class AreaInterchangeController(SystemControl):
    '''
    Area interchange control is set to control active power of an area.
    '''

    pTolerance: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power net interchange tolerance. The attribute shall be a positive
            value or zero.
            '''

        })
    '''
    Active power net interchange tolerance. The attribute shall be a positive
    value or zero.
    '''

    BiddingZone: Optional[BiddingZone] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BiddingZone.AreaInterchangeController',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Bidding zone which has an area interchange controller.
            '''

        })
    '''
    Bidding zone which has an area interchange controller.
    '''

    BiddingZoneBorder: Optional[BiddingZoneBorder] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BiddingZoneBorder.AreaInterchangeController',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Bidding zone border that has an area interchange controller.
            '''

        })
    '''
    Bidding zone border that has an area interchange controller.
    '''

    ControlArea: Optional[ControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlArea.AreaInterchangeController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Control area that has a area interchange controller.
            '''

        })
    '''
    Control area that has a area interchange controller.
    '''
    
@dataclass(repr=False)
class PowerFrequencyController(SystemControl):
    '''
    Power frequency controller is controlling the active power balance as typically
    done by the secondary control. If an unbalance between the scheduled active
    power values of each generation unit and the loads plus losses occurs,
    primary control will adapt (increase/decrease) the active power production
    of each unit (depending on the power shift key strategy), leading to an
    over- or under-frequency situation. The secondary frequency controller
    will then control the frequency back to its nominal value, re- establishing
    a cost-efficient generation delivered by each unit.
    '''

    FrequencyMonitoringTerminal: list[FrequencyMonitoringTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FrequencyMonitoringTerminal.PowerFrequencyController',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Frequency monitoring terminal for this power frequency controller.
            '''
        
        })
    '''
    Frequency monitoring terminal for this power frequency controller.
    '''
    
    mode: Optional[ PowerFrequencyControlKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Mode of the power frequency controller.
            '''

        })
    '''
    Mode of the power frequency controller.
    '''

    ControlArea: Optional[ControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlArea.PowerFrequencyController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Control area which has a power frequency controller.
            '''

        })
    '''
    Control area which has a power frequency controller.
    '''

    MonitoringArea: Optional[MonitoringArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MonitoringArea.PowerFrequencyController',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Monitoring area that has this power frequency controller.
            '''

        })
    '''
    Monitoring area that has this power frequency controller.
    '''

    PowerShiftKeyStrategy: Optional[PowerShiftKeyStrategy] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerShiftKeyStrategy.PowerFrequencyController',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Power shift key strategy for this power frequency controller.
            '''

        })
    '''
    Power shift key strategy for this power frequency controller.
    '''
    
@stereotype(CIMStereotype.NC)
@dataclass(repr=False)
class BiddingZone(PowerSystemResource):
    '''
    A bidding zone is a market-based method for handling power transmission
    congestion. It consists of scheduling areas that include the relevant production
    (supply) and consumption (demand) to form an electrical area with the same
    market price without capacity allocation.
    '''

    AreaInterchangeController: Optional[AreaInterchangeController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AreaInterchangeController.BiddingZone',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Area interchange controller for this bidding zone.
            '''

        })
    '''
    Area interchange controller for this bidding zone.
    '''
    
@stereotype(CIMStereotype.NC)
@dataclass(repr=False)
class BiddingZoneBorder(PowerSystemResource):
    '''
    Defines the aggregated connection capacity between two Bidding Zones.
    '''

    AreaInterchangeController: Optional[AreaInterchangeController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AreaInterchangeController.BiddingZoneBorder',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Area interchange controller that relates to this bidding zone border.
            '''

        })
    '''
    Area interchange controller that relates to this bidding zone border.
    '''
    
@stereotype(CIMStereotype.European)
@dataclass(repr=False)
class BoundaryPoint(PowerSystemResource):
    '''
    Designates a connection point at which one or more model authority sets
    shall connect to. The location of the connection point as well as other
    properties are agreed between organisations responsible for the interconnection,
    hence all attributes of the class represent this agreement. It is primarily
    used in a boundary model authority set which can contain one or many BoundaryPoint-s
    among other Equipment-s and their connections.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'European',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.BoundaryPoint',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The connectivity node that is designated as a boundary point.
            '''
        
        })
    '''
    The connectivity node that is designated as a boundary point.
    '''
    
    fromEndIsoCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The ISO code of the region which the "From" side of the Boundary point
            belongs to or it is connected to.
            The ISO code is a two-character country code as defined by ISO 3166 (http://www.iso.org/iso/country_codes).
            The length of the string is 2 characters maximum.
            '''

        })
    '''
    The ISO code of the region which the "From" side of the Boundary point
    belongs to or it is connected to.
    The ISO code is a two-character country code as defined by ISO 3166
    (http://www.iso.org/iso/country_codes). The length of the string is
    2 characters maximum.
    '''

    fromEndName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            A human readable name with length of the string 64 characters maximum.
            It covers the following two cases:
            -if the Boundary point is placed on a tie-line, it is the name (IdentifiedObject.name)
            of the substation at which the "From" side of the tie-line is connected
            to.
            -if the Boundary point is placed in a substation, it is the name (IdentifiedObject.name)
            of the element (e.g. PowerTransformer, ACLineSegment, Switch, etc.) at
            which the "From" side of the Boundary point is connected to.
            '''

        })
    '''
    A human readable name with length of the string 64 characters maximum.
    It covers the following two cases:
    -if the Boundary point is placed on a tie-line, it is the name (IdentifiedObject.name)
    of the substation at which the "From" side of the tie-line is connected
    to.
    -if the Boundary point is placed in a substation, it is the name (IdentifiedObject.name)
    of the element (e.g. PowerTransformer, ACLineSegment, Switch, etc.)
    at which the "From" side of the Boundary point is connected to.
    '''

    fromEndNameTso: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            Identifies the name of the transmission system operator, distribution system
            operator or other entity at which the "From" side of the interconnection
            is connected to. The length of the string is 64 characters maximum.
            '''

        })
    '''
    Identifies the name of the transmission system operator, distribution
    system operator or other entity at which the "From" side of the interconnection
    is connected to. The length of the string is 64 characters maximum.
    '''

    isDirectCurrent: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            If true, this boundary point is a point of common coupling (PCC) of a direct
            current (DC) interconnection, otherwise the interconnection is AC (default).
            '''

        })
    '''
    If true, this boundary point is a point of common coupling (PCC) of
    a direct current (DC) interconnection, otherwise the interconnection
    is AC (default).
    '''

    isExcludedFromAreaInterchange: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            If true, this boundary point is on the interconnection that is excluded
            from control area interchange calculation and consequently has no related
            tie flows. Otherwise, the interconnection is included in control area interchange
            and a TieFlow is required at all sides of the boundary point (default).
            '''

        })
    '''
    If true, this boundary point is on the interconnection that is excluded
    from control area interchange calculation and consequently has no related
    tie flows. Otherwise, the interconnection is included in control area
    interchange and a TieFlow is required at all sides of the boundary
    point (default).
    '''

    toEndIsoCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The ISO code of the region which the "To" side of the Boundary point belongs
            to or is connected to.
            The ISO code is a two-character country code as defined by ISO 3166 (http://www.iso.org/iso/country_codes).
            The length of the string is 2 characters maximum.
            '''

        })
    '''
    The ISO code of the region which the "To" side of the Boundary point
    belongs to or is connected to.
    The ISO code is a two-character country code as defined by ISO 3166
    (http://www.iso.org/iso/country_codes). The length of the string is
    2 characters maximum.
    '''

    toEndName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            A human readable name with length of the string 64 characters maximum.
            It covers the following two cases:
            -if the Boundary point is placed on a tie-line, it is the name (IdentifiedObject.name)
            of the substation at which the "To" side of the tie-line is connected to.
            -if the Boundary point is placed in a substation, it is the name (IdentifiedObject.name)
            of the element (e.g. PowerTransformer, ACLineSegment, Switch, etc.) at
            which the "To" side of the Boundary point is connected to.
            '''

        })
    '''
    A human readable name with length of the string 64 characters maximum.
    It covers the following two cases:
    -if the Boundary point is placed on a tie-line, it is the name (IdentifiedObject.name)
    of the substation at which the "To" side of the tie-line is connected
    to.
    -if the Boundary point is placed in a substation, it is the name (IdentifiedObject.name)
    of the element (e.g. PowerTransformer, ACLineSegment, Switch, etc.)
    at which the "To" side of the Boundary point is connected to.
    '''

    toEndNameTso: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            Identifies the name of the transmission system operator, distribution system
            operator or other entity at which the "To" side of the interconnection
            is connected to. The length of the string is 64 characters maximum.
            '''

        })
    '''
    Identifies the name of the transmission system operator, distribution
    system operator or other entity at which the "To" side of the interconnection
    is connected to. The length of the string is 64 characters maximum.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'European',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.BoundaryPoint',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The connectivity node that is designated as a boundary point.
            '''

        })
    '''
    The connectivity node that is designated as a boundary point.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CAESPlant(PowerSystemResource):
    '''
    Compressed air energy storage plant.
    '''

    AirCompressor: Optional[AirCompressor] = field(
        default=None,
        metadata={
        'type': 'European',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.BoundaryPoint',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The connectivity node that is designated as a boundary point.
            '''

        })
    '''
    The connectivity node that is designated as a boundary point.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.CAESPlant',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''

    energyStorageCapacity: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The rated energy storage capacity. The attribute shall be a positive value.
            '''

        })
    '''
    The rated energy storage capacity. The attribute shall be a positive
    value.
    '''

    ratedCapacityP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The CAES plant's gross rated generating capacity. The attribute shall be
            a positive value.
            '''

        })
    '''
    The CAES plant's gross rated generating capacity. The attribute shall
    be a positive value.
    '''

    AirCompressor: Optional[AirCompressor] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'AirCompressor.CAESPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''

        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.CAESPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''

        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CogenerationPlant(PowerSystemResource):
    '''
    A set of thermal generating units for the production of electrical energy
    and process steam (usually from the output of the steam turbines). The
    steam sendout is typically used for industrial purposes or for municipal
    heating and cooling.
    '''

    SteamSendoutSchedule: Optional[SteamSendoutSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AirCompressor.CAESPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''

        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''
    
    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.CAESPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''

        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CogenerationPlant(PowerSystemResource):
    '''
    A set of thermal generating units for the production of electrical energy
    and process steam (usually from the output of the steam turbines). The
    steam sendout is typically used for industrial purposes or for municipal
    heating and cooling.
    '''

    cogenHPSendoutRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The high pressure steam sendout.
            '''

        })
    '''
    The high pressure steam sendout.
    '''

    cogenHPSteamRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The high pressure steam rating.
            '''

        })
    '''
    The high pressure steam rating.
    '''

    cogenLPSendoutRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The low pressure steam sendout.
            '''

        })
    '''
    The low pressure steam sendout.
    '''

    cogenLPSteamRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The low pressure steam rating.
            '''

        })
    '''
    The low pressure steam rating.
    '''

    ratedP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The rated output active power of the cogeneration plant.
            The attribute shall be a positive value.
            '''

        })
    '''
    The rated output active power of the cogeneration plant.
    The attribute shall be a positive value.
    '''

    SteamSendoutSchedule: Optional[SteamSendoutSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'SteamSendoutSchedule.CogenerationPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''

        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
@dataclass(repr=False)
class CombinedCyclePlant(PowerSystemResource):
    '''
    A set of combustion turbines and steam turbines where the exhaust heat
    from the combustion turbines is recovered to make steam for the steam turbines,
    resulting in greater overall plant efficiency.
    '''
    
    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ThermalGeneratingUnit.CogenerationPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a cogeneration plant.
            '''

        })
    '''
    A thermal generating unit may be a member of a cogeneration plant.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CombinedCyclePlant(PowerSystemResource):
    '''
    A set of combustion turbines and steam turbines where the exhaust heat
    from the combustion turbines is recovered to make steam for the steam turbines,
    resulting in greater overall plant efficiency.
    '''

    combCyclePlantRating: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The combined cycle plant's active power output rating.
            '''

        })
    '''
    The combined cycle plant's active power output rating.
    '''
    
@dataclass(repr=False)
class CombustionTurbine(PowerSystemResource):
    '''
    A prime mover that is typically fuelled by gas or light oil.
    '''

    AirCompressor: Optional[AirCompressor] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AirCompressor.CombustionTurbine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A CAES air compressor is driven by combustion turbine.
            '''

        })
    '''
    A CAES air compressor is driven by combustion turbine.
    '''
    
@dataclass(repr=False)
class CommunicationLink(PowerSystemResource):
    '''
    The connection to remote units is through one or more communication links.
    Reduntant links may exist. The CommunicationLink class inherits PowerSystemResource.
    The intention is to allow CommunicationLinks to have Measurements. These
    Measurements can be used to model link status as operational, out of service,
    unit failure etc.
    '''

    communicationMediumKind: Optional[ CommunicationMediumKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration GridAPPSD Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    communicationMediumKind: Optional[ CommunicationMediumKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration GridAPPSD Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    communicationProtocolType: Optional[ CommunicationProtocolKind ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BilateralExchangeActor.CommunicationLink',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            ICCP data provider or consumer using communication addressing for a Bilateral
            table.
            '''

        })
    '''
    ICCP data provider or consumer using communication addressing for a
    Bilateral table.
    '''
    
    BilateralExchangeActor: Optional[BilateralExchangeActor] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeasurementSystem.CommunicationLink',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    ICCP data provider or consumer using communication addressing for a
    Bilateral table.
    '''
    
@dataclass(repr=False)
class ConnectivityNodeContainer(PowerSystemResource):
    '''
    A base class for all objects that may contain connectivity nodes or topological
    nodes.
    '''

    ConnectivityNodes: list[ConnectivityNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConnectivityNode.ConnectivityNodeContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Connectivity nodes which belong to this connectivity node container.
            '''

        })
    '''
    Connectivity nodes which belong to this connectivity node container.
    '''

    TopologicalNode: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.ConnectivityNodeContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The topological nodes which belong to this connectivity node container.
            '''

        })
    '''
    The topological nodes which belong to this connectivity node container.
    '''
    
@dataclass(repr=False)
class EquipmentContainer(ConnectivityNodeContainer):
    '''
    A modelling construct to provide a root class for containing equipment.
    '''

    AdditionalGroupedEquipment: list[Equipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Equipment.AdditionalEquipmentContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The additonal contained equipment. The equipment belong to the equipment
            container. The equipment is contained in another equipment container, but
            also grouped with this equipment container. Examples include when a switch
            contained in a substation is also desired to be grouped with a line contianer
            or when a switch is included in a secondary substation and also grouped
            in a feeder.
            '''

        })
    '''
    The additonal contained equipment. The equipment belong to the equipment
    container. The equipment is contained in another equipment container,
    but also grouped with this equipment container. Examples include when
    a switch contained in a substation is also desired to be grouped with
    a line contianer or when a switch is included in a secondary substation
    and also grouped in a feeder.
    '''

    Equipments: list[Equipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Equipment.EquipmentContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Contained equipment.
            '''

        })
    '''
    Contained equipment.
    '''
    
@dataclass(repr=False)
class Bay(EquipmentContainer):
    '''
    A collection of power system resources (within a given substation) including
    conducting equipment, protection relays, measurements, and telemetry. A
    bay typically represents a physical grouping related to modularization
    of equipment.
    '''

    bayEnergyMeasFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates the presence/absence of energy measurements.
            '''

        })
    '''
    Indicates the presence/absence of energy measurements.
    '''

    bayPowerMeasFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates the presence/absence of active/reactive power measurements.
            '''

        })
    '''
    Indicates the presence/absence of active/reactive power measurements.
    '''

    breakerConfiguration: Optional[ BreakerConfiguration ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Breaker configuration.
            '''

        })
    '''
    Breaker configuration.
    '''

    busBarConfiguration: Optional[ BusbarConfiguration ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Busbar configuration.
            '''

        })
    '''
    Busbar configuration.
    '''

    Circuit: Optional[Circuit] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Circuit.EndBay',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Circuit containing the bay.
            '''

        })
    '''
    Circuit containing the bay.
    '''

    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.Bays',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Substation containing the bay.
            '''

        })
    '''
    Substation containing the bay.
    '''

    VoltageLevel: Optional[VoltageLevel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageLevel.Bays',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage level containing this bay.
            '''

        })
    '''
    The voltage level containing this bay.
    '''
    
@dataclass(repr=False)
class DCConverterUnit(EquipmentContainer):
    '''
    Indivisible operative unit comprising all equipment between the point of
    common coupling on the AC side and the point of common coupling � DC side,
    essentially one or more converters, together with one or more converter
    transformers, converter control equipment, essential protective and switching
    devices and auxiliaries, if any, used for conversion.
    '''

    ACPointOfCommonCoupling: Optional[ACPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACPointOfCommonCoupling.DCConverterUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            AC point of common coupling for this DC converter unit.
            '''

        })
    '''
    AC point of common coupling for this DC converter unit.
    '''

    DCPointOfCommonCoupling: Optional[DCPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCPointOfCommonCoupling.DCConverterUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DCNode that is the point of common coupling at DC side of this DCConverterUnit.
            '''

        })
    '''
    DCNode that is the point of common coupling at DC side of this DCConverterUnit.
    '''
    
@dataclass(repr=False)
class DCSubstationBipole(EquipmentContainer):
    '''
    Part of a bipolar DC system (IEC 60633) contained within a DC substation.
    '''

    DirectCurrentSubstationBipoleController: Optional[DirectCurrentSubstationBipoleController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentSubstationBipoleController.DCSubstationBipole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation bipole controller controlling this DC substation bipole.
            '''

        })
    '''
    DC substation bipole controller controlling this DC substation bipole.
    '''
    
@dataclass(repr=False)
class DCSubstationPole(EquipmentContainer):
    '''
    Part of an DC system pole (IEC 60633) which is contained within a DC substation.
    '''

    DirectCurrentSubstationPoleController: Optional[DirectCurrentSubstationPoleController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentSubstationPoleController.DCSubstationPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation pole controller controlling this DC substation pole.
            '''

        })
    '''
    DC substation pole controller controlling this DC substation pole.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Feeder(EquipmentContainer):
    '''
    A collection of equipment for organizational purposes, used for grouping
    distribution resources.
    The organization a feeder does not necessarily reflect connectivity or
    current operation state.
    '''

    NormalEnergizingSubstation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.NormalEnergizedFeeder',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The substation that nominally energizes the feeder. Also used for naming
            purposes.
            '''

        })
    '''
    The substation that nominally energizes the feeder. Also used for naming
    purposes.
    '''
    
    NormalHeadTerminal: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubSchedulingArea.Feeder',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The subscheduling area that has this feeder.
            '''

        })
    '''
    The subscheduling area that has this feeder.
    '''
    
    NormalEnergizingSubstation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Substation.NamingFeeder',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The secondary substations that are normally energized from the feeder.
            Used for naming purposes. Should be consistent with the other associations
            for energizing terminal specification and the feeder energization specification.
            '''

        })
    '''
    The secondary substations that are normally energized from the feeder.
    Used for naming purposes. Should be consistent with the other associations
    for energizing terminal specification and the feeder energization specification.
    '''
    
    SubSchedulingArea: Optional[SubSchedulingArea] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.NormalHeadFeeder',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal head terminal or terminals of the feeder.
            '''

        })
    '''
    The normal head terminal or terminals of the feeder.
    '''
    
@dataclass(repr=False)
class Line(EquipmentContainer):
    '''
    Contains equipment beyond a substation belonging to a power transmission
    line.
    '''

    ACTieCorridor: Optional[ACTieCorridor] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACTieCorridor.Line',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            ACTieCorridor that the line is part of.
            '''

        })
    '''
    ACTieCorridor that the line is part of.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubGeographicalRegion.Lines',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The sub-geographical region of the line.
            '''

        })
    '''
    The sub-geographical region of the line.
    '''

    SchedulingArea: Optional[SchedulingArea] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SchedulingArea.Line',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The scheduling area that has this line.
            '''

        })
    '''
    The scheduling area that has this line.
    '''
    
@stereotype(CIMStereotype.NC)
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class Circuit(Line):
    '''
    '''

    EndBay: list[Bay] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bay.Circuit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class Plant(EquipmentContainer):
    '''
    A Plant is a collection of equipment for purposes of generation.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Substation(EquipmentContainer):
    '''
    A collection of equipment for purposes other than generation or utilization,
    through which electric energy in bulk is passed for the purposes of switching
    or modifying its characteristics.
    '''

    Bays: list[Bay] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bay.Substation',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Bays contained in the substation.
            '''
        
        })
    '''
    Bays contained in the substation.
    '''
    
    NormalEnergizedFeeder: list[Feeder] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Feeder.NormalEnergizingSubstation',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal energized feeders of the substation. Also used for naming purposes.
            '''
        
        })
    '''
    The normal energized feeders of the substation. Also used for naming
    purposes.
    '''
    
    VoltageLevels: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.Substation',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage levels within this substation.
            '''
        
        })
    '''
    The voltage levels within this substation.
    '''
    
    NamingFeeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.NamingSecondarySubstation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The primary feeder that normally energizes the secondary substation. Used
            for naming purposes. Either this association or the substation to subgeographical
            region should be used for hierarchical containment specification.
            '''

        })
    '''
    The primary feeder that normally energizes the secondary substation.
    Used for naming purposes. Either this association or the substation
    to subgeographical region should be used for hierarchical containment
    specification.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubGeographicalRegion.Substations',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SubGeographicalRegion containing the substation.
            '''

        })
    '''
    The SubGeographicalRegion containing the substation.
    '''

    SchedulingArea: Optional[SchedulingArea] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SchedulingArea.Substation',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The scheduling area that has this substation.
            '''

        })
    '''
    The scheduling area that has this substation.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class VoltageLevel(EquipmentContainer):
    '''
    A collection of equipment at one common system voltage forming a switchgear.
    The equipment typically consists of breakers, busbars, instrumentation,
    control, regulation and protection devices as well as assemblies of all
    these.
    '''
    
    NormalEnergizedFeeder: list[Feeder] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Feeder.NormalEnergizingSubstation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal energized feeders of the substation. Also used for naming purposes.
            '''

        })
    '''
    The normal energized feeders of the substation. Also used for naming
    purposes.
    '''
    
    VoltageLevels: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.Substation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage levels within this substation.
            '''
        
        })
    '''
    The voltage levels within this substation.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class VoltageLevel(EquipmentContainer):
    '''
    A collection of equipment at one common system voltage forming a switchgear.
    The equipment typically consists of breakers, busbars, instrumentation,
    control, regulation and protection devices as well as assemblies of all
    these.
    '''

    highVoltageLimit: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The bus bar's high voltage limit.
            The limit applies to all equipment and nodes contained in a given VoltageLevel.
            It is not required that it is exchanged in pair with lowVoltageLimit. It
            is preferable to use operational VoltageLimit, which prevails, if present.
            '''

        })
    '''
    The bus bar's high voltage limit.
    The limit applies to all equipment and nodes contained in a given VoltageLevel.
    It is not required that it is exchanged in pair with lowVoltageLimit.
    It is preferable to use operational VoltageLimit, which prevails, if
    present.
    '''

    lowVoltageLimit: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The bus bar's low voltage limit.
            The limit applies to all equipment and nodes contained in a given VoltageLevel.
            It is not required that it is exchanged in pair with highVoltageLimit.
            It is preferable to use operational VoltageLimit, which prevails, if present.
            '''

        })
    '''
    The bus bar's low voltage limit.
    The limit applies to all equipment and nodes contained in a given VoltageLevel.
    It is not required that it is exchanged in pair with highVoltageLimit.
    It is preferable to use operational VoltageLimit, which prevails, if
    present.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.VoltageLevel',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The base voltage used for all equipment within the voltage level.
            '''

        })
    '''
    The base voltage used for all equipment within the voltage level.
    '''

    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Substation.VoltageLevels',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The substation of the voltage level.
            '''

        })
    '''
    The substation of the voltage level.
    '''
    
@dataclass(repr=False)
class ControlArea(PowerSystemResource):
    '''
    A control area is a grouping of generating units and/or loads and a cutset
    of tie lines (as terminals) which may be used for a variety of purposes
    including automatic generation control, power flow solution area interchange
    control specification, and input to load forecasting. All generation and
    load within the area defined by the terminals on the border are considered
    in the area interchange control. Note that any number of overlapping control
    area specifications may be superimposed on the physical model. The following
    general principles apply to ControlArea:
    1. The control area orientation for net interchange is positive for an
    import, negative for an export.
    2. The control area net interchange is determined by summing flows in Terminals.
    The Terminals are identified by creating a set of TieFlow objects associated
    with a ControlArea object. Each TieFlow object identifies one Terminal.
    3. In a single network model, a tie between two control areas must be modelled
    in both control area specifications, such that the two representations
    of the tie flow sum to zero.
    4. The normal orientation of Terminal flow is positive for flow into the
    conducting equipment that owns the Terminal. (i.e. flow from a bus into
    a device is positive.) However, the orientation of each flow in the control
    area specification must align with the control area convention, i.e. import
    is positive. If the orientation of the Terminal flow referenced by a TieFlow
    is positive into the control area, then this is confirmed by setting TieFlow.positiveFlowIn
    flag TRUE. If not, the orientation must be reversed by setting the TieFlow.positiveFlowIn
    flag FALSE.
    '''

    AreaInterchangeController: Optional[AreaInterchangeController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AreaInterchangeController.ControlArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Area interchange controller for this control area.
            '''

        })
    '''
    Area interchange controller for this control area.
    '''

    EnergyArea: Optional[EnergyArea] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyArea.ControlArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The energy area that is forecast from this control area specification.
            '''

        })
    '''
    The energy area that is forecast from this control area specification.
    '''

    PowerFrequencyController: Optional[PowerFrequencyController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerFrequencyController.ControlArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power frequency controller for this control area.
            '''

        })
    '''
    Power frequency controller for this control area.
    '''
    
@dataclass(repr=False)
class DCPole(PowerSystemResource):
    '''
    The direct current (DC) system pole (IEC 60633) is part of a DC system
    consisting of all the equipment in the DC substations and the interconnecting
    transmission lines, if any, which during normal operation exhibit a common
    direct voltage polarity with respect to earth.
    '''

    DirectCurrentPoleController: Optional[DirectCurrentPoleController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentPoleController.DCPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC pole controller that controls this DC pole.
            '''

        })
    '''
    DC pole controller that controls this DC pole.
    '''
    
@dataclass(repr=False)
class DCTieCorridor(PowerSystemResource):
    '''
    A collection of one or more direct current poles that connect two different
    control areas.
    '''

    DirectCurrentMasterController: Optional[DirectCurrentMasterController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentMasterController.DCTieCorridor',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Direct current master controller for this DCTieCorridor.
            '''

        })
    '''
    Direct current master controller for this DCTieCorridor.
    '''
    
@dataclass(repr=False)
class EnergyConsumerPhase(PowerSystemResource):
    '''
    A single phase of an energy consumer.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power of the load. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''

        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    pfixed: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power of the load that is a fixed quantity. Load sign convention
            is used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Active power of the load that is a fixed quantity. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    pfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fixed active power as per cent of load group fixed active power. Load sign
            convention is used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Fixed active power as per cent of load group fixed active power. Load
    sign convention is used, i.e. positive sign means flow out from a node.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase of this energy consumer component. If the energy consumer is wye
            connected, the connection is from the indicated phase to the central ground
            or neutral point. If the energy consumer is delta connected, the phase
            indicates an energy consumer connected from the indicated phase to the
            next logical non-neutral phase.
            '''

        })
    '''
    Phase of this energy consumer component. If the energy consumer is
    wye connected, the connection is from the indicated phase to the central
    ground or neutral point. If the energy consumer is delta connected,
    the phase indicates an energy consumer connected from the indicated
    phase to the next logical non-neutral phase.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power of the load. Load sign convention is used, i.e. positive
            sign means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''

        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    qfixed: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power of the load that is a fixed quantity. Load sign convention
            is used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Reactive power of the load that is a fixed quantity. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    qfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fixed reactive power as per cent of load group fixed reactive power. Load
            sign convention is used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Fixed reactive power as per cent of load group fixed reactive power.
    Load sign convention is used, i.e. positive sign means flow out from
    a node.
    '''

    EnergyConsumer: Optional[EnergyConsumer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumer.EnergyConsumerPhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The energy consumer to which this phase belongs.
            '''

        })
    '''
    The energy consumer to which this phase belongs.
    '''
    
@dataclass(repr=False)
class EnergySourcePhase(PowerSystemResource):
    '''
    Represents the single phase information of an unbalanced energy source.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase of this energy source component. If the energy source wye connected,
            the connection is from the indicated phase to the central ground or neutral
            point. If the energy source is delta connected, the phase indicates an
            energy source connected from the indicated phase to the next logical non-neutral
            phase.
            '''

        })
    '''
    Phase of this energy source component. If the energy source wye connected,
    the connection is from the indicated phase to the central ground or
    neutral point. If the energy source is delta connected, the phase indicates
    an energy source connected from the indicated phase to the next logical
    non-neutral phase.
    '''

    EnergySource: Optional[EnergySource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'EnergySource.EnergySourcePhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The energy sourceto which the phase belongs.
            '''

        })
    '''
    The energy sourceto which the phase belongs.
    '''
    
@dataclass(repr=False)
class Equipment(PowerSystemResource):
    '''
    The parts of a power system that are physical devices, electronic or mechanical.
    '''

    ContingencyEquipment: list[ContingencyEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ContingencyEquipment.Equipment',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The contingency equipments in which this equipment participates.
            '''
        
        })
    '''
    The contingency equipments in which this equipment participates.
    '''
    
    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.Equipment',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit sets associated with this equipment.
            '''
        
        })
    '''
    The operational limit sets associated with this equipment.
    '''
    
    aggregate: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The aggregate flag provides an alternative way of representing an aggregated
            (equivalent) element. It is applicable in cases when the dedicated classes
            for equivalent equipment do not have all of the attributes necessary to
            represent the required level of detail. In case the flag is set to "true"
            the single instance of equipment represents multiple pieces of equipment
            that have been modelled together as an aggregate equivalent obtained by
            a network reduction procedure. Examples would be power transformers or
            synchronous machines operating in parallel modelled as a single aggregate
            power transformer or aggregate synchronous machine.
            The attribute is not used for EquivalentBranch, EquivalentShunt, EquivalentInjection
            and ExternalNetworkInjection.
            '''

        })
    '''
    The aggregate flag provides an alternative way of representing an aggregated
    (equivalent) element. It is applicable in cases when the dedicated
    classes for equivalent equipment do not have all of the attributes
    necessary to represent the required level of detail. In case the flag
    is set to "true" the single instance of equipment represents multiple
    pieces of equipment that have been modelled together as an aggregate
    equivalent obtained by a network reduction procedure. Examples would
    be power transformers or synchronous machines operating in parallel
    modelled as a single aggregate power transformer or aggregate synchronous
    machine.
    The attribute is not used for EquivalentBranch, EquivalentShunt, EquivalentInjection
    and ExternalNetworkInjection.
    '''

    inService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the availability of the equipment. True means the equipment is
            available for topology processing, which determines if the equipment is
            energized or not. False means that the equipment is treated by network
            applications as if it is not in the model.
            '''

        })
    '''
    Specifies the availability of the equipment. True means the equipment
    is available for topology processing, which determines if the equipment
    is energized or not. False means that the equipment is treated by network
    applications as if it is not in the model.
    '''

    networkAnalysisEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The equipment is enabled to participate in network analysis. If unspecified,
            the value is assumed to be true.
            '''

        })
    '''
    The equipment is enabled to participate in network analysis. If unspecified,
    the value is assumed to be true.
    '''

    normallyInService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the availability of the equipment under normal operating conditions.
            True means the equipment is available for topology processing, which determines
            if the equipment is energized or not. False means that the equipment is
            treated by network applications as if it is not in the model.
            '''

        })
    '''
    Specifies the availability of the equipment under normal operating
    conditions. True means the equipment is available for topology processing,
    which determines if the equipment is energized or not. False means
    that the equipment is treated by network applications as if it is not
    in the model.
    '''

    AdditionalEquipmentContainer: list[EquipmentContainer] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EquipmentContainer.AdditionalGroupedEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Additional equipment container beyond the primary equipment container.
            The equipment is contained in another equipment container, but also grouped
            with this equipment container.
            '''

        })
    '''
    Additional equipment container beyond the primary equipment container.
    The equipment is contained in another equipment container, but also
    grouped with this equipment container.
    '''

    EquipmentContainer: Optional[EquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EquipmentContainer.Equipments',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Container of this equipment.
            '''

        })
    '''
    Container of this equipment.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CompositeSwitch(Equipment):
    '''
    A model of a set of individual Switches normally enclosed within the same
    cabinet and possibly with interlocks that restrict the combination of switch
    positions. These are typically found in medium voltage distribution networks.
    A CompositeSwitch could represent a Ring-Main-Unit (RMU), or pad-mounted
    switchgear, with primitive internal devices such as an internal bus-bar
    plus 3 or 4 internal switches each of which may individually be open or
    closed. A CompositeSwitch and a set of contained Switches can also be used
    to represent a multi-position switch e.g. a switch that can connect a circuit
    to Ground, Open or Busbar.
    '''
    
    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.Equipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit sets associated with this equipment.
            '''

        })
    '''
    The operational limit sets associated with this equipment.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CompositeSwitch(Equipment):
    '''
    A model of a set of individual Switches normally enclosed within the same
    cabinet and possibly with interlocks that restrict the combination of switch
    positions. These are typically found in medium voltage distribution networks.
    A CompositeSwitch could represent a Ring-Main-Unit (RMU), or pad-mounted
    switchgear, with primitive internal devices such as an internal bus-bar
    plus 3 or 4 internal switches each of which may individually be open or
    closed. A CompositeSwitch and a set of contained Switches can also be used
    to represent a multi-position switch e.g. a switch that can connect a circuit
    to Ground, Open or Busbar.
    '''

    compositeSwitchType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An alphanumeric code that can be used as a reference to extra information
            such as the description of the interlocking scheme if any.
            '''

        })
    '''
    An alphanumeric code that can be used as a reference to extra information
    such as the description of the interlocking scheme if any.
    '''
    
@dataclass(repr=False)
class ConductingEquipment(Equipment):
    '''
    The parts of the AC power system that are designed to carry current or
    that are conductively connected through terminals.
    '''

    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Switch.CompositeSwitch',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Switches contained in this Composite switch.
            '''

        })
    '''
    Switches contained in this Composite switch.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConductingEquipment(Equipment):
    '''
    The parts of the AC power system that are designed to carry current or
    that are conductively connected through terminals.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.ConductingEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Base voltage of this conducting equipment. Use only when there is no voltage
            level container used and only one base voltage applies. For example, not
            used for transformers.
            '''

        })
    '''
    Base voltage of this conducting equipment. Use only when there is no
    voltage level container used and only one base voltage applies. For
    example, not used for transformers.
    '''

    GroundingAction: Optional[GroundAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GroundAction.GroundedEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Action involving grounding operation on this conducting equipment.
            '''

        })
    '''
    Action involving grounding operation on this conducting equipment.
    '''

    JumpingAction: Optional[JumperAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'JumperAction.JumpedEquipments',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Jumper action involving jumping operation on this conducting equipment.
            '''

        })
    '''
    Jumper action involving jumping operation on this conducting equipment.
    '''

    Outage: Optional[Outage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Outage.OutageIsolationEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ResourceContainer: Optional[ResourceContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ResourceContainer.ContainedEquipment',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class ACDCConverter(ConductingEquipment):
    '''
    A unit with valves for three phases, together with unit control equipment,
    essential protective and switching devices, DC storage capacitors, phase
    reactors and auxiliaries, if any, used for conversion.
    '''

    ACDCConverterController: Optional[ACDCConverterController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCConverterController.ACDCConverter',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Direct current controller which controls the ACDC converter.
            '''

        })
    '''
    Direct current controller which controls the ACDC converter.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Clamp(ConductingEquipment):
    '''
    A Clamp is a galvanic connection at a line segment where other equipment
    is connected. A Clamp does not cut the line segment.
    A Clamp is ConductingEquipment and has one Terminal with an associated
    ConnectivityNode. Any other ConductingEquipment can be connected to the
    Clamp ConnectivityNode.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The length to the place where the clamp is located starting from side one
            of the line segment, i.e. the line segment terminal with sequence number
            equal to 1.
            '''

        })
    '''
    The length to the place where the clamp is located starting from side
    one of the line segment, i.e. the line segment terminal with sequence
    number equal to 1.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.Clamp',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line segment to which the clamp is connected.
            '''

        })
    '''
    The line segment to which the clamp is connected.
    '''

    ClampAction: Optional[ClampAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ClampAction.Clamp',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    JumperAction: Optional[JumperAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'JumperAction.Clamp',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Conductor(ConductingEquipment):
    '''
    Combination of conducting material with consistent electrical characteristics,
    building a single electrical system, used to carry current between points
    in the power system.
    '''

    length: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Segment length for calculating line segment capabilities.
            '''

        })
    '''
    Segment length for calculating line segment capabilities.
    '''

    DamageCurve: Optional[ConductorCharacteristicCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductorCharacteristicCurve.Conductor',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Damage curve associated to a conductor.
            '''

        })
    '''
    Damage curve associated to a conductor.
    '''
    
@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ACLineSegment(Conductor):
    '''
    A line segment is a conductor or combination of conductors, with consistent
    electrical characteristics along its length, building a single electrical
    system that carries alternating current between two points in the power
    system.
    The BaseVoltage at the two ends of a line segment shall have the same BaseVoltage.nominalVoltage.
    However, boundary lines may have slightly different BaseVoltage.nominalVoltages
    and variation is allowed. Larger voltage difference in general requires
    use of an equivalent branch.
    Line segment impedances can be either directly described in electrical
    terms or physical line detail can be provided from which impedances can
    be calculated.
    <b>Directly described impedances</b>
    For symmetrical, transposed three phase line segments, it is sufficient
    to use attributes of the line segment, which describe impedances and admittances
    for the entire length of the line segment. Additionally, line segment impedances
    can be computed by using line segment length and associated per length
    impedances.
    Unbalanced modeling of impedances is supported by the per length phase
    impedance matrix (PerLengthPhaseImpedance) in conjunction with phase-to-sequence
    number mapping supplied by either ACLineSegmentPhase or WirePosition. The
    sequence numbers are referenced by the row and column attributes of the
    per length phase impedance matrix. This method enables single-phase and
    two-phase line segments, and transpositions of phases, to be described
    using the same per length phase impedance matrix. The length of the line
    segment is used in the computation of total impedance values for the line
    segment.
    <b>Line detail characteristics</b>
    There are three approaches to providing line detail and all use WireAssembly
    to supply line positions:
    <ul>
    <li>Option 1 - WireAssembly supplies only line positions. ACLineSegmentPhase
    points to wire type and intraphase spacing and supplies the phase-to-sequence
    number mapping.</li>
    <li>Option 2 - WireAssembly supplies line position and, for each position,
    also supplies wire type and intraphase spacing. ACLineSegmentPhase supplies
    the phase-to-sequence number mapping.</li>
    <li>Option 3 - WireAssembly supplies line position and, for each position,
    also supplies wire type and intraphase spacing and phase. WireAssembly
    therefore supplies the phase-to-sequence number mapping and ACLineSegmentPhase
    is not needed.</li>
    </ul>
    '''

    ACLineSegmentPhases: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.ACLineSegment',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line segment phases which belong to the line segment.
            '''
        
        })
    '''
    The line segment phases which belong to the line segment.
    '''
    
    Clamp: list[Clamp] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Clamp.ACLineSegment',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The clamps connected to the line segment.
            '''
        
        })
    '''
    The clamps connected to the line segment.
    '''
    
    Cut: list[Cut] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Cut.ACLineSegment',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cuts applied to the line segment.
            '''
        
        })
    '''
    Cuts applied to the line segment.
    '''
    
    LineSegmentCoupling: Optional[LineSegmentCoupling] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LineSegmentCoupling.ACLineSegment',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The description of this line's coupling with other lines in a coupled group.
            '''
        
        })
    '''
    The description of this line's coupling with other lines in a coupled
    group.
    '''
    
    Poles: list[Pole] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Pole.ACLineSegment',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    b0ch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance, uniformly distributed, of the
            entire line segment.
            '''

        })
    '''
    Zero sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line segment.
    '''

    bch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance, uniformly distributed,
            of the entire line segment. This value represents the full charging over
            the full length of the line segment.
            '''

        })
    '''
    Positive sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line segment. This value represents the full charging
    over the full length of the line segment.
    '''

    g0ch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance, uniformly distributed, of the
            entire line segment.
            '''

        })
    '''
    Zero sequence shunt (charging) conductance, uniformly distributed,
    of the entire line segment.
    '''

    gch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance, uniformly distributed,
            of the entire line segment.
            '''

        })
    '''
    Positive sequence shunt (charging) conductance, uniformly distributed,
    of the entire line segment.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence series resistance of the entire line segment.
            '''

        })
    '''
    Positive sequence series resistance of the entire line segment.
    '''

    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence series resistance of the entire line segment.
            '''

        })
    '''
    Zero sequence series resistance of the entire line segment.
    '''

    shortCircuitEndTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum permitted temperature at the end of SC for the calculation of minimum
            short-circuit currents. Used for short circuit data exchange according
            to IEC 60909.
            '''

        })
    '''
    Maximum permitted temperature at the end of SC for the calculation
    of minimum short-circuit currents. Used for short circuit data exchange
    according to IEC 60909.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence series reactance of the entire line segment.
            '''

        })
    '''
    Positive sequence series reactance of the entire line segment.
    '''

    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence series reactance of the entire line segment.
            '''

        })
    '''
    Zero sequence series reactance of the entire line segment.
    '''

    EarthResistivity: Optional[EarthResistivity] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EarthResistivity.ACLineSegments',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    LineGroundingAction: Optional[GroundAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GroundAction.AlongACLineSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Ground action involving clamp usage (for the case when the ground is applied
            along the line segment instead of at its terminals).
            '''

        })
    '''
    Ground action involving clamp usage (for the case when the ground is
    applied along the line segment instead of at its terminals).
    '''

    LineJumpingAction: Optional[JumperAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'JumperAction.ACLineSegments',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Jumper action involving clamp usage (for the case when the jumper is applied
            along the line segment instead of at its terminals).
            '''

        })
    '''
    Jumper action involving clamp usage (for the case when the jumper is
    applied along the line segment instead of at its terminals).
    '''

    LineSegmentCoupling: Optional[LineSegmentCoupling] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LineSegmentCoupling.ACLineSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The description of this line's coupling with other lines in a coupled group.
            '''

        })
    '''
    The description of this line's coupling with other lines in a coupled
    group.
    '''

    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthImpedance.ACLineSegments',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Per-length impedance of this line segment.
            '''

        })
    '''
    Per-length impedance of this line segment.
    '''

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.ACLineSegements',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.ACLineSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class BusSegment(Conductor):
    '''
    A two terminal and power conducting device of negligible impedance and
    length represented as zero impedance device that can be used to represent
    the conductor between connection points to substation conducting equipment
    on a substation bus.
    '''

    Retain: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if retain
            '''

        })
    '''
    True if retain
    '''

    retained: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Bus segment is retained in the topological solution. The flow through retained
            bus sections will normally be calculated in power flow.
            '''

        })
    '''
    Bus segment is retained in the topological solution. The flow through
    retained bus sections will normally be calculated in power flow.
    '''
    
@dataclass(repr=False)
class WireSegment(Conductor):
    '''
    A two terminal and power conducting device of negligible impedance and
    length represented as zero impedance device that can be used to connect
    auxiliary equipment to its terminals.
    '''

    WireSegmentPhases: list[WireSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireSegmentPhase.WireSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The wire segment phases which belong to the wire segment.
            '''

        })
    '''
    The wire segment phases which belong to the wire segment.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Connector(ConductingEquipment):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation and are
    modelled with a single logical terminal.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BusbarSection(Connector):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation. The BusbarSection
    class is intended to represent physical parts of bus bars no matter how
    that bus bar is constructed.
    Voltage measurements are typically obtained from voltage transformers that
    are connected to busbar sections. A bus bar section may have many physical
    terminals but for analysis is modelled with exactly one logical terminal.
    '''

    ipMax: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum allowable peak short-circuit current of busbar (Ipmax in IEC 60909-0).
            Mechanical limit of the busbar in the substation itself. Used for short
            circuit data exchange according to IEC 60909.
            '''

        })
    '''
    Maximum allowable peak short-circuit current of busbar (Ipmax in IEC
    60909-0).
    Mechanical limit of the busbar in the substation itself. Used for short
    circuit data exchange according to IEC 60909.
    '''
    
    ipMax: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageControlZone.BusbarSection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''

        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''

    VoltageControlZone: Optional[VoltageControlZone] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageControlZone.BusbarSection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''

        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''
    
@dataclass(repr=False)
class Junction(Connector):
    '''
    A point where one or more conducting equipments are connected with zero
    resistance.
    The Junction class is intended to provide a place to associate additional
    information to a connectivity node which connects two or more equipment
    terminals. Examples include a tee-point or the connection point between
    two switches.
    The Junction class is intended to provide a method to associate additional
    information, for instance Location, to a ConnectivityNode. Examples include
    a T-point or the connection point between two switches. Typically, BusbarSection
    objects and Junction objects are represented by different symbols on diagrams.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class EarthFaultCompensator(ConductingEquipment):
    '''
    A conducting equipment used to represent a connection to ground which is
    typically used to compensate earth faults. An earth fault compensator device
    modelled with a single terminal implies a second terminal solidly connected
    to ground. If two terminals are modelled, the ground is not assumed and
    normal connection rules apply.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nominal resistance of device.
            '''

        })
    '''
    Nominal resistance of device.
    '''
    
@dataclass(repr=False)
class GroundingImpedance(EarthFaultCompensator):
    '''
    A fixed impedance device used for grounding.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactance of device.
            '''

        })
    '''
    Reactance of device.
    '''
    
@dataclass(repr=False)
class PetersenCoil(EarthFaultCompensator):
    '''
    A variable impedance device normally used to offset line charging during
    single line faults in an ungrounded section of network.
    '''

    mode: Optional[ PetersenCoilModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The mode of operation of the Petersen coil.
            '''

        })
    '''
    The mode of operation of the Petersen coil.
    '''

    nominalU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The nominal voltage for which the coil is designed.
            '''

        })
    '''
    The nominal voltage for which the coil is designed.
    '''

    offsetCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The offset current that the Petersen coil controller is operating from
            the resonant point. This is normally a fixed amount for which the controller
            is configured and could be positive or negative. Typically 0 to 60 A depending
            on voltage and resonance conditions.
            '''

        })
    '''
    The offset current that the Petersen coil controller is operating from
    the resonant point. This is normally a fixed amount for which the controller
    is configured and could be positive or negative. Typically 0 to 60
    A depending on voltage and resonance conditions.
    '''

    positionCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The control current used to control the Petersen coil also known as the
            position current. Typically in the range of 20 mA to 200 mA.
            '''

        })
    '''
    The control current used to control the Petersen coil also known as
    the position current. Typically in the range of 20 mA to 200 mA.
    '''

    xGroundMax: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum reactance.
            '''

        })
    '''
    The maximum reactance.
    '''

    xGroundMin: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum reactance.
            '''

        })
    '''
    The minimum reactance.
    '''

    xGroundNominal: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The nominal reactance. This is the operating point (normally over compensation)
            that is defined based on the resonance point in the healthy network condition.
            The impedance is calculated based on nominal voltage divided by position
            current.
            '''

        })
    '''
    The nominal reactance. This is the operating point (normally over compensation)
    that is defined based on the resonance point in the healthy network
    condition. The impedance is calculated based on nominal voltage divided
    by position current.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class EnergyConnection(ConductingEquipment):
    '''
    A connection of energy generation or consumption on the power system model.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.NC)
@dataclass(repr=False)
class EnergyConsumer(EnergyConnection):
    '''
    Generic user of energy - a point of consumption on the power system model.
    EnergyConsumer.pfixed, .qfixed, .pfixedPct and .qfixedPct have meaning
    only if there is no LoadResponseCharacteristic associated with EnergyConsumer
    or if LoadResponseCharacteristic.exponentModel is set to False.
    '''

    EnergyConsumerPhase: list[EnergyConsumerPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumerPhase.EnergyConsumer',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual phase models for this energy consumer.
            '''
        
        })
    '''
    The individual phase models for this energy consumer.
    '''
    
    customerCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of individual customers represented by this demand.
            '''

        })
    '''
    Number of individual customers represented by this demand.
    '''

    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Required for Yn and I connections (as represented by EnergyConsumer.phaseConnection).
            True if the neutral is solidly grounded.
            '''

        })
    '''
    Required for Yn and I connections (as represented by EnergyConsumer.phaseConnection).
    True if the neutral is solidly grounded.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power of the load. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''

        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    pfixed: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power of the load that is a fixed quantity and does not vary as
            load group value varies. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            '''

        })
    '''
    Active power of the load that is a fixed quantity and does not vary
    as load group value varies. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    '''

    pfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fixed active power as a percentage of load group fixed active power. Used
            to represent the time-varying components. Load sign convention is used,
            i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Fixed active power as a percentage of load group fixed active power.
    Used to represent the time-varying components. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of phase connection, such as wye or delta.
            '''

        })
    '''
    The type of phase connection, such as wye or delta.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power of the load. Load sign convention is used, i.e. positive
            sign means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''

        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    qfixed: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power of the load that is a fixed quantity and does not vary as
            load group value varies. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            '''

        })
    '''
    Reactive power of the load that is a fixed quantity and does not vary
    as load group value varies. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    '''

    qfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fixed reactive power as a percentage of load group fixed reactive power.
            Used to represent the time-varying components. Load sign convention is
            used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Fixed reactive power as a percentage of load group fixed reactive power.
    Used to represent the time-varying components. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    AreaDispatchableUnit: Optional[AreaDispatchableUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AreaDispatchableUnit.EnergyConsumer',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Area dispatchable unit that has this energy consumer.
            '''

        })
    '''
    Area dispatchable unit that has this energy consumer.
    '''

    EnergyConsumerAction: Optional[EnergyConsumerAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumerAction.EnergyConsumer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    LoadDynamics: Optional[LoadDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadDynamics.EnergyConsumer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Load dynamics model used to describe dynamic behaviour of this energy consumer.
            '''

        })
    '''
    Load dynamics model used to describe dynamic behaviour of this energy
    consumer.
    '''

    LoadResponse: Optional[LoadResponseCharacteristic] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadResponseCharacteristic.EnergyConsumer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The load response characteristic of this load. If missing, this load is
            assumed to be constant power.
            '''

        })
    '''
    The load response characteristic of this load. If missing, this load
    is assumed to be constant power.
    '''

    PowerCutZone: Optional[PowerCutZone] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerCutZone.EnergyConsumers',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The energy consumer is assigned to this power cut zone.
            '''

        })
    '''
    The energy consumer is assigned to this power cut zone.
    '''
    
@dataclass(repr=False)
class ConformLoad(EnergyConsumer):
    '''
    ConformLoad represents loads that follow a daily load change pattern where
    the pattern can be used to scale the load with a system load.
    '''

    LoadGroup: Optional[ConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConformLoadGroup.EnergyConsumers',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Group of this ConformLoad.
            '''

        })
    '''
    Group of this ConformLoad.
    '''
    
@dataclass(repr=False)
class NonConformLoad(EnergyConsumer):
    '''
    NonConformLoad represents loads that do not follow a daily load change
    pattern and whose changes are not correlated with the daily load change
    pattern.
    '''

    LoadGroup: Optional[NonConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NonConformLoadGroup.EnergyConsumers',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Group of this ConformLoad.
            '''

        })
    '''
    Group of this ConformLoad.
    '''
    
@dataclass(repr=False)
class StationSupply(EnergyConsumer):
    '''
    Station supply with load derived from the station output.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergySource(EnergyConnection):
    '''
    A generic equivalent for an energy supplier on a transmission or distribution
    voltage level.
    '''

    EnergySourcePhase: list[EnergySourcePhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergySourcePhase.EnergySource',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual phase information of the energy source.
            '''
        
        })
    '''
    The individual phase information of the energy source.
    '''
    
    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    activePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            High voltage source active injection. Load sign convention is used, i.e.
            positive sign means flow out from a node.
            Starting value for steady state solutions.
            '''

        })
    '''
    High voltage source active injection. Load sign convention is used,
    i.e. positive sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase-to-phase nominal voltage.
            '''

        })
    '''
    Phase-to-phase nominal voltage.
    '''

    pMax: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This is the maximum active power that can be produced by the source. Load
            sign convention is used, i.e. positive sign means flow out from a TopologicalNode
            (bus) into the conducting equipment.
            '''

        })
    '''
    This is the maximum active power that can be produced by the source.
    Load sign convention is used, i.e. positive sign means flow out from
    a TopologicalNode (bus) into the conducting equipment.
    '''

    pMin: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This is the minimum active power that can be produced by the source. Load
            sign convention is used, i.e. positive sign means flow out from a TopologicalNode
            (bus) into the conducting equipment.
            '''

        })
    '''
    This is the minimum active power that can be produced by the source.
    Load sign convention is used, i.e. positive sign means flow out from
    a TopologicalNode (bus) into the conducting equipment.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence Thevenin resistance.
            '''

        })
    '''
    Positive sequence Thevenin resistance.
    '''

    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence Thevenin resistance.
            '''

        })
    '''
    Zero sequence Thevenin resistance.
    '''

    r2: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Negative sequence Thevenin resistance.
            '''

        })
    '''
    Negative sequence Thevenin resistance.
    '''

    reactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            High voltage source reactive injection. Load sign convention is used, i.e.
            positive sign means flow out from a node.
            Starting value for steady state solutions.
            '''

        })
    '''
    High voltage source reactive injection. Load sign convention is used,
    i.e. positive sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    voltageAngle: Optional[ float | AngleRadians ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase angle of a-phase open circuit used when voltage characteristics need
            to be imposed at the node associated with the terminal of the energy source,
            such as when voltages and angles from the transmission level are used as
            input to the distribution network. The attribute shall be a positive value
            or zero.
            '''

        })
    '''
    Phase angle of a-phase open circuit used when voltage characteristics
    need to be imposed at the node associated with the terminal of the
    energy source, such as when voltages and angles from the transmission
    level are used as input to the distribution network. The attribute
    shall be a positive value or zero.
    '''

    voltageMagnitude: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase-to-phase open circuit voltage magnitude used when voltage characteristics
            need to be imposed at the node associated with the terminal of the energy
            source, such as when voltages and angles from the transmission level are
            used as input to the distribution network. The attribute shall be a positive
            value or zero.
            '''

        })
    '''
    Phase-to-phase open circuit voltage magnitude used when voltage characteristics
    need to be imposed at the node associated with the terminal of the
    energy source, such as when voltages and angles from the transmission
    level are used as input to the distribution network. The attribute
    shall be a positive value or zero.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence Thevenin reactance.
            '''

        })
    '''
    Positive sequence Thevenin reactance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence Thevenin reactance.
            '''

        })
    '''
    Zero sequence Thevenin reactance.
    '''

    x2: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Negative sequence Thevenin reactance.
            '''

        })
    '''
    Negative sequence Thevenin reactance.
    '''

    EnergySchedulingType: Optional[EnergySchedulingType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergySchedulingType.EnergySource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Energy Scheduling Type of an Energy Source.
            '''

        })
    '''
    Energy Scheduling Type of an Energy Source.
    '''

    EnergySourceAction: Optional[EnergySourceAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergySourceAction.EnergySource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Action taken with this energy source.
            '''

        })
    '''
    Action taken with this energy source.
    '''
    
@dataclass(repr=False)
class RegulatingCondEq(EnergyConnection):
    '''
    A type of conducting equipment that can regulate a quantity (i.e. voltage
    or flow) at a specific point in the network.
    '''

    controlEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the regulation status of the equipment. True is regulating, false
            is not regulating.
            '''

        })
    '''
    Specifies the regulation status of the equipment. True is regulating,
    false is not regulating.
    '''

    EquipmentController: Optional[EquipmentController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EquipmentController.RegulatingCondEq',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The equipment controller for this regulating conducting equipment.
            '''

        })
    '''
    The equipment controller for this regulating conducting equipment.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegulatingControl.RegulatingCondEq',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The regulating control scheme in which this equipment participates.
            '''

        })
    '''
    The regulating control scheme in which this equipment participates.
    '''
    
@dataclass(repr=False)
class ExternalNetworkInjection(RegulatingCondEq):
    '''
    This class represents the external network for use in power flow and short-circuit
    calculations.
    In the power flow domain the external network is modelled as a power injection
    with power limits and a power-frequency bias. For short-circuit calculations
    the external network is modelled as the �network feeders� element defined
    in section 6.2 of IEC60909-0:2016. Boolean flag ikSecond allows short-circuit
    calculations using the superposition method to detect that the maximum
    and minimum initial symmetrical short-circuit currents have to be corrected
    for the fact that they were calculated according the IEC60909-0 method.
    '''

    ikSecond: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates whether the maximum and minimum initial symmetrical short-circuit
            currents (Ik� max and Ik� min) have been calculated according to the IEC
            60909-0 method. Is only used in short-circuit calculations done according
            to the superposition method.
            '''

        })
    '''
    Indicates whether the maximum and minimum initial symmetrical short-circuit
    currents (Ik� max and Ik� min) have been calculated according to the
    IEC 60909-0 method. Is only used in short-circuit calculations done
    according to the superposition method.
    '''

    maxR0ToX0Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum ratio of zero sequence resistance to zero sequence reactance (R(0)/X(0)
            max). R0 and X0 are the real and imaginary parts of the zero sequence short-circuit
            impedance Z0 defined in clause 3.19.3 of IEC 60909-0:2016.
            '''

        })
    '''
    Maximum ratio of zero sequence resistance to zero sequence reactance
    (R(0)/X(0) max). R0 and X0 are the real and imaginary parts of the
    zero sequence short-circuit impedance Z0 defined in clause 3.19.3 of
    IEC 60909-0:2016.
    '''

    maxR1ToX1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum ratio of positive sequence resistance to positive sequence reactance
            (R(1)/X(1) max). R1 and X1 are the real and imaginary parts of the positive
            sequence short-circuit impedance Z1 defined in clause 3.19.1 of IEC 60909-0:2016.
            '''

        })
    '''
    Maximum ratio of positive sequence resistance to positive sequence
    reactance (R(1)/X(1) max). R1 and X1 are the real and imaginary parts
    of the positive sequence short-circuit impedance Z1 defined in clause
    3.19.1 of IEC 60909-0:2016.
    '''

    maxZ0ToZ1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum ratio of zero sequence impedance to its positive sequence impedance
            (Z(0)/Z(1) max). Z0 is the zero sequence short-circuit impedance defined
            in clause 3.19.3 of IEC 60909-0:2016. Z1 is the positive sequence short-circuit
            impedance defined in clause 3.19.1 of IEC 60909-0:2016.
            '''

        })
    '''
    Maximum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) max). Z0 is the zero sequence short-circuit impedance defined
    in clause 3.19.3 of IEC 60909-0:2016. Z1 is the positive sequence short-circuit
    impedance defined in clause 3.19.1 of IEC 60909-0:2016.
    '''

    minR0ToX0Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum ratio of zero sequence resistance to zero sequence reactance (R(0)/X(0)
            min). R0 and X0 are the real and imaginary parts of the zero sequence short-circuit
            impedance Z0 defined in clause 3.19.3 of IEC 60909-0:2016.
            '''

        })
    '''
    Minimum ratio of zero sequence resistance to zero sequence reactance
    (R(0)/X(0) min). R0 and X0 are the real and imaginary parts of the
    zero sequence short-circuit impedance Z0 defined in clause 3.19.3 of
    IEC 60909-0:2016.
    '''

    minR1ToX1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum ratio of positive sequence resistance to positive sequence reactance
            (R(1)/X(1) min). R1 and X1 are the real and imaginary parts of the positive
            sequence short-circuit impedance Z1 defined in clause 3.19.1 of IEC 60909-0:2016.
            '''

        })
    '''
    Minimum ratio of positive sequence resistance to positive sequence
    reactance (R(1)/X(1) min). R1 and X1 are the real and imaginary parts
    of the positive sequence short-circuit impedance Z1 defined in clause
    3.19.1 of IEC 60909-0:2016.
    '''

    minZ0ToZ1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum ratio of zero sequence impedance to its positive sequence impedance
            (Z(0)/Z(1) min). Z0 is the zero sequence short-circuit impedance defined
            in clause 3.19.3 of IEC 60909-0:2016. Z1 is the positive sequence short-circuit
            impedance defined in clause 3.19.1 of IEC 60909-0:2016.
            '''

        })
    '''
    Minimum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) min). Z0 is the zero sequence short-circuit impedance defined
    in clause 3.19.3 of IEC 60909-0:2016. Z1 is the positive sequence short-circuit
    impedance defined in clause 3.19.1 of IEC 60909-0:2016.
    '''

    referencePriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Priority of unit for use as powerflow voltage phase angle reference bus
            selection. 0 = don t care (default) 1 = highest priority. 2 is less than
            1 and so on.
            '''

        })
    '''
    Priority of unit for use as powerflow voltage phase angle reference
    bus selection. 0 = don t care (default) 1 = highest priority. 2 is
    less than 1 and so on.
    '''

    governorSCD: Optional[ float | ActivePowerPerFrequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power Frequency Bias. This is the change in power injection divided by
            the change in frequency and negated. A positive value of the power frequency
            bias provides additional power injection upon a drop in frequency.
            '''

        })
    '''
    Power Frequency Bias. This is the change in power injection divided
    by the change in frequency and negated. A positive value of the power
    frequency bias provides additional power injection upon a drop in frequency.
    '''

    maxInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum initial symmetrical short-circuit current (Ik" max) in A. Ik� is
            defined in clause 3.5 of IEC 60909-0:2016.
            '''

        })
    '''
    Maximum initial symmetrical short-circuit current (Ik" max) in A. Ik�
    is defined in clause 3.5 of IEC 60909-0:2016.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum active power of the injection.
            '''

        })
    '''
    Maximum active power of the injection.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum reactive power of the injection. Used for modelling of infeed for
            load flow exchange. Not used for short-circuit modelling.
            '''

        })
    '''
    Maximum reactive power of the injection. Used for modelling of infeed
    for load flow exchange. Not used for short-circuit modelling.
    '''

    minInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum initial symmetrical short-circuit current (Ik" min) in A. Ik� is
            defined in clause 3.5 of IEC 60909-0:2016.
            '''

        })
    '''
    Minimum initial symmetrical short-circuit current (Ik" min) in A. Ik�
    is defined in clause 3.5 of IEC 60909-0:2016.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum active power of the injection.
            '''

        })
    '''
    Minimum active power of the injection.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum reactive power of the injection. Used for modelling of infeed for
            load flow exchange. Not used for short-circuit modelling.
            '''

        })
    '''
    Minimum reactive power of the injection. Used for modelling of infeed
    for load flow exchange. Not used for short-circuit modelling.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for steady state solutions.
            '''

        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for steady state solutions.
            '''

        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    voltageFactor: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Voltage factor (c) in pu which has been used to calculate the maximum and
            minimum initial symmetrical short-circuit currents (Ik� max and Ik� min).
            Is only used in short-circuit calculations done according to the superposition
            method. The voltage factor is defined in clause 3.15 of IEC 60909-0:2016.
            '''

        })
    '''
    Voltage factor (c) in pu which has been used to calculate the maximum
    and minimum initial symmetrical short-circuit currents (Ik� max and
    Ik� min). Is only used in short-circuit calculations done according
    to the superposition method. The voltage factor is defined in clause
    3.15 of IEC 60909-0:2016.
    '''
    
@dataclass(repr=False)
class FrequencyConverter(RegulatingCondEq):
    '''
    A device to convert from one frequency to another (e.g., frequency F1 to
    F2) comprises a pair of FrequencyConverter instances. One converts from
    F1 to DC, the other converts the DC to F2.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Frequency on the AC side.
            '''

        })
    '''
    Frequency on the AC side.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum active power on the DC side at which the frequency converter
            should operate.
            '''

        })
    '''
    The maximum active power on the DC side at which the frequency converter
    should operate.
    '''

    maxU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum voltage on the DC side at which the frequency converter should
            operate.
            '''

        })
    '''
    The maximum voltage on the DC side at which the frequency converter
    should operate.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum active power on the DC side at which the frequency converter
            should operate.
            '''

        })
    '''
    The minimum active power on the DC side at which the frequency converter
    should operate.
    '''

    minU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum voltage on the DC side at which the frequency converter should
            operate.
            '''

        })
    '''
    The minimum voltage on the DC side at which the frequency converter
    should operate.
    '''
    
@dataclass(repr=False)
class PowerElectronicsConnection(RegulatingCondEq):
    '''
    A connection to the AC network for energy production or consumption that
    uses power electronics rather than rotating machines.
    '''

    PowerElectronicsConnectionPhase: list[PowerElectronicsConnectionPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnectionPhase.PowerElectronicsConnection',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual phases models for the power electronics connection.
            '''
        
        })
    '''
    The individual phases models for the power electronics connection.
    '''
    
    PowerElectronicsUnit: list[PowerElectronicsUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsUnit.PowerElectronicsConnection',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An AC network connection may have several power electronics units connecting
            through it.
            '''
        
        })
    '''
    An AC network connection may have several power electronics units connecting
    through it.
    '''
    
    inSafeMode: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates whether the inverter entered (true) or not (false) into Safe
            Mode.
            '''

        })
    '''
    Indicates whether the inverter entered (true) or not (false) into Safe
    Mode.
    '''

    isGridForming: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    maxIFault: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum fault current this device will contribute, in per-unit of rated
            current, before the converter protection will trip or bypass.
            '''

        })
    '''
    Maximum fault current this device will contribute, in per-unit of rated
    current, before the converter protection will trip or bypass.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum reactive power limit. This is the maximum (nameplate) limit for
            the unit.
            '''

        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit
    for the unit.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum reactive power limit for the unit. This is the minimum (nameplate)
            limit for the unit.
            '''

        })
    '''
    Minimum reactive power limit for the unit. This is the minimum (nameplate)
    limit for the unit.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''

        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''

        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nameplate apparent power rating for the unit.
            The attribute shall have a positive value.
            '''

        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
            for short circuit data exchange according to IEC 60909.
            The attribute shall be a positive value.
            '''

        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily
    used for short circuit data exchange according to IEC 60909.
    The attribute shall be a positive value.
    '''

    DERDynamics: Optional[DERDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERDynamics.PowerElectronicsConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DER dynamics model associated with this power electronics connection model.
            '''

        })
    '''
    DER dynamics model associated with this power electronics connection
    model.
    '''

    StatcomDynamics: Optional[StatcomDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StatcomDynamics.PowerElectronicsConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The statcom dynamics model associated with this power electronics connection.
            '''

        })
    '''
    The statcom dynamics model associated with this power electronics connection.
    '''

    WindTurbineType3or4Dynamics: Optional[WindTurbineType3or4Dynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WindTurbineType3or4Dynamics.PowerElectronicsConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The wind turbine type 3 or type 4 dynamics model associated with this power
            electronics connection.
            '''

        })
    '''
    The wind turbine type 3 or type 4 dynamics model associated with this
    power electronics connection.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class EVSE(PowerElectronicsConnection):
    '''
    Equipment or a combination of equipment, providing dedicated functions
    to supply electric energy from a fixed electrical installation or supply
    network to an EV for the purpose of charging and discharging [SOURCE: IEC
    61851-1:2017, 3.1.1, modified
    Electric Vehicle Supply Equipment (EVSE) is a power conversion and interface
    device that enables electric vehicles to connect to the power system for
    charging or, when supported, discharging (V2G). An EVSE controls the flow
    of power between the grid (or local DER/microgrid resources) and the connected
    vehicle battery, ensuring safety, interoperability, and adherence to communication
    standards.
    '''

    chargingModeType: Optional[ ChargingModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration GridAPPSD Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class RotatingMachine(RegulatingCondEq):
    '''
    A rotating machine which may be used as a generator or motor.
    '''

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.RotatingMachine',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''
        
        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''
    
    RotatingMachinePhase: Optional[RotatingMachinePhase] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachinePhase.RotatingMachine',
        'namespace': 'http://epri.com/GridAPPSD#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ratedPowerFactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power factor (nameplate data). It is primarily used for short circuit data
            exchange according to IEC 60909. The attribute cannot be a negative value.
            '''

        })
    '''
    Power factor (nameplate data). It is primarily used for short circuit
    data exchange according to IEC 60909. The attribute cannot be a negative
    value.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''

        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''

        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nameplate apparent power rating for the unit.
            The attribute shall have a positive value.
            '''

        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
            for short circuit data exchange according to IEC 60909.
            The attribute shall be a positive value.
            '''

        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily
    used for short circuit data exchange according to IEC 60909.
    The attribute shall be a positive value.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.RotatingMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A synchronous machine may operate as a generator and as such becomes a
            member of a generating unit.
            '''

        })
    '''
    A synchronous machine may operate as a generator and as such becomes
    a member of a generating unit.
    '''

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.RotatingMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''
        
        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''
    
    RotatingMachinePhase: Optional[RotatingMachinePhase] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachinePhase.RotatingMachine',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.RotatingMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''

        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''

    RotatingMachinePhase: Optional[RotatingMachinePhase] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachinePhase.RotatingMachine',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class AsynchronousMachine(RotatingMachine):
    '''
    A rotating machine whose shaft rotates asynchronously with the electrical
    field. Also known as an induction machine with no external connection to
    the rotor windings, e.g. squirrel-cage induction machine.
    '''

    converterFedDrive: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates whether the machine is a converter fed drive. Used for short
            circuit data exchange according to IEC 60909.
            '''

        })
    '''
    Indicates whether the machine is a converter fed drive. Used for short
    circuit data exchange according to IEC 60909.
    '''

    iaIrRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Ratio of locked-rotor current to the rated current of the motor (Ia/Ir).
            Used for short circuit data exchange according to IEC 60909.
            '''

        })
    '''
    Ratio of locked-rotor current to the rated current of the motor (Ia/Ir).
    Used for short circuit data exchange according to IEC 60909.
    '''

    polePairNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of pole pairs of stator. Used for short circuit data exchange according
            to IEC 60909.
            '''

        })
    '''
    Number of pole pairs of stator. Used for short circuit data exchange
    according to IEC 60909.
    '''

    reversible: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates for converter drive motors if the power can be reversible. Used
            for short circuit data exchange according to IEC 60909.
            '''

        })
    '''
    Indicates for converter drive motors if the power can be reversible.
    Used for short circuit data exchange according to IEC 60909.
    '''

    rxLockedRotorRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Locked rotor ratio (R/X). Used for short circuit data exchange according
            to IEC 60909.
            '''

        })
    '''
    Locked rotor ratio (R/X). Used for short circuit data exchange according
    to IEC 60909.
    '''

    asynchronousMachineType: Optional[ AsynchronousMachineKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates the type of Asynchronous Machine (motor or generator).
            '''

        })
    '''
    Indicates the type of Asynchronous Machine (motor or generator).
    '''

    efficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Efficiency of the asynchronous machine at nominal operation as a percentage.
            Indicator for converter drive motors. Used for short circuit data exchange
            according to IEC 60909.
            '''

        })
    '''
    Efficiency of the asynchronous machine at nominal operation as a percentage.
    Indicator for converter drive motors. Used for short circuit data exchange
    according to IEC 60909.
    '''

    nominalFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nameplate data indicates if the machine is 50 Hz or 60 Hz.
            '''

        })
    '''
    Nameplate data indicates if the machine is 50 Hz or 60 Hz.
    '''

    nominalSpeed: Optional[ float | RotationSpeed ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nameplate data. Depends on the slip and number of pole pairs.
            '''

        })
    '''
    Nameplate data. Depends on the slip and number of pole pairs.
    '''

    ratedMechanicalPower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated mechanical power (Pr in IEC 60909-0). Used for short circuit data
            exchange according to IEC 60909.
            '''

        })
    '''
    Rated mechanical power (Pr in IEC 60909-0). Used for short circuit
    data exchange according to IEC 60909.
    '''

    rr1: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Damper 1 winding resistance.
            '''

        })
    '''
    Damper 1 winding resistance.
    '''

    rr2: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Damper 2 winding resistance.
            '''

        })
    '''
    Damper 2 winding resistance.
    '''

    tpo: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transient rotor time constant (greater than tppo).
            '''

        })
    '''
    Transient rotor time constant (greater than tppo).
    '''

    tppo: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sub-transient rotor time constant (greater than 0).
            '''

        })
    '''
    Sub-transient rotor time constant (greater than 0).
    '''

    xlr1: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Damper 1 winding leakage reactance.
            '''

        })
    '''
    Damper 1 winding leakage reactance.
    '''

    xlr2: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Damper 2 winding leakage reactance.
            '''

        })
    '''
    Damper 2 winding leakage reactance.
    '''

    xm: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Magnetizing reactance.
            '''

        })
    '''
    Magnetizing reactance.
    '''

    xp: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transient reactance (unsaturated) (greater than or equal to xpp).
            '''

        })
    '''
    Transient reactance (unsaturated) (greater than or equal to xpp).
    '''

    xpp: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sub-transient reactance (unsaturated).
            '''

        })
    '''
    Sub-transient reactance (unsaturated).
    '''

    xs: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Synchronous reactance (greater than xp).
            '''

        })
    '''
    Synchronous reactance (greater than xp).
    '''

    AsynchronousMachineDynamics: Optional[AsynchronousMachineDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AsynchronousMachineDynamics.AsynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asynchronous machine dynamics model used to describe dynamic behaviour
            of this asynchronous machine.
            '''

        })
    '''
    Asynchronous machine dynamics model used to describe dynamic behaviour
    of this asynchronous machine.
    '''

    DERDynamics: Optional[DERDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERDynamics.AsynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DER dynamics model associated with this asynchronous machine model.
            '''

        })
    '''
    DER dynamics model associated with this asynchronous machine model.
    '''
    
@dataclass(repr=False)
class SynchronousMachine(RotatingMachine):
    '''
    An electromechanical device that operates with shaft rotating synchronously
    with the network. It is a single machine operating either as a generator
    or synchronous condenser or pump.
    '''

    ReactiveCapabilityCurve: list[ReactiveCapabilityCurve] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ReactiveCapabilityCurve.SynchronousMachine',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reactive capability curve for this synchronous machine.
            '''
        
        })
    '''
    The reactive capability curve for this synchronous machine.
    '''
    
    coolantCondition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Temperature or pressure of coolant medium.
            '''

        })
    '''
    Temperature or pressure of coolant medium.
    '''

    earthing: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates whether or not the generator is earthed. Used for short circuit
            data exchange according to IEC 60909.
            '''

        })
    '''
    Indicates whether or not the generator is earthed. Used for short circuit
    data exchange according to IEC 60909.
    '''

    mu: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Factor to calculate the breaking current (4.5.2.1 in IEC 60909-0).
            Used only for single fed short circuit on a generator (4.3.4.2. in IEC
            60909-0).
            '''

        })
    '''
    Factor to calculate the breaking current (4.5.2.1 in IEC 60909-0).
    Used only for single fed short circuit on a generator (4.3.4.2. in
    IEC 60909-0).
    '''

    referencePriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Priority of unit for use as powerflow voltage phase angle reference bus
            selection. 0 = don t care (default) 1 = highest priority. 2 is less than
            1 and so on.
            '''

        })
    '''
    Priority of unit for use as powerflow voltage phase angle reference
    bus selection. 0 = don t care (default) 1 = highest priority. 2 is
    less than 1 and so on.
    '''

    aVRToManualLag: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Time delay required when switching from Automatic Voltage Regulation (AVR)
            to Manual for a lagging MVAr violation.
            '''

        })
    '''
    Time delay required when switching from Automatic Voltage Regulation
    (AVR) to Manual for a lagging MVAr violation.
    '''

    aVRToManualLead: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Time delay required when switching from Automatic Voltage Regulation (AVR)
            to Manual for a leading MVAr violation.
            '''

        })
    '''
    Time delay required when switching from Automatic Voltage Regulation
    (AVR) to Manual for a leading MVAr violation.
    '''

    baseQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Default base reactive power value. This value represents the initial reactive
            power that can be used by any application function.
            '''

        })
    '''
    Default base reactive power value. This value represents the initial
    reactive power that can be used by any application function.
    '''

    condenserP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power consumed when in condenser mode operation.
            '''

        })
    '''
    Active power consumed when in condenser mode operation.
    '''

    coolantType: Optional[ CoolantType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Method of cooling the machine.
            '''

        })
    '''
    Method of cooling the machine.
    '''

    earthingStarPointR: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generator star point earthing resistance (Re). Used for short circuit data
            exchange according to IEC 60909.
            '''

        })
    '''
    Generator star point earthing resistance (Re). Used for short circuit
    data exchange according to IEC 60909.
    '''

    earthingStarPointX: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generator star point earthing reactance (Xe). Used for short circuit data
            exchange according to IEC 60909.
            '''

        })
    '''
    Generator star point earthing reactance (Xe). Used for short circuit
    data exchange according to IEC 60909.
    '''

    ikk: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Steady-state short-circuit current (in A for the profile) of generator
            with compound excitation during 3-phase short circuit.
            - Ikk=0: Generator with no compound excitation.
            - Ikk&lt;&gt;0: Generator with compound excitation.
            Ikk is used to calculate the minimum steady-state short-circuit current
            for generators with compound excitation.
            (4.6.1.2 in IEC 60909-0:2001).
            Used only for single fed short circuit on a generator. (4.3.4.2. in IEC
            60909-0:2001).
            '''

        })
    '''
    Steady-state short-circuit current (in A for the profile) of generator
    with compound excitation during 3-phase short circuit.
    - Ikk=0: Generator with no compound excitation.
    - Ikk&lt;&gt;0: Generator with compound excitation.
    Ikk is used to calculate the minimum steady-state short-circuit current
    for generators with compound excitation.
    (4.6.1.2 in IEC 60909-0:2001).
    Used only for single fed short circuit on a generator. (4.3.4.2. in
    IEC 60909-0:2001).
    '''

    manualToAVR: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Time delay required when switching from Manual to Automatic Voltage Regulation.
            This value is used in the accelerating power reference frame for powerflow
            solutions.
            '''

        })
    '''
    Time delay required when switching from Manual to Automatic Voltage
    Regulation. This value is used in the accelerating power reference
    frame for powerflow solutions.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum reactive power limit. This is the maximum (nameplate) limit for
            the unit.
            '''

        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit
    for the unit.
    '''

    maxU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum voltage limit for the unit.
            '''

        })
    '''
    Maximum voltage limit for the unit.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum reactive power limit for the unit.
            '''

        })
    '''
    Minimum reactive power limit for the unit.
    '''

    minU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum voltage limit for the unit.
            '''

        })
    '''
    Minimum voltage limit for the unit.
    '''

    operatingMode: Optional[ SynchronousMachineOperatingMode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Current mode of operation.
            '''

        })
    '''
    Current mode of operation.
    '''

    qPercent: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Part of the coordinated reactive control that comes from this machine.
            The attribute is used as a participation factor not necessarily summing
            up to 100 % for the participating devices in the control.
            '''

        })
    '''
    Part of the coordinated reactive control that comes from this machine.
    The attribute is used as a participation factor not necessarily summing
    up to 100 % for the participating devices in the control.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Equivalent resistance (RG) of generator. RG is considered for the calculation
            of all currents, except for the calculation of the peak current ip. Used
            for short circuit data exchange according to IEC 60909.
            '''

        })
    '''
    Equivalent resistance (RG) of generator. RG is considered for the calculation
    of all currents, except for the calculation of the peak current ip.
    Used for short circuit data exchange according to IEC 60909.
    '''

    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence resistance of the synchronous machine.
            '''

        })
    '''
    Zero sequence resistance of the synchronous machine.
    '''

    r2: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Negative sequence resistance.
            '''

        })
    '''
    Negative sequence resistance.
    '''

    satDirectSubtransX: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Direct-axis subtransient reactance saturated, also known as Xd"sat.
            '''

        })
    '''
    Direct-axis subtransient reactance saturated, also known as Xd"sat.
    '''

    satDirectSyncX: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Direct-axes saturated synchronous reactance (xdsat); reciprocal of short-circuit
            ration. Used for short circuit data exchange, only for single fed short
            circuit on a generator. (4.3.4.2. in IEC 60909-0:2001).
            '''

        })
    '''
    Direct-axes saturated synchronous reactance (xdsat); reciprocal of
    short-circuit ration. Used for short circuit data exchange, only for
    single fed short circuit on a generator. (4.3.4.2. in IEC 60909-0:2001).
    '''

    satDirectTransX: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Saturated Direct-axis transient reactance. The attribute is primarily used
            for short circuit calculations according to ANSI.
            '''

        })
    '''
    Saturated Direct-axis transient reactance. The attribute is primarily
    used for short circuit calculations according to ANSI.
    '''

    shortCircuitRotorType: Optional[ ShortCircuitRotorKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of rotor, used by short circuit applications, only for single fed
            short circuit according to IEC 60909.
            '''

        })
    '''
    Type of rotor, used by short circuit applications, only for single
    fed short circuit according to IEC 60909.
    '''

    type: Optional[ SynchronousMachineKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Modes that this synchronous machine can operate in.
            '''

        })
    '''
    Modes that this synchronous machine can operate in.
    '''

    voltageRegulationRange: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Range of generator voltage regulation (PG in IEC 60909-0) used for calculation
            of the impedance correction factor KG defined in IEC 60909-0.
            This attribute is used to describe the operating voltage of the generating
            unit.
            '''

        })
    '''
    Range of generator voltage regulation (PG in IEC 60909-0) used for
    calculation of the impedance correction factor KG defined in IEC 60909-0.
    This attribute is used to describe the operating voltage of the generating
    unit.
    '''

    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence reactance of the synchronous machine.
            '''

        })
    '''
    Zero sequence reactance of the synchronous machine.
    '''

    x2: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Negative sequence reactance.
            '''

        })
    '''
    Negative sequence reactance.
    '''

    DERDynamics: Optional[DERDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERDynamics.SynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DER dynamics model associated with this synchronous machine model.
            '''

        })
    '''
    DER dynamics model associated with this synchronous machine model.
    '''

    InitialReactiveCapabilityCurve: Optional[ReactiveCapabilityCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReactiveCapabilityCurve.InitiallyUsedBySynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The default reactive capability curve for use by a synchronous machine.
            The reference voltage (exchanged by ReactiveCapabilityCurve.referenceVoltage)
            for this ReactiveCapabilityCurve shall be equal to the BaseVoltage.nominalVoltage
            of the ConnectivityNode to which the Equipment is connected to. The information
            is obtained via the containment of the Equipment or the ConnectivityNode.
            '''

        })
    '''
    The default reactive capability curve for use by a synchronous machine.
    The reference voltage (exchanged by ReactiveCapabilityCurve.referenceVoltage)
    for this ReactiveCapabilityCurve shall be equal to the BaseVoltage.nominalVoltage
    of the ConnectivityNode to which the Equipment is connected to. The
    information is obtained via the containment of the Equipment or the
    ConnectivityNode.
    '''

    SynchronousMachineDynamics: Optional[SynchronousMachineDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SynchronousMachineDynamics.SynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Synchronous machine dynamics model used to describe dynamic behaviour of
            this synchronous machine.
            '''

        })
    '''
    Synchronous machine dynamics model used to describe dynamic behaviour
    of this synchronous machine.
    '''
    
@dataclass(repr=False)
class ShuntCompensator(RegulatingCondEq):
    '''
    A shunt capacitor or reactor or switchable bank of shunt capacitors or
    reactors. A section of a shunt compensator is an individual capacitor or
    reactor. A negative value for bPerSection indicates that the compensator
    is a reactor. ShuntCompensator is a single terminal device. Ground is implied.
    '''

    ShuntCompensatorPhase: list[ShuntCompensatorPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ReactiveCapabilityCurve.SynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reactive capability curve for this synchronous machine.
            '''

        })
    '''
    The reactive capability curve for this synchronous machine.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ShuntCompensator(RegulatingCondEq):
    '''
    A shunt capacitor or reactor or switchable bank of shunt capacitors or
    reactors. A section of a shunt compensator is an individual capacitor or
    reactor. A negative value for bPerSection indicates that the compensator
    is a reactor. ShuntCompensator is a single terminal device. Ground is implied.
    '''

    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Required for Yn and I connections (as represented by ShuntCompensator.phaseConnection).
            True if the neutral is solidly grounded.
            '''

        })
    '''
    Required for Yn and I connections (as represented by ShuntCompensator.phaseConnection).
    True if the neutral is solidly grounded.
    '''

    maximumSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum number of sections that may be switched in.
            '''

        })
    '''
    The maximum number of sections that may be switched in.
    '''

    normalSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal number of sections switched in. The value shall be between zero
            and ShuntCompensator.maximumSections.
            '''

        })
    '''
    The normal number of sections switched in. The value shall be between
    zero and ShuntCompensator.maximumSections.
    '''

    sections: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Shunt compensator sections in use. Starting value for steady state solution.
            The attribute shall be a positive value or zero. Non integer values are
            allowed to support continuous variables. The reasons for continuous value
            are to support study cases where no discrete shunt compensators has yet
            been designed, a solutions where a narrow voltage band force the sections
            to oscillate or accommodate for a continuous solution as input.
            For LinearShuntConpensator the value shall be between zero and ShuntCompensator.maximumSections.
            At value zero the shunt compensator conductance and admittance is zero.
            Linear interpolation of conductance and admittance between the previous
            and next integer section is applied in case of non-integer values.
            For NonlinearShuntCompensator(-s) shall only be set to one of the NonlinearShuntCompenstorPoint.sectionNumber.
            There is no interpolation between NonlinearShuntCompenstorPoint(-s).
            '''

        })
    '''
    Shunt compensator sections in use. Starting value for steady state
    solution. The attribute shall be a positive value or zero. Non integer
    values are allowed to support continuous variables. The reasons for
    continuous value are to support study cases where no discrete shunt
    compensators has yet been designed, a solutions where a narrow voltage
    band force the sections to oscillate or accommodate for a continuous
    solution as input.
    For LinearShuntConpensator the value shall be between zero and ShuntCompensator.maximumSections.
    At value zero the shunt compensator conductance and admittance is zero.
    Linear interpolation of conductance and admittance between the previous
    and next integer section is applied in case of non-integer values.
    For NonlinearShuntCompensator(-s) shall only be set to one of the NonlinearShuntCompenstorPoint.sectionNumber.
    There is no interpolation between NonlinearShuntCompenstorPoint(-s).
    '''

    aVRDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An automatic voltage regulation delay (AVRDelay) which is the time delay
            from a change in voltage to when the capacitor is allowed to change state.
            This filters out temporary changes in voltage.
            '''

        })
    '''
    An automatic voltage regulation delay (AVRDelay) which is the time
    delay from a change in voltage to when the capacitor is allowed to
    change state. This filters out temporary changes in voltage.
    '''

    nomU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage at which the nominal reactive power may be calculated. This
            should normally be within 10% of the voltage at which the capacitor is
            connected to the network.
            '''

        })
    '''
    The voltage at which the nominal reactive power may be calculated.
    This should normally be within 10% of the voltage at which the capacitor
    is connected to the network.
    '''

    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of phase connection, such as wye or delta.
            '''

        })
    '''
    The type of phase connection, such as wye or delta.
    '''

    voltageSensitivity: Optional[ float | VoltagePerReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Voltage sensitivity required for the device to regulate the bus voltage,
            in voltage/reactive power.
            '''

        })
    '''
    Voltage sensitivity required for the device to regulate the bus voltage,
    in voltage/reactive power.
    '''

    ShuntCompensatorAction: Optional[ShuntCompensatorAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorAction.ShuntCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ShuntCompensatorDynamics: Optional[ShuntCompensatorDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorDynamics.ShuntCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Shunt compensator dynamics model used to describe dynamic behaviour of
            this shunt compensator.
            '''

        })
    '''
    Shunt compensator dynamics model used to describe dynamic behaviour
    of this shunt compensator.
    '''

    StaticVarCompensatorSystemDynamics: Optional[StaticVarCompensatorSystemDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StaticVarCompensatorSystemDynamics.ShuntCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Static Var Compensator system dynamics model used to describe dynamic behaviour
            of this Static Var Compensator system.
            '''

        })
    '''
    Static Var Compensator system dynamics model used to describe dynamic
    behaviour of this Static Var Compensator system.
    '''
    
@dataclass(repr=False)
class LinearShuntCompensator(ShuntCompensator):
    '''
    A linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    b0PerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance per section.
            '''

        })
    '''
    Zero sequence shunt (charging) susceptance per section.
    '''

    bPerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance per section.
            '''

        })
    '''
    Positive sequence shunt (charging) susceptance per section.
    '''

    g0PerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance per section.
            '''

        })
    '''
    Zero sequence shunt (charging) conductance per section.
    '''

    gPerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance per section.
            '''

        })
    '''
    Positive sequence shunt (charging) conductance per section.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class NonlinearShuntCompensator(ShuntCompensator):
    '''
    A non linear shunt compensator has bank or section admittance values that
    differ. The attributes gTotal, bTotal, g0Total and b0Total of the associated
    NonlinearShuntCompensatorPoint describe the total conductance and admittance
    of a NonlinearShuntCompensatorPoint at a section number specified by NonlinearShuntCompensatorPoint.sectionNumber.
    '''

    NonlinearShuntCompensatorPoints: list[NonlinearShuntCompensatorPoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonlinearShuntCompensatorPoint.NonlinearShuntCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All points of the non-linear shunt compensator.
            '''

        })
    '''
    All points of the non-linear shunt compensator.
    '''
    
@dataclass(repr=False)
class VariableShuntCompensator(NonlinearShuntCompensator):
    '''
    A variable shunt compensator (VSR) is an oil-filled reactor with discrete
    on-line regulation of reactive power. The regulation range typically varies
    between 30% and 100% of the rated reactive power. When energized VSR cannot
    have a reactive output of 0 Mvar, so minimal valid section number is 1
    with reactive power output at either 100% or at minimal reactive power
    output. Note that reactive power can increase or decrease with increasing
    of the section number (NonlinearShuntCompensatorPoint.sectionNumber).
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StaticSynchronousSeriesCompensator(RegulatingCondEq):
    '''
    Static synchronous series compensator (SSSC) is a type of flexible AC transmission
    system which consists of a solid-state voltage source inverter coupled
    with a transformer that is connected in series with a transmission line.
    This device can inject an almost sinusoidal voltage in series with the
    line. This injected voltage could be considered as an inductive or capacitive
    reactance, which is connected in series with the transmission line. This
    feature can provide controllable voltage compensation. In addition, SSSC
    is able to reverse the power flow by injecting a sufficiently large series
    reactive compensating voltage. Moreover it can inject a voltage proportional
    to the difference between the line current and the pre-configured current
    threshold.<font color="#636671"> </font>It shall have two Terminal-s associated
    with it.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Control'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StaticVarCompensator(RegulatingCondEq):
    '''
    A facility for providing variable and controllable shunt reactive power.
    The SVC typically consists of a stepdown transformer, filter, thyristor-controlled
    reactor, and thyristor-switched capacitor arms.
    The SVC may operate in fixed MVar output mode or in voltage control mode.
    When in voltage control mode, the output of the SVC will be proportional
    to the deviation of voltage at the controlled bus from the voltage setpoint.
    The SVC characteristic slope defines the proportion. If the voltage at
    the controlled bus is equal to the voltage setpoint, the SVC MVar output
    is zero.
    '''

    capacitiveRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Capacitive reactance at maximum capacitive reactive power. Shall always
            be positive.
            '''

        })
    '''
    Capacitive reactance at maximum capacitive reactive power. Shall always
    be positive.
    '''

    inductiveRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Inductive reactance at maximum inductive reactive power. Shall always be
            negative.
            '''

        })
    '''
    Inductive reactance at maximum inductive reactive power. Shall always
    be negative.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''

        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''

    slope: Optional[ float | VoltagePerReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The characteristics slope of an SVC defines how the reactive power output
            changes in proportion to the difference between the regulated bus voltage
            and the voltage setpoint.
            The attribute shall be a positive value or zero.
            '''

        })
    '''
    The characteristics slope of an SVC defines how the reactive power
    output changes in proportion to the difference between the regulated
    bus voltage and the voltage setpoint.
    The attribute shall be a positive value or zero.
    '''

    sVCControlMode: Optional[ SVCControlMode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            SVC control mode.
            '''

        })
    '''
    SVC control mode.
    '''

    voltageSetPoint: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reactive power output of the SVC is proportional to the difference
            between the voltage at the regulated bus and the voltage setpoint. When
            the regulated bus voltage is equal to the voltage setpoint, the reactive
            power output is zero.
            '''

        })
    '''
    The reactive power output of the SVC is proportional to the difference
    between the voltage at the regulated bus and the voltage setpoint.
    When the regulated bus voltage is equal to the voltage setpoint, the
    reactive power output is zero.
    '''

    StaticVarCompensatorDynamics: Optional[StaticVarCompensatorDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StaticVarCompensatorDynamics.StaticVarCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Static Var Compensator dynamics model used to describe dynamic behaviour
            of this Static Var Compensator.
            '''

        })
    '''
    Static Var Compensator dynamics model used to describe dynamic behaviour
    of this Static Var Compensator.
    '''
    
@dataclass(repr=False)
class ExtendedWardEquivalent(ConductingEquipment):
    '''
    An extended ward equivalent is a combination of an impedance load, a PQ
    load and as voltage source with an internal impedance.
    '''

    ReactiveCapabilityCurve: list[ReactiveCapabilityCurve] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ReactiveCapabilityCurve.ExtendedWardEquivalent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reactive capability curve used by this extended ward equivalent.
            '''

        })
    '''
    The reactive capability curve used by this extended ward equivalent.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Ground(ConductingEquipment):
    '''
    A point where the system is grounded used for connecting conducting equipment
    to ground. The power system model can have any number of grounds.
    '''

    GroundAction: Optional[GroundAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GroundAction.Ground',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Action taken with this ground.
            '''

        })
    '''
    Action taken with this ground.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class PowerTransformer(ConductingEquipment):
    '''
    An electrical device consisting of two or more coupled windings, with or
    without a magnetic core, for introducing mutual coupling between electric
    circuits. Transformers can be used to control voltage and phase shift (active
    power flow).
    A power transformer may be composed of separate transformer tanks that
    need not be identical.
    A power transformer can be modelled with or without tanks and is intended
    for use in both balanced and unbalanced representations. A power transformer
    typically has two terminals, but may have one (grounding), three or more
    terminals.
    The inherited association ConductingEquipment.BaseVoltage should not be
    used. The association from TransformerEnd to BaseVoltage should be used
    instead.
    '''

    PowerTransformerEnd: list[PowerTransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerTransformerEnd.PowerTransformer',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ends of this power transformer.
            '''
        
        })
    '''
    The ends of this power transformer.
    '''
    
    TransformerTanks: list[TransformerTank] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTank.PowerTransformer',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All transformers that belong to this bank.
            '''
        
        })
    '''
    All transformers that belong to this bank.
    '''
    
    isPartOfGeneratorUnit: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates whether the machine is part of a power station unit. Used for
            short circuit data exchange according to IEC 60909. It has an impact on
            how the correction factors are calculated for transformers, since the transformer
            is not necessarily part of a synchronous machine and generating unit. It
            is not always possible to derive this information from the model. This
            is why the attribute is necessary.
            '''

        })
    '''
    Indicates whether the machine is part of a power station unit. Used
    for short circuit data exchange according to IEC 60909. It has an impact
    on how the correction factors are calculated for transformers, since
    the transformer is not necessarily part of a synchronous machine and
    generating unit. It is not always possible to derive this information
    from the model. This is why the attribute is necessary.
    '''

    operationalValuesConsidered: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            It is used to define if the data (other attributes related to short circuit
            data exchange) defines long term operational conditions or not. Used for
            short circuit data exchange according to IEC 60909.
            '''

        })
    '''
    It is used to define if the data (other attributes related to short
    circuit data exchange) defines long term operational conditions or
    not. Used for short circuit data exchange according to IEC 60909.
    '''

    vectorGroup: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Vector group of the transformer for protective relaying, e.g., Dyn1. For
            unbalanced transformers, this may not be simply determined from the constituent
            winding connections and phase angle displacements.
            The vectorGroup string consists of the following components in the order
            listed: high voltage winding connection, mid voltage winding connection
            (for three winding transformers), phase displacement clock number from
            0 to 11, low voltage winding connection
            phase displacement clock number from 0 to 11. The winding connections are
            D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag with
            neutral), A (auto transformer). Upper case means the high voltage, lower
            case mid or low. The high voltage winding always has clock position 0 and
            is not included in the vector group string. Some examples: YNy0 (two winding
            wye to wye with no phase displacement), YNd11 (two winding wye to delta
            with 330 degrees phase displacement), YNyn0d5 (three winding transformer
            wye with neutral high voltage, wye with neutral mid voltage and no phase
            displacement, delta low voltage with 150 degrees displacement).
            Phase displacement is defined as the angular difference between the phasors
            representing the voltages between the neutral point (real or imaginary)
            and the corresponding terminals of two windings, a positive sequence voltage
            system being applied to the high-voltage terminals, following each other
            in alphabetical sequence if they are lettered, or in numerical sequence
            if they are numbered: the phasors are assumed to rotate in a counter-clockwise
            sense.
            '''

        })
    '''
    Vector group of the transformer for protective relaying, e.g., Dyn1.
    For unbalanced transformers, this may not be simply determined from
    the constituent winding connections and phase angle displacements.
    The vectorGroup string consists of the following components in the
    order listed: high voltage winding connection, mid voltage winding
    connection (for three winding transformers), phase displacement clock
    number from 0 to 11, low voltage winding connection
    phase displacement clock number from 0 to 11. The winding connections
    are D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag
    with neutral), A (auto transformer). Upper case means the high voltage,
    lower case mid or low. The high voltage winding always has clock position
    0 and is not included in the vector group string. Some examples: YNy0
    (two winding wye to wye with no phase displacement), YNd11 (two winding
    wye to delta with 330 degrees phase displacement), YNyn0d5 (three winding
    transformer wye with neutral high voltage, wye with neutral mid voltage
    and no phase displacement, delta low voltage with 150 degrees displacement).
    Phase displacement is defined as the angular difference between the
    phasors representing the voltages between the neutral point (real or
    imaginary) and the corresponding terminals of two windings, a positive
    sequence voltage system being applied to the high-voltage terminals,
    following each other in alphabetical sequence if they are lettered,
    or in numerical sequence if they are numbered: the phasors are assumed
    to rotate in a counter-clockwise sense.
    '''

    beforeShCircuitHighestOperatingCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The highest operating current (Ib in IEC 60909-0) before short circuit
            (depends on network configuration and relevant reliability philosophy).
            It is used for calculation of the impedance correction factor KT defined
            in IEC 60909-0.
            '''

        })
    '''
    The highest operating current (Ib in IEC 60909-0) before short circuit
    (depends on network configuration and relevant reliability philosophy).
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0.
    '''

    beforeShCircuitHighestOperatingVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The highest operating voltage (Ub in IEC 60909-0) before short circuit.
            It is used for calculation of the impedance correction factor KT defined
            in IEC 60909-0. This is worst case voltage on the low side winding (3.7.1
            of IEC 60909:2001). Used to define operating conditions.
            '''

        })
    '''
    The highest operating voltage (Ub in IEC 60909-0) before short circuit.
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0. This is worst case voltage on the low side winding
    (3.7.1 of IEC 60909:2001). Used to define operating conditions.
    '''

    beforeShortCircuitAnglePf: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The angle of power factor before short circuit (phib in IEC 60909-0). It
            is used for calculation of the impedance correction factor KT defined in
            IEC 60909-0. This is the worst case power factor. Used to define operating
            conditions.
            '''

        })
    '''
    The angle of power factor before short circuit (phib in IEC 60909-0).
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0. This is the worst case power factor. Used to define
    operating conditions.
    '''

    highSideMinOperatingU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum operating voltage (uQmin in IEC 60909-0) at the high voltage
            side (Q side) of the unit transformer of the power station unit. A value
            well established from long-term operating experience of the system. It
            is used for calculation of the impedance correction factor KG defined in
            IEC 60909-0.
            '''

        })
    '''
    The minimum operating voltage (uQmin in IEC 60909-0) at the high voltage
    side (Q side) of the unit transformer of the power station unit. A
    value well established from long-term operating experience of the system.
    It is used for calculation of the impedance correction factor KG defined
    in IEC 60909-0.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class SeriesCompensator(ConductingEquipment):
    '''
    A Series Compensator is a series capacitor or reactor or an AC transmission
    line without charging susceptance. It is a two terminal device.
    '''

    varistorPresent: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Describe if a metal oxide varistor (mov) for over voltage protection is
            configured in parallel with the series compensator. It is used for short
            circuit calculations.
            '''

        })
    '''
    Describe if a metal oxide varistor (mov) for over voltage protection
    is configured in parallel with the series compensator. It is used for
    short circuit calculations.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence resistance.
            '''

        })
    '''
    Positive sequence resistance.
    '''

    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence resistance.
            '''

        })
    '''
    Zero sequence resistance.
    '''

    varistorRatedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum current the varistor is designed to handle at specified duration.
            It is used for short circuit calculations and exchanged only if SeriesCompensator.varistorPresent
            is true.
            The attribute shall be a positive value.
            '''

        })
    '''
    The maximum current the varistor is designed to handle at specified
    duration. It is used for short circuit calculations and exchanged only
    if SeriesCompensator.varistorPresent is true.
    The attribute shall be a positive value.
    '''

    varistorVoltageThreshold: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC voltage at which the varistor starts conducting. It is used for
            short circuit calculations and exchanged only if SeriesCompensator.varistorPresent
            is true.
            '''

        })
    '''
    The DC voltage at which the varistor starts conducting. It is used
    for short circuit calculations and exchanged only if SeriesCompensator.varistorPresent
    is true.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence reactance.
            '''

        })
    '''
    Positive sequence reactance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence reactance.
            '''

        })
    '''
    Zero sequence reactance.
    '''
    
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Switch(ConductingEquipment):
    '''
    A generic device designed to close, or open, or both, one or more electric
    circuits. All switches are two terminal devices including grounding switches.
    The ACDCTerminal.connected at the two sides of the switch shall not be
    considered for assessing switch connectivity, i.e. only Switch.open, .normalOpen
    and .locked are relevant.
    '''

    SwitchPhase: list[SwitchPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SwitchPhase.Switch',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual switch phases for the switch.
            '''
        
        })
    '''
    The individual switch phases for the switch.
    '''
    
    SwitchSchedules: list[SwitchSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SwitchSchedule.Switch',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A Switch can be associated with SwitchSchedules.
            '''
        
        })
    '''
    A Switch can be associated with SwitchSchedules.
    '''
    
    locked: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, the switch is locked. The resulting switch state is a combination
            of locked and Switch.open attributes as follows:
            <ul>
            <li>locked=true and Switch.open=true. The resulting state is open and locked;</li>
            <li>locked=false and Switch.open=true. The resulting state is open;</li>
            <li>locked=false and Switch.open=false. The resulting state is closed.</li>
            </ul>
            '''

        })
    '''
    If true, the switch is locked. The resulting switch state is a combination
    of locked and Switch.open attributes as follows:
    <ul>
    <li>locked=true and Switch.open=true. The resulting state is open and
    locked;</li>
    <li>locked=false and Switch.open=true. The resulting state is open;</li>
    <li>locked=false and Switch.open=false. The resulting state is closed.</li>
    </ul>
    '''

    normalOpen: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The attribute is used in cases when no Measurement for the status value
            is present. If the Switch has a status measurement the Discrete.normalValue
            is expected to match with the Switch.normalOpen.
            '''

        })
    '''
    The attribute is used in cases when no Measurement for the status value
    is present. If the Switch has a status measurement the Discrete.normalValue
    is expected to match with the Switch.normalOpen.
    '''

    open: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The attribute tells if the switch is considered open when used as input
            to topology processing.
            '''

        })
    '''
    The attribute tells if the switch is considered open when used as input
    to topology processing.
    '''

    retained: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Branch is retained in the topological solution. The flow through retained
            switches will normally be calculated in power flow.
            '''

        })
    '''
    Branch is retained in the topological solution. The flow through retained
    switches will normally be calculated in power flow.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum continuous current carrying capacity in amps governed by the
            device material and construction.
            The attribute shall be a positive value.
            '''

        })
    '''
    The maximum continuous current carrying capacity in amps governed by
    the device material and construction.
    The attribute shall be a positive value.
    '''

    CompositeSwitch: Optional[CompositeSwitch] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CompositeSwitch.Switches',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Composite switch to which this Switch belongs.
            '''

        })
    '''
    Composite switch to which this Switch belongs.
    '''

    SwitchAction: Optional[SwitchAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SwitchAction.OperatedSwitch',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Action changing status of this switch.
            '''

        })
    '''
    Action changing status of this switch.
    '''
    
@dataclass(repr=False)
class Cut(Switch):
    '''
    A cut separates a line segment into two parts. The cut appears as a switch
    inserted between these two parts and connects them together. As the cut
    is normally open there is no galvanic connection between the two line segment
    parts. But it is possible to close the cut to get galvanic connection.
    The cut terminals are oriented towards the line segment terminals with
    the same sequence number. Hence the cut terminal with sequence number equal
    to 1 is oriented to the line segment's terminal with sequence number equal
    to 1.
    The cut terminals also act as connection points for jumpers and other equipment,
    e.g. a mobile generator. To enable this, connectivity nodes are placed
    at the cut terminals. Once the connectivity nodes are in place any conducting
    equipment can be connected at them.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The length to the place where the cut is located starting from side one
            of the cut line segment, i.e. the line segment Terminal with sequenceNumber
            equal to 1.
            '''

        })
    '''
    The length to the place where the cut is located starting from side
    one of the cut line segment, i.e. the line segment Terminal with sequenceNumber
    equal to 1.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.Cut',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line segment to which the cut is applied.
            '''

        })
    '''
    The line segment to which the cut is applied.
    '''

    CutAction: Optional[CutAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CutAction.Cut',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Action taken with this cut.
            '''

        })
    '''
    Action taken with this cut.
    '''
    
@dataclass(repr=False)
class Disconnector(Switch):
    '''
    A mechanical switching device which provides, in the open position, an
    isolating distance in accordance with specified requirements.
    A disconnector is capable of opening and closing a circuit when either
    negligible current is broken or made, or when no significant change in
    the voltage across the terminals of each of the poles of the disconnector
    occurs. It is also capable of carrying currents under normal circuit conditions
    and carrying for a specified time currents under abnormal conditions such
    as those of short circuit.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EarthingSwitch(Switch):
    '''
    A mechanical switching device for earthing parts of a circuit, capable
    of withstanding for a specified time currents under abnormal conditions
    such as those of short circuit, but not required to carry current under
    normal conditions of the circuit.
    An earthing switch may have a short-circuit making capacity.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Fuse(Switch):
    '''
    An overcurrent protective device with a circuit opening fusible part that
    is heated and severed by the passage of overcurrent through it. A fuse
    is considered a switching device because it breaks current.
    '''

    MiinimumMeltCurve: Optional[FuseCharacteristicCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseCharacteristicCurve.FuseMinimumMelt',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Curves that define the time-current operation of this fuse (Minimum Melt)
            '''

        })
    '''
    Curves that define the time-current operation of this fuse (Minimum
    Melt)
    '''

    TotalClearingTimeCurve: Optional[FuseCharacteristicCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseCharacteristicCurve.FuseTotalClearing',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Curves that define the time-current operation of this fuse (Total Clearing
            Time Curves)
            '''

        })
    '''
    Curves that define the time-current operation of this fuse (Total Clearing
    Time Curves)
    '''

    MiinimumMeltCurve: Optional[FuseCharacteristicCurve] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseCharacteristicCurve.FuseMinimumMelt',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Curves that define the time-current operation of this fuse (Minimum Melt)
            '''

        })
    '''
    Curves that define the time-current operation of this fuse (Minimum
    Melt)
    '''

    TotalClearingTimeCurve: Optional[FuseCharacteristicCurve] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuseCharacteristicCurve.FuseTotalClearing',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Curves that define the time-current operation of this fuse (Total Clearing
            Time Curves)
            '''

        })
    '''
    Curves that define the time-current operation of this fuse (Total Clearing
    Time Curves)
    '''
    
@dataclass(repr=False)
class GroundDisconnector(Switch):
    '''
    A manually operated or motor operated mechanical switching device used
    for isolating a circuit or equipment from ground.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Jumper(Switch):
    '''
    A short section of conductor with negligible impedance which can be manually
    removed and replaced if the circuit is de-energized. Note that zero-impedance
    branches can potentially be modelled by other equipment types.
    '''

    JumperAction: Optional[JumperAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'JumperAction.Jumper',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Action taken with this jumper.
            '''

        })
    '''
    Action taken with this jumper.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ProtectedSwitch(Switch):
    '''
    A ProtectedSwitch is a switching device that can be operated by ProtectionEquipment.
    '''

    RecloseSequences: list[RecloseSequence] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RecloseSequence.ProtectedSwitch',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A breaker may have zero or more automatic reclosures after a trip occurs.
            '''
        
        })
    '''
    A breaker may have zero or more automatic reclosures after a trip occurs.
    '''
    
    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum fault current a breaking device can break safely under prescribed
            conditions of use.
            '''

        })
    '''
    The maximum fault current a breaking device can break safely under
    prescribed conditions of use.
    '''

    makingCapacity: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'GB Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://GB/placeholder/ext#',
        'docstring':
            '''
            The making current of the circuit breaker is the maximum peak value of
            the current that the breaker can interrupt without any damage if the breaker
            is closed at fault.
            '''

        })
    '''
    The making current of the circuit breaker is the maximum peak value
    of the current that the breaker can interrupt without any damage if
    the breaker is closed at fault.
    '''
    
@dataclass(repr=False)
class Breaker(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal circuit conditions and also making, carrying for
    a specified time, and breaking currents under specified abnormal circuit
    conditions e.g. those of short circuit.
    '''

    inTransitTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The transition time from open to close.
            '''

        })
    '''
    The transition time from open to close.
    '''
    
@dataclass(repr=False)
class DisconnectingCircuitBreaker(Breaker):
    '''
    A circuit breaking device including disconnecting function, eliminating
    the need for separate disconnectors.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LoadBreakSwitch(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal operating conditions.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Recloser(ProtectedSwitch):
    '''
    Pole-mounted fault interrupter with built-in phase and ground relays, current
    transformer (CT), and supplemental controls.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Sectionaliser(Switch):
    '''
    Automatic switch that will lock open to isolate a faulted section. It may,
    or may not, have load breaking capability. Its primary purpose is to provide
    fault sectionalising at locations where the fault current is either too
    high, or too low, for proper coordination of fuses.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CurrentTransformer(Equipment):
    '''
    Instrument transformer used to measure electrical qualities of the circuit
    that is being protected and/or monitored. Typically used as current transducer
    for the purpose of metering or protection. A typical secondary current
    rating would be 5A.
    '''

    usage: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Intended usage of the CT; i.e. metering, protection.
            '''

        })
    '''
    Intended usage of the CT; i.e. metering, protection.
    '''

    accuracyLimit: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Percent of rated current for which the CT remains accurate within specified
            limits.
            '''

        })
    '''
    Percent of rated current for which the CT remains accurate within specified
    limits.
    '''

    coreBurden: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power burden of the CT core.
            '''

        })
    '''
    Power burden of the CT core.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@stereotype(CIMStereotype.NC)
@dataclass(repr=False)
class GeneratingUnit(Equipment):
    '''
    A single or set of synchronous machines for converting mechanical power
    into alternating-current power. For example, individual machines within
    a set may be defined for scheduling purposes while a single control signal
    is derived for the set. In this case there would be a GeneratingUnit for
    each member of the set and an additional GeneratingUnit corresponding to
    the set.
    '''

    GenUnitOpCostCurves: list[GenUnitOpCostCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GenUnitOpCostCurve.GeneratingUnit',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have one or more cost curves, depending upon fuel
            mixture and fuel cost.
            '''
        
        })
    '''
    A generating unit may have one or more cost curves, depending upon
    fuel mixture and fuel cost.
    '''
    
    GenUnitOpSchedule: Optional[GenUnitOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GenUnitOpSchedule.GeneratingUnit',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''
        
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
    GrossToNetActivePowerCurves: list[GrossToNetActivePowerCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GrossToNetActivePowerCurve.GeneratingUnit',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have a gross active power to net active power curve,
            describing the losses and auxiliary power requirements of the unit.
            '''
        
        })
    '''
    A generating unit may have a gross active power to net active power
    curve, describing the losses and auxiliary power requirements of the
    unit.
    '''
    
    RotatingMachine: list[RotatingMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RotatingMachine.GeneratingUnit',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A synchronous machine may operate as a generator and as such becomes a
            member of a generating unit.
            '''
        
        })
    '''
    A synchronous machine may operate as a generator and as such becomes
    a member of a generating unit.
    '''
    
    longPF: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generating unit long term economic participation factor.
            '''

        })
    '''
    Generating unit long term economic participation factor.
    '''

    normalPF: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generating unit economic participation factor. The sum of the participation
            factors across generating units does not have to sum to one. It is used
            for representing distributed slack participation factor. The attribute
            shall be a positive value or zero.
            '''

        })
    '''
    Generating unit economic participation factor. The sum of the participation
    factors across generating units does not have to sum to one. It is
    used for representing distributed slack participation factor. The attribute
    shall be a positive value or zero.
    '''

    penaltyFactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Defined as: 1 / ( 1 - Incremental Transmission Loss); with the Incremental
            Transmission Loss expressed as a plus or minus value. The typical range
            of penalty factors is (0.9 to 1.1).
            '''

        })
    '''
    Defined as: 1 / ( 1 - Incremental Transmission Loss); with the Incremental
    Transmission Loss expressed as a plus or minus value. The typical range
    of penalty factors is (0.9 to 1.1).
    '''

    shortPF: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generating unit short term economic participation factor.
            '''

        })
    '''
    Generating unit short term economic participation factor.
    '''

    tieLinePF: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generating unit economic participation factor.
            '''

        })
    '''
    Generating unit economic participation factor.
    '''

    allocSpinResP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The planned unused capacity (spinning reserve) which can be used to support
            emergency load.
            '''

        })
    '''
    The planned unused capacity (spinning reserve) which can be used to
    support emergency load.
    '''

    autoCntrlMarginP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The planned unused capacity which can be used to support automatic control
            overruns.
            '''

        })
    '''
    The planned unused capacity which can be used to support automatic
    control overruns.
    '''

    baseP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            For dispatchable units, this value represents the economic active power
            basepoint, for units that are not dispatchable, this value represents the
            fixed generation value. The value shall be between the operating low and
            high limits.
            '''

        })
    '''
    For dispatchable units, this value represents the economic active power
    basepoint, for units that are not dispatchable, this value represents
    the fixed generation value. The value shall be between the operating
    low and high limits.
    '''

    controlDeadband: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Unit control error deadband. When a unit's desired active power change
            is less than this deadband, then no control pulses will be sent to the
            unit.
            '''

        })
    '''
    Unit control error deadband. When a unit's desired active power change
    is less than this deadband, then no control pulses will be sent to
    the unit.
    '''

    controlPulseHigh: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Pulse high limit which is the largest control pulse that the unit can respond
            to.
            '''

        })
    '''
    Pulse high limit which is the largest control pulse that the unit can
    respond to.
    '''

    controlPulseLow: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Pulse low limit which is the smallest control pulse that the unit can respond
            to.
            '''

        })
    '''
    Pulse low limit which is the smallest control pulse that the unit can
    respond to.
    '''

    controlResponseRate: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Unit response rate which specifies the active power change for a control
            pulse of one second in the most responsive loading level of the unit.
            '''

        })
    '''
    Unit response rate which specifies the active power change for a control
    pulse of one second in the most responsive loading level of the unit.
    '''

    efficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The efficiency of the unit in converting mechanical energy, from the prime
            mover, into electrical energy.
            '''

        })
    '''
    The efficiency of the unit in converting mechanical energy, from the
    prime mover, into electrical energy.
    '''

    genControlMode: Optional[ GeneratorControlMode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit control mode.
            '''

        })
    '''
    The unit control mode.
    '''

    genControlSource: Optional[ GeneratorControlSource ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The source of controls for a generating unit. Defines the control status
            of the generating unit.
            '''

        })
    '''
    The source of controls for a generating unit. Defines the control status
    of the generating unit.
    '''

    governorMPL: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Governor motor position limit.
            '''

        })
    '''
    Governor motor position limit.
    '''

    governorSCD: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Governor Speed Changer Droop. This is the change in generator power output
            divided by the change in frequency normalized by the nominal power of the
            generator and the nominal frequency and expressed in percent and negated.
            A positive value of speed change droop provides additional generator output
            upon a drop in frequency.
            '''

        })
    '''
    Governor Speed Changer Droop. This is the change in generator power
    output divided by the change in frequency normalized by the nominal
    power of the generator and the nominal frequency and expressed in percent
    and negated. A positive value of speed change droop provides additional
    generator output upon a drop in frequency.
    '''

    highControlLimit: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            High limit for secondary (AGC) control.
            '''

        })
    '''
    High limit for secondary (AGC) control.
    '''

    initialP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Default initial active power which is used to store a powerflow result
            for the initial active power for this unit in this network configuration.
            '''

        })
    '''
    Default initial active power which is used to store a powerflow result
    for the initial active power for this unit in this network configuration.
    '''

    lowControlLimit: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Low limit for secondary (AGC) control.
            '''

        })
    '''
    Low limit for secondary (AGC) control.
    '''

    lowerRampRate: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal maximum rate the generating unit active power output can be
            lowered by control actions.
            '''

        })
    '''
    The normal maximum rate the generating unit active power output can
    be lowered by control actions.
    '''

    maxEconomicP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum high economic active power limit, that should not exceed the maximum
            operating active power limit.
            '''

        })
    '''
    Maximum high economic active power limit, that should not exceed the
    maximum operating active power limit.
    '''

    maximumAllowableSpinningReserve: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum allowable spinning reserve. Spinning reserve will never be considered
            greater than this value regardless of the current operating point.
            '''

        })
    '''
    Maximum allowable spinning reserve. Spinning reserve will never be
    considered greater than this value regardless of the current operating
    point.
    '''

    maxOperatingP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This is the maximum operating active power limit the dispatcher can enter
            for this unit.
            '''

        })
    '''
    This is the maximum operating active power limit the dispatcher can
    enter for this unit.
    '''

    minEconomicP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Low economic active power limit that shall be greater than or equal to
            the minimum operating active power limit.
            '''

        })
    '''
    Low economic active power limit that shall be greater than or equal
    to the minimum operating active power limit.
    '''

    minimumOffTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum time interval between unit shutdown and startup.
            '''

        })
    '''
    Minimum time interval between unit shutdown and startup.
    '''

    minOperatingP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This is the minimum operating active power limit the dispatcher can enter
            for this unit.
            '''

        })
    '''
    This is the minimum operating active power limit the dispatcher can
    enter for this unit.
    '''

    modelDetail: Optional[ int | Classification ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Detail level of the generator model data.
            '''

        })
    '''
    Detail level of the generator model data.
    '''

    nominalP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The nominal power of the generating unit. Used to give precise meaning
            to percentage based attributes such as the governor speed change droop
            (governorSCD attribute).
            The attribute shall be a positive value equal to or less than RotatingMachine.ratedS.
            '''

        })
    '''
    The nominal power of the generating unit. Used to give precise meaning
    to percentage based attributes such as the governor speed change droop
    (governorSCD attribute).
    The attribute shall be a positive value equal to or less than RotatingMachine.ratedS.
    '''

    raiseRampRate: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal maximum rate the generating unit active power output can be
            raised by control actions.
            '''

        })
    '''
    The normal maximum rate the generating unit active power output can
    be raised by control actions.
    '''

    ratedGrossMaxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's gross rated maximum capacity (book value).
            The attribute shall be a positive value.
            '''

        })
    '''
    The unit's gross rated maximum capacity (book value).
    The attribute shall be a positive value.
    '''

    ratedGrossMinP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The gross rated minimum generation level which the unit can safely operate
            at while delivering power to the transmission grid.
            The attribute shall be a positive value.
            '''

        })
    '''
    The gross rated minimum generation level which the unit can safely
    operate at while delivering power to the transmission grid.
    The attribute shall be a positive value.
    '''

    ratedNetMaxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The net rated maximum capacity determined by subtracting the auxiliary
            power used to operate the internal plant machinery from the rated gross
            maximum capacity.
            The attribute shall be a positive value.
            '''

        })
    '''
    The net rated maximum capacity determined by subtracting the auxiliary
    power used to operate the internal plant machinery from the rated gross
    maximum capacity.
    The attribute shall be a positive value.
    '''

    startupCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The initial startup cost incurred for each start of the GeneratingUnit.
            '''

        })
    '''
    The initial startup cost incurred for each start of the GeneratingUnit.
    '''

    startupTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Time it takes to get the unit on-line, from the time that the prime mover
            mechanical power is applied.
            '''

        })
    '''
    Time it takes to get the unit on-line, from the time that the prime
    mover mechanical power is applied.
    '''

    totalEfficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The efficiency of the unit in converting the fuel into electrical energy.
            '''

        })
    '''
    The efficiency of the unit in converting the fuel into electrical energy.
    '''

    variableCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The variable cost component of production per unit of ActivePower.
            '''

        })
    '''
    The variable cost component of production per unit of ActivePower.
    '''

    AreaDispatchableUnit: Optional[AreaDispatchableUnit] = field(
        default=None,
        metadata={
        'type': 'NC AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AreaDispatchableUnit.GeneratingUnit',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The area dispatchable unit for this generating unit.
            '''

        })
    '''
    The area dispatchable unit for this generating unit.
    '''

    GenUnitOpSchedule: Optional[GenUnitOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GenUnitOpSchedule.GeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''

        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''

    ScheduleResource: Optional[ScheduleResource] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ScheduleResource.GeneratingUnit',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The schedule resource that has this generating unit.
            '''

        })
    '''
    The schedule resource that has this generating unit.
    '''
    
@dataclass(repr=False)
class GeothermalGeneratingUnit(GeneratingUnit):
    '''
    Generating unit that is generating electrical power from geothermal energy.
    '''
    
    GenUnitOpSchedule: Optional[GenUnitOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GenUnitOpSchedule.GeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''

        })
    '''
    Kind of geothermal generating unit.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class HydroGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover is a hydraulic turbine (e.g. Francis,
    Pelton, Kaplan).
    '''

    HydroGeneratingEfficiencyCurves: list[HydroGeneratingEfficiencyCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GrossToNetActivePowerCurve.GeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have a gross active power to net active power curve,
            describing the losses and auxiliary power requirements of the unit.
            '''

        })
    '''
    A generating unit may have a gross active power to net active power
    curve, describing the losses and auxiliary power requirements of the
    unit.
    '''
    
    PenstockLossCurve: Optional[PenstockLossCurve] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RotatingMachine.GeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A synchronous machine may operate as a generator and as such becomes a
            member of a generating unit.
            '''

        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
    TailbayLossCurve: list[TailbayLossCurve] = field(
        default_factory=list,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of geothermal generating unit.
            '''

        })
    '''
    Kind of geothermal generating unit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class HydroGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover is a hydraulic turbine (e.g. Francis,
    Pelton, Kaplan).
    '''

    dropHeight: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The height water drops from the reservoir mid-point to the turbine.
            '''

        })
    '''
    The height water drops from the reservoir mid-point to the turbine.
    '''

    energyConversionCapability: Optional[ HydroEnergyConversionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Energy conversion capability for generating.
            '''

        })
    '''
    Energy conversion capability for generating.
    '''

    hydroUnitWaterCost: Optional[ float | CostPerVolume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The equivalent cost of water that drives the hydro turbine.
            '''

        })
    '''
    The equivalent cost of water that drives the hydro turbine.
    '''

    turbineType: Optional[ HydroTurbineKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of turbine.
            '''

        })
    '''
    Type of turbine.
    '''

    HydroPowerPlant: Optional[HydroPowerPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPowerPlant.HydroGeneratingUnits',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro generating unit belongs to a hydro power plant.
            '''

        })
    '''
    The hydro generating unit belongs to a hydro power plant.
    '''

    PenstockLossCurve: Optional[PenstockLossCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PenstockLossCurve.HydroGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''

        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
@dataclass(repr=False)
class NuclearGeneratingUnit(GeneratingUnit):
    '''
    A nuclear generating unit.
    '''

    reactorKind: Optional[ NuclearReactorKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration NC Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Kind of nuclear reactor.
            '''

        })
    '''
    Kind of nuclear reactor.
    '''
    
@dataclass(repr=False)
class SolarGeneratingUnit(GeneratingUnit):
    '''
    A solar thermal generating unit, connected to the grid by means of a rotating
    machine. This class does not represent photovoltaic (PV) generation.
    '''

    SolarPowerPlant: Optional[SolarPowerPlant] = field(
        default=None,
        metadata={
        'type': 'European',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SolarPowerPlant.SolarGeneratingUnits',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            A solar power plant may have solar generating units.
            '''

        })
    '''
    A solar power plant may have solar generating units.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ThermalGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover could be a steam turbine, combustion
    turbine, or diesel engine.
    '''

    oMCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Operating and maintenance cost for the thermal unit.
            '''

        })
    '''
    Operating and maintenance cost for the thermal unit.
    '''
    
    EmmissionAccounts: list[EmissionAccount] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''

        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
    EmissionCurves: list[EmissionCurve] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.ThermalGeneratingUnits',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a cogeneration plant.
            '''

        })
    '''
    A thermal generating unit may be a member of a cogeneration plant.
    '''
    
    FossilFuels: list[FossilFuel] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CombinedCyclePlant.ThermalGeneratingUnits',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a combined cycle plant.
            '''

        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''
    
    FuelAllocationSchedules: list[FuelAllocationSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FuelAllocationSchedule.ThermalGeneratingUnit',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more fuel allocation schedules.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''

    HeatInputCurve: Optional[HeatInputCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatInputCurve.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''

        })
    '''
    A thermal generating unit may have a heat input curve.
    '''

    HeatRateCurve: Optional[HeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''

    IncrementalHeatRateCurve: Optional[IncrementalHeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IncrementalHeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''

    ShutdownCurve: Optional[ShutdownCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShutdownCurve.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''

        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''

    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a startup model.
            '''

        })
    '''
    A thermal generating unit may have a startup model.
    '''
    
    oMCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''

        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EmissionAccount.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more emission allowance accounts.
            '''

        })
    '''
    A thermal generating unit may have one or more emission allowance accounts.
    '''
    
    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EmissionCurve.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more emission curves.
            '''

        })
    '''
    A thermal generating unit may have one or more emission curves.
    '''
    
    CombinedCyclePlant: Optional[CombinedCyclePlant] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FossilFuel.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more fossil fuels.
            '''

        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''
    
    FuelAllocationSchedules: list[FuelAllocationSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FuelAllocationSchedule.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more fuel allocation schedules.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''

    HeatInputCurve: Optional[HeatInputCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatInputCurve.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''

        })
    '''
    A thermal generating unit may have a heat input curve.
    '''

    HeatRateCurve: Optional[HeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''

    IncrementalHeatRateCurve: Optional[IncrementalHeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IncrementalHeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''

    ShutdownCurve: Optional[ShutdownCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShutdownCurve.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''

        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''

    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a startup model.
            '''

        })
    '''
    A thermal generating unit may have a startup model.
    '''
    
@dataclass(repr=False)
class WindGeneratingUnit(GeneratingUnit):
    '''
    A wind driven generating unit, connected to the grid by means of a rotating
    machine. May be used to represent a single turbine or an aggregation.
    '''

    windGenUnitType: Optional[ WindGenUnitKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The kind of wind generating unit.
            '''

        })
    '''
    The kind of wind generating unit.
    '''

    WindPowerPlant: Optional[WindPowerPlant] = field(
        default=None,
        metadata={
        'type': 'European',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WindPowerPlant.WindGeneratingUnits',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            A wind power plant may have wind generating units.
            '''

        })
    '''
    A wind power plant may have wind generating units.
    '''
    
@stereotype(CIMStereotype.NC)
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class HydroPump(Equipment):
    '''
    A synchronous motor-driven pump, typically associated with a pumped storage
    plant.
    '''

    HydroPumpOpSchedule: Optional[HydroPumpOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPumpOpSchedule.HydroPump',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''
        
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
    RotatingMachine: Optional[RotatingMachine] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachine.HydroPump',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''
        
        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''
    
    pumpDischAtMaxHead: Optional[ float | VolumeFlowRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The pumping discharge under maximum head conditions, usually at full gate.
            '''

        })
    '''
    The pumping discharge under maximum head conditions, usually at full
    gate.
    '''

    pumpDischAtMinHead: Optional[ float | VolumeFlowRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The pumping discharge under minimum head conditions, usually at full gate.
            '''

        })
    '''
    The pumping discharge under minimum head conditions, usually at full
    gate.
    '''

    pumpPowerAtMaxHead: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The pumping power under maximum head conditions, usually at full gate.
            '''

        })
    '''
    The pumping power under maximum head conditions, usually at full gate.
    '''

    pumpPowerAtMinHead: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The pumping power under minimum head conditions, usually at full gate.
            '''

        })
    '''
    The pumping power under minimum head conditions, usually at full gate.
    '''

    AreaDispatchableUnit: Optional[AreaDispatchableUnit] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AreaDispatchableUnit.HydroPump',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Area dispatchable unit associated with a Hydro Pump.
            '''

        })
    '''
    Area dispatchable unit associated with a Hydro Pump.
    '''

    HydroPowerPlant: Optional[HydroPowerPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPowerPlant.HydroPumps',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro pump may be a member of a pumped storage plant or a pump for
            distributing water.
            '''

        })
    '''
    The hydro pump may be a member of a pumped storage plant or a pump
    for distributing water.
    '''

    HydroPumpOpSchedule: Optional[HydroPumpOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPumpOpSchedule.HydroPump',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''

        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''

    RotatingMachine: Optional[RotatingMachine] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RotatingMachine.HydroPump',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''

        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''

    ScheduleResource: Optional[ScheduleResource] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ScheduleResource.HydroPump',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The schedule resource that has this hydro pump.
            '''

        })
    '''
    The schedule resource that has this hydro pump.
    '''
    
@dataclass(repr=False)
class PotentialTransformer(Equipment):
    '''
    Instrument transformer (also known as Voltage Transformer) used to measure
    electrical qualities of the circuit that is being protected and/or monitored.
    Typically used as voltage transducer for the purpose of metering, protection,
    or sometimes auxiliary substation supply. A typical secondary voltage rating
    would be 120V.
    '''

    nominalRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nominal ratio between the primary and secondary voltage.
            '''

        })
    '''
    Nominal ratio between the primary and secondary voltage.
    '''

    type: Optional[ PotentialTransformerKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Potential transformer construction type.
            '''

        })
    '''
    Potential transformer construction type.
    '''
    
@stereotype(CIMStereotype.NC)
@dataclass(repr=False)
class PowerElectronicsUnit(Equipment):
    '''
    A generating unit or battery or aggregation that connects to the AC network
    using power electronics rather than rotating machines.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum active power limit. This is the maximum (nameplate) limit for the
            unit.
            '''

        })
    '''
    Maximum active power limit. This is the maximum (nameplate) limit for
    the unit.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum active power limit. This is the minimum (nameplate) limit for the
            unit.
            '''

        })
    '''
    Minimum active power limit. This is the minimum (nameplate) limit for
    the unit.
    '''

    AreaDispatchableUnit: Optional[AreaDispatchableUnit] = field(
        default=None,
        metadata={
        'type': 'NC AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AreaDispatchableUnit.PowerElectronicsUnit',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The area dispatchable unit for this power electronics unit.
            '''

        })
    '''
    The area dispatchable unit for this power electronics unit.
    '''

    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsConnection.PowerElectronicsUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A power electronics unit has a connection to the AC network.
            '''

        })
    '''
    A power electronics unit has a connection to the AC network.
    '''

    PowerElectronicsUnitController: Optional[PowerElectronicsUnitController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsUnitController.PowerElectronicsUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power electronics unit controller for this power electronics unit.
            '''

        })
    '''
    Power electronics unit controller for this power electronics unit.
    '''

    PowerShiftKeyDistribution: Optional[PowerShiftKeyDistribution] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerShiftKeyDistribution.PowerElectronicsUnit',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Distribution for a given bid.
            '''

        })
    '''
    Distribution for a given bid.
    '''

    ScheduleResource: Optional[ScheduleResource] = field(
        default=None,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ScheduleResource.PowerElectronicsUnit',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The schedule resource that has this power electronics unit.
            '''

        })
    '''
    The schedule resource that has this power electronics unit.
    '''
    
@dataclass(repr=False)
class BatteryUnit(PowerElectronicsUnit):
    '''
    An electrochemical energy storage device.
    '''

    batteryState: Optional[ BatteryStateKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The current state of the battery (charging, full, etc.).
            '''

        })
    '''
    The current state of the battery (charging, full, etc.).
    '''

    chargingEfficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    dischargingEfficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    idlingP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Real power consumed while idling
            '''

        })
    '''
    Real power consumed while idling
    '''

    idlingQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Reactive power consumed while idling
            &lt;&lt;conversion note&gt;&gt;
            DSS equivalent is %Idlingkvar, Percent of rated kW consumed as reactive
            power (kvar) while idling. Default =
            '''

        })
    '''
    Reactive power consumed while idling
    &lt;&lt;conversion note&gt;&gt;
    DSS equivalent is %Idlingkvar, Percent of rated kW consumed as reactive
    power (kvar) while idling. Default =
    '''

    minimumE: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Percent of rated kWh storage capacity to be held in reserve for normal
            operation. This is treated as the minimum energy discharge level unless
            there is an emergency. For emergency operation set this property lower.
            Cannot be less than zero.
            '''

        })
    '''
    Percent of rated kWh storage capacity to be held in reserve for normal
    operation. This is treated as the minimum energy discharge level unless
    there is an emergency. For emergency operation set this property lower.
    Cannot be less than zero.
    '''

    ratedE: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Full energy storage capacity of the battery. The attribute shall be a positive
            value.
            '''

        })
    '''
    Full energy storage capacity of the battery. The attribute shall be
    a positive value.
    '''

    storedE: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Amount of energy currently stored. The attribute shall be a positive value
            or zero and lower than BatteryUnit.ratedE.
            '''

        })
    '''
    Amount of energy currently stored. The attribute shall be a positive
    value or zero and lower than BatteryUnit.ratedE.
    '''
    
@dataclass(repr=False)
class MobileElectricalUnit(BatteryUnit):
    '''
    '''

    ChargingUnit: Optional[ChargingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ChargingUnit.MobileElectricalUnit',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class ElectricalVehicleUnit(MobileElectricalUnit):
    '''
    '''

    v2gCapable: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class ChargingUnit(PowerElectronicsUnit):
    '''
    A unit that supplies electrical power for charging electrical non-stationary
    entities, e.g. electrical vehicle, trucks, buses, ferries, boats and airplanes.
    The characteristic is that the energy consumption is highly schedule dependent.
    '''

    MobileElectricalUnit: list[MobileElectricalUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MobileElectricalUnit.ChargingUnit',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class FlexibleEnergyUnit(PowerElectronicsUnit):
    '''
    Flexible consumer or embedded producer of energy. The unit cannot be a
    net producer.
    '''

    buffer: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The active power, that has the flexibility to operate as production and/or
            consumption. The buffer is bound. Example are heat pump, cooling system,
            embedded batteries including electric vehicle. Load sign convention is
            used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    The active power, that has the flexibility to operate as production
    and/or consumption. The buffer is bound. Example are heat pump, cooling
    system, embedded batteries including electric vehicle. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    timeShift: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The active power, that can be shifted from one pricing interval (market
            time unit) to another. It is expected to be a limited on the length of
            the shift. Example from household could be washing machine or dishwasher.
            Example from industry is the possible to shut down a machine for the relevant
            period. Load sign convention is used, i.e. positive sign means flow out
            from a node.
            '''

        })
    '''
    The active power, that can be shifted from one pricing interval (market
    time unit) to another. It is expected to be a limited on the length
    of the shift. Example from household could be washing machine or dishwasher.
    Example from industry is the possible to shut down a machine for the
    relevant period. Load sign convention is used, i.e. positive sign means
    flow out from a node.
    '''

    unconstrained: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The active power, that has the flexibility to operate as production without
            any bound by a buffer. Example are alternative heating (wood, gas, diesel
            etc) or power generators. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            '''

        })
    '''
    The active power, that has the flexibility to operate as production
    without any bound by a buffer. Example are alternative heating (wood,
    gas, diesel etc) or power generators. Load sign convention is used,
    i.e. positive sign means flow out from a node.
    '''

    uncontrollable: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The active power, that forms the base consumption for the unit. This is
            measured and expected consumption. Load sign convention is used, i.e. positive
            sign means flow out from a node.
            '''

        })
    '''
    The active power, that forms the base consumption for the unit. This
    is measured and expected consumption. Load sign convention is used,
    i.e. positive sign means flow out from a node.
    '''
    
@dataclass(repr=False)
class PhotoVoltaicUnit(PowerElectronicsUnit):
    '''
    A photovoltaic device or an aggregation of such devices.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerElectricalChemicalUnit(PowerElectronicsUnit):
    '''
    A unit capable of either generating electrical energy from chemical reactions
    or using electrical energy to cause chemical reactions.
    '''

    kind: Optional[ PowerElectricalChemicalUnitKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of power electrical chemical unit.
            '''

        })
    '''
    Kind of power electrical chemical unit.
    '''
    
@dataclass(repr=False)
class PowerElectronicsMarineUnit(PowerElectronicsUnit):
    '''
    A unit that capture energy from marine sources, e.g. waves, for generating
    electrical power.
    '''

    kind: Optional[ MarineUnitKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of marine unit.
            '''

        })
    '''
    Kind of marine unit.
    '''
    
@dataclass(repr=False)
class PowerElectronicsThermalUnit(PowerElectronicsUnit):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://gridappsd.org/CIM/extension#'
    @property
    def __package__(self):
        return 'ProductionEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerElectronicsWindUnit(PowerElectronicsUnit):
    '''
    A wind generating unit that connects to the AC network with power electronics
    rather than rotating machines or an aggregation of such units.
    '''

    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ProtectionEquipment(Equipment):
    '''
    An electrical device designed to respond to input conditions in a prescribed
    manner and after specified conditions are met to cause contact operation
    or similar abrupt change in associated electric control circuits, or simply
    to display the detected condition. Protection equipment is associated with
    conducting equipment and usually operate circuit breakers.
    '''

    ProtectionFunction: list[ProtectionFunction] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionFunction.ProtectionEquipment',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Protection functions may be contained in protection equipment.
            '''
        
        })
    '''
    Protection functions may be contained in protection equipment.
    '''
    
    ProtectionFunctionBlock: list[ProtectionFunctionBlock] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionFunctionBlock.ProtectionEquipment',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Protection function blocks may be contained in protection equipment.
            '''
        
        })
    '''
    Protection function blocks may be contained in protection equipment.
    '''
    
    ProtectionRelatedFunctionBlock: list[ProtectionRelatedFunctionBlock] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionRelatedFunctionBlock.ProtectionEquipment',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Protection related function blocks may be contained in protection equipment.
            '''
        
        })
    '''
    Protection related function blocks may be contained in protection equipment.
    '''
    
    highLimit: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum allowable value.
            '''

        })
    '''
    The maximum allowable value.
    '''

    lowLimit: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum allowable value.
            '''

        })
    '''
    The minimum allowable value.
    '''

    powerDirectionFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Direction same as positive active power flow value.
            '''

        })
    '''
    Direction same as positive active power flow value.
    '''

    relayDelayTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time delay from detection of abnormal conditions to relay operation.
            '''

        })
    '''
    The time delay from detection of abnormal conditions to relay operation.
    '''

    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit multiplier of the value.
            '''

        })
    '''
    The unit multiplier of the value.
    '''

    unitSymbol: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit of measure of the value.
            '''

        })
    '''
    The unit of measure of the value.
    '''

    DigitalFaultRecorder: Optional[DigitalFaultRecorder] = field(
        default=None,
        metadata={
        'type': 'GridAPPSD',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DigitalFaultRecorder.ProtectionEquipment',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PhasorMeasurementUnit: Optional[PhasorMeasurementUnit] = field(
        default=None,
        metadata={
        'type': 'GridAPPSD',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhasorMeasurementUnit.ProtectionEquipment',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class CurrentRelay(ProtectionEquipment):
    '''
    A device that checks current flow values in any direction or designated
    direction.
    '''

    inverseTimeFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Set true if the current relay has inverse time characteristic.
            '''

        })
    '''
    Set true if the current relay has inverse time characteristic.
    '''

    currentLimit1: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Current limit number one 1 for inverse time pickup.
            '''

        })
    '''
    Current limit number one 1 for inverse time pickup.
    '''

    currentLimit2: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Current limit number 2 for inverse time pickup.
            '''

        })
    '''
    Current limit number 2 for inverse time pickup.
    '''

    currentLimit3: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Current limit number 3 for inverse time pickup.
            '''

        })
    '''
    Current limit number 3 for inverse time pickup.
    '''

    timeDelay1: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Inverse time delay number 1 for current limit number 1.
            '''

        })
    '''
    Inverse time delay number 1 for current limit number 1.
    '''

    timeDelay2: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Inverse time delay number 2 for current limit number 2.
            '''

        })
    '''
    Inverse time delay number 2 for current limit number 2.
    '''

    timeDelay3: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Inverse time delay number 3 for current limit number 3.
            '''

        })
    '''
    Inverse time delay number 3 for current limit number 3.
    '''
    
@dataclass(repr=False)
class SynchrocheckRelay(ProtectionEquipment):
    '''
    A device that operates when two AC circuits are within the desired limits
    of frequency, phase angle, and voltage, to permit or to cause the paralleling
    of these two circuits. Used to prevent the paralleling of non-synchronous
    topological islands.
    '''

    maxAngleDiff: Optional[ float | AngleRadians ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum allowable voltage vector phase angle difference across the
            open device.
            '''

        })
    '''
    The maximum allowable voltage vector phase angle difference across
    the open device.
    '''

    maxFreqDiff: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum allowable frequency difference across the open device.
            '''

        })
    '''
    The maximum allowable frequency difference across the open device.
    '''

    maxVoltDiff: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum allowable difference voltage across the open device.
            '''

        })
    '''
    The maximum allowable difference voltage across the open device.
    '''
    
@dataclass(repr=False)
class TransformerTank(Equipment):
    '''
    An assembly of two or more coupled windings that transform electrical power
    between voltage levels. These windings are bound on a common core and placed
    in the same tank. Transformer tank can be used to model both single-phase
    and 3-phase transformers.
    '''

    TransformerTankEnds: list[TransformerTankEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTankEnd.TransformerTank',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All windings of this transformer.
            '''
        
        })
    '''
    All windings of this transformer.
    '''
    
    PowerTransformer: Optional[PowerTransformer] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerTransformer.TransformerTanks',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Bank this transformer belongs to.
            '''

        })
    '''
    Bank this transformer belongs to.
    '''

    TransformerTankInfo: Optional[TransformerTankInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerTankInfo.TransformerTanks',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@dataclass(repr=False)
class FuelStorage(PowerSystemResource):
    '''
    Fuel storage. e.g. pile of coal that can be shared between multiple thermal
    generating units.
    '''

    FossilFuel: list[FossilFuel] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTankEnd.TransformerTank',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All windings of this transformer.
            '''

        })
    '''
    All windings of this transformer.
    '''
    
    @property
    def __namespace__(self):
        return 'http://cim.ucaiug.io/CIM101/draft#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FuelStorage(PowerSystemResource):
    '''
    Fuel storage. e.g. pile of coal that can be shared between multiple thermal
    generating units.
    '''

    energyStorage: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Amount of energy available in the storage.
            '''

        })
    '''
    Amount of energy available in the storage.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class HydroPowerPlant(PowerSystemResource):
    '''
    A hydro power station which can generate or pump. When generating, the
    generator turbines receive water from an upper reservoir. When pumping,
    the pumps receive their water from a lower reservoir.
    '''

    HydroGeneratingUnits: list[HydroGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FossilFuel.FuelStorage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fossil fuel stored in a fuel storage.
            '''

        })
    '''
    Fossil fuel stored in a fuel storage.
    '''
    
    HydroPumps: list[HydroPump] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroPump.HydroPowerPlant',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro pump may be a member of a pumped storage plant or a pump for
            distributing water.
            '''
        
        })
    '''
    The hydro pump may be a member of a pumped storage plant or a pump
    for distributing water.
    '''

    penstockType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type and configuration of hydro plant penstock(s).
            '''

        })
    '''
    Type and configuration of hydro plant penstock(s).
    '''

    surgeTankCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A code describing the type (or absence) of surge tank that is associated
            with the hydro power plant.
            '''

        })
    '''
    A code describing the type (or absence) of surge tank that is associated
    with the hydro power plant.
    '''

    dischargeTravelDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Water travel delay from tailbay to next downstream hydro power station.
            '''

        })
    '''
    Water travel delay from tailbay to next downstream hydro power station.
    '''

    genRatedP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro plant's generating rating active power for rated head conditions.
            The attribute shall be a positive value.
            '''

        })
    '''
    The hydro plant's generating rating active power for rated head conditions.
    The attribute shall be a positive value.
    '''

    hydroPlantStorageType: Optional[ HydroPlantStorageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of hydro power plant water storage.
            '''

        })
    '''
    The type of hydro power plant water storage.
    '''

    plantDischargeCapacity: Optional[ float | VolumeFlowRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total plant discharge capacity.
            '''

        })
    '''
    Total plant discharge capacity.
    '''

    plantRatedHead: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The plant's rated gross head.
            The attribute shall be a positive value.
            '''

        })
    '''
    The plant's rated gross head.
    The attribute shall be a positive value.
    '''

    pumpRatedP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro plant's pumping rating active power for rated head conditions.
            The attribute shall be a positive value.
            '''

        })
    '''
    The hydro plant's pumping rating active power for rated head conditions.
    The attribute shall be a positive value.
    '''

    surgeTankCrestLevel: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The level at which the surge tank spills.
            '''

        })
    '''
    The level at which the surge tank spills.
    '''

    GenSourcePumpDischargeReservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Reservoir.UpstreamFromHydroPowerPlants',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generators are supplied water from or pumps discharge water to an upstream
            reservoir.
            '''

        })
    '''
    Generators are supplied water from or pumps discharge water to an upstream
    reservoir.
    '''

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.HydroPowerPlants',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generators discharge water to or pumps are supplied water from a downstream
            reservoir.
            '''

        })
    '''
    Generators discharge water to or pumps are supplied water from a downstream
    reservoir.
    '''
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class MeasurementSystem(PowerSystemResource):
    '''
    '''

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroGeneratingUnit.HydroPowerPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro generating unit belongs to a hydro power plant.
            '''

        })
    '''
    The hydro generating unit belongs to a hydro power plant.
    '''
    
    CommunicationLink: Optional[CommunicationLink] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroPump.HydroPowerPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro pump may be a member of a pumped storage plant or a pump for
            distributing water.
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class MeasurementSystem(PowerSystemResource):
    '''
    '''

    CommunicationLink: Optional[CommunicationLink] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CommunicationLink.Sensors',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.MeasurementSystem',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class ConductingMeter(MeasurementSystem):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://gridappsd.org/CIM/extension#'
    @property
    def __package__(self):
        return 'MeasEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class DigitalFaultRecorder(MeasurementSystem):
    '''
    '''

    ProtectionEquipment: list[ProtectionEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionEquipment.DigitalFaultRecorder',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    PMUStream: Optional[PMUStream] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PMUStream.PMU',
        'namespace': 'http://epri.com/GridAPPSD#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ProtectionEquipment: list[ProtectionEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionEquipment.PhasorMeasurementUnit',
        'namespace': 'http://epri.com/GridAPPSD#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''

    reportingRate: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            For periodic data frames, PMUs shall support data reporting (by recording
            or output) at sub-multiples of the
            nominal power system frequency. Required rates are provided in Table 18
            in IEEE Std. C37.118
            '''

        })
    '''
    For periodic data frames, PMUs shall support data reporting (by recording
    or output) at sub-multiples of the
    nominal power system frequency. Required rates are provided in Table
    18 in IEEE Std. C37.118
    '''

    timeSourceType: Optional[ TimeSourceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            PMU must have a time source, which may be a dedicated GPS antenna for each
            PMU or an alternate source (used to prevent vulnerabilities from GPS spoofing).
            The PMU can only use one time source at a time.
            '''

        })
    '''
    PMU must have a time source, which may be a dedicated GPS antenna for
    each PMU or an alternate source (used to prevent vulnerabilities from
    GPS spoofing). The PMU can only use one time source at a time.
    '''

    usageType: Optional[ SynchrophaserUsageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            P-type units use a single electrical cycle for protection applications.
            M-type units use 5 or more cycles for higher quality frequency measurements.
            '''

        })
    '''
    P-type units use a single electrical cycle for protection applications.
    M-type units use 5 or more cycles for higher quality frequency measurements.
    '''

    PhasorDataConcentrator: Optional[PhasorDataConcentrator] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhasorDataConcentrator.PhasorMeasurementUnits',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PMUConfiguration: Optional[PMUConfiguration] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PMUConfiguration.PhasorMeasurementUnit',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PMUStream: Optional[PMUStream] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PMUStream.PMU',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PMUConfiguration: Optional[PMUConfiguration] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PMUConfiguration.PhasorMeasurementUnit',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PMUStream: Optional[PMUStream] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PMUStream.PMU',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class DisturbanceRecorder(PhasorMeasurementUnit):
    '''
    PMU that is also capable of collecting point-on-wave data
    '''

    @property
    def __namespace__(self):
        return 'http://gridappsd.org/CIM/extension#'
    @property
    def __package__(self):
        return 'AuxEqEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class PointOnWaveSensor(MeasurementSystem):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://gridappsd.org/CIM/extension#'
    @property
    def __package__(self):
        return 'AuxEqEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.NC)
@dataclass(repr=False)
class MonitoringArea(PowerSystemResource):
    '''
    A coherent part of the interconnected electrical power system, that includes
    the system operators' responsibility area and the surrounding parts of
    other system operators' responsibility area, that need to be monitored
    for security assessment.
    '''

    PowerFrequencyController: Optional[PowerFrequencyController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerFrequencyController.MonitoringArea',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Power frequency controller that applied to this monitoring area.
            '''

        })
    '''
    Power frequency controller that applied to this monitoring area.
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class PhasorDataConcentrator(PowerSystemResource):
    '''
    '''

    LocalPDC: list[PhasorDataConcentrator] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhasorDataConcentrator.CentralPDC',
        'namespace': 'http://epri.com/GridAPPSD#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PhasorMeasurementUnits: list[PhasorMeasurementUnit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhasorMeasurementUnit.PhasorDataConcentrator',
        'namespace': 'http://epri.com/GridAPPSD#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    timeSourceType: Optional[ TimeSourceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            PDC may or may not have its own dedicated time source. The timestamp issued
            by PDC will not supersede the timestamp from individual PMUs.
            '''

        })
    '''
    PDC may or may not have its own dedicated time source. The timestamp
    issued by PDC will not supersede the timestamp from individual PMUs.
    '''

    CentralPDC: Optional[PhasorDataConcentrator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhasorDataConcentrator.LocalPDC',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class PowerCutZone(PowerSystemResource):
    '''
    An area or zone of the power system which is used for load shedding purposes.
    '''

    EnergyConsumers: list[EnergyConsumer] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhasorMeasurementUnit.PhasorDataConcentrator',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://gridappsd.org/CIM/extension#'
    @property
    def __package__(self):
        return 'AuxEqEXT'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class PowerCutZone(PowerSystemResource):
    '''
    An area or zone of the power system which is used for load shedding purposes.
    '''

    cutLevel1: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            First level (amount) of load to cut as a percentage of total zone load.
            '''

        })
    '''
    First level (amount) of load to cut as a percentage of total zone load.
    '''

    cutLevel2: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Second level (amount) of load to cut as a percentage of total zone load.
            '''

        })
    '''
    Second level (amount) of load to cut as a percentage of total zone
    load.
    '''
    
@dataclass(repr=False)
class PowerElectronicsConnectionPhase(PowerSystemResource):
    '''
    A single phase of a power electronics connection.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow into the equipment from the network.
            '''

        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow into the equipment from the network.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase of this energy producer component. If the energy producer is wye
            connected, the connection is from the indicated phase to the central ground
            or neutral point. If the energy producer is delta connected, the phase
            indicates an energy producer connected from the indicated phase to the
            next logical non-neutral phase.
            '''

        })
    '''
    Phase of this energy producer component. If the energy producer is
    wye connected, the connection is from the indicated phase to the central
    ground or neutral point. If the energy producer is delta connected,
    the phase indicates an energy producer connected from the indicated
    phase to the next logical non-neutral phase.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow into the equipment from the network.
            '''

        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow into the equipment from the network.
    '''

    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsConnection.PowerElectronicsConnectionPhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power electronics connection of this power electronics connection phase.
            '''

        })
    '''
    Power electronics connection of this power electronics connection phase.
    '''
    
@stereotype(CIMStereotype.NC)
@dataclass(repr=False)
class PowerTransferCorridor(PowerSystemResource):
    '''
    A power transfer corridor is defined as a set of circuits (transmission
    lines or transformers) separating two portions of the power system, or
    a subset of circuits exposed to a substantial portion of the transmission
    exchange between two parts of the system.
    '''

    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.PowerTransferCorridor',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            The operational limit set relevant for this power transfer corridor.
            '''

        })
    '''
    The operational limit set relevant for this power transfer corridor.
    '''
    
@dataclass(repr=False)
class RegulatingControl(PowerSystemResource):
    '''
    Specifies a set of equipment that works together to control a power system
    quantity such as voltage or flow.
    Remote bus voltage control is possible by specifying the controlled terminal
    located at some place remote from the controlling equipment.
    The specified terminal shall be associated with the connectivity node of
    the controlled point. The most specific subtype of RegulatingControl shall
    be used in case such equipment participate in the control, e.g. TapChangerControl
    for tap changers.
    For flow control, load sign convention is used, i.e. positive sign means
    flow out from a TopologicalNode (bus) into the conducting equipment.
    The attribute minAllowedTargetValue and maxAllowedTargetValue are required
    in the following cases:
    - For a power generating module operated in power factor control mode to
    specify maximum and minimum power factor values;
    - Whenever it is necessary to have an off center target voltage for the
    tap changer regulator. For instance, due to long cables to off shore wind
    farms and the need to have a simpler setup at the off shore transformer
    platform, the voltage is controlled from the land at the connection point
    for the off shore wind farm. Since there usually is a voltage rise along
    the cable, there is typical and overvoltage of up 3 to 4 kV compared to
    the on shore station. Thus in normal operation the tap changer on the on
    shore station is operated with a target set point, which is in the lower
    parts of the dead band.
    The attributes minAllowedTargetValue and maxAllowedTargetValue are not
    related to the attribute targetDeadband and thus they are not treated as
    an alternative of the targetDeadband. They are needed due to limitations
    in the local substation controller. The attribute targetDeadband is used
    to prevent the power flow from moving the tap position in circles (hunting)
    that is to be used regardless of the attributes minAllowedTargetValue and
    maxAllowedTargetValue.
    '''

    RegulatingCondEq: list[RegulatingCondEq] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulatingCondEq.RegulatingControl',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The equipment that participates in this regulating control scheme.
            '''
        
        })
    '''
    The equipment that participates in this regulating control scheme.
    '''
    
    RegulationSchedule: list[RegulationSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulationSchedule.RegulatingControl',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Schedule for this regulating control.
            '''
        
        })
    '''
    Schedule for this regulating control.
    '''
    
    discrete: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, indicates that regulation is performed in the simulation in a
            discrete mode. If false, indicates that non-discrete regulation is used
            in the simulation. This applies to equipment with discrete controls, e.g.
            tap changers and shunt compensators.
            '''

        })
    '''
    If true, indicates that regulation is performed in the simulation in
    a discrete mode. If false, indicates that non-discrete regulation is
    used in the simulation. This applies to equipment with discrete controls,
    e.g. tap changers and shunt compensators.
    '''

    enabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The flag tells if regulation is enabled.
            '''

        })
    '''
    The flag tells if regulation is enabled.
    '''

    maxAllowedTargetValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum allowed target value. See also RegulatingControl description.
            '''

        })
    '''
    Maximum allowed target value. See also RegulatingControl description.
    '''

    minAllowedTargetValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum allowed target value. See also RegulatingControl description.
            '''

        })
    '''
    Minimum allowed target value. See also RegulatingControl description.
    '''

    targetDeadband: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This is the deadband set on the controller. It is used with discrete control
            to avoid excessive tap changes in tap changers and state changes in shunt
            compensator banks while regulating. The units in which deadband is expressed
            are based on RegulatingControl.mode. The attribute shall be a positive
            value or zero. If RegulatingControl.discrete is set to "false", the RegulatingControl.targetDeadband
            is to be ignored in simulations. If TapChanger.ctRatio or TapChanger.ptRatio
            are populated, deadband shall be expressed in secondary units.
            Note that for instance, if the targetValue is 100 kV and the targetDeadband
            is 2 kV the range is from 99 to 101 kV.
            '''

        })
    '''
    This is the deadband set on the controller. It is used with discrete
    control to avoid excessive tap changes in tap changers and state changes
    in shunt compensator banks while regulating. The units in which deadband
    is expressed are based on RegulatingControl.mode. The attribute shall
    be a positive value or zero. If RegulatingControl.discrete is set to
    "false", the RegulatingControl.targetDeadband is to be ignored in simulations.
    If TapChanger.ctRatio or TapChanger.ptRatio are populated, deadband
    shall be expressed in secondary units.
    Note that for instance, if the targetValue is 100 kV and the targetDeadband
    is 2 kV the range is from 99 to 101 kV.
    '''

    targetValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The target value set on the controller. It is the starting value for a
            steady state solution. This value can be used for the target value without
            the use of schedules. The value has the units appropriate to the mode attribute.
            If used for a TapChangerControl and if TapChanger.ctRatio or TapChanger.ptRatio
            are populated, the target value shall be expressed in secondary units.
            As an example, with PT ratio of 60 on a 12.47 KV distribution system, a
            phase to ground PT has a ratio of 7200 volts primary to 120 volts secondary.
            If the required primary target is 7128 volts for a single phase tap changer
            then the value of targetValue would equal 118.8 volts secondary (7128/60).
            '''

        })
    '''
    The target value set on the controller. It is the starting value for
    a steady state solution. This value can be used for the target value
    without the use of schedules. The value has the units appropriate to
    the mode attribute.
    If used for a TapChangerControl and if TapChanger.ctRatio or TapChanger.ptRatio
    are populated, the target value shall be expressed in secondary units.
    As an example, with PT ratio of 60 on a 12.47 KV distribution system,
    a phase to ground PT has a ratio of 7200 volts primary to 120 volts
    secondary. If the required primary target is 7128 volts for a single
    phase tap changer then the value of targetValue would equal 118.8 volts
    secondary (7128/60).
    '''

    mode: Optional[ RegulatingControlModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The regulating control mode presently available. This specification allows
            for determining the kind of regulation without need for obtaining the units
            from a schedule.
            '''

        })
    '''
    The regulating control mode presently available. This specification
    allows for determining the kind of regulation without need for obtaining
    the units from a schedule.
    '''

    monitoredPhase: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase voltage controlling this regulator, measured at regulator location.
            '''

        })
    '''
    Phase voltage controlling this regulator, measured at regulator location.
    '''

    targetValueUnitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the multiplier used for the targetValue, targetDeadband, .maxAllowedTargetValue,
            .minAllowedTargetValue as well as TapChangerControl.maxLimitVoltage and
            TapChangerControl.minLimitVoltage.
            '''

        })
    '''
    Specifies the multiplier used for the targetValue, targetDeadband,
    .maxAllowedTargetValue, .minAllowedTargetValue as well as TapChangerControl.maxLimitVoltage
    and TapChangerControl.minLimitVoltage.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.RegulatingControl',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminal associated with this regulating control. The terminal is associated
            instead of a node, since the terminal could connect into either a topological
            node or a connectivity node. Sometimes it is useful to model regulation
            at a terminal of a bus bar object.
            '''

        })
    '''
    The terminal associated with this regulating control. The terminal
    is associated instead of a node, since the terminal could connect into
    either a topological node or a connectivity node. Sometimes it is useful
    to model regulation at a terminal of a bus bar object.
    '''
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class ShuntCompensatorControl(RegulatingControl):
    '''
    Distribution capacitor bank control settings.
    '''

    ShuntCompensatorInfo: Optional[ShuntCompensatorInfo] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorInfo.ShuntCompensatorControl',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''
    
@stereotype(CIMStereotype.gmdm)
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class TapChangerControl(RegulatingControl):
    '''
    denotes whether tap changer control can operate for reverse power flows
    caused by distribution-connected generation
    '''

    TapChanger: list[TapChanger] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TapChanger.TapChangerControl',
        'namespace': 'http://ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The tap changers that participates in this regulating tap control scheme.
            '''
        
        })
    '''
    The tap changers that participates in this regulating tap control scheme.
    '''
    
    lineDropCompensation: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, the line drop compensation is to be applied.
            '''

        })
    '''
    If true, the line drop compensation is to be applied.
    '''

    reverseToNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    reversible: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    lineDropR: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Line drop compensator resistance setting for normal (forward) power flow.
            '''

        })
    '''
    Line drop compensator resistance setting for normal (forward) power
    flow.
    '''

    lineDropX: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Line drop compensator reactance setting for normal (forward) power flow.
            '''

        })
    '''
    Line drop compensator reactance setting for normal (forward) power
    flow.
    '''

    maxLimitVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum allowed regulated voltage on the PT secondary. This is the locally
            measured secondary voltage, including the effect of any line drop compensation.
            Typically used for distribution circuit voltage regulator. Sometimes referred
            to as first-house protection. If utilized, then TapChanger.ptRatio must
            be supplied.
            '''

        })
    '''
    Maximum allowed regulated voltage on the PT secondary. This is the
    locally measured secondary voltage, including the effect of any line
    drop compensation. Typically used for distribution circuit voltage
    regulator. Sometimes referred to as first-house protection. If utilized,
    then TapChanger.ptRatio must be supplied.
    '''

    minLimitVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum allowed regulated voltage on the PT secondary. This is the locally
            measured secondary voltage, including the effect of any line drop compensation.
            Typically used for distribution circuit voltage regulator. Sometimes referred
            to as last-house protection. If utilized, then TapChanger.ptRatio must
            be supplied.
            '''

        })
    '''
    Minimum allowed regulated voltage on the PT secondary. This is the
    locally measured secondary voltage, including the effect of any line
    drop compensation. Typically used for distribution circuit voltage
    regulator. Sometimes referred to as last-house protection. If utilized,
    then TapChanger.ptRatio must be supplied.
    '''

    reverseLineDropR: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Line drop compensator resistance setting for reverse power flow.
            '''

        })
    '''
    Line drop compensator resistance setting for reverse power flow.
    '''

    reverseLineDropX: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Line drop compensator reactance setting for reverse power flow.
            '''

        })
    '''
    Line drop compensator reactance setting for reverse power flow.
    '''

    reverseTargetDeadband: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''