from __future__ import annotations

import logging
from dataclasses import dataclass, field
from enum import Enum
from typing import Optional

from cimgraph.data_profile.identity import Identity, stereotype
from cimgraph.data_profile.units import CIMUnit, UnitMultiplier, UnitSymbol

_log = logging.getLogger(__name__)
'''
Annotated CIMantic Graphs data profile for Profile
Generated by CIMTool http://cimtool.org
'''

class CIMStereotype(Enum):
    Attribute = 'Attribute'
    CIMDatatype = 'CIMDatatype'
    GridAPPSD = 'GridAPPSD'
    NeedsWork = 'NeedsWork'
    Primitive = 'Primitive'
    ShadowExtension = 'ShadowExtension'
    ToBeRemoved = 'ToBeRemoved'
    add = 'add'
    deprecated = 'deprecated'
    enumeration = 'enumeration'
    profcim = 'profcim'

BASE_URI = 'http://www.ucaiug.org/profile#'
ONTOLOGY_URI = 'http://iec.ch/TC57/CIM101#'

@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a class that provides common identification for all classes needing
    identification and naming attributes.
    '''

    mRID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Master resource identifier issued by a model authority. The mRID is unique
            within an exchange context. Global uniqueness is easily achieved by using
            a UUID, as specified in IETF RFC 4122, for the mRID. The use of UUID is
            strongly recommended.
            For CIMXML data files in RDF syntax conforming to IEC 61970-552, the mRID
            is mapped to rdf:ID or rdf:about attributes that identify CIM object elements.
            '''

        })
    '''
    Master resource identifier issued by a model authority. The mRID is
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in IETF RFC 4122, for the mRID. The use
    of UUID is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552, the
    mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
    object elements.
    '''

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''

        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''

    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The name is any free human readable and possibly non unique text naming
            the object.
            '''

        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''

@dataclass(repr=False)
class ACDCTerminal(IdentifiedObject):
    '''
    An electrical connection point (AC or DC) to a piece of conducting equipment.
    Terminals are connected at physical connection points called connectivity
    nodes.
    '''

    connected: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The connected status is related to a bus-branch model and the topological
            node to terminal relation. True implies the terminal is connected to the
            related topological node and false implies it is not.
            In a bus-branch model, the connected status is used to tell if equipment
            is disconnected without having to change the connectivity described by
            the topological node to terminal relation. A valid case is that conducting
            equipment can be connected in one end and open in the other. In particular
            for an AC line segment, where the reactive line charging can be significant,
            this is a relevant case.
            '''

        })
    '''
    The connected status is related to a bus-branch model and the topological
    node to terminal relation. True implies the terminal is connected to
    the related topological node and false implies it is not.
    In a bus-branch model, the connected status is used to tell if equipment
    is disconnected without having to change the connectivity described
    by the topological node to terminal relation. A valid case is that
    conducting equipment can be connected in one end and open in the other.
    In particular for an AC line segment, where the reactive line charging
    can be significant, this is a relevant case.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The orientation of the terminal connections for a multiple terminal conducting
            equipment. The sequence numbering starts with 1 and additional terminals
            should follow in increasing order. The first terminal is the "starting
            point" for a two terminal branch.
            '''

        })
    '''
    The orientation of the terminal connections for a multiple terminal
    conducting equipment. The sequence numbering starts with 1 and additional
    terminals should follow in increasing order. The first terminal is
    the "starting point" for a two terminal branch.
    '''

@dataclass(repr=False)
class Terminal(ACDCTerminal):
    '''
    An AC electrical connection point to a piece of conducting equipment. Terminals
    are connected at physical connection points called connectivity nodes.
    '''

    phases: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Represents the normal network phasing condition. If the attribute is missing,
            three phases (ABC) shall be assumed, except for terminals of grounding
            classes (specializations of EarthFaultCompensator, GroundDisconnector,
            and Ground) which will be assumed to be N. Therefore, phase code ABCN is
            explicitly declared when needed, e.g. for star point grounding equipment.
            The phase code on terminals connecting the same ConnectivityNode or TopologicalNode
            as well as for equipment between two terminals shall be consistent.
            '''

        })
    '''
    Represents the normal network phasing condition. If the attribute is
    missing, three phases (ABC) shall be assumed, except for terminals
    of grounding classes (specializations of EarthFaultCompensator, GroundDisconnector,
    and Ground) which will be assumed to be N. Therefore, phase code ABCN
    is explicitly declared when needed, e.g. for star point grounding equipment.
    The phase code on terminals connecting the same ConnectivityNode or
    TopologicalNode as well as for equipment between two terminals shall
    be consistent.
    '''

    Bushing: Optional[Bushing] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Bushing.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ConductingEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.Terminals',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The conducting equipment of the terminal. Conducting equipment have terminals
            that may be connected to other conducting equipment terminals via connectivity
            nodes or topological nodes.
            '''

        })
    '''
    The conducting equipment of the terminal. Conducting equipment have
    terminals that may be connected to other conducting equipment terminals
    via connectivity nodes or topological nodes.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.Terminals',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The connectivity node to which this terminal connects with zero impedance.
            '''

        })
    '''
    The connectivity node to which this terminal connects with zero impedance.
    '''

    NormalHeadFeeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.NormalHeadTerminal',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The feeder that this terminal normally feeds. Only specified for the terminals
            at head of feeders.
            '''

        })
    '''
    The feeder that this terminal normally feeds. Only specified for the
    terminals at head of feeders.
    '''

@dataclass(repr=False)
class Asset(IdentifiedObject):
    '''
    Tangible resource of the utility, including power system equipment, various
    end devices, cabinets, buildings, etc. For electrical network equipment,
    the role of the asset is defined through PowerSystemResource and its subclasses,
    defined mainly in the Wires model (refer to IEC61970-301 and model package
    IEC61970::Wires). Asset description places emphasis on the physical characteristics
    of the equipment fulfilling that role.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.Assets',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            All power system resources used to electrically model this asset. For example,
            transformer asset is electrically modelled with a transformer and its windings
            and tap changer.
            '''

        })
    '''
    All power system resources used to electrically model this asset. For
    example, transformer asset is electrically modelled with a transformer
    and its windings and tap changer.
    '''

@dataclass(repr=False)
class Bushing(Asset):
    '''
    Bushing asset.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.Bushing',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Terminal to which this bushing is attached.
            '''

        })
    '''
    Terminal to which this bushing is attached.
    '''

@dataclass(repr=False)
class Crossarm(Asset):
    '''
    Cross arm
    '''

    material: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Material
            '''

        })
    '''
    Material
    '''

    OverheadStructure: Optional[OverheadStructure] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OverheadStructure.Crossarm',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class AssetInfo(IdentifiedObject):
    '''
    Set of attributes of an asset, representing typical datasheet information
    of a physical device that can be instantiated and shared in different data
    exchange contexts:
    - as attributes of an asset instance (installed or in stock)
    - as attributes of an asset model (product by a manufacturer)
    - as attributes of a type asset (generic type of an asset as used in designs/extension
    planning).
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.AssetDatasheet',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            All power system resources with this datasheet information.
            '''

        })
    '''
    All power system resources with this datasheet information.
    '''

@dataclass(repr=False)
class ConductingAssetInfo(AssetInfo):
    '''
    Generic information for conducting asset
    '''

    phaseCount: Optional[ PhaseCountKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Number of phases
            '''

        })
    '''
    Number of phases
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Rated current.
            '''

        })
    '''
    Rated current.
    '''

    ratedFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Rated frequency such as 50Hz or 60Hz
            '''

        })
    '''
    Rated frequency such as 50Hz or 60Hz
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Rated voltage.
            '''

        })
    '''
    Rated voltage.
    '''

@dataclass(repr=False)
class ConductorInfo(ConductingAssetInfo):
    '''
    Common class for rigid and flexible conductors.
    [IEC 826-14-06]: Conductive part intended to carry a specified electric
    current
    '''

    purpose: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Phase, neutral, lighting, or something else
            '''

        })
    '''
    Phase, neutral, lighting, or something else
    '''

    crossSection: Optional[ float | Area ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Area of conducting material cross section
            '''

        })
    '''
    Area of conducting material cross section
    '''

    massPerLength: Optional[ float | MassPerLength ] = field(
        default=None,
        metadata={
        'type': 'NeedsWork Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Area of conducting material cross section
            '''

        })
    '''
    Area of conducting material cross section
    '''

    material: Optional[ WireMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Conductor material.
            '''

        })
    '''
    Conductor material.
    '''

    rAC25: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 25 �C.
            '''

        })
    '''
    AC resistance per unit length of the conductor at 25 �C.
    '''

    rAC50: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 50 �C.
            '''

        })
    '''
    AC resistance per unit length of the conductor at 50 �C.
    '''

    rAC75: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 75 �C.
            '''

        })
    '''
    AC resistance per unit length of the conductor at 75 �C.
    '''

    rDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            DC resistance per unit length of the conductor at 20 �C.
            '''

        })
    '''
    DC resistance per unit length of the conductor at 20 �C.
    '''

@dataclass(repr=False)
class CrossarmInfo(AssetInfo):
    '''
    Cross arm information
    '''

@dataclass(repr=False)
class InsulationInfo(AssetInfo):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    insulated: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            True if conductor is insulated.
            '''

        })
    '''
    True if conductor is insulated.
    '''

    insulationMaterial: Optional[ WireInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            (if insulated conductor) Material used for insulation.
            '''

        })
    '''
    (if insulated conductor) Material used for insulation.
    '''

    insulationThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            (if insulated conductor) Thickness of the insulation.
            '''

        })
    '''
    (if insulated conductor) Thickness of the insulation.
    '''

    CableInfo: Optional[CableInfo] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CableInfo.InsulationInfo',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class InsulatorInfo(AssetInfo):
    '''
    Insulator information
    '''

@dataclass(repr=False)
class PhaseToPhaseSpacing(AssetInfo):
    '''
    Distance from
    '''

    sequenceNumberWire1: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    sequenceNumberWire2: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    distance: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    fromPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    toPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.PhaseSpacing',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class PoleAssetInfo(AssetInfo):
    '''
    Pole asset data sheet.
    '''

@dataclass(repr=False)
class WireAssemblyInfo(AssetInfo):
    '''
    Describes the construction of a multi-conductor wire.<-NOTE: period missing.
    '''

    ACLineSegements: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.WireAssemblyInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Wire phase information associated with this wire assembly.
            '''

        })
    '''
    Wire phase information associated with this wire assembly.
    '''

    numberOfPhases: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    installationType: Optional[ WireInstallationKind ] = field(
        default=None,
        metadata={
        'type': 'GridAPPSD enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    usage: Optional[ WireUsageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    EarthResistivity: Optional[EarthResistivity] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EarthResistivity.WireAssemblyInfos',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthImpedance.WireAssemblyInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.WireAssemblyInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class WireBundleInfo(AssetInfo):
    '''
    '''

    WirePhaseInfos: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireBundleInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    wireCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    gmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Equivalent geometric mean radius of the symmetric conductor bundle, calculated
            from the radius
            '''

        })
    '''
    Equivalent geometric mean radius of the symmetric conductor bundle,
    calculated from the radius
    '''

    radius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Equivalent radius of the conductor
            '''

        })
    '''
    Equivalent radius of the conductor
    '''

    wireSpacing: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Distance between wire sub-conductors in a symmetrical bundle.
            '''

        })
    '''
    Distance between wire sub-conductors in a symmetrical bundle.
    '''

    WireInfo: Optional[WireInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireInfo.WireBundleInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''


@dataclass(repr=False)
class WireSpacingInfo(AssetInfo):
    '''
    Wire spacing data that associates multiple wire positions with the line
    segment, and allows to calculate line segment impedances. Number of phases
    can be derived from the number of associated wire positions whose phase
    is not neutral.
    '''

    ACLineSegment: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PhaseSpacing: list[PhaseToPhaseSpacing] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseToPhaseSpacing.WireSpacingInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.WireSpacingInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WirePositions: list[WirePosition] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePosition.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            All positions of single wires (phase or neutral) making the conductor.
            '''

        })
    '''
    All positions of single wires (phase or neutral) making the conductor.
    '''

    spacingType: Optional[ WireSpacingKind ] = field(
        default=None,
        metadata={
        'type': 'GridAPPSD enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class ConductorCharacteristicCurve(IdentifiedObject):
    '''
    Class to associate damage curves to conductors or to their datasheets.
    '''

    Conductor: list[Conductor] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Conductor.DamageCurve',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            A conductor can have a damage curve associated to it.
            '''

        })
    '''
    A conductor can have a damage curve associated to it.
    '''

@dataclass(repr=False)
class ConnectivityNode(IdentifiedObject):
    '''
    Connectivity nodes are points where terminals of AC conducting equipment
    are connected together with zero impedance.
    '''

    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Terminals interconnected with zero impedance at a this connectivity node.
            '''

        })
    '''
    Terminals interconnected with zero impedance at a this connectivity
    node.
    '''

@dataclass(repr=False)
class EarthResistivity(IdentifiedObject):
    '''
    Resistance of earth (soil)
    '''

    ACLineSegments: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.EarthResistivity',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireAssemblyInfos: list[WireAssemblyInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireAssemblyInfo.EarthResistivity',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    earthModelType: Optional[ EarthModelKind ] = field(
        default=None,
        metadata={
        'type': 'GridAPPSD enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    earthReturnGMR: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            Geometry mean radius of a set of hypothetical conductors with same impedance
            as the earth return, per Carson's Equations
            '''

        })
    '''
    Geometry mean radius of a set of hypothetical conductors with same
    impedance as the earth return, per Carson's Equations
    '''

    rho: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class GroundAction(IdentifiedObject):
    '''
    Action on ground as a switching step.
    '''

@dataclass(repr=False)
class LineSegmentCoupling(IdentifiedObject):
    '''
    Describes the relationship of a line in a coupled group to the reference
    line in the group. (Reference line has a coupledLineNumber = 1.)
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.LineSegmentCoupling',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The line whose relationship in a coupled group is described.
            '''

        })
    '''
    The line whose relationship in a coupled group is described.
    '''

@dataclass(repr=False)
class OverheadStructure(IdentifiedObject):
    '''
    A structure is an element of an electric transmission or distribution system
    that supports the overhead conductors and associated equipment used for
    the transmission of electricity.
    '''

    Crossarm: list[Crossarm] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Crossarm.OverheadStructure',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class PerLengthLineParameter(IdentifiedObject):
    '''
    Common type for per-length electrical line parameters.
    '''

@dataclass(repr=False)
class PerLengthImpedance(PerLengthLineParameter):
    '''
    Common type for per-length electrical impedances.
    '''

    ACLineSegments: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.PerLengthImpedance',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            All line segments described by this per-length impedance.
            '''

        })
    '''
    All line segments described by this per-length impedance.
    '''

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.PerLengthImpedance',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class PerLengthPhaseImpedance(PerLengthImpedance):
    '''
    The per length phase impedance matrix expresses impedance and admittance
    parameters per unit length for n-conductor unbalanced line segments. A
    phase impedance matrix contains both self impedances for each phase and
    mutual impedances between pairs of phases. The matrix is stored in symmetric
    lower triangular format where the diagonal entries represent self-impedances
    (and have the same value in row and column) and the off diagonal entries
    represent phase-to-phase impedances (and have different row and column
    values).
    The matrix can be use to express impedances for both non-coupled and coupled
    line segments. Coupled line segments share a single per length phase impedance
    matrix whose entries reflect the self and mutual impedances of all the
    phases of all the wires.
    '''

    PhaseImpedanceData: list[PhaseImpedanceData] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseImpedanceData.PhaseImpedance',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            All data that belong to this conductor phase impedance.
            '''

        })
    '''
    All data that belong to this conductor phase impedance.
    '''

    conductorCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Conductor count identifies the number of phase, neutral, and other wires
            represented in the phase impedance matrix and constrains the number of
            elements in the matrix. Typically, Kron reduction is used for incorporating
            effects of neutral impedance in the phase conductor values (so conductor
            count only considers phase wires), but neutrals can be included in the
            matrix (in which case conductor count would include the neutral wire(s)).
            For a phase impedance matrix associated with the lines of a coupled line
            segment group, the conductor count reflects the total of the conductors
            associated with all the coupled line segments in the group.
            '''

        })
    '''
    Conductor count identifies the number of phase, neutral, and other
    wires represented in the phase impedance matrix and constrains the
    number of elements in the matrix. Typically, Kron reduction is used
    for incorporating effects of neutral impedance in the phase conductor
    values (so conductor count only considers phase wires), but neutrals
    can be included in the matrix (in which case conductor count would
    include the neutral wire(s)). For a phase impedance matrix associated
    with the lines of a coupled line segment group, the conductor count
    reflects the total of the conductors associated with all the coupled
    line segments in the group.
    '''

@dataclass(repr=False)
class PerLengthSequenceImpedance(PerLengthImpedance):
    '''
    Sequence impedance and admittance parameters per unit length, for transposed
    line segments of 1, 2, or 3 phases. For 1-phase line segments, define x
    = x0 = xself. For 2-phase line segments, define x = xself - xmutual and
    x0 = xself + xmutual.
    '''

    b0ch: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance, per unit of length.
            '''

        })
    '''
    Zero sequence shunt (charging) susceptance, per unit of length.
    '''

    bch: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance, per unit of length.
            '''

        })
    '''
    Positive sequence shunt (charging) susceptance, per unit of length.
    '''

    g0ch: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance, per unit of length.
            '''

        })
    '''
    Zero sequence shunt (charging) conductance, per unit of length.
    '''

    gch: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance, per unit of length.
            '''

        })
    '''
    Positive sequence shunt (charging) conductance, per unit of length.
    '''

    r: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Positive sequence series resistance, per unit of length.
            '''

        })
    '''
    Positive sequence series resistance, per unit of length.
    '''

    r0: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Zero sequence series resistance, per unit of length.
            '''

        })
    '''
    Zero sequence series resistance, per unit of length.
    '''

    x: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Positive sequence series reactance, per unit of length.
            '''

        })
    '''
    Positive sequence series reactance, per unit of length.
    '''

    x0: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Zero sequence series reactance, per unit of length.
            '''

        })
    '''
    Zero sequence series reactance, per unit of length.
    '''

@dataclass(repr=False)
class PhaseImpedanceData(IdentifiedObject):
    '''
    Per length phase impedance matrix entry describes impedance and conductance
    matrix element values for a specific row and column of the matrix.
    The phases to which each entry applies can be determined by means of the
    row and column attributes which bind to a sequence number provided in either
    ACLineSegmentPhase or WirePosition (which also specify phase). Due to physical
    symmetry that is reflected in the matrix, only the lower triangle of the
    matrix is populated with the row and column method. That is, the column
    attribute is always less than or equal to the row attribute.
    '''

    column: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The matrix entry's column number has a range of possible values from 1
            to the conductor count of the matrix, but due to symmetry, only entries
            in the lower triangle (including diagonal) of the matrix need be defined.
            Column number binds to the sequence number in either ACLineSegmentPhase
            or WirePosition, which then identifies the phase for this entry.
            '''

        })
    '''
    The matrix entry's column number has a range of possible values from
    1 to the conductor count of the matrix, but due to symmetry, only entries
    in the lower triangle (including diagonal) of the matrix need be defined.
    Column number binds to the sequence number in either ACLineSegmentPhase
    or WirePosition, which then identifies the phase for this entry.
    '''

    row: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The matrix entry's row number has a range of possible values from 1 to
            the conductor count of the matrix, but due to symmetry, only entries in
            the lower triangle (including diagonal) of the matrix need be defined.
            Row number binds to the sequence number in either ACLineSegmentPhase or
            WirePosition, which then identifies the phase for this entry.
            '''

        })
    '''
    The matrix entry's row number has a range of possible values from 1
    to the conductor count of the matrix, but due to symmetry, only entries
    in the lower triangle (including diagonal) of the matrix need be defined.
    Row number binds to the sequence number in either ACLineSegmentPhase
    or WirePosition, which then identifies the phase for this entry.
    '''

    b: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Susceptance matrix entry value, per length of unit.
            '''

        })
    '''
    Susceptance matrix entry value, per length of unit.
    '''

    fromPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Refer to the class description.
            '''

        })
    '''
    Refer to the class description.
    '''

    g: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Conductance matrix entry value, per length of unit.
            '''

        })
    '''
    Conductance matrix entry value, per length of unit.
    '''

    r: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Resistance matrix entry value, per length of unit.
            '''

        })
    '''
    Resistance matrix entry value, per length of unit.
    '''

    toPhase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Refer to the class description.
            '''

        })
    '''
    Refer to the class description.
    '''

    x: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Reactance matrix entry value, per length of unit.
            '''

        })
    '''
    Reactance matrix entry value, per length of unit.
    '''

    PhaseImpedance: Optional[PerLengthPhaseImpedance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthPhaseImpedance.PhaseImpedanceData',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Conductor phase impedance to which this data belongs.
            '''

        })
    '''
    Conductor phase impedance to which this data belongs.
    '''

@dataclass(repr=False)
class PowerSystemResource(IdentifiedObject):
    '''
    A power system resource (PSR) can be an item of equipment such as a switch,
    an equipment container containing many individual items of equipment such
    as a substation, or an organisational entity such as sub-control area.
    Power system resources can have measurements associated.
    '''

    AssetDatasheet: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.PowerSystemResources',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Datasheet information for this power system resource.
            '''

        })
    '''
    Datasheet information for this power system resource.
    '''

    Assets: list[Asset] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Asset.PowerSystemResources',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            All assets represented by this power system resource. For example, multiple
            conductor assets are electrically modelled as a single AC line segment.
            '''

        })
    '''
    All assets represented by this power system resource. For example,
    multiple conductor assets are electrically modelled as a single AC
    line segment.
    '''

@dataclass(repr=False)
class ACLineSegmentPhase(PowerSystemResource):
    '''
    A line segment phase represents one phase (or optionally the neutral) of
    an alternating current line segment.
    Under most circumstances there is not a line segment phase for the neutral.
    However, if a wire assembly is being used and it does not specify phase,
    a line segment phase must exist for each position in the assembly (including
    the neutral).
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Sequence number provides the numbering for this line segment phase. When
            impedance is directly described, sequence number binds the phase to the
            column and row for entries in the per length phase impedance matrix (PhaseImpedanceData
            of PerLengthPhaseImpedance). When used in conjunction with a wire assembly
            description, sequence number associates the line segment phase to a position.
            For a line segment not a part of a parallel line segment group, sequence
            number starts at one and increments by one through each line segment phase
            associated with the line segment. If there is a line segment phase for
            neutral, it is numbered last.
            '''

        })
    '''
    Sequence number provides the numbering for this line segment phase.
    When impedance is directly described, sequence number binds the phase
    to the column and row for entries in the per length phase impedance
    matrix (PhaseImpedanceData of PerLengthPhaseImpedance). When used in
    conjunction with a wire assembly description, sequence number associates
    the line segment phase to a position.
    For a line segment not a part of a parallel line segment group, sequence
    number starts at one and increments by one through each line segment
    phase associated with the line segment. If there is a line segment
    phase for neutral, it is numbered last.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Phase identifies the phase or neutral connection of the conductor at both
            ends.
            '''

        })
    '''
    Phase identifies the phase or neutral connection of the conductor at
    both ends.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.ACLineSegmentPhases',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The line segment to which the phase belongs.
            '''

        })
    '''
    The line segment to which the phase belongs.
    '''

    WireInfo: Optional[WireInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireInfo.ACLineSegmentPhase',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Equipment(PowerSystemResource):
    '''
    The parts of a power system that are physical devices, electronic or mechanical.
    '''

@dataclass(repr=False)
class ConductingEquipment(Equipment):
    '''
    The parts of the AC power system that are designed to carry current or
    that are conductively connected through terminals.
    '''

    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConductingEquipment',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Conducting equipment have terminals that may be connected to other conducting
            equipment terminals via connectivity nodes or topological nodes.
            '''

        })
    '''
    Conducting equipment have terminals that may be connected to other
    conducting equipment terminals via connectivity nodes or topological
    nodes.
    '''

@dataclass(repr=False)
class Conductor(ConductingEquipment):
    '''
    Combination of conducting material with consistent electrical characteristics,
    building a single electrical system, used to carry current between points
    in the power system.
    '''

    length: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Segment length for calculating line segment capabilities.
            '''

        })
    '''
    Segment length for calculating line segment capabilities.
    '''

    DamageCurve: Optional[ConductorCharacteristicCurve] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductorCharacteristicCurve.Conductor',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Damage curve associated to a conductor.
            '''

        })
    '''
    Damage curve associated to a conductor.
    '''

@dataclass(repr=False)
class ACLineSegment(Conductor):
    '''
    A line segment is a conductor or combination of conductors, with consistent
    electrical characteristics along its length, building a single electrical
    system that carries alternating current between two points in the power
    system.
    The BaseVoltage at the two ends of a line segment shall have the same BaseVoltage.nominalVoltage.
    However, boundary lines may have slightly different BaseVoltage.nominalVoltages
    and variation is allowed. Larger voltage difference in general requires
    use of an equivalent branch.
    Line segment impedances can be either directly described in electrical
    terms or physical line detail can be provided from which impedances can
    be calculated.
    <b>Directly described impedances</b>
    For symmetrical, transposed three phase line segments, it is sufficient
    to use attributes of the line segment, which describe impedances and admittances
    for the entire length of the line segment. Additionally, line segment impedances
    can be computed by using line segment length and associated per length
    impedances.
    Unbalanced modeling of impedances is supported by the per length phase
    impedance matrix (PerLengthPhaseImpedance) in conjunction with phase-to-sequence
    number mapping supplied by either ACLineSegmentPhase or WirePosition. The
    sequence numbers are referenced by the row and column attributes of the
    per length phase impedance matrix. This method enables single-phase and
    two-phase line segments, and transpositions of phases, to be described
    using the same per length phase impedance matrix. The length of the line
    segment is used in the computation of total impedance values for the line
    segment.
    <b>Line detail characteristics</b>
    There are three approaches to providing line detail and all use WireAssembly
    to supply line positions:
    <ul>
    <li>Option 1 - WireAssembly supplies only line positions. ACLineSegmentPhase
    points to wire type and intraphase spacing and supplies the phase-to-sequence
    number mapping.</li>
    <li>Option 2 - WireAssembly supplies line position and, for each position,
    also supplies wire type and intraphase spacing. ACLineSegmentPhase supplies
    the phase-to-sequence number mapping.</li>
    <li>Option 3 - WireAssembly supplies line position and, for each position,
    also supplies wire type and intraphase spacing and phase. WireAssembly
    therefore supplies the phase-to-sequence number mapping and ACLineSegmentPhase
    is not needed.</li>
    </ul>
    '''

    ACLineSegmentPhases: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The line segment phases which belong to the line segment.
            '''

        })
    '''
    The line segment phases which belong to the line segment.
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance, uniformly distributed, of the
            entire line segment.
            '''

        })
    '''
    Zero sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line segment.
    '''

    bch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance, uniformly distributed,
            of the entire line segment. This value represents the full charging over
            the full length of the line segment.
            '''

        })
    '''
    Positive sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line segment. This value represents the full charging
    over the full length of the line segment.
    '''

    g0ch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance, uniformly distributed, of the
            entire line segment.
            '''

        })
    '''
    Zero sequence shunt (charging) conductance, uniformly distributed,
    of the entire line segment.
    '''

    gch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance, uniformly distributed,
            of the entire line segment.
            '''

        })
    '''
    Positive sequence shunt (charging) conductance, uniformly distributed,
    of the entire line segment.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Positive sequence series resistance of the entire line segment.
            '''

        })
    '''
    Positive sequence series resistance of the entire line segment.
    '''

    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Zero sequence series resistance of the entire line segment.
            '''

        })
    '''
    Zero sequence series resistance of the entire line segment.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Positive sequence series reactance of the entire line segment.
            '''

        })
    '''
    Positive sequence series reactance of the entire line segment.
    '''

    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Zero sequence series reactance of the entire line segment.
            '''

        })
    '''
    Zero sequence series reactance of the entire line segment.
    '''

    EarthResistivity: Optional[EarthResistivity] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EarthResistivity.ACLineSegments',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    LineSegmentCoupling: Optional[LineSegmentCoupling] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LineSegmentCoupling.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The description of this line's coupling with other lines in a coupled group.
            '''

        })
    '''
    The description of this line's coupling with other lines in a coupled
    group.
    '''

    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthImpedance.ACLineSegments',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Per-length impedance of this line segment.
            '''

        })
    '''
    Per-length impedance of this line segment.
    '''

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.ACLineSegements',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IntraphaseSpacing.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Feeder(PowerSystemResource):
    '''
    A collection of equipment for organizational purposes, used for grouping
    distribution resources.
    The organization a feeder does not necessarily reflect connectivity or
    current operation state.
    '''

    NormalHeadTerminal: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.NormalHeadFeeder',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The normal head terminal or terminals of the feeder.
            '''

        })
    '''
    The normal head terminal or terminals of the feeder.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class WireInfo(ConductorInfo):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    ACLineSegmentPhase: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.WireInfo',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireBundleInfo: list[WireBundleInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireBundleInfo.WireInfo',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireInfo',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Wire phase information associated with this wire information.
            '''

        })
    '''
    Wire phase information associated with this wire information.
    '''

    coreStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            (if used) Number of strands in the steel core.
            '''

        })
    '''
    (if used) Number of strands in the steel core.
    '''

    insulated: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            True if conductor is insulated.
            '''

        })
    '''
    True if conductor is insulated.
    '''

    sizeDescription: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
            '''

        })
    '''
    Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
    '''

    strandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Number of strands in the conductor.
            '''

        })
    '''
    Number of strands in the conductor.
    '''

    constructionKind: Optional[ WireMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    coreRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            (if there is a different core material) Radius of the central core.
            '''

        })
    '''
    (if there is a different core material) Radius of the central core.
    '''

    coreStrandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    gmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Geometric mean radius. If we replace the conductor by a thin walled tube
            of radius GMR, then its reactance is identical to the reactance of the
            actual conductor.
            '''

        })
    '''
    Geometric mean radius. If we replace the conductor by a thin walled
    tube of radius GMR, then its reactance is identical to the reactance
    of the actual conductor.
    '''

    insulationMaterial: Optional[ WireInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            (if insulated conductor) Material used for insulation.
            '''

        })
    '''
    (if insulated conductor) Material used for insulation.
    '''

    insulationThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            (if insulated conductor) Thickness of the insulation.
            '''

        })
    '''
    (if insulated conductor) Thickness of the insulation.
    '''

    radius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Outside radius of the wire.
            '''

        })
    '''
    Outside radius of the wire.
    '''

    ratedStrength: Optional[ float | Force ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    strandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class BareWireInfo(WireInfo):
    '''
    Bare wire data.
    '''

    wireConstructionKind: Optional[ WireConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Kind of wire construction
            '''

        })
    '''
    Kind of wire construction
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class CableInfo(WireInfo):
    '''
    Cable data.
    '''

    InsulationInfo: Optional[InsulationInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InsulationInfo.CableInfo',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    isStrandFill: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            True if wire strands are extruded in a way to fill the voids in the cable.
            '''

        })
    '''
    True if wire strands are extruded in a way to fill the voids in the
    cable.
    '''

    sheathAsNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            True if sheath / shield is used as a neutral (i.e., bonded).
            '''

        })
    '''
    True if sheath / shield is used as a neutral (i.e., bonded).
    '''

    constructionKind: Optional[ CableConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Kind of construction of this cable.
            '''

        })
    '''
    Kind of construction of this cable.
    '''

    diameterOverCore: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Diameter over the core, including any semi-con screen; should be the insulating
            layer's inside diameter.
            '''

        })
    '''
    Diameter over the core, including any semi-con screen; should be the
    insulating layer's inside diameter.
    '''

    diameterOverInsulation: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Diameter over the insulating layer, excluding outer screen.
            '''

        })
    '''
    Diameter over the insulating layer, excluding outer screen.
    '''

    diameterOverJacket: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Diameter over the outermost jacketing layer.
            '''

        })
    '''
    Diameter over the outermost jacketing layer.
    '''

    diameterOverScreen: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Diameter over the outer screen; should be the shield's inside diameter.
            '''

        })
    '''
    Diameter over the outer screen; should be the shield's inside diameter.
    '''

    nominalTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Maximum nominal design operating temperature.
            '''

        })
    '''
    Maximum nominal design operating temperature.
    '''

    outerJacketKind: Optional[ CableOuterJacketKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Kind of outer jacket of this cable.
            '''

        })
    '''
    Kind of outer jacket of this cable.
    '''

    shieldMaterial: Optional[ CableShieldMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Material of the shield.
            '''

        })
    '''
    Material of the shield.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class OverheadWireInfo(WireInfo):
    '''
    Overhead wire data.
    '''

    wireConstructionKind: Optional[ WireConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute add',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class WirePosition(IdentifiedObject):
    '''
    Identification, spacing and configuration of the wires of a conductor with
    respect to a structure.
    '''

    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WirePosition',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Wire phase information for this wire position.
            '''

        })
    '''
    Wire phase information for this wire position.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Numbering for wires on a WireSpacingInfo. Neutrals should be numbered last.
            '''

        })
    '''
    Numbering for wires on a WireSpacingInfo. Neutrals should be numbered
    last.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'ToBeRemoved enumeration Attribute add',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The phase connection of the wire at both ends.
            '''

        })
    '''
    The phase connection of the wire at both ends.
    '''

    xCoord: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Signed horizontal distance from the wire at this position to a common reference
            point.
            '''

        })
    '''
    Signed horizontal distance from the wire at this position to a common
    reference point.
    '''

    yCoord: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Signed vertical distance from the wire at this position: above ground (positive
            value) or burial depth below ground (negative value).
            '''

        })
    '''
    Signed vertical distance from the wire at this position: above ground
    (positive value) or burial depth below ground (negative value).
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.WirePositions',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Wire spacing data this wire position belongs to.
            '''

        })
    '''
    Wire spacing data this wire position belongs to.
    '''

@dataclass(repr=False)
class WirePhaseInfo(Identity):
    '''
    Information on a wire carrying a single phase.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.WirePhaseInfo',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Wire assembly information using this wire phase information.
            '''

        })
    '''
    Wire assembly information using this wire phase information.
    '''

    WireBundleInfo: Optional[WireBundleInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireBundleInfo.WirePhaseInfos',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireInfo: Optional[WireInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireInfo.WirePhaseInfo',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Wire information contributing to this wire phase information.
            '''

        })
    '''
    Wire information contributing to this wire phase information.
    '''

    WirePosition: Optional[WirePosition] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WirePosition.WirePhaseInfo',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Wire position with this wire phase information.
            '''

        })
    '''
    Wire position with this wire phase information.
    '''

@stereotype(CIMStereotype.enumeration)
class CableConstructionKind(Enum):
    '''
    Kind of cable construction.
    '''

    compacted = 'compacted'
    '''
    Compacted cable.
    '''

    compressed = 'compressed'
    '''
    Compressed cable.
    '''

    other = 'other'
    '''
    Other kind of cable construction.
    '''

    sector = 'sector'
    '''
    Sector cable.
    '''

    segmental = 'segmental'
    '''
    Segmental cable.
    '''

    solid = 'solid'
    '''
    Solid cable.
    '''

    stranded = 'stranded'
    '''
    Stranded cable.
    '''

@stereotype(CIMStereotype.enumeration)
class CableOuterJacketKind(Enum):
    '''
    Kind of cable outer jacket.
    '''

    insulating = 'insulating'
    '''
    Insulating cable outer jacket.
    '''

    linearLowDensityPolyethylene = 'linearLowDensityPolyethylene'
    '''
    Linear low density polyethylene cable outer jacket.
    '''

    none = 'none'
    '''
    Cable has no outer jacket.
    '''

    other = 'other'
    '''
    Pther kind of cable outer jacket.
    '''

    polyethylene = 'polyethylene'
    '''
    Polyethylene cable outer jacket.
    '''

    pvc = 'pvc'
    '''
    PVC cable outer jacket.
    '''

    semiconducting = 'semiconducting'
    '''
    Semiconducting cable outer jacket.
    '''

@stereotype(CIMStereotype.enumeration)
class CableShieldMaterialKind(Enum):
    '''
    Kind of cable shield material.
    '''

    aluminum = 'aluminum'
    '''
    Aluminum cable shield.
    '''

    copper = 'copper'
    '''
    Copper cable shield.
    '''

    lead = 'lead'
    '''
    Lead cable shield.
    '''

    other = 'other'
    '''
    Other kind of cable shield material.
    '''

    steel = 'steel'
    '''
    Steel cable shield.
    '''

@stereotype(CIMStereotype.GridAPPSD)
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class EarthModelKind(Enum):
    '''
    '''

    carson = 'carson'
    '''
    '''

    deri = 'deri'
    '''
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class PhaseCode(Enum):
    '''
    Enumeration of phase identifiers used to designate the combination of phase
    and/or neutral conductors at a terminal, measurement or equipment modelled
    as a single-line balanced equivalent.
    This is an unordered enumeration of phase identifiers. Allows designation
    of phases for both transmission and distribution equipment, circuits and
    loads. The enumeration, by itself, does not describe how the phases are
    connected together or connected to ground. Ground is not explicitly denoted
    as a phase.
    Residential and small commercial loads are often served from single-phase,
    or split-phase, secondary circuits. For the example of s12N, phases 1 and
    2 refer to hot wires that are 180 degrees out of phase, while N refers
    to the neutral wire. Through single-phase transformer connections, these
    secondary circuits may be served from one or two of the primary phases
    A, B, and C. For three-phase loads, use the A, B, C phase codes instead
    of s12N.
    The integer values are from IEC 61968-9 to support revenue metering applications.
    '''

    A = 'A'
    '''
    Phase A.
    '''

    AB = 'AB'
    '''
    Phases A and B.
    '''

    ABC = 'ABC'
    '''
    Phases A, B, and C.
    '''

    ABCN = 'ABCN'
    '''
    Phases A, B, C, and N.
    '''

    ABN = 'ABN'
    '''
    Phases A, B, and neutral.
    '''

    AC = 'AC'
    '''
    Phases A and C.
    '''

    ACN = 'ACN'
    '''
    Phases A, C and neutral.
    '''

    AN = 'AN'
    '''
    Phases A and neutral.
    '''

    B = 'B'
    '''
    Phase B.
    '''

    BC = 'BC'
    '''
    Phases B and C.
    '''

    BCN = 'BCN'
    '''
    Phases B, C, and neutral.
    '''

    BN = 'BN'
    '''
    Phases B and neutral.
    '''

    C = 'C'
    '''
    Phase C.
    '''

    CN = 'CN'
    '''
    Phases C and neutral.
    '''

    N = 'N'
    '''
    Neutral phase.
    '''

    X = 'X'
    '''
    Unknown non-neutral phase.
    '''

    XN = 'XN'
    '''
    Unknown non-neutral phase plus neutral.
    '''

    XY = 'XY'
    '''
    Two unknown non-neutral phases.
    '''

    XYN = 'XYN'
    '''
    Two unknown non-neutral phases plus neutral.
    '''

    none = 'none'
    '''
    No phases specified.
    '''

    s1 = 's1'
    '''
    Secondary phase 1.
    '''

    s12 = 's12'
    '''
    Secondary phase 1 and 2.
    '''

    s12N = 's12N'
    '''
    Secondary phases 1, 2, and neutral.
    '''

    s1N = 's1N'
    '''
    Secondary phase 1 and neutral.
    '''

    s2 = 's2'
    '''
    Secondary phase 2.
    '''

    s2N = 's2N'
    '''
    Secondary phase 2 and neutral.
    '''

@stereotype(CIMStereotype.enumeration)
class PhaseCountKind(Enum):
    '''
    Number of phases supported by a device.
    '''

    other = 'other'
    '''
    Other
    '''

    singlePhase = 'singlePhase'
    '''
    Single phase
    '''

    threePhase = 'threePhase'
    '''
    Three phases
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class SinglePhaseKind(Enum):
    '''
    Enumeration of phase identifiers used to designate the specific phase of
    conducting equipment modelled as individual unbalanced phases.
    Allows designation of specific phases for transmission and distribution
    equipment, circuits and loads.
    '''

    A = 'A'
    '''
    Phase A.
    '''

    B = 'B'
    '''
    Phase B.
    '''

    C = 'C'
    '''
    Phase C.
    '''

    N = 'N'
    '''
    Neutral.
    '''

    s1 = 's1'
    '''
    Secondary phase 1.
    '''

    s2 = 's2'
    '''
    Secondary phase 2.
    '''

@stereotype(CIMStereotype.enumeration)
class WireConstructionKind(Enum):
    '''
    Kind of cable construction.
    '''

    other = 'other'
    '''
    Other kind of cable construction.
    '''

    solid = 'solid'
    '''
    Solid cable.
    '''

    stranded = 'stranded'
    '''
    Stranded cable.
    '''

@stereotype(CIMStereotype.GridAPPSD)
@stereotype(CIMStereotype.enumeration)
class WireInstallationKind(Enum):
    '''
    '''

    overheadBare = 'overheadBare'
    '''
    '''

    overheadSpacerCable = 'overheadSpacerCable'
    '''
    '''

    overheadTreeWire = 'overheadTreeWire'
    '''
    '''

    undergroundConduit = 'undergroundConduit'
    '''
    '''

    undergroundDirectBury = 'undergroundDirectBury'
    '''
    '''

    undergroundDuctBank = 'undergroundDuctBank'
    '''
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class WireInsulationKind(Enum):
    '''
    Kind of wire insulation.
    '''

    asbestosAndVarnishedCambric = 'asbestosAndVarnishedCambric'
    '''
    Asbestos and varnished cambric wire insulation.
    '''

    beltedPilc = 'beltedPilc'
    '''
    Belted pilc wire insulation.
    '''

    butyl = 'butyl'
    '''
    Butyl wire insulation.
    '''

    crosslinkedPolyethylene = 'crosslinkedPolyethylene'
    '''
    Crosslinked polyethylene wire insulation.
    '''

    ethylenePropyleneRubber = 'ethylenePropyleneRubber'
    '''
    Ethylene propylene rubber wire insulation.
    '''

    highMolecularWeightPolyethylene = 'highMolecularWeightPolyethylene'
    '''
    High nolecular weight polyethylene wire insulation.
    '''

    highPressureFluidFilled = 'highPressureFluidFilled'
    '''
    High pressure fluid filled wire insulation.
    '''

    lowCapacitanceRubber = 'lowCapacitanceRubber'
    '''
    Low capacitance rubber wire insulation.
    '''

    oilPaper = 'oilPaper'
    '''
    Oil paper wire insulation.
    '''

    other = 'other'
    '''
    Other kind of wire insulation.
    '''

    ozoneResistantRubber = 'ozoneResistantRubber'
    '''
    Ozone resistant rubber wire insulation.
    '''

    rubber = 'rubber'
    '''
    Rubber wire insulation.
    '''

    siliconRubber = 'siliconRubber'
    '''
    Silicon rubber wire insulation.
    '''

    treeResistantHighMolecularWeightPolyethylene = 'treeResistantHighMolecularWeightPolyethylene'
    '''
    Tree resistant high molecular weight polyethylene wire insulation.
    '''

    treeRetardantCrosslinkedPolyethylene = 'treeRetardantCrosslinkedPolyethylene'
    '''
    Tree retardant crosslinked polyethylene wire insulation.
    '''

    unbeltedPilc = 'unbeltedPilc'
    '''
    Unbelted pilc wire insulation.
    '''

    varnishedCambricCloth = 'varnishedCambricCloth'
    '''
    Varnished cambric cloth wire insulation.
    '''

    varnishedDacronGlass = 'varnishedDacronGlass'
    '''
    Varnished dacron glass wire insulation.
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class WireMaterialKind(Enum):
    '''
    Kind of wire material.
    '''

    aaac = 'aaac'
    '''
    Aluminum-alloy conductor steel reinforced.
    '''

    acsr = 'acsr'
    '''
    Aluminum conductor steel reinforced.
    '''

    aluminum = 'aluminum'
    '''
    Aluminum wire.
    '''

    aluminumAlloy = 'aluminumAlloy'
    '''
    Aluminum-alloy wire.
    '''

    aluminumAlloySteel = 'aluminumAlloySteel'
    '''
    Aluminum-alloy-steel wire.
    '''

    aluminumSteel = 'aluminumSteel'
    '''
    Aluminum-steel wire.
    '''

    copper = 'copper'
    '''
    Copper wire.
    '''

    other = 'other'
    '''
    Other wire material.
    '''

    steel = 'steel'
    '''
    Steel wire.
    '''

@stereotype(CIMStereotype.GridAPPSD)
@stereotype(CIMStereotype.enumeration)
class WireSpacingKind(Enum):
    '''
    '''

    flatSpaced = 'flatSpaced'
    '''
    '''

    flatTouching = 'flatTouching'
    '''
    '''

    other = 'other'
    '''
    '''

    trefoil = 'trefoil'
    '''
    '''

@stereotype(CIMStereotype.enumeration)
class WireUsageKind(Enum):
    '''
    Kind of wire usage.
    '''

    distribution = 'distribution'
    '''
    Wire is used in medium voltage network.
    '''

    other = 'other'
    '''
    Other kind of wire usage.
    '''

    secondary = 'secondary'
    '''
    Wire is used in low voltage circuit.
    '''

    transmission = 'transmission'
    '''
    Wire is used in extra-high voltage or high voltage network.
    '''

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Area(CIMUnit):
    '''
    Area.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.m2
    def __init__(self, value, input_unit: str='m2', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Conductance(CIMUnit):
    '''
    Factor by which voltage must be multiplied to give corresponding power
    lost from a circuit. Real part of admittance.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.S
    def __init__(self, value, input_unit: str='S', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ConductancePerLength(CIMUnit):
    '''
    Real part of admittance per unit of length.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.SPerm
    def __init__(self, value, input_unit: str='SPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class CurrentFlow(CIMUnit):
    '''
    Electrical current with sign convention: positive flow is out of the conducting
    equipment into the connectivity node. Can be both AC and DC.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.A
    def __init__(self, value, input_unit: str='A', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Displacement(CIMUnit):
    '''
    Unit of displacement relative to a reference position, hence can be negative.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.m
    def __init__(self, value, input_unit: str='m', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Force(CIMUnit):
    '''
    Force in newtons. It shall be a positive value or zero.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.N
    def __init__(self, value, input_unit: str='N', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Frequency(CIMUnit):
    '''
    Cycles per second.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.Hz
    def __init__(self, value, input_unit: str='Hz', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Length(CIMUnit):
    '''
    Unit of length. It shall be a positive value or zero.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.m
    def __init__(self, value, input_unit: str='m', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class MassPerLength(CIMUnit):
    '''
    Mass per length. It shall be a positive value or zero.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.kgPerm
    def __init__(self, value, input_unit: str='kgPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Reactance(CIMUnit):
    '''
    Reactance (imaginary part of impedance), at rated frequency.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohm
    def __init__(self, value, input_unit: str='ohm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ReactancePerLength(CIMUnit):
    '''
    Reactance (imaginary part of impedance) per unit of length, at rated frequency.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohmPerm
    def __init__(self, value, input_unit: str='ohmPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Resistance(CIMUnit):
    '''
    Resistance (real part of impedance).
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohm
    def __init__(self, value, input_unit: str='ohm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ResistancePerLength(CIMUnit):
    '''
    Resistance (real part of impedance) per unit of length.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohmPerm
    def __init__(self, value, input_unit: str='ohmPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Susceptance(CIMUnit):
    '''
    Imaginary part of admittance.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.S
    def __init__(self, value, input_unit: str='S', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class SusceptancePerLength(CIMUnit):
    '''
    Imaginary part of admittance per unit of length.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.SPerm
    def __init__(self, value, input_unit: str='SPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Temperature(CIMUnit):
    '''
    Value of temperature in degrees Celsius.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.degC
    def __init__(self, value, input_unit: str='degC', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Voltage(CIMUnit):
    '''
    Electrical voltage, can be both AC and DC.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.V
    def __init__(self, value, input_unit: str='V', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
