from __future__ import annotations

import logging
from dataclasses import dataclass, field
from enum import Enum
from typing import Optional

from cimgraph.data_profile.identity import Identity, stereotype
from cimgraph.data_profile.units import CIMUnit, UnitMultiplier, UnitSymbol

_log = logging.getLogger(__name__)
'''
Annotated CIMantic Graphs data profile for PMU
Generated by CIMTool http://cimtool.org
'''

class CIMStereotype(Enum):
    AggregateOf = 'AggregateOf'
    Attribute = 'Attribute'
    CIMDatatype = 'CIMDatatype'
    GridAPPSD = 'GridAPPSD'
    NC = 'NC'
    OfAggregate = 'OfAggregate'
    Primitive = 'Primitive'
    ShadowExtension = 'ShadowExtension'
    deprecated = 'deprecated'
    enumeration = 'enumeration'
    harmonization = 'harmonization'
    profcim = 'profcim'

BASE_URI = 'http://www.gridappsd.org/profiles/pmu#'
ONTOLOGY_URI = 'http://iec.ch/TC57/CIM101#'

@dataclass(repr=False)
class CalculationMethodOrder(Identity):
    '''
    The order of this calculation method in a hierarchy of calculation methods.
    '''

    CalculationMethodHierarchy: Optional[CalculationMethodHierarchy] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CalculationMethodHierarchy.CalculationMethodOrder',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The calculation method hierarchy of which this order of statistical calculation
            is a member.
            '''

        })
    '''
    The calculation method hierarchy of which this order of statistical
    calculation is a member.
    '''

@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a class that provides common identification for all classes needing
    identification and naming attributes.
    '''

    mRID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Master resource identifier issued by a model authority. The mRID is unique
            within an exchange context. Global uniqueness is easily achieved by using
            a UUID, as specified in IETF RFC 4122, for the mRID. The use of UUID is
            strongly recommended.
            For CIMXML data files in RDF syntax conforming to IEC 61970-552, the mRID
            is mapped to rdf:ID or rdf:about attributes that identify CIM object elements.
            '''

        })
    '''
    Master resource identifier issued by a model authority. The mRID is
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in IETF RFC 4122, for the mRID. The use
    of UUID is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552, the
    mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
    object elements.
    '''

    aliasName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The aliasName is free text human readable name of the object alternative
            to IdentifiedObject.name. It may be non unique and may not correlate to
            a naming hierarchy.
            The attribute aliasName is retained because of backwards compatibility
            between CIM releases. It is however recommended to replace aliasName with
            the Name class as aliasName is planned for retirement at a future time.
            '''

        })
    '''
    The aliasName is free text human readable name of the object alternative
    to IdentifiedObject.name. It may be non unique and may not correlate
    to a naming hierarchy.
    The attribute aliasName is retained because of backwards compatibility
    between CIM releases. It is however recommended to replace aliasName
    with the Name class as aliasName is planned for retirement at a future
    time.
    '''

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''

        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''

    name: list[Name] = field(
        default_factory=list,
        metadata={
        'type': 'NC',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Name.IdentifiedObject',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            All names of this identified object. Names may be but are not guaranteed
            to be unique.
            '''

        })
    '''
    All names of this identified object. Names may be but are not guaranteed
    to be unique.
    '''

@dataclass(repr=False)
class ACDCTerminal(IdentifiedObject):
    '''
    An electrical connection point (AC or DC) to a piece of conducting equipment.
    Terminals are connected at physical connection points called connectivity
    nodes.
    '''

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Measurements associated with this terminal defining where the measurement
            is placed in the network topology. It may be used, for instance, to capture
            the sensor position, such as a voltage transformer (PT) at a busbar or
            a current transformer (CT) at the bar between a breaker and an isolator.
            '''

        })
    '''
    Measurements associated with this terminal defining where the measurement
    is placed in the network topology. It may be used, for instance, to
    capture the sensor position, such as a voltage transformer (PT) at
    a busbar or a current transformer (CT) at the bar between a breaker
    and an isolator.
    '''

    connected: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The connected status is related to a bus-branch model and the topological
            node to terminal relation. True implies the terminal is connected to the
            related topological node and false implies it is not.
            In a bus-branch model, the connected status is used to tell if equipment
            is disconnected without having to change the connectivity described by
            the topological node to terminal relation. A valid case is that conducting
            equipment can be connected in one end and open in the other. In particular
            for an AC line segment, where the reactive line charging can be significant,
            this is a relevant case.
            '''

        })
    '''
    The connected status is related to a bus-branch model and the topological
    node to terminal relation. True implies the terminal is connected to
    the related topological node and false implies it is not.
    In a bus-branch model, the connected status is used to tell if equipment
    is disconnected without having to change the connectivity described
    by the topological node to terminal relation. A valid case is that
    conducting equipment can be connected in one end and open in the other.
    In particular for an AC line segment, where the reactive line charging
    can be significant, this is a relevant case.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The orientation of the terminal connections for a multiple terminal conducting
            equipment. The sequence numbering starts with 1 and additional terminals
            should follow in increasing order. The first terminal is the "starting
            point" for a two terminal branch.
            '''

        })
    '''
    The orientation of the terminal connections for a multiple terminal
    conducting equipment. The sequence numbering starts with 1 and additional
    terminals should follow in increasing order. The first terminal is
    the "starting point" for a two terminal branch.
    '''

@dataclass(repr=False)
class Terminal(ACDCTerminal):
    '''
    An AC electrical connection point to a piece of conducting equipment. Terminals
    are connected at physical connection points called connectivity nodes.
    '''

    phases: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Represents the normal network phasing condition. If the attribute is missing,
            three phases (ABC) shall be assumed, except for terminals of grounding
            classes (specializations of EarthFaultCompensator, GroundDisconnector,
            and Ground) which will be assumed to be N. Therefore, phase code ABCN is
            explicitly declared when needed, e.g. for star point grounding equipment.
            The phase code on terminals connecting the same ConnectivityNode or TopologicalNode
            as well as for equipment between two terminals shall be consistent.
            '''

        })
    '''
    Represents the normal network phasing condition. If the attribute is
    missing, three phases (ABC) shall be assumed, except for terminals
    of grounding classes (specializations of EarthFaultCompensator, GroundDisconnector,
    and Ground) which will be assumed to be N. Therefore, phase code ABCN
    is explicitly declared when needed, e.g. for star point grounding equipment.
    The phase code on terminals connecting the same ConnectivityNode or
    TopologicalNode as well as for equipment between two terminals shall
    be consistent.
    '''

    ConductingEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.Terminals',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The conducting equipment of the terminal. Conducting equipment have terminals
            that may be connected to other conducting equipment terminals via connectivity
            nodes or topological nodes.
            '''

        })
    '''
    The conducting equipment of the terminal. Conducting equipment have
    terminals that may be connected to other conducting equipment terminals
    via connectivity nodes or topological nodes.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.Terminals',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The connectivity node to which this terminal connects with zero impedance.
            '''

        })
    '''
    The connectivity node to which this terminal connects with zero impedance.
    '''

@stereotype(CIMStereotype.harmonization)
@dataclass(repr=False)
class CalculationMethodHierarchy(IdentifiedObject):
    '''
    The hierarchy of calculation methods used to derive this measurement.
    '''

    Measurement: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.CalculationMethodHierarchy',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Measurement to which this calculation method hierarchy applies.
            '''

        })
    '''
    Measurement to which this calculation method hierarchy applies.
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.CalculationMethodHierarchy',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Measurement value to which this calculation method hierarchy applies.
            '''

        })
    '''
    Measurement value to which this calculation method hierarchy applies.
    '''

    CalculationMethodOrder: list[CalculationMethodOrder] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CalculationMethodOrder.CalculationMethodHierarchy',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Order of a statistical calculation associated with this calculation method
            hierarchy.
            '''

        })
    '''
    Order of a statistical calculation associated with this calculation
    method hierarchy.
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.CalculationMethodHierarchy',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Measurement value to which this calculation method hierarchy applies.
            '''

        })
    '''
    Measurement value to which this calculation method hierarchy applies.
    '''

@dataclass(repr=False)
class ConnectivityNode(IdentifiedObject):
    '''
    Connectivity nodes are points where terminals of AC conducting equipment
    are connected together with zero impedance.
    '''

    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Terminals interconnected with zero impedance at a this connectivity node.
            '''

        })
    '''
    Terminals interconnected with zero impedance at a this connectivity
    node.
    '''

@dataclass(repr=False)
class Location(IdentifiedObject):
    '''
    The place, scene, or point of something where someone or something has
    been, is, and/or will be at a given moment in time. It can be defined with
    one or more position points (coordinates) in a given coordinate system.
    '''

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Locations',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.Location',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            All power system resources at this location.
            '''

        })
    '''
    All power system resources at this location.
    '''

@dataclass(repr=False)
class Measurement(IdentifiedObject):
    '''
    A Measurement represents any measured, calculated or non-measured non-calculated
    quantity. Any piece of equipment may contain Measurements, e.g. a substation
    may have temperature measurements and door open indications, a transformer
    may have oil temperature and tank pressure measurements, a bay may contain
    a number of power flow measurements and a Breaker may contain a switch
    status measurement.
    The PSR - Measurement association is intended to capture this use of Measurement
    and is included in the naming hierarchy based on EquipmentContainer. The
    naming hierarchy typically has Measurements as leaves, e.g. Substation-VoltageLevel-Bay-Switch-Measurement.
    Some Measurements represent quantities related to a particular sensor location
    in the network, e.g. a voltage transformer (VT) or potential transformer
    (PT) at a busbar or a current transformer (CT) at the bar between a breaker
    and an isolator. The sensing position is not captured in the PSR - Measurement
    association. Instead it is captured by the Measurement - Terminal association
    that is used to define the sensing location in the network topology. The
    location is defined by the connection of the Terminal to ConductingEquipment.
    If both a Terminal and PSR are associated, and the PSR is of type ConductingEquipment,
    the associated Terminal should belong to that ConductingEquipment instance.
    When the sensor location is needed both Measurement-PSR and Measurement-Terminal
    are used. The Measurement-Terminal association is never used alone.
    '''

    measurementType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Specifies the type of measurement. For example, this specifies if the measurement
            represents an indoor temperature, outdoor temperature, bus voltage, line
            flow, etc.
            When the measurementType is set to "Specialization", the type of Measurement
            is defined in more detail by the specialized class which inherits from
            Measurement.
            '''

        })
    '''
    Specifies the type of measurement. For example, this specifies if the
    measurement represents an indoor temperature, outdoor temperature,
    bus voltage, line flow, etc.
    When the measurementType is set to "Specialization", the type of Measurement
    is defined in more detail by the specialized class which inherits from
    Measurement.
    '''

    phases: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Indicates to which phases the measurement applies and avoids the need to
            use 'measurementType' to also encode phase information (which would explode
            the types). The phase information in Measurement, along with 'measurementType'
            and 'phases' uniquely defines a Measurement for a device, based on normal
            network phase. Their meaning will not change when the computed energizing
            phasing is changed due to jumpers or other reasons.
            If the attribute is missing three phases (ABC) shall be assumed.
            '''

        })
    '''
    Indicates to which phases the measurement applies and avoids the need
    to use 'measurementType' to also encode phase information (which would
    explode the types). The phase information in Measurement, along with
    'measurementType' and 'phases' uniquely defines a Measurement for a
    device, based on normal network phase. Their meaning will not change
    when the computed energizing phasing is changed due to jumpers or other
    reasons.
    If the attribute is missing three phases (ABC) shall be assumed.
    '''

    sourceType: Optional[ MeasurementSourceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The unit multiplier of the measured quantity.
            '''

        })
    '''
    The unit multiplier of the measured quantity.
    '''

    unitSymbol: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The unit of measure of the measured quantity.
            '''

        })
    '''
    The unit of measure of the measured quantity.
    '''

    CalculationMethodHierarchy: Optional[CalculationMethodHierarchy] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CalculationMethodHierarchy.Measurement',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Calculation method hierarchy which applies to this analog.
            '''

        })
    '''
    Calculation method hierarchy which applies to this analog.
    '''

    Locations: list[Location] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Location.Measurements',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    MeasurementSystem: Optional[MeasurementSystem] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementSystem.Measurements',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.Measurements',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The power system resource that contains the measurement.
            '''

        })
    '''
    The power system resource that contains the measurement.
    '''

    Terminal: Optional[ACDCTerminal] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCTerminal.Measurements',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            One or more measurements may be associated with a terminal in the network.
            '''

        })
    '''
    One or more measurements may be associated with a terminal in the network.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Analog(Measurement):
    '''
    Analog represents an analog Measurement.
    '''

    maxValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    minValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Normal value range minimum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range minimum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    normalValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Normal measurement value, e.g., used for percentage calculations.
            '''

        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''

    positiveFlowIn: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Indicates the direction of positive flow relative to the primary equipment
            connectivity.
            The attribute is applicable for measurements of flow such as active power,
            reactive power or current.
            TRUE means a positive measurement value at the terminal, where the measurement
            is located, indicates power is flowing into the related PowerSystemResource.
            FALSE means a positive measurement value at the terminal, where the measurement
            is located, indicates power is flowing out of the related PowerSystemResource.
            '''

        })
    '''
    Indicates the direction of positive flow relative to the primary equipment
    connectivity.
    The attribute is applicable for measurements of flow such as active
    power, reactive power or current.
    TRUE means a positive measurement value at the terminal, where the
    measurement is located, indicates power is flowing into the related
    PowerSystemResource.
    FALSE means a positive measurement value at the terminal, where the
    measurement is located, indicates power is flowing out of the related
    PowerSystemResource.
    '''

@stereotype(CIMStereotype.harmonization)
@dataclass(repr=False)
class MeasurementValue(IdentifiedObject):
    '''
    The current state for a measurement. A state value is an instance of a
    measurement from a specific source. Measurements can be associated with
    many state values, each representing a different source for the measurement.
    '''

    CalculationMethodHierarchy: Optional[CalculationMethodHierarchy] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CalculationMethodHierarchy.MeasurementValue',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The time when the value was last updated.
            '''

        })
    '''
    The time when the value was last updated.
    '''

    sensorAccuracy: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The limit, expressed as a percentage of the sensor maximum, that errors
            will not exceed when the sensor is used under reference conditions.
            '''

        })
    '''
    The limit, expressed as a percentage of the sensor maximum, that errors
    will not exceed when the sensor is used under reference conditions.
    '''

    CalculationMethodHierarchy: Optional[CalculationMethodHierarchy] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CalculationMethodHierarchy.MeasurementValue',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    MeasurementValueQuality: Optional[MeasurementValueQuality] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueQuality.MeasurementValue',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''

        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''

    MeasurementValueSource: Optional[MeasurementValueSource] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueSource.MeasurementValues',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            A reference to the type of source that updates the MeasurementValue, e.g.
            SCADA, CCLink, manual, etc. User conventions for the names of sources are
            contained in the introduction to IEC 61970-301.
            '''

        })
    '''
    A reference to the type of source that updates the MeasurementValue,
    e.g. SCADA, CCLink, manual, etc. User conventions for the names of
    sources are contained in the introduction to IEC 61970-301.
    '''

    RemoteSource: Optional[RemoteSource] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RemoteSource.MeasurementValue',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Link to the physical telemetered point associated with this measurement.
            '''

        })
    '''
    Link to the physical telemetered point associated with this measurement.
    '''

@dataclass(repr=False)
class MeasurementVector(MeasurementValue):
    '''
    '''

@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class PhasorMeasurementValue(MeasurementVector):
    '''
    '''

@dataclass(repr=False)
class MeasurementValueSource(IdentifiedObject):
    '''
    MeasurementValueSource describes the alternative sources updating a MeasurementValue.
    User conventions for how to use the MeasurementValueSource attributes are
    defined in IEC 61970-301.
    '''

    MeasurementValues: list[MeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeasurementValue.MeasurementValueSource',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The MeasurementValues updated by the source.
            '''

        })
    '''
    The MeasurementValues updated by the source.
    '''

@dataclass(repr=False)
class PMUConfiguration(IdentifiedObject):
    '''
    PMU Configuration Frame data from IEEE Std. C37.118
    '''

@dataclass(repr=False)
class PowerSystemResource(IdentifiedObject):
    '''
    A power system resource (PSR) can be an item of equipment such as a switch,
    an equipment container containing many individual items of equipment such
    as a substation, or an organisational entity such as sub-control area.
    Power system resources can have measurements associated.
    '''

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.PowerSystemResource',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The measurements associated with this power system resource.
            '''

        })
    '''
    The measurements associated with this power system resource.
    '''

    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.PowerSystemResources',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Location of this power system resource.
            '''

        })
    '''
    Location of this power system resource.
    '''

@dataclass(repr=False)
class ConnectivityNodeContainer(PowerSystemResource):
    '''
    A base class for all objects that may contain connectivity nodes or topological
    nodes.
    '''

@dataclass(repr=False)
class EquipmentContainer(ConnectivityNodeContainer):
    '''
    A modelling construct to provide a root class for containing equipment.
    '''

    Equipments: list[Equipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Equipment.EquipmentContainer',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Contained equipment.
            '''

        })
    '''
    Contained equipment.
    '''

@dataclass(repr=False)
class Substation(EquipmentContainer):
    '''
    A collection of equipment for purposes other than generation or utilization,
    through which electric energy in bulk is passed for the purposes of switching
    or modifying its characteristics.
    '''

@dataclass(repr=False)
class Equipment(PowerSystemResource):
    '''
    The parts of a power system that are physical devices, electronic or mechanical.
    '''

    EquipmentContainer: Optional[EquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EquipmentContainer.Equipments',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Container of this equipment.
            '''

        })
    '''
    Container of this equipment.
    '''

@dataclass(repr=False)
class ConductingEquipment(Equipment):
    '''
    The parts of the AC power system that are designed to carry current or
    that are conductively connected through terminals.
    '''

    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConductingEquipment',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Conducting equipment have terminals that may be connected to other conducting
            equipment terminals via connectivity nodes or topological nodes.
            '''

        })
    '''
    Conducting equipment have terminals that may be connected to other
    conducting equipment terminals via connectivity nodes or topological
    nodes.
    '''

@dataclass(repr=False)
class Connector(ConductingEquipment):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation and are
    modelled with a single logical terminal.
    '''

@dataclass(repr=False)
class BusbarSection(Connector):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation. The BusbarSection
    class is intended to represent physical parts of bus bars no matter how
    that bus bar is constructed.
    Voltage measurements are typically obtained from voltage transformers that
    are connected to busbar sections. A bus bar section may have many physical
    terminals but for analysis is modelled with exactly one logical terminal.
    '''

@dataclass(repr=False)
class Junction(Connector):
    '''
    A point where one or more conducting equipments are connected with zero
    resistance.
    The Junction class is intended to provide a place to associate additional
    information to a connectivity node which connects two or more equipment
    terminals. Examples include a tee-point or the connection point between
    two switches.
    The Junction class is intended to provide a method to associate additional
    information, for instance Location, to a ConnectivityNode. Examples include
    a T-point or the connection point between two switches. Typically, BusbarSection
    objects and Junction objects are represented by different symbols on diagrams.
    '''

@dataclass(repr=False)
class CurrentTransformer(Equipment):
    '''
    Instrument transformer used to measure electrical qualities of the circuit
    that is being protected and/or monitored. Typically used as current transducer
    for the purpose of metering or protection. A typical secondary current
    rating would be 5A.
    '''

    usage: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Intended usage of the CT; i.e. metering, protection.
            '''

        })
    '''
    Intended usage of the CT; i.e. metering, protection.
    '''

    accuracyLimit: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Percent of rated current for which the CT remains accurate within specified
            limits.
            '''

        })
    '''
    Percent of rated current for which the CT remains accurate within specified
    limits.
    '''

    coreBurden: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Power burden of the CT core.
            '''

        })
    '''
    Power burden of the CT core.
    '''

@dataclass(repr=False)
class PotentialTransformer(Equipment):
    '''
    Instrument transformer (also known as Voltage Transformer) used to measure
    electrical qualities of the circuit that is being protected and/or monitored.
    Typically used as voltage transducer for the purpose of metering, protection,
    or sometimes auxiliary substation supply. A typical secondary voltage rating
    would be 120V.
    '''

    nominalRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Nominal ratio between the primary and secondary voltage.
            '''

        })
    '''
    Nominal ratio between the primary and secondary voltage.
    '''

    type: Optional[ PotentialTransformerKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Potential transformer construction type.
            '''

        })
    '''
    Potential transformer construction type.
    '''

@dataclass(repr=False)
class ProtectionEquipment(Equipment):
    '''
    An electrical device designed to respond to input conditions in a prescribed
    manner and after specified conditions are met to cause contact operation
    or similar abrupt change in associated electric control circuits, or simply
    to display the detected condition. Protection equipment is associated with
    conducting equipment and usually operate circuit breakers.
    '''

    highLimit: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The maximum allowable value.
            '''

        })
    '''
    The maximum allowable value.
    '''

    lowLimit: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The minimum allowable value.
            '''

        })
    '''
    The minimum allowable value.
    '''

    powerDirectionFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Direction same as positive active power flow value.
            '''

        })
    '''
    Direction same as positive active power flow value.
    '''

    relayDelayTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The time delay from detection of abnormal conditions to relay operation.
            '''

        })
    '''
    The time delay from detection of abnormal conditions to relay operation.
    '''

    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The unit multiplier of the value.
            '''

        })
    '''
    The unit multiplier of the value.
    '''

    unitSymbol: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            The unit of measure of the value.
            '''

        })
    '''
    The unit of measure of the value.
    '''

    DigitalFaultRecorder: Optional[DigitalFaultRecorder] = field(
        default=None,
        metadata={
        'type': 'GridAPPSD',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DigitalFaultRecorder.ProtectionEquipment',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PhasorMeasurementUnit: Optional[PhasorMeasurementUnit] = field(
        default=None,
        metadata={
        'type': 'GridAPPSD',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhasorMeasurementUnit.ProtectionEquipment',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class MeasurementSystem(PowerSystemResource):
    '''
    '''

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.MeasurementSystem',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class DigitalFaultRecorder(MeasurementSystem):
    '''
    '''

    ProtectionEquipment: list[ProtectionEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionEquipment.DigitalFaultRecorder',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class MergingUnit(MeasurementSystem):
    '''
    '''

@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class PhasorMeasurementUnit(MeasurementSystem):
    '''
    '''

    ProtectionEquipment: list[ProtectionEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionEquipment.PhasorMeasurementUnit',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    reportingRate: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            For periodic data frames, PMUs shall support data reporting (by recording
            or output) at sub-multiples of the
            nominal power system frequency. Required rates are provided in Table 18
            in IEEE Std. C37.118
            '''

        })
    '''
    For periodic data frames, PMUs shall support data reporting (by recording
    or output) at sub-multiples of the
    nominal power system frequency. Required rates are provided in Table
    18 in IEEE Std. C37.118
    '''

    timeSourceType: Optional[ TimeSourceKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            PMU must have a time source, which may be a dedicated GPS antenna for each
            PMU or an alternate source (used to prevent vulnerabilities from GPS spoofing).
            The PMU can only use one time source at a time.
            '''

        })
    '''
    PMU must have a time source, which may be a dedicated GPS antenna for
    each PMU or an alternate source (used to prevent vulnerabilities from
    GPS spoofing). The PMU can only use one time source at a time.
    '''

    usageType: Optional[ SynchrophaserUsageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://gridappsd.org/CIM/extension#',
        'docstring':
            '''
            P-type units use a single electrical cycle for protection applications.
            M-type units use 5 or more cycles for higher quality frequency measurements.
            '''

        })
    '''
    P-type units use a single electrical cycle for protection applications.
    M-type units use 5 or more cycles for higher quality frequency measurements.
    '''

@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class DisturbanceRecorder(PhasorMeasurementUnit):
    '''
    PMU that is also capable of collecting point-on-wave data
    '''

@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class PointOnWaveSensor(MeasurementSystem):
    '''
    '''

@dataclass(repr=False)
class PhasorDataConcentrator(PowerSystemResource):
    '''
    '''

@dataclass(repr=False)
class RemoteSource(IdentifiedObject):
    '''
    Remote sources are state variables that are telemetered or calculated within
    the remote unit.
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.RemoteSource',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Link to the physical telemetered point associated with this measurement.
            '''

        })
    '''
    Link to the physical telemetered point associated with this measurement.
    '''

@dataclass(repr=False)
class SynchrophaserFrame(IdentifiedObject):
    '''
    Two-byte frame synchronization word following series of bits defined in
    Table 1 of IEEE c37.118-2024
    '''

@stereotype(CIMStereotype.GridAPPSD)
@dataclass(repr=False)
class PMUConfigurationFrame(SynchrophaserFrame):
    '''
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class MeasurementValueQuality(Identity):
    '''
    Measurement quality flags. Bits 0-10 are defined for substation automation
    in IEC 61850-7-3. Bits 11-15 are reserved for future expansion by that
    document. Bits 16-31 are reserved for EMS applications.
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.MeasurementValueQuality',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''

        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''

@stereotype(CIMStereotype.NC)
@stereotype(CIMStereotype.Attribute)
@dataclass(repr=False)
class Name(Identity):
    '''
    The Name class, in possible combination with a name type and a naming authority
    provides the means to define any number of names or alternative identifiers
    for an object.
    '''

    IdentifiedObject: Optional[IdentifiedObject] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IdentifiedObject.Name',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Identified object that this name designates.
            '''

        })
    '''
    Identified object that this name designates.
    '''

@dataclass(repr=False)
class PMUStream(Identity):
    '''
    '''

@dataclass(repr=False)
class PMUValueConcentration(Identity):
    '''
    '''

@dataclass(repr=False)
class PositionPoint(Identity):
    '''
    Set of spatial coordinates that determine a point, defined in the coordinate
    system specified in 'Location.CoordinateSystem'. Use a single position
    point instance to describe a point-oriented location. Use a sequence of
    position points to describe a line-oriented object (physical location of
    non-point oriented objects like cables or lines), or area of an object
    (like a substation or a geographical zone - in this case, have first and
    last position point with the same values).
    '''

    xPosition: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            X axis position.
            '''

        })
    '''
    X axis position.
    '''

    yPosition: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            Y axis position.
            '''

        })
    '''
    Y axis position.
    '''

    zPosition: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM101#',
        'docstring':
            '''
            (if applicable) Z axis position.
            '''

        })
    '''
    (if applicable) Z axis position.
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class MeasurementSourceKind(Enum):
    '''
    Source from which the measurement has been obtained, such as SCADA, ICCP
    link, or a co-simulation
    '''

    allocated = 'allocated'
    '''
    '''

    ami = 'ami'
    '''
    Measurement from a smart meter for advanced metering infrastructure
    '''

    calculated = 'calculated'
    '''
    '''

    ccLink = 'ccLink'
    '''
    Value received from a remote control centre via ICCP, TASE.2, or other
    control centre protocol
    '''

    estimated = 'estimated'
    '''
    '''

    forecasted = 'forecasted'
    '''
    '''

    operator = 'operator'
    '''
    Operated entered values (always manually maintained, PSR is not connected
    to an RTU)
    '''

    powerFlow = 'powerFlow'
    '''
    '''

    scada = 'scada'
    '''
    Telemetered values received from a local SCADA system
    '''

    thirdParty = 'thirdParty'
    '''
    Measurements received from a non-utility 3rd party, such as a DER aggregator
    '''

    wams = 'wams'
    '''
    PMU values received over a wide area measurement system
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class PhaseCode(Enum):
    '''
    Enumeration of phase identifiers used to designate the combination of phase
    and/or neutral conductors at a terminal, measurement or equipment modelled
    as a single-line balanced equivalent.
    This is an unordered enumeration of phase identifiers. Allows designation
    of phases for both transmission and distribution equipment, circuits and
    loads. The enumeration, by itself, does not describe how the phases are
    connected together or connected to ground. Ground is not explicitly denoted
    as a phase.
    Residential and small commercial loads are often served from single-phase,
    or split-phase, secondary circuits. For the example of s12N, phases 1 and
    2 refer to hot wires that are 180 degrees out of phase, while N refers
    to the neutral wire. Through single-phase transformer connections, these
    secondary circuits may be served from one or two of the primary phases
    A, B, and C. For three-phase loads, use the A, B, C phase codes instead
    of s12N.
    The integer values are from IEC 61968-9 to support revenue metering applications.
    '''

    A = 'A'
    '''
    Phase A.
    '''

    AB = 'AB'
    '''
    Phases A and B.
    '''

    ABC = 'ABC'
    '''
    Phases A, B, and C.
    '''

    ABCN = 'ABCN'
    '''
    Phases A, B, C, and N.
    '''

    ABN = 'ABN'
    '''
    Phases A, B, and neutral.
    '''

    AC = 'AC'
    '''
    Phases A and C.
    '''

    ACN = 'ACN'
    '''
    Phases A, C and neutral.
    '''

    AN = 'AN'
    '''
    Phases A and neutral.
    '''

    B = 'B'
    '''
    Phase B.
    '''

    BC = 'BC'
    '''
    Phases B and C.
    '''

    BCN = 'BCN'
    '''
    Phases B, C, and neutral.
    '''

    BN = 'BN'
    '''
    Phases B and neutral.
    '''

    C = 'C'
    '''
    Phase C.
    '''

    CN = 'CN'
    '''
    Phases C and neutral.
    '''

    N = 'N'
    '''
    Neutral phase.
    '''

    X = 'X'
    '''
    Unknown non-neutral phase.
    '''

    XN = 'XN'
    '''
    Unknown non-neutral phase plus neutral.
    '''

    XY = 'XY'
    '''
    Two unknown non-neutral phases.
    '''

    XYN = 'XYN'
    '''
    Two unknown non-neutral phases plus neutral.
    '''

    none = 'none'
    '''
    No phases specified.
    '''

    s1 = 's1'
    '''
    Secondary phase 1.
    '''

    s12 = 's12'
    '''
    Secondary phase 1 and 2.
    '''

    s12N = 's12N'
    '''
    Secondary phases 1, 2, and neutral.
    '''

    s1N = 's1N'
    '''
    Secondary phase 1 and neutral.
    '''

    s2 = 's2'
    '''
    Secondary phase 2.
    '''

    s2N = 's2N'
    '''
    Secondary phase 2 and neutral.
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class PotentialTransformerKind(Enum):
    '''
    The construction kind of the potential transformer.
    '''

    capacitiveCoupling = 'capacitiveCoupling'
    '''
    The potential transformer is using capacitive coupling to create secondary
    voltage.
    '''

    inductive = 'inductive'
    '''
    The potential transformer is using induction coils to create secondary
    voltage.
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class SynchrophaserUsageKind(Enum):
    '''
    '''

    measurement = 'measurement'
    '''
    '''

    protection = 'protection'
    '''
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class TimeSourceKind(Enum):
    '''
    '''

    atomicClock = 'atomicClock'
    '''
    local rubidium or cesium clock
    '''

    crystalOscillator = 'crystalOscillator'
    '''
    quartz or other crystal oscillator
    '''

    gnss = 'gnss'
    '''
    Other global navigation satellite systems, such as BeiDeo, Galileo,
    or GLONASS
    '''

    gps = 'gps'
    '''
    global positioning system
    '''

    ntp = 'ntp'
    '''
    network time protocol
    '''

    ptp = 'ptp'
    '''
    precision time protocol via IEEE Std. 1588
    '''

    radioTime = 'radioTime'
    '''
    radio time source such WWVB or MSF
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class UnitMultiplier(Enum):
    '''
    The unit multipliers defined for the CIM. When applied to unit symbols,
    the unit symbol is treated as a derived unit. Regardless of the contents
    of the unit symbol text, the unit symbol shall be treated as if it were
    a single-character unit symbol. Unit symbols should not contain multipliers,
    and it should be left to the multiplier to define the multiple for an entire
    data type.
    For example, if a unit symbol is "m2Pers" and the multiplier is "k", then
    the value is k(m**2/s), and the multiplier applies to the entire final
    value, not to any individual part of the value. This can be conceptualized
    by substituting a derived unit symbol for the unit type. If one imagines
    that the symbol "&#222;" represents the derived unit "m2Pers", then applying
    the multiplier "k" can be conceptualized simply as "k&#222;".
    For example, the SI unit for mass is "kg" and not "g". If the unit symbol
    is defined as "kg", then the multiplier is applied to "kg" as a whole and
    does not replace the "k" in front of the "g". In this case, the multiplier
    of "m" would be used with the unit symbol of "kg" to represent one gram.
    As a text string, this violates the instructions in IEC 80000-1. However,
    because the unit symbol in CIM is treated as a derived unit instead of
    as an SI unit, it makes more sense to conceptualize the "kg" as if it were
    replaced by one of the proposed replacements for the SI mass symbol. If
    one imagines that the "kg" were replaced by a symbol "&#222;", then it
    is easier to conceptualize the multiplier "m" as creating the proper unit
    "m&#222;", and not the forbidden unit "mkg".
    '''

    E = 'E'
    '''
    Exa 10**18.
    '''

    G = 'G'
    '''
    Giga 10**9.
    '''

    M = 'M'
    '''
    Mega 10**6.
    '''

    P = 'P'
    '''
    Peta 10**15.
    '''

    T = 'T'
    '''
    Tera 10**12.
    '''

    Y = 'Y'
    '''
    Yotta 10**24.
    '''

    Z = 'Z'
    '''
    Zetta 10**21.
    '''

    a = 'a'
    '''
    Atto 10**-18.
    '''

    c = 'c'
    '''
    Centi 10**-2.
    '''

    d = 'd'
    '''
    Deci 10**-1.
    '''

    da = 'da'
    '''
    Deca 10**1.
    '''

    f = 'f'
    '''
    Femto 10**-15.
    '''

    h = 'h'
    '''
    Hecto 10**2.
    '''

    k = 'k'
    '''
    Kilo 10**3.
    '''

    m = 'm'
    '''
    Milli 10**-3.
    '''

    micro = 'micro'
    '''
    Micro 10**-6.
    '''

    n = 'n'
    '''
    Nano 10**-9.
    '''

    none = 'none'
    '''
    No multiplier or equivalently multiply by 1.
    '''

    p = 'p'
    '''
    Pico 10**-12.
    '''

    y = 'y'
    '''
    Yocto 10**-24.
    '''

    z = 'z'
    '''
    Zepto 10**-21.
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class UnitSymbol(Enum):
    '''
    The derived units defined for usage in the CIM. In some cases, the derived
    unit is equal to an SI unit. Whenever possible, the standard derived symbol
    is used instead of the formula for the derived unit. For example, the unit
    symbol Farad is defined as "F" instead of "CPerV". In cases where a standard
    symbol does not exist for a derived unit, the formula for the unit is used
    as the unit symbol. For example, density does not have a standard symbol
    and so it is represented as "kgPerm^3". With the exception of the "kg",
    which is an SI unit, the unit symbols do not contain multipliers and therefore
    represent the base derived unit to which a multiplier can be applied as
    a whole.
    Every unit symbol is treated as an unparseable text as if it were a single-letter
    symbol. The meaning of each unit symbol is defined by the accompanying
    descriptive text and not by the text contents of the unit symbol.
    To allow the widest possible range of serializations without requiring
    special character handling, several substitutions are made which deviate
    from the format described in IEC 80000-1. The division symbol "/" is replaced
    by the letters "Per". Exponents are written in plain text after the unit
    as "m^3". The letters "deg" are used instead of the degree symbol. Any
    clarification of the meaning for a substitution is included in the description
    for the unit symbol.
    Non-SI units are included in list of unit symbols to allow sources of data
    to be correctly labelled with their non-SI units (for example, a GPS sensor
    that is reporting numbers that represent feet instead of meters). This
    allows software to use the unit symbol information correctly convert and
    scale the raw data of those sources into SI-based units.
    The integer values are used for harmonization with IEC 61850.
    '''

    A = 'A'
    '''
    Current in amperes.
    '''

    A2 = 'A2'
    '''
    Amperes squared (A^2).
    '''

    A2h = 'A2h'
    '''
    Ampere-squared hour, ampere-squared hour.
    '''

    A2s = 'A2s'
    '''
    Ampere squared time in square amperes (A^2*s).
    '''

    APerA = 'APerA'
    '''
    Current, ratio of amperages.
    '''

    APerm = 'APerm'
    '''
    Amperes per metre (A/m), magnetic field strength.
    '''

    Ah = 'Ah'
    '''
    Ampere-hours, ampere-hours.
    '''

    As = 'As'
    '''
    Ampere seconds (A*s).
    '''

    Bq = 'Bq'
    '''
    Radioactivity in becquerels (1/s).
    '''

    Btu = 'Btu'
    '''
    Energy, British Thermal Units.
    '''

    C = 'C'
    '''
    Electric charge in coulombs (A*s).
    '''

    CPerkg = 'CPerkg'
    '''
    Exposure (x rays), coulombs per kilogram.
    '''

    CPerm2 = 'CPerm2'
    '''
    Surface charge density, coulombs per square metre.
    '''

    CPerm3 = 'CPerm3'
    '''
    Electric charge density, coulombs per cubic metre.
    '''

    F = 'F'
    '''
    Electric capacitance in farads (C/V).
    '''

    FPerm = 'FPerm'
    '''
    Permittivity, farads per metre.
    '''

    G = 'G'
    '''
    Magnetic flux density, gausses (1 G = 10e-4*T).
    '''

    Gy = 'Gy'
    '''
    Absorbed dose in grays (J/kg).
    '''

    GyPers = 'GyPers'
    '''
    Absorbed dose rate, grays per second.
    '''

    H = 'H'
    '''
    Electric inductance in henrys (Wb/A).
    '''

    HPerm = 'HPerm'
    '''
    Permeability, henrys per metre.
    '''

    Hz = 'Hz'
    '''
    Frequency in hertz (1/s).
    '''

    HzPerHz = 'HzPerHz'
    '''
    Frequency, rate of frequency change.
    '''

    HzPers = 'HzPers'
    '''
    Rate of change of frequency in hertz per second.
    '''

    J = 'J'
    '''
    Energy in joules (N*m = C*V = W*s).
    '''

    JPerK = 'JPerK'
    '''
    Heat capacity in joules/kelvin.
    '''

    JPerkg = 'JPerkg'
    '''
    Specific energy, J/kg.
    '''

    JPerkgK = 'JPerkgK'
    '''
    Specific heat capacity, specific entropy, joules per kilogram Kelvin.
    '''

    JPerm2 = 'JPerm2'
    '''
    Insulation energy density, joules per square metre or watt second per
    square metre.
    '''

    JPerm3 = 'JPerm3'
    '''
    Energy density, joules per cubic metre.
    '''

    JPermol = 'JPermol'
    '''
    Molar energy, joules per mole.
    '''

    JPermolK = 'JPermolK'
    '''
    Molar entropy, molar heat capacity, joules per mole kelvin.
    '''

    JPers = 'JPers'
    '''
    Energy rate in joules per second (J/s).
    '''

    K = 'K'
    '''
    Temperature in kelvins.
    '''

    KPers = 'KPers'
    '''
    Temperature change rate in kelvins per second.
    '''

    M = 'M'
    '''
    Length, nautical miles (1 M = 1852 m).
    '''

    Mx = 'Mx'
    '''
    Magnetic flux, maxwells (1 Mx = 10-8 Wb).
    '''

    N = 'N'
    '''
    Force in newtons (kg*m/s^2).
    '''

    NPerm = 'NPerm'
    '''
    Surface tension, newton per metre.
    '''

    Nm = 'Nm'
    '''
    Moment of force, newton metres.
    '''

    Oe = 'Oe'
    '''
    Magnetic field in oersteds, (1 Oe = (10^3/(4*pi)) A/m = 79.57747 A/m).
    '''

    Pa = 'Pa'
    '''
    Pressure in pascals (N/m^2). Note: the absolute or relative measurement
    of pressure is implied with this entry. See below for more explicit
    forms.
    '''

    PaPers = 'PaPers'
    '''
    Pressure change rate in pascals per second.
    '''

    Pas = 'Pas'
    '''
    Dynamic viscosity, pascal seconds.
    '''

    Q = 'Q'
    '''
    Quantity power, Q.
    '''

    Qh = 'Qh'
    '''
    Quantity energy, Qh.
    '''

    S = 'S'
    '''
    Conductance in siemens.
    '''

    SPerm = 'SPerm'
    '''
    Conductance per length (F/m).
    '''

    Sv = 'Sv'
    '''
    Dose equivalent in sieverts (J/kg).
    '''

    T = 'T'
    '''
    Magnetic flux density in teslas (Wb/m^2).
    '''

    V = 'V'
    '''
    Electric potential in volts (W/A).
    '''

    V2 = 'V2'
    '''
    Volt squared (W^2/A^2).
    '''

    V2h = 'V2h'
    '''
    Volt-squared hour, volt-squared-hours.
    '''

    VA = 'VA'
    '''
    Apparent power in volt amperes. See also real power and reactive power.
    '''

    VAh = 'VAh'
    '''
    Apparent energy in volt ampere hours.
    '''

    VAr = 'VAr'
    '''
    Reactive power in volt amperes reactive. The "reactive" or "imaginary"
    component of electrical power (V*I*sin(phi)). (See also real power
    and apparent power).
    Note: Different meter designs use different methods to arrive at their
    results. Some meters may compute reactive power as an arithmetic value,
    while others compute the value vectorially. The data consumer should
    determine the method in use and the suitability of the measurement
    for the intended purpose.
    '''

    VArh = 'VArh'
    '''
    Reactive energy in volt ampere reactive hours.
    '''

    VPerHz = 'VPerHz'
    '''
    Magnetic flux in volt per hertz.
    '''

    VPerV = 'VPerV'
    '''
    Voltage, ratio of voltages.
    '''

    VPerVA = 'VPerVA'
    '''
    Power factor, PF, the ratio of the active power to the apparent power.
    Note: The sign convention used for power factor will differ between
    IEC meters and EEI (ANSI) meters. It is assumed that the data consumers
    understand the type of meter being used and agree on the sign convention
    in use at any given utility.
    '''

    VPerVAr = 'VPerVAr'
    '''
    Power factor, PF, the ratio of the active power to the apparent power.
    Note: The sign convention used for power factor will differ between
    IEC meters and EEI (ANSI) meters. It is assumed that the data consumers
    understand the type of meter being used and agree on the sign convention
    in use at any given utility.
    '''

    VPerm = 'VPerm'
    '''
    Electric field strength, volts per metre.
    '''

    Vh = 'Vh'
    '''
    Volt-hour, Volt hours.
    '''

    Vs = 'Vs'
    '''
    Volt seconds (Ws/A).
    '''

    W = 'W'
    '''
    Real power in watts (J/s). Electrical power may have real and reactive
    components. The real portion of electrical power (I^2*R or V*I*cos(phi)),
    is expressed in Watts. See also apparent power and reactive power.
    '''

    WPerA = 'WPerA'
    '''
    Active power per current flow, watts per Ampere.
    '''

    WPerW = 'WPerW'
    '''
    Signal Strength, ratio of power.
    '''

    WPerm2 = 'WPerm2'
    '''
    Heat flux density, irradiance, watts per square metre.
    '''

    WPerm2sr = 'WPerm2sr'
    '''
    Radiance, watts per square metre steradian.
    '''

    WPermK = 'WPermK'
    '''
    Thermal conductivity in watt/metres kelvin.
    '''

    WPers = 'WPers'
    '''
    Ramp rate in watts per second.
    '''

    WPersr = 'WPersr'
    '''
    Radiant intensity, watts per steradian.
    '''

    Wb = 'Wb'
    '''
    Magnetic flux in webers (V*s).
    '''

    Wh = 'Wh'
    '''
    Real energy in watt hours.
    '''

    anglemin = 'anglemin'
    '''
    Plane angle, minutes.
    '''

    anglesec = 'anglesec'
    '''
    Plane angle, seconds.
    '''

    bar = 'bar'
    '''
    Pressure in bars, (1 bar = 100 kPa).
    '''

    cd = 'cd'
    '''
    Luminous intensity in candelas.
    '''

    charPers = 'charPers'
    '''
    Data rate (baud) in characters per second.
    '''

    character = 'character'
    '''
    Number of characters.
    '''

    cosPhi = 'cosPhi'
    '''
    Power factor, dimensionless.
    Note 1: This definition of power factor only holds for balanced systems.
    See the alternative definition under code 153.
    Note 2�: Beware of differing sign conventions in use between the IEC
    and EEI. It is assumed that the data consumer understands the type
    of meter in use and the sign convention in use by the utility.
    '''

    count = 'count'
    '''
    Amount of substance, counter value.
    '''

    d = 'd'
    '''
    Time in days, day = 24 h = 86400 s.
    '''

    dB = 'dB'
    '''
    Sound pressure level in decibels. Note: multiplier "d" is included
    in this unit symbol for compatibility with IEC 61850-7-3.
    '''

    dBm = 'dBm'
    '''
    Power level (logarithmic ratio of signal strength , Bel-mW), normalized
    to 1 mW. Note: multiplier "d" is included in this unit symbol for compatibility
    with IEC 61850-7-3.
    '''

    deg = 'deg'
    '''
    Plane angle in degrees.
    '''

    degC = 'degC'
    '''
    Relative temperature in degrees Celsius (degC).
    '''

    ft3 = 'ft3'
    '''
    Volume, cubic feet.
    '''

    gPerg = 'gPerg'
    '''
    Concentration, The ratio of the mass of a solute divided by the mass
    of the solution.
    '''

    gal = 'gal'
    '''
    Volume in gallons, US gallon (1 gal = 231 in^3 = 128 fl ounce).
    '''

    h = 'h'
    '''
    Time in hours, hour = 60 min = 3600 s.
    '''

    ha = 'ha'
    '''
    Area, hectares.
    '''

    kat = 'kat'
    '''
    Catalytic activity, katal = mol/s.
    '''

    katPerm3 = 'katPerm3'
    '''
    Catalytic activity concentration, katals per cubic metre.
    '''

    kg = 'kg'
    '''
    Mass in kilograms. Note: multiplier "k" is included in this unit symbol
    for compatibility with IEC 61850-7-3.
    '''

    kgPerJ = 'kgPerJ'
    '''
    Weight per energy in kilograms per joule (kg/J). Note: multiplier "k"
    is included in this unit symbol for compatibility with IEC 61850-7-3.
    '''

    kgPerm = 'kgPerm'
    '''
    Mass per length in kilogram/metres (kg/m). Note: multiplier "k" is
    included in this unit symbol for compatibility with mass datatype.
    '''

    kgPerm3 = 'kgPerm3'
    '''
    Density in kilogram/cubic metres (kg/m^3). Note: multiplier "k" is
    included in this unit symbol for compatibility with IEC 61850-7-3.
    '''

    kgm = 'kgm'
    '''
    Moment of mass in kilogram metres (kg*m) (first moment of mass). Note:
    multiplier "k" is included in this unit symbol for compatibility with
    IEC 61850-7-3.
    '''

    kgm2 = 'kgm2'
    '''
    Moment of mass in kilogram square metres (kg*m^2) (Second moment of
    mass, commonly called the moment of inertia). Note: multiplier "k"
    is included in this unit symbol for compatibility with IEC 61850-7-3.
    '''

    kn = 'kn'
    '''
    Speed, knots (1 kn = 1852/3600) m/s.
    '''

    l = 'l'
    '''
    Volume in litres, litre = dm^3 = m^3/1000.
    '''

    lPerh = 'lPerh'
    '''
    Volumetric flow rate, litres per hour.
    '''

    lPerl = 'lPerl'
    '''
    Concentration, The ratio of the volume of a solute divided by the volume
    of the solution.
    '''

    lPers = 'lPers'
    '''
    Volumetric flow rate in litres per second.
    '''

    lm = 'lm'
    '''
    Luminous flux in lumens (cd*sr).
    '''

    lx = 'lx'
    '''
    Illuminance in lux (lm/m^2).
    '''

    m = 'm'
    '''
    Length in metres.
    '''

    m2 = 'm2'
    '''
    Area in square metres (m^2).
    '''

    m2Pers = 'm2Pers'
    '''
    Viscosity in square metres/second (m^2/s).
    '''

    m3 = 'm3'
    '''
    Volume in cubic metres (m^3).
    '''

    m3Compensated = 'm3Compensated'
    '''
    Volume, cubic metres, with the value compensated for weather effects.
    '''

    m3Perh = 'm3Perh'
    '''
    Volumetric flow rate, cubic metres per hour.
    '''

    m3Perkg = 'm3Perkg'
    '''
    Specific volume, cubic metres per kilogram, v.
    '''

    m3Pers = 'm3Pers'
    '''
    Volumetric flow rate in cubic metres per second (m^3/s).
    '''

    m3Uncompensated = 'm3Uncompensated'
    '''
    Volume, cubic metres, with the value uncompensated for weather effects.
    '''

    mPerm3 = 'mPerm3'
    '''
    Fuel efficiency in metres per cubic metres (m/m^3).
    '''

    mPers = 'mPers'
    '''
    Velocity in metres per second (m/s).
    '''

    mPers2 = 'mPers2'
    '''
    Acceleration in metres per second squared (m/s^2).
    '''

    min = 'min'
    '''
    Time in minutes, minute = 60 s.
    '''

    mmHg = 'mmHg'
    '''
    Pressure, millimetres of mercury (1 mmHg is approximately 133.3 Pa).
    '''

    mol = 'mol'
    '''
    Amount of substance in moles.
    '''

    molPerkg = 'molPerkg'
    '''
    Concentration, Molality, the amount of solute in moles and the amount
    of solvent in kilograms.
    '''

    molPerm3 = 'molPerm3'
    '''
    Concentration, The amount of substance concentration, (c), the amount
    of solvent in moles divided by the volume of solution in m^3.
    '''

    molPermol = 'molPermol'
    '''
    Concentration, Molar fraction, the ratio of the molar amount of a solute
    divided by the molar amount of the solution.
    '''

    none = 'none'
    '''
    Dimension less quantity, e.g. count, per unit, etc.
    '''

    ohm = 'ohm'
    '''
    Electric resistance in ohms (V/A).
    '''

    ohmPerm = 'ohmPerm'
    '''
    Electric resistance per length in ohms per metre ((V/A)/m).
    '''

    ohmm = 'ohmm'
    '''
    Resistivity, ohm metres, (rho).
    '''

    onePerHz = 'onePerHz'
    '''
    Reciprocal of frequency (1/Hz).
    '''

    onePerm = 'onePerm'
    '''
    Wavenumber, reciprocal metres, (1/m).
    '''

    ppm = 'ppm'
    '''
    Concentration in parts per million.
    '''

    rad = 'rad'
    '''
    Plane angle in radians (m/m).
    '''

    radPers = 'radPers'
    '''
    Angular velocity in radians per second (rad/s).
    '''

    radPers2 = 'radPers2'
    '''
    Angular acceleration, radians per second squared.
    '''

    rev = 'rev'
    '''
    Amount of rotation, revolutions.
    '''

    rotPers = 'rotPers'
    '''
    Rotations per second (1/s). See also Hz (1/s).
    '''

    s = 's'
    '''
    Time in seconds.
    '''

    sPers = 'sPers'
    '''
    Time, Ratio of time.
    '''

    sr = 'sr'
    '''
    Solid angle in steradians (m^2/m^2).
    '''

    therm = 'therm'
    '''
    Energy, therms.
    '''

    tonne = 'tonne'
    '''
    Mass in tons, "tonne" or "metric ton" (1000 kg = 1 Mg).
    '''

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ActivePower(CIMUnit):
    '''
    Product of RMS value of the voltage and the RMS value of the in-phase component
    of the current.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.W
    def __init__(self, value, input_unit: str='W', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Frequency(CIMUnit):
    '''
    Cycles per second.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.Hz
    def __init__(self, value, input_unit: str='Hz', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class PerCent(CIMUnit):
    '''
    Percentage on a defined base. For example, specify as 100 to indicate at
    the defined base.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.none
    def __init__(self, value, input_unit: str='none', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Seconds(CIMUnit):
    '''
    Time, in seconds.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.s
    def __init__(self, value, input_unit: str='s', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
